# -*- coding: utf-8 -*-

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *

import resources

class ManagerPlugin:

	def __init__(self, iface):
		# Save reference to the QGIS interface
		self.iface = iface
	
	def initGui(self):
		# Create action that will start plugin configuration
		self.action = QAction(QIcon(":/icons/spatialite_icon.png"), "SpatiaLite Manager", self.iface.mainWindow())
		QObject.connect(self.action, SIGNAL("triggered()"), self.run)
	
		# Add toolbar button and menu item
		self.iface.addToolBarIcon(self.action)
		if hasattr( self.iface, 'addPluginToDatabaseMenu' ):
			self.iface.addPluginToDatabaseMenu("&SpatiaLite Manager", self.action)
		else:
			self.iface.addPluginToMenu("&SpatiaLite Manager", self.action)
		
	
	def unload(self):
		# Remove the plugin menu item and icon
		if hasattr( self.iface, 'removePluginDatabaseMenu' ):
			self.iface.removePluginDatabaseMenu("&SpatiaLite Manager",self.action)
		else:
			self.iface.removePluginMenu("&SpatiaLite Manager",self.action)
		self.iface.removeToolBarIcon(self.action)
	
	def run(self):

		try:
			import pyspatialite
		except ImportError, e:
			QMessageBox.information(self.iface.mainWindow(), "hey", "Couldn't import Python module 'pyspatialite' for communication with Sqlite database. Without it you won't be able to run SpatiaLite manager.")
			return
		
		from ManagerWindow import ManagerWindow
		self.dlg = ManagerWindow(True, None)
		self.dlg.show()

