# -*- coding: utf-8 -*-

"""
/***************************************************************************
 SpatialAnalysisToolbox
                                 A QGIS plugin
This plugin adds some useful algorithms for Spatial Analysis. Some of them are: Moran's I, Local Moran's I, GWR.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-03-01
        copyright            : (C) 2020 by Parmenion Delialis
        email                : parmeniondelialis@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Parmenion Delialis'
__date__ = '2022-03-01'
__copyright__ = '(C) 2022 by Parmenion Delialis'


__revision__ = '$Format:%H$'

from qgis.core import QgsProcessingProvider
from qgis.PyQt.QtGui import QIcon
from .algorithms.CloneLayer import CloneLayer
from .algorithms.GWR_ import GWR_
from .algorithms.LocalMoransI import LocalMoransI
from .algorithms.MoransI import MoransI
from .algorithms.CorrelationMatrix import CorrelationMatrix
from .algorithms.LocationQuotient import LocationQuotient
from .algorithms.EntropyIndex import EntropyIndex
from .algorithms.DummyVariables import DummyVariables

class SpatialAnalysisToolboxProvider(QgsProcessingProvider):

    def __init__(self):
        QgsProcessingProvider.__init__(self)

    def unload(self):
        pass

    def loadAlgorithms(self):
        self.addAlgorithm(CloneLayer())
        self.addAlgorithm(GWR_())
        self.addAlgorithm(LocalMoransI())
        self.addAlgorithm(MoransI())
        self.addAlgorithm(CorrelationMatrix())
        self.addAlgorithm(LocationQuotient())
        self.addAlgorithm(EntropyIndex())
        self.addAlgorithm(DummyVariables())

    def id(self):
        return 'sat'

    def name(self):
        return self.tr('Spatial Analysis Toolbox')

    def icon(self):
        import os
        pluginPath = os.path.dirname(__file__)
        return QIcon(os.path.join(pluginPath, 'icon.png'))

    def longName(self):
        return self.name()
