from qgis.PyQt.QtCore import QLocale
from qgis.core import QgsSettings

_KOREAN_TRANSLATIONS = {
    'SpatialAnalyzer - Spatial Analysis Toolbox': 'SpatialAnalyzer - 공간 분석 도구상자',
    'Sample Data': '샘플 데이터',
    '01-Spatial Central Tendency': '01-중심경향성(평균좌표, 중앙좌표, 중심객체)',
    '02-Spatial Dispersion': '02-공간분포',
    '03-Clustering': '03-군집분석',
    '04-Gravity Model': '04-중력모형',
    '06-Spatial Regression': '06-공간회귀분석',
    '07-Dimension Reduction': '07-차원축소',
    '05-Spatial Autocorrelation': '05-공간자기상관',
    'Gi*': 'Gi*',
    'Centers(Mean Center, Median Center, Central Feature)': '평균좌표, 중앙좌표 , 중심피처',
    'Central Feature Tracker': '누적중심피처',
    'DBSCAN': '밀도기반 군집분석(DBSCAN)',
    'Geographically Weighted Regression': '지리가중 회귀분석',
    'Gravity': '중력모형',
    'Hierarchical': '계층적 군집분석(Hierarchical)',
    'K-Means': 'K-평균 군집분석(K-Means)',
    'Mean Center Tracker': '누적평균좌표',
    'Median Center Tracker': '누적중앙좌표',
    'Principal Component Analysis': '주성분 분석(PCA)',
    "Local Moran's i": '로컬 모란지수',
    'Standard Deviation Ellipse': '표준편차타원체',
    'Standard Distance': '표준거리',
    't-SNE': 't-SNE',
}


def _user_locale_name():
    try:
        locale = QgsSettings().value('locale/userLocale', '', type=str)
    except Exception:
        locale = ''
    if not locale:
        locale = QLocale().name()
    return locale or ''


def _is_korean_locale():
    return _user_locale_name().lower().startswith('ko')



def localized_menu_text(english_text, fallback_text=None):
    """Return a locale-aware menu label.

    Parameters
    ----------
    english_text: str
        The canonical English string used as the lookup key.
    fallback_text: Optional[str]
        The text to return when no translation is available. Defaults to
        ``english_text`` if omitted.
    """

    if fallback_text is None:
        fallback_text = english_text

    if _is_korean_locale():
        text = _KOREAN_TRANSLATIONS.get(english_text, fallback_text)
    else:
        text = fallback_text

    return text
