# -*- coding: utf-8 -*-
"""
/***************************************************************************
 SPAQLunicorn
                                 A QGIS plugin
 This plugin adds a GeoJSON layer from a Wikidata SPARQL query.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-10-28
        git sha              : $Format:%H$
        copyright            : (C) 2019 by SPARQL Unicorn
        email                : rse@fthiery.de
        developer(s)         : Florian Thiery,  Timo Homburg
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

#import sys
#import pip
from qgis.utils import iface
from qgis.core import Qgis

from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication,QRegExp, Qt,pyqtSignal
from qgis.PyQt.QtGui import QColor, QTextCharFormat, QFont, QIcon, QSyntaxHighlighter
from qgis.PyQt.QtWidgets import QAction, QFileDialog, QTableWidgetItem, QCheckBox, QDialog, QPushButton,QPlainTextEdit,QTextEdit, QLabel, QLineEdit, QListWidget, QComboBox, QRadioButton,QMessageBox
from qgis.core import QgsProject, Qgis,QgsRasterLayer,QgsPointXY, QgsRectangle, QgsDistanceArea
from qgis.core import QgsVectorLayer, QgsProject, QgsGeometry,QgsFeature, QgsCoordinateReferenceSystem, QgsCoordinateTransform, QgsWkbTypes,QgsMapLayer
from qgis.gui import QgsMapToolEmitPoint, QgsMapCanvas, QgsRubberBand,QgsMapTool
from qgis.utils import iface
import rdflib
from rdflib.plugins.sparql import prepareQuery
import sys
import requests
import uuid

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .sparql_unicorn_dialog import SPAQLunicornDialog
import os.path
import re

# external libraires for SPARQL Unicorn
from SPARQLWrapper import SPARQLWrapper, JSON
#import rdflib
import json
#from convertbng.util import convert_bng, convert_lonlat


def format(color, style=''):
    """Return a QTextCharFormat with the given attributes.
    """
    _color = QColor()
    _color.setNamedColor(color)

    _format = QTextCharFormat()
    _format.setForeground(_color)
    if 'bold' in style:
        _format.setFontWeight(QFont.Bold)
    if 'italic' in style:
        _format.setFontItalic(True)

    return _format

STYLES = {
    'keyword': format('#b32424'),
    'operator': format('black'),
    'error': format('red'),
    'brace': format('black'),
    'defclass': format('#14866d'),
    'uri': format('#2a4b8d'),
	'prefixcls': format('#14866d'),
    'string': format('#ac6600'),
    'string2': format('darkMagenta'),
    'comment': format('#72777d'),
    'self': format('blue', 'italic'),
    'numbers': format('black'),
}

class RectangleMapTool(QgsMapToolEmitPoint):

    rectangleCreated = pyqtSignal()
    deactivated = pyqtSignal()

    point1=""
    point2=""
    point3=""
    point4=""
    chosen=False

    def __init__(self, canvas):
        self.canvas = canvas
        QgsMapToolEmitPoint.__init__(self, self.canvas)

        self.rubberBand = QgsRubberBand(self.canvas, QgsWkbTypes.PolygonGeometry)
        self.rubberBand.setColor(QColor(255, 0, 0, 100))
        self.rubberBand.setWidth(2)

        self.reset()

    def reset(self):
        self.startPoint = self.endPoint = None
        self.isEmittingPoint = False
        self.rubberBand.reset(QgsWkbTypes.PolygonGeometry)

    def canvasPressEvent(self, e):
        self.startPoint = self.toMapCoordinates(e.pos())
        self.endPoint = self.startPoint
        self.isEmittingPoint = True

        self.showRect(self.startPoint, self.endPoint)

    def canvasReleaseEvent(self, e):
        self.isEmittingPoint = False
        if self.rectangle() is not None:
            self.rectangleCreated.emit()

    def canvasMoveEvent(self, e):
        if not self.isEmittingPoint:
            return

        self.endPoint = self.toMapCoordinates(e.pos())
        self.showRect(self.startPoint, self.endPoint)

    def showRect(self, startPoint, endPoint):
        self.rubberBand.reset(QgsWkbTypes.PolygonGeometry)
        if startPoint.x() == endPoint.x() or startPoint.y() == endPoint.y():
            return

        self.point1 = QgsPointXY(startPoint.x(), startPoint.y())
        self.point2 = QgsPointXY(startPoint.x(), endPoint.y())
        self.point3 = QgsPointXY(endPoint.x(), endPoint.y())
        self.point4 = QgsPointXY(endPoint.x(), startPoint.y())

        self.rubberBand.addPoint(self.point1, False)
        self.rubberBand.addPoint(self.point2, False)
        self.rubberBand.addPoint(self.point3, False)
        # True to update canvas
        self.rubberBand.addPoint(self.point4, True)
        self.rubberBand.show()
        chosen=True

    def rectangle(self):
        if self.startPoint is None or self.endPoint is None:
            return None
        elif self.startPoint.x() == self.endPoint.x() or \
                self.startPoint.y() == self.endPoint.y():
            return None

        return QgsRectangle(self.startPoint, self.endPoint)

    def setRectangle(self, rect):
        if rect == self.rectangle():
            return False

        if rect is None:
            self.reset()
        else:
            self.startPoint = QgsPointXY(rect.xMaximum(), rect.yMaximum())
            self.endPoint = QgsPointXY(rect.xMinimum(), rect.yMinimum())
            self.showRect(self.startPoint, self.endPoint)
        return True

    def deactivate(self):
        QgsMapTool.deactivate(self)
        self.deactivated.emit()

class SPARQLHighlighter (QSyntaxHighlighter):
    """Syntax highlighter for the Python language.
    """
    # Python keywords
    keywords = [
        'SELECT', 'INSERT', 'WHERE', 'ORDER', 'BY', 'LIMIT',
        'OFFSET', 'FROM', 'PREFIX', 'GRAPH', 'NAMED', 'BIND',
        'VALUES', 'ASC', 'DESC', 'FILTER', 'DISTINCT', 'REDUCED',
        'OPTIONAL', 'CONSTRUCT', 'ASK', 'DESCRIBE', 'BOUND', 'IF','SERVICE',
        'EXISTS', 'NOT', 'IN', 'STR', 'AS','LANG','DELETE','CREATE','CLEAR','DROP','LOAD','COPY','MOVE','ADD'
        'IRI', 'URI', 'False', 'a'
    ]

    # Python operators
    operators = [
        '=',
        # Comparison
        '==', '!=', '<', '<=', '>', '>=',
        # Arithmetic
        '\+', '-', '\*', '/', '//', '\%', '\*\*',
        # In-place
        '\+=', '-=', '\*=', '/=', '\%=',
        # Bitwise
        '\^', '\|', '\&', '\~', '>>', '<<',
    ]

    errorhighlightline=-1

    currentline=0

    errorhighlightcol=-1

    # Python braces
    braces = [
        '\{', '\}', '\(', '\)', '\[', '\]',
    ]
    def __init__(self, document,errorlabel):
        QSyntaxHighlighter.__init__(self, document.document())
        #msgBox=QMessageBox()
        #msgBox.setText(document.toPlainText())
        #msgBox.exec()
        # Multi-line strings (expression, flag, style)
        # FIXME: The triple-quotes in these two lines will mess up the
        # syntax highlighting from this point onward
        self.tri_single = (QRegExp("'''"), 1, STYLES['string2'])
        self.tri_double = (QRegExp('"""'), 2, STYLES['string2'])

        rules = []


          # All other rules
        rules += [
            # 'self'
            (r'\bself\b', 0, STYLES['self']),

            # Double-quoted string, possibly containing escape sequences
            (r'"[^"\\]*(\\.[^"\\]*)*"', 0, STYLES['string']),
            # Single-quoted string, possibly containing escape sequences
            (r"'[^'\\]*(\\.[^'\\]*)*'", 0, STYLES['string']),

            # 'def' followed by an identifier
            (r'([?]\w+)', 1, STYLES['defclass']),
            (r'([<][h][t][t][p][:][/][/]\w+[>])', 0, STYLES['uri']),
			# 'class' followed by an identifier
            (r'(\w+[:]\w+)', 1, STYLES['uri']),


            # From '#' until a newline
            (r'#[^\n]*', 0, STYLES['comment']),

            # Numeric literals
            (r'\b[+-]?[0-9]+[lL]?\b', 0, STYLES['numbers']),
            (r'\b[+-]?0[xX][0-9A-Fa-f]+[lL]?\b', 0, STYLES['numbers']),
            (r'\b[+-]?[0-9]+(?:\.[0-9]+)?(?:[eE][+-]?[0-9]+)?\b', 0, STYLES['numbers']),
        ]
		        # Keyword, operator, and brace rules
        rules += [(r'\b%s\b' % w, 0, STYLES['keyword'])
            for w in SPARQLHighlighter.keywords]
        rules += [(r'%s' % o, 0, STYLES['operator'])
            for o in SPARQLHighlighter.operators]
        rules += [(r'%s' % b, 0, STYLES['brace'])
            for b in SPARQLHighlighter.braces]

        # Build a QRegExp for each pattern
        self.rules = [(QRegExp(pat), index, fmt)
            for (pat, index, fmt) in rules]


    def highlightBlock(self, text):
        """Apply syntax highlighting to the given block of text.
        """
        self.currentline+=1
        #msgBox=QMessageBox()
        #msgBox.setText(str(self.errorhighlightline))
        #msgBox.exec()
        #if self.errorhighlightline!=-1:
        #    self.setFormat(0, len(text), STYLES['error'])
        #else:
		#    # Do other syntax formatting
        for expression, nth, format in self.rules:
            index = expression.indexIn(text, 0)
            while index >= 0:
                # We actually want the index of the nth match
                index = expression.pos(nth)
                length = expression.matchedLength()
                self.setFormat(index, length, format)
                index = expression.indexIn(text, index + length)

        self.setCurrentBlockState(0)
        # Do multi-line strings
        in_multiline = self.match_multiline(text, *self.tri_single)
        if not in_multiline:
            in_multiline = self.match_multiline(text, *self.tri_double)


    def match_multiline(self, text, delimiter, in_state, style):
        """Do highlighting of multi-line strings. ``delimiter`` should be a
        ``QRegExp`` for triple-single-quotes or triple-double-quotes, and
        ``in_state`` should be a unique integer to represent the corresponding
        state changes when inside those strings. Returns True if we're still
        inside a multi-line string when this function is finished.
        """
        # If inside triple-single quotes, start at 0
        if self.previousBlockState() == in_state:
            start = 0
            add = 0
        # Otherwise, look for the delimiter on this line
        else:
            start = delimiter.indexIn(text)
            # Move past this match
            add = delimiter.matchedLength()

        # As long as there's a delimiter match on this line...
        while start >= 0:
            # Look for the ending delimiter
            end = delimiter.indexIn(text, start + add)
            # Ending delimiter on this line?
            if end >= add:
                length = end - start + add + delimiter.matchedLength()
                self.setCurrentBlockState(0)
            # No; multi-line string
            else:
                self.setCurrentBlockState(in_state)
                length = text.length() - start + add
            # Apply formatting
            self.setFormat(start, length, style)
            # Look for the next match
            start = delimiter.indexIn(text, start + length)

        # Return True if still inside a multi-line string, False otherwise
        if self.currentBlockState() == in_state:
            return True
        else:
            return False

class SPAQLunicorn:
    """QGIS Plugin Implementation."""

    loadedfromfile=False

    justloadingfromfile=False

    tableCheckBoxes=[]

    currentgraph=None

    currentcol=0

    vl=""
	
    geonamesconcepts=["ADM1","ADM1H","ADM2","ADM2H","ADM3","ADM3H","ADM4","ADM4H","ADM5","ADM5H","ADMD","ADMDH","ADMF","AGRC","AGRF","AIRB","AIRF","AIRH","AIRP","AIRQ","AIRS","AIRT","AMTH","AMUS","ANCH","ANS","APNU","AQC","ARCH","ARCHV","ARCU","AREA","ARRU","ART","ASPH","ASTR","ASYL","ATHF","ATM","ATOL","BANK","BAR","BAY","BAYS","BCH","BCHS","BCN","BDG","BDGQ","BDLD","BDLU","BGHT","BKSU","BLDA","BLDG","BLDO","BLDR","BLHL","BLOW","BNCH","BNK","BNKR","BNKU","BNKX","BOG","BP","BRKS","BRKW","BSND","BSNP","BSNU","BSTN","BTL","BTYD","BUR","BUSH","BUSTN","BUSTP","BUTE","CAPE","CAPG","CARN","CAVE","CDAU","CFT","CH","CHN","CHNL","CHNM","CHNN","CLDA","CLF","CLG","CMN","CMP","CMPL","CMPLA","CMPMN","CMPO","CMPQ","CMPRF","CMTY","CNFL","CNL","CNLA","CNLB","CNLD","CNLI","CNLN","CNLQ","CNLSB","CNLX","CNS","CNSU","CNYN","CNYU","COLF","COMC","CONE","CONT","COVE","CRDR","CRKT","CRNT","CRQ","CRQS","CRRL","CRSU","CRTR","CSNO","CST","CSTL","CSTM","CSWY","CTHSE","CTRA","CTRB","CTRCM","CTRF","CTRM","CTRR","CTRS","CUET","CULT","CUTF","CVNT","DAM","DAMQ","DAMSB","DARY","DCK","DCKB","DCKD","DCKY","DEPU","DEVH","DIKE","DIP","DLTA","DOMG","DPOF","DPR","DPRG","DSRT","DTCH","DTCHD","DTCHI","DTCHM","DUNE","DVD","EDGU","ERG","ESCU","EST","ESTO","ESTR","ESTSG","ESTT","ESTX","ESTY","FAN","FANU","FCL","FISH","FJD","FJDS","FLD","FLDI","FLLS","FLLSX","FLTM","FLTT","FLTU","FNDY","FORD","FRM","FRMQ","FRMS","FRMT","FRST","FRSTF","FRZU","FSR","FT","FURU","FY","FYT","GAP","GAPU","GASF","GATE","GDN","GHAT","GHSE","GLCR","GLYU","GOSP","GOVL","GRAZ","GRGE","GROVE","GRSLD","GRVC","GRVE","GRVO","GRVP","GRVPN","GULF","GVL","GYSR","H","HBR","HBRX","HDLD","HERM","HLL","HLLS","HLLU","HLSU","HLT","HMCK","HMDA","HMSD","HOLU","HSE","HSEC","HSP","HSPC","HSPD","HSPL","HSTS","HTH","HTL","HUT","HUTS","INDS","INLT","INLTQ","INSM","INTF","ISL","ISLET","ISLF","ISLM","ISLS","ISLT","ISLX","ISTH","ITTR","JTY","KNLU","KNSU","KRST","L","LAND","LAVA","LBED","LCTY","LDGU","LDNG","LEPC","LEV","LEVU","LGN","LGNS","LGNX","LIBR","LK","LKC","LKI","LKN","LKNI","LKO","LKOI","LKS","LKSB","LKSC","LKSI","LKSN","LKSNI","LKX","LNDF","LOCK","LTER","LTHSE","MALL","MAR","MDW","MESA","MESU","MFG","MFGB","MFGC","MFGCU","MFGLM","MFGM","MFGN","MFGPH","MFGQ","MFGSG","MGV","MILB","MKT","ML","MLM","MLO","MLSG","MLSGQ","MLSW","MLWND","MLWTR","MN","MNA","MNAU","MNC","MNCR","MNCU","MND","MNDU","MNFE","MNMT","MNN","MNQ","MNQR","MOLE","MOOR","MOTU","MRN","MRSH","MRSHN","MSQE","MSSN","MSSNQ","MSTY","MT","MTRO","MTS","MTU","MUS","MVA","NKM","NOV","NRWS","NSY","NTK","NTKS","NVB","OAS","OBPT","OBS","OBSR","OCH","OCN","OILF","OILJ","OILP","OILQ","OILR","OILT","OILW","OPRA","OVF","P","PAL","PAN","PANS","PASS","PCL","PCLD","PCLF","PCLH","PCLI","PCLIX","PCLS","PEAT","PEN","PENX","PGDA","PIER","PK","PKLT","PKS","PKSU","PKU","PLAT","PLATX","PLDR","PLN","PLNU","PLNX","PLTU","PMPO","PMPW","PND","PNDI","PNDN","PNDNI","PNDS","PNDSF","PNDSI","PNDSN","PNLU","PO","POOL","POOLI","PP","PPL","PPLA","PPLA2","PPLA3","PPLA4","PPLA5","PPLC","PPLCH","PPLF","PPLG","PPLH","PPLL","PPLQ","PPLR","PPLS","PPLW","PPLX","PPQ","PRK","PRKGT","PRKHQ","PRMN","PRN","PRNJ","PRNQ","PROM","PRSH","PRT","PRVU","PS","PSH","PSN","PSTB","PSTC","PSTP","PT","PTGE","PTS","PYR","PYRS","QCKS","QUAY","R","RCH","RD","RDA","RDB","RDCR","RDCUT","RDGB","RDGE","RDGG","RDGU","RDIN","RDJCT","RDST","RDSU","RECG","RECR","REG","RES","RESA","RESF","RESH","RESN","RESP","REST","RESV","RESW","RET","RF","RFC","RFSU","RFU","RFX","RGN","RGNE","RGNH","RGNL","RHSE","RISU","RJCT","RK","RKFL","RKRY","RKS","RLG","RLGR","RNCH","RNGA","RPDS","RR","RRQ","RSD","RSGNL","RSRT","RSTN","RSTNQ","RSTP","RSTPQ","RSV","RSVI","RSVT","RTE","RUIN","RVN","RYD","S","SALT","SAND","SBED","SBKH","SCH","SCHA","SCHC","SCHL","SCHM","SCHN","SCHT","SCNU","SCRB","SCRP","SCSU","SD","SDL","SDLU","SEA","SECP","SHFU","SHLU","SHOL","SHOR","SHPF","SHRN","SHSE","SHSU","SHVU","SILL","SILU","SINK","SLCE","SLID","SLP","SLPU","SMSU","SMU","SNOW","SNTR","SPA","SPIT","SPLY","SPNG","SPNS","SPNT","SPRU","SPUR","SQR","ST","STBL","STDM","STKR","STLMT","STM","STMA","STMB","STMC","STMD","STMH","STMI","STMIX","STMM","STMQ","STMS","STMSB","STMX","STNB","STNC","STNE","STNF","STNI","STNM","STNR","STNS","STNW","STPS","STRT","SWMP","SWT","SYG","SYSI","T","TAL","TERR","TERU","THTR","TMB","TMPL","TMSU","TMTU","TNGU","TNKD","TNL","TNLC","TNLN","TNLRD","TNLRR","TNLS","TOLL","TOWR","TRAM","TRANT","TRB","TREE","TRGD","TRGU","TRIG","TRL","TRMO","TRNU","TRR","TUND","TWO","U","UNIP","UNIV","UPLD","USGE","V","VAL","VALG","VALS","VALU","VALX","VETF","VIN","VINS","VLC","VLSU","WAD","WADB","WADJ","WADM","WADS","WADX","WALL","WALLA","WEIR","WHRF","WHRL","WLL","WLLQ","WLLS","WRCK","WTLD","WTLDI","WTRC","WTRH","WTRW","ZN","ZNB","ZNF","ZOO"]

    bboxbuffer=""

    currentrow=0

    exportNameSpace=""

    bboxextent=""

    rect_tool=""

    curbbox=[]

    bboxCoordinateLabelLon=""

    bboxCoordinateLabelLat=""

    exportIdCol=""

    mts_layer=""

    map_canvas=""

    exportClassCol=""

    exportSetClass=""

    searchResult=""

    tripleStoreEdit=""

    conceptSearchEdit=""

    sparqlhighlight=""

    interlinkdialog=""

    exportColConfig={}

    errorline=-1

    d=""

    enrichedExport=False

    outputfile=""

    prefixes=["","PREFIX geo:<http://www.opengis.net/geosparql#> PREFIX wd: <http://www.wikidata.org/entity/> PREFIX wds: <http://www.wikidata.org/entity/statement/> PREFIX wdv: <http://www.wikidata.org/value/> PREFIX wdt: <http://www.wikidata.org/prop/direct/> PREFIX wikibase: <http://wikiba.se/ontology#> PREFIX p: <http://www.wikidata.org/prop/> PREFIX ps: <http://www.wikidata.org/prop/statement/> PREFIX pq: <http://www.wikidata.org/prop/qualifier/> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX bd: <http://www.bigdata.com/rdf#> PREFIX wdref: <http://www.wikidata.org/reference/> PREFIX psv: <http://www.wikidata.org/prop/statement/value/> PREFIX psn: <http://www.wikidata.org/prop/statement/value-normalized/> PREFIX pqv: <http://www.wikidata.org/prop/qualifier/value/> PREFIX pqn: <http://www.wikidata.org/prop/qualifier/value-normalized/> PREFIX pr: <http://www.wikidata.org/prop/reference/> PREFIX prv: <http://www.wikidata.org/prop/reference/value/> PREFIX prn: <http://www.wikidata.org/prop/reference/value-normalized/> PREFIX wdno: <http://www.wikidata.org/prop/novalue/> PREFIX wdata: <http://www.wikidata.org/wiki/Special:EntityData/> PREFIX schema: <http://schema.org/> PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX skos: <http://www.w3.org/2004/02/skos/core#> PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> PREFIX prov: <http://www.w3.org/ns/prov#> PREFIX bds: <http://www.bigdata.com/rdf/search#> PREFIX gas: <http://www.bigdata.com/rdf/gas#> PREFIX hint: <http://www.bigdata.com/queryHints#>",
    "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX spatial: <http://data.ordnancesurvey.co.uk/ontology/spatialrelations/> PREFIX gaz: <http://data.ordnancesurvey.co.uk/ontology/50kGazetteer/>",
    "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX dcterms: <http://purl.org/dc/terms/> PREFIX geo: <http://www.w3.org/2003/01/geo/wgs84_pos#> PREFIX nm: <http://nomisma.org/id/> PREFIX nmo: <http://nomisma.org/ontology#> PREFIX skos: <http://www.w3.org/2004/02/skos/core#> PREFIX spatial: <http://jena.apache.org/spatial#> PREFIX xsd: <http://www.w3.org/2001/XMLSchema#>",
    "PREFIX crm: <http://www.cidoc-crm.org/cidoc-crm/> PREFIX crmgeo: <http://www.ics.forth.gr/isl/CRMgeo/> PREFIX crmsci: <http://www.ics.forth.gr/isl/CRMsci/> PREFIX dcterms: <http://purl.org/dc/terms/> PREFIX foaf: <http://xmlns.com/foaf/0.1/> PREFIX geo: <http://www.w3.org/2003/01/geo/wgs84_pos#> PREFIX kid: <http://kerameikos.org/id/> PREFIX kon: <http://kerameikos.org/ontology#> PREFIX org: <http://www.w3.org/ns/org#> PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX skos: <http://www.w3.org/2004/02/skos/core#> PREFIX xsd: <http://www.w3.org/2001/XMLSchema#>",
    "Prefix lgdo: <http://linkedgeodata.org/ontology/> Prefix geom: <http://geovocab.org/geometry#> Prefix ogc: <http://www.opengis.net/ont/geosparql#> Prefix owl: <http://www.w3.org/2002/07/owl#> Prefix ogc: <http://www.opengis.net/ont/geosparql#> Prefix geom: <http://geovocab.org/geometry#> Prefix lgdo: <http://linkedgeodata.org/ontology/>",
    "Prefix dbo: <http://dbpedia.org/ontology/> PREFIX geo:<http://www.w3.org/2003/01/geo/wgs84_pos#> Prefix geom: <http://geovocab.org/geometry#> Prefix ogc: <http://www.opengis.net/ont/geosparql#> Prefix owl: <http://www.w3.org/2002/07/owl#> Prefix geom: <http://geovocab.org/geometry#> Prefix lgdo: <http://linkedgeodata.org/ontology/>",
    "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX geo:<http://www.w3.org/2003/01/geo/wgs84_pos#> PREFIX gn:<http://www.geonames.org/ontology#> Prefix geom: <http://geovocab.org/geometry#> Prefix ogc: <http://www.opengis.net/ont/geosparql#> Prefix owl: <http://www.w3.org/2002/07/owl#> prefix wgs84_pos: <http://www.w3.org/2003/01/geo/wgs84_pos#>",
    "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> Prefix geom: <http://geovocab.org/geometry#> Prefix ogc: <http://www.opengis.net/ont/geosparql#> Prefix owl: <http://www.w3.org/2002/07/owl#> Prefix osi: <http://ontologies.geohive.ie/osi#> ", 
	""
    ]

    endpoints=["","https://query.wikidata.org/sparql","http://data.ordnancesurvey.co.uk/datasets/os-linked-data/apis/sparql","http://nomisma.org/query","http://kerameikos.org/query",
        "http://linkedgeodata.org/sparql","http://dbpedia.org/sparql","http://factforge.net/repositories/ff-news","http://sandbox.mainzed.org/osi/sparql","http://zbw.eu/beta/sparql/econ_pers/query"]

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'SPAQLunicorn_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&SPARQL Unicorn Wikidata Plugin')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('SPAQLunicorn', message)

    def validateSPARQL(self):
        try:
            prepareQuery(self.prefixes[self.dlg.comboBox.currentIndex()]+"\n"+self.dlg.inp_sparql.toPlainText())
            self.dlg.errorLabel.setText("Valid Query")
            self.errorline=-1
            self.sparqlhighlight.errorhighlightline=self.errorline
            self.sparqlhighlight.currentline=0
        except Exception as e:
            self.dlg.errorLabel.setText(str(e))
            if "line" in str(e):
                ex=str(e)
                start = ex.find('line:') + 5
                end = ex.find(',', start)
                start2 = ex.find('col:') + 4
                end2 = ex.find(')', start2)
                self.errorline=ex[start:end]
                self.sparqlhighlight.errorhighlightcol=ex[start2:end2]
                self.sparqlhighlight.errorhighlightline=self.errorline
                self.sparqlhighlight.currentline=0
                #msgBox=QMessageBox()
                #msgBox.setText(str(self.errorline)+" "+str(self.sparqlhighlight.errorhighlightline)+" "+str(self.sparqlhighlight.errorhighlightcol))
                #msgBox.exec()

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToVectorMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        #a = str('numpy' in sys.modules)
        #iface.messageBar().pushMessage("load libs", a, level=Qgis.Success)

        icon_path = ':/plugins/sparql_unicorn/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Adds GeoJSON layer from a Wikidata'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginVectorMenu(
                self.tr(u'&SPARQL Unicorn Wikidata Plugin'),
                action)
            self.iface.removeToolBarIcon(action)

    def processResults(self,results,reproject,latval,lonval):
        features = []
        first=True
        newobject=True
        item=""
        for result in results["results"]["bindings"]:
            if "item" in result and "rel" in result and  "val" in result and (item=="" or result["item"]["value"]!=item):
                if item!="":
                    myGeometryInstance=QgsGeometry.fromWkt(result["geo"]["value"])
                    if reproject!="":
                        sourceCrs = QgsCoordinateReferenceSystem(reproject)
                        destCrs = QgsCoordinateReferenceSystem(4326)
                        tr = QgsCoordinateTransform(sourceCrs, destCrs, QgsProject.instance())
                        myGeometryInstance.transform(tr)
                    #feature = { 'type': 'Feature', 'properties': { 'label': result["label"]["value"], 'item': result["item"]["value"] }, 'geometry': wkt.loads(result["geo"]["value"].replace("Point", "POINT")) }
                    feature = { 'type': 'Feature', 'properties': properties, 'geometry':  json.loads(myGeometryInstance.asJson()) }
                    features.append(feature)
                properties = {}
                item=result["item"]["value"]
            if not "rel" in result and not "val" in result:
                properties = {}
            for var in results["head"]["vars"]:
                if var in result:
                    if var=="rel" and "val" in result:
                        properties[result[var]["value"]] = result["val"]["value"]
                    elif var!="val":
                        properties[var] = result[var]["value"]
            if not "rel" in result and not "val" in result and "geo" in result:
                myGeometryInstance=QgsGeometry.fromWkt(result["geo"]["value"].replace("<http://www.opengis.net/def/crs/EPSG/0/2157> ",""))
                if reproject!="":
                    sourceCrs = QgsCoordinateReferenceSystem(reproject)
                    destCrs = QgsCoordinateReferenceSystem(4326)
                    tr = QgsCoordinateTransform(sourceCrs, destCrs, QgsProject.instance())
                    myGeometryInstance.transform(tr)
                #feature = { 'type': 'Feature', 'properties': { 'label': result["label"]["value"], 'item': result["item"]["value"] }, 'geometry': wkt.loads(result["geo"]["value"].replace("Point", "POINT")) }
                feature = { 'type': 'Feature', 'properties': properties, 'geometry':  json.loads(myGeometryInstance.asJson()) }
                features.append(feature)
            if not "rel" in result and not "val" in result and latval in result and lonval in result and reproject==27700:
                myGeometryInstance = QgsGeometry.fromWkt("POINT("+str(float(result[latval]["value"]))+" "+str(float(result[lonval]["value"]))+")")
                if reproject!="":
                    sourceCrs = QgsCoordinateReferenceSystem(reproject)
                    destCrs = QgsCoordinateReferenceSystem(4326)
                    tr = QgsCoordinateTransform(sourceCrs, destCrs, QgsProject.instance())
                    myGeometryInstance.transform(tr)
                #feature = { 'type': 'Feature', 'properties': { 'label': result["label"]["value"], 'item': result["item"]["value"] }, 'geometry': wkt.loads(result["geo"]["value"].replace("Point", "POINT")) }
                feature = { 'type': 'Feature', 'properties': properties, 'geometry':  json.loads(myGeometryInstance.asJson()) }
                features.append(feature)
            if not "rel" in result and not "val" in result and latval in result and lonval in result and reproject!=27700:
                myGeometryInstance = QgsGeometry.fromWkt("POINT("+str(float(result[lonval]["value"]))+" "+str(float(result[latval]["value"]))+")")
                if reproject!="":
                    sourceCrs = QgsCoordinateReferenceSystem(reproject)
                    destCrs = QgsCoordinateReferenceSystem(4326)
                    tr = QgsCoordinateTransform(sourceCrs, destCrs, QgsProject.instance())
                    myGeometryInstance.transform(tr)
                #feature = { 'type': 'Feature', 'properties': { 'label': result["label"]["value"], 'item': result["item"]["value"] }, 'geometry': wkt.loads(result["geo"]["value"].replace("Point", "POINT")) }
                feature = { 'type': 'Feature', 'properties': properties, 'geometry':  json.loads(myGeometryInstance.asJson()) }
                features.append(feature)
            #print(properties)
        if "rel" in results["results"]["bindings"] and "val" in results["results"]["bindings"]:
            myGeometryInstance = QgsGeometry.fromWkt(result["geo"]["value"])
            if reproject!="":
                sourceCrs = QgsCoordinateReferenceSystem(reproject)
                destCrs = QgsCoordinateReferenceSystem(4326)
                tr = QgsCoordinateTransform(sourceCrs, destCrs, QgsProject.instance())
                myGeometryInstance.transform(tr)
            #feature = { 'type': 'Feature', 'properties': { 'label': result["label"]["value"], 'item': result["item"]["value"] }, 'geometry': wkt.loads(result["geo"]["value"].replace("Point", "POINT")) }
            feature = { 'type': 'Feature', 'properties': properties, 'geometry':  json.loads(myGeometryInstance.asJson()) }
            features.append(feature)
        if features==[]:
            return None
        geojson = {'type': 'FeatureCollection', 'features': features }
        return geojson

    def create_unicorn_layer(self):
        endpointIndex = self.dlg.comboBox.currentIndex()
        # SPARQL query
        #print(self.loadedfromfile)
		# query
        query = self.dlg.inp_sparql.toPlainText()
        if self.loadedfromfile:
            concept = self.dlg.layerconcepts.currentText()
            geojson=self.getGeoJSONFromGeoConcept(self.currentgraph,concept)
            vlayer = QgsVectorLayer(json.dumps(geojson, sort_keys=True, indent=4),"unicorn_"+self.dlg.inp_label.text(),"ogr")
            print(vlayer.isValid())
            QgsProject.instance().addMapLayer(vlayer)
            canvas = iface.mapCanvas()
            canvas.setExtent(vlayer.extent())
            iface.messageBar().pushMessage("Add layer", "OK", level=Qgis.Success)
            #iface.messageBar().pushMessage("Error", "An error occured", level=Qgis.Critical)
            self.dlg.close()
            return
        else:
            endpoint_url=self.endpoints[endpointIndex]
        if "?rel" in query and "?val" in query and not "?item" in query:
            msgBox=QMessageBox()
            msgBox.setText("A SPARQL query including the ?rel and ?val variable needs to include an ?item variable indicating the individual URI. ")
            msgBox.exec()
            return
        if (endpointIndex==1 or endpointIndex==8) and not "?geo" in query:
            msgBox=QMessageBox()
            msgBox.setText("The SPARQL query needs to include a ?geo variable indicating a geometry literal! ")
            msgBox.exec()
            return
        if (endpointIndex==2) and not "?easting" in query and not "?northing" in query:
            msgBox=QMessageBox()
            msgBox.setText("The SPARQL query needs to include a ?geo variable indicating a geometry literal! ")
            msgBox.exec()
            return
        if (endpointIndex==3 or endpointIndex==4 or endpointIndex==5 or endpointIndex==6 or endpointIndex==7 or endpointIndex==9) and not "?lat" in query  and not "?lon" in query:
            msgBox=QMessageBox()
            msgBox.setText("The SPARQL query needs to include a ?lat and a ?lon variable indicating a latitude and longitude literals! ")
            msgBox.exec()
            return
        sparql = SPARQLWrapper(endpoint_url, agent="Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.64 Safari/537.11")
        sparql.setQuery(self.prefixes[endpointIndex] + query)
        sparql.setReturnFormat(JSON)
        try:
            results = sparql.query().convert()
        except Exception as e:
            msgBox=QMessageBox()
            msgBox.setText("The following exception occurred: "+str(e))
            msgBox.exec()
            return
        #print(results)
        # geojson stuff
        
        if endpointIndex == 1:
            geojson=self.processResults(results,"","","")
        elif endpointIndex == 2:
            geojson=self.processResults(results,27700,"easting","northing")
        elif endpointIndex == 3 or endpointIndex == 4 or endpointIndex==5 or endpointIndex==6 or endpointIndex==7 or endpointIndex==9:
            geojson=self.processResults(results,"","lat","lon")
        elif endpointIndex == 8:
            geojson=self.processResults(results,2157,"","")
        if geojson==None:
            msgBox=QMessageBox()
            msgBox.setText("The query yielded no results. Therefore no layer will be created!")
            msgBox.exec()
            return
        # add layer
        vlayer = QgsVectorLayer(json.dumps(geojson, sort_keys=True, indent=4),"unicorn_"+self.dlg.inp_label.text(),"ogr")
        print(vlayer.isValid())
        QgsProject.instance().addMapLayer(vlayer)
        canvas = iface.mapCanvas()
        canvas.setExtent(vlayer.extent())
        iface.messageBar().pushMessage("Add layer", "OK", level=Qgis.Success)
        #iface.messageBar().pushMessage("Error", "An error occured", level=Qgis.Critical)
        self.dlg.close()

    """Extracts geographic concepts from an rdf file."""
    def getGeoConceptsFromGraph(self,graph):
        viewlist=[]
        qres = graph.query(
        """SELECT DISTINCT ?a_class (count(?a_class) as ?count)
        WHERE {
          ?a rdf:type ?a_class .
          ?a <http://www.opengis.net/ont/geosparql#hasGeometry> ?a_geom .
        }""")
        print(qres)
        self.dlg.layercount.setText("["+str(len(qres))+"]")
        for row in qres:
            viewlist.append(str(row[0]))
        return viewlist

    """Extracts geographic WKT concepts from Wikidata."""
    def getGeoConceptsFromWikidata(self):
        viewlist=[]
        resultlist=[]
        sparql = SPARQLWrapper("https://query.wikidata.org/sparql", agent="Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.64 Safari/537.11")
        sparql.setQuery(
        """SELECT DISTINCT ?class
        WHERE {
          ?a <http://www.wikidata.org/prop/direct/P31> ?class .
          ?a <http://www.wikidata.org/prop/direct/P625> ?a_geom .
        } LIMIT 500""")
        print("now sending query")
        sparql.setReturnFormat(JSON)
        results = sparql.query().convert()
        for result in results["results"]["bindings"]:
            viewlist.append(str(result["class"]["value"]))
        print(viewlist)
        labels=self.getWikidataLabelsForQIDs(viewlist)
        print(labels)
        self.dlg.layercount.setText("["+str(len(labels))+"]")
        i=0
        sorted_labels=sorted(labels.items(),key=lambda x:x[1])
        for lab in sorted_labels:
            resultlist.append(labels[lab[0]]+"("+lab[0]+")")
            i=i+1
        return resultlist

    """Extracts geographic concepts from a SPARQL endpoint."""
    def getGeoConceptsFromGeoSPARQLTripleStore(self,triplestoreurl):
        viewlist=[]
        resultlist=[]
        sparql = SPARQLWrapper(triplestoreurl, agent="Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.64 Safari/537.11")
        sparql.setQuery(
        """SELECT DISTINCT ?class
        WHERE {
          ?a <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> ?class .
          ?a <http://www.opengis.net/ont/geosparql#hasGeometry> ?geom .
        } LIMIT 500""")
        print("now sending query")
        sparql.setReturnFormat(JSON)
        results = sparql.query().convert().sort()
        for result in results["results"]["bindings"]:
            viewlist.append(str(result["class"]["value"]))
        print(viewlist)
        self.dlg.layercount.setText("["+str(len(viewlist))+"]")
        return viewlist

    """Extracts geographic concepts from a triplestore saving geoconcepts using lat lon properties."""
    def getGeoConceptsFromLatLonTripleStore(self,triplestoreurl):
        viewlist=[]
        resultlist=[]
        sparql = SPARQLWrapper(triplestoreurl, agent="Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.64 Safari/537.11")
        sparql.setQuery(
        """SELECT DISTINCT ?class
        WHERE {
          ?a <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> ?class .
          ?a <http://www.w3.org/2003/01/geo/wgs84_pos#lat> ?lat .
          ?a <http://www.w3.org/2003/01/geo/wgs84_pos#long> ?long .
        }  LIMIT 500""")
        print("now sending query")
        sparql.setReturnFormat(JSON)
        results = sparql.query().convert()
        for result in results["results"]["bindings"]:
            viewlist.append(str(result["class"]["value"]))
        print(viewlist)
        self.dlg.layercount.setText("["+str(len(viewlist))+"]")
        return viewlist
		
    """Extracts geographic concepts from a triplestore saving geoconcepts using lat lon properties."""
    def getGeoConceptsFromEastingNorthingTripleStore(self,triplestoreurl):
        viewlist=[]
        resultlist=[]
        sparql = SPARQLWrapper(triplestoreurl, agent="Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.64 Safari/537.11")
        sparql.setQuery(
        """SELECT DISTINCT ?class
        WHERE {
          ?a <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> ?class .
          ?a <http://data.ordnancesurvey.co.uk/ontology/spatialrelations/easting> ?easting .
          ?a <http://data.ordnancesurvey.co.uk/ontology/spatialrelations/northing> ?northing .
        }  LIMIT 100""")
        print("now sending query")
        sparql.setReturnFormat(JSON)
        results = sparql.query().convert()
        for result in results["results"]["bindings"]:
            viewlist.append(str(result["class"]["value"]))
        print(viewlist)
        self.dlg.layercount.setText("["+str(len(viewlist))+"]")
        return viewlist

    """Returns classes for a given label from a triple store."""
    def getClassesFromLabel(self):
        viewlist=[]
        resultlist=[]
        label=self.dlg.conceptSearchEdit.text()
        language="en"
        if self.dlg.currentcol==4:
            results=self.getPIDsForLabels(label)
        else:
            results=self.getQIDsForLabels(label)
        self.dlg.searchResult.clear()
        for result in results:
            self.dlg.searchResult.addItem(str(results[result]))
        return viewlist

    """Returns properties for a given label from a triple store."""
    def getPropertiesFromLabel(self):
        viewlist=[]
        resultlist=[]
        sparql = SPARQLWrapper(triplestoreurl, agent="Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.64 Safari/537.11")
        sparql.setQuery(
        """SELECT DISTINCT ?class
        WHERE {
          ?class <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://www.w3.org/2002/07/owl#Property> .
          ?class <http://www.w3.org/2000/01/rdf-schema#label> """+"\""+label+"\"@"+language+""" .
        }  LIMIT 500""")
        print("now sending query")
        sparql.setReturnFormat(JSON)
        results = sparql.query().convert()
        for result in results["results"]["bindings"]:
            self.dlg.searchResult.addItem(str(result["class"]["value"]))
        return viewlist


    def getWikidataLabelsForQIDs(self,qids):
        result={}
        url="https://www.wikidata.org/w/api.php?action=wbgetentities&props=labels&ids="
        i=0
        qidquery=""
        for qid in qids:
            qidquery+="Q"+qid.split("Q")[1]
            if (i%50)==0:
                print(url+qidquery+"&languages=en&format=json")
                myResponse = json.loads(requests.get(url+qidquery+"&languages=en&format=json").text)
                print(myResponse)
                for ent in myResponse["entities"]:
                    print(ent)
                    if "en" in myResponse["entities"][ent]["labels"]:
                        result[ent]=myResponse["entities"][ent]["labels"]["en"]["value"]
                qidquery=""
            else:
                qidquery+="|"
            i=i+1
        return result

    def getQIDsForLabels(self,label):
        result={}
        url="https://www.wikidata.org/w/api.php?action=wbsearchentities&search="+label+"&format=json&language=en&uselang=en&type=item"
        myResponse = json.loads(requests.get(url).text)
        for ent in myResponse["search"]:
            qid=ent["url"]
            label=ent["label"]+" ("+ent["id"]+") ["+ent["description"]+"]"
            result[qid]=label
        return result

    def getPIDsForLabels(self,label):
        result={}
        url="https://www.wikidata.org/w/api.php?action=wbsearchentities&search="+label+"&format=json&language=en&uselang=en&type=property"
        myResponse = json.loads(requests.get(url).text)
        for ent in myResponse["search"]:
            qid=ent["url"]
            label=ent["label"]+" ("+ent["id"]+") ["+ent["description"]+"]"
            result[qid]=label
        return result

    def getGeoJSONFromGeoConcept(self,graph,concept):
        print(concept)
        qres = graph.query(
        """SELECT DISTINCT ?a ?rel ?val ?wkt
        WHERE {
          ?a rdf:type <"""+concept+"""> .
          ?a ?rel ?val .
          OPTIONAL { ?val <http://www.opengis.net/ont/geosparql#asWKT> ?wkt}
        }""")
        geos=[]
        geometries = {
            'type': 'FeatureCollection',
            'features': geos,
            }
        newfeature=False
        lastfeature=""
        currentgeo={}
        for row in qres:
            print(lastfeature+" - "+row[0]+" - "+str(len(row)))
            print(row)
            if(lastfeature=="" or lastfeature!=row[0]):
                if(lastfeature!=""):
                    geos.append(currentgeo)
                lastfeature=row[0]
                currentgeo={'id':row[0],'geometry':{},'properties':{}}
            if(row[3]!=None):
                print(row[3])
                if("<" in row[3]):
                    currentgeo['geometry']=json.loads(QgsGeometry.fromWkt(row[3].split(">")[1].strip()).asJson())
                else:
                    currentgeo['geometry']=json.loads(QgsGeometry.fromWkt(row[3]).asJson())
            else:
                currentgeo['properties'][str(row[1])]=str(row[2])
        return geometries

    def createInterlinkSearchDialog(self, row, column):
        if column>3:
            self.dlg.currentcol=column
            self.dlg.currentrow=row
            self.dlg.interlinkdialog = QDialog()
            self.dlg.interlinkdialog.setMinimumSize(650, 400)
            self.dlg.conceptSearchEdit = QLineEdit(self.dlg.interlinkdialog)
            self.dlg.conceptSearchEdit.move(100,10)
            conceptSearchLabel = QLabel("Search Concept:",self.dlg.interlinkdialog)
            conceptSearchLabel.move(0,10)
            findConcept = QRadioButton("Class",self.dlg.interlinkdialog)
            findConcept.move(230,15)
            if column!=4:
                findConcept.setChecked(True)
            findProperty = QRadioButton("Property",self.dlg.interlinkdialog)
            findProperty.move(230,40)
            if column==4:
                findProperty.setChecked(True)
            findProperty.setEnabled(False)
            findConcept.setEnabled(False)
            self.dlg.tripleStoreEdit = QComboBox(self.dlg.interlinkdialog)
            self.dlg.tripleStoreEdit.move(100,40)
            tripleStoreLabel = QLabel("Triple Store:",self.dlg.interlinkdialog)
            tripleStoreLabel.move(0,40)
            searchButton = QPushButton("Search",self.dlg.interlinkdialog)
            searchButton.move(10,70)
            searchButton.clicked.connect(self.getClassesFromLabel)
            searchResultLabel = QLabel("Search Results",self.dlg.interlinkdialog)
            searchResultLabel.move(100,100)
            self.dlg.searchResult = QListWidget(self.dlg.interlinkdialog)
            self.dlg.searchResult.move(30,120)
            self.dlg.searchResult.setMinimumSize(600, 300)
            applyButton = QPushButton("Apply",self.dlg.interlinkdialog)
            applyButton.move(150,430)
            applyButton.clicked.connect(self.applyConceptToColumn)
            self.dlg.interlinkdialog.setWindowTitle("Search Interlink Concept")
            self.dlg.interlinkdialog.exec_()

    def applyConceptToColumn(self):
        print("test")
        self.dlg.interlinkTable.setItem(self.dlg.currentrow,self.dlg.currentcol,QTableWidgetItem(self.dlg.searchResult.currentItem().text()))
        self.dlg.interlinkdialog.close()

    def loadLayerForEnrichment(self):
        layers = QgsProject.instance().layerTreeRoot().children()
        selectedLayerIndex = self.dlg.chooseLayerEnrich.currentIndex()
        layer = layers[selectedLayerIndex].layer()
        self.dlg.IDColumnEnrich.clear()
        self.dlg.enrichTableResult.hide()
        self.dlg.enrichTable.show()
        fieldnames = [field.name() for field in layer.fields()]
        while self.dlg.enrichTable.rowCount() > 0:
            self.dlg.enrichTable.removeRow(0);
        row=0
        self.dlg.enrichTable.setColumnCount(4)
        self.dlg.enrichTable.setHorizontalHeaderLabels(["Column","EnrichmentConcept","TripleStore","Strategy"])
        for field in fieldnames:
            item=QTableWidgetItem(field)
            item.setFlags(QtCore.Qt.ItemIsEnabled)
            currentRowCount = self.dlg.enrichTable.rowCount()
            self.dlg.IDColumnEnrich.addItem(field)
            self.dlg.enrichTable.insertRow(row)
            self.dlg.enrichTable.setItem(row,0,item)
            cbox=QComboBox()
            cbox.addItem("No Enrichment")
            cbox.addItem("Keep Local")
            cbox.addItem("Keep Remote")
            cbox.addItem("Merge")
            cbox.addItem("Ask User")
            self.dlg.enrichTable.setCellWidget(row,3,cbox)
            #self.dlg.enrichTable.setItem(row,3,cbox)
            row+=1

    def enrichLayer(self):
        layers = QgsProject.instance().layerTreeRoot().children()
        selectedLayerIndex = self.dlg.chooseLayerEnrich.currentIndex()
        layer = layers[selectedLayerIndex].layer()
        attlist={}
        itemlist=[]
        propertylist=[]
        idfield=self.dlg.IDColumnEnrich.currentText()
        for row in range(self.dlg.enrichTable.rowCount()):
            item = self.dlg.enrichTable.item(row, 0).text()
            property=self.dlg.enrichTable.item(row, 1)
            strategy = self.dlg.enrichTable.cellWidget(row, 3).currentText()
            if item!=idfield:
                propertylist.append(self.dlg.enrichTable.item(row, 1))
            if strategy!="No Enrichment" and property!=None:
                itemlist.append(item)
                attlist[item]=[]
                for f in layer.getFeatures():
                    attlist[item].append(f[item])
                query="SELECT ?item ?val WHERE {\n VALUES ?item { "
                for it in attlist[idfield]:
                    query+=it
                query+=" } . \n"
                query+="?item <"+property+"> ?val . } ORDER BY ?item "
                sparql = SPARQLWrapper(triplestoreurl, agent="Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.64 Safari/537.11")
                sparql.setQuery(query)
                print("now sending query")
                sparql.setReturnFormat(JSON)
                results = sparql.query().convert()
                resultcounter=0
                for f in layer.getFeatures():
                    if strategy=="Keep Local" and f[item]=="" and results["results"]["bindings"][resultcounter]["val"]["value"]!="":
                        f[item]=results["results"]["bindings"][resultcounter]["val"]["value"]
                    elif strategy=="Keep Remote" and results["results"]["bindings"][resultcounter]["val"]["value"]!="":
                        f[item]=results["results"]["bindings"][resultcounter]["val"]["value"]
                    elif strategy=="Merge":
                        f[item]=str(f[item])+";"+str(results["results"]["bindings"][resultcounter]["val"]["value"])
                    elif strategy=="Ask User":
                        print("Asking user")
                    resultcounter+=1
            row+=1
        self.dlg.enrichTable.hide()
        self.dlg.enrichTableResult.show()
        fieldnames = [field.name() for field in layer.fields()]
        self.dlg.enrichTableResult.setColumnCount(len(layer.fields()))
        self.dlg.enrichTableResult.setHorizontalHeaderLabels(fieldnames)
        row=0
        for f in layer.getFeatures():
            fieldcounter=0
            for field in f:
                item=QTableWidgetItem(field)
                self.dlg.enrichTableResult.setItem(row,fieldcounter,item)
                fieldcounter+=1
            row+=1



    def loadLayerForInterlink(self):
        layers = QgsProject.instance().layerTreeRoot().children()
        selectedLayerIndex = self.dlg.chooseLayerInterlink.currentIndex()
        layer = layers[selectedLayerIndex].layer()
        fieldnames = [field.name() for field in layer.fields()]
        while self.dlg.interlinkTable.rowCount() > 0:
            self.dlg.interlinkTable.removeRow(0);
        row=0
        self.dlg.interlinkTable.setHorizontalHeaderLabels(["Export?","IDColumn?","GeoColumn?","Column","ColumnProperty","ColumnConcept","ValueConcepts"])
        self.dlg.interlinkTable.setColumnCount(7)
        for field in fieldnames:
            item=QTableWidgetItem(field)
            item.setFlags(QtCore.Qt.ItemIsEnabled)
            item2=QTableWidgetItem()
            item2.setCheckState(True)
            item3=QTableWidgetItem()
            item3.setCheckState(False)
            item4=QTableWidgetItem()
            item4.setCheckState(False)
            currentRowCount = self.dlg.interlinkTable.rowCount()
            self.dlg.interlinkTable.insertRow(row)
            self.dlg.interlinkTable.setItem(row,3,item)
            self.dlg.interlinkTable.setItem(row,0,item2)
            self.dlg.interlinkTable.setItem(row,1,item3)
            self.dlg.interlinkTable.setItem(row,2,item4)
            row+=1

    def exportEnrichedLayer(self):
        self.exportIdCol=""
        self.exportNameSpace=self.dlg.interlinkNameSpace.text()
        self.exportSetClass=self.dlg.interlinkOwlClassInput.text()
        for row in range(self.dlg.interlinkTable.rowCount()):
            item = self.dlg.interlinkTable.item(row, 0)
            if item.checkState():
                if self.dlg.interlinkTable.item(row, 1).checkState():
                    self.exportIdCol=self.dlg.interlinkTable.item(row, 3).text()
                else:
                    column = self.dlg.interlinkTable.item(row, 3).text()
                    if self.dlg.interlinkTable.item(row,4)!=None:
                        column=self.dlg.interlinkTable.item(row,4).text()
                    if self.dlg.interlinkTable.item(row, 5)!=None:
                        concept = self.dlg.interlinkTable.item(row, 5).text()
                        self.exportColConfig[column]=concept
                    if self.dlg.interlinkTable.item(row, 6)!=None:
                        valueconcept = self.dlg.interlinkTable.item(row, 6).text()
        self.enrichedExport=True
        self.exportLayer()

    def matchColumnValueFromTripleStore(self,toquery):
        values="VALUES ?vals { "
        for queryval in toquery:
            values+="\""+queryval+"\""
        values+="}"
        sparql = SPARQLWrapper("https://query.wikidata.org/sparql", agent="Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.64 Safari/537.11")
        sparql.setQuery(
        """SELECT DISTINCT ?a
        WHERE {
          ?a wdt:P31 ?class .
          ?a ?label ?vals .
        } """)
        sparql.setReturnFormat(JSON)
        results = sparql.query().convert()
        for result in results["results"]["bindings"]:
            viewlist.append(str(result["a"]["value"]))
        return viewlist


    def exportLayer(self):
        filename, _filter = QFileDialog.getSaveFileName(
            self.dlg, "Select   output file ","", "Linked data (*.rdfxml *.ttl *.n3 *.owl *.nt *.nq *.trix *.json-ld)",)
        if filename=="":
             return
        layers = QgsProject.instance().layerTreeRoot().children()
        if self.enrichedExport:
            selectedLayerIndex = self.dlg.chooseLayerInterlink.currentIndex()
        else:
            selectedLayerIndex = self.dlg.loadedLayers.currentIndex()
        layer = layers[selectedLayerIndex].layer()
        fieldnames = [field.name() for field in layer.fields()]
        ttlstring="<http://www.opengis.net/ont/geosparql#Feature> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://www.w3.org/2002/07/owl#Class> .\n"
        ttlstring+="<http://www.opengis.net/ont/geosparql#SpatialObject> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://www.w3.org/2002/07/owl#Class> .\n"
        ttlstring+="<http://www.opengis.net/ont/geosparql#Geometry> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://www.w3.org/2002/07/owl#Class> .\n"
        ttlstring+="<http://www.opengis.net/ont/geosparql#hasGeometry> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://www.w3.org/2002/07/owl#ObjectProperty> .\n"
        ttlstring+="<http://www.opengis.net/ont/geosparql#asWKT> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://www.w3.org/2002/07/owl#DatatypeProperty> .\n"
        ttlstring+="<http://www.opengis.net/ont/geosparql#Feature> <http://www.w3.org/2000/01/rdf-schema#subClassOf> <http://www.opengis.net/ont/geosparql#SpatialObject> .\n"
        ttlstring+="<http://www.opengis.net/ont/geosparql#Geometry> <http://www.w3.org/2000/01/rdf-schema#subClassOf> <http://www.opengis.net/ont/geosparql#SpatialObject> .\n"
        first=0
        if self.exportNameSpace=="":
            namespace="http://www.github.com/sparqlunicorn#"
        else:
            namespace=self.exportNameSpace
        if self.exportIdCol=="":
            idcol="id"
        else:
            idcol=self.exportIdCol
        classcol="http://www.w3.org/1999/02/22-rdf-syntax-ns#type"
        curid=""
        if self.exportSetClass=="":
            curclassid=namespace+str(uuid.uuid4())
        else:
            curclassid=self.exportSetClass
        for f in layer.getFeatures():
            geom = f.geometry()
            if not idcol in fieldnames:
                curid=namespace+str(uuid.uuid4())
            else:
                curid=f[idcol]
            if not classcol in fieldnames:
                ttlstring+="<"+curid+"> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <"+curclassid+"> .\n"
                if first==0:
                    ttlstring+="<"+curclassid+"> <http://www.w3.org/2000/01/rdf-schema#subClassOf> <http://www.opengis.net/ont/geosparql#Feature> .\n"
                    ttlstring+="<"+curclassid+"> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://www.w3.org/2002/07/owl#Class> .\n"
            ttlstring+="<"+curid+"> <http://www.opengis.net/ont/geosparql#hasGeometry> <"+curid+"_geom> .\n"
            ttlstring+="<"+curid+"_geom> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://www.opengis.net/ont/geosparql#"+QgsWkbTypes.displayString(geom.wkbType())+"> .\n"
            ttlstring+="<http://www.opengis.net/ont/geosparql#"+QgsWkbTypes.displayString(geom.wkbType())+"> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://www.w3.org/2002/07/owl#Class> .\n"
            ttlstring+="<http://www.opengis.net/ont/geosparql#"+QgsWkbTypes.displayString(geom.wkbType())+"> <http://www.w3.org/2000/01/rdf-schema#subClassOf> <http://www.opengis.net/ont/geosparql#Geometry> .\n"
            ttlstring+="<"+curid+"_geom> <http://www.opengis.net/ont/geosparql#asWKT> \""+geom.asWkt()+"\"^^<http://www.opengis.net/ont/geosparql#wktLiteral> .\n"
            for prop in fieldnames:
                if prop=="http://www.w3.org/1999/02/22-rdf-syntax-ns#type" and "http" in f[prop]:
                    ttlstring+="<"+f[prop]+"> <"+prop+"> <http://www.w3.org/2002/07/owl#Class> .\n"
                    ttlstring+="<"+f[prop]+"> <http://www.w3.org/2000/01/rdf-schema#subClassOf> <http://www.opengis.net/ont/geosparql#Feature> .\n"
                if prop=="id":
                    continue
                elif prop=="http://www.w3.org/2000/01/rdf-schema#label" or prop=="http://www.w3.org/2000/01/rdf-schema#comment":
                    ttlstring+="<"+curid+"> <"+prop+"> \""+str(f[prop]).replace('"','\\"')+"\"^^<http://www.w3.org/2001/XMLSchema#string> .\n"
                    if first<10:
                        ttlstring+="<"+prop+"> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://www.w3.org/2002/07/owl#AnnotationProperty> .\n"
                        ttlstring+="<"+prop+"> <http://www.w3.org/2000/01/rdf-schema#domain> <"+curclassid+"> .\n"
                elif not f[prop] or f[prop]==None or f[prop]=="":
                    continue
                elif re.match(r'^-?\d+$', str(f[prop])):
                    ttlstring+="<"+curid+"> <"+prop+"> \""+str(f[prop])+"\"^^<http://www.w3.org/2001/XMLSchema#integer> .\n"
                    if first<10:
                        ttlstring+="<"+prop+"> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://www.w3.org/2002/07/owl#DatatypeProperty> .\n"
                        ttlstring+="<"+prop+"> <http://www.w3.org/2000/01/rdf-schema#domain> <"+curclassid+"> .\n"
                        ttlstring+="<"+prop+"> <http://www.w3.org/2000/01/rdf-schema#range> <http://www.w3.org/2001/XMLSchema#integer> .\n"
                elif re.match(r'^-?\d+(?:\.\d+)?$', str(f[prop])):
                    ttlstring+="<"+curid+"> <"+prop+"> \""+str(f[prop])+"\"^^<http://www.w3.org/2001/XMLSchema#double> .\n"
                    if first:
                        ttlstring+="<"+prop+"> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://www.w3.org/2002/07/owl#DatatypeProperty> .\n"
                        ttlstring+="<"+prop+"> <http://www.w3.org/2000/01/rdf-schema#domain> <"+curclassid+"> .\n"
                        ttlstring+="<"+prop+"> <http://www.w3.org/2000/01/rdf-schema#range> <http://www.w3.org/2001/XMLSchema#double> .\n"
                elif "http" in f[prop]:
                    ttlstring+="<"+curid+"> <"+prop+"> <"+str(f[prop])+"> .\n"
                    if first<10:
                        ttlstring+="<"+prop+"> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://www.w3.org/2002/07/owl#ObjectProperty> .\n"
                        ttlstring+="<"+prop+"> <http://www.w3.org/2000/01/rdf-schema#domain> <"+curclassid+"> .\n"
                else:
                    ttlstring+="<"+curid+"> <"+prop+"> \""+str(f[prop]).replace('"','\\"')+"\"^^<http://www.w3.org/2001/XMLSchema#string> .\n"
                    if first<10:
                        ttlstring+="<"+prop+"> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://www.w3.org/2002/07/owl#DatatypeProperty> .\n"
                        ttlstring+="<"+prop+"> <http://www.w3.org/2000/01/rdf-schema#domain> <"+curclassid+"> .\n"
                        ttlstring+="<"+prop+"> <http://www.w3.org/2000/01/rdf-schema#range> <http://www.w3.org/2001/XMLSchema#string> .\n"
            if first<10:
                first=first+1
#        with open(filename+"_temp", 'w') as output_file:
#            output_file.write(ttlstring)
        g=rdflib.Graph()
        g.parse(data=ttlstring, format="ttl")
        splitted=filename.split(".")
        exportNameSpace=""
        exportSetClass=""
        with open(filename, 'w') as output_file:
            output_file.write(g.serialize(format=splitted[len(splitted)-1]).decode("utf-8"))
            iface.messageBar().pushMessage("export layer successfully!", "OK", level=Qgis.Success)

    def exportLayerAsGeoJSONLD(self):
        context={
    "geojson": "https://purl.org/geojson/vocab#",
    "Feature": "geojson:Feature",
    "FeatureCollection": "geojson:FeatureCollection",
    "GeometryCollection": "geojson:GeometryCollection",
    "LineString": "geojson:LineString",
    "MultiLineString": "geojson:MultiLineString",
    "MultiPoint": "geojson:MultiPoint",
    "MultiPolygon": "geojson:MultiPolygon",
    "Point": "geojson:Point",
    "Polygon": "geojson:Polygon",
    "bbox": {
      "@container": "@list",
      "@id": "geojson:bbox"
    },
    "coordinates": {
      "@container": "@list",
      "@id": "geojson:coordinates"
    },
    "features": {
      "@container": "@set",
      "@id": "geojson:features"
    },
    "geometry": "geojson:geometry",
    "id": "@id",
    "properties": "geojson:properties",
    "type": "@type",
    "description": "http://purl.org/dc/terms/description",
    "title": "http://purl.org/dc/terms/title"
  }
        layer = layers[selectedLayerIndex].layer()
        fieldnames = [field.name() for field in layer.fields()]
        currentgeo={}
        geos=[]
        for f in layer.getFeatures():
            geom = f.geometry()
            currentgeo={'id':row[0],'geometry':json.loads(geom.asJson()),'properties':{}}
            for prop in fieldnames:
                if prop=="id":
                    currentgeo["id"]=f[prop]
                else:
                    currentgeo["properties"][prop]=f[prop]
            geos.append(currentgeo)
        featurecollection={"@context":context, "type":"FeatureCollection", "@id":"http://example.com/collections/1", "features": geos }
        return featurecollection

    def loadGraph(self):
        dialog = QFileDialog(self.dlg)
        dialog.setFileMode(QFileDialog.AnyFile)
        self.justloadingfromfile=True
        if dialog.exec_():
            self.dlg.comboBox.setCurrentIndex(0)
            fileNames = dialog.selectedFiles()
            g = rdflib.Graph()
            filepath=fileNames[0].split(".")
            result = g.parse(fileNames[0], format=filepath[len(filepath)-1])
            print(g)
            self.currentgraph=g
            geoconcepts=self.getGeoConceptsFromGraph(g)
            self.dlg.layerconcepts.clear()
            for geo in geoconcepts:
                self.dlg.layerconcepts.addItem(geo)
            self.dlg.inp_sparql.setPlainText("""SELECT DISTINCT ?a ?rel ?val ?wkt
            WHERE {
            ?a rdf:type <"""+geoconcepts[0]+"""> .
            ?a ?rel ?val .
            OPTIONAL { ?val geo:asWKT ?wkt}
            }""")
            self.loadedfromfile=True
            self.justloadingfromfile=False
            return result
        return None

    def getWikidataAreaConcepts(self):
        resultlist=[]
        resultlist.append("city"+" (Q515)")
        resultlist.append("country"+" (Q6256)")
        return resultlist

    def loadAreas(self):
        resultlist=[]
        return resultlist

    def loadUnicornLayers(self):
        # Fetch the currently loaded layers
        layers = QgsProject.instance().layerTreeRoot().children()
        # Populate the comboBox with names of all the loaded unicorn layers
        self.dlg.loadedLayers.clear()
        self.dlg.chooseLayerInterlink.clear()
        self.dlg.chooseLayerEnrich.clear()
        for layer in layers:
            ucl = layer.name()
            #if type(layer) == QgsMapLayer.VectorLayer:
            self.dlg.loadedLayers.addItem(layer.name())
            self.dlg.chooseLayerInterlink.addItem(layer.name())
            self.dlg.chooseLayerEnrich.addItem(layer.name())

    def endpointselectaction(self):
        endpointIndex = self.dlg.comboBox.currentIndex()
        self.dlg.layerconcepts.clear()
        if endpointIndex==1:
            print("changing to wikidata")
            conceptlist=self.getGeoConceptsFromWikidata()
            for concept in conceptlist:
                self.dlg.layerconcepts.addItem(concept)
            conceptlist2=self.getWikidataAreaConcepts()
            for concept in conceptlist2:
                self.dlg.areaconcepts.addItem(concept)
        elif endpointIndex==2:
            self.dlg.layerconcepts.addItem("http://data.ordnancesurvey.co.uk/ontology/50kGazetteer/NamedPlace")
            #conceptlist=self.getGeoConceptsFromEastingNorthingTripleStore("http://data.ordnancesurvey.co.uk/datasets/os-linked-data/apis/sparql")
            #for concept in conceptlist:
                #self.dlg.layerconcepts.addItem(concept)
        elif endpointIndex==3:
            self.dlg.layerconcepts.addItem("http://www.w3.org/2003/01/geo/wgs84_pos#SpatialThing")
            self.dlg.layerconcepts.addItem("http://www.w3.org/2004/02/skos/core#Concept")
            self.dlg.layerconcepts.addItem("http://nomisma.org/ontology#Mint")
            self.dlg.layerconcepts.addItem("http://nomisma.org/ontology#Region")
        elif endpointIndex==4:
            self.dlg.layerconcepts.addItem("http://www.w3.org/2003/01/geo/wgs84_pos#SpatialThing")
            self.dlg.layerconcepts.addItem("http://www.cidoc-crm.org/cidoc-crm/E53_Place")
            self.dlg.layerconcepts.addItem("http://www.ics.forth.gr/isl/CRMgeo/SP5_Geometric_Place_Expression")
        elif endpointIndex==5:
            conceptlist=self.getGeoConceptsFromLatLonTripleStore("http://linkedgeodata.org/sparql")
            for concept in conceptlist:
                self.dlg.layerconcepts.addItem(concept)
        elif endpointIndex==6:
            conceptlist=self.getGeoConceptsFromLatLonTripleStore("http://dbpedia.org/sparql")
            for concept in conceptlist:
                self.dlg.layerconcepts.addItem(concept)
        elif endpointIndex==7:
            #conceptlist=self.getGeoConceptsFromLatLonTripleStore("http://factforge.net/repositories/ff-news")
            self.dlg.layerconcepts.addItem("Feature")
            for concept in self.geonamesconcepts:
                self.dlg.layerconcepts.addItem("Feature: "+concept)
        elif endpointIndex==8:
            self.dlg.layerconcepts.addItem("http://www.opengis.net/ont/geosparql#Feature")
            self.dlg.layerconcepts.addItem("http://ontologies.geohive.ie/osi#County")
            self.dlg.layerconcepts.addItem("http://ontologies.geohive.ie/osi#Barony")
            self.dlg.layerconcepts.addItem("http://ontologies.geohive.ie/osi#Council")
            self.dlg.layerconcepts.addItem("http://ontologies.geohive.ie/osi#Townland")
            self.dlg.layerconcepts.addItem("http://ontologies.geohive.ie/osi#ElectoralDivision")
            self.dlg.layerconcepts.addItem("http://ontologies.geohive.ie/osi#GaeltachtRegion")
            self.dlg.layerconcepts.addItem("http://ontologies.geohive.ie/osi#LocalElectoralArea")
            self.dlg.layerconcepts.addItem("http://ontologies.geohive.ie/osi#MunicipalDistrict")
            self.dlg.layerconcepts.addItem("http://ontologies.geohive.ie/osi#NationalConstituency")
            self.dlg.layerconcepts.addItem("http://ontologies.geohive.ie/osi#CivilParish")
            self.dlg.layerconcepts.addItem("http://ontologies.geohive.ie/osi#RuralArea")
            self.dlg.inp_sparql.setPlainText("""SELECT ?item ?label ?geo WHERE {
            ?item a <"""+self.dlg.layerconcepts.currentText()+""">.
            ?item rdfs:label ?label.
            FILTER (lang(?label) = 'en')
            ?item ogc:hasGeometry [
            ogc:asWKT ?geo
            ] .
            } LIMIT 10""")
        elif endpointIndex==9:
            conceptlist=self.getGeoConceptsFromLatLonTripleStore("http://zbw.eu/beta/sparql/gnd/query")
            for concept in conceptlist:
                self.dlg.layerconcepts.addItem(concept)

    def setBBOXInQuery(self):
        pointt1=QgsGeometry.fromWkt(self.rect_tool.point1.asWkt())
        pointt2=QgsGeometry.fromWkt(self.rect_tool.point2.asWkt())
        pointt3=QgsGeometry.fromWkt(self.rect_tool.point3.asWkt())
        pointt4=QgsGeometry.fromWkt(self.rect_tool.point4.asWkt())
        sourceCrs = QgsCoordinateReferenceSystem(self.mts_layer.crs())
        destCrs = QgsCoordinateReferenceSystem(4326)
        tr = QgsCoordinateTransform(sourceCrs, destCrs, QgsProject.instance())
        pointt1.transform(tr)
        pointt2.transform(tr)
        pointt3.transform(tr)
        pointt4.transform(tr)
        polygon = QgsGeometry.fromPolylineXY( [pointt1.asPoint(),pointt2.asPoint(),pointt3.asPoint(),pointt4.asPoint()] )
        center=polygon.centroid()
        #distance = QgsDistanceArea()
        #distance.setSourceCrs(destCrs)
        #distance.setEllipsoidalMode(True)
        #distance.setEllipsoid('WGS84')
        widthm = 100 #distance.measureLine(pointt1, pointt2)
        self.curbbox=[]
        self.curbbox.append(pointt1)
        self.curbbox.append(pointt2)
        self.curbbox.append(pointt3)
        self.curbbox.append(pointt4)
        self.d.close()
        curquery=self.dlg.inp_sparql.toPlainText()
        endpointIndex = self.dlg.comboBox.currentIndex()
        if endpointIndex==1:
            curquery=curquery[0:curquery.rfind('}')]+"""SERVICE wikibase:box {\n ?item wdt:P625 ?geo .\n
      bd:serviceParam wikibase:cornerSouthWest " """+pointt2.asWkt()+""""^^<http://www.opengis.net/geosparql#wktLiteral> .\n
      bd:serviceParam wikibase:cornerNorthEast " """+pointt4.asWkt()+""""^^<http://www.opengis.net/geosparql#wktLiteral> .\n
    }\n }"""+curquery[curquery.rfind('}')+1:]
            self.dlg.inp_sparql.setPlainText(curquery)
        elif endpointIndex==5:
            curquery=curquery[0:curquery.rfind('}')]+"""Filter(bif:st_intersects (?geo, bif:st_point ("""+str(center.asPoint().y())+","+str(center.asPoint().x())+"),"+str(widthm/1000)+""")) .}"""+curquery[curquery.rfind('}')+1:]
            self.dlg.inp_sparql.setPlainText(curquery)
        elif endpointIndex==6:
            curquery=curquery[0:curquery.rfind('}')]+"""FILTER(bif:st_within(bif:st_point(?lon, ?lat), bif:st_point("""+str(center.asPoint().x())+","+str(center.asPoint().y())+"),"+str(widthm/1000)+""")) .}"""+curquery[curquery.rfind('}')+1:]
            self.dlg.inp_sparql.setPlainText(curquery)

    def getPointFromCanvas(self):
        self.d = QDialog()
        self.vl = QgsVectorLayer("Point", "temporary_points", "memory")
        self.map_canvas = QgsMapCanvas(self.d)
        self.map_canvas.setMinimumSize(500, 475)
        uri="url=http://a.tile.openstreetmap.org/{z}/{x}/{y}.png&zmin=0&type=xyz"
        self.mts_layer=QgsRasterLayer(uri,'OSM','wms')
        if not self.mts_layer.isValid():
            print ("Layer failed to load!")
        self.rect_tool = RectangleMapTool(self.map_canvas)
        self.map_canvas.setMapTool(self.rect_tool)
        #self.rect_tool.canvasClicked.connect( self.displaypoint )
        self.map_canvas.setExtent(self.mts_layer.extent())
        self.map_canvas.setLayers( [self.vl,self.mts_layer] )
        self.map_canvas.setCurrentLayer(self.mts_layer)
        #self.bboxextent = QLineEdit(self.d)
        #self.bboxextent.move(80,500)
        #self.bboxextent.setText("100")
        #self.bboxCoordinateLabelLon=QLabel("Lon: ",self.d)
        #self.bboxCoordinateLabelLon.move(0,470)
        #self.bboxCoordinateLabelLon.setMinimumSize(500, 30)
        #bboxextentLabel = QLabel("BBOX Extent:",self.d)
        #bboxextentLabel.move(0,505)
        #bboxextentLabel2 = QLabel("km",self.d)
        #bboxextentLabel2.move(200,505)
        b1 = QPushButton("Apply",self.d)
        b1.move(400,500)
        b1.clicked.connect(self.setBBOXInQuery)
        self.d.setWindowTitle("Choose BoundingBox")
        self.d.exec_()

    def display_point(self):
        print("hallo")

    def viewselectaction(self):
        endpointIndex = self.dlg.comboBox.currentIndex()
        if endpointIndex==0:
            self.justloadingfromfile=False
            return
        if endpointIndex==1:
            if self.dlg.layerconcepts.currentText()=="":
                concept="1248784"
            else:
                concept=self.dlg.layerconcepts.currentText().split("Q")[1].replace(")","")
            if self.dlg.queryTemplates.currentText()=="All Attributes":
                self.dlg.inp_sparql.setPlainText("""SELECT ?item ?itemLabel ?rel ?val ?geo WHERE {
            ?item <http://www.wikidata.org/prop/direct/P31> <http://www.wikidata.org/entity/Q"""+concept+"""> .
            ?item <http://www.wikidata.org/prop/direct/P625> ?geo .
            ?item ?rel ?val .
			SERVICE wikibase:label { bd:serviceParam wikibase:language "[AUTO_LANGUAGE],en". }
            } LIMIT 100""")
            else:
                self.dlg.inp_sparql.setPlainText("""SELECT ?item ?itemLabel ?geo WHERE {
            ?item <http://www.wikidata.org/prop/direct/P31> <http://www.wikidata.org/entity/Q"""+concept+""">.
            ?item <http://www.wikidata.org/prop/direct/P625> ?geo .
			SERVICE wikibase:label { bd:serviceParam wikibase:language "[AUTO_LANGUAGE],en". }
            } LIMIT 10""")
        elif endpointIndex==2:
            self.dlg.inp_sparql.setPlainText("""SELECT ?item ?easting ?northing {
            ?item a <"""+self.dlg.layerconcepts.currentText()+""">.
            ?item <http://data.ordnancesurvey.co.uk/ontology/spatialrelations/easting> ?easting .
            ?item <http://data.ordnancesurvey.co.uk/ontology/spatialrelations/northing> ?northing .
            } LIMIT 10""")
        elif endpointIndex==3:
            if self.dlg.queryTemplates.currentText()=="All Attributes":
                self.dlg.inp_sparql.setPlainText("""SELECT ?item ?rel ?val ?lat ?lon WHERE {
            ?item a <"""+self.dlg.layerconcepts.currentText()+""">.
			?item ?rel ?val .
            ?item <http://www.w3.org/2003/01/geo/wgs84_pos#lat> ?lat .
            ?item <http://www.w3.org/2003/01/geo/wgs84_pos#long> ?lon .
            } LIMIT 100""")
            else:
                self.dlg.inp_sparql.setPlainText("""SELECT ?item ?lat ?lon WHERE {
            ?item a <"""+self.dlg.layerconcepts.currentText()+""">.
            ?item <http://www.w3.org/2003/01/geo/wgs84_pos#lat> ?lat .
            ?item <http://www.w3.org/2003/01/geo/wgs84_pos#long> ?lon .
            } LIMIT 10""")
        elif endpointIndex==4:
            if self.dlg.queryTemplates.currentText()=="All Attributes":
                self.dlg.inp_sparql.setPlainText("""SELECT ?item ?label ?rel ?val ?lat ?lon WHERE {
            ?item a <"""+self.dlg.layerconcepts.currentText()+""">.
            ?item ?rel ?val .
            ?item <http://www.w3.org/2003/01/geo/wgs84_pos#lat> ?lat .
            ?item <http://www.w3.org/2003/01/geo/wgs84_pos#long> ?lon .
            } LIMIT 10""")
            else:
                self.dlg.inp_sparql.setPlainText("""SELECT ?item ?label ?lat ?lon WHERE {
            ?item a <"""+self.dlg.layerconcepts.currentText()+""">.
            ?item <http://www.w3.org/2003/01/geo/wgs84_pos#lat> ?lat .
            ?item <http://www.w3.org/2003/01/geo/wgs84_pos#long> ?lon .
            } LIMIT 10""")
        elif endpointIndex==5:
            if self.dlg.queryTemplates.currentText()=="All Attributes":
                self.dlg.inp_sparql.setPlainText("""SELECT ?item ?label ?rel ?val ?lat ?lon  WHERE {
            ?item rdf:type <"""+self.dlg.layerconcepts.currentText()+"""> .
            ?item rdfs:label ?label .
            ?item ?rel ?val .
            ?item <http://www.w3.org/2003/01/geo/wgs84_pos#lat> ?lat .
            ?item <http://www.w3.org/2003/01/geo/wgs84_pos#long> ?lon .
            FILTER(langMatches(lang(?label),'EN'))
            } LIMIT 10""")
            else:
                self.dlg.inp_sparql.setPlainText("""SELECT ?item ?label ?lat ?lon  WHERE {
            ?item rdf:type <"""+self.dlg.layerconcepts.currentText()+"""> .
            ?item rdfs:label ?label .
            ?item <http://www.w3.org/2003/01/geo/wgs84_pos#lat> ?lat .
            ?item <http://www.w3.org/2003/01/geo/wgs84_pos#long> ?lon .
            FILTER(langMatches(lang(?label),'EN'))
            } LIMIT 10""")
        elif endpointIndex==6:
            self.dlg.inp_sparql.setPlainText("""SELECT ?item ?label ?lat ?lon  WHERE {
            ?item rdf:type <"""+self.dlg.layerconcepts.currentText()+"""> .
            ?item rdfs:label ?label .
            ?item <http://www.w3.org/2003/01/geo/wgs84_pos#lat> ?lat .
            ?item <http://www.w3.org/2003/01/geo/wgs84_pos#long> ?lon .
            FILTER(langMatches(lang(?label),'EN'))
            } LIMIT 10""")
        elif endpointIndex==7:
            if self.dlg.layerconcepts.currentText()=="Feature":
                self.dlg.inp_sparql.setPlainText("""SELECT ?item ?lat ?lon WHERE {
            ?item a <http://www.geonames.org/ontology#Feature>.
            ?item <http://www.w3.org/2003/01/geo/wgs84_pos#lat> ?lat .
            ?item <http://www.w3.org/2003/01/geo/wgs84_pos#long> ?lon .
            } LIMIT 10""")				
            else:
                self.dlg.inp_sparql.setPlainText("""SELECT ?item ?lat ?lon WHERE {
            ?item a <http://www.geonames.org/ontology#Feature>.
            ?item <http://www.geonames.org/ontology#featureCode> <http://www.geonames.org/ontology#"""+self.dlg.layerconcepts.currentText()[9:]+"""> .
            ?item <http://www.w3.org/2003/01/geo/wgs84_pos#lat> ?lat .
            ?item <http://www.w3.org/2003/01/geo/wgs84_pos#long> ?lon .
            } LIMIT 10""")
        elif endpointIndex==8:
            self.dlg.inp_sparql.setPlainText("""SELECT ?item ?label ?geo WHERE {
            ?item a <"""+self.dlg.layerconcepts.currentText()+""">.
            ?item rdfs:label ?label.
            FILTER (lang(?label) = 'en')
            ?item ogc:hasGeometry [
            ogc:asWKT ?geo
            ] .
            } LIMIT 10""")
        elif endpointIndex==9:
            self.dlg.inp_sparql.setPlainText("""SELECT ?item ?lat ?lon WHERE {
            ?item a <https://d-nb.info/standards/elementset/gnd#"""+self.dlg.layerconcepts.currentText()+""">.
            ?item <http://www.w3.org/2003/01/geo/wgs84_pos#lat> ?lat .
            ?item <http://www.w3.org/2003/01/geo/wgs84_pos#long> ?lon .
            } LIMIT 10""")

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = SPAQLunicornDialog()
            self.sparqlhighlight = SPARQLHighlighter(self.dlg.inp_sparql,self.dlg.errorLabel)
            self.dlg.comboBox.clear()
            self.dlg.comboBox.addItem('File') #0
            self.dlg.comboBox.addItem('Wikidata --> ?geo required!') #1
            self.dlg.comboBox.addItem('Ordnance Survey UK --> ?easting ?northing required!') #2
            self.dlg.comboBox.addItem('nomisma.org --> ?lat ?long required!') #3
            self.dlg.comboBox.addItem('kerameikos.org --> ?lat ?long required!') #4
            self.dlg.comboBox.addItem('Linked Geodata (OSM) --> ?geo required!') #5
            self.dlg.comboBox.addItem('DBPedia --> ?lat ?lon required!') #6
            self.dlg.comboBox.addItem('Geonames --> ?lat ?lon required!') #7
            self.dlg.comboBox.addItem('Ordnance Survey Ireland --> ?geo required!') #8
            #self.dlg.comboBox.addItem('German National Library (GND) --> ?lat ?lon required!') #9
            self.dlg.comboBox.setCurrentIndex(1);
            self.dlg.label_11.hide()
            self.dlg.queryTemplates.hide()
            self.dlg.areas.hide()
            self.dlg.label_9.hide()
            self.dlg.areaconcepts.hide()
            self.dlg.label_8.hide()
            self.dlg.tabWidget.removeTab(2)
            self.dlg.tabWidget.removeTab(1)
            self.dlg.comboBox.currentIndexChanged.connect(self.endpointselectaction)
            self.dlg.queryTemplates.currentIndexChanged.connect(self.viewselectaction)
            self.dlg.loadedLayers.clear()
            self.dlg.inp_sparql.textChanged.connect(self.validateSPARQL)
            self.dlg.bboxButton.clicked.connect(self.getPointFromCanvas)
            self.dlg.interlinkTable.cellClicked.connect(self.createInterlinkSearchDialog)
            #self.dlg.searchClassButton.clicked.connect(self.createInterlinkSearchDialog)
            self.dlg.chooseLayerInterlink.clear()
            self.dlg.layerconcepts.clear()
            #self.dlg.layerconcepts.view().setVerticalScrollBarPolicy(Qt.ScrollBarAsNeeded)
            self.dlg.startEnrichment.clicked.connect(self.enrichLayer)
            self.dlg.layerconcepts.currentIndexChanged.connect(self.viewselectaction)
            self.dlg.layerconcepts.currentIndexChanged.connect(self.loadAreas)
            self.dlg.pushButton.clicked.connect(self.create_unicorn_layer) # load action
            self.dlg.exportLayers.clicked.connect(self.exportLayer)
            self.dlg.exportInterlink.clicked.connect(self.exportEnrichedLayer)
            self.dlg.loadLayerInterlink.clicked.connect(self.loadLayerForInterlink)
            self.dlg.enrichTableResult.hide()
            #self.dlg.loadLayerInterlink.view().setVerticalScrollBarPolicy(Qt.ScrollBarAsNeeded)
            #self.dlg.IDColumnEnrich.view().setVerticalScrollBarPolicy(Qt.ScrollBarAsNeeded)
            self.dlg.loadLayerEnrich.clicked.connect(self.loadLayerForEnrichment)
            #self.dlg.loadLayerEnrich.view().setVerticalScrollBarPolicy(Qt.ScrollBarAsNeeded)
            self.dlg.refreshLayersInterlink.clicked.connect(self.loadUnicornLayers)
            self.dlg.loadFileButton.clicked.connect(self.loadGraph) # load action

        if self.first_start == False:
            self.loadUnicornLayers()

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
