# -*- coding: utf-8 -*-
"""
/***************************************************************************
 SPAQLunicorn
                                 A QGIS plugin
 This plugin adds a GeoJSON layer from a Wikidata SPARQL query.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-10-28
        git sha              : $Format:%H$
        copyright            : (C) 2019 by SPARQL Unicorn
        email                : rse@fthiery.de
        developer(s)         : Florian Thiery,  Timo Homburg
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.utils import iface
from qgis.core import Qgis, QgsMessageLog

from qgis.PyQt.QtCore import QSettings, QCoreApplication, Qt, QItemSelectionModel, QTranslator
from qgis.PyQt.QtGui import QIcon, QStandardItem
from qgis.PyQt.QtWidgets import QAction, QFileDialog, QMessageBox, QProgressDialog
from qgis.core import QgsProject, QgsApplication


from .resources import *
import os.path
import sys
sys.path.insert(0, os.path.abspath(os.path.join(os.path.dirname(__file__), "dependencies")))
from .util.ui.uiutils import UIUtils
from .util.layerutils import LayerUtils

import json

from rdflib import *

# Import the code for the dialog
from .dialogs.uploadrdfdialog import UploadRDFDialog
from .dialogs.loginwindowdialog import LoginWindowDialog
from .dialogs.sparql_unicorn_dialog import SPARQLunicornDialog

geoconcepts = ""

## The main SPARQL unicorn dialog.
#
class SPARQLunicorn:

    enrichedExport = False

    exportNameSpace = None

    exportIdCol = None

    exportSetClass = None
    # Triple store configuration map
    triplestoreconf = None

    enrichLayer = None

    qtask = None

    originalRowCount = 0

    enrichLayerCounter = 0

    addVocabConf = None

    savedQueriesJSON = {}

    exportColConfig = {}

    valueconcept = {}

    columnvars = {}

    prefixes = []

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'SPAQLunicorn_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&SPARQL Unicorn Wikidata Plugin')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('SPAQLunicorn', message)

    def add_action(
            self,
            icon_path,
            text,
            callback,
            enabled_flag=True,
            add_to_menu=True,
            add_to_toolbar=True,
            status_tip=None,
            whats_this=None,
            parent=None):
        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToVectorMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        # a = str('numpy' in sys.modules)
        # iface.messageBar().pushMessage("load libs", a, level=Qgis.Success)

        icon_path = ':/icons/resources/icons/sparqlunicorn.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Adds GeoJSON layer from a Wikidata'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True

    ## Removes the plugin menu item and icon from QGIS GUI.
    #  @param self The object pointer.
    def unload(self):
        for action in self.actions:
            self.iface.removePluginVectorMenu(
                self.tr(u'&SPARQL Unicorn Wikidata Plugin'),
                action)
            self.iface.removeToolBarIcon(action)


    def exportLayer2(self):
        self.exportLayer(None, None, None, None, None, None, self.dlg.exportTripleStore_2.isChecked())

    ## Creates the export layer dialog for exporting layers as TTL.
    #  @param self The object pointer.
    def exportLayer(self, urilist=None, classurilist=None, includelist=None, proptypelist=None, valuemappings=None,
                    valuequeries=None, exportToTripleStore=False):
        layers = QgsProject.instance().layerTreeRoot().children()
        if self.enrichedExport:
            selectedLayerIndex = self.dlg.chooseLayerInterlink.currentIndex()
        else:
            selectedLayerIndex = self.dlg.chooseLayerInterlink.currentIndex()
        layer = layers[selectedLayerIndex].layer()
        if exportToTripleStore:
            ttlstring = LayerUtils.layerToTTLString(layer, "".join(self.prefixes[self.dlg.comboBox.currentIndex()]),
                                                    urilist, classurilist, includelist, proptypelist, valuemappings,
                                                    valuequeries)
            uploaddialog = UploadRDFDialog(ttlstring, self.triplestoreconf, self.dlg.comboBox.currentIndex())
            uploaddialog.setMinimumSize(450, 250)
            uploaddialog.setWindowTitle("Upload interlinked dataset to triple store ")
            uploaddialog.exec_()
        else:
            filename, _filter = QFileDialog.getSaveFileName(
                self.dlg, "Select   output file ", "", "Linked Data (*.ttl *.n3 *.nt *.graphml)", )
            if filename == "":
                return
            if filename.endswith("graphml"):
                ttlstring = LayerUtils.layerToGraphML(layer)
            else:
                ttlstring = LayerUtils.layerToTTLString(layer, "".join(self.prefixes[self.dlg.comboBox.currentIndex()]),
                                                        urilist, classurilist, includelist, proptypelist, valuemappings,
                                                        valuequeries)
            with open(filename, 'w') as output_file:
                output_file.write(ttlstring)
                iface.messageBar().pushMessage("export layer successfully!", "OK", level=Qgis.Success)
            if not filename.endswith("graphml"):
                g = Graph()
                g.parse(data=ttlstring, format="ttl")
                splitted = filename.split(".")
                exportNameSpace = ""
                exportSetClass = ""
                with open(filename, 'w') as output_file:
                    output_file.write(g.serialize(format=splitted[len(splitted) - 1]).decode("utf-8"))
                    iface.messageBar().pushMessage("export layer successfully!", "OK", level=Qgis.Success)

    ## Saves a personal copy of the triplestore configuration file to disk.
    #  @param self The object pointer.
    def saveTripleStoreConfig(self):
        __location__ = os.path.realpath(os.path.join(os.getcwd(), os.path.dirname(__file__)))
        with open(os.path.join(__location__, 'conf/triplestoreconf_personal.json'), 'w') as myfile:
            myfile.write(json.dumps(self.triplestoreconf, indent=2))

    ## Restores the triple store configuration file with the version delivered with the SPARQLUnicorn QGIS plugin.
    #  @param self The object pointer.
    def resetTripleStoreConfig(self):
        __location__ = os.path.realpath(os.path.join(os.getcwd(), os.path.dirname(__file__)))
        with open(os.path.join(__location__, 'conf/triplestoreconf.json'), 'r') as myfile:
            data = myfile.read()
        self.triplestoreconf = json.loads(data)
        with open(os.path.join(__location__, 'conf/triplestoreconf_personal.json'), 'w') as myfile:
            myfile.write(json.dumps(self.triplestoreconf, indent=2))

    def run(self):
        """Run method that performs all the real work"""
        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            __location__ = os.path.realpath(os.path.join(os.getcwd(), os.path.dirname(__file__)))
            if os.path.isfile(os.path.join(__location__, 'conf/triplestoreconf_personal.json')):
                with open(os.path.join(__location__, 'conf/triplestoreconf_personal.json'), 'r') as myfile:
                    data = myfile.read()
            else:
                with open(os.path.join(__location__, 'conf/triplestoreconf.json'), 'r') as myfile:
                    data = myfile.read()
            # parse file
            with open(os.path.join(__location__, 'owl/addvocabconf.json'), 'r') as myfile:
                data2 = myfile.read()
            with open(os.path.join(__location__, 'owl/vocabs.json'), 'r') as myfile:
                data3 = myfile.read()
            with open(os.path.join(__location__, 'owl/prefixes.json'), 'r') as myfile:
                data4 = myfile.read()
            if os.path.isfile(os.path.join(__location__, 'conf/savedqueries.json')):
                with open(os.path.join(__location__, 'conf/savedqueries.json'), 'r') as myfile:
                    data5 = myfile.read()
                self.savedQueriesJSON = json.loads(data5)
            self.triplestoreconf = json.loads(data)
            self.addVocabConf = json.loads(data2)
            self.autocomplete = json.loads(data3)
            self.prefixstore = json.loads(data4)
            counter = 0
            for store in self.triplestoreconf:
                self.prefixes.append("")
                for prefix in store["prefixes"]:
                    self.prefixes[counter] += "PREFIX " + prefix + ":<" + store["prefixes"][prefix] + ">\n"
                counter += 1
            self.addVocabConf = json.loads(data2)
            self.saveTripleStoreConfig()
            self.first_start = False
            self.dlg = SPARQLunicornDialog(self.triplestoreconf, self.prefixes, self.addVocabConf, self.autocomplete,
                                           self.prefixstore, self.savedQueriesJSON, self)
            self.dlg.comboBox.clear()
            for triplestore in self.triplestoreconf:
                if triplestore["active"]:
                    item = triplestore["name"]
                    if "mandatoryvariables" in triplestore and len(triplestore["mandatoryvariables"]) > 0:
                        item += " --> "
                        for mandvar in triplestore["mandatoryvariables"]:
                            item += "?" + mandvar + " "
                    if "type" in triplestore and triplestore["type"] == "geosparqlendpoint":
                        item += " [GeoSPARQL Endpoint]"
                        self.dlg.comboBox.addItem(UIUtils.geoendpointicon,item)
                    elif "type" in triplestore and triplestore["type"] == "sparqlendpoint":
                        item += " [SPARQL Endpoint]"
                        self.dlg.comboBox.addItem(UIUtils.linkeddataicon,item)
                    elif "type" in triplestore and triplestore["type"] == "file":
                        item += " [File]"
                        self.dlg.comboBox.addItem(UIUtils.rdffileicon,item)
                    else:
                        self.dlg.comboBox.addItem(item)
            self.dlg.comboBox.setCurrentIndex(0)
            self.dlg.oauthTestButton.hide()
            self.dlg.oauthTestButton.clicked.connect(lambda: LoginWindowDialog(self).exec())
            self.dlg.tabchanged(self.dlg.tabWidget.currentIndex())
            self.dlg.endpointselectaction()
        else:
            self.dlg.show()
