# -*- coding: utf-8 -*-
"""
/***************************************************************************
 SoilMoisture
                                 A QGIS plugin
 It computes soil moisture at high resolution using the SMAP/SMOS 36km coarse resolution global soil moisture data
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-09-16
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Neha K. Nawandar
        email                : nehanawandar@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from asyncio.log import logger
import math,os
import numpy as np
import pandas as pd
import time,datetime

from osgeo import gdal, osr, ogr
#import matplotlib.pyplot as plt
import csv
#from scipy.io import savemat

from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .soil_moisture_dialog import SoilMoistureDialog
import os.path

# libraries imported on 16/09/2022
from qgis.PyQt import uic
from qgis.PyQt import QtWidgets

from PyQt5 import QtCore,QtGui,QtWidgets
from PyQt5.QtWidgets import *



class SoilMoisture:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'SoilMoisture_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # 16/09/2022
        self.dlg=SoilMoistureDialog()
        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Q-DAI')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('SoilMoisture', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)
        # 16/09/2022
        self.ini_display()


        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/soil_moisture/icon.png'
        global lat_file_path
        lat_file_path=':/plugins/soil_moisture/lat.csv'
        
        self.add_action(
            icon_path,
            text=self.tr(u'SM HR'),
            callback=self.run,
            parent=self.iface.mainWindow())        

        # will be set False in run()
        # self.first_start = True

        # 16/09/2022
        self.dlg.pb_red.clicked.connect(self.pb_red_clicked)
        self.dlg.pb_nir.clicked.connect(self.pb_nir_clicked)
        self.dlg.pb_lst.clicked.connect(self.pb_lst_clicked)
        self.dlg.pb_shape.clicked.connect(self.pb_shape_clicked)
        self.dlg.pb_ot_compute.clicked.connect(self.pb_ot_compute_clicked)
        self.dlg.pb_ot_close.clicked.connect(self.pb_ot_close_clicked)

        self.dlg.pb_sm.clicked.connect(self.pb_sm_clicked)
        self.dlg.pb_sm_extract.clicked.connect(self.pb_sm_extract_clicked)
        self.dlg.pb_sm_compute.clicked.connect(self.pb_sm_compute_clicked)        
        self.dlg.pb_sm_close.clicked.connect(self.pb_sm_close_clicked)

    def pb_ot_close_clicked(self):
        self.dlg.cb_clip_bands.setChecked(False)
        self.dlg.close()

    def pb_sm_close_clicked(self):
        self.dlg.cb_clip_bands.setChecked(False)
        self.dlg.close()

    def pb_red_clicked(self):
        global r_dataset,r_array,r_cols,r_rows,r_geoTransform,r_projection,red,file_dir
        red_band_filename=QFileDialog.getOpenFileName(self.dlg,'Open corrected Red band','', '*tif;*tiff;*TIF;*TIFF')
        red_band_path=red_band_filename[0]    
        r_dataset=gdal.Open(red_band_path)   
        # red_band=r_dataset.GetRasterBand(1)
        # r_rows=r_dataset.RasterXSize
        # r_cols=r_dataset.RasterYSize
        # r_geoTransform=r_dataset.GetGeoTransform()
        # r_projection=r_dataset.GetProjection()
        # r_band= r_dataset.GetRasterBand(1)
        r_array=r_dataset.GetRasterBand(1).ReadAsArray().astype('float64')

        # file_dir=str(QFileDialog.getExistingDirectory(red_band_path))
        # print(file_dir)
        # display the location from where the clipped red and nir bands are stored
        # logger=self.dlg.tb_otinput
        # l1='\nChosen directory for saving the tif files:'+file_dir
        # logger.append(l1)

        # display the location from where red band is taken
        logger=self.dlg.tb_otinput
        l1='\nRed band location:'+(red_band_path)
        logger.append(l1)

    def pb_nir_clicked(self):
        global n_dataset,n_array,n_cols,n_rows,n_geoTransform,n_projection,nir
        nir_band_filename=QFileDialog.getOpenFileName(self.dlg,'Open corrected NIR band','', '*tif;*tiff;*TIF;*TIFF')
        nir_band_path=nir_band_filename[0]
        n_dataset=gdal.Open(nir_band_path)
        # nir_band=n_dataset.GetRasterBand(1)
        # n_cols=n_dataset.RasterXSize
        # n_rows=n_dataset.RasterYSize
        # n_geoTransform=n_dataset.GetGeoTransform()
        # n_projection=n_dataset.GetProjection()     
        # n_band=n_dataset.GetRasterBand(1)
        n_array=n_dataset.GetRasterBand(1).ReadAsArray().astype('float64') 
        # nir=np.nan_to_num(n_array)

        # display the location from where nir band is taken
        logger=self.dlg.tb_otinput
        l1='\nNIR band location:'+(nir_band_path)
        logger.append(l1)

    def pb_lst_clicked(self):
        global l_dataset,l_array,l_cols,l_rows,l_geoTransform,l_projection,lst
        lst_band_filename=QFileDialog.getOpenFileName(self.dlg,'Open corrected LST band','', '*tif;*tiff;*TIF;*TIFF')
        lst_band_path=lst_band_filename[0]
        l_dataset=gdal.Open(lst_band_path)
        # lst_band=l_dataset.GetRasterBand(1)
        # l_cols=l_dataset.RasterXSize
        # l_rows=l_dataset.RasterYSize
        # l_geoTransform=l_dataset.GetGeoTransform()
        # l_projection=l_dataset.GetProjection()     
        # l_band=l_dataset.GetRasterBand(1)
        l_array=l_dataset.GetRasterBand(1).ReadAsArray().astype('float64') 
        # lst=np.nan_to_num(l_array)

        # display the location from where nir band is taken
        logger=self.dlg.tb_otinput
        l1='\nLST band location:'+(lst_band_path)
        logger.append(l1)

    def pb_shape_clicked(self):
        global shape_input,file_dir,r_dataset,n_dataset,l_dataset
        global r_array_clipped,n_array_clipped,l_array_clipped
        shape_filename=QFileDialog.getOpenFileName(self.dlg,'Open shape file','', '*shp')
        shape_input=shape_filename[0]
        logger=self.dlg.tb_otinput
        l1='\nSelected shape file:'+shape_input
        logger.append(l1)


    def pb_ot_compute_clicked(self):
        global file_dir,r_dataset,n_dataset,l_dataset
        global r_array,n_array,l_array
        global r_array_clipped,n_array_clipped,l_array_clipped

        # clip bands if that option is selected
        if self.dlg.cb_clip_bands.isChecked():
            # save the clipped red band image
            file_dir=str(QFileDialog.getExistingDirectory(self.dlg,"Select the output directory to save essential intermediate outputs"))
            # display the location from where the clipped red and nir bands are stored
            logger=self.dlg.tb_otinput
            l1='\nChosen directory for saving the tif files:'+file_dir
            logger.append(l1)

            browse=file_dir+'/'
            print(browse)
            folder_01='IITD_SMC_%s' % (time.strftime("%d%m%Y_") + time.strftime("%H%M%S"))
            if not os.path.exists(os.path.join(browse, folder_01)):
                os.makedirs(os.path.join(browse, folder_01))
                # print("%s is created in directory: %s" % (folder_01, browse))
            else:
                folder_create=False
                while not folder_create:
                    folder_01='IITD_SMC%s' % (time.strftime("%d%m%Y_") + time.strftime("%H%M%S"))
                    if not os.path.exists(os.path.join(browse, folder_01)):
                        os.makedirs(os.path.join(browse, folder_01))
                        # print("%s is created in directory: %s" % (folder_01, browse))
                        folder_create=True

                del folder_create


            file_dir=browse+folder_01+'/'
            # print(file_dir)

            r_raster_input=r_dataset
            r_raster_output=file_dir+'red_clipped_%s' % (time.strftime("%d%m%Y_") + time.strftime("%H%M%S"))+'.tif'
            logger=self.dlg.tb_otinput
            l1='\nThe clipped red file path is:'+r_raster_output
            logger.append(l1)
            gdal.Warp(r_raster_output,r_raster_input,cutlineDSName=shape_input,format='GTiff',cropToCutline=True)
            r_dataset=gdal.Open(r_raster_output)
            # red_band=r_dataset.GetRasterBand(1)
            # r_rows=r_dataset.RasterXSize
            # r_cols=r_dataset.RasterYSize
            # r_geoTransform=r_dataset.GetGeoTransform()
            # r_projection=r_dataset.GetProjection()
            # r_band= r_dataset.GetRasterBand(1)
            r_array_clipped=r_dataset.GetRasterBand(1).ReadAsArray().astype('float64')
            # red=np.nan_to_num(r_array)
            logger=self.dlg.tb_otinput
            logger.append('\nRed band clipped and converted in array form')

            n_raster_input=n_dataset
            n_raster_output=file_dir+'nir_clipped_%s' % (time.strftime("%d%m%Y_") + time.strftime("%H%M%S"))+'.tif'
            logger=self.dlg.tb_otinput
            l1='\nThe clipped nir file path is:'+n_raster_output
            logger.append(l1)
            gdal.Warp(n_raster_output,n_raster_input,cutlineDSName=shape_input,format='GTiff',cropToCutline=True)
            n_dataset=gdal.Open(n_raster_output)
            nir_band=n_dataset.GetRasterBand(1)
            n_cols=n_dataset.RasterXSize
            n_rows=n_dataset.RasterYSize
            n_geoTransform=n_dataset.GetGeoTransform()
            n_projection=n_dataset.GetProjection()     
            n_band=n_dataset.GetRasterBand(1)
            n_array_clipped=n_dataset.ReadAsArray()
            # nir=np.nan_to_num(n_array)
            logger=self.dlg.tb_otinput
            logger.append('\nNIR band clipped and converted in array form')  

            l_raster_input=l_dataset
            l_raster_output=file_dir+'lst_clipped_%s' % (time.strftime("%d%m%Y_") + time.strftime("%H%M%S"))+'.tif'
            logger=self.dlg.tb_otinput
            l1='\nThe clipped nir file path is:'+l_raster_output
            logger.append(l1)
            gdal.Warp(l_raster_output,l_raster_input,cutlineDSName=shape_input,format='GTiff',cropToCutline=True)
            l_dataset=gdal.Open(l_raster_output)
            lst_band=n_dataset.GetRasterBand(1)
            l_cols=n_dataset.RasterXSize
            l_rows=n_dataset.RasterYSize
            l_geoTransform=n_dataset.GetGeoTransform()
            l_projection=n_dataset.GetProjection()     
            l_band=n_dataset.GetRasterBand(1)
            l_array_clipped=n_dataset.ReadAsArray()
            # lst=np.nan_to_num(l_array)
            logger=self.dlg.tb_otinput
            logger.append('\nLST band clipped and converted in array form')  

            logger.append('\nBands clipped as per ROI')

        else:
            print('Clipping not required')
            file_dir=str(QFileDialog.getExistingDirectory(self.dlg,"Select the output directory to save essential intermediate outputs"))
            # display the location from where the clipped red and nir bands are stored
            logger=self.dlg.tb_otinput
            l1='\nChosen directory for saving the tif files:'+file_dir
            logger.append(l1)

            browse=file_dir+'/'
            print(browse)
            folder_01='IITD_SMC_%s' % (time.strftime("%d%m%Y_") + time.strftime("%H%M%S"))
            if not os.path.exists(os.path.join(browse, folder_01)):
                os.makedirs(os.path.join(browse, folder_01))
                # print("%s is created in directory: %s" % (folder_01, browse))
            else:
                folder_create=False
                while not folder_create:
                    folder_01='IITD_SMC%s' % (time.strftime("%d%m%Y_") + time.strftime("%H%M%S"))
                    if not os.path.exists(os.path.join(browse, folder_01)):
                        os.makedirs(os.path.join(browse, folder_01))
                        # print("%s is created in directory: %s" % (folder_01, browse))
                        folder_create=True

                del folder_create


            file_dir=browse+folder_01+'/'
        print('Path:',file_dir)

        # file_dir=str(QFileDialog.getExistingDirectory(self.dlg,"Select the output directory to save essential intermediate outputs"))
        # # display the location from where the clipped red and nir bands are stored
        # logger=self.dlg.tb_otinput
        # l1='\nChosen directory for saving the tif files:'+file_dir
        # logger.append(l1)

        # browse=file_dir
        # print(browse)
        # folder_01='IITD_SMC_%s' % (time.strftime("%d%m%Y_") + time.strftime("%H%M%S"))
        # if not os.path.exists(os.path.join(browse, folder_01)):
        #     os.makedirs(os.path.join(browse, folder_01))
        #     # print("%s is created in directory: %s" % (folder_01, browse))
        # else:
        #     folder_create=False
        #     while not folder_create:
        #         folder_01='IITD_SMC%s' % (time.strftime("%d%m%Y_") + time.strftime("%H%M%S"))
        #         if not os.path.exists(os.path.join(browse, folder_01)):
        #             os.makedirs(os.path.join(browse, folder_01))
        #             # print("%s is created in directory: %s" % (folder_01, browse))
        #             folder_create=True

        #     del folder_create


        # file_dir=file_dir+folder_01+'/'
        # print(file_dir)
        
        time.sleep(5)

        # select proper array based on whether the bands were clipped or not
        if self.dlg.cb_clip_bands.isChecked():
            red=np.nan_to_num(r_array_clipped)
            nir=np.nan_to_num(n_array_clipped)
            lst=np.nan_to_num(l_array_clipped)

        else:    
            red=np.nan_to_num(r_array)
            nir=np.nan_to_num(n_array)
            lst=np.nan_to_num(l_array)
        
        print(np.shape(red),np.shape(nir),np.shape(lst))

        global ndvi,fv,SEE,see_avg
        ndvi_s=0.15
        ndvi_v=0.9
        ndvi=np.where(red+nir==0.,0,(nir-red)/(nir+red))
        fv=(ndvi-ndvi_s)/(ndvi_v-ndvi_s)
        print(ndvi.shape,fv.shape)
        # print(np.amax(ndvi),np.amin(ndvi),np.amax(fv),np.amin(fv))
        # print(np.amax(lst),np.amin(lst),np.amax(red),np.amin(red),np.amax(nir),np.amin(nir))

        # arrange as a 1d array
        x=fv.flatten()
        y=lst.flatten()

        m,=x.shape
        n,=y.shape
        m1=2
        # print(m,n)

        # combine fv and lst in one variable comb and getOffset
        comb=np.zeros((m,m1),dtype='float64')
        for i in range(m):
            comb[i][0]=x[i,]
            comb[i][1]=y[i,]

        
        # tsmax
        lstAxisMax=np.nanmax(comb,axis=0)-0.5
        print('LST axis max:',lstAxisMax)
        lstMaxIndex=np.where(y>lstAxisMax[1])

        lstMax = []
        for i in lstMaxIndex[0]:
            lstMax.append([x[i], y[i]])


        minlstMax = np.nanmin(lstMax, axis=0)

        Tssmax = []
        for i in lstMax:
            if (i[0] == minlstMax[0]):
                Tssmax.append(i)
        Tsmax = np.mean(Tssmax, axis=0)
        Tsmax1=tsmax=Tsmax[1]
        print ('Tsmax')
        print (Tsmax1)

        # tsmin
        lstAxisMin = np.nanmin(comb, axis=0) + 0.1
        print('LST axis min:',lstAxisMin)
        lstMinIndex = np.where(y < lstAxisMin[1])

        lstMin = []
        for i in lstMinIndex[0]:
            lstMin.append([x[i], y[i]])

        minlstMin = np.nanmin(lstMin, axis=0)

        Tssmin = []
        for i in lstMin:
            if (i[0] == minlstMin[0]):
                Tssmin.append(i)
        Tsmin = np.average(Tssmin, axis=0)
        Tsmin1=tsmin= Tsmin[1]
        print ('Tsmin')
        print (Tsmin1)


        # tsmax
        lstAxisMax=np.nanmax(comb,axis=0)-0.5
        print('LST axis max:',lstAxisMax)
        lstMaxIndex=np.where(y>lstAxisMax[1])

        lstMax = []
        for i in lstMaxIndex[0]:
            lstMax.append([x[i], y[i]])


        minlstMax = np.nanmin(lstMax, axis=0)

        Tssmax = []
        for i in lstMax:
            if (i[0] == minlstMax[0]):
                Tssmax.append(i)
        Tsmax = np.mean(Tssmax, axis=0)
        Tsmax1=tsmax=Tsmax[1]
        print ('Tsmax')
        print (Tsmax1)

        # tsmin
        lstAxisMin = np.nanmin(comb, axis=0) + 0.1
        print('LST axis min:',lstAxisMin)
        lstMinIndex = np.where(y < lstAxisMin[1])

        lstMin = []
        for i in lstMinIndex[0]:
            lstMin.append([x[i], y[i]])

        minlstMin = np.nanmin(lstMin, axis=0)

        Tssmin = []
        for i in lstMin:
            if (i[0] == minlstMin[0]):
                Tssmin.append(i)
        Tsmin = np.average(Tssmin, axis=0)
        Tsmin1=tsmin= Tsmin[1]
        print ('Tsmin')
        print (Tsmin1)

        # end members

        # tvmax
        fvcAxisMax = np.nanmax(comb, axis=0) - 0.1
        fvcMaxIndex = np.where(x > fvcAxisMax[0])

        fvcMax = []
        for i in fvcMaxIndex[0]:
            fvcMax.append([x[i], y[i]])

        maxArrfvcMax = np.nanmax(fvcMax, axis=0)
        # print('Tv max axis:',maxArrfvcMax)
        Tvmmax = []
        for i in fvcMax:
            if (i[1] > (maxArrfvcMax[1] - 10)):
                Tvmmax.append(i)

        Tvmax = np.mean(Tvmmax, axis=0)
        print ('Tvmax')
        print (Tvmax)

        # tvmin
        minArrfvcMax = np.nanmin(fvcMax, axis=0)
        # print('Tv min axis:',minArrfvcMax)
        Tvmmin = []
        for i in fvcMax:
            if (i[1] < (minArrfvcMax[1] + 10)):
                Tvmmin.append(i)

        Tvmin = np.mean(Tvmmin, axis=0)
        print ('Tvmin')
        print (Tvmin)

        tvmax=Tvmax[1]
        tvmin=Tvmin[1]
        print('Tv max and min:',tvmax,tvmin)

        # hourglass using fv and lst
        # line connecting Tsmax and Tvmin
        a1=(Tvmin[1]-Tsmax[1])/(Tvmin[0]-Tsmax[0])
        b1=-1
        c1=-a1*Tsmax[0]+Tsmax[1]

        # line conencting Tvmax and Tsmin
        a2=(Tsmin[1]-Tvmax[1])/(Tsmin[0]-Tvmax[0])
        b2=-1
        c2=-a2*Tvmax[0]+Tvmax[1]

        # intersection of the two lines
        x1=(b1*c2-b2*c1)/(a1*b2-a2*b1)
        y1=(c1*a2-c2*a1)/(a1*b2-a2*b1)
        print(a1,b1,c1,a2,b2,c2,x1,y1)
        intersection=[x1,y1]
        print('Intesection of 2 lines in hourglass:',intersection)

        # plt.figure
        # plt.scatter(fv,t)
        # plt.xlabel('Fractional vegetation cover (fv)')
        # plt.ylabel('Land surface temperature (LST)')
        # plt.title('Tvmax, Tvmin, Tsmax and Tsmin using hourglass approach')
        # plt.plot([Tsmax[0],Tvmin[0]],[Tsmax[1],Tvmin[0]],'r')
        # plt.plot([Tvmax[0],Tsmin[0]],[Tvmax[1],Tvmin[1]],'y')
        # plt.show()

        def area_triangle(x1,y1,x2,y2,x3,y3):
            area=abs((0.5)*(x1*(y2-y3)+x2*(y3-y1)+x3*(y1-y2)))
            area=round(area,0)
            return area
        
        area_a=area_triangle(Tsmax[0],Tsmax[1],Tsmin[0],Tsmin[1],intersection[0],intersection[1])
        # print('Area zone A:',area_a)
        area_b=area_triangle(Tsmax[0],Tsmax[1],Tvmax[0],Tvmax[1],intersection[0],intersection[1])
        # print('Area zone B:',area_b)
        area_c=area_triangle(Tsmin[0],Tsmin[1],Tvmin[0],Tvmin[1],intersection[0],intersection[1])
        # print('Area zone C:',area_c)

        points_in_zone_a=[]
        points_in_zone_b=[]
        points_in_zone_c=[]
        points_zoneless=[]
        Tv=np.zeros((comb.shape[0],1))
        print(Tv.shape)

        start=time.time()

        for i in range(comb.shape[0]):
            temp1=comb[i]
            area_temp1_za_1=area_triangle(Tsmax[0],Tsmax[1],Tsmin[0],Tsmin[1],temp1[0],temp1[1])
            area_temp1_za_2=area_triangle(Tsmax[0],Tsmax[1],intersection[0],intersection[1],temp1[0],temp1[1])
            area_temp1_za_3=area_triangle(intersection[0],intersection[1],Tsmin[0],Tsmin[1],temp1[0],temp1[1])
            area_temp1_za=area_temp1_za_1+area_temp1_za_2+area_temp1_za_3

            area_temp1_zb_1=area_triangle(Tsmax[0],Tsmax[1],Tvmax[0],Tvmax[1],temp1[0],temp1[1])
            area_temp1_zb_2=area_triangle(Tsmax[0],Tsmax[1],intersection[0],intersection[1],temp1[0],temp1[1])
            area_temp1_zb_3=area_triangle(intersection[0],intersection[1],Tvmax[0],Tvmax[1],temp1[0],temp1[1])
            area_temp1_zb=area_temp1_zb_1+area_temp1_zb_2+area_temp1_zb_3

            area_temp1_zc_1=area_triangle(Tsmin[0],Tsmin[1],Tvmin[0],Tvmin[1],temp1[0],temp1[1])
            area_temp1_zc_2=area_triangle(Tsmin[0],Tsmin[1],intersection[0],intersection[1],temp1[0],temp1[1])
            area_temp1_zc_3=area_triangle(intersection[0],intersection[1],Tvmin[0],Tvmin[1],temp1[0],temp1[1])
            area_temp1_zc=area_temp1_zc_1+area_temp1_zc_2+area_temp1_zc_3

            if area_a>=area_temp1_za:
                points_in_zone_a.append(temp1)
                Tv[i]=(tvmax+tvmin)/2
            if area_b>=area_temp1_zb:
                points_in_zone_b.append(temp1)
                Tv[i]=(tvmax+y[i])/2
            if area_c>=area_temp1_zc:
                points_in_zone_c.append(temp1)
                Tv[i]=(y[i]+tvmin)/2
            else:
                points_zoneless.append(temp1)
                Tv[i]=(tvmax+y[i])/2
                
        end=time.time()
        print('time taken for assigning zones:',end-start)

        t=lst
        Tv1=np.reshape(Tv,(t.shape[0],t.shape[1]))
        Ts=np.zeros((t.shape[0],t.shape[1]))
        print(Ts.shape)

        Ts=(t-fv*Tv1)/(1-fv)
        # ep.plot_bands(Ts, cmap="RdYlGn", cols=1, title='Ts', vmin=np.nanmin(Ts), vmax=np.nanmax(Ts),figsize=(8,6))

        SEE=np.zeros((t.shape[0],t.shape[1]))
        print(SEE.shape)

        SEE=(Tsmax1-Ts)/(Tsmax1-Tsmin1)
        # ep.plot_bands(SEE, cmap="RdYlGn", cols=1, title='SEE', vmin=np.nanmin(SEE), vmax=np.nanmax(SEE),figsize=(8,6))

        [m1,n1]=red.shape
        print(m1,n1)

        see_avg=np.zeros((m1,n1))
        [m2,n2]=see_avg.shape
        print(m2,n2)

        num_pix_mat1=m1*n1
        num_pix_mat2=m2*n2

        s_lr=36000

        diff_values=num_pix_mat1/s_lr
        f_size_row=int(np.floor(m1/diff_values))
        f_size_col=int(np.floor(n1/diff_values))

        print(diff_values,f_size_row,f_size_col)

        see_avg=SEE

        for i in range(int(np.ceil(diff_values))):
            for j in range(int(np.ceil(diff_values))):
                if i*f_size_row>m1:
                    avg1=np.mean(SEE[f_size_row*(i):m1,f_size_col*(j):n1])
                    see_avg[f_size_row*(i):m1,f_size_col*(j):n1]=avg1
            
                if j*f_size_col>n1:
                    avg1=np.mean(SEE[f_size_row*(i):m1,f_size_col*(j):n1])
                    see_avg[f_size_row*(i):m1,f_size_col*(j):n1]=avg1          
                
                avg1=np.mean(SEE[f_size_row*i:f_size_row*(i+1),f_size_col*j:f_size_col*(j+1)])
                see_avg[f_size_row*i:f_size_row*(i+1),f_size_col*j:f_size_col*(j+1)]=avg1

        # compute again to avoid overwriting due to SEE mean
        SEE=(Tsmax1-Ts)/(Tsmax1-Tsmin1)

        
        # save the computed paramters in form of tif files
        def save_tif(inputRaster, file_path, fileName):
            global x_pixels,y_pixels,geotransform,ref,l_dataset
            x_pixels = l_dataset.RasterXSize
            y_pixels = l_dataset.RasterYSize
            # print(x_pixels,y_pixels,file_path)

            geotransform = l_dataset.GetGeoTransform()
            ref = l_dataset.GetProjectionRef()
            # print(geotransform,ref)

            driver = gdal.GetDriverByName('GTiff')
            dataset = driver.Create(file_path + fileName + '.tif', x_pixels, y_pixels, 1, gdal.GDT_Float32)
            print(driver,dataset,file_path,fileName)

            dataset.SetGeoTransform(geotransform)
            dataset.SetProjection(ref)

            dataset.GetRasterBand(1).WriteArray(inputRaster)

            print (fileName,'saved')
            dataset.FlushCache()

        
        if self.dlg.cb_save_red.isChecked():
            save_tif(inputRaster=red, file_path=file_dir, fileName='red')    
            logger=self.dlg.tb_otinput
            l1='\nRed band saved'
            logger.append(l1)
              
        if self.dlg.cb_save_nir.isChecked():
            save_tif(inputRaster=nir, file_path=file_dir, fileName='nir')
            logger=self.dlg.tb_otinput
            l1='\nNIR band saved'
            logger.append(l1)

        if self.dlg.cb_save_lst.isChecked():
            save_tif(inputRaster=t, file_path=file_dir, fileName='lst')
            logger=self.dlg.tb_otinput
            l1='\nLST saved'
            logger.append(l1)
        
        if self.dlg.cb_save_intermediate.isChecked():
            save_tif(inputRaster=ndvi, file_path=file_dir, fileName='ndvi')
            save_tif(inputRaster=fv, file_path=file_dir, fileName='fv')
            save_tif(inputRaster=Tv1, file_path=file_dir, fileName='Tv')
            save_tif(inputRaster=Ts, file_path=file_dir, fileName='Ts')
            logger=self.dlg.tb_otinput
            l1='\nNDVI, Fv, Ts and Tv saved'
            logger.append(l1)
        
        # compulsory to save
        save_tif(inputRaster=SEE, file_path=file_dir, fileName='see_hr')
        logger=self.dlg.tb_otinput
        l1='\nSEE HR saved'
        logger.append(l1)
        save_tif(inputRaster=see_avg, file_path=file_dir, fileName='see_avg')
        logger=self.dlg.tb_otinput
        l1='\nSEE mean saved'
        logger.append(l1)


    # getting the coarse resolution soil moisture product
    def pb_sm_clicked(self):
        global dataset,datasets_subdata,smap_file
        smap_file1=QFileDialog.getOpenFileName(self.dlg,'Open L3 Soil moisture product from SMAP','', '*.h5')
        smap_file=smap_file1[0]

        logger_sm=self.dlg.tb_sminput
        l1='\nSoil moisture product loaded from: '+str(smap_file)
        logger_sm.append(l1)

        # logger_sm=self.dlg.tb_sminput
        # l1='\nFilename: '+str(smap_file)
        # logger_sm.append(l1)
        
        # read the h5 dataset using gdal 
        dataset=gdal.Open(smap_file)
        datasets_subdata=dataset.GetSubDatasets()

    def pb_sm_extract_clicked(self):
        global file_dir,diff_lat,diff_long
        print('SEE and SEE mean taken from:',file_dir)

        # lat_file=pd.read_csv(lat_file_path)
        # diff_lat=lat_file.iloc[:,1]
        diff_lat=[
            83.63197,
81.48033,
79.76896,
78.30298,
76.99911,
75.81257,
74.71601,
73.69126,
72.725525,
71.80941,
70.935745,
70.09893,
69.294495,
68.51881,
67.76884,
67.04206,
66.33635,
65.64985,
64.98099,
64.32838,
63.690807,
63.0672,
62.456604,
61.858166,
61.27113,
60.6948,
60.128555,
59.571827,
59.024097,
58.484894,
57.95379,
57.43037,
56.91428,
56.40517,
55.90273,
55.40666,
54.916687,
54.43256,
53.954033,
53.48089,
53.012913,
52.549908,
52.091694,
51.63809,
51.18893,
50.74406,
50.303333,
49.86661,
49.433758,
49.00465,
48.579163,
48.15719,
47.738617,
47.32334,
46.911266,
46.502296,
46.09634,
45.693314,
45.293133,
44.89572,
44.501,
44.108894,
43.71934,
43.332268,
42.94761,
42.565308,
42.185303,
41.80753,
41.431942,
41.058483,
40.6871,
40.317745,
39.950367,
39.58492,
39.22136,
38.859642,
38.499725,
38.14157,
37.785137,
37.430386,
37.07728,
36.72578,
36.375854,
36.027473,
35.680595,
35.335194,
34.991234,
34.64869,
34.30753,
33.967724,
33.629246,
33.29207,
32.956165,
32.62151,
32.28808,
31.955841,
31.62478,
31.294872,
30.966091,
30.638416,
30.311827,
29.9863,
29.661814,
29.33835,
29.01589,
28.694414,
28.3739,
28.054333,
27.735691,
27.417961,
27.101122,
26.785158,
26.470053,
26.15579,
25.842354,
25.529726,
25.217896,
24.906843,
24.596556,
24.28702,
23.978218,
23.67014,
23.36277,
23.056093,
22.7501,
22.444773,
22.140102,
21.836075,
21.532677,
21.229897,
20.927721,
20.626143,
20.325144,
20.024717,
19.72485,
19.42553,
19.126749,
18.828493,
18.530754,
18.233519,
17.93678,
17.640526,
17.344746,
17.049429,
16.754568,
16.460152,
16.166172,
15.872617,
15.579478,
15.286747,
14.994413,
14.70247,
14.410906,
14.119713,
13.828882,
13.538405,
13.248274,
12.958479,
12.669013,
12.379867,
12.091032,
11.802501,
11.514265,
11.226317,
10.938648,
10.651252,
10.364119,
10.077242,
9.790613,
9.504226,
9.218072,
8.932143,
8.646433,
8.360933,
8.075637,
7.790537,
7.5056257,
7.2208962,
6.9363413,
6.6519537,
6.367726,
6.0836515,
5.799723,
5.5159335,
5.2322764,
4.9487443,
4.6653304,
4.3820276,
4.0988297,
3.8157291,
3.5327194,
3.2497935,
2.966945,
2.684167,
2.4014523,
2.1187947,
1.8361874,
1.5536234,
1.2710963,
0.9885993,
0.7061257,
0.4236687,
0.14122179,
-0.14122179,
-0.4236687,
-0.7061257,
-0.9885993,
-1.2710963,
-1.5536234,
-1.8361874,
-2.1187947,
-2.4014523,
-2.684167,
-2.966945,
-3.2497935,
-3.5327194,
-3.8157291,
-4.0988297,
-4.3820276,
-4.6653304,
-4.9487443,
-5.2322764,
-5.5159335,
-5.799723,
-6.0836515,
-6.367726,
-6.6519537,
-6.9363413,
-7.2208962,
-7.5056257,
-7.790537,
-8.075637,
-8.360933,
-8.646433,
-8.932143,
-9.218072,
-9.504226,
-9.790613,
-10.077242,
-10.364119,
-10.651252,
-10.938648,
-11.226317,
-11.514265,
-11.802501,
-12.091032,
-12.379867,
-12.669013,
-12.958479,
-13.248274,
-13.538405,
-13.828882,
-14.119713,
-14.410906,
-14.70247,
-14.994413,
-15.286747,
-15.579478,
-15.872617,
-16.166172,
-16.460152,
-16.754568,
-17.049429,
-17.344746,
-17.640526,
-17.93678,
-18.233519,
-18.530754,
-18.828493,
-19.126749,
-19.42553,
-19.72485,
-20.024717,
-20.325144,
-20.626143,
-20.927721,
-21.229897,
-21.532677,
-21.836075,
-22.140102,
-22.444773,
-22.7501,
-23.056093,
-23.36277,
-23.67014,
-23.978218,
-24.28702,
-24.596556,
-24.906843,
-25.217896,
-25.529726,
-25.842354,
-26.15579,
-26.470053,
-26.785158,
-27.101122,
-27.417961,
-27.735691,
-28.054333,
-28.3739,
-28.694414,
-29.01589,
-29.33835,
-29.661814,
-29.9863,
-30.311827,
-30.638416,
-30.966091,
-31.294872,
-31.62478,
-31.955841,
-32.28808,
-32.62151,
-32.956165,
-33.29207,
-33.629246,
-33.967724,
-34.30753,
-34.64869,
-34.991234,
-35.335194,
-35.680595,
-36.027473,
-36.375854,
-36.72578,
-37.07728,
-37.430386,
-37.785137,
-38.14157,
-38.499725,
-38.859642,
-39.22136,
-39.58492,
-39.950367,
-40.317745,
-40.6871,
-41.058483,
-41.431942,
-41.80753,
-42.185303,
-42.565308,
-42.94761,
-43.332268,
-43.71934,
-44.108894,
-44.501,
-44.89572,
-45.293133,
-45.693314,
-46.09634,
-46.502296,
-46.911266,
-47.32334,
-47.738617,
-48.15719,
-48.579163,
-49.00465,
-49.433758,
-49.86661,
-50.303333,
-50.74406,
-51.18893,
-51.63809,
-52.091694,
-52.549908,
-53.012913,
-53.48089,
-53.954033,
-54.43256,
-54.916687,
-55.40666,
-55.90273,
-56.40517,
-56.91428,
-57.43037,
-57.95379,
-58.484894,
-59.024097,
-59.571827,
-60.128555,
-60.6948,
-61.27113,
-61.858166,
-62.456604,
-63.0672,
-63.690807,
-64.32838,
-64.98099,
-65.64985,
-66.33635,
-67.04206,
-67.76884,
-68.51881,
-69.294495,
-70.09893,
-70.935745,
-71.80941,
-72.725525,
-73.69126,
-74.71601,
-75.81257,
-76.99911,
-78.30298,
-79.76896,
-81.48033,
-83.63197]

        # get the latitude, longitude and soil moisture data of both am and pm
        sm_am=datasets_subdata[26][0]
        lat_am=datasets_subdata[13][0]
        long_am=datasets_subdata[15][0]
        print(sm_am,'\n',lat_am,'\n',long_am)

        sm_pm=datasets_subdata[80][0]
        lat_pm=datasets_subdata[66][0]
        long_pm=datasets_subdata[68][0]
        print(sm_pm,'\n',lat_pm,'\n',long_pm)

        sm_am_data=gdal.Open(sm_am).ReadAsArray()
        lat_am_data=gdal.Open(lat_am).ReadAsArray()
        long_am_data=gdal.Open(long_am).ReadAsArray()

        sm_pm_data=gdal.Open(sm_pm).ReadAsArray()
        lat_pm_data=gdal.Open(lat_pm).ReadAsArray()
        long_pm_data=gdal.Open(long_pm).ReadAsArray()


        # save the data as csv files
        csv_filename_sm=smap_file+'_sm.csv'
        pd.DataFrame(sm_am_data).to_csv(csv_filename_sm)

        csv_filename_lat=smap_file+'_lat.csv'
        pd.DataFrame(lat_am_data).to_csv(csv_filename_lat)

        csv_filename_long=smap_file+'_long.csv'
        pd.DataFrame(long_am_data).to_csv(csv_filename_long)

        csv_filename_sm_pm=smap_file+'_sm_pm.csv'
        pd.DataFrame(sm_pm_data).to_csv(csv_filename_sm_pm)

        csv_filename_lat_pm=smap_file+'_lat_pm.csv'
        pd.DataFrame(lat_pm_data).to_csv(csv_filename_lat_pm)

        csv_filename_long_pm=smap_file+'_long_pm.csv'
        pd.DataFrame(long_pm_data).to_csv(csv_filename_long_pm)

        lat_file=pd.read_csv(csv_filename_lat)
        long_file=pd.read_csv(csv_filename_long)
        sm_file=pd.read_csv(csv_filename_sm)

        lat_pm_file=pd.read_csv(csv_filename_lat_pm)
        long_pm_file=pd.read_csv(csv_filename_long_pm)
        sm_pm_file=pd.read_csv(csv_filename_sm_pm)
        
        # diff_lat=[]
        # diff_lat1=lat_file.iloc[0:37,1]
        # # print(diff_lat)
        # diff_lat2=lat_file.iloc[37:135,553]
        # # print(diff_lat2)
        # diff_lat3=lat_file.iloc[135:298,1]
        # # print(diff_lat3)
        # diff_lat4=lat_file.iloc[298:372,567]
        # # print(diff_lat4)
        # diff_lat5=lat_file.iloc[372:,1]
        # # print(diff_lat5)

        # diff_lat=np.append(diff_lat,diff_lat1)
        # diff_lat=np.append(diff_lat,diff_lat2)
        # diff_lat=np.append(diff_lat,diff_lat3)
        # diff_lat=np.append(diff_lat,diff_lat4)
        # diff_lat=np.append(diff_lat,diff_lat5)
        # logger_sm=self.dlg.tb_sminput
        # l1='\nGlobal Latitude list saved'
        # logger_sm.append(l1)

        diff_long=long_file.iloc[0,:]
        # logger_sm=self.dlg.tb_sminput
        # l1='Global Longitude list saved'
        # logger_sm.append(l1)

        logger_sm=self.dlg.tb_sminput
        l1='Global soil moisture saved'
        logger_sm.append(l1)

        lat_min=self.dlg.le_lat_min.text()
        lat_max=self.dlg.le_lat_max.text()
        print(lat_min,lat_max)

        long_min=self.dlg.le_long_min.text()
        long_max=self.dlg.le_long_max.text()
        print(long_min,long_max)

        lat_min=float(lat_min)
        lat_max=float(lat_max)
        long_min=float(long_min)
        long_max=float(long_max)
        print(lat_min,lat_max,long_min,long_max)

        diff_lat=np.asarray(diff_lat)
        lat=np.where((diff_lat>=lat_min)&(diff_lat<=lat_max))
        lat=np.unique(lat[0])
        print(lat)

        long=np.where((diff_long>=long_min)&(diff_long<=long_max))
        long=np.unique(long[0])
        print(long)

        global rows,cols,sm_mat,sm_mat_am,sm_mat_pm
        rows=len(lat)
        cols=len(long)
        sm_mat_am=np.zeros((rows,cols))
        sm_mat_pm=np.zeros((rows,cols))
        # print(sm_mat)


        for i in range(rows):
            for j in range(cols):
                sm_mat_am[i,j]=sm_file.loc[lat[i]][long[j]]
                sm_mat_pm[i,j]=sm_pm_file.loc[lat[i]][long[j]]
                # logger_sm.append(str(sm_mat[i,j]))
                        
        # replacing -9999 with 0; it means no value exists
        for i in range(rows):
            for j in range(cols):
                if sm_mat_am[i][j]==-9999:
                    sm_mat_am[i]=0

        for i in range(rows):
            for j in range(cols):
                if sm_mat_pm[i][j]==-9999:
                    sm_mat_pm[i]=0
        
        logger_sm=self.dlg.tb_sminput
        l1='\nSoil moisture extracted for given extent (AM): '+str(sm_mat_am)
        logger_sm.append(l1)

        logger_sm=self.dlg.tb_sminput
        l1='\nSoil moisture extracted for given extent (PM): '+str(sm_mat_pm)
        logger_sm.append(l1)

        print(sm_mat_am)
        print(sm_mat_pm)
        
        sm_mat_am_zero=np.all((sm_mat_am==0))
        print(sm_mat_am_zero)
        sm_mat_pm_zero=np.all((sm_mat_pm==0))
        print(sm_mat_pm_zero)

        if sm_mat_am_zero:
            sm_mat=sm_mat_pm
        else:
            sm_mat=sm_mat_am
        print(sm_mat)

        logger_sm=self.dlg.tb_sminput
        l1='\nValid Soil moisture: '+str(sm_mat)
        logger_sm.append(l1)

        
    def pb_sm_compute_clicked(self):
        
        # data_path=str(QFileDialog.getExistingDirectory(self.dlg,"Select the output directory where the intermediate outputs (SEE) were saved"))
        # print(data_path)

        # data_path=file_dir
        # print(data_path)

        # SEE1=gdal.Open(data_path+'/see_hr.tif')
        # see_avg1=gdal.Open(data_path+'/see_avg.tif')
        # SEE=SEE1.GetRasterBand(1).ReadAsArray()
        # see_avg=see_avg1.GetRasterBand(1).ReadAsArray()
        # see_avg=np.nan_to_num(see_avg)
               
        block_size_row=int(SEE.shape[0]/rows)
        block_size_col=int(SEE.shape[1]/cols)
        print(block_size_row,block_size_col)
        sm_rescale=np.zeros((SEE.shape[0],SEE.shape[1]))

        for i in range(rows):
            for j in range(cols):
                sm_rescale[i*block_size_row:(i+1)*block_size_row,j*block_size_col:(j+1)*block_size_col]=sm_mat[i][j]
        print(sm_rescale)

        SMp=np.zeros((SEE.shape[0],SEE.shape[1]))
        D_SMp_SEE=np.zeros((SEE.shape[0],SEE.shape[1]))

        D_SMp_SEE_nr=np.zeros((SEE.shape[0],SEE.shape[1]))
        D_SMp_SEE_dr=np.zeros((SEE.shape[0],SEE.shape[1]))

        for i in range(SEE.shape[0]):
            for j in range(SEE.shape[1]):
                SMp[i,j]=(np.pi*sm_rescale[i,j])/(np.arccos(1-2*see_avg[i,j]))

        for i in range(SEE.shape[0]):
            for j in range(SEE.shape[1]):
                # D_SMp_SEE[i,j]=(SMp[i,j]/np.pi)/(np.sqrt(SEE[i,j]-SEE[i,j]*SEE[i,j]))
                D_SMp_SEE_nr[i,j]=(SMp[i,j]/np.pi)
                D_SMp_SEE_dr[i,j]=(np.sqrt(SEE[i,j]*(1-SEE[i,j])))
                # D_SMp_SEE_dr[i,j]=SEE[i,j]*(1-SEE[i,j])
        
        for i in range(SEE.shape[0]):
            for j in range(SEE.shape[1]):
                D_SMp_SEE[i,j]=D_SMp_SEE_nr[i,j]/D_SMp_SEE_dr[i,j]
        
        print('SEE:',np.nanmin(SEE),np.nanmax(SEE))
        print('SEE mean:',np.nanmin(see_avg),np.nanmax(see_avg))
        print('SMp:',np.nanmin(SMp),np.nanmax(SMp))
        
        print('D_SMp_SEE_nr:',np.nanmin(D_SMp_SEE_nr),np.nanmax(D_SMp_SEE_nr))
        print('D_SMp_SEE_dr:',np.nanmin(D_SMp_SEE_dr),np.nanmax(D_SMp_SEE_dr))
        print('D_SMp_SEE:',np.nanmin(D_SMp_SEE),np.nanmax(D_SMp_SEE))
        
        # SM_hr1=np.zeros((lst.shape[0],lst.shape[1]))
        SM_hr2=np.zeros((SEE.shape[0],SEE.shape[1]))

        def save_tif(inputRaster, file_path, fileName):
            x_pixels = r_dataset.RasterXSize
            y_pixels = r_dataset.RasterYSize

            # print(x_pixels,y_pixels)

            geotransform = r_dataset.GetGeoTransform()
            ref = r_dataset.GetProjectionRef()

            # print(geotransform,ref)

            driver = gdal.GetDriverByName('GTiff')
            dataset = driver.Create(file_path + fileName + '.tif', x_pixels, y_pixels, 1, gdal.GDT_Float32)

            dataset.SetGeoTransform(geotransform)
            dataset.SetProjection(ref)

            dataset.GetRasterBand(1).WriteArray(inputRaster)

            print (fileName,'saved')
            dataset.FlushCache()

        for i in range(SEE.shape[0]):
            for j in range(SEE.shape[1]):
        #         SM_hr1[i,j]=sm_rescale[i,j]+(sm_rescale[i,j]/see_avg[i,j]*(SEE[i,j]-see_avg[i,j]))
                SM_hr2[i,j]=sm_rescale[i,j]+D_SMp_SEE[i,j]*(SEE[i,j]-see_avg[i,j])
            
        
        for i in range(SEE.shape[0]-1):
            for j in range(SEE.shape[1]-1):
                if(SM_hr2[i,j]<0):
                    if(i<SEE.shape[0] & j<SEE.shape[1]):
                        SM_hr2[i,j]=np.where(1<SM_hr2[i+1,j+1]>0.,SM_hr2[i+1,j+1],0.1)
                    else:
                        SM_hr2[i,j]=np.where(1<SM_hr2[i-1,j-1]>0.,SM_hr2[i-1,j-1],0.1)
                if(SM_hr2[i,j]>1):
                    if(i<SEE.shape[0]):
                        SM_hr2[i,j]=np.where(0>SM_hr2[i+1,j+1]<1.,SM_hr2[i+1,j+1],1)
                    else:
                        SM_hr2[i,j]=np.where(0>SM_hr2[i-1,j-1]<1.,SM_hr2[i-1,j-1],1)

        logger_sm=self.dlg.tb_sminput
        # l1='\nSoil moisture estimated at high resolution: '+str(SM_hr2)
        l1='\nSoil moisture estimated at high resolution. SM saved.'
        logger_sm.append(l1)

        # print(SM_hr2)
        
        print(np.nanmin(SM_hr2),np.nanmax(SM_hr2))
            
        
        # file_dir1=str(QFileDialog.getExistingDirectory(self.dlg,"Select the output directory to save the soil moisture output"))
        file_dir1=file_dir
        # save_tif(inputRaster=SM_hr1, file_path=file_dir, fileName=sm_filename+'_sm1')
        # f1=sm_filename+'_sm1.tif'
        save_tif(inputRaster=SM_hr2, file_path=file_dir1+'/', fileName='sm_hr')
        save_tif(inputRaster=sm_rescale, file_path=file_dir1+'/', fileName='sm_lr')
        save_tif(inputRaster=D_SMp_SEE_nr, file_path=file_dir1+'/', fileName='D_SMp_SEE_nr')
        save_tif(inputRaster=D_SMp_SEE_dr, file_path=file_dir1+'/', fileName='D_SMp_SEE_dr')
        save_tif(inputRaster=D_SMp_SEE, file_path=file_dir1+'/', fileName='D_SMp_SEE')
        save_tif(inputRaster=SMp, file_path=file_dir1+'/', fileName='SMp')
        # f2=smap_file+'_sm2.tif'


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Q-DAI'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = SoilMoistureDialog()

        # show the dialog
        self.dlg.show()

        # 16/09/2022
        self.dlg.setFixedSize(self.dlg.size())

        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass

    def ini_display(self):
            # For terminal outputs
            # tb_display is name of the text display browser
            logger = self.dlg.tb_otinput
            logger.append(
                'Soil moisture computation Plugin (Based on the DisPATCh algorithm)\n'
                '\nThis plugin takes the coarse resolution soil moisture content and downscales it to high spatial resolution.' 
                '\nFollow the below given steps to use the plugin:'
                '\n1. Select the corrected Optical (Red and NIR) and Thermal (LST) bands.'
                '\n2. If bands need to be clipped, first check the Clip bands checkbox and then select the proper shape file.'
                '\n3. Select the checkboxes to save the bands, intermediate parameters'
                '\n4. Choose the output directory where all the clipped bands/ parameters will be saved'
                '\n5. Click on Compute all parameters button to compute the intermediate parameters. These will be used along with soil moisture product to achieve the final output'
                '\n**************************************'
                '\nOutputs based on the selections made by the user:'
            )

            logger_sm=self.dlg.tb_sminput
            logger_sm.append(
                'Soil moisture computation Plugin\n'
                '\n1. Load soil moisture product here'
                '\n2. Provide the latitude and longitude extent for required region (example shown below for Delhi region)'
                '\nExample:'
                '\nLatitude extent: 28.316 28.92'
                '\nLongitude extent: 76.7 77.49'
                '\n3. Click on Extract for given location (LR) button to get the soil moisture for ROI'
                '\n**************************************'
                '\nOutputs based on the selections made by the user:'
            )
              