# -*- coding: utf-8 -*-
"""
/***************************************************************************
 SmoothGeometry
                                 A QGIS plugin
 This plugin smooth a selected geometry
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-12-31
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Valerio Pinna
        email                : pinnavalerio@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os.path
import sys
import subprocess
from qgis.PyQt.QtCore import *
from qgis.PyQt.QtGui import *
from PyQt5.QtGui import *
from qgis.PyQt.QtWidgets import *
from qgis.PyQt import uic
from PyQt5.QtWidgets import QMessageBox
from qgis.core import (Qgis,
                       QgsApplication,
                       QgsMapLayer,
                       QgsMessageLog,
                       QgsWkbTypes,
                       QgsProject,
                       QgsVectorLayerTools,
                       QgsVectorFileWriter,
                       QgsGeometry,
                       QgsPoint,
                       QgsPointXY,
                       QgsFeatureRequest,
                       QgsVectorLayer,
                       QgsDistanceArea,
                       QgsUnitTypes,
                       QgsEditFormConfig)
                       
from qgis.utils import iface

# Initialize Qt resources from file resources.py
from .resources import *

Ui_ConfigureSmoothGeometryDialogBase = uic.loadUiType(os.path.join(os.path.dirname(__file__), 'configuresmoothingbase.ui'))[0]


def iterations():
    settings = QSettings()
    return settings.value('iterations', type=int)

def setIterations(itera):
    settings = QSettings()
    return settings.setValue('iterations', itera)
    
def offset():
    settings = QSettings()
    return settings.value('offset', type=float)

def setOffset(offset_new_value):
    settings = QSettings()
    return settings.setValue('offset', offset_new_value)

def minDistance():
    settings = QSettings()    
    return settings.value('minDistance', type=float)

def setMinDistance(mindistance_new_value):
    settings = QSettings()
    return settings.setValue('minDistance', mindistance_new_value)

def maxAngle():
    settings = QSettings()   
    return settings.value('maxAngle', type=int)

def setMaxAngle(maxangle_new_value):
    settings = QSettings()
    return settings.setValue('maxAngle',maxangle_new_value)


class ConfigureSmoothGeometryDialog (QDialog, Ui_ConfigureSmoothGeometryDialogBase):
    def __init__(self, parent):
        super().__init__()
        self.iface = parent
        self.setupUi(self)
        
        #update the dialog with the last entered value
        
        self.boxIterations.setValue(iterations())
        itera = iterations()
        
        self.boxOffset.setValue(offset())
        offset_new_value =  offset()
        
        self.boxMinDistance.setValue(minDistance())
        mindistance_new_value =minDistance()
        
        
        self.boxMaxAngle.setValue(maxAngle())
        maxangle_new_value = maxAngle()
        
        
        
class SmoothGeometry:
    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        self.toolButton = QToolButton()
        self.toolButton.setMenu(QMenu())
        self.toolButton.setPopupMode(QToolButton.MenuButtonPopup)
        self.toolBtnAction = self.iface.addToolBarWidget(self.toolButton)
        
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        
        
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'SmoothGeometry_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Smooth Geometry Tool')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('SmoothGeometry', message)


#new InitGui copied from Reloader Plugin

    def initGui(self):    
        self.actionRun = QAction(
          QIcon(os.path.join(os.path.dirname(__file__), "icon.png")),
          self.tr('Smooth the selected geometries'),
          self.iface.mainWindow()
        )
        
        self.iface.addPluginToMenu(self.tr(u'&Smooth Geometry Tool'), self.actionRun)
        m = self.toolButton.menu()
        m.addAction(self.actionRun)
        self.toolButton.setDefaultAction(self.actionRun)
        self.actionRun.triggered.connect(self.run)
        self.actionConfigure = QAction(
          QIcon(os.path.join(os.path.dirname(__file__), "smooth_geometry_config_icon.png")),
          self.tr('Configure'),
          self.iface.mainWindow()
        )
        self.iface.registerMainWindowAction(self.actionConfigure, "")
        self.actionConfigure.setToolTip(self.tr('Configure the smoothing settings'))
        m.addAction(self.actionConfigure)
        self.iface.addPluginToMenu(self.tr(u'&Smooth Geometry Tool'), self.actionConfigure)
        self.actionConfigure.triggered.connect(self.configure)
  
 
    def unload(self):
       for action in [self.actionRun,self.actionConfigure]:
           self.iface.removePluginMenu(self.tr(u'&Smooth Geometry Tool'),action)
           self.iface.removeToolBarIcon(action)
           self.iface.unregisterMainWindowAction(action)

       self.iface.removeToolBarIcon(self.toolBtnAction)


    
       
      

    def run(self):
        
        settings = QSettings
        itera = iterations()      
        offset_new_value= offset()
        mindistance_new_value= minDistance()
        maxangle_new_value=maxAngle()
        
        
        """Run method that performs all the real work"""
        layers_list = QgsProject.instance().mapLayers()
        
        if len(layers_list)!= 0:                            
            
            layer = iface.activeLayer()
            if layer is not None:
                if layer.type() != QgsVectorLayer.VectorLayer:
                    return self.dontdonothing()
 
                if layer.type() == QgsVectorLayer.VectorLayer:

                    layer = iface.activeLayer()
                    layer.startEditing()
                    layer.beginEditCommand("Smooth Geometry")                     
            
                    for f in layer.selectedFeatures():
                        feat_to_change=[]
                        g = f.geometry()
                        
                        
                        sm = g.smooth(
                        #iterations
                        itera,
                        #offset
                        offset_new_value,
                        #MinDistance
                        mindistance_new_value,
                        #maxAngle
                        maxangle_new_value)                  
                        
                        feat_to_change.append(f.id())
                        feat_to_change.append(sm)
             
                        layer.changeGeometry(feat_to_change[0],feat_to_change[1])
                   
                    
                layer.triggerRepaint()
                iface.mapCanvas().refresh()
                layer.endEditCommand()
        
    def configure(self):
        dlg = ConfigureSmoothGeometryDialog(self.iface)
        dlg.exec_()
        if dlg.result():
            itera = dlg.boxIterations.value()
            setIterations(itera)
            
            offset_new_value = dlg.boxOffset.value()
            setOffset(offset_new_value)
            
            
            mindistance_new_value = dlg.boxMinDistance.value()
            setMinDistance(mindistance_new_value)
            
            maxangle_new_value = dlg.boxMaxAngle.value()
            setMaxAngle(maxangle_new_value)
            
    



    def dontdonothing(self):
            pass
