# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Smarty
                                 A QGIS plugin
 Smarty attempt
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-01-19
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Smarty
        email                : caroline@smarty.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from calendar import c # FIXME: I don't think we are using these?
from itertools import count
from operator import add, truediv
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt
from qgis.PyQt.QtGui import QIcon, QColor, QStandardItemModel, QStandardItem
# from qgis.PyQt.QtNetwork import QtNetworkRequest
from qgis.PyQt.QtWidgets import QAction, QCompleter, QApplication
# from qgis.core import QgsProject, Qgis
from qgis.core import (QgsCoordinateReferenceSystem, QgsCoordinateTransform, QgsProject,
                       QgsPointXY, QgsGeometry, QgsVectorLayer, QgsFeature, QgsMarkerSymbol, Qgis, QgsMapLayer,
                       QgsPalLayerSettings, QgsTextFormat, QgsTextBackgroundSettings, QgsVectorLayerSimpleLabeling)

#########
import pip
# import smartystreets_python_sdk
from .smartystreets_python_sdk import StaticCredentials, exceptions, ClientBuilder, SharedCredentials, StaticCredentials, Batch, Request
from .smartystreets_python_sdk.us_street import Lookup as StreetLookup
from .smartystreets_python_sdk.us_autocomplete_pro import Lookup as AutocompleteProLookup, geolocation_type
#########

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .smarty_dialog import SmartyDialog
from .utils import Utils
import os.path
import sys
import os
import pandas as pd
import webbrowser
import csv

class Smarty:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):

        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """

        self.completer = QCompleter(caseSensitivity=QtCore.Qt.CaseInsensitive) # we added this
        self.completer.setCompletionMode(QCompleter.UnfilteredPopupCompletion)
        self.completer.setMaxVisibleItems(100)

        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Smarty_{}.qm'.format(locale))
        
        self.settings = QSettings()
        self.counter2 = 0
        self.layers = None
        self.value = 0
        self.length = 0

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Smarty')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Smarty', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/smarty/smarty-icon-gradient.png'
        self.add_action(
            icon_path,
            text=self.tr(u''),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Smarty'),
                action)
            self.iface.removeToolBarIcon(action)
    
    def smarty_single(self):
        # Check to make sure that the user has added an ID if the layer requires an ID
        if self.dlg.id_check_box.isChecked() and len(self.dlg.single_address_id.text()) == 0:
            self.iface.messageBar().pushMessage("ERROR ", "User indicated desire to add an ID, but no ID was given - Please add an ID." , level=Qgis.Critical, duration=6)
            return
        # Check to make sure that either a new layer or existing layer has been chosen 
        if self.dlg.new_layer_radio.isChecked() == False and self.dlg.existing_layer_radio.isChecked() == False:
            self.iface.messageBar().pushMessage("ERROR ", "Please choose an existing layer or create a new one." , level=Qgis.Critical, duration=6)
            return

        # Check to make sure user adds an ID to layer if the existing layer has an ID associated with the addresses
        if self.dlg.existing_layer_radio.isChecked() and self.dlg.single_address_id.text() == '' and self.dlg.single_frame_id.isEnabled():

            self.iface.messageBar().pushMessage("ERROR ", "You must add an ID for this address if you want to add it to the current existing layer." , level=Qgis.Critical, duration=6)
            return

        # Reset everytime so metadata is not shown initially 
        self.dlg.meta_data.setChecked(False)
        self.meta_resize()

        # Set up the API keys for the US Street Address API
        key = '119911182158064178' 
        hostname = 'qgis_smarty' 

        # Set up credentials for API 
        credentials = SharedCredentials(key, hostname)
        request = Request()
        credentials.sign(request)
        client = ClientBuilder(credentials).with_licenses(["us-rooftop-geo"]).build_us_street_api_client()
        lookup = StreetLookup()
        lookup.match = "enhanced" 
        
        # Check to see if user is using single line entry or multiple line entry
        if self.dlg.tabWidget_2.currentIndex() == 1:
            # Make sure user has inputted information before moving on
            if not len(self.dlg.street.text()) > 0:
                self.iface.messageBar().pushMessage("ERROR ", "Please add an address" , level=Qgis.Critical, duration=6)
                return
            i_address = self.dlg.street.text()
            i_city = self.dlg.city.text() 
            i_state = self.dlg.state.text() 
            i_zip = self.dlg.zipcode.text()
            # If user has inputted information then set lookup information
            lookup.street = i_address
            lookup.city = i_city 
            lookup.state = i_state
            lookup.zipcode = i_zip
            lookup.candidates = 3
        else:
            # Make sure user has inputted information before moving on with API call
            if not len(self.dlg.single_address_lookup.text()) > 0:
                self.iface.messageBar().pushMessage("ERROR ", "Please add an address" , level=Qgis.Critical, duration=6)
                return
            i_address = self.dlg.single_address_lookup.text()
            i_city = ''
            i_state = ''
            i_zip = ''
            lookup.street = i_address
        
        # Send the lookup
        try:
            client.send_lookup(lookup)
        except exceptions.SmartyException as err:
            self.iface.messageBar().pushMessage("FAIL ", str(exceptions.SmartyException), level=Qgis.Critical, duration=6)
            return

        result = lookup.result
        # Handle the success of the API call
        success = Utils.handle_success(result)
        if success == "No Match. The address is invalid.":
            self.dlg.resize(586, 532)
            self.dlg.results.setVisible(True)
            self.dlg.summary_result.setText(success)
            self.iface.messageBar().pushMessage("NO MATCH ", "See Summary section of results for more information.", level=Qgis.Critical, duration=6)
            return

        if len(result) == 0:
            self.iface.messageBar().pushMessage("No match found ", "try entering the address in the 'Address Components'", level=Qgis.Critical, duration=6)
            return
        candidate = result[0] 

        project = QgsProject.instance()

        # Create a new layer or use an existing layer chosen by the user
        if self.dlg.new_layer_radio.isChecked():
            layer_name = self.dlg.layer_name_single.text()
            
            if layer_name == "":
                layer_name = "Smarty"
            
            if self.dlg.id_check_box.isChecked():
                layer_out = QgsVectorLayer("Point?crs=EPSG:4326&field=id:string&field=address:string&field=longitude:string&field=latitude:string&field=city:string&field=state:string&field=zip_code:string&field=zip_4:string&field=precision:string&field=county:string&field=county_fips:string&field=rdi:string&field=cong_dist:string&field=time_zone:string&field=dst:string&field=label:string&field=summary:string&field=i_address:string&field=i_city:string&field=i_state:string&field=i_zip:string",
                layer_name,
                "memory") 
            else:
                layer_out = QgsVectorLayer("Point?crs=EPSG:4326&field=address:string&field=longitude:string&field=latitude:string&field=city:string&field=state:string&field=zip_code:string&field=zip_4:string&field=precision:string&field=county:string&field=county_fips:string&field=rdi:string&field=cong_dist:string&field=time_zone:string&field=dst:string&field=label:string&field=summary:string&field=i_address:string&field=i_city:string&field=i_state:string&field=i_zip:string",
                layer_name,
                "memory") 

        elif self.dlg.existing_layer_radio.isChecked():
            index = self.dlg.layer_box.currentIndex()
            layers = self.refresh_layers()
            if len(layers) == 0:
                self.iface.messageBar().pushMessage("No matching layer ", "Please choose a valid layer", level=Qgis.Critical, duration=6)
                return
            layer_out = layers[index] 
        
        # Receive all the API information
        address = self.set_address(candidate)
        longitude = candidate.metadata.longitude
        latitude = candidate.metadata.latitude
        city = candidate.components.city_name
        state = candidate.components.state_abbreviation
        zip_code = candidate.components.zipcode
        zip_4 = candidate.components.plus4_code
        precision = candidate.metadata.precision
        county = candidate.metadata.county_name
        county_fips = candidate.metadata.county_fips
        rdi = candidate.metadata.rdi
        cong_dist = candidate.metadata.congressional_district
        time_zone = candidate.metadata.time_zone
        dst = candidate.metadata.obeys_dst 

        self.dlg.resize(700,900)
        self.dlg.results.setVisible(True)
        
        # Set received API values on the dialogue box
        self.dlg.address_result.setText(address) 
        self.dlg.city_result.setText(city)
        self.dlg.state_result.setText(state)
        self.dlg.zip_result.setText(zip_code)
        self.dlg.zip_4_result.setText(zip_4)
        self.dlg.latitude_result.setText(str(latitude))
        self.dlg.longitude_result.setText(str(longitude))
        self.dlg.precision_result.setText(precision)

        self.dlg.county_name_result.setText(county)
        self.dlg.county_fips_result.setText(county_fips)
        self.dlg.rdi_result.setText(rdi)
        self.dlg.congressional_district_result.setText(cong_dist)
        self.dlg.time_zone_result.setText(time_zone)
        self.dlg.dst_result.setText(str(dst))
        self.dlg.summary_result.setText(success)

        # Create Lat/Long point to output
        point_out = QgsPointXY(longitude, latitude)
        feature = QgsFeature()
        feature.setGeometry(QgsGeometry.fromPointXY(point_out)) 

        # Set point label
        if len(self.dlg.point_label.text()) == 0:
            label = ''
        else:
            label = self.dlg.point_label.text() 

        # Create attributes associated with created layer
        id = self.dlg.single_address_id.text()
        if self.dlg.new_layer_radio.isChecked() and self.dlg.id_check_box.isChecked():
            feature.setAttributes([id, address, longitude, latitude, city, state, zip_code, zip_4, precision, county,
            county_fips, rdi, cong_dist, time_zone, dst, label, success, i_address, i_city, i_state, i_zip]) 
        elif self.dlg.existing_layer_radio.isChecked() and len(self.dlg.single_address_id.text()) > 0: 
            feature.setAttributes([id, address, longitude, latitude, city, state, zip_code, zip_4, precision, county,
            county_fips, rdi, cong_dist, time_zone, dst, label, success, i_address, i_city, i_state, i_zip]) 
        else:
            feature.setAttributes([address, longitude, latitude, city, state, zip_code, zip_4, precision, county,
            county_fips, rdi, cong_dist, time_zone, dst, label, success, i_address, i_city, i_state, i_zip])   

        # Set symbol
        symbol = self.set_symbol(self.dlg.symbol_color_single.color(), self.dlg.symbol_drop_down_single.currentText(), self.dlg.symbol_size_single.value())
        
        layer_out.dataProvider().addFeature(feature)
        layer_out.renderer().setSymbol(symbol)

        if label != '':
            layer_out = self.set_label_single(layer_out)

        layer_out.updateExtents()

        # Add created layer to the current project
        project.addMapLayer(layer_out)
        
        # Zoom in on the bounding box of the lat/long point
        if self.dlg.zoom_in.isChecked(): 
            # convert coordinates
            crsSrc = QgsCoordinateReferenceSystem(4326)  # WGS84
            crsDest = QgsCoordinateReferenceSystem(QgsProject.instance().crs())
            xform = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
            # forward transformation: src -> dest
            center_point = xform.transform(point_out)
            self.iface.mapCanvas().setCenter(center_point)

            zoom = 18.75
            if zoom is not None: # transform the zoom level to scale
                scale_value = 591657550.5 / 2 ** (zoom - 1)
                self.iface.mapCanvas().zoomScale(scale_value)
        # Commit all changes to the created layer
        layer_out.commitChanges()
        self.layers = self.refresh_layers()

        # Reset portions of the dialogue box
        self.dlg.point_label.setText('')
        self.dlg.layer_name_single.setText('')
        self.dlg.single_address_id.setText('')
        if not self.dlg.existing_layer_radio.isEnabled():
            self.dlg.existing_layer_radio.setDisabled(False)
    
    def smarty_batch(self):
        # Make sure the user has chosen a file path before moving onto the API call
        if self.dlg.csv_file_output.filePath() == '':
            self.iface.messageBar().pushMessage("Error: ", "Please select an output file", level=Qgis.Critical, duration=6)
            return
        elif self.dlg.csv_file.filePath() == '':
            self.iface.messageBar().pushMessage("Error: ", "Please select a CSV file to process", level=Qgis.Critical, duration=6)
            return
        # Read the csv into a pandas dataframe
        df = pd.read_csv(self.dlg.csv_file.filePath())
        # Check is user wants to use their own Address ID
        if self.dlg.id_box.isChecked():
            id_column_name = self.dlg.batch_id.currentText()
        else:
            id_column_name = 'smarty-id' 
            df.insert(0,id_column_name,range(0,0 + len(df)))
        
        df.insert(0, '----', '')
        
        self.length = df.shape[0]
        # Process the csv and pandas dataframe differently depending on whether the user uses multiple columns or one column for the Address
        if self.dlg.batch_components_frame.isEnabled() == False:
            self.freeform_batch(df, id_column_name)
        else:
            address = self.dlg.batch_address.currentText()
            city = self.dlg.batch_city.currentText() 
            state = self.dlg.batch_state.currentText() 
            zip = self.dlg.batch_zip.currentText()


            project = QgsProject.instance()
            # Create new VectorLayer to output results on
            if self.dlg.layer_name_batch.text() == '':
                layer_out = QgsVectorLayer("Point?crs=EPSG:4326&field=id:string&field=address:string&field=longitude:string&field=latitude:string&field=city:string&field=state:string&field=zip_code:string&field=zip_4:string&field=precision:string&field=county:string&field=county_fips:string&field=rdi:string&field=cong_dist:string&field=time_zone:string&field=dst:string&field=label:string&field=summary:string&field=i_address:string&field=i_city:string&field=i_state:string&field=i_zip:string",
                'Smarty',
                "memory") 
            else:
                layer_out = QgsVectorLayer("Point?crs=EPSG:4326&field=id:string&field=address:string&field=longitude:string&field=latitude:string&field=city:string&field=state:string&field=zip_code:string&field=zip_4:string&field=precision:string&field=county:string&field=county_fips:string&field=rdi:string&field=cong_dist:string&field=time_zone:string&field=dst:string&field=label:string&field=summary:string&field=i_address:string&field=i_city:string&field=i_state:string&field=i_zip:string",
                self.dlg.layer_name_batch.text(),
                "memory") 
            # Set up credentials and Batch
            auth_id = self.dlg.auth_id.text()
            auth_token = self.dlg.auth_token.text()
            credentials = StaticCredentials(auth_id, auth_token)
            client = ClientBuilder(credentials).with_licenses(["us-rooftop-geocoding-custom-enterprise-cloud,us-rooftop-geocoding-cloud,us-rooftop-geocoding-enterprise-cloud"]).build_us_street_api_client()
            batch = Batch()

            counter = 0
            # Iterate over every row of the pandas dataframe to set up the batch lookup
            for _, row in df.iterrows():
                batch.add(StreetLookup())
                batch[counter].street = row[address] 
                batch[counter].city = row[city]
                batch[counter].state = row[state] 
                batch[counter].zipcode = str(row[zip])
                batch[counter].match = 'enhanced'

                counter += 1
                # Once the batch is full we will send our API call in another function
                if batch.is_full():
                    self.process_batch(df, id_column_name, address, city, state, zip, layer_out, client, batch, self.counter2)
                    batch.clear()
                    counter = 0
            # if the batch is not full but still has addresses on it we still want to process those addresses
            if len(batch) != 0:
                self.process_batch(df, id_column_name, address, city, state, zip, layer_out, client, batch, self.counter2) 
            
            if self.dlg.display_output_box.isChecked():
                # Zoom into the extents of the newly created layer
                canvas = self.iface.mapCanvas() 
                layer_out.selectAll() 
                canvas.zoomToSelected(layer_out)
                canvas.refresh()
                layer_out.removeSelection() 
                # Add created layer to the project map
                project.addMapLayer(layer_out)
                # Reset and update certain features on dialogue box
                self.layers = self.refresh_layers()
            
            self.output_csv(layer_out)
            self.enable_single_id_box()
            
            self.dlg.batch_button.setStyleSheet('background-color: rgb(10, 95, 255);color: white;border-width: 4px;border-radius: 4px;')
            self.dlg.batch_button.setText('Process Batch')

        self.iface.messageBar().pushMessage("Batch processed successfully", level=Qgis.Success, duration=6)
        self.value = 0
        self.layers = self.refresh_layers()

    def process_batch(self, df, id_column_name, address, city, state, zip, layer_out, client, batch, counter2):
        # Set up the progress bar to show user progress of batch lookups
        self.value += 100      
        if self.value < self.length:
            percent = self.value / self.length
            self.dlg.batch_button.setStyleSheet('background: qlineargradient(x1:0, y1:0, x2:1, y2:0, stop: 0 #0a60ff, stop: ' + str(percent) + ' #0a60ff, stop: ' + str(percent+ .01) + ' rgba(255, 0, 0, 0), stop: 1 #ccdeff)')
            str_percent = str(percent)
            self.dlg.batch_button.setText('Processing %' + str_percent[2:4])
            QApplication.processEvents()
        # Send the batch API call
        try:
            client.send_batch(batch)
        except exceptions.SmartyException as err: # 401 ERROR
            self.iface.messageBar().pushMessage("Error: ", str(err), level=Qgis.Critical, duration=6)
            return
        # Enumerate over the returned values on the batch
        for i, lookup in enumerate(batch):
            i_address = str(df.at[i,address])
            i_city = str(df.at[i,city])
            i_state = str(df.at[i,state])
            i_zip = str(df.at[i,zip])
            # Use chosen ID or create ID for each address
            if self.dlg.id_box.isChecked() == False:
                counter2 += 1 
                id = counter2
            else: 
                id = str(df.at[i,id_column_name])
            # Set address/point label
            if self.dlg.batch_point_label.currentText() == 'None':
                label = ''
            else:
                label = str(df.at[i,self.dlg.batch_point_label.currentText()])
                layer_out = self.set_label_batch(layer_out)

            candidates = lookup.result
            # If there are no result from the API on this particular address we will output the address the API received
            if len(candidates) == 0:
                self.iface.messageBar().pushMessage('No Match for given address. ' + str(df.at[i,address]) + ' ' + str(df.at[i,city]) + ' ' + str(df.at[i,state]))
                address_result = i_address
                city_result = i_city
                state_result = i_state
                zip_result = i_zip
                feature.setAttributes([id, address_result, '', '', city_result, state_result, zip_result, '', '', '',
                '', '', '', '', '', label, 'No Match', i_address, i_city, i_state, i_zip])
                continue

            candidate = candidates[0]
            # Receive all API information
            longitude = candidate.metadata.longitude
            latitude = candidate.metadata.latitude
            address_result = self.set_address(candidate)
            longitude = candidate.metadata.longitude
            latitude = candidate.metadata.latitude
            city_result = candidate.components.city_name
            state_result = candidate.components.state_abbreviation
            zip_result = candidate.components.zipcode
            zip_4 = candidate.components.plus4_code
            precision = candidate.metadata.precision
            county = candidate.metadata.county_name
            county_fips = candidate.metadata.county_fips
            rdi = candidate.metadata.rdi
            cong_dist = candidate.metadata.congressional_district
            time_zone = candidate.metadata.time_zone
            dst = candidate.metadata.obeys_dst

            feature = QgsFeature()
            if longitude == None or latitude == None:
                longitude = 0
                latitude = 0
            else: 
                # Create outputted lat/long point
                point_out = QgsPointXY(longitude, latitude)
                feature.setGeometry(QgsGeometry.fromPointXY(point_out))

            # Handle success of address lookup
            success = Utils.handle_success(candidates) 

            # Set attributes for associated layer
            feature.setAttributes([id, address_result, longitude, latitude, city_result, state_result, zip_result, zip_4, precision, county,
                            county_fips, rdi, cong_dist, time_zone, dst, label, success, i_address, i_city, i_state, i_zip])

            # Set symbol features
            symbol = self.set_symbol(self.dlg.symbol_color.color(), self.dlg.symbol_drop_down.currentText(), self.dlg.symbol_size_batch.value())

            # Add symbol to created layer    
            layer_out.dataProvider().addFeature(feature)
            layer_out.renderer().setSymbol(symbol)     
            layer_out.updateExtents()

        # Reset certain areas of dlg
        self.dlg.layer_name_batch.setText('')
        return layer_out
 
    def freeform_batch(self, df, id_column_name):
        address = self.dlg.batch_address.currentText()
        # create a pandas dataframe of all addresses where the address is not null 
        df = df[df[address].notna()]
        add_df = df[[id_column_name, address]].copy()

        project = QgsProject.instance()
        # Create new vector layer
        if self.dlg.layer_name_batch.text() == '':
            layer_out = QgsVectorLayer("Point?crs=EPSG:4326&field=id:string&field=address:string&field=longitude:string&field=latitude:string&field=city:string&field=state:string&field=zip_code:string&field=zip_4:string&field=precision:string&field=county:string&field=county_fips:string&field=rdi:string&field=cong_dist:string&field=time_zone:string&field=dst:string&field=label:string&field=summary:string&field=i_address:string&field=i_city:string&field=i_state:string&field=i_zip:string",
            'Smarty',
            "memory") 
        else:
            layer_out = QgsVectorLayer("Point?crs=EPSG:4326&field=id:string&field=address:string&field=longitude:string&field=latitude:string&field=city:string&field=state:string&field=zip_code:string&field=zip_4:string&field=precision:string&field=county:string&field=county_fips:string&field=rdi:string&field=cong_dist:string&field=time_zone:string&field=dst:string&field=label:string&field=summary:string&field=i_address:string&field=i_city:string&field=i_state:string&field=i_zip:string",
            self.dlg.layer_name_batch.text(),
            "memory") 
        # Set up credentials 
        auth_id = self.dlg.auth_id.text()
        auth_token = self.dlg.auth_token.text()
        credentials = StaticCredentials(auth_id, auth_token)
        client = ClientBuilder(credentials).with_licenses(["us-rooftop-geocoding-custom-enterprise-cloud,us-rooftop-geocoding-cloud,us-rooftop-geocoding-enterprise-cloud"]).build_us_street_api_client()
        batch = Batch()
        # Iterate over all the rows of the pandas dataframe
        counter = 0
        for _, row in add_df.iterrows():
            # Set up lookup
            batch.add(StreetLookup())
            batch[counter].street = row[address]
            batch[counter].match = 'enhanced'

            counter += 1
            # Process the lookup if the batch is full 
            if batch.is_full():
                self.process_freeform_batch(df, id_column_name, address, layer_out, client, batch, self.counter2)
                batch.clear()
                counter = 0
        # If the batch is not full but contians address process the batch 
        if len(batch) != 0:
            self.process_freeform_batch(df, id_column_name, address, layer_out, client, batch, self.counter2) 
        if self.dlg.display_output_box.isChecked():
            # Zoom to the extents of the created layer
            canvas = self.iface.mapCanvas() 
            layer_out.selectAll() 
            canvas.zoomToSelected(layer_out)
            canvas.refresh()
            layer_out.removeSelection() 
            # Add the new layer to the current project map
            project.addMapLayer(layer_out)
            # Reset certain parts of the dialogue box
            self.layers = self.refresh_layers()

        self.dlg.batch_button.setStyleSheet('background-color: rgb(10, 95, 255);color: white;border-width: 4px;border-radius: 4px;')
        self.dlg.batch_button.setText('Process Batch')
        self.output_csv(layer_out)
        self.enable_single_id_box()
        return df
    
    def process_freeform_batch(self, df, id_column_name, address, layer_out, client, batch, counter2):
        self.value += 100
        # Update the progress bar to infrom the user the progress of their batch lookup
        if self.value < self.length:
            percent = self.value / self.length
            self.dlg.batch_button.setStyleSheet('background: qlineargradient(x1:0, y1:0, x2:1, y2:0, stop: 0 #0a60ff, stop: ' + str(percent) + ' #0a60ff, stop: ' + str(percent+ .01) + ' rgba(255, 0, 0, 0), stop: 1 #ccdeff)')
            str_percent = str(percent)
            self.dlg.batch_button.setText('Processing %' + str_percent[2:4])
            QApplication.processEvents()
        # Send the batch API call
        try:
            client.send_batch(batch)
        except exceptions.SmartyException as err: # 401 ERROR
            self.iface.messageBar().pushMessage("Error ", str(err), level=Qgis.Critical, duration=6)
            return
        # Enumerate over the batch results
        for i, lookup in enumerate(batch):
            i_address = str(df.at[i,address])
            i_city = ''
            i_state = ''
            i_zip = ''
            # Create an ID for each Address or use ID user provided
            if self.dlg.id_box.isChecked() == False:
                counter2 += 1 
                id = counter2
            else: 
                id = str(df.at[i,id_column_name])
            # Set lat/long label 
            if self.dlg.batch_point_label.currentText() == 'None':
                label = ''
            else:
                label = str(df.at[i,self.dlg.batch_point_label.currentText()])
                layer_out = self.set_label_batch(layer_out)

            candidates = lookup.result
            # There were no potential addresses returned so we output the address they gave us
            if len(candidates) == 0:
                self.iface.messageBar().pushMessage('No Match for given address. ' + str(df.at[i,address]))  
                address_result = str(df.at[i,address])
                city_result = ''
                state_result = ''
                zip_result = ''
                feature.setAttributes([id, address_result, '', '', city_result, state_result, zip_result, '', '', '',
                '', '', '', '', '', label, 'No Match - The address is invalid.', i_address, i_city, i_state, i_zip])

                continue
                    
            candidate = candidates[0]
            # Receive information returned by API
            longitude = candidate.metadata.longitude
            latitude = candidate.metadata.latitude
            address_result = self.set_address(candidate)
            longitude = candidate.metadata.longitude
            latitude = candidate.metadata.latitude
            city_result = candidate.components.city_name
            state_result = candidate.components.state_abbreviation
            zip_result = candidate.components.zipcode
            zip_4 = candidate.components.plus4_code
            precision = candidate.metadata.precision
            county = candidate.metadata.county_name
            county_fips = candidate.metadata.county_fips
            rdi = candidate.metadata.rdi
            cong_dist = candidate.metadata.congressional_district
            time_zone = candidate.metadata.time_zone
            dst = candidate.metadata.obeys_dst

            feature = QgsFeature()
            if longitude == None or latitude == None:
                longitude = 0
                latitude = 0
            else: 
                # Create outputted lat/long point
                point_out = QgsPointXY(longitude, latitude)
                feature.setGeometry(QgsGeometry.fromPointXY(point_out))

            # Handle the success of the API call
            success = Utils.handle_success(candidates)

            # Set up the attributes associated with the new layer
            feature.setAttributes([id, address_result, longitude, latitude, city_result, state_result, zip_result, zip_4, precision, county,
                            county_fips, rdi, cong_dist, time_zone, dst, label, success, i_address, i_city, i_state, i_zip])

            # Set symbol and features for lat/long point
            symbol = self.set_symbol(self.dlg.symbol_color.color(), self.dlg.symbol_drop_down.currentText(), self.dlg.symbol_size_batch.value())

            # Add lat/long point to layer   
            layer_out.dataProvider().addFeature(feature)
            layer_out.renderer().setSymbol(symbol)    

            layer_out.updateExtents()
            # Reset certain areas of the dialogue box
            self.dlg.layer_name_batch.setText('')
        return layer_out

    def smarty_geo_link(self):  # Link to website if user clicks on button
        webbrowser.open("https://www.smarty.com/pricing/us-rooftop-geocoding")
    
    def smarty_documentation(self):  # Link to website if user clicks on button
        webbrowser.open("https://www.smarty.com/docs/qgis-geocoding-plugin-us-address") 

    def visit_smarty(self):  # Link to website if user clicks on button
        webbrowser.open("https://www.smarty.com/products/us-rooftop-geocoding") 

    # def smarty_help_link(self):  # Link to website if user clicks on button
    #     webbrowser.open("https://www.smarty.com/docs/sdk/python")

    def set_symbol(self, color, symbol, size):
        # Set size of the symbol
        if size == 0:
            size = '10'
        # Create actual symbol
        symbol = QgsMarkerSymbol.createSimple({'name': symbol, 'color': color, 'outline_color': '35,35,35,255', 'outline_style': 'solid', 'size':size})
        return symbol
    
    def add_tokens(self):
    
        auth_id_len = len(self.dlg.auth_id.text())
        auth_token_len = len(self.dlg.auth_token.text())
        # Make sure that the user has infact added someting to the dialogue box for their credentials
        if auth_id_len == 0 and auth_token_len == 0:
            self.iface.messageBar().pushMessage("FAIL: ", "Please add an Auth ID and an Auth Token", level=Qgis.Critical, duration=6)
            self.dlg.frame.setEnabled(False)
            return
        elif auth_id_len == 0:
            self.iface.messageBar().pushMessage("FAIL: ", "Please add an Auth ID", level=Qgis.Critical, duration=6)
            self.dlg.frame.setEnabled(False)
            return
        elif auth_token_len == 0:
            self.iface.messageBar().pushMessage("FAIL: ", "Please add an Auth Token", level=Qgis.Critical, duration=6)
            self.dlg.frame.setEnabled(False)
            return
        # Set up credentials for an initial lookup
        credentials = StaticCredentials(self.dlg.auth_id.text() , self.dlg.auth_token.text()) 
        client = ClientBuilder(credentials).with_licenses(["us-rooftop-geocoding-custom-enterprise-cloud,us-rooftop-geocoding-cloud,us-rooftop-geocoding-enterprise-cloud"]).build_us_street_api_client()
        lookup = StreetLookup()
        lookup.street = "484 W Bulldog Blvd, Provo, UT 84604" 
        # Send one lookup to make sure they are authorized to use send batches to Smarty API
        try:
            client.send_lookup(lookup)
        except exceptions.SmartyException as err:
            message = str(err)
            self.iface.messageBar().pushMessage("Error ", message, level=Qgis.Critical, duration=6)
            self.dlg.frame.setEnabled(False)
            return

        # Grab what user has set in their auth tokens and set them as global variables
        self.settings.setValue("auth_id", self.dlg.auth_id.text())
        self.settings.setValue("auth_token", self.dlg.auth_token.text())
        self.dlg.frame.setEnabled(True)
        self.iface.messageBar().pushMessage("Success", "Auth ID and Auth Token are valid and have been added to the plugin", level=Qgis.Success, duration=6)

    def meta_resize(self): # resize the dialogue box to show or hide the outputted metadata
        if self.dlg.meta_data.isChecked():
            # self.dlg.resize(586,1018)
            self.dlg.meta_data_results.setVisible(True)
        else:
            # self.dlg.resize(586,820)
            self.dlg.meta_data_results.setVisible(False)
    
    def refresh_layers(self):
        layers = QgsProject.instance().layerTreeRoot().children()
        layers_list = []
        layers = QgsProject.instance().mapLayers().values()
        # Iterate over all layers currently found in the QGIS project
        for layer in layers: 
            # Make sure we are only dealing with vector layers
            if layer.type() == QgsMapLayer.VectorLayer: 
                attributeTableConfig = layer.attributeTableConfig()

                path = os.path.dirname(os.path.abspath(__file__))
                path1 = path + '/smarty_example_id.shp' 
                path2 = path + '/smarty_example.shp'
                # Make sure that any layers users can add addresses to are layers created by Smarty's QGIS plugin
                temp_layer = QgsVectorLayer("Point?crs=EPSG:4326&field=id:string&field=address:string&field=longitude:string&field=latitude:string&field=city:string&field=state:string&field=zip_code:string&field=zip_4:string&field=precision:string&field=county:string&field=county_fips:string&field=rdi:string&field=cong_dist:string&field=time_zone:string&field=dst:string&field=label:string&field=summary:string&field=i_address:string&field=i_city:string&field=i_state:string&field=i_zip:string",
                "Smarty",
                "memory") 
                temp_layer2 = QgsVectorLayer("Point?crs=EPSG:4326&field=address:string&field=longitude:string&field=latitude:string&field=city:string&field=state:string&field=zip_code:string&field=zip_4:string&field=precision:string&field=county:string&field=county_fips:string&field=rdi:string&field=cong_dist:string&field=time_zone:string&field=dst:string&field=label:string&field=summary:string&field=i_address:string&field=i_city:string&field=i_state:string&field=i_zip:string",
                "Smarty",
                "memory") 
                temp_layer3 = QgsVectorLayer(path1,
                "Smarty",
                "ogr") 
                temp_layer4 = QgsVectorLayer(path2,
                "Smarty",
                "ogr") 

                temp_attributeTableConfig = temp_layer.attributeTableConfig()
                temp_attributeTableConfig2 = temp_layer2.attributeTableConfig()
                temp_attributeTableConfig3 = temp_layer3.attributeTableConfig()
                temp_attributeTableConfig4 = temp_layer4.attributeTableConfig()

                if attributeTableConfig.hasSameColumns(temp_attributeTableConfig):
                    layers_list.append( layer )
                elif attributeTableConfig.hasSameColumns(temp_attributeTableConfig2):
                    layers_list.append( layer )
                elif attributeTableConfig.hasSameColumns(temp_attributeTableConfig3):
                    layers_list.append( layer )
                elif attributeTableConfig.hasSameColumns(temp_attributeTableConfig4):
                    layers_list.append( layer )

        self.dlg.layer_box.clear()
        self.dlg.layer_box.addItems([layer.name() for layer in layers_list])

        return layers_list
    
    def fill_symbols(self):
        # Grab all the Smarty chosen symbols and fill drop downs with all options
        symbols = ['star', 'regular_star', 'square', 'cross', 'rectangle', 'diamond', 'pentagon', 'triangle', 'equilateral_triangle', 'circle', 'arrow', 'filled_arrowhead', 'x']

        self.dlg.symbol_drop_down.addItems(symbol for symbol in symbols)
        self.dlg.symbol_drop_down_single.addItems(symbol for symbol in symbols)

    def show_new_layer(self): # Enable certain areas of dialogue box if user wants to create a new layer
        self.dlg.single_frame_id.setEnabled(False)
        self.dlg.id_check_box.setEnabled(True)

        self.dlg.stacked_widget.setCurrentIndex(0)
        self.dlg.stacked_widget.setVisible(True)

        self.dlg.new_layer_frame.setDisabled(False)
        self.dlg.new_layer_frame.setVisible(True)
    
    def show_existing_layer(self): # Enable certain areas of dialogue box if user wants to use an existing layer
        self.dlg.id_check_box.setEnabled(False)
        self.dlg.id_check_box.setChecked(False)

        self.dlg.stacked_widget.setVisible(True)
        self.dlg.stacked_widget.setCurrentIndex(1)
        
        self.dlg.existing_layer_frame.setVisible(True)
        self.dlg.existing_layer_frame.setDisabled(False)

    def set_label_single(self, layer_out): # Set label settings for a single lookup layer
        label_settings = QgsPalLayerSettings()
        label_settings.displayAll = True
        label_settings.fieldName = 'label'

        text_format = QgsTextFormat()
        background_color = QgsTextBackgroundSettings()
        background_color.setFillColor(QColor('white'))
        background_color.setEnabled(True)
        text_format.setBackground(background_color )
        text_format.setSize(15)
        label_settings.setFormat(text_format)
        label_settings.LinePlacementFlags(1)
        # label_settings.quadOffset(7)
        # label_settings.xOffset = 3
        # label_settings.yOffset = 7

        layer_out.setLabeling(QgsVectorLayerSimpleLabeling(label_settings))
        layer_out.setLabelsEnabled(True)
        layer_out.triggerRepaint()

        return layer_out

    def set_label_batch(self, layer_out): # Set label settings for batch layer
        if self.dlg.batch_point_label.currentIndex == 1:
            return 
        label_settings = QgsPalLayerSettings()

        label_settings.displayAll = True

        label_settings.fieldName = 'label'

        text_format = QgsTextFormat()
        background_color = QgsTextBackgroundSettings()
        background_color.setFillColor(QColor('white'))
        background_color.setEnabled(True)
        text_format.setBackground(background_color)
        text_format.setSize(10)
        label_settings.setFormat(text_format)

        layer_out.setLabeling(QgsVectorLayerSimpleLabeling(label_settings))
        layer_out.setLabelsEnabled(True)
        layer_out.triggerRepaint()

        return layer_out
   
    def autocomplete(self):
        key = '119911182158064178' # FIXME: secret key id --> change name to secret_key_id
        hostname = 'qgis_smarty' # secret key token --> secret_key_token

        credentials = SharedCredentials(key, hostname)
        client = ClientBuilder(credentials).with_licenses(["us-autocomplete-pro-cloud"]).build_us_autocomplete_pro_api_client()
        text = self.dlg.single_address_lookup.text()
        
        # Send an API autocomplete call if user adds text
        if len(text) > 0 :
            lookup = AutocompleteProLookup(text) 
            client.send(lookup) 

            suggestion_list = []
            for suggestion in lookup.result:

                if suggestion.entries != 0:
                    entry = ' (' + str(suggestion.entries) + ' entries)'
                else:
                    entry = ''
                # Store all suggestions
                address = suggestion.street_line + " " + suggestion.secondary + entry + " " + suggestion.city + " " + suggestion.state + " " + suggestion.zipcode
                suggestion_list.append(address)
            # Set up Qcompleter
            self.autocomplete_model = QStandardItemModel()
            for text in suggestion_list:
                self.autocomplete_model.appendRow(QStandardItem(text))

            self.completer.setModel(self.autocomplete_model)
            self.dlg.single_address_lookup.setCompleter(self.completer)
        else:
            return
    
    def set_address(self, candidate): # Set up the returned address from the API calls
        address = ''
        if candidate.components.primary_number is not None:
            address = address + candidate.components.primary_number + ' '
        if candidate.components.street_predirection is not None:
            address = address + candidate.components.street_predirection + ' '
        if candidate.components.street_name is not None:
            address = address + candidate.components.street_name + ' '
        if candidate.components.street_postdirection is not None:
            address = address + candidate.components.street_postdirection + ' '
        
        return address
    
    def resize_dialog(self): # Resize the dialogue box depending on which tab user is on (single address lookup vs batch lookup)
        if self.dlg.tabWidget.currentIndex() == 0:
            if self.dlg.results.isVisible() == True:
                # self.dlg.resize(586,400)
                self.dlg.tabWidget.resize(400,400)
                self.dlg.results.setVisible(False)
    
    def add_csv(self):
        # Reset certain aspects of the dialogue
        if len(self.dlg.csv_file.filePath()) != 0 and self.dlg.batch_address.currentText != '': 
            self.dlg.id_box.setChecked(False)
            self.dlg.batch_id.clear()
            self.dlg.batch_address.clear()
            self.dlg.batch_city.clear()
            self.dlg.batch_state.clear()
            self.dlg.batch_zip.clear()
            self.dlg.batch_point_label.clear()
        # Throw error if a file path has not been chosen
        if len(self.dlg.csv_file.filePath()) == 0:
            self.iface.messageBar().pushMessage("Error: ", "Please select a file path", level=Qgis.Critical, duration=6)
            return 
        if len(self.dlg.batch_address.currentText()) > 0:
            self.reset_csv
        # Create pandas dataframe from the given csv
        df = pd.read_csv(self.dlg.csv_file.filePath())
        # Create and populate downs with the column names
        fields = df.columns.values.tolist()
        
        fields.insert(0,'----')

        self.dlg.batch_address.addItems(fields) 
        self.dlg.batch_city.addItems(fields)
        self.dlg.batch_state.addItems(fields)
        self.dlg.batch_zip.addItems(fields)
        self.dlg.batch_id.addItems(fields)
        fields.insert(0,"None")
        fields.remove('----')

        self.dlg.batch_point_label.addItems(fields)
        # Auto populate drop downs with the most intuitive column
        counter = 0
        for field in fields:
            field = field.lower()
            if field == 'address' or field == 'street' or field == 'addr':
                self.dlg.batch_address.setCurrentIndex(counter)
            elif field == 'city':
                self.dlg.batch_city.setCurrentIndex(counter)
            elif field == 'state' or field == 'st':
                self.dlg.batch_state.setCurrentIndex(counter)
            elif field == 'zip' or field == 'zipcode' or field == 'zip_code' or field == 'zip code':
                self.dlg.batch_zip.setCurrentIndex(counter)
            counter +=1

    def enable_id_box(self): # Enable certain parts of dialogue for adding an address ID
        if len(self.dlg.csv_file.filePath()) == 0:
            self.iface.messageBar().pushMessage("Error: ", "Please select a file path", level=Qgis.Critical, duration=6)
            self.dlg.id_box.setChecked(False)
            return 
        if self.dlg.id_box.isChecked():
            self.dlg.batch_id.setEnabled(True)
        else:
            self.dlg.batch_id.setEnabled(False) 
    
    def single_line_enable(self): # Enable certain parts of dialogue depending on whether the user is use a single line entry
        if self.dlg.single_line_box.isChecked():
            self.dlg.batch_address.setEnabled(True)
            self.dlg.batch_city.setEnabled(False)
            self.dlg.batch_state.setEnabled(False)
            self.dlg.batch_zip.setEnabled(False)
            self.dlg.city_label_batch.setEnabled(False)
            self.dlg.state_label_batch.setEnabled(False)
            self.dlg.zip_label_batch.setEnabled(False)
        else:
            self.dlg.batch_city.setEnabled(True)
            self.dlg.batch_state.setEnabled(True)
            self.dlg.batch_zip.setEnabled(True)
            self.dlg.city_label_batch.setEnabled(True)
            self.dlg.state_label_batch.setEnabled(True)
            self.dlg.zip_label_batch.setEnabled(True)
    
    def reset_csv(self):
        # Reset all aspects of the dialogue associated with adding/setting the input csv file
        self.dlg.csv_file.setFilePath(' ')
        self.dlg.csv_file_output.setFilePath(' ')
        
        self.dlg.id_box.setChecked(False)
        self.dlg.single_line_box.setChecked(False)
        self.dlg.batch_id.clear()
        self.dlg.batch_address.clear()
        self.dlg.batch_city.clear()
        self.dlg.batch_state.clear()
        self.dlg.batch_zip.clear()
        self.dlg.batch_point_label.clear()

        self.dlg.display_output_box.setChecked(True)

    def handle_success(self, result): # Handle and determine the success of the API request
        if Utils.is_valid(result):
            return "valid_address"
        if Utils.is_invalid(result):
            return "invalid_address"
        if Utils.is_missing_secondary(result):
            return "missing_secondary"
        if Utils.is_ambiguous(result):
            return "ambiguous_address"
        return "MAJOR ERROR"

    def output_csv(self, layer_out):
        # Throw error if the file path has not been chosen 
        if self.dlg.csv_file_output.filePath() == '':
            self.iface.messageBar().pushMessage("Error: ", "Please select a folder path", level=Qgis.Critical, duration=6)
            return 
        # Create a new csv file for the user according to file path and name they have chosen
        folder_path = self.dlg.csv_file_output.filePath()
        if folder_path[-4:] != '.csv': 
            file_path = folder_path + '.csv'

        # Grab all the fields from the selected layer (newly created layer from the batch lookup) to add to the csv
        fields = [field.name() for field in layer_out.fields()] 
        # Write to the csv file
        with open(file_path, 'a') as name:
            wr = csv.writer(name, quoting=csv.QUOTE_ALL)
            wr.writerow(fields)

            features = layer_out.getFeatures()
            for feature in features:
                attrs = feature.attributes()
                wr.writerow(attrs)
    
    def enable_single_id_box(self): # Enable certain parts of dialogue depending on whether the user is adding an ID to an address
        if self.dlg.existing_layer_radio.isChecked():
            index = self.dlg.layer_box.currentIndex()
            if len(self.layers) == 0:
                return
            chosen_layer = self.layers[index] 
            
            field_name = 'id'
            field_index = chosen_layer.fields().indexFromName(field_name) 

            if field_index == -1:
                self.dlg.single_frame_id.setDisabled(True)
            else: 
                self.dlg.single_frame_id.setDisabled(False)
        else:
            return

    def enable_single_id(self): # Enable certain parts of the dialogue to allow adding an ID to an address
        if self.dlg.id_check_box.isChecked():
            self.dlg.single_frame_id.setEnabled(True)
        else:
            self.dlg.single_frame_id.setEnabled(False)

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = SmartyDialog()
            self.dlg.resize(700, 900)

            # Create a global settings variable         
            settings = QtCore.QSettings()

            # Set the global variables to the text of the auth_id and auth_token
            self.dlg.auth_id.setText(settings.value('auth_id'))
            self.dlg.auth_token.setText(settings.value('auth_token'))

            # Disable sections of dialogue box
            if len(self.dlg.auth_id.text()) == 0:
                self.dlg.frame.setDisabled(True)
            self.dlg.batch_id.setDisabled(True)
            self.dlg.single_frame_id.setDisabled(True)
            self.dlg.id_check_box.setEnabled(False)
                
            # Listen for clicked buttons
            self.dlg.single_lookup.clicked.connect(self.smarty_single)
            self.dlg.batch_button.clicked.connect(self.smarty_batch)
            self.dlg.smarty_link_2.clicked.connect(self.smarty_geo_link)
            self.dlg.smarty_link_help.clicked.connect(self.smarty_documentation)
            self.dlg.visit_smarty.clicked.connect(self.visit_smarty)
            self.dlg.meta_data.clicked.connect(self.meta_resize) 
            self.dlg.new_layer_radio.clicked.connect(self.show_new_layer)
            self.dlg.existing_layer_radio.clicked.connect(self.show_existing_layer)
            self.dlg.existing_layer_radio.clicked.connect(self.enable_single_id_box)
            self.dlg.reset_csv.clicked.connect(self.reset_csv)
            self.dlg.add_csv.clicked.connect(self.add_csv)
            self.dlg.add_tokens.clicked.connect(self.add_tokens) 
            self.dlg.tabWidget.tabBarClicked.connect(self.resize_dialog)
            # self.dlg.tabWidget_3.tabBarClicked.connect(self.resize_dialog_batch)

            # Fill drop downs
            self.layers = self.refresh_layers()
            if len(self.layers) == 0:
                self.dlg.existing_layer_radio.setDisabled(True)
            self.fill_symbols()

            # Set correct visibility
            self.dlg.meta_data_results.setVisible(False)
            self.dlg.results.setVisible(False)
            self.dlg.stacked_widget.setVisible(False)

            # Set default checked box
            self.dlg.display_output_box.setChecked(True)
            self.dlg.zoom_in.setChecked(True)
            
            # State changed
            self.dlg.single_address_lookup.textChanged.connect(self.autocomplete)
            self.dlg.layer_box.currentIndexChanged.connect(self.enable_single_id_box)
            self.dlg.id_check_box.stateChanged.connect(self.enable_single_id)
            self.dlg.id_box.stateChanged.connect(self.enable_id_box) 
            self.dlg.single_line_box.stateChanged.connect(self.single_line_enable)

            # Set colors
            self.dlg.symbol_color_single.setColor(QColor(255, 0, 22))
            self.dlg.symbol_color.setColor(QColor(255, 0, 22))

            self.layers = self.refresh_layers()

            self.dlg.setWindowFlags(Qt.WindowStaysOnTopHint)


        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
