from qgis.core import QgsProcessingProvider, QgsApplication
from qgis.PyQt.QtGui import QIcon
import os

class SmartMoveProvider(QgsProcessingProvider):
    def __init__(self, iface=None):
        super().__init__()
        self.iface = iface

    def initGui(self):
        QgsApplication.processingRegistry().addProvider(self)

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self)

    def id(self):
        return 'smart_move_mobility_analytics'

    def name(self):
        return self.tr('SMART-MOVE Mobility Analytics')

    def icon(self):
        path = os.path.join(os.path.dirname(__file__), 'icon.png')
        return QIcon(path)

    def loadAlgorithms(self):
        from .algorithms.traffic_analyzer import TrafficAnalyzer
        from .algorithms.traffic_summary_visualizer_v10 import TrafficSummaryVisualizerV10
        self.addAlgorithm(TrafficAnalyzer())
        self.addAlgorithm(TrafficSummaryVisualizerV10())
