#!/usr/bin/env python
"""
Serializable object subclass

COMPLETE INTERPRETATION
"""

from .scalebar_base import ScalebarBase
from ..stream import Stream


class DoubleAlternatingScaleBar(ScalebarBase):
    """
    DoubleAlternatingScaleBar
    """

    @staticmethod
    def cls_id():
        return "6589f148-f7f7-11d2-b872-00600802e603"

    def __init__(self):  # pylint: disable=useless-super-delegation
        super().__init__()
        self.bar_height = 12
        self.fill_symbol1 = None
        self.fill_symbol2 = None

    def read(self, stream: Stream, version):
        super()._read(stream, version, "Double Alternating Scale Bar")

        self.bar_height = stream.read_double("bar height")

        self.fill_symbol1 = stream.read_object("fill symbol 1")
        self.fill_symbol2 = stream.read_object("fill symbol 2")

        stream.read_ushort("unknown", expected=2)

        self.division_line_symbol = stream.read_object("division line symbol")
        self.sub_division_line_symbol = stream.read_object("subdivision line symbol")
        self.division_height = stream.read_double("division height")
        self.sub_division_height = stream.read_double("subdivision height")
        self.mark_position = stream.read_int("mark position")
        self.mark_frequency = stream.read_int("mark frequency")

    def to_dict(self):  # pylint: disable=method-hidden
        res = super().to_dict()
        res["bar_height"] = self.bar_height
        res["fill_symbol1"] = self.fill_symbol1.to_dict() if self.fill_symbol1 else None
        res["fill_symbol2"] = self.fill_symbol2.to_dict() if self.fill_symbol2 else None
        return res
