# -*- coding: utf-8 -*-

"""
/***************************************************************************
 HSA
                                 A QGIS plugin
 This plugin add to the processing toolbox a geoprocess to compute the Hydraulic Average Slope
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-03-04
        copyright            : (C) 2022 by Salvatore Fiandaca, Antonio Cotroneo, Federico Gianoli
        email                : gianoli.federico@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Salvatore Fiandaca, Antonio Cotroneo, Federico Gianoli'
__date__ = '2022-03-04'
__copyright__ = '(C) 2022 by Salvatore Fiandaca, Antonio Cotroneo, Federico Gianoli'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterVectorLayer
from qgis.core import QgsProcessingParameterRasterLayer
from qgis.core import QgsProcessingParameterNumber
from qgis.core import QgsProcessingParameterFeatureSink
from qgis.core import QgsExpression
import processing


class HSA(QgsProcessingAlgorithm):

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterVectorLayer('astaprincipale', 'Asta principale', types=[QgsProcessing.TypeVectorLine], defaultValue=None))
        self.addParameter(QgsProcessingParameterRasterLayer('dtm', 'DTM', defaultValue=None))
        self.addParameter(QgsProcessingParameterNumber('passocurvedilivello', 'Passo Curve di livello', type=QgsProcessingParameterNumber.Integer, minValue=1, maxValue=1000, defaultValue=50))
        self.addParameter(QgsProcessingParameterFeatureSink('Ifmed', 'ifmed', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(8, model_feedback)
        results = {}
        outputs = {}

        # Curve di livello
        alg_params = {
            'BAND': 1,
            'CREATE_3D': False,
            'EXTRA': '',
            'FIELD_NAME': 'ELEV',
            'IGNORE_NODATA': False,
            'INPUT': parameters['dtm'],
            'INTERVAL': QgsExpression('@passocurvedilivello').evaluate(),
            'NODATA': None,
            'OFFSET': 0,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['CurveDiLivello'] = processing.run('gdal:contour', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # Estrai, curve valide
        # Estrae tutte le isoispe tranne quelle chiuse e che intersecano l'asta
        alg_params = {
            'EXPRESSION': ' NOT(\r\n is_closed( $geometry)\r\n and\r\n intersects($geometry, geometry(get_feature_by_id( @astaprincipale ,0))))',
            'INPUT': outputs['CurveDiLivello']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EstraiCurveValide'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}

        # Dividi con linee
        alg_params = {
            'INPUT': parameters['astaprincipale'],
            'LINES': outputs['EstraiCurveValide']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DividiConLinee'] = processing.run('native:splitwithlines', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return {}

        # FieldCalc: quota_m
        # Aggiungo un campo "quota_m" e lo popolo con la quota (punto medio) dell'asta
        alg_params = {
            'FIELD_LENGTH': 9,
            'FIELD_NAME': 'quota_m',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 1,  # Intero (32 bit)
            'FORMULA': 'raster_value( @dtm ,1,line_interpolate_point($geometry, length($geometry)/2))',
            'INPUT': outputs['DividiConLinee']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FieldcalcQuota_m'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(4)
        if feedback.isCanceled():
            return {}

        # RiorgaCampi: id,passo,len
        # Riorganizzo e ricalcolo alcuni campi che serviranno in seguito.
        alg_params = {
            'FIELDS_MAPPING': [{'expression': '"quota_m"','length': 9,'name': 'quota_m','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},{'expression': 'array_find(array_reverse(array_agg("quota_m", order_by:="quota_m")),"quota_m")+1','length': 9,'name': 'id','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},{'expression': ' @passocurvedilivello','length': 9,'name': 'passo','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},{'expression': 'round(length($geometry),2)','length': 9,'name': 'len','precision': 2,'sub_type': 0,'type': 6,'type_name': 'double precision'}],
            'INPUT': outputs['FieldcalcQuota_m']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RiorgacampiIdpassolen'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(5)
        if feedback.isCanceled():
            return {}

        # Estrai aste valide
        # Estrae solo le aste con lunghezza maggiuore di zero
        alg_params = {
            'EXPRESSION': '"len" > 0',
            'INPUT': outputs['RiorgacampiIdpassolen']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EstraiAsteValide'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(6)
        if feedback.isCanceled():
            return {}

        # Riorga-finale
        # Riorganizza i campi aggiungendo tutti gli altri campi calcolati
        alg_params = {
            'FIELDS_MAPPING': [{'expression': '"quota_m"','length': 9,'name': 'quota_m','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},{'expression': '"id"','length': 9,'name': 'id','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},{'expression': '"passo"','length': 9,'name': 'passo','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},{'expression': '"len"','length': 9,'name': 'len','precision': 2,'sub_type': 0,'type': 6,'type_name': 'double precision'},{'expression': 'with_variable(\'cucu\',array_reverse(array_agg(len,order_by:="quota_m")),if(id=1,@cucu[0],round(array_sum(array_slice(@cucu,0,id-1)),2)))','length': 9,'name': 'lenCum','precision': 2,'sub_type': 0,'type': 6,'type_name': 'double precision'},{'expression': 'with_variable(\'cucu\',array_reverse(array_agg(len,order_by:="quota_m")),if(id=1,array_sum(@cucu)-@cucu[0],round(array_sum(@cucu)- array_sum(array_slice(@cucu,0,id-1)),2)))','length': 9,'name': 'lenCumCon','precision': 2,'sub_type': 0,'type': 6,'type_name': 'double precision'},{'expression': 'round(@passocurvedilivello/length($geometry),5)','length': 9,'name': 'if50','precision': 5,'sub_type': 0,'type': 6,'type_name': 'double precision'},{'expression': 'round(@passocurvedilivello/length($geometry),5)*1000','length': 9,'name': 'if50x1000','precision': 2,'sub_type': 0,'type': 6,'type_name': 'double precision'},{'expression': 'round((length($geometry))^2/@passocurvedilivello,2)','length': 9,'name': 'len/if50','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},{'expression': 'round(length($geometry)/(sqrt(@passocurvedilivello/length($geometry))),0)','length': 9,'name': 'len/sqrif50','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},{'expression': '(array_sum(array_agg(length($geometry)))/(array_sum(array_agg(length($geometry)/(sqrt(50/length($geometry)))))))^2','length': 9,'name': 'if_med-i','precision': 5,'sub_type': 0,'type': 6,'type_name': 'double precision'},{'expression': '(array_sum(array_agg(length($geometry)))/\r\narray_sum(array_agg((length($geometry))^2/@passocurvedilivello)))','length': 9,'name': 'if_med-g','precision': 5,'sub_type': 0,'type': 6,'type_name': 'double precision'}],
            'INPUT': outputs['EstraiAsteValide']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Riorgafinale'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(7)
        if feedback.isCanceled():
            return {}

        # Aggrega
        # Aggrega tutte le aste divise e visualizza il dato finale ifmed-g e if_med-i
        alg_params = {
            'AGGREGATES': [{'aggregate': 'first_value','delimiter': ',','input': '"if_med-g"','length': 9,'name': 'if_med-g','precision': 5,'sub_type': 0,'type': 6,'type_name': 'double precision'},{'aggregate': 'first_value','delimiter': ',','input': '"if_med-i"','length': 9,'name': 'if_med-i','precision': 5,'sub_type': 0,'type': 6,'type_name': 'double precision'}],
            'GROUP_BY': 'NULL',
            'INPUT': outputs['Riorgafinale']['OUTPUT'],
            'OUTPUT': parameters['Ifmed']
        }
        outputs['Aggrega'] = processing.run('native:aggregate', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Ifmed'] = outputs['Aggrega']['OUTPUT']
        return results

    def name(self):
        return 'modello'

    def displayName(self):
        return 'modello'

    def group(self):
        return ''

    def groupId(self):
        return ''

    def shortHelpString(self):
        return """<html><body><p>L'algoritmo permette di calcolare la pendenza media idraulica di un'asta fluviale principale.</p>
<h2>Parametri in ingresso
</h2>
<h3>Asta principale</h3>
<p>Asta fluviale, deve essere unica feature</p>
<h3>DTM</h3>
<p>DTM del bacino dell'asta principale</p>
<h3>Passo Curve di livello</h3>
<p>Passo delle isoipse (es:10,50,100)</p>
<h2>Risultati</h2>
<h3>ifmed</h3>
<p>Pendenza media dell'aste fluviale principale:
if_med-i : pendenza media idraulica
if_med-g: pendenza media geometrica</p>
<br><p align="right">Autore algoritmo: Totò Fiandaca, Federico Gianoli, Antonio Cotroneo</p><p align="right">Autore della guida: Totò Fiandaca</p><p align="right">Versione algoritmo: v0.2</p></body></html>"""

    def helpUrl(self):
        return 'https://github.com/pigreco/field_calc_idraulica/blob/main/README.md'

    def createInstance(self):
        return HSA()
