# -*- coding: utf-8 -*-
"""
/***************************************************************************
 skraafotos
                                 A QGIS plugin
 Dette plugin laver opslag på Dataforsyningens Skråfotos
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-03-21
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Morten Storm, Styrke 10 ApS
        email                : morten@styrke10.dk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.PyQt.QtCore import Qt, QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon, QPixmap, QMovie
from qgis.PyQt.QtWidgets import QAction, QApplication, QMessageBox, QLabel
from PyQt5 import Qt, QtCore, QtWidgets, QtGui, QtWebKit, QtWebKitWidgets, QtXml, QtNetwork, uic
from PyQt5.QtGui import QGuiApplication
import subprocess
from qgis.core import *
from qgis.gui import *
from qgis.utils import *

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .skraafoto_dialog import skraafotosDialog
import os.path

import math
import webbrowser  

rb=QgsRubberBand(iface.mapCanvas(),QgsWkbTypes.PointGeometry )
rl=QgsRubberBand(iface.mapCanvas(),QgsWkbTypes.LineGeometry )
pressed=False
line=False
point0=iface.mapCanvas().getCoordinateTransform().toMapCoordinates(0, 0)
point1=iface.mapCanvas().getCoordinateTransform().toMapCoordinates(0, 0)

class skraafotos:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'skraafotos_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Skråfotos')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('skraafotos', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToWebMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/skraafoto/skraafoto.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Opslag på Skråfotos'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginWebMenu(
                self.tr(u'&Skråfotos'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = skraafotosDialog()
            self.dlg.setModal(True)


        # Read whether the explanation dialog should be shown
        s = QgsSettings()
        if s.value("skraafoto/DontShow"):
            bDontShow = True
        else:
            bDontShow = False
        self.dlg.chkDontShow.setChecked(bDontShow)
        QgsMessageLog.logMessage('Reading settings: {}'.format(bDontShow), tag="skraafoto", level=Qgis.Success )

        if not self.dlg.chkDontShow.isChecked():
            # show the dialog
            self.dlg.show()
            # Run the dialog event loop
            result = self.dlg.exec_()
        else:
            result = True
            
        # See if OK was pressed
        if result:
            QgsMessageLog.logMessage('Storing settings: {}'.format(self.dlg.chkDontShow.isChecked()), tag="skraafoto", level=Qgis.Success )
            s.setValue("skraafoto/DontShow", self.dlg.chkDontShow.isChecked())

            tool = PointTool(self.iface.mapCanvas())
            self.iface.mapCanvas().setMapTool(tool)
            QApplication.setOverrideCursor(QtCore.Qt.CrossCursor)


class PointTool(QgsMapTool):  
    def __init__(self, canvas):
        QgsMapTool.__init__(self, canvas)
        self.canvas = canvas    

    def canvasPressEvent(self, event):
        x = event.pos().x()
        y = event.pos().y()
        global rb, pressed, point0, point1
        point1 = None
        if not pressed: 
            pressed=True
            rb=QgsRubberBand(iface.mapCanvas(),QgsWkbTypes.PointGeometry )
            rb.setColor(QtCore.Qt.red)
            point0 = self.canvas.getCoordinateTransform().toMapCoordinates(x, y)
            rb.addPoint(point0) 
        #QgsMessageLog.logMessage('canvasPressEvent, pressed: {}, point0: {}'.format(pressed,point0.asWkt()), tag='skraafoto', level=Qgis.Success )

    def canvasMoveEvent(self, event):
        x = event.pos().x()
        y = event.pos().y()        
        global pressed, point0, point1, line, rl
        if pressed:
            if not line:
                rl.setColor ( QtCore.Qt.red )
                point1 = self.canvas.getCoordinateTransform().toMapCoordinates(x, y)
                rl.addPoint(point0)  
                rl.addPoint(point1)
                line=True
            else:
                if line: 
                    point1 = self.canvas.getCoordinateTransform().toMapCoordinates(x, y)
                    rl.reset(QgsWkbTypes.LineGeometry)
                    rl.addPoint(point0)  
                    rl.addPoint(point1)
            #QgsMessageLog.logMessage('canvasMoveEvent: line: {}, point0: {}, point1: {}'.format(pressed,line,point0.asWkt(),point1.asWkt()), tag='skraafoto', level=Qgis.Success )

    def canvasReleaseEvent(self, event):
        global pressed, line, rb, rl, point1, point0
        if point1 is None:
            point1 = point0
        angle = math.atan2(point1.x() - point0.x(), point1.y() - point0.y())
        angle = math.degrees(angle) if angle>0 else math.degrees(angle) + 360
        quadrant = int(((angle+45) % 360) / 90)
        orientation = ['north','east','south','west'][quadrant]

        pressed=False
        line=False
        actual_crs = self.canvas.mapSettings().destinationCrs()
        destination_crs = QgsCoordinateReferenceSystem(25832)  # ETRS 89 UTM zone 32N
        xform = QgsCoordinateTransform(actual_crs, destination_crs, QgsProject.instance())
        pt1 = xform.transform(point1)

        url='https://skraafoto.dataforsyningen.dk/?orientation={}&center={},{}'.format(orientation,str(pt1.x()),str(pt1.y()))
        webbrowser.open_new(url)

        rl.reset()
        rb.reset()
        self.canvas.unsetMapTool(self)
        QApplication.restoreOverrideCursor()

        QgsMessageLog.logMessage('showing photo, angle: {}, quadrant: {}, orientation: {}, point0: {}, point1: {}'.format(angle,quadrant,orientation,point0.asWkt(),point1.asWkt()), tag='skraafoto', level=Qgis.Success )
        
    def activate(self):
        pass

    def deactivate(self):
        pass

    def isZoomTool(self):
        return False

    def isTransient(self):
        return False

    def isEditTool(self):
        return True