# -*- coding: utf-8 -*-
"""
/***************************************************************************
 SinalizacaoCamadas
                                 A QGIS plugin
 Sinalização Camadas
                              -------------------
        begin                : 2017-02-17
        git sha              : $Format:%H$
        copyright            : (C) 2017 by Mário Fraga
        email                : mariofraga@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt4.QtCore import QSettings, QTranslator, qVersion, QCoreApplication
from PyQt4.QtGui import QAction, QIcon
# Initialize Qt resources from file resources.py
import resources
# Import the code for the dialog
from Sinalizacao_Camadas_dialog import SinalizacaoCamadasDialog
#import os.pathfrom dbconnection_dialog import dbconnectionDialog
import os.path
import os
from PyQt4.QtSql import *
from PyQt4.QtSql import QSqlQuery
from PyQt4.QtCore import *
from PyQt4.QtGui import *
import qgis
from qgis.core import *
from qgis.gui import QgsAttributeTableModel
import PyQt4.QtGui
import os.path
import shutil
from qgis.gui import QgsMessageBar
import sys, subprocess, re
from sys import platform as _platform
import psycopg2
import time



class SinalizacaoCamadas:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface



        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'SinalizacaoCamadas_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)


        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Sinalizacao Camadas')
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'SinalizacaoCamadas')
        self.toolbar.setObjectName(u'SinalizacaoCamadas')





    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('SinalizacaoCamadas', message)



    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        # Create the dialog (after translation) and keep reference
        self.dlg = SinalizacaoCamadasDialog()

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        icon_path = ':/plugins/SinalizacaoCamadas/setas1.png'
        action = self.add_action(icon_path,text=self.tr(u'Sinalização Camadas'),callback=self.run,parent=self.iface.mainWindow())


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Sinalizacao Camadas'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

    def populateFields(self):

        actlayer = qgis.utils.iface.activeLayer()
        cache = QgsVectorLayerCache(actlayer, 50000)
        self.modelc = QgsAttributeTableModel(cache)
        self.modelc.loadLayer()

        index = self.modelc.index(0, 0)

        campos = []
        for i in range(0, self.modelc.columnCount(index)):
            campos.append(self.modelc.headerData(i, Qt.Horizontal, Qt.DisplayRole))

        self.dlg.comboBoxCampos.addItems(campos)




    def mensagemErro(self, strMsg):
        msgBox = PyQt4.QtGui.QMessageBox()
        msgBox.setText(strMsg)
        msgBox.setStandardButtons(QMessageBox.Ok);
        msgBox.exec_()
        self.dlg.accept()

    def fechaConexao(self,conn):
        if conn:
            conn.close()

    def abrirConexao(self, camada):
        dsu = QgsDataSourceURI(camada.dataProvider().dataSourceUri())
        return psycopg2.connect(database=dsu.database(), user=dsu.username(), password=dsu.password(), host=dsu.host())

    def listaTipoOperacao(self, camada):
        try:
            conn = self.abrirConexao(camada)
            c = conn.cursor()
            c.execute('SELECT *  FROM indice_imagens.tb_tipo_operacao ORDER BY co_seq_operacao DESC;')
            self.dlg.comboBoxCampos.clear()
            campos = []
            for item in c.fetchall():
                print(c)
                campos.append(item[1])
                print("item="+str(item[1]))

            print("saiu do for")

            self.dlg.comboBoxCampos.addItems(campos)


            #mostra a camada selecionada.
            dsu = QgsDataSourceURI(camada.dataProvider().dataSourceUri())
            self.keycolumn = dsu.keyColumn()
            #self.populateTable(camada)

            self.fechaConexao(conn)




        except TypeError as e:
            print "Erro na Conexao ({0}): {1}".format(e.args, e.message)
        except psycopg2.OperationalError as e:
            print "Erro na Conexao1 ({0}): {1}".format(e.args, e.message)


        except:
            raise

    def getCodigoperacao(self, c, nomeOperacao):
        print("getCodigoperacao")
        c.execute("""SELECT * FROM indice_imagens.tb_tipo_operacao WHERE ds_operacao='""" + nomeOperacao + """' """)
        return c.fetchone()[0]

    def getCodigoUsuario(self, c, nomeUsuario):
        print("getCodigoUsuario")
        c.execute("""SELECT co_seq_responsavel FROM amazoniasar.tb_responsavel WHERE no_login='""" + nomeUsuario + """' """)
        return c.fetchone()[0]

    def getRegister(self, c, codigoImagem, codigoOperacao):
        print("getRegistro")
        c.execute("SELECT co_seq_imagem_responsavel FROM indice_imagens.rl_imagem_responsavel WHERE co_imagem = " + str(codigoImagem) + " and tp_operacao = " + str(codigoOperacao) + "")
        return c.fetchone()

    def insertRegister(self, c, codigoImagem, codigoOperacao,codigoUsuario, valorMarcado):
        print("insertRegister")
        c.execute("INSERT INTO indice_imagens.rl_imagem_responsavel(co_imagem, co_responsavel, st_operacao, tp_operacao) VALUES (" + str(
                codigoImagem) + "," + str(codigoUsuario) + "," + str(valorMarcado) + "," + str(
                codigoOperacao) + ")")

    def updateRegister(self, c, codigoImagem, codigoOperacao, codigoUsuario, id, valorMarcado):
        print("updateRegister")
        c.execute("UPDATE indice_imagens.rl_imagem_responsavel SET co_imagem=" + str(
            codigoImagem) + ", co_responsavel=" + str(codigoUsuario) + ", st_operacao=" + str(
            valorMarcado) + ", dt_alteracao='" + str(time.strftime("%Y-%m-%d")) + "', tp_operacao=" + str(
            codigoOperacao) + "  WHERE co_seq_imagem_responsavel=" + str(id) + "")

    def salvaInformacoes(self, camada, codigoImagem, nomeOperacao):
        try:
            print("Nome dao operacao: " + nomeOperacao + str(codigoImagem))
            conn = self.abrirConexao(camada)
            print("conectado ao banco metodo salvar.")
            c = conn.cursor()
            codigoOperacao = self.getCodigoperacao(c,nomeOperacao)
            dsu = QgsDataSourceURI(camada.dataProvider().dataSourceUri())
            codigoUsuario = self.getCodigoUsuario(c,dsu.username())

            if (self.dlg.radioButtonSim.isChecked()):
                valorMarcado = True
            else:
                valorMarcado = False

            existe = self.getRegister(c, codigoImagem, codigoOperacao)

            if existe:
                self.updateRegister(c, codigoImagem, codigoOperacao, codigoUsuario, existe[0], valorMarcado)
                #self.mensagemErro(u'Informações Alteradas Com Sucesso!')
            else:
                self.insertRegister(c, codigoImagem, codigoOperacao, codigoUsuario, valorMarcado)


            conn.commit()
            self.fechaConexao(conn)

        except TypeError as e:
            print "Erro na Conexao ({0}): {1}".format(e.args, e.message)
        except psycopg2.OperationalError as e:
            print "Erro na Conexao1 ({0}): {1}".format(e.args, e.message)
        except psycopg2.ProgrammingError as e:
            print "Erro na ProgrammingError ({0}): {1}".format(e.args, e.message)
        except psycopg2.DataError as e:
            print "DataError ({0}): {1}".format(e.args, e.message)
        except:
            raise


    def run(self):

        try:
            self.dlg = SinalizacaoCamadasDialog()

            actlayer = qgis.utils.iface.activeLayer()
            self.codigoImagem = 0
            if actlayer is None:
                return
            self.listaTipoOperacao(actlayer)

            self.features = actlayer.selectedFeatures()
            fidlist = []
            if len(self.features) > 0:
                for f in self.features:
                    fidlist.append(f[self.keycolumn])

                selection = []
                strsel = self.keycolumn + " IN ("

                for fid in fidlist:
                    selection.append(fid)
                    strsel = strsel + "'" + str(fid) + "',"
                    self.codigoImagem = fid

                strsel = strsel[:-1] + ")"
                actlayer.setSubsetString(strsel)
                cache = QgsVectorLayerCache(actlayer, 5)
                self.modelt = QgsAttributeTableModel(cache)
                self.modelt.loadLayer()
                table = self.dlg.tableView
                table.setModel(self.modelt)
                self.dlg.radioButtonSim.setChecked(True)
                self.dlg.show()
                result = self.dlg.exec_()

                if result:

                    for fid in fidlist:
                        print("selecao#ok")
                        self.salvaInformacoes(actlayer, fid,self.dlg.comboBoxCampos.currentText())
                        print("selecao#fim")
                    self.mensagemErro(u'Informações Salvas Com Sucesso!')
                    actlayer.setSubsetString('')
                    pass
            else:
                self.mensagemErro("Selecione Pelo Menos uma Camada.")


        except AttributeError as e:
            print "I/O Erro({0}): {1}".format(e.args, e.message)
        except NameError as e:
            print "Erro Name({0}): {1}".format(e.args, e.message)
        except:
            print "Unexpected error:", sys.exc_info()[0]
            self.mensagemErro("Erro.");