# -*- coding: utf-8 -*-
"""
/***************************************************************************
 SIOSETools
                                 A QGIS plugin
 Este plugin permite consultar la cartografía SIOSE del IGN.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-10-18
        git sha              : $Format:%H$
        copyright            : (C) 2023 by IGN-UCLM
        email                : david.hernadez@uclm.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import sys, os, subprocess
from qgis.PyQt.QtCore import *
from qgis.PyQt.QtGui import *
from qgis.PyQt import QtGui, QtWidgets, uic
from qgis.PyQt.QtWidgets import QDialog, QTableWidgetItem, QListWidgetItem, QFileDialog, QMessageBox, QProgressBar
from qgis.PyQt.QtCore import QVariant
from qgis.core import *
from qgis.gui import QgsMessageBar
from . import siose_tools_definitions as SDefs

# sys.path.append("C:\Program Files\JetBrains\PyCharm 2023.2\debug-eggs\pydevd-pycharm.egg") # dhl
# import pydevd

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'clip_siose_select_type_dialog.ui'))


class ClipSioseSelectTypeDialog(QDialog, FORM_CLASS):
    """
    Brief:
    """

    def __init__(self,
                 parent=None):
        """
        Brief:
        """
        super(ClipSioseSelectTypeDialog, self).__init__(parent)
        self.setupUi(self)
        self.clipSioseHRRadioButton.toggled.connect(self.selectClip)
        self.clipSioseMapCanvasRadioButton.toggled.connect(self.selectClip)
        self.clipSioseSelectedFeatures.toggled.connect(self.selectClip)
        self.selectPushButton.clicked.connect(self.select)
        SDefs.select_clip = False
        self.selectClip()

    def select(self):
        SDefs.select_clip = True
        self.close()

    def selectClip(self):
        if self.clipSioseHRRadioButton.isChecked():
            SDefs.clip_type = SDefs.CONST_CLIP_TYPE_SIOSEHR_ADMINISTRATIVE_UNIT
        if self.clipSioseMapCanvasRadioButton.isChecked():
            SDefs.clip_type = SDefs.CONST_CLIP_TYPE_SIOSE_MAP_CANVAS
        if self.clipSioseSelectedFeatures.isChecked():
            SDefs.clip_type = SDefs.CONST_CLIP_TYPE_SIOSE_SELECTED_FEATURES
