# -*- coding: utf-8 -*-
"""
/***************************************************************************
 SIOSETools
                                 A QGIS plugin
 Este plugin permite consultar la cartografía SIOSE del IGN.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-10-18
        git sha              : $Format:%H$
        copyright            : (C) 2023 by IGN-UCLM
        email                : david.hernadez@uclm.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import sys, os, subprocess
from qgis.PyQt.QtCore import *
from qgis.PyQt.QtGui import *
from qgis.PyQt import QtGui, QtWidgets, uic
from qgis.PyQt.QtWidgets import QDialog, QTableWidgetItem, QListWidgetItem, QFileDialog, QMessageBox, QProgressBar
from qgis.PyQt.QtCore import QVariant
from qgis.core import *
from qgis.gui import QgsMessageBar
from osgeo import gdal, osr, ogr
import shutil
from datetime import datetime
from . import siose_tools_definitions as SDefs
import math

# sys.path.append("C:\Program Files\JetBrains\PyCharm 2023.2\debug-eggs\pydevd-pycharm.egg") # dhl
# import pydevd

from .siose_gpkg_tools import SioseGpkgTools

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'clip_siose_dialog.ui'))


def copy_shapefile(input_shp, output_shp):
    str_error = ''
    input_base_name = os.path.splitext(os.path.basename(input_shp))[0]
    input_base_path = os.path.dirname(input_shp)
    output_base_path = os.path.dirname(output_shp)
    output_base_name = os.path.splitext(os.path.basename(output_shp))[0]
    for file in os.listdir(input_base_path):
        file_base_name = os.path.splitext(os.path.basename(file))[0]
        if file_base_name == input_base_name:
            file_extension = os.path.splitext(os.path.basename(file))[1]
            output_file = output_base_path + "/" + output_base_name + file_extension
            output_file = os.path.normcase(output_file)
            input_file = input_base_path + "/" + file
            input_file = os.path.normcase(input_file)
            try:
                shutil.copyfile(input_file, output_file)
            except EnvironmentError as e:
                str_error = "Unable to copy file. %s" % e
                return str_error
    return str_error


def remove_shapefile(input_shp):
    str_error = ''
    input_base_name = os.path.splitext(os.path.basename(input_shp))[0]
    input_base_path = os.path.dirname(input_shp)
    for file in os.listdir(input_base_path):
        file_base_name = os.path.splitext(os.path.basename(file))[0]
        if file_base_name == input_base_name:
            file_extension = os.path.splitext(os.path.basename(file))[1]
            input_file = input_base_path + "/" + file
            input_file = os.path.normcase(input_file)
            if not QFile.remove(input_file):
                str_error = 'Error borrando el fichero: ' + input_file
                return str_error
    return str_error


class ClipSioseHrTask(QgsTask):
    messaging = pyqtSignal(str)
    result = pyqtSignal(dict)

    def __init__(self,
                 target_file_name,
                 administrative_unit_id,
                 polygons_layer_name_output,
                 values_layer_name_output,
                 uses_layer_name_output,
                 combined_layer_name_output,
                 plane_table_layer_name_output,
                 selection_vrt_name,
                 polygons_plane_table_relation_field_name,
                 from_administrative_unit):
        super(ClipSioseHrTask, self).__init__()
        self.target_file_name = target_file_name
        self.administrative_unit_id = administrative_unit_id
        self.polygons_layer_name_output = polygons_layer_name_output
        self.values_layer_name_output = values_layer_name_output
        self.uses_layer_name_output = uses_layer_name_output
        self.combined_layer_name_output = combined_layer_name_output
        self.plane_table_layer_name_output = plane_table_layer_name_output
        self.selection_vrt_name = selection_vrt_name
        self.polygons_plane_table_relation_field_name = polygons_plane_table_relation_field_name
        self.from_administrative_unit = from_administrative_unit
        self.load_as_process = True

    def run(self):
        results = {}
        # pydevd.settrace('localhost',port=54200,stdoutToServer=True,stderrToServer=True)
        start = datetime.now()
        if not self.from_administrative_unit:
            str_target_file_name = '\"' + os.path.normcase(self.target_file_name) + '\"'
            str_selection_file_name = '\"' + os.path.normcase(self.selection_vrt_name) + '\"'
            sql_statment = (f'SELECT ' + SDefs.CONST_SIOSE_T_POLIGONOS_INPUT_NAME
                            + '.* FROM ' + SDefs.CONST_SIOSE_T_POLIGONOS_INPUT_NAME + ', '
                            + SDefs.CONST_CLIP_SIOSE_SELECTION_AUXILIAR_BASE_NAME + ' WHERE ST_INTERSECTS('
                            + SDefs.CONST_SIOSE_T_POLIGONOS_INPUT_NAME + '.geom, '
                            + SDefs.CONST_CLIP_SIOSE_SELECTION_AUXILIAR_BASE_NAME + '.geometry)')
            if self.load_as_process:
                sql_statment_str = "\"" + sql_statment + "\""
                command = ["ogr2ogr", str_target_file_name,
                           str_selection_file_name, "-nln",
                           self.polygons_layer_name_output, "-append", "-sql", sql_statment_str,
                           "-dialect", "SQLITE", "-gt", "100000"]
                str_command = ''
                for str_aux in command:
                    str_command += str_aux + ' '
                # self.display_msg_error(str_command)
                try:
                    subprocess.check_call(str_command, shell=True)
                except subprocess.CalledProcessError as e:
                    str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                    str_error += (', GDAL Error in execution: ' + str_command)
                    # self.display_msg_error(str_error)
                    results['success'] = False
                    results['error'] = str_error
                    self.result.emit(results)
                    return True
            else:
                gdoptions = gdal.VectorTranslateOptions(options=['-nln', self.polygons_layer_name_output, '-append', ],
                                                        SQLStatement=sql_statment,
                                                        SQLDialect='SQLITE')
                try:
                    output_ds = gdal.VectorTranslate(destNameOrDestDS=self.target_file_name,
                                                     srcDS=self.selection_vrt_name,
                                                     options=gdoptions)
                except Exception as e:
                    str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                    str_error += (', GDAL Error: ' + gdal.GetLastErrorMsg())
                    # self.display_msg_error(str_error)
                    results['success'] = False
                    results['error'] = str_error
                    self.result.emit(results)
                    return True
            sql_statment = (f'SELECT ' + SDefs.CONST_SIOSE_T_VALORES_INPUT_NAME
                            + '.* FROM ' + SDefs.CONST_SIOSE_T_VALORES_INPUT_NAME + ', '
                            + SDefs.CONST_SIOSE_T_POLIGONOS_OUTPUT_NAME + ' WHERE '
                            + SDefs.CONST_SIOSE_T_VALORES_INPUT_NAME + '.' + SDefs.CONST_SIOSE_ID_POLYGON
                            + '=' + SDefs.CONST_SIOSE_T_POLIGONOS_OUTPUT_NAME + '.' + SDefs.CONST_SIOSE_ID_POLYGON)
            if self.load_as_process:
                sql_statment_str = "\"" + sql_statment + "\""
                command = ["ogr2ogr", str_target_file_name,
                           str_selection_file_name, "-nln",
                           self.values_layer_name_output, "-append", "-sql", sql_statment_str,
                           "-dialect", "SQLITE", "-gt", "100000"]
                str_command = ''
                for str_aux in command:
                    str_command += str_aux + ' '
                # self.display_msg_error(str_command)
                try:
                    subprocess.check_call(str_command, shell=True)
                except subprocess.CalledProcessError as e:
                    str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                    str_error += (', GDAL Error in execution: ' + str_command)
                    # self.display_msg_error(str_error)
                    results['success'] = False
                    results['error'] = str_error
                    self.result.emit(results)
                    return True
            else:
                gdoptions = gdal.VectorTranslateOptions(options=['-nln', self.values_layer_name_output, '-append', ],
                                                        SQLStatement=sql_statment,
                                                        SQLDialect='SQLITE')
                try:
                    output_ds = gdal.VectorTranslate(destNameOrDestDS=self.target_file_name,
                                                     srcDS=self.selection_vrt_name,
                                                     options=gdoptions)
                except Exception as e:
                    str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                    str_error += (', GDAL Error: ' + gdal.GetLastErrorMsg())
                    # self.display_msg_error(str_error)
                    results['success'] = False
                    results['error'] = str_error
                    self.result.emit(results)
                    return True
            sql_statment = (f'SELECT ' + SDefs.CONST_SIOSE_TABLA_PLANA_INPUT_NAME
                            + '.* FROM ' + SDefs.CONST_SIOSE_TABLA_PLANA_INPUT_NAME + ', '
                            + SDefs.CONST_SIOSE_T_POLIGONOS_OUTPUT_NAME + ' WHERE '
                            + SDefs.CONST_SIOSE_TABLA_PLANA_INPUT_NAME + '.' + self.polygons_plane_table_relation_field_name
                            + '=' + SDefs.CONST_SIOSE_T_POLIGONOS_OUTPUT_NAME + '.' + self.polygons_plane_table_relation_field_name)
            if self.load_as_process:
                sql_statment_str = "\"" + sql_statment + "\""
                command = ["ogr2ogr", str_target_file_name,
                           str_selection_file_name, "-nln",
                           self.plane_table_layer_name_output, "-append", "-sql", sql_statment_str,
                           "-dialect", "SQLITE", "-gt", "100000"]
                str_command = ''
                for str_aux in command:
                    str_command += str_aux + ' '
                # self.display_msg_error(str_command)
                try:
                    subprocess.check_call(str_command, shell=True)
                except subprocess.CalledProcessError as e:
                    str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                    str_error += (', GDAL Error in execution: ' + str_command)
                    # self.display_msg_error(str_error)
                    results['success'] = False
                    results['error'] = str_error
                    self.result.emit(results)
                    return True
            else:
                gdoptions = gdal.VectorTranslateOptions(
                    options=['-nln', self.plane_table_layer_name_output, '-append', ],
                    SQLStatement=sql_statment,
                    SQLDialect='SQLITE')
                try:
                    output_ds = gdal.VectorTranslate(destNameOrDestDS=self.target_file_name,
                                                     srcDS=self.selection_vrt_name,
                                                     options=gdoptions)
                except Exception as e:
                    str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                    str_error += (', GDAL Error: ' + gdal.GetLastErrorMsg())
                    # self.display_msg_error(str_error)
                    results['success'] = False
                    results['error'] = str_error
                    self.result.emit(results)
                    return True
            if not self.load_as_process:
                output_ds = None
        else:
            str_target_file_name = '\"' + os.path.normcase(self.target_file_name) + '\"'
            str_selection_file_name = '\"' + os.path.normcase(self.selection_vrt_name) + '\"'
            sql_statment = (f'SELECT ' + SDefs.CONST_SIOSE_T_POLIGONOS_INPUT_NAME
                            + '.* FROM ' + SDefs.CONST_SIOSE_T_POLIGONOS_INPUT_NAME + ' WHERE '
                            + SDefs.CONST_SIOSE_HR_ADMINISTRATIVE_UNIT_FIELD_ID + ' = '
                            + str(self.administrative_unit_id))
            sql_statment_str = "\"" + sql_statment + "\""
            command = ["ogr2ogr", str_target_file_name,
                       str_selection_file_name, "-nln",
                       self.polygons_layer_name_output, "-append", "-sql", sql_statment_str,
                       "-dialect", "SQLITE", "-gt", "100000"]
            str_command = ''
            for str_aux in command:
                str_command += str_aux + ' '
            # self.display_msg_error(str_command)
            try:
                subprocess.check_call(str_command, shell=True)
            except subprocess.CalledProcessError as e:
                str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                str_error += (', GDAL Error in execution: ' + str_command)
                # self.display_msg_error(str_error)
                results['success'] = False
                results['error'] = str_error
                self.result.emit(results)
                return True
            sql_statment = (f'SELECT ' + SDefs.CONST_SIOSE_T_VALORES_INPUT_NAME
                            + '.* FROM ' + SDefs.CONST_SIOSE_T_VALORES_INPUT_NAME + ' WHERE '
                            + SDefs.CONST_SIOSE_HR_ADMINISTRATIVE_UNIT_FIELD_ID + ' = '
                            + str(self.administrative_unit_id))
            sql_statment_str = "\"" + sql_statment + "\""
            command = ["ogr2ogr", str_target_file_name,
                       str_selection_file_name, "-nln",
                       self.values_layer_name_output, "-append", "-sql", sql_statment_str,
                       "-dialect", "SQLITE", "-gt", "100000"]
            str_command = ''
            for str_aux in command:
                str_command += str_aux + ' '
            # self.display_msg_error(str_command)
            try:
                subprocess.check_call(str_command, shell=True)
            except subprocess.CalledProcessError as e:
                str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                str_error += (', GDAL Error in execution: ' + str_command)
                # self.display_msg_error(str_error)
                results['success'] = False
                results['error'] = str_error
                self.result.emit(results)
                return True
            sql_statment = (f'SELECT ' + SDefs.CONST_SIOSE_T_USOS_INPUT_NAME
                            + '.* FROM ' + SDefs.CONST_SIOSE_T_USOS_INPUT_NAME + ' WHERE '
                            + SDefs.CONST_SIOSE_HR_ADMINISTRATIVE_UNIT_FIELD_ID + ' = '
                            + str(self.administrative_unit_id))
            sql_statment_str = "\"" + sql_statment + "\""
            command = ["ogr2ogr", str_target_file_name,
                       str_selection_file_name, "-nln",
                       self.uses_layer_name_output, "-append", "-sql", sql_statment_str,
                       "-dialect", "SQLITE", "-gt", "100000"]
            str_command = ''
            for str_aux in command:
                str_command += str_aux + ' '
            # self.display_msg_error(str_command)
            try:
                subprocess.check_call(str_command, shell=True)
            except subprocess.CalledProcessError as e:
                str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                str_error += (', GDAL Error in execution: ' + str_command)
                # self.display_msg_error(str_error)
                results['success'] = False
                results['error'] = str_error
                self.result.emit(results)
                return True
            sql_statment = (f'SELECT ' + SDefs.CONST_SIOSE_T_COMBINADA_INPUT_NAME
                            + '.* FROM ' + SDefs.CONST_SIOSE_T_COMBINADA_INPUT_NAME + ' WHERE '
                            + SDefs.CONST_SIOSE_HR_ADMINISTRATIVE_UNIT_FIELD_ID + ' = '
                            + str(self.administrative_unit_id))
            sql_statment_str = "\"" + sql_statment + "\""
            command = ["ogr2ogr", str_target_file_name,
                       str_selection_file_name, "-nln",
                       self.combined_layer_name_output, "-append", "-sql", sql_statment_str,
                       "-dialect", "SQLITE", "-gt", "100000"]
            str_command = ''
            for str_aux in command:
                str_command += str_aux + ' '
            # self.display_msg_error(str_command)
            try:
                subprocess.check_call(str_command, shell=True)
            except subprocess.CalledProcessError as e:
                str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                str_error += (', GDAL Error in execution: ' + str_command)
                # self.display_msg_error(str_error)
                results['success'] = False
                results['error'] = str_error
                self.result.emit(results)
                return True
            sql_statment = (f'SELECT ' + SDefs.CONST_SIOSE_TABLA_PLANA_INPUT_NAME
                            + '.* FROM ' + SDefs.CONST_SIOSE_TABLA_PLANA_INPUT_NAME)
            sql_statment_str = "\"" + sql_statment + "\""
            command = ["ogr2ogr", str_target_file_name,
                       str_selection_file_name, "-nln",
                       self.plane_table_layer_name_output, "-append", "-sql", sql_statment_str,
                       "-dialect", "SQLITE", "-gt", "100000"]
            str_command = ''
            for str_aux in command:
                str_command += str_aux + ' '
            # self.display_msg_error(str_command)
            try:
                subprocess.check_call(str_command, shell=True)
            except subprocess.CalledProcessError as e:
                str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                str_error += (', GDAL Error in execution: ' + str_command)
                # self.display_msg_error(str_error)
                results['success'] = False
                results['error'] = str_error
                self.result.emit(results)
                return True
            sql_statment = (f'DELETE FROM ' + SDefs.CONST_SIOSE_HR_TABLA_PLANA_LAYER + ' WHERE '
                            + SDefs.CONST_SIOSE_HR_SIOSE_CODE + ' NOT IN SELECT('
                            + SDefs.CONST_SIOSE_HR_T_USOS_LAYER + '.' + SDefs.CONST_SIOSE_HR_SIOSE_CODE
                            + ' FROM ' + SDefs.CONST_SIOSE_HR_T_USOS_LAYER + ')')
            sql_statment_str = "\"" + sql_statment + "\""
            command = ["ogrinfo", "-sql", sql_statment_str, str_target_file_name]
            str_command = ''
            for str_aux in command:
                str_command += str_aux + ' '
            # self.display_msg_error(str_command)
            try:
                subprocess.check_call(str_command, shell=True)
            except subprocess.CalledProcessError as e:
                str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                str_error += (', GDAL Error in execution: ' + str_command)
                # self.display_msg_error(str_error)
                results['success'] = False
                results['error'] = str_error
                self.result.emit(results)
                return True
            command = ["ogrinfo", "-sql", "\"VACUUM\"", str_target_file_name]
            str_command = ''
            for str_aux in command:
                str_command += str_aux + ' '
            # self.display_msg_error(str_command)
            try:
                subprocess.check_call(str_command, shell=True)
            except subprocess.CalledProcessError as e:
                str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                str_error += (', GDAL Error in execution: ' + str_command)
                # self.display_msg_error(str_error)
                results['success'] = False
                results['error'] = str_error
                self.result.emit(results)
                return True
        end = datetime.now()
        # msg_time = "Se ha completado la tarea en " + str((end - start).total_seconds()) + " segundos"
        msg_time = "Se ha completado la tarea en " + str(math.ceil((end - start).total_seconds())) + " segundos"
        results['success'] = True
        results['target_file_name'] = self.target_file_name
        results['polygons_layer_name_output'] = self.polygons_layer_name_output
        results['values_layer_name_output'] = self.values_layer_name_output
        results['msg_time'] = msg_time
        if  self.from_administrative_unit:
            results['uses_layer_name_output'] = self.uses_layer_name_output
        self.result.emit(results)
        return True


class ClipSioseDialog(QDialog, FORM_CLASS):
    """
    Brief:
    """

    def __init__(self,
                 iface,
                 gdal_error_handler,
                 siose_gpkg_tools,
                 settings,
                 last_path,
                 siose_hr_selected,
                 from_map_canvas,
                 from_selected_features,
                 from_administrative_unit,
                 siose_layer_names,
                 siose_hr_layer_names,
                 siose_template,
                 siose_hr_template,
                 temp_path,
                 parent=None):
        """
        Brief:
        """
        super(ClipSioseDialog, self).__init__(parent)
        self.setupUi(self)
        self.iface = iface
        self.gdal_error_handler = gdal_error_handler
        self.siose_gpkg_tools = siose_gpkg_tools
        self.settings = settings
        self.last_path = last_path
        self.siose_hr_selected = siose_hr_selected
        self.from_map_canvas = from_map_canvas
        self.from_selected_features = from_selected_features
        self.from_administrative_unit = from_administrative_unit
        title = ''
        self.fieldNameLabel.setVisible(False)
        self.fieldNameComboBox.setVisible(False)
        self.fieldValueLabel.setVisible(False)
        self.fieldValueComboBox.setVisible(False)
        if not siose_hr_selected:
            if from_map_canvas:
                title = SDefs.CONST_CLIP_SIOSE_FROM_MAP_CANVAS_TEXT
            else:
                title = SDefs.CONST_CLIP_SIOSE_FROM_SELECTED_FEATURES_TEXT
        else:
            title = SDefs.CONST_CLIP_SIOSE_HR_FROM_ADMINISTRATIVE_UNIT_TEXT
            self.fieldNameLabel.setVisible(True)
            self.fieldNameComboBox.setVisible(True)
            self.fieldValueLabel.setVisible(True)
            self.fieldValueComboBox.setVisible(True)
            self.fieldNameComboBox.addItem(SDefs.CONST_SIOSE_HR_ADMINISTRATIVE_UNIT_FIELD_NAME)
            self.fieldNameComboBox.setEnabled(False)
            self.fieldValueComboBox.setEnabled(False)
        self.title = title
        self.setWindowTitle(title)
        self.is_closed = False
        self.sourcePushButton.clicked.connect(self.selectSource)
        self.targetPushButton.clicked.connect(self.selectTarget)
        self.clipPushButton.clicked.connect(self.selectClip)
        self.siose_layer_names = siose_layer_names
        self.siose_hr_layer_names = siose_hr_layer_names
        self.siose_template = siose_template
        self.siose_hr_template = siose_hr_template
        self.temp_path = temp_path
        self.selection_shapefile_name = os.path.join(temp_path,
                                                     (SDefs.CONST_CLIP_SIOSE_SELECTION_AUXILIAR_BASE_NAME + '.shp'))
        self.selection_vrt_name = os.path.join(temp_path,
                                               (SDefs.CONST_CLIP_SIOSE_SELECTION_AUXILIAR_BASE_NAME + '.vrt'))
        self.source_filename = None
        self.target_filename = None
        self.load_as_process = True  # False para que se ejecute como funcion, pero tarda mucho mas
        self.administrative_unid_id_by_name = {}
        self.fieldValueComboBox.currentIndexChanged.connect(self.selectAdministrativeUnit)
        self.progressBar.setValue(0)

    def add_map_layer(self, results: dict):
        success = results['success']
        if not success:
            error_msg = results['error']
            self.display_msg_error(error_msg)
            return
        target_file_name = results['target_file_name']
        polygons_layer_name_output = results['polygons_layer_name_output']
        values_layer_name_output = results['values_layer_name_output']
        uses_layer_name_output = None
        if 'uses_layer_name_output' in results:
            uses_layer_name_output = results['uses_layer_name_output']
        text = self.tr(u'Se ha creado: ' + target_file_name)
        text = text + '\n' + results['msg_time']
        self.display_msg_error(text)
        if self.addToMapCheckBox.isChecked():
            (target_file_directory, target_file_namefile) = os.path.split(target_file_name)
            (target_file_basename, extension) = os.path.splitext(target_file_namefile)
            target_geometry_layer_url = target_file_name + "|layername=" + polygons_layer_name_output
            polygons_layer_name = SDefs.CONST_SIOSE_T_POLIGONOS_LAYER
            if self.siose_hr_selected:
                polygons_layer_name = SDefs.CONST_SIOSE_HR_T_POLIGONOS_LAYER
            target_geometry_layer = QgsVectorLayer(target_geometry_layer_url, polygons_layer_name,
                                                   "ogr")
            if not target_geometry_layer.isValid():
                str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                str_error += self.tr(u'\n No es valida la capa: ')
                str_error += target_geometry_layer_url
                self.display_msg_error(str_error)
                return
            target_values_layer_url = target_file_name + "|layername=" + values_layer_name_output
            values_layer_name = SDefs.CONST_SIOSE_T_VALORES_LAYER
            if self.siose_hr_selected:
                values_layer_name = SDefs.CONST_SIOSE_HR_T_VALORES_LAYER
            target_values_layer = QgsVectorLayer(target_values_layer_url, values_layer_name, "ogr")
            if not target_values_layer.isValid():
                str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                str_error += self.tr(u'\n No es valida la capa: ')
                str_error += target_values_layer_url
                self.display_msg_error(str_error)
                return
            if uses_layer_name_output:
                target_uses_layer_url = target_file_name + "|layername=" + uses_layer_name_output
                uses_layer_name = SDefs.CONST_SIOSE_HR_T_USOS_LAYER
                target_uses_layer = QgsVectorLayer(target_uses_layer_url, uses_layer_name, "ogr")
                if not target_uses_layer.isValid():
                    str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                    str_error += self.tr(u'\n No es valida la capa: ')
                    str_error += target_uses_layer_url
                    self.display_msg_error(str_error)
                    return
            QgsProject.instance().addMapLayer(target_geometry_layer, False)
            QgsProject.instance().addMapLayer(target_values_layer, False)
            if uses_layer_name_output:
                QgsProject.instance().addMapLayer(target_uses_layer, False)
            root = QgsProject.instance().layerTreeRoot()
            group_target_file_basename = root.insertGroup(0, target_file_basename)
            group_target_file_basename.addLayer(target_geometry_layer)
            if uses_layer_name_output:
                group_target_file_basename.addLayer(target_uses_layer)
            group_target_file_basename.addLayer(target_values_layer)
        source_file_name = self.sourceLineEdit.text()
        target_file_name = self.targetLineEdit.text()
        self.source_file_name = source_file_name
        self.target_file_ame = target_file_name

    def start_busy(self):
        self.progressBar.setMaximum(0)

    def end_busy(self):
        self.progressBar.setMaximum(1)

    def clip_sisoe_hr_completed(self):
        self.end_busy()
        self.clipSioseHrTask.disconnect()
        self.clipPushButton.setEnabled(True)
        self.close()

    def display_msg_error(self, text):
        msgBox = QMessageBox()
        msgBox.setIcon(QMessageBox.Information)
        # msgBox.setWindowTitle(self.windowTitle)
        msgBox.setTextFormat(Qt.RichText)
        msgBox.setText(text)
        msgBox.exec_()

    def getIsClosed(self):
        return self.is_closed

    def getLastPath(self):
        return self.last_path

    def selectAdministrativeUnit(self):
        administrative_unit_name = self.fieldValueComboBox.currentText()
        if administrative_unit_name == SDefs.CONST_NO_COMBO_SELECT:
            return
        source_file_name = self.sourceLineEdit.text()
        source_file_path = os.path.dirname(source_file_name)
        source_base_name = os.path.basename(source_file_name).split('.', 1)[0]
        administrative_unit_name = administrative_unit_name.replace(' ','_')
        source_base_name += ('_' + administrative_unit_name + '.gpkg')
        target_file_name = os.path.join(source_file_path, source_base_name)
        target_file_name = os.path.normcase(target_file_name)
        self.targetLineEdit.setText(target_file_name)

    def selectClip(self):
        self.progressBar.setValue(0)
        source_file_name = self.sourceLineEdit.text()
        if not source_file_name:
            str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
            str_error += self.tr(u'\n Seleccione el fichero origen')
            self.display_msg_error(str_error)
            return
        polygons_layer_name_output = SDefs.CONST_SIOSE_T_POLIGONOS_LAYER
        values_layer_name_output = SDefs.CONST_SIOSE_T_VALORES_LAYER
        plane_table_layer_name_output = SDefs.CONST_SIOSE_TABLA_PLANA_LAYER
        polygons_plane_table_relation_field_name = SDefs.CONST_SIOSE_SIOSE_CODE
        uses_layer_name_output = None
        combined_layer_name_output = None
        if self.siose_hr_selected:
            only_siose_model_layers = False
            all_siose_model_layers = True
            success, str_siose_hr_id = self.siose_gpkg_tools.getIsSioseHr(source_file_name,
                                                                          only_siose_model_layers,
                                                                          all_siose_model_layers)
            if not success:
                str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                str_error += self.siose_gpkg_tools.getLastError()
                self.display_msg_error(str_error)
                return
            polygons_layer_name_output = SDefs.CONST_SIOSE_HR_T_POLIGONOS_LAYER
            values_layer_name_output = SDefs.CONST_SIOSE_HR_T_VALORES_LAYER
            plane_table_layer_name_output = SDefs.CONST_SIOSE_HR_TABLA_PLANA_LAYER
            polygons_plane_table_relation_field_name = SDefs.CONST_SIOSE_HR_SIOSE_CODE
            uses_layer_name_output = SDefs.CONST_SIOSE_HR_T_USOS_LAYER
            combined_layer_name_output = SDefs.CONST_SIOSE_HR_T_COMBINADA_LAYER
        target_file_name = self.targetLineEdit.text()
        if not target_file_name:
            str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
            str_error += self.tr(u'\n Seleccione el fichero destino')
            self.display_msg_error(str_error)
            return
        administrative_unit_id = None
        if self.from_administrative_unit:
            administrative_unit_name = self.fieldValueComboBox.currentText()
            if administrative_unit_name == SDefs.CONST_NO_COMBO_SELECT:
                str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                str_error += self.tr(u'\n Seleccione el municipio')
                self.display_msg_error(str_error)
                return
            administrative_unit_id = self.administrative_unid_id_by_name[administrative_unit_name]
        if not self.from_administrative_unit:
            ogr_geometries = []
            selection_crs = osr.SpatialReference()
            if self.from_map_canvas:
                map_canvas_extent_wkt = self.iface.mapCanvas().extent().asWktPolygon()
                try:
                    ogr_polygon = ogr.CreateGeometryFromWkt(map_canvas_extent_wkt)
                except Exception as e:
                    str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                    str_error += (', GDAL Error: ' + gdal.GetLastErrorMsg())
                    self.display_msg_error(str_error)
                    return
                ogr_geometries.append(ogr_polygon)
                map_canvas_crs_epsg_code_string = QgsProject.instance().crs().authid()
                try:
                    # map_canvas_crs.ImportFromEPSG(map_canvas_crs_epsg_code)
                    selection_crs.SetFromUserInput(map_canvas_crs_epsg_code_string)
                except Exception as e:
                    str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                    str_error += (', GDAL Error: ' + gdal.GetLastErrorMsg())
                    self.display_msg_error(str_error)
                    return
            else:
                numberOfFeaturesSelected = self.iface.activeLayer().selectedFeatureCount()
                if numberOfFeaturesSelected < 1:
                    str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                    str_error += self.tr(u'\n Seleccione al menos un fenomeno en la capa activa')
                    self.display_msg_error(str_error)
                    return
                selected_layer_crs_epsg_code_string = self.iface.activeLayer().crs().authid()
                try:
                    # map_canvas_crs.ImportFromEPSG(map_canvas_crs_epsg_code)
                    selection_crs.SetFromUserInput(selected_layer_crs_epsg_code_string)
                except Exception as e:
                    str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                    str_error += (', GDAL Error: ' + gdal.GetLastErrorMsg())
                    self.display_msg_error(str_error)
                    return
                for selectedFeature in self.iface.activeLayer().selectedFeatures():
                    selectedFeatureGeometry = selectedFeature.geometry()
                    selectedFeatureGeometryType = selectedFeatureGeometry.wkbType()
                    selectedFeatureGeometryWkt = None
                    if selectedFeatureGeometryType == QgsWkbTypes.Polygon \
                            or selectedFeatureGeometryType == QgsWkbTypes.MultiPolygon:
                        selectedFeatureGeometryWkt = selectedFeatureGeometry.asWkt()
                    else:
                        selectedFeatureGeometryWkt = selectedFeatureGeometry.boundingBox().asWkt()
                    if not selectedFeatureGeometryWkt:
                        continue
                    try:
                        ogr_polygon = ogr.CreateGeometryFromWkt(selectedFeatureGeometryWkt)
                    except Exception as e:
                        str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                        str_error += (', GDAL Error: ' + gdal.GetLastErrorMsg())
                        self.display_msg_error(str_error)
                        return
                    ogr_geometries.append(ogr_polygon)
            driver = ogr.GetDriverByName("ESRI Shapefile")
            if QFile.exists(self.selection_shapefile_name):
                str_aux_error = remove_shapefile(self.selection_shapefile_name)
                if str_aux_error:
                    str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                    str_error += ('\n ' + str_aux_error)
                    self.display_msg_error(str_error)
                    return
            ds = driver.CreateDataSource(self.selection_shapefile_name)
            layer = ds.CreateLayer(SDefs.CONST_CLIP_SIOSE_SELECTION_AUXILIAR_BASE_NAME,
                                   selection_crs, ogr.wkbMultiPolygon)
            idField = ogr.FieldDefn(SDefs.CONST_CLIP_SIOSE_SELECTION_AUXILIAR_FIELD_ID_NAME, ogr.OFTInteger)
            layer.CreateField(idField)
            featureDefn = layer.GetLayerDefn()
            cont = 1
            for ogr_geometry in ogr_geometries:
                feature = ogr.Feature(featureDefn)
                feature.SetGeometry(ogr_geometry)
                feature.SetField(SDefs.CONST_CLIP_SIOSE_SELECTION_AUXILIAR_FIELD_ID_NAME, cont)
                layer.CreateFeature(feature)
                cont = cont + 1
                feature = None
            ds = None
        if QFile.exists(target_file_name):
            if not QFile.remove(target_file_name):
                str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                str_error += self.tr(u'\n No se ha podido borrar el fichero destino existente: ')
                str_error += target_file_name
                self.display_msg_error(str_error)
                return
        if not self.siose_hr_selected:
            if not QFile.copy(self.siose_template, target_file_name):
                str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                str_error += self.tr(u'\n No se ha podido copiar la plantilla en el fichero destino: ')
                str_error += target_file_name
                self.display_msg_error(str_error)
                return
        else:
            if not QFile.copy(self.siose_hr_template, target_file_name):
                str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                str_error += self.tr(u'\n No se ha podido copiar la plantilla en el fichero destino: ')
                str_error += target_file_name
                self.display_msg_error(str_error)
                return
        # crear el vrt
        if QFile.exists(self.selection_vrt_name):
            if not QFile.remove(self.selection_vrt_name):
                str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                str_error += self.tr(u'\n No se ha podido borrar el fichero destino existente: ')
                str_error += self.selection_vrt_name
                self.display_msg_error(str_error)
                return
        vrt_file = open(self.selection_vrt_name, 'w')
        vrt_text = '<' + SDefs.CONST_VRT_FILE_TAG_OGRVRTDATASOURCE + '>\n'
        vrt_file.write(vrt_text)

        if not self.from_administrative_unit:
            vrt_text = '\t' + '<' + SDefs.CONST_VRT_FILE_TAG_OGRVRTLAYER + ' '
            vrt_text += (SDefs.CONST_VRT_FILE_OGRVRTLAYER_ATTRIBUTE_NAME + '=\"'
                         + SDefs.CONST_CLIP_SIOSE_SELECTION_AUXILIAR_BASE_NAME + '\"' + '>\n')
            vrt_file.write(vrt_text)
            vrt_text = '\t\t' + '<' + SDefs.CONST_VRT_FILE_TAG_SRCDATASOURCE + '>'
            vrt_text += self.selection_shapefile_name
            vrt_text += ('</' + SDefs.CONST_VRT_FILE_TAG_SRCDATASOURCE + '>\n')
            vrt_file.write(vrt_text)
            vrt_text = '\t\t' + '<' + SDefs.CONST_VRT_FILE_TAG_SRCLAYER + '>'
            vrt_text += SDefs.CONST_CLIP_SIOSE_SELECTION_AUXILIAR_BASE_NAME
            vrt_text += ('</' + SDefs.CONST_VRT_FILE_TAG_SRCLAYER + '>\n')
            vrt_file.write(vrt_text)
            vrt_text = '\t' + '</' + SDefs.CONST_VRT_FILE_TAG_OGRVRTLAYER + '>\n'
            vrt_file.write(vrt_text)

        vrt_text = '\t' + '<' + SDefs.CONST_VRT_FILE_TAG_OGRVRTLAYER + ' '
        vrt_text += (SDefs.CONST_VRT_FILE_OGRVRTLAYER_ATTRIBUTE_NAME + '=\"'
                     + SDefs.CONST_SIOSE_T_POLIGONOS_INPUT_NAME + '\"' + '>\n')
        vrt_file.write(vrt_text)
        vrt_text = '\t\t' + '<' + SDefs.CONST_VRT_FILE_TAG_SRCDATASOURCE + '>'
        vrt_text += source_file_name
        vrt_text += ('</' + SDefs.CONST_VRT_FILE_TAG_SRCDATASOURCE + '>\n')
        vrt_file.write(vrt_text)
        vrt_text = '\t\t' + '<' + SDefs.CONST_VRT_FILE_TAG_SRCLAYER + '>'
        if not self.siose_hr_selected:
            vrt_text += SDefs.CONST_SIOSE_T_POLIGONOS_LAYER
        else:
            vrt_text += 'SAR_' + str_siose_hr_id + '_' + SDefs.CONST_SIOSE_T_POLIGONOS_LAYER
        vrt_text += ('</' + SDefs.CONST_VRT_FILE_TAG_SRCLAYER + '>\n')
        vrt_file.write(vrt_text)
        vrt_text = '\t' + '</' + SDefs.CONST_VRT_FILE_TAG_OGRVRTLAYER + '>\n'
        vrt_file.write(vrt_text)

        vrt_text = '\t' + '<' + SDefs.CONST_VRT_FILE_TAG_OGRVRTLAYER + ' '
        vrt_text += (SDefs.CONST_VRT_FILE_OGRVRTLAYER_ATTRIBUTE_NAME + '=\"'
                     + SDefs.CONST_SIOSE_T_VALORES_INPUT_NAME + '\"' + '>\n')
        vrt_file.write(vrt_text)
        vrt_text = '\t\t' + '<' + SDefs.CONST_VRT_FILE_TAG_SRCDATASOURCE + '>'
        vrt_text += source_file_name
        vrt_text += ('</' + SDefs.CONST_VRT_FILE_TAG_SRCDATASOURCE + '>\n')
        vrt_file.write(vrt_text)
        vrt_text = '\t\t' + '<' + SDefs.CONST_VRT_FILE_TAG_SRCLAYER + '>'
        if not self.siose_hr_selected:
            vrt_text += SDefs.CONST_SIOSE_T_VALORES_LAYER
        else:
            vrt_text += 'SAR_' + str_siose_hr_id + '_' + SDefs.CONST_SIOSE_T_VALORES_LAYER
        vrt_text += ('</' + SDefs.CONST_VRT_FILE_TAG_SRCLAYER + '>\n')
        vrt_file.write(vrt_text)
        vrt_text = '\t' + '</' + SDefs.CONST_VRT_FILE_TAG_OGRVRTLAYER + '>\n'
        vrt_file.write(vrt_text)

        if self.siose_hr_selected:
            vrt_text = '\t' + '<' + SDefs.CONST_VRT_FILE_TAG_OGRVRTLAYER + ' '
            vrt_text += (SDefs.CONST_VRT_FILE_OGRVRTLAYER_ATTRIBUTE_NAME + '=\"'
                         + SDefs.CONST_SIOSE_T_USOS_INPUT_NAME + '\"' + '>\n')
            vrt_file.write(vrt_text)
            vrt_text = '\t\t' + '<' + SDefs.CONST_VRT_FILE_TAG_SRCDATASOURCE + '>'
            vrt_text += source_file_name
            vrt_text += ('</' + SDefs.CONST_VRT_FILE_TAG_SRCDATASOURCE + '>\n')
            vrt_file.write(vrt_text)
            vrt_text = '\t\t' + '<' + SDefs.CONST_VRT_FILE_TAG_SRCLAYER + '>'
            vrt_text += 'SAR_' + str_siose_hr_id + '_' + SDefs.CONST_SIOSE_T_USOS_LAYER
            vrt_text += ('</' + SDefs.CONST_VRT_FILE_TAG_SRCLAYER + '>\n')
            vrt_file.write(vrt_text)
            vrt_text = '\t' + '</' + SDefs.CONST_VRT_FILE_TAG_OGRVRTLAYER + '>\n'
            vrt_file.write(vrt_text)

        if self.siose_hr_selected:
            vrt_text = '\t' + '<' + SDefs.CONST_VRT_FILE_TAG_OGRVRTLAYER + ' '
            vrt_text += (SDefs.CONST_VRT_FILE_OGRVRTLAYER_ATTRIBUTE_NAME + '=\"'
                         + SDefs.CONST_SIOSE_T_COMBINADA_INPUT_NAME + '\"' + '>\n')
            vrt_file.write(vrt_text)
            vrt_text = '\t\t' + '<' + SDefs.CONST_VRT_FILE_TAG_SRCDATASOURCE + '>'
            vrt_text += source_file_name
            vrt_text += ('</' + SDefs.CONST_VRT_FILE_TAG_SRCDATASOURCE + '>\n')
            vrt_file.write(vrt_text)
            vrt_text = '\t\t' + '<' + SDefs.CONST_VRT_FILE_TAG_SRCLAYER + '>'
            vrt_text += 'SAR_' + str_siose_hr_id + '_' + SDefs.CONST_SIOSE_T_COMBINADA_LAYER
            vrt_text += ('</' + SDefs.CONST_VRT_FILE_TAG_SRCLAYER + '>\n')
            vrt_file.write(vrt_text)
            vrt_text = '\t' + '</' + SDefs.CONST_VRT_FILE_TAG_OGRVRTLAYER + '>\n'
            vrt_file.write(vrt_text)

        vrt_text = '\t' + '<' + SDefs.CONST_VRT_FILE_TAG_OGRVRTLAYER + ' '
        vrt_text += (SDefs.CONST_VRT_FILE_OGRVRTLAYER_ATTRIBUTE_NAME + '=\"'
                     + SDefs.CONST_SIOSE_TABLA_PLANA_INPUT_NAME + '\"' + '>\n')
        vrt_file.write(vrt_text)
        vrt_text = '\t\t' + '<' + SDefs.CONST_VRT_FILE_TAG_SRCDATASOURCE + '>'
        vrt_text += source_file_name
        vrt_text += ('</' + SDefs.CONST_VRT_FILE_TAG_SRCDATASOURCE + '>\n')
        vrt_file.write(vrt_text)
        vrt_text = '\t\t' + '<' + SDefs.CONST_VRT_FILE_TAG_SRCLAYER + '>'
        if not self.siose_hr_selected:
            vrt_text += SDefs.CONST_SIOSE_TABLA_PLANA_LAYER
        else:
            vrt_text += 'SAR_' + str_siose_hr_id + '_' + SDefs.CONST_SIOSE_TABLA_PLANA_LAYER
        vrt_text += ('</' + SDefs.CONST_VRT_FILE_TAG_SRCLAYER + '>\n')
        vrt_file.write(vrt_text)
        vrt_text = '\t' + '</' + SDefs.CONST_VRT_FILE_TAG_OGRVRTLAYER + '>\n'
        vrt_file.write(vrt_text)

        vrt_text = '\t' + '<' + SDefs.CONST_VRT_FILE_TAG_OGRVRTLAYER + ' '
        vrt_text += (SDefs.CONST_VRT_FILE_OGRVRTLAYER_ATTRIBUTE_NAME + '=\"'
                     + SDefs.CONST_SIOSE_T_POLIGONOS_OUTPUT_NAME + '\"' + '>\n')
        vrt_file.write(vrt_text)
        vrt_text = '\t\t' + '<' + SDefs.CONST_VRT_FILE_TAG_SRCDATASOURCE + '>'
        vrt_text += target_file_name
        vrt_text += ('</' + SDefs.CONST_VRT_FILE_TAG_SRCDATASOURCE + '>\n')
        vrt_file.write(vrt_text)
        vrt_text = '\t\t' + '<' + SDefs.CONST_VRT_FILE_TAG_SRCLAYER + '>'
        if not self.siose_hr_selected:
            vrt_text += SDefs.CONST_SIOSE_T_POLIGONOS_LAYER
        else:
            vrt_text += SDefs.CONST_SIOSE_HR_T_POLIGONOS_LAYER
        vrt_text += ('</' + SDefs.CONST_VRT_FILE_TAG_SRCLAYER + '>\n')
        vrt_file.write(vrt_text)
        vrt_text = '\t' + '</' + SDefs.CONST_VRT_FILE_TAG_OGRVRTLAYER + '>\n'
        vrt_file.write(vrt_text)

        vrt_text = '</' + SDefs.CONST_VRT_FILE_TAG_OGRVRTDATASOURCE + '>'
        vrt_file.write(vrt_text)
        vrt_file.close()

        self.source_file_name = source_file_name
        self.target_file_ame = target_file_name

        self.iface.messageBar().pushMessage("SIOSE Tools", ("El proceso de recorte puede durar bastantes minutos"), level=Qgis.Info)
        self.iface.mainWindow().repaint()
        self.clipPushButton.setEnabled(False)
        self.start_busy()
        self.clipSioseHrTask = ClipSioseHrTask(target_file_name,
                                               administrative_unit_id,
                                               polygons_layer_name_output,
                                               values_layer_name_output,
                                               uses_layer_name_output,
                                               combined_layer_name_output,
                                               plane_table_layer_name_output,
                                               self.selection_vrt_name,
                                               polygons_plane_table_relation_field_name,
                                               self.from_administrative_unit)
        self.clipSioseHrTask.result.connect(self.add_map_layer)
        self.clipSioseHrTask.taskCompleted.connect(self.clip_sisoe_hr_completed)
        QgsApplication.taskManager().addTask(self.clipSioseHrTask)

    def selectSource(self):
        self.administrative_unid_id_by_name = {}
        old_source = self.sourceLineEdit.text()
        title = self.tr(u'Seleccione GPKG origen (.gpkg)')
        filters = "GPKG files (*.gpkg)"
        fileName, _ = QFileDialog.getOpenFileName(self, title, self.last_path, filters)
        if fileName:
            if not self.siose_gpkg_tools.check_model(fileName, self.siose_hr_selected, True, True):
                str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                str_error = str_error + '\n'
                str_error = str_error + self.siose_gpkg_tools.getLastError()
                self.display_msg_error(str_error)
                return
            if self.siose_hr_selected and self.from_administrative_unit:
                self.iface.mainWindow().repaint()
                self.fieldValueComboBox.setEnabled(False)
                self.fieldValueComboBox.clear()
                success, id = self.siose_gpkg_tools.getIsSioseHr(fileName, True, True)
                if not success:
                    str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                    str_error = str_error + '\n'
                    str_error = str_error + self.siose_gpkg_tools.getLastError()
                    self.display_msg_error(str_error)
                    return
                self.iface.messageBar().pushMessage("SIOSE Tools", "Leyendo unidades administrativas", level=Qgis.Info)
                self.iface.mainWindow().repaint()
                polygons_layer_name = 'SAR_' + id + '_' + SDefs.CONST_SIOSE_T_POLIGONOS_LAYER
                fieldsNames = [SDefs.CONST_SIOSE_HR_ADMINISTRATIVE_UNIT_FIELD_NAME,
                               SDefs.CONST_SIOSE_HR_ADMINISTRATIVE_UNIT_FIELD_ID]
                success, values = self.siose_gpkg_tools.getFieldsValuesUsingOgr(fileName,
                                                                                polygons_layer_name,
                                                                                fieldsNames,
                                                                                True)
                if not success:
                    str_error = 'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name
                    str_error = str_error + '\n'
                    str_error = str_error + self.siose_gpkg_tools.getLastError()
                    self.display_msg_error(str_error)
                    return
                self.fieldValueComboBox.currentIndexChanged.disconnect(self.selectAdministrativeUnit)
                self.fieldValueComboBox.addItem(SDefs.CONST_NO_COMBO_SELECT)
                administrative_units_names = values[SDefs.CONST_SIOSE_HR_ADMINISTRATIVE_UNIT_FIELD_NAME]
                administrative_units_ids = values[SDefs.CONST_SIOSE_HR_ADMINISTRATIVE_UNIT_FIELD_ID]
                for i in range(len(administrative_units_names)):
                    administrative_unit_name = administrative_units_names[i]
                    administrative_unit_id = administrative_units_ids[i]
                    self.administrative_unid_id_by_name[administrative_unit_name] = administrative_unit_id
                for administrative_unit in self.administrative_unid_id_by_name.keys():
                    self.fieldValueComboBox.addItem(administrative_unit)
                self.fieldValueComboBox.setEnabled(True)
                self.fieldValueComboBox.currentIndexChanged.connect(self.selectAdministrativeUnit)
                self.iface.messageBar().clearWidgets()
            fileInfo = QFileInfo(fileName)
            self.last_path = fileInfo.absolutePath()
            self.settings.setValue("last_path", self.last_path)
            self.settings.sync()
            self.sourceLineEdit.setText(fileName)

    def selectTarget(self):
        old_source = self.targetLineEdit.text()
        title = self.tr(u'Seleccione GPKG destino (.gpkg)')
        filters = "GPKG files (*.gpkg)"
        fileName, _ = QFileDialog.getSaveFileName(self, title, self.last_path, filters)
        if fileName:
            fileInfo = QFileInfo(fileName)
            self.last_path = fileInfo.absolutePath()
            self.settings.setValue("last_path", self.last_path)
            self.settings.sync()
            self.targetLineEdit.setText(fileName)
