# -*- coding: utf-8 -*-
"""
/***************************************************************************
 SIOSETools
                                 A QGIS plugin
 Este plugin permite consultar la cartografía SIOSE del IGN.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-10-18
        git sha              : $Format:%H$
        copyright            : (C) 2023 by IGN-UCLM
        email                : david.hernadez@uclm.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt, QFileInfo, QDir
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QMessageBox, QToolButton
from qgis.PyQt.QtWidgets import QMessageBox,QFileDialog,QTabWidget,QInputDialog,QLineEdit
from qgis.PyQt.QtCore import QSettings, QTranslator, qVersion, QCoreApplication, QFileInfo, QDir, QObject, QFile
from osgeo import gdal, osr, ogr
from qgis.core import QgsApplication, QgsDataSourceUri, Qgis

import os, sys
# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
import os.path
from .clip_siose_select_type_dialog import ClipSioseSelectTypeDialog
from .clip_siose_dialog import ClipSioseDialog
from . import siose_tools_definitions as SDefs
# from .query_coverages_dialog import QueryCoveragesDialog
from .query_coverages_or_uses_dialog import QueryCoveragesOrUsesDialog
from .siose_gpkg_tools import SioseGpkgTools

pluginsPath = QFileInfo(QgsApplication.qgisUserDatabaseFilePath()).path()
pluginPath = os.path.dirname(os.path.realpath(__file__))
pluginPath = os.path.join(pluginsPath, pluginPath)


# sys.path.append("C:\Program Files\JetBrains\PyCharm 2023.2\debug-eggs\pydevd-pycharm.egg") # dhl
# import pydevd

class GdalErrorHandler(object):
    def __init__(self):
        self.err_level = gdal.CE_None
        self.err_no = 0
        self.err_msg = ''

    def handler(self, err_level, err_no, err_msg):
        self.err_level = err_level
        self.err_no = err_no
        self.err_msg = err_msg

class SIOSETools:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """

        # pydevd.settrace('localhost',port=54200,stdoutToServer=True,stderrToServer=True)

        self.gdal_error_handler = GdalErrorHandler()
        gdal.PushErrorHandler(self.gdal_error_handler.handler)
        gdal.UseExceptions()  # Exceptions will get raised on anything >= gdal.CE_Failure
        assert self.gdal_error_handler.err_level == gdal.CE_None, 'the error level starts at 0'

        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'SIOSETools_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&SIOSE Tools')
        self.toolbar = self.iface.addToolBar(u'SIOSE Tools')
        self.toolbar.setObjectName(u'SIOSE Tools')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

        self.using_siose_hr = False

        self.path_plugin = pluginPath
        self.temp_path = os.path.join(pluginPath, SDefs.CONST_TEMPORAL_PATH)
        if not QDir.current().exists(self.temp_path):
            QDir.current().mkpath(self.temp_path)
        path_file_qsettings = self.path_plugin + '/' + SDefs.CONST_SETTINGS_FILE_NAME
        self.settings = QSettings(path_file_qsettings, QSettings.IniFormat)

        self.templates_path = os.path.join(self.path_plugin, SDefs.CONST_TEMPLATES_PATH)
        if not QDir.current().exists(self.templates_path):
            raise ValueError(self.tr(u'No se encuentra la carpeta de plantillas:\n') + self.templates_path)
        self.siose_template = os.path.join(self.templates_path, SDefs.CONST_SIOSE_TEMPLATE)
        if not QFile.exists(self.siose_template):
            raise ValueError(self.tr(u'No se encuentra el fichero plantilla de SIOSE:\n') + self.siose_template)
        self.siose_hr_template = os.path.join(self.templates_path, SDefs.CONST_SIOSE_HR_TEMPLATE)
        if not QFile.exists(self.siose_hr_template):
            raise ValueError(self.tr(u'No se encuentra el fichero plantilla de SIOSE AR:\n') + self.siose_hr_template)

        auxDir = QDir.current()
        self.last_path = self.settings.value("last_path")
        if not self.last_path or not auxDir.exists(self.last_path):
            self.last_path = QDir.currentPath()
            self.settings.setValue("last_path", self.last_path)
            self.settings.sync()

        self.siose_layer_names = None
        self.siose_hr_layer_names = None
        self.set_layer_names()
        self.load_siose_dialog_from_map_canvas = None
        self.load_siose_dialog_from_selected_features = None
        self.load_siose_hr_dialog_from_administrative_unit = None
        self.load_siose_hr_dialog_from_map_canvas = None
        self.load_siose_hr_dialog_from_selected_features = None
        self.query_1_dialog = None
        self.query_2_dialog = None
        self.query_3_dialog = None
        self.query_4_dialog = None
        self.query_coverages_dialog = None
        self.query_uses_dialog = None
        self.siose_gpkg_tools = SioseGpkgTools(self.iface, self.gdal_error_handler,
                                               self.siose_layer_names, self.siose_hr_layer_names,
                                               self.templates_path)

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('SIOSETools', message)

    def add_action(
            self,
            icon_path,
            text,
            callback,
            enabled_flag=True,
            add_to_menu=True,
            add_to_toolbar=True,
            status_tip=None,
            whats_this=None,
            parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            # self.iface.addToolBarIcon(action)
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def close_load_siose_dialog_from_map_canvas(self, event):
        self.load_siose_dialog_from_map_canvas = None

    def close_load_siose_dialog_from_selected_features(self, event):
        self.load_siose_dialog_from_selected_features = None

    def close_load_siose_hr_dialog_from_administrative_unit(self, event):
        self.load_siose_hr_dialog_from_administrative_unit = None

    def close_load_siose_hr_dialog_from_map_canvas(self, event):
        self.load_siose_hr_dialog_from_map_canvas = None

    def close_load_siose_hr_dialog_from_selected_features(self, event):
        self.load_siose_hr_dialog_from_selected_features = None

    def close_query_1_dialog(self, event):
        self.query_1_dialog.disconnetMapCanvasLayers()
        self.query_1_dialog = None

    def close_query_2_dialog(self, event):
        self.query_2_dialog.disconnetMapCanvasLayers()
        self.query_2_dialog = None

    def close_query_3_dialog(self, event):
        self.query_3_dialog.disconnetMapCanvasLayers()
        self.query_3_dialog = None

    def close_query_4_dialog(self, event):
        self.query_4_dialog.disconnetMapCanvasLayers()
        self.query_4_dialog = None

    def close_query_coverages_dialog(self, event):
        self.query_coverages_dialog.disconnetMapCanvasLayers()
        self.query_coverages_dialog = None

    def close_query_uses_dialog(self, event):
        self.query_uses_dialog.disconnetMapCanvasLayers()
        self.query_uses_dialog = None

    def createToolButton(self, parent, text):
        button = QToolButton(parent)
        button.setObjectName(text)
        button.setToolButtonStyle(Qt.ToolButtonIconOnly)
        button.setPopupMode(QToolButton.MenuButtonPopup)
        parent.addWidget(button)
        return button

    def display_msg_error(self, text):
        msgBox = QMessageBox()
        msgBox.setIcon(QMessageBox.Information)
        # msgBox.setWindowTitle(self.windowTitle)
        msgBox.setTextFormat(Qt.RichText)
        msgBox.setText(text)
        msgBox.exec_()

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        # icon_path = ':/plugins/siose_tools/icon.png'
        # self.add_action(
        #     icon_path,
        #     text=self.tr(u'SIOSE Tools'),
        #     callback=self.run,
        #     parent=self.iface.mainWindow())
        #
        # # will be set False in run()
        # self.first_start = True

        iconPath = QIcon(':/plugins/siose_tools/icons/st_01_ayuda.png')
        self.qaction_info = self.add_action(
            iconPath,
            text=self.tr(u'Información SIOSE Tools'),
            callback=self.tool_info,
            parent=self.iface.mainWindow())

        iconPath = QIcon(':/plugins/siose_tools/icons/st_02_seleccion.png')
        self.qaction_clipSelectType = self.add_action(
            iconPath,
            text=self.tr(u'Recortar SIOSE / SIOSE AR'),
            callback=self.tool_clip_select_type,
            parent=self.iface.mainWindow())

        # iconPath = QIcon(':/plugins/siose_tools/icons/save1.png')
        # self.qaction_loadFromMapCanvas_0 = self.add_action(
        #     iconPath,
        #     text=self.tr(u'Recortar SIOSE de la zona visible'),
        #     callback=self.tool_load_siose_from_map_canvas,
        #     parent=self.iface.mainWindow(),
        #     add_to_toolbar=False)
        #
        # iconPath = QIcon(':/plugins/siose_tools/icons/save2.png')
        # self.qaction_loadFromSelectedFeatures_0 = self.add_action(
        #     iconPath,
        #     text=self.tr(u'Recortar SIOSE de la zona seleccionada'),
        #     callback=self.tool_load_siose_from_selected_features,
        #     parent=self.iface.mainWindow(),
        #     add_to_toolbar=False)
        #
        # iconPath = QIcon(':/plugins/siose_tools/icons/save3.png')
        # self.qaction_loadFromAdministrativeUnit_1 = self.add_action(
        #     iconPath,
        #     text=self.tr(u'Recortar SIOSE AR de un municipio'),
        #     callback=self.tool_load_siose_hr_from_administrative_unit,
        #     parent=self.iface.mainWindow(),
        #     add_to_toolbar=False)
        #
        # self.loadSelectionButton_0 = self.createToolButton(self.toolbar, u'loadSelectionButton0')
        # self.loadSelectionButton_0.addAction(self.qaction_loadFromMapCanvas_0)
        # self.loadSelectionButton_0.addAction(self.qaction_loadFromSelectedFeatures_0)
        # self.loadSelectionButton_0.addAction(self.qaction_loadFromAdministrativeUnit_1)
        # self.loadSelectionButton_0.setDefaultAction(self.qaction_loadFromMapCanvas_0)

        iconPath = QIcon(':/plugins/siose_tools/icons/st_03_coberturas.png')
        self.qaction_info = self.add_action(
            iconPath,
            text=self.tr(u'Consultar coberturas'),
            callback=self.tool_query_coverages,
            parent=self.iface.mainWindow())

        # iconPath = QIcon(':/plugins/siose_tools/icons/view1.png')
        # self.qaction_info = self.add_action(
        #     iconPath,
        #     text=self.tr(u'Consultar coberturas'),
        #     callback=self.tool_query_coverages,
        #     parent=self.iface.mainWindow(),
        #     add_to_toolbar=False)
        #
        # iconPath = QIcon(':/plugins/siose_tools/icons/view2.png')
        # self.qaction_viewer1 = self.add_action(
        #     iconPath,
        #     text=self.tr(u'Consultar zonas de suelo sellado'),
        #     callback=self.tool_query_1,
        #     parent=self.iface.mainWindow(),
        #     add_to_toolbar=False)
        #
        # iconPath = QIcon(':/plugins/siose_tools/icons/view3.png')
        # self.qaction_viewer2 = self.add_action(
        #     iconPath,
        #     text=self.tr(u'Consultar Fracción de Cabida Cubierta arbórea (FCC)'),
        #     callback=self.tool_query_2,
        #     parent=self.iface.mainWindow(),
        #     add_to_toolbar=False)
        #
        # iconPath = QIcon(':/plugins/siose_tools/icons/view4.png')
        # self.qaction_viewer3 = self.add_action(
        #     iconPath,
        #     text=self.tr(u'Consultar cultivos leñosos'),
        #     callback=self.tool_query_3,
        #     parent=self.iface.mainWindow(),
        #     add_to_toolbar=False)
        #
        # iconPath = QIcon(':/plugins/siose_tools/icons/view5.png')
        # self.qaction_viewer4 = self.add_action(
        #     iconPath,
        #     text=self.tr(u'Consultar zonas de agua'),
        #     callback=self.tool_query_4,
        #     parent=self.iface.mainWindow(),
        #     add_to_toolbar=False)

        # self.viewSelectionButton = self.createToolButton(self.toolbar, u'viewSelectionButton')
        # self.viewSelectionButton.addAction(self.qaction_info)
        # self.viewSelectionButton.addAction(self.qaction_viewer1)
        # self.viewSelectionButton.addAction(self.qaction_viewer2)
        # self.viewSelectionButton.addAction(self.qaction_viewer3)
        # self.viewSelectionButton.addAction(self.qaction_viewer4)
        # self.viewSelectionButton.setDefaultAction(self.qaction_info)

        iconPath = QIcon(':/plugins/siose_tools/icons/st_04_usos.png')
        self.qaction_info = self.add_action(
            iconPath,
            text = self.tr(u'Consultar usos'),
            callback = self.tool_query_uses,
            parent = self.iface.mainWindow())

        self.load_siose_dialog_from_map_canvas = None
        self.load_siose_dialog_from_selected_features = None
        self.load_siose_hr_dialog_from_map_canvas = None
        self.load_siose_hr_dialog_from_selected_features = None
        self.load_siose_hr_dialog_from_administrative_unit = None

    def set_layer_names(self):
        function_name = 'siose_tools: set_layer_names'
        try:
            self.siose_layer_names = [l.GetName() for l in ogr.Open(self.siose_template)]
        except Exception as e:
            assert self.gdal_error_handler.err_level == gdal.CE_Failure, (
                    'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name +
                    self.tr(u', error en la apertura del fichero: ') + self.siose_template)
        try:
            self.siose_hr_layer_names = \
                [l.GetName().removeprefix(
                    SDefs.CONST_SIOSE_HR_LAYER_NAMES_PREFIX) for l in ogr.Open(self.siose_hr_template)]
        except Exception as e:
            assert self.gdal_error_handler.err_level == gdal.CE_Failure, (
                    'Clase: ' + type(self).__name__ + ', funcion: ' + sys._getframe().f_code.co_name +
                    self.tr(u', error en la apertura del fichero: ') + self.siose_hr_template)

    def tool_info(self):
        pathInfoFile = os.path.normcase(os.path.join(self.plugin_dir,
                                                     'help',
                                                     'SIOSETools_Manual.pdf'))
        os.startfile(pathInfoFile)

    def tool_clip_select_type(self):
        clip_select_type_dialog = ClipSioseSelectTypeDialog()
        clip_select_type_dialog.exec_()
        if not SDefs.select_clip:
            return
        if SDefs.clip_type == SDefs.CONST_CLIP_TYPE_SIOSEHR_ADMINISTRATIVE_UNIT:
            self.tool_load_siose_hr_from_administrative_unit()
        elif SDefs.clip_type == SDefs.CONST_CLIP_TYPE_SIOSE_MAP_CANVAS:
            self.tool_load_siose_from_map_canvas()
        elif SDefs.clip_type == SDefs.CONST_CLIP_TYPE_SIOSE_SELECTED_FEATURES:
            self.tool_load_siose_from_selected_features()

    # def tool_query_1(self):
    #     if not self.query_1_dialog:
    #         query_coverages = True
    #         coverages_ids_selected_tag = SDefs.CONST_COVERAGES_CATEGORY_SOIL
    #         self.query_1_dialog = QueryCoveragesOrUsesDialog(self.iface,
    #                                                          self.gdal_error_handler,
    #                                                          self.siose_gpkg_tools,
    #                                                          self.settings,
    #                                                          self.last_path,
    #                                                          query_coverages,
    #                                                          coverages_ids_selected_tag)
    #         self.query_1_dialog.closeEvent = self.close_query_1_dialog
    #         if self.query_1_dialog.getNumberOfValidSources() == 0:
    #             self.query_1_dialog = None
    #             return
    #         self.query_1_dialog.show()  # show the dialog
    #         result = self.query_1_dialog.exec_()  # Run the dialog
    #     else:
    #         self.query_1_dialog.activateWindow()
    #
    # def tool_query_2(self):
    #     if not self.query_2_dialog:
    #         query_coverages = True
    #         coverages_ids_selected_tag = SDefs.CONST_COVERAGES_CATEGORY_FCC
    #         self.query_2_dialog = QueryCoveragesOrUsesDialog(self.iface,
    #                                                          self.gdal_error_handler,
    #                                                          self.siose_gpkg_tools,
    #                                                          self.settings,
    #                                                          self.last_path,
    #                                                          query_coverages,
    #                                                          coverages_ids_selected_tag)
    #         self.query_2_dialog.closeEvent = self.close_query_2_dialog
    #         if self.query_2_dialog.getNumberOfValidSources() == 0:
    #             self.query_2_dialog = None
    #             return
    #         self.query_2_dialog.show()  # show the dialog
    #         result = self.query_2_dialog.exec_()  # Run the dialog
    #     else:
    #         self.query_2_dialog.activateWindow()
    #
    # def tool_query_3(self):
    #     if not self.query_3_dialog:
    #         query_coverages = True
    #         coverages_ids_selected_tag = SDefs.CONST_COVERAGES_CATEGORY_CROPS
    #         self.query_3_dialog = QueryCoveragesOrUsesDialog(self.iface,
    #                                                          self.gdal_error_handler,
    #                                                          self.siose_gpkg_tools,
    #                                                          self.settings,
    #                                                          self.last_path,
    #                                                          query_coverages,
    #                                                          coverages_ids_selected_tag)
    #         self.query_3_dialog.closeEvent = self.close_query_3_dialog
    #         if self.query_3_dialog.getNumberOfValidSources() == 0:
    #             self.query_3_dialog = None
    #             return
    #         self.query_3_dialog.show()  # show the dialog
    #         result = self.query_3_dialog.exec_()  # Run the dialog
    #     else:
    #         self.query_3_dialog.activateWindow()
    #
    # def tool_query_4(self):
    #     if not self.query_4_dialog:
    #         query_coverages = True
    #         coverages_ids_selected_tag = SDefs.CONST_COVERAGES_CATEGORY_WATER
    #         self.query_4_dialog = QueryCoveragesOrUsesDialog(self.iface,
    #                                                          self.gdal_error_handler,
    #                                                          self.siose_gpkg_tools,
    #                                                          self.settings,
    #                                                          self.last_path,
    #                                                          query_coverages,
    #                                                          coverages_ids_selected_tag)
    #         self.query_4_dialog.closeEvent = self.close_query_4_dialog
    #         if self.query_4_dialog.getNumberOfValidSources() == 0:
    #             self.query_4_dialog = None
    #             return
    #         self.query_4_dialog.show()  # show the dialog
    #         result = self.query_4_dialog.exec_()  # Run the dialog
    #     else:
    #         self.query_4_dialog.activateWindow()

    def tool_query_coverages(self):
        if not self.query_coverages_dialog:
            query_coverages = True
            self.query_coverages_dialog = QueryCoveragesOrUsesDialog(self.iface,
                                                                     self.gdal_error_handler,
                                                                     self.siose_gpkg_tools,
                                                                     self.settings,
                                                                     self.last_path,
                                                                     self.path_plugin,
                                                                     query_coverages)
            self.query_coverages_dialog.closeEvent = self.close_query_coverages_dialog
            if self.query_coverages_dialog.getNumberOfValidSources() == 0:
                self.query_coverages_dialog = None
                return
            self.query_coverages_dialog.show()  # show the dialog
            result = self.query_coverages_dialog.exec_()  # Run the dialog
        else:
            self.query_coverages_dialog.activateWindow()

    def tool_query_uses(self):
        if not self.query_uses_dialog:
            query_coverages = False
            self.query_uses_dialog = QueryCoveragesOrUsesDialog(self.iface,
                                                                self.gdal_error_handler,
                                                                self.siose_gpkg_tools,
                                                                self.settings,
                                                                self.last_path,
                                                                self.path_plugin,
                                                                query_coverages)
            self.query_uses_dialog.closeEvent = self.close_query_uses_dialog
            if self.query_uses_dialog.getNumberOfValidSources() == 0:
                self.query_uses_dialog = None
                return
            self.query_uses_dialog.show()  # show the dialog
            result = self.query_uses_dialog.exec_()  # Run the dialog
        else:
            self.query_uses_dialog.activateWindow()

    def tool_statistics(self):
        # QMessageBox.informacion(self.iface.mainWindow(),
        #                         c.APPLICATION_NAME,
        #                         'He pulsado algún botón de cálculo de estadísticas')
        yo = 1

    def tool_load_siose_from_map_canvas(self):
        siose_hr_selected = False
        from_map_canvas = True
        from_selected_features = False
        from_administrative_unit = False
        if not self.load_siose_dialog_from_map_canvas:
            self.load_siose_dialog_from_map_canvas = ClipSioseDialog(self.iface,
                                                                     self.gdal_error_handler,
                                                                     self.siose_gpkg_tools,
                                                                     self.settings,
                                                                     self.last_path,
                                                                     siose_hr_selected,
                                                                     from_map_canvas,
                                                                     from_selected_features,
                                                                     from_administrative_unit,
                                                                     self.siose_layer_names,
                                                                     self.siose_hr_layer_names,
                                                                     self.siose_template,
                                                                     self.siose_hr_template,
                                                                     self.temp_path)
            self.load_siose_dialog_from_map_canvas.closeEvent = self.close_load_siose_dialog_from_map_canvas
            self.load_siose_dialog_from_map_canvas.show()  # show the dialog
            result = self.load_siose_dialog_from_map_canvas.exec_()  # Run the dialog
        else:
            self.load_siose_dialog_from_map_canvas.activateWindow()

    def tool_load_siose_from_selected_features(self):
        siose_hr_selected = False
        from_map_canvas = False
        from_selected_features = True
        from_administrative_unit = False
        if not self.load_siose_dialog_from_selected_features:
            self.load_siose_dialog_from_selected_features = ClipSioseDialog(self.iface,
                                                                            self.gdal_error_handler,
                                                                            self.siose_gpkg_tools,
                                                                            self.settings,
                                                                            self.last_path,
                                                                            siose_hr_selected,
                                                                            from_map_canvas,
                                                                            from_selected_features,
                                                                            from_administrative_unit,
                                                                            self.siose_layer_names,
                                                                            self.siose_hr_layer_names,
                                                                            self.siose_template,
                                                                            self.siose_hr_template,
                                                                            self.temp_path)
            self.load_siose_dialog_from_selected_features.closeEvent = (
                self.close_load_siose_dialog_from_selected_features)
            self.load_siose_dialog_from_selected_features.show()  # show the dialog
            result = self.load_siose_dialog_from_selected_features.exec_()  # Run the dialog
        else:
            self.load_siose_dialog_from_selected_features.activateWindow()

    def tool_load_siose_hr_from_administrative_unit(self):
        siose_hr_selected = True
        from_map_canvas = False
        from_selected_features = False
        from_administrative_unit = True
        if not self.load_siose_hr_dialog_from_administrative_unit:
            self.load_siose_hr_dialog_from_administrative_unit = ClipSioseDialog(self.iface,
                                                                                 self.gdal_error_handler,
                                                                                 self.siose_gpkg_tools,
                                                                                 self.settings,
                                                                                 self.last_path,
                                                                                 siose_hr_selected,
                                                                                 from_map_canvas,
                                                                                 from_selected_features,
                                                                                 from_administrative_unit,
                                                                                 self.siose_layer_names,
                                                                                 self.siose_hr_layer_names,
                                                                                 self.siose_template,
                                                                                 self.siose_hr_template,
                                                                                 self.temp_path)
            self.load_siose_hr_dialog_from_administrative_unit.closeEvent = (
                self.close_load_siose_hr_dialog_from_administrative_unit)
            self.load_siose_hr_dialog_from_administrative_unit.show()  # show the dialog
            result = self.load_siose_hr_dialog_from_administrative_unit.exec_()  # Run the dialog
        else:
            self.load_siose_hr_dialog_from_administrative_unit.activateWindow()

    def tool_load_siose_hr_from_map_canvas(self):
        siose_hr_selected = True
        from_map_canvas = True
        from_selected_features = False
        from_administrative_unit = False
        if not self.load_siose_hr_dialog_from_map_canvas:
            self.load_siose_hr_dialog_from_map_canvas = ClipSioseDialog(self.iface,
                                                                        self.gdal_error_handler,
                                                                        self.siose_gpkg_tools,
                                                                        self.settings,
                                                                        self.last_path,
                                                                        siose_hr_selected,
                                                                        from_map_canvas,
                                                                        from_selected_features,
                                                                        from_administrative_unit,
                                                                        self.siose_layer_names,
                                                                        self.siose_hr_layer_names,
                                                                        self.siose_template,
                                                                        self.siose_hr_template,
                                                                        self.temp_path)
            self.load_siose_hr_dialog_from_map_canvas.closeEvent = self.close_load_siose_hr_dialog_from_map_canvas
            self.load_siose_hr_dialog_from_map_canvas.show()  # show the dialog
            result = self.load_siose_hr_dialog_from_map_canvas.exec_()  # Run the dialog
        else:
            self.load_siose_hr_dialog_from_map_canvas.activateWindow()

    def tool_load_siose_hr_from_selected_features(self):
        siose_hr_selected = True
        from_map_canvas = False
        from_selected_features = True
        from_administrative_unit = False
        if not self.load_siose_hr_dialog_from_selected_features:
            self.load_siose_hr_dialog_from_selected_features = ClipSioseDialog(self.iface,
                                                                               self.gdal_error_handler,
                                                                               self.siose_gpkg_tools,
                                                                               self.settings,
                                                                               self.last_path,
                                                                               siose_hr_selected,
                                                                               from_map_canvas,
                                                                               from_selected_features,
                                                                               from_administrative_unit,
                                                                               self.siose_layer_names,
                                                                               self.siose_hr_layer_names,
                                                                               self.siose_template,
                                                                               self.siose_hr_template,
                                                                               self.temp_path)
            self.load_siose_hr_dialog_from_selected_features.closeEvent = (
                self.close_load_siose_hr_dialog_from_selected_features)
            self.load_siose_hr_dialog_from_selected_features.show()  # show the dialog
            result = self.load_siose_hr_dialog_from_selected_features.exec_()  # Run the dialog
        else:
            self.load_siose_hr_dialog_from_selected_features.activateWindow()

    def tool_unload(self):
        yo = 1

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&SIOSE Tools'),
                action)
            self.iface.removeToolBarIcon(action)

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        # if self.first_start == True:
        #     self.first_start = False
        #     self.dlg = SIOSEToolsDialog()
        #
        # # show the dialog
        # self.dlg.show()
        # # Run the dialog event loop
        # result = self.dlg.exec_()
        # # See if OK was pressed
        # if result:
        #     # Do something useful here - delete the line containing pass and
        #     # substitute with your code.
        #     pass
        pass
