# -*- coding: utf-8 -*-
"""
/***************************************************************************
 SIOSETools
                                 A QGIS plugin
 Este plugin permite consultar la cartografía SIOSE del IGN.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-10-18
        git sha              : $Format:%H$
        copyright            : (C) 2023 by IGN-UCLM
        email                : david.hernadez@uclm.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import sys, os, subprocess, re
from qgis.PyQt.QtCore import *
from qgis.PyQt.QtGui import *
from qgis.PyQt import QtGui, QtWidgets, uic
from qgis.PyQt.QtWidgets import QDialog, QTableWidget, QTableWidgetItem, QListWidgetItem, QFileDialog
from qgis.PyQt.QtWidgets import QMessageBox, QInputDialog, QLineEdit, QComboBox
from qgis.PyQt.QtCore import QVariant
from qgis.core import *
from qgis.gui import QgsMessageBar
from osgeo import gdal, osr, ogr
import shutil
from qgis.PyQt import QtGui, QtWidgets, uic
from qgis.core import QgsApplication, QgsDataSourceUri, QgsMapLayerProxyModel, QgsRectangle, QgsGeometry, \
    QgsCoordinateReferenceSystem, QgsCoordinateTransform, QgsProject, QgsVectorLayer
from qgis.PyQt.QtGui import QIntValidator
from . import siose_tools_definitions as SDefs
from .siose_gpkg_tools import SioseGpkgTools
import json
import codecs

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'query_coverages_or_uses_dialog.ui'))


class QueryCoveragesOrUsesDialog(QDialog, FORM_CLASS):
    """
    Brief:
    """

    def __init__(self,
                 iface,
                 gdal_error_handler,
                 siose_gpkg_tools,
                 settings,
                 last_path,
                 path_plugin,
                 query_coverages,
                 parent=None):
        """
        Brief:
        """
        super(QueryCoveragesOrUsesDialog, self).__init__(parent)
        self.setupUi(self)
        self.iface = iface  # Save reference to the QGIS interface
        self.gdal_error_handler = gdal_error_handler
        self.siose_gpkg_tools = siose_gpkg_tools
        self.settings = settings
        self.last_path = last_path
        self.path_plugin = path_plugin
        self.queries = None
        self.is_siose_hr = None
        self.queries_file_name = os.path.join(self.path_plugin, SDefs.CONST_QUERIES_FILE_NAME)
        self.query_coverages = query_coverages  # si False se consultan usos
        # self.load_queries()
        self.coverages_ids_selected = []
        self.uses_ids_selected = []
        if self.query_coverages:
            title = SDefs.CONST_QUERY_COVERAGE_TITLE
            group_box_title = SDefs.CONST_GROUP_BOX_COVERAGES_TITLE
        else:
            title = SDefs.CONST_QUERY_USES_TITLE
            group_box_title = SDefs.CONST_GROUP_BOX_USES_TITLE
        self.source_layer_by_layer_id = {}
        self.source_layer_id_by_combo_text = {}
        self.sourceComboBox.currentIndexChanged.connect(self.selectSource)
        self.sourceComboBoxIsConnected = True
        self.iface.mapCanvas().layersChanged.connect(self.populateSourceComboBox)
        self.queryComboBox.currentIndexChanged.connect(self.selectQuery)
        self.removeQueryPushButton.clicked.connect(self.selectRemoveQuery)
        self.saveQueryPushButton.clicked.connect(self.selectSaveQuery)
        self.populateSourceComboBox()
        self.onlySelectedCheckBox.setEnabled(False)
        self.groupBox.setEnabled(False)
        self.processSelectionPushButton.setEnabled(False)
        self.processLayerPushButton.setEnabled(False)
        self.processStatisticsPushButton.setEnabled(False)
        self.title = title
        self.setWindowTitle(title)
        self.groupBox.setTitle(group_box_title)
        for percentageValue in range(101):
            self.commonPercentageComboBox.addItem(str(percentageValue))
        str_default_common_percentage = str(SDefs.CONST_PERCENTAGE_DEFAULT_VALUE)
        percentageIndex = self.commonPercentageComboBox.findText(str_default_common_percentage)
        if percentageIndex > -1:
            self.commonPercentageComboBox.setCurrentIndex(percentageIndex)
        self.activateAllPushButton.clicked.connect(self.activateAll)
        self.activateSelectionPushButton.clicked.connect(self.activateSelection)
        self.deactivateAllPushButton.clicked.connect(self.deactivateAll)
        self.deactivateSelectionPushButton.clicked.connect(self.deactivateSelection)
        self.setPercentageAllPushButton.clicked.connect(self.setPercentageAll)
        self.setPercentageSelectionPushButton.clicked.connect(self.setPercentageSelection)
        self.processSelectionPushButton.clicked.connect(self.processSelection)
        self.processLayerPushButton.clicked.connect(self.processLayer)
        self.processStatisticsPushButton.clicked.connect(self.processStatistics)
        self.onlySelectedCheckBox.stateChanged.connect(self.setOnlySelected)
        self.spatial_selected_features_ids = []  # almacena id, que es entero, y no ID_POLYGON
        self.coverages = {}
        self.spatial_selected_coverages_ids = []  # almacena el valor del campo ID_COBERTURAS
        self.coverages_values_by_polygon_id = {}
        self.statistics_by_coverage_id = {}
        self.uses = {}
        self.useIdByTag = {}
        self.spatial_selected_uses_ids = []
        self.uses_values_by_parcela_id = {}
        self.statistics_by_use_id = {}
        self.usesPercentagesInComboBox = False # para usar QLineEdit
        if self.usesPercentagesInComboBox:
            self.commonPercentageComboBox.setVisible(True)
            self.commonPercentageLineEdit.setVisible(False)
        else:
            self.commonPercentageComboBox.setVisible(False)
            self.commonPercentageLineEdit.setVisible(True)
            onlyInt = QIntValidator()
            onlyInt.setRange(0, 100)
            self.commonPercentageLineEdit.setValidator(onlyInt)
            self.commonPercentageLineEdit.setText(str(SDefs.CONST_PERCENTAGE_DEFAULT_VALUE))

    def activateAll(self):
        for row in range(self.tableWidget.rowCount()):
            item = self.tableWidget.item(row, 0)
            item.setCheckState(Qt.Checked)

    def activateSelection(self):
        for row in range(self.tableWidget.rowCount()):
            item = self.tableWidget.item(row, 1)
            if item.isSelected():
                self.tableWidget.item(row, 0).setCheckState(Qt.Checked)

    def deactivateAll(self):
        for row in range(self.tableWidget.rowCount()):
            item = self.tableWidget.item(row, 0)
            item.setCheckState(Qt.Unchecked)

    def deactivateSelection(self):
        for row in range(self.tableWidget.rowCount()):
            item = self.tableWidget.item(row, 1)
            if item.isSelected():
                self.tableWidget.item(row, 0).setCheckState(Qt.Unchecked)

    def disconnetMapCanvasLayers(self):
        self.iface.mapCanvas().layersChanged.disconnect(self.populateSourceComboBox)

    def display_msg_error(self, text):
        msgBox = QMessageBox()
        msgBox.setIcon(QMessageBox.Information)
        # msgBox.setWindowTitle(self.windowTitle)
        msgBox.setTextFormat(Qt.RichText)
        msgBox.setText(text)
        msgBox.exec_()

    def fillTabWidget(self):
        for i in range(self.tableWidget.rowCount()):
            self.tableWidget.removeRow(0)
        i = -1
        ids = []
        if self.query_coverages:
            ids = self.coverages.keys()
        else:
            ids = self.uses.keys()
        for id in ids:
            if self.query_coverages:
                if len(self.spatial_selected_coverages_ids) > 0:
                    if not id in self.spatial_selected_coverages_ids:
                        continue
            else:
                if len(self.spatial_selected_uses_ids) > 0:
                    if not id in self.spatial_selected_uses_ids:
                        continue
            i = i + 1
            self.tableWidget.insertRow(i)
            if self.query_coverages:
                description = self.coverages[id]['description']
                percentage = self.coverages[id]['percentage']
                tag = self.coverages[id]['tag']
            else:
                description = self.uses[id]['description']
                percentage = self.uses[id]['percentage']
                tag = self.uses[id]['tag']
            itemId = QTableWidgetItem(str(id))
            itemId.setTextAlignment(Qt.AlignCenter)
            itemId.setFlags(Qt.ItemIsSelectable)
            itemId.setFlags(Qt.ItemIsUserCheckable | Qt.ItemIsEnabled)
            itemId.setCheckState(Qt.Unchecked)
            itemId.setBackground(QBrush(QColor(Qt.white), Qt.SolidPattern))
            itemId.setForeground(QBrush(QColor(Qt.black), Qt.SolidPattern))
            self.tableWidget.setItem(i, 0, itemId)
            itemDescription = QTableWidgetItem(description)
            itemDescription.setTextAlignment(Qt.AlignCenter)
            itemDescription.setFlags(Qt.ItemIsSelectable)
            itemDescription.setBackground(QBrush(QColor(Qt.white), Qt.SolidPattern))
            itemDescription.setForeground(QBrush(QColor(Qt.black), Qt.SolidPattern))
            self.tableWidget.setItem(i, 1, itemDescription)
            if self.usesPercentagesInComboBox:
                percentageComboBox = QComboBox()
                for percentageValue in range(101):
                    percentageComboBox.addItem(str(percentageValue))
                percentageIndex = percentageComboBox.findText(str(percentage))
                if percentageIndex > -1:
                    percentageComboBox.setCurrentIndex(percentageIndex)
                self.tableWidget.setCellWidget(i, 2, percentageComboBox)
            else:
                percentageLineEdit = QLineEdit()
                onlyInt = QIntValidator()
                onlyInt.setRange(0, 100)
                percentageLineEdit.setValidator(onlyInt)
                percentageLineEdit.setText(str(percentage))
                self.tableWidget.setCellWidget(i, 2, percentageLineEdit)
            itemTag = QTableWidgetItem(tag)
            itemTag.setTextAlignment(Qt.AlignCenter)
            itemTag.setFlags(Qt.ItemIsSelectable)
            itemTag.setBackground(QBrush(QColor(Qt.white), Qt.SolidPattern))
            itemTag.setForeground(QBrush(QColor(Qt.black), Qt.SolidPattern))
            self.tableWidget.setItem(i, 3, itemTag)
        if i > -1:
            self.groupBox.setEnabled(True)
            #self.tableWidget.resizeColumnToContents(0)
            self.tableWidget.resizeColumnsToContents()
            self.processSelectionPushButton.setEnabled(True)
        else:
            self.groupBox.setEnabled(False)
            self.processSelectionPushButton.setEnabled(False)
        self.processLayerPushButton.setEnabled(False)
        self.processStatisticsPushButton.setEnabled(False)
        if self.query_coverages:
            if len(self.coverages_ids_selected) > 0:
                self.activateAll()
        else:
            if len(self.uses_ids_selected) > 0:
                self.activateAll()
        self.queryComboBox.setFocus()
        self.activateWindow()

    def getNumberOfValidSources(self):
        return self.sourceComboBox.count() - 1

    def load_queries(self):
        if self.queries:
            self.queries.clear()
            self.queries = None
        if not QFile.exists(self.queries_file_name):
            self.queries = {}
            self.queries[SDefs.CONST_QUERIES_COVERAGES_TAG] = {}
            self.queries[SDefs.CONST_QUERIES_COVERAGES_HR_TAG] = {}
            self.queries[SDefs.CONST_QUERIES_USES_TAG] = {}
            for query_id in SDefs.coverages_ids_by_query.keys():
                self.queries[SDefs.CONST_QUERIES_COVERAGES_TAG][query_id] = {}
                for coverage_id in SDefs.coverages_ids_by_query[query_id]:
                    self.queries[SDefs.CONST_QUERIES_COVERAGES_TAG][query_id][str(coverage_id)] = (
                        SDefs.CONST_PERCENTAGE_DEFAULT_VALUE)
            for query_id in SDefs.coverages_hr_ids_by_query.keys():
                self.queries[SDefs.CONST_QUERIES_COVERAGES_HR_TAG][query_id] = {}
                for coverage_id in SDefs.coverages_hr_ids_by_query[query_id]:
                    self.queries[SDefs.CONST_QUERIES_COVERAGES_HR_TAG][query_id][str(coverage_id)] = (
                        SDefs.CONST_PERCENTAGE_DEFAULT_VALUE)
            for query_id in SDefs.uses_ids_by_query.keys():
                self.queries[SDefs.CONST_QUERIES_USES_TAG][query_id] = {}
                for use_id in SDefs.uses_ids_by_query[query_id]:
                    self.queries[SDefs.CONST_QUERIES_USES_TAG][query_id][str(use_id)] = (
                        SDefs.CONST_PERCENTAGE_DEFAULT_VALUE)
            # with open(self.queries_file_name, 'w') as json_file:
            #     json.dump(self.queries, json_file, indent = 4, sort_keys=True, ensure_ascii=False)
            with codecs.open(self.queries_file_name, 'w', 'utf-8') as fp:
                fp.write(json.dumps(self.queries, indent=4, sort_keys=True, ensure_ascii=False))
        else:
            with open(self.queries_file_name, encoding='utf-8') as json_file:
                self.queries = json.load(json_file)
            need_save = False
            for query_id in SDefs.coverages_ids_by_query.keys():
                if not query_id in self.queries[SDefs.CONST_QUERIES_COVERAGES_TAG].keys():
                    self.queries[SDefs.CONST_QUERIES_COVERAGES_TAG][query_id] = {}
                    for coverage_id in SDefs.coverages_ids_by_query[query_id]:
                        self.queries[SDefs.CONST_QUERIES_COVERAGES_TAG][query_id][coverage_id] = (
                            SDefs.CONST_PERCENTAGE_DEFAULT_VALUE)
                    if not need_save:
                        need_save = True
            for query_id in SDefs.coverages_hr_ids_by_query.keys():
                if not query_id in self.queries[SDefs.CONST_QUERIES_COVERAGES_HR_TAG].keys():
                    self.queries[SDefs.CONST_QUERIES_COVERAGES_HR_TAG][query_id] = {}
                    for coverage_id in SDefs.coverages_hr_ids_by_query[query_id]:
                        self.queries[SDefs.CONST_QUERIES_COVERAGES_HR_TAG][query_id][coverage_id] = (
                            SDefs.CONST_PERCENTAGE_DEFAULT_VALUE)
                    if not need_save:
                        need_save = True
            for query_id in SDefs.uses_ids_by_query.keys():
                if not query_id in self.queries[SDefs.CONST_QUERIES_USES_TAG].keys():
                    self.queries[SDefs.CONST_QUERIES_USES_TAG][query_id] = {}
                    for use_id in SDefs.uses_ids_by_query[query_id]:
                        self.queries[SDefs.CONST_QUERIES_USES_TAG][query_id][use_id] = (
                            SDefs.CONST_PERCENTAGE_DEFAULT_VALUE)
                    if not need_save:
                        need_save = True
            if need_save:
                self.save_queries()
        self.queryComboBox.clear()
        self.queryComboBox.addItem(SDefs.CONST_QUERY_GENERIC)
        if self.query_coverages:
            if not self.is_siose_hr:
                for query_id in self.queries[SDefs.CONST_QUERIES_COVERAGES_TAG].keys():
                    self.queryComboBox.addItem(query_id)
            else:
                for query_id in self.queries[SDefs.CONST_QUERIES_COVERAGES_HR_TAG].keys():
                    self.queryComboBox.addItem(query_id)
        else:
            for query_id in self.queries[SDefs.CONST_QUERIES_USES_TAG].keys():
                self.queryComboBox.addItem(query_id)

    def save_queries(self):
        with codecs.open(self.queries_file_name, 'w', 'utf-8') as fp:
            fp.write(json.dumps(self.queries, indent=4, sort_keys=True, ensure_ascii=False))

    def populateSourceComboBox(self):
        previous_source_layer_combo_text = None
        if self.sourceComboBox.count() > 1:
            previous_source_layer_combo_text = self.sourceComboBox.currentText()
        if self.sourceComboBoxIsConnected:
            self.sourceComboBox.currentIndexChanged.disconnect(self.selectSource)
            self.sourceComboBoxIsConnected = False
        self.sourceComboBox.clear()
        self.source_layer_by_layer_id.clear()
        self.source_layer_id_by_combo_text.clear()
        self.sourceComboBox.addItem(SDefs.CONST_NO_COMBO_SELECT)
        self.source_layer_id_by_combo_text[SDefs.CONST_NO_COMBO_SELECT] = None
        map_layers = self.iface.mapCanvas().layers()  # no incluye las no visibles
        if self.query_coverages:
            if len(map_layers) == 0:
                msg = self.tr(u'Debe estar cargada y visible alguna capa de polígonos de SIOSE o SIOSE AR')
                self.display_msg_error(msg)
                return
        else:
            if len(map_layers) == 0:
                msg = self.tr(u'Debe estar cargada y visible alguna capa de usos de SIOSE AR')
                self.display_msg_error(msg)
                return
        cont = 1
        for layer in map_layers:
            if (layer.type() != QgsMapLayerType.VectorLayer
                    or layer.geometryType() != QgsWkbTypes.PolygonGeometry):
                continue
            layerProvider = layer.dataProvider()
            layerStorage = layerProvider.storageType()
            if layerStorage != SDefs.CONST_GPKG_DRIVER_TAG:
                continue
            layer_uri = layerProvider.dataSourceUri()
            layer_file_path = layer_uri.split('|')[0]
            layer_file_base_name = os.path.splitext(os.path.basename(layer_file_path))[0]
            only_siose_model_layers = False
            all_siose_model_layers = True
            is_siose = False
            is_siose_hr = False
            is_siose = self.siose_gpkg_tools.getIsSiose(layer_file_path, False, True)
            if not is_siose:
                is_siose_hr, id = self.siose_gpkg_tools.getIsSioseHr(layer_file_path, False, True)
            if not is_siose and not is_siose_hr:
                continue
            if self.query_coverages:
                if not SDefs.CONST_QUERY_COVERAGES_VALID_NAME in layer_uri:
                    continue
            else:
                if not SDefs.CONST_QUERY_USES_VALID_NAME in layer_uri:
                    continue
            layer_name = layer.name()
            layer_uri_short = layer_file_base_name + '|' + layer_name
            self.source_layer_by_layer_id[layer.id()] = layer
            self.source_layer_id_by_combo_text[layer_uri_short] = layer.id()
            self.sourceComboBox.addItem(layer_uri_short)
            cont = cont + 1
        if self.sourceComboBox.count() == 1:
            if self.query_coverages:
                msg = self.tr(u'No hay ninguna capa cargada y visible de polígonos de SIOSE o SIOSE AR')
            else:
                msg = self.tr(u'No hay ninguna capa cargada y visible de usos de SIOSE AR')
            self.display_msg_error(msg)
            self.close()
            return
        if previous_source_layer_combo_text:
            new_pos = self.sourceComboBox.findText(previous_source_layer_combo_text)
            if new_pos < 0:
                self.sourceComboBox.currentIndexChanged.connect(self.selectSource)
                self.sourceComboBoxIsConnected = True
                self.sourceComboBox.setCurrentIndex(0)
                self.selectSource()
            else:
                self.sourceComboBox.setCurrentIndex(new_pos)
                self.sourceComboBox.currentIndexChanged.connect(self.selectSource)
                self.sourceComboBoxIsConnected = True
        else:
            self.sourceComboBox.currentIndexChanged.connect(self.selectSource)
            self.sourceComboBoxIsConnected = True
            self.sourceComboBox.setCurrentIndex(0)
            self.selectSource()

    def processLayer(self):
        if self.query_coverages:
            if len(self.coverages_values_by_polygon_id) == 0:
                msg = self.tr(u'No hay ninguna cobertura seleccionada')
                self.display_msg_error(msg)
                return
        else:
            if len(self.uses_values_by_polygon_id) == 0:
                msg = self.tr(u'No hay ningún uso seleccionado')
                self.display_msg_error(msg)
                return
        layer_id = self.source_layer_id_by_combo_text[self.sourceComboBox.currentText()]
        layer = self.source_layer_by_layer_id[layer_id]
        layerProvider = layer.dataProvider()
        layer_uri = layerProvider.dataSourceUri()
        layer_file_path = layer_uri.split('|')[0]
        only_siose_model_layers = False
        all_siose_model_layers = True
        is_siose = False
        is_siose_hr = False
        is_siose = self.siose_gpkg_tools.getIsSiose(layer_file_path, False, True)
        if not is_siose:
            is_siose_hr, id = self.siose_gpkg_tools.getIsSioseHr(layer_file_path, False, True)
        # if not is_siose and not is_siose_hr:
        #     continue
        qml_file = None
        layer_with_values_title = "Poligonos con valores de coberturas"
        if is_siose:
            qml_file = self.siose_gpkg_tools.getSioseCodiigeQmlFile()
        else:
            if self.query_coverages:
                qml_file = self.siose_gpkg_tools.getSioseHrCoveragesQmlFile()
            else:
                qml_file = self.siose_gpkg_tools.getSioseHrUsesQmlFile()
                layer_with_values_title = "Poligonos con valores de usos"
        layer_with_values = QgsVectorLayer("MultiPolygon?crs=" + layer.crs().authid(),
                                           layer_with_values_title, "memory")
        layer_fields = layer.dataProvider().fields().toList()
        layer_with_values.dataProvider().addAttributes(layer_fields)
        layer_with_values.updateFields()

        features_ids = []
        feature_id_by_polygon_id = {}
        if self.query_coverages:
            for feaure_id in self.coverages_values_by_polygon_id.keys():
                features_ids.append(feaure_id)
        else:
            for feaure_id in self.uses_values_by_polygon_id.keys():
                features_ids.append(feaure_id)
        features = []
        for feature in layer.getFeatures(features_ids):
            features.append(feature)
        layer_with_values.startEditing()
        for feature in features:
            if self.query_coverages:
                feature_id_by_polygon_id[feature[SDefs.CONST_SIOSE_ID_POLYGON]] = feature.id()
            else:
                feature_id_by_polygon_id[feature[SDefs.CONST_SIOSE_ID_PARCELA]] = feature.id()
        layer_with_values.addFeatures(features)
        layer_with_values.updateExtents()
        layer_with_values.commitChanges()

        if self.query_coverages:
            coverages_ids_new_fields = []
            for feature_id in features_ids:
                coverages_ids = self.coverages_values_by_polygon_id[feature_id].keys()
                for coverage_id in coverages_ids:
                    if coverage_id in coverages_ids_new_fields:
                        continue
                    if is_siose:
                        area_field_name = str(coverage_id) + SDefs.CONST_HA_SUFFIX
                    else:
                        area_field_name = str(coverage_id) + SDefs.CONST_M2_SUFFIX
                    percentage_field_name = str(coverage_id) + SDefs.CONST_POR_SUFFIX
                    layer_with_values.startEditing()
                    layer_with_values.addAttribute(QgsField(area_field_name, QVariant.Double))
                    layer_with_values.addAttribute(QgsField(percentage_field_name, QVariant.Double))
                    layer_with_values.commitChanges()
                    coverages_ids_new_fields.append(coverage_id)
        else:
            uses_ids_new_fields = []
            for feature_id in features_ids:
                uses_ids = self.uses_values_by_polygon_id[feature_id].keys()
                for use_id in uses_ids:
                    if use_id in uses_ids_new_fields:
                        continue
                    area_field_name = str(use_id) + SDefs.CONST_M2_SUFFIX
                    percentage_field_name = str(use_id) + SDefs.CONST_POR_SUFFIX
                    layer_with_values.startEditing()
                    layer_with_values.addAttribute(QgsField(area_field_name, QVariant.Double))
                    layer_with_values.addAttribute(QgsField(percentage_field_name, QVariant.Double))
                    layer_with_values.commitChanges()
                    uses_ids_new_fields.append(use_id)

        layer_with_values.startEditing()
        for feature in layer_with_values.getFeatures():
            if self.query_coverages:
                feature_polygon_id = feature[SDefs.CONST_SIOSE_ID_POLYGON]
            else:
                feature_polygon_id = feature[SDefs.CONST_SIOSE_ID_PARCELA]
            feature_id = feature_id_by_polygon_id[feature_polygon_id]
            if self.query_coverages:
                coverages_ids = self.coverages_values_by_polygon_id[feature_id].keys()
                for coverage_id in coverages_ids:
                    if is_siose:
                        area_field_name = str(coverage_id) + SDefs.CONST_HA_SUFFIX
                        area = self.coverages_values_by_polygon_id[feature_id][coverage_id][SDefs.CONST_SUPERF_HA]
                    else:
                        area_field_name = str(coverage_id) + SDefs.CONST_M2_SUFFIX
                        area = self.coverages_values_by_polygon_id[feature_id][coverage_id][SDefs.CONST_SUPERF_M2]
                    percentage_field_name = str(coverage_id) + SDefs.CONST_POR_SUFFIX
                    percentage = self.coverages_values_by_polygon_id[feature_id][coverage_id][SDefs.CONST_SUPERF_POR]
                    feature[area_field_name] = area
                    feature[percentage_field_name] = percentage
                    layer_with_values.updateFeature(feature)
            else:
                uses_ids = self.uses_values_by_polygon_id[feature_id].keys()
                for use_id in uses_ids:
                    area_field_name = str(use_id) + SDefs.CONST_M2_SUFFIX
                    area = self.uses_values_by_polygon_id[feature_id][use_id][SDefs.CONST_SUPERF_M2]
                    percentage_field_name = str(use_id) + SDefs.CONST_POR_SUFFIX
                    percentage = self.uses_values_by_polygon_id[feature_id][use_id][SDefs.CONST_SUPERF_POR]
                    feature[area_field_name] = area
                    feature[percentage_field_name] = percentage
                    layer_with_values.updateFeature(feature)

        layer_with_values.commitChanges()

        if not layer_with_values.isValid():
            if self.query_coverages:
                msg = self.tr(u'No se ha generado correctamente la capa de poligonos con valores de coberturas')
            else:
                msg = self.tr(u'No se ha generado correctamente la capa de poligonos con valores de usos')
            self.display_msg_error(msg)
            return
        else:
            layer_with_values.loadNamedStyle(qml_file)
            QgsProject.instance().addMapLayer(layer_with_values, False)
            QgsProject.instance().layerTreeRoot().insertChildNode(0, QgsLayerTreeLayer(layer_with_values))
            # self.iface.mapCanvas().refreshAllLayers()

    def processSelection(self):
        self.coverages_values_by_polygon_id = {}
        self.statistics_by_coverage_id = {}
        self.uses_values_by_polygon_id = {}
        self.statistics_by_use_id = {}
        self.processLayerPushButton.setEnabled(False)
        self.processStatisticsPushButton.setEnabled(False)
        pos = self.sourceComboBox.currentIndex()
        layer_id = self.source_layer_id_by_combo_text[self.sourceComboBox.currentText()]
        layer = self.source_layer_by_layer_id[layer_id]
        layerProvider = layer.dataProvider()
        layer_uri = layerProvider.dataSourceUri()
        layer_file_path = layer_uri.split('|')[0]
        is_siose_hr, id = self.siose_gpkg_tools.getIsSioseHr(layer_file_path, False, True)
        if not is_siose_hr:
            layer_values_uri = layer_file_path + '|layername=' + SDefs.CONST_SIOSE_T_VALORES_LAYER
            layer_polygons_uri = layer_file_path + '|layername=' + SDefs.CONST_SIOSE_T_POLIGONOS_LAYER
        else:
            if self.query_coverages:
                layer_values_uri = layer_file_path + '|layername=' + SDefs.CONST_SIOSE_HR_T_VALORES_LAYER
                layer_polygons_uri = layer_file_path + '|layername=' + SDefs.CONST_SIOSE_HR_T_POLIGONOS_LAYER
            else:
                layer_values_uri = layer_file_path + '|layername=' + SDefs.CONST_SIOSE_HR_T_USOS_LAYER
                layer_polygons_uri = None
        percentageByActivated = {}
        descriptionByActivated = {}
        tagByActivated = {}
        idByTagActivated = {}
        for row in range(self.tableWidget.rowCount()):
            if self.tableWidget.item(row, 0).checkState() == Qt.Checked:
                str_id = self.tableWidget.item(row, 0).text()
                widget = self.tableWidget.cellWidget(row, 2)
                percentage = 0.
                if self.usesPercentagesInComboBox:
                    if isinstance(widget, QComboBox):
                        percentage = int(widget.currentText())
                else:
                    if isinstance(widget, QLineEdit):
                        percentage = int(widget.text())
                percentageByActivated[int(str_id)] = percentage
                descriptionByActivated[int(str_id)] = self.tableWidget.item(row, 1).text()
                if is_siose_hr and not self.query_coverages:
                    tag = self.uses[int(str_id)]['tag']
                    tagByActivated[int(str_id)] = tag
                    idByTagActivated[tag] = int(str_id)
        if len(percentageByActivated) == 0:
            if self.query_coverages:
                msg = self.tr(u'No hay ninguna cobertura seleccionada')
            else:
                msg = self.tr(u'No hay ningún uso seleccionado')
            self.display_msg_error(msg)
            return
        # full_loaded_layer_list = QgsProject.instance().layerTreeRoot().findLayers()
        # obtener layer de T_VALUES
        # layer_values_uri = layer_file_path + '|layername=T_VALORES'
        layer_values = None
        if not is_siose_hr:
            loaded_layers_values = QgsProject.instance().mapLayersByName(SDefs.CONST_SIOSE_T_VALORES_LAYER)
        else:
            if self.query_coverages:
                loaded_layers_values = QgsProject.instance().mapLayersByName(SDefs.CONST_SIOSE_HR_T_VALORES_LAYER)
            else:
                loaded_layers_values = QgsProject.instance().mapLayersByName(SDefs.CONST_SIOSE_HR_T_USOS_LAYER)
        for loaded_layer_values in loaded_layers_values:
            loaded_layer_values_provider = loaded_layer_values.dataProvider()
            loaded_layer_values_uri = loaded_layer_values_provider.dataSourceUri()
            loaded_layer_values_file_path = loaded_layer_values_uri.split('|')[0]
            if not is_siose_hr:
                loaded_layer_values_uri_short = loaded_layer_values_file_path + '|layername=' + SDefs.CONST_SIOSE_T_VALORES_LAYER
            else:
                if self.query_coverages:
                    loaded_layer_values_uri_short = loaded_layer_values_file_path + '|layername=' + SDefs.CONST_SIOSE_HR_T_VALORES_LAYER
                else:
                    loaded_layer_values_uri_short = loaded_layer_values_file_path + '|layername=' + SDefs.CONST_SIOSE_HR_T_USOS_LAYER
            if layer_values_uri == loaded_layer_values_uri_short:
                layer_values = loaded_layer_values
                break
        if not layer_values:
            if not is_siose_hr:
                layer_values = QgsVectorLayer(layer_values_uri, SDefs.CONST_SIOSE_T_VALORES_LAYER, "ogr")
            else:
                if self.query_coverages:
                    layer_values = QgsVectorLayer(layer_values_uri, SDefs.CONST_SIOSE_HR_T_VALORES_LAYER, "ogr")
                else:
                    layer_values = QgsVectorLayer(layer_values_uri, SDefs.CONST_SIOSE_HR_T_USOS_LAYER, "ogr")
            if not layer_values.isValid():
                if not is_siose_hr:
                    msg = self.tr(u'Cartografía SIOSE no se encuentra la tabla ' + SDefs.CONST_SIOSE_T_VALORES_LAYER)
                else:
                    if self.query_coverages:
                        msg = self.tr(u'Cartografía SIOSE AR no se encuentra la tabla ' + SDefs.CONST_SIOSE_HR_T_VALORES_LAYER)
                    else:
                        msg = self.tr(u'Cartografía SIOSE AR no se encuentra la tabla ' + SDefs.CONST_SIOSE_HR_T_USOS_LAYER)
                self.display_msg_error(msg)
                return
            else:
                QgsProject.instance().addMapLayer(layer_values)
        if self.query_coverages:
            self.iface.messageBar().pushMessage("SIOSE Tools", "Seleccionando coberturas ...", level=Qgis.Info)
        else:
            self.iface.messageBar().pushMessage("SIOSE Tools", "Seleccionando usos ...", level=Qgis.Info)
        self.iface.mainWindow().repaint()
        # obtener layer de T_POLIGONOS
        if self.query_coverages:
            if not is_siose_hr:
                layer_polygons_uri = layer_file_path + '|layername=' + SDefs.CONST_SIOSE_T_POLIGONOS_LAYER
            else:
                layer_polygons_uri = layer_file_path + '|layername=' + SDefs.CONST_SIOSE_HR_T_POLIGONOS_LAYER
            layer_polygons = None
            if not is_siose_hr:
                loaded_layers_polygons = QgsProject.instance().mapLayersByName(SDefs.CONST_SIOSE_T_POLIGONOS_LAYER)
            else:
                loaded_layers_polygons = QgsProject.instance().mapLayersByName(SDefs.CONST_SIOSE_HR_T_POLIGONOS_LAYER)
            for loaded_layer_polygons in loaded_layers_polygons:
                loaded_layer_polygons_provider = loaded_layer_polygons.dataProvider()
                loaded_layer_polygons_uri = loaded_layer_polygons_provider.dataSourceUri()
                loaded_layer_polygons_file_path = loaded_layer_polygons_uri.split('|')[0]
                if not is_siose_hr:
                    loaded_layer_polygons_uri_short = loaded_layer_polygons_file_path + '|layername=' + SDefs.CONST_SIOSE_T_POLIGONOS_LAYER
                else:
                    loaded_layer_polygons_uri_short = loaded_layer_polygons_file_path + '|layername=' + SDefs.CONST_SIOSE_HR_T_POLIGONOS_LAYER
                if layer_polygons_uri == loaded_layer_polygons_uri_short:
                    layer_polygons = loaded_layer_polygons
                    break
            if not layer_polygons:
                if not is_siose_hr:
                    layer_polygons = QgsVectorLayer(layer_values_uri, SDefs.CONST_SIOSE_T_POLIGONOS_LAYER, "ogr")
                else:
                    layer_polygons = QgsVectorLayer(layer_values_uri, SDefs.CONST_SIOSE_HR_T_POLIGONOS_LAYER, "ogr")
                if not layer_polygons.isValid():
                    if not is_siose_hr:
                        msg = self.tr(u'Cartografía SIOSE no se encuentra la tabla ' + SDefs.CONST_SIOSE_T_VALORES_LAYER)
                    else:
                        msg = self.tr(u'Cartografía SIOSE AR no se encuentra la tabla ' + SDefs.CONST_SIOSE_HR_T_VALORES_LAYER)
                    self.display_msg_error(msg)
                    self.iface.messageBar().clearWidgets()
                    return
                else:
                    QgsProject.instance().addMapLayer(layer_polygons)
            # # Creación de la relación
            rel = QgsRelation()
            rel.setReferencingLayer(layer_values.id())
            rel.setReferencedLayer(layer_polygons.id())
            rel.addFieldPair(SDefs.CONST_SIOSE_ID_POLYGON, SDefs.CONST_SIOSE_ID_POLYGON)
            rel.setId('Relation SIOSE')
            rel.setName('Relación SIOSE ' + SDefs.CONST_SIOSE_ID_POLYGON)
            # Se itera en las coverturas
            features_polygons_ids_coverages = []
            features_values_ids_coverages = []
            features_polygons_ids_by_coverage_id = {}
            coverages_id_to_query = percentageByActivated.keys()
            for coverage_id in coverages_id_to_query:
                coverage_description = descriptionByActivated[coverage_id]
                if not is_siose_hr:
                    str_query = SDefs.CONST_SIOSE_ID_COVERAGES + '=' + str(coverage_id)
                else:
                    str_query = SDefs.CONST_SIOSE_ID_COVERAGE + '=' + str(coverage_id)
                str_query = str_query + ' AND ' + SDefs.CONST_SUPERF_POR + ' >= '
                str_query = str_query + str(percentageByActivated[coverage_id])
                expr = QgsExpression(str_query)
                features_values = layer_values.getFeatures(QgsFeatureRequest(expr))
                coverage_area = 0
                polygons_ids_coverage = []
                for feature_values in features_values:
                    feature_polygon = rel.getReferencedFeature(feature_values)
                    feature_polygon_id = feature_polygon.id()
                    if len(self.spatial_selected_features_ids) > 0:
                        if not feature_polygon_id in self.spatial_selected_features_ids:
                            continue
                    if not is_siose_hr:
                        coverage_area = coverage_area + feature_values[SDefs.CONST_SUPERF_HA]
                    else:
                        coverage_area = coverage_area + feature_values[SDefs.CONST_SUPERF_M2]
                    if not feature_polygon_id in polygons_ids_coverage:
                        polygons_ids_coverage.append(feature_polygon_id)
                    if not feature_polygon_id in features_polygons_ids_coverages:
                        features_polygons_ids_coverages.append(feature_polygon_id)
                    feature_values_id = feature_values.id()
                    if not feature_values_id in features_values_ids_coverages:
                        features_values_ids_coverages.append(feature_values_id)
                    coverages_values = {}
                    coverage_values = {}
                    if not is_siose_hr:
                        coverage_values[SDefs.CONST_SUPERF_HA] = feature_values[SDefs.CONST_SUPERF_HA]
                    else:
                        coverage_values[SDefs.CONST_SUPERF_M2] = feature_values[SDefs.CONST_SUPERF_M2]
                    coverage_values[SDefs.CONST_SUPERF_POR] = feature_values[SDefs.CONST_SUPERF_POR]
                    coverages_values[coverage_id] = coverage_values
                    self.coverages_values_by_polygon_id[feature_polygon_id] = coverages_values
                features_polygons_ids_by_coverage_id[coverage_id] = polygons_ids_coverage
                coverage_statistics = {}
                coverage_statistics['description'] = coverage_description
                coverage_statistics['area'] = coverage_area
                self.statistics_by_coverage_id[coverage_id] = coverage_statistics
            layer_polygons.selectByIds(features_polygons_ids_coverages)
            self.iface.setActiveLayer(layer_polygons)
            self.iface.mapCanvas().zoomToSelected(layer_polygons)
            layer_values.selectByIds(features_values_ids_coverages)
            if len(features_polygons_ids_coverages) > 0:
                self.processLayerPushButton.setEnabled(True)
                self.processStatisticsPushButton.setEnabled(True)
                self.onlySelectedCheckBox.setEnabled(True)
            else:
                self.processLayerPushButton.setEnabled(False)
                self.processStatisticsPushButton.setEnabled(False)
        else:
            layer = QgsVectorLayer(layer_values_uri, SDefs.CONST_SIOSE_HR_T_USOS_LAYER, "ogr")
            if not layer.isValid():
                msg = 'En el fichero: ' + layer_file_path
                msg = msg + '\nno es valida la capa: ' + SDefs.CONST_SIOSE_HR_T_USOS_LAYER
                self.display_msg_error(msg)
                self.iface.messageBar().clearWidgets()
                return
            features_polygons_ids_uses = []
            features_polygons_ids_by_use_id = {}
            for feature in layer.getFeatures():
                polygon_id = feature.id()
                if len(self.spatial_selected_features_ids) > 0:
                    if not polygon_id in self.spatial_selected_features_ids:
                        continue
                id_parcela = feature[SDefs.CONST_SIOSE_ID_PARCELA]
                rotulo = feature[SDefs.CONST_SIOSE_HR_SIOSE_CODE]
                area = feature[SDefs.CONST_SUPERF_M2]
                str_rotulo_values = rotulo.split('_')
                for str_rotulo_value in str_rotulo_values:
                    str_percentage = re.findall(r'\d+', str_rotulo_value)
                    use_percentage = None
                    use_tag = None
                    if len(str_percentage) > 1:
                        msg = 'En el fichero: ' + layer_file_path
                        msg = msg + '\nen la parcela: ' + id_parcela
                        msg = msg + '\nel uso no es válido: ' + rotulo
                        msg = msg + '\nhay un uso con más de un número: ' + str_rotulo_value
                        self.display_msg_error(msg)
                        self.iface.messageBar().clearWidgets()
                        return
                    elif len(str_percentage) == 1:
                        str_percentage = str_percentage[0]
                        use_percentage = float(str_percentage)
                        use_tag = str_rotulo_value.replace(str_percentage, '')
                    if not use_percentage:
                        use_percentage = 100.
                        use_tag = str_rotulo_value
                    if not use_tag in idByTagActivated:
                        continue
                    use_id = idByTagActivated[use_tag]
                    if not use_percentage >= percentageByActivated[use_id]:
                        continue
                    use_description = descriptionByActivated[use_id]
                    use_area = area * use_percentage / 100.
                    if not use_id in self.statistics_by_use_id:
                        use_statistics = {}
                        use_statistics['description'] = use_description
                        use_statistics['area'] = use_area
                        use_statistics['tag'] = use_tag
                        self.statistics_by_use_id[use_id] = use_statistics
                    else:
                        self.statistics_by_use_id[use_id]['area'] = self.statistics_by_use_id[use_id]['area'] + use_area
                    use_values = {}
                    use_values[SDefs.CONST_SUPERF_M2] = use_area
                    use_values[SDefs.CONST_SUPERF_POR] = use_percentage
                    if not polygon_id in self.uses_values_by_polygon_id:
                        uses_values = {}
                        uses_values[use_id] = use_values
                        self.uses_values_by_polygon_id[polygon_id] = uses_values
                    else:
                        self.uses_values_by_polygon_id[polygon_id][use_id] = use_values
                    if not use_id in features_polygons_ids_by_use_id:
                        features_polygons_ids_by_use_id[use_id] = []
                    if not polygon_id in features_polygons_ids_by_use_id[use_id]:
                        features_polygons_ids_by_use_id[use_id].append(polygon_id)
                    if not polygon_id in features_polygons_ids_uses:
                        features_polygons_ids_uses.append(polygon_id)
            layer_values.selectByIds(features_polygons_ids_uses)
            self.iface.setActiveLayer(layer_values)
            self.iface.mapCanvas().zoomToSelected(layer_values)
            if len(features_polygons_ids_uses) > 0:
                self.processLayerPushButton.setEnabled(True)
                self.processStatisticsPushButton.setEnabled(True)
                self.onlySelectedCheckBox.setEnabled(True)
            else:
                self.processLayerPushButton.setEnabled(False)
                self.processStatisticsPushButton.setEnabled(False)
        self.iface.messageBar().clearWidgets()

    def processStatistics(self):
        layer_id = self.source_layer_id_by_combo_text[self.sourceComboBox.currentText()]
        layer = self.source_layer_by_layer_id[layer_id]
        layerProvider = layer.dataProvider()
        layer_uri = layerProvider.dataSourceUri()
        layer_file_path = layer_uri.split('|')[0]
        is_siose_hr, id = self.siose_gpkg_tools.getIsSioseHr(layer_file_path, False, True)
        if not is_siose_hr:
            layer_statistics_name = "Estadísticas Coberturas SIOSE"
        else:
            layer_statistics_name = "Estadísticas Coberturas SIOSE AR"
        layer_statistics_field_value_name = "Cobertura"
        if not is_siose_hr:
            layer_statistics_field_area_name = "Superficie HA"
        else:
            layer_statistics_field_area_name = "Superficie M2"
        if self.query_coverages:
            if len(self.statistics_by_coverage_id) == 0:
                msg = self.tr(u'No se han generado estadísticas')
                self.display_msg_error(msg)
                return
        else:
            layer_statistics_name = "Estadísticas Usos SIOSE"
            layer_statistics_field_area_name = "Superficie M2"
            layer_statistics_field_value_name = "Uso"
            if self.query_coverages:
                if len(self.statistics_by_coverage_id) == 0:
                    msg = self.tr(u'No se han generado estadísticas')
                    self.display_msg_error(msg)
                    return
        layer_statistics_memory = QgsVectorLayer("NoGeometry", layer_statistics_name, "memory")
        layer_statistics_memory.startEditing()
        layer_statistics_memory.dataProvider().addAttributes([QgsField("ID", QVariant.Int),
                                                              QgsField(layer_statistics_field_value_name,
                                                                       QVariant.String),
                                                              QgsField(layer_statistics_field_area_name, QVariant.Double)])
        layer_statistics_memory.commitChanges()
        layer_statistics_memory.startEditing()
        total_area = 0.
        if self.query_coverages:
            coverages_ids = self.statistics_by_coverage_id.keys()
            for coverage_id in coverages_ids:
                description = self.statistics_by_coverage_id[coverage_id]['description']
                area = self.statistics_by_coverage_id[coverage_id]['area']
                total_area = total_area + area
                feature = QgsFeature()
                feature.setFields(layer_statistics_memory.fields())
                feature.setAttributes([coverage_id, description, area])
                layer_statistics_memory.addFeature(feature)
        else:
            uses_ids = self.statistics_by_use_id.keys()
            for use_id in uses_ids:
                description = self.statistics_by_use_id[use_id]['description']
                area = self.statistics_by_use_id[use_id]['area']
                total_area = total_area + area
                feature = QgsFeature()
                feature.setFields(layer_statistics_memory.fields())
                feature.setAttributes([use_id, description, area])
                layer_statistics_memory.addFeature(feature)
        # total_area register
        total_area_id = -1
        total_area_description = 'ÁREA TOTAL'
        feature = QgsFeature()
        feature.setFields(layer_statistics_memory.fields())
        feature.setAttributes([total_area_id, total_area_description, total_area])
        layer_statistics_memory.addFeature(feature)
        layer_statistics_memory.commitChanges()
        if not layer_statistics_memory.isValid():
            msg = self.tr(u'No se ha generado correctamente la capa de estadísticas de coberturas')
            self.display_msg_error(msg)
            return
        else:
            QgsProject.instance().addMapLayer(layer_statistics_memory, False)
            QgsProject.instance().layerTreeRoot().insertChildNode(0, QgsLayerTreeLayer(layer_statistics_memory))
            # self.iface.mapCanvas().refreshAllLayers()

    def selectQuery(self):
        self.coverages_ids_selected.clear()
        self.coverages.clear()
        self.uses_ids_selected.clear()
        self.uses.clear()
        self.useIdByTag.clear()
        self.removeQueryPushButton.setEnabled(True)
        query_id = self.queryComboBox.currentText()
        if query_id in SDefs.coverages_ids_by_query:
            self.removeQueryPushButton.setEnabled(False)
        elif query_id == SDefs.CONST_QUERY_GENERIC:
            self.removeQueryPushButton.setEnabled(False)
        if self.query_coverages:
            if not self.is_siose_hr:
                if query_id in self.queries[SDefs.CONST_QUERIES_COVERAGES_TAG].keys():
                    for coverage_id in self.queries[SDefs.CONST_QUERIES_COVERAGES_TAG][query_id].keys():
                        self.coverages_ids_selected.append(int(coverage_id))
            else:
                if query_id in self.queries[SDefs.CONST_QUERIES_COVERAGES_HR_TAG].keys():
                    for coverage_id in self.queries[SDefs.CONST_QUERIES_COVERAGES_HR_TAG][query_id].keys():
                        self.coverages_ids_selected.append(int(coverage_id))
        else:
            if query_id in self.queries[SDefs.CONST_QUERIES_USES_TAG].keys():
                for use_id in self.queries[SDefs.CONST_QUERIES_USES_TAG][query_id].keys():
                    self.uses_ids_selected.append(int(use_id))
        pos = self.sourceComboBox.currentIndex()
        layer_id = self.source_layer_id_by_combo_text[self.sourceComboBox.currentText()]
        layer = self.source_layer_by_layer_id[layer_id]
        layerProvider = layer.dataProvider()
        layer_uri = layerProvider.dataSourceUri()
        layer_file_path = layer_uri.split('|')[0]
        is_siose_hr, id = self.siose_gpkg_tools.getIsSioseHr(layer_file_path, False, True)
        if not is_siose_hr and not self.query_coverages:
            msg = self.tr(u'La consulta de usos solo se puede realizar en SIOSE AR')
            self.display_msg_error(msg)
            self.close()
            return
        md = QgsProviderRegistry.instance().providerMetadata("ogr")
        conn = md.createConnection(layer_file_path, {})
        query_sql = None
        if not is_siose_hr:
            query_sql = SDefs.CONST_SQL_GET_SIOSE_COVERAGES
        else:
            if self.query_coverages:
                query_sql = SDefs.CONST_SQL_GET_SIOSE_HR_COVERAGES
            else:
                query_sql = SDefs.CONST_SQL_GET_SIOSE_HR_USES
        # self.display_msg_error(query)
        if self.query_coverages:
            values_to_read = "Coberturas"
        else:
            values_to_read = 'Usos'
        self.iface.messageBar().pushMessage("SIOSE Tools", ("Leyendo " + values_to_read), level=Qgis.Info)
        self.iface.mainWindow().repaint()
        results = conn.executeSql(query_sql)
        if self.query_coverages:
            for result in results:
                coverage_id = result[0]
                coverage_percentage = SDefs.CONST_PERCENTAGE_DEFAULT_VALUE
                if len(self.coverages_ids_selected) > 0:
                    if not coverage_id in self.coverages_ids_selected:
                        continue
                    else:
                        if not self.is_siose_hr:
                            coverage_percentage = self.queries[SDefs.CONST_QUERIES_COVERAGES_TAG][query_id][str(coverage_id)]
                        else:
                            coverage_percentage = self.queries[SDefs.CONST_QUERIES_COVERAGES_HR_TAG][query_id][str(coverage_id)]
                coverage_description = result[1]
                coverage_tag = result[2]
                if not coverage_tag:
                    coverage_tag = ''
                coverage = {}
                coverage['description'] = coverage_description
                coverage['percentage'] = coverage_percentage
                coverage['tag'] = coverage_tag
                self.coverages[coverage_id] = coverage
            if len(self.coverages) == 0:
                msg = self.tr(u'En la capa no hay ninguna cobertura de los tipos elegidos')
                self.display_msg_error(msg)
                self.close()
                self.iface.messageBar().clearWidgets()
                return
        else:
            for result in results:
                use_id = result[0]
                use_percentage = SDefs.CONST_PERCENTAGE_DEFAULT_VALUE
                if len(self.uses_ids_selected) > 0:
                    if not use_id in self.uses_ids_selected:
                        continue
                    else:
                        use_percentage = self.queries[SDefs.CONST_QUERIES_USES_TAG][query_id][str(use_id)]
                use_description = result[1]
                use_tag = result[2]
                use = {}
                use['description'] = use_description
                use['percentage'] = use_percentage
                use['tag'] = use_tag
                self.uses[use_id] = use
                self.useIdByTag[use_tag] = use_id
            if len(self.uses) == 0:
                msg = self.tr(u'En la capa no hay ningún uso de los tipos elegidos')
                self.display_msg_error(msg)
                self.close()
                self.iface.messageBar().clearWidgets()
                return
        self.iface.messageBar().clearWidgets()
        if len(layer.selectedFeatures()) > 0:
            self.onlySelectedCheckBox.setEnabled(True)
            self.queryComboBox.setEnabled(True)
        self.iface.messageBar().pushMessage("SIOSE Tools", ("Cargando en la tabla " + values_to_read), level=Qgis.Info)
        self.iface.mainWindow().repaint()
        self.fillTabWidget()
        self.iface.messageBar().clearWidgets()

    def selectRemoveQuery(self):
        query_id = self.queryComboBox.currentText()
        if self.query_coverages:
            if not self.is_siose_hr:
                if not query_id in self.queries[SDefs.CONST_QUERIES_COVERAGES_TAG].keys():
                    return
                self.queries[SDefs.CONST_QUERIES_COVERAGES_TAG].pop(query_id)
            else:
                if not query_id in self.queries[SDefs.CONST_QUERIES_COVERAGES_HR_TAG].keys():
                    return
                self.queries[SDefs.CONST_QUERIES_COVERAGES_HR_TAG].pop(query_id)
        else:
            if not query_id in self.queries[SDefs.CONST_QUERIES_USES_TAG].keys():
                return
            self.queries[SDefs.CONST_QUERIES_USES_TAG].pop(query_id)
        self.save_queries()
        self.queryComboBox.removeItem(self.queryComboBox.findText(query_id))
        self.queryComboBox.setCurrentIndex(0)

    def selectSaveQuery(self):
        query_id = self.queryComboBox.currentText()
        if self.query_coverages:
            if not self.is_siose_hr:
                if not query_id in self.queries[SDefs.CONST_QUERIES_COVERAGES_TAG].keys():
                    text, ok = QInputDialog.getText(self, 'Identificador de selección de coberturas',
                                                    'Identificador:')
                    if ok:
                        if text in self.queries[SDefs.CONST_QUERIES_COVERAGES_TAG].keys():
                            msg = self.tr(u'Existe una selección de coberturas con el id introducido, debe borrarla antes')
                            self.display_msg_error(msg)
                            return
                    else:
                        return
                    query_id = text
                    self.queries[SDefs.CONST_QUERIES_COVERAGES_TAG][query_id] = {}
            else:
                if not query_id in self.queries[SDefs.CONST_QUERIES_COVERAGES_HR_TAG].keys():
                    text, ok = QInputDialog.getText(self, 'Identificador de selección de coberturas',
                                                    'Identificador:')
                    if ok:
                        if text in self.queries[SDefs.CONST_QUERIES_COVERAGES_HR_TAG].keys():
                            msg = self.tr(u'Existe una selección de coberturas con el id introducido, debe borrarla antes')
                            self.display_msg_error(msg)
                            return
                    else:
                        return
                    query_id = text
                    self.queries[SDefs.CONST_QUERIES_COVERAGES_HR_TAG][query_id] = {}
        else:
            if not query_id in self.queries[SDefs.CONST_QUERIES_USES_TAG].keys():
                text, ok = QInputDialog.getText(self, 'Identificador de selección de usos',
                                                'Identificador:')
                if ok:
                    if text in self.queries[SDefs.CONST_QUERIES_COVERAGES_TAG].keys():
                        msg = self.tr(u'Existe una selección de usos con el id introducido, debe borrarla antes')
                        self.display_msg_error(msg)
                        return
                else:
                    return
                query_id = text
                self.queries[SDefs.CONST_QUERIES_USES_TAG][query_id] = {}
        need_save = False
        for row in range(self.tableWidget.rowCount()):
            if self.tableWidget.item(row, 0).checkState() == Qt.Checked:
                str_id = self.tableWidget.item(row, 0).text()
                id = int(str_id)
                widget = self.tableWidget.cellWidget(row, 2)
                percentage = 0
                if self.usesPercentagesInComboBox:
                    if isinstance(widget, QComboBox):
                        percentage = int(widget.currentText())
                else:
                    if isinstance(widget, QLineEdit):
                        percentage = int(widget.text())
                if self.query_coverages:
                    if not self.is_siose_hr:
                        self.queries[SDefs.CONST_QUERIES_COVERAGES_TAG][query_id][str_id] = percentage
                    else:
                        self.queries[SDefs.CONST_QUERIES_COVERAGES_HR_TAG][query_id][str_id] = percentage
                else:
                    self.queries[SDefs.CONST_QUERIES_USES_TAG][query_id][str_id] = percentage
                if not need_save:
                    need_save = True
        if need_save:
            self.save_queries()
            if self.queryComboBox.findText(query_id) == -1:
                self.queryComboBox.addItem(query_id)
                self.queryComboBox.setCurrentIndex(self.queryComboBox.findText(query_id))

    def setOnlySelected(self):
        self.spatial_selected_coverages_ids = []
        self.spatial_selected_uses_ids = []
        self.spatial_selected_features_ids = []
        if not self.onlySelectedCheckBox.isChecked():
            self.selectSource()
            return
        pos = self.sourceComboBox.currentIndex()
        layer_id = self.source_layer_id_by_combo_text[self.sourceComboBox.currentText()]
        layer = self.source_layer_by_layer_id[layer_id]
        layerProvider = layer.dataProvider()
        layer_uri = layerProvider.dataSourceUri()
        layer_file_path = layer_uri.split('|')[0]
        is_siose_hr, id = self.siose_gpkg_tools.getIsSioseHr(layer_file_path, False, True)
        if not is_siose_hr:
            layer_values_uri = layer_file_path + '|layername=' + SDefs.CONST_SIOSE_T_VALORES_LAYER
            layer_polygons_uri = layer_file_path + '|layername=' + SDefs.CONST_SIOSE_T_POLIGONOS_LAYER
        else:
            if self.query_coverages:
                layer_values_uri = layer_file_path + '|layername=' + SDefs.CONST_SIOSE_HR_T_VALORES_LAYER
                layer_polygons_uri = layer_file_path + '|layername=' + SDefs.CONST_SIOSE_HR_T_POLIGONOS_LAYER
            else:
                layer_values_uri = layer_file_path + '|layername=' + SDefs.CONST_SIOSE_HR_T_USOS_LAYER
                layer_polygons_uri = None
        # obtener layer de T_VALUES
        layer_values = None
        if not is_siose_hr:
            loaded_layers_values = QgsProject.instance().mapLayersByName(SDefs.CONST_SIOSE_T_VALORES_LAYER)
        else:
            if self.query_coverages:
                loaded_layers_values = QgsProject.instance().mapLayersByName(SDefs.CONST_SIOSE_HR_T_VALORES_LAYER)
            else:
                loaded_layers_values = QgsProject.instance().mapLayersByName(SDefs.CONST_SIOSE_HR_T_USOS_LAYER)
        for loaded_layer_values in loaded_layers_values:
            loaded_layer_values_provider = loaded_layer_values.dataProvider()
            loaded_layer_values_uri = loaded_layer_values_provider.dataSourceUri()
            loaded_layer_values_file_path = loaded_layer_values_uri.split('|')[0]
            if not is_siose_hr:
                loaded_layer_values_uri_short = loaded_layer_values_file_path + '|layername=' + SDefs.CONST_SIOSE_T_VALORES_LAYER
            else:
                if self.query_coverages:
                    loaded_layer_values_uri_short = loaded_layer_values_file_path + '|layername=' + SDefs.CONST_SIOSE_HR_T_VALORES_LAYER
                else:
                    loaded_layer_values_uri_short = loaded_layer_values_file_path + '|layername=' + SDefs.CONST_SIOSE_HR_T_USOS_LAYER
            if layer_values_uri == loaded_layer_values_uri_short:
                layer_values = loaded_layer_values
                break
        if not layer_values:
            if not is_siose_hr:
                layer_values = QgsVectorLayer(layer_values_uri, SDefs.CONST_SIOSE_T_VALORES_LAYER, "ogr")
            else:
                if self.query_coverages:
                    layer_values = QgsVectorLayer(layer_values_uri, SDefs.CONST_SIOSE_HR_T_VALORES_LAYER, "ogr")
                else:
                    layer_values = QgsVectorLayer(layer_values_uri, SDefs.CONST_SIOSE_HR_T_USOS_LAYER, "ogr")
            if not layer_values.isValid():
                if not is_siose_hr:
                    msg = self.tr(u'Cartografía SIOSE no se encuentra la tabla ' + SDefs.CONST_SIOSE_T_VALORES_LAYER)
                else:
                    if self.query_coverages:
                        msg = self.tr(u'Cartografía SIOSE AR no se encuentra la tabla ' + SDefs.CONST_SIOSE_HR_T_VALORES_LAYER)
                    else:
                        msg = self.tr(u'Cartografía SIOSE AR no se encuentra la tabla ' + SDefs.CONST_SIOSE_HR_T_USOS_LAYER)
                self.display_msg_error(msg)
                return
            else:
                QgsProject.instance().addMapLayer(layer_values)
        # obtener layer de T_POLIGONOS
        if self.query_coverages:
            if not is_siose_hr:
                layer_polygons_uri = layer_file_path + '|layername=' + SDefs.CONST_SIOSE_T_POLIGONOS_LAYER
            else:
                layer_polygons_uri = layer_file_path + '|layername=' + SDefs.CONST_SIOSE_HR_T_POLIGONOS_LAYER
            layer_polygons = None
            if not is_siose_hr:
                loaded_layers_polygons = QgsProject.instance().mapLayersByName(SDefs.CONST_SIOSE_T_POLIGONOS_LAYER)
            else:
                loaded_layers_polygons = QgsProject.instance().mapLayersByName(SDefs.CONST_SIOSE_HR_T_POLIGONOS_LAYER)
            for loaded_layer_polygons in loaded_layers_polygons:
                loaded_layer_polygons_provider = loaded_layer_polygons.dataProvider()
                loaded_layer_polygons_uri = loaded_layer_polygons_provider.dataSourceUri()
                loaded_layer_polygons_file_path = loaded_layer_polygons_uri.split('|')[0]
                if not is_siose_hr:
                    loaded_layer_polygons_uri_short = loaded_layer_polygons_file_path + '|layername=' + SDefs.CONST_SIOSE_T_POLIGONOS_LAYER
                else:
                    loaded_layer_polygons_uri_short = loaded_layer_polygons_file_path + '|layername=' + SDefs.CONST_SIOSE_HR_T_POLIGONOS_LAYER
                if layer_polygons_uri == loaded_layer_polygons_uri_short:
                    layer_polygons = loaded_layer_polygons
                    break
            if not layer_polygons:
                if not is_siose_hr:
                    layer_polygons = QgsVectorLayer(layer_values_uri, SDefs.CONST_SIOSE_T_POLIGONOS_LAYER, "ogr")
                else:
                    layer_polygons = QgsVectorLayer(layer_values_uri, SDefs.CONST_SIOSE_HR_T_POLIGONOS_LAYER, "ogr")
                if not layer_polygons.isValid():
                    if not is_siose_hr:
                        msg = self.tr(u'Cartografía SIOSE no se encuentra la tabla ' + SDefs.CONST_SIOSE_T_VALORES_LAYER)
                    else:
                        msg = self.tr(u'Cartografía SIOSE AR no se encuentra la tabla ' + SDefs.CONST_SIOSE_HR_T_VALORES_LAYER)
                    self.display_msg_error(msg)
                    return
                else:
                    QgsProject.instance().addMapLayer(layer_polygons)
            # Creación de la relación
            rel = QgsRelation()
            rel.setReferencingLayer(layer_values.id())
            rel.setReferencedLayer(layer_polygons.id())
            rel.addFieldPair(SDefs.CONST_SIOSE_ID_POLYGON, SDefs.CONST_SIOSE_ID_POLYGON)
            rel.setId('Relation SIOSE')
            rel.setName('Relación SIOSE ' + SDefs.CONST_SIOSE_ID_POLYGON)
            selected_features = layer_polygons.selectedFeatures()
            for selected_feature in selected_features:
                selected_feauture_id = selected_feature.id()
                self.spatial_selected_features_ids.append(selected_feauture_id)
                values_related = rel.getRelatedFeatures(selected_feature)
                for value_related in values_related:
                    if not is_siose_hr:
                        coverage_id = value_related[SDefs.CONST_SIOSE_ID_COVERAGES]
                    else:
                        coverage_id = value_related[SDefs.CONST_SIOSE_ID_COVERAGE]
                    if not coverage_id in self.spatial_selected_coverages_ids:
                        self.spatial_selected_coverages_ids.append(coverage_id)
            self.fillTabWidget()
        else:
            selected_features = layer_values.selectedFeatures()
            for selected_feature in selected_features:
                selected_feauture_id = selected_feature.id()
                self.spatial_selected_features_ids.append(selected_feauture_id)
                id_parcela = selected_feature[SDefs.CONST_SIOSE_ID_PARCELA]
                rotulo = selected_feature[SDefs.CONST_SIOSE_HR_SIOSE_CODE]
                str_rotulo_values = rotulo.split('_')
                for str_rotulo_value in str_rotulo_values:
                    str_percentage = re.findall(r'\d+', str_rotulo_value)
                    use_percentage = None
                    use_tag = None
                    if len(str_percentage) > 1:
                        msg = 'En el fichero: ' + layer_file_path
                        msg = msg + '\nen la parcela: ' + id_parcela
                        msg = msg + '\nel uso no es válido: ' + rotulo
                        msg = msg + '\nhay un uso con más de un número: ' + str_rotulo_value
                        self.display_msg_error(msg)
                        return
                    elif len(str_percentage) == 1:
                        str_percentage = str_percentage[0]
                        use_percentage = float(str_percentage)
                        use_tag = str_rotulo_value.replace(str_percentage, '')
                    if not use_percentage:
                        use_percentage = 100.
                        use_tag = str_rotulo_value
                    if not use_tag in self.useIdByTag:
                        msg = 'En el fichero: ' + layer_file_path
                        msg = msg + '\nen la parcela: ' + id_parcela
                        msg = msg + '\nel uso no es válido: ' + rotulo
                        msg = msg + '\nhay un id para el uso: ' + use_tag
                        self.display_msg_error(msg)
                        return
                    use_id = self.useIdByTag[use_tag]
                    if not use_id in self.spatial_selected_uses_ids:
                        self.spatial_selected_uses_ids.append(use_id)
            self.fillTabWidget()

    def setPercentageAll(self):
        value = 0
        if self.usesPercentagesInComboBox:
            value = self.commonPercentageComboBox.currentText()
        else:
            value = self.commonPercentageLineEdit.text()
        for row in range(self.tableWidget.rowCount()):
            widget = self.tableWidget.cellWidget(row, 2)
            if self.usesPercentagesInComboBox:
                if isinstance(widget, QComboBox):
                    index = widget.findText(value)
                    if index > -1:
                        widget.setCurrentIndex(index)
            else:
                if isinstance(widget, QLineEdit):
                    widget.setText(value)

    def setPercentageSelection(self):
        value = 0
        if self.usesPercentagesInComboBox:
            value = self.commonPercentageComboBox.currentText()
        else:
            value = self.commonPercentageLineEdit.text()
        for row in range(self.tableWidget.rowCount()):
            item = self.tableWidget.item(row, 1)
            if item.isSelected():
                widget = self.tableWidget.cellWidget(row, 2)
                if self.usesPercentagesInComboBox:
                    if isinstance(widget, QComboBox):
                        index = widget.findText(value)
                        if index > -1:
                            widget.setCurrentIndex(index)
                else:
                    if isinstance(widget, QLineEdit):
                        widget.setText(value)

    def selectSource(self):
        self.spatial_selected_features_ids = []
        self.coverages = {}
        self.spatial_selected_coverages_ids = []
        self.coverages_values_by_polygon_id = {}
        self.statistics_by_coverage_id = {}
        self.uses = {}
        self.useIdByTag = {}
        self.spatial_selected_uses_ids = []
        self.uses_values_by_parcela_id = {}
        self.statistics_by_use_id = {}
        self.onlySelectedCheckBox.setEnabled(False)
        self.queryComboBox.setEnabled(False)
        self.saveQueryPushButton.setEnabled(False)
        self.removeQueryPushButton.setEnabled(False)
        self.is_siose_hr = None
        current_text = self.sourceComboBox.currentText()
        if current_text == SDefs.CONST_NO_COMBO_SELECT:
            self.fillTabWidget()
            return
        pos = self.sourceComboBox.currentIndex()
        layer_id = self.source_layer_id_by_combo_text[self.sourceComboBox.currentText()]
        layer = self.source_layer_by_layer_id[layer_id]
        layerProvider = layer.dataProvider()
        layer_uri = layerProvider.dataSourceUri()
        layer_file_path = layer_uri.split('|')[0]
        self.is_siose_hr, id = self.siose_gpkg_tools.getIsSioseHr(layer_file_path, False, True)
        if not self.is_siose_hr and not self.query_coverages:
            msg = self.tr(u'La consulta de usos solo se puede realizar en SIOSE AR')
            self.display_msg_error(msg)
            self.close()
            return
        if len(layer.selectedFeatures()) > 0:
            self.onlySelectedCheckBox.setEnabled(True)
        self.load_queries()
        self.queryComboBox.setEnabled(True)
        self.saveQueryPushButton.setEnabled(True)
        if self.queryComboBox.count() > 1:
            self.queryComboBox.setEnabled(True)
        else:
            self.queryComboBox.setEnabled(False)
        self.selectQuery()
        # md = QgsProviderRegistry.instance().providerMetadata("ogr")
        # conn = md.createConnection(layer_file_path, {})
        # query = None
        # if not is_siose_hr:
        #     query = SDefs.CONST_SQL_GET_SIOSE_COVERAGES
        # else:
        #     if self.query_coverages:
        #         query = SDefs.CONST_SQL_GET_SIOSE_HR_COVERAGES
        #     else:
        #         query = SDefs.CONST_SQL_GET_SIOSE_HR_USES
        # # self.display_msg_error(query)
        # if self.query_coverages:
        #     values_to_read = "Coberturas"
        # else:
        #     values_to_read = 'Usos'
        # self.iface.messageBar().pushMessage("SIOSE Tools", ("Leyendo " + values_to_read), level=Qgis.Info)
        # self.iface.mainWindow().repaint()
        # results = conn.executeSql(query)
        # if self.query_coverages:
        #     for result in results:
        #         coverage_id = result[0]
        #         if len(self.coverages_ids_selected) > 0:
        #             if not coverage_id in self.coverages_ids_selected:
        #                 continue
        #         coverage_description = result[1]
        #         coverage_percentage = SDefs.CONST_PERCENTAGE_DEFAULT_VALUE
        #         coverage = {}
        #         coverage['description'] = coverage_description
        #         coverage['percentage'] = coverage_percentage
        #         self.coverages[coverage_id] = coverage
        #     if len(self.coverages) == 0:
        #         msg = self.tr(u'En la capa no hay ninguna cobertura de los tipos elegidos')
        #         self.display_msg_error(msg)
        #         self.close()
        #         self.iface.messageBar().clearWidgets()
        #         return
        # else:
        #     for result in results:
        #         use_id = result[0]
        #         if len(self.uses_ids_selected) > 0:
        #             if not use_id in self.uses_ids_selected:
        #                 continue
        #         use_description = result[1]
        #         use_percentage = SDefs.CONST_PERCENTAGE_DEFAULT_VALUE
        #         use_tag = result[2]
        #         use = {}
        #         use['description'] = use_description
        #         use['percentage'] = use_percentage
        #         use['etiqueta'] = use_tag
        #         self.uses[use_id] = use
        #         self.useIdByTag[use_tag] = use_id
        #     if len(self.uses) == 0:
        #         msg = self.tr(u'En la capa no hay ningún uso de los tipos elegidos')
        #         self.display_msg_error(msg)
        #         self.close()
        #         self.iface.messageBar().clearWidgets()
        #         return
        # self.iface.messageBar().clearWidgets()
        # if len(layer.selectedFeatures()) > 0:
        #     self.onlySelectedCheckBox.setEnabled(True)
        #     self.queryComboBox.setEnable(True)
        # self.iface.messageBar().pushMessage("SIOSE Tools", ("Cargando en la tabla " + values_to_read), level=Qgis.Info)
        # self.iface.mainWindow().repaint()
        # self.fillTabWidget()
        # self.iface.messageBar().clearWidgets()
