from __future__ import absolute_import
from __future__ import division
from __future__ import print_function
from __future__ import unicode_literals

iddtxt = """!IDD_Version 8.0.0.008
! **************************************************************************
! This file is the Input Data Dictionary (IDD) for EnergyPlus.
! The IDD defines the syntax and data model for each type of input "Object."
! Lines in EnergyPlus input files (and IDD) are limited to 500 characters.
!
! Object Description
! ------------------
! To define an object (a record with data), develop a key word that is unique
! Each data item to the object can be A (Alphanumeric string) or N (numeric)
! Number each A and N.  This will show how the data items will be put into the
! arrays that are passed to the Input Processor "Get" (GetObjectItem) routines.
! All alpha fields are limited to 100 characters.  Numeric fields should be
! valid numerics (can include such as 1.0E+05) and are placed into double
! precision variables.
!
! NOTE: Even though a field may be optional, a comma representing that field
!   must be included (unless it is the last field in the object).  Since the
!   entire input is "field-oriented" and not "keyword-oriented", the EnergyPlus
!   Input Processor must have some representation (even if blank) for each
!   field.
!
! Object Documentation
! --------------------
! In addition, the following special comments appear one per line and
! most are followed by a value.  Comments may apply to a field or the object
! or a group of objects.
!
! Field-level comments:
!
!  \\field           Name of field
!                     (should be succinct and readable, blanks are encouraged)
!
!  \\note            Note describing the field and its valid values. If multiple lines,
!                   start each line with \\note. Limit line length to 100 characters.
!
!  \\required-field  To flag fields which may not be left blank
!                     (this comment has no "value")
!
!  \\begin-extensible  Marks the first field at which the object accepts an extensible
!                   field set.  A fixed number of fields from this marker define the
!                   extensible field set, see the object code \\extensible for
!                   more information.
!
!  \\units           Units (must be from EnergyPlus standard units list)
!                   EnergyPlus units are standard SI units
!
!  \\ip-units        IP-Units (for use by input processors with IP units)
!                   This is only used if the default conversion is not
!                   appropriate.
!
!  \\unitsBasedOnField  For fields that may have multiple possible units, indicates
!                   the field in the object that can be used to determine
!                   the units. The field reference is in the A2 form.
!
!  \\minimum         Minimum that includes the following value
!
!  \\minimum>        Minimum that must be > than the following value
!
!  \\maximum         Maximum that includes the following value
!
!  \\maximum<        Maximum that must be < than the following value
!
!  \\default         Default for the field (if N/A then omit entire line)
!
!  \\deprecated      This field is not really used and will be deleted from the object.
!                   The required information is gotten internally or
!                   not needed by the program.
!
!  \\autosizable     Flag to indicate that this field can be used with the Auto
!                   Sizing routines to produce calculated results for the
!                   field.  If a value follows this, then that will be used
!                   when the "Autosize" feature is flagged.  To trigger
!                   autosizing for a field, enter Autosize as the field's
!                   value.  Only applicable to numeric fields.
!
!  \\autocalculatable Flag to indicate that this field can be automatically
!                   calculated. To trigger auto calculation for a field, enter
!                   Autocalculate as the field's value.  Only applicable to
!                   numeric fields.
!
!  \\type            Type of data for the field -
!                     integer
!                     real
!                     alpha       (arbitrary string),
!                     choice      (alpha with specific list of choices, see
!                                 \\key)
!                     object-list (link to a list of objects defined elsewhere,
!                                  see \\object-list and \\reference)
!                     external-list (uses a special list from an external source,
!                                    see \\external-list)
!                     node        (name used in connecting HVAC components)
!
!  \\retaincase      Retains the alphabetic case for alpha type fields
!
!  \\key             Possible value for "\\type choice" (blanks are significant)
!                     use multiple \\key lines to indicate all valid choices
!
!  \\object-list     Name of a list of user-provided object names that are valid
!                     entries for this field (used with "\\reference")
!                     see Zone and BuildingSurface:Detailed objects below for
!                     examples.
!                  ** Note that a field may have multiple \\object-list commands.
!
!  \\external-list   The values for this field should be selected from a special
!                   list generated outside of the IDD file. The choices for the
!                   special lists are:
!                        autoRDDvariable
!                        autoRDDmeter
!                        autoRDDvariableMeter
!                   When one of these are selected the options for the field
!                   are taken from the RDD or MDD file or both.
!
!  \\reference       Name of a list of names to which this object belongs
!                     used with "\\type object-list" and with "\\object-list"
!                     see Zone and BuildingSurface:Detailed objects below for
!                     examples:
!
!                        Zone,
!                          A1 , \\field Name
!                               \\type alpha
!                               \\reference ZoneNames
!
!                        BuildingSurface:Detailed,
!                          A4 , \\field Zone Name
!                               \\note Zone the surface is a part of
!                               \\type object-list
!                               \\object-list ZoneNames
!
!             For each zone, the field "Name" may be referenced
!             by other objects, such as BuildingSurface:Detailed, so it is
!             commented with "\\reference ZoneNames"
!             Fields that reference a zone name, such as BuildingSurface:Detailed's
!             "Zone Name", are commented as
!             "\\type object-list" and "\\object-list ZoneNames"
!             ** Note that a field may have multiple \\reference commands.
!             ** This is useful if the object belongs to a small specific
!             object-list as well as a larger more general object-list.
!
! Object-level comments:
!
!  \\memo            Memo describing the object. If multiple lines, start each line
!                   with \\memo.
!                   Limit line length to 100 characters.
!
!  \\unique-object   To flag objects which should appear only once in an idf
!                     (this comment has no "value")
!
!  \\required-object To flag objects which are required in every idf
!                     (this comment has no "value")
!
!  \\min-fields      Minimum number of fields that should be included in the
!                   object.  If appropriate, the Input Processor will fill
!                   any missing fields with defaults (for numeric fields).
!                   It will also supply that number of fields to the "get"
!                   routines using blanks for alpha fields (note -- blanks
!                   may not be allowable for some alpha fields).
!
!  \\obsolete        This object has been replaced though is kept (and is read)
!                   in the current version.  Please refer to documentation as
!                   to the dispersal of the object.  If this object is
!                   encountered in an IDF, the InputProcessor will post an
!                   appropriate message to the error file.
!                   usage:  \\obsolete New=>[New object name]
!
!  \\extensible:<#>  This object is dynamically extensible -- meaning, if you
!           change the IDD appropriately (if the object has a simple list
!           structure -- just add items to the list arguments (i.e. BRANCH
!           LIST). These will be automatically redimensioned and used during
!           the simulation. <#> should be entered by the developer to signify
!           how many of the last fields are needed to be extended (and EnergyPlus
!           will attempt to auto-extend the object).  The first field of the first
!           instance of the extensible field set is marked with \\begin-extensible.
!
!  \\begin-extensible See previous item, marks beginning of extensible fields in
!                   an object.
!
!  \\format          The object should have a special format when saved in
!                   the IDF Editor with the special format option enabled.
!                   The options include SingleLine, Vertices, CompactSchedule,
!                   FluidProperties, ViewFactors, and Spectral.
!                   The SingleLine option puts all the fields for the object
!                   on a single line. The Vertices option is used in objects
!                   that use X, Y and Z fields to format those three fields
!                   on a single line.
!                   The CompactSchedule formats that specific object.
!                   The FluidProperty option formats long lists of fluid
!                   properties to ten values per line.
!                   The ViewFactor option formats three fields related to
!                   view factors per line.
!                   The Spectral option formats the four fields related to
!                   window glass spectral data per line.
!
!   \\reference-class-name Adds the name of the class to the reference list
!                   similar to \\reference.
!
! Group-level comments:
!
!  \\group          Name for a group of related objects
!
!
! Notes on comments
! -----------------
!
! 1.  If a particular comment is not applicable (such as units, or default)
! then simply omit the comment rather than indicating N/A.
!
! 2.  Memos and notes should be brief (recommend 5 lines or less per block).
! More extensive explanations are expected to be in the user documentation
!
! Default IP conversions (no \\ip-units necessary)
!      $/(m3/s)               =>   $/(ft3/min)         0.000472000059660808
!      $/(W/K)                =>   $/(Btu/h-F)         0.52667614683731
!      $/kW                   =>   $/(kBtuh/h)         0.293083235638921
!      $/m2                   =>   $/ft2               0.0928939733269818
!      $/m3                   =>   $/ft3               0.0283127014102352
!      (kg/s)/W               =>   (lbm/sec)/(Btu/hr)  0.646078115385742
!      1/K                    =>   1/F                 0.555555555555556
!      1/m                    =>   1/ft                0.3048
!      A/K                    =>   A/F                 0.555555555555556
!      C                      =>   F                   1.8 (plus 32)
!      cm                     =>   in                  0.3937
!      cm2                    =>   inch2               0.15500031000062
!      deltaC                 =>   deltaF              1.8
!      deltaJ/kg              =>   deltaBtu/lb         0.0004299
!      g/GJ                   =>   lb/MWh              0.00793664091373665
!      g/kg                   =>   grains/lb           7
!      g/MJ                   =>   lb/MWh              7.93664091373665
!      g/mol                  =>   lb/mol              0.0022046
!      g/m-s                  =>   lb/ft-s             0.000671968949659
!      g/m-s-K                =>   lb/ft-s-F           0.000373574867724868
!      GJ                     =>   ton-hrs             78.9889415481832
!      J                      =>   Wh                  0.000277777777777778
!      J/K                    =>   Btu/F               526.565
!      J/kg                   =>   Btu/lb              0.00042986
!      J/kg-K                 =>   Btu/lb-F            0.000239005736137667
!      J/kg-K2                =>   Btu/lb-F2           0.000132889924714692
!      J/kg-K3                =>   Btu/lb-F3           7.38277359526066E-05
!      J/m2-K                 =>   Btu/ft2-F           4.89224766847393E-05
!      J/m3                   =>   Btu/ft3             2.68096514745308E-05
!      J/m3-K                 =>   Btu/ft3-F           1.49237004739337E-05
!      K                      =>   R                   1.8
!      K/m                    =>   F/ft                0.54861322767449
!      kg                     =>   lb                  2.2046
!      kg/J                   =>   lb/Btu              2325.83774250441
!      kg/kg-K                =>   lb/lb-F             0.555555555555556
!      kg/m                   =>   lb/ft               0.67196893069637
!      kg/m2                  =>   lb/ft2              0.204794053596664
!      kg/m3                  =>   lb/ft3              0.062428
!      kg/m-s                 =>   lb/ft-s             0.67196893069637
!      kg/m-s-K               =>   lb/ft-s-F           0.373316072609094
!      kg/m-s-K2              =>   lb/ft-s-F2          0.207397818116164
!      kg/Pa-s-m2             =>   lb/psi-s-ft2        1412.00523459398
!      kg/s                   =>   lb/s                2.20462247603796
!      kg/s2                  =>   lb/s2               2.2046
!      kg/s-m                 =>   lb/s-ft             0.67196893069637
!      kJ/kg                  =>   Btu/lb              0.429925
!      kPa                    =>   psi                 0.145038
!      L/day                  =>   pint/day            2.11337629827348
!      L/GJ                   =>   gal/kWh             0.000951022349025202
!      L/kWh                  =>   pint/kWh            2.11337629827348
!      L/MJ                   =>   gal/kWh             0.951022349025202
!      lux                    =>   foot-candles        0.092902267
!      m                      =>   ft                  3.28083989501312
!      m/hr                   =>   ft/hr               3.28083989501312
!      m/s                    =>   ft/min              196.850393700787
!      m/s                    =>   miles/hr            2.2369362920544
!      m/yr                   =>   inch/yr             39.3700787401575
!      m2                     =>   ft2                 10.7639104167097
!      m2/m                   =>   ft2/ft              3.28083989501312
!      m2/person              =>   ft2/person          10.764961
!      m2/s                   =>   ft2/s               10.7639104167097
!      m2-K/W                 =>   ft2-F-hr/Btu        5.678263
!      m3                     =>   ft3                 35.3146667214886
!      m3                     =>   gal                 264.172037284185
!      m3/GJ                  =>   ft3/MWh             127.13292
!      m3/hr                  =>   ft3/hr              35.3146667214886
!      m3/hr-m2               =>   ft3/hr-ft2          3.28083989501312
!      m3/hr-person           =>   ft3/hr-person       35.3146667214886
!      m3/kg                  =>   ft3/lb              16.018
!      m3/m2                  =>   ft3/ft2             3.28083989501312
!      m3/MJ                  =>   ft3/kWh             127.13292
!      m3/person              =>   ft3/person          35.3146667214886
!      m3/s                   =>   ft3/min             2118.88000328931
!      m3/s-m                 =>   ft3/min-ft          645.89
!      m3/s-m2                =>   ft3/min-ft2         196.85
!      m3/s-person            =>   ft3/min-person      2118.6438
!      m3/s-W                 =>   (ft3/min)/(Btu/h)   621.099127332943
!      N-m                    =>   lbf-in              8.85074900525547
!      N-s/m2                 =>   lbf-s/ft2           0.0208857913669065
!      Pa                     =>   psi                 0.000145037743897283
!      percent/K              =>   percent/F           0.555555555555556
!      person/m2              =>   person/ft2          0.0928939733269818
!      s/m                    =>   s/ft                0.3048
!      V/K                    =>   V/F                 0.555555555555556
!      W                      =>   Btu/h               3.4121412858518
!      W/(m3/s)               =>   W/(ft3/min)         0.0004719475
!      W/K                    =>   Btu/h-F             1.89563404769544
!      W/m                    =>   Btu/h-ft            1.04072
!      W/m2                   =>   Btu/h-ft2           0.316957210776545
!      W/m2                   =>   W/ft2               0.09290304
!      W/m2-K                 =>   Btu/h-ft2-F         0.176110194261872
!      W/m2-K2                =>   Btu/h-ft2-F2        0.097826
!      W/m-K                  =>   Btu-in/h-ft2-F      6.93481276005548
!      W/m-K2                 =>   Btu/h-F2-ft         0.321418310071648
!      W/m-K3                 =>   Btu/h-F3-ft         0.178565727817582
!      W/person               =>   Btu/h-person        3.4121412858518
!
! Other conversions supported (needs the \\ip-units code)
!
!      kPa                    =>   inHg                0.29523
!      m                      =>   in                  39.3700787401575
!      m3/s                   =>   gal/min             15850.3222370511
!      Pa                     =>   ftH2O               0.00033455
!      Pa                     =>   inH2O               0.00401463
!      Pa                     =>   inHg                0.00029613
!      Pa                     =>   Pa                  1
!      W                      =>   W                   1
!      W/m2                   =>   W/m2                1
!      W/m-K                  =>   Btu/h-ft-F          0.577796066000163
!      W/person               =>   W/person            1
!
! Units fields that are not translated
!      $
!      1/hr
!      A
!      Ah
!      A/V
!      Availability
!      Control
!      cycles/hr
!      days
!      deg
!      dimensionless
!      eV
!      hr
!      J/J
!      kg/kg
!      kg-H2O/kg-air
!      kmol
!      kmol/s
!      m3/m3
!      minutes
!      Mode
!      ms
!      ohms
!      percent
!      ppm
!      rev/min
!      s
!      V
!      VA
!      W/m2 or deg C
!      W/m2, W or deg C
!      W/s
!      W/W
!      years
! **************************************************************************

Lead Input;

Simulation Data;

\\group Simulation Parameters

Version,
      \\memo Specifies the EnergyPlus version of the IDF file.
      \\unique-object
      \\format singleLine
  A1 ; \\Field Version Identifier
      \\required-field
      \\default 7.0

SimulationControl,
      \\unique-object
      \\memo Note that the following 3 fields are related to the Sizing:Zone, Sizing:System,
      \\memo and Sizing:Plant objects.  Having these fields set to Yes but no corresponding
      \\memo Sizing object will not cause the sizing to be done. However, having any of these
      \\memo fields set to No, the corresponding Sizing object is ignored.
      \\memo Note also, if you want to do system sizing, you must also do zone sizing in the same
      \\memo run or an error will result.
  A1, \\field Do Zone Sizing Calculation
      \\note If Yes, Zone sizing is accomplished from corresponding Sizing:Zone objects
      \\note and autosize fields.
      \\type choice
      \\key Yes
      \\key No
      \\default No
  A2, \\field Do System Sizing Calculation
      \\note If Yes, System sizing is accomplished from corresponding Sizing:System objects
      \\note and autosize fields.
      \\note If Yes, Zone sizing (previous field) must also be Yes.
      \\type choice
      \\key Yes
      \\key No
      \\default No
  A3, \\field Do Plant Sizing Calculation
      \\note If Yes, Plant sizing is accomplished from corresponding Sizing:Plant objects
      \\note and autosize fields.
      \\type choice
      \\key Yes
      \\key No
      \\default No
  A4, \\field Run Simulation for Sizing Periods
      \\note If Yes, SizingPeriod:* objects are executed and results from those may be displayed..
      \\type choice
      \\key Yes
      \\key No
      \\default Yes
  A5; \\field Run Simulation for Weather File Run Periods
      \\note If Yes, RunPeriod:* objects are executed and results from those may be displayed..
      \\type choice
      \\key Yes
      \\key No
      \\default Yes

Building,
       \\memo Describes parameters that are used during the simulation
       \\memo of the building. There are necessary correlations between the entries for
       \\memo this object and some entries in the Site:WeatherStation and
       \\memo Site:HeightVariation objects, specifically the Terrain field.
       \\unique-object
       \\required-object
       \\min-fields 8
  A1 , \\field Name
       \\required-field
       \\retaincase
       \\default NONE
  N1 , \\field North Axis
       \\note degrees from true North
       \\units deg
       \\type real
       \\default 0.0
  A2 , \\field Terrain
       \\note  Country=FlatOpenCountry | Suburbs=CountryTownsSuburbs | City=CityCenter | Ocean=body of water (5km) | Urban=Urban-Industrial-Forest
       \\type choice
       \\key Country
       \\key Suburbs
       \\key City
       \\key Ocean
       \\key Urban
       \\default Suburbs
  N2 , \\field Loads Convergence Tolerance Value
       \\note Loads Convergence Tolerance Value is a fraction of load
       \\type real
       \\minimum> 0.0
       \\maximum .5
       \\default .04
  N3 , \\field Temperature Convergence Tolerance Value
       \\units deltaC
       \\type real
       \\minimum> 0.0
       \\maximum .5
       \\default .4
  A3 , \\field Solar Distribution
       \\note  MinimalShadowing | FullExterior | FullInteriorAndExterior | FullExteriorWithReflections | FullInteriorAndExteriorWithReflections
       \\type choice
       \\key MinimalShadowing
       \\key FullExterior
       \\key FullInteriorAndExterior
       \\key FullExteriorWithReflections
       \\key FullInteriorAndExteriorWithReflections
       \\default FullExterior
  N4 , \\field Maximum Number of Warmup Days
       \\note EnergyPlus will only use as many warmup days as needed to reach convergence tolerance.
       \\note This field's value should NOT be set less than 25.
       \\type integer
       \\minimum> 0
       \\default 25
  N5 ; \\field Minimum Number of Warmup Days
       \\note The minimum number of warmup days that produce enough temperature and flux history
       \\note to start EnergyPlus simulation for all reference buildings was suggested to be 6.
       \\note When this field is greater than the maximum warmup days defined previous field
       \\note the maximum number of warmup days will be reset to the minimum value entered here.
       \\note Warmup days will be set to be the value you entered when it is less than the default 6.
       \\type integer
       \\minimum> 0
       \\default 6

ShadowCalculation,
       \\unique-object
       \\memo This object is used to control details of the solar, shading, and daylighting models
  A1 , \\field Calculation Method
       \\note choose calculation method. note that TimestepFrequency is only needed for certain cases
       \\note and can increase execution time significantly.
       \\type choice
       \\key AverageOverDaysInFrequency
       \\key TimestepFrequency
       \\default AverageOverDaysInFrequency
  N1 , \\field Calculation Frequency
       \\required-field
       \\type integer
       \\minimum 1
       \\default 20
       \\note enter number of days
       \\note this field is only used if the previous field is set to AverageOverDaysInFrequency
       \\note 0=Use Default Periodic Calculation|<else> calculate every <value> day
       \\note only really applicable to RunPeriods
       \\note warning issued if >31
  N2 , \\field Maximum Figures in Shadow Overlap Calculations
       \\note Number of allowable figures in shadow overlap calculations
       \\type integer
       \\minimum 200
       \\default 15000
  A2 , \\field Polygon Clipping Algorithm
       \\note Advanced Feature.  Internal default is SutherlandHodgman
       \\note Refer to InputOutput Reference and Engineering Reference for more information
       \\type choice
       \\key ConvexWeilerAtherton
       \\key SutherlandHodgman
  A3 ; \\field Sky Diffuse Modeling Algorithm
       \\note Advanced Feature.  Internal default is SimpleSkyDiffuseModeling
       \\note If you have shading elements that change transmittance over the
       \\note year, you may wish to choose the detailed method.
       \\note Refer to InputOutput Reference and Engineering Reference for more information
       \\type choice
       \\key SimpleSkyDiffuseModeling
       \\key DetailedSkyDiffuseModeling


SurfaceConvectionAlgorithm:Inside,
       \\memo Default indoor surface heat transfer convection algorithm to be used for all zones
       \\unique-object
       \\format singleLine
  A1 ; \\field Algorithm
       \\required-field
       \\type choice
       \\key Simple
       \\key TARP
       \\key CeilingDiffuser
       \\key AdaptiveConvectionAlgorithm
       \\default TARP
       \\note Simple = constant value natural convection (ASHRAE)
       \\note TARP = variable natural convection based on temperature difference (ASHRAE, Walton)
       \\note CeilingDiffuser = ACH-based forced and mixed convection correlations
       \\note  for ceiling diffuser configuration with simple natural convection limit
       \\note AdaptiveConvectionAlgorithm = dynamic selection of convection models based on conditions

SurfaceConvectionAlgorithm:Outside,
       \\memo Default outside surface heat transfer convection algorithm to be used for all zones
       \\unique-object
       \\format singleLine
  A1 ; \\field Algorithm
       \\required-field
       \\type choice
       \\key SimpleCombined
       \\key TARP
       \\key MoWiTT
       \\key DOE-2
       \\key AdaptiveConvectionAlgorithm
       \\default DOE-2
       \\note SimpleCombined = Combined radiation and convection coefficient using simple ASHRAE model
       \\note TARP = correlation from models developed by ASHRAE, Walton, and Sparrow et. al.
       \\note MoWiTT = correlation from measurements by Klems and Yazdanian for smooth surfaces
       \\note DOE-2 = correlation from measurements by Klems and Yazdanian for rough surfaces
       \\note AdaptiveConvectionAlgorithm = dynamic selection of correlations based on conditions


HeatBalanceAlgorithm,
       \\memo Determines which Heat Balance Algorithm will be used ie.
       \\memo CTF (Conduction Transfer Functions),
       \\memo EMPD (Effective Moisture Penetration Depth with Conduction Transfer Functions).
       \\memo Advanced/Research Usage: CondFD (Conduction Finite Difference)
       \\memo Advanced/Research Usage: ConductionFiniteDifferenceSimplified
       \\memo Advanced/Research Usage: HAMT (Combined Heat And Moisture Finite Element)
       \\unique-object
       \\format singleLine
  A1 , \\field Algorithm
       \\required-field
       \\type choice
       \\key ConductionTransferFunction
       \\key MoisturePenetrationDepthConductionTransferFunction
       \\key ConductionFiniteDifference
       \\key CombinedHeatAndMoistureFiniteElement
       \\default ConductionTransferFunction
  N1 , \\field Surface Temperature Upper Limit
       \\type real
       \\minimum 200
       \\default 200
       \\units C
  N2 , \\field Minimum Surface Convection Heat Transfer Coefficient Value
       \\units W/m2-K
       \\default 0.1
       \\minimum> 0.0
  N3 ; \\field Maximum Surface Convection Heat Transfer Coefficient Value
       \\units W/m2-K
       \\default 1000
       \\minimum 1.0

HeatBalanceSettings:ConductionFiniteDifference,
       \\memo Determines settings for the Conduction Finite Difference
       \\memo algorithm for surface heat transfer modeling.
       \\unique-object
  A1 , \\field Difference Scheme
       \\type choice
       \\key CrankNicholsonSecondOrder
       \\key FullyImplicitFirstOrder
       \\default FullyImplicitFirstOrder
  N1 , \\field Space Discretization Constant
       \\note increase or decrease number of nodes
       \\type real
       \\default 3
  N2 , \\field Relaxation Factor
       \\type real
       \\default 1.0
       \\minimum 0.01
       \\maximum 1.0
  N3 ; \\field Inside Face Surface Temperature Convergence Criteria
       \\type real
       \\default 0.002
       \\minimum 1.0E-7
       \\maximum 0.01

ZoneAirHeatBalanceAlgorithm,
       \\memo Determines which algorithm will be used to solve the zone air heat balance.
       \\unique-object
       \\format singleLine
  A1 ; \\field Algorithm
       \\type choice
       \\key ThirdOrderBackwardDifference
       \\key AnalyticalSolution
       \\key EulerMethod
       \\default ThirdOrderBackwardDifference

ZoneAirContaminantBalance,
       \\memo Determines which contaminant concentration will be simulates.
       \\unique-object
       \\format singleLine
  A1 , \\field Carbon Dioxide Concentration
       \\note If Yes, CO2 simulation will be performed.
       \\type choice
       \\key Yes
       \\key No
       \\default No
  A2 , \\field Outdoor Carbon Dioxide Schedule Name
       \\note Schedule values should be in parts per million (ppm)
       \\type object-list
       \\object-list ScheduleNames
  A3 , \\field Generic Contaminant Concentration
       \\note If Yes, generic contaminant simulation will be performed.
       \\type choice
       \\key Yes
       \\key No
       \\default No
  A4 ; \\field Outdoor Generic Contaminant Schedule Name
       \\note Schedule values should be generic contaminant concentration in parts per
       \\note million (ppm)
       \\type object-list
       \\object-list ScheduleNames

ZoneCapacitanceMultiplier:ResearchSpecial,
       \\unique-object
       \\format singleLine
       \\memo Multiplier altering the relative capacitance of the air compared to an empty zone
       \\min-fields 4
  N1 , \\field Temperature Capacity Multiplier
       \\type real
       \\default 1.0
       \\minimum> 0.0
       \\note Used to alter the capacitance of zone air with respect to heat or temperature
  N2 , \\field Humidity Capacity Multiplier
       \\type real
       \\default 1.0
       \\minimum> 0.0
       \\note Used to alter the capacitance of zone air with respect to moisture or humidity ratio
  N3 , \\field Carbon Dioxide Capacity Multiplier
       \\type real
       \\default 1.0
       \\minimum> 0.0
       \\note Used to alter the capacitance of zone air with respect to zone air carbob dioxide concentration
  N4 ; \\field Generic Contaminant Capacity Multiplier
       \\type real
       \\default 1.0
       \\minimum> 0.0
       \\note Used to alter the capacitance of zone air with respect to zone air generic contaminant concentration

Timestep,
       \\memo Specifies the "basic" timestep for the simulation. The
       \\memo value entered here is also known as the Zone Timestep.  This is used in
       \\memo the Zone Heat Balance Model calculation as the driving timestep for heat
       \\memo transfer and load calculations.
       \\unique-object
       \\format singleLine
  N1 ; \\field Number of Timesteps per Hour
       \\required-field
       \\note Number in hour: normal validity 4 to 60: 6 suggested
       \\note Must be evenly divisible into 60
       \\note Allowable values include 1, 2, 3, 4, 5, 6, 10, 12, 15, 20, 30, and 60
       \\note Normal 6 is mimimum as lower values may cause inaccuracies
       \\note A minimum value of 20 is suggested for both ConductionFiniteDifference
       \\note and CombinedHeatAndMoistureFiniteElement surface heat balance alogorithms
       \\note A minimum of 12 is suggested for simulations involving a Vegetated Roof (Material:RoofVegetation).
       \\default 6
       \\type integer
       \\minimum 1
       \\maximum 60

ConvergenceLimits,
       \\memo Specifies limits on HVAC system simulation timesteps and iterations.
       \\memo This item is an advanced feature that should be used only with caution.
       \\unique-object
  N1 , \\field Minimum System Timestep
       \\units minutes
       \\type integer
       \\note 0 sets the minimum to the zone timestep (ref: Timestep)
       \\note 1 is normal (ratchet down to 1 minute)
       \\note setting greater than zone timestep (in minutes) will effectively set to zone timestep
       \\minimum 0
       \\maximum 60
  N2 , \\field Maximum HVAC Iterations
       \\type integer
       \\default 20
       \\minimum 1
  N3 , \\field Minimum Plant Iterations
       \\note Controls the minimum number of plant system solver iterations within a single HVAC iteration
       \\note Larger values will increase runtime but might improve solution accuracy for complicated plant systems
       \\note Complex plants include: several interconnected loops, heat recovery, thermal load following generators, etc.
       \\type integer
       \\default 2
       \\minimum 1
  N4 ; \\field Maximum Plant Iterations
       \\note Controls the maximum number of plant system solver iterations within a single HVAC iteration
       \\note Smaller values might decrease runtime but could decrease solution accuracy for complicated plant systems
       \\type integer
       \\default 8
       \\minimum 2

ProgramControl,
       \\memo used to support various efforts in time reduction for simulation including threading
  N1 ; \\field Number of Threads Allowed
       \\type integer
       \\minimum 0
       \\note This is currently used only in the Interior Radiant Exchange module -- view factors on # surfaces
       \\note if value is 0, then maximum number allowed will be used.


\\group Compliance Objects

Compliance:Building,
       \\memo Building level inputs related to compliance to building standards, building codes, and beyond energy code programs.
       \\unique-object
       \\min-fields 1
  N1;  \\field Building Rotation for Appendix G
       \\note Additional degrees of rotation to be used with the requirement in ASHRAE Standard 90.1 Appendix G
       \\note that states that the baseline building should be rotated in four directions.
       \\units deg
       \\type real
       \\default 0.0

\\group Location and Climate

Site:Location,
       \\memo Specifies the building's location. Only one location is allowed.
       \\memo Weather data file location, if it exists, will override this object.
       \\unique-object
       \\min-fields 5
  A1 , \\field Name
       \\required-field
       \\type  alpha
  N1 , \\field Latitude
       \\units deg
       \\minimum -90.0
       \\maximum +90.0
       \\default 0.0
       \\note + is North, - is South, degree minutes represented in decimal (i.e. 30 minutes is .5)
       \\type real
  N2 , \\field Longitude
       \\units deg
       \\minimum -180.0
       \\maximum +180.0
       \\default 0.0
       \\note - is West, + is East, degree minutes represented in decimal (i.e. 30 minutes is .5)
       \\type real
  N3 , \\field Time Zone
       \\note basic these limits on the WorldTimeZone Map (2003)
       \\units hr
       \\minimum -12.0
       \\maximum +14.0
       \\default 0.0
       \\note  Time relative to GMT. Decimal hours.
       \\type real
  N4 ; \\field Elevation
       \\units m
       \\minimum -300.0
       \\maximum< 8900.0
       \\default 0.0
       \\type real

SizingPeriod:DesignDay,
      \\memo The design day object creates the parameters for the program to create
      \\memo the 24 hour weather profile that can be used for sizing as well as
      \\memo running to test the other simulation parameters. Parameters in this
      \\memo include a date (month and day), a day type (which uses the appropriate
      \\memo schedules for either sizing or simple tests), min/max temperatures,
      \\memo wind speeds, and solar radiation values.
  A1, \\field Name
       \\type alpha
       \\required-field
       \\reference DesignDays
       \\reference RunPeriodsAndDesignDays
  N1,  \\field Month
       \\required-field
       \\minimum 1
       \\maximum 12
       \\type integer
  N2,  \\field Day of Month
       \\required-field
       \\minimum 1
       \\maximum 31
       \\type integer
       \\note must be valid for Month field
  A2,  \\field Day Type
       \\required-field
       \\note Day Type selects the schedules appropriate for this design day
       \\type choice
       \\key Sunday
       \\key Monday
       \\key Tuesday
       \\key Wednesday
       \\key Thursday
       \\key Friday
       \\key Saturday
       \\key Holiday
       \\key SummerDesignDay
       \\key WinterDesignDay
       \\key CustomDay1
       \\key CustomDay2
  N3,  \\field Maximum Dry-Bulb Temperature
       \\required-field
       \\units C
       \\minimum -70
       \\maximum 70
       \\type real
  N4,  \\field Daily Dry-Bulb Temperature Range
       \\note Must still produce appropriate maximum dry bulb (within range)
       \\note This field is not needed if Dry-Bulb Temperature Range Modifier Type
       \\note is "delta".
       \\units deltaC
       \\minimum 0
       \\default 0
       \\type real
  A3,  \\field Dry-Bulb Temperature Range Modifier Type
       \\note Type of modifier to the dry-bulb temperature calculated for the timestep
       \\type choice
       \\key MultiplierSchedule
       \\key DifferenceSchedule
       \\key DefaultMultipliers
       \\default DefaultMultipliers
  A4,  \\field Dry-Bulb Temperature Range Modifier Day Schedule Name
       \\type object-list
       \\object-list DayScheduleNames
       \\note Only used when previous field is "MultiplierSchedule" or "DifferenceSchedule".
       \\note For type "MultiplierSchedule"  the hour/time interval values should specify
       \\note   the fraction (0-1) of the dry-bulb temperature range to be subtracted
       \\note   from the maximum dry-bulb temperature for each timestep in the day
       \\note For type "DifferenceSchedule" the values should specify a number to be subtracted
       \\note   from the maximum dry-bulb temperature for each timestep in the day.
       \\note Note that numbers in the difference schedule cannot be negative as that
       \\note   would result in a higher maximum than the maximum previously specified.
  A5,  \\field Humidity Condition Type
       \\note values/schedules indicated here and in subsequent fields create the humidity
       \\note values in the 24 hour design day conditions profile.
       \\type choice
       \\key WetBulb
       \\key DewPoint
       \\key HumidityRatio
       \\key Enthalpy
       \\key RelativeHumiditySchedule
       \\key WetBulbProfileMultiplierSchedule
       \\key WetBulbProfileDifferenceSchedule
       \\key WetBulbProfileDefaultMultipliers
       \\default WetBulb
  N5,  \\field Wetbulb or DewPoint at Maximum Dry-Bulb
       \\note Wetbulb or dewpoint temperature coincident with the maximum temperature.
       \\note Required only if field Humidity Condition Type is "Wetbulb", "Dewpoint",
       \\note "WetBulbProfileMultiplierSchedule", "WetBulbProfileDifferenceSchedule",
       \\note or "WetBulbProfileDefaultMultipliers"
       \\type real
       \\units C
  A6,  \\field Humidity Condition Day Schedule Name
       \\type object-list
       \\object-list DayScheduleNames
       \\note Only used when Humidity Condition Type is "RelativeHumiditySchedule",
       \\note  "WetBulbProfileMultiplierSchedule", or "WetBulbProfileDifferenceSchedule"
       \\note For type "RelativeHumiditySchedule", the hour/time interval values should specify
       \\note   relative humidity (percent) from 0.0 to 100.0.
       \\note For type "WetBulbProfileMultiplierSchedule" the hour/time interval values should specify
       \\note   the fraction (0-1) of the wet-bulb temperature range to be subtracted from the
       \\note   maximum wet-bulb temperature for each timestep in the day (units = Fraction)
       \\note For type "WetBulbProfileDifferenceSchedule" the values should specify a number to be subtracted
       \\note   from the maximum wet-bulb temperature for each timestep in the day. (units = deltaC)
  N6,  \\field Humidity Ratio at Maximum Dry-Bulb
       \\note Humidity ratio coincident with the maximum temperature (constant humidity ratio throughout day).
       \\note Required only if field Humidity Condition Type is "HumidityRatio".
       \\type real
       \\units kgWater/kgDryAir
  N7,  \\field Enthalpy at Maximum Dry-Bulb  !will require units transition.
       \\note Enthalpy coincident with the maximum temperature.
       \\note Required only if field Humidity Condition Type is "Enthalpy".
       \\type real
       \\units J/kg
  N8,  \\field Daily Wet-Bulb Temperature Range
       \\units deltaC
       \\note Required only if Humidity Condition Type = "WetbulbProfileMultiplierSchedule" or
       \\note "WetBulbProfileDefaultMultipliers"
  N9,  \\field Barometric Pressure
       \\note This field's value is also checked against the calculated "standard barometric pressure"
       \\note for the location.  If out of range (>10%) or blank, then is replaced by standard value.
       \\units Pa
       \\minimum 31000
       \\maximum 120000
       \\type real
       \\ip-units inHg
  N10, \\field Wind Speed
       \\required-field
       \\units m/s
       \\minimum 0
       \\maximum 40
       \\ip-units miles/hr
       \\type real
  N11, \\field Wind Direction
       \\required-field
       \\units deg
       \\minimum 0
       \\maximum 360
       \\note North=0.0 East=90.0
       \\note 0 and 360 are the same direction.
       \\type real
  A7,  \\field Rain Indicator
       \\note Yes is raining (all day), No is not raining
       \\type choice
       \\key Yes
       \\key No
       \\default No
  A8,  \\field Snow Indicator
       \\type choice
       \\key Yes
       \\key No
       \\default No
       \\note Yes is Snow on Ground, No is no Snow on Ground
  A9,  \\field Daylight Saving Time Indicator
       \\note Yes -- use schedules modified for Daylight Saving Time Schedules.
       \\note No - do not use schedules modified for Daylight Saving Time Schedules
       \\type choice
       \\key Yes
       \\key No
       \\default No
  A10, \\field Solar Model Indicator
       \\type choice
       \\key ASHRAEClearSky
       \\key ZhangHuang
       \\key Schedule
       \\key ASHRAETau
       \\default ASHRAEClearSky
  A11, \\field Beam Solar Day Schedule Name
       \\note if Solar Model Indicator = Schedule, then beam schedule name (for day)
       \\type object-list
       \\object-list DayScheduleNames
  A12, \\field Diffuse Solar Day Schedule Name
       \\note if Solar Model Indicator = Schedule, then diffuse schedule name (for day)
       \\type object-list
       \\object-list DayScheduleNames
  N12, \\field ASHRAE Clear Sky Optical Depth for Beam Irradiance (taub)
       \\units dimensionless
       \\note Required if Solar Model Indicator = ASHRAETau
       \\minimum 0
       \\maximum 1
       \\default 0
  N13, \\field ASHRAE Clear Sky Optical Depth for Diffuse Irradiance (taud)
       \\units dimensionless
       \\note Required if Solar Model Indicator = ASHRAETau
       \\minimum 0
       \\maximum 3
       \\default 0
  N14; \\field Sky Clearness
       \\note Used if Sky Model Indicator = ASHRAEClearSky or ZhangHuang
       \\minimum 0.0
       \\maximum 1.2
       \\default 0.0
       \\note 0.0 is totally unclear, 1.0 is totally clear
       \\type real

SizingPeriod:WeatherFileDays,
       \\memo Use a weather file period for design sizing calculations.
  A1 , \\field Name
       \\reference DesignDays
       \\reference RunPeriodsAndDesignDays
       \\required-field
       \\note user supplied name for reporting
  N1 , \\field Begin Month
       \\required-field
       \\minimum 1
       \\maximum 12
       \\type integer
  N2 , \\field Begin Day of Month
       \\required-field
       \\minimum 1
       \\maximum 31
       \\type integer
  N3 , \\field End Month
       \\required-field
       \\minimum 1
       \\maximum 12
       \\type integer
  N4 , \\field End Day of Month
       \\required-field
       \\minimum 1
       \\maximum 31
       \\type integer
  A2 , \\field Day of Week for Start Day
       \\note  =[|Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|SummerDesignDay|WinterDesignDay|
       \\note    |CustomDay1|CustomDay2];
       \\note if you use SummerDesignDay or WinterDesignDay or the CustomDays then this will apply
       \\note to the whole period; other days (i.e., Monday) will signify a start day and
       \\note normal sequence ofsubsequent days
       \\default Monday
       \\type choice
       \\key Sunday
       \\key Monday
       \\key Tuesday
       \\key Wednesday
       \\key Thursday
       \\key Friday
       \\key Saturday
       \\key SummerDesignDay
       \\key WinterDesignDay
       \\key CustomDay1
       \\key CustomDay2
  A3,  \\field Use Weather File Daylight Saving Period
       \\note If yes or blank, use daylight saving period as specified on Weatherfile.
       \\note If no, do not use the daylight saving period as specified on the Weatherfile.
       \\type choice
       \\default Yes
       \\key Yes
       \\key No
  A4;  \\field Use Weather File Rain and Snow Indicators
       \\type choice
       \\key Yes
       \\key No
       \\default Yes

SizingPeriod:WeatherFileConditionType,
       \\memo Use a weather file period for design sizing calculations.
       \\memo EPW weather files are created with typical and extreme periods
       \\memo created heuristically from the weather file data.  For more
       \\memo details on these periods, see AuxiliaryPrograms document.
  A1 , \\field Name
       \\required-field
       \\reference DesignDays
       \\reference RunPeriodsAndDesignDays
       \\note user supplied name for reporting
  A2 , \\field Period Selection
       \\required-field
       \\retaincase
       \\note Following is a list of all possible types of Extreme and Typical periods that
       \\note might be identified in the Weather File. Not all possible types are available
       \\note for all weather files.
       \\type choice
       \\key SummerExtreme
       \\key SummerTypical
       \\key WinterExtreme
       \\key WinterTypical
       \\key AutumnTypical
       \\key SpringTypical
       \\key WetSeason
       \\key DrySeason
       \\key NoDrySeason
       \\key NoWetSeason
       \\key TropicalHot
       \\key TropicalCold
       \\key NoDrySeasonMax
       \\key NoDrySeasonMin
       \\key NoWetSeasonMax
       \\key NoWetSeasonMin
  A3 , \\field Day of Week for Start Day
       \\note  =[|Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|SummerDesignDay|WinterDesignDay|
       \\note    |CustomDay1|CustomDay2];
       \\note if you use SummerDesignDay or WinterDesignDay or the CustomDays then this will apply
       \\note to the whole period; other days (i.e., Monday) will signify a start day and
       \\note normal sequence ofsubsequent days
       \\default Monday
       \\type choice
       \\key Sunday
       \\key Monday
       \\key Tuesday
       \\key Wednesday
       \\key Thursday
       \\key Friday
       \\key Saturday
       \\key SummerDesignDay
       \\key WinterDesignDay
       \\key CustomDay1
       \\key CustomDay2
  A4,  \\field Use Weather File Daylight Saving Period
       \\note If yes or blank, use daylight saving period as specified on Weatherfile.
       \\note If no, do not use the daylight saving period as specified on the Weatherfile.
       \\type choice
       \\default Yes
       \\key Yes
       \\key No
  A5;  \\field Use Weather File Rain and Snow Indicators
       \\type choice
       \\key Yes
       \\key No
       \\default Yes

RunPeriod,
       \\memo Specified a range of dates and other parameters for a weather file simulation.
       \\memo Multiple run periods may be input, but they may not overlap.
       \\min-fields 11
  A1 , \\field Name
       \\reference RunPeriods
       \\reference RunPeriodsAndDesignDays
       \\note descriptive name (used in reporting mainly)
       \\note if blank, weather file title is used.  if not blank, must be unique
  N1 , \\field Begin Month
       \\required-field
       \\minimum 1
       \\maximum 12
       \\type integer
  N2 , \\field Begin Day of Month
       \\required-field
       \\minimum 1
       \\maximum 31
       \\type integer
  N3 , \\field End Month
       \\required-field
       \\minimum 1
       \\maximum 12
       \\type integer
  N4 , \\field End Day of Month
       \\required-field
       \\minimum 1
       \\maximum 31
       \\type integer
  A2 , \\field Day of Week for Start Day
       \\note  =<blank - use WeatherFile>|Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday];
       \\default UseWeatherFile
       \\type choice
       \\key Sunday
       \\key Monday
       \\key Tuesday
       \\key Wednesday
       \\key Thursday
       \\key Friday
       \\key Saturday
       \\key UseWeatherFile
  A3,  \\field Use Weather File Holidays and Special Days
       \\note If yes or blank, use holidays as specified on Weatherfile.
       \\note If no, do not use the holidays specified on the Weatherfile.
       \\note Note: You can still specify holidays/special days using the RunPeriodControl:SpecialDays object(s).
       \\type choice
       \\default Yes
       \\key Yes
       \\key No
  A4,  \\field Use Weather File Daylight Saving Period
       \\note If yes or blank, use daylight saving period as specified on Weatherfile.
       \\note If no, do not use the daylight saving period as specified on the Weatherfile.
       \\type choice
       \\default Yes
       \\key Yes
       \\key No
  A5,  \\field Apply Weekend Holiday Rule
       \\note if yes and single day holiday falls on weekend, "holiday" occurs on following Monday
       \\type choice
       \\key Yes
       \\key No
       \\default No
  A6,  \\field Use Weather File Rain Indicators
       \\type choice
       \\key Yes
       \\key No
       \\default Yes
  A7,  \\field Use Weather File Snow Indicators
       \\type choice
       \\key Yes
       \\key No
       \\default Yes
  N5,  \\field Number of Times Runperiod to be Repeated
       \\type integer
       \\minimum 1
       \\default 1
  A8,  \\field Increment Day of Week on repeat
       \\type choice
       \\key Yes
       \\key No
       \\default Yes
  N6;  \\field Start Year
       \\note this is the start year for the start date.  If the leap year is "Yes" in the weather file header
       \\note (that is HOLIDAYS/SPECIAL DAYS header first field), then any year which is a leap year will assume
       \\note there will be a Feb 29. A repeat of this runperiod will automatically increment the year.

RunPeriod:CustomRange,
       \\memo run simulation for a custom created weather file
       \\min-fields 13
  A1 , \\field Name
       \\reference RunPeriods
       \\reference RunPeriodsAndDesignDays
       \\note descriptive name (used in reporting mainly)
       \\note if blank, weather file title is used.  if not blank, must be unique
  N1 , \\field Begin Month
       \\required-field
       \\minimum 1
       \\maximum 12
       \\type integer
  N2 , \\field Begin Day of Month
       \\required-field
       \\minimum 1
       \\maximum 31
       \\type integer
  N3,  \\field Begin Year
       \\required-field
       \\note must be start year of this date on weather file
  N4 , \\field End Month
       \\required-field
       \\minimum 1
       \\maximum 12
       \\type integer
  N5 , \\field End Day of Month
       \\required-field
       \\minimum 1
       \\maximum 31
       \\type integer
  N6,  \\field End Year
       \\required-field
       \\note must be end year of this date on weather file
  A2 , \\field Day of Week for Start Day
       \\note  =<blank - use WeatherFile>|Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday];
       \\default UseWeatherFile
       \\type choice
       \\key Sunday
       \\key Monday
       \\key Tuesday
       \\key Wednesday
       \\key Thursday
       \\key Friday
       \\key Saturday
       \\key UseWeatherFile
  A3,  \\field Use Weather File Holidays and Special Days
       \\note If yes or blank, use holidays as specified on Weatherfile.
       \\note If no, do not use the holidays specified on the Weatherfile.
       \\note Note: You can still specify holidays/special days using the RunPeriodControl:SpecialDays object(s).
       \\type choice
       \\default Yes
       \\key Yes
       \\key No
  A4,  \\field Use Weather File Daylight Saving Period
       \\note If yes or blank, use daylight saving period as specified on Weatherfile.
       \\note If no, do not use the daylight saving period as specified on the Weatherfile.
       \\type choice
       \\default Yes
       \\key Yes
       \\key No
  A5,  \\field Apply Weekend Holiday Rule
       \\note if yes and single day holiday falls on weekend, "holiday" occurs on following Monday
       \\type choice
       \\key Yes
       \\key No
       \\default No
  A6,  \\field Use Weather File Rain Indicators
       \\type choice
       \\key Yes
       \\key No
       \\default Yes
  A7;  \\field Use Weather File Snow Indicators
       \\type choice
       \\key Yes
       \\key No
       \\default Yes

RunPeriodControl:SpecialDays,
     \\min-fields 4
     \\memo This object sets up holidays/special days to be used during weather file
     \\memo run periods.  (These are not used with SizingPeriod:* objects.)
     \\memo Depending on the value in the run period, days on the weather file may also
     \\memo be used.  However, the weather file specification will take precedence over
     \\memo any specification shown here.  (No error message on duplicate days or overlapping
     \\memo days).
 A1, \\field Name
     \\required-field
 A2, \\field Start Date
     \\required-field
     \\note  Dates can be several formats:
     \\note  <number>/<number>  (month/day)
     \\note  <number> <Month>
     \\note  <Month> <number>
     \\note <Nth> <Weekday> in <Month)
     \\note Last <WeekDay> in <Month>
     \\note <Month> can be January, February, March, April, May, June, July, August, September, October, November, December
     \\note Months can be the first 3 letters of the month
     \\note <Weekday> can be Sunday, Monday, Tuesday, Wednesday, Thursday, Friday, Saturday
     \\note <Nth> can be 1 or 1st, 2 or 2nd, etc. up to 5(?)
 N1, \\field Duration
     \\units days
     \\minimum 1
     \\maximum 366
     \\default 1
 A3; \\field Special Day Type
       \\required-field
       \\note Special Day Type selects the schedules appropriate for each day so labeled
       \\type choice
       \\key Holiday
       \\key SummerDesignDay
       \\key WinterDesignDay
       \\key CustomDay1
       \\key CustomDay2
       \\default Holiday

RunPeriodControl:DaylightSavingTime,
     \\unique-object
     \\min-fields 2
     \\memo This object sets up the daylight saving time period for any RunPeriod.
     \\memo Ignores any daylight saving time period on the weather file and uses this definition.
     \\memo These are not used with SizingPeriod:DesignDay objects.
     \\memo Use with SizingPeriod:WeatherFileDays object can be controlled in that object.
 A1, \\field Start Date
     \\required-field
 A2; \\field End Date
     \\required-field
     \\note  Dates can be several formats:
     \\note  <number>/<number>  (month/day)
     \\note  <number> <Month>
     \\note  <Month> <number>
     \\note <Nth> <Weekday> in <Month)
     \\note Last <WeekDay> in <Month>
     \\note <Month> can be January, February, March, April, May, June, July, August, September, October, November, December
     \\note Months can be the first 3 letters of the month
     \\note <Weekday> can be Sunday, Monday, Tuesday, Wednesday, Thursday, Friday, Saturday
     \\note <Nth> can be 1 or 1st, 2 or 2nd, etc. up to 5(?)

WeatherProperty:SkyTemperature,
       \\memo This object is used to override internal sky temperature calculations.
  A1,  \\field Name
       \\note blank in this field will apply to all run periods (that is, all objects=
       \\note SizingPeriod:WeatherFileDays, SizingPeriod:WeatherFileConditionType or RunPeriod
       \\note otherwise, this name must match one of the environment object names.
       \\type object-list
       \\object-list RunPeriodsAndDesignDays
  A2,  \\field Calculation Type
       \\required-field
       \\type choice
       \\key ScheduleValue
       \\key DifferenceScheduleDryBulbValue
       \\key DifferenceScheduleDewPointValue
  A3;  \\field Schedule Name
       \\required-field
       \\note if name matches a SizingPeriod:DesignDay, put in a day schedule of this name
       \\note if name is for a SizingPeriod:WeatherFileDays, SizingPeriod:WeatherFileConditionType or
       \\note RunPeriod, put in a full year schedule that covers the appropriate days.
       \\type object-list
       \\object-list ScheduleAndDayScheduleNames

Site:WeatherStation,
       \\unique-object
       \\memo This object should only be used for non-standard weather data.  Standard weather data
       \\memo such as TMY2, IWEC, and ASHRAE design day data are all measured at the
       \\memo default conditions and do not require this object.
  N1 , \\field Wind Sensor Height Above Ground
       \\type real
       \\units m
       \\default 10.0
       \\minimum> 0.0
  N2 , \\field Wind Speed Profile Exponent
       \\type real
       \\default 0.14
       \\minimum 0.0
  N3 , \\field Wind Speed Profile Boundary Layer Thickness
       \\type real
       \\units m
       \\default 270.0
       \\minimum 0.0
  N4 ; \\field Air Temperature Sensor Height Above Ground
       \\type real
       \\units m
       \\default 1.5
       \\minimum 0.0

Site:HeightVariation,
       \\unique-object
       \\memo This object is used if the user requires advanced control over height-dependent
       \\memo variations in wind speed and temperature.  When this object is not present, the default model
       \\memo for temperature dependence on height is used, and the wind speed is modeled according
       \\memo to the Terrain field of the BUILDING object.
  N1 , \\field Wind Speed Profile Exponent
       \\note Set to zero for no wind speed dependence on height.
       \\type real
       \\default 0.22
       \\minimum 0.0
  N2 , \\field Wind Speed Profile Boundary Layer Thickness
       \\type real
       \\units m
       \\default 370.0
       \\minimum> 0.0
  N3 ; \\field Air Temperature Gradient Coefficient
       \\note Set to zero for no air temperature dependence on height.
       \\type real
       \\units K/m
       \\default 0.0065
       \\minimum 0.0

Site:GroundTemperature:BuildingSurface,
       \\memo These temperatures are specifically for those surfaces that have the outside environment
       \\memo of "Ground".  Documentation about what values these should be is located in the
       \\memo Auxiliary programs document (Ground Heat Transfer) as well as the InputOutput Reference.
       \\memo CAUTION - Do not use the "undisturbed" ground temperatures from the weather data.
       \\memo These values are too extreme for the soil under a conditioned building.
       \\memo For best results, use the Slab or Basement program to calculate custom monthly
       \\memo average ground temperatures (see Auxiliary Programs).  For typical commercial
       \\memo buildings in the USA, a reasonable default value is 2C less than the average indoor space temperature.
       \\unique-object
       \\min-fields 12
       \\format singleLine
  N1 , \\field January Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 18
  N2 , \\field February Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 18
  N3 , \\field March Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 18
  N4 , \\field April Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 18
  N5 , \\field May Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 18
  N6 , \\field June Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 18
  N7 , \\field July Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 18
  N8 , \\field August Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 18
  N9 , \\field September Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 18
  N10, \\field October Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 18
  N11, \\field November Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 18
  N12; \\field December Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 18

Site:GroundTemperature:FCfactorMethod,
       \\memo These temperatures are specifically for underground walls and ground floors
       \\memo defined with the C-factor and F-factor methods, and should be close to the
       \\memo monthly average outdoor air temperature delayed by 3 months for the location.
       \\unique-object
       \\min-fields 12
       \\format singleLine
  N1 , \\field January Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 13
  N2 , \\field February Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 13
  N3 , \\field March Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 13
  N4 , \\field April Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 13
  N5 , \\field May Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 13
  N6 , \\field June Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 13
  N7 , \\field July Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 13
  N8 , \\field August Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 13
  N9 , \\field September Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 13
  N10, \\field October Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 13
  N11, \\field November Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 13
  N12; \\field December Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 13

Site:GroundTemperature:Shallow,
       \\memo These temperatures are specifically for the Surface Ground Heat Exchanger and
       \\memo should probably be close to the average outdoor air temperature for the location.
       \\memo They are not used in other models.
       \\unique-object
       \\min-fields 12
       \\format singleLine
  N1 , \\field January Surface Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 13
  N2 , \\field February Surface Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 13
  N3 , \\field March Surface Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 13
  N4 , \\field April Surface Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 13
  N5 , \\field May Surface Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 13
  N6 , \\field June Surface Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 13
  N7 , \\field July Surface Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 13
  N8 , \\field August Surface Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 13
  N9 , \\field September Surface Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 13
  N10, \\field October Surface Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 13
  N11, \\field November Surface Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 13
  N12; \\field December Surface Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 13

Site:GroundTemperature:Deep,
       \\memo These temperatures are specifically for the ground heat exchangers that would use
       \\memo "deep" (3-4 m depth) ground temperatures for their heat source.
       \\memo They are not used in other models.
       \\unique-object
       \\min-fields 12
       \\format singleLine
  N1 , \\field January Deep Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 16
  N2 , \\field February Deep Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 16
  N3 , \\field March Deep Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 16
  N4 , \\field April Deep Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 16
  N5 , \\field May Deep Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 16
  N6 , \\field June Deep Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 16
  N7 , \\field July Deep Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 16
  N8 , \\field August Deep Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 16
  N9 , \\field September Deep Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 16
  N10, \\field October Deep Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 16
  N11, \\field November Deep Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 16
  N12; \\field December Deep Ground Temperature
       \\required-field
       \\units C
       \\type real
       \\default 16

Site:GroundReflectance,
        \\memo Specifies the ground reflectance values used to calculate ground reflected solar.
        \\memo The ground reflectance can be further modified when snow is on the ground
        \\memo by Site:GroundReflectance:SnowModifier.
  \\unique-object
  \\min-fields 12
  \\format singleLine
  N1 , \\field January Ground Reflectance
        \\default 0.2
        \\type real
        \\minimum 0.0
        \\maximum 1.0
        \\units dimensionless
   N2 , \\field February Ground Reflectance
        \\default 0.2
        \\type real
        \\minimum 0.0
        \\maximum 1.0
        \\units dimensionless
   N3 , \\field March Ground Reflectance
        \\default 0.2
        \\type real
        \\minimum 0.0
        \\maximum 1.0
        \\units dimensionless
   N4 , \\field April Ground Reflectance
        \\default 0.2
        \\type real
        \\minimum 0.0
        \\maximum 1.0
        \\units dimensionless
   N5 , \\field May Ground Reflectance
        \\default 0.2
        \\type real
        \\minimum 0.0
        \\maximum 1.0
        \\units dimensionless
   N6 , \\field June Ground Reflectance
        \\default 0.2
        \\type real
        \\minimum 0.0
        \\maximum 1.0
        \\units dimensionless
   N7 , \\field July Ground Reflectance
        \\default 0.2
        \\type real
        \\minimum 0.0
        \\maximum 1.0
        \\units dimensionless
   N8 , \\field August Ground Reflectance
        \\default 0.2
        \\type real
        \\minimum 0.0
        \\maximum 1.0
        \\units dimensionless
   N9 , \\field September Ground Reflectance
         \\default 0.2
         \\type real
         \\minimum 0.0
         \\maximum 1.0
         \\units dimensionless
   N10 , \\field October Ground Reflectance
         \\default 0.2
         \\type real
         \\minimum 0.0
         \\maximum 1.0
         \\units dimensionless
   N11 , \\field November Ground Reflectance
         \\default 0.2
         \\type real
         \\minimum 0.0
         \\maximum 1.0
         \\units dimensionless
   N12 ; \\field December Ground Reflectance
         \\default 0.2
         \\type real
         \\minimum 0.0
         \\maximum 1.0
         \\units dimensionless

Site:GroundReflectance:SnowModifier,
      \\memo Specifies ground reflectance multipliers when snow resident on the ground.
      \\memo These multipliers are applied to the "normal" ground reflectances specified
      \\memo in Site:GroundReflectance.
  N1, \\field Ground Reflected Solar Modifier
  \\minimum 0.0
  \\default 1.0
    \\note Value for modifying the "normal" ground reflectance when Snow is on ground
    \\note  when calculating the "Ground Reflected Solar Radiation Value"
    \\note  a value of 1.0 here uses the "normal" ground reflectance
    \\note  Ground Reflected Solar = (BeamSolar*CosSunZenith + DiffuseSolar)*GroundReflectance
    \\note    This would be further modified by the Snow Ground Reflectance Modifier when Snow was on the ground
    \\note    When Snow on ground, effective GroundReflectance is normal GroundReflectance*"Ground Reflectance Snow Modifier"
    \\note  Ground Reflectance achieved in this manner will be restricted to [0.0,1.0]
  N2; \\field Daylighting Ground Reflected Solar Modifier
  \\minimum 0.0
  \\default 1.0
    \\note Value for modifying the "normal" daylighting ground reflectance when Snow is on ground
    \\note  when calculating the "Ground Reflected Solar Radiation Value"
    \\note  a value of 1.0 here uses the "normal" ground reflectance
    \\note  Ground Reflected Solar = (BeamSolar*CosSunZenith + DiffuseSolar)*GroundReflectance
    \\note    This would be further modified by the Snow Ground Reflectance Modifier when Snow was on the ground
    \\note    When Snow on ground, effective GroundReflectance is normal GroundReflectance*"Daylighting Ground Reflectance Snow Modifier"
    \\note  Ground Reflectance achieved in this manner will be restricted to [0.0,1.0]

Site:WaterMainsTemperature,
       \\memo Used to calculate water mains temperatures delivered by underground water main pipes.
       \\memo Water mains temperatures are a function of outdoor climate conditions
       \\memo and vary with time of year.
  A1 , \\field Calculation Method
       \\required-field
       \\type choice
       \\key Schedule
       \\key Correlation
  A2 , \\field Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
  N1 , \\field Annual Average Outdoor Air Temperature
       \\type real
       \\units C
  N2 ; \\field Maximum Difference In Monthly Average Outdoor Air Temperatures
       \\type real
       \\units deltaC
       \\minimum 0

Site:Precipitation,
      \\memo Used to describe the amount of water precipitation at the building site.
      \\memo Precipitation includes both rain and the equivalent water content of snow.
  A1, \\field Precipitation Model Type
      \\type choice
      \\key ScheduleAndDesignLevel
  N1, \\field Design Level for Total Annual Precipitation
      \\note meters of water per year used for design level
      \\units m/yr
  A2, \\field Precipitation Rates Schedule Name
      \\type object-list
      \\object-list ScheduleNames
      \\note Schedule values in meters of water per hour
      \\note values should be non-negative
  N2; \\field Average Total Annual Precipitation
      \\note meters of water per year from average weather statistics
      \\minimum 0
      \\units m/yr

RoofIrrigation,
      \\memo Used to describe the amount of irrigation on the ecoroof surface over the course
      \\memo of the simulation runperiod.
  A1, \\field Irrigation Model Type
      \\type choice
      \\key Schedule
      \\key SmartSchedule
      \\note SmartSchedule will not allow irrigation when soil is already moist.
      \\note Current threshold set at 30% of saturation.
  A2, \\field Irrigation Rate Schedule Name
      \\type object-list
      \\object-list ScheduleNames
      \\note Schedule values in meters of water per hour
      \\note values should be non-negative
  N1; \\field Irrigation Maximum Saturation Threshold
      \\note Used with SmartSchedule to set the saturation level at which no
      \\note irrigation is allowed.
      \\units percent
      \\minimum 0.0
      \\maximum 100.0
      \\default 40.0

\\group Schedules

ScheduleTypeLimits,
       \\memo ScheduleTypeLimits specifies the data types and limits for the values contained in schedules
  A1,  \\field Name
       \\required-field
       \\reference ScheduleTypeLimitsNames
       \\note used to validate schedule types in various schedule objects
  N1,  \\field Lower Limit Value
       \\note lower limit (real or integer) for the Schedule Type.  e.g. if fraction, this is 0.0
       \\unitsBasedOnField A3
  N2,  \\field Upper Limit Value
       \\note upper limit (real or integer) for the Schedule Type.  e.g. if fraction, this is 1.0
       \\unitsBasedOnField A3
  A2,  \\field Numeric Type
       \\note Numeric type is either Continuous (all numbers within the min and
       \\note max are valid or Discrete (only integer numbers between min and
       \\note max are valid.  (Could also allow REAL and INTEGER to mean the
       \\note same things)
       \\type choice
       \\key Continuous
       \\key Discrete
  A3;  \\field Unit Type
       \\note Temperature (C or F)
       \\note DeltaTemperature (C or F)
       \\note PrecipitationRate (m/hr or ft/hr)
       \\note Angle (degrees)
       \\note Convection Coefficient (W/m2-K or Btu/sqft-hr-F)
       \\note Activity Level (W/person)
       \\note Velocity (m/s or ft/min)
       \\note Capacity (W or Btu/h)
       \\note Power (W)
       \\type choice
       \\key Dimensionless
       \\key Temperature
       \\key DeltaTemperature
       \\key PrecipitationRate
       \\key Angle
       \\key ConvectionCoefficient
       \\key ActivityLevel
       \\key Velocity
       \\key Capacity
       \\key Power
       \\key Availability
       \\key Percent
       \\key Control
       \\key Mode
       \\default Dimensionless

Schedule:Day:Hourly,
       \\min-fields 26
       \\memo A Schedule:Day:Hourly contains 24 values for each hour of the day.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference DayScheduleNames
       \\reference ScheduleAndDayScheduleNames
  A2 , \\field Schedule Type Limits Name
       \\type object-list
       \\object-list ScheduleTypeLimitsNames
  N1 , \\field Hour 1
       \\type real
       \\default 0
  N2 , \\field Hour 2
       \\type real
       \\default 0
  N3 , \\field Hour 3
       \\type real
       \\default 0
  N4 , \\field Hour 4
       \\type real
       \\default 0
  N5 , \\field Hour 5
       \\type real
       \\default 0
  N6 , \\field Hour 6
       \\type real
       \\default 0
  N7 , \\field Hour 7
       \\type real
       \\default 0
  N8 , \\field Hour 8
       \\type real
       \\default 0
  N9 , \\field Hour 9
       \\type real
       \\default 0
  N10, \\field Hour 10
       \\type real
       \\default 0
  N11, \\field Hour 11
       \\type real
       \\default 0
  N12, \\field Hour 12
       \\type real
       \\default 0
  N13, \\field Hour 13
       \\type real
       \\default 0
  N14, \\field Hour 14
       \\type real
       \\default 0
  N15, \\field Hour 15
       \\type real
       \\default 0
  N16, \\field Hour 16
       \\type real
       \\default 0
  N17, \\field Hour 17
       \\type real
       \\default 0
  N18, \\field Hour 18
       \\type real
       \\default 0
  N19, \\field Hour 19
       \\type real
       \\default 0
  N20, \\field Hour 20
       \\type real
       \\default 0
  N21, \\field Hour 21
       \\type real
       \\default 0
  N22, \\field Hour 22
       \\type real
       \\default 0
  N23, \\field Hour 23
       \\type real
       \\default 0
  N24; \\field Hour 24
       \\type real
       \\default 0

Schedule:Day:Interval,
       \\extensible:2 - repeat last two fields, remembering to remove ; from "inner" fields.
       \\memo A Schedule:Day:Interval contains a full day of values with specified end times for each value
       \\memo Currently, is set up to allow for 10 minute intervals for an entire day.
       \\min-fields 5
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference DayScheduleNames
       \\reference ScheduleAndDayScheduleNames
  A2 , \\field Schedule Type Limits Name
       \\type object-list
       \\object-list ScheduleTypeLimitsNames
  A3 , \\field Interpolate to Timestep
       \\note when the interval does not match the user specified timestep a Yes choice will average between the intervals request (to
       \\note timestep resolution.  a No choice will use the interval value at the simulation timestep without regard to if it matches
       \\note the boundary or not.
       \\type choice
       \\key Yes
       \\key No
       \\default No
 A4  , \\field Time 1
       \\begin-extensible
       \\note "until" includes the time entered.
       \\units hh:mm
 N1  , \\field Value Until Time 1
 A5  , \\field Time 2
       \\note "until" includes the time entered.
       \\units hh:mm
 N2  , \\field Value Until Time 2
 A6  , \\field Time 3
       \\note "until" includes the time entered.
       \\units hh:mm
 N3  , \\field Value Until Time 3
 A7  , \\field Time 4
       \\note "until" includes the time entered.
       \\units hh:mm
 N4  , \\field Value Until Time 4
 A8  , \\field Time 5
       \\note "until" includes the time entered.
       \\units hh:mm
 N5  , \\field Value Until Time 5
 A9  , \\field Time 6
       \\note "until" includes the time entered.
       \\units hh:mm
 N6  , \\field Value Until Time 6
 A10 , \\field Time 7
       \\note "until" includes the time entered.
       \\units hh:mm
 N7  , \\field Value Until Time 7
 A11 , \\field Time 8
       \\note "until" includes the time entered.
       \\units hh:mm
 N8  , \\field Value Until Time 8
 A12 , \\field Time 9
       \\note "until" includes the time entered.
       \\units hh:mm
 N9  , \\field Value Until Time 9
 A13 , \\field Time 10
       \\note "until" includes the time entered.
       \\units hh:mm
 N10 , \\field Value Until Time 10
 A14 , \\field Time 11
       \\note "until" includes the time entered.
       \\units hh:mm
 N11 , \\field Value Until Time 11
 A15 , \\field Time 12
       \\note "until" includes the time entered.
       \\units hh:mm
 N12 , \\field Value Until Time 12
 A16 , \\field Time 13
       \\note "until" includes the time entered.
       \\units hh:mm
 N13 , \\field Value Until Time 13
 A17 , \\field Time 14
       \\note "until" includes the time entered.
       \\units hh:mm
 N14 , \\field Value Until Time 14
 A18 , \\field Time 15
       \\note "until" includes the time entered.
       \\units hh:mm
 N15 , \\field Value Until Time 15
 A19 , \\field Time 16
       \\note "until" includes the time entered.
       \\units hh:mm
 N16 , \\field Value Until Time 16
 A20 , \\field Time 17
       \\note "until" includes the time entered.
       \\units hh:mm
 N17 , \\field Value Until Time 17
 A21 , \\field Time 18
       \\note "until" includes the time entered.
       \\units hh:mm
 N18 , \\field Value Until Time 18
 A22 , \\field Time 19
       \\note "until" includes the time entered.
       \\units hh:mm
 N19 , \\field Value Until Time 19
 A23 , \\field Time 20
       \\note "until" includes the time entered.
       \\units hh:mm
 N20 , \\field Value Until Time 20
 A24 , \\field Time 21
       \\note "until" includes the time entered.
       \\units hh:mm
 N21 , \\field Value Until Time 21
 A25 , \\field Time 22
       \\note "until" includes the time entered.
       \\units hh:mm
 N22 , \\field Value Until Time 22
 A26 , \\field Time 23
       \\note "until" includes the time entered.
       \\units hh:mm
 N23 , \\field Value Until Time 23
 A27 , \\field Time 24
       \\note "until" includes the time entered.
       \\units hh:mm
 N24 , \\field Value Until Time 24
 A28 , \\field Time 25
       \\note "until" includes the time entered.
       \\units hh:mm
 N25 , \\field Value Until Time 25
 A29 , \\field Time 26
       \\note "until" includes the time entered.
       \\units hh:mm
 N26 , \\field Value Until Time 26
 A30 , \\field Time 27
       \\note "until" includes the time entered.
       \\units hh:mm
 N27 , \\field Value Until Time 27
 A31 , \\field Time 28
       \\note "until" includes the time entered.
       \\units hh:mm
 N28 , \\field Value Until Time 28
 A32 , \\field Time 29
       \\note "until" includes the time entered.
       \\units hh:mm
 N29 , \\field Value Until Time 29
 A33 , \\field Time 30
       \\note "until" includes the time entered.
       \\units hh:mm
 N30 , \\field Value Until Time 30
 A34 , \\field Time 31
       \\note "until" includes the time entered.
       \\units hh:mm
 N31 , \\field Value Until Time 31
 A35 , \\field Time 32
       \\note "until" includes the time entered.
       \\units hh:mm
 N32 , \\field Value Until Time 32
 A36 , \\field Time 33
       \\note "until" includes the time entered.
       \\units hh:mm
 N33 , \\field Value Until Time 33
 A37 , \\field Time 34
       \\note "until" includes the time entered.
       \\units hh:mm
 N34 , \\field Value Until Time 34
 A38 , \\field Time 35
       \\note "until" includes the time entered.
       \\units hh:mm
 N35 , \\field Value Until Time 35
 A39 , \\field Time 36
       \\note "until" includes the time entered.
       \\units hh:mm
 N36 , \\field Value Until Time 36
 A40 , \\field Time 37
       \\note "until" includes the time entered.
       \\units hh:mm
 N37 , \\field Value Until Time 37
 A41 , \\field Time 38
       \\note "until" includes the time entered.
       \\units hh:mm
 N38 , \\field Value Until Time 38
 A42 , \\field Time 39
       \\note "until" includes the time entered.
       \\units hh:mm
 N39 , \\field Value Until Time 39
 A43 , \\field Time 40
       \\note "until" includes the time entered.
       \\units hh:mm
 N40 , \\field Value Until Time 40
 A44 , \\field Time 41
       \\note "until" includes the time entered.
       \\units hh:mm
 N41 , \\field Value Until Time 41
 A45 , \\field Time 42
       \\note "until" includes the time entered.
       \\units hh:mm
 N42 , \\field Value Until Time 42
 A46 , \\field Time 43
       \\note "until" includes the time entered.
       \\units hh:mm
 N43 , \\field Value Until Time 43
 A47 , \\field Time 44
       \\note "until" includes the time entered.
       \\units hh:mm
 N44 , \\field Value Until Time 44
 A48 , \\field Time 45
       \\note "until" includes the time entered.
       \\units hh:mm
 N45 , \\field Value Until Time 45
 A49 , \\field Time 46
       \\note "until" includes the time entered.
       \\units hh:mm
 N46 , \\field Value Until Time 46
 A50 , \\field Time 47
       \\note "until" includes the time entered.
       \\units hh:mm
 N47 , \\field Value Until Time 47
 A51 , \\field Time 48
       \\note "until" includes the time entered.
       \\units hh:mm
 N48 , \\field Value Until Time 48
 A52 , \\field Time 49
       \\note "until" includes the time entered.
       \\units hh:mm
 N49 , \\field Value Until Time 49
 A53 , \\field Time 50
       \\note "until" includes the time entered.
       \\units hh:mm
 N50 , \\field Value Until Time 50
 A54 , \\field Time 51
       \\note "until" includes the time entered.
       \\units hh:mm
 N51 , \\field Value Until Time 51
 A55 , \\field Time 52
       \\note "until" includes the time entered.
       \\units hh:mm
 N52 , \\field Value Until Time 52
 A56 , \\field Time 53
       \\note "until" includes the time entered.
       \\units hh:mm
 N53 , \\field Value Until Time 53
 A57 , \\field Time 54
       \\note "until" includes the time entered.
       \\units hh:mm
 N54 , \\field Value Until Time 54
 A58 , \\field Time 55
       \\note "until" includes the time entered.
       \\units hh:mm
 N55 , \\field Value Until Time 55
 A59 , \\field Time 56
       \\note "until" includes the time entered.
       \\units hh:mm
 N56 , \\field Value Until Time 56
 A60 , \\field Time 57
       \\note "until" includes the time entered.
       \\units hh:mm
 N57 , \\field Value Until Time 57
 A61 , \\field Time 58
       \\note "until" includes the time entered.
       \\units hh:mm
 N58 , \\field Value Until Time 58
 A62 , \\field Time 59
       \\note "until" includes the time entered.
       \\units hh:mm
 N59 , \\field Value Until Time 59
 A63 , \\field Time 60
       \\note "until" includes the time entered.
       \\units hh:mm
 N60 , \\field Value Until Time 60
 A64 , \\field Time 61
       \\note "until" includes the time entered.
       \\units hh:mm
 N61 , \\field Value Until Time 61
 A65 , \\field Time 62
       \\note "until" includes the time entered.
       \\units hh:mm
 N62 , \\field Value Until Time 62
 A66 , \\field Time 63
       \\note "until" includes the time entered.
       \\units hh:mm
 N63 , \\field Value Until Time 63
 A67 , \\field Time 64
       \\note "until" includes the time entered.
       \\units hh:mm
 N64 , \\field Value Until Time 64
 A68 , \\field Time 65
       \\note "until" includes the time entered.
       \\units hh:mm
 N65 , \\field Value Until Time 65
 A69 , \\field Time 66
       \\note "until" includes the time entered.
       \\units hh:mm
 N66 , \\field Value Until Time 66
 A70 , \\field Time 67
       \\note "until" includes the time entered.
       \\units hh:mm
 N67 , \\field Value Until Time 67
 A71 , \\field Time 68
       \\note "until" includes the time entered.
       \\units hh:mm
 N68 , \\field Value Until Time 68
 A72 , \\field Time 69
       \\note "until" includes the time entered.
       \\units hh:mm
 N69 , \\field Value Until Time 69
 A73 , \\field Time 70
       \\note "until" includes the time entered.
       \\units hh:mm
 N70 , \\field Value Until Time 70
 A74 , \\field Time 71
       \\note "until" includes the time entered.
       \\units hh:mm
 N71 , \\field Value Until Time 71
 A75 , \\field Time 72
       \\note "until" includes the time entered.
       \\units hh:mm
 N72 , \\field Value Until Time 72
 A76 , \\field Time 73
       \\note "until" includes the time entered.
       \\units hh:mm
 N73 , \\field Value Until Time 73
 A77 , \\field Time 74
       \\note "until" includes the time entered.
       \\units hh:mm
 N74 , \\field Value Until Time 74
 A78 , \\field Time 75
       \\note "until" includes the time entered.
       \\units hh:mm
 N75 , \\field Value Until Time 75
 A79 , \\field Time 76
       \\note "until" includes the time entered.
       \\units hh:mm
 N76 , \\field Value Until Time 76
 A80 , \\field Time 77
       \\note "until" includes the time entered.
       \\units hh:mm
 N77 , \\field Value Until Time 77
 A81 , \\field Time 78
       \\note "until" includes the time entered.
       \\units hh:mm
 N78 , \\field Value Until Time 78
 A82 , \\field Time 79
       \\note "until" includes the time entered.
       \\units hh:mm
 N79 , \\field Value Until Time 79
 A83 , \\field Time 80
       \\note "until" includes the time entered.
       \\units hh:mm
 N80 , \\field Value Until Time 80
 A84 , \\field Time 81
       \\note "until" includes the time entered.
       \\units hh:mm
 N81 , \\field Value Until Time 81
 A85 , \\field Time 82
       \\note "until" includes the time entered.
       \\units hh:mm
 N82 , \\field Value Until Time 82
 A86 , \\field Time 83
       \\note "until" includes the time entered.
       \\units hh:mm
 N83 , \\field Value Until Time 83
 A87 , \\field Time 84
       \\note "until" includes the time entered.
       \\units hh:mm
 N84 , \\field Value Until Time 84
 A88 , \\field Time 85
       \\note "until" includes the time entered.
       \\units hh:mm
 N85 , \\field Value Until Time 85
 A89 , \\field Time 86
       \\note "until" includes the time entered.
       \\units hh:mm
 N86 , \\field Value Until Time 86
 A90 , \\field Time 87
       \\note "until" includes the time entered.
       \\units hh:mm
 N87 , \\field Value Until Time 87
 A91 , \\field Time 88
       \\note "until" includes the time entered.
       \\units hh:mm
 N88 , \\field Value Until Time 88
 A92 , \\field Time 89
       \\note "until" includes the time entered.
       \\units hh:mm
 N89 , \\field Value Until Time 89
 A93 , \\field Time 90
       \\note "until" includes the time entered.
       \\units hh:mm
 N90 , \\field Value Until Time 90
 A94 , \\field Time 91
       \\note "until" includes the time entered.
       \\units hh:mm
 N91 , \\field Value Until Time 91
 A95 , \\field Time 92
       \\note "until" includes the time entered.
       \\units hh:mm
 N92 , \\field Value Until Time 92
 A96 , \\field Time 93
       \\note "until" includes the time entered.
       \\units hh:mm
 N93 , \\field Value Until Time 93
 A97 , \\field Time 94
       \\note "until" includes the time entered.
       \\units hh:mm
 N94 , \\field Value Until Time 94
 A98 , \\field Time 95
       \\note "until" includes the time entered.
       \\units hh:mm
 N95 , \\field Value Until Time 95
 A99 , \\field Time 96
       \\note "until" includes the time entered.
       \\units hh:mm
 N96 , \\field Value Until Time 96
 A100, \\field Time 97
       \\note "until" includes the time entered.
       \\units hh:mm
 N97 , \\field Value Until Time 97
 A101, \\field Time 98
       \\note "until" includes the time entered.
       \\units hh:mm
 N98 , \\field Value Until Time 98
 A102, \\field Time 99
       \\note "until" includes the time entered.
       \\units hh:mm
 N99 , \\field Value Until Time 99
 A103, \\field Time 100
       \\note "until" includes the time entered.
       \\units hh:mm
 N100, \\field Value Until Time 100
 A104, \\field Time 101
       \\note "until" includes the time entered.
       \\units hh:mm
 N101, \\field Value Until Time 101
 A105, \\field Time 102
       \\note "until" includes the time entered.
       \\units hh:mm
 N102, \\field Value Until Time 102
 A106, \\field Time 103
       \\note "until" includes the time entered.
       \\units hh:mm
 N103, \\field Value Until Time 103
 A107, \\field Time 104
       \\note "until" includes the time entered.
       \\units hh:mm
 N104, \\field Value Until Time 104
 A108, \\field Time 105
       \\note "until" includes the time entered.
       \\units hh:mm
 N105, \\field Value Until Time 105
 A109, \\field Time 106
       \\note "until" includes the time entered.
       \\units hh:mm
 N106, \\field Value Until Time 106
 A110, \\field Time 107
       \\note "until" includes the time entered.
       \\units hh:mm
 N107, \\field Value Until Time 107
 A111, \\field Time 108
       \\note "until" includes the time entered.
       \\units hh:mm
 N108, \\field Value Until Time 108
 A112, \\field Time 109
       \\note "until" includes the time entered.
       \\units hh:mm
 N109, \\field Value Until Time 109
 A113, \\field Time 110
       \\note "until" includes the time entered.
       \\units hh:mm
 N110, \\field Value Until Time 110
 A114, \\field Time 111
       \\note "until" includes the time entered.
       \\units hh:mm
 N111, \\field Value Until Time 111
 A115, \\field Time 112
       \\note "until" includes the time entered.
       \\units hh:mm
 N112, \\field Value Until Time 112
 A116, \\field Time 113
       \\note "until" includes the time entered.
       \\units hh:mm
 N113, \\field Value Until Time 113
 A117, \\field Time 114
       \\note "until" includes the time entered.
       \\units hh:mm
 N114, \\field Value Until Time 114
 A118, \\field Time 115
       \\note "until" includes the time entered.
       \\units hh:mm
 N115, \\field Value Until Time 115
 A119, \\field Time 116
       \\note "until" includes the time entered.
       \\units hh:mm
 N116, \\field Value Until Time 116
 A120, \\field Time 117
       \\note "until" includes the time entered.
       \\units hh:mm
 N117, \\field Value Until Time 117
 A121, \\field Time 118
       \\note "until" includes the time entered.
       \\units hh:mm
 N118, \\field Value Until Time 118
 A122, \\field Time 119
       \\note "until" includes the time entered.
       \\units hh:mm
 N119, \\field Value Until Time 119
 A123, \\field Time 120
       \\note "until" includes the time entered.
       \\units hh:mm
 N120, \\field Value Until Time 120
 A124, \\field Time 121
       \\note "until" includes the time entered.
       \\units hh:mm
 N121, \\field Value Until Time 121
 A125, \\field Time 122
       \\note "until" includes the time entered.
       \\units hh:mm
 N122, \\field Value Until Time 122
 A126, \\field Time 123
       \\note "until" includes the time entered.
       \\units hh:mm
 N123, \\field Value Until Time 123
 A127, \\field Time 124
       \\note "until" includes the time entered.
       \\units hh:mm
 N124, \\field Value Until Time 124
 A128, \\field Time 125
       \\note "until" includes the time entered.
       \\units hh:mm
 N125, \\field Value Until Time 125
 A129, \\field Time 126
       \\note "until" includes the time entered.
       \\units hh:mm
 N126, \\field Value Until Time 126
 A130, \\field Time 127
       \\note "until" includes the time entered.
       \\units hh:mm
 N127, \\field Value Until Time 127
 A131, \\field Time 128
       \\note "until" includes the time entered.
       \\units hh:mm
 N128, \\field Value Until Time 128
 A132, \\field Time 129
       \\note "until" includes the time entered.
       \\units hh:mm
 N129, \\field Value Until Time 129
 A133, \\field Time 130
       \\note "until" includes the time entered.
       \\units hh:mm
 N130, \\field Value Until Time 130
 A134, \\field Time 131
       \\note "until" includes the time entered.
       \\units hh:mm
 N131, \\field Value Until Time 131
 A135, \\field Time 132
       \\note "until" includes the time entered.
       \\units hh:mm
 N132, \\field Value Until Time 132
 A136, \\field Time 133
       \\note "until" includes the time entered.
       \\units hh:mm
 N133, \\field Value Until Time 133
 A137, \\field Time 134
       \\note "until" includes the time entered.
       \\units hh:mm
 N134, \\field Value Until Time 134
 A138, \\field Time 135
       \\note "until" includes the time entered.
       \\units hh:mm
 N135, \\field Value Until Time 135
 A139, \\field Time 136
       \\note "until" includes the time entered.
       \\units hh:mm
 N136, \\field Value Until Time 136
 A140, \\field Time 137
       \\note "until" includes the time entered.
       \\units hh:mm
 N137, \\field Value Until Time 137
 A141, \\field Time 138
       \\note "until" includes the time entered.
       \\units hh:mm
 N138, \\field Value Until Time 138
 A142, \\field Time 139
       \\note "until" includes the time entered.
       \\units hh:mm
 N139, \\field Value Until Time 139
 A143, \\field Time 140
       \\note "until" includes the time entered.
       \\units hh:mm
 N140, \\field Value Until Time 140
 A144, \\field Time 141
       \\note "until" includes the time entered.
       \\units hh:mm
 N141, \\field Value Until Time 141
 A145, \\field Time 142
       \\note "until" includes the time entered.
       \\units hh:mm
 N142, \\field Value Until Time 142
 A146, \\field Time 143
       \\note "until" includes the time entered.
       \\units hh:mm
 N143, \\field Value Until Time 143
 A147, \\field Time 144
       \\note "until" includes the time entered.
       \\units hh:mm
 N144; \\field Value Until Time 144


Schedule:Day:List,
      \\memo Schedule:Day:List will allow the user to list 24 hours worth of values, which can be sub-hourly in nature.
      \\min-fields 5
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference DayScheduleNames
       \\reference ScheduleAndDayScheduleNames
  A2 , \\field Schedule Type Limits Name
       \\type object-list
       \\object-list ScheduleTypeLimitsNames
  A3 , \\field Interpolate to Timestep
       \\note when the interval does not match the user specified timestep a "Yes" choice will average between the intervals request (to
       \\note timestep resolution.  a "No" choice will use the interval value at the simulation timestep without regard to if it matches
       \\note the boundary or not.
       \\type choice
       \\key Yes
       \\key No
       \\default No
  N1 , \\field Minutes per Item
       \\note Must be evenly divisible into 60
       \\type integer
       \\minimum 1
       \\maximum 60
  N2,  \\field Value 1
       \\default 0.0
        N3,N4,         N5,N6,N7,N8,         N9,N10,N11,N12,      N13,N14,N15,N16,     N17,N18,N19,N20, \\note fields as indicated
  N21,N22,N23,N24,     N25,N26,N27,N28,     N29,N30,N31,N32,     N33,N34,N35,N36,     N37,N38,N39,N40, \\note fields as indicated
  N41,N42,N43,N44,     N45,N46,N47,N48,     N49,N50,N51,N52,     N53,N54,N55,N56,     N57,N58,N59,N60, \\note fields as indicated
  N61,N62,N63,N64,     N65,N66,N67,N68,     N69,N70,N71,N72,     N73,N74,N75,N76,     N77,N78,N79,N80, \\note fields as indicated
  N81,N82,N83,N84,     N85,N86,N87,N88,     N89,N90,N91,N92,     N93,N94,N95,N96,     N97,N98,N99,N100, \\note fields as indicated

  N101,N102,N103,N104, N105,N106,N107,N108, N109,N110,N111,N112, N113,N114,N115,N116, N117,N118,N119,N120, \\note fields as indicated
  N121,N122,N123,N124, N125,N126,N127,N128, N129,N130,N131,N132, N133,N134,N135,N136, N137,N138,N139,N140, \\note fields as indicated
  N141,N142,N143,N144, N145,N146,N147,N148, N149,N150,N151,N152, N153,N154,N155,N156, N157,N158,N159,N160, \\note fields as indicated
  N161,N162,N163,N164, N165,N166,N167,N168, N169,N170,N171,N172, N173,N174,N175,N176, N177,N178,N179,N180, \\note fields as indicated
  N181,N182,N183,N184, N185,N186,N187,N188, N189,N190,N191,N192, N193,N194,N195,N196, N197,N198,N199,N200, \\note fields as indicated

  N201,N202,N203,N204, N205,N206,N207,N208, N209,N210,N211,N212, N213,N214,N215,N216, N217,N218,N219,N220, \\note fields as indicated
  N221,N222,N223,N224, N225,N226,N227,N228, N229,N230,N231,N232, N233,N234,N235,N236, N237,N238,N239,N240, \\note fields as indicated
  N241,N242,N243,N244, N245,N246,N247,N248, N249,N250,N251,N252, N253,N254,N255,N256, N257,N258,N259,N260, \\note fields as indicated
  N261,N262,N263,N264, N265,N266,N267,N268, N269,N270,N271,N272, N273,N274,N275,N276, N277,N278,N279,N280, \\note fields as indicated
  N281,N282,N283,N284, N285,N286,N287,N288, N289,N290,N291,N292, N293,N294,N295,N296, N297,N298,N299,N300, \\note fields as indicated

  N301,N302,N303,N304, N305,N306,N307,N308, N309,N310,N311,N312, N313,N314,N315,N316, N317,N318,N319,N320, \\note fields as indicated
  N321,N322,N323,N324, N325,N326,N327,N328, N329,N330,N331,N332, N333,N334,N335,N336, N337,N338,N339,N340, \\note fields as indicated
  N341,N342,N343,N344, N345,N346,N347,N348, N349,N350,N351,N352, N353,N354,N355,N356, N357,N358,N359,N360, \\note fields as indicated
  N361,N362,N363,N364, N365,N366,N367,N368, N369,N370,N371,N372, N373,N374,N375,N376, N377,N378,N379,N380, \\note fields as indicated
  N381,N382,N383,N384, N385,N386,N387,N388, N389,N390,N391,N392, N393,N394,N395,N396, N397,N398,N399,N400, \\note fields as indicated

  N401,N402,N403,N404, N405,N406,N407,N408, N409,N410,N411,N412, N413,N414,N415,N416, N417,N418,N419,N420, \\note fields as indicated
  N421,N422,N423,N424, N425,N426,N427,N428, N429,N430,N431,N432, N433,N434,N435,N436, N437,N438,N439,N440, \\note fields as indicated
  N441,N442,N443,N444, N445,N446,N447,N448, N449,N450,N451,N452, N453,N454,N455,N456, N457,N458,N459,N460, \\note fields as indicated
  N461,N462,N463,N464, N465,N466,N467,N468, N469,N470,N471,N472, N473,N474,N475,N476, N477,N478,N479,N480, \\note fields as indicated
  N481,N482,N483,N484, N485,N486,N487,N488, N489,N490,N491,N492, N493,N494,N495,N496, N497,N498,N499,N500, \\note fields as indicated

  N501,N502,N503,N504, N505,N506,N507,N508, N509,N510,N511,N512, N513,N514,N515,N516, N517,N518,N519,N520, \\note fields as indicated
  N521,N522,N523,N524, N525,N526,N527,N528, N529,N530,N531,N532, N533,N534,N535,N536, N537,N538,N539,N540, \\note fields as indicated
  N541,N542,N543,N544, N545,N546,N547,N548, N549,N550,N551,N552, N553,N554,N555,N556, N557,N558,N559,N560, \\note fields as indicated
  N561,N562,N563,N564, N565,N566,N567,N568, N569,N570,N571,N572, N573,N574,N575,N576, N577,N578,N579,N580, \\note fields as indicated
  N581,N582,N583,N584, N585,N586,N587,N588, N589,N590,N591,N592, N593,N594,N595,N596, N597,N598,N599,N600, \\note fields as indicated

  N601,N602,N603,N604, N605,N606,N607,N608, N609,N610,N611,N612, N613,N614,N615,N616, N617,N618,N619,N620, \\note fields as indicated
  N621,N622,N623,N624, N625,N626,N627,N628, N629,N630,N631,N632, N633,N634,N635,N636, N637,N638,N639,N640, \\note fields as indicated
  N641,N642,N643,N644, N645,N646,N647,N648, N649,N650,N651,N652, N653,N654,N655,N656, N657,N658,N659,N660, \\note fields as indicated
  N661,N662,N663,N664, N665,N666,N667,N668, N669,N670,N671,N672, N673,N674,N675,N676, N677,N678,N679,N680, \\note fields as indicated
  N681,N682,N683,N684, N685,N686,N687,N688, N689,N690,N691,N692, N693,N694,N695,N696, N697,N698,N699,N700, \\note fields as indicated

  N701,N702,N703,N704, N705,N706,N707,N708, N709,N710,N711,N712, N713,N714,N715,N716, N717,N718,N719,N720, \\note fields as indicated
  N721,N722,N723,N724, N725,N726,N727,N728, N729,N730,N731,N732, N733,N734,N735,N736, N737,N738,N739,N740, \\note fields as indicated
  N741,N742,N743,N744, N745,N746,N747,N748, N749,N750,N751,N752, N753,N754,N755,N756, N757,N758,N759,N760, \\note fields as indicated
  N761,N762,N763,N764, N765,N766,N767,N768, N769,N770,N771,N772, N773,N774,N775,N776, N777,N778,N779,N780, \\note fields as indicated
  N781,N782,N783,N784, N785,N786,N787,N788, N789,N790,N791,N792, N793,N794,N795,N796, N797,N798,N799,N800, \\note fields as indicated

  N801,N802,N803,N804, N805,N806,N807,N808, N809,N810,N811,N812, N813,N814,N815,N816, N817,N818,N819,N820, \\note fields as indicated
  N821,N822,N823,N824, N825,N826,N827,N828, N829,N830,N831,N832, N833,N834,N835,N836, N837,N838,N839,N840, \\note fields as indicated
  N841,N842,N843,N844, N845,N846,N847,N848, N849,N850,N851,N852, N853,N854,N855,N856, N857,N858,N859,N860, \\note fields as indicated
  N861,N862,N863,N864, N865,N866,N867,N868, N869,N870,N871,N872, N873,N874,N875,N876, N877,N878,N879,N880, \\note fields as indicated
  N881,N882,N883,N884, N885,N886,N887,N888, N889,N890,N891,N892, N893,N894,N895,N896, N897,N898,N899,N900, \\note fields as indicated

  N901,N902,N903,N904, N905,N906,N907,N908, N909,N910,N911,N912, N913,N914,N915,N916, N917,N918,N919,N920, \\note fields as indicated
  N921,N922,N923,N924, N925,N926,N927,N928, N929,N930,N931,N932, N933,N934,N935,N936, N937,N938,N939,N940, \\note fields as indicated
  N941,N942,N943,N944, N945,N946,N947,N948, N949,N950,N951,N952, N953,N954,N955,N956, N957,N958,N959,N960, \\note fields as indicated
  N961,N962,N963,N964, N965,N966,N967,N968, N969,N970,N971,N972, N973,N974,N975,N976, N977,N978,N979,N980, \\note fields as indicated
  N981,N982,N983,N984, N985,N986,N987,N988, N989,N990,N991,N992, N993,N994,N995,N996, N997,N998,N999,N1000, \\note fields as indicated

  N1001,N1002,N1003,N1004, N1005,N1006,N1007,N1008, N1009,N1010,N1011,N1012, N1013,N1014,N1015,N1016, N1017,N1018,N1019,N1020, \\note fields as indicated
  N1021,N1022,N1023,N1024, N1025,N1026,N1027,N1028, N1029,N1030,N1031,N1032, N1033,N1034,N1035,N1036, N1037,N1038,N1039,N1040, \\note fields as indicated
  N1041,N1042,N1043,N1044, N1045,N1046,N1047,N1048, N1049,N1050,N1051,N1052, N1053,N1054,N1055,N1056, N1057,N1058,N1059,N1060, \\note fields as indicated
  N1061,N1062,N1063,N1064, N1065,N1066,N1067,N1068, N1069,N1070,N1071,N1072, N1073,N1074,N1075,N1076, N1077,N1078,N1079,N1080, \\note fields as indicated
  N1081,N1082,N1083,N1084, N1085,N1086,N1087,N1088, N1089,N1090,N1091,N1092, N1093,N1094,N1095,N1096, N1097,N1098,N1099,N1100, \\note fields as indicated

  N1101,N1102,N1103,N1104, N1105,N1106,N1107,N1108, N1109,N1110,N1111,N1112, N1113,N1114,N1115,N1116, N1117,N1118,N1119,N1120, \\note fields as indicated
  N1121,N1122,N1123,N1124, N1125,N1126,N1127,N1128, N1129,N1130,N1131,N1132, N1133,N1134,N1135,N1136, N1137,N1138,N1139,N1140, \\note fields as indicated
  N1141,N1142,N1143,N1144, N1145,N1146,N1147,N1148, N1149,N1150,N1151,N1152, N1153,N1154,N1155,N1156, N1157,N1158,N1159,N1160, \\note fields as indicated
  N1161,N1162,N1163,N1164, N1165,N1166,N1167,N1168, N1169,N1170,N1171,N1172, N1173,N1174,N1175,N1176, N1177,N1178,N1179,N1180, \\note fields as indicated
  N1181,N1182,N1183,N1184, N1185,N1186,N1187,N1188, N1189,N1190,N1191,N1192, N1193,N1194,N1195,N1196, N1197,N1198,N1199,N1200, \\note fields as indicated

  N1201,N1202,N1203,N1204, N1205,N1206,N1207,N1208, N1209,N1210,N1211,N1212, N1213,N1214,N1215,N1216, N1217,N1218,N1219,N1220,\\note fields as indicated
  N1221,N1222,N1223,N1224, N1225,N1226,N1227,N1228, N1229,N1230,N1231,N1232, N1233,N1234,N1235,N1236, N1237,N1238,N1239,N1240,\\note fields as indicated
  N1241,N1242,N1243,N1244, N1245,N1246,N1247,N1248, N1249,N1250,N1251,N1252, N1253,N1254,N1255,N1256, N1257,N1258,N1259,N1260,\\note fields as indicated
  N1261,N1262,N1263,N1264, N1265,N1266,N1267,N1268, N1269,N1270,N1271,N1272, N1273,N1274,N1275,N1276, N1277,N1278,N1279,N1280,\\note fields as indicated
  N1281,N1282,N1283,N1284, N1285,N1286,N1287,N1288, N1289,N1290,N1291,N1292, N1293,N1294,N1295,N1296, N1297,N1298,N1299,N1300,\\note fields as indicated

  N1301,N1302,N1303,N1304, N1305,N1306,N1307,N1308, N1309,N1310,N1311,N1312, N1313,N1314,N1315,N1316, N1317,N1318,N1319,N1320,\\note fields as indicated
  N1321,N1322,N1323,N1324, N1325,N1326,N1327,N1328, N1329,N1330,N1331,N1332, N1333,N1334,N1335,N1336, N1337,N1338,N1339,N1340,\\note fields as indicated
  N1341,N1342,N1343,N1344, N1345,N1346,N1347,N1348, N1349,N1350,N1351,N1352, N1353,N1354,N1355,N1356, N1357,N1358,N1359,N1360,\\note fields as indicated
  N1361,N1362,N1363,N1364, N1365,N1366,N1367,N1368, N1369,N1370,N1371,N1372, N1373,N1374,N1375,N1376, N1377,N1378,N1379,N1380,\\note fields as indicated
  N1381,N1382,N1383,N1384, N1385,N1386,N1387,N1388, N1389,N1390,N1391,N1392, N1393,N1394,N1395,N1396, N1397,N1398,N1399,N1400,\\note fields as indicated

  N1401,N1402,N1403,N1404, N1405,N1406,N1407,N1408, N1409,N1410,N1411,N1412, N1413,N1414,N1415,N1416, N1417,N1418,N1419,N1420,\\note fields as indicated
  N1421,N1422,N1423,N1424, N1425,N1426,N1427,N1428, N1429,N1430,N1431,N1432, N1433,N1434,N1435,N1436, N1437,N1438,N1439,N1440,\\note fields as indicated
  N1441;\\note fields as indicated

Schedule:Week:Daily,
  \\min-fields 13
       \\memo  A Schedule:Week:Daily contains 12 Schedule:Day:Hourly objects, one for each day type.
  A1 , \\field Name
       \\required-field
       \\reference WeekScheduleNames
       \\type alpha
  A2 , \\field Sunday Schedule:Day Name
       \\required-field
       \\type object-list
       \\object-list DayScheduleNames
  A3 , \\field Monday Schedule:Day Name
       \\required-field
       \\type object-list
       \\object-list DayScheduleNames
  A4 , \\field Tuesday Schedule:Day Name
       \\required-field
       \\type object-list
       \\object-list DayScheduleNames
  A5 , \\field Wednesday Schedule:Day Name
       \\required-field
       \\type object-list
       \\object-list DayScheduleNames
  A6 , \\field Thursday Schedule:Day Name
       \\required-field
       \\type object-list
       \\object-list DayScheduleNames
  A7 , \\field Friday Schedule:Day Name
       \\required-field
       \\type object-list
       \\object-list DayScheduleNames
  A8 , \\field Saturday Schedule:Day Name
       \\required-field
       \\type object-list
       \\object-list DayScheduleNames
  A9 , \\field Holiday Schedule:Day Name
       \\required-field
       \\type object-list
       \\object-list DayScheduleNames
  A10, \\field SummerDesignDay Schedule:Day Name
       \\required-field
       \\type object-list
       \\object-list DayScheduleNames
  A11, \\field WinterDesignDay Schedule:Day Name
       \\required-field
       \\type object-list
       \\object-list DayScheduleNames
  A12, \\field CustomDay1 Schedule:Day Name
       \\required-field
       \\type object-list
       \\object-list DayScheduleNames
  A13; \\field CustomDay2 Schedule:Day Name
       \\required-field
       \\type object-list
       \\object-list DayScheduleNames

Schedule:Week:Compact,
  \\extensible:2 - repeat last two fields, remembering to remove ; from "inner" fields.
  \\memo Compact definition for Schedule:Day:List
  \\min-fields 3
  A1 , \\field Name
       \\required-field
       \\reference WeekScheduleNames
       \\type alpha
  A2 , \\field DayType List 1
       \\begin-extensible
       \\note "For" is an optional prefix/start of the For fields.  Choices can be combined on single line
       \\note if separated by spaces. i.e. "Holiday Weekends"
       \\note Should have a space after For, if it is included. i.e. "For Alldays"
       \\required-field
       \\type choice
       \\key AllDays
       \\key Weekdays
       \\key Weekends
       \\key Sunday
       \\key Monday
       \\key Tuesday
       \\key Wednesday
       \\key Thursday
       \\key Friday
       \\key Saturday
       \\key Holiday
       \\key SummerDesignDay
       \\key WinterDesignDay
       \\key CustomDay1
       \\key CustomDay2
  A3 , \\field Schedule:Day Name 1
       \\required-field
       \\type object-list
       \\object-list DayScheduleNames
  A4 , \\field DayType List 2
       \\type choice
       \\key AllOtherDays
       \\key Weekdays
       \\key Weekends
       \\key Sunday
       \\key Monday
       \\key Tuesday
       \\key Wednesday
       \\key Thursday
       \\key Friday
       \\key Saturday
       \\key Holiday
       \\key SummerDesignDay
       \\key WinterDesignDay
       \\key CustomDay1
       \\key CustomDay2
  A5 , \\field Schedule:Day Name 2
       \\type object-list
       \\object-list DayScheduleNames
  A6 , \\field DayType List 3
       \\type choice
       \\key AllOtherDays
       \\key Weekdays
       \\key Weekends
       \\key Sunday
       \\key Monday
       \\key Tuesday
       \\key Wednesday
       \\key Thursday
       \\key Friday
       \\key Saturday
       \\key Holiday
       \\key SummerDesignDay
       \\key WinterDesignDay
       \\key CustomDay1
       \\key CustomDay2
  A7 , \\field Schedule:Day Name 3
       \\type object-list
       \\object-list DayScheduleNames
  A8 , \\field DayType List 4
       \\type choice
       \\key AllOtherDays
       \\key Weekdays
       \\key Weekends
       \\key Sunday
       \\key Monday
       \\key Tuesday
       \\key Wednesday
       \\key Thursday
       \\key Friday
       \\key Saturday
       \\key Holiday
       \\key SummerDesignDay
       \\key WinterDesignDay
       \\key CustomDay1
       \\key CustomDay2
  A9 , \\field Schedule:Day Name 4
       \\type object-list
       \\object-list DayScheduleNames
  A10, \\field DayType List 5
       \\type choice
       \\key AllOtherDays
       \\key Weekdays
       \\key Weekends
       \\key Sunday
       \\key Monday
       \\key Tuesday
       \\key Wednesday
       \\key Thursday
       \\key Friday
       \\key Saturday
       \\key Holiday
       \\key SummerDesignDay
       \\key WinterDesignDay
       \\key CustomDay1
       \\key CustomDay2
  A11; \\field Schedule:Day Name 5
       \\type object-list
       \\object-list DayScheduleNames

Schedule:Year,
 \\min-fields 7
       \\memo A Schedule:Year contains from 1 to 52 week schedules
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ScheduleNames
  A2 , \\field Schedule Type Limits Name
       \\type object-list
       \\object-list ScheduleTypeLimitsNames
  A3 , \\field Schedule:Week Name 1
       \\required-field
       \\type object-list
       \\object-list WeekScheduleNames
  N1 , \\field Start Month 1
       \\required-field
       \\type integer
       \\minimum 1
       \\maximum 12
  N2 , \\field Start Day 1
       \\required-field
       \\type integer
       \\minimum 1
       \\maximum 31
  N3 , \\field End Month 1
       \\required-field
       \\type integer
       \\minimum 1
       \\maximum 12
  N4 , \\field End Day 1
       \\required-field
       \\type integer
       \\minimum 1
       \\maximum 31
  A4 , \\field Schedule:Week Name 2
       \\type object-list
       \\object-list WeekScheduleNames
  N5 , \\field Start Month 2
       \\type integer
       \\minimum 1
       \\maximum 12
  N6 , \\field Start Day 2
       \\type integer
       \\minimum 1
       \\maximum 31
  N7 , \\field End Month 2
       \\type integer
       \\minimum 1
       \\maximum 12
  N8 , \\field End Day 2
       \\type integer
       \\minimum 1
       \\maximum 31
  A5 , \\field Schedule:Week Name 3
       \\type object-list
       \\object-list WeekScheduleNames
  N9 , \\field Start Month 3
       \\type integer
       \\minimum 1
       \\maximum 12
  N10, \\field Start Day 3
       \\type integer
       \\minimum 1
       \\maximum 31
  N11, \\field End Month 3
       \\type integer
       \\minimum 1
       \\maximum 12
  N12, \\field End Day 3
       \\type integer
       \\minimum 1
       \\maximum 31
  A6 , \\field Schedule:Week Name 4
       \\type object-list
       \\object-list WeekScheduleNames
  N13, \\field Start Month 4
       \\type integer
       \\minimum 1
       \\maximum 12
  N14, \\field Start Day 4
       \\type integer
       \\minimum 1
       \\maximum 31
  N15, \\field End Month 4
       \\type integer
       \\minimum 1
       \\maximum 12
  N16, \\field End Day 4
       \\type integer
       \\minimum 1
       \\maximum 31
  A7 , \\field Schedule:Week Name 5
       \\type object-list
       \\object-list WeekScheduleNames
  N17, \\field Start Month 5
       \\type integer
       \\minimum 1
       \\maximum 12
  N18, \\field Start Day 5
       \\type integer
       \\minimum 1
       \\maximum 31
  N19, \\field End Month 5
       \\type integer
       \\minimum 1
       \\maximum 12
  N20, \\field End Day 5
       \\type integer
       \\minimum 1
       \\maximum 31
  A8 , \\field Schedule:Week Name 6
       \\type object-list
       \\object-list WeekScheduleNames
  N21, \\field Start Month 6
       \\type integer
       \\minimum 1
       \\maximum 12
  N22, \\field Start Day 6
       \\type integer
       \\minimum 1
       \\maximum 31
  N23, \\field End Month 6
       \\type integer
       \\minimum 1
       \\maximum 12
  N24, \\field End Day 6
       \\type integer
       \\minimum 1
       \\maximum 31
  A9 , \\field Schedule:Week Name 7
       \\type object-list
       \\object-list WeekScheduleNames
  N25, \\field Start Month 7
       \\type integer
       \\minimum 1
       \\maximum 12
  N26, \\field Start Day 7
       \\type integer
       \\minimum 1
       \\maximum 31
  N27, \\field End Month 7
       \\type integer
       \\minimum 1
       \\maximum 12
  N28, \\field End Day 7
       \\type integer
       \\minimum 1
       \\maximum 31
  A10, \\field Schedule:Week Name 8
       \\type object-list
       \\object-list WeekScheduleNames
  N29, \\field Start Month 8
       \\type integer
       \\minimum 1
       \\maximum 12
  N30, \\field Start Day 8
       \\type integer
       \\minimum 1
       \\maximum 31
  N31, \\field End Month 8
       \\type integer
       \\minimum 1
       \\maximum 12
  N32, \\field End Day 8
       \\type integer
       \\minimum 1
       \\maximum 31
  A11, \\field Schedule:Week Name 9
       \\type object-list
       \\object-list WeekScheduleNames
  N33, \\field Start Month 9
       \\type integer
       \\minimum 1
       \\maximum 12
  N34, \\field Start Day 9
       \\type integer
       \\minimum 1
       \\maximum 31
  N35, \\field End Month 9
       \\type integer
       \\minimum 1
       \\maximum 12
  N36, \\field End Day 9
       \\type integer
       \\minimum 1
       \\maximum 31
  A12, \\field Schedule:Week Name 10
       \\type object-list
       \\object-list WeekScheduleNames
  N37, \\field Start Month 10
       \\type integer
       \\minimum 1
       \\maximum 12
  N38, \\field Start Day 10
       \\type integer
       \\minimum 1
       \\maximum 31
  N39, \\field End Month 10
       \\type integer
       \\minimum 1
       \\maximum 12
  N40, \\field End Day 10
       \\type integer
       \\minimum 1
       \\maximum 31
  A13, \\field Schedule:Week Name 11
       \\type object-list
       \\object-list WeekScheduleNames
  N41, \\field Start Month 11
       \\type integer
       \\minimum 1
       \\maximum 12
  N42, \\field Start Day 11
       \\type integer
       \\minimum 1
       \\maximum 31
  N43, \\field End Month 11
       \\type integer
       \\minimum 1
       \\maximum 12
  N44, \\field End Day 11
       \\type integer
       \\minimum 1
       \\maximum 31
  A14, \\field Schedule:Week Name 12
       \\type object-list
       \\object-list WeekScheduleNames
  N45, \\field Start Month 12
       \\type integer
       \\minimum 1
       \\maximum 12
  N46, \\field Start Day 12
       \\type integer
       \\minimum 1
       \\maximum 31
  N47, \\field End Month 12
       \\type integer
       \\minimum 1
       \\maximum 12
  N48, \\field End Day 12
       \\type integer
       \\minimum 1
       \\maximum 31
  A15, \\field Schedule:Week Name 13
       \\type object-list
       \\object-list WeekScheduleNames
  N49, \\field Start Month 13
       \\type integer
       \\minimum 1
       \\maximum 12
  N50, \\field Start Day 13
       \\type integer
       \\minimum 1
       \\maximum 31
  N51, \\field End Month 13
       \\type integer
       \\minimum 1
       \\maximum 12
  N52, \\field End Day 13
       \\type integer
       \\minimum 1
       \\maximum 31
  A16, \\field Schedule:Week Name 14
       \\type object-list
       \\object-list WeekScheduleNames
  N53, \\field Start Month 14
       \\type integer
       \\minimum 1
       \\maximum 12
  N54, \\field Start Day 14
       \\type integer
       \\minimum 1
       \\maximum 31
  N55, \\field End Month 14
       \\type integer
       \\minimum 1
       \\maximum 12
  N56, \\field End Day 14
       \\type integer
       \\minimum 1
       \\maximum 31
  A17, \\field Schedule:Week Name 15
       \\type object-list
       \\object-list WeekScheduleNames
  N57, \\field Start Month 15
       \\type integer
       \\minimum 1
       \\maximum 12
  N58, \\field Start Day 15
       \\type integer
       \\minimum 1
       \\maximum 31
  N59, \\field End Month 15
       \\type integer
       \\minimum 1
       \\maximum 12
  N60, \\field End Day 15
       \\type integer
       \\minimum 1
       \\maximum 31
  A18, \\field Schedule:Week Name 16
       \\type object-list
       \\object-list WeekScheduleNames
  N61, \\field Start Month 16
       \\type integer
       \\minimum 1
       \\maximum 12
  N62, \\field Start Day 16
       \\type integer
       \\minimum 1
       \\maximum 31
  N63, \\field End Month 16
       \\type integer
       \\minimum 1
       \\maximum 12
  N64, \\field End Day 16
       \\type integer
       \\minimum 1
       \\maximum 31
  A19, \\field Schedule:Week Name 17
       \\type object-list
       \\object-list WeekScheduleNames
  N65, \\field Start Month 17
       \\type integer
       \\minimum 1
       \\maximum 12
  N66, \\field Start Day 17
       \\type integer
       \\minimum 1
       \\maximum 31
  N67, \\field End Month 17
       \\type integer
       \\minimum 1
       \\maximum 12
  N68, \\field End Day 17
       \\type integer
       \\minimum 1
       \\maximum 31
  A20, \\field Schedule:Week Name 18
       \\type object-list
       \\object-list WeekScheduleNames
  N69, \\field Start Month 18
       \\type integer
       \\minimum 1
       \\maximum 12
  N70, \\field Start Day 18
       \\type integer
       \\minimum 1
       \\maximum 31
  N71, \\field End Month 18
       \\type integer
       \\minimum 1
       \\maximum 12
  N72, \\field End Day 18
       \\type integer
       \\minimum 1
       \\maximum 31
  A21, \\field Schedule:Week Name 19
       \\type object-list
       \\object-list WeekScheduleNames
  N73, \\field Start Month 19
       \\type integer
       \\minimum 1
       \\maximum 12
  N74, \\field Start Day 19
       \\type integer
       \\minimum 1
       \\maximum 31
  N75, \\field End Month 19
       \\type integer
       \\minimum 1
       \\maximum 12
  N76, \\field End Day 19
       \\type integer
       \\minimum 1
       \\maximum 31
  A22, \\field Schedule:Week Name 20
       \\type object-list
       \\object-list WeekScheduleNames
  N77, \\field Start Month 20
       \\type integer
       \\minimum 1
       \\maximum 12
  N78, \\field Start Day 20
       \\type integer
       \\minimum 1
       \\maximum 31
  N79, \\field End Month 20
       \\type integer
       \\minimum 1
       \\maximum 12
  N80, \\field End Day 20
       \\type integer
       \\minimum 1
       \\maximum 31
  A23, \\field Schedule:Week Name 21
       \\type object-list
       \\object-list WeekScheduleNames
  N81, \\field Start Month 21
       \\type integer
       \\minimum 1
       \\maximum 12
  N82, \\field Start Day 21
       \\type integer
       \\minimum 1
       \\maximum 31
  N83, \\field End Month 21
       \\type integer
       \\minimum 1
       \\maximum 12
  N84, \\field End Day 21
       \\type integer
       \\minimum 1
       \\maximum 31
  A24, \\field Schedule:Week Name 22
       \\type object-list
       \\object-list WeekScheduleNames
  N85, \\field Start Month 22
       \\type integer
       \\minimum 1
       \\maximum 12
  N86, \\field Start Day 22
       \\type integer
       \\minimum 1
       \\maximum 31
  N87, \\field End Month 22
       \\type integer
       \\minimum 1
       \\maximum 12
  N88, \\field End Day 22
       \\type integer
       \\minimum 1
       \\maximum 31
  A25, \\field Schedule:Week Name 23
       \\type object-list
       \\object-list WeekScheduleNames
  N89, \\field Start Month 23
       \\type integer
       \\minimum 1
       \\maximum 12
  N90, \\field Start Day 23
       \\type integer
       \\minimum 1
       \\maximum 31
  N91, \\field End Month 23
       \\type integer
       \\minimum 1
       \\maximum 12
  N92, \\field End Day 23
       \\type integer
       \\minimum 1
       \\maximum 31
  A26, \\field Schedule:Week Name 24
       \\type object-list
       \\object-list WeekScheduleNames
  N93, \\field Start Month 24
       \\type integer
       \\minimum 1
       \\maximum 12
  N94, \\field Start Day 24
       \\type integer
       \\minimum 1
       \\maximum 31
  N95, \\field End Month 24
       \\type integer
       \\minimum 1
       \\maximum 12
  N96, \\field End Day 24
       \\type integer
       \\minimum 1
       \\maximum 31
  A27, \\field Schedule:Week Name 25
       \\type object-list
       \\object-list WeekScheduleNames
  N97, \\field Start Month 25
       \\type integer
       \\minimum 1
       \\maximum 12
  N98, \\field Start Day 25
       \\type integer
       \\minimum 1
       \\maximum 31
  N99, \\field End Month 25
       \\type integer
       \\minimum 1
       \\maximum 12
 N100, \\field End Day 25
       \\type integer
       \\minimum 1
       \\maximum 31
  A28, \\field Schedule:Week Name 26
       \\type object-list
       \\object-list WeekScheduleNames
 N101, \\field Start Month 26
       \\type integer
       \\minimum 1
       \\maximum 12
 N102, \\field Start Day 26
       \\type integer
       \\minimum 1
       \\maximum 31
 N103, \\field End Month 26
       \\type integer
       \\minimum 1
       \\maximum 12
 N104, \\field End Day 26
       \\type integer
       \\minimum 1
       \\maximum 31
 \\note Schedule:Week for Weeks 27-53 are condensed
 A29,N105,N106,N107,N108, \\note For Week  27
 A30,N109,N110,N111,N112, \\note For Week  28
 A31,N113,N114,N115,N116, \\note For Week  29
 A32,N117,N118,N119,N120, \\note For Week  30
 A33,N121,N122,N123,N124, \\note For Week  31
 A34,N125,N126,N127,N128, \\note For Week  32
 A35,N129,N130,N131,N132, \\note For Week  33
 A36,N133,N134,N135,N136, \\note For Week  34
 A37,N137,N138,N139,N140, \\note For Week  35
 A38,N141,N142,N143,N144, \\note For Week  36
 A39,N145,N146,N147,N148, \\note For Week  37
 A40,N149,N150,N151,N152, \\note For Week  38
 A41,N153,N154,N155,N156, \\note For Week  39
 A42,N157,N158,N159,N160, \\note For Week  40
 A43,N161,N162,N163,N164, \\note For Week  41
 A44,N165,N166,N167,N168, \\note For Week  42
 A45,N169,N170,N171,N172, \\note For Week  43
 A46,N173,N174,N175,N176, \\note For Week  44
 A47,N177,N178,N179,N180, \\note For Week  45
 A48,N181,N182,N183,N184, \\note For Week  46
 A49,N185,N186,N187,N188, \\note For Week  47
 A50,N189,N190,N191,N192, \\note For Week  48
 A51,N193,N194,N195,N196, \\note For Week  49
 A52,N197,N198,N199,N200, \\note For Week  50
 A53,N201,N202,N203,N204, \\note For Week  51
 A54,N205,N206,N207,N208, \\note For Week  52
 A55,N209,N210,N211,N212; \\note For Week  53

Schedule:Compact,
   \\extensible:1 - repeat last field, remembering to remove ; from "inner" fields.
   \\min-fields 5
   \\memo Irregular object.  Does not follow the usual definition for fields.  Fields A3... are:
   \\memo Through: Date
   \\memo For: Applicable days (ref: Schedule:Week:Compact)
   \\memo Interpolate: Yes/No (ref: Schedule:Day:Interval) -- optional, if not used will be "No"
   \\memo Until: <Time> (ref: Schedule:Day:Interval)
   \\memo <numeric value>
   \\memo words "Through","For","Interpolate","Until" must be included.
   \\format compactSchedule
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ScheduleNames
  A2 , \\field Schedule Type Limits Name
       \\type object-list
       \\object-list ScheduleTypeLimitsNames
  A3 , \\field Field 1
       \\begin-extensible
  A4 , \\field Field 2
  A5 , \\field Field 3
  A6 , \\field Field 4
  A7 , \\field Field 5
  A8 , \\field Field 6
  A9 , \\field Field 7
  A10, \\field Field 8
  A11, \\field Field 9
  A12, \\field Field 10
  A13, \\field Field 11
  A14, \\field Field 12
  A15, \\field Field 13
  A16, \\field Field 14
  A17, \\field Field 15
  A18, \\field Field 16
  A19, \\field Field 17
  A20, \\field Field 18
  A21, \\field Field 19
  A22, \\field Field 20
  A23, \\field Field 21
  A24, \\field Field 22
  A25, \\field Field 23
  A26, \\field Field 24
  A27, \\field Field 25
  A28, \\field Field 26
  A29, \\field Field 27
  A30, \\field Field 28
  A31, \\field Field 29
  A32, \\field Field 30
  A33, \\field Field 31
  A34, \\field Field 32
  A35, \\field Field 33
  A36, \\field Field 34
  A37, \\field Field 35
  A38, \\field Field 36
  A39, \\field Field 37
  A40, \\field Field 38
  A41, \\field Field 39
  A42, \\field Field 40
  A43, \\field Field 41
  A44, \\field Field 42
  A45, \\field Field 43
  A46, \\field Field 44
  A47, \\field Field 45
  A48, \\field Field 46
  A49, \\field Field 47
  A50, \\field Field 48
  A51, \\field Field 49
  A52, \\field Field 50
  A53, \\field Field 51
  A54, \\field Field 52
  A55, \\field Field 53
  A56, \\field Field 54
  A57, \\field Field 55
  A58, \\field Field 56
  A59, \\field Field 57
  A60, \\field Field 58
  A61, \\field Field 59
  A62, \\field Field 60
  A63, \\field Field 61
  A64, \\field Field 62
  A65, \\field Field 63
  A66, \\field Field 64
  A67, \\field Field 65
  A68, \\field Field 66
  A69, \\field Field 67
  A70, \\field Field 68
  A71, \\field Field 69
  A72, \\field Field 70
  A73, \\field Field 71
  A74, \\field Field 72
  A75, \\field Field 73
  A76, \\field Field 74
  A77, \\field Field 75
  A78, \\field Field 76
  A79, \\field Field 77
  A80, \\field Field 78
  A81, \\field Field 79
  A82, \\field Field 80
  A83, \\field Field 81
  A84, \\field Field 82
  A85, \\field Field 83
  A86, \\field Field 84
  A87, \\field Field 85
  A88, \\field Field 86
  A89, \\field Field 87
  A90, \\field Field 88
  A91, \\field Field 89
  A92, \\field Field 90
  A93, \\field Field 91
  A94, \\field Field 92
  A95, \\field Field 93
  A96, \\field Field 94
  A97, \\field Field 95
  A98, \\field Field 96
  A99, \\field Field 97
 A100, \\field Field 98
 A101, \\field Field 99
 A102, \\field Field 100
 A103, \\field Field 101
 A104, \\field Field 102
 A105, \\field Field 103
 A106, \\field Field 104
 A107, \\field Field 105
 A108, \\field Field 106
 A109, \\field Field 107
 A110, \\field Field 108
 A111, \\field Field 109
 A112, \\field Field 110
 A113, \\field Field 111
 A114, \\field Field 112
 A115, \\field Field 113
 A116, \\field Field 114
 A117, \\field Field 115
 A118, \\field Field 116
 A119, \\field Field 117
 A120, \\field Field 118
 A121, \\field Field 119
 A122, \\field Field 120
 A123, \\field Field 121
 A124, \\field Field 122
 A125, \\field Field 123
 A126, \\field Field 124
 A127, \\field Field 125
 A128, \\field Field 126
 A129, \\field Field 127
 A130, \\field Field 128
 A131, \\field Field 129
 A132, \\field Field 130
 A133, \\field Field 131
 A134, \\field Field 132
 A135, \\field Field 133
 A136, \\field Field 134
 A137, \\field Field 135
 A138, \\field Field 136
 A139, \\field Field 137
 A140, \\field Field 138
 A141, \\field Field 139
 A142, \\field Field 140
 A143, \\field Field 141
 A144, \\field Field 142
 A145, \\field Field 143
 A146, \\field Field 144
 A147, \\field Field 145
 A148, \\field Field 146
 A149, \\field Field 147
 A150, \\field Field 148
 A151, \\field Field 149
 A152, \\field Field 150
 A153,A154,A155,A156,A157,A158,A159,A160,A161,A162,A163,A164,A165,A166,A167, \\note fields as indicated
 A168,A169,A170,A171,A172,A173,A174,A175,A176,A177,A178,A179,A180,A181,A182, \\note fields as indicated
 A183,A184,A185,A186,A187,A188,A189,A190,A191,A192,A193,A194,A195,A196,A197, \\note fields as indicated
 A198,A199,A200,A201,A202,A203,A204,A205,A206,A207,A208,A209,A210,A211,A212, \\note fields as indicated
 A213,A214,A215,A216,A217,A218,A219,A220,A221,A222,A223,A224,A225,A226,A227, \\note fields as indicated
 A228,A229,A230,A231,A232,A233,A234,A235,A236,A237,A238,A239,A240,A241,A242, \\note fields as indicated
 A243,A244,A245,A246,A247,A248,A249,A250,A251,A252,A253,A254,A255,A256,A257, \\note fields as indicated
 A258,A259,A260,A261,A262,A263,A264,A265,A266,A267,A268,A269,A270,A271,A272, \\note fields as indicated
 A273,A274,A275,A276,A277,A278,A279,A280,A281,A282,A283,A284,A285,A286,A287, \\note fields as indicated
 A288,A289,A290,A291,A292,A293,A294,A295,A296,A297,A298,A299,A300,A301,A302, \\note fields as indicated
 A303,A304,A305,A306,A307,A308,A309,A310,A311,A312,A313,A314,A315,A316,A317, \\note fields as indicated
 A318,A319,A320,A321,A322,A323,A324,A325,A326,A327,A328,A329,A330,A331,A332, \\note fields as indicated
 A333,A334,A335,A336,A337,A338,A339,A340,A341,A342,A343,A344,A345,A346,A347, \\note fields as indicated
 A348,A349,A350,A351,A352,A353,A354,A355,A356,A357,A358,A359,A360,A361,A362, \\note fields as indicated
 A363,A364,A365,A366,A367,A368,A369,A370,A371,A372,A373,A374,A375,A376,A377, \\note fields as indicated
 A378,A379,A380,A381,A382,A383,A384,A385,A386,A387,A388,A389,A390,A391,A392, \\note fields as indicated
 A393,A394,A395,A396,A397,A398,A399,A400,A401,A402,A403,A404,A405,A406,A407, \\note fields as indicated
 A408,A409,A410,A411,A412,A413,A414,A415,A416,A417,A418,A419,A420,A421,A422, \\note fields as indicated
 A423,A424,A425,A426,A427,A428,A429,A430,A431,A432,A433,A434,A435,A436,A437, \\note fields as indicated
 A438,A439,A440,A441,A442,A443,A444,A445,A446,A447,A448,A449,A450,A451,A452, \\note fields as indicated
 A453,A454,A455,A456,A457,A458,A459,A460,A461,A462,A463,A464,A465,A466,A467, \\note fields as indicated
 A468,A469,A470,A471,A472,A473,A474,A475,A476,A477,A478,A479,A480,A481,A482, \\note fields as indicated
 A483,A484,A485,A486,A487,A488,A489,A490,A491,A492,A493,A494,A495,A496,A497, \\note fields as indicated
 A498,A499,A500,A501,A502,A503,A504,A505,A506,A507,A508,A509,A510,A511,A512, \\note fields as indicated
 A513,A514,A515,A516,A517,A518,A519,A520,A521,A522,A523,A524,A525,A526,A527, \\note fields as indicated
 A528,A529,A530,A531,A532,A533,A534,A535,A536,A537,A538,A539,A540,A541,A542, \\note fields as indicated
 A543,A544,A545,A546,A547,A548,A549,A550,A551,A552,A553,A554,A555,A556,A557, \\note fields as indicated
 A558,A559,A560,A561,A562,A563,A564,A565,A566,A567,A568,A569,A570,A571,A572, \\note fields as indicated
 A573,A574,A575,A576,A577,A578,A579,A580,A581,A582,A583,A584,A585,A586,A587, \\note fields as indicated
 A588,A589,A590,A591,A592,A593,A594,A595,A596,A597,A598,A599,A600,A601,A602, \\note fields as indicated
 A603,A604,A605,A606,A607,A608,A609,A610,A611,A612,A613,A614,A615,A616,A617, \\note fields as indicated
 A618,A619,A620,A621,A622,A623,A624,A625,A626,A627,A628,A629,A630,A631,A632, \\note fields as indicated
 A633,A634,A635,A636,A637,A638,A639,A640,A641,A642,A643,A644,A645,A646,A647, \\note fields as indicated
 A648,A649,A650,A651,A652,A653,A654,A655,A656,A657,A658,A659,A660,A661,A662, \\note fields as indicated
 A663,A664,A665,A666,A667,A668,A669,A670,A671,A672,A673,A674,A675,A676,A677, \\note fields as indicated
 A678,A679,A680,A681,A682,A683,A684,A685,A686,A687,A688,A689,A690,A691,A692, \\note fields as indicated
 A693,A694,A695,A696,A697,A698,A699,A700,A701,A702,A703,A704,A705,A706,A707, \\note fields as indicated
 A708,A709,A710,A711,A712,A713,A714,A715,A716,A717,A718,A719,A720,A721,A722, \\note fields as indicated
 A723,A724,A725,A726,A727,A728,A729,A730,A731,A732,A733,A734,A735,A736,A737, \\note fields as indicated
 A738,A739,A740,A741,A742,A743,A744,A745,A746,A747,A748,A749,A750,A751,A752, \\note fields as indicated
 A753,A754,A755,A756,A757,A758,A759,A760,A761,A762,A763,A764,A765,A766,A767, \\note fields as indicated
 A768,A769,A770,A771,A772,A773,A774,A775,A776,A777,A778,A779,A780,A781,A782, \\note fields as indicated
 A783,A784,A785,A786,A787,A788,A789,A790,A791,A792,A793,A794,A795,A796,A797, \\note fields as indicated
 A798,A799,A800,A801,A802,A803,A804,A805,A806,A807,A808,A809,A810,A811,A812, \\note fields as indicated
 A813,A814,A815,A816,A817,A818,A819,A820,A821,A822,A823,A824,A825,A826,A827, \\note fields as indicated
 A828,A829,A830,A831,A832,A833,A834,A835,A836,A837,A838,A839,A840,A841,A842, \\note fields as indicated
 A843,A844,A845,A846,A847,A848,A849,A850,A851,A852,A853,A854,A855,A856,A857, \\note fields as indicated
 A858,A859,A860,A861,A862,A863,A864,A865,A866,A867,A868,A869,A870,A871,A872, \\note fields as indicated
 A873,A874,A875,A876,A877,A878,A879,A880,A881,A882,A883,A884,A885,A886,A887, \\note fields as indicated
 A888,A889,A890,A891,A892,A893,A894,A895,A896,A897,A898,A899,A900,A901,A902, \\note fields as indicated
 A903,A904,A905,A906,A907,A908,A909,A910,A911,A912,A913,A914,A915,A916,A917, \\note fields as indicated
 A918,A919,A920,A921,A922,A923,A924,A925,A926,A927,A928,A929,A930,A931,A932, \\note fields as indicated
 A933,A934,A935,A936,A937,A938,A939,A940,A941,A942,A943,A944,A945,A946,A947, \\note fields as indicated
 A948,A949,A950,A951,A952,A953,A954,A955,A956,A957,A958,A959,A960,A961,A962, \\note fields as indicated
 A963,A964,A965,A966,A967,A968,A969,A970,A971,A972,A973,A974,A975,A976,A977, \\note fields as indicated
 A978,A979,A980,A981,A982,A983,A984,A985,A986,A987,A988,A989,A990,A991,A992, \\note fields as indicated
 A993,A994,A995,A996,A997,A998,A999,A1000,A1001,A1002,A1003,A1004,A1005,A1006,A1007, \\note fields as indicated
 A1008,A1009,A1010,A1011,A1012,A1013,A1014,A1015,A1016,A1017,A1018,A1019,A1020,A1021,A1022, \\note fields as indicated
 A1023,A1024,A1025,A1026,A1027,A1028,A1029,A1030,A1031,A1032,A1033,A1034,A1035,A1036,A1037, \\note fields as indicated
 A1038,A1039,A1040,A1041,A1042,A1043,A1044,A1045,A1046,A1047,A1048,A1049,A1050,A1051,A1052, \\note fields as indicated
 A1053,A1054,A1055,A1056,A1057,A1058,A1059,A1060,A1061,A1062,A1063,A1064,A1065,A1066,A1067, \\note fields as indicated
 A1068,A1069,A1070,A1071,A1072,A1073,A1074,A1075,A1076,A1077,A1078,A1079,A1080,A1081,A1082, \\note fields as indicated
 A1083,A1084,A1085,A1086,A1087,A1088,A1089,A1090,A1091,A1092,A1093,A1094,A1095,A1096,A1097, \\note fields as indicated
 A1098,A1099,A1100,A1101,A1102,A1103,A1104,A1105,A1106,A1107,A1108,A1109,A1110,A1111,A1112, \\note fields as indicated
 A1113,A1114,A1115,A1116,A1117,A1118,A1119,A1120,A1121,A1122,A1123,A1124,A1125,A1126,A1127, \\note fields as indicated
 A1128,A1129,A1130,A1131,A1132,A1133,A1134,A1135,A1136,A1137,A1138,A1139,A1140,A1141,A1142, \\note fields as indicated
 A1143,A1144,A1145,A1146,A1147,A1148,A1149,A1150,A1151,A1152,A1153,A1154,A1155,A1156,A1157, \\note fields as indicated
 A1158,A1159,A1160,A1161,A1162,A1163,A1164,A1165,A1166,A1167,A1168,A1169,A1170,A1171,A1172, \\note fields as indicated
 A1173,A1174,A1175,A1176,A1177,A1178,A1179,A1180,A1181,A1182,A1183,A1184,A1185,A1186,A1187, \\note fields as indicated
 A1188,A1189,A1190,A1191,A1192,A1193,A1194,A1195,A1196,A1197,A1198,A1199,A1200,A1201,A1202, \\note fields as indicated
 A1203,A1204,A1205,A1206,A1207,A1208,A1209,A1210,A1211,A1212,A1213,A1214,A1215,A1216,A1217, \\note fields as indicated
 A1218,A1219,A1220,A1221,A1222,A1223,A1224,A1225,A1226,A1227,A1228,A1229,A1230,A1231,A1232, \\note fields as indicated
 A1233,A1234,A1235,A1236,A1237,A1238,A1239,A1240,A1241,A1242,A1243,A1244,A1245,A1246,A1247, \\note fields as indicated
 A1248,A1249,A1250,A1251,A1252,A1253,A1254,A1255,A1256,A1257,A1258,A1259,A1260,A1261,A1262, \\note fields as indicated
 A1263,A1264,A1265,A1266,A1267,A1268,A1269,A1270,A1271,A1272,A1273,A1274,A1275,A1276,A1277, \\note fields as indicated
 A1278,A1279,A1280,A1281,A1282,A1283,A1284,A1285,A1286,A1287,A1288,A1289,A1290,A1291,A1292, \\note fields as indicated
 A1293,A1294,A1295,A1296,A1297,A1298,A1299,A1300,A1301,A1302,A1303,A1304,A1305,A1306,A1307, \\note fields as indicated
 A1308,A1309,A1310,A1311,A1312,A1313,A1314,A1315,A1316,A1317,A1318,A1319,A1320,A1321,A1322, \\note fields as indicated
 A1323,A1324,A1325,A1326,A1327,A1328,A1329,A1330,A1331,A1332,A1333,A1334,A1335,A1336,A1337, \\note fields as indicated
 A1338,A1339,A1340,A1341,A1342,A1343,A1344,A1345,A1346,A1347,A1348,A1349,A1350,A1351,A1352, \\note fields as indicated
 A1353,A1354,A1355,A1356,A1357,A1358,A1359,A1360,A1361,A1362,A1363,A1364,A1365,A1366,A1367, \\note fields as indicated
 A1368,A1369,A1370,A1371,A1372,A1373,A1374,A1375,A1376,A1377,A1378,A1379,A1380,A1381,A1382, \\note fields as indicated
 A1383,A1384,A1385,A1386,A1387,A1388,A1389,A1390,A1391,A1392,A1393,A1394,A1395,A1396,A1397, \\note fields as indicated
 A1398,A1399,A1400,A1401,A1402,A1403,A1404,A1405,A1406,A1407,A1408,A1409,A1410,A1411,A1412, \\note fields as indicated
 A1413,A1414,A1415,A1416,A1417,A1418,A1419,A1420,A1421,A1422,A1423,A1424,A1425,A1426,A1427, \\note fields as indicated
 A1428,A1429,A1430,A1431,A1432,A1433,A1434,A1435,A1436,A1437,A1438,A1439,A1440,A1441,A1442, \\note fields as indicated
 A1443,A1444,A1445,A1446,A1447,A1448,A1449,A1450,A1451,A1452,A1453,A1454,A1455,A1456,A1457, \\note fields as indicated
 A1458,A1459,A1460,A1461,A1462,A1463,A1464,A1465,A1466,A1467,A1468,A1469,A1470,A1471,A1472, \\note fields as indicated
 A1473,A1474,A1475,A1476,A1477,A1478,A1479,A1480,A1481,A1482,A1483,A1484,A1485,A1486,A1487, \\note fields as indicated
 A1488,A1489,A1490,A1491,A1492,A1493,A1494,A1495,A1496,A1497,A1498,A1499,A1500,A1501,A1502, \\note fields as indicated
 A1503,A1504,A1505,A1506,A1507,A1508,A1509,A1510,A1511,A1512,A1513,A1514,A1515,A1516,A1517, \\note fields as indicated
 A1518,A1519,A1520,A1521,A1522,A1523,A1524,A1525,A1526,A1527,A1528,A1529,A1530,A1531,A1532, \\note fields as indicated
 A1533,A1534,A1535,A1536,A1537,A1538,A1539,A1540,A1541,A1542,A1543,A1544,A1545,A1546,A1547, \\note fields as indicated
 A1548,A1549,A1550,A1551,A1552,A1553,A1554,A1555,A1556,A1557,A1558,A1559,A1560,A1561,A1562, \\note fields as indicated
 A1563,A1564,A1565,A1566,A1567,A1568,A1569,A1570,A1571,A1572,A1573,A1574,A1575,A1576,A1577, \\note fields as indicated
 A1578,A1579,A1580,A1581,A1582,A1583,A1584,A1585,A1586,A1587,A1588,A1589,A1590,A1591,A1592, \\note fields as indicated
 A1593,A1594,A1595,A1596,A1597,A1598,A1599,A1600,A1601,A1602,A1603,A1604,A1605,A1606,A1607, \\note fields as indicated
 A1608,A1609,A1610,A1611,A1612,A1613,A1614,A1615,A1616,A1617,A1618,A1619,A1620,A1621,A1622, \\note fields as indicated
 A1623,A1624,A1625,A1626,A1627,A1628,A1629,A1630,A1631,A1632,A1633,A1634,A1635,A1636,A1637, \\note fields as indicated
 A1638,A1639,A1640,A1641,A1642,A1643,A1644,A1645,A1646,A1647,A1648,A1649,A1650,A1651,A1652, \\note fields as indicated
 A1653,A1654,A1655,A1656,A1657,A1658,A1659,A1660,A1661,A1662,A1663,A1664,A1665,A1666,A1667, \\note fields as indicated
 A1668,A1669,A1670,A1671,A1672,A1673,A1674,A1675,A1676,A1677,A1678,A1679,A1680,A1681,A1682, \\note fields as indicated
 A1683,A1684,A1685,A1686,A1687,A1688,A1689,A1690,A1691,A1692,A1693,A1694,A1695,A1696,A1697, \\note fields as indicated
 A1698,A1699,A1700,A1701,A1702,A1703,A1704,A1705,A1706,A1707,A1708,A1709,A1710,A1711,A1712, \\note fields as indicated
 A1713,A1714,A1715,A1716,A1717,A1718,A1719,A1720,A1721,A1722,A1723,A1724,A1725,A1726,A1727, \\note fields as indicated
 A1728,A1729,A1730,A1731,A1732,A1733,A1734,A1735,A1736,A1737,A1738,A1739,A1740,A1741,A1742, \\note fields as indicated
 A1743,A1744,A1745,A1746,A1747,A1748,A1749,A1750,A1751,A1752,A1753,A1754,A1755,A1756,A1757, \\note fields as indicated
 A1758,A1759,A1760,A1761,A1762,A1763,A1764,A1765,A1766,A1767,A1768,A1769,A1770,A1771,A1772, \\note fields as indicated
 A1773,A1774,A1775,A1776,A1777,A1778,A1779,A1780,A1781,A1782,A1783,A1784,A1785,A1786,A1787, \\note fields as indicated
 A1788,A1789,A1790,A1791,A1792,A1793,A1794,A1795,A1796,A1797,A1798,A1799,A1800,A1801,A1802, \\note fields as indicated
 A1803,A1804,A1805,A1806,A1807,A1808,A1809,A1810,A1811,A1812,A1813,A1814,A1815,A1816,A1817, \\note fields as indicated
 A1818,A1819,A1820,A1821,A1822,A1823,A1824,A1825,A1826,A1827,A1828,A1829,A1830,A1831,A1832, \\note fields as indicated
 A1833,A1834,A1835,A1836,A1837,A1838,A1839,A1840,A1841,A1842,A1843,A1844,A1845,A1846,A1847, \\note fields as indicated
 A1848,A1849,A1850,A1851,A1852,A1853,A1854,A1855,A1856,A1857,A1858,A1859,A1860,A1861,A1862, \\note fields as indicated
 A1863,A1864,A1865,A1866,A1867,A1868,A1869,A1870,A1871,A1872,A1873,A1874,A1875,A1876,A1877, \\note fields as indicated
 A1878,A1879,A1880,A1881,A1882,A1883,A1884,A1885,A1886,A1887,A1888,A1889,A1890,A1891,A1892, \\note fields as indicated
 A1893,A1894,A1895,A1896,A1897,A1898,A1899,A1900,A1901,A1902,A1903,A1904,A1905,A1906,A1907, \\note fields as indicated
 A1908,A1909,A1910,A1911,A1912,A1913,A1914,A1915,A1916,A1917,A1918,A1919,A1920,A1921,A1922, \\note fields as indicated
 A1923,A1924,A1925,A1926,A1927,A1928,A1929,A1930,A1931,A1932,A1933,A1934,A1935,A1936,A1937, \\note fields as indicated
 A1938,A1939,A1940,A1941,A1942,A1943,A1944,A1945,A1946,A1947,A1948,A1949,A1950,A1951,A1952, \\note fields as indicated
 A1953,A1954,A1955,A1956,A1957,A1958,A1959,A1960,A1961,A1962,A1963,A1964,A1965,A1966,A1967, \\note fields as indicated
 A1968,A1969,A1970,A1971,A1972,A1973,A1974,A1975,A1976,A1977,A1978,A1979,A1980,A1981,A1982, \\note fields as indicated
 A1983,A1984,A1985,A1986,A1987,A1988,A1989,A1990,A1991,A1992,A1993,A1994,A1995,A1996,A1997, \\note fields as indicated
 A1998,A1999,A2000,A2001,A2002,A2003,A2004,A2005,A2006,A2007,A2008,A2009,A2010,A2011,A2012, \\note fields as indicated
 A2013,A2014,A2015,A2016,A2017,A2018,A2019,A2020,A2021,A2022,A2023,A2024,A2025,A2026,A2027, \\note fields as indicated
 A2028,A2029,A2030,A2031,A2032,A2033,A2034,A2035,A2036,A2037,A2038,A2039,A2040,A2041,A2042, \\note fields as indicated
 A2043,A2044,A2045,A2046,A2047,A2048,A2049,A2050,A2051,A2052,A2053,A2054,A2055,A2056,A2057, \\note fields as indicated
 A2058,A2059,A2060,A2061,A2062,A2063,A2064,A2065,A2066,A2067,A2068,A2069,A2070,A2071,A2072, \\note fields as indicated
 A2073,A2074,A2075,A2076,A2077,A2078,A2079,A2080,A2081,A2082,A2083,A2084,A2085,A2086,A2087, \\note fields as indicated
 A2088,A2089,A2090,A2091,A2092,A2093,A2094,A2095,A2096,A2097,A2098,A2099,A2100,A2101,A2102, \\note fields as indicated
 A2103,A2104,A2105,A2106,A2107,A2108,A2109,A2110,A2111,A2112,A2113,A2114,A2115,A2116,A2117, \\note fields as indicated
 A2118,A2119,A2120,A2121,A2122,A2123,A2124,A2125,A2126,A2127,A2128,A2129,A2130,A2131,A2132, \\note fields as indicated
 A2133,A2134,A2135,A2136,A2137,A2138,A2139,A2140,A2141,A2142,A2143,A2144,A2145,A2146,A2147, \\note fields as indicated
 A2148,A2149,A2150,A2151,A2152,A2153,A2154,A2155,A2156,A2157,A2158,A2159,A2160,A2161,A2162, \\note fields as indicated
 A2163,A2164,A2165,A2166,A2167,A2168,A2169,A2170,A2171,A2172,A2173,A2174,A2175,A2176,A2177, \\note fields as indicated
 A2178,A2179,A2180,A2181,A2182,A2183,A2184,A2185,A2186,A2187,A2188,A2189,A2190,A2191,A2192, \\note fields as indicated
 A2193,A2194,A2195,A2196,A2197,A2198,A2199,A2200,A2201,A2202,A2203,A2204,A2205,A2206,A2207, \\note fields as indicated
 A2208,A2209,A2210,A2211,A2212,A2213,A2214,A2215,A2216,A2217,A2218,A2219,A2220,A2221,A2222, \\note fields as indicated
 A2223,A2224,A2225,A2226,A2227,A2228,A2229,A2230,A2231,A2232,A2233,A2234,A2235,A2236,A2237, \\note fields as indicated
 A2238,A2239,A2240,A2241,A2242,A2243,A2244,A2245,A2246,A2247,A2248,A2249,A2250,A2251,A2252, \\note fields as indicated
 A2253,A2254,A2255,A2256,A2257,A2258,A2259,A2260,A2261,A2262,A2263,A2264,A2265,A2266,A2267, \\note fields as indicated
 A2268,A2269,A2270,A2271,A2272,A2273,A2274,A2275,A2276,A2277,A2278,A2279,A2280,A2281,A2282, \\note fields as indicated
 A2283,A2284,A2285,A2286,A2287,A2288,A2289,A2290,A2291,A2292,A2293,A2294,A2295,A2296,A2297, \\note fields as indicated
 A2298,A2299,A2300,A2301,A2302,A2303,A2304,A2305,A2306,A2307,A2308,A2309,A2310,A2311,A2312, \\note fields as indicated
 A2313,A2314,A2315,A2316,A2317,A2318,A2319,A2320,A2321,A2322,A2323,A2324,A2325,A2326,A2327, \\note fields as indicated
 A2328,A2329,A2330,A2331,A2332,A2333,A2334,A2335,A2336,A2337,A2338,A2339,A2340,A2341,A2342, \\note fields as indicated
 A2343,A2344,A2345,A2346,A2347,A2348,A2349,A2350,A2351,A2352,A2353,A2354,A2355,A2356,A2357, \\note fields as indicated
 A2358,A2359,A2360,A2361,A2362,A2363,A2364,A2365,A2366,A2367,A2368,A2369,A2370,A2371,A2372, \\note fields as indicated
 A2373,A2374,A2375,A2376,A2377,A2378,A2379,A2380,A2381,A2382,A2383,A2384,A2385,A2386,A2387, \\note fields as indicated
 A2388,A2389,A2390,A2391,A2392,A2393,A2394,A2395,A2396,A2397,A2398,A2399,A2400,A2401,A2402, \\note fields as indicated
 A2403,A2404,A2405,A2406,A2407,A2408,A2409,A2410,A2411,A2412,A2413,A2414,A2415,A2416,A2417, \\note fields as indicated
 A2418,A2419,A2420,A2421,A2422,A2423,A2424,A2425,A2426,A2427,A2428,A2429,A2430,A2431,A2432, \\note fields as indicated
 A2433,A2434,A2435,A2436,A2437,A2438,A2439,A2440,A2441,A2442,A2443,A2444,A2445,A2446,A2447, \\note fields as indicated
 A2448,A2449,A2450,A2451,A2452,A2453,A2454,A2455,A2456,A2457,A2458,A2459,A2460,A2461,A2462, \\note fields as indicated
 A2463,A2464,A2465,A2466,A2467,A2468,A2469,A2470,A2471,A2472,A2473,A2474,A2475,A2476,A2477, \\note fields as indicated
 A2478,A2479,A2480,A2481,A2482,A2483,A2484,A2485,A2486,A2487,A2488,A2489,A2490,A2491,A2492, \\note fields as indicated
 A2493,A2494,A2495,A2496,A2497,A2498,A2499,A2500,A2501,A2502,A2503,A2504,A2505,A2506,A2507, \\note fields as indicated
 A2508,A2509,A2510,A2511,A2512,A2513,A2514,A2515,A2516,A2517,A2518,A2519,A2520,A2521,A2522, \\note fields as indicated
 A2523,A2524,A2525,A2526,A2527,A2528,A2529,A2530,A2531,A2532,A2533,A2534,A2535,A2536,A2537, \\note fields as indicated
 A2538,A2539,A2540,A2541,A2542,A2543,A2544,A2545,A2546,A2547,A2548,A2549,A2550,A2551,A2552, \\note fields as indicated
 A2553,A2554,A2555,A2556,A2557,A2558,A2559,A2560,A2561,A2562,A2563,A2564,A2565,A2566,A2567, \\note fields as indicated
 A2568,A2569,A2570,A2571,A2572,A2573,A2574,A2575,A2576,A2577,A2578,A2579,A2580,A2581,A2582, \\note fields as indicated
 A2583,A2584,A2585,A2586,A2587,A2588,A2589,A2590,A2591,A2592,A2593,A2594,A2595,A2596,A2597, \\note fields as indicated
 A2598,A2599,A2600,A2601,A2602,A2603,A2604,A2605,A2606,A2607,A2608,A2609,A2610,A2611,A2612, \\note fields as indicated
 A2613,A2614,A2615,A2616,A2617,A2618,A2619,A2620,A2621,A2622,A2623,A2624,A2625,A2626,A2627, \\note fields as indicated
 A2628,A2629,A2630,A2631,A2632,A2633,A2634,A2635,A2636,A2637,A2638,A2639,A2640,A2641,A2642, \\note fields as indicated
 A2643,A2644,A2645,A2646,A2647,A2648,A2649,A2650,A2651,A2652,A2653,A2654,A2655,A2656,A2657, \\note fields as indicated
 A2658,A2659,A2660,A2661,A2662,A2663,A2664,A2665,A2666,A2667,A2668,A2669,A2670,A2671,A2672, \\note fields as indicated
 A2673,A2674,A2675,A2676,A2677,A2678,A2679,A2680,A2681,A2682,A2683,A2684,A2685,A2686,A2687, \\note fields as indicated
 A2688,A2689,A2690,A2691,A2692,A2693,A2694,A2695,A2696,A2697,A2698,A2699,A2700,A2701,A2702, \\note fields as indicated
 A2703,A2704,A2705,A2706,A2707,A2708,A2709,A2710,A2711,A2712,A2713,A2714,A2715,A2716,A2717, \\note fields as indicated
 A2718,A2719,A2720,A2721,A2722,A2723,A2724,A2725,A2726,A2727,A2728,A2729,A2730,A2731,A2732, \\note fields as indicated
 A2733,A2734,A2735,A2736,A2737,A2738,A2739,A2740,A2741,A2742,A2743,A2744,A2745,A2746,A2747, \\note fields as indicated
 A2748,A2749,A2750,A2751,A2752,A2753,A2754,A2755,A2756,A2757,A2758,A2759,A2760,A2761,A2762, \\note fields as indicated
 A2763,A2764,A2765,A2766,A2767,A2768,A2769,A2770,A2771,A2772,A2773,A2774,A2775,A2776,A2777, \\note fields as indicated
 A2778,A2779,A2780,A2781,A2782,A2783,A2784,A2785,A2786,A2787,A2788,A2789,A2790,A2791,A2792, \\note fields as indicated
 A2793,A2794,A2795,A2796,A2797,A2798,A2799,A2800,A2801,A2802,A2803,A2804,A2805,A2806,A2807, \\note fields as indicated
 A2808,A2809,A2810,A2811,A2812,A2813,A2814,A2815,A2816,A2817,A2818,A2819,A2820,A2821,A2822, \\note fields as indicated
 A2823,A2824,A2825,A2826,A2827,A2828,A2829,A2830,A2831,A2832,A2833,A2834,A2835,A2836,A2837, \\note fields as indicated
 A2838,A2839,A2840,A2841,A2842,A2843,A2844,A2845,A2846,A2847,A2848,A2849,A2850,A2851,A2852, \\note fields as indicated
 A2853,A2854,A2855,A2856,A2857,A2858,A2859,A2860,A2861,A2862,A2863,A2864,A2865,A2866,A2867, \\note fields as indicated
 A2868,A2869,A2870,A2871,A2872,A2873,A2874,A2875,A2876,A2877,A2878,A2879,A2880,A2881,A2882, \\note fields as indicated
 A2883,A2884,A2885,A2886,A2887,A2888,A2889,A2890,A2891,A2892,A2893,A2894,A2895,A2896,A2897, \\note fields as indicated
 A2898,A2899,A2900,A2901,A2902,A2903,A2904,A2905,A2906,A2907,A2908,A2909,A2910,A2911,A2912, \\note fields as indicated
 A2913,A2914,A2915,A2916,A2917,A2918,A2919,A2920,A2921,A2922,A2923,A2924,A2925,A2926,A2927, \\note fields as indicated
 A2928,A2929,A2930,A2931,A2932,A2933,A2934,A2935,A2936,A2937,A2938,A2939,A2940,A2941,A2942, \\note fields as indicated
 A2943,A2944,A2945,A2946,A2947,A2948,A2949,A2950,A2951,A2952,A2953,A2954,A2955,A2956,A2957, \\note fields as indicated
 A2958,A2959,A2960,A2961,A2962,A2963,A2964,A2965,A2966,A2967,A2968,A2969,A2970,A2971,A2972, \\note fields as indicated
 A2973,A2974,A2975,A2976,A2977,A2978,A2979,A2980,A2981,A2982,A2983,A2984,A2985,A2986,A2987, \\note fields as indicated
 A2988,A2989,A2990,A2991,A2992,A2993,A2994,A2995,A2996,A2997,A2998,A2999,A3000,A3001,A3002, \\note fields as indicated
 A3003,A3004,A3005,A3006,A3007,A3008,A3009,A3010,A3011,A3012,A3013,A3014,A3015,A3016,A3017, \\note fields as indicated
 A3018,A3019,A3020,A3021,A3022,A3023,A3024,A3025,A3026,A3027,A3028,A3029,A3030,A3031,A3032, \\note fields as indicated
 A3033,A3034,A3035,A3036,A3037,A3038,A3039,A3040,A3041,A3042,A3043,A3044,A3045,A3046,A3047, \\note fields as indicated
 A3048,A3049,A3050,A3051,A3052,A3053,A3054,A3055,A3056,A3057,A3058,A3059,A3060,A3061,A3062, \\note fields as indicated
 A3063,A3064,A3065,A3066,A3067,A3068,A3069,A3070,A3071,A3072,A3073,A3074,A3075,A3076,A3077, \\note fields as indicated
 A3078,A3079,A3080,A3081,A3082,A3083,A3084,A3085,A3086,A3087,A3088,A3089,A3090,A3091,A3092, \\note fields as indicated
 A3093,A3094,A3095,A3096,A3097,A3098,A3099,A3100,A3101,A3102,A3103,A3104,A3105,A3106,A3107, \\note fields as indicated
 A3108,A3109,A3110,A3111,A3112,A3113,A3114,A3115,A3116,A3117,A3118,A3119,A3120,A3121,A3122, \\note fields as indicated
 A3123,A3124,A3125,A3126,A3127,A3128,A3129,A3130,A3131,A3132,A3133,A3134,A3135,A3136,A3137, \\note fields as indicated
 A3138,A3139,A3140,A3141,A3142,A3143,A3144,A3145,A3146,A3147,A3148,A3149,A3150,A3151,A3152, \\note fields as indicated
 A3153,A3154,A3155,A3156,A3157,A3158,A3159,A3160,A3161,A3162,A3163,A3164,A3165,A3166,A3167, \\note fields as indicated
 A3168,A3169,A3170,A3171,A3172,A3173,A3174,A3175,A3176,A3177,A3178,A3179,A3180,A3181,A3182, \\note fields as indicated
 A3183,A3184,A3185,A3186,A3187,A3188,A3189,A3190,A3191,A3192,A3193,A3194,A3195,A3196,A3197, \\note fields as indicated
 A3198,A3199,A3200,A3201,A3202,A3203,A3204,A3205,A3206,A3207,A3208,A3209,A3210,A3211,A3212, \\note fields as indicated
 A3213,A3214,A3215,A3216,A3217,A3218,A3219,A3220,A3221,A3222,A3223,A3224,A3225,A3226,A3227, \\note fields as indicated
 A3228,A3229,A3230,A3231,A3232,A3233,A3234,A3235,A3236,A3237,A3238,A3239,A3240,A3241,A3242, \\note fields as indicated
 A3243,A3244,A3245,A3246,A3247,A3248,A3249,A3250,A3251,A3252,A3253,A3254,A3255,A3256,A3257, \\note fields as indicated
 A3258,A3259,A3260,A3261,A3262,A3263,A3264,A3265,A3266,A3267,A3268,A3269,A3270,A3271,A3272, \\note fields as indicated
 A3273,A3274,A3275,A3276,A3277,A3278,A3279,A3280,A3281,A3282,A3283,A3284,A3285,A3286,A3287, \\note fields as indicated
 A3288,A3289,A3290,A3291,A3292,A3293,A3294,A3295,A3296,A3297,A3298,A3299,A3300,A3301,A3302, \\note fields as indicated
 A3303,A3304,A3305,A3306,A3307,A3308,A3309,A3310,A3311,A3312,A3313,A3314,A3315,A3316,A3317, \\note fields as indicated
 A3318,A3319,A3320,A3321,A3322,A3323,A3324,A3325,A3326,A3327,A3328,A3329,A3330,A3331,A3332, \\note fields as indicated
 A3333,A3334,A3335,A3336,A3337,A3338,A3339,A3340,A3341,A3342,A3343,A3344,A3345,A3346,A3347, \\note fields as indicated
 A3348,A3349,A3350,A3351,A3352,A3353,A3354,A3355,A3356,A3357,A3358,A3359,A3360,A3361,A3362, \\note fields as indicated
 A3363,A3364,A3365,A3366,A3367,A3368,A3369,A3370,A3371,A3372,A3373,A3374,A3375,A3376,A3377, \\note fields as indicated
 A3378,A3379,A3380,A3381,A3382,A3383,A3384,A3385,A3386,A3387,A3388,A3389,A3390,A3391,A3392, \\note fields as indicated
 A3393,A3394,A3395,A3396,A3397,A3398,A3399,A3400,A3401,A3402,A3403,A3404,A3405,A3406,A3407, \\note fields as indicated
 A3408,A3409,A3410,A3411,A3412,A3413,A3414,A3415,A3416,A3417,A3418,A3419,A3420,A3421,A3422, \\note fields as indicated
 A3423,A3424,A3425,A3426,A3427,A3428,A3429,A3430,A3431,A3432,A3433,A3434,A3435,A3436,A3437, \\note fields as indicated
 A3438,A3439,A3440,A3441,A3442,A3443,A3444,A3445,A3446,A3447,A3448,A3449,A3450,A3451,A3452, \\note fields as indicated
 A3453,A3454,A3455,A3456,A3457,A3458,A3459,A3460,A3461,A3462,A3463,A3464,A3465,A3466,A3467, \\note fields as indicated
 A3468,A3469,A3470,A3471,A3472,A3473,A3474,A3475,A3476,A3477,A3478,A3479,A3480,A3481,A3482, \\note fields as indicated
 A3483,A3484,A3485,A3486,A3487,A3488,A3489,A3490,A3491,A3492,A3493,A3494,A3495,A3496,A3497, \\note fields as indicated
 A3498,A3499,A3500,A3501,A3502,A3503,A3504,A3505,A3506,A3507,A3508,A3509,A3510,A3511,A3512, \\note fields as indicated
 A3513,A3514,A3515,A3516,A3517,A3518,A3519,A3520,A3521,A3522,A3523,A3524,A3525,A3526,A3527, \\note fields as indicated
 A3528,A3529,A3530,A3531,A3532,A3533,A3534,A3535,A3536,A3537,A3538,A3539,A3540,A3541,A3542, \\note fields as indicated
 A3543,A3544,A3545,A3546,A3547,A3548,A3549,A3550,A3551,A3552,A3553,A3554,A3555,A3556,A3557, \\note fields as indicated
 A3558,A3559,A3560,A3561,A3562,A3563,A3564,A3565,A3566,A3567,A3568,A3569,A3570,A3571,A3572, \\note fields as indicated
 A3573,A3574,A3575,A3576,A3577,A3578,A3579,A3580,A3581,A3582,A3583,A3584,A3585,A3586,A3587, \\note fields as indicated
 A3588,A3589,A3590,A3591,A3592,A3593,A3594,A3595,A3596,A3597,A3598,A3599,A3600,A3601,A3602, \\note fields as indicated
 A3603,A3604,A3605,A3606,A3607,A3608,A3609,A3610,A3611,A3612,A3613,A3614,A3615,A3616,A3617, \\note fields as indicated
 A3618,A3619,A3620,A3621,A3622,A3623,A3624,A3625,A3626,A3627,A3628,A3629,A3630,A3631,A3632, \\note fields as indicated
 A3633,A3634,A3635,A3636,A3637,A3638,A3639,A3640,A3641,A3642,A3643,A3644,A3645,A3646,A3647, \\note fields as indicated
 A3648,A3649,A3650,A3651,A3652,A3653,A3654,A3655,A3656,A3657,A3658,A3659,A3660,A3661,A3662, \\note fields as indicated
 A3663,A3664,A3665,A3666,A3667,A3668,A3669,A3670,A3671,A3672,A3673,A3674,A3675,A3676,A3677, \\note fields as indicated
 A3678,A3679,A3680,A3681,A3682,A3683,A3684,A3685,A3686,A3687,A3688,A3689,A3690,A3691,A3692, \\note fields as indicated
 A3693,A3694,A3695,A3696,A3697,A3698,A3699,A3700,A3701,A3702,A3703,A3704,A3705,A3706,A3707, \\note fields as indicated
 A3708,A3709,A3710,A3711,A3712,A3713,A3714,A3715,A3716,A3717,A3718,A3719,A3720,A3721,A3722, \\note fields as indicated
 A3723,A3724,A3725,A3726,A3727,A3728,A3729,A3730,A3731,A3732,A3733,A3734,A3735,A3736,A3737, \\note fields as indicated
 A3738,A3739,A3740,A3741,A3742,A3743,A3744,A3745,A3746,A3747,A3748,A3749,A3750,A3751,A3752, \\note fields as indicated
 A3753,A3754,A3755,A3756,A3757,A3758,A3759,A3760,A3761,A3762,A3763,A3764,A3765,A3766,A3767, \\note fields as indicated
 A3768,A3769,A3770,A3771,A3772,A3773,A3774,A3775,A3776,A3777,A3778,A3779,A3780,A3781,A3782, \\note fields as indicated
 A3783,A3784,A3785,A3786,A3787,A3788,A3789,A3790,A3791,A3792,A3793,A3794,A3795,A3796,A3797, \\note fields as indicated
 A3798,A3799,A3800,A3801,A3802,A3803,A3804,A3805,A3806,A3807,A3808,A3809,A3810,A3811,A3812, \\note fields as indicated
 A3813,A3814,A3815,A3816,A3817,A3818,A3819,A3820,A3821,A3822,A3823,A3824,A3825,A3826,A3827, \\note fields as indicated
 A3828,A3829,A3830,A3831,A3832,A3833,A3834,A3835,A3836,A3837,A3838,A3839,A3840,A3841,A3842, \\note fields as indicated
 A3843,A3844,A3845,A3846,A3847,A3848,A3849,A3850,A3851,A3852,A3853,A3854,A3855,A3856,A3857, \\note fields as indicated
 A3858,A3859,A3860,A3861,A3862,A3863,A3864,A3865,A3866,A3867,A3868,A3869,A3870,A3871,A3872, \\note fields as indicated
 A3873,A3874,A3875,A3876,A3877,A3878,A3879,A3880,A3881,A3882,A3883,A3884,A3885,A3886,A3887, \\note fields as indicated
 A3888,A3889,A3890,A3891,A3892,A3893,A3894,A3895,A3896,A3897,A3898,A3899,A3900,A3901,A3902, \\note fields as indicated
 A3903,A3904,A3905,A3906,A3907,A3908,A3909,A3910,A3911,A3912,A3913,A3914,A3915,A3916,A3917, \\note fields as indicated
 A3918,A3919,A3920,A3921,A3922,A3923,A3924,A3925,A3926,A3927,A3928,A3929,A3930,A3931,A3932, \\note fields as indicated
 A3933,A3934,A3935,A3936,A3937,A3938,A3939,A3940,A3941,A3942,A3943,A3944,A3945,A3946,A3947, \\note fields as indicated
 A3948,A3949,A3950,A3951,A3952,A3953,A3954,A3955,A3956,A3957,A3958,A3959,A3960,A3961,A3962, \\note fields as indicated
 A3963,A3964,A3965,A3966,A3967,A3968,A3969,A3970,A3971,A3972,A3973,A3974,A3975,A3976,A3977, \\note fields as indicated
 A3978,A3979,A3980,A3981,A3982,A3983,A3984,A3985,A3986,A3987,A3988,A3989,A3990,A3991,A3992, \\note fields as indicated
 A3993,A3994,A3995,A3996,A3997,A3998,A3999,A4000,A4001,A4002,A4003,A4004,A4005,A4006,A4007, \\note fields as indicated
 A4008,A4009,A4010,A4011,A4012,A4013,A4014,A4015,A4016,A4017,A4018,A4019,A4020,A4021,A4022, \\note fields as indicated
 A4023,A4024,A4025,A4026,A4027,A4028,A4029,A4030,A4031,A4032,A4033,A4034,A4035,A4036,A4037, \\note fields as indicated
 A4038,A4039,A4040,A4041,A4042,A4043,A4044,A4045,A4046,A4047,A4048,A4049,A4050,A4051,A4052, \\note fields as indicated
 A4053,A4054,A4055,A4056,A4057,A4058,A4059,A4060,A4061,A4062,A4063,A4064,A4065,A4066,A4067, \\note fields as indicated
 A4068,A4069,A4070,A4071,A4072,A4073,A4074,A4075,A4076,A4077,A4078,A4079,A4080,A4081,A4082, \\note fields as indicated
 A4083,A4084,A4085,A4086,A4087,A4088,A4089,A4090,A4091,A4092,A4093,A4094,A4095,A4096,A4097, \\note fields as indicated
 A4098,A4099,A4100,A4101,A4102,A4103,A4104,A4105,A4106,A4107,A4108,A4109,A4110,A4111,A4112, \\note fields as indicated
 A4113,A4114,A4115,A4116,A4117,A4118,A4119,A4120,A4121,A4122,A4123,A4124,A4125,A4126,A4127, \\note fields as indicated
 A4128,A4129,A4130,A4131,A4132,A4133,A4134,A4135,A4136,A4137,A4138,A4139,A4140,A4141,A4142, \\note fields as indicated
 A4143,A4144,A4145,A4146,A4147,A4148,A4149,A4150,A4151,A4152,A4153,A4154,A4155,A4156,A4157, \\note fields as indicated
 A4158,A4159,A4160,A4161,A4162,A4163,A4164,A4165,A4166,A4167,A4168,A4169,A4170,A4171,A4172, \\note fields as indicated
 A4173,A4174,A4175,A4176,A4177,A4178,A4179,A4180,A4181,A4182,A4183,A4184,A4185,A4186,A4187, \\note fields as indicated
 A4188,A4189,A4190,A4191,A4192,A4193,A4194,A4195,A4196,A4197,A4198,A4199,A4200,A4201,A4202, \\note fields as indicated
 A4203,A4204,A4205,A4206,A4207,A4208,A4209,A4210,A4211,A4212,A4213,A4214,A4215,A4216,A4217, \\note fields as indicated
 A4218,A4219,A4220,A4221,A4222,A4223,A4224,A4225,A4226,A4227,A4228,A4229,A4230,A4231,A4232, \\note fields as indicated
 A4233,A4234,A4235,A4236,A4237,A4238,A4239,A4240,A4241,A4242,A4243,A4244,A4245,A4246,A4247, \\note fields as indicated
 A4248,A4249,A4250,A4251,A4252,A4253,A4254,A4255,A4256,A4257,A4258,A4259,A4260,A4261,A4262, \\note fields as indicated
 A4263,A4264,A4265,A4266,A4267,A4268,A4269,A4270,A4271,A4272,A4273,A4274,A4275,A4276,A4277, \\note fields as indicated
 A4278,A4279,A4280,A4281,A4282,A4283,A4284,A4285,A4286,A4287,A4288,A4289,A4290,A4291,A4292, \\note fields as indicated
 A4293,A4294,A4295,A4296,A4297,A4298,A4299,A4300,A4301,A4302,A4303,A4304,A4305,A4306,A4307, \\note fields as indicated
 A4308,A4309,A4310,A4311,A4312,A4313,A4314,A4315,A4316,A4317,A4318,A4319,A4320,A4321,A4322, \\note fields as indicated
 A4323,A4324,A4325,A4326,A4327,A4328,A4329,A4330,A4331,A4332,A4333,A4334,A4335,A4336,A4337, \\note fields as indicated
 A4338,A4339,A4340,A4341,A4342,A4343,A4344,A4345,A4346,A4347,A4348,A4349,A4350,A4351,A4352, \\note fields as indicated
 A4353,A4354,A4355,A4356,A4357,A4358,A4359,A4360,A4361,A4362,A4363,A4364,A4365,A4366,A4367, \\note fields as indicated
 A4368,A4369,A4370,A4371,A4372,A4373,A4374,A4375,A4376,A4377,A4378,A4379,A4380,A4381,A4382, \\note fields as indicated
 A4383,A4384,A4385,A4386,A4387,A4388,A4389,A4390,A4391,A4392,A4393,A4394,A4395,A4396,A4397, \\note fields as indicated
 A4398,A4399,A4400,A4401,A4402,A4403,A4404,A4405,A4406,A4407,A4408,A4409,A4410,A4411,A4412, \\note fields as indicated
 A4413,A4414,A4415,A4416,A4417,A4418,A4419,A4420,A4421,A4422,A4423,A4424,A4425,A4426,A4427, \\note fields as indicated
 A4428,A4429,A4430,A4431,A4432,A4433,A4434,A4435,A4436,A4437,A4438,A4439,A4440,A4441,A4442, \\note fields as indicated
 A4443,A4444,A4445,A4446,A4447,A4448,A4449,A4450,A4451,A4452,A4453,A4454,A4455,A4456,A4457, \\note fields as indicated
 A4458,A4459,A4460,A4461,A4462,A4463,A4464,A4465,A4466,A4467,A4468,A4469,A4470,A4471,A4472, \\note fields as indicated
 A4473,A4474,A4475,A4476,A4477,A4478,A4479,A4480,A4481,A4482,A4483,A4484,A4485,A4486,A4487, \\note fields as indicated
 A4488,A4489,A4490,A4491,A4492,A4493,A4494,A4495,A4496,A4497,A4498,A4499,A4500; \\note fields as indicated

Schedule:Constant,
   \\memo Constant hourly value for entire year.
   \\format singleLine
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ScheduleNames
  A2 , \\field Schedule Type Limits Name
       \\type object-list
       \\object-list ScheduleTypeLimitsNames
  N1 ; \\field Hourly Value
       \\type real
       \\default 0

Schedule:File,
 \\min-fields 5
       \\memo A Schedule:File points to a text computer file that has 8760-8784 hours of data.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ScheduleNames
  A2 , \\field Schedule Type Limits Name
       \\type object-list
       \\object-list ScheduleTypeLimitsNames
  A3 , \\field File Name
       \\required-field
       \\retaincase
  N1 , \\field Column Number
       \\required-field
       \\type integer
       \\minimum 1
  N2 , \\field Rows to Skip at Top
       \\required-field
       \\type integer
       \\minimum 0
  N3 , \\field Number of Hours of Data
       \\note 8760 hours does not account for leap years, 8784 does.
       \\note should be either 8760 or 8784
       \\default 8760
       \\minimum 8760
       \\maximum 8784
  A4 , \\field Column Separator
       \\type choice
       \\key Comma
       \\key Tab
       \\key Fixed
       \\key Semicolon
       \\default Comma
  A5 , \\field Interpolate to Timestep
       \\note when the interval does not match the user specified timestep a "Yes" choice will average between the intervals request (to
       \\note timestep resolution.  a "No" choice will use the interval value at the simulation timestep without regard to if it matches
       \\note the boundary or not.
       \\type choice
       \\key Yes
       \\key No
       \\default No
  N4 ; \\field Minutes per Item
       \\note Must be evenly divisible into 60
       \\type integer
       \\minimum 1
       \\maximum 60

\\group Surface Construction Elements

Material,
    \\memo Regular materials described with full set of thermal properties
    \\min-fields 6
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference MaterialName
  A2 , \\field Roughness
       \\required-field
       \\type choice
       \\key VeryRough
       \\key Rough
       \\key MediumRough
       \\key MediumSmooth
       \\key Smooth
       \\key VerySmooth
  N1 , \\field Thickness
       \\required-field
       \\units m
       \\type real
       \\minimum> 0
       \\maximum 3.0
       \\ip-units in
  N2 , \\field Conductivity
       \\required-field
       \\units W/m-K
       \\type real
       \\minimum> 0
  N3 , \\field Density
       \\required-field
       \\units kg/m3
       \\type real
       \\minimum> 0
  N4 , \\field Specific Heat
       \\required-field
       \\units J/kg-K
       \\type real
       \\minimum 100
  N5 , \\field Thermal Absorptance
       \\type real
       \\minimum> 0
       \\default .9
       \\maximum 0.99999
  N6 , \\field Solar Absorptance
       \\type real
       \\default .7
       \\minimum 0
       \\maximum 1
  N7 ; \\field Visible Absorptance
       \\type real
       \\minimum 0
       \\default .7
       \\maximum 1

Material:NoMass,
    \\memo Regular materials properties described whose principal description is R (Thermal Resistance)
     \\min-fields 3
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference MaterialName
  A2 , \\field Roughness
       \\required-field
       \\type choice
       \\key VeryRough
       \\key Rough
       \\key MediumRough
       \\key MediumSmooth
       \\key Smooth
       \\key VerySmooth
  N1 , \\field Thermal Resistance
       \\required-field
       \\units m2-K/W
       \\type real
       \\minimum .001
  N2 , \\field Thermal Absorptance
       \\type real
       \\minimum> 0
       \\default .9
       \\maximum 0.99999
  N3 , \\field Solar Absorptance
       \\type real
       \\minimum 0
       \\default .7
       \\maximum 1
  N4 ; \\field Visible Absorptance
       \\type real
       \\minimum 0
       \\default .7
       \\maximum 1

Material:InfraredTransparent,
       \\memo Special infrared transparent material.  Similar to a Material:Nomass with low thermal resistance.
       \\memo  High absorptance in both wavelengths.
       \\memo  Area will be doubled internally to make internal radiant exchange accurate.
       \\memo  Should be only material in single layer surface construction.
       \\memo  All thermal properties are set internally. User needs only to supply name.
       \\memo Cannot be used with ConductionFiniteDifference solution algorithms
       \\min-fields 1
  A1 ; \\field Name
       \\required-field
       \\type alpha
       \\reference MaterialName

Material:AirGap,
       \\min-fields 2
       \\memo Air Space in Opaque Construction
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference MaterialName
  N1 ; \\field Thermal Resistance
       \\required-field
       \\units m2-K/W
       \\type real
       \\minimum> 0

Material:RoofVegetation,
  \\memo EcoRoof model, plant layer plus soil layer
  \\memo Implemented by Portland State University
  \\memo (Sailor et al., January, 2007)
  \\memo only one material must be referenced per simulation though the same EcoRoof material could be
  \\memo used in multiple constructions. New moisture redistribution scheme (2010) requires higher
  \\memo number of timesteps per hour (minimum 12 recommended).
  \\min-fields 18
  A1 ,\\field Name
      \\required-field
      \\type alpha
      \\reference MaterialName
  N1 ,\\field Height of Plants
      \\type real
      \\note The ecoroof module is designed for short plants and shrubs.
      \\minimum> 0.005
      \\maximum  1.0
      \\units m
      \\default .2
  N2 ,\\field Leaf Area Index
      \\required-field
      \\units dimensionless
      \\note Entire surface is assumed covered, so decrease LAI accordingly.
      \\minimum> 0.001
      \\maximum 5.0
      \\default 1.0
      \\type real
  N3 ,\\field Leaf Reflectivity
      \\required-field
      \\type real
      \\units dimensionless
      \\note Leaf reflectivity (albedo) is typically 0.18-0.25
      \\maximum 0.5
      \\minimum 0.05
      \\default 0.22
  N4 ,\\field Leaf Emissivity
      \\required-field
      \\type real
      \\minimum 0.8
      \\maximum 1.0
      \\default 0.95
  N5 ,\\field Minimum Stomatal Resistance
      \\units s/m
      \\default 180.0
      \\note This depends upon plant type
      \\minimum 50.0
      \\maximum 300.
      \\type real
  A2 ,\\field Soil Layer Name
      \\type alpha
      \\default Green Roof Soil
  A3 ,\\field Roughness
      \\required-field
      \\type choice
      \\key VeryRough
      \\key MediumRough
      \\key Rough
      \\key Smooth
      \\key MediumSmooth
      \\key VerySmooth
      \\default MediumRough
  N6 ,\\field Thickness
      \\note thickness of the soil layer of the EcoRoof
      \\required-field
      \\units m
      \\type real
      \\note Soil depths of 0.15m (6in) and 0.30m (12in) are common.
      \\default 0.1
      \\minimum> 0.05
      \\maximum 0.7
      \\ip-units in
  N7 ,\\field Conductivity of Dry Soil
      \\required-field
      \\units W/m-K
      \\type real
      \\note Thermal conductivity of dry soil.
      \\note Typical ecoroof soils range from 0.3 to 0.5
      \\default 0.35
      \\minimum  0.2
      \\maximum 1.5
  N8 ,\\field Density of Dry Soil
      \\required-field
      \\units kg/m3
      \\note Density of dry soil (the code modifies this as the soil becomes moist)
      \\note Typical ecoroof soils range from 400 to 1000 (dry to wet)
      \\type real
      \\minimum 300
      \\maximum 2000
      \\default 1100
  N9 ,\\field Specific Heat of Dry Soil
      \\required-field
      \\units J/kg-K
      \\type real
      \\note Specific heat of dry soil
      \\minimum> 500
      \\maximum 2000
      \\default 1200
  N10,\\field Thermal Absorptance
      \\type real
      \\note Soil emissivity is typically in range of 0.90 to 0.98
      \\minimum> 0.8
      \\default .9
      \\maximum 1.0
  N11,\\field Solar Absorptance
      \\type real
      \\note Solar absorptance of dry soil (1-albedo) is typically 0.60 to 0.85
      \\note corresponding to a dry albedo of 0.15 to 0.40
      \\default .70
      \\minimum 0.40
      \\maximum 0.9
  N12,\\field Visible Absorptance
      \\type real
      \\minimum> 0.5
      \\default .75
      \\maximum 1.0
  N13,\\field Saturation Volumetric Moisture Content of the Soil Layer
      \\type real
      \\note Maximum moisture content is typically less than 0.5
      \\minimum> 0.1
      \\maximum 0.5
      \\default 0.3
  N14,\\field Residual Volumetric Moisture Content of the Soil Layer
      \\type real
      \\minimum  0.01
      \\maximum  0.1
      \\default 0.01
  N15,\\field Initial Volumetric Moisture Content of the Soil Layer
      \\type real
      \\minimum> 0.05
      \\maximum  0.5
      \\default 0.1
  A4; \\field Moisture Diffusion Calculation Method
      \\note Advanced calculation requires increased number of timesteps (recommended >20).
      \\type choice
      \\key Simple
      \\key Advanced
      \\default Advanced

WindowMaterial:SimpleGlazingSystem,
       \\min-fields 3
       \\memo Alternate method of describing windows
       \\memo This window material object is used to define an entire glazing system
       \\memo using simple performance parameters.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference MaterialName
       \\reference GlazingMaterialName
  N1 , \\field U-Factor
       \\required-field
       \\note Enter U-Factor including film coefficients
       \\note Note that the effective upper limit for U-factor is 5.8 W/m2-K
       \\units W/m2-K
       \\minimum> 0
       \\maximum  7
  N2 , \\field Solar Heat Gain Coefficient
       \\required-field
       \\note SHGC at Normal Incidence
       \\minimum> 0
       \\maximum< 1
  N3 ; \\field Visible Transmittance
       \\note VT at Normal Incidence
       \\note optional
       \\minimum> 0
       \\maximum< 1

WindowMaterial:Glazing,
    \\min-fields 14
    \\memo Glass material properties for Windows or Glass Doors
    \\memo Transmittance/Reflectance input method.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference MaterialName
       \\reference GlazingMaterialName
  A2 , \\field Optical Data Type
       \\required-field
       \\type choice
       \\key SpectralAverage
       \\key Spectral
       \\key BSDF
  A3 , \\field Window Glass Spectral Data Set Name
       \\note Used only when Optical Data Type = Spectral
       \\object-list SpectralDataSets
  N1 , \\field Thickness
       \\required-field
       \\units m
       \\type real
       \\minimum> 0.0
       \\ip-units in
  N2 , \\field Solar Transmittance at Normal Incidence
       \\note Used only when Optical Data Type = SpectralAverage
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  N3 , \\field Front Side Solar Reflectance at Normal Incidence
       \\note Used only when Optical Data Type = SpectralAverage
       \\note Front Side is side closest to outdoor air
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  N4 , \\field Back Side Solar Reflectance at Normal Incidence
       \\note Used only when Optical Data Type = SpectralAverage
       \\note Back Side is side closest to zone air
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  N5 , \\field Visible Transmittance at Normal Incidence
       \\note Used only when Optical Data Type = SpectralAverage
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  N6 , \\field Front Side Visible Reflectance at Normal Incidence
       \\note Used only when Optical Data Type = SpectralAverage
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  N7 , \\field Back Side Visible Reflectance at Normal Incidence
       \\note Used only when Optical Data Type = SpectralAverage
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  N8 , \\field Infrared Transmittance at Normal Incidence
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  N9 , \\field Front Side Infrared Hemispherical Emissivity
       \\type real
       \\minimum> 0.0
       \\maximum< 1.0
       \\default 0.84
  N10, \\field Back Side Infrared Hemispherical Emissivity
       \\type real
       \\minimum> 0.0
       \\maximum< 1.0
       \\default 0.84
  N11, \\field Conductivity
       \\units W/m-K
       \\type real
       \\minimum> 0.0
       \\default 0.9
  N12, \\field Dirt Correction Factor for Solar and Visible Transmittance
       \\type real
       \\minimum> 0.0
       \\maximum 1.0
       \\default 1.0
  A4,  \\field Solar Diffusing
       \\type choice
       \\key No
       \\key Yes
       \\default No
  N13, \\field Young's modulus
       \\note coefficient used for deflection calculations. Used only with complex
       \\note fenestration when deflection model is set to TemperatureAndPressureInput
       \\units Pa
       \\type real
       \\minimum> 0.0
       \\default 7.2e10
  N14; \\field Poisson's ratio
       \\note coefficient used for deflection calculations. Used only with complex
       \\note fenestration when deflection model is set to TemperatureAndPressureInput
       \\type real
       \\minimum > 0.0
       \\maximum < 1.0
       \\default 0.22

WindowMaterial:GlazingGroup:Thermochromic,
    \\min-fields 3
    \\extensible:2 - repeat last two fields remembering to remove ; from "inner" fields.
    \\memo thermochromic glass at different temperatures
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference MaterialName
       \\reference GlazingMaterialName
  N1 , \\field Optical Data Temperature 1
       \\begin-extensible
       \\required-field
       \\units C
       \\ip-units F
       \\type real
  A2 , \\field Window Material Glazing Name 1
       \\required-field
       \\type object-list
       \\object-list GlazingMaterialName
  N2 , \\field Optical Data Temperature 2
       \\units C
       \\ip-units F
       \\type real
  A3 , \\field Window Material Glazing Name 2
       \\type object-list
       \\object-list GlazingMaterialName
  N3 , \\field Optical Data Temperature 3
       \\units C
       \\ip-units F
       \\type real
  A4 , \\field Window Material Glazing Name 3
       \\type object-list
       \\object-list GlazingMaterialName
  N4 , \\field Optical Data Temperature 4
       \\units C
       \\ip-units F
       \\type real
  A5 , \\field Window Material Glazing Name 4
       \\type object-list
       \\object-list GlazingMaterialName
  N5 , \\field Optical Data Temperature 5
       \\units C
       \\ip-units F
       \\type real
  A6 , \\field Window Material Glazing Name 5
       \\type object-list
       \\object-list GlazingMaterialName
  N6 , \\field Optical Data Temperature 6
       \\units C
       \\ip-units F
       \\type real
  A7 , \\field Window Material Glazing Name 6
       \\type object-list
       \\object-list GlazingMaterialName
  N7 , \\field Optical Data Temperature 7
       \\units C
       \\ip-units F
       \\type real
  A8 , \\field Window Material Glazing Name 7
       \\type object-list
       \\object-list GlazingMaterialName
  N8 , \\field Optical Data Temperature 8
       \\units C
       \\ip-units F
       \\type real
  A9 , \\field Window Material Glazing Name 8
       \\type object-list
       \\object-list GlazingMaterialName
  N9 , \\field Optical Data Temperature 9
       \\units C
       \\ip-units F
       \\type real
  A10, \\field Window Material Glazing Name 9
       \\type object-list
       \\object-list GlazingMaterialName
  N10, \\field Optical Data Temperature 10
       \\units C
       \\ip-units F
       \\type real
  A11, \\field Window Material Glazing Name 10
       \\type object-list
       \\object-list GlazingMaterialName
  N11, \\field Optical Data Temperature 11
       \\units C
       \\ip-units F
       \\type real
  A12, \\field Window Material Glazing Name 11
       \\type object-list
       \\object-list GlazingMaterialName
  N12, \\field Optical Data Temperature 12
       \\units C
       \\ip-units F
       \\type real
  A13, \\field Window Material Glazing Name 12
       \\type object-list
       \\object-list GlazingMaterialName
  N13, \\field Optical Data Temperature 13
       \\units C
       \\ip-units F
       \\type real
  A14, \\field Window Material Glazing Name 13
       \\type object-list
       \\object-list GlazingMaterialName
  N14, \\field Optical Data Temperature 14
       \\units C
       \\ip-units F
       \\type real
  A15, \\field Window Material Glazing Name 14
       \\type object-list
       \\object-list GlazingMaterialName
  N15, \\field Optical Data Temperature 15
       \\units C
       \\ip-units F
       \\type real
  A16, \\field Window Material Glazing Name 15
       \\type object-list
       \\object-list GlazingMaterialName
  N16, \\field Optical Data Temperature 16
       \\units C
       \\ip-units F
       \\type real
  A17, \\field Window Material Glazing Name 16
       \\type object-list
       \\object-list GlazingMaterialName
  N17, \\field Optical Data Temperature 17
       \\units C
       \\ip-units F
       \\type real
  A18, \\field Window Material Glazing Name 17
       \\type object-list
       \\object-list GlazingMaterialName
  N18, \\field Optical Data Temperature 18
       \\units C
       \\ip-units F
       \\type real
  A19, \\field Window Material Glazing Name 18
       \\type object-list
       \\object-list GlazingMaterialName
  N19, \\field Optical Data Temperature 19
       \\units C
       \\ip-units F
       \\type real
  A20, \\field Window Material Glazing Name 19
       \\type object-list
       \\object-list GlazingMaterialName
  N20, \\field Optical Data Temperature 20
       \\units C
       \\ip-units F
       \\type real
  A21, \\field Window Material Glazing Name 20
       \\type object-list
       \\object-list GlazingMaterialName
  N21, \\field Optical Data Temperature 21
       \\units C
       \\ip-units F
       \\type real
  A22, \\field Window Material Glazing Name 21
       \\type object-list
       \\object-list GlazingMaterialName
  N22, \\field Optical Data Temperature 22
       \\units C
       \\ip-units F
       \\type real
  A23, \\field Window Material Glazing Name 22
       \\type object-list
       \\object-list GlazingMaterialName
  N23, \\field Optical Data Temperature 23
       \\units C
       \\ip-units F
       \\type real
  A24, \\field Window Material Glazing Name 23
       \\type object-list
       \\object-list GlazingMaterialName
  N24, \\field Optical Data Temperature 24
       \\units C
       \\ip-units F
       \\type real
  A25, \\field Window Material Glazing Name 24
       \\type object-list
       \\object-list GlazingMaterialName
  N25, \\field Optical Data Temperature 25
       \\units C
       \\ip-units F
       \\type real
  A26, \\field Window Material Glazing Name 25
       \\type object-list
       \\object-list GlazingMaterialName
  N26, \\field Optical Data Temperature 26
       \\units C
       \\ip-units F
       \\type real
  A27, \\field Window Material Glazing Name 26
       \\type object-list
       \\object-list GlazingMaterialName
  N27, \\field Optical Data Temperature 27
       \\units C
       \\ip-units F
       \\type real
  A28, \\field Window Material Glazing Name 27
       \\type object-list
       \\object-list GlazingMaterialName
  N28, \\field Optical Data Temperature 28
       \\units C
       \\ip-units F
       \\type real
  A29, \\field Window Material Glazing Name 28
       \\type object-list
       \\object-list GlazingMaterialName
  N29, \\field Optical Data Temperature 29
       \\units C
       \\ip-units F
       \\type real
  A30, \\field Window Material Glazing Name 29
       \\type object-list
       \\object-list GlazingMaterialName
  N30, \\field Optical Data Temperature 30
       \\units C
       \\ip-units F
       \\type real
  A31, \\field Window Material Glazing Name 30
       \\type object-list
       \\object-list GlazingMaterialName
  N31, \\field Optical Data Temperature 31
       \\units C
       \\ip-units F
       \\type real
  A32, \\field Window Material Glazing Name 31
       \\type object-list
       \\object-list GlazingMaterialName
  N32, \\field Optical Data Temperature 32
       \\units C
       \\ip-units F
       \\type real
  A33, \\field Window Material Glazing Name 32
       \\type object-list
       \\object-list GlazingMaterialName
  N33, \\field Optical Data Temperature 33
       \\units C
       \\ip-units F
       \\type real
  A34, \\field Window Material Glazing Name 33
       \\type object-list
       \\object-list GlazingMaterialName
  N34, \\field Optical Data Temperature 34
       \\units C
       \\ip-units F
       \\type real
  A35, \\field Window Material Glazing Name 34
       \\type object-list
       \\object-list GlazingMaterialName
  N35, \\field Optical Data Temperature 35
       \\units C
       \\ip-units F
       \\type real
  A36, \\field Window Material Glazing Name 35
       \\type object-list
       \\object-list GlazingMaterialName
  N36, \\field Optical Data Temperature 36
       \\units C
       \\ip-units F
       \\type real
  A37, \\field Window Material Glazing Name 36
       \\type object-list
       \\object-list GlazingMaterialName
  N37, \\field Optical Data Temperature 37
       \\units C
       \\ip-units F
       \\type real
  A38, \\field Window Material Glazing Name 37
       \\type object-list
       \\object-list GlazingMaterialName
  N38, \\field Optical Data Temperature 38
       \\units C
       \\ip-units F
       \\type real
  A39, \\field Window Material Glazing Name 38
       \\type object-list
       \\object-list GlazingMaterialName
  N39, \\field Optical Data Temperature 39
       \\units C
       \\ip-units F
       \\type real
  A40, \\field Window Material Glazing Name 39
       \\type object-list
       \\object-list GlazingMaterialName
  N40, \\field Optical Data Temperature 40
       \\units C
       \\ip-units F
       \\type real
  A41, \\field Window Material Glazing Name 40
       \\type object-list
       \\object-list GlazingMaterialName
  N41, \\field Optical Data Temperature 41
       \\units C
       \\ip-units F
       \\type real
  A42, \\field Window Material Glazing Name 41
       \\type object-list
       \\object-list GlazingMaterialName
  N42, \\field Optical Data Temperature 42
       \\units C
       \\ip-units F
       \\type real
  A43, \\field Window Material Glazing Name 42
       \\type object-list
       \\object-list GlazingMaterialName
  N43, \\field Optical Data Temperature 43
       \\units C
       \\ip-units F
       \\type real
  A44, \\field Window Material Glazing Name 43
       \\type object-list
       \\object-list GlazingMaterialName
  N44, \\field Optical Data Temperature 44
       \\units C
       \\ip-units F
       \\type real
  A45, \\field Window Material Glazing Name 44
       \\type object-list
       \\object-list GlazingMaterialName
  N45, \\field Optical Data Temperature 45
       \\units C
       \\ip-units F
       \\type real
  A46; \\field Window Material Glazing Name 45
       \\type object-list
       \\object-list GlazingMaterialName

WindowMaterial:Glazing:RefractionExtinctionMethod,
    \\memo Glass material properties for Windows or Glass Doors
    \\memo Index of Refraction/Extinction Coefficient input method
    \\memo Not to be used for coated glass
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference MaterialName
       \\reference GlazingMaterialName
  N1 , \\field Thickness
       \\required-field
       \\units m
       \\type real
       \\minimum> 0.0
       \\ip-units in
  N2 , \\field Solar Index of Refraction
       \\required-field
       \\type real
       \\minimum> 1.0
  N3 , \\field Solar Extinction Coefficient
       \\required-field
       \\units 1/m
       \\type real
       \\minimum> 0.0
  N4 , \\field Visible Index of Refraction
       \\required-field
       \\type real
       \\minimum> 1.0
  N5 , \\field Visible Extinction Coefficient
       \\required-field
       \\units 1/m
       \\type real
       \\minimum> 0.0
  N6 , \\field Infrared Transmittance at Normal Incidence
       \\type real
       \\maximum< 1.0
       \\minimum 0.0
       \\default 0.0
  N7 , \\field Infrared Hemispherical Emissivity
       \\note Emissivity of front and back side assumed equal
       \\type real
       \\maximum< 1.0
       \\minimum> 0.0
       \\default 0.84
  N8 , \\field Conductivity
       \\units W/m-K
       \\type real
       \\minimum> 0.0
       \\default 0.9
  N9 , \\field Dirt Correction Factor for Solar and Visible Transmittance
       \\type real
       \\minimum> 0.0
       \\maximum 1.0
       \\default 1.0
  A2 ; \\field Solar Diffusing
       \\type choice
       \\key No
       \\key Yes
       \\default No

WindowMaterial:Gas,
    \\memo Gas material properties that are used in Windows or Glass Doors
       \\min-fields 3
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference MaterialName
       \\reference WindowGasAndGasMixtures
  A2 , \\field Gas Type
       \\required-field
       \\type choice
       \\key Air
       \\key Argon
       \\key Krypton
       \\key Xenon
       \\key Custom
  N1 , \\field Thickness
       \\required-field
       \\units m
       \\type real
       \\minimum> 0.0
       \\ip-units in
  N2 , \\field Conductivity Coefficient A
       \\units W/m-K
       \\type real
       \\note Used only if Gas Type = Custom
  N3 , \\field Conductivity Coefficient B
       \\units W/m-K2
       \\type real
       \\note Used only if Gas Type = Custom
  N4 , \\field Conductivity Coefficient C
       \\units W/m-K3
       \\type real
       \\note Used only if Gas Type = Custom
  N5 , \\field Viscosity Coefficient A
       \\units kg/m-s
       \\type real
       \\note Used only if Gas Type = Custom
       \\minimum> 0.0
  N6 , \\field Viscosity Coefficient B
       \\units kg/m-s-K
       \\type real
       \\note Used only if Gas Type = Custom
  N7 , \\field Viscosity Coefficient C
       \\units kg/m-s-K2
       \\type real
       \\note Used only if Gas Type = Custom
  N8 , \\field Specific Heat Coefficient A
       \\units J/kg-K
       \\type real
       \\note Used only if Gas Type = Custom
       \\minimum> 0.0
  N9 , \\field Specific Heat Coefficient B
       \\units J/kg-K2
       \\type real
       \\note Used only if Gas Type = Custom
  N10 ,\\field Specific Heat Coefficient C
       \\units J/kg-K3
       \\type real
       \\note Used only if Gas Type = Custom
  N11 ,\\field Molecular Weight
       \\type real
       \\note Used only if Gas Type = Custom
       \\units g/mol
       \\minimum 20.0
       \\maximum 200.0
  N12 ;\\field Specific Heat Ratio
       \\type real
       \\note Used only if Gas Type = Custom
       \\minimum >1.0

WindowGap:SupportPillar,
    \\memo used to define pillar geometry for support pillars
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference WindowGapSupportPillars
  N1 , \\field Spacing
       \\units m
       \\type real
       \\minimum> 0.0
       \\default 0.04
 N2 ; \\field Radius
       \\units m
       \\type real
       \\minimum> 0.0
       \\default 0.0004

WindowGap:DeflectionState,
       \\memo Used to enter data describing deflection state of the gap. It is referenced from
       \\memo WindowMaterial:Gap object only and it is used only when deflection model is set to
       \\memo MeasuredDeflection, otherwise it is ignored.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference WindowGapDeflectionStates
  N1 , \\field Deflected Thickness
       \\note if left blank will be considered that gap has no deflection
       \\units m
       \\type real
       \\minimum 0.0
  N2 , \\field Initial Temperature
       \\units C
       \\type real
       \\minimum 0.0
       \\default 25
  N3 ; \\field Initial Pressure
       \\units Pa
       \\type real
       \\minimum 0.0
       \\default 101325

WindowMaterial:GasMixture,
    \\memo Gas mixtures that are used in Windows or Glass Doors
       \\min-fields 7
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference MaterialName
       \\reference WindowGasAndGasMixtures
  N1 , \\field Thickness
       \\required-field
       \\units m
       \\type real
       \\minimum> 0.0
  N2 , \\field Number of Gases in Mixture
       \\required-field
       \\type integer
       \\minimum 1
       \\maximum 4
  A2 , \\field Gas 1 Type
       \\required-field
       \\type choice
       \\key Air
       \\key Argon
       \\key Krypton
       \\key Xenon
  N3 , \\field Gas 1 Fraction
       \\required-field
       \\type real
       \\minimum> 0.0
       \\maximum 1.0
  A3 , \\field Gas 2 Type
       \\required-field
       \\type choice
       \\key Air
       \\key Argon
       \\key Krypton
       \\key Xenon
  N4 , \\field Gas 2 Fraction
       \\required-field
       \\type real
       \\minimum> 0.0
       \\maximum 1.0
  A4 , \\field Gas 3 Type
       \\type choice
       \\key Air
       \\key Argon
       \\key Krypton
       \\key Xenon
  N5 , \\field Gas 3 Fraction
       \\type real
       \\minimum> 0.0
       \\maximum 1.0
  A5 , \\field Gas 4 Type
       \\type choice
       \\key Air
       \\key Argon
       \\key Krypton
       \\key Xenon
  N6 ; \\field Gas 4 Fraction
       \\type real
       \\minimum> 0.0
       \\maximum 1.0

WindowMaterial:Gap,
       \\memo Used to define the gap between two layers in a complex fenestration system, where the
       \\memo Construction:ComplexFenestrationState object is used. It is referenced as a layer in the
       \\memo Construction:ComplexFenestrationState object. It cannot be referenced as a layer from the
       \\memo Construction object.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference MaterialName
  N1 , \\field Thickness
       \\required-field
       \\units m
       \\type real
       \\minimum >0
  A2 , \\field Gas (or Gas Mixture)
       \\note This field should reference only WindowMaterial:Gas
       \\note or WindowMaterial:GasMixture objects
       \\required-field
       \\type object-list
       \\object-list WindowGasAndGasMixtures
  N2 , \\field Pressure
       \\required-field
       \\units Pa
       \\type real
       \\default 101325
  A3 , \\field Deflection State
       \\type object-list
       \\object-list WindowGapDeflectionStates
  A4 ; \\field Support Pillar
       \\type object-list
       \\object-list WindowGapSupportPillars

WindowMaterial:Shade,
       \\memo Specifies the properties of window shade materials. Reflectance and emissivity
       \\memo properties are assumed to be the same on both sides of the shade. Shades are considered
       \\memo to be perfect diffusers (all transmitted and reflected radiation is
       \\memo hemispherically-diffuse) independent of angle of incidence.
  \\min-fields 15
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference MaterialName
       \\reference WindowShadesScreensAndBlinds
  N1 , \\field Solar Transmittance
       \\required-field
       \\note Assumed independent of incidence angle
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N2 , \\field Solar Reflectance
       \\required-field
       \\note Assumed same for both sides
       \\note Assumed independent of incidence angle
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N3 , \\field Visible Transmittance
       \\required-field
       \\note Assumed independent of incidence angle
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N4 , \\field Visible Reflectance
       \\required-field
       \\note Assumed same for both sides
       \\note Assumed independent of incidence angle
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N5 , \\field Infrared Hemispherical Emissivity
       \\required-field
       \\type real
       \\units dimensionless
       \\maximum< 1
       \\minimum> 0
  N6 , \\field Infrared Transmittance
       \\required-field
       \\type real
       \\units dimensionless
       \\maximum< 1
       \\minimum 0
  N7 , \\field Thickness
       \\required-field
       \\type real
       \\units m
       \\minimum> 0
       \\ip-units in
  N8 , \\field Conductivity
       \\required-field
       \\units W/m-K
       \\type real
       \\minimum> 0
  N9 , \\field Shade to Glass Distance
       \\type real
       \\units m
       \\minimum 0.001
       \\maximum 1.0
       \\default 0.050
       \\ip-units in
  N10, \\field Top Opening Multiplier
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.5
  N11, \\field Bottom Opening Multiplier
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.5
  N12, \\field Left-Side Opening Multiplier
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.5
  N13, \\field Right-Side Opening Multiplier
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.5
  N14; \\field Airflow Permeability
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 0.8
       \\default 0.0

WindowMaterial:ComplexShade,
    \\memo Complex window shading layer thermal properties
     \\min-fields 12
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference WindowComplexShades
       \\reference WindowShadesScreensAndBlinds
  A2 , \\field Layer Type
       \\type choice
       \\key Venetian
       \\key Woven
       \\key Perforated
  N1 , \\field Thickness
       \\type real
       \\units m
       \\minimum> 0
       \\default 0.002
  N2 , \\field Conductivity
       \\units W/m-K
       \\type real
       \\minimum> 0
       \\default 1
  N3 , \\field IR Transmittance
       \\type real
       \\maximum 1
       \\minimum 0
       \\default 0
  N4 , \\field Front Emissivity
       \\type real
       \\maximum 1
       \\minimum 0
       \\default 0.84
  N5 , \\field Back Emissivity
       \\type real
       \\maximum 1
       \\minimum 0
       \\default 0.84
  N6 , \\field TopOpeningMultiplier
       \\required-field
       \\type real
       \\minimum 0
       \\maximum 1
       \\default 0
  N7 , \\field BottomOpeningMultiplier
       \\required-field
       \\type real
       \\minimum 0
       \\maximum 1
       \\default 0
  N8 , \\field LeftSideOpeningMultiplier
       \\required-field
       \\type real
       \\minimum 0
       \\maximum 1
       \\default 0
  N9 , \\field RightSideOpeningMultiplier
       \\required-field
       \\type real
       \\minimum 0
       \\maximum 1
       \\default 0
 N10 , \\field FrontOpeningMultiplier
       \\required-field
       \\type real
       \\minimum 0
       \\maximum 1
       \\default 0.05
 N11 , \\field Slat Width
       \\units m
       \\type real
       \\minimum> 0
       \\default 0.016
 N12 , \\field Slat Spacing
       \\note Distance between adjacent slat faces
       \\units m
       \\type real
       \\minimum> 0
       \\default 0.012
  N13 , \\field Slat Thickness
       \\note Distance between top and bottom surfaces of slat
       \\note Slat is assumed to be rectangular in cross section and flat
       \\type real
       \\units m
       \\minimum> 0
       \\default 0.0006
  N14 , \\field Slat Angle
       \\type real
       \\units deg
       \\default 90
       \\minimum -90
       \\maximum 90
  N15 , \\field Slat Conductivity
       \\type real
       \\units W/m-K
       \\minimum> 0
       \\default 160.0
  N16 ; \\field Slat Curve
       \\note this value represents curvature radius of the slat.
       \\note if the slat is flat use zero.
       \\note if this value is not zero, then it must be > SlatWidth/2.
       \\type real
       \\units m
       \\minimum 0.0
       \\default 0

WindowMaterial:Blind,
    \\memo Window blind thermal properties
     \\min-fields 29
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference MaterialName
       \\reference WindowShadesScreensAndBlinds
  A2 , \\field Slat Orientation
       \\type choice
       \\key Horizontal
       \\key Vertical
       \\default Horizontal
  N1 , \\field Slat Width
       \\required-field
       \\units m
       \\type real
       \\minimum> 0
       \\maximum 1
       \\ip-units in
  N2 , \\field Slat Separation
       \\required-field
       \\note Distance between adjacent slat faces
       \\units m
       \\type real
       \\minimum> 0
       \\maximum 1
       \\ip-units in
  N3 , \\field Slat Thickness
       \\note Distance between top and bottom surfaces of slat
       \\note Slat is assumed to be rectangular in cross section and flat
       \\type real
       \\units m
       \\minimum> 0
       \\maximum 0.1
       \\default 0.00025
       \\ip-units in
  N4 , \\field Slat Angle
       \\note If WindowProperty:ShadingControl for the window that incorporates this blind
       \\note has Type of Slat Angle Control for Blinds = FixedSlatAngle,
       \\note then this is the fixed value of the slat angle;
       \\note If WindowProperty:ShadingControl for the window that incorporates this blind
       \\note has Type of Slat Angle Control for Blinds = BlockBeamSolar,
       \\note then this is the slat angle when slat angle control
       \\note is not in effect (e.g., when there is no beam solar on the blind);
       \\note Not used if WindowProperty:ShadingControl for the window that incorporates this blind
       \\note has Type of Slat Angle Control for Blinds = ScheduledSlatAngle.
       \\type real
       \\units deg
       \\default 45
       \\minimum 0
       \\maximum 180
  N5 , \\field Slat Conductivity
       \\type real
       \\units W/m-K
       \\minimum> 0
       \\default 221.0
       \\note default is for aluminum
  N6 , \\field Slat Beam Solar Transmittance
       \\type real
       \\maximum< 1
       \\minimum 0
       \\default 0
  N7 , \\field Front Side Slat Beam Solar Reflectance
       \\required-field
       \\type real
       \\maximum< 1
       \\minimum 0
  N8 , \\field Back Side Slat Beam Solar Reflectance
       \\required-field
       \\type real
       \\maximum< 1
       \\minimum 0
  N9 , \\field Slat Diffuse Solar Transmittance
       \\note Must equal "Slat beam solar transmittance"
       \\type real
       \\maximum< 1
       \\minimum 0
       \\default 0
  N10, \\field Front Side Slat Diffuse Solar Reflectance
       \\note Must equal "Front Side Slat Beam Solar Reflectance"
       \\required-field
       \\type real
       \\maximum< 1
       \\minimum 0
  N11, \\field Back Side Slat Diffuse Solar Reflectance
       \\note Must equal "Back Side Slat Beam Solar Reflectance"
       \\required-field
       \\type real
       \\maximum< 1
       \\minimum 0
  N12, \\field Slat Beam Visible Transmittance
       \\note Required for detailed daylighting calculation
       \\type real
       \\maximum< 1
       \\minimum 0
       \\required-field
  N13, \\field Front Side Slat Beam Visible Reflectance
       \\note Required for detailed daylighting calculation
       \\type real
       \\maximum< 1
       \\minimum 0
  N14, \\field Back Side Slat Beam Visible Reflectance
       \\note Required for detailed daylighting calculation
       \\type real
       \\maximum< 1
       \\minimum 0
  N15, \\field Slat Diffuse Visible Transmittance
       \\note Used only for detailed daylighting calculation
       \\note Must equal "Slat Beam Visible Transmittance"
       \\type real
       \\maximum< 1
       \\minimum 0
       \\default 0
  N16, \\field Front Side Slat Diffuse Visible Reflectance
       \\note Required for detailed daylighting calculation
       \\note Must equal "Front Side Slat Beam Visible Reflectance"
       \\type real
       \\maximum< 1
       \\minimum 0
  N17, \\field Back Side Slat Diffuse Visible Reflectance
       \\note Required for detailed daylighting calculation
       \\note Must equal "Back Side Slat Beam Visible Reflectance"
       \\type real
       \\maximum< 1
       \\minimum 0
  N18, \\field Slat Infrared Hemispherical Transmittance
       \\type real
       \\maximum< 1
       \\minimum 0
       \\default 0
  N19, \\field Front Side Slat Infrared Hemispherical Emissivity
       \\type real
       \\maximum< 1
       \\minimum 0
       \\default 0.9
  N20, \\field Back Side Slat Infrared Hemispherical Emissivity
       \\type real
       \\maximum< 1
       \\minimum 0
       \\default 0.9
  N21, \\field Blind to Glass Distance
       \\type real
       \\units m
       \\minimum 0.01
       \\maximum 1.0
       \\default 0.050
       \\ip-units in
  N22, \\field Blind Top Opening Multiplier
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.5
  N23, \\field Blind Bottom Opening Multiplier
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  N24, \\field Blind Left Side Opening Multiplier
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.5
  N25, \\field Blind Right Side Opening Multiplier
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.5
  N26, \\field Minimum Slat Angle
       \\note Used only if WindowProperty:ShadingControl for the window that incorporates
       \\note this blind varies the slat angle (i.e., WindowProperty:ShadingControl with
       \\note Type of Slat Angle Control for Blinds = ScheduledSlatAngle
       \\note or BlockBeamSolar)
       \\type real
       \\units deg
       \\default 0
       \\minimum 0
       \\maximum 180
  N27; \\field Maximum Slat Angle
       \\note Used only if WindowProperty:ShadingControl for the window that incorporates
       \\note this blind varies the slat angle (i.e., WindowProperty:ShadingControl with
       \\note Type of Slat Angle Control for Blinds = ScheduledSlatAngle
       \\note or BlockBeamSolar)
       \\type real
       \\units deg
       \\default 180
       \\minimum 0
       \\maximum 180

WindowMaterial:Screen,
       \\memo Window screen physical properties. Can only be located on the exterior side of a window construction.
       \\min-fields 9
  A1 , \\field Name
       \\note Enter a unique name for this window screen material.
       \\required-field
       \\type alpha
       \\reference MaterialName
       \\reference WindowShadesScreensAndBlinds
  A2 , \\field Reflected Beam Transmittance Accounting Method
       \\note Select the method used to account for the beam solar reflected off the material surface.
       \\type choice
       \\key DoNotModel
       \\key ModelAsDirectBeam
       \\key ModelAsDiffuse
       \\default ModelAsDiffuse
  N1 , \\field Diffuse Solar Reflectance
       \\note Diffuse reflectance of the screen material over the entire solar radiation spectrum.
       \\note Assumed to be the same for both sides of the screen.
       \\required-field
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N2 , \\field Diffuse Visible Reflectance
       \\note Diffuse visible reflectance of the screen material averaged over the solar spectrum
       \\note and weighted by the response of the human eye.
       \\note Assumed to be the same for both sides of the screen.
       \\required-field
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N3 , \\field Thermal Hemispherical Emissivity
       \\note Long-wave emissivity of the screen material.
       \\note Assumed to be the same for both sides of the screen.
       \\type real
       \\units dimensionless
       \\maximum< 1
       \\minimum> 0
       \\default 0.9
  N4 , \\field Conductivity
       \\note Thermal conductivity of the screen material.
       \\type real
       \\units W/m-K
       \\minimum> 0
       \\default 221.0
       \\note Default is for aluminum.
  N5 , \\field Screen Material Spacing
       \\note Spacing assumed to be the same in both directions.
       \\required-field
       \\type real
       \\units m
       \\minimum> 0
       \\ip-units in
  N6 , \\field Screen Material Diameter
       \\note Diameter assumed to be the same in both directions.
       \\required-field
       \\type real
       \\units m
       \\minimum> 0
       \\ip-units in
  N7 , \\field Screen to Glass Distance
       \\note Distance from the window screen to the adjacent glass surface.
       \\type real
       \\units m
       \\minimum 0.001
       \\maximum 1.0
       \\default 0.025
       \\ip-units in
  N8 , \\field Top Opening Multiplier
       \\note Effective area for air flow at the top of the screen divided by the perpendicular
       \\note area between the glass and the top of the screen.
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  N9 , \\field Bottom Opening Multiplier
       \\note Effective area for air flow at the bottom of the screen divided by the perpendicular
       \\note area between the glass and the bottom of the screen.
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  N10, \\field Left Side Opening Multiplier
       \\note Effective area for air flow at the left side of the screen divided by the perpendicular
       \\note area between the glass and the left side of the screen.
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  N11, \\field Right Side Opening Multiplier
       \\note Effective area for air flow at the right side of the screen divided by the perpendicular
       \\note area between the glass and the right side of the screen.
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  N12; \\field Angle of Resolution for Screen Transmittance Output Map
       \\note Select the resolution of azimuth and altitude angles for the screen transmittance map.
       \\note A value of 0 means no transmittance map will be generated.
       \\note Valid values for this field are 0, 1, 2, 3 and 5.
       \\type choice
       \\units deg
       \\key 0
       \\key 1
       \\key 2
       \\key 3
       \\key 5
       \\default 0

MaterialProperty:MoisturePenetrationDepth:Settings,
    \\memo Additional properties for moisture using EMPD procedure
    \\memo HeatBalanceAlgorithm choice=MoisturePenetrationDepthConductionTransferFunction only
    \\memo Has no effect with other HeatBalanceAlgorithm solution algorithms
  A1 , \\field Name
       \\required-field
       \\type object-list
       \\object-list MaterialName
       \\note Material Name that the moisture properties will be added to.
       \\note Additional material properties required to perform the EMPD model.
       \\note Effective Mean Penetration Depth (EMPD)
  N1 , \\field Moisture Penetration Depth
       \\required-field
       \\note This is the penetration depth
       \\units m
       \\minimum 0.0
       \\type real
  N2 , \\field Moisture Equation Coefficient a
       \\required-field
       \\units dimensionless
       \\type real
  N3 , \\field Moisture Equation Coefficient b
       \\required-field
       \\units dimensionless
       \\type real
  N4 , \\field Moisture Equation Coefficient c
       \\required-field
       \\units dimensionless
       \\type real
  N5 ; \\field Moisture Equation Coefficient d
       \\required-field
       \\units dimensionless
       \\type real

MaterialProperty:PhaseChange,
    \\memo Additional properties for temperature dependent thermal conductivity
    \\memo and enthalpy for Phase Change Materials (PCM)
    \\memo HeatBalanceAlgorithm = CondFD(ConductionFiniteDifference) solution algorithm only.
    \\memo Constructions with this should use the detailed CondFD process.
    \\memo Has no effect with other HeatBalanceAlgorithm solution algorithms
  A1 , \\field Name
       \\required-field
       \\type object-list
       \\object-list MaterialName
       \\note Regular Material Name to which the additional properties will be added.
       \\note this the material name for the basic material properties.
  N1 , \\field Temperature Coefficient for Thermal Conductivity
       \\note The base temperature is 20C.
       \\note This is the thermal conductivity change per degree excursion from 20C.
       \\note This variable conductivity function is overridden by the VariableThermalConductivity object, if present.
       \\units W/m-K2
       \\type real
       \\default 0.0
  N2 , \\field Temperature 1
       \\required-field
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
       \\default 0.0
  N3,  \\field Enthalpy 1
       \\required-field
       \\note for Temperature-enthalpy function corresponding to temperature 1
       \\units J/kg
       \\default 0.0
  N4 , \\field Temperature 2
       \\required-field
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
       \\default 0.0
  N5,  \\field Enthalpy 2
       \\required-field
       \\note for Temperature-enthalpy function corresponding to temperature 2
       \\units J/kg
       \\type real
       \\default 0.0
  N6 , \\field Temperature 3
       \\required-field
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
       \\default 0.0
  N7,  \\field Enthalpy 3
       \\required-field
       \\note for Temperature-enthalpy function corresponding to temperature 3
       \\units J/kg
       \\type real
       \\default 0.0
  N8 , \\field Temperature 4
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
       \\default 0.0
  N9,  \\field Enthalpy 4
       \\note for Temperature-enthalpy function corresponding to temperature 4
       \\units J/kg
       \\type real
       \\default 0.0
  N10, \\field Temperature 5
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
       \\default 0.0
  N11, \\field Enthalpy 5
       \\note for Temperature-enthalpy function corresponding to temperature 5
       \\units J/kg
       \\type real
       \\default 0.0
  N12, \\field Temperature 6
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
       \\default 0.0
  N13, \\field Enthalpy 6
       \\note for Temperature-enthalpy function corresponding to temperature 6
       \\units J/kg
       \\type real
       \\default 0.0
  N14, \\field Temperature 7
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
       \\default 0.0
  N15, \\field Enthalpy 7
       \\note for Temperature-enthalpy function corresponding to temperature 7
       \\units J/kg
       \\type real
       \\default 0.0
  N16, \\field Temperature 8
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
       \\default 0.0
  N17, \\field Enthalpy 8
       \\note for Temperature-enthalpy function corresponding to temperature 8
       \\units J/kg
       \\type real
       \\default 0.0
  N18 , \\field Temperature 9
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
       \\default 0.0
  N19,  \\field Enthalpy 9
       \\note for Temperature-enthalpy function corresponding to temperature 1
       \\units J/kg
       \\default 0.0
  N20 , \\field Temperature 10
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
       \\default 0.0
  N21,  \\field Enthalpy 10
       \\note for Temperature-enthalpy function corresponding to temperature 2
       \\units J/kg
       \\type real
       \\default 0.0
  N22 , \\field Temperature 11
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
       \\default 0.0
  N23,  \\field Enthalpy 11
       \\note for Temperature-enthalpy function corresponding to temperature 3
       \\units J/kg
       \\type real
       \\default 0.0
  N24 , \\field Temperature 12
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
       \\default 0.0
  N25,  \\field Enthalpy 12
       \\note for Temperature-enthalpy function corresponding to temperature 14
       \\units J/kg
       \\type real
       \\default 0.0
  N26, \\field Temperature 13
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
       \\default 0.0
  N27, \\field Enthalpy 13
       \\note for Temperature-enthalpy function corresponding to temperature 15
       \\units J/kg
       \\type real
       \\default 0.0
  N28, \\field Temperature 14
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
       \\default 0.0
  N29, \\field Enthalpy 14
       \\note for Temperature-enthalpy function corresponding to temperature 16
       \\units J/kg
       \\type real
       \\default 0.0
  N30, \\field Temperature 15
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
       \\default 0.0
  N31, \\field Enthalpy 15
       \\note for Temperature-enthalpy function corresponding to temperature 17
       \\units J/kg
       \\type real
       \\default 0.0
  N32, \\field Temperature 16
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
       \\default 0.0
  N33; \\field Enthalpy 16
       \\note for Temperature-enthalpy function corresponding to temperature 16
       \\units J/kg
       \\type real
       \\default 0.0

MaterialProperty:VariableThermalConductivity,
    \\memo Additional properties for temperature dependent thermal conductivity
    \\memo using piecewise linear temperature-conductivity function.
    \\memo HeatBalanceAlgorithm = CondFD(ConductionFiniteDifference) solution algorithm only.
    \\memo Has no effect with other HeatBalanceAlgorithm solution algorithms
  A1 , \\field Name
       \\required-field
       \\type object-list
       \\object-list MaterialName
       \\note Regular Material Name to which the additional properties will be added.
       \\note this the material name for the basic material properties.
  N1 , \\field Temperature 1
       \\required-field
       \\note for Temperature-Thermal Conductivity function
       \\units C
       \\type real
       \\default 0.0
  N2,  \\field Thermal Conductivity 1
       \\required-field
       \\note for Temperature-Thermal Conductivity function corresponding to temperature 1
       \\units W/m-K
       \\default 0.0
  N3 , \\field Temperature 2
       \\required-field
       \\note for Temperature-Thermal Conductivity function
       \\units C
       \\type real
       \\default 0.0
  N4,  \\field Thermal Conductivity 2
       \\required-field
       \\note for Temperature-Thermal Conductivity function corresponding to temperature 2
       \\units W/m-K
       \\type real
       \\default 0.0
  N5 , \\field Temperature 3
       \\required-field
       \\note for Temperature-Thermal Conductivity function
       \\units C
       \\type real
       \\default 0.0
  N6,  \\field Thermal Conductivity 3
       \\required-field
       \\note for Temperature-Thermal Conductivity function corresponding to temperature 3
       \\units W/m-K
       \\type real
       \\default 0.0
  N7 , \\field Temperature 4
       \\note for Temperature-Thermal Conductivity function
       \\units C
       \\type real
       \\default 0.0
  N8,  \\field Thermal Conductivity 4
       \\note for Temperature-Thermal Conductivity function corresponding to temperature 4
       \\units W/m-K
       \\type real
       \\default 0.0
  N9, \\field Temperature 5
       \\note for Temperature-Thermal Conductivity function
       \\units C
       \\type real
       \\default 0.0
  N10, \\field Thermal Conductivity 5
       \\note for Temperature-Thermal Conductivity function corresponding to temperature 5
       \\units W/m-K
       \\type real
       \\default 0.0
  N11, \\field Temperature 6
       \\note for Temperature-Thermal Conductivity function
       \\units C
       \\type real
       \\default 0.0
  N12, \\field Thermal Conductivity 6
       \\note for Temperature-Thermal Conductivity function corresponding to temperature 6
       \\units W/m-K
       \\type real
       \\default 0.0
  N13, \\field Temperature 7
       \\note for Temperature-Thermal Conductivity function
       \\units C
       \\type real
       \\default 0.0
  N14, \\field Thermal Conductivity 7
       \\note for Temperature-Thermal Conductivity function corresponding to temperature 7
       \\units W/m-K
       \\type real
       \\default 0.0
  N15, \\field Temperature 8
       \\note for Temperature-Thermal Conductivity function
       \\units C
       \\type real
       \\default 0.0
  N16, \\field Thermal Conductivity 8
       \\note for Temperature-Thermal Conductivity function corresponding to temperature 8
       \\units W/m-K
       \\type real
       \\default 0.0
  N17 , \\field Temperature 9
       \\note for Temperature-Thermal Conductivity function
       \\units C
       \\type real
       \\default 0.0
  N18,  \\field Thermal Conductivity 9
       \\note for Temperature-Thermal Conductivity function corresponding to temperature 9
       \\units W/m-K
       \\default 0.0
  N19 , \\field Temperature 10
       \\note for Temperature-Thermal Conductivity function
       \\units C
       \\type real
       \\default 0.0
  N20;  \\field Thermal Conductivity 10
       \\note for Temperature-Thermal Conductivity function corresponding to temperature 10
       \\units W/m-K
       \\type real
       \\default 0.0

MaterialProperty:HeatAndMoistureTransfer:Settings,
    \\memo HeatBalanceAlgorithm = CombinedHeatAndMoistureFiniteElement solution algorithm only.
    \\memo Additional material properties for surfaces.
    \\memo Has no effect with other HeatBalanceAlgorithm solution algorithms
  A1, \\field Material Name
      \\required-field
      \\type object-list
      \\object-list MaterialName
      \\note Material Name that the moisture properties will be added to.
      \\note This augments material properties needed for combined heat and moisture transfer for surfaces.
  N1, \\field Porosity
      \\required-field
      \\units m3/m3
      \\minimum 0.0
      \\maximum 1.0
      \\type real
  N2; \\field Initial Water Content Ratio
      \\note units are the water/material density ratio at the begining of each run period.
      \\required-field
      \\units kg/kg
      \\minimum 0.0
      \\default 0.2
      \\type real

MaterialProperty:HeatAndMoistureTransfer:SorptionIsotherm,
    \\memo HeatBalanceAlgorithm = CombinedHeatAndMoistureFiniteElement solution algorithm only.
    \\memo Relationship between moisture content and relative humidity fraction.
    \\memo Has no effect with other HeatBalanceAlgorithm solution algorithms
  A1 , \\field Material Name
       \\required-field
       \\type object-list
       \\object-list MaterialName
       \\note The Material Name that the moisture sorption isotherm will be added to.
  N1,  \\field Number of Isotherm Coordinates
       \\required-field
       \\note Number of data Coordinates
       \\minimum 1
       \\maximum 25
       \\type integer
  N2, \\field Relative Humidity Fraction 1
      \\required-field
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N3, \\field Moisture Content 1
      \\required-field
      \\minimum 0.0
      \\units kg/m3
  N4, \\field Relative Humidity Fraction 2
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N5, \\field Moisture Content 2
      \\minimum 0.0
      \\units kg/m3
  N6, \\field Relative Humidity Fraction 3
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N7, \\field Moisture Content 3
      \\minimum 0.0
      \\units kg/m3
  N8, \\field Relative Humidity Fraction 4
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N9, \\field Moisture Content 4
      \\units kg/m3
      \\minimum 0.0
  N10, \\field Relative Humidity Fraction 5
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N11, \\field Moisture Content 5
      \\minimum 0.0
      \\units kg/m3
  N12, \\field Relative Humidity Fraction 6
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N13, \\field Moisture Content 6
      \\minimum 0.0
      \\units kg/m3
  N14, \\field Relative Humidity Fraction 7
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N15, \\field Moisture Content 7
      \\minimum 0.0
      \\units kg/m3
  N16, \\field Relative Humidity Fraction 8
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N17, \\field Moisture Content 8
      \\minimum 0.0
      \\units kg/m3
  N18,\\field Relative Humidity Fraction 9
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N19, \\field Moisture Content 9
      \\minimum 0.0
      \\units kg/m3
  N20,\\field Relative Humidity Fraction 10
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N21, \\field Moisture Content 10
      \\minimum 0.0
      \\units kg/m3
  N22,\\field Relative Humidity Fraction 11
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N23, \\field Moisture Content 11
      \\minimum 0.0
      \\units kg/m3
  N24,\\field Relative Humidity Fraction 12
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N25, \\field Moisture Content 12
      \\minimum 0.0
      \\units kg/m3
  N26,\\field Relative Humidity Fraction 13
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N27, \\field Moisture Content 13
      \\minimum 0.0
      \\units kg/m3
  N28,\\field Relative Humidity Fraction 14
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N29,\\field Moisture Content 14
      \\minimum 0.0
      \\units kg/m3
  N30,\\field Relative Humidity Fraction 15
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N31,\\field Moisture Content 15
      \\minimum 0.0
      \\units kg/m3
  N32,\\field Relative Humidity Fraction 16
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N33,\\field Moisture Content 16
      \\minimum 0.0
      \\units kg/m3
  N34,\\field Relative Humidity Fraction 17
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N35,\\field Moisture Content 17
      \\minimum 0.0
      \\units kg/m3
  N36,\\field Relative Humidity Fraction 18
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N37,\\field Moisture Content 18
      \\minimum 0.0
      \\units kg/m3
  N38,\\field Relative Humidity Fraction 19
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N39,\\field Moisture Content 19
      \\minimum 0.0
      \\units kg/m3
  N40,\\field Relative Humidity Fraction 20
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N41,\\field Moisture Content 20
      \\minimum 0.0
      \\units kg/m3
  N42,\\field Relative Humidity Fraction 21
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N43,\\field Moisture Content 21
      \\minimum 0.0
      \\units kg/m3
  N44,\\field Relative Humidity Fraction 22
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N45,\\field Moisture Content 22
      \\minimum 0.0
      \\units kg/m3
  N46,\\field Relative Humidity Fraction 23
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N47,\\field Moisture Content 23
      \\minimum 0.0
      \\units kg/m3
  N48,\\field Relative Humidity Fraction 24
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N49,\\field Moisture Content 24
      \\minimum 0.0
      \\units kg/m3
  N50,\\field Relative Humidity Fraction 25
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N51;\\field Moisture Content 25
      \\minimum 0.0
      \\units kg/m3

MaterialProperty:HeatAndMoistureTransfer:Suction,
    \\memo HeatBalanceAlgorithm = CombinedHeatAndMoistureFiniteElement solution algorithm only.
    \\memo Relationship between liquid suction transport coefficient and moisture content
    \\memo Has no effect with other HeatBalanceAlgorithm solution algorithms
  A1 , \\field Material Name
       \\required-field
       \\type object-list
       \\object-list MaterialName
       \\note Material Name that the moisture properties will be added to.
  N1,  \\field Number of Suction points
       \\required-field
       \\note Number of Suction Liquid Transport Coefficient coordinates
       \\minimum 1
       \\maximum 25
       \\type integer
  N2,\\field Moisture Content 1
     \\required-field
     \\minimum 0.0
     \\units kg/m3
  N3,\\field Liquid Transport Coefficient 1
     \\required-field
     \\minimum 0.0
     \\units m2/s
  N4,\\field Moisture Content 2
      \\minimum 0.0
     \\units kg/m3
  N5,\\field Liquid Transport Coefficient 2
      \\minimum 0.0
     \\units m2/s
  N6,\\field Moisture Content 3
      \\minimum 0.0
     \\units kg/m3
  N7,\\field Liquid Transport Coefficient 3
      \\minimum 0.0
     \\units m2/s
  N8,\\field Moisture Content 4
      \\minimum 0.0
     \\units kg/m3
  N9,\\field Liquid Transport Coefficient 4
      \\minimum 0.0
     \\units m2/s
  N10,\\field Moisture Content 5
      \\minimum 0.0
     \\units kg/m3
  N11,\\field Liquid Transport Coefficient 5
      \\minimum 0.0
     \\units m2/s
  N12,\\field Moisture Content 6
      \\minimum 0.0
     \\units kg/m3
  N13,\\field Liquid Transport Coefficient 6
      \\minimum 0.0
     \\units m2/s
  N14,\\field Moisture Content 7
      \\minimum 0.0
     \\units kg/m3
  N15,\\field Liquid Transport Coefficient 7
      \\minimum 0.0
     \\units m2/s
  N16,\\field Moisture Content 8
      \\minimum 0.0
     \\units kg/m3
  N17,\\field Liquid Transport Coefficient 8
      \\minimum 0.0
     \\units m2/s
  N18,\\field Moisture Content 9
      \\minimum 0.0
     \\units kg/m3
  N19,\\field Liquid Transport Coefficient 9
      \\minimum 0.0
     \\units m2/s
  N20,\\field Moisture Content 10
      \\minimum 0.0
     \\units kg/m3
  N21,\\field Liquid Transport Coefficient 10
      \\minimum 0.0
     \\units m2/s
  N22,\\field Moisture Content 11
      \\minimum 0.0
     \\units kg/m3
  N23,\\field Liquid Transport Coefficient 11
      \\minimum 0.0
     \\units m2/s
  N24,\\field Moisture Content 12
      \\minimum 0.0
     \\units kg/m3
  N25,\\field Liquid Transport Coefficient 12
      \\minimum 0.0
     \\units m2/s
  N26,\\field Moisture Content 13
      \\minimum 0.0
     \\units kg/m3
  N27,\\field Liquid Transport Coefficient 13
      \\minimum 0.0
     \\units m2/s
  N28,\\field Moisture Content 14
      \\minimum 0.0
     \\units kg/m3
  N29,\\field Liquid Transport Coefficient 14
      \\minimum 0.0
     \\units m2/s
  N30,\\field Moisture Content 15
      \\minimum 0.0
     \\units kg/m3
  N31,\\field Liquid Transport Coefficient 15
      \\minimum 0.0
     \\units m2/s
  N32,\\field Moisture Content 16
      \\minimum 0.0
     \\units kg/m3
  N33,\\field Liquid Transport Coefficient 16
      \\minimum 0.0
     \\units m2/s
  N34,\\field Moisture Content 17
      \\minimum 0.0
     \\units kg/m3
  N35,\\field Liquid Transport Coefficient 17
      \\minimum 0.0
     \\units m2/s
  N36,\\field Moisture Content 18
      \\minimum 0.0
     \\units kg/m3
  N37,\\field Liquid Transport Coefficient 18
      \\minimum 0.0
     \\units m2/s
  N38,\\field Moisture Content 19
      \\minimum 0.0
     \\units kg/m3
  N39,\\field Liquid Transport Coefficient 19
      \\minimum 0.0
     \\units m2/s
  N40,\\field Moisture Content 20
      \\minimum 0.0
     \\units kg/m3
  N41,\\field Liquid Transport Coefficient 20
      \\minimum 0.0
     \\units m2/s
  N42,\\field Moisture Content 21
      \\minimum 0.0
     \\units kg/m3
  N43,\\field Liquid Transport Coefficient 21
      \\minimum 0.0
     \\units m2/s
  N44,\\field Moisture Content 22
      \\minimum 0.0
     \\units kg/m3
  N45,\\field Liquid Transport Coefficient 22
      \\minimum 0.0
     \\units m2/s
  N46,\\field Moisture Content 23
      \\minimum 0.0
     \\units kg/m3
  N47,\\field Liquid Transport Coefficient 23
      \\minimum 0.0
     \\units m2/s
  N48,\\field Moisture Content 24
      \\minimum 0.0
     \\units kg/m3
  N49,\\field Liquid Transport Coefficient 24
      \\minimum 0.0
     \\units m2/s
  N50,\\field Moisture Content 25
      \\minimum 0.0
     \\units kg/m3
  N51;\\field Liquid Transport Coefficient 25
      \\minimum 0.0
     \\units m2/s

MaterialProperty:HeatAndMoistureTransfer:Redistribution,
    \\memo HeatBalanceAlgorithm = CombinedHeatAndMoistureFiniteElement solution algorithm only.
    \\memo Relationship between liquid transport coefficient and moisture content
    \\memo Has no effect with other HeatBalanceAlgorithm solution algorithms
  A1 , \\field Material Name
       \\required-field
       \\type object-list
       \\object-list MaterialName
       \\note Moisture Material Name that the moisture properties will be added to.
  N1,  \\field Number of Redistribution points
       \\required-field
       \\note number of data points
       \\minimum 1
       \\maximum 25
       \\type integer
  N2,\\field Moisture Content 1
     \\minimum 0.0
     \\required-field
     \\units kg/m3
  N3,\\field Liquid Transport Coefficient 1
     \\minimum 0.0
     \\required-field
     \\units m2/s
  N4,\\field Moisture Content 2
      \\minimum 0.0
     \\units kg/m3
  N5,\\field Liquid Transport Coefficient 2
      \\minimum 0.0
     \\units m2/s
  N6,\\field Moisture Content 3
      \\minimum 0.0
     \\units kg/m3
  N7,\\field Liquid Transport Coefficient 3
      \\minimum 0.0
     \\units m2/s
  N8,\\field Moisture Content 4
      \\minimum 0.0
     \\units kg/m3
  N9,\\field Liquid Transport Coefficient 4
      \\minimum 0.0
     \\units m2/s
  N10,\\field Moisture Content 5
      \\minimum 0.0
     \\units kg/m3
  N11,\\field Liquid Transport Coefficient 5
      \\minimum 0.0
     \\units m2/s
  N12,\\field Moisture Content 6
      \\minimum 0.0
     \\units kg/m3
  N13,\\field Liquid Transport Coefficient 6
      \\minimum 0.0
     \\units m2/s
  N14,\\field Moisture Content 7
      \\minimum 0.0
     \\units kg/m3
  N15,\\field Liquid Transport Coefficient 7
      \\minimum 0.0
     \\units m2/s
  N16,\\field Moisture Content 8
      \\minimum 0.0
     \\units kg/m3
  N17,\\field Liquid Transport Coefficient 8
      \\minimum 0.0
     \\units m2/s
  N18,\\field Moisture Content 9
      \\minimum 0.0
     \\units kg/m3
  N19,\\field Liquid Transport Coefficient 9
      \\minimum 0.0
     \\units m2/s
  N20,\\field Moisture Content 10
      \\minimum 0.0
     \\units kg/m3
  N21,\\field Liquid Transport Coefficient 10
      \\minimum 0.0
     \\units m2/s
  N22,\\field Moisture Content 11
      \\minimum 0.0
     \\units kg/m3
  N23,\\field Liquid Transport Coefficient 11
      \\minimum 0.0
     \\units m2/s
  N24,\\field Moisture Content 12
      \\minimum 0.0
     \\units kg/m3
  N25,\\field Liquid Transport Coefficient 12
      \\minimum 0.0
     \\units m2/s
  N26,\\field Moisture Content 13
      \\minimum 0.0
     \\units kg/m3
  N27,\\field Liquid Transport Coefficient 13
      \\minimum 0.0
     \\units m2/s
  N28,\\field Moisture Content 14
      \\minimum 0.0
     \\units kg/m3
  N29,\\field Liquid Transport Coefficient 14
      \\minimum 0.0
     \\units m2/s
  N30,\\field Moisture Content 15
      \\minimum 0.0
     \\units kg/m3
  N31,\\field Liquid Transport Coefficient 15
      \\minimum 0.0
     \\units m2/s
  N32,\\field Moisture Content 16
      \\minimum 0.0
     \\units kg/m3
  N33,\\field Liquid Transport Coefficient 16
      \\minimum 0.0
     \\units m2/s
  N34,\\field Moisture Content 17
      \\minimum 0.0
     \\units kg/m3
  N35,\\field Liquid Transport Coefficient 17
      \\minimum 0.0
     \\units m2/s
  N36,\\field Moisture Content 18
      \\minimum 0.0
     \\units kg/m3
  N37,\\field Liquid Transport Coefficient 18
      \\minimum 0.0
     \\units m2/s
  N38,\\field Moisture Content 19
      \\minimum 0.0
     \\units kg/m3
  N39,\\field Liquid Transport Coefficient 19
      \\minimum 0.0
     \\units m2/s
  N40,\\field Moisture Content 20
      \\minimum 0.0
     \\units kg/m3
  N41,\\field Liquid Transport Coefficient 20
      \\minimum 0.0
     \\units m2/s
  N42,\\field Moisture Content 21
      \\minimum 0.0
     \\units kg/m3
  N43,\\field Liquid Transport Coefficient 21
      \\minimum 0.0
     \\units m2/s
  N44,\\field Moisture Content 22
      \\minimum 0.0
     \\units kg/m3
  N45,\\field Liquid Transport Coefficient 22
      \\minimum 0.0
     \\units m2/s
  N46,\\field Moisture Content 23
      \\minimum 0.0
     \\units kg/m3
  N47,\\field Liquid Transport Coefficient 23
      \\minimum 0.0
     \\units m2/s
  N48,\\field Moisture Content 24
      \\minimum 0.0
     \\units kg/m3
  N49,\\field Liquid Transport Coefficient 24
      \\minimum 0.0
     \\units m2/s
  N50,\\field Moisture Content 25
      \\minimum 0.0
     \\units kg/m3
  N51;\\field Liquid Transport Coefficient 25
      \\minimum 0.0
     \\units m2/s

MaterialProperty:HeatAndMoistureTransfer:Diffusion,
    \\memo HeatBalanceAlgorithm = CombinedHeatAndMoistureFiniteElement solution algorithm only.
    \\memo Relationship between water vapor diffusion and relative humidity fraction
    \\memo Has no effect with other HeatBalanceAlgorithm solution algorithms
  A1 , \\field Material Name
       \\required-field
       \\type object-list
       \\object-list MaterialName
       \\note Moisture Material Name that the moisture properties will be added to.
  N1,  \\field Number of Data Pairs
       \\required-field
       \\note Water Vapor Diffusion Resistance Factor
       \\minimum 1
       \\maximum 25
       \\type integer
  N2, \\field Relative Humidity Fraction 1
      \\required-field
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N3,\\field Water Vapor Diffusion Resistance Factor 1
      \\required-field
      \\minimum 0.0
      \\units dimensionless
  N4, \\field Relative Humidity Fraction 2
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N5,\\field Water Vapor Diffusion Resistance Factor 2
      \\minimum 0.0
      \\units dimensionless
  N6, \\field Relative Humidity Fraction 3
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N7,\\field Water Vapor Diffusion Resistance Factor 3
      \\minimum 0.0
      \\units dimensionless
  N8, \\field Relative Humidity Fraction 4
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N9,\\field Water Vapor Diffusion Resistance Factor 4
      \\minimum 0.0
      \\units dimensionless
  N10, \\field Relative Humidity Fraction 5
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N11,\\field Water Vapor Diffusion Resistance Factor 5
      \\minimum 0.0
      \\units dimensionless
  N12,\\field Relative Humidity Fraction 6
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N13,\\field Water Vapor Diffusion Resistance Factor 6
      \\minimum 0.0
      \\units dimensionless
  N14,\\field Relative Humidity Fraction 7
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N15,\\field Water Vapor Diffusion Resistance Factor 7
      \\minimum 0.0
      \\units dimensionless
  N16,\\field Relative Humidity Fraction 8
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N17,\\field Water Vapor Diffusion Resistance Factor 8
      \\minimum 0.0
      \\units dimensionless
  N18,\\field Relative Humidity Fraction 9
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N19,\\field Water Vapor Diffusion Resistance Factor 9
      \\minimum 0.0
      \\units dimensionless
  N20,\\field Relative Humidity Fraction 10
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N21,\\field Water Vapor Diffusion Resistance Factor 10
      \\minimum 0.0
      \\units dimensionless
  N22,\\field Relative Humidity Fraction 11
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N23,\\field Water Vapor Diffusion Resistance Factor 11
      \\minimum 0.0
      \\units dimensionless
 N24,\\field Relative Humidity Fraction 12
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N25,\\field Water Vapor Diffusion Resistance Factor 12
      \\minimum 0.0
      \\units dimensionless
  N26,\\field Relative Humidity Fraction 13
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N27,\\field Water Vapor Diffusion Resistance Factor 13
      \\minimum 0.0
      \\units dimensionless
  N28,\\field Relative Humidity Fraction 14
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N29,\\field Water Vapor Diffusion Resistance Factor 14
      \\minimum 0.0
      \\units dimensionless
  N30,\\field Relative Humidity Fraction 15
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N31,\\field Water Vapor Diffusion Resistance Factor 15
      \\minimum 0.0
      \\units dimensionless
  N32,\\field Relative Humidity Fraction 16
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N33,\\field Water Vapor Diffusion Resistance Factor 16
      \\minimum 0.0
      \\units dimensionless
  N34,\\field Relative Humidity Fraction 17
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N35,\\field Water Vapor Diffusion Resistance Factor 17
      \\minimum 0.0
      \\units dimensionless
  N36,\\field Relative Humidity Fraction 18
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N37,\\field Water Vapor Diffusion Resistance Factor 18
      \\minimum 0.0
      \\units dimensionless
  N38,\\field Relative Humidity Fraction 19
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N39,\\field Water Vapor Diffusion Resistance Factor 19
      \\minimum 0.0
      \\units dimensionless
  N40,\\field Relative Humidity Fraction 20
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N41,\\field Water Vapor Diffusion Resistance Factor 20
      \\minimum 0.0
      \\units dimensionless
  N42,\\field Relative Humidity Fraction 21
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N43,\\field Water Vapor Diffusion Resistance Factor 21
      \\minimum 0.0
      \\units dimensionless
  N44,\\field Relative Humidity Fraction 22
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N45,\\field Water Vapor Diffusion Resistance Factor 22
      \\minimum 0.0
      \\units dimensionless
  N46,\\field Relative Humidity Fraction 23
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N47,\\field Water Vapor Diffusion Resistance Factor 23
      \\minimum 0.0
      \\units dimensionless
  N48,\\field Relative Humidity Fraction 24
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N49,\\field Water Vapor Diffusion Resistance Factor 24
      \\minimum 0.0
      \\units dimensionless
  N50,\\field Relative Humidity Fraction 25
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N51;\\field Water Vapor Diffusion Resistance Factor 25
      \\minimum 0.0
      \\units dimensionless

MaterialProperty:HeatAndMoistureTransfer:ThermalConductivity,
    \\memo HeatBalanceAlgorithm = CombinedHeatAndMoistureFiniteElement solution algorithm only.
    \\memo Relationship between thermal conductivity and moisture content
    \\memo Has no effect with other HeatBalanceAlgorithm solution algorithms
  A1 , \\field Material Name
       \\required-field
       \\type object-list
       \\object-list MaterialName
       \\note Moisture Material Name that the Thermal Conductivity will be added to.
  N1,  \\field Number of Thermal Coordinates
       \\required-field
       \\note number of data coordinates
       \\minimum 1
       \\maximum 25
       \\type integer
  N2, \\field Moisture Content 1
      \\required-field
      \\minimum 0.0
      \\units kg/m3
  N3, \\field Thermal Conductivity 1
      \\required-field
      \\minimum> 0.0
      \\units W/m-K
  N4, \\field Moisture Content 2
      \\minimum 0.0
      \\units kg/m3
  N5, \\field Thermal Conductivity 2
      \\minimum> 0.0
      \\units W/m-K
  N6, \\field Moisture Content 3
      \\minimum 0.0
      \\units kg/m3
  N7, \\field Thermal Conductivity 3
      \\minimum> 0.0
      \\units W/m-K
  N8, \\field Moisture Content 4
      \\minimum 0.0
      \\units kg/m3
  N9, \\field Thermal Conductivity 4
      \\minimum> 0.0
      \\units W/m-K
  N10, \\field Moisture Content 5
      \\minimum 0.0
      \\units kg/m3
  N11,\\field Thermal Conductivity 5
      \\minimum> 0.0
      \\units W/m-K
  N12, \\field Moisture Content 6
      \\minimum 0.0
      \\units kg/m3
  N13,\\field Thermal Conductivity 6
      \\minimum> 0.0
      \\units W/m-K
  N14,\\field Moisture Content 7
      \\minimum 0.0
      \\units kg/m3
  N15,\\field Thermal Conductivity 7
      \\minimum> 0.0
      \\units W/m-K
  N16,\\field Moisture Content 8
      \\minimum 0.0
      \\units kg/m3
  N17,\\field Thermal Conductivity 8
      \\minimum> 0.0
      \\units W/m-K
  N18,\\field Moisture Content 9
      \\minimum 0.0
      \\units kg/m3
  N19,\\field Thermal Conductivity 9
      \\minimum> 0.0
      \\units W/m-K
  N20,\\field Moisture Content 10
      \\minimum 0.0
      \\units kg/m3
  N21,\\field Thermal Conductivity 10
      \\minimum> 0.0
      \\units W/m-K
  N22,\\field Moisture Content 11
      \\minimum 0.0
      \\units kg/m3
  N23,\\field Thermal Conductivity 11
      \\minimum> 0.0
      \\units W/m-K
  N24,\\field Moisture Content 12
      \\minimum 0.0
      \\units kg/m3
  N25,\\field Thermal Conductivity 12
      \\minimum> 0.0
      \\units W/m-K
  N26,\\field Moisture Content 13
      \\minimum 0.0
      \\units kg/m3
  N27,\\field Thermal Conductivity 13
      \\minimum> 0.0
      \\units W/m-K
  N28,\\field Moisture Content 14
      \\minimum 0.0
      \\units kg/m3
  N29,\\field Thermal Conductivity 14
      \\minimum> 0.0
      \\units W/m-K
  N30,\\field Moisture Content 15
      \\minimum 0.0
      \\units kg/m3
  N31,\\field Thermal Conductivity 15
      \\minimum> 0.0
      \\units W/m-K
  N32,\\field Moisture Content 16
      \\minimum 0.0
      \\units kg/m3
  N33,\\field Thermal Conductivity 16
      \\minimum> 0.0
      \\units W/m-K
  N34,\\field Moisture Content 17
      \\minimum 0.0
      \\units kg/m3
  N35,\\field Thermal Conductivity 17
      \\minimum> 0.0
      \\units W/m-K
  N36,\\field Moisture Content 18
      \\minimum 0.0
      \\units kg/m3
  N37,\\field Thermal Conductivity 18
      \\minimum> 0.0
      \\units W/m-K
  N38,\\field Moisture Content 19
      \\minimum 0.0
      \\units kg/m3
  N39,\\field Thermal Conductivity 19
      \\minimum> 0.0
      \\units W/m-K
  N40,\\field Moisture Content 20
      \\minimum 0.0
      \\units kg/m3
  N41,\\field Thermal Conductivity 20
      \\minimum> 0.0
      \\units W/m-K
  N42,\\field Moisture Content 21
      \\minimum 0.0
      \\units kg/m3
  N43,\\field Thermal Conductivity 21
      \\minimum> 0.0
      \\units W/m-K
  N44,\\field Moisture Content 22
      \\minimum 0.0
      \\units kg/m3
  N45,\\field Thermal Conductivity 22
      \\minimum> 0.0
      \\units W/m-K
  N46,\\field Moisture Content 23
      \\minimum 0.0
      \\units kg/m3
  N47,\\field Thermal Conductivity 23
      \\minimum> 0.0
      \\units W/m-K
  N48,\\field Moisture Content 24
      \\minimum 0.0
      \\units kg/m3
  N49,\\field Thermal Conductivity 24
      \\minimum> 0.0
      \\units W/m-K
  N50,\\field Moisture Content 25
      \\minimum 0.0
      \\units kg/m3
  N51;\\field Thermal Conductivity 25
      \\minimum> 0.0
      \\units W/m-K

MaterialProperty:GlazingSpectralData,
       \\memo Name is followed by up to 800 sets of normal-incidence measured values of
       \\memo [wavelength, transmittance, front reflectance, back reflectance] for wavelengths
       \\memo covering the solar spectrum (from about 0.25 to 2.5 microns)
       \\format Spectral
  A1,  \\field Name
       \\required-field
       \\reference SpectralDataSets
  N1,N2,N3,N4,         N5,N6,N7,N8,         N9,N10,N11,N12,      N13,N14,N15,N16,     N17,N18,N19,N20, \\note fields as indicated
  N21,N22,N23,N24,     N25,N26,N27,N28,     N29,N30,N31,N32,     N33,N34,N35,N36,     N37,N38,N39,N40, \\note fields as indicated
  N41,N42,N43,N44,     N45,N46,N47,N48,     N49,N50,N51,N52,     N53,N54,N55,N56,     N57,N58,N59,N60, \\note fields as indicated
  N61,N62,N63,N64,     N65,N66,N67,N68,     N69,N70,N71,N72,     N73,N74,N75,N76,     N77,N78,N79,N80, \\note fields as indicated
  N81,N82,N83,N84,     N85,N86,N87,N88,     N89,N90,N91,N92,     N93,N94,N95,N96,     N97,N98,N99,N100, \\note fields as indicated

  N101,N102,N103,N104, N105,N106,N107,N108, N109,N110,N111,N112, N113,N114,N115,N116, N117,N118,N119,N120, \\note fields as indicated
  N121,N122,N123,N124, N125,N126,N127,N128, N129,N130,N131,N132, N133,N134,N135,N136, N137,N138,N139,N140, \\note fields as indicated
  N141,N142,N143,N144, N145,N146,N147,N148, N149,N150,N151,N152, N153,N154,N155,N156, N157,N158,N159,N160, \\note fields as indicated
  N161,N162,N163,N164, N165,N166,N167,N168, N169,N170,N171,N172, N173,N174,N175,N176, N177,N178,N179,N180, \\note fields as indicated
  N181,N182,N183,N184, N185,N186,N187,N188, N189,N190,N191,N192, N193,N194,N195,N196, N197,N198,N199,N200, \\note fields as indicated

  N201,N202,N203,N204, N205,N206,N207,N208, N209,N210,N211,N212, N213,N214,N215,N216, N217,N218,N219,N220, \\note fields as indicated
  N221,N222,N223,N224, N225,N226,N227,N228, N229,N230,N231,N232, N233,N234,N235,N236, N237,N238,N239,N240, \\note fields as indicated
  N241,N242,N243,N244, N245,N246,N247,N248, N249,N250,N251,N252, N253,N254,N255,N256, N257,N258,N259,N260, \\note fields as indicated
  N261,N262,N263,N264, N265,N266,N267,N268, N269,N270,N271,N272, N273,N274,N275,N276, N277,N278,N279,N280, \\note fields as indicated
  N281,N282,N283,N284, N285,N286,N287,N288, N289,N290,N291,N292, N293,N294,N295,N296, N297,N298,N299,N300, \\note fields as indicated

  N301,N302,N303,N304, N305,N306,N307,N308, N309,N310,N311,N312, N313,N314,N315,N316, N317,N318,N319,N320, \\note fields as indicated
  N321,N322,N323,N324, N325,N326,N327,N328, N329,N330,N331,N332, N333,N334,N335,N336, N337,N338,N339,N340, \\note fields as indicated
  N341,N342,N343,N344, N345,N346,N347,N348, N349,N350,N351,N352, N353,N354,N355,N356, N357,N358,N359,N360, \\note fields as indicated
  N361,N362,N363,N364, N365,N366,N367,N368, N369,N370,N371,N372, N373,N374,N375,N376, N377,N378,N379,N380, \\note fields as indicated
  N381,N382,N383,N384, N385,N386,N387,N388, N389,N390,N391,N392, N393,N394,N395,N396, N397,N398,N399,N400, \\note fields as indicated

  N401,N402,N403,N404, N405,N406,N407,N408, N409,N410,N411,N412, N413,N414,N415,N416, N417,N418,N419,N420, \\note fields as indicated
  N421,N422,N423,N424, N425,N426,N427,N428, N429,N430,N431,N432, N433,N434,N435,N436, N437,N438,N439,N440, \\note fields as indicated
  N441,N442,N443,N444, N445,N446,N447,N448, N449,N450,N451,N452, N453,N454,N455,N456, N457,N458,N459,N460, \\note fields as indicated
  N461,N462,N463,N464, N465,N466,N467,N468, N469,N470,N471,N472, N473,N474,N475,N476, N477,N478,N479,N480, \\note fields as indicated
  N481,N482,N483,N484, N485,N486,N487,N488, N489,N490,N491,N492, N493,N494,N495,N496, N497,N498,N499,N500, \\note fields as indicated

  N501,N502,N503,N504, N505,N506,N507,N508, N509,N510,N511,N512, N513,N514,N515,N516, N517,N518,N519,N520, \\note fields as indicated
  N521,N522,N523,N524, N525,N526,N527,N528, N529,N530,N531,N532, N533,N534,N535,N536, N537,N538,N539,N540, \\note fields as indicated
  N541,N542,N543,N544, N545,N546,N547,N548, N549,N550,N551,N552, N553,N554,N555,N556, N557,N558,N559,N560, \\note fields as indicated
  N561,N562,N563,N564, N565,N566,N567,N568, N569,N570,N571,N572, N573,N574,N575,N576, N577,N578,N579,N580, \\note fields as indicated
  N581,N582,N583,N584, N585,N586,N587,N588, N589,N590,N591,N592, N593,N594,N595,N596, N597,N598,N599,N600, \\note fields as indicated

  N601,N602,N603,N604, N605,N606,N607,N608, N609,N610,N611,N612, N613,N614,N615,N616, N617,N618,N619,N620, \\note fields as indicated
  N621,N622,N623,N624, N625,N626,N627,N628, N629,N630,N631,N632, N633,N634,N635,N636, N637,N638,N639,N640, \\note fields as indicated
  N641,N642,N643,N644, N645,N646,N647,N648, N649,N650,N651,N652, N653,N654,N655,N656, N657,N658,N659,N660, \\note fields as indicated
  N661,N662,N663,N664, N665,N666,N667,N668, N669,N670,N671,N672, N673,N674,N675,N676, N677,N678,N679,N680, \\note fields as indicated
  N681,N682,N683,N684, N685,N686,N687,N688, N689,N690,N691,N692, N693,N694,N695,N696, N697,N698,N699,N700, \\note fields as indicated

  N701,N702,N703,N704, N705,N706,N707,N708, N709,N710,N711,N712, N713,N714,N715,N716, N717,N718,N719,N720, \\note fields as indicated
  N721,N722,N723,N724, N725,N726,N727,N728, N729,N730,N731,N732, N733,N734,N735,N736, N737,N738,N739,N740, \\note fields as indicated
  N741,N742,N743,N744, N745,N746,N747,N748, N749,N750,N751,N752, N753,N754,N755,N756, N757,N758,N759,N760, \\note fields as indicated
  N761,N762,N763,N764, N765,N766,N767,N768, N769,N770,N771,N772, N773,N774,N775,N776, N777,N778,N779,N780, \\note fields as indicated
  N781,N782,N783,N784, N785,N786,N787,N788, N789,N790,N791,N792, N793,N794,N795,N796, N797,N798,N799,N800, \\note fields as indicated

  N801,N802,N803,N804, N805,N806,N807,N808, N809,N810,N811,N812, N813,N814,N815,N816, N817,N818,N819,N820, \\note fields as indicated
  N821,N822,N823,N824, N825,N826,N827,N828, N829,N830,N831,N832, N833,N834,N835,N836, N837,N838,N839,N840, \\note fields as indicated
  N841,N842,N843,N844, N845,N846,N847,N848, N849,N850,N851,N852, N853,N854,N855,N856, N857,N858,N859,N860, \\note fields as indicated
  N861,N862,N863,N864, N865,N866,N867,N868, N869,N870,N871,N872, N873,N874,N875,N876, N877,N878,N879,N880, \\note fields as indicated
  N881,N882,N883,N884, N885,N886,N887,N888, N889,N890,N891,N892, N893,N894,N895,N896, N897,N898,N899,N900, \\note fields as indicated

  N901,N902,N903,N904, N905,N906,N907,N908, N909,N910,N911,N912, N913,N914,N915,N916, N917,N918,N919,N920, \\note fields as indicated
  N921,N922,N923,N924, N925,N926,N927,N928, N929,N930,N931,N932, N933,N934,N935,N936, N937,N938,N939,N940, \\note fields as indicated
  N941,N942,N943,N944, N945,N946,N947,N948, N949,N950,N951,N952, N953,N954,N955,N956, N957,N958,N959,N960, \\note fields as indicated
  N961,N962,N963,N964, N965,N966,N967,N968, N969,N970,N971,N972, N973,N974,N975,N976, N977,N978,N979,N980, \\note fields as indicated
  N981,N982,N983,N984, N985,N986,N987,N988, N989,N990,N991,N992, N993,N994,N995,N996, N997,N998,N999,N1000, \\note fields as indicated

  N1001,N1002,N1003,N1004, N1005,N1006,N1007,N1008, N1009,N1010,N1011,N1012, N1013,N1014,N1015,N1016, N1017,N1018,N1019,N1020, \\note fields as indicated
  N1021,N1022,N1023,N1024, N1025,N1026,N1027,N1028, N1029,N1030,N1031,N1032, N1033,N1034,N1035,N1036, N1037,N1038,N1039,N1040, \\note fields as indicated
  N1041,N1042,N1043,N1044, N1045,N1046,N1047,N1048, N1049,N1050,N1051,N1052, N1053,N1054,N1055,N1056, N1057,N1058,N1059,N1060, \\note fields as indicated
  N1061,N1062,N1063,N1064, N1065,N1066,N1067,N1068, N1069,N1070,N1071,N1072, N1073,N1074,N1075,N1076, N1077,N1078,N1079,N1080, \\note fields as indicated
  N1081,N1082,N1083,N1084, N1085,N1086,N1087,N1088, N1089,N1090,N1091,N1092, N1093,N1094,N1095,N1096, N1097,N1098,N1099,N1100, \\note fields as indicated

  N1101,N1102,N1103,N1104, N1105,N1106,N1107,N1108, N1109,N1110,N1111,N1112, N1113,N1114,N1115,N1116, N1117,N1118,N1119,N1120, \\note fields as indicated
  N1121,N1122,N1123,N1124, N1125,N1126,N1127,N1128, N1129,N1130,N1131,N1132, N1133,N1134,N1135,N1136, N1137,N1138,N1139,N1140, \\note fields as indicated
  N1141,N1142,N1143,N1144, N1145,N1146,N1147,N1148, N1149,N1150,N1151,N1152, N1153,N1154,N1155,N1156, N1157,N1158,N1159,N1160, \\note fields as indicated
  N1161,N1162,N1163,N1164, N1165,N1166,N1167,N1168, N1169,N1170,N1171,N1172, N1173,N1174,N1175,N1176, N1177,N1178,N1179,N1180, \\note fields as indicated
  N1181,N1182,N1183,N1184, N1185,N1186,N1187,N1188, N1189,N1190,N1191,N1192, N1193,N1194,N1195,N1196, N1197,N1198,N1199,N1200, \\note fields as indicated

  N1201,N1202,N1203,N1204, N1205,N1206,N1207,N1208, N1209,N1210,N1211,N1212, N1213,N1214,N1215,N1216, N1217,N1218,N1219,N1220, \\note fields as indicated
  N1221,N1222,N1223,N1224, N1225,N1226,N1227,N1228, N1229,N1230,N1231,N1232, N1233,N1234,N1235,N1236, N1237,N1238,N1239,N1240, \\note fields as indicated
  N1241,N1242,N1243,N1244, N1245,N1246,N1247,N1248, N1249,N1250,N1251,N1252, N1253,N1254,N1255,N1256, N1257,N1258,N1259,N1260, \\note fields as indicated
  N1261,N1262,N1263,N1264, N1265,N1266,N1267,N1268, N1269,N1270,N1271,N1272, N1273,N1274,N1275,N1276, N1277,N1278,N1279,N1280, \\note fields as indicated
  N1281,N1282,N1283,N1284, N1285,N1286,N1287,N1288, N1289,N1290,N1291,N1292, N1293,N1294,N1295,N1296, N1297,N1298,N1299,N1300, \\note fields as indicated

  N1301,N1302,N1303,N1304, N1305,N1306,N1307,N1308, N1309,N1310,N1311,N1312, N1313,N1314,N1315,N1316, N1317,N1318,N1319,N1320, \\note fields as indicated
  N1321,N1322,N1323,N1324, N1325,N1326,N1327,N1328, N1329,N1330,N1331,N1332, N1333,N1334,N1335,N1336, N1337,N1338,N1339,N1340, \\note fields as indicated
  N1341,N1342,N1343,N1344, N1345,N1346,N1347,N1348, N1349,N1350,N1351,N1352, N1353,N1354,N1355,N1356, N1357,N1358,N1359,N1360, \\note fields as indicated
  N1361,N1362,N1363,N1364, N1365,N1366,N1367,N1368, N1369,N1370,N1371,N1372, N1373,N1374,N1375,N1376, N1377,N1378,N1379,N1380, \\note fields as indicated
  N1381,N1382,N1383,N1384, N1385,N1386,N1387,N1388, N1389,N1390,N1391,N1392, N1393,N1394,N1395,N1396, N1397,N1398,N1399,N1400, \\note fields as indicated

  N1401,N1402,N1403,N1404, N1405,N1406,N1407,N1408, N1409,N1410,N1411,N1412, N1413,N1414,N1415,N1416, N1417,N1418,N1419,N1420, \\note fields as indicated
  N1421,N1422,N1423,N1424, N1425,N1426,N1427,N1428, N1429,N1430,N1431,N1432, N1433,N1434,N1435,N1436, N1437,N1438,N1439,N1440, \\note fields as indicated
  N1441,N1442,N1443,N1444, N1445,N1446,N1447,N1448, N1449,N1450,N1451,N1452, N1453,N1454,N1455,N1456, N1457,N1458,N1459,N1460, \\note fields as indicated
  N1461,N1462,N1463,N1464, N1465,N1466,N1467,N1468, N1469,N1470,N1471,N1472, N1473,N1474,N1475,N1476, N1477,N1478,N1479,N1480, \\note fields as indicated
  N1481,N1482,N1483,N1484, N1485,N1486,N1487,N1488, N1489,N1490,N1491,N1492, N1493,N1494,N1495,N1496, N1497,N1498,N1499,N1500, \\note fields as indicated

  N1501,N1502,N1503,N1504, N1505,N1506,N1507,N1508, N1509,N1510,N1511,N1512, N1513,N1514,N1515,N1516, N1517,N1518,N1519,N1520, \\note fields as indicated
  N1521,N1522,N1523,N1524, N1525,N1526,N1527,N1528, N1529,N1530,N1531,N1532, N1533,N1534,N1535,N1536, N1537,N1538,N1539,N1540, \\note fields as indicated
  N1541,N1542,N1543,N1544, N1545,N1546,N1547,N1548, N1549,N1550,N1551,N1552, N1553,N1554,N1555,N1556, N1557,N1558,N1559,N1560, \\note fields as indicated
  N1561,N1562,N1563,N1564, N1565,N1566,N1567,N1568, N1569,N1570,N1571,N1572, N1573,N1574,N1575,N1576, N1577,N1578,N1579,N1580, \\note fields as indicated
  N1581,N1582,N1583,N1584, N1585,N1586,N1587,N1588, N1589,N1590,N1591,N1592, N1593,N1594,N1595,N1596, N1597,N1598,N1599,N1600, \\note fields as indicated

  N1601,N1602,N1603,N1604, N1605,N1606,N1607,N1608, N1609,N1610,N1611,N1612, N1613,N1614,N1615,N1616, N1617,N1618,N1619,N1620, \\note fields as indicated
  N1621,N1622,N1623,N1624, N1625,N1626,N1627,N1628, N1629,N1630,N1631,N1632, N1633,N1634,N1635,N1636, N1637,N1638,N1639,N1640, \\note fields as indicated
  N1641,N1642,N1643,N1644, N1645,N1646,N1647,N1648, N1649,N1650,N1651,N1652, N1653,N1654,N1655,N1656, N1657,N1658,N1659,N1660, \\note fields as indicated
  N1661,N1662,N1663,N1664, N1665,N1666,N1667,N1668, N1669,N1670,N1671,N1672, N1673,N1674,N1675,N1676, N1677,N1678,N1679,N1680, \\note fields as indicated
  N1681,N1682,N1683,N1684, N1685,N1686,N1687,N1688, N1689,N1690,N1691,N1692, N1693,N1694,N1695,N1696, N1697,N1698,N1699,N1700, \\note fields as indicated

  N1701,N1702,N1703,N1704, N1705,N1706,N1707,N1708, N1709,N1710,N1711,N1712, N1713,N1714,N1715,N1716, N1717,N1718,N1719,N1720, \\note fields as indicated
  N1721,N1722,N1723,N1724, N1725,N1726,N1727,N1728, N1729,N1730,N1731,N1732, N1733,N1734,N1735,N1736, N1737,N1738,N1739,N1740, \\note fields as indicated
  N1741,N1742,N1743,N1744, N1745,N1746,N1747,N1748, N1749,N1750,N1751,N1752, N1753,N1754,N1755,N1756, N1757,N1758,N1759,N1760, \\note fields as indicated
  N1761,N1762,N1763,N1764, N1765,N1766,N1767,N1768, N1769,N1770,N1771,N1772, N1773,N1774,N1775,N1776, N1777,N1778,N1779,N1780, \\note fields as indicated
  N1781,N1782,N1783,N1784, N1785,N1786,N1787,N1788, N1789,N1790,N1791,N1792, N1793,N1794,N1795,N1796, N1797,N1798,N1799,N1800, \\note fields as indicated

  N1801,N1802,N1803,N1804, N1805,N1806,N1807,N1808, N1809,N1810,N1811,N1812, N1813,N1814,N1815,N1816, N1817,N1818,N1819,N1820,  \\note fields as indicated
  N1821,N1822,N1823,N1824, N1825,N1826,N1827,N1828, N1829,N1830,N1831,N1832, N1833,N1834,N1835,N1836, N1837,N1838,N1839,N1840,  \\note fields as indicated
  N1841,N1842,N1843,N1844, N1845,N1846,N1847,N1848, N1849,N1850,N1851,N1852, N1853,N1854,N1855,N1856, N1857,N1858,N1859,N1860,  \\note fields as indicated
  N1861,N1862,N1863,N1864, N1865,N1866,N1867,N1868, N1869,N1870,N1871,N1872, N1873,N1874,N1875,N1876, N1877,N1878,N1879,N1880,  \\note fields as indicated
  N1881,N1882,N1883,N1884, N1885,N1886,N1887,N1888, N1889,N1890,N1891,N1892, N1893,N1894,N1895,N1896, N1897,N1898,N1899,N1900,  \\note fields as indicated

  N1901,N1902,N1903,N1904, N1905,N1906,N1907,N1908, N1909,N1910,N1911,N1912, N1913,N1914,N1915,N1916, N1917,N1918,N1919,N1920,  \\note fields as indicated
  N1921,N1922,N1923,N1924, N1925,N1926,N1927,N1928, N1929,N1930,N1931,N1932, N1933,N1934,N1935,N1936, N1937,N1938,N1939,N1940,  \\note fields as indicated
  N1941,N1942,N1943,N1944, N1945,N1946,N1947,N1948, N1949,N1950,N1951,N1952, N1953,N1954,N1955,N1956, N1957,N1958,N1959,N1960,  \\note fields as indicated
  N1961,N1962,N1963,N1964, N1965,N1966,N1967,N1968, N1969,N1970,N1971,N1972, N1973,N1974,N1975,N1976, N1977,N1978,N1979,N1980,  \\note fields as indicated
  N1981,N1982,N1983,N1984, N1985,N1986,N1987,N1988, N1989,N1990,N1991,N1992, N1993,N1994,N1995,N1996, N1997,N1998,N1999,N2000,  \\note fields as indicated

  N2001,N2002,N2003,N2004, N2005,N2006,N2007,N2008, N2009,N2010,N2011,N2012, N2013,N2014,N2015,N2016, N2017,N2018,N2019,N2020,  \\note fields as indicated
  N2021,N2022,N2023,N2024, N2025,N2026,N2027,N2028, N2029,N2030,N2031,N2032, N2033,N2034,N2035,N2036, N2037,N2038,N2039,N2040,  \\note fields as indicated
  N2041,N2042,N2043,N2044, N2045,N2046,N2047,N2048, N2049,N2050,N2051,N2052, N2053,N2054,N2055,N2056, N2057,N2058,N2059,N2060,  \\note fields as indicated
  N2061,N2062,N2063,N2064, N2065,N2066,N2067,N2068, N2069,N2070,N2071,N2072, N2073,N2074,N2075,N2076, N2077,N2078,N2079,N2080,  \\note fields as indicated
  N2081,N2082,N2083,N2084, N2085,N2086,N2087,N2088, N2089,N2090,N2091,N2092, N2093,N2094,N2095,N2096, N2097,N2098,N2099,N2100,  \\note fields as indicated

  N2101,N2102,N2103,N2104, N2105,N2106,N2107,N2108, N2109,N2110,N2111,N2112, N2113,N2114,N2115,N2116, N2117,N2118,N2119,N2120,  \\note fields as indicated
  N2121,N2122,N2123,N2124, N2125,N2126,N2127,N2128, N2129,N2130,N2131,N2132, N2133,N2134,N2135,N2136, N2137,N2138,N2139,N2140,  \\note fields as indicated
  N2141,N2142,N2143,N2144, N2145,N2146,N2147,N2148, N2149,N2150,N2151,N2152, N2153,N2154,N2155,N2156, N2157,N2158,N2159,N2160,  \\note fields as indicated
  N2161,N2162,N2163,N2164, N2165,N2166,N2167,N2168, N2169,N2170,N2171,N2172, N2173,N2174,N2175,N2176, N2177,N2178,N2179,N2180,  \\note fields as indicated
  N2181,N2182,N2183,N2184, N2185,N2186,N2187,N2188, N2189,N2190,N2191,N2192, N2193,N2194,N2195,N2196, N2197,N2198,N2199,N2200,  \\note fields as indicated

  N2201,N2202,N2203,N2204, N2205,N2206,N2207,N2208, N2209,N2210,N2211,N2212, N2213,N2214,N2215,N2216, N2217,N2218,N2219,N2220,  \\note fields as indicated
  N2221,N2222,N2223,N2224, N2225,N2226,N2227,N2228, N2229,N2230,N2231,N2232, N2233,N2234,N2235,N2236, N2237,N2238,N2239,N2240,  \\note fields as indicated
  N2241,N2242,N2243,N2244, N2245,N2246,N2247,N2248, N2249,N2250,N2251,N2252, N2253,N2254,N2255,N2256, N2257,N2258,N2259,N2260,  \\note fields as indicated
  N2261,N2262,N2263,N2264, N2265,N2266,N2267,N2268, N2269,N2270,N2271,N2272, N2273,N2274,N2275,N2276, N2277,N2278,N2279,N2280,  \\note fields as indicated
  N2281,N2282,N2283,N2284, N2285,N2286,N2287,N2288, N2289,N2290,N2291,N2292, N2293,N2294,N2295,N2296, N2297,N2298,N2299,N2300,  \\note fields as indicated

  N2301,N2302,N2303,N2304, N2305,N2306,N2307,N2308, N2309,N2310,N2311,N2312, N2313,N2314,N2315,N2316, N2317,N2318,N2319,N2320,  \\note fields as indicated
  N2321,N2322,N2323,N2324, N2325,N2326,N2327,N2328, N2329,N2330,N2331,N2332, N2333,N2334,N2335,N2336, N2337,N2338,N2339,N2340,  \\note fields as indicated
  N2341,N2342,N2343,N2344, N2345,N2346,N2347,N2348, N2349,N2350,N2351,N2352, N2353,N2354,N2355,N2356, N2357,N2358,N2359,N2360,  \\note fields as indicated
  N2361,N2362,N2363,N2364, N2365,N2366,N2367,N2368, N2369,N2370,N2371,N2372, N2373,N2374,N2375,N2376, N2377,N2378,N2379,N2380,  \\note fields as indicated
  N2381,N2382,N2383,N2384, N2385,N2386,N2387,N2388, N2389,N2390,N2391,N2392, N2393,N2394,N2395,N2396, N2397,N2398,N2399,N2400,  \\note fields as indicated

  N2401,N2402,N2403,N2404, N2405,N2406,N2407,N2408, N2409,N2410,N2411,N2412, N2413,N2414,N2415,N2416, N2417,N2418,N2419,N2420,  \\note fields as indicated
  N2421,N2422,N2423,N2424, N2425,N2426,N2427,N2428, N2429,N2430,N2431,N2432, N2433,N2434,N2435,N2436, N2437,N2438,N2439,N2440,  \\note fields as indicated
  N2441,N2442,N2443,N2444, N2445,N2446,N2447,N2448, N2449,N2450,N2451,N2452, N2453,N2454,N2455,N2456, N2457,N2458,N2459,N2460,  \\note fields as indicated
  N2461,N2462,N2463,N2464, N2465,N2466,N2467,N2468, N2469,N2470,N2471,N2472, N2473,N2474,N2475,N2476, N2477,N2478,N2479,N2480,  \\note fields as indicated
  N2481,N2482,N2483,N2484, N2485,N2486,N2487,N2488, N2489,N2490,N2491,N2492, N2493,N2494,N2495,N2496, N2497,N2498,N2499,N2500,  \\note fields as indicated

  N2501,N2502,N2503,N2504, N2505,N2506,N2507,N2508, N2509,N2510,N2511,N2512, N2513,N2514,N2515,N2516, N2517,N2518,N2519,N2520,  \\note fields as indicated
  N2521,N2522,N2523,N2524, N2525,N2526,N2527,N2528, N2529,N2530,N2531,N2532, N2533,N2534,N2535,N2536, N2537,N2538,N2539,N2540,  \\note fields as indicated
  N2541,N2542,N2543,N2544, N2545,N2546,N2547,N2548, N2549,N2550,N2551,N2552, N2553,N2554,N2555,N2556, N2557,N2558,N2559,N2560,  \\note fields as indicated
  N2561,N2562,N2563,N2564, N2565,N2566,N2567,N2568, N2569,N2570,N2571,N2572, N2573,N2574,N2575,N2576, N2577,N2578,N2579,N2580,  \\note fields as indicated
  N2581,N2582,N2583,N2584, N2585,N2586,N2587,N2588, N2589,N2590,N2591,N2592, N2593,N2594,N2595,N2596, N2597,N2598,N2599,N2600,  \\note fields as indicated

  N2601,N2602,N2603,N2604, N2605,N2606,N2607,N2608, N2609,N2610,N2611,N2612, N2613,N2614,N2615,N2616, N2617,N2618,N2619,N2620,  \\note fields as indicated
  N2621,N2622,N2623,N2624, N2625,N2626,N2627,N2628, N2629,N2630,N2631,N2632, N2633,N2634,N2635,N2636, N2637,N2638,N2639,N2640,  \\note fields as indicated
  N2641,N2642,N2643,N2644, N2645,N2646,N2647,N2648, N2649,N2650,N2651,N2652, N2653,N2654,N2655,N2656, N2657,N2658,N2659,N2660,  \\note fields as indicated
  N2661,N2662,N2663,N2664, N2665,N2666,N2667,N2668, N2669,N2670,N2671,N2672, N2673,N2674,N2675,N2676, N2677,N2678,N2679,N2680,  \\note fields as indicated
  N2681,N2682,N2683,N2684, N2685,N2686,N2687,N2688, N2689,N2690,N2691,N2692, N2693,N2694,N2695,N2696, N2697,N2698,N2699,N2700,  \\note fields as indicated

  N2701,N2702,N2703,N2704, N2705,N2706,N2707,N2708, N2709,N2710,N2711,N2712, N2713,N2714,N2715,N2716, N2717,N2718,N2719,N2720,  \\note fields as indicated
  N2721,N2722,N2723,N2724, N2725,N2726,N2727,N2728, N2729,N2730,N2731,N2732, N2733,N2734,N2735,N2736, N2737,N2738,N2739,N2740,  \\note fields as indicated
  N2741,N2742,N2743,N2744, N2745,N2746,N2747,N2748, N2749,N2750,N2751,N2752, N2753,N2754,N2755,N2756, N2757,N2758,N2759,N2760,  \\note fields as indicated
  N2761,N2762,N2763,N2764, N2765,N2766,N2767,N2768, N2769,N2770,N2771,N2772, N2773,N2774,N2775,N2776, N2777,N2778,N2779,N2780,  \\note fields as indicated
  N2781,N2782,N2783,N2784, N2785,N2786,N2787,N2788, N2789,N2790,N2791,N2792, N2793,N2794,N2795,N2796, N2797,N2798,N2799,N2800,  \\note fields as indicated

  N2801,N2802,N2803,N2804, N2805,N2806,N2807,N2808, N2809,N2810,N2811,N2812, N2813,N2814,N2815,N2816, N2817,N2818,N2819,N2820,  \\note fields as indicated
  N2821,N2822,N2823,N2824, N2825,N2826,N2827,N2828, N2829,N2830,N2831,N2832, N2833,N2834,N2835,N2836, N2837,N2838,N2839,N2840,  \\note fields as indicated
  N2841,N2842,N2843,N2844, N2845,N2846,N2847,N2848, N2849,N2850,N2851,N2852, N2853,N2854,N2855,N2856, N2857,N2858,N2859,N2860,  \\note fields as indicated
  N2861,N2862,N2863,N2864, N2865,N2866,N2867,N2868, N2869,N2870,N2871,N2872, N2873,N2874,N2875,N2876, N2877,N2878,N2879,N2880,  \\note fields as indicated
  N2881,N2882,N2883,N2884, N2885,N2886,N2887,N2888, N2889,N2890,N2891,N2892, N2893,N2894,N2895,N2896, N2897,N2898,N2899,N2900,  \\note fields as indicated

  N2901,N2902,N2903,N2904, N2905,N2906,N2907,N2908, N2909,N2910,N2911,N2912, N2913,N2914,N2915,N2916, N2917,N2918,N2919,N2920,  \\note fields as indicated
  N2921,N2922,N2923,N2924, N2925,N2926,N2927,N2928, N2929,N2930,N2931,N2932, N2933,N2934,N2935,N2936, N2937,N2938,N2939,N2940,  \\note fields as indicated
  N2941,N2942,N2943,N2944, N2945,N2946,N2947,N2948, N2949,N2950,N2951,N2952, N2953,N2954,N2955,N2956, N2957,N2958,N2959,N2960,  \\note fields as indicated
  N2961,N2962,N2963,N2964, N2965,N2966,N2967,N2968, N2969,N2970,N2971,N2972, N2973,N2974,N2975,N2976, N2977,N2978,N2979,N2980,  \\note fields as indicated
  N2981,N2982,N2983,N2984, N2985,N2986,N2987,N2988, N2989,N2990,N2991,N2992, N2993,N2994,N2995,N2996, N2997,N2998,N2999,N3000,  \\note fields as indicated

  N3001,N3002,N3003,N3004, N3005,N3006,N3007,N3008, N3009,N3010,N3011,N3012, N3013,N3014,N3015,N3016, N3017,N3018,N3019,N3020,  \\note fields as indicated
  N3021,N3022,N3023,N3024, N3025,N3026,N3027,N3028, N3029,N3030,N3031,N3032, N3033,N3034,N3035,N3036, N3037,N3038,N3039,N3040,  \\note fields as indicated
  N3041,N3042,N3043,N3044, N3045,N3046,N3047,N3048, N3049,N3050,N3051,N3052, N3053,N3054,N3055,N3056, N3057,N3058,N3059,N3060,  \\note fields as indicated
  N3061,N3062,N3063,N3064, N3065,N3066,N3067,N3068, N3069,N3070,N3071,N3072, N3073,N3074,N3075,N3076, N3077,N3078,N3079,N3080,  \\note fields as indicated
  N3081,N3082,N3083,N3084, N3085,N3086,N3087,N3088, N3089,N3090,N3091,N3092, N3093,N3094,N3095,N3096, N3097,N3098,N3099,N3100,  \\note fields as indicated

  N3101,N3102,N3103,N3104, N3105,N3106,N3107,N3108, N3109,N3110,N3111,N3112, N3113,N3114,N3115,N3116, N3117,N3118,N3119,N3120,  \\note fields as indicated
  N3121,N3122,N3123,N3124, N3125,N3126,N3127,N3128, N3129,N3130,N3131,N3132, N3133,N3134,N3135,N3136, N3137,N3138,N3139,N3140,  \\note fields as indicated
  N3141,N3142,N3143,N3144, N3145,N3146,N3147,N3148, N3149,N3150,N3151,N3152, N3153,N3154,N3155,N3156, N3157,N3158,N3159,N3160,  \\note fields as indicated
  N3161,N3162,N3163,N3164, N3165,N3166,N3167,N3168, N3169,N3170,N3171,N3172, N3173,N3174,N3175,N3176, N3177,N3178,N3179,N3180,  \\note fields as indicated
  N3181,N3182,N3183,N3184, N3185,N3186,N3187,N3188, N3189,N3190,N3191,N3192, N3193,N3194,N3195,N3196, N3197,N3198,N3199,N3200;  \\note fields as indicated

Construction,
       \\memo Start with outside layer and work your way to the inside layer
       \\memo Up to 10 layers total, 8 for windows
       \\memo Enter the material name for each layer
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ConstructionNames
  A2 , \\field Outside Layer
       \\required-field
       \\type object-list
       \\object-list MaterialName
  A3 , \\field Layer 2
       \\type object-list
       \\object-list MaterialName
  A4 , \\field Layer 3
       \\type object-list
       \\object-list MaterialName
  A5 , \\field Layer 4
       \\type object-list
       \\object-list MaterialName
  A6 , \\field Layer 5
       \\type object-list
       \\object-list MaterialName
  A7 , \\field Layer 6
       \\type object-list
       \\object-list MaterialName
  A8 , \\field Layer 7
       \\type object-list
       \\object-list MaterialName
  A9 , \\field Layer 8
       \\type object-list
       \\object-list MaterialName
  A10, \\field Layer 9
       \\type object-list
       \\object-list MaterialName
  A11; \\field Layer 10
       \\type object-list
       \\object-list MaterialName

Construction:CfactorUndergroundWall,
       \\memo Alternate method of describing underground wall constructions
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ConstructionNames
  N1 , \\field C-Factor
       \\required-field
       \\units W/m2-K
       \\type real
       \\minimum> 0.0
       \\note Enter C-Factor without film coefficients or soil
  N2 ; \\field Height
       \\required-field
       \\units m
       \\type real
       \\minimum> 0.0
       \\note Enter height of the underground wall

Construction:FfactorGroundFloor,
       \\memo Alternate method of describing slab-on-grade or underground floor constructions
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ConstructionNames
  N1 , \\field F-Factor
       \\required-field
       \\units W/m-K
       \\ip-units Btu/h-ft-F
       \\type real
       \\minimum> 0.0
  N2 , \\field Area
       \\required-field
       \\units m2
       \\type real
       \\minimum> 0.0
       \\note Enter area of the floor
  N3 ; \\field PerimeterExposed
       \\required-field
       \\units m
       \\type real
       \\minimum 0.0
       \\note Enter exposed perimeter of the floor

Construction:InternalSource,
       \\memo Start with outside layer and work your way to the inside Layer
       \\memo Up to 10 layers total, 8 for windows
       \\memo Enter the material name for each layer
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ConstructionNames
  N1 , \\field Source Present After Layer Number
       \\required-field
       \\type integer
       \\minimum 1
       \\note refers to the list of materials which follows
  N2 , \\field Temperature Calculation Requested After Layer Number
       \\required-field
       \\type integer
       \\note refers to the list of materials which follows
  N3 , \\field Dimensions for the CTF Calculation
       \\required-field
       \\type integer
       \\minimum 1
       \\maximum 2
       \\note 1 = 1-dimensional calculation, 2 = 2-dimensional calculation
  N4 , \\field Tube Spacing
       \\required-field
       \\type real
       \\units m
       \\note uniform spacing between tubes or resistance wires in direction
       \\note perpendicular to main intended direction of heat transfer
  A2 , \\field Outside Layer
       \\required-field
       \\type object-list
       \\object-list MaterialName
  A3 , \\field Layer 2
       \\type object-list
       \\object-list MaterialName
  A4 , \\field Layer 3
       \\type object-list
       \\object-list MaterialName
  A5 , \\field Layer 4
       \\type object-list
       \\object-list MaterialName
  A6 , \\field Layer 5
       \\type object-list
       \\object-list MaterialName
  A7 , \\field Layer 6
       \\type object-list
       \\object-list MaterialName
  A8 , \\field Layer 7
       \\type object-list
       \\object-list MaterialName
  A9 , \\field Layer 8
       \\type object-list
       \\object-list MaterialName
  A10, \\field Layer 9
       \\type object-list
       \\object-list MaterialName
  A11; \\field Layer 10
       \\type object-list
       \\object-list MaterialName

WindowThermalModel:Params,
       \\memo object is used to select which thermal model should be used in tarcog simulations
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference WindowThermalModelParameters
  A2 , \\field standard
       \\type choice
       \\key ISO15099
       \\key EN673Declared
       \\key EN673Design
       \\default ISO15099
  A3 , \\field Thermal Model
       \\type choice
       \\key ISO15099
       \\key ScaledCavityWidth
       \\key ConvectiveScalarModel_NoSDThickness
       \\key ConvectiveScalarModel_withSDThickness
       \\default ISO15099
  N1 , \\field SDScalar
       \\type real
       \\minimum  0.0
       \\maximum 1.0
       \\default 1
  A4 , \\field Deflection Model
       \\type choice
       \\key NoDeflection
       \\key TemperatureAndPressureInput
       \\key MeasuredDeflection
       \\default NoDeflection
  N2 , \\field Vacuum Pressure Limit
       \\type real
       \\units Pa
       \\minimum >0
       \\default 13.238
  N3 , \\field Initial temperature
       \\note This is temperature in time of window fabrication
       \\type real
       \\units C
       \\minimum >0
       \\default 25
  N4 ; \\field Initial pressure
       \\note This is pressure in time of window fabrication
       \\type real
       \\units Pa
       \\minimum >0
       \\default 101325


Construction:ComplexFenestrationState,
       \\memo Describes one state for a complex glazing system
       \\memo These input objects are typically generated by using WINDOW software and export to IDF syntax
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ConstructionNames
       \\reference ComplexFenestrationStates
  A2 , \\field Basis Type
       \\required-field
       \\type choice
       \\key LBNLWINDOW
       \\key UserDefined
       \\default LBNLWINDOW
  A3 , \\field Basis Symmetry Type
       \\type choice
       \\key Axisymmetric
       \\key None
       \\default None
  A4 , \\field Window Thermal Model
       \\required-field
       \\type object-list
       \\object-list WindowThermalModelParameters
  A5 , \\field Basis Matrix Name
       \\type object-list
       \\object-list DataMatrices
       \\required-field
  A6 , \\field Solar Optical Complex Front Transmittance Matrix Name
       \\type object-list
       \\object-list DataMatrices
       \\required-field
  A7 , \\field Solar Optical Complex Back Reflectance Matrix Name
       \\type object-list
       \\object-list DataMatrices
       \\required-field
  A8 , \\field Visible Optical Complex Front Transmittance Matrix Name
       \\type object-list
       \\object-list DataMatrices
       \\required-field
  A9 , \\field Visible Optical Complex Back Transmittance Matrix Name
       \\type object-list
       \\object-list DataMatrices
       \\required-field
  A10, \\field Outside Layer Material Name
       \\note optional field  currently unused
       \\note for future development
       \\type object-list
       \\object-list MaterialName
  A11,  \\field Outside Layer Directional Front Absoptance Matrix Name
       \\required-field
       \\type object-list
       \\object-list DataMatrices
  A12, \\field Outside Layer Directional Back Absoptance Matrix Name
       \\required-field
       \\type object-list
       \\object-list DataMatrices
  A13, \\field Layer 2 Material Name
       \\type object-list
       \\object-list MaterialName
  A14, \\field Layer 2 Directional Front Absoptance Matrix Name
       \\type object-list
       \\object-list DataMatrices
  A15, \\field Layer 2 Directional Back Absoptance Matrix Name
       \\type object-list
       \\object-list DataMatrices
  A16, \\field Layer 3 Material Name
       \\type object-list
       \\object-list MaterialName
  A17, \\field Layer 3 Directional Front Absoptance Matrix Name
       \\type object-list
       \\object-list DataMatrices
  A18, \\field Layer 3 Directional Back Absoptance Matrix Name
       \\type object-list
       \\object-list DataMatrices
  A19, \\field Layer 4 Material Name
       \\type object-list
       \\object-list MaterialName
  A20, \\field Layer 4 Directional Front Absoptance Matrix Name
       \\type object-list
       \\object-list DataMatrices
  A21, \\field Layer 4 Directional Back Absoptance Matrix Name
       \\type object-list
       \\object-list DataMatrices
  A22, \\field Layer 5 Material Name
       \\type object-list
       \\object-list MaterialName
  A23, \\field Layer 5 Directional Front Absoptance Matrix Name
       \\type object-list
       \\object-list DataMatrices
  A24, \\field Layer 5 Directional Back Absoptance Matrix Name
       \\type object-list
       \\object-list DataMatrices
  A25, \\field Layer 6 Material Name
       \\type object-list
       \\object-list MaterialName
  A26, \\field Layer 6 Directional Front Absoptance Matrix Name
       \\type object-list
       \\object-list DataMatrices
  A27, \\field Layer 6 Directional Back Absoptance Matrix Name
       \\type object-list
       \\object-list DataMatrices
  A28, \\field Layer 7 Material Name
       \\type object-list
       \\object-list MaterialName
  A29, \\field Layer 7 Directional Front Absoptance Matrix Name
       \\type object-list
       \\object-list DataMatrices
  A30, \\field Layer 7 Directional Back Absoptance Matrix Name
       \\type object-list
       \\object-list DataMatrices
  A31, \\field Layer 8 Material Name
       \\type object-list
       \\object-list MaterialName
  A32, \\field Layer 8 Directional Front Absoptance Matrix Name
       \\type object-list
       \\object-list DataMatrices
  A33, \\field Layer 8 Directional Back Absoptance Matrix Name
       \\type object-list
       \\object-list DataMatrices
  A34, \\field Layer 9 Material Name
       \\type object-list
       \\object-list MaterialName
  A35, \\field Layer 9 Directional Front Absoptance Matrix Name
       \\type object-list
       \\object-list DataMatrices
  A36, \\field Layer 9 Directional Back Absoptance Matrix Name
       \\type object-list
       \\object-list DataMatrices
  A37, \\field Layer 10 Material Name
       \\type object-list
       \\object-list MaterialName
  A38, \\field Layer 10 Directional Front Absoptance Matrix Name
       \\type object-list
       \\object-list DataMatrices
  A39; \\field Layer 10 Directional Back Absoptance Matrix Name
       \\type object-list
       \\object-list DataMatrices

Construction:WindowDataFile,
       \\memo Initiates search of the Window data file for a window called Name.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ConstructionNames
  A2 ; \\field File Name
       \\retaincase
       \\note default file name is "Window5DataFile.dat"
       \\note limit on this field is 100 characters.

\\group Thermal Zones and Surfaces

GlobalGeometryRules,
      \\memo Specifes the geometric rules used to describe the input of surface vertices and
      \\memo daylighting reference points.
      \\required-object
      \\unique-object
  A1, \\field Starting Vertex Position
      \\required-field
      \\note Specified as entry for a 4 sided surface/rectangle
      \\note Surfaces are specified as viewed from outside the surface
      \\note Shading surfaces as viewed from behind.  (towards what they are shading)
      \\type choice
      \\key UpperLeftCorner
      \\key LowerLeftCorner
      \\key UpperRightCorner
      \\key LowerRightCorner
  A2, \\field Vertex Entry Direction
      \\required-field
      \\type choice
      \\key Counterclockwise
      \\key Clockwise
  A3, \\field Coordinate System
      \\required-field
      \\note relative -- coordinates are entered relative to zone origin
      \\note world -- all coordinates entered are "absolute" for this facility
      \\note absolute -- same as world
      \\type choice
      \\key Relative
      \\key World
      \\key Absolute
  A4, \\field Daylighting Reference Point Coordinate System
      \\type choice
      \\key Relative
      \\default Relative
      \\note Relative -- coordinates are entered relative to zone origin
      \\key World
      \\note World -- all coordinates entered are "absolute" for this facility
      \\key Absolute
      \\note absolute -- same as world
  A5; \\field Rectangular Surface Coordinate System
      \\type choice
      \\key Relative
      \\default Relative
      \\note Relative -- Starting corner is entered relative to zone origin
      \\key World
      \\note World -- Starting corner is entered in "absolute"
      \\key Absolute
      \\note absolute -- same as world

GeometryTransform,
      \\memo Provides a simple method of altering the footprint geometry of a model. The intent
      \\memo is to provide a single parameter that can be used to reshape the building description
      \\memo contained in the rest of the input file.
     \\unique-object
  A1, \\field Plane of Transform
      \\required-field
      \\type choice
      \\key XY
      \\default XY
      \\note only current allowed value is "XY"
  N1, \\field Current Aspect Ratio
      \\required-field
      \\minimum> 0
      \\note Aspect ratio of building as described in idf
  N2; \\field New Aspect Ratio
      \\required-field
      \\minimum> 0
      \\note Aspect ratio to transform to during run

Zone,
       \\memo Defines a thermal zone of the building.
  \\format vertices
  A1 , \\Field Name
       \\required-field
       \\type alpha
       \\reference ZoneNames
       \\reference OutFaceEnvNames
       \\reference ZoneAndZoneListNames
       \\reference AirflowNetworkNodeAndZoneNames
  N1 , \\field Direction of Relative North
       \\units deg
       \\type real
       \\default 0
  N2 , \\field X Origin
       \\units m
       \\type real
       \\default 0
  N3 , \\field Y Origin
       \\units m
       \\type real
       \\default 0
  N4 , \\field Z Origin
       \\units m
       \\type real
       \\default 0
  N5 , \\field Type
       \\type integer
       \\maximum 1
       \\minimum 1
       \\default 1
  N6 , \\field Multiplier
       \\type integer
       \\minimum 1
       \\default 1
  N7 , \\field Ceiling Height
       \\note If this field is 0.0, negative or autocalculate, then the average height
       \\note of the zone is automatically calculated and used in subsequent calculations.
       \\note If this field is positive, then the number entered here will be used.
       \\note Note that the Zone Ceiling Height is the distance from the Floor to
       \\note the Ceiling in the Zone, not an absolute height from the ground.
       \\units m
       \\type real
       \\autocalculatable
       \\default autocalculate
  N8 , \\field Volume
       \\note If this field is 0.0, negative or autocalculate, then the volume of the zone
       \\note is automatically calculated and used in subsequent calculations.
       \\note If this field is positive, then the number entered here will be used.
       \\units m3
       \\type real
       \\autocalculatable
       \\default autocalculate
  N9 , \\field Floor Area
       \\note If this field is 0.0, negative or autocalculate, then the floor area of the zone
       \\note is automatically calculated and used in subsequent calculations.
       \\note If this field is positive, then the number entered here will be used.
       \\units m2
       \\type real
       \\autocalculatable
       \\default autocalculate
  A2 , \\field Zone Inside Convection Algorithm
       \\type choice
       \\key Simple
       \\key TARP
       \\key CeilingDiffuser
       \\key AdaptiveConvectionAlgorithm
       \\key TrombeWall
       \\note Will default to same value as SurfaceConvectionAlgorithm:Inside object
       \\note setting this field overrides the default SurfaceConvectionAlgorithm:Inside for this zone
       \\note Simple = constant natural convection (ASHRAE)
       \\note TARP = variable natural convection based on temperature difference (ASHRAE)
       \\note CeilingDiffuser = ACH based forced and mixed convection correlations
       \\note  for ceiling diffuser configuration with simple natural convection limit
       \\note AdaptiveConvectionAlgorithm = dynamic selection of convection models based on conditions
       \\note TrombeWall = variable natural convection in an enclosed rectangular cavity
  A3,  \\field Zone Outside Convection Algorithm
       \\note Will default to same value as SurfaceConvectionAlgorithm:Outside object
       \\note setting this field overrides the default SurfaceConvectionAlgorithm:Outside for this zone
       \\type choice
       \\key SimpleCombined
       \\key TARP
       \\key DOE-2
       \\key MoWiTT
       \\key AdaptiveConvectionAlgorithm
       \\note SimpleCombined = Combined radiation and convection coefficient using simple ASHRAE model
       \\note TARP = correlation from models developed by ASHRAE, Walton, and Sparrow et. al.
       \\note MoWiTT = correlation from measurements by Klems and Yazdanian for smooth surfaces
       \\note DOE-2 = correlation from measurements by Klems and Yazdanian for rough surfaces
       \\note AdaptiveConvectionAlgorithm = dynamic selection of correlations based on conditions
  A4;  \\field Part of Total Floor Area
       \\type choice
       \\key Yes
       \\key No
       \\default Yes

ZoneList,
       \\memo Defines a list of thermal zones which can be referenced as a group. The ZoneList name
       \\memo may be used elsewhere in the input to apply a parameter to all zones in the list.
       \\memo ZoneLists can be used effectively with the following objects: People, Lights,
       \\memo ElectricEquipment, GasEquipment, HotWaterEquipment, ZoneInfiltration:DesignFlowRate,
       \\memo ZoneVentilation:DesignFlowRate, Sizing:Zone, ZoneControl:Thermostat, and others.
       \\min-fields 2
       \\extensible:1 - repeat last field, remembering to remove ; from "inner" fields.
  A1 , \\field Name
       \\note Name of the Zone List
       \\required-field
       \\type alpha
       \\reference ZoneListNames
       \\reference ZoneAndZoneListNames
  A2 , \\field Zone 1 Name
       \\begin-extensible
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  A3 , \\field Zone 2 Name
       \\type object-list
       \\object-list ZoneNames
  A4 , \\field Zone 3 Name
       \\type object-list
       \\object-list ZoneNames
  A5 , \\field Zone 4 Name
       \\type object-list
       \\object-list ZoneNames
  A6 , \\field Zone 5 Name
       \\type object-list
       \\object-list ZoneNames
  A7 , \\field Zone 6 Name
       \\type object-list
       \\object-list ZoneNames
  A8 , \\field Zone 7 Name
       \\type object-list
       \\object-list ZoneNames
  A9 , \\field Zone 8 Name
       \\type object-list
       \\object-list ZoneNames
  A10, \\field Zone 9 Name
       \\type object-list
       \\object-list ZoneNames
  A11, \\field Zone 10 Name
       \\type object-list
       \\object-list ZoneNames
  A12, \\field Zone 11 Name
       \\type object-list
       \\object-list ZoneNames
  A13, \\field Zone 12 Name
       \\type object-list
       \\object-list ZoneNames
  A14, \\field Zone 13 Name
       \\type object-list
       \\object-list ZoneNames
  A15, \\field Zone 14 Name
       \\type object-list
       \\object-list ZoneNames
  A16, \\field Zone 15 Name
       \\type object-list
       \\object-list ZoneNames
  A17, \\field Zone 16 Name
       \\type object-list
       \\object-list ZoneNames
  A18, \\field Zone 17 Name
       \\type object-list
       \\object-list ZoneNames
  A19, \\field Zone 18 Name
       \\type object-list
       \\object-list ZoneNames
  A20, \\field Zone 19 Name
       \\type object-list
       \\object-list ZoneNames
  A21, \\field Zone 20 Name
       \\type object-list
       \\object-list ZoneNames
  A22, \\field Zone 21 Name
       \\type object-list
       \\object-list ZoneNames
  A23, \\field Zone 22 Name
       \\type object-list
       \\object-list ZoneNames
  A24, \\field Zone 23 Name
       \\type object-list
       \\object-list ZoneNames
  A25, \\field Zone 24 Name
       \\type object-list
       \\object-list ZoneNames
  A26, \\field Zone 25 Name
       \\type object-list
       \\object-list ZoneNames
  A27, \\field Zone 26 Name
       \\type object-list
       \\object-list ZoneNames
  A28, \\field Zone 27 Name
       \\type object-list
       \\object-list ZoneNames
  A29, \\field Zone 28 Name
       \\type object-list
       \\object-list ZoneNames
  A30, \\field Zone 29 Name
       \\type object-list
       \\object-list ZoneNames
  A31, \\field Zone 30 Name
       \\type object-list
       \\object-list ZoneNames
  A32, \\field Zone 31 Name
       \\type object-list
       \\object-list ZoneNames
  A33, \\field Zone 32 Name
       \\type object-list
       \\object-list ZoneNames
  A34, \\field Zone 33 Name
       \\type object-list
       \\object-list ZoneNames
  A35, \\field Zone 34 Name
       \\type object-list
       \\object-list ZoneNames
  A36, \\field Zone 35 Name
       \\type object-list
       \\object-list ZoneNames
  A37, \\field Zone 36 Name
       \\type object-list
       \\object-list ZoneNames
  A38, \\field Zone 37 Name
       \\type object-list
       \\object-list ZoneNames
  A39, \\field Zone 38 Name
       \\type object-list
       \\object-list ZoneNames
  A40, \\field Zone 39 Name
       \\type object-list
       \\object-list ZoneNames
  A41, \\field Zone 40 Name
       \\type object-list
       \\object-list ZoneNames
  A42, \\field Zone 41 Name
       \\type object-list
       \\object-list ZoneNames
  A43, \\field Zone 42 Name
       \\type object-list
       \\object-list ZoneNames
  A44, \\field Zone 43 Name
       \\type object-list
       \\object-list ZoneNames
  A45, \\field Zone 44 Name
       \\type object-list
       \\object-list ZoneNames
  A46, \\field Zone 45 Name
       \\type object-list
       \\object-list ZoneNames
  A47, \\field Zone 46 Name
       \\type object-list
       \\object-list ZoneNames
  A48, \\field Zone 47 Name
       \\type object-list
       \\object-list ZoneNames
  A49, \\field Zone 48 Name
       \\type object-list
       \\object-list ZoneNames
  A50, \\field Zone 49 Name
       \\type object-list
       \\object-list ZoneNames
  A51, \\field Zone 50 Name
       \\type object-list
       \\object-list ZoneNames
  A52, \\field Zone 51 Name
       \\type object-list
       \\object-list ZoneNames
  A53, \\field Zone 52 Name
       \\type object-list
       \\object-list ZoneNames
  A54, \\field Zone 53 Name
       \\type object-list
       \\object-list ZoneNames
  A55, \\field Zone 54 Name
       \\type object-list
       \\object-list ZoneNames
  A56, \\field Zone 55 Name
       \\type object-list
       \\object-list ZoneNames
  A57, \\field Zone 56 Name
       \\type object-list
       \\object-list ZoneNames
  A58, \\field Zone 57 Name
       \\type object-list
       \\object-list ZoneNames
  A59, \\field Zone 58 Name
       \\type object-list
       \\object-list ZoneNames
  A60, \\field Zone 59 Name
       \\type object-list
       \\object-list ZoneNames
  A61, \\field Zone 60 Name
       \\type object-list
       \\object-list ZoneNames
  A62, \\field Zone 61 Name
       \\type object-list
       \\object-list ZoneNames
  A63, \\field Zone 62 Name
       \\type object-list
       \\object-list ZoneNames
  A64, \\field Zone 63 Name
       \\type object-list
       \\object-list ZoneNames
  A65, \\field Zone 64 Name
       \\type object-list
       \\object-list ZoneNames
  A66, \\field Zone 65 Name
       \\type object-list
       \\object-list ZoneNames
  A67, \\field Zone 66 Name
       \\type object-list
       \\object-list ZoneNames
  A68, \\field Zone 67 Name
       \\type object-list
       \\object-list ZoneNames
  A69, \\field Zone 68 Name
       \\type object-list
       \\object-list ZoneNames
  A70, \\field Zone 69 Name
       \\type object-list
       \\object-list ZoneNames
  A71, \\field Zone 70 Name
       \\type object-list
       \\object-list ZoneNames
  A72, \\field Zone 71 Name
       \\type object-list
       \\object-list ZoneNames
  A73, \\field Zone 72 Name
       \\type object-list
       \\object-list ZoneNames
  A74, \\field Zone 73 Name
       \\type object-list
       \\object-list ZoneNames
  A75, \\field Zone 74 Name
       \\type object-list
       \\object-list ZoneNames
  A76, \\field Zone 75 Name
       \\type object-list
       \\object-list ZoneNames
  A77, \\field Zone 76 Name
       \\type object-list
       \\object-list ZoneNames
  A78, \\field Zone 77 Name
       \\type object-list
       \\object-list ZoneNames
  A79, \\field Zone 78 Name
       \\type object-list
       \\object-list ZoneNames
  A80, \\field Zone 79 Name
       \\type object-list
       \\object-list ZoneNames
  A81, \\field Zone 80 Name
       \\type object-list
       \\object-list ZoneNames
  A82, \\field Zone 81 Name
       \\type object-list
       \\object-list ZoneNames
  A83, \\field Zone 82 Name
       \\type object-list
       \\object-list ZoneNames
  A84, \\field Zone 83 Name
       \\type object-list
       \\object-list ZoneNames
  A85, \\field Zone 84 Name
       \\type object-list
       \\object-list ZoneNames
  A86, \\field Zone 85 Name
       \\type object-list
       \\object-list ZoneNames
  A87, \\field Zone 86 Name
       \\type object-list
       \\object-list ZoneNames
  A88, \\field Zone 87 Name
       \\type object-list
       \\object-list ZoneNames
  A89, \\field Zone 88 Name
       \\type object-list
       \\object-list ZoneNames
  A90, \\field Zone 89 Name
       \\type object-list
       \\object-list ZoneNames
  A91, \\field Zone 90 Name
       \\type object-list
       \\object-list ZoneNames
  A92, \\field Zone 91 Name
       \\type object-list
       \\object-list ZoneNames
  A93, \\field Zone 92 Name
       \\type object-list
       \\object-list ZoneNames
  A94, \\field Zone 93 Name
       \\type object-list
       \\object-list ZoneNames
  A95, \\field Zone 94 Name
       \\type object-list
       \\object-list ZoneNames
  A96, \\field Zone 95 Name
       \\type object-list
       \\object-list ZoneNames
  A97, \\field Zone 96 Name
       \\type object-list
       \\object-list ZoneNames
  A98, \\field Zone 97 Name
       \\type object-list
       \\object-list ZoneNames
  A99, \\field Zone 98 Name
       \\type object-list
       \\object-list ZoneNames
  A100, \\field Zone 99 Name
       \\type object-list
       \\object-list ZoneNames
  A101, \\field Zone 100 Name
       \\type object-list
       \\object-list ZoneNames
  A102,A103,A104,A105,A106,A107,A108,A109,A110,A111, \\note fields as indicated
  A112,A113,A114,A115,A116,A117,A118,A119,A120,A121, \\note fields as indicated
  A122,A123,A124,A125,A126,A127,A128,A129,A130,A131, \\note fields as indicated
  A132,A133,A134,A135,A136,A137,A138,A139,A140,A141, \\note fields as indicated
  A142,A143,A144,A145,A146,A147,A148,A149,A150,A151, \\note fields as indicated
  A152,A153,A154,A155,A156,A157,A158,A159,A160,A161, \\note fields as indicated
  A162,A163,A164,A165,A166,A167,A168,A169,A170,A171, \\note fields as indicated
  A172,A173,A174,A175,A176,A177,A178,A179,A180,A181, \\note fields as indicated
  A182,A183,A184,A185,A186,A187,A188,A189,A190,A191, \\note fields as indicated
  A192,A193,A194,A195,A196,A197,A198,A199,A200,A201, \\note fields as indicated
  A202,A203,A204,A205,A206,A207,A208,A209,A210,A211, \\note fields as indicated
  A212,A213,A214,A215,A216,A217,A218,A219,A220,A221, \\note fields as indicated
  A222,A223,A224,A225,A226,A227,A228,A229,A230,A231, \\note fields as indicated
  A232,A233,A234,A235,A236,A237,A238,A239,A240,A241, \\note fields as indicated
  A242,A243,A244,A245,A246,A247,A248,A249,A250,A251, \\note fields as indicated
  A252,A253,A254,A255,A256,A257,A258,A259,A260,A261, \\note fields as indicated
  A262,A263,A264,A265,A266,A267,A268,A269,A270,A271, \\note fields as indicated
  A272,A273,A274,A275,A276,A277,A278,A279,A280,A281, \\note fields as indicated
  A282,A283,A284,A285,A286,A287,A288,A289,A290,A291, \\note fields as indicated
  A292,A293,A294,A295,A296,A297,A298,A299,A300,A301, \\note fields as indicated
  A302,A303,A304,A305,A306,A307,A308,A309,A310,A311, \\note fields as indicated
  A312,A313,A314,A315,A316,A317,A318,A319,A320,A321, \\note fields as indicated
  A322,A323,A324,A325,A326,A327,A328,A329,A330,A331, \\note fields as indicated
  A332,A333,A334,A335,A336,A337,A338,A339,A340,A341, \\note fields as indicated
  A342,A343,A344,A345,A346,A347,A348,A349,A350,A351, \\note fields as indicated
  A352,A353,A354,A355,A356,A357,A358,A359,A360,A361, \\note fields as indicated
  A362,A363,A364,A365,A366,A367,A368,A369,A370,A371, \\note fields as indicated
  A372,A373,A374,A375,A376,A377,A378,A379,A380,A381, \\note fields as indicated
  A382,A383,A384,A385,A386,A387,A388,A389,A390,A391, \\note fields as indicated
  A392,A393,A394,A395,A396,A397,A398,A399,A400,A401, \\note fields as indicated
  A402,A403,A404,A405,A406,A407,A408,A409,A410,A411, \\note fields as indicated
  A412,A413,A414,A415,A416,A417,A418,A419,A420,A421, \\note fields as indicated
  A422,A423,A424,A425,A426,A427,A428,A429,A430,A431, \\note fields as indicated
  A432,A433,A434,A435,A436,A437,A438,A439,A440,A441, \\note fields as indicated
  A442,A443,A444,A445,A446,A447,A448,A449,A450,A451, \\note fields as indicated
  A452,A453,A454,A455,A456,A457,A458,A459,A460,A461, \\note fields as indicated
  A462,A463,A464,A465,A466,A467,A468,A469,A470,A471, \\note fields as indicated
  A472,A473,A474,A475,A476,A477,A478,A479,A480,A481, \\note fields as indicated
  A482,A483,A484,A485,A486,A487,A488,A489,A490,A491, \\note fields as indicated
  A492,A493,A494,A495,A496,A497,A498,A499,A500,A501; \\note fields as indicated

ZoneGroup,
       \\memo Adds a multiplier to a ZoneList. This can be used to reduce the amount of input
       \\memo necessary for simulating repetitive structures, such as the identical floors of a
       \\memo multi-story building.
       \\min-fields 2
  A1 , \\field Name
       \\note Name of the Zone Group
       \\required-field
       \\type alpha
  A2,  \\field Zone List Name
       \\required-field
       \\type object-list
       \\object-list ZoneListNames
  N1;  \\field Zone List Multiplier
       \\type integer
       \\default 1
       \\minimum 1

BuildingSurface:Detailed,
  \\memo Allows for detailed entry of building heat transfer surfaces.  Does not include subsurfaces such as windows or doors.
  \\extensible:3 -- duplicate last set of x,y,z coordinates (last 3 fields), remembering to remove ; from "inner" fields.
  \\format vertices
  \\min-fields 19
  A1 , \\Field Name
       \\required-field
       \\type alpha
       \\reference SurfaceNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference HeatTranBaseSurfNames
       \\reference OutFaceEnvNames
       \\reference AllHeatTranAngFacNames
       \\reference RadGroupAndSurfNames
       \\reference SurfGroupAndHTSurfNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Surface Type
       \\required-field
       \\type choice
       \\key Floor
       \\key Wall
       \\key Ceiling
       \\key Roof
  A3 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A4 , \\field Zone Name
       \\required-field
       \\note Zone the surface is a part of
       \\type object-list
       \\object-list ZoneNames
  A5 , \\field Outside Boundary Condition
       \\required-field
       \\type choice
       \\key Adiabatic
       \\key Surface
       \\key Zone
       \\key Outdoors
       \\key Ground
       \\key GroundFCfactorMethod
       \\key OtherSideCoefficients
       \\key OtherSideConditionsModel
       \\key GroundSlabPreprocessorAverage
       \\key GroundSlabPreprocessorCore
       \\key GroundSlabPreprocessorPerimeter
       \\key GroundBasementPreprocessorAverageWall
       \\key GroundBasementPreprocessorAverageFloor
       \\key GroundBasementPreprocessorUpperWall
       \\key GroundBasementPreprocessorLowerWall
  A6,  \\field Outside Boundary Condition Object
       \\type object-list
       \\object-list OutFaceEnvNames
       \\note Non-blank only if the field Outside Boundary Condition is Surface,
       \\note Zone, OtherSideCoefficients or OtherSideConditionsModel
       \\note If Surface, specify name of corresponding surface in adjacent zone or
       \\note specify current surface name for internal partition separating like zones
       \\note If Zone, specify the name of the corresponding zone and
       \\note the program will generate the corresponding interzone surface
       \\note If OtherSideCoefficients, specify name of SurfaceProperty:OtherSideCoefficients
       \\note If OtherSideConditionsModel, specify name of SurfaceProperty:OtherSideConditionsModel
  A7 , \\field Sun Exposure
       \\required-field
       \\type choice
       \\key SunExposed
       \\key NoSun
       \\default SunExposed
  A8,  \\field Wind Exposure
       \\required-field
       \\type choice
       \\key WindExposed
       \\key NoWind
       \\default WindExposed
  N1,  \\field View Factor to Ground
       \\type real
       \\note From the exterior of the surface
       \\note Unused if one uses the "reflections" options in Solar Distribution in Building input
       \\note unless a DaylightingDevice:Shelf or DaylightingDevice:Tubular object has been specified.
       \\note autocalculate will automatically calculate this value from the tilt of the surface
       \\autocalculatable
       \\minimum 0.0
       \\maximum 1.0
       \\default autocalculate
  N2 , \\field Number of Vertices
       \\note shown with 120 vertex coordinates -- extensible object
       \\note  "extensible" -- duplicate last set of x,y,z coordinates (last 3 fields),
       \\note remembering to remove ; from "inner" fields.
       \\note for clarity in any error messages, renumber the fields as well.
       \\note (and changing z terminator to a comma "," for all but last one which needs a semi-colon ";")
       \\autocalculatable
       \\minimum 3
       \\default autocalculate
       \\note vertices are given in GlobalGeometryRules coordinates -- if relative, all surface coordinates
       \\note are "relative" to the Zone Origin.  If world, then building and zone origins are used
       \\note for some internal calculations, but all coordinates are given in an "absolute" system.
  N3,  \\field Vertex 1 X-coordinate
       \\begin-extensible
       \\required-field
       \\units m
       \\type real
  N4 , \\field Vertex 1 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N5 , \\field Vertex 1 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N6,  \\field Vertex 2 X-coordinate
       \\required-field
       \\units m
       \\type real
  N7,  \\field Vertex 2 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N8,  \\field Vertex 2 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N9,  \\field Vertex 3 X-coordinate
       \\required-field
       \\units m
       \\type real
  N10, \\field Vertex 3 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N11, \\field Vertex 3 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N12, \\field Vertex 4 X-coordinate
       \\units m
       \\type real
  N13, \\field Vertex 4 Y-coordinate
       \\type real
       \\units m
  N14, \\field Vertex 4 Z-coordinate
       \\units m
       \\type real
  N15, \\field Vertex 5 X-coordinate
       \\units m
       \\type real
  N16, \\field Vertex 5 Y-coordinate
       \\type real
       \\units m
  N17, \\field Vertex 5 Z-coordinate
       \\units m
       \\type real
  N18, \\field Vertex 6 X-coordinate
       \\units m
       \\type real
  N19, \\field Vertex 6 Y-coordinate
       \\type real
       \\units m
  N20, \\field Vertex 6 Z-coordinate
       \\units m
       \\type real
  N21, \\field Vertex 7 X-coordinate
       \\units m
       \\type real
  N22, \\field Vertex 7 Y-coordinate
       \\type real
       \\units m
  N23, \\field Vertex 7 Z-coordinate
       \\units m
       \\type real
  N24, \\field Vertex 8 X-coordinate
       \\units m
       \\type real
  N25, \\field Vertex 8 Y-coordinate
       \\type real
       \\units m
  N26, \\field Vertex 8 Z-coordinate
       \\units m
       \\type real
  N27, \\field Vertex 9 X-coordinate
       \\units m
       \\type real
  N28, \\field Vertex 9 Y-coordinate
       \\type real
       \\units m
  N29, \\field Vertex 9 Z-coordinate
       \\units m
       \\type real
  N30, \\field Vertex 10 X-coordinate
       \\units m
       \\type real
  N31, \\field Vertex 10 Y-coordinate
       \\type real
       \\units m
  N32, \\field Vertex 10 Z-coordinate
       \\units m
       \\type real
  N33, \\field Vertex 11 X-coordinate
       \\units m
       \\type real
  N34, \\field Vertex 11 Y-coordinate
       \\type real
       \\units m
  N35, \\field Vertex 11 Z-coordinate
       \\units m
       \\type real
  N36, \\field Vertex 12 X-coordinate
       \\units m
       \\type real
  N37, \\field Vertex 12 Y-coordinate
       \\type real
       \\units m
  N38, \\field Vertex 12 Z-coordinate
       \\units m
       \\type real
  N39, \\field Vertex 13 X-coordinate
       \\units m
       \\type real
  N40, \\field Vertex 13 Y-coordinate
       \\type real
       \\units m
  N41, \\field Vertex 13 Z-coordinate
       \\units m
       \\type real
  N42, \\field Vertex 14 X-coordinate
       \\units m
       \\type real
  N43, \\field Vertex 14 Y-coordinate
       \\type real
       \\units m
  N44, \\field Vertex 14 Z-coordinate
       \\units m
       \\type real
  N45, \\field Vertex 15 X-coordinate
       \\units m
       \\type real
  N46, \\field Vertex 15 Y-coordinate
       \\type real
       \\units m
  N47, \\field Vertex 15 Z-coordinate
       \\units m
       \\type real
  N48, \\field Vertex 16 X-coordinate
       \\units m
       \\type real
  N49, \\field Vertex 16 Y-coordinate
       \\type real
       \\units m
  N50, \\field Vertex 16 Z-coordinate
       \\units m
       \\type real
  N51, \\field Vertex 17 X-coordinate
       \\units m
       \\type real
  N52, \\field Vertex 17 Y-coordinate
       \\type real
       \\units m
  N53, \\field Vertex 17 Z-coordinate
       \\units m
       \\type real
  N54, \\field Vertex 18 X-coordinate
       \\units m
       \\type real
  N55, \\field Vertex 18 Y-coordinate
       \\type real
       \\units m
  N56, \\field Vertex 18 Z-coordinate
       \\units m
       \\type real
  N57, \\field Vertex 19 X-coordinate
       \\units m
       \\type real
  N58, \\field Vertex 19 Y-coordinate
       \\type real
       \\units m
  N59, \\field Vertex 19 Z-coordinate
       \\units m
       \\type real
  N60, \\field Vertex 20 X-coordinate
       \\units m
       \\type real
  N61, \\field Vertex 20 Y-coordinate
       \\type real
       \\units m
  N62, \\field Vertex 20 Z-coordinate
       \\units m
       \\type real
  N63, \\field Vertex 21 X-coordinate
       \\units m
       \\type real
  N64, \\field Vertex 21 Y-coordinate
       \\type real
       \\units m
  N65, \\field Vertex 21 Z-coordinate
       \\units m
       \\type real
  N66, \\field Vertex 22 X-coordinate
       \\units m
       \\type real
  N67, \\field Vertex 22 Y-coordinate
       \\type real
       \\units m
  N68, \\field Vertex 22 Z-coordinate
       \\units m
       \\type real
  N69, \\field Vertex 23 X-coordinate
       \\units m
       \\type real
  N70, \\field Vertex 23 Y-coordinate
       \\type real
       \\units m
  N71, \\field Vertex 23 Z-coordinate
       \\units m
       \\type real
  N72, \\field Vertex 24 X-coordinate
       \\units m
       \\type real
  N73, \\field Vertex 24 Y-coordinate
       \\type real
       \\units m
  N74, \\field Vertex 24 Z-coordinate
       \\units m
       \\type real
  N75, \\field Vertex 25 X-coordinate
       \\units m
       \\type real
  N76, \\field Vertex 25 Y-coordinate
       \\type real
       \\units m
  N77, \\field Vertex 25 Z-coordinate
       \\units m
       \\type real
  N78, \\field Vertex 26 X-coordinate
       \\units m
       \\type real
  N79, \\field Vertex 26 Y-coordinate
       \\type real
       \\units m
  N80, \\field Vertex 26 Z-coordinate
       \\units m
       \\type real
  N81, \\field Vertex 27 X-coordinate
       \\units m
       \\type real
  N82, \\field Vertex 27 Y-coordinate
       \\type real
       \\units m
  N83, \\field Vertex 27 Z-coordinate
       \\units m
       \\type real
  N84, \\field Vertex 28 X-coordinate
       \\units m
       \\type real
  N85, \\field Vertex 28 Y-coordinate
       \\type real
       \\units m
  N86, \\field Vertex 28 Z-coordinate
       \\units m
       \\type real
  N87, \\field Vertex 29 X-coordinate
       \\units m
       \\type real
  N88, \\field Vertex 29 Y-coordinate
       \\type real
       \\units m
  N89, \\field Vertex 29 Z-coordinate
       \\units m
       \\type real
  N90, \\field Vertex 30 X-coordinate
       \\units m
       \\type real
  N91, \\field Vertex 30 Y-coordinate
       \\type real
       \\units m
  N92, \\field Vertex 30 Z-coordinate
       \\units m
       \\type real
  N93, \\field Vertex 31 X-coordinate
       \\units m
       \\type real
  N94, \\field Vertex 31 Y-coordinate
       \\units m
       \\type real
  N95, \\field Vertex 31 Z-coordinate
       \\units m
       \\type real
  N96, \\field Vertex 32 X-coordinate
       \\units m
       \\type real
  N97, \\field Vertex 32 Y-coordinate
       \\units m
       \\type real
  N98, \\field Vertex 32 Z-coordinate
       \\units m
       \\type real
  N99, \\field Vertex 33 X-coordinate
       \\units m
       \\type real
  N100, \\field Vertex 33 Y-coordinate
       \\units m
       \\type real
  N101, \\field Vertex 33 Z-coordinate
       \\units m
       \\type real
  N102, \\field Vertex 34 X-coordinate
       \\units m
       \\type real
  N103, \\field Vertex 34 Y-coordinate
       \\units m
       \\type real
  N104, \\field Vertex 34 Z-coordinate
       \\units m
       \\type real
  N105, \\field Vertex 35 X-coordinate
       \\units m
       \\type real
  N106, \\field Vertex 35 Y-coordinate
       \\units m
       \\type real
  N107, \\field Vertex 35 Z-coordinate
       \\units m
       \\type real
  N108, \\field Vertex 36 X-coordinate
       \\units m
       \\type real
  N109, \\field Vertex 36 Y-coordinate
       \\units m
       \\type real
  N110, \\field Vertex 36 Z-coordinate
       \\units m
       \\type real
  N111, \\field Vertex 37 X-coordinate
       \\units m
       \\type real
  N112, \\field Vertex 37 Y-coordinate
       \\units m
       \\type real
  N113, \\field Vertex 37 Z-coordinate
       \\units m
       \\type real
  N114, \\field Vertex 38 X-coordinate
       \\units m
       \\type real
  N115, \\field Vertex 38 Y-coordinate
       \\units m
       \\type real
  N116, \\field Vertex 38 Z-coordinate
       \\units m
       \\type real
  N117, \\field Vertex 39 X-coordinate
       \\units m
       \\type real
  N118, \\field Vertex 39 Y-coordinate
       \\units m
       \\type real
  N119, \\field Vertex 39 Z-coordinate
       \\units m
       \\type real
  N120, \\field Vertex 40 X-coordinate
       \\units m
       \\type real
  N121, \\field Vertex 40 Y-coordinate
       \\units m
       \\type real
  N122, \\field Vertex 40 Z-coordinate
       \\units m
       \\type real
  N123, \\field Vertex 41 X-coordinate
       \\units m
       \\type real
  N124, \\field Vertex 41 Y-coordinate
       \\units m
       \\type real
  N125, \\field Vertex 41 Z-coordinate
       \\units m
       \\type real
  N126, \\field Vertex 42 X-coordinate
       \\units m
       \\type real
  N127, \\field Vertex 42 Y-coordinate
       \\units m
       \\type real
  N128, \\field Vertex 42 Z-coordinate
       \\units m
       \\type real
  N129, \\field Vertex 43 X-coordinate
       \\units m
       \\type real
  N130, \\field Vertex 43 Y-coordinate
       \\units m
       \\type real
  N131, \\field Vertex 43 Z-coordinate
       \\units m
       \\type real
  N132, \\field Vertex 44 X-coordinate
       \\units m
       \\type real
  N133, \\field Vertex 44 Y-coordinate
       \\units m
       \\type real
  N134, \\field Vertex 44 Z-coordinate
       \\units m
       \\type real
  N135, \\field Vertex 45 X-coordinate
       \\units m
       \\type real
  N136, \\field Vertex 45 Y-coordinate
       \\units m
       \\type real
  N137, \\field Vertex 45 Z-coordinate
       \\units m
       \\type real
  N138, \\field Vertex 46 X-coordinate
       \\units m
       \\type real
  N139, \\field Vertex 46 Y-coordinate
       \\units m
       \\type real
  N140, \\field Vertex 46 Z-coordinate
       \\units m
       \\type real
  N141, \\field Vertex 47 X-coordinate
       \\units m
       \\type real
  N142, \\field Vertex 47 Y-coordinate
       \\units m
       \\type real
  N143, \\field Vertex 47 Z-coordinate
       \\units m
       \\type real
  N144, \\field Vertex 48 X-coordinate
       \\units m
       \\type real
  N145, \\field Vertex 48 Y-coordinate
       \\units m
       \\type real
  N146, \\field Vertex 48 Z-coordinate
       \\units m
       \\type real
  N147, \\field Vertex 49 X-coordinate
       \\units m
       \\type real
  N148, \\field Vertex 49 Y-coordinate
       \\units m
       \\type real
  N149, \\field Vertex 49 Z-coordinate
       \\units m
       \\type real
  N150, \\field Vertex 50 X-coordinate
       \\units m
       \\type real
  N151, \\field Vertex 50 Y-coordinate
       \\units m
       \\type real
  N152, \\field Vertex 50 Z-coordinate
       \\units m
       \\type real
  N153, \\field Vertex 51 X-coordinate
       \\units m
       \\type real
  N154, \\field Vertex 51 Y-coordinate
       \\units m
       \\type real
  N155, \\field Vertex 51 Z-coordinate
       \\units m
       \\type real
  N156, \\field Vertex 52 X-coordinate
       \\units m
       \\type real
  N157, \\field Vertex 52 Y-coordinate
       \\units m
       \\type real
  N158, \\field Vertex 52 Z-coordinate
       \\units m
       \\type real
  N159, \\field Vertex 53 X-coordinate
       \\units m
       \\type real
  N160, \\field Vertex 53 Y-coordinate
       \\units m
       \\type real
  N161, \\field Vertex 53 Z-coordinate
       \\units m
       \\type real
  N162, \\field Vertex 54 X-coordinate
       \\units m
       \\type real
  N163, \\field Vertex 54 Y-coordinate
       \\units m
       \\type real
  N164, \\field Vertex 54 Z-coordinate
       \\units m
       \\type real
  N165, \\field Vertex 55 X-coordinate
       \\units m
       \\type real
  N166, \\field Vertex 55 Y-coordinate
       \\units m
       \\type real
  N167, \\field Vertex 55 Z-coordinate
       \\units m
       \\type real
  N168, \\field Vertex 56 X-coordinate
       \\units m
       \\type real
  N169, \\field Vertex 56 Y-coordinate
       \\units m
       \\type real
  N170, \\field Vertex 56 Z-coordinate
       \\units m
       \\type real
  N171, \\field Vertex 57 X-coordinate
       \\units m
       \\type real
  N172, \\field Vertex 57 Y-coordinate
       \\units m
       \\type real
  N173, \\field Vertex 57 Z-coordinate
       \\units m
       \\type real
  N174, \\field Vertex 58 X-coordinate
       \\units m
       \\type real
  N175, \\field Vertex 58 Y-coordinate
       \\units m
       \\type real
  N176, \\field Vertex 58 Z-coordinate
       \\units m
       \\type real
  N177, \\field Vertex 59 X-coordinate
       \\units m
       \\type real
  N178, \\field Vertex 59 Y-coordinate
       \\units m
       \\type real
  N179, \\field Vertex 59 Z-coordinate
       \\units m
       \\type real
  N180, \\field Vertex 60 X-coordinate
       \\units m
       \\type real
  N181, \\field Vertex 60 Y-coordinate
       \\units m
       \\type real
  N182, \\field Vertex 60 Z-coordinate
       \\units m
       \\type real
  N183, \\field Vertex 61 X-coordinate
       \\units m
       \\type real
  N184, \\field Vertex 61 Y-coordinate
       \\units m
       \\type real
  N185, \\field Vertex 61 Z-coordinate
       \\units m
       \\type real
  N186, \\field Vertex 62 X-coordinate
       \\units m
       \\type real
  N187, \\field Vertex 62 Y-coordinate
       \\units m
       \\type real
  N188, \\field Vertex 62 Z-coordinate
       \\units m
       \\type real
  N189, \\field Vertex 63 X-coordinate
       \\units m
       \\type real
  N190, \\field Vertex 63 Y-coordinate
       \\units m
       \\type real
  N191, \\field Vertex 63 Z-coordinate
       \\units m
       \\type real
  N192, \\field Vertex 64 X-coordinate
       \\units m
       \\type real
  N193, \\field Vertex 64 Y-coordinate
       \\units m
       \\type real
  N194, \\field Vertex 64 Z-coordinate
       \\units m
       \\type real
  N195, \\field Vertex 65 X-coordinate
       \\units m
       \\type real
  N196, \\field Vertex 65 Y-coordinate
       \\units m
       \\type real
  N197, \\field Vertex 65 Z-coordinate
       \\units m
       \\type real
  N198, \\field Vertex 66 X-coordinate
       \\units m
       \\type real
  N199, \\field Vertex 66 Y-coordinate
       \\units m
       \\type real
  N200, \\field Vertex 66 Z-coordinate
       \\units m
       \\type real
  N201, \\field Vertex 67 X-coordinate
       \\units m
       \\type real
  N202, \\field Vertex 67 Y-coordinate
       \\units m
       \\type real
  N203, \\field Vertex 67 Z-coordinate
       \\units m
       \\type real
  N204, \\field Vertex 68 X-coordinate
       \\units m
       \\type real
  N205, \\field Vertex 68 Y-coordinate
       \\units m
       \\type real
  N206, \\field Vertex 68 Z-coordinate
       \\units m
       \\type real
  N207, \\field Vertex 69 X-coordinate
       \\units m
       \\type real
  N208, \\field Vertex 69 Y-coordinate
       \\units m
       \\type real
  N209, \\field Vertex 69 Z-coordinate
       \\units m
       \\type real
  N210, \\field Vertex 70 X-coordinate
       \\units m
       \\type real
  N211, \\field Vertex 70 Y-coordinate
       \\units m
       \\type real
  N212, \\field Vertex 70 Z-coordinate
       \\units m
       \\type real
  N213, \\field Vertex 71 X-coordinate
       \\units m
       \\type real
  N214, \\field Vertex 71 Y-coordinate
       \\units m
       \\type real
  N215, \\field Vertex 71 Z-coordinate
       \\units m
       \\type real
  N216, \\field Vertex 72 X-coordinate
       \\units m
       \\type real
  N217, \\field Vertex 72 Y-coordinate
       \\units m
       \\type real
  N218, \\field Vertex 72 Z-coordinate
       \\units m
       \\type real
  N219, \\field Vertex 73 X-coordinate
       \\units m
       \\type real
  N220, \\field Vertex 73 Y-coordinate
       \\units m
       \\type real
  N221, \\field Vertex 73 Z-coordinate
       \\units m
       \\type real
  N222, \\field Vertex 74 X-coordinate
       \\units m
       \\type real
  N223, \\field Vertex 74 Y-coordinate
       \\units m
       \\type real
  N224, \\field Vertex 74 Z-coordinate
       \\units m
       \\type real
  N225, \\field Vertex 75 X-coordinate
       \\units m
       \\type real
  N226, \\field Vertex 75 Y-coordinate
       \\units m
       \\type real
  N227, \\field Vertex 75 Z-coordinate
       \\units m
       \\type real
  N228, \\field Vertex 76 X-coordinate
       \\units m
       \\type real
  N229, \\field Vertex 76 Y-coordinate
       \\units m
       \\type real
  N230, \\field Vertex 76 Z-coordinate
       \\units m
       \\type real
  N231, \\field Vertex 77 X-coordinate
       \\units m
       \\type real
  N232, \\field Vertex 77 Y-coordinate
       \\units m
       \\type real
  N233, \\field Vertex 77 Z-coordinate
       \\units m
       \\type real
  N234, \\field Vertex 78 X-coordinate
       \\units m
       \\type real
  N235, \\field Vertex 78 Y-coordinate
       \\units m
       \\type real
  N236, \\field Vertex 78 Z-coordinate
       \\units m
       \\type real
  N237, \\field Vertex 79 X-coordinate
       \\units m
       \\type real
  N238, \\field Vertex 79 Y-coordinate
       \\units m
       \\type real
  N239, \\field Vertex 79 Z-coordinate
       \\units m
       \\type real
  N240, \\field Vertex 80 X-coordinate
       \\units m
       \\type real
  N241, \\field Vertex 80 Y-coordinate
       \\units m
       \\type real
  N242, \\field Vertex 80 Z-coordinate
       \\units m
       \\type real
  N243, \\field Vertex 81 X-coordinate
       \\units m
       \\type real
  N244, \\field Vertex 81 Y-coordinate
       \\units m
       \\type real
  N245, \\field Vertex 81 Z-coordinate
       \\units m
       \\type real
  N246, \\field Vertex 82 X-coordinate
       \\units m
       \\type real
  N247, \\field Vertex 82 Y-coordinate
       \\units m
       \\type real
  N248, \\field Vertex 82 Z-coordinate
       \\units m
       \\type real
  N249, \\field Vertex 83 X-coordinate
       \\units m
       \\type real
  N250, \\field Vertex 83 Y-coordinate
       \\units m
       \\type real
  N251, \\field Vertex 83 Z-coordinate
       \\units m
       \\type real
  N252, \\field Vertex 84 X-coordinate
       \\units m
       \\type real
  N253, \\field Vertex 84 Y-coordinate
       \\units m
       \\type real
  N254, \\field Vertex 84 Z-coordinate
       \\units m
       \\type real
  N255, \\field Vertex 85 X-coordinate
       \\units m
       \\type real
  N256, \\field Vertex 85 Y-coordinate
       \\units m
       \\type real
  N257, \\field Vertex 85 Z-coordinate
       \\units m
       \\type real
  N258, \\field Vertex 86 X-coordinate
       \\units m
       \\type real
  N259, \\field Vertex 86 Y-coordinate
       \\units m
       \\type real
  N260, \\field Vertex 86 Z-coordinate
       \\units m
       \\type real
  N261, \\field Vertex 87 X-coordinate
       \\units m
       \\type real
  N262, \\field Vertex 87 Y-coordinate
       \\units m
       \\type real
  N263, \\field Vertex 87 Z-coordinate
       \\units m
       \\type real
  N264, \\field Vertex 88 X-coordinate
       \\units m
       \\type real
  N265, \\field Vertex 88 Y-coordinate
       \\units m
       \\type real
  N266, \\field Vertex 88 Z-coordinate
       \\units m
       \\type real
  N267, \\field Vertex 89 X-coordinate
       \\units m
       \\type real
  N268, \\field Vertex 89 Y-coordinate
       \\units m
       \\type real
  N269, \\field Vertex 89 Z-coordinate
       \\units m
       \\type real
  N270, \\field Vertex 90 X-coordinate
       \\units m
       \\type real
  N271, \\field Vertex 90 Y-coordinate
       \\units m
       \\type real
  N272, \\field Vertex 90 Z-coordinate
       \\units m
       \\type real
  N273, \\field Vertex 91 X-coordinate
       \\units m
       \\type real
  N274, \\field Vertex 91 Y-coordinate
       \\units m
       \\type real
  N275, \\field Vertex 91 Z-coordinate
       \\units m
       \\type real
  N276, \\field Vertex 92 X-coordinate
       \\units m
       \\type real
  N277, \\field Vertex 92 Y-coordinate
       \\units m
       \\type real
  N278, \\field Vertex 92 Z-coordinate
       \\units m
       \\type real
  N279, \\field Vertex 93 X-coordinate
       \\units m
       \\type real
  N280, \\field Vertex 93 Y-coordinate
       \\units m
       \\type real
  N281, \\field Vertex 93 Z-coordinate
       \\units m
       \\type real
  N282, \\field Vertex 94 X-coordinate
       \\units m
       \\type real
  N283, \\field Vertex 94 Y-coordinate
       \\units m
       \\type real
  N284, \\field Vertex 94 Z-coordinate
       \\units m
       \\type real
  N285, \\field Vertex 95 X-coordinate
       \\units m
       \\type real
  N286, \\field Vertex 95 Y-coordinate
       \\units m
       \\type real
  N287, \\field Vertex 95 Z-coordinate
       \\units m
       \\type real
  N288, \\field Vertex 96 X-coordinate
       \\units m
       \\type real
  N289, \\field Vertex 96 Y-coordinate
       \\units m
       \\type real
  N290, \\field Vertex 96 Z-coordinate
       \\units m
       \\type real
  N291, \\field Vertex 97 X-coordinate
       \\units m
       \\type real
  N292, \\field Vertex 97 Y-coordinate
       \\units m
       \\type real
  N293, \\field Vertex 97 Z-coordinate
       \\units m
       \\type real
  N294, \\field Vertex 98 X-coordinate
       \\units m
       \\type real
  N295, \\field Vertex 98 Y-coordinate
       \\units m
       \\type real
  N296, \\field Vertex 98 Z-coordinate
       \\units m
       \\type real
  N297, \\field Vertex 99 X-coordinate
       \\units m
       \\type real
  N298, \\field Vertex 99 Y-coordinate
       \\units m
       \\type real
  N299, \\field Vertex 99 Z-coordinate
       \\units m
       \\type real
  N300, \\field Vertex 100 X-coordinate
       \\units m
       \\type real
  N301, \\field Vertex 100 Y-coordinate
       \\units m
       \\type real
  N302, \\field Vertex 100 Z-coordinate
       \\units m
       \\type real
  N303, \\field Vertex 101 X-coordinate
       \\units m
       \\type real
  N304, \\field Vertex 101 Y-coordinate
       \\units m
       \\type real
  N305, \\field Vertex 101 Z-coordinate
       \\units m
       \\type real
  N306, \\field Vertex 102 X-coordinate
       \\units m
       \\type real
  N307, \\field Vertex 102 Y-coordinate
       \\units m
       \\type real
  N308, \\field Vertex 102 Z-coordinate
       \\units m
       \\type real
  N309, \\field Vertex 103 X-coordinate
       \\units m
       \\type real
  N310, \\field Vertex 103 Y-coordinate
       \\units m
       \\type real
  N311, \\field Vertex 103 Z-coordinate
       \\units m
       \\type real
  N312, \\field Vertex 104 X-coordinate
       \\units m
       \\type real
  N313, \\field Vertex 104 Y-coordinate
       \\units m
       \\type real
  N314, \\field Vertex 104 Z-coordinate
       \\units m
       \\type real
  N315, \\field Vertex 105 X-coordinate
       \\units m
       \\type real
  N316, \\field Vertex 105 Y-coordinate
       \\units m
       \\type real
  N317, \\field Vertex 105 Z-coordinate
       \\units m
       \\type real
  N318, \\field Vertex 106 X-coordinate
       \\units m
       \\type real
  N319, \\field Vertex 106 Y-coordinate
       \\units m
       \\type real
  N320, \\field Vertex 106 Z-coordinate
       \\units m
       \\type real
  N321, \\field Vertex 107 X-coordinate
       \\units m
       \\type real
  N322, \\field Vertex 107 Y-coordinate
       \\units m
       \\type real
  N323, \\field Vertex 107 Z-coordinate
       \\units m
       \\type real
  N324, \\field Vertex 108 X-coordinate
       \\units m
       \\type real
  N325, \\field Vertex 108 Y-coordinate
       \\units m
       \\type real
  N326, \\field Vertex 108 Z-coordinate
       \\units m
       \\type real
  N327, \\field Vertex 109 X-coordinate
       \\units m
       \\type real
  N328, \\field Vertex 109 Y-coordinate
       \\units m
       \\type real
  N329, \\field Vertex 109 Z-coordinate
       \\units m
       \\type real
  N330, \\field Vertex 110 X-coordinate
       \\units m
       \\type real
  N331, \\field Vertex 110 Y-coordinate
       \\units m
       \\type real
  N332, \\field Vertex 110 Z-coordinate
       \\units m
       \\type real
  N333, \\field Vertex 111 X-coordinate
       \\units m
       \\type real
  N334, \\field Vertex 111 Y-coordinate
       \\units m
       \\type real
  N335, \\field Vertex 111 Z-coordinate
       \\units m
       \\type real
  N336, \\field Vertex 112 X-coordinate
       \\units m
       \\type real
  N337, \\field Vertex 112 Y-coordinate
       \\units m
       \\type real
  N338, \\field Vertex 112 Z-coordinate
       \\units m
       \\type real
  N339, \\field Vertex 113 X-coordinate
       \\units m
       \\type real
  N340, \\field Vertex 113 Y-coordinate
       \\units m
       \\type real
  N341, \\field Vertex 113 Z-coordinate
       \\units m
       \\type real
  N342, \\field Vertex 114 X-coordinate
       \\units m
       \\type real
  N343, \\field Vertex 114 Y-coordinate
       \\units m
       \\type real
  N344, \\field Vertex 114 Z-coordinate
       \\units m
       \\type real
  N345, \\field Vertex 115 X-coordinate
       \\units m
       \\type real
  N346, \\field Vertex 115 Y-coordinate
       \\units m
       \\type real
  N347, \\field Vertex 115 Z-coordinate
       \\units m
       \\type real
  N348, \\field Vertex 116 X-coordinate
       \\units m
       \\type real
  N349, \\field Vertex 116 Y-coordinate
       \\units m
       \\type real
  N350, \\field Vertex 116 Z-coordinate
       \\units m
       \\type real
  N351, \\field Vertex 117 X-coordinate
       \\units m
       \\type real
  N352, \\field Vertex 117 Y-coordinate
       \\units m
       \\type real
  N353, \\field Vertex 117 Z-coordinate
       \\units m
       \\type real
  N354, \\field Vertex 118 X-coordinate
       \\units m
       \\type real
  N355, \\field Vertex 118 Y-coordinate
       \\units m
       \\type real
  N356, \\field Vertex 118 Z-coordinate
       \\units m
       \\type real
  N357, \\field Vertex 119 X-coordinate
       \\units m
       \\type real
  N358, \\field Vertex 119 Y-coordinate
       \\units m
       \\type real
  N359, \\field Vertex 119 Z-coordinate
       \\units m
       \\type real
  N360, \\field Vertex 120 X-coordinate
       \\units m
       \\type real
  N361, \\field Vertex 120 Y-coordinate
       \\units m
       \\type real
  N362; \\field Vertex 120 Z-coordinate
       \\units m
       \\type real

Wall:Detailed,
  \\memo Allows for detailed entry of wall heat transfer surfaces.
  \\extensible:3 -- duplicate last set of x,y,z coordinates (last 3 fields), remembering to remove ; from "inner" fields.
  \\format vertices
  \\min-fields 18
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SurfaceNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference HeatTranBaseSurfNames
       \\reference OutFaceEnvNames
       \\reference AllHeatTranAngFacNames
       \\reference RadGroupAndSurfNames
       \\reference SurfGroupAndHTSurfNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Zone Name
       \\required-field
       \\note Zone the surface is a part of
       \\type object-list
       \\object-list ZoneNames
  A4 , \\field Outside Boundary Condition
       \\required-field
       \\type choice
       \\key Adiabatic
       \\key Surface
       \\key Zone
       \\key Outdoors
       \\key Ground
       \\key GroundFCfactorMethod
       \\key OtherSideCoefficients
       \\key OtherSideConditionsModel
       \\key GroundSlabPreprocessorAverage
       \\key GroundSlabPreprocessorCore
       \\key GroundSlabPreprocessorPerimeter
       \\key GroundBasementPreprocessorAverageWall
       \\key GroundBasementPreprocessorAverageFloor
       \\key GroundBasementPreprocessorUpperWall
       \\key GroundBasementPreprocessorLowerWall
  A5,  \\field Outside Boundary Condition Object
       \\type object-list
       \\object-list OutFaceEnvNames
       \\note Non-blank only if the field Outside Boundary Condition is Surface,
       \\note Zone, OtherSideCoefficients or OtherSideConditionsModel
       \\note If Surface, specify name of corresponding surface in adjacent zone or
       \\note specify current surface name for internal partition separating like zones
       \\note If Zone, specify the name of the corresponding zone and
       \\note the program will generate the corresponding interzone surface
       \\note If OtherSideCoefficients, specify name of SurfaceProperty:OtherSideCoefficients
       \\note If OtherSideConditionsModel, specify name of SurfaceProperty:OtherSideConditionsModel
  A6 , \\field Sun Exposure
       \\required-field
       \\type choice
       \\key SunExposed
       \\key NoSun
       \\default SunExposed
  A7,  \\field Wind Exposure
       \\required-field
       \\type choice
       \\key WindExposed
       \\key NoWind
       \\default WindExposed
  N1,  \\field View Factor to Ground
       \\type real
       \\note From the exterior of the surface
       \\note Unused if one uses the "reflections" options in Solar Distribution in Building input
       \\note unless a DaylightingDevice:Shelf or DaylightingDevice:Tubular object has been specified.
       \\note autocalculate will automatically calculate this value from the tilt of the surface
       \\autocalculatable
       \\minimum 0.0
       \\maximum 1.0
       \\default autocalculate
  N2 , \\field Number of Vertices
       \\note shown with 10 vertex coordinates -- extensible object
       \\note  "extensible" -- duplicate last set of x,y,z coordinates, renumbering please
       \\note (and changing z terminator to a comma "," for all but last one which needs a semi-colon ";")
       \\autocalculatable
       \\minimum 3
       \\default autocalculate
       \\note vertices are given in GlobalGeometryRules coordinates -- if relative, all surface coordinates
       \\note are "relative" to the Zone Origin.  If world, then building and zone origins are used
       \\note for some internal calculations, but all coordinates are given in an "absolute" system.
  N3,  \\field Vertex 1 X-coordinate
       \\begin-extensible
       \\required-field
       \\units m
       \\type real
  N4 , \\field Vertex 1 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N5 , \\field Vertex 1 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N6,  \\field Vertex 2 X-coordinate
       \\required-field
       \\units m
       \\type real
  N7,  \\field Vertex 2 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N8,  \\field Vertex 2 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N9,  \\field Vertex 3 X-coordinate
       \\required-field
       \\units m
       \\type real
  N10, \\field Vertex 3 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N11, \\field Vertex 3 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N12, \\field Vertex 4 X-coordinate
       \\units m
       \\type real
  N13, \\field Vertex 4 Y-coordinate
       \\type real
       \\units m
  N14, \\field Vertex 4 Z-coordinate
       \\units m
       \\type real
  N15, \\field Vertex 5 X-coordinate
       \\units m
       \\type real
  N16, \\field Vertex 5 Y-coordinate
       \\type real
       \\units m
  N17, \\field Vertex 5 Z-coordinate
       \\units m
       \\type real
  N18, \\field Vertex 6 X-coordinate
       \\units m
       \\type real
  N19, \\field Vertex 6 Y-coordinate
       \\type real
       \\units m
  N20, \\field Vertex 6 Z-coordinate
       \\units m
       \\type real
  N21, \\field Vertex 7 X-coordinate
       \\units m
       \\type real
  N22, \\field Vertex 7 Y-coordinate
       \\type real
       \\units m
  N23, \\field Vertex 7 Z-coordinate
       \\units m
       \\type real
  N24, \\field Vertex 8 X-coordinate
       \\units m
       \\type real
  N25, \\field Vertex 8 Y-coordinate
       \\type real
       \\units m
  N26, \\field Vertex 8 Z-coordinate
       \\units m
       \\type real
  N27, \\field Vertex 9 X-coordinate
       \\units m
       \\type real
  N28, \\field Vertex 9 Y-coordinate
       \\type real
       \\units m
  N29, \\field Vertex 9 Z-coordinate
       \\units m
       \\type real
  N30, \\field Vertex 10 X-coordinate
       \\units m
       \\type real
  N31, \\field Vertex 10 Y-coordinate
       \\type real
       \\units m
  N32; \\field Vertex 10 Z-coordinate
       \\units m
       \\type real

RoofCeiling:Detailed,
  \\memo Allows for detailed entry of roof/ceiling heat transfer surfaces.
  \\extensible:3 -- duplicate last set of x,y,z coordinates (last 3 fields), remembering to remove ; from "inner" fields.
  \\format vertices
  \\min-fields 18
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SurfaceNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference HeatTranBaseSurfNames
       \\reference OutFaceEnvNames
       \\reference AllHeatTranAngFacNames
       \\reference RadGroupAndSurfNames
       \\reference SurfGroupAndHTSurfNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Zone Name
       \\required-field
       \\note Zone the surface is a part of
       \\type object-list
       \\object-list ZoneNames
  A4 , \\field Outside Boundary Condition
       \\required-field
       \\type choice
       \\key Adiabatic
       \\key Surface
       \\key Zone
       \\key Outdoors
       \\key Ground
       \\key OtherSideCoefficients
       \\key OtherSideConditionsModel
       \\key GroundSlabPreprocessorAverage
       \\key GroundSlabPreprocessorCore
       \\key GroundSlabPreprocessorPerimeter
       \\key GroundBasementPreprocessorAverageWall
       \\key GroundBasementPreprocessorAverageFloor
       \\key GroundBasementPreprocessorUpperWall
       \\key GroundBasementPreprocessorLowerWall
 A5,  \\field Outside Boundary Condition Object
       \\type object-list
       \\object-list OutFaceEnvNames
       \\note Non-blank only if the field Outside Boundary Condition is Surface,
       \\note Zone, OtherSideCoefficients or OtherSideConditionsModel
       \\note If Surface, specify name of corresponding surface in adjacent zone or
       \\note specify current surface name for internal partition separating like zones
       \\note If Zone, specify the name of the corresponding zone and
       \\note the program will generate the corresponding interzone surface
       \\note If OtherSideCoefficients, specify name of SurfaceProperty:OtherSideCoefficients
       \\note If OtherSideConditionsModel, specify name of SurfaceProperty:OtherSideConditionsModel
  A6 , \\field Sun Exposure
       \\required-field
       \\type choice
       \\key SunExposed
       \\key NoSun
       \\default SunExposed
  A7,  \\field Wind Exposure
       \\required-field
       \\type choice
       \\key WindExposed
       \\key NoWind
       \\default WindExposed
  N1,  \\field View Factor to Ground
       \\type real
       \\note From the exterior of the surface
       \\note Unused if one uses the "reflections" options in Solar Distribution in Building input
       \\note unless a DaylightingDevice:Shelf or DaylightingDevice:Tubular object has been specified.
       \\note autocalculate will automatically calculate this value from the tilt of the surface
       \\autocalculatable
       \\minimum 0.0
       \\maximum 1.0
       \\default autocalculate
  N2 , \\field Number of Vertices
       \\note shown with 10 vertex coordinates -- extensible object
       \\note  "extensible" -- duplicate last set of x,y,z coordinates, renumbering please
       \\note (and changing z terminator to a comma "," for all but last one which needs a semi-colon ";")
       \\autocalculatable
       \\minimum 3
       \\default autocalculate
       \\note vertices are given in GlobalGeometryRules coordinates -- if relative, all surface coordinates
       \\note are "relative" to the Zone Origin.  If world, then building and zone origins are used
       \\note for some internal calculations, but all coordinates are given in an "absolute" system.
  N3,  \\field Vertex 1 X-coordinate
       \\begin-extensible
       \\required-field
       \\units m
       \\type real
  N4 , \\field Vertex 1 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N5 , \\field Vertex 1 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N6,  \\field Vertex 2 X-coordinate
       \\required-field
       \\units m
       \\type real
  N7,  \\field Vertex 2 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N8,  \\field Vertex 2 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N9,  \\field Vertex 3 X-coordinate
       \\required-field
       \\units m
       \\type real
  N10, \\field Vertex 3 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N11, \\field Vertex 3 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N12, \\field Vertex 4 X-coordinate
       \\units m
       \\type real
  N13, \\field Vertex 4 Y-coordinate
       \\type real
       \\units m
  N14, \\field Vertex 4 Z-coordinate
       \\units m
       \\type real
  N15, \\field Vertex 5 X-coordinate
       \\units m
       \\type real
  N16, \\field Vertex 5 Y-coordinate
       \\type real
       \\units m
  N17, \\field Vertex 5 Z-coordinate
       \\units m
       \\type real
  N18, \\field Vertex 6 X-coordinate
       \\units m
       \\type real
  N19, \\field Vertex 6 Y-coordinate
       \\type real
       \\units m
  N20, \\field Vertex 6 Z-coordinate
       \\units m
       \\type real
  N21, \\field Vertex 7 X-coordinate
       \\units m
       \\type real
  N22, \\field Vertex 7 Y-coordinate
       \\type real
       \\units m
  N23, \\field Vertex 7 Z-coordinate
       \\units m
       \\type real
  N24, \\field Vertex 8 X-coordinate
       \\units m
       \\type real
  N25, \\field Vertex 8 Y-coordinate
       \\type real
       \\units m
  N26, \\field Vertex 8 Z-coordinate
       \\units m
       \\type real
  N27, \\field Vertex 9 X-coordinate
       \\units m
       \\type real
  N28, \\field Vertex 9 Y-coordinate
       \\type real
       \\units m
  N29, \\field Vertex 9 Z-coordinate
       \\units m
       \\type real
  N30, \\field Vertex 10 X-coordinate
       \\units m
       \\type real
  N31, \\field Vertex 10 Y-coordinate
       \\type real
       \\units m
  N32; \\field Vertex 10 Z-coordinate
       \\units m
       \\type real

Floor:Detailed,
  \\memo Allows for detailed entry of floor heat transfer surfaces.
  \\extensible:3 -- duplicate last set of x,y,z coordinates (last 3 fields), remembering to remove ; from "inner" fields.
  \\format vertices
  \\min-fields 18
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SurfaceNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference HeatTranBaseSurfNames
       \\reference OutFaceEnvNames
       \\reference AllHeatTranAngFacNames
       \\reference RadGroupAndSurfNames
       \\reference SurfGroupAndHTSurfNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Zone Name
       \\required-field
       \\note Zone the surface is a part of
       \\type object-list
       \\object-list ZoneNames
  A4 , \\field Outside Boundary Condition
       \\required-field
       \\type choice
       \\key Adiabatic
       \\key Surface
       \\key Zone
       \\key Outdoors
       \\key Ground
       \\key GroundFCfactorMethod
       \\key OtherSideCoefficients
       \\key OtherSideConditionsModel
       \\key GroundSlabPreprocessorAverage
       \\key GroundSlabPreprocessorCore
       \\key GroundSlabPreprocessorPerimeter
       \\key GroundBasementPreprocessorAverageWall
       \\key GroundBasementPreprocessorAverageFloor
       \\key GroundBasementPreprocessorUpperWall
       \\key GroundBasementPreprocessorLowerWall
 A5,  \\field Outside Boundary Condition Object
       \\type object-list
       \\object-list OutFaceEnvNames
       \\note Non-blank only if the field Outside Boundary Condition is Surface,
       \\note Zone, OtherSideCoefficients or OtherSideConditionsModel
       \\note If Surface, specify name of corresponding surface in adjacent zone or
       \\note specify current surface name for internal partition separating like zones
       \\note If Zone, specify the name of the corresponding zone and
       \\note the program will generate the corresponding interzone surface
       \\note If OtherSideCoefficients, specify name of SurfaceProperty:OtherSideCoefficients
       \\note If OtherSideConditionsModel, specify name of SurfaceProperty:OtherSideConditionsModel
  A6 , \\field Sun Exposure
       \\required-field
       \\type choice
       \\key SunExposed
       \\key NoSun
       \\default SunExposed
  A7,  \\field Wind Exposure
       \\required-field
       \\type choice
       \\key WindExposed
       \\key NoWind
       \\default WindExposed
  N1,  \\field View Factor to Ground
       \\type real
       \\note From the exterior of the surface
       \\note Unused if one uses the "reflections" options in Solar Distribution in Building input
       \\note unless a DaylightingDevice:Shelf or DaylightingDevice:Tubular object has been specified.
       \\note autocalculate will automatically calculate this value from the tilt of the surface
       \\autocalculatable
       \\minimum 0.0
       \\maximum 1.0
       \\default autocalculate
  N2 , \\field Number of Vertices
       \\note shown with 10 vertex coordinates -- extensible object
       \\note  "extensible" -- duplicate last set of x,y,z coordinates, renumbering please
       \\note (and changing z terminator to a comma "," for all but last one which needs a semi-colon ";")
       \\autocalculatable
       \\minimum 3
       \\default autocalculate
       \\note vertices are given in GlobalGeometryRules coordinates -- if relative, all surface coordinates
       \\note are "relative" to the Zone Origin.  If world, then building and zone origins are used
       \\note for some internal calculations, but all coordinates are given in an "absolute" system.
  N3,  \\field Vertex 1 X-coordinate
       \\begin-extensible
       \\required-field
       \\units m
       \\type real
  N4 , \\field Vertex 1 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N5 , \\field Vertex 1 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N6,  \\field Vertex 2 X-coordinate
       \\required-field
       \\units m
       \\type real
  N7,  \\field Vertex 2 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N8,  \\field Vertex 2 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N9,  \\field Vertex 3 X-coordinate
       \\required-field
       \\units m
       \\type real
  N10, \\field Vertex 3 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N11, \\field Vertex 3 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N12, \\field Vertex 4 X-coordinate
       \\units m
       \\type real
  N13, \\field Vertex 4 Y-coordinate
       \\type real
       \\units m
  N14, \\field Vertex 4 Z-coordinate
       \\units m
       \\type real
  N15, \\field Vertex 5 X-coordinate
       \\units m
       \\type real
  N16, \\field Vertex 5 Y-coordinate
       \\type real
       \\units m
  N17, \\field Vertex 5 Z-coordinate
       \\units m
       \\type real
  N18, \\field Vertex 6 X-coordinate
       \\units m
       \\type real
  N19, \\field Vertex 6 Y-coordinate
       \\type real
       \\units m
  N20, \\field Vertex 6 Z-coordinate
       \\units m
       \\type real
  N21, \\field Vertex 7 X-coordinate
       \\units m
       \\type real
  N22, \\field Vertex 7 Y-coordinate
       \\type real
       \\units m
  N23, \\field Vertex 7 Z-coordinate
       \\units m
       \\type real
  N24, \\field Vertex 8 X-coordinate
       \\units m
       \\type real
  N25, \\field Vertex 8 Y-coordinate
       \\type real
       \\units m
  N26, \\field Vertex 8 Z-coordinate
       \\units m
       \\type real
  N27, \\field Vertex 9 X-coordinate
       \\units m
       \\type real
  N28, \\field Vertex 9 Y-coordinate
       \\type real
       \\units m
  N29, \\field Vertex 9 Z-coordinate
       \\units m
       \\type real
  N30, \\field Vertex 10 X-coordinate
       \\units m
       \\type real
  N31, \\field Vertex 10 Y-coordinate
       \\type real
       \\units m
  N32; \\field Vertex 10 Z-coordinate
       \\units m
       \\type real

Wall:Exterior,
       \\memo Allows for simplified entry of exterior walls.
       \\memo View Factor to Ground is automatically calculated.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SurfaceNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference HeatTranBaseSurfNames
       \\reference AllHeatTranAngFacNames
       \\reference RadGroupAndSurfNames
       \\reference SurfGroupAndHTSurfNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Zone Name
       \\required-field
       \\note Zone the surface is a part of
       \\type object-list
       \\object-list ZoneNames
  N1,  \\field Azimuth Angle
       \\note Facing direction of outside of wall (S=180,N=0,E=90,W=270)
       \\minimum 0
       \\maximum 360
       \\units deg
  N2,  \\field Tilt Angle
       \\note Walls are usually tilted 90 degrees
       \\default 90
       \\minimum 0
       \\maximum 180
       \\units deg
  N3,  \\field Starting X Coordinate
       \\note Starting (x,y,z) coordinate is the Lower Left Corner of the Wall
       \\units m
  N4,  \\field Starting Y Coordinate
       \\units m
  N5,  \\field Starting Z Coordinate
       \\units m
  N6,  \\field Length
       \\units m
  N7;  \\field Height
       \\units m

Wall:Adiabatic,
       \\memo Allows for simplified entry of interior walls.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SurfaceNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference HeatTranBaseSurfNames
       \\reference AllHeatTranAngFacNames
       \\reference RadGroupAndSurfNames
       \\reference SurfGroupAndHTSurfNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Zone Name
       \\required-field
       \\note Zone the surface is a part of
       \\type object-list
       \\object-list ZoneNames
  N1,  \\field Azimuth Angle
       \\note Facing direction of outside of wall (S=180,N=0,E=90,W=270)
       \\minimum 0
       \\maximum 360
       \\units deg
  N2,  \\field Tilt Angle
       \\note Walls are usually tilted 90 degrees
       \\default 90
       \\minimum 0
       \\maximum 180
       \\units deg
  N3,  \\field Starting X Coordinate
       \\note Starting (x,y,z) coordinate is the Lower Left Corner of the Wall
       \\units m
  N4,  \\field Starting Y Coordinate
       \\units m
  N5,  \\field Starting Z Coordinate
       \\units m
  N6,  \\field Length
       \\units m
  N7;  \\field Height
       \\units m

Wall:Underground,
       \\memo Allows for simplified entry of underground walls.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SurfaceNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference HeatTranBaseSurfNames
       \\reference AllHeatTranAngFacNames
       \\reference RadGroupAndSurfNames
       \\reference SurfGroupAndHTSurfNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file.
       \\note If the construction is type "Construction:CfactorUndergroundWall",
       \\note then the GroundFCfactorMethod will be used.
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Zone Name
       \\required-field
       \\note Zone the surface is a part of
       \\type object-list
       \\object-list ZoneNames
  N1,  \\field Azimuth Angle
       \\note Facing direction of outside of wall (S=180,N=0,E=90,W=270)
       \\minimum 0
       \\maximum 360
       \\units deg
  N2,  \\field Tilt Angle
       \\note Walls are usually tilted 90 degrees
       \\default 90
       \\minimum 0
       \\maximum 180
       \\units deg
  N3,  \\field Starting X Coordinate
       \\note Starting (x,y,z) coordinate is the Lower Left Corner of the Wall
       \\units m
  N4,  \\field Starting Y Coordinate
       \\units m
  N5,  \\field Starting Z Coordinate
       \\units m
  N6,  \\field Length
       \\units m
  N7;  \\field Height
       \\units m

Wall:Interzone,
       \\memo Allows for simplified entry of interzone walls (walls between zones).
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SurfaceNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference HeatTranBaseSurfNames
       \\reference OutFaceEnvNames
       \\reference AllHeatTranAngFacNames
       \\reference RadGroupAndSurfNames
       \\reference SurfGroupAndHTSurfNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Zone Name
       \\required-field
       \\note Zone for the inside of the surface
       \\type object-list
       \\object-list ZoneNames
  A4 , \\field Outside Boundary Condition Object
       \\required-field
       \\note Specify a surface name in an adjacent zone for known interior walls.
       \\note Specify a zone name of an adjacent zone to automatically generate
       \\note the interior wall in the adjacent zone.
       \\type object-list
       \\object-list OutFaceEnvNames
  N1,  \\field Azimuth Angle
       \\note Facing direction of outside of wall (S=180,N=0,E=90,W=270)
       \\minimum 0
       \\maximum 360
       \\units deg
  N2,  \\field Tilt Angle
       \\note Walls are usually tilted 90 degrees
       \\default 90
       \\minimum 0
       \\maximum 180
       \\units deg
  N3,  \\field Starting X Coordinate
       \\note Starting (x,y,z) coordinate is the Lower Left Corner of the Wall
       \\units m
  N4,  \\field Starting Y Coordinate
       \\units m
  N5,  \\field Starting Z Coordinate
       \\units m
  N6,  \\field Length
       \\units m
  N7;  \\field Height
       \\units m

Roof,
       \\memo Allows for simplified entry of roofs (exterior).
       \\memo View Factor to Ground is automatically calculated.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SurfaceNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference HeatTranBaseSurfNames
       \\reference AllHeatTranAngFacNames
       \\reference RadGroupAndSurfNames
       \\reference SurfGroupAndHTSurfNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Zone Name
       \\required-field
       \\note Zone the surface is a part of
       \\type object-list
       \\object-list ZoneNames
  N1,  \\field Azimuth Angle
       \\note Facing direction of outside of Roof
       \\minimum 0
       \\maximum 360
       \\units deg
  N2,  \\field Tilt Angle
       \\note Flat Roofs are tilted 0 degrees
       \\minimum 0
       \\maximum 180
       \\default 0
       \\units deg
  N3,  \\field Starting X Coordinate
       \\note If not Flat, Starting coordinate is the Lower Left Corner of the Roof
       \\units m
  N4,  \\field Starting Y Coordinate
       \\units m
  N5,  \\field Starting Z Coordinate
       \\units m
  N6,  \\field Length
       \\note Along X Axis
       \\units m
  N7;  \\field Width
       \\note Along Y Axis
       \\units m

Ceiling:Adiabatic,
       \\memo Allows for simplified entry of interior ceilings.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SurfaceNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference HeatTranBaseSurfNames
       \\reference AllHeatTranAngFacNames
       \\reference RadGroupAndSurfNames
       \\reference SurfGroupAndHTSurfNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Zone Name
       \\required-field
       \\note Zone the surface is a part of
       \\type object-list
       \\object-list ZoneNames
  N1,  \\field Azimuth Angle
       \\note Facing direction of outside of Ceiling
       \\minimum 0
       \\maximum 360
       \\units deg
  N2,  \\field Tilt Angle
       \\note Ceilings are usually tilted 0 degrees
       \\minimum 0
       \\maximum 180
       \\default 0
       \\units deg
  N3,  \\field Starting X Coordinate
       \\note If not Flat, Starting coordinate is the Lower Left Corner of the Ceiling
       \\units m
  N4,  \\field Starting Y Coordinate
       \\units m
  N5,  \\field Starting Z Coordinate
       \\units m
  N6,  \\field Length
       \\note Along X Axis
       \\units m
  N7;  \\field Width
       \\note Along Y Axis
       \\units m

Ceiling:Interzone,
       \\memo Allows for simplified entry of ceilings using adjacent zone
       \\memo (interzone) heat transfer - adjacent surface should be a floor
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SurfaceNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference OutFaceEnvNames
       \\reference HeatTranBaseSurfNames
       \\reference AllHeatTranAngFacNames
       \\reference RadGroupAndSurfNames
       \\reference SurfGroupAndHTSurfNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Zone Name
       \\required-field
       \\note Zone for the inside of the surface
       \\type object-list
       \\object-list ZoneNames
  A4 , \\field Outside Boundary Condition Object
       \\required-field
       \\note Specify a surface name in an adjacent zone for known interior floors
       \\note Specify a zone name of an adjacent zone to automatically generate
       \\note the interior floor in the adjacent zone.
       \\type object-list
       \\object-list OutFaceEnvNames
  N1,  \\field Azimuth Angle
       \\note Facing direction of outside of wall (S=180,N=0,E=90,W=270)
       \\minimum 0
       \\maximum 360
       \\units deg
  N2,  \\field Tilt Angle
       \\note Ceilings are usually tilted 0 degrees
       \\minimum 0
       \\maximum 180
       \\default 0
       \\units deg
  N3,  \\field Starting X Coordinate
       \\note If not Flat, should be Lower Left Corner (from outside)
       \\units m
  N4,  \\field Starting Y Coordinate
       \\units m
  N5,  \\field Starting Z Coordinate
       \\units m
  N6,  \\field Length
       \\note Along X Axis
       \\units m
  N7;  \\field Width
       \\note Along Y Axis
       \\units m

Floor:GroundContact,
       \\memo Allows for simplified entry of exterior floors with ground contact.
       \\memo View Factors to Ground is automatically calculated.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SurfaceNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference HeatTranBaseSurfNames
       \\reference AllHeatTranAngFacNames
       \\reference RadGroupAndSurfNames
       \\reference SurfGroupAndHTSurfNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\note If the construction is type "Construction:FfactorGroundFloor",
       \\note then the GroundFCfactorMethod will be used.
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Zone Name
       \\required-field
       \\note Zone the surface is a part of
       \\type object-list
       \\object-list ZoneNames
  N1,  \\field Azimuth Angle
       \\units deg
       \\minimum 0
       \\maximum 360
  N2,  \\field Tilt Angle
       \\note Floors are usually tilted 180 degrees
       \\units deg
       \\minimum 0
       \\maximum 180
       \\default 180
  N3,  \\field Starting X Coordinate
       \\note if not flat, should be lower left corner (from outside)
       \\units m
  N4,  \\field Starting Y Coordinate
       \\units m
  N5,  \\field Starting Z Coordinate
       \\units m
  N6,  \\field Length
       \\note Along X Axis
       \\units m
  N7;  \\field Width
       \\note Along Y Axis
       \\units m

Floor:Adiabatic,
       \\memo Allows for simplified entry of exterior floors
       \\memo ignoring ground contact or interior floors.
       \\memo View Factor to Ground is automatically calculated.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SurfaceNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference HeatTranBaseSurfNames
       \\reference AllHeatTranAngFacNames
       \\reference RadGroupAndSurfNames
       \\reference SurfGroupAndHTSurfNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Zone Name
       \\required-field
       \\note Zone the surface is a part of
       \\type object-list
       \\object-list ZoneNames
  N1,  \\field Azimuth Angle
       \\units deg
       \\minimum 0
       \\maximum 360
  N2,  \\field Tilt Angle
       \\note Floors are usually tilted 180 degrees
       \\units deg
       \\minimum 0
       \\maximum 180
       \\default 180
  N3,  \\field Starting X Coordinate
       \\note if not flat, should be lower left corner (from outside)
       \\units m
  N4,  \\field Starting Y Coordinate
       \\units m
  N5,  \\field Starting Z Coordinate
       \\units m
  N6,  \\field Length
       \\note Along X Axis
       \\units m
  N7;  \\field Width
       \\note Along Y Axis
       \\units m

Floor:Interzone,
       \\memo Allows for simplified entry of floors using adjacent zone
       \\memo (interzone) heat transfer - adjacent surface should be a ceiling.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SurfaceNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference HeatTranBaseSurfNames
       \\reference OutFaceEnvNames
       \\reference AllHeatTranAngFacNames
       \\reference RadGroupAndSurfNames
       \\reference SurfGroupAndHTSurfNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Zone Name
       \\required-field
       \\note Zone for the inside of the surface
       \\type object-list
       \\object-list ZoneNames
  A4 , \\field Outside Boundary Condition Object
       \\required-field
       \\note Specify a surface name in an adjacent zone for known interior ceilings.
       \\note Specify a zone name of an adjacent zone to automatically generate
       \\note the interior ceiling in the adjacent zone.
       \\type object-list
       \\object-list OutFaceEnvNames
  N1,  \\field Azimuth Angle
       \\minimum 0
       \\maximum 360
       \\units deg
  N2,  \\field Tilt Angle
       \\note Floors are usually tilted 180 degrees
       \\minimum 0
       \\maximum 180
       \\default 180
       \\units deg
  N3,  \\field Starting X Coordinate
       \\note If not Flat, should be Lower Left Corner (from outside)
       \\units m
  N4,  \\field Starting Y Coordinate
       \\units m
  N5,  \\field Starting Z Coordinate
       \\units m
  N6,  \\field Length
       \\note Along X Axis
       \\units m
  N7;  \\field Width
       \\note Along Y Axis
       \\units m

FenestrationSurface:Detailed,
       \\memo Allows for detailed entry of subsurfaces
       \\memo (windows, doors, glass doors, tubular daylighting devices).
       \\min-fields 19
       \\format vertices
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SubSurfNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference OutFaceEnvNames
       \\reference AllHeatTranAngFacNames
       \\reference RadGroupAndSurfNames
       \\reference SurfGroupAndHTSurfNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Surface Type
       \\required-field
       \\type choice
       \\key Window
       \\key Door
       \\key GlassDoor
       \\key TubularDaylightDome
       \\key TubularDaylightDiffuser
  A3 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A4 , \\field Building Surface Name
       \\required-field
       \\type object-list
       \\object-list SurfaceNames
  A5,  \\field Outside Boundary Condition Object
       \\type object-list
       \\object-list OutFaceEnvNames
       \\note Non-blank only if base surface field Outside Boundary Condition is
       \\note Surface or OtherSideCoefficients
       \\note If Base Surface's Surface, specify name of corresponding subsurface in adjacent zone or
       \\note specify current subsurface name for internal partition separating like zones
       \\note If OtherSideCoefficients, specify name of SurfaceProperty:OtherSideCoefficients
       \\note  or leave blank to inherit Base Surface's OtherSide Coefficients
  N1, \\field View Factor to Ground
       \\type real
       \\note From the exterior of the surface
       \\note Unused if one uses the "reflections" options in Solar Distribution in Building input
       \\note unless a DaylightingDevice:Shelf or DaylightingDevice:Tubular object has been specified.
       \\note autocalculate will automatically calculate this value from the tilt of the surface
       \\autocalculatable
       \\minimum 0.0
       \\maximum 1.0
       \\default autocalculate
  A6, \\field Shading Control Name
       \\note enter the name of a WindowProperty:ShadingControl object
       \\type object-list
       \\object-list WindowShadeControlNames
       \\note used for windows and glass doors only
       \\note If not specified, window or glass door has no shading (blind, roller shade, etc.)
  A7, \\field Frame and Divider Name
       \\note Enter the name of a WindowProperty:FrameAndDivider object
       \\type object-list
       \\object-list WindowFrameAndDividerNames
       \\note Used only for exterior windows (rectangular) and glass doors.
       \\note Unused for triangular windows.
       \\note If not specified (blank), window or glass door has no frame or divider
       \\note and no beam solar reflection from reveal surfaces.
  N2 , \\field Multiplier
       \\note Used only for Surface Type = WINDOW, GLASSDOOR or DOOR
       \\note Non-integer values will be truncated to integer
       \\default 1.0
       \\minimum 1.0
  N3 , \\field Number of Vertices
       \\minimum 3
       \\maximum 4
       \\autocalculatable
       \\default autocalculate
       \\note vertices are given in GlobalGeometryRules coordinates -- if relative, all surface coordinates
       \\note are "relative" to the Zone Origin.  If world, then building and zone origins are used
       \\note for some internal calculations, but all coordinates are given in an "absolute" system.
  N4,  \\field Vertex 1 X-coordinate
       \\required-field
       \\units m
       \\type real
  N5 , \\field Vertex 1 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N6 , \\field Vertex 1 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N7,  \\field Vertex 2 X-coordinate
       \\required-field
       \\units m
       \\type real
  N8,  \\field Vertex 2 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N9,  \\field Vertex 2 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N10,  \\field Vertex 3 X-coordinate
       \\required-field
       \\units m
       \\type real
  N11, \\field Vertex 3 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N12, \\field Vertex 3 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N13, \\field Vertex 4 X-coordinate
       \\units m
       \\type real
       \\note Not used for triangles
  N14, \\field Vertex 4 Y-coordinate
       \\type real
       \\units m
       \\note Not used for triangles
  N15; \\field Vertex 4 Z-coordinate
       \\units m
       \\type real
       \\note Not used for triangles

Window,
       \\memo Allows for simplified entry of Windows.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SubSurfNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference OutFaceEnvNames
       \\reference AllHeatTranAngFacNames
       \\reference RadGroupAndSurfNames
       \\reference SurfGroupAndHTSurfNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Building Surface Name
       \\note Name of Surface (Wall, usually) the Window is on (i.e., Base Surface)
       \\note Window assumes the azimuth and tilt angles of the surface it is on.
       \\required-field
       \\type object-list
       \\object-list SurfaceNames
  A4, \\field Shading Control Name
       \\note enter the name of a WindowProperty:ShadingControl object
       \\type object-list
       \\object-list WindowShadeControlNames
       \\note used for windows and glass doors only
       \\note If not specified, window or glass door has no shading (blind, roller shade, etc.)
  A5, \\field Frame and Divider Name
       \\note Enter the name of a WindowProperty:FrameAndDivider object
       \\type object-list
       \\object-list WindowFrameAndDividerNames
       \\note Used only for exterior windows (rectangular) and glass doors.
       \\note Unused for triangular windows.
       \\note If not specified (blank), window or glass door has no frame or divider
       \\note and no beam solar reflection from reveal surfaces.
  N1 , \\field Multiplier
       \\note Used only for Surface Type = WINDOW, GLASSDOOR or DOOR
       \\note Non-integer values will be truncated to integer
       \\default 1.0
       \\minimum 1.0
  N2,  \\field Starting X Coordinate
       \\note Window starting coordinate is specified relative to the Base Surface origin.
       \\units m
  N3,  \\field Starting Z Coordinate
       \\note How far up the wall the Window starts. (in 2-d, this would be a Y Coordinate)
       \\units m
  N4,  \\field Length
       \\units m
  N5;  \\field Height
       \\units m

Door,
       \\memo Allows for simplified entry of opaque Doors.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SubSurfNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference OutFaceEnvNames
       \\reference AllHeatTranAngFacNames
       \\reference RadGroupAndSurfNames
       \\reference SurfGroupAndHTSurfNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Building Surface Name
       \\note Name of Surface (Wall, usually) the Door is on (i.e., Base Surface)
       \\note Door assumes the azimuth and tilt angles of the surface it is on.
       \\required-field
       \\type object-list
       \\object-list SurfaceNames
  N1 , \\field Multiplier
       \\note Used only for Surface Type = WINDOW, GLASSDOOR or DOOR
       \\note Non-integer values will be truncated to integer
       \\default 1.0
       \\minimum 1.0
  N2,  \\field Starting X Coordinate
       \\note Door starting coordinate is specified relative to the Base Surface origin.
       \\units m
  N3,  \\field Starting Z Coordinate
       \\note How far up the wall the Door starts. (in 2-d, this would be a Y Coordinate)
       \\units m
  N4,  \\field Length
       \\units m
  N5;  \\field Height
       \\units m

GlazedDoor,
       \\memo Allows for simplified entry of glass Doors.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SubSurfNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference OutFaceEnvNames
       \\reference AllHeatTranAngFacNames
       \\reference RadGroupAndSurfNames
       \\reference SurfGroupAndHTSurfNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Building Surface Name
       \\note Name of Surface (Wall, usually) the Door is on (i.e., Base Surface)
       \\note Door assumes the azimuth and tilt angles of the surface it is on.
       \\required-field
       \\type object-list
       \\object-list SurfaceNames
  A4, \\field Shading Control Name
       \\note enter the name of a WindowProperty:ShadingControl object
       \\type object-list
       \\object-list WindowShadeControlNames
       \\note used for windows and glass doors only
       \\note If not specified, window or glass door has no shading (blind, roller shade, etc.)
  A5, \\field Frame and Divider Name
       \\note Enter the name of a WindowProperty:FrameAndDivider object
       \\type object-list
       \\object-list WindowFrameAndDividerNames
       \\note Used only for exterior windows (rectangular) and glass doors.
       \\note Unused for triangular windows.
       \\note If not specified (blank), window or glass door has no frame or divider
       \\note and no beam solar reflection from reveal surfaces.
  N1 , \\field Multiplier
       \\note Used only for Surface Type = WINDOW, GLASSDOOR or DOOR
       \\note Non-integer values will be truncated to integer
       \\default 1.0
       \\minimum 1.0
  N2,  \\field Starting X Coordinate
       \\note Door starting coordinate is specified relative to the Base Surface origin.
       \\units m
  N3,  \\field Starting Z Coordinate
       \\note How far up the wall the Door starts. (in 2-d, this would be a Y Coordinate)
       \\units m
  N4,  \\field Length
       \\units m
  N5;  \\field Height
       \\units m

Window:Interzone,
       \\memo Allows for simplified entry of interzone windows (adjacent to
       \\memo other zones).
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SubSurfNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference OutFaceEnvNames
       \\reference AllHeatTranAngFacNames
       \\reference RadGroupAndSurfNames
       \\reference SurfGroupAndHTSurfNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Building Surface Name
       \\note Name of Surface (Wall, usually) the Window is on (i.e., Base Surface)
       \\note Window assumes the azimuth and tilt angles of the surface it is on.
       \\required-field
       \\type object-list
       \\object-list SurfaceNames
  A4,  \\field Outside Boundary Condition Object
       \\type object-list
       \\object-list OutFaceEnvNames
       \\note Specify a surface name in an adjacent zone for known interior windows.
       \\note Specify a zone name of an adjacent zone to automatically generate
       \\note the interior window in the adjacent zone.
       \\note a blank field will set up a Window in an adjacent zone
       \\note (same zone as adjacent to base surface)
  N1 , \\field Multiplier
       \\note Used only for Surface Type = WINDOW, GLASSDOOR or DOOR
       \\note Non-integer values will be truncated to integer
       \\default 1.0
       \\minimum 1.0
  N2,  \\field Starting X Coordinate
       \\note Window starting coordinate is specified relative to the Base Surface origin.
       \\units m
  N3,  \\field Starting Z Coordinate
       \\note How far up the wall the Window starts. (in 2-d, this would be a Y Coordinate)
       \\units m
  N4,  \\field Length
       \\units m
  N5;  \\field Height
       \\units m

Door:Interzone,
       \\memo Allows for simplified entry of interzone (opaque interior) doors (adjacent to
       \\memo other zones).
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SubSurfNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference OutFaceEnvNames
       \\reference AllHeatTranAngFacNames
       \\reference RadGroupAndSurfNames
       \\reference SurfGroupAndHTSurfNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Building Surface Name
       \\note Name of Surface (Wall, usually) the Door is on (i.e., Base Surface)
       \\note Door assumes the azimuth and tilt angles of the surface it is on.
       \\required-field
       \\type object-list
       \\object-list SurfaceNames
  A4,  \\field Outside Boundary Condition Object
       \\type object-list
       \\object-list OutFaceEnvNames
       \\note Specify a surface name in an adjacent zone for known interior doors.
       \\note Specify a zone name of an adjacent zone to automatically generate
       \\note the interior door in the adjacent zone.
       \\note a blank field will set up a Window in an adjacent zone
       \\note (same zone as adjacent to base surface)
  N1 , \\field Multiplier
       \\note Used only for Surface Type = WINDOW, GLASSDOOR or DOOR
       \\note Non-integer values will be truncated to integer
       \\default 1.0
       \\minimum 1.0
  N2,  \\field Starting X Coordinate
       \\note Door starting coordinate is specified relative to the Base Surface origin.
       \\units m
  N3,  \\field Starting Z Coordinate
       \\note How far up the wall the Door starts. (in 2-d, this would be a Y Coordinate)
       \\units m
  N4,  \\field Length
       \\units m
  N5;  \\field Height
       \\units m

GlazedDoor:Interzone,
       \\memo Allows for simplified entry of interzone (glass interior) doors (adjacent to
       \\memo other zones).
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SubSurfNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference OutFaceEnvNames
       \\reference AllHeatTranAngFacNames
       \\reference RadGroupAndSurfNames
       \\reference SurfGroupAndHTSurfNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Building Surface Name
       \\note Name of Surface (Wall, usually) the Door is on (i.e., Base Surface)
       \\note Door assumes the azimuth and tilt angles of the surface it is on.
       \\required-field
       \\type object-list
       \\object-list SurfaceNames
  A4,  \\field Outside Boundary Condition Object
       \\type object-list
       \\object-list OutFaceEnvNames
       \\note Specify a surface name in an adjacent zone for known interior doors.
       \\note Specify a zone name of an adjacent zone to automatically generate
       \\note the interior door in the adjacent zone.
       \\note a blank field will set up a Window in an adjacent zone
       \\note (same zone as adjacent to base surface)
  N1 , \\field Multiplier
       \\note Used only for Surface Type = WINDOW, GLASSDOOR or DOOR
       \\note Non-integer values will be truncated to integer
       \\default 1.0
       \\minimum 1.0
  N2,  \\field Starting X Coordinate
       \\note Door starting coordinate is specified relative to the Base Surface origin.
       \\units m
  N3,  \\field Starting Z Coordinate
       \\note How far up the wall the Door starts. (in 2-d, this would be a Y Coordinate)
       \\units m
  N4,  \\field Length
       \\units m
  N5;  \\field Height
       \\units m

WindowProperty:ShadingControl,
       \\memo Specifies the type, location, and controls for window shades, window blinds, and
       \\memo switchable glazing. Referenced by the surface objects for exterior windows and glass
       \\memo doors (ref: FenestrationSurface:Detailed, Window, and GlazedDoor).
    \\min-fields 11
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference WindowShadeControlNames
       \\note Referenced by surfaces that are exterior windows
       \\note Not used by interzone windows
  A2 , \\field Shading Type
       \\required-field
       \\type choice
       \\key InteriorShade
       \\key ExteriorShade
       \\key ExteriorScreen
       \\key InteriorBlind
       \\key ExteriorBlind
       \\key BetweenGlassShade
       \\key BetweenGlassBlind
       \\key SwitchableGlazing
  A3 , \\field Construction with Shading Name
       \\type object-list
       \\object-list ConstructionNames
       \\note Required if Shading Type = SwitchableGlazing
       \\note Required if Shading Type = interior or exterior shade or blind, or exterior screen, and
       \\note "Shading Device Material Name" is not specified.
       \\note If both "Construction with Shading Name" and "Shading Device Material Name" are entered,
       \\note the former takes precedence.
  A4 , \\field Shading Control Type
       \\required-field
       \\type choice
       \\key AlwaysOn
       \\key AlwaysOff
       \\key OnIfScheduleAllows
       \\note OnIfScheduleAllows requires that Schedule Name be specified and
       \\note Shading Control Is Scheduled = Yes.
       \\note AlwaysOn, AlwaysOff and OnIfScheduleAllows are the only valid control types for ExteriorScreen.
       \\note The following six control types are used primarily to reduce
       \\note zone cooling load due to window solar gain
       \\key OnIfHighSolarOnWindow
       \\key OnIfHighHorizontalSolar
       \\key OnIfHighOutdoorAirTemperature
       \\key OnIfHighZoneAirTemperature
       \\key OnIfHighZoneCooling
       \\key OnIfHighGlare
       \\note Following entry should be used only if Shading Type = SwitchableGlazing
       \\note and window is in a daylit zone
       \\key MeetDaylightIlluminanceSetpoint
       \\note The following three control types are used to reduce zone Heating load. They can be
       \\note used with any Shading Type but are most appropriate for opaque interior or exterior
       \\note shades with high insulating value ("opaque movable insulation")
       \\key OnNightIfLowOutdoorTempAndOffDay
       \\key OnNightIfLowInsideTempAndOffDay
       \\key OnNightIfHeatingAndOffDay
       \\note The following two control types are used to reduce zone heating and cooling load.
       \\note They can be used with any Shading Type but are most appropriate for translucent interior
       \\note or exterior shades with high insulating value ("translucent movable insulation")
       \\key OnNightIfLowOutdoorTempAndOnDayIfCooling
       \\key OnNightIfHeatingAndOnDayIfCooling
       \\note The following two control types are used to reduce zone Cooling load.
       \\note They can be used with any Shading Type but are most appropriate for interior
       \\note or exterior blinds,interior or exterior shades with low insulating value, or
       \\note switchable glazing
       \\key OffNightAndOnDayIfCoolingAndHighSolarOnWindow
       \\key OnNightAndOnDayIfCoolingAndHighSolarOnWindow
       \\note The following four control types require that both Setpoint and Setpoint2 be specified
       \\note Setpoint will correspond to outdoor air temp or zone air temp (deg C)
       \\note Setpoint2 will correspond to solar on window or horizontal solar (W/m2)
       \\key OnIfHighOutdoorAirTempAndHighSolarOnWindow
       \\key OnIfHighOutdoorAirTempAndHighHorizontalSolar
       \\key OnIfHighZoneAirTempAndHighSolarOnWindow
       \\key OnIfHighZoneAirTempAndHighHorizontalSolar
  A5 , \\field Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note Required if Shading Control Is Scheduled = Yes.
       \\note If schedule value = 1, shading control is active, i.e., shading can take place only
       \\note if the control test passes. If schedule value = 0, shading is off whether or not
       \\note the control test passes. Schedule Name is required if Shading Control Is Scheduled = Yes.
       \\note If Schedule Name is not specified, shading control is assumed to be active at all times.
  N1 , \\field Setpoint
       \\units W/m2, W or deg C
       \\note W/m2 for solar-based controls, W for cooling- or heating-based controls,
       \\note deg C for temperature-based controls.
       \\note Unused for Shading Control Type = AlwaysOn, AlwaysOff, OnIfScheduleAllows,
       \\note OnIfHighGlare, Glare, and DaylightIlluminance
       \\type real
  A6 , \\field Shading Control Is Scheduled
       \\type choice
       \\key No
       \\key Yes
       \\default No
       \\note If Yes, Schedule Name is required; if No, Schedule Name is not used.
       \\note Shading Control Is Scheduled = Yes is required if Shading Control Type = OnIfScheduleAllows.
  A7 , \\field Glare Control Is Active
       \\type choice
       \\key No
       \\key Yes
       \\default No
       \\note If Yes and window is in a daylit zone, shading is on if zone's discomfort glare index exceeds
       \\note the maximum discomfort glare index specified in the Daylighting object referenced by the zone.
       \\note The glare test is OR'ed with the test specified by Shading Control Type.
       \\note Glare Control Is Active = Yes is required if Shading Control Type = OnIfHighGlare.
  A8,  \\field Shading Device Material Name
       \\type object-list
       \\object-list WindowShadesScreensAndBlinds
       \\note Enter then name of a WindowMaterial:Shade, WindowMaterial:Screen or WindowMaterial:Blind object.
       \\note Required if "Construction with Shading Name" is not specified.
       \\note Not used if Shading Control Type = SwitchableGlazing, BetweenGlassShade, or BetweenGlassBlind.
       \\note If both "Construction with Shading Name" and "Shading Device Material Name" are entered,
       \\note the former takes precedence.
  A9 , \\field Type of Slat Angle Control for Blinds
       \\type choice
       \\key FixedSlatAngle
       \\key ScheduledSlatAngle
       \\key BlockBeamSolar
       \\default FixedSlatAngle
       \\note Used only if Shading Type = InteriorBlind, ExteriorBlind or BetweenGlassBlind.
       \\note If choice is ScheduledSlatAngle then Slat Angle Schedule Name is required.
  A10, \\field Slat Angle Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note Used only if Shading Type = InteriorBlind, ExteriorBlind or BetweenGlassBlind.
       \\note Required if Type of Slat Angle Control for Blinds = ScheduledSlatAngle
       \\note Schedule values should be degrees (0 minimum, 180 maximum)
  N2 ; \\field Setpoint 2
       \\units W/m2 or deg C
       \\note W/m2 for solar-based controls, deg C for temperature-based controls.
       \\note Used only as the second setpoint for the following two-setpoint control types:
       \\note OnIfHighOutdoorAirTempAndHighSolarOnWindow, OnIfHighOutdoorAirTempAndHighHorizontalSolar,
       \\note OnIfHighZoneAirTempAndHighSolarOnWindow, and OnIfHighZoneAirTempAndHighHorizontalSolar
       \\type real
       \\ip-units unknown

WindowProperty:FrameAndDivider,
         \\memo Specifies the dimensions of a window frame, dividers, and inside reveal surfaces.
         \\memo Referenced by the surface objects for exterior windows and glass doors
         \\memo (ref: FenestrationSurface:Detailed, Window, and GlazedDoor).
      \\min-fields 20
    A1 , \\field Name
         \\required-field
         \\type alpha
         \\reference WindowFrameAndDividerNames
         \\note Referenced by surfaces that are exterior windows
         \\note Not used by interzone windows
    N1 , \\field Frame Width
         \\units m
         \\type real
         \\minimum 0.0
         \\maximum 1.0
         \\default 0.0
         \\note Width of frame in plane of window
         \\note Frame width assumed the same on all sides of window
    N2 , \\field Frame Outside Projection
         \\units m
         \\type real
         \\minimum 0.0
         \\maximum 0.5
         \\default 0.0
         \\note Amount that frame projects outward from the outside face of the glazing
    N3 , \\field Frame Inside Projection
         \\units m
         \\type real
         \\minimum 0.0
         \\maximum 0.5
         \\default 0.0
         \\note Amount that frame projects inward from the inside face of the glazing
    N4 , \\field Frame Conductance
         \\units W/m2-K
         \\type real
         \\minimum 0.0
         \\note Effective conductance of frame
         \\note Excludes air films
         \\note Obtained from WINDOW 5 or other 2-D calculation
    N5 , \\field Ratio of Frame-Edge Glass Conductance to Center-Of-Glass Conductance
         \\type real
         \\minimum 1.0
         \\maximum 4.0
         \\default 1.0
         \\note Excludes air films; applies only to multipane windows
         \\note Obtained from WINDOW 5 or other 2-D calculation
    N6 , \\field Frame Solar Absorptance
         \\type real
         \\minimum 0.0
         \\maximum 1.0
         \\default 0.7
         \\note Assumed same on outside and inside of frame
    N7 , \\field Frame Visible Absorptance
         \\type real
         \\minimum 0.0
         \\maximum 1.0
         \\default 0.7
         \\note Assumed same on outside and inside of frame
    N8 , \\field Frame Thermal Hemispherical Emissivity
         \\type real
         \\minimum> 0.0
         \\default 0.9
         \\note Assumed same on outside and inside of frame
    A2 , \\field Divider Type
         \\required-field
         \\type choice
         \\key DividedLite
         \\key Suspended
         \\default DividedLite
    N9 , \\field Divider Width
         \\units m
         \\type real
         \\minimum 0.0
         \\maximum 0.5
         \\default 0.0
         \\note Width of dividers in plane of window
         \\note Width assumed the same for all dividers
    N10, \\field Number of Horizontal Dividers
         \\type real
         \\minimum 0
         \\default 0
         \\note "Horizontal" means parallel to local window X-axis
    N11, \\field Number of Vertical Dividers
         \\type real
         \\minimum 0
         \\default 0
         \\note "Vertical" means parallel to local window Y-axis
    N12, \\field Divider Outside Projection
         \\units m
         \\type real
         \\minimum 0.0
         \\maximum 0.5
         \\default 0.0
         \\note Amount that divider projects outward from the outside face of the glazing
         \\note Outside projection assumed the same for all divider elements
    N13, \\field Divider Inside Projection
         \\units m
         \\type real
         \\minimum 0.0
         \\maximum 0.5
         \\default 0.0
         \\note Amount that divider projects inward from the inside face of the glazing
         \\note Inside projection assumed the same for all divider elements
    N14, \\field Divider Conductance
         \\units W/m2-K
         \\type real
         \\minimum 0.0
         \\default 0.0
         \\note Effective conductance of divider
         \\note Excludes air films
         \\note Obtained from WINDOW 5 or other 2-D calculation
    N15, \\field Ratio of Divider-Edge Glass Conductance to Center-Of-Glass Conductance
         \\type real
         \\minimum 1.0
         \\maximum 4.0
         \\default 1.0
         \\note Excludes air films
         \\note Obtained from WINDOW 5 or other 2-D calculation
    N16, \\field Divider Solar Absorptance
         \\type real
         \\minimum 0.0
         \\maximum 1.0
         \\default 0.0
         \\note Assumed same on outside and inside of divider
    N17, \\field Divider Visible Absorptance
         \\type real
         \\minimum 0.0
         \\maximum 1.0
         \\default 0.0
         \\note Assumed same on outside and inside of divider
    N18, \\field Divider Thermal Hemispherical Emissivity
         \\type real
         \\minimum> 0.0
         \\maximum< 1.0
         \\default 0.9
         \\note Assumed same on outside and inside of divider
    N19, \\field Outside Reveal Solar Absorptance
         \\type real
         \\minimum 0.0
         \\maximum 1.0
         \\default 0.0
    N20, \\field Inside Sill Depth
         \\units m
         \\type real
         \\minimum 0.0
         \\maximum 2.0
         \\default 0.0
    N21, \\field Inside Sill Solar Absorptance
         \\type real
         \\minimum 0.0
         \\maximum 1.0
         \\default 0.0
    N22, \\field Inside Reveal Depth
         \\note Distance from plane of inside surface of glazing
         \\note to plane of inside surface of wall.
         \\note Outside reveal depth is determined from the geometry
         \\note of the window and the wall it is on; it is non-zero if the plane of
         \\note the outside surface of the glazing is set back from the plane of the
         \\note outside surface of the wall.
         \\units m
         \\minimum 0.0
         \\maximum 2.0
         \\default 0.0
    N23; \\field Inside Reveal Solar Absorptance
         \\type real
         \\minimum 0.0
         \\maximum 1.0
         \\default 0.0

WindowProperty:AirflowControl,
    \\memo Used to control forced airflow through a gap between glass layers
    \\min-fields 7
  A1 , \\field Name
       \\required-field
       \\type object-list
       \\object-list SubSurfNames
       \\note Name must be that of an exterior window with two or three glass layers.
  A2 , \\field Airflow Source
       \\type choice
       \\key IndoorAir
       \\key OutdoorAir
       \\default IndoorAir
  A3 , \\field Airflow Destination
       \\type choice
       \\key IndoorAir
       \\key OutdoorAir
       \\key ReturnAir
       \\default OutdoorAir
  N1 , \\field Maximum Flow Rate
       \\units m3/s-m
       \\note Above is m3/s per m of glazing width
       \\ip-units ft3/min-ft
       \\default 0.0
       \\minimum 0.0
  A4 , \\field Airflow Control Type
       \\type choice
       \\key AlwaysOnAtMaximumFlow
       \\key AlwaysOff
       \\key ScheduledOnly
       \\note ScheduledOnly requires that Airflow Has Multiplier Schedule Name = Yes
       \\note  and that Airflow Multiplier Schedule Name is specified.
       \\default AlwaysOnAtMaximumFlow
  A5 , \\field Airflow Is Scheduled
       \\type choice
       \\key Yes
       \\key No
       \\default No
       \\note If Yes, then Airflow Multiplier Schedule Name must be specified
  A6 ; \\field Airflow Multiplier Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note Required if Airflow Is Scheduled = Yes.
       \\note Schedule values are 0.0 or 1.0 and multiply Maximum Air Flow.

WindowProperty:StormWindow,
       \\min-fields 7
       \\memo This is a movable exterior glass layer that is usually applied in the winter
       \\memo and removed in the summer.
  A1,  \\field Window Name
       \\note Must be the name of a FenestrationSurface:Detailed object with Surface Type = WINDOW.
       \\note The WindowProperty:StormWindow object can only be used with exterior windows.
       \\required-field
       \\type alpha
       \\object-list SubSurfNames
  A2,  \\field Storm Glass Layer Name
       \\note Must be a WindowMaterial:Glazing or WindowMaterial:Glazing:RefractionExtinctionMethod
       \\note Gap between storm glass layer and adjacent glass layer is assumed to be filled
       \\note with Air
       \\required-field
       \\type object-list
       \\object-list GlazingMaterialName
  N1,  \\field Distance Between Storm Glass Layer and Adjacent Glass
       \\type real
       \\units m
       \\minimum> 0.0
       \\maximum 0.5
       \\default 0.050
  N2,  \\field Month that Storm Glass Layer is Put On
       \\required-field
       \\minimum 1
       \\maximum 12
       \\type integer
  N3,  \\field Day of Month that Storm Glass Layer is Put On
       \\required-field
       \\minimum 1
       \\maximum 31
       \\type integer
  N4,  \\field Month that Storm Glass Layer is Taken Off
       \\required-field
       \\minimum 1
       \\maximum 12
       \\type integer
  N5;  \\field Day of Month that Storm Glass Layer is Taken Off
       \\required-field
       \\minimum 1
       \\maximum 31
       \\type integer

InternalMass,
       \\memo Used to describe internal zone surface area that does not need to be part of geometric
       \\memo representation. This should be the total surface area exposed to the zone air.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference AllHeatTranSurfNames
       \\reference AllHeatTranAngFacNames
       \\reference SurfGroupAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Zone Name
       \\required-field
       \\note Zone the surface is a part of
       \\note used to be Interior Environment
       \\type object-list
       \\object-list ZoneNames
  N1 ; \\field Surface Area
       \\required-field
       \\units m2
       \\minimum> 0

Shading:Site,
       \\memo used for shading elements such as trees
       \\memo these items are fixed in space and would not move with relative geometry
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference AllShadingAndHTSurfNames
       \\reference AllShadingSurfNames
  N1,  \\field Azimuth Angle
       \\note Facing direction of outside of shading device (S=180,N=0,E=90,W=270)
       \\minimum 0
       \\maximum 360
       \\units deg
  N2,  \\field Tilt Angle
       \\default 90
       \\minimum 0
       \\maximum 180
       \\units deg
  N3,  \\field Starting X Coordinate
       \\note Starting coordinate is the Lower Left Corner of the Shade
       \\units m
  N4,  \\field Starting Y Coordinate
       \\units m
  N5,  \\field Starting Z Coordinate
       \\units m
  N6,  \\field Length
       \\units m
  N7;  \\field Height
       \\units m

Shading:Building,
       \\memo used for shading elements such as trees, other buildings, parts of this building not being modeled
       \\memo these items are relative to the current building and would move with relative geometry
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference AllShadingAndHTSurfNames
       \\reference AllShadingSurfNames
  N1,  \\field Azimuth Angle
       \\note Facing direction of outside of shading device (S=180,N=0,E=90,W=270)
       \\minimum 0
       \\maximum 360
       \\units deg
  N2,  \\field Tilt Angle
       \\default 90
       \\minimum 0
       \\maximum 180
       \\units deg
  N3,  \\field Starting X Coordinate
       \\note Starting coordinate is the Lower Left Corner of the Shade
       \\units m
  N4,  \\field Starting Y Coordinate
       \\units m
  N5,  \\field Starting Z Coordinate
       \\units m
  N6,  \\field Length
       \\units m
  N7;  \\field Height
       \\units m

Shading:Site:Detailed,
  \\extensible:3 -- duplicate last set of x,y,z coordinates, renumbering please (and changing z terminator to , for all but last)
       \\memo used for shading elements such as trees
       \\memo these items are fixed in space and would not move with relative geometry
       \\format vertices
       \\min-fields 12
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference AllShadingAndHTSurfNames
       \\reference AllShadingSurfNames
  A2,  \\field Transmittance Schedule Name
       \\note Transmittance schedule for the shading device, defaults to zero (always opaque)
       \\type object-list
       \\object-list ScheduleNames
  N1 , \\field Number of Vertices
       \\required-field
       \\note shown with 6 vertex coordinates -- extensible object
       \\autocalculatable
       \\default autocalculate
       \\minimum 3
       \\note Rules for vertices are given in GlobalGeometryRules coordinates --
       \\note For this object all surface coordinates are in world coordinates.
  N2,  \\field Vertex 1 X-coordinate
       \\begin-extensible
       \\required-field
       \\units m
       \\type real
  N3 , \\field Vertex 1 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N4 , \\field Vertex 1 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N5,  \\field Vertex 2 X-coordinate
       \\required-field
       \\units m
       \\type real
  N6,  \\field Vertex 2 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N7, \\field Vertex 2 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N8, \\field Vertex 3 X-coordinate
       \\required-field
       \\units m
       \\type real
  N9,  \\field Vertex 3 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N10, \\field Vertex 3 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N11, \\field Vertex 4 X-coordinate
       \\units m
       \\type real
  N12, \\field Vertex 4 Y-coordinate
       \\units m
       \\type real
  N13, \\field Vertex 4 Z-coordinate
       \\units m
       \\type real
  N14, \\field Vertex 5 X-coordinate
       \\units m
       \\type real
  N15, \\field Vertex 5 Y-coordinate
       \\units m
       \\type real
  N16, \\field Vertex 5 Z-coordinate
       \\units m
       \\type real
  N17, \\field Vertex 6 X-coordinate
       \\units m
       \\type real
  N18, \\field Vertex 6 Y-coordinate
       \\units m
       \\type real
  N19, \\field Vertex 6 Z-coordinate
       \\units m
       \\type real
  N20, \\field Vertex 7 X-coordinate
       \\units m
       \\type real
  N21, \\field Vertex 7 Y-coordinate
       \\units m
       \\type real
  N22, \\field Vertex 7 Z-coordinate
       \\units m
       \\type real
  N23, \\field Vertex 8 X-coordinate
       \\units m
       \\type real
  N24, \\field Vertex 8 Y-coordinate
       \\units m
       \\type real
  N25, \\field Vertex 8 Z-coordinate
       \\units m
       \\type real
  N26, \\field Vertex 9 X-coordinate
       \\units m
       \\type real
  N27, \\field Vertex 9 Y-coordinate
       \\units m
       \\type real
  N28, \\field Vertex 9 Z-coordinate
       \\units m
       \\type real
  N29, \\field Vertex 10 X-coordinate
       \\units m
       \\type real
  N30, \\field Vertex 10 Y-coordinate
       \\units m
       \\type real
  N31, \\field Vertex 10 Z-coordinate
       \\units m
       \\type real
  N32, \\field Vertex 11 X-coordinate
       \\units m
       \\type real
  N33, \\field Vertex 11 Y-coordinate
       \\units m
       \\type real
  N34, \\field Vertex 11 Z-coordinate
       \\units m
       \\type real
  N35, \\field Vertex 12 X-coordinate
       \\units m
       \\type real
  N36, \\field Vertex 12 Y-coordinate
       \\units m
       \\type real
  N37, \\field Vertex 12 Z-coordinate
       \\units m
       \\type real
  N38, \\field Vertex 13 X-coordinate
       \\units m
       \\type real
  N39, \\field Vertex 13 Y-coordinate
       \\units m
       \\type real
  N40, \\field Vertex 13 Z-coordinate
       \\units m
       \\type real
  N41, \\field Vertex 14 X-coordinate
       \\units m
       \\type real
  N42, \\field Vertex 14 Y-coordinate
       \\units m
       \\type real
  N43, \\field Vertex 14 Z-coordinate
       \\units m
       \\type real
  N44, \\field Vertex 15 X-coordinate
       \\units m
       \\type real
  N45, \\field Vertex 15 Y-coordinate
       \\units m
       \\type real
  N46, \\field Vertex 15 Z-coordinate
       \\units m
       \\type real
  N47, \\field Vertex 16 X-coordinate
       \\units m
       \\type real
  N48, \\field Vertex 16 Y-coordinate
       \\units m
       \\type real
  N49, \\field Vertex 16 Z-coordinate
       \\units m
       \\type real
  N50, \\field Vertex 17 X-coordinate
       \\units m
       \\type real
  N51, \\field Vertex 17 Y-coordinate
       \\units m
       \\type real
  N52, \\field Vertex 17 Z-coordinate
       \\units m
       \\type real
  N53, \\field Vertex 18 X-coordinate
       \\units m
       \\type real
  N54, \\field Vertex 18 Y-coordinate
       \\units m
       \\type real
  N55, \\field Vertex 18 Z-coordinate
       \\units m
       \\type real
  N56, \\field Vertex 19 X-coordinate
       \\units m
       \\type real
  N57, \\field Vertex 19 Y-coordinate
       \\units m
       \\type real
  N58, \\field Vertex 19 Z-coordinate
       \\units m
       \\type real
  N59, \\field Vertex 20 X-coordinate
       \\units m
       \\type real
  N60, \\field Vertex 20 Y-coordinate
       \\units m
       \\type real
  N61, \\field Vertex 20 Z-coordinate
       \\units m
       \\type real
  N62, \\field Vertex 21 X-coordinate
       \\units m
       \\type real
  N63, \\field Vertex 21 Y-coordinate
       \\units m
       \\type real
  N64, \\field Vertex 21 Z-coordinate
       \\units m
       \\type real
  N65, \\field Vertex 22 X-coordinate
       \\units m
       \\type real
  N66, \\field Vertex 22 Y-coordinate
       \\units m
       \\type real
  N67, \\field Vertex 22 Z-coordinate
       \\units m
       \\type real
  N68, \\field Vertex 23 X-coordinate
       \\units m
       \\type real
  N69, \\field Vertex 23 Y-coordinate
       \\units m
       \\type real
  N70, \\field Vertex 23 Z-coordinate
       \\units m
       \\type real
  N71, \\field Vertex 24 X-coordinate
       \\units m
       \\type real
  N72, \\field Vertex 24 Y-coordinate
       \\units m
       \\type real
  N73, \\field Vertex 24 Z-coordinate
       \\units m
       \\type real
  N74, \\field Vertex 25 X-coordinate
       \\units m
       \\type real
  N75, \\field Vertex 25 Y-coordinate
       \\units m
       \\type real
  N76, \\field Vertex 25 Z-coordinate
       \\units m
       \\type real
  N77, \\field Vertex 26 X-coordinate
       \\units m
       \\type real
  N78, \\field Vertex 26 Y-coordinate
       \\units m
       \\type real
  N79, \\field Vertex 26 Z-coordinate
       \\units m
       \\type real
  N80, \\field Vertex 27 X-coordinate
       \\units m
       \\type real
  N81, \\field Vertex 27 Y-coordinate
       \\units m
       \\type real
  N82, \\field Vertex 27 Z-coordinate
       \\units m
       \\type real
  N83, \\field Vertex 28 X-coordinate
       \\units m
       \\type real
  N84, \\field Vertex 28 Y-coordinate
       \\units m
       \\type real
  N85, \\field Vertex 28 Z-coordinate
       \\units m
       \\type real
  N86, \\field Vertex 29 X-coordinate
       \\units m
       \\type real
  N87, \\field Vertex 29 Y-coordinate
       \\units m
       \\type real
  N88, \\field Vertex 29 Z-coordinate
       \\units m
       \\type real
  N89, \\field Vertex 30 X-coordinate
       \\units m
       \\type real
  N90, \\field Vertex 30 Y-coordinate
       \\units m
       \\type real
  N91, \\field Vertex 30 Z-coordinate
       \\units m
       \\type real
  N92, \\field Vertex 31 X-coordinate
       \\units m
       \\type real
  N93, \\field Vertex 31 Y-coordinate
       \\units m
       \\type real
  N94, \\field Vertex 31 Z-coordinate
       \\units m
       \\type real
  N95, \\field Vertex 32 X-coordinate
       \\units m
       \\type real
  N96, \\field Vertex 32 Y-coordinate
       \\units m
       \\type real
  N97, \\field Vertex 32 Z-coordinate
       \\units m
       \\type real
  N98, \\field Vertex 33 X-coordinate
       \\units m
       \\type real
  N99, \\field Vertex 33 Y-coordinate
       \\units m
       \\type real
  N100, \\field Vertex 33 Z-coordinate
       \\units m
       \\type real
  N101, \\field Vertex 34 X-coordinate
       \\units m
       \\type real
  N102, \\field Vertex 34 Y-coordinate
       \\units m
       \\type real
  N103, \\field Vertex 34 Z-coordinate
       \\units m
       \\type real
  N104, \\field Vertex 35 X-coordinate
       \\units m
       \\type real
  N105, \\field Vertex 35 Y-coordinate
       \\units m
       \\type real
  N106, \\field Vertex 35 Z-coordinate
       \\units m
       \\type real
  N107, \\field Vertex 36 X-coordinate
       \\units m
       \\type real
  N108, \\field Vertex 36 Y-coordinate
       \\units m
       \\type real
  N109, \\field Vertex 36 Z-coordinate
       \\units m
       \\type real
  N110, \\field Vertex 37 X-coordinate
       \\units m
       \\type real
  N111, \\field Vertex 37 Y-coordinate
       \\units m
       \\type real
  N112, \\field Vertex 37 Z-coordinate
       \\units m
       \\type real
  N113, \\field Vertex 38 X-coordinate
       \\units m
       \\type real
  N114, \\field Vertex 38 Y-coordinate
       \\units m
       \\type real
  N115, \\field Vertex 38 Z-coordinate
       \\units m
       \\type real
  N116, \\field Vertex 39 X-coordinate
       \\units m
       \\type real
  N117, \\field Vertex 39 Y-coordinate
       \\units m
       \\type real
  N118, \\field Vertex 39 Z-coordinate
       \\units m
       \\type real
  N119, \\field Vertex 40 X-coordinate
       \\units m
       \\type real
  N120, \\field Vertex 40 Y-coordinate
       \\units m
       \\type real
  N121, \\field Vertex 40 Z-coordinate
       \\units m
       \\type real
  N122, \\field Vertex 41 X-coordinate
       \\units m
       \\type real
  N123, \\field Vertex 41 Y-coordinate
       \\units m
       \\type real
  N124, \\field Vertex 41 Z-coordinate
       \\units m
       \\type real
  N125, \\field Vertex 42 X-coordinate
       \\units m
       \\type real
  N126, \\field Vertex 42 Y-coordinate
       \\units m
       \\type real
  N127, \\field Vertex 42 Z-coordinate
       \\units m
       \\type real
  N128, \\field Vertex 43 X-coordinate
       \\units m
       \\type real
  N129, \\field Vertex 43 Y-coordinate
       \\units m
       \\type real
  N130, \\field Vertex 43 Z-coordinate
       \\units m
       \\type real
  N131, \\field Vertex 44 X-coordinate
       \\units m
       \\type real
  N132, \\field Vertex 44 Y-coordinate
       \\units m
       \\type real
  N133, \\field Vertex 44 Z-coordinate
       \\units m
       \\type real
  N134, \\field Vertex 45 X-coordinate
       \\units m
       \\type real
  N135, \\field Vertex 45 Y-coordinate
       \\units m
       \\type real
  N136, \\field Vertex 45 Z-coordinate
       \\units m
       \\type real
  N137, \\field Vertex 46 X-coordinate
       \\units m
       \\type real
  N138, \\field Vertex 46 Y-coordinate
       \\units m
       \\type real
  N139, \\field Vertex 46 Z-coordinate
       \\units m
       \\type real
  N140, \\field Vertex 47 X-coordinate
       \\units m
       \\type real
  N141, \\field Vertex 47 Y-coordinate
       \\units m
       \\type real
  N142, \\field Vertex 47 Z-coordinate
       \\units m
       \\type real
  N143, \\field Vertex 48 X-coordinate
       \\units m
       \\type real
  N144, \\field Vertex 48 Y-coordinate
       \\units m
       \\type real
  N145, \\field Vertex 48 Z-coordinate
       \\units m
       \\type real
  N146, \\field Vertex 49 X-coordinate
       \\units m
       \\type real
  N147, \\field Vertex 49 Y-coordinate
       \\units m
       \\type real
  N148, \\field Vertex 49 Z-coordinate
       \\units m
       \\type real
  N149, \\field Vertex 50 X-coordinate
       \\units m
       \\type real
  N150, \\field Vertex 50 Y-coordinate
       \\units m
       \\type real
  N151, \\field Vertex 50 Z-coordinate
       \\units m
       \\type real
  N152, \\field Vertex 51 X-coordinate
       \\units m
       \\type real
  N153, \\field Vertex 51 Y-coordinate
       \\units m
       \\type real
  N154, \\field Vertex 51 Z-coordinate
       \\units m
       \\type real
  N155, \\field Vertex 52 X-coordinate
       \\units m
       \\type real
  N156, \\field Vertex 52 Y-coordinate
       \\units m
       \\type real
  N157, \\field Vertex 52 Z-coordinate
       \\units m
       \\type real
  N158, \\field Vertex 53 X-coordinate
       \\units m
       \\type real
  N159, \\field Vertex 53 Y-coordinate
       \\units m
       \\type real
  N160, \\field Vertex 53 Z-coordinate
       \\units m
       \\type real
  N161, \\field Vertex 54 X-coordinate
       \\units m
       \\type real
  N162, \\field Vertex 54 Y-coordinate
       \\units m
       \\type real
  N163, \\field Vertex 54 Z-coordinate
       \\units m
       \\type real
  N164, \\field Vertex 55 X-coordinate
       \\units m
       \\type real
  N165, \\field Vertex 55 Y-coordinate
       \\units m
       \\type real
  N166, \\field Vertex 55 Z-coordinate
       \\units m
       \\type real
  N167, \\field Vertex 56 X-coordinate
       \\units m
       \\type real
  N168, \\field Vertex 56 Y-coordinate
       \\units m
       \\type real
  N169, \\field Vertex 56 Z-coordinate
       \\units m
       \\type real
  N170, \\field Vertex 57 X-coordinate
       \\units m
       \\type real
  N171, \\field Vertex 57 Y-coordinate
       \\units m
       \\type real
  N172, \\field Vertex 57 Z-coordinate
       \\units m
       \\type real
  N173, \\field Vertex 58 X-coordinate
       \\units m
       \\type real
  N174, \\field Vertex 58 Y-coordinate
       \\units m
       \\type real
  N175, \\field Vertex 58 Z-coordinate
       \\units m
       \\type real
  N176, \\field Vertex 59 X-coordinate
       \\units m
       \\type real
  N177, \\field Vertex 59 Y-coordinate
       \\units m
       \\type real
  N178, \\field Vertex 59 Z-coordinate
       \\units m
       \\type real
  N179, \\field Vertex 60 X-coordinate
       \\units m
       \\type real
  N180, \\field Vertex 60 Y-coordinate
       \\units m
       \\type real
  N181, \\field Vertex 60 Z-coordinate
       \\units m
       \\type real
  N182, \\field Vertex 61 X-coordinate
       \\units m
       \\type real
  N183, \\field Vertex 61 Y-coordinate
       \\units m
       \\type real
  N184, \\field Vertex 61 Z-coordinate
       \\units m
       \\type real
  N185, \\field Vertex 62 X-coordinate
       \\units m
       \\type real
  N186, \\field Vertex 62 Y-coordinate
       \\units m
       \\type real
  N187, \\field Vertex 62 Z-coordinate
       \\units m
       \\type real
  N188, \\field Vertex 63 X-coordinate
       \\units m
       \\type real
  N189, \\field Vertex 63 Y-coordinate
       \\units m
       \\type real
  N190, \\field Vertex 63 Z-coordinate
       \\units m
       \\type real
  N191, \\field Vertex 64 X-coordinate
       \\units m
       \\type real
  N192, \\field Vertex 64 Y-coordinate
       \\units m
       \\type real
  N193, \\field Vertex 64 Z-coordinate
       \\units m
       \\type real
  N194, \\field Vertex 65 X-coordinate
       \\units m
       \\type real
  N195, \\field Vertex 65 Y-coordinate
       \\units m
       \\type real
  N196, \\field Vertex 65 Z-coordinate
       \\units m
       \\type real
  N197, \\field Vertex 66 X-coordinate
       \\units m
       \\type real
  N198, \\field Vertex 66 Y-coordinate
       \\units m
       \\type real
  N199, \\field Vertex 66 Z-coordinate
       \\units m
       \\type real
  N200, \\field Vertex 67 X-coordinate
       \\units m
       \\type real
  N201, \\field Vertex 67 Y-coordinate
       \\units m
       \\type real
  N202, \\field Vertex 67 Z-coordinate
       \\units m
       \\type real
  N203, \\field Vertex 68 X-coordinate
       \\units m
       \\type real
  N204, \\field Vertex 68 Y-coordinate
       \\units m
       \\type real
  N205, \\field Vertex 68 Z-coordinate
       \\units m
       \\type real
  N206, \\field Vertex 69 X-coordinate
       \\units m
       \\type real
  N207, \\field Vertex 69 Y-coordinate
       \\units m
       \\type real
  N208, \\field Vertex 69 Z-coordinate
       \\units m
       \\type real
  N209, \\field Vertex 70 X-coordinate
       \\units m
       \\type real
  N210, \\field Vertex 70 Y-coordinate
       \\units m
       \\type real
  N211, \\field Vertex 70 Z-coordinate
       \\units m
       \\type real
  N212, \\field Vertex 71 X-coordinate
       \\units m
       \\type real
  N213, \\field Vertex 71 Y-coordinate
       \\units m
       \\type real
  N214, \\field Vertex 71 Z-coordinate
       \\units m
       \\type real
  N215, \\field Vertex 72 X-coordinate
       \\units m
       \\type real
  N216, \\field Vertex 72 Y-coordinate
       \\units m
       \\type real
  N217, \\field Vertex 72 Z-coordinate
       \\units m
       \\type real
  N218, \\field Vertex 73 X-coordinate
       \\units m
       \\type real
  N219, \\field Vertex 73 Y-coordinate
       \\units m
       \\type real
  N220, \\field Vertex 73 Z-coordinate
       \\units m
       \\type real
  N221, \\field Vertex 74 X-coordinate
       \\units m
       \\type real
  N222, \\field Vertex 74 Y-coordinate
       \\units m
       \\type real
  N223, \\field Vertex 74 Z-coordinate
       \\units m
       \\type real
  N224, \\field Vertex 75 X-coordinate
       \\units m
       \\type real
  N225, \\field Vertex 75 Y-coordinate
       \\units m
       \\type real
  N226, \\field Vertex 75 Z-coordinate
       \\units m
       \\type real
  N227, \\field Vertex 76 X-coordinate
       \\units m
       \\type real
  N228, \\field Vertex 76 Y-coordinate
       \\units m
       \\type real
  N229, \\field Vertex 76 Z-coordinate
       \\units m
       \\type real
  N230, \\field Vertex 77 X-coordinate
       \\units m
       \\type real
  N231, \\field Vertex 77 Y-coordinate
       \\units m
       \\type real
  N232, \\field Vertex 77 Z-coordinate
       \\units m
       \\type real
  N233, \\field Vertex 78 X-coordinate
       \\units m
       \\type real
  N234, \\field Vertex 78 Y-coordinate
       \\units m
       \\type real
  N235, \\field Vertex 78 Z-coordinate
       \\units m
       \\type real
  N236, \\field Vertex 79 X-coordinate
       \\units m
       \\type real
  N237, \\field Vertex 79 Y-coordinate
       \\units m
       \\type real
  N238, \\field Vertex 79 Z-coordinate
       \\units m
       \\type real
  N239, \\field Vertex 80 X-coordinate
       \\units m
       \\type real
  N240, \\field Vertex 80 Y-coordinate
       \\units m
       \\type real
  N241, \\field Vertex 80 Z-coordinate
       \\units m
       \\type real
  N242, \\field Vertex 81 X-coordinate
       \\units m
       \\type real
  N243, \\field Vertex 81 Y-coordinate
       \\units m
       \\type real
  N244, \\field Vertex 81 Z-coordinate
       \\units m
       \\type real
  N245, \\field Vertex 82 X-coordinate
       \\units m
       \\type real
  N246, \\field Vertex 82 Y-coordinate
       \\units m
       \\type real
  N247, \\field Vertex 82 Z-coordinate
       \\units m
       \\type real
  N248, \\field Vertex 83 X-coordinate
       \\units m
       \\type real
  N249, \\field Vertex 83 Y-coordinate
       \\units m
       \\type real
  N250, \\field Vertex 83 Z-coordinate
       \\units m
       \\type real
  N251, \\field Vertex 84 X-coordinate
       \\units m
       \\type real
  N252, \\field Vertex 84 Y-coordinate
       \\units m
       \\type real
  N253, \\field Vertex 84 Z-coordinate
       \\units m
       \\type real
  N254, \\field Vertex 85 X-coordinate
       \\units m
       \\type real
  N255, \\field Vertex 85 Y-coordinate
       \\units m
       \\type real
  N256, \\field Vertex 85 Z-coordinate
       \\units m
       \\type real
  N257, \\field Vertex 86 X-coordinate
       \\units m
       \\type real
  N258, \\field Vertex 86 Y-coordinate
       \\units m
       \\type real
  N259, \\field Vertex 86 Z-coordinate
       \\units m
       \\type real
  N260, \\field Vertex 87 X-coordinate
       \\units m
       \\type real
  N261, \\field Vertex 87 Y-coordinate
       \\units m
       \\type real
  N262, \\field Vertex 87 Z-coordinate
       \\units m
       \\type real
  N263, \\field Vertex 88 X-coordinate
       \\units m
       \\type real
  N264, \\field Vertex 88 Y-coordinate
       \\units m
       \\type real
  N265, \\field Vertex 88 Z-coordinate
       \\units m
       \\type real
  N266, \\field Vertex 89 X-coordinate
       \\units m
       \\type real
  N267, \\field Vertex 89 Y-coordinate
       \\units m
       \\type real
  N268, \\field Vertex 89 Z-coordinate
       \\units m
       \\type real
  N269, \\field Vertex 90 X-coordinate
       \\units m
       \\type real
  N270, \\field Vertex 90 Y-coordinate
       \\units m
       \\type real
  N271, \\field Vertex 90 Z-coordinate
       \\units m
       \\type real
  N272, \\field Vertex 91 X-coordinate
       \\units m
       \\type real
  N273, \\field Vertex 91 Y-coordinate
       \\units m
       \\type real
  N274, \\field Vertex 91 Z-coordinate
       \\units m
       \\type real
  N275, \\field Vertex 92 X-coordinate
       \\units m
       \\type real
  N276, \\field Vertex 92 Y-coordinate
       \\units m
       \\type real
  N277, \\field Vertex 92 Z-coordinate
       \\units m
       \\type real
  N278, \\field Vertex 93 X-coordinate
       \\units m
       \\type real
  N279, \\field Vertex 93 Y-coordinate
       \\units m
       \\type real
  N280, \\field Vertex 93 Z-coordinate
       \\units m
       \\type real
  N281, \\field Vertex 94 X-coordinate
       \\units m
       \\type real
  N282, \\field Vertex 94 Y-coordinate
       \\units m
       \\type real
  N283, \\field Vertex 94 Z-coordinate
       \\units m
       \\type real
  N284, \\field Vertex 95 X-coordinate
       \\units m
       \\type real
  N285, \\field Vertex 95 Y-coordinate
       \\units m
       \\type real
  N286, \\field Vertex 95 Z-coordinate
       \\units m
       \\type real
  N287, \\field Vertex 96 X-coordinate
       \\units m
       \\type real
  N288, \\field Vertex 96 Y-coordinate
       \\units m
       \\type real
  N289, \\field Vertex 96 Z-coordinate
       \\units m
       \\type real
  N290, \\field Vertex 97 X-coordinate
       \\units m
       \\type real
  N291, \\field Vertex 97 Y-coordinate
       \\units m
       \\type real
  N292, \\field Vertex 97 Z-coordinate
       \\units m
       \\type real
  N293, \\field Vertex 98 X-coordinate
       \\units m
       \\type real
  N294, \\field Vertex 98 Y-coordinate
       \\units m
       \\type real
  N295, \\field Vertex 98 Z-coordinate
       \\units m
       \\type real
  N296, \\field Vertex 99 X-coordinate
       \\units m
       \\type real
  N297, \\field Vertex 99 Y-coordinate
       \\units m
       \\type real
  N298, \\field Vertex 99 Z-coordinate
       \\units m
       \\type real
  N299, \\field Vertex 100 X-coordinate
       \\units m
       \\type real
  N300, \\field Vertex 100 Y-coordinate
       \\units m
       \\type real
  N301, \\field Vertex 100 Z-coordinate
       \\units m
       \\type real
  N302, \\field Vertex 101 X-coordinate
       \\units m
       \\type real
  N303, \\field Vertex 101 Y-coordinate
       \\units m
       \\type real
  N304, \\field Vertex 101 Z-coordinate
       \\units m
       \\type real
  N305, \\field Vertex 102 X-coordinate
       \\units m
       \\type real
  N306, \\field Vertex 102 Y-coordinate
       \\units m
       \\type real
  N307, \\field Vertex 102 Z-coordinate
       \\units m
       \\type real
  N308, \\field Vertex 103 X-coordinate
       \\units m
       \\type real
  N309, \\field Vertex 103 Y-coordinate
       \\units m
       \\type real
  N310, \\field Vertex 103 Z-coordinate
       \\units m
       \\type real
  N311, \\field Vertex 104 X-coordinate
       \\units m
       \\type real
  N312, \\field Vertex 104 Y-coordinate
       \\units m
       \\type real
  N313, \\field Vertex 104 Z-coordinate
       \\units m
       \\type real
  N314, \\field Vertex 105 X-coordinate
       \\units m
       \\type real
  N315, \\field Vertex 105 Y-coordinate
       \\units m
       \\type real
  N316, \\field Vertex 105 Z-coordinate
       \\units m
       \\type real
  N317, \\field Vertex 106 X-coordinate
       \\units m
       \\type real
  N318, \\field Vertex 106 Y-coordinate
       \\units m
       \\type real
  N319, \\field Vertex 106 Z-coordinate
       \\units m
       \\type real
  N320, \\field Vertex 107 X-coordinate
       \\units m
       \\type real
  N321, \\field Vertex 107 Y-coordinate
       \\units m
       \\type real
  N322, \\field Vertex 107 Z-coordinate
       \\units m
       \\type real
  N323, \\field Vertex 108 X-coordinate
       \\units m
       \\type real
  N324, \\field Vertex 108 Y-coordinate
       \\units m
       \\type real
  N325, \\field Vertex 108 Z-coordinate
       \\units m
       \\type real
  N326, \\field Vertex 109 X-coordinate
       \\units m
       \\type real
  N327, \\field Vertex 109 Y-coordinate
       \\units m
       \\type real
  N328, \\field Vertex 109 Z-coordinate
       \\units m
       \\type real
  N329, \\field Vertex 110 X-coordinate
       \\units m
       \\type real
  N330, \\field Vertex 110 Y-coordinate
       \\units m
       \\type real
  N331, \\field Vertex 110 Z-coordinate
       \\units m
       \\type real
  N332, \\field Vertex 111 X-coordinate
       \\units m
       \\type real
  N333, \\field Vertex 111 Y-coordinate
       \\units m
       \\type real
  N334, \\field Vertex 111 Z-coordinate
       \\units m
       \\type real
  N335, \\field Vertex 112 X-coordinate
       \\units m
       \\type real
  N336, \\field Vertex 112 Y-coordinate
       \\units m
       \\type real
  N337, \\field Vertex 112 Z-coordinate
       \\units m
       \\type real
  N338, \\field Vertex 113 X-coordinate
       \\units m
       \\type real
  N339, \\field Vertex 113 Y-coordinate
       \\units m
       \\type real
  N340, \\field Vertex 113 Z-coordinate
       \\units m
       \\type real
  N341, \\field Vertex 114 X-coordinate
       \\units m
       \\type real
  N342, \\field Vertex 114 Y-coordinate
       \\units m
       \\type real
  N343, \\field Vertex 114 Z-coordinate
       \\units m
       \\type real
  N344, \\field Vertex 115 X-coordinate
       \\units m
       \\type real
  N345, \\field Vertex 115 Y-coordinate
       \\units m
       \\type real
  N346, \\field Vertex 115 Z-coordinate
       \\units m
       \\type real
  N347, \\field Vertex 116 X-coordinate
       \\units m
       \\type real
  N348, \\field Vertex 116 Y-coordinate
       \\units m
       \\type real
  N349, \\field Vertex 116 Z-coordinate
       \\units m
       \\type real
  N350, \\field Vertex 117 X-coordinate
       \\units m
       \\type real
  N351, \\field Vertex 117 Y-coordinate
       \\units m
       \\type real
  N352, \\field Vertex 117 Z-coordinate
       \\units m
       \\type real
  N353, \\field Vertex 118 X-coordinate
       \\units m
       \\type real
  N354, \\field Vertex 118 Y-coordinate
       \\units m
       \\type real
  N355, \\field Vertex 118 Z-coordinate
       \\units m
       \\type real
  N356, \\field Vertex 119 X-coordinate
       \\units m
       \\type real
  N357, \\field Vertex 119 Y-coordinate
       \\units m
       \\type real
  N358, \\field Vertex 119 Z-coordinate
       \\units m
       \\type real
  N359, \\field Vertex 120 X-coordinate
       \\units m
       \\type real
  N360, \\field Vertex 120 Y-coordinate
       \\units m
       \\type real
  N361; \\field Vertex 120 Z-coordinate
       \\units m
       \\type real

Shading:Building:Detailed,
  \\extensible:3 -- duplicate last set of x,y,z coordinates, renumbering please (and changing z terminator to , for all but last)
       \\memo used for shading elements such as trees, other buildings, parts of this building not being modeled
       \\memo these items are relative to the current building and would move with relative geometry
       \\format vertices
       \\min-fields 12
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference AllShadingAndHTSurfNames
       \\reference AllShadingSurfNames
  A2,  \\field Transmittance Schedule Name
       \\note Transmittance schedule for the shading device, defaults to zero (always opaque)
       \\type object-list
       \\object-list ScheduleNames
  N1 , \\field Number of Vertices
       \\required-field
       \\note shown with 6 vertex coordinates -- extensible object
       \\autocalculatable
       \\default autocalculate
       \\minimum 3
       \\note Rules for vertices are given in GlobalGeometryRules coordinates --
       \\note For this object all surface coordinates are relative to the building origin (0,0,0)
       \\note and will rotate with the BUILDING north axis.
  N2,  \\field Vertex 1 X-coordinate
       \\begin-extensible
       \\required-field
       \\units m
       \\type real
  N3 , \\field Vertex 1 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N4 , \\field Vertex 1 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N5,  \\field Vertex 2 X-coordinate
       \\required-field
       \\units m
       \\type real
  N6,  \\field Vertex 2 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N7, \\field Vertex 2 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N8, \\field Vertex 3 X-coordinate
       \\required-field
       \\units m
       \\type real
  N9,  \\field Vertex 3 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N10, \\field Vertex 3 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N11, \\field Vertex 4 X-coordinate
       \\units m
       \\type real
  N12, \\field Vertex 4 Y-coordinate
       \\type real
       \\units m
  N13, \\field Vertex 4 Z-coordinate
       \\units m
       \\type real
  N14, \\field Vertex 5 X-coordinate
       \\units m
       \\type real
  N15, \\field Vertex 5 Y-coordinate
       \\units m
       \\type real
  N16, \\field Vertex 5 Z-coordinate
       \\units m
       \\type real
  N17, \\field Vertex 6 X-coordinate
       \\units m
       \\type real
  N18, \\field Vertex 6 Y-coordinate
       \\units m
       \\type real
  N19, \\field Vertex 6 Z-coordinate
       \\units m
       \\type real
  N20, \\field Vertex 7 X-coordinate
       \\units m
       \\type real
  N21, \\field Vertex 7 Y-coordinate
       \\units m
       \\type real
  N22, \\field Vertex 7 Z-coordinate
       \\units m
       \\type real
  N23, \\field Vertex 8 X-coordinate
       \\units m
       \\type real
  N24, \\field Vertex 8 Y-coordinate
       \\units m
       \\type real
  N25, \\field Vertex 8 Z-coordinate
       \\units m
       \\type real
  N26, \\field Vertex 9 X-coordinate
       \\units m
       \\type real
  N27, \\field Vertex 9 Y-coordinate
       \\units m
       \\type real
  N28, \\field Vertex 9 Z-coordinate
       \\units m
       \\type real
  N29, \\field Vertex 10 X-coordinate
       \\units m
       \\type real
  N30, \\field Vertex 10 Y-coordinate
       \\units m
       \\type real
  N31, \\field Vertex 10 Z-coordinate
       \\units m
       \\type real
  N32, \\field Vertex 11 X-coordinate
       \\units m
       \\type real
  N33, \\field Vertex 11 Y-coordinate
       \\units m
       \\type real
  N34, \\field Vertex 11 Z-coordinate
       \\units m
       \\type real
  N35, \\field Vertex 12 X-coordinate
       \\units m
       \\type real
  N36, \\field Vertex 12 Y-coordinate
       \\units m
       \\type real
  N37, \\field Vertex 12 Z-coordinate
       \\units m
       \\type real
  N38, \\field Vertex 13 X-coordinate
       \\units m
       \\type real
  N39, \\field Vertex 13 Y-coordinate
       \\units m
       \\type real
  N40, \\field Vertex 13 Z-coordinate
       \\units m
       \\type real
  N41, \\field Vertex 14 X-coordinate
       \\units m
       \\type real
  N42, \\field Vertex 14 Y-coordinate
       \\units m
       \\type real
  N43, \\field Vertex 14 Z-coordinate
       \\units m
       \\type real
  N44, \\field Vertex 15 X-coordinate
       \\units m
       \\type real
  N45, \\field Vertex 15 Y-coordinate
       \\units m
       \\type real
  N46, \\field Vertex 15 Z-coordinate
       \\units m
       \\type real
  N47, \\field Vertex 16 X-coordinate
       \\units m
       \\type real
  N48, \\field Vertex 16 Y-coordinate
       \\units m
       \\type real
  N49, \\field Vertex 16 Z-coordinate
       \\units m
       \\type real
  N50, \\field Vertex 17 X-coordinate
       \\units m
       \\type real
  N51, \\field Vertex 17 Y-coordinate
       \\units m
       \\type real
  N52, \\field Vertex 17 Z-coordinate
       \\units m
       \\type real
  N53, \\field Vertex 18 X-coordinate
       \\units m
       \\type real
  N54, \\field Vertex 18 Y-coordinate
       \\units m
       \\type real
  N55, \\field Vertex 18 Z-coordinate
       \\units m
       \\type real
  N56, \\field Vertex 19 X-coordinate
       \\units m
       \\type real
  N57, \\field Vertex 19 Y-coordinate
       \\units m
       \\type real
  N58, \\field Vertex 19 Z-coordinate
       \\units m
       \\type real
  N59, \\field Vertex 20 X-coordinate
       \\units m
       \\type real
  N60, \\field Vertex 20 Y-coordinate
       \\units m
       \\type real
  N61, \\field Vertex 20 Z-coordinate
       \\units m
       \\type real
  N62, \\field Vertex 21 X-coordinate
       \\units m
       \\type real
  N63, \\field Vertex 21 Y-coordinate
       \\units m
       \\type real
  N64, \\field Vertex 21 Z-coordinate
       \\units m
       \\type real
  N65, \\field Vertex 22 X-coordinate
       \\units m
       \\type real
  N66, \\field Vertex 22 Y-coordinate
       \\units m
       \\type real
  N67, \\field Vertex 22 Z-coordinate
       \\units m
       \\type real
  N68, \\field Vertex 23 X-coordinate
       \\units m
       \\type real
  N69, \\field Vertex 23 Y-coordinate
       \\units m
       \\type real
  N70, \\field Vertex 23 Z-coordinate
       \\units m
       \\type real
  N71, \\field Vertex 24 X-coordinate
       \\units m
       \\type real
  N72, \\field Vertex 24 Y-coordinate
       \\units m
       \\type real
  N73, \\field Vertex 24 Z-coordinate
       \\units m
       \\type real
  N74, \\field Vertex 25 X-coordinate
       \\units m
       \\type real
  N75, \\field Vertex 25 Y-coordinate
       \\units m
       \\type real
  N76, \\field Vertex 25 Z-coordinate
       \\units m
       \\type real
  N77, \\field Vertex 26 X-coordinate
       \\units m
       \\type real
  N78, \\field Vertex 26 Y-coordinate
       \\units m
       \\type real
  N79, \\field Vertex 26 Z-coordinate
       \\units m
       \\type real
  N80, \\field Vertex 27 X-coordinate
       \\units m
       \\type real
  N81, \\field Vertex 27 Y-coordinate
       \\units m
       \\type real
  N82, \\field Vertex 27 Z-coordinate
       \\units m
       \\type real
  N83, \\field Vertex 28 X-coordinate
       \\units m
       \\type real
  N84, \\field Vertex 28 Y-coordinate
       \\units m
       \\type real
  N85, \\field Vertex 28 Z-coordinate
       \\units m
       \\type real
  N86, \\field Vertex 29 X-coordinate
       \\units m
       \\type real
  N87, \\field Vertex 29 Y-coordinate
       \\units m
       \\type real
  N88, \\field Vertex 29 Z-coordinate
       \\units m
       \\type real
  N89, \\field Vertex 30 X-coordinate
       \\units m
       \\type real
  N90, \\field Vertex 30 Y-coordinate
       \\units m
       \\type real
  N91, \\field Vertex 30 Z-coordinate
       \\units m
       \\type real
  N92, \\field Vertex 31 X-coordinate
       \\units m
       \\type real
  N93, \\field Vertex 31 Y-coordinate
       \\units m
       \\type real
  N94, \\field Vertex 31 Z-coordinate
       \\units m
       \\type real
  N95, \\field Vertex 32 X-coordinate
       \\units m
       \\type real
  N96, \\field Vertex 32 Y-coordinate
       \\units m
       \\type real
  N97, \\field Vertex 32 Z-coordinate
       \\units m
       \\type real
  N98, \\field Vertex 33 X-coordinate
       \\units m
       \\type real
  N99, \\field Vertex 33 Y-coordinate
       \\units m
       \\type real
  N100, \\field Vertex 33 Z-coordinate
       \\units m
       \\type real
  N101, \\field Vertex 34 X-coordinate
       \\units m
       \\type real
  N102, \\field Vertex 34 Y-coordinate
       \\units m
       \\type real
  N103, \\field Vertex 34 Z-coordinate
       \\units m
       \\type real
  N104, \\field Vertex 35 X-coordinate
       \\units m
       \\type real
  N105, \\field Vertex 35 Y-coordinate
       \\units m
       \\type real
  N106, \\field Vertex 35 Z-coordinate
       \\units m
       \\type real
  N107, \\field Vertex 36 X-coordinate
       \\units m
       \\type real
  N108, \\field Vertex 36 Y-coordinate
       \\units m
       \\type real
  N109, \\field Vertex 36 Z-coordinate
       \\units m
       \\type real
  N110, \\field Vertex 37 X-coordinate
       \\units m
       \\type real
  N111, \\field Vertex 37 Y-coordinate
       \\units m
       \\type real
  N112, \\field Vertex 37 Z-coordinate
       \\units m
       \\type real
  N113, \\field Vertex 38 X-coordinate
       \\units m
       \\type real
  N114, \\field Vertex 38 Y-coordinate
       \\units m
       \\type real
  N115, \\field Vertex 38 Z-coordinate
       \\units m
       \\type real
  N116, \\field Vertex 39 X-coordinate
       \\units m
       \\type real
  N117, \\field Vertex 39 Y-coordinate
       \\units m
       \\type real
  N118, \\field Vertex 39 Z-coordinate
       \\units m
       \\type real
  N119, \\field Vertex 40 X-coordinate
       \\units m
       \\type real
  N120, \\field Vertex 40 Y-coordinate
       \\units m
       \\type real
  N121, \\field Vertex 40 Z-coordinate
       \\units m
       \\type real
  N122, \\field Vertex 41 X-coordinate
       \\units m
       \\type real
  N123, \\field Vertex 41 Y-coordinate
       \\units m
       \\type real
  N124, \\field Vertex 41 Z-coordinate
       \\units m
       \\type real
  N125, \\field Vertex 42 X-coordinate
       \\units m
       \\type real
  N126, \\field Vertex 42 Y-coordinate
       \\units m
       \\type real
  N127, \\field Vertex 42 Z-coordinate
       \\units m
       \\type real
  N128, \\field Vertex 43 X-coordinate
       \\units m
       \\type real
  N129, \\field Vertex 43 Y-coordinate
       \\units m
       \\type real
  N130, \\field Vertex 43 Z-coordinate
       \\units m
       \\type real
  N131, \\field Vertex 44 X-coordinate
       \\units m
       \\type real
  N132, \\field Vertex 44 Y-coordinate
       \\units m
       \\type real
  N133, \\field Vertex 44 Z-coordinate
       \\units m
       \\type real
  N134, \\field Vertex 45 X-coordinate
       \\units m
       \\type real
  N135, \\field Vertex 45 Y-coordinate
       \\units m
       \\type real
  N136, \\field Vertex 45 Z-coordinate
       \\units m
       \\type real
  N137, \\field Vertex 46 X-coordinate
       \\units m
       \\type real
  N138, \\field Vertex 46 Y-coordinate
       \\units m
       \\type real
  N139, \\field Vertex 46 Z-coordinate
       \\units m
       \\type real
  N140, \\field Vertex 47 X-coordinate
       \\units m
       \\type real
  N141, \\field Vertex 47 Y-coordinate
       \\units m
       \\type real
  N142, \\field Vertex 47 Z-coordinate
       \\units m
       \\type real
  N143, \\field Vertex 48 X-coordinate
       \\units m
       \\type real
  N144, \\field Vertex 48 Y-coordinate
       \\units m
       \\type real
  N145, \\field Vertex 48 Z-coordinate
       \\units m
       \\type real
  N146, \\field Vertex 49 X-coordinate
       \\units m
       \\type real
  N147, \\field Vertex 49 Y-coordinate
       \\units m
       \\type real
  N148, \\field Vertex 49 Z-coordinate
       \\units m
       \\type real
  N149, \\field Vertex 50 X-coordinate
       \\units m
       \\type real
  N150, \\field Vertex 50 Y-coordinate
       \\units m
       \\type real
  N151, \\field Vertex 50 Z-coordinate
       \\units m
       \\type real
  N152, \\field Vertex 51 X-coordinate
       \\units m
       \\type real
  N153, \\field Vertex 51 Y-coordinate
       \\units m
       \\type real
  N154, \\field Vertex 51 Z-coordinate
       \\units m
       \\type real
  N155, \\field Vertex 52 X-coordinate
       \\units m
       \\type real
  N156, \\field Vertex 52 Y-coordinate
       \\units m
       \\type real
  N157, \\field Vertex 52 Z-coordinate
       \\units m
       \\type real
  N158, \\field Vertex 53 X-coordinate
       \\units m
       \\type real
  N159, \\field Vertex 53 Y-coordinate
       \\units m
       \\type real
  N160, \\field Vertex 53 Z-coordinate
       \\units m
       \\type real
  N161, \\field Vertex 54 X-coordinate
       \\units m
       \\type real
  N162, \\field Vertex 54 Y-coordinate
       \\units m
       \\type real
  N163, \\field Vertex 54 Z-coordinate
       \\units m
       \\type real
  N164, \\field Vertex 55 X-coordinate
       \\units m
       \\type real
  N165, \\field Vertex 55 Y-coordinate
       \\units m
       \\type real
  N166, \\field Vertex 55 Z-coordinate
       \\units m
       \\type real
  N167, \\field Vertex 56 X-coordinate
       \\units m
       \\type real
  N168, \\field Vertex 56 Y-coordinate
       \\units m
       \\type real
  N169, \\field Vertex 56 Z-coordinate
       \\units m
       \\type real
  N170, \\field Vertex 57 X-coordinate
       \\units m
       \\type real
  N171, \\field Vertex 57 Y-coordinate
       \\units m
       \\type real
  N172, \\field Vertex 57 Z-coordinate
       \\units m
       \\type real
  N173, \\field Vertex 58 X-coordinate
       \\units m
       \\type real
  N174, \\field Vertex 58 Y-coordinate
       \\units m
       \\type real
  N175, \\field Vertex 58 Z-coordinate
       \\units m
       \\type real
  N176, \\field Vertex 59 X-coordinate
       \\units m
       \\type real
  N177, \\field Vertex 59 Y-coordinate
       \\units m
       \\type real
  N178, \\field Vertex 59 Z-coordinate
       \\units m
       \\type real
  N179, \\field Vertex 60 X-coordinate
       \\units m
       \\type real
  N180, \\field Vertex 60 Y-coordinate
       \\units m
       \\type real
  N181, \\field Vertex 60 Z-coordinate
       \\units m
       \\type real
  N182, \\field Vertex 61 X-coordinate
       \\units m
       \\type real
  N183, \\field Vertex 61 Y-coordinate
       \\units m
       \\type real
  N184, \\field Vertex 61 Z-coordinate
       \\units m
       \\type real
  N185, \\field Vertex 62 X-coordinate
       \\units m
       \\type real
  N186, \\field Vertex 62 Y-coordinate
       \\units m
       \\type real
  N187, \\field Vertex 62 Z-coordinate
       \\units m
       \\type real
  N188, \\field Vertex 63 X-coordinate
       \\units m
       \\type real
  N189, \\field Vertex 63 Y-coordinate
       \\units m
       \\type real
  N190, \\field Vertex 63 Z-coordinate
       \\units m
       \\type real
  N191, \\field Vertex 64 X-coordinate
       \\units m
       \\type real
  N192, \\field Vertex 64 Y-coordinate
       \\units m
       \\type real
  N193, \\field Vertex 64 Z-coordinate
       \\units m
       \\type real
  N194, \\field Vertex 65 X-coordinate
       \\units m
       \\type real
  N195, \\field Vertex 65 Y-coordinate
       \\units m
       \\type real
  N196, \\field Vertex 65 Z-coordinate
       \\units m
       \\type real
  N197, \\field Vertex 66 X-coordinate
       \\units m
       \\type real
  N198, \\field Vertex 66 Y-coordinate
       \\units m
       \\type real
  N199, \\field Vertex 66 Z-coordinate
       \\units m
       \\type real
  N200, \\field Vertex 67 X-coordinate
       \\units m
       \\type real
  N201, \\field Vertex 67 Y-coordinate
       \\units m
       \\type real
  N202, \\field Vertex 67 Z-coordinate
       \\units m
       \\type real
  N203, \\field Vertex 68 X-coordinate
       \\units m
       \\type real
  N204, \\field Vertex 68 Y-coordinate
       \\units m
       \\type real
  N205, \\field Vertex 68 Z-coordinate
       \\units m
       \\type real
  N206, \\field Vertex 69 X-coordinate
       \\units m
       \\type real
  N207, \\field Vertex 69 Y-coordinate
       \\units m
       \\type real
  N208, \\field Vertex 69 Z-coordinate
       \\units m
       \\type real
  N209, \\field Vertex 70 X-coordinate
       \\units m
       \\type real
  N210, \\field Vertex 70 Y-coordinate
       \\units m
       \\type real
  N211, \\field Vertex 70 Z-coordinate
       \\units m
       \\type real
  N212, \\field Vertex 71 X-coordinate
       \\units m
       \\type real
  N213, \\field Vertex 71 Y-coordinate
       \\units m
       \\type real
  N214, \\field Vertex 71 Z-coordinate
       \\units m
       \\type real
  N215, \\field Vertex 72 X-coordinate
       \\units m
       \\type real
  N216, \\field Vertex 72 Y-coordinate
       \\units m
       \\type real
  N217, \\field Vertex 72 Z-coordinate
       \\units m
       \\type real
  N218, \\field Vertex 73 X-coordinate
       \\units m
       \\type real
  N219, \\field Vertex 73 Y-coordinate
       \\units m
       \\type real
  N220, \\field Vertex 73 Z-coordinate
       \\units m
       \\type real
  N221, \\field Vertex 74 X-coordinate
       \\units m
       \\type real
  N222, \\field Vertex 74 Y-coordinate
       \\units m
       \\type real
  N223, \\field Vertex 74 Z-coordinate
       \\units m
       \\type real
  N224, \\field Vertex 75 X-coordinate
       \\units m
       \\type real
  N225, \\field Vertex 75 Y-coordinate
       \\units m
       \\type real
  N226, \\field Vertex 75 Z-coordinate
       \\units m
       \\type real
  N227, \\field Vertex 76 X-coordinate
       \\units m
       \\type real
  N228, \\field Vertex 76 Y-coordinate
       \\units m
       \\type real
  N229, \\field Vertex 76 Z-coordinate
       \\units m
       \\type real
  N230, \\field Vertex 77 X-coordinate
       \\units m
       \\type real
  N231, \\field Vertex 77 Y-coordinate
       \\units m
       \\type real
  N232, \\field Vertex 77 Z-coordinate
       \\units m
       \\type real
  N233, \\field Vertex 78 X-coordinate
       \\units m
       \\type real
  N234, \\field Vertex 78 Y-coordinate
       \\units m
       \\type real
  N235, \\field Vertex 78 Z-coordinate
       \\units m
       \\type real
  N236, \\field Vertex 79 X-coordinate
       \\units m
       \\type real
  N237, \\field Vertex 79 Y-coordinate
       \\units m
       \\type real
  N238, \\field Vertex 79 Z-coordinate
       \\units m
       \\type real
  N239, \\field Vertex 80 X-coordinate
       \\units m
       \\type real
  N240, \\field Vertex 80 Y-coordinate
       \\units m
       \\type real
  N241, \\field Vertex 80 Z-coordinate
       \\units m
       \\type real
  N242, \\field Vertex 81 X-coordinate
       \\units m
       \\type real
  N243, \\field Vertex 81 Y-coordinate
       \\units m
       \\type real
  N244, \\field Vertex 81 Z-coordinate
       \\units m
       \\type real
  N245, \\field Vertex 82 X-coordinate
       \\units m
       \\type real
  N246, \\field Vertex 82 Y-coordinate
       \\units m
       \\type real
  N247, \\field Vertex 82 Z-coordinate
       \\units m
       \\type real
  N248, \\field Vertex 83 X-coordinate
       \\units m
       \\type real
  N249, \\field Vertex 83 Y-coordinate
       \\units m
       \\type real
  N250, \\field Vertex 83 Z-coordinate
       \\units m
       \\type real
  N251, \\field Vertex 84 X-coordinate
       \\units m
       \\type real
  N252, \\field Vertex 84 Y-coordinate
       \\units m
       \\type real
  N253, \\field Vertex 84 Z-coordinate
       \\units m
       \\type real
  N254, \\field Vertex 85 X-coordinate
       \\units m
       \\type real
  N255, \\field Vertex 85 Y-coordinate
       \\units m
       \\type real
  N256, \\field Vertex 85 Z-coordinate
       \\units m
       \\type real
  N257, \\field Vertex 86 X-coordinate
       \\units m
       \\type real
  N258, \\field Vertex 86 Y-coordinate
       \\units m
       \\type real
  N259, \\field Vertex 86 Z-coordinate
       \\units m
       \\type real
  N260, \\field Vertex 87 X-coordinate
       \\units m
       \\type real
  N261, \\field Vertex 87 Y-coordinate
       \\units m
       \\type real
  N262, \\field Vertex 87 Z-coordinate
       \\units m
       \\type real
  N263, \\field Vertex 88 X-coordinate
       \\units m
       \\type real
  N264, \\field Vertex 88 Y-coordinate
       \\units m
       \\type real
  N265, \\field Vertex 88 Z-coordinate
       \\units m
       \\type real
  N266, \\field Vertex 89 X-coordinate
       \\units m
       \\type real
  N267, \\field Vertex 89 Y-coordinate
       \\units m
       \\type real
  N268, \\field Vertex 89 Z-coordinate
       \\units m
       \\type real
  N269, \\field Vertex 90 X-coordinate
       \\units m
       \\type real
  N270, \\field Vertex 90 Y-coordinate
       \\units m
       \\type real
  N271, \\field Vertex 90 Z-coordinate
       \\units m
       \\type real
  N272, \\field Vertex 91 X-coordinate
       \\units m
       \\type real
  N273, \\field Vertex 91 Y-coordinate
       \\units m
       \\type real
  N274, \\field Vertex 91 Z-coordinate
       \\units m
       \\type real
  N275, \\field Vertex 92 X-coordinate
       \\units m
       \\type real
  N276, \\field Vertex 92 Y-coordinate
       \\units m
       \\type real
  N277, \\field Vertex 92 Z-coordinate
       \\units m
       \\type real
  N278, \\field Vertex 93 X-coordinate
       \\units m
       \\type real
  N279, \\field Vertex 93 Y-coordinate
       \\units m
       \\type real
  N280, \\field Vertex 93 Z-coordinate
       \\units m
       \\type real
  N281, \\field Vertex 94 X-coordinate
       \\units m
       \\type real
  N282, \\field Vertex 94 Y-coordinate
       \\units m
       \\type real
  N283, \\field Vertex 94 Z-coordinate
       \\units m
       \\type real
  N284, \\field Vertex 95 X-coordinate
       \\units m
       \\type real
  N285, \\field Vertex 95 Y-coordinate
       \\units m
       \\type real
  N286, \\field Vertex 95 Z-coordinate
       \\units m
       \\type real
  N287, \\field Vertex 96 X-coordinate
       \\units m
       \\type real
  N288, \\field Vertex 96 Y-coordinate
       \\units m
       \\type real
  N289, \\field Vertex 96 Z-coordinate
       \\units m
       \\type real
  N290, \\field Vertex 97 X-coordinate
       \\units m
       \\type real
  N291, \\field Vertex 97 Y-coordinate
       \\units m
       \\type real
  N292, \\field Vertex 97 Z-coordinate
       \\units m
       \\type real
  N293, \\field Vertex 98 X-coordinate
       \\units m
       \\type real
  N294, \\field Vertex 98 Y-coordinate
       \\units m
       \\type real
  N295, \\field Vertex 98 Z-coordinate
       \\units m
       \\type real
  N296, \\field Vertex 99 X-coordinate
       \\units m
       \\type real
  N297, \\field Vertex 99 Y-coordinate
       \\units m
       \\type real
  N298, \\field Vertex 99 Z-coordinate
       \\units m
       \\type real
  N299, \\field Vertex 100 X-coordinate
       \\units m
       \\type real
  N300, \\field Vertex 100 Y-coordinate
       \\units m
       \\type real
  N301, \\field Vertex 100 Z-coordinate
       \\units m
       \\type real
  N302, \\field Vertex 101 X-coordinate
       \\units m
       \\type real
  N303, \\field Vertex 101 Y-coordinate
       \\units m
       \\type real
  N304, \\field Vertex 101 Z-coordinate
       \\units m
       \\type real
  N305, \\field Vertex 102 X-coordinate
       \\units m
       \\type real
  N306, \\field Vertex 102 Y-coordinate
       \\units m
       \\type real
  N307, \\field Vertex 102 Z-coordinate
       \\units m
       \\type real
  N308, \\field Vertex 103 X-coordinate
       \\units m
       \\type real
  N309, \\field Vertex 103 Y-coordinate
       \\units m
       \\type real
  N310, \\field Vertex 103 Z-coordinate
       \\units m
       \\type real
  N311, \\field Vertex 104 X-coordinate
       \\units m
       \\type real
  N312, \\field Vertex 104 Y-coordinate
       \\units m
       \\type real
  N313, \\field Vertex 104 Z-coordinate
       \\units m
       \\type real
  N314, \\field Vertex 105 X-coordinate
       \\units m
       \\type real
  N315, \\field Vertex 105 Y-coordinate
       \\units m
       \\type real
  N316, \\field Vertex 105 Z-coordinate
       \\units m
       \\type real
  N317, \\field Vertex 106 X-coordinate
       \\units m
       \\type real
  N318, \\field Vertex 106 Y-coordinate
       \\units m
       \\type real
  N319, \\field Vertex 106 Z-coordinate
       \\units m
       \\type real
  N320, \\field Vertex 107 X-coordinate
       \\units m
       \\type real
  N321, \\field Vertex 107 Y-coordinate
       \\units m
       \\type real
  N322, \\field Vertex 107 Z-coordinate
       \\units m
       \\type real
  N323, \\field Vertex 108 X-coordinate
       \\units m
       \\type real
  N324, \\field Vertex 108 Y-coordinate
       \\units m
       \\type real
  N325, \\field Vertex 108 Z-coordinate
       \\units m
       \\type real
  N326, \\field Vertex 109 X-coordinate
       \\units m
       \\type real
  N327, \\field Vertex 109 Y-coordinate
       \\units m
       \\type real
  N328, \\field Vertex 109 Z-coordinate
       \\units m
       \\type real
  N329, \\field Vertex 110 X-coordinate
       \\units m
       \\type real
  N330, \\field Vertex 110 Y-coordinate
       \\units m
       \\type real
  N331, \\field Vertex 110 Z-coordinate
       \\units m
       \\type real
  N332, \\field Vertex 111 X-coordinate
       \\units m
       \\type real
  N333, \\field Vertex 111 Y-coordinate
       \\units m
       \\type real
  N334, \\field Vertex 111 Z-coordinate
       \\units m
       \\type real
  N335, \\field Vertex 112 X-coordinate
       \\units m
       \\type real
  N336, \\field Vertex 112 Y-coordinate
       \\units m
       \\type real
  N337, \\field Vertex 112 Z-coordinate
       \\units m
       \\type real
  N338, \\field Vertex 113 X-coordinate
       \\units m
       \\type real
  N339, \\field Vertex 113 Y-coordinate
       \\units m
       \\type real
  N340, \\field Vertex 113 Z-coordinate
       \\units m
       \\type real
  N341, \\field Vertex 114 X-coordinate
       \\units m
       \\type real
  N342, \\field Vertex 114 Y-coordinate
       \\units m
       \\type real
  N343, \\field Vertex 114 Z-coordinate
       \\units m
       \\type real
  N344, \\field Vertex 115 X-coordinate
       \\units m
       \\type real
  N345, \\field Vertex 115 Y-coordinate
       \\units m
       \\type real
  N346, \\field Vertex 115 Z-coordinate
       \\units m
       \\type real
  N347, \\field Vertex 116 X-coordinate
       \\units m
       \\type real
  N348, \\field Vertex 116 Y-coordinate
       \\units m
       \\type real
  N349, \\field Vertex 116 Z-coordinate
       \\units m
       \\type real
  N350, \\field Vertex 117 X-coordinate
       \\units m
       \\type real
  N351, \\field Vertex 117 Y-coordinate
       \\units m
       \\type real
  N352, \\field Vertex 117 Z-coordinate
       \\units m
       \\type real
  N353, \\field Vertex 118 X-coordinate
       \\units m
       \\type real
  N354, \\field Vertex 118 Y-coordinate
       \\units m
       \\type real
  N355, \\field Vertex 118 Z-coordinate
       \\units m
       \\type real
  N356, \\field Vertex 119 X-coordinate
       \\units m
       \\type real
  N357, \\field Vertex 119 Y-coordinate
       \\units m
       \\type real
  N358, \\field Vertex 119 Z-coordinate
       \\units m
       \\type real
  N359, \\field Vertex 120 X-coordinate
       \\units m
       \\type real
  N360, \\field Vertex 120 Y-coordinate
       \\units m
       \\type real
  N361; \\field Vertex 120 Z-coordinate
       \\units m
       \\type real

Shading:Overhang,
      \\memo Overhangs are usually flat shading surfaces that reference a window or door.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference AttachedShadingSurfNames
       \\reference AllShadingAndHTSurfNames
       \\reference AllShadingSurfNames
  A2 , \\field Window or Door Name
       \\required-field
       \\type object-list
       \\object-list SubSurfNames
  N1,  \\field Height above Window or Door
       \\units m
  N2,  \\field Tilt Angle from Window/Door
       \\units deg
       \\default 90
       \\minimum 0
       \\maximum 180
  N3,  \\field Left extension from Window/Door Width
       \\units m
  N4,  \\field Right extension from Window/Door Width
       \\note N3 + N4 + Window/Door Width is Overhang Length
       \\units m
  N5;  \\field Depth
       \\units m
       \\minimum 0

Shading:Overhang:Projection,
      \\memo Overhangs are typically flat shading surfaces that reference a window or door.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference AttachedShadingSurfNames
       \\reference AllShadingAndHTSurfNames
       \\reference AllShadingSurfNames
  A2 , \\field Window or Door Name
       \\required-field
       \\type object-list
       \\object-list SubSurfNames
  N1,  \\field Height above Window or Door
       \\units m
  N2,  \\field Tilt Angle from Window/Door
       \\units deg
       \\default 90
       \\minimum 0
       \\maximum 180
  N3,  \\field Left extension from Window/Door Width
       \\units m
  N4,  \\field Right extension from Window/Door Width
       \\units m
       \\note N3 + N4 + Window/Door Width is Overhang Length
  N5;  \\field Depth as Fraction of Window/Door Height
       \\units dimensionless
       \\minimum 0

Shading:Fin,
      \\memo Fins are usually shading surfaces that are perpendicular to a window or door.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference AttachedShadingSurfNames
       \\reference AllShadingAndHTSurfNames
       \\reference AllShadingSurfNames
  A2 , \\field Window or Door Name
       \\required-field
       \\type object-list
       \\object-list SubSurfNames
  N1,  \\field Left Extension from Window/Door
       \\units m
  N2,  \\field Left Distance Above Top of Window
       \\units m
  N3,  \\field Left Distance Below Bottom of Window
       \\units m
       \\note N2 + N3 + height of Window/Door is height of Fin
  N4,  \\field Left Tilt Angle from Window/Door
       \\units deg
       \\default 90
       \\minimum 0
       \\maximum 180
  N5,  \\field Left Depth
       \\units m
       \\minimum 0
  N6,  \\field Right Extension from Window/Door
       \\units m
  N7,  \\field Right Distance Above Top of Window
       \\units m
  N8,  \\field Right Distance Below Bottom of Window
       \\note N7 + N8 + height of Window/Door is height of Fin
       \\units m
  N9,  \\field Right Tilt Angle from Window/Door
       \\units deg
       \\default 90
       \\minimum 0
       \\maximum 180
  N10; \\field Right Depth
       \\units m
       \\minimum 0

Shading:Fin:Projection,
      \\memo Fins are usually shading surfaces that are perpendicular to a window or door.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference AttachedShadingSurfNames
       \\reference AllShadingAndHTSurfNames
       \\reference AllShadingSurfNames
  A2 , \\field Window or Door Name
       \\required-field
       \\type object-list
       \\object-list SubSurfNames
  N1,  \\field Left Extension from Window/Door
       \\units m
  N2,  \\field Left Distance Above Top of Window
       \\units m
  N3,  \\field Left Distance Below Bottom of Window
       \\units m
       \\note N2 + N3 + height of Window/Door is height of Fin
  N4,  \\field Left Tilt Angle from Window/Door
       \\units deg
       \\default 90
       \\minimum 0
       \\maximum 180
  N5,  \\field Left Depth as Fraction of Window/Door Width
       \\units dimensionless
       \\minimum 0
  N6,  \\field Right Extension from Window/Door
       \\units m
  N7,  \\field Right Distance Above Top of Window
       \\units m
  N8,  \\field Right Distance Below Bottom of Window
       \\note N7 + N8 + height of Window/Door is height of Fin
       \\units m
  N9,  \\field Right Tilt Angle from Window/Door
       \\units deg
       \\default 90
       \\minimum 0
       \\maximum 180
  N10; \\field Right Depth as Fraction of Window/Door Width
       \\units dimensionless
       \\minimum 0

Shading:Zone:Detailed,
  \\extensible:3 -- duplicate last set of x,y,z coordinates, renumbering please (and changing z terminator to , for all but last)
       \\memo used For fins, overhangs, elements that shade the building, are attached to the building
       \\memo but are not part of the heat transfer calculations
       \\format vertices
       \\min-fields 13
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference AttachedShadingSurfNames
       \\reference AllShadingAndHTSurfNames
       \\reference AllShadingSurfNames
  A2 , \\field Base Surface Name
       \\required-field
       \\type object-list
       \\object-list SurfaceNames
  A3,  \\field Transmittance Schedule Name
       \\note Transmittance schedule for the shading device, defaults to zero (always opaque)
       \\type object-list
       \\object-list ScheduleNames
  N1 , \\field Number of Vertices
       \\required-field
       \\note shown with 6 vertex coordinates -- extensible object
       \\autocalculatable
       \\default autocalculate
       \\minimum 3
       \\note vertices are given in GlobalGeometryRules coordinates -- if relative, all surface coordinates
       \\note are "relative" to the Zone Origin.  if world, then building and zone origins are used
       \\note for some internal calculations, but all coordinates are given in an "absolute" system.
  N2,  \\field Vertex 1 X-coordinate
       \\begin-extensible
       \\required-field
       \\units m
       \\type real
  N3 , \\field Vertex 1 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N4 , \\field Vertex 1 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N5,  \\field Vertex 2 X-coordinate
       \\required-field
       \\units m
       \\type real
  N6,  \\field Vertex 2 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N7, \\field Vertex 2 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N8, \\field Vertex 3 X-coordinate
       \\required-field
       \\units m
       \\type real
  N9,  \\field Vertex 3 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N10, \\field Vertex 3 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N11, \\field Vertex 4 X-coordinate
       \\units m
       \\type real
  N12, \\field Vertex 4 Y-coordinate
       \\type real
       \\units m
  N13, \\field Vertex 4 Z-coordinate
       \\units m
       \\type real
  N14, \\field Vertex 5 X-coordinate
       \\units m
       \\type real
  N15, \\field Vertex 5 Y-coordinate
       \\type real
       \\units m
  N16, \\field Vertex 5 Z-coordinate
       \\units m
       \\type real
  N17, \\field Vertex 6 X-coordinate
       \\units m
       \\type real
  N18, \\field Vertex 6 Y-coordinate
       \\units m
       \\type real
  N19, \\field Vertex 6 Z-coordinate
       \\units m
       \\type real
  N20, \\field Vertex 7 X-coordinate
       \\units m
       \\type real
  N21, \\field Vertex 7 Y-coordinate
       \\units m
       \\type real
  N22, \\field Vertex 7 Z-coordinate
       \\units m
       \\type real
  N23, \\field Vertex 8 X-coordinate
       \\units m
       \\type real
  N24, \\field Vertex 8 Y-coordinate
       \\units m
       \\type real
  N25, \\field Vertex 8 Z-coordinate
       \\units m
       \\type real
  N26, \\field Vertex 9 X-coordinate
       \\units m
       \\type real
  N27, \\field Vertex 9 Y-coordinate
       \\units m
       \\type real
  N28, \\field Vertex 9 Z-coordinate
       \\units m
       \\type real
  N29, \\field Vertex 10 X-coordinate
       \\units m
       \\type real
  N30, \\field Vertex 10 Y-coordinate
       \\units m
       \\type real
  N31, \\field Vertex 10 Z-coordinate
       \\units m
       \\type real
  N32, \\field Vertex 11 X-coordinate
       \\units m
       \\type real
  N33, \\field Vertex 11 Y-coordinate
       \\units m
       \\type real
  N34, \\field Vertex 11 Z-coordinate
       \\units m
       \\type real
  N35, \\field Vertex 12 X-coordinate
       \\units m
       \\type real
  N36, \\field Vertex 12 Y-coordinate
       \\units m
       \\type real
  N37, \\field Vertex 12 Z-coordinate
       \\units m
       \\type real
  N38, \\field Vertex 13 X-coordinate
       \\units m
       \\type real
  N39, \\field Vertex 13 Y-coordinate
       \\units m
       \\type real
  N40, \\field Vertex 13 Z-coordinate
       \\units m
       \\type real
  N41, \\field Vertex 14 X-coordinate
       \\units m
       \\type real
  N42, \\field Vertex 14 Y-coordinate
       \\units m
       \\type real
  N43, \\field Vertex 14 Z-coordinate
       \\units m
       \\type real
  N44, \\field Vertex 15 X-coordinate
       \\units m
       \\type real
  N45, \\field Vertex 15 Y-coordinate
       \\units m
       \\type real
  N46, \\field Vertex 15 Z-coordinate
       \\units m
       \\type real
  N47, \\field Vertex 16 X-coordinate
       \\units m
       \\type real
  N48, \\field Vertex 16 Y-coordinate
       \\units m
       \\type real
  N49, \\field Vertex 16 Z-coordinate
       \\units m
       \\type real
  N50, \\field Vertex 17 X-coordinate
       \\units m
       \\type real
  N51, \\field Vertex 17 Y-coordinate
       \\units m
       \\type real
  N52, \\field Vertex 17 Z-coordinate
       \\units m
       \\type real
  N53, \\field Vertex 18 X-coordinate
       \\units m
       \\type real
  N54, \\field Vertex 18 Y-coordinate
       \\units m
       \\type real
  N55, \\field Vertex 18 Z-coordinate
       \\units m
       \\type real
  N56, \\field Vertex 19 X-coordinate
       \\units m
       \\type real
  N57, \\field Vertex 19 Y-coordinate
       \\units m
       \\type real
  N58, \\field Vertex 19 Z-coordinate
       \\units m
       \\type real
  N59, \\field Vertex 20 X-coordinate
       \\units m
       \\type real
  N60, \\field Vertex 20 Y-coordinate
       \\units m
       \\type real
  N61, \\field Vertex 20 Z-coordinate
       \\units m
       \\type real
  N62, \\field Vertex 21 X-coordinate
       \\units m
       \\type real
  N63, \\field Vertex 21 Y-coordinate
       \\units m
       \\type real
  N64, \\field Vertex 21 Z-coordinate
       \\units m
       \\type real
  N65, \\field Vertex 22 X-coordinate
       \\units m
       \\type real
  N66, \\field Vertex 22 Y-coordinate
       \\units m
       \\type real
  N67, \\field Vertex 22 Z-coordinate
       \\units m
       \\type real
  N68, \\field Vertex 23 X-coordinate
       \\units m
       \\type real
  N69, \\field Vertex 23 Y-coordinate
       \\units m
       \\type real
  N70, \\field Vertex 23 Z-coordinate
       \\units m
       \\type real
  N71, \\field Vertex 24 X-coordinate
       \\units m
       \\type real
  N72, \\field Vertex 24 Y-coordinate
       \\units m
       \\type real
  N73, \\field Vertex 24 Z-coordinate
       \\units m
       \\type real
  N74, \\field Vertex 25 X-coordinate
       \\units m
       \\type real
  N75, \\field Vertex 25 Y-coordinate
       \\units m
       \\type real
  N76, \\field Vertex 25 Z-coordinate
       \\units m
       \\type real
  N77, \\field Vertex 26 X-coordinate
       \\units m
       \\type real
  N78, \\field Vertex 26 Y-coordinate
       \\units m
       \\type real
  N79, \\field Vertex 26 Z-coordinate
       \\units m
       \\type real
  N80, \\field Vertex 27 X-coordinate
       \\units m
       \\type real
  N81, \\field Vertex 27 Y-coordinate
       \\units m
       \\type real
  N82, \\field Vertex 27 Z-coordinate
       \\units m
       \\type real
  N83, \\field Vertex 28 X-coordinate
       \\units m
       \\type real
  N84, \\field Vertex 28 Y-coordinate
       \\units m
       \\type real
  N85, \\field Vertex 28 Z-coordinate
       \\units m
       \\type real
  N86, \\field Vertex 29 X-coordinate
       \\units m
       \\type real
  N87, \\field Vertex 29 Y-coordinate
       \\units m
       \\type real
  N88, \\field Vertex 29 Z-coordinate
       \\units m
       \\type real
  N89, \\field Vertex 30 X-coordinate
       \\units m
       \\type real
  N90, \\field Vertex 30 Y-coordinate
       \\units m
       \\type real
  N91, \\field Vertex 30 Z-coordinate
       \\units m
       \\type real
  N92, \\field Vertex 31 X-coordinate
       \\units m
       \\type real
  N93, \\field Vertex 31 Y-coordinate
       \\units m
       \\type real
  N94, \\field Vertex 31 Z-coordinate
       \\units m
       \\type real
  N95, \\field Vertex 32 X-coordinate
       \\units m
       \\type real
  N96, \\field Vertex 32 Y-coordinate
       \\units m
       \\type real
  N97, \\field Vertex 32 Z-coordinate
       \\units m
       \\type real
  N98, \\field Vertex 33 X-coordinate
       \\units m
       \\type real
  N99, \\field Vertex 33 Y-coordinate
       \\units m
       \\type real
  N100, \\field Vertex 33 Z-coordinate
       \\units m
       \\type real
  N101, \\field Vertex 34 X-coordinate
       \\units m
       \\type real
  N102, \\field Vertex 34 Y-coordinate
       \\units m
       \\type real
  N103, \\field Vertex 34 Z-coordinate
       \\units m
       \\type real
  N104, \\field Vertex 35 X-coordinate
       \\units m
       \\type real
  N105, \\field Vertex 35 Y-coordinate
       \\units m
       \\type real
  N106, \\field Vertex 35 Z-coordinate
       \\units m
       \\type real
  N107, \\field Vertex 36 X-coordinate
       \\units m
       \\type real
  N108, \\field Vertex 36 Y-coordinate
       \\units m
       \\type real
  N109, \\field Vertex 36 Z-coordinate
       \\units m
       \\type real
  N110, \\field Vertex 37 X-coordinate
       \\units m
       \\type real
  N111, \\field Vertex 37 Y-coordinate
       \\units m
       \\type real
  N112, \\field Vertex 37 Z-coordinate
       \\units m
       \\type real
  N113, \\field Vertex 38 X-coordinate
       \\units m
       \\type real
  N114, \\field Vertex 38 Y-coordinate
       \\units m
       \\type real
  N115, \\field Vertex 38 Z-coordinate
       \\units m
       \\type real
  N116, \\field Vertex 39 X-coordinate
       \\units m
       \\type real
  N117, \\field Vertex 39 Y-coordinate
       \\units m
       \\type real
  N118, \\field Vertex 39 Z-coordinate
       \\units m
       \\type real
  N119, \\field Vertex 40 X-coordinate
       \\units m
       \\type real
  N120, \\field Vertex 40 Y-coordinate
       \\units m
       \\type real
  N121, \\field Vertex 40 Z-coordinate
       \\units m
       \\type real
  N122, \\field Vertex 41 X-coordinate
       \\units m
       \\type real
  N123, \\field Vertex 41 Y-coordinate
       \\units m
       \\type real
  N124, \\field Vertex 41 Z-coordinate
       \\units m
       \\type real
  N125, \\field Vertex 42 X-coordinate
       \\units m
       \\type real
  N126, \\field Vertex 42 Y-coordinate
       \\units m
       \\type real
  N127, \\field Vertex 42 Z-coordinate
       \\units m
       \\type real
  N128, \\field Vertex 43 X-coordinate
       \\units m
       \\type real
  N129, \\field Vertex 43 Y-coordinate
       \\units m
       \\type real
  N130, \\field Vertex 43 Z-coordinate
       \\units m
       \\type real
  N131, \\field Vertex 44 X-coordinate
       \\units m
       \\type real
  N132, \\field Vertex 44 Y-coordinate
       \\units m
       \\type real
  N133, \\field Vertex 44 Z-coordinate
       \\units m
       \\type real
  N134, \\field Vertex 45 X-coordinate
       \\units m
       \\type real
  N135, \\field Vertex 45 Y-coordinate
       \\units m
       \\type real
  N136, \\field Vertex 45 Z-coordinate
       \\units m
       \\type real
  N137, \\field Vertex 46 X-coordinate
       \\units m
       \\type real
  N138, \\field Vertex 46 Y-coordinate
       \\units m
       \\type real
  N139, \\field Vertex 46 Z-coordinate
       \\units m
       \\type real
  N140, \\field Vertex 47 X-coordinate
       \\units m
       \\type real
  N141, \\field Vertex 47 Y-coordinate
       \\units m
       \\type real
  N142, \\field Vertex 47 Z-coordinate
       \\units m
       \\type real
  N143, \\field Vertex 48 X-coordinate
       \\units m
       \\type real
  N144, \\field Vertex 48 Y-coordinate
       \\units m
       \\type real
  N145, \\field Vertex 48 Z-coordinate
       \\units m
       \\type real
  N146, \\field Vertex 49 X-coordinate
       \\units m
       \\type real
  N147, \\field Vertex 49 Y-coordinate
       \\units m
       \\type real
  N148, \\field Vertex 49 Z-coordinate
       \\units m
       \\type real
  N149, \\field Vertex 50 X-coordinate
       \\units m
       \\type real
  N150, \\field Vertex 50 Y-coordinate
       \\units m
       \\type real
  N151, \\field Vertex 50 Z-coordinate
       \\units m
       \\type real
  N152, \\field Vertex 51 X-coordinate
       \\units m
       \\type real
  N153, \\field Vertex 51 Y-coordinate
       \\units m
       \\type real
  N154, \\field Vertex 51 Z-coordinate
       \\units m
       \\type real
  N155, \\field Vertex 52 X-coordinate
       \\units m
       \\type real
  N156, \\field Vertex 52 Y-coordinate
       \\units m
       \\type real
  N157, \\field Vertex 52 Z-coordinate
       \\units m
       \\type real
  N158, \\field Vertex 53 X-coordinate
       \\units m
       \\type real
  N159, \\field Vertex 53 Y-coordinate
       \\units m
       \\type real
  N160, \\field Vertex 53 Z-coordinate
       \\units m
       \\type real
  N161, \\field Vertex 54 X-coordinate
       \\units m
       \\type real
  N162, \\field Vertex 54 Y-coordinate
       \\units m
       \\type real
  N163, \\field Vertex 54 Z-coordinate
       \\units m
       \\type real
  N164, \\field Vertex 55 X-coordinate
       \\units m
       \\type real
  N165, \\field Vertex 55 Y-coordinate
       \\units m
       \\type real
  N166, \\field Vertex 55 Z-coordinate
       \\units m
       \\type real
  N167, \\field Vertex 56 X-coordinate
       \\units m
       \\type real
  N168, \\field Vertex 56 Y-coordinate
       \\units m
       \\type real
  N169, \\field Vertex 56 Z-coordinate
       \\units m
       \\type real
  N170, \\field Vertex 57 X-coordinate
       \\units m
       \\type real
  N171, \\field Vertex 57 Y-coordinate
       \\units m
       \\type real
  N172, \\field Vertex 57 Z-coordinate
       \\units m
       \\type real
  N173, \\field Vertex 58 X-coordinate
       \\units m
       \\type real
  N174, \\field Vertex 58 Y-coordinate
       \\units m
       \\type real
  N175, \\field Vertex 58 Z-coordinate
       \\units m
       \\type real
  N176, \\field Vertex 59 X-coordinate
       \\units m
       \\type real
  N177, \\field Vertex 59 Y-coordinate
       \\units m
       \\type real
  N178, \\field Vertex 59 Z-coordinate
       \\units m
       \\type real
  N179, \\field Vertex 60 X-coordinate
       \\units m
       \\type real
  N180, \\field Vertex 60 Y-coordinate
       \\units m
       \\type real
  N181, \\field Vertex 60 Z-coordinate
       \\units m
       \\type real
  N182, \\field Vertex 61 X-coordinate
       \\units m
       \\type real
  N183, \\field Vertex 61 Y-coordinate
       \\units m
       \\type real
  N184, \\field Vertex 61 Z-coordinate
       \\units m
       \\type real
  N185, \\field Vertex 62 X-coordinate
       \\units m
       \\type real
  N186, \\field Vertex 62 Y-coordinate
       \\units m
       \\type real
  N187, \\field Vertex 62 Z-coordinate
       \\units m
       \\type real
  N188, \\field Vertex 63 X-coordinate
       \\units m
       \\type real
  N189, \\field Vertex 63 Y-coordinate
       \\units m
       \\type real
  N190, \\field Vertex 63 Z-coordinate
       \\units m
       \\type real
  N191, \\field Vertex 64 X-coordinate
       \\units m
       \\type real
  N192, \\field Vertex 64 Y-coordinate
       \\units m
       \\type real
  N193, \\field Vertex 64 Z-coordinate
       \\units m
       \\type real
  N194, \\field Vertex 65 X-coordinate
       \\units m
       \\type real
  N195, \\field Vertex 65 Y-coordinate
       \\units m
       \\type real
  N196, \\field Vertex 65 Z-coordinate
       \\units m
       \\type real
  N197, \\field Vertex 66 X-coordinate
       \\units m
       \\type real
  N198, \\field Vertex 66 Y-coordinate
       \\units m
       \\type real
  N199, \\field Vertex 66 Z-coordinate
       \\units m
       \\type real
  N200, \\field Vertex 67 X-coordinate
       \\units m
       \\type real
  N201, \\field Vertex 67 Y-coordinate
       \\units m
       \\type real
  N202, \\field Vertex 67 Z-coordinate
       \\units m
       \\type real
  N203, \\field Vertex 68 X-coordinate
       \\units m
       \\type real
  N204, \\field Vertex 68 Y-coordinate
       \\units m
       \\type real
  N205, \\field Vertex 68 Z-coordinate
       \\units m
       \\type real
  N206, \\field Vertex 69 X-coordinate
       \\units m
       \\type real
  N207, \\field Vertex 69 Y-coordinate
       \\units m
       \\type real
  N208, \\field Vertex 69 Z-coordinate
       \\units m
       \\type real
  N209, \\field Vertex 70 X-coordinate
       \\units m
       \\type real
  N210, \\field Vertex 70 Y-coordinate
       \\units m
       \\type real
  N211, \\field Vertex 70 Z-coordinate
       \\units m
       \\type real
  N212, \\field Vertex 71 X-coordinate
       \\units m
       \\type real
  N213, \\field Vertex 71 Y-coordinate
       \\units m
       \\type real
  N214, \\field Vertex 71 Z-coordinate
       \\units m
       \\type real
  N215, \\field Vertex 72 X-coordinate
       \\units m
       \\type real
  N216, \\field Vertex 72 Y-coordinate
       \\units m
       \\type real
  N217, \\field Vertex 72 Z-coordinate
       \\units m
       \\type real
  N218, \\field Vertex 73 X-coordinate
       \\units m
       \\type real
  N219, \\field Vertex 73 Y-coordinate
       \\units m
       \\type real
  N220, \\field Vertex 73 Z-coordinate
       \\units m
       \\type real
  N221, \\field Vertex 74 X-coordinate
       \\units m
       \\type real
  N222, \\field Vertex 74 Y-coordinate
       \\units m
       \\type real
  N223, \\field Vertex 74 Z-coordinate
       \\units m
       \\type real
  N224, \\field Vertex 75 X-coordinate
       \\units m
       \\type real
  N225, \\field Vertex 75 Y-coordinate
       \\units m
       \\type real
  N226, \\field Vertex 75 Z-coordinate
       \\units m
       \\type real
  N227, \\field Vertex 76 X-coordinate
       \\units m
       \\type real
  N228, \\field Vertex 76 Y-coordinate
       \\units m
       \\type real
  N229, \\field Vertex 76 Z-coordinate
       \\units m
       \\type real
  N230, \\field Vertex 77 X-coordinate
       \\units m
       \\type real
  N231, \\field Vertex 77 Y-coordinate
       \\units m
       \\type real
  N232, \\field Vertex 77 Z-coordinate
       \\units m
       \\type real
  N233, \\field Vertex 78 X-coordinate
       \\units m
       \\type real
  N234, \\field Vertex 78 Y-coordinate
       \\units m
       \\type real
  N235, \\field Vertex 78 Z-coordinate
       \\units m
       \\type real
  N236, \\field Vertex 79 X-coordinate
       \\units m
       \\type real
  N237, \\field Vertex 79 Y-coordinate
       \\units m
       \\type real
  N238, \\field Vertex 79 Z-coordinate
       \\units m
       \\type real
  N239, \\field Vertex 80 X-coordinate
       \\units m
       \\type real
  N240, \\field Vertex 80 Y-coordinate
       \\units m
       \\type real
  N241, \\field Vertex 80 Z-coordinate
       \\units m
       \\type real
  N242, \\field Vertex 81 X-coordinate
       \\units m
       \\type real
  N243, \\field Vertex 81 Y-coordinate
       \\units m
       \\type real
  N244, \\field Vertex 81 Z-coordinate
       \\units m
       \\type real
  N245, \\field Vertex 82 X-coordinate
       \\units m
       \\type real
  N246, \\field Vertex 82 Y-coordinate
       \\units m
       \\type real
  N247, \\field Vertex 82 Z-coordinate
       \\units m
       \\type real
  N248, \\field Vertex 83 X-coordinate
       \\units m
       \\type real
  N249, \\field Vertex 83 Y-coordinate
       \\units m
       \\type real
  N250, \\field Vertex 83 Z-coordinate
       \\units m
       \\type real
  N251, \\field Vertex 84 X-coordinate
       \\units m
       \\type real
  N252, \\field Vertex 84 Y-coordinate
       \\units m
       \\type real
  N253, \\field Vertex 84 Z-coordinate
       \\units m
       \\type real
  N254, \\field Vertex 85 X-coordinate
       \\units m
       \\type real
  N255, \\field Vertex 85 Y-coordinate
       \\units m
       \\type real
  N256, \\field Vertex 85 Z-coordinate
       \\units m
       \\type real
  N257, \\field Vertex 86 X-coordinate
       \\units m
       \\type real
  N258, \\field Vertex 86 Y-coordinate
       \\units m
       \\type real
  N259, \\field Vertex 86 Z-coordinate
       \\units m
       \\type real
  N260, \\field Vertex 87 X-coordinate
       \\units m
       \\type real
  N261, \\field Vertex 87 Y-coordinate
       \\units m
       \\type real
  N262, \\field Vertex 87 Z-coordinate
       \\units m
       \\type real
  N263, \\field Vertex 88 X-coordinate
       \\units m
       \\type real
  N264, \\field Vertex 88 Y-coordinate
       \\units m
       \\type real
  N265, \\field Vertex 88 Z-coordinate
       \\units m
       \\type real
  N266, \\field Vertex 89 X-coordinate
       \\units m
       \\type real
  N267, \\field Vertex 89 Y-coordinate
       \\units m
       \\type real
  N268, \\field Vertex 89 Z-coordinate
       \\units m
       \\type real
  N269, \\field Vertex 90 X-coordinate
       \\units m
       \\type real
  N270, \\field Vertex 90 Y-coordinate
       \\units m
       \\type real
  N271, \\field Vertex 90 Z-coordinate
       \\units m
       \\type real
  N272, \\field Vertex 91 X-coordinate
       \\units m
       \\type real
  N273, \\field Vertex 91 Y-coordinate
       \\units m
       \\type real
  N274, \\field Vertex 91 Z-coordinate
       \\units m
       \\type real
  N275, \\field Vertex 92 X-coordinate
       \\units m
       \\type real
  N276, \\field Vertex 92 Y-coordinate
       \\units m
       \\type real
  N277, \\field Vertex 92 Z-coordinate
       \\units m
       \\type real
  N278, \\field Vertex 93 X-coordinate
       \\units m
       \\type real
  N279, \\field Vertex 93 Y-coordinate
       \\units m
       \\type real
  N280, \\field Vertex 93 Z-coordinate
       \\units m
       \\type real
  N281, \\field Vertex 94 X-coordinate
       \\units m
       \\type real
  N282, \\field Vertex 94 Y-coordinate
       \\units m
       \\type real
  N283, \\field Vertex 94 Z-coordinate
       \\units m
       \\type real
  N284, \\field Vertex 95 X-coordinate
       \\units m
       \\type real
  N285, \\field Vertex 95 Y-coordinate
       \\units m
       \\type real
  N286, \\field Vertex 95 Z-coordinate
       \\units m
       \\type real
  N287, \\field Vertex 96 X-coordinate
       \\units m
       \\type real
  N288, \\field Vertex 96 Y-coordinate
       \\units m
       \\type real
  N289, \\field Vertex 96 Z-coordinate
       \\units m
       \\type real
  N290, \\field Vertex 97 X-coordinate
       \\units m
       \\type real
  N291, \\field Vertex 97 Y-coordinate
       \\units m
       \\type real
  N292, \\field Vertex 97 Z-coordinate
       \\units m
       \\type real
  N293, \\field Vertex 98 X-coordinate
       \\units m
       \\type real
  N294, \\field Vertex 98 Y-coordinate
       \\units m
       \\type real
  N295, \\field Vertex 98 Z-coordinate
       \\units m
       \\type real
  N296, \\field Vertex 99 X-coordinate
       \\units m
       \\type real
  N297, \\field Vertex 99 Y-coordinate
       \\units m
       \\type real
  N298, \\field Vertex 99 Z-coordinate
       \\units m
       \\type real
  N299, \\field Vertex 100 X-coordinate
       \\units m
       \\type real
  N300, \\field Vertex 100 Y-coordinate
       \\units m
       \\type real
  N301, \\field Vertex 100 Z-coordinate
       \\units m
       \\type real
  N302, \\field Vertex 101 X-coordinate
       \\units m
       \\type real
  N303, \\field Vertex 101 Y-coordinate
       \\units m
       \\type real
  N304, \\field Vertex 101 Z-coordinate
       \\units m
       \\type real
  N305, \\field Vertex 102 X-coordinate
       \\units m
       \\type real
  N306, \\field Vertex 102 Y-coordinate
       \\units m
       \\type real
  N307, \\field Vertex 102 Z-coordinate
       \\units m
       \\type real
  N308, \\field Vertex 103 X-coordinate
       \\units m
       \\type real
  N309, \\field Vertex 103 Y-coordinate
       \\units m
       \\type real
  N310, \\field Vertex 103 Z-coordinate
       \\units m
       \\type real
  N311, \\field Vertex 104 X-coordinate
       \\units m
       \\type real
  N312, \\field Vertex 104 Y-coordinate
       \\units m
       \\type real
  N313, \\field Vertex 104 Z-coordinate
       \\units m
       \\type real
  N314, \\field Vertex 105 X-coordinate
       \\units m
       \\type real
  N315, \\field Vertex 105 Y-coordinate
       \\units m
       \\type real
  N316, \\field Vertex 105 Z-coordinate
       \\units m
       \\type real
  N317, \\field Vertex 106 X-coordinate
       \\units m
       \\type real
  N318, \\field Vertex 106 Y-coordinate
       \\units m
       \\type real
  N319, \\field Vertex 106 Z-coordinate
       \\units m
       \\type real
  N320, \\field Vertex 107 X-coordinate
       \\units m
       \\type real
  N321, \\field Vertex 107 Y-coordinate
       \\units m
       \\type real
  N322, \\field Vertex 107 Z-coordinate
       \\units m
       \\type real
  N323, \\field Vertex 108 X-coordinate
       \\units m
       \\type real
  N324, \\field Vertex 108 Y-coordinate
       \\units m
       \\type real
  N325, \\field Vertex 108 Z-coordinate
       \\units m
       \\type real
  N326, \\field Vertex 109 X-coordinate
       \\units m
       \\type real
  N327, \\field Vertex 109 Y-coordinate
       \\units m
       \\type real
  N328, \\field Vertex 109 Z-coordinate
       \\units m
       \\type real
  N329, \\field Vertex 110 X-coordinate
       \\units m
       \\type real
  N330, \\field Vertex 110 Y-coordinate
       \\units m
       \\type real
  N331, \\field Vertex 110 Z-coordinate
       \\units m
       \\type real
  N332, \\field Vertex 111 X-coordinate
       \\units m
       \\type real
  N333, \\field Vertex 111 Y-coordinate
       \\units m
       \\type real
  N334, \\field Vertex 111 Z-coordinate
       \\units m
       \\type real
  N335, \\field Vertex 112 X-coordinate
       \\units m
       \\type real
  N336, \\field Vertex 112 Y-coordinate
       \\units m
       \\type real
  N337, \\field Vertex 112 Z-coordinate
       \\units m
       \\type real
  N338, \\field Vertex 113 X-coordinate
       \\units m
       \\type real
  N339, \\field Vertex 113 Y-coordinate
       \\units m
       \\type real
  N340, \\field Vertex 113 Z-coordinate
       \\units m
       \\type real
  N341, \\field Vertex 114 X-coordinate
       \\units m
       \\type real
  N342, \\field Vertex 114 Y-coordinate
       \\units m
       \\type real
  N343, \\field Vertex 114 Z-coordinate
       \\units m
       \\type real
  N344, \\field Vertex 115 X-coordinate
       \\units m
       \\type real
  N345, \\field Vertex 115 Y-coordinate
       \\units m
       \\type real
  N346, \\field Vertex 115 Z-coordinate
       \\units m
       \\type real
  N347, \\field Vertex 116 X-coordinate
       \\units m
       \\type real
  N348, \\field Vertex 116 Y-coordinate
       \\units m
       \\type real
  N349, \\field Vertex 116 Z-coordinate
       \\units m
       \\type real
  N350, \\field Vertex 117 X-coordinate
       \\units m
       \\type real
  N351, \\field Vertex 117 Y-coordinate
       \\units m
       \\type real
  N352, \\field Vertex 117 Z-coordinate
       \\units m
       \\type real
  N353, \\field Vertex 118 X-coordinate
       \\units m
       \\type real
  N354, \\field Vertex 118 Y-coordinate
       \\units m
       \\type real
  N355, \\field Vertex 118 Z-coordinate
       \\units m
       \\type real
  N356, \\field Vertex 119 X-coordinate
       \\units m
       \\type real
  N357, \\field Vertex 119 Y-coordinate
       \\units m
       \\type real
  N358, \\field Vertex 119 Z-coordinate
       \\units m
       \\type real
  N359, \\field Vertex 120 X-coordinate
       \\units m
       \\type real
  N360, \\field Vertex 120 Y-coordinate
       \\units m
       \\type real
  N361; \\field Vertex 120 Z-coordinate
       \\units m
       \\type real

ShadingProperty:Reflectance,
       \\min-fields 3
       \\memo If this object is not defined for a shading surface the default values
       \\memo listed in following fields will be used in the solar reflection calculation.
  A1,  \\field Shading Surface Name
       \\required-field
       \\type object-list
       \\object-list AllShadingSurfNames
  N1,  \\field Diffuse Solar Reflectance of Unglazed Part of Shading Surface
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.2
  N2,  \\field Diffuse Visible Reflectance of Unglazed Part of Shading Surface
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.2
  N3,  \\field Fraction of Shading Surface That Is Glazed
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  A2;  \\field Glazing Construction Name
       \\note Required if Fraction of Shading Surface That Is Glazed > 0.0

\\group Advanced Construction, Surface, Zone Concepts

SurfaceProperty:HeatTransferAlgorithm,
       \\memo Determines which Heat Balance Algorithm will be used for a specific surface
       \\memo Allows selectively overriding the global setting in HeatBalanceAlgorithm
       \\memo CTF (Conduction Transfer Functions),
       \\memo EMPD (Effective Moisture Penetration Depth with Conduction Transfer Functions).
       \\memo Advanced/Research Usage: CondFD (Conduction Finite Difference)
       \\memo Advanced/Research Usage: HAMT (Combined Heat And Moisture Finite Element)
       \\min-fields 2
  A1 , \\field Surface Name
       \\required-field
       \\type object-list
       \\object-list SurfaceNames
  A2 ; \\field Algorithm
       \\required-field
       \\type choice
       \\key ConductionTransferFunction
       \\key MoisturePenetrationDepthConductionTransferFunction
       \\key ConductionFiniteDifference
       \\key CombinedHeatAndMoistureFiniteElement
       \\default ConductionTransferFunction

SurfaceProperty:HeatTransferAlgorithm:MultipleSurface,
       \\memo Determines which Heat Balance Algorithm will be used for a group of surface types
       \\memo Allows selectively overriding the global setting in HeatBalanceAlgorithm
       \\memo CTF (Conduction Transfer Functions),
       \\memo EMPD (Effective Moisture Penetration Depth with Conduction Transfer Functions).
       \\memo Advanced/Research Usage: CondFD (Conduction Finite Difference)
       \\memo Advanced/Research Usage: HAMT (Combined Heat And Moisture Finite Element)
       \\min-fields 3
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Surface Type
       \\required-field
       \\type choice
       \\key AllExteriorSurfaces
       \\key AllExteriorWalls
       \\key AllExteriorRoofs
       \\key AllExteriorFloors
       \\key AllGroundContactSurfaces
       \\key AllInteriorSurfaces
       \\key AllInteriorWalls
       \\key AllInteriorCeilings
       \\key AllInteriorFloors
  A3 ; \\field Algorithm
       \\required-field
       \\type choice
       \\key ConductionTransferFunction
       \\key MoisturePenetrationDepthConductionTransferFunction
       \\key ConductionFiniteDifference
       \\key CombinedHeatAndMoistureFiniteElement
       \\default ConductionTransferFunction

SurfaceProperty:HeatTransferAlgorithm:SurfaceList,
       \\min-fields 3
       \\extensible:1
       \\memo Determines which Heat Balance Algorithm will be used for a list of surfaces
       \\memo Allows selectively overriding the global setting in HeatBalanceAlgorithm
       \\memo CTF (Conduction Transfer Functions),
       \\memo EMPD (Effective Moisture Penetration Depth with Conduction Transfer Functions).
       \\memo Advanced/Research Usage: CondFD (Conduction Finite Difference)
       \\memo Advanced/Research Usage: HAMT (Combined Heat And Moisture Finite Element)
       \\min-fields 3
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Algorithm
       \\required-field
       \\type choice
       \\key ConductionTransferFunction
       \\key MoisturePenetrationDepthConductionTransferFunction
       \\key ConductionFiniteDifference
       \\key CombinedHeatAndMoistureFiniteElement
       \\default ConductionTransferFunction
  A3 , \\field Surface Name 1
       \\begin-extensible
       \\required-field
       \\type object-list
       \\object-list SurfaceNames
  A4 , \\field Surface Name 2
       \\type object-list
       \\object-list SurfaceNames
  A5 , \\field Surface Name 3
       \\type object-list
       \\object-list SurfaceNames
  A6 , \\field Surface Name 4
       \\type object-list
       \\object-list SurfaceNames
  A7 , \\field Surface Name 5
       \\type object-list
       \\object-list SurfaceNames
  A8 ; \\field Surface Name 6
       \\type object-list
       \\object-list SurfaceNames

SurfaceProperty:HeatTransferAlgorithm:Construction,
       \\memo Determines which Heat Balance Algorithm will be used for surfaces that have a specific type of construction
       \\memo Allows selectively overriding the global setting in HeatBalanceAlgorithm
       \\memo CTF (Conduction Transfer Functions),
       \\memo EMPD (Effective Moisture Penetration Depth with Conduction Transfer Functions).
       \\memo Advanced/Research Usage: CondFD (Conduction Finite Difference)
       \\memo Advanced/Research Usage: HAMT (Combined Heat And Moisture Finite Element)
       \\min-fields 3
  A1 , \\field Name
       \\type alpha
  A2 , \\field Algorithm
       \\required-field
       \\type choice
       \\key ConductionTransferFunction
       \\key MoisturePenetrationDepthConductionTransferFunction
       \\key ConductionFiniteDifference
       \\key CombinedHeatAndMoistureFiniteElement
       \\default ConductionTransferFunction
  A3 ; \\field Construction Name
       \\required-field
       \\type object-list
       \\object-list ConstructionNames

SurfaceControl:MovableInsulation,
      \\memo Exterior or Interior Insulation on opaque surfaces
  A1, \\field Insulation Type
      \\required-field
      \\type choice
      \\key Outside
      \\key Inside
  A2, \\field Surface Name
      \\required-field
      \\type object-list
      \\object-list SurfaceNames
  A3, \\field Material Name
      \\required-field
      \\object-list MaterialName
  A4; \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames

SurfaceProperty:OtherSideCoefficients,
      \\memo This object sets the other side conditions for a surface in a variety of ways.
      \\min-fields 8
  A1, \\field Name
      \\required-field
      \\reference OSCNames
      \\reference OutFaceEnvNames
  N1, \\field Combined Convective/Radiative Film Coefficient
      \\units W/m2-K
      \\required-field
      \\type real
      \\note if>0, this field becomes the exterior convective/radiative film coefficient
      \\note and the other fields are used to calculate the outdoor air temperature
      \\note then exterior surface temperature based on outdoor air and specified coefficient
      \\note if<=0, then remaining fields calculate the outside surface temperature
      \\note The following fields are used in the equation:
      \\note OtherSideTemp=N2*N3 + N4*OutdoorDry-bulb + N5*GroundTemp + N6*WindSpeed*OutdoorDry-bulb + N7*TempZone + N9*TempPrev
  N2, \\field Constant Temperature
      \\units C
      \\type real
      \\default 0
      \\note This parameter will be overwritten by the values from the Constant Temperature Schedule Name (below) if one is present
  N3, \\field Constant Temperature Coefficient
      \\note This coefficient is used even with a Schedule.  It should normally be 1.0 in that case.
      \\note This field is ignored if Sinusoidal Variation of Constant Temperature Coefficient = Yes.
      \\default 1
  N4, \\field External Dry-Bulb Temperature Coefficient
      \\type real
      \\default 0
  N5, \\field Ground Temperature Coefficient
      \\type real
      \\default 0
  N6, \\field Wind Speed Coefficient
      \\type real
      \\default 0
  N7, \\field Zone Air Temperature Coefficient
      \\type real
      \\default 0
  A2, \\field Constant Temperature Schedule Name
      \\note Name of schedule for values of constant temperature.
      \\note Schedule values replace any value specified in the field Constant Temperature.
      \\type object-list
      \\object-list ScheduleNames
  A3, \\field Sinusoidal Variation of Constant Temperature Coefficient
      \\note Optionally used to vary Constant Temperature Coefficient with unitary sine wave
      \\type choice
      \\key Yes
      \\key No
      \\default No
  N8, \\field Period of Sinusoidal Variation
      \\note Use with sinusoidal variation to define the time period
      \\type real
      \\units hr
      \\default 24
      \\minimum> 0
  N9, \\field Previous Other Side Temperature Coefficient
      \\note This coefficient multiplies the other side temperature result from the
      \\note previous zone timestep
      \\type real
      \\default 0
 N10, \\field Minimum Other Side Temperature Limit
      \\note This field specifies a lower limit for the other side temperature result.
      \\note Blank indicates no limit
      \\type real
      \\units C
 N11; \\field Maximum Other Side Temperature Limit
      \\note This field specifies an upper limit for the other side temperature result.
      \\note Blank indicates no limit
      \\type real
      \\units C


SurfaceProperty:OtherSideConditionsModel,
      \\memo This object sets up modifying the other side conditions for a surface from other model results.
  A1, \\field Name
      \\required-field
      \\reference OSCMNames
      \\reference OutFaceEnvNames
  A2; \\field Type of Modeling
      \\type choice
      \\key GapConvectionRadiation
      \\key UndergroundPipingSystemSurface
      \\note GapConvectionRadiation provides boundary conditions for convection
      \\note  and linearized thermal radiation across a gap or cavity
      \\note  on the other side of the surface that are modeled sperately.
      \\note UndergroundPipingSystemSurface provides boundary conditions for
      \\note  surfaces in contact with PipingSystem:Underground domains
      \\default GapConvectionRadiation


SurfaceConvectionAlgorithm:Inside:AdaptiveModelSelections,
       \\unique-object
       \\memo Options to change the individual convection model equations for dynamic selection when using AdaptiveConvectiongAlgorithm
       \\memo This object is only needed to make changes to the default model selections for any or all of the surface categories.
       \\memo This object is for the inside face, the side of the surface facing a thermal zone.
  A1 , \\field Name
       \\type alpha
  A2 , \\field Simple Bouyancy Vertical Wall Equation Source
       \\note Applies to zone with no HVAC or when HVAC is off
       \\note This is for vertical walls
       \\type choice
       \\default FohannoPolidoriVerticalWall
       \\key ASHRAEVerticalWall
       \\key AlamdariHammondVerticalWall
       \\key KhalifaEq3WallAwayFromHeat
       \\key KhalifaEq6NonHeatedWalls
       \\key FohannoPolidoriVerticalWall
       \\key ISO15099Windows
       \\key UserCurve
  A3 , \\field Simple Bouyancy Vertical Wall User Curve Name
       \\note The SurfaceConvectionAlgorithm:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A4 , \\field Simple Bouyancy Stable Horizontal Equation Source
       \\note Applies to zone with no HVAC or when HVAC is off
       \\note This is for horizontal surfaces with heat flow directed for stable thermal stratification
       \\type choice
       \\default AlamdariHammondStableHorizontal
       \\key WaltonStableHorizontalOrTilt
       \\key AlamdariHammondStableHorizontal
       \\key UserCurve
  A5 , \\field Simple Bouyancy Stable Horizontal Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A6 , \\field Simple Bouyancy Unstable Horizontal Equation Source
       \\note Applies to zone with no HVAC or when HVAC is off
        \\note This is for passive horizontal surfaces with heat flow for unstable thermal stratification
       \\type choice
       \\default AlamdariHammondUnstableHorizontal
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key UserCurve
  A7 , \\field Simple Bouyancy Unstable Horizontal Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A8 , \\field Simple Bouyancy Stable Tilted Equation Source
       \\note Applies to zone with no HVAC or when HVAC is off
       \\note This is for tilted surfaces with heat flow for stable thermal stratification
       \\type choice
       \\default WaltonStableHorizontalOrTilt
       \\key WaltonStableHorizontalOrTilt
       \\key AlamdariHammondStableHorizontal
       \\key UserCurve
  A9 , \\field Simple Bouyancy Stable Tilted Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A10 , \\field Simple Bouyancy Unstable Tilted Equation Source
       \\note Applies to zone with no HVAC or when HVAC is off
       \\note This is for tilted surfaces with heat flow for unstable thermal stratification
       \\type choice
       \\default WaltonUnstableHorizontalOrTilt
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key UserCurve
  A11, \\field Simple Bouyancy Unstable Tilted Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A12, \\field Simple Bouyancy Windows Equation Source
       \\note Applies to zone with no HVAC or when HVAC is off
       \\note This is for all window surfaces
       \\type choice
       \\default ISO15099Windows
       \\key ASHRAEVerticalWall
       \\key AlamdariHammondVerticalWall
       \\key FohannoPolidoriVerticalWall
       \\key KaradagChilledCeiling
       \\key ISO15099Windows
       \\key UserCurve
  A13, \\field Simple Bouyancy Windows Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A14, \\field Floor Heat Ceiling Cool Vertical Wall Equation Source
       \\note Applies to zone with in-floor heating and/or in-ceiling cooling
       \\note This is for vertical walls
       \\type choice
       \\default KhalifaEq3WallAwayFromHeat
       \\key ASHRAEVerticalWall
       \\key AlamdariHammondVerticalWall
       \\key KhalifaEq3WallAwayFromHeat
       \\key FohannoPolidoriVerticalWall
       \\key ISO15099Windows
       \\key UserCurve
  A15, \\field Floor Heat Ceiling Cool Vertical Wall Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A16, \\field Floor Heat Ceiling Cool Stable Horizontal Equation Source
       \\note Applies to zone with in-floor heating and/or in-ceiling cooling
       \\note This is for passive horizontal surfaces with heat flow for stable thermal stratification
       \\type choice
       \\default AlamdariHammondStableHorizontal
       \\key WaltonStableHorizontalOrTilt
       \\key AlamdariHammondStableHorizontal
       \\key UserCurve
  A17, \\field Floor Heat Ceiling Cool Stable Horizontal Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A18, \\field Floor Heat Ceiling Cool Unstable Horizontal Equation Source
       \\note Applies to zone with in-floor heating and/or in-ceiling cooling
       \\note This is for passive horizontal surfaces with heat flow for unstable thermal stratification
       \\type choice
       \\default KhalifaEq4CeilingAwayFromHeat
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key KhalifaEq4CeilingAwayFromHeat
       \\key UserCurve
  A19, \\field Floor Heat Ceiling Cool Unstable Horizontal Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A20, \\field Floor Heat Ceiling Cool Heated Floor Equation Source
       \\note Applies to zone with in-floor heating and/or in-ceiling cooling
       \\note This is for a floor with active heating elements
       \\type choice
       \\default AwbiHattonHeatedFloor
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key AwbiHattonHeatedFloor
       \\key UserCurve
  A21, \\field Floor Heat Ceiling Cool Heated Floor Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A22, \\field Floor Heat Ceiling Cool Chilled Ceiling Equation Source
       \\note Applies to zone with in-floor heating and/or in-ceiling cooling
       \\note This is for a ceiling with active cooling elements
       \\type choice
       \\default KaradagChilledCeiling
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key KaradagChilledCeiling
       \\key UserCurve
  A23, \\field Floor Heat Ceiling Cool Chilled Ceiling Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A24, \\field Floor Heat Ceiling Cool Stable Tilted Equation Source
       \\note Applies to zone with in-floor heating and/or in-ceiling cooling
       \\note This is for tilted surfaces with heat flow for stable thermal stratification
       \\type choice
       \\default WaltonStableHorizontalOrTilt
       \\key WaltonStableHorizontalOrTilt
       \\key AlamdariHammondStableHorizontal
       \\key ISO15099Windows
       \\key UserCurve
  A25, \\field Floor Heat Ceiling Cool Stable Tilted Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A26, \\field Floor Heat Ceiling Cool Unstable Tilted Equation Source
       \\note Applies to zone with in-floor heating and/or in-ceiling cooling
       \\note This is for tilted surfaces with heat flow for unstable thermal stratification
       \\type choice
       \\default WaltonUnstableHorizontalOrTilt
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key ISO15099Windows
       \\key UserCurve
  A27, \\field Floor Heat Ceiling Cool Unstable Tilted Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A28, \\field Floor Heat Ceiling Cool Window Equation Source
       \\note Applies to zone with in-floor heating and/or in-ceiling cooling
       \\note This is for all window surfaces
       \\type choice
       \\default ISO15099Windows
       \\key ASHRAEVerticalWall
       \\key AlamdariHammondVerticalWall
       \\key ISO15099Windows
       \\key UserCurve
  A29, \\field Floor Heat Ceiling Cool Window Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A30, \\field Wall Panel Heating Vertical Wall Equation Source
       \\note Applies to zone with in-wall panel heating
       \\note This is for vertical walls that are not actively heated
       \\type choice
       \\default KhalifaEq6NonHeatedWalls
       \\key ASHRAEVerticalWall
       \\key AlamdariHammondVerticalWall
       \\key KhalifaEq6NonHeatedWalls
       \\key FohannoPolidoriVerticalWall
       \\key ISO15099Windows
       \\key UserCurve
  A31, \\field Wall Panel Heating Vertical Wall Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A32, \\field Wall Panel Heating Heated Wall Equation Source
       \\note Applies to zone with in-wall panel heating
       \\note This is for vertical walls that are being actively heated
       \\type choice
       \\default AwbiHattonHeatedWall
       \\key ASHRAEVerticalWall
       \\key AlamdariHammondVerticalWall
       \\key KhalifaEq5WallNearHeat
       \\key AwbiHattonHeatedWall
       \\key FohannoPolidoriVerticalWall
       \\key ISO15099Windows
       \\key UserCurve
  A33, \\field Wall Panel Heating Heated Wall Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A34, \\field Wall Panel Heating Stable Horizontal Equation Source
       \\note Applies to zone with in-wall panel heating
       \\note This is for horizontal surfaces with heat flow directed for stable thermal stratification
       \\type choice
       \\default AlamdariHammondStableHorizontal
       \\key WaltonStableHorizontalOrTilt
       \\key AlamdariHammondStableHorizontal
       \\key UserCurve
  A35, \\field Wall Panel Heating Stable Horizontal Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A36, \\field Wall Panel Heating Unstable Horizontal Equation Source
       \\note Applies to zone with in-wall panel heating
       \\note This is for horizontal surfaces with heat flow directed for unstable thermal stratification
       \\type choice
       \\default KhalifaEq7Ceiling
       \\key ASHRAEVerticalWall
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key KhalifaEq7Ceiling
       \\key KaradagChilledCeiling
       \\key UserCurve
  A37, \\field Wall Panel Heating Unstable Horizontal Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A38, \\field Wall Panel Heating Stable Tilted Equation Source
       \\note Applies to zone with in-wall panel heating
       \\note This is for tilted surfaces with heat flow for stable thermal stratification
       \\type choice
       \\default WaltonStableHorizontalOrTilt
       \\key WaltonStableHorizontalOrTilt
       \\key AlamdariHammondStableHorizontal
       \\key ISO15099Windows
       \\key UserCurve
  A39, \\field Wall Panel Heating Stable Tilted Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A40, \\field Wall Panel Heating Unstable Tilted Equation Source
       \\note Applies to zone with in-wall panel heating
       \\note This is for tilted surfaces with heat flow for unstable thermal stratification
       \\type choice
       \\default WaltonUnstableHorizontalOrTilt
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key ISO15099Windows
       \\key UserCurve
  A41, \\field Wall Panel Heating Unstable Tilted Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A42, \\field Wall Panel Heating Window Equation Source
       \\note Applies to zone with in-wall panel heating
       \\note This is for all window surfaces
       \\type choice
       \\default ISO15099Windows
       \\key ASHRAEVerticalWall
       \\key AlamdariHammondVerticalWall
       \\key FohannoPolidoriVerticalWall
       \\key ISO15099Windows
       \\key UserCurve
  A43, \\field Wall Panel Heating Window Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A44, \\field Convective Zone Heater Vertical Wall Equation Source
       \\note Applies to zone with convective heater
       \\note This is for vertical walls not directly affected by heater
       \\type choice
       \\default FohannoPolidoriVerticalWall
       \\key ASHRAEVerticalWall
       \\key AlamdariHammondVerticalWall
       \\key KhalifaEq3WallAwayFromHeat
       \\key KhalifaEq6NonHeatedWalls
       \\key FohannoPolidoriVerticalWall
       \\key ISO15099Windows
       \\key UserCurve
  A45, \\field Convective Zone Heater Vertical Wall Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A46, \\field Convective Zone Heater Vertical Walls Near Heater Equation Source
       \\note Applies to zone with convective heater
       \\note This is for vertical walls that are directly affected by heater
       \\note Walls are considered "near" when listed in field set for Fraction of Radiant Energy to Surface
       \\type choice
       \\default KhalifaEq5WallNearHeat
       \\key ASHRAEVerticalWall
       \\key AlamdariHammondVerticalWall
       \\key KhalifaEq5WallNearHeat
       \\key AwbiHattonHeatedWall
       \\key FohannoPolidoriVerticalWall
       \\key ISO15099Windows
       \\key UserCurve
  A47, \\field Convective Zone Heater Vertical Walls Near Heater Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A48, \\field Convective Zone Heater Stable Horizontal Equation Source
       \\note Applies to zone with convective heater
       \\note This is for horizontal surfaces with heat flow directed for stable thermal stratification
       \\type choice
       \\default AlamdariHammondStableHorizontal
       \\key WaltonStableHorizontalOrTilt
       \\key AlamdariHammondStableHorizontal
       \\key UserCurve
  A49, \\field Convective Zone Heater Stable Horizontal Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A50, \\field Convective Zone Heater Unstable Horizontal Equation Source
       \\note Applies to zone with convective heater
       \\note This is for horizontal surfaces with heat flow directed for unstable thermal stratification
       \\type choice
       \\default KhalifaEq7Ceiling
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key KhalifaEq4CeilingAwayFromHeat
       \\key KhalifaEq7Ceiling
       \\key UserCurve
  A51, \\field Convective Zone Heater Unstable Horizontal Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A52, \\field Convective Zone Heater Stable Tilted Equation Source
       \\note Applies to zone with convective heater
       \\note This is for tilted surfaces with heat flow for stable thermal stratification
       \\type choice
       \\default WaltonStableHorizontalOrTilt
       \\key WaltonStableHorizontalOrTilt
       \\key AlamdariHammondStableHorizontal
       \\key UserCurve
  A53, \\field Convective Zone Heater Stable Tilted Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A54, \\field Convective Zone Heater Unstable Tilted Equation Source
       \\note Applies to zone with convective heater
       \\note This is for tilted surfaces with heat flow for unstable thermal stratification
       \\type choice
       \\default WaltonUnstableHorizontalOrTilt
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key UserCurve
  A55, \\field Convective Zone Heater Unstable Tilted Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A56, \\field Convective Zone Heater Windows Equation Source
       \\note Applies to zone with convective heater
       \\note This is for all window surfaces
       \\type choice
       \\default ISO15099Windows
       \\key ASHRAEVerticalWall
       \\key AlamdariHammondVerticalWall
       \\key KhalifaEq3WallAwayFromHeat
       \\key FohannoPolidoriVerticalWall
       \\key ISO15099Windows
       \\key UserCurve
  A57, \\field Convective Zone Heater Windows Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A58, \\field Central Air Diffuser Wall Equation Source
       \\note Applies to zone with mechanical forced central air with diffusers
       \\note This is for all wall surfaces
       \\type choice
       \\default GoldsteinNovoselacCeilingDiffuserWalls
       \\key ASHRAEVerticalWall
       \\key FisherPedersenCeilingDiffuserWalls
       \\key AlamdariHammondVerticalWall
       \\key BeausoleilMorrisonMixedAssistedWall
       \\key BeausoleilMorrisonMixedOpposingWall
       \\key FohannoPolidoriVerticalWall
       \\key ISO15099Windows
       \\key GoldsteinNovoselacCeilingDiffuserWalls
       \\key UserCurve
  A59, \\field Central Air Diffuser Wall Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A60, \\field Central Air Diffuser Ceiling Equation Source
       \\note Applies to zone with mechanical forced central air with diffusers
       \\note This is for all ceiling surfaces
       \\type choice
       \\default FisherPedersenCeilingDiffuserCeiling
       \\key FisherPedersenCeilingDiffuserCeiling
       \\key BeausoleilMorrisonMixedStableCeiling
       \\key BeausoleilMorrisonMixedUnstableCeiling
       \\key UserCurve
  A61, \\field Central Air Diffuser Ceiling Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A62, \\field Central Air Diffuser Floor Equation Source
       \\note Applies to zone with mechanical forced central air with diffusers
       \\note This is for all floor surfaces
       \\type choice
       \\default GoldsteinNovoselacCeilingDiffuserFloor
       \\key FisherPedersenCeilingDiffuserFloor
       \\key BeausoleilMorrisonMixedStableFloor
       \\key BeausoleilMorrisonMixedUnstableFloor
       \\key GoldsteinNovoselacCeilingDiffuserFloor
       \\key UserCurve
  A63, \\field Central Air Diffuser Floor Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A64, \\field Central Air Diffuser Window Equation Source
       \\note Applies to zone with mechanical forced central air with diffusers
       \\note This is for all window surfaces
       \\type choice
       \\default GoldsteinNovoselacCeilingDiffuserWindow
       \\key ASHRAEVerticalWall
       \\key FisherPedersenCeilingDiffuserWalls
       \\key BeausoleilMorrisonMixedAssistedWall
       \\key BeausoleilMorrisonMixedOpposingWall
       \\key FohannoPolidoriVerticalWall
       \\key AlamdariHammondVerticalWall
       \\key ISO15099Windows
       \\key GoldsteinNovoselacCeilingDiffuserWindow
       \\key UserCurve
  A65, \\field Central Air Diffuser Window Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A66, \\field Mechanical Zone Fan Circulation Vertical Wall Equation Source
       \\note reference choice fields
       \\type choice
       \\default KhalifaEq3WallAwayFromHeat
       \\key KhalifaEq3WallAwayFromHeat
       \\key ASHRAEVerticalWall
       \\key FisherPedersenCeilingDiffuserWalls
       \\key AlamdariHammondVerticalWall
       \\key BeausoleilMorrisonMixedAssistedWall
       \\key BeausoleilMorrisonMixedOpposingWall
       \\key FohannoPolidoriVerticalWall
       \\key ISO15099Windows
       \\key GoldsteinNovoselacCeilingDiffuserWalls
       \\key UserCurve
  A67, \\field Mechanical Zone Fan Circulation Vertical Wall Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A68, \\field Mechanical Zone Fan Circulation Stable Horizontal Equation Source
       \\note reference choice fields
       \\type choice
       \\default AlamdariHammondStableHorizontal
       \\key WaltonStableHorizontalOrTilt
       \\key AlamdariHammondStableHorizontal
       \\key UserCurve
  A69, \\field Mechanical Zone Fan Circulation Stable Horizontal Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A70, \\field Mechanical Zone Fan Circulation Unstable Horizontal Equation Source
       \\note reference choice fields
       \\type choice
       \\default KhalifaEq4CeilingAwayFromHeat
       \\key KhalifaEq4CeilingAwayFromHeat
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key UserCurve
  A71, \\field Mechanical Zone Fan Circulation Unstable Horizontal Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A72, \\field Mechanical Zone Fan Circulation Stable Tilted Equation Source
       \\note reference choice fields
       \\type choice
       \\default WaltonStableHorizontalOrTilt
       \\key WaltonStableHorizontalOrTilt
       \\key UserCurve
  A73, \\field Mechanical Zone Fan Circulation Stable Tilted Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A74, \\field Mechanical Zone Fan Circulation Unstable Tilted Equation Source
       \\note reference choice fields
       \\type choice
       \\default WaltonUnstableHorizontalOrTilt
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key UserCurve
  A75, \\field Mechanical Zone Fan Circulation Unstable Tilted Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A76, \\field Mechanical Zone Fan Circulation Window Equation Source
       \\note reference choice fields
       \\type choice
       \\default ISO15099Windows
       \\key ASHRAEVerticalWall
       \\key AlamdariHammondVerticalWall
       \\key FohannoPolidoriVerticalWall
       \\key ISO15099Windows
       \\key GoldsteinNovoselacCeilingDiffuserWindow
       \\key UserCurve
  A77, \\field Mechanical Zone Fan Circulation Window Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A78, \\field Mixed Regime Bouyancy Assisting Flow on Walls Equation Source
       \\note reference choice fields
       \\type choice
       \\default BeausoleilMorrisonMixedAssistedWall
       \\key BeausoleilMorrisonMixedAssistedWall
       \\key AlamdariHammondVerticalWall
       \\key FohannoPolidoriVerticalWall
       \\key ASHRAEVerticalWall
       \\key FisherPedersenCeilingDiffuserWalls
       \\key GoldsteinNovoselacCeilingDiffuserWalls
       \\key UserCurve
  A79, \\field Mixed Regime Bouyancy Assisting Flow on Walls Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A80, \\field Mixed Regime Bouyancy Oppossing Flow on Walls Equation Source
       \\note reference choice fields
       \\type choice
       \\default BeausoleilMorrisonMixedOpposingWall
       \\key BeausoleilMorrisonMixedOpposingWall
       \\key AlamdariHammondVerticalWall
       \\key FohannoPolidoriVerticalWall
       \\key ASHRAEVerticalWall
       \\key FisherPedersenCeilingDiffuserWalls
       \\key GoldsteinNovoselacCeilingDiffuserWalls
       \\key UserCurve
  A81, \\field Mixed Regime Bouyancy Oppossing Flow on Walls Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A82, \\field Mixed Regime Stable Floor Equation Source
       \\note reference choice fields
       \\type choice
       \\default BeausoleilMorrisonMixedStableFloor
       \\key BeausoleilMorrisonMixedStableFloor
       \\key WaltonStableHorizontalOrTilt
       \\key AlamdariHammondStableHorizontal
       \\key UserCurve
  A83, \\field Mixed Regime Stable Floor Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A84, \\field Mixed Regime Unstable Floor Equation Source
       \\note reference choice fields
       \\type choice
       \\default BeausoleilMorrisonMixedUnstableFloor
       \\key BeausoleilMorrisonMixedUnstableFloor
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key UserCurve
  A85, \\field Mixed Regime Unstable Floor Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A86, \\field Mixed Regime Stable Ceiling Equation Source
       \\note reference choice fields
       \\type choice
       \\default BeausoleilMorrisonMixedStableCeiling
       \\key BeausoleilMorrisonMixedStableCeiling
       \\key WaltonStableHorizontalOrTilt
       \\key AlamdariHammondStableHorizontal
       \\key UserCurve
  A87, \\field Mixed Regime Stable Ceiling Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A88, \\field Mixed Regime Unstable Ceiling Equation Source
       \\note reference choice fields
       \\type choice
       \\default BeausoleilMorrisonMixedUnstableCeiling
       \\key BeausoleilMorrisonMixedUnstableCeiling
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key UserCurve
  A89, \\field Mixed Regime Unstable Ceiling Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A90, \\field Mixed Regime Window Equation Source
       \\note reference choice fields
       \\type choice
       \\default GoldsteinNovoselacCeilingDiffuserWindow
       \\key GoldsteinNovoselacCeilingDiffuserWindow
       \\key ISO15099Windows
       \\key UserCurve
  A91; \\field Mixed Regime Window Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels

SurfaceConvectionAlgorithm:Outside:AdaptiveModelSelections,
       \\unique-object
       \\memo Options to change the individual convection model equations for dynamic selection when using AdaptiveConvectiongAlgorithm
       \\memo This object is only needed to make changes to the default model selections for any or all of the surface categories.
       \\memo This object is for the outside face, the side of the surface facing away from the thermal zone.
  A1 , \\field Name
       \\type alpha
  A2 , \\field Wind Convection Windward Vertical Wall Equation Source
       \\type choice
       \\default TARPWindward
       \\key SimpleCombined
       \\key TARPWindward
       \\key MoWiTTWindward
       \\key DOE2Windward
       \\key NusseltJurges
       \\key McAdams
       \\key Mitchell
       \\key BlockenWindward
       \\key EmmelVertical
       \\key UserCurve
  A3 , \\field Wind Convection Windward Equation Vertical Wall User Curve Name
       \\note The SurfaceConvectionAlgorithm:Outside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionOutsideModels
  A4 , \\field Wind Convection Leeward Vertical Wall Equation Source
       \\type choice
       \\default TARPLeeward
       \\key SimpleCombined
       \\key TARPLeeward
       \\key MoWiTTLeeward
       \\key DOE2Leeward
       \\key EmmelVertical
       \\key NusseltJurges
       \\key McAdams
       \\key Mitchell
       \\key UserCurve
  A5 , \\field Wind Convection Leeward Vertical Wall Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Outside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionOutsideModels
  A6 , \\field Wind Convection Horizontal Roof Equation Source
       \\type choice
       \\default ClearRoof
       \\key SimpleCombined
       \\key TARPWindward
       \\key MoWiTTWindward
       \\key DOE2Windward
       \\key NusseltJurges
       \\key McAdams
       \\key Mitchell
       \\key BlockenWindward
       \\key EmmelRoof
       \\key ClearRoof
       \\key UserCurve
  A7 , \\field Wind Convection Horizontal Roof User Curve Name
       \\note The SurfaceConvectionAlgorithm:Outside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionOutsideModels
  A8 , \\field Natural Convection Vertical Wall Equation Source
       \\note This is for vertical walls
       \\type choice
       \\default ASHRAEVerticalWall
       \\key ASHRAEVerticalWall
       \\key AlamdariHammondVerticalWall
       \\key FohannoPolidoriVerticalWall
       \\key ISO15099Windows
       \\key UserCurve
       \\key None
  A9 , \\field Natural Convection Vertical Wall Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Outside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionOutsideModels
  A10, \\field Natural Convection Stable Horizontal Equation Source
       \\note This is for horizontal surfaces with heat flow directed for stable thermal stratification
       \\type choice
       \\default WaltonStableHorizontalOrTilt
       \\key WaltonStableHorizontalOrTilt
       \\key AlamdariHammondStableHorizontal
       \\key UserCurve
       \\key None
  A11, \\field Natural Convection Stable Horizontal Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Outside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionOutsideModels
  A12, \\field Natural Convection Unstable Horizontal Equation Source
       \\type choice
       \\default WaltonUnstableHorizontalOrTilt
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key UserCurve
       \\key None
  A13; \\field Natural Convection Unstable Horizontal Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Outside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionOutsideModels


SurfaceConvectionAlgorithm:Inside:UserCurve,
       \\memo Used to describe a custom model equation for surface convection heat transfer coefficient
       \\memo If more than one curve is referenced they are all used and added together.
  A1 , \\field Name
       \\reference UserConvectionInsideModels
       \\reference UserConvectionModels
  A2 , \\field Reference Temperature for Convection Heat Transfer
       \\note Controls which temperature is differenced from surface temperature when using the Hc value
       \\type choice
       \\key MeanAirTemperature
       \\key AdjacentAirTemperature
       \\key SupplyAirTemperature
  A3 , \\field Hc Function of Temperature Difference Curve Name
       \\note  Curve's "x" is absolute value of delta-T (Surface temperature minus reference temperature, (C))
       \\type alpha
       \\object-list LinearCurves
       \\object-list QuadraticCurves
       \\object-list CubicCurves
       \\object-list QuarticCurves
       \\object-list ExponentCurves
  A4 , \\field Hc Function of Temperature Difference Divided by Height Curve Name
       \\note Curve's "x" is absolute value of delta-T/Height (Surface temp minus Air temp)/(vertical length scale), (C/m)
       \\note when used for an inside face the vertical length scale is the zone's interior height
       \\object-list LinearCurves
       \\object-list QuadraticCurves
       \\object-list CubicCurves
       \\object-list QuarticCurves
       \\object-list ExponentCurves
  A5 , \\field Hc Function of Air Change Rate Curve Name
       \\note Curve's "x" is mechanical ACH (Air Changes per hour from mechanical air system), (1/hr)
       \\object-list LinearCurves
       \\object-list QuadraticCurves
       \\object-list CubicCurves
       \\object-list QuarticCurves
       \\object-list ExponentCurves
  A6 ; \\field Hc Function of Air System Volume Flow Rate Divided by Zone Perimeter Length Curve Name
       \\note Curve's "x" is mechanical system air flow rate (m3/s) divided by zone's length along
       \\note exterior walls (m).
       \\object-list LinearCurves
       \\object-list QuadraticCurves
       \\object-list CubicCurves
       \\object-list QuarticCurves
       \\object-list ExponentCurves

SurfaceConvectionAlgorithm:Outside:UserCurve,
       \\memo Used to describe a custom model equation for surface convection heat transfer coefficient
       \\memo If more than one curve is referenced they are all used and added together.
  A1 , \\field Name
       \\reference UserConvectionOutsideModels
       \\reference UserConvectionModels
  A2 , \\field Wind Speed Type for Curve
       \\type choice
       \\key WeatherFile
       \\key HeightAdjust
       \\key ParallelComponent
       \\key ParallelComponentHeightAdjust
       \\default HeightAdjust
  A3 , \\field Hf Function of Wind Speed Curve Name
       \\note Curve's "x" is wind speed of the type determined in the previous field (m/s)
       \\object-list LinearCurves
       \\object-list QuadraticCurves
       \\object-list CubicCurves
       \\object-list QuarticCurves
       \\object-list ExponentCurves
  A4 , \\field Hn Function of Temperature Difference Curve Name
       \\note  Curve's "x" is absolute value of delta-T (Surface temperature minus air temperature, (C))
       \\object-list LinearCurves
       \\object-list QuadraticCurves
       \\object-list CubicCurves
       \\object-list QuarticCurves
       \\object-list ExponentCurves
  A5 ; \\field Hn Function of Temperature Difference Divided by Height Curve Name
       \\note Curve's "x" is absolute value of delta-T/Height (Surface temp minus Air temp)/(vertical length scale), (C/m)
       \\note when used for an outside face the vertical length scale is the exterior facade's overall height
       \\object-list LinearCurves
       \\object-list QuadraticCurves
       \\object-list CubicCurves
       \\object-list QuarticCurves
       \\object-list ExponentCurves

SurfaceProperty:ConvectionCoefficients,
      \\memo Allow user settable interior and/or exterior convection coefficients.
      \\memo Note that some other factors may limit the lower bounds for these values, such as
      \\memo for windows, the interior convection coefficient must be >.28,
      \\memo for trombe wall algorithm selection (zone), the interior convection coefficient must be >.1
      \\memo for TARP interior convection, the lower limit is also .1
      \\memo Minimum and maximum limits are set in HeatBalanceAlgorithm object.
      \\memo Defaults in HeatBalanceAlgorithm object are [.1,1000].
  A1, \\field Surface Name
      \\required-field
      \\type object-list
      \\object-list SurfaceNames
  A2, \\field Convection Coefficient 1 Location
      \\required-field
      \\type choice
      \\key Outside
      \\key Inside
  A3, \\field Convection Coefficient 1 Type
      \\required-field
      \\type choice
      \\key Value
      \\key Schedule
      \\key UserCurve
      \\key Simple
      \\key SimpleCombined
      \\key TARP
      \\key DOE-2
      \\key MoWitt
      \\key AdaptiveConvectionAlgorithm
      \\key ASHRAEVerticalWall
      \\key WaltonUnstableHorizontalOrTilt
      \\key WaltonStableHorizontalOrTilt
      \\key FisherPedersenCeilingDiffuserWalls
      \\key FisherPedersenCeilingDiffuserCeiling
      \\key FisherPedersenCeilingDiffuserFloor
      \\key AlamdariHammondStableHorizontal
      \\key AlamdariHammondUnstableHorizontal
      \\key AlamdariHammondVerticalWall
      \\key KhalifaEq3WallAwayFromHeat
      \\key KhalifaEq4CeilingAwayFromHeat
      \\key KhalifaEq5WallNearHeat
      \\key KhalifaEq6NonHeatedWalls
      \\key KhalifaEq7Ceiling
      \\key AwbiHattonHeatedFloor
      \\key AwbiHattonHeatedWall
      \\key BeausoleilMorrisonMixedAssistedWall
      \\key BeausoleilMorrisonMixedOpposingWall
      \\key BeausoleilMorrisonMixedStableFloor
      \\key BeausoleilMorrisonMixedUnstableFloor
      \\key BeausoleilMorrisonMixedStableCeiling
      \\key BeausoleilMorrisonMixedUnstableCeiling
      \\key FohannoPolidoriVerticalWall
      \\key KaradagChilledCeiling
      \\key ISO15099Windows
      \\key GoldsteinNovoselacCeilingDiffuserWindow
      \\key GoldsteinNovoselacCeilingDiffuserWalls
      \\key GoldsteinNovoselacCeilingDiffuserFloor
      \\key NusseltJurges
      \\key McAdams
      \\key Mitchell
      \\key EmmelVertical
      \\key EmmelRoof
      \\key ClearRoof
  N1, \\field Convection Coefficient 1
      \\note used if Convection Type=Value, min and max limits are set in HeatBalanceAlgorithm object.
      \\note Default limits are Minimum >= 0.1 and Maximum <= 1000
      \\units W/m2-K
  A4, \\field Convection Coefficient 1 Schedule Name
      \\note used if Convection Type=Schedule,  min and max limits are set in HeatBalanceAlgorithm object.
      \\note Default limits are Minimum >= 0.1 and Maximum <= 1000
      \\type object-list
      \\object-list ScheduleNames
  A5, \\field Convection Coefficient 1 User Curve Name
      \\note used if Convection Type = UserCurve
      \\type object-list
      \\object-list UserConvectionModels
  A6, \\field Convection Coefficient 2 Location
      \\type choice
      \\key Outside
      \\key Inside
  A7, \\field Convection Coefficient 2 Type
      \\type choice
      \\key Value
      \\key Schedule
      \\key UserCurve
      \\key Simple
      \\key SimpleCombined
      \\key TARP
      \\key DOE-2
      \\key MoWitt
      \\key AdaptiveConvectionAlgorithm
      \\key ASHRAEVerticalWall
      \\key WaltonUnstableHorizontalOrTilt
      \\key WaltonStableHorizontalOrTilt
      \\key FisherPedersenCeilingDiffuserWalls
      \\key FisherPedersenCeilingDiffuserCeiling
      \\key FisherPedersenCeilingDiffuserFloor
      \\key AlamdariHammondStableHorizontal
      \\key AlamdariHammondUnstableHorizontal
      \\key AlamdariHammondVerticalWall
      \\key KhalifaEq3WallAwayFromHeat
      \\key KhalifaEq4CeilingAwayFromHeat
      \\key KhalifaEq5WallNearHeat
      \\key KhalifaEq6NonHeatedWalls
      \\key KhalifaEq7Ceiling
      \\key AwbiHattonHeatedFloor
      \\key AwbiHattonHeatedWall
      \\key BeausoleilMorrisonMixedAssistedWall
      \\key BeausoleilMorrisonMixedOpposingWall
      \\key BeausoleilMorrisonMixedStableFloor
      \\key BeausoleilMorrisonMixedUnstableFloor
      \\key BeausoleilMorrisonMixedStableCeiling
      \\key BeausoleilMorrisonMixedUnstableCeiling
      \\key FohannoPolidoriVerticalWall
      \\key KaradagChilledCeiling
      \\key ISO15099Windows
      \\key GoldsteinNovoselacCeilingDiffuserWindow
      \\key GoldsteinNovoselacCeilingDiffuserWalls
      \\key GoldsteinNovoselacCeilingDiffuserFloor
      \\key NusseltJurges
      \\key McAdams
      \\key Mitchell
      \\key EmmelVertical
      \\key EmmelRoof
      \\key ClearRoof
  N2, \\field Convection Coefficient 2
      \\note used if Convection Type=Value, min and max limits are set in HeatBalanceAlgorithm object.
      \\note Default limits are Minimum >= 0.1 and Maximum <= 1000
      \\default .1
      \\units W/m2-K
  A8, \\field Convection Coefficient 2 Schedule Name
      \\note used if Convection Type=Schedule,  min and max limits are set in HeatBalanceAlgorithm object.
      \\note Default limits are Minimum >= 0.1 and Maximum <= 1000
      \\type object-list
      \\object-list ScheduleNames
  A9; \\field Convection Coefficient 2 User Curve Name
      \\note used if Convection Type = UserCurve
      \\type object-list
      \\object-list UserConvectionModels

SurfaceProperty:ConvectionCoefficients:MultipleSurface,
      \\memo Allow user settable interior and/or exterior convection coefficients.
      \\memo Note that some other factors may limit the lower bounds for these values, such as
      \\memo for windows, the interior convection coefficient must be >.28,
      \\memo for trombe wall algorithm selection (zone), the interior convection coefficient must be >.1
      \\memo for TARP interior convection, the lower limit is also .1
      \\memo Minimum and maximum limits are set in HeatBalanceAlgorithm object.
      \\memo Defaults in HeatBalanceAlgorithm object are [.1,1000].
  A1, \\field Surface Type
      \\required-field
      \\type choice
      \\key AllExteriorSurfaces
      \\key AllExteriorWindows
      \\key AllExteriorWalls
      \\key AllExteriorRoofs
      \\key AllExteriorFloors
      \\key AllInteriorSurfaces
      \\key AllInteriorWalls
      \\key AllInteriorWindows
      \\key AllInteriorCeilings
      \\key AllInteriorFloors
  A2, \\field Convection Coefficient 1 Location
      \\required-field
      \\type choice
      \\key Outside
      \\key Inside
  A3, \\field Convection Coefficient 1 Type
      \\required-field
      \\type choice
      \\key Value
      \\key Schedule
      \\key Simple
      \\key SimpleCombined
      \\key TARP
      \\key DOE-2
      \\key MoWitt
      \\key AdaptiveConvectionAlgorithm
      \\key ASHRAEVerticalWall
      \\key WaltonUnstableHorizontalOrTilt
      \\key WaltonStableHorizontalOrTilt
      \\key FisherPedersenCeilingDiffuserWalls
      \\key FisherPedersenCeilingDiffuserCeiling
      \\key FisherPedersenCeilingDiffuserFloor
      \\key AlamdariHammondStableHorizontal
      \\key AlamdariHammondUnstableHorizontal
      \\key AlamdariHammondVerticalWall
      \\key KhalifaEq3WallAwayFromHeat
      \\key KhalifaEq4CeilingAwayFromHeat
      \\key KhalifaEq5WallNearHeat
      \\key KhalifaEq6NonHeatedWalls
      \\key KhalifaEq7Ceiling
      \\key AwbiHattonHeatedFloor
      \\key AwbiHattonHeatedWall
      \\key BeausoleilMorrisonMixedAssistedWall
      \\key BeausoleilMorrisonMixedOpposingWall
      \\key BeausoleilMorrisonMixedStableFloor
      \\key BeausoleilMorrisonMixedUnstableFloor
      \\key BeausoleilMorrisonMixedStableCeiling
      \\key BeausoleilMorrisonMixedUnstableCeiling
      \\key FohannoPolidoriVerticalWall
      \\key KaradagChilledCeiling
      \\key ISO15099Windows
      \\key GoldsteinNovoselacCeilingDiffuserWindow
      \\key GoldsteinNovoselacCeilingDiffuserWalls
      \\key GoldsteinNovoselacCeilingDiffuserFloor
      \\key NusseltJurges
      \\key McAdams
      \\key Mitchell
      \\key BlockenWindard
      \\key EmmelVertical
      \\key EmmelRoof
      \\key ClearRoof
      \\key UserCurve
  N1, \\field Convection Coefficient 1
      \\note used if Convection Type=Value, min and max limits are set in HeatBalanceAlgorithm object.
      \\note Default limits are Minimum >= 0.1 and Maximum <= 1000
      \\units W/m2-K
  A4, \\field Convection Coefficient 1 Schedule Name
      \\note used if Convection Type=Schedule,  min and max limits are set in HeatBalanceAlgorithm object.
      \\note Default limits are Minimum >= 0.1 and Maximum <= 1000
      \\type object-list
      \\object-list ScheduleNames
  A5, \\field Convection Coefficient 1 User Curve Name
      \\note used if Convection Type = UserCurve
      \\type object-list
      \\object-list UserConvectionModels
  A6, \\field Convection Coefficient 2 Location
      \\type choice
      \\key Outside
      \\key Inside
  A7, \\field Convection Coefficient 2 Type
      \\type choice
      \\key Value
      \\key Schedule
      \\key Simple
      \\key SimpleCombined
      \\key TARP
      \\key DOE-2
      \\key MoWitt
      \\key AdaptiveConvectionAlgorithm
      \\key ASHRAEVerticalWall
      \\key WaltonUnstableHorizontalOrTilt
      \\key WaltonStableHorizontalOrTilt
      \\key FisherPedersenCeilingDiffuserWalls
      \\key FisherPedersenCeilingDiffuserCeiling
      \\key FisherPedersenCeilingDiffuserFloor
      \\key AlamdariHammondStableHorizontal
      \\key AlamdariHammondUnstableHorizontal
      \\key AlamdariHammondVerticalWall
      \\key KhalifaEq3WallAwayFromHeat
      \\key KhalifaEq4CeilingAwayFromHeat
      \\key KhalifaEq5WallNearHeat
      \\key KhalifaEq6NonHeatedWalls
      \\key KhalifaEq7Ceiling
      \\key AwbiHattonHeatedFloor
      \\key AwbiHattonHeatedWall
      \\key BeausoleilMorrisonMixedAssistedWall
      \\key BeausoleilMorrisonMixedOpposingWall
      \\key BeausoleilMorrisonMixedStableFloor
      \\key BeausoleilMorrisonMixedUnstableFloor
      \\key BeausoleilMorrisonMixedStableCeiling
      \\key BeausoleilMorrisonMixedUnstableCeiling
      \\key FohannoPolidoriVerticalWall
      \\key KaradagChilledCeiling
      \\key ISO15099Windows
      \\key GoldsteinNovoselacCeilingDiffuserWindow
      \\key GoldsteinNovoselacCeilingDiffuserWalls
      \\key GoldsteinNovoselacCeilingDiffuserFloor
      \\key NusseltJurges
      \\key McAdams
      \\key Mitchell
      \\key BlockenWindard
      \\key EmmelVertical
      \\key EmmelRoof
      \\key ClearRoof
      \\key UserCurve
  N2, \\field Convection Coefficient 2
      \\note used if Convection Type=Value, min and max limits are set in HeatBalanceAlgorithm object.
      \\note Default limits are Minimum >= 0.1 and Maximum <= 1000
      \\default .1
      \\units W/m2-K
  A8, \\field Convection Coefficient 2 Schedule Name
      \\note used if Convection Type=Schedule,  min and max limits are set in HeatBalanceAlgorithm object.
      \\note Default limits are Minimum >= 0.1 and Maximum <= 1000
      \\type object-list
      \\object-list ScheduleNames
  A9; \\field Convection Coefficient 2 User Curve Name
      \\note used if Convection Type = UserCurve
      \\type object-list
      \\object-list UserConvectionModels

SurfaceProperties:VaporCoefficients,
      \\memo The interior and external vapor transfer coefficients.
      \\memo Normally these value are calculated using the heat convection coefficient values.
      \\memo Use this object to used fixed constant values.
      \\memo Units are kg/Pa.s.m2
      \\memo This will only work with the CombinedHeatAndMoistureFiniteElement algorithm for surfaces.
      \\memo Other algorithms will ignore these coefficients
  A1, \\field Surface Name
      \\required-field
      \\type object-list
      \\object-list SurfaceNames
  A2, \\field Constant External Vapor Transfer Coefficient
      \\required-field
      \\type choice
      \\key Yes
      \\key No
      \\default No
  N1, \\field External Vapor Coefficient Value
      \\units kg/Pa-s-m2
      \\default 0
      \\minimum 0.0
  A3, \\field Constant Internal vapor Transfer Coefficient
      \\required-field
      \\type choice
      \\key Yes
      \\key No
      \\default No
  N2; \\field Internal Vapor Coefficient Value
      \\units kg/Pa-s-m2
      \\default 0
      \\minimum 0.0

SurfaceProperty:ExteriorNaturalVentedCavity,
       \\memo Used to describe the decoupled layer, or baffle, and the characteristics of the cavity
       \\memo and openings for naturally ventilated exterior surfaces. This object is also used in
       \\memo conjunction with the OtherSideConditionsModel.
       \\extensible:1 - repeat last field, remembering to remove ; from "inner" fields.
  A1,  \\field Name
       \\required-field
       \\type alpha
       \\reference VentedCavityNames
  A2,  \\field Boundary Conditions Model Name
       \\note Enter the name of a SurfaceProperty:OtherSideConditionsModel object
       \\required-field
       \\type object-list
       \\object-list OSCMNames
  N1,  \\field Area Fraction of Openings
       \\type real
       \\minimum> 0
       \\maximum 1.0
       \\units dimensionless
  N2,  \\field Thermal Emissivity of Exterior Baffle Material
       \\type real
       \\minimum 0
       \\maximum 1
       \\units dimensionless
  N3,  \\field Solar Absorbtivity of Exterior Baffle
       \\type real
       \\minimum 0
       \\maximum 1
       \\units dimensionless
  N4, \\field Height Scale for Buoyancy-Driven Ventilation
       \\type real
       \\units m
       \\minimum> 0.0
  N5,  \\field Effective Thickness of Cavity Behind Exterior Baffle
       \\type real
       \\minimum> 0.
       \\units m
       \\note if corrugated, use average depth
  N6,  \\field Ratio of Actual Surface Area to Projected Surface Area
       \\type real
       \\note this parameter is used to help account for corrugations in the collector
       \\default 1.0
       \\minimum 0.8
       \\maximum 2.0
       \\units dimensionless
  A3,  \\field Roughness of Exterior Surface
       \\required-field
       \\type choice
       \\key VeryRough
       \\key Rough
       \\key MediumRough
       \\key MediumSmooth
       \\key Smooth
       \\key VerySmooth
  N7,  \\field Effectiveness for Perforations with Respect to Wind
       \\type real
       \\units dimensionless
       \\default 0.25
       \\minimum> 0
       \\maximum 1.5
  N8,  \\field Discharge Coefficient for Openings with Respect to Buoyancy Driven Flow
       \\type real
       \\units dimensionless
       \\default 0.65
       \\minimum> 0.0
       \\maximum 1.5
  A4,  \\field Surface 1 Name
       \\begin-extensible
       \\required-field
       \\type object-list
       \\object-list AllShadingAndHTSurfNames
  A5,  \\field Surface 2 Name
       \\type object-list
       \\object-list AllShadingAndHTSurfNames
  A6,  \\field Surface 3 Name
       \\type object-list
       \\object-list AllShadingAndHTSurfNames
  A7,  \\field Surface 4 Name
       \\type object-list
       \\object-list AllShadingAndHTSurfNames
  A8,  \\field Surface 5 Name
       \\type object-list
       \\object-list AllShadingAndHTSurfNames
  A9,  \\field Surface 6 Name
       \\type object-list
       \\object-list AllShadingAndHTSurfNames
  A10,  \\field Surface 7 Name
       \\type object-list
       \\object-list AllShadingAndHTSurfNames
  A11,  \\field Surface 8 Name
       \\type object-list
       \\object-list AllShadingAndHTSurfNames
  A12,  \\field Surface 9 Name
       \\type object-list
       \\object-list AllShadingAndHTSurfNames
  A13;  \\field Surface 10 Name
       \\type object-list
       \\object-list AllShadingAndHTSurfNames

ZoneProperty:UserViewFactors:bySurfaceName,
       \\memo View factors for Surface to Surface in a zone.
       \\memo (Number of Surfaces)**2 must be entered.
       \\extensible:3 - copy last three fields, remembering to remove ;
       \\format ViewFactor
  A1,  \\field Zone Name
       \\type object-list
       \\object-list ZoneNames
  A2,  \\field From Surface 1
       \\begin-extensible
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A3,  \\field To Surface 1
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N1,  \\field View Factor 1
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A4,  \\field From Surface 2
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A5,  \\field To Surface 2
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N2,  \\field View Factor 2
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A6,  \\field From Surface 3
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A7,  \\field To Surface 3
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N3,  \\field View Factor 3
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A8,  \\field From Surface 4
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A9,  \\field To Surface 4
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N4,  \\field View Factor 4
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A10, \\field From Surface 5
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A11, \\field To Surface 5
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N5,  \\field View Factor 5
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A12, \\field From Surface 6
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A13, \\field To Surface 6
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N6,  \\field View Factor 6
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A14, \\field From Surface 7
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A15, \\field To Surface 7
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N7,  \\field View Factor 7
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A16, \\field From Surface 8
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A17, \\field To Surface 8
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N8,  \\field View Factor 8
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A18, \\field From Surface 9
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A19, \\field To Surface 9
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N9,  \\field View Factor 9
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A20, \\field From Surface 10
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A21, \\field To Surface 10
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N10, \\field View Factor 10
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A22, \\field From Surface 11
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A23, \\field To Surface 11
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N11, \\field View Factor 11
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A24, \\field From Surface 12
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A25, \\field To Surface 12
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N12, \\field View Factor 12
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A26, \\field From Surface 13
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A27, \\field To Surface 13
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N13, \\field View Factor 13
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A28, \\field From Surface 14
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A29, \\field To Surface 14
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N14, \\field View Factor 14
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A30, \\field From Surface 15
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A31, \\field To Surface 15
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N15, \\field View Factor 15
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A32, \\field From Surface 16
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A33, \\field To Surface 16
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N16, \\field View Factor 16
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A34, \\field From Surface 17
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A35, \\field To Surface 17
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N17, \\field View Factor 17
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A36, \\field From Surface 18
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A37, \\field To Surface 18
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N18, \\field View Factor 18
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A38, \\field From Surface 19
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A39, \\field To Surface 19
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N19, \\field View Factor 19
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A40, \\field From Surface 20
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A41, \\field To Surface 20
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N20, \\field View Factor 20
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A42,A43,N21, \\note fields as indicated
  A44,A45,N22, \\note fields as indicated
  A46,A47,N23, \\note fields as indicated
  A48,A49,N24, \\note fields as indicated
  A50,A51,N25, \\note fields as indicated
  A52,A53,N26, \\note fields as indicated
  A54,A55,N27, \\note fields as indicated
  A56,A57,N28, \\note fields as indicated
  A58,A59,N29, \\note fields as indicated
  A60,A61,N30, \\note fields as indicated
  A62,A63,N31, \\note fields as indicated
  A64,A65,N32, \\note fields as indicated
  A66,A67,N33, \\note fields as indicated
  A68,A69,N34, \\note fields as indicated
  A70,A71,N35, \\note fields as indicated
  A72,A73,N36, \\note fields as indicated
  A74,A75,N37, \\note fields as indicated
  A76,A77,N38, \\note fields as indicated
  A78,A79,N39, \\note fields as indicated
  A80,A81,N40, \\note fields as indicated
  A82,A83,N41, \\note fields as indicated
  A84,A85,N42, \\note fields as indicated
  A86,A87,N43, \\note fields as indicated
  A88,A89,N44, \\note fields as indicated
  A90,A91,N45, \\note fields as indicated
  A92,A93,N46, \\note fields as indicated
  A94,A95,N47, \\note fields as indicated
  A96,A97,N48, \\note fields as indicated
  A98,A99,N49, \\note fields as indicated
  A100,A101,N50, \\note fields as indicated
  A102,A103,N51, \\note fields as indicated
  A104,A105,N52, \\note fields as indicated
  A106,A107,N53, \\note fields as indicated
  A108,A109,N54, \\note fields as indicated
  A110,A111,N55, \\note fields as indicated
  A112,A113,N56, \\note fields as indicated
  A114,A115,N57, \\note fields as indicated
  A116,A117,N58, \\note fields as indicated
  A118,A119,N59, \\note fields as indicated
  A120,A121,N60, \\note fields as indicated
  A122,A123,N61, \\note fields as indicated
  A124,A125,N62, \\note fields as indicated
  A126,A127,N63, \\note fields as indicated
  A128,A129,N64, \\note fields as indicated
  A130,A131,N65, \\note fields as indicated
  A132,A133,N66, \\note fields as indicated
  A134,A135,N67, \\note fields as indicated
  A136,A137,N68, \\note fields as indicated
  A138,A139,N69, \\note fields as indicated
  A140,A141,N70, \\note fields as indicated
  A142,A143,N71, \\note fields as indicated
  A144,A145,N72, \\note fields as indicated
  A146,A147,N73, \\note fields as indicated
  A148,A149,N74, \\note fields as indicated
  A150,A151,N75, \\note fields as indicated
  A152,A153,N76, \\note fields as indicated
  A154,A155,N77, \\note fields as indicated
  A156,A157,N78, \\note fields as indicated
  A158,A159,N79, \\note fields as indicated
  A160,A161,N80, \\note fields as indicated
  A162,A163,N81, \\note fields as indicated
  A164,A165,N82, \\note fields as indicated
  A166,A167,N83, \\note fields as indicated
  A168,A169,N84, \\note fields as indicated
  A170,A171,N85, \\note fields as indicated
  A172,A173,N86, \\note fields as indicated
  A174,A175,N87, \\note fields as indicated
  A176,A177,N88, \\note fields as indicated
  A178,A179,N89, \\note fields as indicated
  A180,A181,N90, \\note fields as indicated
  A182,A183,N91, \\note fields as indicated
  A184,A185,N92, \\note fields as indicated
  A186,A187,N93, \\note fields as indicated
  A188,A189,N94, \\note fields as indicated
  A190,A191,N95, \\note fields as indicated
  A192,A193,N96, \\note fields as indicated
  A194,A195,N97, \\note fields as indicated
  A196,A197,N98, \\note fields as indicated
  A198,A199,N99, \\note fields as indicated
  A200,A201,N100, \\note fields as indicated
  A202,A203,N101, \\note fields as indicated
  A204,A205,N102, \\note fields as indicated
  A206,A207,N103, \\note fields as indicated
  A208,A209,N104, \\note fields as indicated
  A210,A211,N105, \\note fields as indicated
  A212,A213,N106, \\note fields as indicated
  A214,A215,N107, \\note fields as indicated
  A216,A217,N108, \\note fields as indicated
  A218,A219,N109, \\note fields as indicated
  A220,A221,N110, \\note fields as indicated
  A222,A223,N111, \\note fields as indicated
  A224,A225,N112, \\note fields as indicated
  A226,A227,N113, \\note fields as indicated
  A228,A229,N114, \\note fields as indicated
  A230,A231,N115, \\note fields as indicated
  A232,A233,N116, \\note fields as indicated
  A234,A235,N117, \\note fields as indicated
  A236,A237,N118, \\note fields as indicated
  A238,A239,N119, \\note fields as indicated
  A240,A241,N120, \\note fields as indicated
  A242,A243,N121; \\note fields as indicated

\\group Detailed Ground Heat Transfer

GroundHeatTransfer:Control,
  \\memo Object determines if the Slab and Basement preprocessors
  \\memo are going to be executed.
  A1 , \\field Name
    \\note This field is included for consistency.11
  A2 , \\field Run Basement Preprocessor
       \\type choice
       \\key Yes
       \\key No
       \\default No
  A3 ; \\field Run Slab Preprocessor
       \\type choice
       \\key Yes
       \\key No
       \\default No

GroundHeatTransfer:Slab:Materials,
    \\memo Object gives an overall description of the slab ground heat transfer model.
        N1, \\field NMAT: Number of materials
            \\note This field specifies the number of different materials that will be used in the model.
            \\note Typically only a ground material and a slab material are used. (2 materials)
            \\minimum> 0
          \\required-field
        N2, \\field ALBEDO: Surface Albedo: No Snow
            \\note Two fields specify the albedo value of the surface: first for no snow coverage days;
            \\note second for days with snow coverage. The albedo is the solar reflectivity of the surface,
            \\note and can vary from 0.05 for blacktop to 0.95 for fresh snow.
            \\note Typical values for North America reported by Bahnfleth range from 0.16 to 0.4.
            \\minimum 0.0
            \\maximum 1.0
          \\default 0.16
        N3, \\field ALBEDO: Surface Albedo: Snow
            \\minimum 0.0
            \\maximum 1.0
          \\default 0.40
        N4, \\field EPSLW: Surface Emissivity: No Snow
          \\note EPSLW (No Snow and Snow) specifies the long wavelength (thermal) emissivity of the ground surface.
          \\note primarily important for nighttime radiation to sky.
          \\note typical value .95
            \\minimum> 0.0
          \\default 0.94
        N5, \\field EPSLW: Surface Emissivity: Snow
            \\minimum> 0.0
          \\default 0.86
        N6, \\field Z0: Surface Roughness: No Snow
          \\note fields Z0 (No Snow and Snow) describe the height at which an experimentally velocity profile goes to zero.
          \\note typical value= .75 cm
         \\minimum> 0.0
          \\default .75
          \\units cm
        N7, \\field Z0: Surface Roughness: Snow
            \\note typical value= .05 cm
         \\minimum> 0.0
          \\default 0.25
          \\units cm
        N8, \\field HIN: Indoor HConv: Downward Flow
            \\note These fields specify the combined convective and radiative heat transfer coefficient between
            \\note the slab top inside surface and the room air for the cases where heat is flowing downward,
            \\note and upward. The program toggles between the two if the direction of the heat flux changes.
            \\note Typical values can be found in the ASHRAE Handbook of Fundamentals, but should be
            \\note about 6 W/(m2-K) for downward heat flow and 9 W/(m2-K) for upward heat flow.
            \\note typical value= 4-10
            \\units W/m2-K
            \\minimum> 0.0
          \\default 6.13
        N9; \\field HIN: Indoor HConv: Upward
            \\minimum> 0.0
            \\note typical value= 4-10
            \\units W/m2-K
          \\default 9.26

GroundHeatTransfer:Slab:MatlProps,
    \\memo This object contains the material properties for the materials
    \\memo used in the model. The fields are mostly self explanatory.
     N1,  \\field RHO: Slab Material density
          \\note Density of Slab Material
          \\note typical value= 2300.0
          \\units kg/m3
          \\minimum> 0.0
          \\default 2300
     N2,  \\field RHO: Soil Density
          \\note Density of Soil Material
          \\note typical value= 1200.0
          \\minimum> 0.0
          \\default 1200
          \\units kg/m3
     N3,  \\field CP: Slab CP
          \\note Specific Heat of Slab Material
          \\note typical value=650.0
          \\units J/kg-K
          \\minimum> 0.0
          \\default 650
     N4,  \\field CP: Soil CP
          \\note Specific Heat of Soil Material
          \\note typical value= 1200.0
          \\minimum> 0.0
          \\default 1200
          \\units J/kg-K
     N5,  \\field TCON: Slab k
          \\note Conductivity of Slab Material
          \\note typical value= .9
          \\minimum> 0.0
          \\units W/m-K
          \\default 0.9
     N6;  \\field TCON: Soil k
          \\note Conductivity of Soil Material
          \\note typical value= 1.0
          \\minimum> 0.0
          \\units W/m-K
          \\default 1.0

GroundHeatTransfer:Slab:BoundConds,
      \\memo Supplies some of the boundary conditions used in the ground heat transfer calculations.
        A1, \\field EVTR: Is surface evapotranspiration modeled
            \\note This field specifies whether or not to use the evapotransporation model.
            \\note The inclusion of evapotransporation in the calculation has the greatest
            \\note effect in warm dry climates, primarily on the ground surface temperature.
            \\note This field can be used to turn the evapotransporation off and on to check
            \\note sensitivity to it.
            \\type choice
            \\key TRUE
            \\key FALSE
          \\required-field
        A2, \\field FIXBC: is the lower boundary at a fixed temperature
            \\note This field permits using a fixed temperature at the lower surface of the model
            \\note instead of a zero heat flux condition. This change normally has a very small
            \\note effect on the results.
            \\note FALSE selects the zero flux lower boundary condition
            \\type choice
            \\key TRUE
            \\key FALSE
          \\required-field
        N1, \\field TDEEPin
            \\note User input lower boundary temperature if FIXBC is TRUE
            \\note Blank for FIXBC FALSE or to use the calculated 1-D deep ground temperature.
            \\units C
        A3, \\field USRHflag: Is the ground surface h specified by the user?
            \\note This field flags the use of a user specified heat transfer coefficient
            \\note on the ground surface. This condition is used primarily for testing.
            \\note For normal runs (USPHflag is FALSE) and the program calculates the heat
            \\note transfer coefficient using the weather conditions.
            \\type choice
            \\key TRUE
            \\key FALSE
          \\required-field
        N2; \\field USERH: User specified ground surface heat transfer coefficient
            \\note Used only if USRHflag is TRUE and the heat transfer coefficient value is
            \\note specified in this field.
            \\units W/m2-K

GroundHeatTransfer:Slab:BldgProps,
          \\memo Object provides information about the building and its operating conditions
          \\memo Monthly Average Temperature SetPoint fields
          \\memo specify the average indoor building set point temperatures for each
          \\memo month of the year. These fields are useful for simulating a building
          \\memo that is not temperature controlled for some of the year.
          \\memo In such a case, the average indoor set point temperatures
          \\memo can be obtained by first running the model in EnergyPlus with an
          \\memo insulated floor boundary condition, and then using the resulting
          \\memo monthly average zone temperatures in these fields.
      N1, \\field IYRS: Number of years to iterate
          \\note This field specifies the number of years to iterate.
          \\note Either the ground heat transfer calculations come to an
          \\note an annual steady periodic condition by converging to a tolerance
          \\note (see ConvTol field) or it runs for this number of years.
          \\note A ten year maximum is usually sufficient.
          \\default 10
          \\minimum 1
      N2, \\field Shape: Slab shape
          \\note Use only the value 0 here. Only a rectangular shape is implemented.
          \\minimum 0
          \\maximum 0
      N3, \\field HBLDG: Building height
          \\note This field supplies the building height. This is used to calculate
          \\note the building shadowing on the ground.
          \\minimum 0
          \\note typical value= 0-20
          \\units m
      N4, \\field TIN1: January Indoor Average Temperature Setpoint
          \\note see memo on object for more information
          \\default 22
          \\units C
      N5, \\field TIN2: February Indoor Average Temperature Setpoint
          \\note see memo on object for more information
          \\default 22
          \\units C
      N6, \\field TIN3: March Indoor Average Temperature Setpoint
          \\note see memo on object for more information
          \\default 22
          \\units C
      N7, \\field TIN4: April Indoor Average Temperature Setpoint
          \\note see memo on object for more information
          \\default 22
          \\units C
      N8, \\field TIN5: May Indoor Average Temperature Setpoint
          \\note see memo on object for more information
          \\default 22
          \\units C
      N9, \\field TIN6: June Indoor Average Temperature Setpoint
          \\note see memo on object for more information
          \\default 22
          \\units C
      N10,\\field TIN7: July Indoor Average Temperature Setpoint
          \\note see memo on object for more information
          \\default 22
          \\units C
      N11,\\field TIN8: August Indoor Average Temperature Setpoint
          \\note see memo on object for more information
          \\default 22
          \\units C
      N12,\\field TIN9: September Indoor Average Temperature Setpoint
          \\note see memo on object for more information
          \\default 22
          \\units C
      N13,\\field TIN10: October Indoor Average Temperature Setpoint
          \\note see memo on object for more information
          \\default 22
          \\units C
      N14,\\field TIN11: November Indoor Average Temperature Setpoint
          \\note see memo on object for more information
          \\default 22
          \\units C
      N15,\\field TIN12: December Indoor Average Temperature Setpoint
          \\note see memo on object for more information
          \\default 22
          \\units C
      N16,\\field TINAmp: Daily Indoor sine wave variation amplitude
          \\note This field permits imposing a daily sinusoidal variation
          \\note in the indoor setpoint temperature to simulate the effect
          \\note of a setback profile.
          \\note The value specified is the amplitude of the sine wave.
          \\default 0
          \\units deltaC
      N17;\\field ConvTol: Convergence Tolerance
          \\note This field specifies the convergence tolerance used to
          \\note control the iteration. When the temperature change of all nodes
          \\note is less than the convergence value, iteration ceases.
          \\default 0.1

GroundHeatTransfer:Slab:Insulation,
    \\memo This object supplies the information about insulation used around the slab.
    \\memo There are two possible configurations: under the slab or vertical insulation
    \\memo around the slab.
        N1, \\field RINS: R value of under slab insulation
            \\note This field provides the thermal resistance value
            \\note of the under slab insulation. It should be zero
            \\note if the vertical insulation configuration is selected.
            \\note typical value= 0-2.0
            \\units m2-K/W
          \\default 0.0
        N2, \\field DINS: Width of strip of under slab insulation
            \\note This specifies the width of the perimeter strip of insulation
            \\note under the slab. It should be zero if for the vertical insulation
            \\note configuration is selected.
            \\note typical value= 0-2.0
            \\units m
          \\default 0.0
        N3, \\field RVINS: R value of vertical insulation
            \\note This field specifies the thermal resistance of the vertical
            \\note insulation. It should be zero if the under slab insulation
            \\note configuration is selected.
            \\note typical value= 0-3.0
            \\units m2-K/W
          \\default 0.0
        N4, \\field ZVINS: Depth of vertical insulation
            \\note This field specifies the depth of the vertical insulation
            \\note into the ground in meters. It starts at the slab upper surface
            \\note and extends into the ground.
            \\note It should be zero if the under slab insulation
            \\note configuration is selected.
            \\note only use values= .2 .4 .6 .8 1.0 1.5 2.0 2.5 3.0
            \\units m
          \\default 0
        N5; \\field IVINS: Flag: Is there vertical insulation
            \\note Specifies if the vertical insulation configuration is being used.
            \\note values: 1=yes vertical insulation 0=no underslab insulation
          \\required-field
          \\type choice
          \\key 0
          \\key 1
          \\default 0

GroundHeatTransfer:Slab:EquivalentSlab,
    \\memo Using an equivalent slab allows non-rectangular shapes to be modeled accurately.
    \\memo Object uses the area - perimeter (area/perimeter) ratio to determine the
    \\memo size of an equivalent rectangular slab.
    \\memo EnergyPlus users normally use this option.
     N1,  \\field APRatio: The area to perimeter ratio for this slab
          \\note Equivalent square slab is simulated,  side is 4*APRatio.
          \\units m
          \\minimum 1.5
          \\maximum 22
          \\required-field
     N2,  \\field SLABDEPTH: Thickness of slab on grade
          \\note This field specifies the thickness of the slab. The slab top surface is level
          \\note with the ground surface, so this is the depth into the ground.
          \\note The slab depth has a significant effect on the temperature calculation,
          \\note and it is also important for the auto-grid process.
          \\note The finite difference grids are set in such a way that they use the slab thickness
          \\note to determine the vertical grid spacing. Autogridding will fail if the slab thickness
          \\note is specified larger than 0.25 meters.
          \\default 0.1
          \\units m
     N3,  \\field CLEARANCE: Distance from edge of slab to domain edge
          \\note This field specifies the distance from the slab to the edge of
          \\note the area that will be modeled with the grid system. It is the basic size
          \\note dimension that is used to set the horizontal extent of the domain.
          \\note 15 meters is a reasonable value.
          \\default 15.0
          \\units m
     N4;  \\field ZCLEARANCE: Distance from bottom of slab to domain bottom
          \\note This field specifies the vertical distance from the slab to the
          \\note bottom edge of the area that will be modeled with the grid system.
          \\note 15 meters is a reasonable value.
          \\default 15.0
          \\units m

GroundHeatTransfer:Slab:AutoGrid,
            \\memo AutoGrid only necessary when EquivalentSlab option not chosen.
            \\memo  Not normally needed by EnergyPlus users.
            \\memo  This object permits user selection of rectangular slab dimensions.
            \\memo  NO SLAB DIMENSIONS LESS THAN 6 m.
        N1, \\field SLABX: X dimension of the building slab
            \\minimum 6
            \\note typical values= 6 to 60.0
            \\units m
          \\required-field
        N2, \\field SLABY: Y dimension of the building slab
            \\minimum 6
            \\note typical values= 6 to 60.0
            \\units m
          \\required-field
        N3, \\field SLABDEPTH: Thickness of slab on grade
            \\default 0.1
            \\units m
        N4, \\field CLEARANCE: Distance from edge of slab to domain edge
            \\default 15.0
            \\units m
        N5; \\field ZCLEARANCE: Distance from bottom of slab to domain bottom
            \\default 15.0
            \\units m

GroundHeatTransfer:Slab:ManualGrid,
            \\memo Manual Grid only necessary when using manual gridding (not recommended)
            \\memo Used only in special cases when previous two objects are not used.
            \\memo User must input complete gridding information.
        N1, \\field NX: Number of cells in the X direction
          \\minimum 1
          \\required-field
        N2, \\field NY: Number of cells in the Y direction
          \\minimum 1
          \\required-field
        N3, \\field NZ: Number of cells in the Z direction
          \\minimum 1
          \\required-field
        N4, \\field IBOX: X direction cell indicator of slab edge
            \\note typical values= 1-10
          \\required-field
        N5; \\field JBOX: Y direction cell indicator of slab edge
            \\note typical values= 1-10
          \\required-field

GroundHeatTransfer:Slab:XFACE,
         \\memo This is only needed when using manual gridding (not recommended)
         \\memo XFACE: X Direction cell face coordinates: m
        N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12, N13, N14,                  \\note fields as indicated
        N15, N16, N17, N18, N19, N20, N21, N22, N23, N24, N25, N26, N27, N28, N29,    \\note fields as indicated
        N30, N31, N32, N33, N34, N35, N36, N37, N38, N39, N40;                        \\note fields as indicated

GroundHeatTransfer:Slab:YFACE,
         \\memo This is only needed when using manual gridding (not recommended)
         \\memo YFACE: Y Direction cell face coordinates: m,
        N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12, N13, N14,                  \\note fields as indicated
        N15, N16, N17, N18, N19, N20, N21, N22, N23, N24, N25, N26, N27, N28, N29,    \\note fields as indicated
        N30, N31, N32, N33, N34, N35, N36, N37, N38, N39, N40;                        \\note fields as indicated

GroundHeatTransfer:Slab:ZFACE,
         \\memo This is only needed when usuing manual gridding (not recommended)
         \\memo ZFACE: Z Direction cell face coordinates: m
        N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12, N13, N14,                  \\note fields as indicated
        N15, N16, N17, N18, N19, N20, N21, N22, N23, N24, N25;                        \\note fields as indicated

GroundHeatTransfer:Basement:SimParameters,
          \\memo Specifies certain parameters that control the Basement preprocessor ground heat
          \\memo transfer simulation.
     N1,  \\field F: Multiplier for the ADI solution
         \\note 0<F<1.0,
          \\note typically 0.1 (0.3 for high k soil - saturated sand is about 2.6 w/m-K)
          \\minimum> 0.0
          \\maximum 1.0
      N2; \\field IYRS: Maximum number of yearly iterations:
         \\note typically 15-30]
          \\minimum 0
          \\default 15

GroundHeatTransfer:Basement:MatlProps,
         \\memo Specifies the material properties for the Basement preprocessor ground heat
         \\memo transfer simulation. Only the Foundation Wall, Floor Slab, Soil,
         \\memo and Gravel properties are currently used.
     N1, \\field NMAT: Number of materials in this domain
         \\maximum 6
          \\required-field
     N2, \\field Density for Foundation Wall
         \\minimum> 0.0
         \\default 2243
         \\units kg/m3
     N3, \\field density for Floor Slab
         \\minimum> 0.0
         \\default 2243
         \\units kg/m3
     N4, \\field density for Ceiling
         \\minimum> 0.0
         \\default 311
         \\units kg/m3
     N5, \\field density for Soil
         \\minimum> 0.0
         \\default 1500
         \\units kg/m3
     N6, \\field density for Gravel
         \\minimum> 0.0
         \\default 2000
         \\units kg/m3
     N7, \\field density for Wood
         \\minimum> 0.0
         \\default 449
         \\units kg/m3
     N8,  \\field Specific heat for foundation wall
          \\minimum> 0.0
          \\default 880
          \\units J/kg-K
     N9,  \\field Specific heat for floor slab
          \\minimum> 0.0
          \\default 880
          \\units J/kg-K
     N10, \\field Specific heat for ceiling
          \\minimum> 0.0
          \\default 1530
          \\units J/kg-K
     N11, \\field Specific heat for soil
          \\minimum> 0.0
          \\default 840
          \\units J/kg-K
     N12, \\field Specific heat for gravel
          \\minimum> 0.0
          \\default 720
          \\units J/kg-K
     N13, \\field Specific heat for wood
          \\minimum> 0.0
          \\default 1530
          \\units J/kg-K
     N14, \\field Thermal conductivity for foundation wall
          \\minimum> 0.0
          \\default 1.4
          \\units W/m-K
     N15, \\field Thermal conductivity for floor slab
          \\minimum> 0.0
          \\default 1.4
          \\units W/m-K
     N16, \\field Thermal conductivity for ceiling
          \\minimum> 0.0
          \\default 0.09
          \\units W/m-K
     N17, \\field thermal conductivity for soil
          \\minimum> 0.0
          \\default 1.1
          \\units W/m-K
     N18, \\field thermal conductivity for gravel
          \\minimum> 0.0
          \\default 1.9
          \\units W/m-K
     N19; \\field thermal conductivity for wood
          \\minimum> 0.0
          \\default 0.12
          \\units W/m-K

GroundHeatTransfer:Basement:Insulation,
         \\memo Describes the insulation used on an exterior basement wall for the Basement
         \\memo preprocessor ground heat transfer simulation.
     N1, \\field REXT: R Value of any exterior insulation
         \\minimum> 0.0
         \\units m2-K/W
     A1; \\field INSFULL: Flag: Is the wall fully insulated?
          \\required-field
         \\type choice
          \\key TRUE
          \\key FALSE
         \\note  True for full insulation
         \\note  False for insulation half way down side wall from grade line

GroundHeatTransfer:Basement:SurfaceProps,
         \\memo Specifies the soil surface properties for the Basement preprocessor ground
         \\memo heat transfer simulation.
     N1, \\field ALBEDO: Surface albedo for No snow conditions
         \\minimum 0.0
          \\maximum 1.0
         \\default 0.16
     N2, \\field ALBEDO: Surface albedo for snow conditions
         \\minimum 0.0
          \\maximum 1.0
         \\default 0.40
     N3, \\field EPSLN: Surface emissivity No Snow
          \\minimum 0.0
          \\maximum 1.0
         \\default 0.94
     N4, \\field EPSLN: Surface emissivity with Snow
          \\minimum 0.0
          \\maximum 1.0
         \\default 0.86
     N5, \\field VEGHT: Surface roughness No snow conditions
          \\minimum 0.0
         \\default 6.0
         \\units cm
     N6, \\field VEGHT: Surface roughness Snow conditions
          \\minimum 0.0
         \\default 0.25
         \\units cm
     A1; \\field PET: Flag, Potential evapotranspiration on?
          \\note  Typically, PET is False
          \\required-field
         \\type choice
          \\key TRUE
          \\key FALSE
          \\default FALSE

GroundHeatTransfer:Basement:BldgData,
         \\memo Specifies the surface and gravel thicknesses used for the Basement
         \\memo preprocessor ground heat transfer simulation.
     N1, \\field DWALL: Wall thickness
         \\units m
         \\minimum 0.2
          \\default 0.2
     N2, \\field DSLAB: Floor slab thickness
         \\units m
         \\minimum> 0.0
         \\maximum 0.25
          \\default 0.1
     N3, \\field DGRAVXY: Width of gravel pit beside basement wall
         \\minimum> 0.0
         \\units  m
          \\default 0.3
     N4, \\field DGRAVZN: Gravel depth extending above the floor slab
         \\minimum> 0.0
         \\units m
          \\default 0.2
     N5; \\field DGRAVZP: Gravel depth below the floor slab
         \\minimum> 0.0
         \\units m
         \\default 0.1

GroundHeatTransfer:Basement:Interior,
       \\memo Provides the information needed to simulate the inside boundary conditions for
       \\memo the Basement preprocessor ground heat transfer simulation.
   A1, \\field COND: Flag: Is the basement conditioned?
          \\required-field
       \\type choice
          \\key TRUE
          \\key FALSE
          \\default TRUE
       \\note for EnergyPlus this should be TRUE
   N1, \\field HIN: Downward convection only heat transfer coefficient
       \\units W/m2-K
          \\minimum> 0.0
          \\default 0.92
   N2, \\field HIN: Upward convection only heat transfer coefficient
       \\units W/m2-K
          \\minimum> 0.0
          \\default 4.04
   N3, \\field HIN: Horizontal convection only heat transfer coefficient
       \\units W/m2-K
          \\minimum> 0.0
          \\default 3.08
   N4, \\field HIN: Downward combined (convection and radiation) heat transfer coefficient
       \\units W/m2-K
          \\minimum> 0.0
          \\default 6.13
   N5, \\field HIN: Upward combined (convection and radiation) heat transfer coefficient
       \\units W/m2-K
          \\minimum> 0.0
          \\default 9.26
   N6; \\field HIN: Horizontal combined (convection and radiation) heat transfer coefficient
       \\units W/m2-K
          \\minimum> 0.0
          \\default 8.29

GroundHeatTransfer:Basement:ComBldg,
   \\memo ComBldg contains the monthly average temperatures (C) and possibility of daily variation amplitude
   N1,  \\field January average temperature
        \\units C
          \\default 22
   N2,  \\field February average temperature
        \\units C
          \\default 22
   N3,  \\field March average temperature
        \\units C
          \\default 22
   N4,  \\field April average temperature
        \\units C
          \\default 22
   N5,  \\field May average temperature
        \\units C
          \\default 22
   N6,  \\field June average temperature
        \\units C
          \\default 22
   N7,  \\field July average temperature
        \\units C
          \\default 22
   N8,  \\field August average temperature
        \\units C
          \\default 22
   N9,  \\field September average temperature
        \\units C
          \\default 22
   N10, \\field October average temperature
        \\units C
          \\default 22
   N11, \\field November average temperature
        \\units C
          \\default 22
   N12, \\field December average temperature
        \\units C
          \\default 22
   N13; \\field Daily variation sine wave amplitude
          \\units deltaC
          \\default 0
        \\note (Normally zero, just for checking)

GroundHeatTransfer:Basement:EquivSlab,  !  Supplies the EquivSizing Flag
    \\memo Using an equivalent slab allows non-rectangular shapes to be
    \\memo modeled accurately.
    \\memo The simulation default should be EquivSizing=True
   N1, \\field APRatio: The area to perimeter ratio for this slab
       \\minimum> 0.0
       \\units m
          \\required-field
   A1; \\field EquivSizing: Flag
          \\required-field
       \\type choice
          \\key TRUE
          \\key FALSE
       \\note Will the dimensions of an equivalent slab be calculated (TRUE)
       \\note or will the dimensions be input directly? (FALSE)]
       \\note Only advanced special simulations should use FALSE.

GroundHeatTransfer:Basement:EquivAutoGrid,
    \\memo EquivAutoGrid necessary when EquivSizing=TRUE, TRUE is is the normal case.
   N1, \\field CLEARANCE: Distance from outside of wall to edge of 3-D ground domain
          \\minimum 0.0
       \\units m
       \\default 15
   N2, \\field SlabDepth: Thickness of the floor slab
          \\minimum 0.0
       \\units m
       \\default  0.1
   N3; \\field BaseDepth: Depth of the basement wall below grade
          \\minimum 0.0
       \\units  m
          \\default 2

GroundHeatTransfer:Basement:AutoGrid,
   \\memo AutoGrid only necessary when EquivSizing is false
   \\memo If the modelled building is not a rectangle or square, Equivalent
   \\memo sizing MUST be used to get accurate results
   N1, \\field CLEARANCE: Distance from outside of wall to edge,
          \\minimum 0
       \\units m
       \\default 15
   N2, \\field SLABX: X dimension of the building slab
          \\required-field
       \\units m
       \\minimum 0
       \\maximum 60
   N3, \\field SLABY: Y dimension of the building slab
          \\required-field
       \\units m
       \\minimum 0
       \\maximum 60
   N4, \\field ConcAGHeight: Height of the foundation wall above grade
       \\units m
          \\minimum 0
          \\default 0
   N5, \\field SlabDepth: Thickness of the floor slab
       \\units m
       \\default 0.1
   N6; \\field BaseDepth: Depth of the basement wall below grade
       \\units m
          \\minimum 0
          \\default 2

GroundHeatTransfer:Basement:ManualGrid,
    \\memo Manual Grid only necessary using manual gridding (not recommended)
       N1, \\field NX: Number of cells in the X direction: 20]
          \\minimum 1
          \\required-field
       N2, \\field NY: Number of cells in the Y direction: 20]
          \\minimum 1
          \\required-field
       N3, \\field NZAG: Number of cells in the Z direction. above grade: 4 Always]
          \\minimum 1
          \\required-field
       N4, \\field NZBG: Number of cells in Z direction. below grade: 10-35]
          \\minimum 1
          \\required-field
       N5, \\field IBASE: X direction cell indicator of slab edge: 5-20]
          \\required-field
       N6, \\field JBASE: Y direction cell indicator of slab edge: 5-20]
          \\required-field
       N7; \\field KBASE: Z direction cell indicator of the top of the floor slab: 5-20]
          \\required-field

GroundHeatTransfer:Basement:XFACE,
    \\memo This is only needed when using manual gridding (not recommended)
    \\memo XFACE: X Direction cell face coordinates: m
       N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12, N13, N14,  \\note fields as indicated
       N15, N16, N17, N18, N19, N20, N21, N22, N23, N24, N25, N26,   \\note fields as indicated
       N27, N28, N29, N30, N31, N32, N33, N34, N35, N36, N37, N38,   \\note fields as indicated
       N39, N40, N41, N42, N43, N44;                                 \\note fields as indicated

GroundHeatTransfer:Basement:YFACE,
    \\memo This is only needed when using manual gridding (not recommended)
    \\memo YFACE: Y Direction cell face coordinates: m
       N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12, N13, N14,  \\note fields as indicated
       N15, N16, N17, N18, N19, N20, N21, N22, N23, N24, N25, N26,   \\note fields as indicated
       N27, N28, N29, N30, N31, N32, N33, N34, N35, N36, N37, N38,   \\note fields as indicated
       N39, N40, N41, N42, N43, N44;                                 \\note fields as indicated

GroundHeatTransfer:Basement:ZFACE,
    \\memo This is only needed when using manual gridding (not recommended)
    \\memo ZFACE: Z Direction cell face coordinates: m
       N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12, N13, N14,  \\note fields as indicated
       N15, N16, N17, N18, N19, N20, N21, N22, N23, N24, N25, N26,   \\note fields as indicated
       N27, N28, N29, N30, N31, N32, N33, N34, N35, N36, N37, N38,   \\note fields as indicated
       N39, N40;                                                     \\note fields as indicated

\\group Room Air Models

RoomAirModelType,
      \\memo Selects the type of room air model to be used in a given zone. If no RoomAirModelType
      \\memo object is specified then the default Mixing model (all zone air at the same
      \\memo temperature) will be used.
  A1, \\field Name
      \\required-field
      \\type alpha
  A2, \\field Zone Name
      \\required-field
      \\type object-list
      \\object-list ZoneNames
  A3, \\field Room-Air Modeling Type
      \\required-field
      \\type choice
      \\key Mixing
      \\note Complete mixing air model
      \\key UserDefined
      \\note UserDefined Room Air Temperature Patterns
      \\note needs RoomAir:TemperaturePattern:UserDefined object referencing this Zone
      \\key OneNodeDisplacementVentilation
      \\note Mundt roomair model for displacement ventilation with single floor air node
      \\note needs RoomAirSettings:OneNodeDisplacementVentilation object referencing this Zone
      \\key ThreeNodeDisplacementVentilation
      \\note (UCSD three-node displacement ventilation model)
      \\note needs RoomAirSettings:ThreeNodeDisplacementVentilation object referencing this Zone
      \\key CrossVentilation
      \\note (UCSD two-zone cross ventilation model)
      \\note needs RoomAirSettings:CrossVentilation object referencing this Zone
      \\key UnderFloorAirDistributionInterior
      \\note 2-Node UFAD model for interior zones
      \\note needs RoomAirSettings:UnderFloorAirDistributionInterior object referencing this Zone
      \\key UnderFloorAirDistributionExterior
      \\note (2-Node UFAD model for exterior zones)
      \\note needs RoomAirSettings:UnderFloorAirDistributionExterior object referencing this Zone
      \\default Mixing
  A4; \\field Air Temperature Coupling Strategy
      \\type choice
      \\key Direct
      \\key Indirect
      \\default Direct

RoomAir:TemperaturePattern:UserDefined,
       \\memo Used to explicitly define temperature patterns that are to be applied to the mean air
       \\memo temperature within a thermal zone.  Used with RoomAirModelType = UserDefined.
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  A3 , \\field Availability Schedule Name
       \\note Availability schedule name for this model. Schedule value > 0 means the model is
       \\note active. Schedule value = 0 means the model is inactive and the zone will be modeled
       \\note as fully mixed (Mixing). If this field is blank, the model is always active.
       \\type object-list
       \\object-list ScheduleNames
  A4 ; \\field Pattern Control Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note The schedule should contain integer values that
       \\note correspond to unique Control Integer fields in
       \\note one of the RoomAir:TemperaturePattern:* objects.

RoomAir:TemperaturePattern:ConstantGradient,
      \\memo Used to model room air with a fixed temperature gradient in the vertical direction.
      \\memo Used in combination with RoomAir:TemperaturePattern:UserDefined.
  A1, \\field Name
      \\required-field
      \\type alpha
  N1, \\field Control Integer for Pattern Control Schedule Name
      \\note reference this entry in Schedule Name
      \\type integer
      \\required-field
  N2, \\field Thermostat Offset
      \\note = (Temp at thermostat- Mean Air Temp)
      \\units deltaC
      \\type real
  N3, \\field Return Air Offset
      \\note = (Tleaving - Mean Air Temp )
      \\units deltaC
      \\type real
  N4, \\field Exhaust Air Offset
      \\note = (Texhaust - Mean Air Temp) deg C
      \\units deltaC
      \\type real
  N5; \\field Temperature Gradient
      \\note Slope of temperature change in vertical direction
      \\units K/m
      \\type real

RoomAir:TemperaturePattern:TwoGradient,
      \\memo Used to model room air with two temperature gradients in the vertical direction.
      \\memo Used in combination with RoomAir:TemperaturePattern:UserDefined.
  A1, \\field Name
      \\required-field
      \\type alpha
  N1, \\field Control Integer for Pattern Control Schedule Name
      \\note reference this entry in Schedule Name
      \\type integer
      \\required-field
  N2, \\field Thermostat Height
      \\note = Distance from floor of zone
      \\units m
      \\type real
  N3, \\field Return Air Height
      \\note = Distance from floor of zone
      \\units m
      \\type real
  N4, \\field Exhaust Air Height
      \\note = Distance from floor of zone
      \\units m
      \\type real
  N5, \\field Temperature Gradient Lower Bound
      \\note Slope of temperature change in vertical direction
      \\units K/m
      \\type real
  N6, \\field Temperature Gradient Upper  Bound
      \\note Slope of temperature change in vertical direction
      \\units K/m
      \\type real
  A2, \\field Gradient Interpolation Mode
      \\type choice
      \\key OutdoorDryBulbTemperature
      \\key ZoneDryBulbTemperature
      \\key ZoneAndOutdoorTemperatureDifference
      \\key SensibleCoolingLoad
      \\key SensibleHeatingLoad
  N7, \\field Upper Temperature Bound
      \\units C
      \\type real
  N8, \\field Lower Temperature Bound
      \\units C
      \\type real
  N9, \\field Upper Heat Rate Bound
      \\units W
      \\type real
  N10; \\field Lower Heat Rate Bound
      \\units W
      \\type real

RoomAir:TemperaturePattern:NondimensionalHeight,
      \\memo Defines a distribution pattern for air temperatures relative to the current mean air
      \\memo temperature as a function of height. The height, referred to as Zeta, is non-dimensional
      \\memo by normalizing with the zone ceiling height.
      \\memo Used in combination with RoomAir:TemperaturePattern:UserDefined.
      \\extensible:2 - repeat last two fields remembering to remove ; from "inner" fields.
  A1, \\field Name
      \\required-field
      \\type alpha
  N1, \\field Control Integer for Pattern Control Schedule Name
      \\note this value should appear in as a schedule value
      \\type integer
      \\required-field
  N2, \\field Thermostat Offset
      \\note = (Temp at thermostat- Mean Air Temp)
      \\units deltaC
      \\type real
  N3, \\field Return Air Offset
      \\note = (Temp leaving - Mean Air Temp ) deg C
      \\units deltaC
      \\type real
  N4, \\field Exhaust Air Offset
      \\note = (Temp exhaust - Mean Air Temp) deg C
      \\units deltaC
      \\type real
      \\note the remaining fields have pairs that describe the relative
      \\note temperature pattern in the vertical direction of a zone
      \\note Zeta is the nondimensional height (in z-direction). on [0..1]
      \\note DeltaTai =  (Tai - MAT) in units of deg. C
      \\note relative deg C on [-10.0 .. 20.0 ]
  N5, \\field Pair 1 Zeta Nondimensional Height
      \\begin-extensible
      \\type real
      \\required-field
  N6, \\field Pair 1 Delta Adjacent Air Temperature
      \\type real
      \\required-field
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N7, \\field Pair 2 Zeta Nondimensional Height
      \\type real
      \\required-field
  N8, \\field Pair 2 Delta Adjacent Air Temperature
      \\type real
      \\required-field
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N9, \\field Pair 3 Zeta Nondimensional Height
      \\type real
  N10,\\field Pair 3 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N11,\\field Pair 4 Zeta Nondimensional Height
      \\type real
  N12,\\field Pair 4 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N13,\\field Pair 5 Zeta Nondimensional Height
      \\type real
  N14,\\field Pair 5 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N15,\\field Pair 6 Zeta Nondimensional Height
      \\type real
  N16,\\field Pair 6 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N17,\\field Pair 7 Zeta Nondimensional Height
      \\type real
  N18,\\field Pair 7 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N19,\\field Pair 8 Zeta Nondimensional Height
      \\type real
  N20,\\field Pair 8 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N21,\\field Pair 9 Zeta Nondimensional Height
      \\type real
  N22,\\field Pair 9 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N23,\\field Pair 10 Zeta Nondimensional Height
      \\type real
  N24,\\field Pair 10 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N25,\\field Pair 11 Zeta Nondimensional Height
      \\type real
  N26,\\field Pair 11 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N27,\\field Pair 12 Zeta Nondimensional Height
      \\type real
  N28,\\field Pair 12 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N29,\\field Pair 13 Zeta Nondimensional Height
      \\type real
  N30,\\field Pair 13 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N31,\\field Pair 14 Zeta Nondimensional Height
      \\type real
  N32,\\field Pair 14 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N33,\\field Pair 15 Zeta Nondimensional Height
      \\type real
  N34,\\field Pair 15 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N35,\\field Pair 16 Zeta Nondimensional Height
      \\type real
  N36,\\field Pair 16 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N37,\\field Pair 17 Zeta Nondimensional Height
      \\type real
  N38,\\field Pair 17 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N39,\\field Pair 18 Zeta Nondimensional Height
      \\type real
  N40,\\field Pair 18 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N41,\\field Pair 19 Zeta Nondimensional Height
      \\type real
  N42;\\field Pair 19 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0

RoomAir:TemperaturePattern:SurfaceMapping,
      \\memo Defines a distribution pattern for the air temperatures adjacent to individual surfaces.
      \\memo This allows controlling the adjacent air temperature on a surface-by-surface basis
      \\memo rather than by height. This allows modeling different adjacent air temperatures on
      \\memo the opposite sides of the zone. Used in combination with
      \\memo RoomAir:TemperaturePattern:UserDefined.
      \\extensible:2 - repeat last two fields remembering to remove ; from "inner" fields.
  A1, \\field Name
      \\required-field
      \\type alpha
  N1, \\field Control Integer for Pattern Control Schedule Name
      \\note reference this entry in schedule
      \\type integer
      \\required-field
  N2, \\field Thermostat Offset
      \\note = (Temp at thermostat- Mean Air Temp)
      \\units deltaC
  N3, \\field Return Air Offset
      \\note = (Tleaving - Mean Air Temp ) deg C
      \\units deltaC
  N4, \\field Exhaust Air Offset
      \\note = (Texhaust - Mean Air Temp) deg C
      \\units deltaC
  A2, \\field Surface Name Pair 1
      \\begin-extensible
      \\required-field
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N5, \\field Delta Adjacent Air Temperature Pair 1
      \\required-field
      \\type real
      \\units deltaC
  A3, \\field Surface Name Pair 2
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N6, \\field Delta Adjacent Air Temperature Pair 2
      \\type real
      \\units deltaC
  A4, \\field Surface Name Pair 3
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N7, \\field Delta Adjacent Air Temperature Pair 3
      \\type real
      \\units deltaC
  A5, \\field Surface Name Pair 4
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N8, \\field Delta Adjacent Air Temperature Pair 4
      \\type real
      \\units deltaC
  A6, \\field Surface Name Pair 5
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N9, \\field Delta Adjacent Air Temperature Pair 5
      \\type real
      \\units deltaC
  A7, \\field Surface Name Pair 6
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N10,\\field Delta Adjacent Air Temperature Pair 6
      \\type real
      \\units deltaC
  A8, \\field Surface Name Pair 7
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N11,\\field Delta Adjacent Air Temperature Pair 7
      \\type real
      \\units deltaC
  A9, \\field Surface Name Pair 8
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N12,\\field Delta Adjacent Air Temperature Pair 8
      \\type real
      \\units deltaC
  A10,\\field Surface Name Pair 9
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N13,\\field Delta Adjacent Air Temperature Pair 9
      \\type real
      \\units deltaC
  A11,\\field Surface Name Pair 10
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N14,\\field Delta Adjacent Air Temperature Pair 10
      \\type real
      \\units deltaC
  A12,\\field Surface Name Pair 11
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N15,\\field Delta Adjacent Air Temperature Pair 11
      \\type real
      \\units deltaC
  A13,\\field Surface Name Pair 12
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N16,\\field Delta Adjacent Air Temperature Pair 12
      \\type real
      \\units deltaC
  A14,\\field Surface Name Pair 13
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N17,\\field Delta Adjacent Air Temperature Pair 13
      \\type real
      \\units deltaC
  A15,\\field Surface Name Pair 14
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N18,\\field Delta Adjacent Air Temperature Pair 14
      \\type real
      \\units deltaC
  A16,\\field Surface Name Pair 15
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N19,\\field Delta Adjacent Air Temperature Pair 15
      \\type real
      \\units deltaC
  A17,\\field Surface Name Pair 16
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N20,\\field Delta Adjacent Air Temperature Pair 16
      \\type real
      \\units deltaC
  A18,\\field Surface Name Pair 17
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N21,\\field Delta Adjacent Air Temperature Pair 17
      \\type real
      \\units deltaC
  A19,\\field Surface Name Pair 18
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N22,\\field Delta Adjacent Air Temperature Pair 18
      \\type real
      \\units deltaC
  A20,\\field Surface Name Pair 19
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N23,\\field Delta Adjacent Air Temperature Pair 19
      \\type real
      \\units deltaC
  A21,\\field Surface Name Pair 20
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N24,\\field Delta Adjacent Air Temperature Pair 20
      \\type real
      \\units deltaC
  A22,\\field Surface Name Pair 21
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N25;\\field Delta Adjacent Air Temperature Pair 21
      \\type real
      \\units deltaC

RoomAir:Node,
      \\memo Define an air node for some types of nodal room air models
  A1, \\field Name
      \\type Alpha
  A2, \\field Node Type
      \\required-field
      \\type choice
      \\key Inlet
      \\key Floor
      \\key Control
      \\key Ceiling
      \\key MundtRoom
      \\key Return
  A3, \\field Zone Name
      \\required-field
      \\type object-list
      \\object-list ZoneNames
  N1, \\field Height of Nodal Control Volume Center
      \\required-field
      \\type real
      \\units m
  A4 , \\field Surface 1 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A5 , \\field Surface 2 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A6 , \\field Surface 3 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A7 , \\field Surface 4 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A8 , \\field Surface 5 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A9 , \\field Surface 6 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A10, \\field Surface 7 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A11, \\field Surface 8 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A12, \\field Surface 9 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A13, \\field Surface 10 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A14, \\field Surface 11 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A15, \\field Surface 12 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A16, \\field Surface 13 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A17, \\field Surface 14 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A18, \\field Surface 15 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A19, \\field Surface 16 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A20, \\field Surface 17 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A21, \\field Surface 18 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A22, \\field Surface 19 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A23, \\field Surface 20 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A24; \\field Surface 21 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames

RoomAirSettings:OneNodeDisplacementVentilation,
       \\memo The Mundt model for displacement ventilation
  A1 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  N1 , \\field Fraction of Convective Internal Loads Added to Floor Air
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  N2 ; \\field Fraction of Infiltration Internal Loads Added to Floor Air
       \\type real
       \\minimum 0.0
       \\maximum 1.0

RoomAirSettings:ThreeNodeDisplacementVentilation,
       \\memo The UCSD model for Displacement Ventilation
  A1 , \\field Zone Name
       \\note Name of Zone being described. Any existing zone name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  A2 , \\field Gain Distribution Schedule Name
       \\note Distribution of the convective heat gains between the occupied and mixed zones.
       \\note 0<= Accepted Value <= 1.
       \\note In the DV model 1 means all convective gains in the lower layer.
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
  N1 , \\field Number of Plumes per Occupant
       \\note Used only in the UCSD displacement ventilation model.
       \\note Effective number of separate plumes per occupant in the occupied zone.
       \\note Plumes that merge together in the occupied zone count as one.
       \\required-field
       \\type real
       \\minimum> 0.0
       \\default 1.0
  N2 , \\field Thermostat Height
       \\note Height of thermostat/temperature control sensor above floor
       \\units m
       \\type real
       \\minimum> 0.0
       \\default 1.1
  N3 , \\field Comfort Height
       \\note Height at which air temperature is calculated for comfort purposes
       \\units m
       \\type real
       \\minimum> 0.0
       \\default 1.1
  N4 ; \\field Temperature Difference Threshold for Reporting
       \\note Minimum temperature difference between predicted upper and lower layer
       \\note temperatures above which DV auxilliary outputs are calculated.
       \\note These outputs are 'DV Transition Height', 'DV Fraction Min Recommended Flow Rate'
       \\note 'DV Average Temp Gradient' and 'DV Maximum Temp Gradient'.  They
       \\note are set to negative values when the temperature difference is less than the
       \\note threshold and the output 'DV Zone Is Mixed' is set to 1
       \\units deltaC
       \\required-field
       \\type real
       \\minimum 0.0
       \\default 0.4

RoomAirSettings:CrossVentilation,
       \\memo This UCSD Cross Ventilation Room Air Model provides a simple model for heat transfer
       \\memo and vertical temperature profile prediction in cross ventilated rooms. The model
       \\memo distinguishes two regions in the room, the main jet region and the recirculations,
       \\memo and predicts characteristic airflow velocities and average air temperatures.
       \\memo Used with RoomAirModelType = CrossVentilation.
  A1 , \\field Zone Name
       \\note Name of Zone being described. Any existing zone name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  A2 , \\field Gain Distribution Schedule Name
       \\note Distribution of the convective heat gains between the jet and recirculation zones.
       \\note 0<= Accepted Value <= 1.
       \\note In the CV model 1 means all convective gains in the jet region.
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
  A3 ; \\field Airflow Region Used for Thermal Comfort Evaluation
       \\note Required field whenever thermal comfort is predicted
       \\note defines Air temperature and Airflow velocity that will be used in the Fanger model
       \\note conditions must refer to one of the two regions: jet or recirculation
       \\type choice
       \\key Jet
       \\key Recirculation

RoomAirSettings:UnderFloorAirDistributionInterior,
       \\memo This Room Air Model is applicable to interior spaces that are served by an underfloor
       \\memo air distribution system. The dominant sources of heat gain should be from people,
       \\memo equipment, and other localized sources located in the occupied part of the room.
       \\memo The model should be used with caution in zones which have large heat gains or losses
       \\memo through exterior walls or windows or which have considerable direct solar gain.
       \\memo Used with RoomAirModelType = UnderFloorAirDistributionInterior.
       \\min-fields 15
  A1 , \\field Zone Name
       \\note Name of Zone with underfloor air distribution
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  N1 , \\field Number of Diffusers
       \\note Total number of diffusers in this zone
       \\type real
       \\minimum> 0.0
       \\autocalculatable
       \\default autocalculate
  N2 , \\field Power per Plume
       \\type real
       \\minimum 0.0
       \\units W
       \\autocalculatable
       \\default autocalculate
  N3 , \\field Design Effective Area of Diffuser
       \\type real
       \\units m2
       \\minimum> 0.0
       \\autocalculatable
       \\default Autocalculate
  N4 , \\field Diffuser Slot Angle from Vertical
       \\type real
       \\units deg
       \\minimum 0.0
       \\maximum 90.
       \\autocalculatable
       \\default Autocalculate
  N5 , \\field Thermostat Height
       \\note Height of thermostat/temperature control sensor above floor
       \\units m
       \\type real
       \\minimum> 0.0
       \\default 1.2
  N6 , \\field Comfort Height
       \\note Height at which air temperature is calculated for comfort purposes
       \\units m
       \\type real
       \\minimum> 0.0
       \\default 1.1
  N7 , \\field Temperature Difference Threshold for Reporting
       \\note Minimum temperature difference between predicted upper and lower layer
       \\note temperatures above which UFAD auxilliary outputs are calculated.
       \\note These outputs are 'UF Transition Height'and 'UF Average Temp Gradient'.  They
       \\note are set to zero values when the temperature difference is less than the
       \\note threshold and the output 'UF Zone Is Mixed' is set to 1
       \\units deltaC
       \\required-field
       \\type real
       \\minimum 0.0
       \\default 0.4
  A2 , \\field Floor Diffuser Type
       \\required-field
       \\type choice
       \\key Custom
       \\key Swirl
       \\key VariableArea
       \\key HorizontalSwirl
       \\key LinearBarGrille
       \\default Swirl
  N8 , \\field Transition Height
       \\note user-specified height above floor of boundary between occupied and upper subzones
       \\type real
       \\units m
       \\minimum> 0.0
       \\autocalculatable
       \\default 1.7
  N9,  \\field Coefficient A
       \\note Coefficient A in Formula Kc = A*Gamma**B + C + D*Gamma + E*Gamma**2
       \\note Kc is the fraction of the total zone load attributable to the lower subzone
       \\type real
       \\autocalculatable
       \\default Autocalculate
  N10, \\field Coefficient B
       \\note Coefficient B in Formula Kc = A*Gamma**B + C + D*Gamma + E*Gamma**2
       \\note Kc is the fraction of the total zone load attributable to the lower subzone
       \\type real
       \\autocalculatable
       \\default Autocalculate
  N11, \\field Coefficient C
       \\note Coefficient C in Formula Kc = A*Gamma**B + C + D*Gamma + E*Gamma**2
       \\note Kc is the fraction of the total zone load attributable to the lower subzone
       \\type real
       \\autocalculatable
       \\default Autocalculate
  N12, \\field Coefficient D
       \\note Coefficient D in Formula Kc = A*Gamma**B + C + D*Gamma + E*Gamma**2
       \\note Kc is the fraction of the total zone load attributable to the lower subzone
       \\type real
       \\autocalculatable
       \\default Autocalculate
  N13; \\field Coefficient E
       \\note Coefficient E in Formula Kc = A*Gamma**B + C + D*Gamma + E*Gamma**2
       \\note Kc is the fraction of the total zone load attributable to the lower subzone
       \\type real
       \\autocalculatable
       \\default Autocalculate

RoomAirSettings:UnderFloorAirDistributionExterior,
       \\memo Applicable to exterior spaces that are served by an underfloor air distribution system.
       \\memo The dominant sources of heat gain should be from people, equipment, and other
       \\memo localized sources located in the occupied part of the room, as well as convective gain
       \\memo  coming from a warm window. Used with RoomAirModelType = CrossVentilation.
  \\min-fields 15
  A1 , \\field Zone Name
       \\note Name of Zone being described. Any existing zone name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  N1 , \\field Number of Diffusers per Zone
       \\type real
       \\minimum> 0.0
       \\autocalculatable
       \\default Autocalculate
  N2 , \\field Power per Plume
       \\type real
       \\minimum 0.0
       \\units W
       \\autocalculatable
       \\default autocalculate
  N3 , \\field Design Effective Area of Diffuser
       \\type real
       \\units m2
       \\minimum> 0.0
       \\autocalculatable
       \\default Autocalculate
  N4 , \\field Diffuser Slot Angle from Vertical
       \\type real
       \\units deg
       \\minimum 0.0
       \\maximum 90.
       \\autocalculatable
       \\default autocalculate
  N5 , \\field Thermostat Height
       \\note Height of thermostat/temperature control sensor above floor
       \\units m
       \\type real
       \\minimum> 0.0
       \\default 1.2
  N6 , \\field Comfort Height
       \\note Height at which Air temperature is calculated for comfort purposes
       \\units m
       \\type real
       \\minimum> 0.0
       \\default 1.1
  N7 , \\field Temperature Difference Threshold for Reporting
       \\note Minimum temperature difference between upper and lower layer
       \\note temperatures above which UFAD auxilliary outputs are calculated.
       \\note These outputs are 'UF Transition Height'and 'UF Average Temp Gradient'.  They
       \\note are set to zero values when the temperature difference is less than the
       \\note threshold and the output 'UF Zone Is Mixed' is set to 1
       \\units deltaC
       \\required-field
       \\type real
       \\minimum 0.0
       \\default 0.4
  A2 , \\field Floor Diffuser Type
       \\required-field
       \\type choice
       \\key Custom
       \\key Swirl
       \\key VariableArea
       \\key HorizontalSwirl
       \\key LinearBarGrille
       \\default Swirl
  N8 , \\field Transition Height
       \\note User-specified height above floor of boundary between occupied and upper subzones
       \\type real
       \\units m
       \\minimum> 0.0
       \\autocalculatable
       \\default 1.7
  N9,  \\field Coefficient A in formula Kc = A*Gamma**B + C + D*Gamma + E*Gamma**2
       \\note Kc is the fraction of the total zone load attributable to the lower subzone
       \\type real
       \\autocalculatable
       \\default Autocalculate
  N10, \\field Coefficient B in formula Kc = A*Gamma**B + C + D*Gamma + E*Gamma**2
       \\note Kc is the fraction of the total zone load attributable to the lower subzone
       \\type real
       \\autocalculatable
       \\default Autocalculate
  N11, \\field Coefficient C in formula Kc = A*Gamma**B + C + D*Gamma + E*Gamma**2
       \\note Kc is the fraction of the total zone load attributable to the lower subzone
       \\type real
       \\autocalculatable
       \\default Autocalculate
  N12, \\field Coefficient D in formula Kc = A*Gamma**B + C + D*Gamma + E*Gamma**2
       \\note Kc is the fraction of the total zone load attributable to the lower subzone
       \\type real
       \\autocalculatable
       \\default Autocalculate
  N13; \\field Coefficient E in formula Kc = A*Gamma**B + C + D*Gamma + E*Gamma**2
       \\note Kc is the fraction of the total zone load attributable to the lower subzone
       \\type real
       \\autocalculatable
       \\default Autocalculate

\\group Internal Gains

People,
   \\memo Sets internal gains and contaminant rates for occupants in the zone.
   \\memo If you use a ZoneList in the Zone or ZoneList name field then this definition applies
   \\memo to all the zones in the ZoneList.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference PeopleNames
  A2 , \\field Zone or ZoneList Name
       \\required-field
       \\type object-list
       \\object-list ZoneAndZoneListNames
  A3 , \\field Number of People Schedule Name
       \\required-field
       \\type object-list
       \\note units in schedule should be fraction applied to number of people (0.0 - 1.0)
       \\object-list ScheduleNames
  A4 , \\field Number of People Calculation Method
       \\note The entered calculation method is used to create the maximum number of people
       \\note for this set of attributes (i.e. sensible fraction, schedule, etc)
       \\note Choices: People -- simply enter number of occupants.
       \\note People per Zone Floor Area -- enter the number to apply.  Value * Floor Area = Number of people
       \\note Zone Floor Area per Person -- enter the number to apply.  Floor Area / Value = Number of people
       \\required-field
       \\type choice
       \\key People
       \\key People/Area
       \\key Area/Person
       \\default People
  N1 , \\field Number of People
       \\type real
       \\minimum 0
  N2 , \\field People per Zone Floor Area
       \\type real
       \\minimum 0
       \\units person/m2
  N3 , \\field Zone Floor Area per Person
       \\type real
       \\minimum 0
       \\units m2/person
  N4 , \\field Fraction Radiant
       \\required-field
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  N5,  \\field Sensible Heat Fraction
       \\note if input, overrides program calculated sensible/latent split
       \\autocalculatable
       \\default autocalculate
       \\minimum 0.0
       \\maximum 1.0
  A5 , \\field Activity Level Schedule Name
       \\required-field
       \\note Note that W has to be converted to mets in TC routine
       \\type object-list
       \\note units in schedule are W/person
       \\object-list ScheduleNames
  N6 , \\field Carbon Dioxide Generation Rate
       \\note CO2 generation rate per unit of activity level.
       \\type real
       \\units m3/s-W
       \\default 3.82E-8
       \\minimum 0.0
       \\maximum 3.82E-7
       \\note The default value is obtained from ASHRAE Std 62.1 at 0.0084 cfm/met/person over
       \\note the general adult population.
  A6 , \\field Enable ASHRAE 55 Comfort Warnings
       \\type choice
       \\key Yes
       \\key No
       \\default No
  A7 , \\field Mean Radiant Temperature Calculation Type
       \\note optional (only required for thermal comfort runs)
       \\type choice
       \\key ZoneAveraged
       \\key SurfaceWeighted
       \\key AngleFactor
       \\default ZoneAveraged
  A8 , \\field Surface Name/Angle Factor List Name
       \\type object-list
       \\object-list AllHeatTranAngFacNames
       \\note optional (only required for thermal comfort runs)
  A9 , \\field Work Efficiency Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note units in schedule are 0.0 to 1.0
       \\note optional (only required for thermal comfort runs)
  A10, \\field Clothing Insulation Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note use "Clo" from ASHRAE or Thermal Comfort guides
       \\note optional (only required for thermal comfort runs)
  A11, \\field Air Velocity Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note units in the schedule are m/s
       \\note optional (only required for thermal comfort runs)
  A12, \\field Thermal Comfort Model 1 Type
       \\type choice
       \\key Fanger
       \\key Pierce
       \\key KSU
       \\key AdaptiveASH55
       \\key AdaptiveCEN15251
       \\note optional (only needed for people thermal comfort results reporting)
  A13, \\field Thermal Comfort Model 2 Type
       \\type choice
       \\key Fanger
       \\key Pierce
       \\key KSU
       \\key AdaptiveASH55
       \\key AdaptiveCEN15251
       \\note optional (second type of thermal comfort model and results reporting)
  A14, \\field Thermal Comfort Model 3 Type
       \\type choice
       \\key Fanger
       \\key Pierce
       \\key KSU
       \\key AdaptiveASH55
       \\key AdaptiveCEN15251
       \\note optional (third thermal comfort model and report type)
  A15, \\field Thermal Comfort Model 4 Type
       \\type choice
       \\key Fanger
       \\key Pierce
       \\key KSU
       \\key AdaptiveASH55
       \\key AdaptiveCEN15251
       \\note optional (fourth thermal comfort model and report type)
  A16; \\field Thermal Comfort Model 5 Type
       \\type choice
       \\key Fanger
       \\key Pierce
       \\key KSU
       \\key AdaptiveASH55
       \\key AdaptiveCEN15251
       \\note optional (fifth thermal comfort model and report type)

ComfortViewFactorAngles,
       \\memo Used to specify radiant view factors for thermal comfort calculations.
  A1 , \\field Name
       \\type alpha
       \\reference AllHeatTranAngFacNames
  A2 , \\field Zone Name
       \\type object-list
       \\object-list ZoneNames
  A3 , \\field Surface 1 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N1 , \\field Angle Factor 1
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A4 , \\field Surface 2 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N2 , \\field Angle Factor 2
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A5 , \\field Surface 3 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N3 , \\field Angle Factor 3
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A6 , \\field Surface 4 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N4 , \\field Angle Factor 4
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A7 , \\field Surface 5 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N5 , \\field Angle Factor 5
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A8 , \\field Surface 6 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N6 , \\field Angle Factor 6
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A9 , \\field Surface 7 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N7 , \\field Angle Factor 7
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A10, \\field Surface 8 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N8 , \\field Angle Factor 8
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A11, \\field Surface 9 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N9 , \\field Angle Factor 9
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A12, \\field Surface 10 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N10, \\field Angle Factor 10
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A13, \\field Surface 11 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N11, \\field Angle Factor 11
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A14, \\field Surface 12 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N12, \\field Angle Factor 12
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A15, \\field Surface 13 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N13, \\field Angle Factor 13
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A16, \\field Surface 14 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N14, \\field Angle Factor 14
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A17, \\field Surface 15 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N15, \\field Angle Factor 15
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A18, \\field Surface 16 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N16, \\field Angle Factor 16
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A19, \\field Surface 17 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N17, \\field Angle Factor 17
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A20, \\field Surface 18 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N18, \\field Angle Factor 18
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A21, \\field Surface 19 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N19, \\field Angle Factor 19
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A22, \\field Surface 20 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N20; \\field Angle Factor 20
       \\type real
       \\minimum 0.0
       \\maximum 1.0

Lights,
   \\memo Sets internal gains for lights in the zone.
   \\memo If you use a ZoneList in the Zone or ZoneList name field then this definition applies
   \\memo to all the zones in the ZoneList.
       \\min-fields 10
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference LightsNames
  A2 , \\field Zone or ZoneList Name
       \\required-field
       \\type object-list
       \\object-list ZoneAndZoneListNames
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note units in schedule should be fraction applied to design level of lights, generally (0.0 - 1.0)
  A4 , \\field Design Level Calculation Method
       \\note The entered calculation method is used to create the maximum amount of lights
       \\note for this set of attributes
       \\note Choices: LightingLevel => Lighting Level -- simply enter watts of lights
       \\note Watts/Area => Watts per Zone Floor Area -- enter the number to apply.  Value * Floor Area = Lights
       \\note Watts/Person => Watts per Person -- enter the number to apply.  Value * Occupants = Lights
       \\required-field
       \\type choice
       \\key LightingLevel
       \\key Watts/Area
       \\key Watts/Person
       \\default LightingLevel
  N1 , \\field Lighting Level
       \\units W
       \\type real
       \\minimum 0
       \\ip-units W
  N2 , \\field Watts per Zone Floor Area
       \\type real
       \\minimum 0
       \\units W/m2
       \\ip-units W/ft2
  N3 , \\field Watts per Person
       \\type real
       \\minimum 0
       \\units W/person
       \\ip-units W/person
  N4 , \\field Return Air Fraction
       \\required-field
       \\note Used only for sizing calculation if return-air-fraction
       \\note coefficients are specified.
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N5 , \\field Fraction Radiant
       \\required-field
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N6 , \\field Fraction Visible
       \\required-field
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N7 , \\field Fraction Replaceable
       \\required-field
       \\note For Daylighting:Controls and Daylighting:DElight:Controls,
       \\note must be 0 or 1:  0 = no dimming control, 1 = full dimming control
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 1.0
  A5 , \\field End-Use Subcategory
       \\type alpha
       \\retaincase
       \\default General
  A6 , \\field Return Air Fraction Calculated from Plenum Temperature
       \\type choice
       \\key Yes
       \\key No
       \\default No
  N8 , \\field Return Air Fraction Function of Plenum Temperature Coefficient 1
       \\note Used only if Return Air Fraction Is Calculated from Plenum Temperature = Yes
       \\note Equation is Return Air Fraction = Coefficient#1 - Coefficient#2 X PlenumTemp(degC)
       \\type real
       \\minimum 0.0
       \\default 0.0
  N9 ; \\field Return Air Fraction Function of Plenum Temperature Coefficient 2
       \\note Used only if Return Air Fraction Is Calculated from Plenum Temperature = Yes
       \\note Equation is Return Air Fraction = Coefficient#1 - Coefficient#2 X PlenumTemp(degC)
       \\type real
       \\units 1/K
       \\minimum 0.0
       \\default 0.0

ElectricEquipment,
   \\memo Sets internal gains for electric equipment in the zone.
   \\memo If you use a ZoneList in the Zone or ZoneList name field then this definition applies
   \\memo to all the zones in the ZoneList.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ElectricEquipmentNames
  A2 , \\field Zone or ZoneList Name
       \\required-field
       \\type object-list
       \\object-list ZoneAndZoneListNames
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note units in schedule should be fraction applied to design level of electric equipment, generally (0.0 - 1.0)
  A4 , \\field Design Level Calculation Method
       \\note The entered calculation method is used to create the maximum amount of electric equipment
       \\note for this set of attributes
       \\note Choices: EquipmentLevel => Equipment Level -- simply enter watts of equipment
       \\note Watts/Area => Watts per Zone Floor Area -- enter the number to apply.  Value * Floor Area = Equipment Level
       \\note Watts/Person => Watts per Person -- enter the number to apply.  Value * Occupants = Equipment Level
       \\required-field
       \\type choice
       \\key EquipmentLevel
       \\key Watts/Area
       \\key Watts/Person
       \\default EquipmentLevel
  N1 , \\field Design Level
       \\units W
       \\type real
       \\minimum 0
       \\ip-units W
  N2 , \\field Watts per Zone Floor Area
       \\type real
       \\minimum 0
       \\units W/m2
       \\ip-units W/ft2
  N3 , \\field Watts per Person
       \\type real
       \\minimum 0
       \\units W/person
       \\ip-units W/person
  N4 , \\field Fraction Latent
       \\required-field
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N5 , \\field Fraction Radiant
       \\required-field
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N6 , \\field Fraction Lost
       \\required-field
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  A5 ; \\field End-Use Subcategory
       \\type alpha
       \\retaincase
       \\default General

GasEquipment,
   \\memo Sets internal gains and contaminant rates for gas equipment in the zone.
   \\memo If you use a ZoneList in the Zone name field then this definition applies to all those zones.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference GasEquipmentNames
  A2 , \\field Zone or ZoneList Name
       \\required-field
       \\type object-list
       \\object-list ZoneAndZoneListNames
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note units in Schedule should be fraction applied to design level of gas equipment, generally (0.0 - 1.0)
  A4 , \\field Design Level Calculation Method
       \\note The entered calculation method is used to create the maximum amount of gas equipment
       \\note for this set of attributes
       \\note Choices: EquipmentLevel => Design Level -- simply enter power input of equipment
       \\note Watts/Area or Power/Area => Power per Zone Floor Area -- enter the number to apply.  Value * Floor Area = Equipment Level
       \\note Watts/Person or Power/Person => Power per Person -- enter the number to apply.  Value * Occupants = Equipment Level
       \\required-field
       \\type choice
       \\key EquipmentLevel
       \\key Watts/Area
       \\key Watts/Person
       \\key Power/Area
       \\key Power/Person
       \\default EquipmentLevel
  N1 , \\field Design Level
       \\units W
       \\type real
       \\minimum 0
       \\ip-units Btu/h
  N2 , \\field Power per Zone Floor Area
       \\type real
       \\minimum 0
       \\units W/m2
       \\ip-units Btu/h-ft2
  N3 , \\field Power per Person
       \\type real
       \\minimum 0
       \\units W/Person
       \\ip-units Btu/h-person
  N4 , \\field Fraction Latent
       \\required-field
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N5 , \\field Fraction Radiant
       \\required-field
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N6 , \\field Fraction Lost
       \\required-field
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N7 , \\field Carbon Dioxide Generation Rate
       \\note CO2 generation rate per unit of power input
       \\type real
       \\units m3/s-W
       \\ip-units (ft3/min)/(Btu/h)
       \\default 0.0
       \\minimum 0.0
       \\maximum 4.0E-7
       \\note The default value assumes the equipment is fully vented.
       \\note For unvented equipment, a suggested value is 3.45E-8 m3/s-W. This value is
       \\note converted from a natural gas CO2 emission rate of 117 lbs CO2 per million Btu.
       \\note The maximum value assumes to be 10 times of the recommended value.
  A5 ; \\field End-Use Subcategory
       \\type alpha
       \\retaincase
       \\default General

HotWaterEquipment,
   \\memo Sets internal gains for hot water equipment in the zone.
   \\memo If you use a ZoneList in the Zone name field then this definition applies to all those zones.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference HotWaterEquipmentNames
  A2 , \\field Zone or ZoneList Name
       \\required-field
       \\type object-list
       \\object-list ZoneAndZoneListNames
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note units in Schedule should be fraction applied to design level of hot water equipment, generally (0.0 - 1.0)
  A4 , \\field Design Level Calculation Method
       \\note The entered calculation method is used to create the maximum amount of hot water equipment
       \\note for this set of attributes
       \\note Choices: EquipmentLevel => Design Level -- simply enter power input of equipment
       \\note Watts/Area or Power/Area => Power per Zone Floor Area -- enter the number to apply.  Value * Floor Area = Equipment Level
       \\note Watts/Person or Power/Person => Power per Person -- enter the number to apply.  Value * Occupants = Equipment Level
       \\required-field
       \\type choice
       \\key EquipmentLevel
       \\key Watts/Area
       \\key Watts/Person
       \\key Power/Area
       \\key Power/Person
       \\default EquipmentLevel
  N1 , \\field Design Level
       \\units W
       \\type real
       \\minimum 0
       \\ip-units Btu/h
  N2 , \\field Power per Zone Floor Area
       \\type real
       \\minimum 0
       \\units W/m2
       \\ip-units Btu/h-ft2
  N3 , \\field Power per Person
       \\type real
       \\minimum 0
       \\units W/Person
       \\ip-units Btu/h-person
  N4 , \\field Fraction Latent
       \\required-field
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N5 , \\field Fraction Radiant
       \\required-field
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N6 , \\field Fraction Lost
       \\required-field
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  A5 ; \\field End-Use Subcategory
       \\type alpha
       \\retaincase
       \\default General

SteamEquipment,
   \\memo Sets internal gains for steam equipment in the zone.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SteamEquipmentNames
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note units in Schedule should be fraction applied to design level of steam equipment, generally (0.0 - 1.0)
  A4 , \\field Design Level Calculation Method
       \\note The entered calculation method is used to create the maximum amount of steam equipment
       \\note for this set of attributes
       \\note Choices: EquipmentLevel => Design Level -- simply enter power input of equipment
       \\note Watts/Area or Power/Area => Power per Zone Floor Area -- enter the number to apply.  Value * Floor Area = Equipment Level
       \\note Watts/Person or Power/Person => Power per Person -- enter the number to apply.  Value * Occupants = Equipment Level
       \\required-field
       \\type choice
       \\key EquipmentLevel
       \\key Watts/Area
       \\key Watts/Person
       \\key Power/Area
       \\key Power/Person
       \\default EquipmentLevel
  N1 , \\field Design Level
       \\units W
       \\type real
       \\minimum 0
       \\ip-units Btu/h
  N2 , \\field Power per Zone Floor Area
       \\type real
       \\minimum 0
       \\units W/m2
       \\ip-units Btu/h-ft2
  N3 , \\field Power per Person
       \\type real
       \\minimum 0
       \\units W/Person
       \\ip-units Btu/h-person
  N4 , \\field Fraction Latent
       \\required-field
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N5 , \\field Fraction Radiant
       \\required-field
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N6 , \\field Fraction Lost
       \\required-field
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  A5 ; \\field End-Use Subcategory
       \\type alpha
       \\retaincase
       \\default General

OtherEquipment,
   \\memo Sets internal gains or losses for "other" equipment in the zone.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference OtherEquipmentNames
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note units in Schedule should be fraction applied to design level of other equipment, generally (0.0 - 1.0)
  A4 , \\field Design Level Calculation Method
       \\note The entered calculation method is used to create the maximum amount of other equipment.
       \\note to set a loss, use a negative value in the following fields.
       \\note for this set of attributes
       \\note Choices: EquipmentLevel => Design Level -- simply enter power input of equipment
       \\note Watts/Area or Power/Area => Power per Zone Floor Area -- enter the number to apply.  Value * Floor Area = Equipment Level
       \\note Watts/Person or Power/Person => Power per Person -- enter the number to apply.  Value * Occupants = Equipment Level
       \\required-field
       \\type choice
       \\key EquipmentLevel
       \\key Watts/Area
       \\key Watts/Person
       \\key Power/Area
       \\key Power/Person
       \\default EquipmentLevel
  N1 , \\field Design Level
       \\units W
       \\type real
       \\ip-units Btu/h
  N2 , \\field Power per Zone Floor Area
       \\type real
       \\units W/m2
       \\ip-units Btu/h-ft2
  N3 , \\field Power per Person
       \\type real
       \\units W/Person
       \\ip-units Btu/h-person
  N4 , \\field Fraction Latent
       \\required-field
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N5 , \\field Fraction Radiant
       \\required-field
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N6 ; \\field Fraction Lost
       \\required-field
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0

ZoneBaseboard:OutdoorTemperatureControlled,
       \\memo Specifies outside temperature-controlled electric baseboard heating.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference BaseboardHeatNames
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note units in Schedule should be fraction applied to capacity of the baseboard heat equipment, generally (0.0 - 1.0)
  N1 , \\field Capacity at Low Temperature
       \\required-field
       \\type real
       \\units W
       \\minimum> 0
  N2 , \\field Low Temperature
       \\required-field
       \\units C
       \\type real
  N3 , \\field Capacity at High Temperature
       \\required-field
       \\type real
       \\units W
       \\minimum 0
  N4 , \\field High Temperature
       \\required-field
       \\units C
       \\type real
  N5 , \\field Fraction Radiant
       \\required-field
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  A4 ; \\field End-Use Subcategory
       \\type alpha
       \\retaincase
       \\default General

ZoneContaminantSourceAndSink:CarbonDioxide,
   \\memo Represents internal CO2 gains and sinks in the zone.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference CO2GenerationNames
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  N1 , \\field Design Generation Rate
       \\units m3/s
       \\type real
       \\Note Positive values represent sources and negative values represent sinks.
  A3 ; \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note Value in this schedule should be a fraction (generally 0.0 - 1.0) applied to the Design Generation Rate

ZoneContaminantSourceAndSink:Generic:Constant,
   \\memo Sets internal generic contaminant gains and sinks in a zone with constant values.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference GenericContaminantSourceAndSinkNames
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  N1 , \\field Design Generation Rate
       \\units m3/s
       \\type real
       \\minimum 0.0
       \\Note The values represent source.
  A3 , \\field Generation Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note Value in this schedule should be a fraction (generally 0.0 - 1.0) applied to the Design Generation Rate
  N2 , \\field Design Removal Coefficient
       \\units m3/s
       \\type real
       \\minimum 0.0
       \\Note The value represent sink.
  A4 ; \\field Removal Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note Value in this schedule should be a fraction (generally 0.0 - 1.0) applied to the
       \\note Design removal Coefficient

SurfaceContaminantSourceAndSink:Generic:PressureDriven,
   \\memo Simulate generic contaminant source driven by the pressure difference across a surface.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference GenericContaminantGenerationNames
  A2 , \\field Surface Name
       \\required-field
       \\type object-list
       \\object-list SurfAndSubSurfNames
  N1 , \\field Design Generation Rate Coefficient
       \\units m3/s
       \\type real
       \\minimum 0.0
  A3 , \\field Generation Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note Value in this schedule should be a fraction (generally 0.0 - 1.0) applied to the
       \\note Design Generation Rate Coefficient
  N2 ; \\field Generation Exponent
       \\units dimensionless
       \\type real
       \\minimum> 0.0
       \\maximum 1.0

ZoneContaminantSourceAndSink:Generic:CutoffModel,
   \\memo Simulate generic contaminant source driven by the cutoff concentration model.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference GenericContaminantGenerationNames
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  N1 , \\field Design Generation Rate Coefficient
       \\units m3/s
       \\type real
       \\minimum 0.0
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note Value in this schedule should be a fraction (generally 0.0 - 1.0) applied to the
       \\note Design Generation Rate Coefficient
  N2 ; \\field Cutoff Generic Contaminant at which Emission Ceases
       \\units ppm
       \\type real
       \\minimum> 0.0
       \\note When the zone concentration level is greater than the cutoff level, emission stops,
       \\note and the source level is zero.

ZoneContaminantSourceAndSink:Generic:DecaySource,
   \\memo Simulate generic contaminant source driven by the cutoff concentration model.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference GenericContaminantGenerationNames
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  N1 , \\field Initial Emission Rate
       \\units m3/s
       \\type real
       \\minimum 0.0
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note Value in this schedule should be a fraction (generally 0.0 - 1.0) applied to the
       \\note Initial Emission Rate. When the value is equal to 1.0, the time will be reset to
       \\note zero.
  N2 ; \\field Delay Time Constant
       \\units s
       \\type real
       \\minimum> 0.0

SurfaceContaminantSourceAndSink:Generic:BoundaryLayerDiffusion,
   \\memo Simulate generic contaminant source driven by the boundary layer diffusion controlled model.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference GenericContaminantGenerationNames
  A2 , \\field Surface Name
       \\required-field
       \\type object-list
       \\object-list SurfaceNames
  N1 , \\field Mass Transfer Coefficient
       \\units m/s
       \\type real
       \\minimum 0.0
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note Value in this schedule should be a fraction (generally 0.0 - 1.0) applied to the
       \\note Initial Emission Rate. When the value is equal to 1.0, the time will be reset to
       \\note zero.
  N2 ; \\field Henry adsorption constant or partition coefficient
       \\units dimensionless
       \\type real
       \\minimum> 0.0

SurfaceContaminantSourceAndSink:Generic:DepositionVelocitySink,
   \\memo Simulate generic contaminant source driven by the boundary layer diffusion controlled model.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference GenericContaminantGenerationNames
  A2 , \\field Surface Name
       \\required-field
       \\type object-list
       \\object-list SurfaceNames
  N1 , \\field Deposition Velocity
       \\units m/s
       \\type real
       \\minimum 0.0
  A3 ; \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note Value in this schedule should be a fraction (generally 0.0 - 1.0) applied to the
       \\note Initial Emission Rate. When the value is equal to 1.0, the time will be reset to
       \\note zero.

ZoneContaminantSourceAndSink:Generic:DepositionRateSink,
   \\memo Simulate generic contaminant source driven by the boundary layer diffusion controlled model.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference GenericContaminantGenerationNames
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  N1 , \\field Deposition Rate
       \\units m/s
       \\type real
       \\minimum 0.0
  A3 ; \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note Value in this schedule should be a fraction (generally 0.0 - 1.0) applied to the
       \\note Initial Emission Rate. When the value is equal to 1.0, the time will be reset to
       \\note zero.

\\group Daylighting

Daylighting:Controls,
       \\min-fields 19
       \\memo Dimming of overhead electric lighting is determined from
       \\memo interior daylight illuminance calculated at one or two reference points.
       \\memo reference points are given in coordinates specified in the GlobalGeometryRules object
       \\memo Daylighting Reference Point CoordinateSystem field
       \\memo Glare from daylighting is also calculated.
  A1 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  N1 , \\field Total Daylighting Reference Points
       \\type integer
       \\minimum 1
       \\maximum 2
       \\default 1
  N2 , \\field X-Coordinate of First Reference Point
       \\units m
       \\required-field
       \\type real
  N3 , \\field Y-Coordinate of First Reference Point
       \\units m
       \\required-field
       \\type real
  N4 , \\field Z-Coordinate of First Reference Point
       \\units m
       \\default 0.8
       \\type real
  N5 , \\field X-Coordinate of Second Reference Point
       \\units m
       \\type real
       \\note Required if Total Daylighting Reference Points = 2
  N6 , \\field Y-Coordinate of Second Reference Point
       \\units m
       \\type real
       \\note Required if Total Daylighting Reference Points = 2
  N7 , \\field Z-Coordinate of Second Reference Point
       \\units m
       \\type real
       \\minimum 0.0
       \\default 0.8
  N8 , \\field Fraction of Zone Controlled by First Reference Point
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 1.0
  N9 , \\field Fraction of Zone Controlled by Second Reference Point
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  N10, \\field Illuminance Setpoint at First Reference Point
       \\units lux
       \\type real
       \\minimum 0.0
       \\default 500
  N11, \\field Illuminance Setpoint at Second Reference Point
       \\units lux
       \\type real
       \\minimum 0.0
       \\default 500
  N12, \\field Lighting Control Type
       \\type integer
       \\minimum 1
       \\maximum 3
       \\note 1=continuous,2=stepped,3=continuous/off
       \\default 1
  N13, \\field Glare Calculation Azimuth Angle of View Direction Clockwise from Zone y-Axis
       \\required-field
       \\units deg
       \\minimum 0
       \\maximum 360
  N14, \\field Maximum Allowable Discomfort Glare Index
       \\type real
       \\minimum 1
       \\note The default is for general office work
       \\default 22
  N15, \\field Minimum Input Power Fraction for Continuous Dimming Control
       \\type real
       \\minimum 0.0
       \\maximum 0.6
       \\default 0.3
  N16, \\field Minimum Light Output Fraction for Continuous Dimming Control
       \\type real
       \\minimum 0.0
       \\maximum 0.6
       \\default 0.2
  N17, \\field Number of Stepped Control Steps
       \\note for Lighting Control Type=2, this field cannot be zero.
       \\type integer
       \\default 1
  N18, \\field Probability Lighting will be Reset When Needed in Manual Stepped Control
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 1.0
  A2 ; \\field Availability Schedule Name
       \\type object-list
       \\object-list ScheduleNames

Daylighting:DELight:Controls,
       \\min-fields 8
       \\memo Dimming of overhead electric lighting is determined from
       \\memo DElight calculated interior daylight illuminance at one or more reference points.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference DElightZoneNames
  A2 , \\field Zone Name
       \\note Name of Thermal Zone hosting the given DElight Zone
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  N1 , \\field Lighting Control Type
       \\type integer
       \\minimum 1
       \\maximum 3
       \\note 1=continuous,2=stepped,3=continuous/off
       \\default 1
  N2 , \\field Minimum Input Power Fraction for Continuous Dimming Control
       \\type real
       \\minimum 0.0
       \\maximum 0.6
       \\default 0.3
  N3 , \\field Minimum Light Output Fraction for Continuous Dimming Control
       \\type real
       \\minimum 0.0
       \\maximum 0.6
       \\default 0.2
  N4 , \\field Number of Stepped Control Steps
       \\type integer
       \\note for Lighting Control Type=2, this field cannot be zero.
       \\default 1
  N5 , \\field Probability Lighting will be Reset When Needed in Manual Stepped Control
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  N6;  \\field Gridding Resolution
       \\units m2
       \\type real
       \\note Maximum surface area for nodes in gridding all surfaces in the DElight zone.
       \\note All reflective and transmitting surfaces will be subdivided
       \\note into approximately square nodes that do not exceed this maximum.
       \\note Higher resolution subdivisions require greater calculation times,
       \\note but generally produce more accurate results.
       \\minimum> 0.0

Daylighting:DELight:ReferencePoint,
       \\min-fields 7
       \\memo DElight reference point for illuminance calculation and electric lighting dimming.
       \\memo reference points are given in coordinates specified in the GlobalGeometryRules object
       \\memo Daylighting Reference Point CoordinateSystem field
       \\memo There is a maximum number of 100 reference points per DElight daylighting zone.
  A1 , \\field Name
       \\type alpha
  A2 , \\field DElight Name
       \\required-field
       \\type object-list
       \\object-list DElightZoneNames
  N1 , \\field X-coordinate of Reference Point
       \\required-field
       \\units m
       \\type real
  N2,  \\field Y-coordinate of Reference Point
       \\required-field
       \\units m
       \\type real
  N3,  \\field Z-coordinate of Reference Point
       \\required-field
       \\units m
       \\type real
  N4 , \\field Fraction of Zone Controlled by Reference Point
       \\required-field
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 1.0
  N5;  \\field Illuminance Setpoint at Reference Point
       \\required-field
       \\units lux
       \\type real
       \\minimum 0.0
       \\default 500

Daylighting:DELight:ComplexFenestration,
       \\min-fields 5
       \\memo Used for DElight Complex Fenestration of all types
  A1,  \\field Name
       \\required-field
       \\note Only used for user reference
       \\type alpha
  A2,  \\field Complex Fenestration Type
       \\required-field
       \\note Used to select the appropriate Complex Fenestration BTDF data
       \\type alpha
  A3,  \\field Building Surface Name
       \\required-field
       \\note This is a reference to a valid surface object (such as BuildingSurface:Detailed) hosting
       \\note this complex fenestration, analogous to the base surface Name
       \\note field for subsurfaces such as Windows.
       \\type object-list
       \\object-list SurfaceNames
  A4,  \\field Window Name
       \\required-field
       \\note This is a reference to a valid FenestrationSurface:Detailed window object
       \\note used to account for the geometry, and the solar and thermal gains/losses,
       \\note of the Complex Fenestration
       \\type object-list
       \\object-list SubSurfNames
  N1;  \\field Fenestration Rotation
       \\units deg
       \\type real
       \\note In-plane counter-clockwise rotation angle of the Complex Fenestration
       \\note optical reference direction and the base edge of the Complex Fenestration.
       \\note The Rotation will typically be zero when the host and CFS surfaces
       \\note are rectangular and height and width edges are aligned.
       \\default 0.0

DaylightingDevice:Tubular,
       \\memo Defines a tubular daylighting device (TDD) consisting of three components:
       \\memo a dome, a pipe, and a diffuser. The dome and diffuser are defined separately using the
       \\memo FenestrationSurface:Detailed object.
       \\extensible:2 Duplicate the last two fields Transition Zone Name and Transition Zone Length
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Dome Name
       \\note This must refer to a subsurface object of type TubularDaylightDome
       \\required-field
       \\type object-list
       \\object-list SubSurfNames
  A3 , \\field Diffuser Name
       \\note This must refer to a subsurface object of type TubularDaylightDiffuser
       \\note Delivery zone is specified in the diffuser object
       \\required-field
       \\type object-list
       \\object-list SubSurfNames
  A4 , \\field Construction Name
       \\required-field
       \\type object-list
       \\object-list ConstructionNames
  N1 , \\field Diameter
       \\required-field
       \\units m
       \\type real
       \\minimum> 0
  N2 , \\field Total Length
       \\note The exterior exposed length is the difference between total and sum of zone lengths
       \\required-field
       \\units m
       \\type real
       \\minimum> 0
  N3 , \\field Effective Thermal Resistance
       \\note R value between TubularDaylightDome and TubularDaylightDiffuser
       \\required-field
       \\units m2-K/W
       \\type real
       \\minimum> 0
       \\default 0.28
  A5 , \\field Transition Zone 1 Name
       \\begin-extensible
       \\type object-list
       \\object-list ZoneNames
  N4 , \\field Transition Zone 1 Length
       \\units m
       \\type real
       \\minimum 0.0
  A6 , \\field Transition Zone 2 Name
       \\type object-list
       \\object-list ZoneNames
  N5 , \\field Transition Zone 2 Length
       \\units m
       \\type real
       \\minimum 0.0
  A7 , \\field Transition Zone 3 Name
       \\type object-list
       \\object-list ZoneNames
  N6 , \\field Transition Zone 3 Length
       \\units m
       \\type real
       \\minimum 0.0
  A8 , \\field Transition Zone 4 Name
       \\type object-list
       \\object-list ZoneNames
  N7; \\field Transition Zone 4 Length
       \\units m
       \\type real
       \\minimum 0.0

DaylightingDevice:Shelf,
       \\memo Defines a daylighting which can have an inside shelf, an outside shelf, or both.
       \\memo The inside shelf is defined as a building surface and the outside shelf is defined
       \\memo as a shading surface.
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Window Name
       \\required-field
       \\type object-list
       \\object-list SubSurfNames
  A3 , \\field Inside Shelf Name
       \\note This must refer to a BuildingSurface:Detailed or equivalent object
       \\note This surface must be its own Surface for other side boundary conditions.
       \\type object-list
       \\object-list SurfaceNames
  A4 , \\field Outside Shelf Name
       \\note This must refer to a Shading:Zone:Detailed object
       \\type object-list
       \\object-list AttachedShadingSurfNames
  A5 , \\field Outside Shelf Construction Name
       \\note Required if outside shelf is specified
       \\type object-list
       \\object-list ConstructionNames
  N1 ; \\field View Factor to Outside Shelf
       \\type real
       \\minimum 0.0
       \\maximum 1.0

DaylightingDevice:LightWell,
       \\min-fields 5
       \\memo Applies only to exterior windows in daylighting-controlled zones or
       \\memo in zones that share an interior window with a daylighting-controlled  zone.
       \\memo Generally used with skylights.
  A1,  \\field Exterior Window Name
       \\required-field
       \\type alpha
       \\object-list SubSurfNames
  N1,  \\field Height of Well
       \\note Distance from Bottom of Window to Bottom of Well
       \\required-field
       \\type real
       \\units m
       \\minimum 0.0
  N2,  \\field Perimeter of Bottom of Well
       \\required-field
       \\units m
       \\type real
       \\minimum> 0.0
  N3,  \\field Area of Bottom of Well
       \\required-field
       \\type real
       \\units m2
       \\minimum> 0.0
  N4;  \\field Visible Reflectance of Well Walls
       \\required-field
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0

Output:DaylightFactors,
   \\memo Reports hourly daylight factors for each exterior window for four sky types
   \\memo (clear, turbid clear, intermediate, and overcast).
  \\format singleLine
   A1;  \\field Reporting Days
   \\required-field
   \\type choice
   \\key SizingDays
   \\key AllShadowCalculationDays

Output:IlluminanceMap,
   \\min-fields 9
   \\memo reference points are given in coordinates specified in the GlobalGeometryRules object
   \\memo Daylighting Reference Point CoordinateSystem field
  A1 , \\field Name
       \\required-field
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  N1 , \\field Z height
       \\units m
       \\type real
       \\default 0.0
  N2 , \\field X Minimum Coordinate
       \\units m
       \\type real
       \\default 0.0
  N3 , \\field X Maximum Coordinate
       \\units m
       \\type real
       \\default 1.0
  N4 , \\field Number of X Grid Points
       \\note Maximum number of total grid points must be <= 2500 (X*Y)
       \\type integer
       \\minimum> 0
       \\default 2
  N5 , \\field Y Minimum Coordinate
       \\units m
       \\type real
       \\default 0.0
  N6 , \\field Y Maximum Coordinate
       \\units m
       \\type real
       \\default 1.0
  N7 ; \\field Number of Y Grid Points
       \\note Maximum number of total grid points must be <= 2500 (X*Y)
       \\type integer
       \\minimum> 0
       \\default 2

OutputControl:IlluminanceMap:Style,
       \\memo default style for the Daylighting Illuminance Map is comma -- this works well for
       \\memo importing into spreadsheet programs such as Excel(tm) but not so well for word
       \\memo processing progams -- there tab may be a better choice.  fixed puts spaces between
       \\memo the "columns"
       \\unique-object
   A1; \\field Column Separator
       \\type choice
       \\key Comma
       \\key Tab
       \\key Fixed
       \\default Comma

\\group Zone Airflow

ZoneInfiltration:DesignFlowRate,
       \\memo  Infiltration is specified as a design level which is modified by a Schedule fraction, temperature difference and wind speed:
       \\memo  Infiltration=Idesign * FSchedule * (A + B*|(Tzone-Todb)| + C*WindSpd + D * WindSpd**2)
       \\memo If you use a ZoneList in the Zone or ZoneList name field then this definition applies
       \\memo to all the zones in the ZoneList.
       \\min-fields 12
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Zone or ZoneList Name
       \\required-field
       \\type object-list
       \\object-list ZoneAndZoneListNames
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
  A4 , \\field Design Flow Rate Calculation Method
       \\note The entered calculation method is used to create the maximum amount of infiltration
       \\note for this set of attributes
       \\note Choices: Flow/Zone => Design Flow Rate -- simply enter Design Flow Rate
       \\note Flow/Area => Flow per Zone Floor Area - Value * Floor Area (zone) = Design Flow Rate
       \\note Flow/ExteriorArea => Flow per Exterior Surface Area - Value * Exterior Surface Area (zone) = Design Flow Rate
       \\note Flow/ExteriorWallArea => Flow per Exterior Surface Area - Value * Exterior Wall Surface Area (zone) = Design Flow Rate
       \\note AirChanges/Hour => Air Changes per Hour - Value * Floor Volume (zone) adjusted for m3/s = Design Volume Flow Rate
       \\note  "Idesign" in Equation is the result.
       \\required-field
       \\type choice
       \\key Flow/Zone
       \\key Flow/Area
       \\key Flow/ExteriorArea
       \\key Flow/ExteriorWallArea
       \\key AirChanges/Hour
       \\default Flow/Zone
  N1 , \\field Design Flow Rate
       \\units m3/s
       \\type real
       \\minimum 0
       \\ip-units ft3/min
  N2 , \\field Flow per Zone Floor Area
       \\type real
       \\minimum 0
       \\units m3/s-m2
  N3 , \\field Flow per Exterior Surface Area
       \\note use key Flow/ExteriorArea for all exterior surface area
       \\note use key Flow/ExteriorWallArea to include only exterior wall area
       \\units m3/s-m2
       \\type real
       \\minimum 0
  N4 , \\field Air Changes per Hour
       \\units 1/hr
       \\type real
       \\minimum 0
  N5 , \\field Constant Term Coefficient
       \\required-field
       \\note  "A" in Equation
       \\type real
       \\default 1
  N6 , \\field Temperature Term Coefficient
       \\required-field
       \\note  "B" in Equation
       \\type real
       \\default 0
  N7 , \\field Velocity Term Coefficient
       \\required-field
       \\note  "C" in Equation
       \\type real
       \\default 0
  N8 ; \\field Velocity Squared Term Coefficient
       \\required-field
       \\note  "D" in Equation
       \\type real
       \\default 0

ZoneInfiltration:EffectiveLeakageArea,
       \\min-fields 6
       \\memo  Infiltration is specified as effective leakage area at 4 Pa, schedule fraction, stack and wind coefficients, and
       \\memo  is a function of temperature difference and wind speed:
       \\memo  Infiltration=FSchedule * (AL /1000) SQRT(Cs*|(Tzone-Todb)| +  Cw*WindSpd**2 )
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
  N1 , \\field Effective Air Leakage Area
       \\units cm2
       \\note "AL" in Equation
       \\note units are cm2 (square centimeters)
       \\minimum> 0
       \\type real
       \\required-field
  N2 , \\field Stack Coefficient
       \\note "Cs" in Equation
       \\minimum> 0
       \\type real
       \\required-field
  N3 ; \\field Wind Coefficient
       \\note "Cw" in Equation
       \\minimum> 0
       \\type real
       \\required-field


ZoneInfiltration:FlowCoefficient,
       \\min-fields 8
       \\memo  Infiltration is specified as flow coefficient, schedule fraction, stack and wind coefficients, and
       \\memo  is a function of temperature difference and wind speed:
       \\memo  Infiltration=FSchedule * SQRT( (c * Cs*|(Tzone-Todb)|**n)**2 + (c* Cw*(s * WindSpd)**2n)**2 )
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
  N1 , \\field Flow Coefficient
       \\note "c" in Equation
       \\minimum> 0
       \\type real
       \\required-field
  N2 , \\field Stack Coefficient
       \\note "Cs" in Equation
       \\minimum> 0
       \\type real
       \\required-field
  N3 , \\field Pressure Exponent
       \\note "n" in Equation
       \\minimum> 0
       \\type real
       \\required-field
       \\default 0.67
  N4 , \\field Wind Coefficient
       \\note "Cw" in Equation
       \\minimum> 0
       \\type real
       \\required-field
  N5 ; \\field Shelter Factor
       \\note "s" in Equation
       \\minimum> 0
       \\type real
       \\required-field


ZoneVentilation:DesignFlowRate,
   \\memo  Ventilation is specified as a design level which is modified by a schedule fraction, temperature difference and wind speed:
   \\memo  Ventilation=Vdesign * Fschedule * (A + B*|(Tzone-Todb)| + C*WindSpd + D * WindSpd**2)
   \\memo If you use a ZoneList in the Zone or ZoneList name field then this definition applies
   \\memo to all the zones in the ZoneList.
   \\min-fields 15
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference VentilationNames
  A2 , \\field Zone or ZoneList Name
       \\required-field
       \\type object-list
       \\object-list ZoneAndZoneListNames
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
  A4 , \\field Design Flow Rate Calculation Method
       \\note The entered calculation method is used to create the maximum amount of ventilation
       \\note for this set of attributes
       \\note Choices: Flow/Zone => Design Flow Rate -- simply enter Design Flow Rate
       \\note Flow/Area => Flow Rate per Zone Floor Area - Value * Floor Area (zone) = Design Flow Rate
       \\note Flow/Person => Flow Rate per Person - Value * #people = Design Flow Rate
       \\note AirChanges/Hour => Air Changes per Hour - Value * Floor Volume (zone) adjusted for m3/s = Design Volume Flow Rate
       \\note  "Vdesign" in Equation is the result.
       \\required-field
       \\type choice
       \\key Flow/Zone
       \\key Flow/Area
       \\key Flow/Person
       \\key AirChanges/Hour
       \\default Flow/Zone
  N1 , \\field Design Flow Rate
       \\units m3/s
       \\type real
       \\minimum 0
  N2 , \\field Flow Rate per Zone Floor Area
       \\type real
       \\minimum 0
       \\units m3/s-m2
  N3 , \\field Flow Rate per Person
       \\type real
       \\minimum 0
       \\units m3/s-person
  N4 , \\field Air Changes per Hour
       \\units 1/hr
       \\type real
       \\minimum 0
  A5 , \\field Ventilation Type
       \\required-field
       \\type choice
       \\key Natural
       \\key Intake
       \\key Exhaust
       \\key Balanced
       \\default Natural
  N5 , \\field Fan Pressure Rise
       \\required-field
       \\note pressure rise across the fan
       \\type real
       \\units Pa
       \\minimum 0
       \\default 0
  N6 , \\field Fan Total Efficiency
       \\required-field
       \\type real
       \\minimum> 0
       \\default 1
  N7 , \\field Constant Term Coefficient
       \\required-field
       \\note  "A" in Equation
       \\type real
       \\default 1
  N8 , \\field Temperature Term Coefficient
       \\required-field
       \\note  "B" in Equation
       \\type real
       \\default 0
  N9 , \\field Velocity Term Coefficient
       \\required-field
       \\note  "C" in Equation
       \\type real
       \\default 0
  N10, \\field Velocity Squared Term Coefficient
       \\required-field
       \\note  "D" in Equation
       \\type real
       \\default 0
  N11, \\field Minimum Indoor Temperature
       \\note this is the indoor temperature below which ventilation is shutoff
       \\units C
       \\type real
       \\minimum -100
       \\maximum 100
       \\default -100
  A6 , \\field Minimum Indoor Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the indoor temperature versus time below which
       \\note ventilation is shutoff.
  N12, \\field Maximum Indoor Temperature
       \\note this is the indoor temperature above which ventilation is shutoff
       \\units C
       \\type real
       \\minimum -100
       \\maximum 100
       \\default 100
  A7 , \\field Maximum Indoor Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the indoor temperature versus time above which
       \\note ventilation is shutoff.
  N13, \\field Delta Temperature
       \\note This is the temperature differential between indoor and outdoor below which ventilation is shutoff.
       \\note If ((IndoorTemp - OutdoorTemp) < DeltaTemperature) then ventilation is not allowed.
       \\note For example, if delta temperature is 2C, ventilation is assumed to be available if the outside air temperature
       \\note is at least 2C cooler than the zone air temperature. The values for this field can include negative numbers.
       \\note This allows ventilation to occur even if the outdoor temperature is above the indoor temperature.
       \\units deltaC
       \\type real
       \\minimum -100
       \\default -100
  A8 , \\field Delta Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the temperature differential between indoor and outdoor
       \\note versus time below which ventilation is shutoff.
  N14, \\field Minimum Outdoor Temperature
       \\note this is the outdoor temperature below which ventilation is shutoff
       \\units C
       \\type real
       \\minimum -100
       \\maximum 100
       \\default -100
  A9 , \\field Minimum Outdoor Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the outdoor temperature versus time below which
       \\note ventilation is shutoff.
  N15, \\field Maximum Outdoor Temperature
       \\note this is the outdoor temperature above which ventilation is shutoff
       \\units C
       \\type real
       \\minimum -100
       \\maximum 100
       \\default 100
  A10, \\field Maximum Outdoor Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the outdoor temperature versus time above which
       \\note ventilation is shutoff.
  N16; \\field Maximum Wind Speed
       \\note this is the outdoor wind speed above which ventilation is shutoff
       \\units m/s
       \\type real
       \\minimum 0
       \\maximum 40
       \\default 40

ZoneVentilation:WindandStackOpenArea,
  \\min-fields 8
       \\memo This object is specified as natural ventilation driven by wind and stack effect only:
       \\memo Ventilation Wind = Cw * Opening Area * Schedule * WindSpd
       \\memo Ventilation Stack = Cd * Opening Area * Schedule * SQRT(2*g*DH*(|(Tzone-Todb)|/Tzone))
       \\memo Total Ventilation = SQRT((Ventilation Wind)^2 + (Ventilation Stack)^2)
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference VentilationNames
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  N1 , \\field Opening Area
       \\note This is the opening area used to calculate stack effect and wind driven ventilation.
       \\units m2
       \\type real
       \\minimum 0
       \\default 0
  A3 , \\field Opening Area Fraction Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the fraction values applied to the opening area given in the previous
       \\note input field (0.0 - 1.0).
  N2 , \\field Opening Effectiveness
       \\note This field is used to calculate wind driven ventilation.
       \\note  "Cw" in the wind-driven equation and the maximum value is 1.0.
       \\note When the input is Autocalculate, the program calculates Cw based on an angle between
       \\note wind direction and effective angle
       \\note Cw = 0.55 at angle = 0, and Cw = 0.3 at angle=180
       \\note Linear interpolation is used to calculate Cw based on the above two values.
       \\units dimensionless
       \\autocalculatable
       \\type real
       \\minimum 0
       \\maximum 1
       \\default Autocalculate
  N3 , \\field Effective Angle
       \\note This field is defined as normal angle of the opening area and is used when input
       \\note field Opening Effectiveness = Autocalculate.
       \\type real
       \\units deg
       \\minimum 0.0
       \\maximum< 360.0
       \\default 0
  N4 , \\field Height Difference
       \\note This is the height difference between the midpoint of an opening and
       \\note the neutral pressure level.
       \\units m
       \\type real
       \\minimum 0
       \\default 0
       \\note  "DH" in the stack equation.
  N5 , \\field Discharge Coefficient for Opening
       \\note This is the discharge coefficient used to calculate stack effect.
       \\note  "Cd" in the stack equation and the maximum value is 1.0.
       \\note When the input is Autocalculate, the following equation is used to calculate the
       \\note coefficient:
       \\note Cd = 0.4 + 0.0045*|(Tzone-Todb)|
       \\autocalculatable
       \\minimum 0.0
       \\maximum 1.0
       \\default Autocalculate
  N6 , \\field Minimum Indoor Temperature
       \\note This is the indoor temperature below which ventilation is shutoff.
       \\units C
       \\type real
       \\minimum -100
       \\maximum 100
       \\default -100
  A4 , \\field Minimum Indoor Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the indoor temperature versus time below which
       \\note ventilation is shutoff.
  N7 , \\field Maximum Indoor Temperature
       \\note This is the indoor temperature above which ventilation is shutoff.
       \\units C
       \\type real
       \\minimum -100
       \\maximum 100
       \\default 100
  A5 , \\field Maximum Indoor Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the indoor temperature versus time above which
       \\note ventilation is shutoff.
  N8 , \\field Delta Temperature
       \\note This is the temperature differential between indoor and outdoor below
       \\note which ventilation is shutoff.
       \\units deltaC
       \\type real
       \\minimum -100
       \\default -100
  A6 , \\field Delta Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the temperature differential between indoor and outdoor
       \\note versus time below which ventilation is shutoff.
  N9 , \\field Minimum Outdoor Temperature
       \\note This is the outdoor temperature below which ventilation is shutoff.
       \\units C
       \\type real
       \\minimum -100
       \\maximum 100
       \\default -100
  A7 , \\field Minimum Outdoor Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the outdoor temperature versus time below which
       \\note ventilation is shutoff.
  N10, \\field Maximum Outdoor Temperature
       \\note This is the outdoor temperature above which ventilation is shutoff.
       \\units C
       \\type real
       \\minimum -100
       \\maximum 100
       \\default 100
  A8 , \\field Maximum Outdoor Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the outdoor temperature versus time above which
       \\note ventilation is shutoff.
  N11; \\field Maximum Wind Speed
       \\note This is the outdoor wind speed above which ventilation is shutoff.
       \\units m/s
       \\type real
       \\minimum 0
       \\maximum 40
       \\default 40

ZoneAirBalance:OutdoorAir,
       \\memo Provide a combined zone outdoor air flow by including interactions between
       \\memo mechanical ventilation, infiltration and duct leakage.
       \\memo This object will combine outdoor flows from all ZoneInfiltration and
       \\memo ZoneVentilation objects in the same zone. Balanced flows will be summed, while
       \\memo unbalanced flows will be added in quadrature.
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  A3 , \\field Air Balance Method
       \\type choice
       \\key Quadrature
       \\key None
       \\default Quadrature
       \\note None: Only perform simple calculations without using a combined zone outdoor air.
       \\note Quadrature: A combined outdoor air is used in the quadrature sum.
  N1 , \\field Induced Outdoor Air Due to Unbalanced Duct Leakage
       \\units m3/s
       \\type real
       \\minimum 0
       \\default 0
  A4 ; \\field Induced Outdoor Air Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the fraction values applied to the Induced Outdoor Air given in the
       \\note previous input field (0.0 - 1.0).

ZoneMixing,
       \\memo ZoneMixing is a simple air exchange from one zone to another. Note that this statement
       \\memo only affects the energy balance of the "receiving" zone and will not produce
       \\memo any effect on the "source" zone. Mixing statements can be complementary and include
       \\memo multiple zones, but the balancing of flows between zones is left to the user's
       \\memo discretion.
 \\min-fields 9
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
  A4 , \\field Design Flow Rate Calculation Method
       \\note The entered calculation method is used to create the maximum amount of ventilation
       \\note for this set of attributes
       \\note Choices: Flow/Zone => Design Flow Rate -- simply enter Design Flow Rate
       \\note Flow/Area => Flow Rate per Zone Floor Area - Value * Floor Area (zone) = Design Flow Rate
       \\note Flow/Person => Flow Rate per Person - Value * #people = Design Flow Rate
       \\note AirChanges/Hour => Air Changes per Hour - Value * Floor Volume (zone) adjusted for m3/s = Design Volume Flow Rate
       \\note  "Vdesign" in Equation is the result.
       \\required-field
       \\type choice
       \\key Flow/Zone
       \\key Flow/Area
       \\key Flow/Person
       \\key AirChanges/Hour
       \\default Flow/Zone
  N1 , \\field Design Flow Rate
       \\units m3/s
       \\type real
       \\minimum 0
  N2 , \\field Flow Rate per Zone Floor Area
       \\type real
       \\minimum 0
       \\units m3/s-m2
  N3 , \\field Flow Rate per Person
       \\type real
       \\minimum 0
       \\units m3/s-person
  N4 , \\field Air Changes per Hour
       \\units 1/hr
       \\type real
       \\minimum 0
  A5 , \\field Source Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  N5 , \\field Delta Temperature
       \\units deltaC
       \\type real
       \\default 0
       \\note This field contains the constant temperature differential between source and
       \\note receiving zones below which mixing is shutoff.
  A6 , \\field Delta Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the temperature differential between source and receiving
       \\note zones versus time below which mixing is shutoff.
  A7 , \\field Minimum Zone Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the zone dry-bulb temperature versus time below which
       \\note mixing is shutoff.
  A8 , \\field Maximum Zone Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the zone dry-bulb temperature versus time above which
       \\note mixing is shutoff.
  A9 , \\field Minimum Source Zone Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the source zone dry-bulb temperature versus time below
       \\note which mixing is shutoff.
  A10, \\field Maximum Source Zone Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the source zone dry-bulb temperature versus time above
       \\note which mixing is shutoff.
  A11, \\field Minimum Outdoor Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the outdoor temperature versus time below which
       \\note mixing is shutoff.
  A12; \\field Maximum Outdoor Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the outdoor temperature versus time above which
       \\note mixing is shutoff.

ZoneCrossMixing,
       \\memo ZoneCrossMixing exchanges an equal amount of air between two zones. Note that this
       \\memo statement affects the energy balance of both zones.
  \\min-fields 9
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
  A4 , \\field Design Flow Rate Calculation Method
       \\note The entered calculation method is used to create the maximum amount of ventilation
       \\note for this set of attributes
       \\note Choices: Flow/Zone => Design Flow Rate -- simply enter Design Flow Rate
       \\note Flow/Area => Flow Rate per Zone Floor Area - Value * Floor Area (zone) = Design Flow Rate
       \\note Flow/Person => Flow Rate per Person - Value * #people = Design Flow Rate
       \\note AirChanges/Hour => Air Changes per Hour - Value * Floor Volume (zone) adjusted for m3/s = Design Volume Flow Rate
       \\note  "Vdesign" in Equation is the result.
       \\required-field
       \\type choice
       \\key Flow/Zone
       \\key Flow/Person
       \\key Flow/Area
       \\key AirChanges/Hour
       \\default Flow/Zone
  N1 , \\field Design Flow Rate
       \\units m3/s
       \\type real
       \\minimum 0
  N2 , \\field Flow Rate per Zone Floor Area
       \\type real
       \\minimum 0
       \\units m3/s-m2
  N3 , \\field Flow Rate per Person
       \\type real
       \\minimum 0
       \\units m3/s-person
  N4 , \\field Air Changes per Hour
       \\units 1/hr
       \\type real
       \\minimum 0
  A5 , \\field Source Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  N5 , \\field Delta Temperature
       \\units deltaC
       \\minimum 0.0
       \\type real
       \\default 0
       \\note This field contains the constant temperature differential between source and
       \\note receiving zones below which cross mixing is shutoff. This value must be greater
       \\note than or equal to zero.
  A6 , \\field Delta Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the temperature differential between source and receiving
       \\note zones versus time below which cross mixing is shutoff.
  A7 , \\field Minimum Zone Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the indoor temperature versus time below which
       \\note cross mixing is shutoff.
  A8 , \\field Maximum Zone Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the indoor temperature versus time above which
       \\note cross mixing is shutoff.
  A9 , \\field Minimum Source Zone Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the source zone dry-bulb temperature versus time below
       \\note which cross mixing is shutoff.
  A10, \\field Maximum Source Zone Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the source zone dry-bulb temperature versus time above
       \\note which cross mixing is shutoff.
  A11, \\field Minimum Outdoor Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the outdoor temperature versus time below which
       \\note cross mixing is shutoff.
  A12; \\field Maximum Outdoor Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the outdoor temperature versus time above which
       \\note cross mixing is shutoff.

ZoneRefrigerationDoorMixing,
  \\min-fields 4
       \\memo Refrigeration Door Mixing is used for an opening between two zones that are at the
       \\memo   same elevation but have different air temperatures.  In this case, the mixing air flow
       \\memo   between the two zones is determined by the density difference between the two zones.
       \\memo   This would typically be used between two zones in a refrigerated warehouse that are
       \\memo   controlled at different temperatures.  It could also be used to model a door to a walk-in
       \\memo   refrigerated space if that space were modeled as a zone instead of using the object Refrigeration:WalkIn.
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Zone 1 Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  A3 , \\field Zone 2 Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  A4 , \\field Schedule Name
       \\note This schedule defines the fraction of the time the refrigeration door is open
       \\note  For example, if the warehouse is closed at night and there are no door openings
       \\note   between two zones, the value for that time period would be 0.
       \\note   If doors were propped open, the value  over that time period would be 1.0
       \\note   If the doors were open about 20% of the time, the value over that period would be 0.2
       \\note   Schedule values must lie between 0 and 1.0
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
  N1 , \\field Door Height
       \\units m
       \\type real
       \\minimum 0
       \\maximum 50.
       \\default 3.0
  N2 , \\field Door Area
       \\type real
       \\minimum 0
       \\maximum 400.
       \\default 9.
       \\units m2
  A5;  \\field Door Protection Type
       \\note Door protection can reduce the air flow through a refrigeration door
       \\note The default value is "None"
       \\note Choices: "None", "AirCurtain", and "StripCurtain"
       \\note A strip curtain reduces the air flow more than an air curtain
       \\type choice
       \\key None
       \\key AirCurtain
       \\key StripCurtain
       \\default None

ZoneEarthtube,
  \\min-fields 22
      \\memo  Earth Tube is specified as a design level which is modified by a Schedule fraction, temperature difference and wind speed:
      \\memo  Earthtube=Edesign * Fschedule * (A + B*|(Tzone-Todb)| + C*WindSpd + D * WindSpd**2)
  A1, \\field Zone Name
      \\required-field
      \\type object-list
      \\object-list ZoneNames
  A2, \\field Schedule Name
      \\required-field
      \\type object-list
      \\object-list ScheduleNames
  N1, \\field Design Flow Rate
      \\required-field
      \\units m3/s
      \\note  "Edesign" in Equation
      \\type real
      \\minimum 0
  N2, \\field Minimum Zone Temperature when Cooling
      \\required-field
      \\note this is the indoor temperature below which the earth tube is shut off
      \\units C
      \\type real
      \\minimum -100
      \\maximum 100
  N3, \\field Maximum Zone Temperature when Heating
      \\required-field
      \\note this is the indoor temperature above which the earth tube is shut off
      \\units C
      \\type real
      \\minimum -100
      \\maximum 100
  N4, \\field Delta Temperature
      \\required-field
      \\note This is the temperature difference between indoor and outdoor below which the earth tube is shut off
      \\units deltaC
      \\type real
      \\minimum 0
  A3, \\field Earthtube Type
      \\required-field
      \\type choice
      \\key Natural
      \\key Intake
      \\key Exhaust
      \\default Natural
  N5, \\field Fan Pressure Rise
      \\required-field
      \\note pressure rise across the fan
      \\type real
      \\units Pa
      \\minimum 0
      \\default 0
  N6, \\field Fan Total Efficiency
      \\required-field
      \\type real
      \\minimum> 0
      \\default 1
  N7, \\field Pipe Radius
      \\required-field
      \\units m
      \\type real
      \\minimum> 0
      \\default 1
  N8, \\field Pipe Thickness
      \\required-field
      \\units m
      \\type real
      \\minimum> 0
      \\default 0.2
  N9, \\field Pipe Length
      \\required-field
      \\units m
      \\type real
      \\minimum> 0
      \\default 15
 N10, \\field Pipe Thermal Conductivity
      \\required-field
      \\units W/m-K
      \\type real
      \\minimum> 0
      \\default 200
 N11, \\field Pipe Depth Under Ground Surface
      \\required-field
      \\units m
      \\type real
      \\minimum> 0
      \\default 3
  A4, \\field Soil Condition
      \\required-field
      \\type choice
      \\key HeavyAndSaturated
      \\key HeavyAndDamp
      \\key HeavyAndDry
      \\key LightAndDry
      \\default HeavyAndDamp
 N12, \\field Average Soil Surface Temperature
      \\required-field
      \\units C
      \\type real
      \\default 0
 N13, \\field Amplitude of Soil Surface Temperature
      \\required-field
      \\units C
      \\type real
      \\minimum 0
      \\default 0
 N14, \\field Phase Constant of Soil Surface Temperature
      \\required-field
      \\units days
      \\type real
      \\minimum 0
      \\default 0
 N15, \\field Constant Term Flow Coefficient
      \\required-field
      \\note  "A" in Equation
      \\type real
      \\default 1
 N16, \\field Temperature Term Flow Coefficient
      \\required-field
      \\note  "B" in Equation
      \\type real
      \\default 0
 N17, \\field Velocity Term Flow Coefficient
      \\required-field
      \\note  "C" in Equation
      \\type real
      \\default 0
 N18; \\field Velocity Squared Term Flow Coefficient
      \\required-field
      \\note  "D" in Equation
      \\type real
      \\default 0

ZoneCoolTower:Shower,
     \\memo A cooltower (sometimes referred to as a wind tower or a shower cooling tower)
     \\memo models passive downdraught evaporative cooling (PDEC) that is designed to capture the
     \\memo wind at the top of a tower and cool the outdoor air using water evaporation before
     \\memo delivering it to a space.
 A1, \\field Name
     \\required-field
 A2, \\field Availability Schedule Name
     \\note Availability schedule name for this system. Schedule value > 0 means the system is available.
     \\note If this field is blank, the system is always available.
     \\type object-list
     \\object-list ScheduleNames
 A3, \\field Zone Name
     \\required-field
     \\type object-list
     \\object-list ZoneNames
 A4, \\field Water Supply Storage Tank Name
     \\note In case of stand alone tank or underground water, leave this input blank
     \\type object-list
     \\object-list WaterStorageTankNames
 A5, \\field Flow Control Type
     \\note Water flow schedule should be selected when the water flow rate is known.
     \\note Wind-driven flow should be selected when the water flow rate is unknown.
     \\type choice
     \\key WaterFlowSchedule
     \\key WindDrivenFlow
     \\default WindDrivenFlow
 A6, \\field Pump Flow Rate Schedule Name
     \\required-field
     \\type object-list
     \\object-list ScheduleNames
 N1, \\field Maximum Water Flow Rate
     \\required-field
     \\units m3/s
     \\type real
 N2, \\field Effective Tower Height
     \\note This field is from either the spray or the wet pad to the top of the outlet.
     \\required-field
     \\units m
     \\type real
 N3, \\field Airflow Outlet Area
     \\note User have to specify effective area when outlet area is relatively bigger than the cross sectional area
     \\note of cooltower. If the number of outlet is more than one, assume the air passes through only one.
     \\required-field
     \\units m2
     \\type real
 N4, \\field Maximum Air Flow Rate
     \\required-field
     \\units m3/s
     \\type real
     \\minimum 0
 N5, \\field Minimum Indoor Temperature
     \\required-field
     \\note This field is to specify the indoor temperature below which cooltower is shutoff.
     \\units C
     \\type real
     \\minimum -100
     \\maximum 100
 N6, \\field Fraction of Water Loss
     \\minimum 0
     \\maximum 1
 N7, \\field Fraction of Flow Schedule
     \\minimum 0
     \\maximum 1
 N8; \\field Rated Power Consumption
     \\required-field
     \\units W
     \\type real

ZoneThermalChimney,
       \\memo A thermal chimney is a vertical shaft utilizing solar radiation to enhance natural
       \\memo ventilation. It consists of an absorber wall, air gap and glass cover with high solar
       \\memo transmissivity.
   \\min-fields 10
   A1, \\field Name
        \\required-field
   A2,  \\field Zone Name
        \\note Name of zone that is the thermal chimney
        \\required-field
        \\type object-list
        \\object-list ZoneNames
   A3, \\field Availability Schedule Name
        \\note Availability schedule name for this system. Schedule value > 0 means the system is available.
        \\note If this field is blank, the system is always available.
        \\type object-list
        \\object-list ScheduleNames
   N1, \\field Width of the Absorber Wall
        \\required-field
        \\units m
        \\type real
        \\minimum 0
   N2, \\field Cross Sectional Area of Air Channel Outlet
        \\required-field
        \\units m2
        \\type real
        \\minimum 0
   N3, \\field Discharge Coefficient
        \\required-field
        \\type real
        \\minimum 0
        \\maximum 1
        \\default 0.8
   A4, \\field Zone 1 Name
        \\required-field
        \\type object-list
        \\object-list ZoneNames
   N4, \\field Distance from Top of Thermal Chimney to Inlet 1
        \\required-field
        \\units m
        \\type real
        \\minimum 0
   N5, \\field Relative Ratios of Air Flow Rates Passing through Zone 1
        \\required-field
        \\type real
        \\minimum 0
        \\maximum 1
        \\default 1.0
   N6, \\field Cross Sectional Areas of Air Channel Inlet 1
        \\required-field
        \\units m2
        \\type real
        \\minimum 0
   A5, \\field Zone 2 Name
        \\type object-list
        \\object-list ZoneNames
   N7, \\field Distance from Top of Thermal Chimney to Inlet 2
        \\units m
        \\type real
        \\minimum 0
   N8, \\field Relative Ratios of Air Flow Rates Passing through Zone 2
        \\type real
        \\minimum 0
        \\maximum 1
   N9, \\field Cross Sectional Areas of Air Channel Inlet 2
        \\units m2
        \\type real
        \\minimum 0
   A6, \\field Zone 3 Name
        \\type object-list
        \\object-list ZoneNames
   N10, \\field Distance from Top of Thermal Chimney to Inlet 3
        \\units m
        \\type real
        \\minimum 0
   N11, \\field Relative Ratios of Air Flow Rates Passing through Zone 3
        \\type real
        \\minimum 0
        \\maximum 1
   N12, \\field Cross Sectional Areas of Air Channel Inlet 3
        \\units m2
        \\type real
        \\minimum 0
   A7, \\field Zone 4 Name
        \\type object-list
        \\object-list ZoneNames
   N13, \\field Distance from Top of Thermal Chimney to Inlet 4
        \\units m
        \\type real
        \\minimum 0
   N14, \\field Relative Ratios of Air Flow Rates Passing through Zone 4
        \\type real
        \\minimum 0
        \\maximum 1
   N15, \\field Cross Sectional Areas of Air Channel Inlet 4
        \\units m2
        \\type real
        \\minimum 0
   A8, \\field Zone 5 Name
        \\type object-list
        \\object-list ZoneNames
   N16, \\field Distance from Top of Thermal Chimney to Inlet 5
        \\units m
        \\type real
        \\minimum 0
   N17, \\field Relative Ratios of Air Flow Rates Passing through Zone 5
        \\type real
        \\minimum 0
        \\maximum 1
   N18, \\field Cross Sectional Areas of Air Channel Inlet 5
        \\units m2
        \\type real
        \\minimum 0
   A9, \\field Zone 6 Name
        \\type object-list
        \\object-list ZoneNames
   N19, \\field Distance from Top of Thermal Chimney to Inlet 6
        \\units m
        \\type real
        \\minimum 0
   N20, \\field Relative Ratios of Air Flow Rates Passing through Zone 6
        \\type real
        \\minimum 0
        \\maximum 1
   N21, \\field Cross Sectional Areas of Air Channel Inlet 6
        \\units m2
        \\type real
        \\minimum 0
   A10, \\field Zone 7 Name
        \\type object-list
        \\object-list ZoneNames
   N22, \\field Distance from Top of Thermal Chimney to Inlet 7
        \\units m
        \\type real
        \\minimum 0
   N23, \\field Relative Ratios of Air Flow Rates Passing through Zone 7
        \\type real
        \\minimum 0
        \\maximum 1
   N24, \\field Cross Sectional Areas of Air Channel Inlet 7
        \\units m2
        \\type real
        \\minimum 0
   A11, \\field Zone 8 Name
        \\type object-list
        \\object-list ZoneNames
   N25, \\field Distance from Top of Thermal Chimney to Inlet 8
        \\units m
        \\type real
        \\minimum 0
   N26, \\field Relative Ratios of Air Flow Rates Passing through Zone 8
        \\type real
        \\minimum 0
        \\maximum 1
   N27, \\field Cross Sectional Areas of Air Channel Inlet 8
        \\units m2
        \\type real
        \\minimum 0
   A12, \\field Zone 9 Name
        \\type object-list
        \\object-list ZoneNames
   N28, \\field Distance from Top of Thermal Chimney to Inlet 9
        \\units m
        \\type real
        \\minimum 0
   N29, \\field Relative Ratios of Air Flow Rates Passing through Zone 9
        \\type real
        \\minimum 0
        \\maximum 1
   N30, \\field Cross Sectional Areas of Air Channel Inlet 9
        \\units m2
        \\type real
        \\minimum 0
   A13, \\field Zone 10 Name
        \\type object-list
        \\object-list ZoneNames
   N31, \\field Distance from Top of Thermal Chimney to Inlet 10
        \\units m
        \\type real
        \\minimum 0
   N32, \\field Relative Ratios of Air Flow Rates Passing through Zone 10
        \\type real
        \\minimum 0
        \\maximum 1
   N33, \\field Cross Sectional Areas of Air Channel Inlet 10
        \\units m2
        \\type real
        \\minimum 0
   A14, \\field Zone 11 Name
        \\type object-list
        \\object-list ZoneNames
   N34, \\field Distance from Top of Thermal Chimney to Inlet 11
        \\units m
        \\type real
        \\minimum 0
   N35, \\field Relative Ratios of Air Flow Rates Passing through Zone 11
        \\type real
        \\minimum 0
        \\maximum 1
   N36, \\field Cross Sectional Areas of Air Channel Inlet 11
        \\units m2
        \\type real
        \\minimum 0
   A15, \\field Zone 12 Name
        \\type object-list
        \\object-list ZoneNames
   N37, \\field Distance from Top of Thermal Chimney to Inlet 12
        \\units m
        \\type real
        \\minimum 0
   N38, \\field Relative Ratios of Air Flow Rates Passing through Zone 12
        \\type real
        \\minimum 0
        \\maximum 1
   N39, \\field Cross Sectional Areas of Air Channel Inlet 12
        \\units m2
        \\type real
        \\minimum 0
   A16, \\field Zone 13 Name
        \\type object-list
        \\object-list ZoneNames
   N40, \\field Distance from Top of Thermal Chimney to Inlet 13
        \\units m
        \\type real
        \\minimum 0
   N41, \\field Relative Ratios of Air Flow Rates Passing through Zone 13
        \\type real
        \\minimum 0
        \\maximum 1
   N42, \\field Cross Sectional Areas of Air Channel Inlet 13
        \\units m2
        \\type real
        \\minimum 0
   A17, \\field Zone 14 Name
        \\type object-list
        \\object-list ZoneNames
   N43, \\field Distance from Top of Thermal Chimney to Inlet 14
        \\units m
        \\type real
        \\minimum 0
   N44, \\field Relative Ratios of Air Flow Rates Passing through Zone 14
        \\type real
        \\minimum 0
        \\maximum 1
   N45, \\field Cross Sectional Areas of Air Channel Inlet 14
        \\units m2
        \\type real
        \\minimum 0
   A18, \\field Zone 15 Name
        \\type object-list
        \\object-list ZoneNames
   N46, \\field Distance from Top of Thermal Chimney to Inlet 15
        \\units m
        \\type real
        \\minimum 0
   N47, \\field Relative Ratios of Air Flow Rates Passing through Zone 15
        \\type real
        \\minimum 0
        \\maximum 1
   N48, \\field Cross Sectional Areas of Air Channel Inlet 15
        \\units m2
        \\type real
        \\minimum 0
   A19, \\field Zone 16 Name
        \\type object-list
        \\object-list ZoneNames
   N49, \\field Distance from Top of Thermal Chimney to Inlet 16
        \\units m
        \\type real
        \\minimum 0
   N50, \\field Relative Ratios of Air Flow Rates Passing through Zone 16
        \\type real
        \\minimum 0
        \\maximum 1
   N51, \\field Cross Sectional Areas of Air Channel Inlet 16
        \\units m2
        \\type real
        \\minimum 0
   A20, \\field Zone 17 Name
        \\type object-list
        \\object-list ZoneNames
   N52, \\field Distance from Top of Thermal Chimney to Inlet 17
        \\units m
        \\type real
        \\minimum 0
   N53, \\field Relative Ratios of Air Flow Rates Passing through Zone 17
        \\type real
        \\minimum 0
        \\maximum 1
   N54, \\field Cross Sectional Areas of Air Channel Inlet 17
        \\units m2
        \\type real
        \\minimum 0
   A21, \\field Zone 18 Name
        \\type object-list
        \\object-list ZoneNames
   N55, \\field Distance from Top of Thermal Chimney to Inlet 18
        \\units m
        \\type real
        \\minimum 0
   N56, \\field Relative Ratios of Air Flow Rates Passing through Zone 18
        \\type real
        \\minimum 0
        \\maximum 1
   N57, \\field Cross Sectional Areas of Air Channel Inlet 18
        \\units m2
        \\type real
        \\minimum 0
   A22, \\field Zone 19 Name
        \\type object-list
        \\object-list ZoneNames
   N58, \\field Distance from Top of Thermal Chimney to Inlet 19
        \\units m
        \\type real
        \\minimum 0
   N59, \\field Relative Ratios of Air Flow Rates Passing through Zone 19
        \\type real
        \\minimum 0
        \\maximum 1
   N60, \\field Cross Sectional Areas of Air Channel Inlet 19
        \\units m2
        \\type real
        \\minimum 0
   A23, \\field Zone 20 Name
        \\type object-list
        \\object-list ZoneNames
   N61, \\field Distance from Top of Thermal Chimney to Inlet 20
        \\units m
        \\type real
        \\minimum 0
   N62, \\field Relative Ratios of Air Flow Rates Passing through Zone 20
        \\type real
        \\minimum 0
        \\maximum 1
   N63; \\field Cross Sectional Areas of Air Channel Inlet 20
        \\units m2
        \\type real
        \\minimum 0

\\group Natural Ventilation and Duct Leakage

! Basic parameters
AirflowNetwork:SimulationControl,
      \\min-fields 13
      \\unique-object
      \\memo This object defines the global parameters used in an Airflow Network simulation.
 A1 , \\field Name
      \\required-field
      \\note Enter a unique name for this object.
 A2 , \\field AirflowNetwork Control
      \\type choice
      \\key MultizoneWithDistribution
      \\key MultizoneWithoutDistribution
      \\key MultizoneWithDistributionOnlyDuringFanOperation
      \\key NoMultizoneOrDistribution
      \\default NoMultizoneOrDistribution
      \\note NoMultizoneOrDistribution: Only perform Simple calculations (objects ZoneInfiltration:*,
      \\note ZoneVentilation:*, ZoneMixing, ZoneCrossMixing, ZoneRefrigerationDoorMixing,
      \\note ZoneAirBalance:OutdoorAir, ZoneEarthtube, ZoneThermalChimney, and ZoneCoolTower:Shower);
      \\note MultizoneWithoutDistribution: Use AirflowNetwork objects to simulate multizone
      \\note Airflows driven by wind during simulation time,
      \\note and objects of ZoneInfiltration:*, ZoneVentilation:*, ZoneMixing, ZoneCrossMixing
      \\note ZoneRefrigerationDoorMixing, ZoneAirBalance:OutdoorAir, ZoneEarthtube,
      \\note ZoneThermalChimney, and ZoneCoolTower:Shower are ignored;
      \\note MultizoneWithDistributionOnlyDuringFanOperation: Perform distribution system
      \\note calculations during system fan on time
      \\note and Simple calculations during system Fan off time;
      \\note MultizoneWithDistribution: Perform distribution system calculations during system
      \\note fan on time and multizone Airflow driven by wind during system fan off time.
 A3 , \\field Wind Pressure Coefficient Type
      \\type choice
      \\key Input
      \\key SurfaceAverageCalculation
      \\default SurfaceAverageCalculation
      \\note Input: User must enter AirflowNetwork:MultiZone:WindPressureCoefficientArray,
      \\note AirflowNetwork:MultiZone:ExternalNode, and
      \\note AirflowNetwork:MultiZone:WindPressureCoefficientValues objects.
      \\note SurfaceAverageCalculation: used only for rectangular buildings.
      \\note If SurfaceAverageCalculation is selected,
      \\note AirflowNetwork:MultiZone:WindPressureCoefficientArray, AirflowNetwork:MultiZone:ExternalNode,
      \\note and AirflowNetwork:MultiZone:WindPressureCoefficientValues objects are not used.
 A4 , \\field AirflowNetwork Wind Pressure Coefficient Array Name
      \\type object-list
      \\object-list WPCSetNames
      \\note Used only if Wind Pressure Coefficient Type = Input, otherwise this field may be left blank.
 A5 , \\field Height Selection for Local Wind Pressure Calculation
      \\type choice
      \\key ExternalNode
      \\key OpeningHeight
      \\default OpeningHeight
      \\note If ExternalNode is selected, the height given in the
      \\note AirflowNetwork:MultiZone:ExternalNode object will be used.
      \\note If OpeningHeight is selected, the surface opening height (centroid) will be used to
      \\note calculate local wind pressure
      \\note This field is ignored when the choice of the Wind Pressure Coefficient Type field is
      \\note SurfaceAverageCalculation.
 A6 , \\field Building Type
      \\note Used only if Wind Pressure Coefficient Type = SurfaceAverageCalculation,
      \\note otherwise this field may be left blank.
      \\type choice
      \\key LowRise
      \\key HighRise
      \\default LowRise
 N1 , \\field Maximum Number of Iterations
      \\type integer
      \\units dimensionless
      \\default 500
      \\minimum> 10
      \\maximum 30000
      \\note Determines the maximum number of iterations used to converge on a solution. If this limit
      \\note is exceeded, the program terminates.
 A7 , \\field Initialization Type
      \\type choice
      \\key LinearInitializationMethod
      \\key ZeroNodePressures
      \\default ZeroNodePressures
 N2 , \\field Relative Airflow Convergence Tolerance
      \\type real
      \\units dimensionless
      \\default 1.E-4
      \\minimum> 0
      \\note This tolerance is defined as the absolute value of the sum of the mass Flow Rates
      \\note divided by the sum of the absolute value of the mass Flow Rates. The mass Flow Rates
      \\note described here refer to the mass Flow Rates at all Nodes in the AirflowNetwork model.
      \\note The solution converges when both this tolerance and the tolerance in the next field
      \\note (Absolute Airflow Convergence Tolerance) are satisfied.
 N3 , \\field Absolute Airflow Convergence Tolerance
      \\type real
      \\units kg/s
      \\default 1.E-6
      \\minimum> 0
      \\note This tolerance is defined as the absolute value of the sum of the mass flow rates. The mass
      \\note flow rates described here refer to the mass flow rates at all nodes in the AirflowNetwork
      \\note model. The solution converges when both this tolerance and the tolerance in the previous
      \\note field (Relative Airflow Convergence Tolerance) are satisfied.
 N4 , \\field Convergence Acceleration Limit
      \\type real
      \\units dimensionless
      \\note Used only for AirflowNetwork:SimulationControl
      \\minimum -1
      \\maximum 1
      \\default -0.5
 N5 , \\field Azimuth Angle of Long Axis of Building
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 180.0
      \\default 0.0
      \\note Degrees clockwise from true North.
      \\note Used only if Wind Pressure Coefficient Type = SurfaceAverageCalculation.
 N6 ; \\field Ratio of Building Width Along Short Axis to Width Along Long Axis
      \\type real
      \\minimum> 0.0
      \\maximum 1.0
      \\default 1.0
      \\note Used only if Wind Pressure Coefficient Type = SurfaceAverageCalculation.

AirflowNetwork:MultiZone:Zone,
      \\min-fields 8
      \\memo This object is used to simultaneously control a thermal zone's window and door openings,
      \\memo both exterior and interior.
  A1, \\field Zone Name
      \\required-field
      \\type object-list
      \\object-list ZoneNames
      \\note Enter the zone name where ventilation control is required.
  A2, \\field Ventilation Control Mode
      \\type choice
      \\key Temperature
      \\key Enthalpy
      \\key Constant
      \\key ASHRAE55Adaptive
      \\key CEN15251Adaptive
      \\key NoVent
      \\default NoVent
      \\note When Ventilation Control Mode = Temperature or Enthalpy, the following
      \\note fields are used to modulate the Ventilation Open Factor for all
      \\note window and door openings in the zone according to the zone's
      \\note indoor-outdoor temperature or enthalpy difference.
      \\note Constant: controlled by field Venting Schedule Name.
      \\note NoVent: control will not open window or door during simulation (Ventilation Open Factor = 0).
  A3, \\field Ventilation Control Zone Temperature Setpoint Schedule Name
      \\type object-list
      \\object-list ScheduleNames
      \\note Used only if Ventilation Control Mode = Temperature or Enthalpy.
  N1, \\field Minimum Venting Open Factor
      \\type real
      \\units dimensionless
      \\minimum 0.0
      \\maximum 1.0
      \\default 0.0
      \\note Used only if Ventilation Control Mode = Temperature or Enthalpy.
  N2, \\field Indoor and Outdoor Temperature Difference Lower Limit For Maximum Venting Open Factor
      \\type real
      \\units deltaC
      \\minimum 0.0
      \\maximum< 100.0
      \\default 0.0
      \\note Applicable only if Ventilation Control Mode = Temperature.
      \\note This value must be less than the corresponding upper value (next field).
  N3, \\field Indoor and Outdoor Temperature Difference Upper Limit for Minimun Venting Open Factor
      \\type real
      \\units deltaC
      \\minimum> 0.0
      \\default 100.0
      \\note Applicable only if Ventilation Control Mode = Temperature.
      \\note This value must be greater than the corresponding lower value (previous field).
  N4, \\field Indoor and Outdoor Enthalpy Difference Lower Limit For Maximum Venting Open Factor
      \\type real
      \\units deltaJ/kg
      \\minimum 0.0
      \\maximum< 300000.0
      \\default 0.0
      \\note Applicable only if Ventilation Control Mode = Enthalpy.
      \\note This value must be less than the corresponding upper value (next field).
  N5, \\field Indoor and Outdoor Enthalpy Difference Upper Limit for Minimun Venting Open Factor
      \\type real
      \\units deltaJ/kg
      \\minimum> 0.0
      \\default 300000.0
      \\note Applicable only if Ventilation Control Mode = Enthalpy.
      \\note This value must be greater than the corresponding lower value (previous field).
  A4; \\field Venting Availability Schedule Name
      \\type object-list
      \\object-list ScheduleNames
      \\note Non-zero Schedule value means venting is allowed if other venting control conditions are
      \\note satisfied. A zero (or negative) Schedule value means venting is not allowed under any
      \\note The Schedule values should be greater than or equal to 0 and less than or equal to 1.
      \\note circumstances. If this Schedule is not specified then venting is allowed if
      \\note other venting control conditions are satisfied.
      \\note Not used if Ventilation Control Mode = NoVent.

AirflowNetwork:MultiZone:Surface,
      \\min-fields 4
      \\memo This object specifies the properties of a surface linkage through which air flows.
      \\memo Airflow Report: Node 1 as an inside face zone;
      \\memo Node 2 as an outside face zone or external node.
  A1, \\field Surface Name
      \\required-field
      \\type object-list
      \\object-list SurfAndSubSurfNames
      \\note Enter the name of a heat transfer surface.
  A2, \\field Leakage Component Name
      \\required-field
      \\type object-list
      \\object-list SurfaceAirflowLeakageNames
      \\note Enter the name of an Airflow Network leakage component. A leakage component is
      \\note one of the following AirflowNetwork:Multizone objects:
      \\note AirflowNetwork:MultiZone:Component:DetailedOpening,
      \\note AirflowNetwork:MultiZone:Component:SimpleOpening,
      \\note AirflowNetwork:MultiZone:Surface:Crack,
      \\note AirflowNetwork:MultiZone:Surface:EffectiveLeakageArea,
      \\note AirflowNetwork:MultiZone:Component:HorizontalOpening, or
      \\note AirflowNetwork:MultiZone:Component:ZoneExhaustFan.
      \\note When the zone exhaust fan name is entered, any surface control fields below A3 are
      \\note ignored when the zone exhaust fan turns on.
  A3, \\field External Node Name
      \\type object-list
      \\object-list ExternalNodeNames
      \\note Used if Wind Pressure Coefficient Type = Input in the AirflowNetwork:SimulationControl object,
      \\note otherwise this field may be left blank.
  N1, \\field Window/Door Opening Factor, or Crack Factor
      \\required-field
      \\type real
      \\units dimensionless
      \\minimum> 0.0
      \\maximum 1.0
      \\default 1.0
      \\note This field specifies a multiplier for a crack, window, or door.
  A4, \\field Ventilation Control Mode
      \\type choice
      \\key Temperature
      \\key Enthalpy
      \\key Constant
      \\key ASHRAE55Adaptive
      \\key CEN15251Adaptive
      \\key NoVent
      \\key ZoneLevel
      \\key AdjacentTemperature
      \\key AdjacentEnthalpy
      \\default ZoneLevel
      \\note When Ventilation Control Mode = Temperature or Enthalpy, the following
      \\note fields are used to modulate the Ventilation Open Factor for a
      \\note window or door opening according to the parent zone's
      \\note indoor-outdoor temperature or enthalpy difference.
      \\note When Ventilation Control Mode = AdjacentTemperature or AdjacentEnthalpy, the following
      \\note fields are used to modulate the Ventilation Open Factor for an interior
      \\note window or door opening according to temperature or enthalpy difference
      \\note between the parent zone and the adjacent zone.
      \\note Constant: controlled by field Venting Schedule Name.
      \\note NoVent: control will not open window or door during simulation (Ventilation Open Factor = 0).
      \\note ZoneLevel: control will be controlled by AirflowNetwork:MultiZone:Zone
      \\note Mode.
  A5, \\field Ventilation Control Zone Temperature Setpoint Schedule Name
      \\type object-list
      \\object-list ScheduleNames
      \\note Used only if Ventilation Control Mode = Temperature or Enthalpy.
  N2, \\field Minimum Venting Open Factor
      \\type real
      \\units dimensionless
      \\minimum 0.0
      \\maximum 1.0
      \\default 0.0
      \\note Used only if Ventilation Control Mode = Temperature or Enthalpy.
  N3, \\field Indoor and Outdoor Temperature Difference Lower Limit For Maximum Venting Open Factor
      \\note Applicable only if Ventilation Control Mode = Temperature
      \\type real
      \\units deltaC
      \\minimum 0.0
      \\maximum< 100
      \\default 0.0
  N4, \\field Indoor and Outdoor Temperature Difference Upper Limit for Minimun Venting Open Factor
      \\type real
      \\units deltaC
      \\minimum> 0.0
      \\default 100.0
      \\note Applicable only if Ventilation Control Mode = Temperature.
      \\note This value must be greater than the corresponding lower value (previous field).
  N5, \\field Indoor and Outdoor Enthalpy Difference Lower Limit For Maximum Venting Open Factor
      \\type real
      \\units deltaJ/kg
      \\minimum 0.0
      \\maximum< 300000.0
      \\default 0.0
      \\note Applicable only if Ventilation Control Mode = Enthalpy.
      \\note This value must be less than the corresponding upper value (next field).
  N6, \\field Indoor and Outdoor Enthalpy Difference Upper Limit for Minimun Venting Open Factor
      \\type real
      \\units deltaJ/kg
      \\minimum> 0.0
      \\default 300000.0
      \\note Applicable only if Ventilation Control Mode = Enthalpy.
      \\note This value must be greater than the corresponding lower value (previous field).
  A6; \\field Venting Availability Schedule Name
      \\type object-list
      \\object-list ScheduleNames
      \\note Non-zero schedule value means venting is allowed if other venting control conditions are
      \\note satisfied. A zero (or negative) schedule value means venting is not allowed under any
      \\note circumstances. The schedule values should be greater than or equal to 0 and less than or
      \\note equal to 1. If this schedule is not specified then venting is allowed if
      \\note other venting control conditions are satisfied.
      \\note Not used if Ventilation Control Mode = NoVent or ZoneLevel.

AirflowNetwork:MultiZone:ReferenceCrackConditions,
      \\min-fields 4
      \\memo This object specifies the conditions under which the air mass flow coefficient was measured.
 A1 , \\field Name
      \\required-field
      \\type alpha
      \\reference ReferenceCrackConditions
      \\note Enter a unique name for this object.
 N1 , \\field Reference Temperature
      \\type real
      \\units C
      \\default 20
      \\note Enter the reference temperature under which the surface crack data were obtained.
 N2 , \\field Reference Barometric Pressure
      \\type real
      \\units Pa
      \\default 101325
      \\minimum 31000
      \\maximum 120000
      \\ip-units inHg
      \\note Enter the reference barometric pressure under which the surface crack data were obtained.
 N3 ; \\field Reference Humidity Ratio
      \\type real
      \\units kgWater/kgDryAir
      \\default 0
      \\note Enter the reference humidity ratio under which the surface crack data were obtained.

AirflowNetwork:MultiZone:Surface:Crack,
      \\min-fields 3
      \\memo This object specifies the properties of airflow through a crack.
 A1 , \\field Name
      \\required-field
      \\type alpha
      \\reference SurfaceAirflowLeakageNames
      \\note Enter a unique name for this object.
 N1 , \\field Air Mass Flow Coefficient at Reference Conditions
      \\type real
      \\required-field
      \\units kg/s
      \\minimum> 0
      \\note Enter the air mass flow coefficient at the conditions defined
      \\note in the Reference Crack Conditions object.
      \\note Defined at 1 Pa pressure difference across this crack.
 N2 , \\field Air Mass Flow Exponent
      \\type real
      \\units dimensionless
      \\minimum 0.5
      \\maximum 1.0
      \\default 0.65
      \\note Enter the air mass flow exponent for the surface crack.
 A2 ; \\field Reference Crack Conditions
      \\type object-list
      \\object-list ReferenceCrackConditions
      \\note Select a AirflowNetwork:MultiZone:ReferenceCrackConditions name associated with
      \\note the air mass flow coefficient entered above.

AirflowNetwork:MultiZone:Surface:EffectiveLeakageArea,
      \\min-fields 5
      \\memo This object is used to define surface air leakage.
 A1 , \\field Name
      \\required-field
      \\type alpha
      \\reference SurfaceAirflowLeakageNames
      \\note Enter a unique name for this object.
 N1 , \\field Effective Leakage Area
      \\required-field
      \\type real
      \\units m2
      \\minimum> 0
      \\note Enter the effective leakage area.
 N2 , \\field Discharge Coefficient
      \\type real
      \\units dimensionless
      \\minimum> 0
      \\default 1.0
      \\note Enter the coefficient used in the air mass flow equation.
 N3 , \\field Reference Pressure Difference
      \\type real
      \\units Pa
      \\minimum> 0
      \\default 4.0
      \\note Enter the pressure difference used to define the air mass flow coefficient and exponent.
 N4 ; \\field Air Mass Flow Exponent
      \\units dimensionless
      \\type real
      \\default .65
      \\minimum 0.5
      \\maximum 1.0
      \\note Enter the exponent used in the air mass flow equation.

AirflowNetwork:MultiZone:Component:DetailedOpening,
      \\min-fields 16
      \\memo This object specifies the properties of airflow through windows and doors (window, door and
      \\memo glass door heat transfer subsurfaces) when they are closed or open.
 A1 , \\field Name
      \\required-field
      \\type alpha
      \\reference SurfaceAirflowLeakageNames
      \\note Enter a unique name for this object.
 N1 , \\field Air Mass Flow Coefficient When Opening is Closed
      \\required-field
      \\type real
      \\units kg/s-m
      \\minimum> 0
      \\note Defined at 1 Pa per meter of crack length. Enter the coefficient used in the following
      \\note equation:
      \\note Mass Flow Rate = Air Mass Flow Coefficient * (dP)^Air Mass Flow Exponent.
      \\note Used only when opening (window or door) is closed.
 N2 , \\field Air Mass Flow Exponent When Opening is Closed
      \\units dimensionless
      \\type real
      \\minimum 0.5
      \\maximum 1.0
      \\default 0.65
      \\note Enter the exponent used in the following equation:
      \\note Mass Flow Rate = Air Mass Flow Coefficient * (dP)^Air Mass Flow Exponent.
      \\note Used only when opening (window or door) is closed.
 A2 , \\field Type of Rectanguler Large Vertical Opening (LVO)
      \\type choice
      \\key NonPivoted
      \\key HorizontallyPivoted
      \\note Select the type of vertical opening: Non-pivoted opening or Horizontally pivoted opening.
      \\default NonPivoted
 N3 , \\field Extra Crack Length or Height of Pivoting Axis
      \\type real
      \\units m
      \\minimum 0
      \\default 0
      \\note Extra crack length is used for LVO Non-pivoted type with multiple openable parts.
      \\note Height of pivoting axis is used for LVO Horizontally pivoted type.
      \\note Specifies window or door characteristics that depend on the LVO type.
      \\note For Non-pivoted Type (rectangular windows and doors), this field is the extra crack length
      \\note in meters due to multiple openable parts, if present.  Extra here means in addition
      \\note to the length of the cracks on the top, bottom and sides of the window/door.
      \\note For Horizontally pivoted Type, this field gives the height of the
      \\note pivoting axis measured from the bottom of the glazed part of the window (m).
 N4 , \\field Number of Sets of Opening Factor Data
      \\required-field
      \\type integer
      \\minimum 2
      \\maximum 4
      \\note Enter the number of the following sets of data for opening factor,
      \\note discharge coefficient, width factor, height factor, and start height factor.
 N5 , \\field Opening Factor 1
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum 0
      \\default 0
      \\note This value must be specified as 0.
 N6 , \\field Discharge Coefficient for Opening Factor 1
      \\type real
      \\units dimensionless
      \\minimum> 0
      \\maximum 1
      \\default 0.001
      \\note The Discharge Coefficient indicates the fractional effectiveness
      \\note for air flow through a window or door at that Opening Factor.
 N7 , \\field Width Factor for Opening Factor 1
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum 1
      \\default 0
      \\note The Width Factor is the opening width divided by the window or door width.
 N8 , \\field Height Factor for Opening Factor 1
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum 1
      \\default 0
      \\note The Height Factor is the opening height divided by the window or door height.
 N9 , \\field Start Height Factor for Opening Factor 1
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum 1
      \\default 0
      \\note The Start Height Factor is the Start Height divided by the window or door height.
      \\note Start Height is the distance between the bottom of the window or door and the
      \\note bottom of the window or door opening. The sum of the Height Factor and the Start Height
      \\note Factor must be less than 1.0 in order to have the opening within the window or door
      \\note dimensions.
 N10, \\field Opening Factor 2
      \\required-field
      \\type real
      \\units dimensionless
      \\minimum> 0
      \\maximum 1
      \\note If Number of Sets of Opening Factor Data = 2, this value must be 1.0.
      \\note If Number of Sets of Opening Factor Data = 3, this value must be less than 1.0.
      \\note If Number of Sets of Opening Factor Data = 4, this value must be less than the
      \\note value entered for Opening factor 3 and greater than the value entered
      \\note for Opening factor 1.
 N11, \\field Discharge Coefficient for Opening Factor 2
      \\type real
      \\units dimensionless
      \\minimum> 0
      \\maximum 1
      \\default 1
      \\note The Discharge Coefficient indicates the fractional effectiveness
      \\note for air flow through a window or door at that Opening Factor.
 N12, \\field Width Factor for Opening Factor 2
      \\type real
      \\units dimensionless
      \\minimum> 0
      \\maximum 1
      \\default 1
      \\note The Width Factor is the opening width divided by the window or door width.
 N13, \\field Height Factor for Opening Factor 2
      \\type real
      \\units dimensionless
      \\minimum> 0
      \\maximum 1
      \\default 1
      \\note The Height Factor is the opening height divided by the window or door height.
 N14, \\field Start Height Factor for Opening Factor 2
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum< 1
      \\default 0
      \\note The Start Height Factor is the Start Height divided by the window or door height.
      \\note Start Height is the distance between the bottom of the window or door and the
      \\note bottom of the window or door opening. The sum of the Height Factor and the Start Height
      \\note Factor must be less than 1.0 in order to have the opening within the window or door
      \\note dimensions.
 N15, \\field Opening Factor 3
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum 1
      \\note If Number of Sets of Opening Factor Data = 3, this value must be 1.0.
      \\note If Number of Sets of Opening Factor Data = 4, this value must be less than 1.0,
      \\note and greater than value entered for Opening factor 2.
 N16, \\field Discharge Coefficient for Opening Factor 3
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum 1
      \\default 0
      \\note The Discharge Coefficient indicates the fractional effectiveness
      \\note for air flow through a window or door at that Opening Factor.
 N17, \\field Width Factor for Opening Factor 3
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum 1
      \\default 0
      \\note The Width Factor is the opening width divided by the window or door width.
 N18, \\field Height Factor for Opening Factor 3
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum 1
      \\default 0
      \\note The Height Factor is the opening height divided by the window or door height.
 N19, \\field Start Height Factor for Opening Factor 3
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum 1
      \\default 0
      \\note The Start Height Factor is the Start Height divided by the window or door height.
      \\note Start Height is the distance between the bottom of the window or door and the
      \\note bottom of the window or door opening. The sum of the Height Factor and the Start Height
      \\note Factor must be less than 1.0 in order to have the opening within the window or door
      \\note dimensions.
 N20, \\field Opening Factor 4
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum 1
      \\note If Number of Sets of Opening Factor Data = 4, this value must be 1.0
 N21, \\field Discharge Coefficient for Opening Factor 4
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum 1
      \\default 0
      \\note The Discharge Coefficient indicates the fractional effectiveness
      \\note for air flow through a window or door at that Opening Factor.
 N22, \\field Width Factor for Opening Factor 4
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum 1
      \\default 0
      \\note The Width Factor is the opening width divided by the window or door width.
 N23, \\field Height Factor for Opening Factor 4
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum 1
      \\default 0
      \\note The Height Factor is the opening height divided by the window or door height.
 N24; \\field Start Height Factor for Opening Factor 4
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum 1
      \\default 0
      \\note The Start Height Factor is the Start Height divided by the window or door height.
      \\note Start Height is the distance between the bottom of the window or door and the
      \\note bottom of the window or door opening. The sum of the Height Factor and the Start Height
      \\note Factor must be less than 1.0 in order to have the opening within the window or door
      \\note dimensions.

AirflowNetwork:MultiZone:Component:SimpleOpening,
      \\min-fields 5
      \\memo This object specifies the properties of air flow through windows and doors (window, door and
      \\memo glass door heat transfer subsurfaces) when they are closed or open.
 A1 , \\field Name
      \\required-field
      \\type alpha
      \\reference SurfaceAirflowLeakageNames
      \\note Enter a unique name for this object.
 N1 , \\field Air Mass Flow Coefficient When Opening is Closed
      \\required-field
      \\type real
      \\minimum> 0
      \\units kg/s-m
      \\note Defined at 1 Pa pressure difference. Enter the coefficient used in the following equation:
      \\note Mass Flow Rate = Air Mass Flow Coefficient * (dP)^Air Mass Flow Exponent.
      \\note Used only when opening (window or door) is closed.
 N2 , \\field Air Mass Flow Exponent When Opening is Closed
      \\units dimensionless
      \\type real
      \\default .65
      \\minimum 0.5
      \\maximum 1.0
      \\note Enter the exponent used in the following equation:
      \\note Mass Flow Rate = Air Mass Flow Coefficient * (dP)^Air Mass Flow Exponent.
      \\note Used only when opening (window or door) is closed.
 N3 , \\field Minimum Density Difference for Two-Way Flow
      \\required-field
      \\units kg/m3
      \\type real
      \\minimum> 0
      \\note Enter the minimum density difference above which two-way flow may occur due to stack effect.
 N4 ; \\field Discharge Coefficient
      \\required-field
      \\units dimensionless
      \\type real
      \\minimum> 0
      \\note The Discharge Coefficient indicates the fractional effectiveness
      \\note for air flow through a window or door at that Opening Factor.

AirflowNetwork:MultiZone:Component:HorizontalOpening,
      \\min-fields 5
      \\memo This object specifies the properties of air flow through a horizontal opening
 A1 , \\field Name
      \\required-field
      \\type alpha
      \\reference SurfaceAirflowLeakageNames
      \\note Enter a unique name for this object.
 N1 , \\field Air Mass Flow Coefficient When Opening is Closed
      \\required-field
      \\type real
      \\minimum> 0
      \\units kg/s-m
      \\note Defined at 1 Pa pressure difference. Enter the coefficient used in the following equation:
      \\note Mass flow rate = Air Mass Flow Coefficient * (dP)^Air Mass Flow Exponent.
      \\note Used only when opening is closed.
 N2 , \\field Air Mass Flow Exponent When Opening is Closed
      \\units dimensionless
      \\type real
      \\default .65
      \\minimum 0.5
      \\maximum 1.0
      \\note Enter the exponent used in the following equation:
      \\note Mass flow rate = Air Mass Flow Coefficient * (dP)^Air Mass Flow Exponent.
      \\note Used only when opening is closed.
 N3 , \\field Sloping Plane Angle
      \\units deg
      \\type real
      \\minimum> 0
      \\maximum 90
      \\default 90
      \\note Sloping plane angle = 90 is equivalent to fully open.
 N4 ; \\field Discharge Coefficient
      \\required-field
      \\units dimensionless
      \\type real
      \\minimum> 0
      \\note The Discharge Coefficient indicates the fractional effectiveness
      \\note for air flow through the opening at that Opening Factor.

AirflowNetwork:MultiZone:Component:ZoneExhaustFan,
      \\min-fields 3
      \\memo This object specifies the additional properties for a zone exhaust fan
      \\memo to perform multizone airflow calculations.
 A1 , \\field Name
      \\required-field
      \\type object-list
      \\object-list FansZoneExhaust
      \\note Enter the name of a Fan:ZoneExhaust object.
 N1 , \\field Air Mass Flow Coefficient When the Zone Exhaust Fan is Off at Reference Conditions
      \\required-field
      \\type real
      \\units kg/s
      \\minimum> 0
      \\note Enter the air mass flow coefficient at the conditions defined
      \\note in the Reference Crack Conditions object.
      \\note Defined at 1 Pa pressure difference. Enter the coefficient used in the following
      \\note equation:
      \\note Mass Flow Rate = Air Mass Flow Coefficient * (dP)^Air Mass Flow Exponent.
      \\note Used only when the fan is off.
 N2 , \\field Air Mass Flow Exponent When the Zone Exhaust Fan is Off
      \\units dimensionless
      \\type real
      \\minimum 0.5
      \\maximum 1.0
      \\default 0.65
      \\note Enter the exponent used in the following equation:
      \\note Mass Flow Rate = Air Mass Flow Coefficient * (dP)^Air Mass Flow Exponent.
      \\note Used only when the fan is off.
 A2 ; \\field Reference Crack Conditions
      \\type object-list
      \\object-list ReferenceCrackConditions
      \\note Select a AirflowNetwork:MultiZone:ReferenceCrackConditions name associated with
      \\note the air mass flow coefficient entered above.

AirflowNetwork:MultiZone:ExternalNode,
      \\min-fields 3
      \\memo This object defines outdoor environmental conditions outside of the building.
 A1 , \\field Name
      \\required-field
      \\type alpha
      \\reference ExternalNodeNames
      \\note Enter a unique name for this object.
      \\note This node name will be referenced by a particular building facade.
 N1 , \\field External Node Height
      \\type real
      \\units m
      \\default 0.0
      \\note Designates the reference height used to calculate relative pressure.
 A2 ; \\field Wind Pressure Coefficient Values Object Name
      \\required-field
      \\type object-list
      \\object-list WPCValueNames
      \\note Enter the name of the AirflowNetwork:MultiZone:WindPressureCoefficientValues object.

AirflowNetwork:MultiZone:WindPressureCoefficientArray,
      \\min-fields 3
      \\memo Used only if Wind Pressure Coefficient (WPC) Type = Input in the AirflowNetwork:SimulationControl
      \\memo object. Number of WPC Values in the corresponding AirflowNetwork:MultiZone:WindPressureCoefficientValues
      \\memo object must be the same as the number of wind directions specified for
      \\memo this AirflowNetwork:MultiZone:WindPressureCoefficientArray object.
 A1 , \\field Name
      \\required-field
      \\reference WPCSetNames
      \\type alpha
      \\note Enter a unique name for the object.
 N1 , \\field Wind Direction 1
      \\required-field
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 1st WPC Array value.
 N2 , \\field Wind Direction 2
      \\required-field
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 2nd WPC Array value.
 N3 , \\field Wind Direction 3
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 3rd WPC Array value.
 N4 , \\field Wind Direction 4
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 4th WPC Array value.
 N5 , \\field Wind Direction 5
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 5th WPC Array value.
 N6 , \\field Wind Direction 6
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 6th WPC Array value.
 N7 , \\field Wind Direction 7
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 7th WPC Array value.
 N8 , \\field Wind Direction 8
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 8th WPC Array value.
 N9 , \\field Wind Direction 9
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 9th WPC Array value.
 N10, \\field Wind Direction 10
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 10th WPC Array value.
 N11, \\field Wind Direction 11
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 11th WPC Array value.
 N12, \\field Wind Direction 12
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 12th WPC Array value.
 N13, \\field Wind Direction 13
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 13th WPC Array value.
 N14, \\field Wind Direction 14
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 14th WPC Array value.
 N15, \\field Wind Direction 15
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 15th WPC Array value.
 N16, \\field Wind Direction 16
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 16th WPC Array value.
 N17, \\field Wind Direction 17
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 17th WPC Array value.
 N18, \\field Wind Direction 18
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 18th WPC Array value.
 N19, \\field Wind Direction 19
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 19th WPC Array value.
 N20, \\field Wind Direction 20
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 20th WPC Array value.
 N21, \\field Wind Direction 21
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 21st WPC Array value.
 N22, \\field Wind Direction 22
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 22nd WPC Array value.
 N23, \\field Wind Direction 23
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 23rd WPC Array value.
 N24, \\field Wind Direction 24
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 24th WPC Array value.
 N25, \\field Wind Direction 25
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 25th WPC Array value.
 N26, \\field Wind Direction 26
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 26th WPC Array value.
 N27, \\field Wind Direction 27
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 27th WPC Array value.
 N28, \\field Wind Direction 28
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 28th WPC Array value.
 N29, \\field Wind Direction 29
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 29th WPC Array value.
 N30, \\field Wind Direction 30
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 30th WPC Array value.
 N31, \\field Wind Direction 31
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 31st WPC Array value.
 N32, \\field Wind Direction 32
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 32nd WPC Array value.
 N33, \\field Wind Direction 33
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 33rd WPC Array value.
 N34, \\field Wind Direction 34
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 34th WPC Array value.
 N35, \\field Wind Direction 35
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 35th WPC Array value.
 N36; \\field Wind Direction 36
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 36th WPC Array value.

AirflowNetwork:MultiZone:WindPressureCoefficientValues,
      \\min-fields 4
      \\memo Used only if Wind Pressure Coefficient (WPC) Type = INPUT in the AirflowNetwork:SimulationControl
      \\memo object. The number of WPC numeric inputs must correspond to the number of wind direction
      \\memo inputs in the AirflowNetwork:Multizone:WindPressureCoefficientArray object.
 A1 , \\field Name
      \\required-field
      \\type alpha
      \\reference WPCValueNames
      \\note Enter a unique name for this object.
 A2 , \\field AirflowNetwork:MultiZone:WindPressureCoefficientArray Name
      \\required-field
      \\type object-list
      \\object-list WPCSetNames
      \\note Enter the name of the AirflowNetwork:Multizone:WindPressureCoefficientArray object.
 N1 , \\field Wind Pressure Coefficient Value 1
      \\required-field
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 1st wind direction.
 N2 , \\field Wind Pressure Coefficient Value 2
      \\required-field
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 2nd wind direction.
 N3 , \\field Wind Pressure Coefficient Value 3
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 3rd wind direction.
 N4 , \\field Wind Pressure Coefficient Value 4
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 4th wind direction.
 N5 , \\field Wind Pressure Coefficient Value 5
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 5th wind direction.
 N6 , \\field Wind Pressure Coefficient Value 6
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 6th wind direction.
 N7 , \\field Wind Pressure Coefficient Value 7
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 7th wind direction.
 N8 , \\field Wind Pressure Coefficient Value 8
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 8th wind direction.
 N9 , \\field Wind Pressure Coefficient Value 9
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 9th wind direction.
 N10, \\field Wind Pressure Coefficient Value 10
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 10th wind direction.
 N11, \\field Wind Pressure Coefficient Value 11
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 11th wind direction.
 N12, \\field Wind Pressure Coefficient Value 12
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 12th wind direction.
 N13, \\field Wind Pressure Coefficient Value 13
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 13th wind direction.
 N14, \\field Wind Pressure Coefficient Value 14
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 14th wind direction.
 N15, \\field Wind Pressure Coefficient Value 15
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 15th wind direction.
 N16, \\field Wind Pressure Coefficient Value 16
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 16th wind direction.
 N17, \\field Wind Pressure Coefficient Value 17
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 17th wind direction.
 N18, \\field Wind Pressure Coefficient Value 18
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 18th wind direction.
 N19, \\field Wind Pressure Coefficient Value 19
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 19th wind direction.
 N20, \\field Wind Pressure Coefficient Value 20
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 20th wind direction.
 N21, \\field Wind Pressure Coefficient Value 21
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 21st wind direction.
 N22, \\field Wind Pressure Coefficient Value 22
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 22nd wind direction.
 N23, \\field Wind Pressure Coefficient Value 23
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 23rd wind direction.
 N24, \\field Wind Pressure Coefficient Value 24
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 24th wind direction.
 N25, \\field Wind Pressure Coefficient Value 25
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 25th wind direction.
 N26, \\field Wind Pressure Coefficient Value 26
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 26th wind direction.
 N27, \\field Wind Pressure Coefficient Value 27
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 27th wind direction.
 N28, \\field Wind Pressure Coefficient Value 28
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 28th wind direction.
 N29, \\field Wind Pressure Coefficient Value 29
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 29th wind direction.
 N30, \\field Wind Pressure Coefficient Value 30
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 30th wind direction.
 N31, \\field Wind Pressure Coefficient Value 31
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 31st wind direction.
 N32, \\field Wind Pressure Coefficient Value 32
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 32nd wind direction.
 N33, \\field Wind Pressure Coefficient Value 33
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 33rd wind direction.
 N34, \\field Wind Pressure Coefficient Value 34
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 34th wind direction.
 N35, \\field Wind Pressure Coefficient Value 35
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 35th wind direction.
 N36; \\field Wind Pressure Coefficient Value 36
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 36th wind direction.

AirflowNetwork:Distribution:Node,
      \\min-fields 4
      \\memo This object represents an air distribution node in the AirflowNetwork model.
 A1 , \\field Name
      \\required-field
      \\type alpha
      \\reference AirflowNetworkNodeAndZoneNames
      \\note Enter a unique name for this object.
 A2 , \\field Component Name or Node Name
      \\type alpha
      \\note Designates node names defined in another object. The node name may occur in air branches.
      \\note Enter a node name to represent a node already defined in an air loop.
      \\note Leave this field blank if the Node or Object Type field below is entered as
      \\note AirLoopHVAC:ZoneMixer, AirLoopHVAC:ZoneSplitter, AirLoopHVAC:OutdoorAirSystem, or Other.
 A3 , \\field Component Object Type or Node Type
      \\type choice
      \\key AirLoopHVAC:ZoneMixer
      \\key AirLoopHVAC:ZoneSplitter
      \\key AirLoopHVAC:OutdoorAirSystem
      \\key OAMixerOutdoorAirStreamNode
      \\key OutdoorAir:NodeList
      \\key OutdoorAir:Node
      \\key Other
      \\default Other
      \\note Designates Node type for the Node or Component Name defined in the field above.
      \\note AirLoopHVAC:ZoneMixer -- Represents a AirLoopHVAC:ZoneMixer object.
      \\note AirLoopHVAC:ZoneSplitter -- Represents a AirLoopHVAC:ZoneSplitter object.
      \\note AirLoopHVAC:OutdoorAirSystem -- Represents an AirLoopHVAC:OutdoorAirSystem object.
      \\note OAMixerOutdoorAirStreamNode -- Represents an external node used in the OutdoorAir:Mixer
      \\note OutdoorAir:NodeList -- Represents an external node when a heat exchanger is used before
      \\note the OutdoorAir:Mixer
      \\note OutdoorAir:Node -- Represents an external node when a heat exchanger is used before
      \\note the OutdoorAir:Mixer
      \\note Other -- none of the above, the Node name already defined in the previous field is part
      \\note of an air loop.
 N1 ; \\field Node Height
      \\type real
      \\units m
      \\default 0.0
      \\note Enter the reference height used to calculate the relative pressure.

AirflowNetwork:Distribution:Component:Leak,
      \\min-fields 3
      \\memo This object defines the characteristics of a supply or return air leak.
 A1 , \\field Name
      \\required-field
      \\type alpha
      \\reference AirflowNetworkComponentNames
      \\note Enter a unique name for this object.
 N1 , \\field Air Mass Flow Coefficient
      \\required-field
      \\type real
      \\units kg/s
      \\minimum> 0
      \\note Defined at 1 Pa pressure difference across this component.
      \\note Enter the coefficient used in the following equation:
      \\note Mass Flow Rate = Air Mass Flow Coefficient * (dP)^Air Mass Flow Exponent
 N2 ; \\field Air Mass Flow Exponent
      \\type real
      \\units dimensionless
      \\minimum 0.5
      \\maximum 1.0
      \\default 0.65
      \\note Enter the exponent used in the following equation:
      \\note Mass Flow Rate = Air Mass Flow Coefficient * (dP)^Air Mass Flow Exponent

AirflowNetwork:Distribution:Component:LeakageRatio,
      \\min-fields 5
      \\memo This object is used to define supply and return air leaks with respect to the fan's maximum
      \\memo air flow rate.
 A1 , \\field Name
      \\required-field
      \\type alpha
      \\reference AirflowNetworkComponentNames
      \\note Enter a unique name for this object.
 N1 , \\field Effective Leakage Ratio
      \\type real
      \\units dimensionless
      \\minimum> 0.0
      \\maximum 1.0
      \\note Defined as a ratio of leak flow rate to the maximum flow rate.
 N2 , \\field Maximum Flow Rate
      \\required-field
      \\units m3/s
      \\type real
      \\minimum> 0.0
      \\note Enter the maximum air flow rate in this air loop.
 N3 , \\field Reference Pressure Difference
      \\required-field
      \\units Pa
      \\type real
      \\minimum> 0.0
      \\note Enter the pressure corresponding to the Effective leakage ratio entered above.
 N4 ; \\field Air Mass Flow Exponent
      \\units dimensionless
      \\type real
      \\default 0.65
      \\minimum 0.5
      \\maximum 1.0
      \\note Enter the exponent used in the air mass flow equation.

AirflowNetwork:Distribution:Component:Duct,
      \\min-fields 8
      \\memo This object defines the relationship between pressure and air flow through the duct.
 A1 , \\field Name
      \\required-field
      \\type alpha
      \\reference AirflowNetworkComponentNames
      \\note Enter a unique name for this object.
 N1 , \\field Duct Length
      \\required-field
      \\type real
      \\units m
      \\minimum> 0.0
      \\note Enter the length of the duct.
 N2 , \\field Hydraulic Diameter
      \\required-field
      \\type real
      \\units m
      \\minimum> 0.0
      \\note Enter the hydraulic diameter of the duct.
      \\note Hydraulic diameter is defined as 4 multiplied by cross section area divided by perimeter
 N3 , \\field Cross Section Area
      \\required-field
      \\type real
      \\units m2
      \\minimum> 0.0
      \\note Enter the cross section area of the duct.
 N4 , \\field Surface Roughness
      \\type real
      \\units m
      \\default 0.0009
      \\minimum> 0.0
      \\note Enter the inside surface roughness of the duct.
 N5 , \\field Coefficient for Local Dynamic Loss Due to Fitting
      \\type real
      \\units dimensionless
      \\default 0.0
      \\minimum 0.0
      \\note Enter the coefficient used to calculate dynamic losses of fittings (e.g. elbows).
 N6 , \\field Overall Heat Transmittance Coefficient (U-Factor) from Air to Air
      \\note including film coefficients at both surfaces
      \\type real
      \\units W/m2-K
      \\minimum> 0.0
      \\default 0.772
      \\note Enter the overall U-value for this duct.
      \\note Default value of 0.772 is equivalent to 1.06 m2-K/W (R6) duct insulation with
      \\note film coefficients for outside and inside equal to 5 and 25 W/m2-K, respectively.
 N7 ; \\field Overall Moisture Transmittance Coefficient from Air to Air
      \\type real
      \\units kg/m2
      \\minimum> 0.0
      \\default 0.001
      \\note Enter the overall moisture transmittance coefficient
      \\note including moisture film coefficients at both surfaces.

AirflowNetwork:Distribution:Component:Fan,
      \\min-fields 2
      \\memo This object defines the name of the constant volume supply Air Fan used in an Air loop.
 A1 , \\field Fan Name
      \\required-field
      \\type object-list
      \\object-list FansCVandOnOff
      \\reference AirflowNetworkComponentNames
      \\note Enter the name of the constant volume fan in the primary air loop.
 A2 ; \\field Supply Fan Object Type
      \\type choice
      \\key Fan:OnOff
      \\key Fan:ConstantVolume
      \\key Fan:VariableVolume
      \\default Fan:ConstantVolume

AirflowNetwork:Distribution:Component:Coil,
      \\min-fields 4
      \\memo This object defines the name of a coil used in an air loop.
 A1 , \\field Coil Name
      \\required-field
      \\type object-list
      \\reference AirflowNetworkComponentNames
      \\object-list AFNCoilNames
      \\note Enter the name of a cooling or heating coil in the primary Air loop.
 A2 , \\field Coil Object Type
      \\required-field
      \\type choice
      \\key Coil:Cooling:DX:SingleSpeed
      \\key Coil:Heating:Gas
      \\key Coil:Heating:Electric
      \\key Coil:Heating:DX:SingleSpeed
      \\key Coil:Cooling:Water
      \\key Coil:Heating:Water
      \\key Coil:Cooling:Water:DetailedGeometry
      \\key Coil:Cooling:DX:TwoStageWithHumidityControlMode
      \\key Coil:Cooling:DX:MultiSpeed
      \\key Coil:Heating:DX:MultiSpeed
      \\key Coil:Heating:Desuperheater
      \\note Select the type of coil corresponding to the name entered in the field above.
 N1 , \\field Air Path Length
      \\required-field
      \\type real
      \\units m
      \\minimum> 0
      \\note Enter the air path length (depth) for the coil.
 N2 ; \\field Air Path Hydraulic Diameter
      \\required-field
      \\units m
      \\type real
      \\minimum> 0
      \\note Enter the hydraulic diameter of this coil. The hydraulic diameter is
      \\note defined as 4 multiplied by the cross section area divided by perimeter.

AirflowNetwork:Distribution:Component:HeatExchanger,
      \\min-fields 4
      \\memo This object defines the name of an air-to-air heat exchanger used in an air loop.
 A1 , \\field HeatExchanger Name
      \\required-field
      \\type object-list
      \\object-list AFNHeatExchangerNames
      \\reference AirflowNetworkComponentNames
      \\note Enter the name of an air-to-air heat exchanger in the primary Air loop.
 A2 , \\field HeatExchanger Object Type
      \\required-field
      \\type choice
      \\key HeatExchanger:AirToAir:FlatPlate
      \\key HeatExchanger:AirToAir:SensibleAndLatent
      \\key HeatExchanger:Desiccant:BalancedFlow
      \\note Select the type of heat exchanger corresponding to the name entered in the field above.
 N1 , \\field Air Path Length
      \\required-field
      \\type real
      \\units m
      \\minimum> 0
      \\note Enter the air path length (depth) for the heat exchanger.
 N2 ; \\field Air Path Hydraulic Diameter
      \\required-field
      \\units m
      \\type real
      \\minimum> 0
      \\note Enter the hydraulic diameter of this heat exchanger. The hydraulic diameter is
      \\note defined as 4 multiplied by the cross section area divided by perimeter.

AirflowNetwork:Distribution:Component:TerminalUnit,
      \\min-fields 4
      \\memo This object defines the name of a terminal unit in an air loop.
 A1 , \\field Terminal Unit Name
      \\required-field
      \\type object-list
      \\reference AirflowNetworkComponentNames
      \\object-list AFNTerminalUnitNames
      \\note Enter the name of a terminal unit in the AirLoopHVAC.
 A2 , \\field Terminal Unit Object Type
      \\required-field
      \\type choice
      \\key AirTerminal:SingleDuct:ConstantVolume:Reheat
      \\key AirTerminal:SingleDuct:VAV:Reheat
      \\note Select the type of terminal unit corresponding to the name entered in the field above.
 N1 , \\field Air Path Length
      \\required-field
      \\type real
      \\units m
      \\minimum> 0
      \\note Enter the air path length (depth) for the terminal unit.
 N2 ; \\field Air Path Hydraulic Diameter
      \\required-field
      \\units m
      \\type real
      \\minimum> 0
      \\note Enter the hydraulic diameter of this terminal unit. The hydraulic diameter is
      \\note defined as 4 multiplied by the cross section area divided by perimeter.

AirflowNetwork:Distribution:Component:ConstantPressureDrop,
      \\min-fields 2
      \\memo This object defines the characteristics of a constant pressure drop component (e.g. filter).
      \\memo Each node connected to this object can not be a node of mixer, splitter, a node of air primary
      \\memo loop, or zone equipment loop. It is recommended to connect to a duct component at both ends.
 A1 , \\field Name
      \\required-field
      \\type alpha
      \\reference AirflowNetworkComponentNames
      \\note Enter a unique name for this object.
 N1 ; \\field Pressure Difference Across the Component
      \\required-field
      \\units Pa
      \\type real
      \\minimum> 0.0
      \\note Enter the pressure drop across this component.

AirflowNetwork:Distribution:Linkage,
      \\min-fields 4
      \\memo This object defines the connection between two nodes and a component.
 A1 , \\field Name
      \\required-field
      \\type alpha
      \\note Enter a unique name for this object.
      \\reference AirflowNetwork LinkageNames
 A2 , \\field Node 1 Name
      \\required-field
      \\type alpha
      \\object-list AirflowNetworkNodeAndZoneNames
      \\note Enter the name of zone or AirflowNetwork Node.
 A3 , \\field Node 2 Name
      \\required-field
      \\type alpha
      \\object-list AirflowNetworkNodeAndZoneNames
      \\note Enter the name of zone or AirflowNetwork Node.
 A4 , \\field Component Name
      \\required-field
      \\type object-list
      \\object-list AirflowNetworkComponentNames
      \\note Enter the name of an AirflowNetwork component. A component is one of the
      \\note following AirflowNetwork:Distribution:Component objects: Leak, LeakageRatio,
      \\note Duct, ConstantVolumeFan, Coil, TerminalUnit, ConstantPressureDrop, or HeatExchanger.
 A5 ; \\field Thermal Zone Name
      \\type object-list
      \\object-list ZoneNames
      \\note Only used if component = AirflowNetwork:Distribution:Component:Duct
      \\note The zone name is where AirflowNetwork:Distribution:Component:Duct is exposed. Leave this field blank if the duct
      \\note conduction loss is ignored.

\\group Exterior Equipment
       ! This equipment is used merely for reporting.
Exterior:Lights,
       \\memo only used for Meter type reporting, does not affect building loads
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ExteriorLightsNames
  A2 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note units in schedule should be fraction applied to capacity of the exterior lights equipment, generally (0.0 - 1.0)
  N1 , \\field Design Level
       \\required-field
       \\units W
       \\type real
       \\minimum 0
       \\ip-units W
  A3,  \\field Control Option
       \\note Astronomical Clock option overrides schedule to turn lights off when sun is up
       \\type choice
       \\key ScheduleNameOnly
       \\key AstronomicalClock
  A4 ; \\field End-Use Subcategory
       \\type alpha
       \\retaincase
       \\default General

Exterior:FuelEquipment,
       \\memo only used for Meter type reporting, does not affect building loads
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ExteriorFuelEquipmentNames
  A2 , \\field Fuel Use Type
       \\required-field
       \\type choice
       \\key Electricity
       \\key NaturalGas
       \\key PropaneGas
       \\key FuelOil#1
       \\key FuelOil#2
       \\key Diesel
       \\key Gasoline
       \\key Coal
       \\key OtherFuel1
       \\key OtherFuel2
       \\key Steam
       \\key DistrictHeating
       \\key DistrictCooling
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note units in schedule should be fraction applied to capacity of the exterior fuel equipment, generally (0.0 - 1.0)
  N1 , \\field Design Level
       \\required-field
       \\units W
       \\type real
       \\minimum 0
       \\ip-units W
  A4 ; \\field End-Use Subcategory
       \\type alpha
       \\retaincase
       \\default General

Exterior:WaterEquipment,
       \\memo only used for Meter type reporting, does not affect building loads
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ExteriorWaterEquipmentNames
  A2 , \\field Fuel Use Type
       \\type choice
       \\key Water
       \\default Water
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note units in Schedule should be fraction applied to capacity of the exterior water equipment, generally (0.0 - 1.0)
  N1 , \\field Design Level
       \\required-field
       \\units m3/s
       \\type real
       \\minimum 0
  A4 ; \\field End-Use Subcategory
       \\type alpha
       \\retaincase
       \\default General

!****************************************************************************************
!*                   BUILDING/SYSTEM LOOP SPECIFICATIONS                                *
!*                                                                                      *
!*        The following syntax specifies the Loops, and equipment associated            *
!*        with HVAC and Building Systems.  Specifications include Plant Loops,          *
!*        Condenser Loops, Air Loops and Zone Equipment.  The following conventions     *
!*        are followed:                                                                 *
!*          1.  The word 'KEY' followed by a description indicates that the alpha       *
!*              string must be selected from the list indicated by the key description. *
!*          2.  The syntax is organized in the following major blocks:                  *
!*               --PLANT LOOP SPECIFICATION                                             *
!*               --CONDENSER LOOP SPECIFICATION
!*               --AIR LOOP SPECIFICATION
!*               --ZONE EQUIPMENT SPECIFICATION
!*               --FLOW CONTROL
!*               --PLANT LOOP CONNECTORS
!*               --PLANT EQUIPMENT
!*               --CONDENSING EQUIPMENT
!*               --PUMPS
!*               --COILS
!*               --AIR LOOP COMPONENTS
!*               --AIR DISTRIBUTION UNITS
!*               --LOCAL CONVECTIVE EQUIPMENT
!*               --HIGH TEMPERATURE RADIANT CONVECTIVE UNITS
!*               --LOW TEMPERATURE RADIANT CONVECTIVE UNITS
!*               --AIR LOOP CONNECTORS
!*               --System Control and Controllers
!************************************************************************************

\\Group HVAC Templates

HVACTemplate:Thermostat,
      \\min-fields 5
      \\memo Zone thermostat control.  Referenced schedules must be
      \\memo defined elsewhere in the idf.  Thermostat control type is
      \\memo dual setpoint with deadband.  It is not necessary to create
      \\memo a thermostat object for every zone, only for each unique
      \\memo set of setpoint schedules.  For example, an office building
      \\memo may have two thermostat objects, one for "Office" and one
      \\memo for "Storage".
  A1, \\field Name
      \\required-field
      \\note This name is referenced by HVACTemplate:Zone:* objects
      \\reference CompactHVACThermostats
  A2, \\field Heating Setpoint Schedule Name
      \\note  Leave blank if constant setpoint specified below, must enter schedule or constant setpoint
      \\type object-list
      \\object-list ScheduleNames
  N1, \\field Constant Heating Setpoint
      \\note  Ignored if schedule specified above, must enter schedule or constant setpoint
      \\units C
  A3, \\field Cooling Setpoint Schedule Name
      \\note  Leave blank if constant setpoint specified below, must enter schedule or constant setpoint
      \\type object-list
      \\object-list ScheduleNames
  N2; \\field Constant Cooling Setpoint
      \\note  Ignored if schedule specified above, must enter schedule or constant setpoint
      \\units C

HVACTemplate:Zone:IdealLoadsAirSystem,
      \\min-fields 2
      \\memo Zone with ideal air system that meets heating or cooling loads
  A1, \\field Zone Name
      \\required-field
      \\note Zone name must match a building zone name
      \\type object-list
      \\object-list ZoneNames
  A2; \\field Template Thermostat Name
      \\note Enter the name of a HVACTemplate:Thermostat object.
      \\note If blank, then it is assumed that standard thermostat objects
      \\note have been defined for this zone.
      \\type object-list
      \\object-list CompactHVACThermostats

HVACTemplate:Zone:FanCoil,
      \\min-fields 25
      \\memo 4 pipe fan coil unit with optional outdoor air.
  A1, \\field Zone Name
      \\required-field
      \\note Zone name must match a building zone name
      \\type object-list
      \\object-list ZoneNames
  A2, \\field Template Thermostat Name
      \\note Enter the name of a HVACTemplate:Thermostat object.
      \\note If blank, then it is assumed that standard thermostat objects
      \\note have been defined for this zone.
      \\type object-list
      \\object-list CompactHVACThermostats
  N1, \\field Supply Air Maximum Flow Rate
      \\note This field may be set to "autosize".  If a value is entered, it will be
      \\note multiplied by the Supply Air Sizing Factor and by zone multipliers.
      \\autosizable
      \\default autosize
      \\units m3/s
  N2, \\field Zone Heating Sizing Factor
      \\note If blank, value from Sizing:Parameters will be used.
  N3, \\field Zone Cooling Sizing Factor
      \\note If blank, value from Sizing:Parameters will be used.
  A3, \\field Outdoor Air Method
      \\note Flow/Person, Flow/Zone, Flow/Area, Sum, and Maximum use the values in the next three
      \\note fields: Outdoor Air Flow Rate per Person, Outdoor Air Flow Rate per Zone Floor Area,
      \\note and Outdoor Air Flow Rate per Zone.
      \\note DetailedSpecification ignores these three Outdoor Air Flow Rate fields and instead
      \\note references design specification objects named in the fields
      \\note Design Specification Outdoor Air Object Name and Design Specification Zone Air
      \\note Distribution Object Name.
      \\type choice
      \\key Flow/Person
      \\key Flow/Zone
      \\key Flow/Area
      \\key Sum
      \\key Maximum
      \\key DetailedSpecification
      \\default Flow/Person
  N4, \\field Outdoor Air Flow Rate per Person
      \\units m3/s
      \\note Default 0.00944 is 20 cfm per person
      \\note This input is used if the field Outdoor Air Method is
      \\note Flow/Person, Sum, or Maximum
      \\default 0.00944
  N5, \\field Outdoor Air Flow Rate per Zone Floor Area
      \\units m3/s-m2
      \\default 0.0
      \\note This input is used if the field Outdoor Air Method is
      \\note Flow/Area, Sum, or Maximum
  N6, \\field Outdoor Air Flow Rate per Zone
      \\type real
      \\units m3/s
      \\default 0.0
      \\note This input is used if the field Outdoor Air Method is
      \\note Flow/Zone, Sum, or Maximum
  A4, \\field System Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
  N7, \\field Supply Fan Total Efficiency
      \\minimum> 0.0
      \\maximum 1.0
      \\default 0.7
  N8, \\field Supply Fan Delta Pressure
      \\units Pa
      \\ip-units inH2O
      \\minimum 0
      \\default 75
  N9, \\field Supply Fan Motor Efficiency
      \\minimum> 0.0
      \\maximum 1.0
      \\default 0.9
 N10, \\field Supply Fan Motor in Air Stream Fraction
      \\minimum 0.0
      \\maximum 1.0
      \\default 1.0
  A5, \\field Cooling Coil Type
      \\type choice
      \\key  ChilledWater
      \\key  ChilledWaterDetailedFlatModel
      \\default  ChilledWater
  A6, \\field Cooling Coil Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
 N11, \\field Cooling Coil Design Setpoint
      \\note Used for sizing when Zone Cooling Design
      \\note Supply Air Temperature Input Method = SupplyAirTemperature
      \\default 14.0
      \\units C
  A7, \\field Heating Coil Type
      \\type choice
      \\key  HotWater
      \\default HotWater
  A8, \\field Heating Coil Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
 N12, \\field Heating Coil Design Setpoint
      \\note Used for sizing when Zone Heating Design
      \\note Supply Air Temperature Input Method = SupplyAirTemperature
      \\default 50.0
      \\units C
  A9, \\field Dedicated Outdoor Air System Name
      \\note Enter the name of an HVACTemplate:System:DedicatedOutdoorAir object if this
      \\note zone is served by a separate dedicated outdoor air system (DOAS).
      \\note Leave field blank if no DOAS serves this zone.
      \\type object-list
      \\object-list HVACTemplateDOASSystems
 A10, \\field Zone Cooling Design Supply Air Temperature Input Method
      \\note SupplyAirTemperature = use the value from Cooling Coil Design Setpoint (above)
      \\note TemperatureDifference = use the value from Zone Cooling Design Supply Air Temperature Difference
      \\type choice
      \\key SupplyAirTemperature
      \\key TemperatureDifference
      \\default SupplyAirTemperature
 N13, \\field Zone Cooling Design Supply Air Temperature Difference
      \\type real
      \\units deltaC
      \\default 11.11
      \\note Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
      \\note Supply Air Temperature Input Method = TemperatureDifference
      \\note The absolute value of this field will be subtracted from the zone temperature
      \\note at peak load to calculate the Zone Cooling Design Supply Air Temperature.
 A11, \\field Zone Heating Design Supply Air Temperature Input Method
      \\note SupplyAirTemperature = use the value from Heating Coil Design Setpoint (above)
      \\note TemperatureDifference = use the value from Zone Heating Design Supply Air Temperature Difference
      \\type choice
      \\key SupplyAirTemperature
      \\key TemperatureDifference
      \\default SupplyAirTemperature
 N14, \\field Zone Heating Design Supply Air Temperature Difference
      \\type real
      \\units deltaC
      \\default 30.0
      \\note Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
      \\note Supply Air Temperature Input Method = TemperatureDifference
      \\note The absolute value of this field will be added to the zone temperature
      \\note at peak load to calculate the Zone Heating Design Supply Air Temperature.
 A12, \\field Design Specification Outdoor Air Object Name
      \\note This field is used only when Outdoor Air Method=DetailedSpecification.
      \\type object-list
      \\object-list DesignSpecificationOutdoorAirNames
 A13; \\field Design Specification Zone Air Distribution Object Name
      \\note This field is used only when Outdoor Air Method=DetailedSpecification.
      \\type object-list
      \\object-list DesignSpecificationZoneAirDistributionNames

HVACTemplate:Zone:PTAC,
      \\min-fields 34
      \\memo Packaged Terminal Air Conditioner
  A1, \\field Zone Name
      \\required-field
      \\note Zone name must match a building zone name
      \\type object-list
      \\object-list ZoneNames
  A2, \\field Template Thermostat Name
      \\note Enter the name of a HVACTemplate:Thermostat object.
      \\note If blank, then it is assumed that standard thermostat objects
      \\note have been defined for this zone.
      \\type object-list
      \\object-list CompactHVACThermostats
  N1, \\field Cooling Supply Air Flow Rate
      \\note Supply air flow rate during cooling operation
      \\note This field may be set to "autosize".  If a value is entered, it will be
      \\note multiplied by the Supply Air Sizing Factor and by zone multipliers.
      \\type real
      \\minimum> 0.0
      \\autosizable
      \\default autosize
      \\units m3/s
  N2, \\field Heating Supply Air Flow Rate
      \\note Supply air flow rate during heating operation
      \\note This field may be set to "autosize".  If a value is entered, it will be
      \\note multiplied by the Supply Air Sizing Factor and by zone multipliers.
      \\type real
      \\minimum> 0.0
      \\autosizable
      \\default autosize
      \\units m3/s
  N3, \\field No Load Supply Air Flow Rate
      \\note Supply air flow rate when no cooling or heating is needed
      \\note Only used when heat pump fan operating mode is continuous. This air flow rate
      \\note is used when no heating or cooling is required and the DX coil compressor is off.
      \\note If this field is left blank or zero, the supply air flow rate from the previous on cycle
      \\note (either cooling or heating) is used.
      \\note A value entered in this field will *not* be multiplied by the sizing factor or
      \\note by zone multipliers.  It is best to autosize or leave blank when using zone multipliers.
      \\type real
      \\minimum 0
      \\autosizable
      \\units m3/s
  N4, \\field Zone Heating Sizing Factor
      \\note If blank, value from Sizing:Parameters will be used.
  N5, \\field Zone Cooling Sizing Factor
      \\note If blank, value from Sizing:Parameters will be used.
  A3, \\field Outdoor Air Method
      \\note Flow/Person, Flow/Zone, Flow/Area, Sum, and Maximum use the values in the next three
      \\note fields: Outdoor Air Flow Rate per Person, Outdoor Air Flow Rate per Zone Floor Area,
      \\note and Outdoor Air Flow Rate per Zone.
      \\note DetailedSpecification ignores these three Outdoor Air Flow Rate fields and instead
      \\note references design specification objects named in the fields
      \\note Design Specification Outdoor Air Object Name and Design Specification Zone Air
      \\note Distribution Object Name.
      \\type choice
      \\key Flow/Person
      \\key Flow/Zone
      \\key Flow/Area
      \\key Sum
      \\key Maximum
      \\key DetailedSpecification
      \\default Flow/Person
  N6, \\field Outdoor Air Flow Rate per Person
      \\units m3/s
      \\note Default 0.00944 is 20 cfm per person
      \\note This input is used if the field Outdoor Air Method is
      \\note Flow/Person, Sum, or Maximum
      \\default 0.00944
  N7, \\field Outdoor Air Flow Rate per Zone Floor Area
      \\units m3/s-m2
      \\default 0.0
      \\note This input is used if the field Outdoor Air Method is
      \\note Flow/Area, Sum, or Maximum
  N8, \\field Outdoor Air Flow Rate per Zone
      \\type real
      \\units m3/s
      \\default 0.0
      \\note This input is used if the field Outdoor Air Method is
      \\note Flow/Zone, Sum, or Maximum
  A4, \\field System Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
  A5, \\field Supply Fan Operating Mode Schedule Name
      \\note Refers to a schedule to specify unitary supply fan operating mode.
      \\note Schedule Name values of 0 indicate cycling fan (auto)
      \\note Schedule values of 1 indicate continuous fan (on)
      \\note Keywords "Cycling" or "Continuous" may also be used here.
      \\type object-list
      \\object-list ScheduleNames
      \\default Cycling
  A6, \\field Supply Fan Placement
      \\type choice
      \\key BlowThrough
      \\key DrawThrough
      \\default DrawThrough
  N9, \\field Supply Fan Total Efficiency
      \\minimum> 0.0
      \\maximum 1.0
      \\default 0.7
 N10, \\field Supply Fan Delta Pressure
      \\units Pa
      \\ip-units inH2O
      \\minimum 0
      \\default 75
 N11, \\field Supply Fan Motor Efficiency
      \\minimum> 0.0
      \\maximum 1.0
      \\default 0.9
  A7, \\field Cooling Coil Type
      \\type choice
      \\key  SingleSpeedDX
      \\default SingleSpeedDX
  A8, \\field Cooling Coil Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
 N12, \\field Cooling Coil Rated Capacity
      \\note Gross capacity excluding effect of supply air fan heat
      \\note Rating point: air entering the cooling coil at 26.7 C dry-bulb/19.4 C wet-bulb, and
      \\note air entering the outdoor condenser coil at 35 C dry-bulb/23.9 C wet-bulb
      \\type real
      \\minimum> 0.0
      \\autosizable
      \\default autosize
      \\units W
 N13, \\field Cooling Coil Rated Sensible Heat Ratio
      \\note Rated sensible heat ratio (gross sensible capacity/gross total capacity)
      \\note Sensible and total capacities do not include effect of supply fan heat
      \\type real
      \\autosizable
      \\minimum 0.5
      \\maximum 1.0
      \\default autosize
 N14, \\field Cooling Coil Rated COP
      \\note Gross cooling capacity divided by power input to the compressor and outdoor fan,
      \\note does not include supply fan heat or supply fan electrical energy input
      \\type real
      \\units W/W
      \\minimum> 0.0
      \\default 3.0
  A9, \\field Heating Coil Type
      \\type choice
      \\key  Electric
      \\key  HotWater
      \\key  Gas
      \\default Electric
 A10, \\field Heating Coil Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
 N15, \\field Heating Coil Capacity
      \\autosizable
      \\default autosize
      \\units W
 N16, \\field Gas Heating Coil Efficiency
      \\note Applies only if Heating Coil Type is Gas
      \\maximum 1.0
      \\minimum 0.0
      \\default 0.8
 N17, \\field Gas Heating Coil Parasitic Electric Load
      \\note Applies only if Heating Coil Type is Gas
      \\units W
      \\ip-units W
      \\minimum 0.0
      \\default 0.0
 A11, \\field Dedicated Outdoor Air System Name
      \\note Enter the name of an HVACTemplate:System:DedicatedOutdoorAir object if this
      \\note zone is served by a separate dedicated outdoor air system (DOAS).
      \\note Leave field blank if no DOAS serves this zone.
      \\type object-list
      \\object-list HVACTemplateDOASSystems
 A12, \\field Zone Cooling Design Supply Air Temperature Input Method
      \\note SupplyAirTemperature = use the value from Zone Cooling Design Supply Air Temperature
      \\note TemperatureDifference = use the value from Zone Cooling Design Supply Air Temperature Difference
      \\type choice
      \\key SupplyAirTemperature
      \\key TemperatureDifference
      \\default SupplyAirTemperature
 N18, \\field Zone Cooling Design Supply Air Temperature
      \\type real
      \\units C
      \\default 14.0
      \\note Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
      \\note Supply Air Temperature Input Method = SupplyAirTemperature
 N19, \\field Zone Cooling Design Supply Air Temperature Difference
      \\type real
      \\units deltaC
      \\default 11.11
      \\note Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
      \\note Supply Air Temperature Input Method = TemperatureDifference
      \\note The absolute value of this field will be subtracted from the zone temperature
      \\note at peak load to calculate the Zone Cooling Design Supply Air Temperature.
 A13, \\field Zone Heating Design Supply Air Temperature Input Method
      \\note SupplyAirTemperature = use the value from Zone Heating Design Supply Air Temperature
      \\note TemperatureDifference = use the value from Zone Heating Design Supply Air Temperature Difference
      \\type choice
      \\key SupplyAirTemperature
      \\key TemperatureDifference
      \\default SupplyAirTemperature
 N20, \\field Zone Heating Design Supply Air Temperature
      \\type real
      \\units C
      \\default 50.0
      \\note Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
      \\note Supply Air Temperature Input Method = SupplyAirTemperature
 N21, \\field Zone Heating Design Supply Air Temperature Difference
      \\type real
      \\units deltaC
      \\default 30.0
      \\note Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
      \\note Supply Air Temperature Input Method = TemperatureDifference
      \\note The absolute value of this field will be added to the zone temperature
      \\note at peak load to calculate the Zone Heating Design Supply Air Temperature.
 A14, \\field Design Specification Outdoor Air Object Name
      \\note This field is used only when Outdoor Air Method=DetailedSpecification.
      \\type object-list
      \\object-list DesignSpecificationOutdoorAirNames
 A15; \\field Design Specification Zone Air Distribution Object Name
      \\note This field is used only when Outdoor Air Method=DetailedSpecification.
      \\type object-list
      \\object-list DesignSpecificationZoneAirDistributionNames

HVACTemplate:Zone:PTHP,
      \\min-fields 44
      \\memo Packaged Terminal Heat Pump
  A1, \\field Zone Name
      \\required-field
      \\note Zone name must match a building zone name
      \\type object-list
      \\object-list ZoneNames
  A2, \\field Template Thermostat Name
      \\note Enter the name of a HVACTemplate:Thermostat object.
      \\note If blank, then it is assumed that standard thermostat objects
      \\note have been defined for this zone.
      \\type object-list
      \\object-list CompactHVACThermostats
  N1, \\field Cooling Supply Air Flow Rate
      \\note Supply air flow rate during cooling operation
      \\note This field may be set to "autosize".  If a value is entered, it will be
      \\note multiplied by the Supply Air Sizing Factor and by zone multipliers.
      \\type real
      \\minimum> 0.0
      \\autosizable
      \\default autosize
      \\units m3/s
  N2, \\field Heating Supply Air Flow Rate
      \\note Supply air flow rate during heating operation
      \\note This field may be set to "autosize".  If a value is entered, it will be
      \\note multiplied by the Supply Air Sizing Factor and by zone multipliers.
      \\type real
      \\minimum> 0.0
      \\autosizable
      \\default autosize
      \\units m3/s
  N3, \\field No Load Supply Air Flow Rate
      \\note Supply air flow rate when no cooling or heating is needed
      \\note Only used when heat pump fan operating mode is continuous. This air flow rate
      \\note is used when no heating or cooling is required and the DX coil compressor is off.
      \\note If this field is left blank or zero, the supply air flow rate from the previous on cycle
      \\note (either cooling or heating) is used.
      \\note A value entered in this field will *not* be multiplied by the sizing factor or
      \\note by zone multipliers.  It is best to autosize or leave blank when using zone multipliers.
      \\type real
      \\minimum 0
      \\autosizable
      \\units m3/s
  N4, \\field Zone Heating Sizing Factor
      \\note If blank, value from Sizing:Parameters will be used.
  N5, \\field Zone Cooling Sizing Factor
      \\note If blank, value from Sizing:Parameters will be used.
  A3, \\field Outdoor Air Method
      \\note Flow/Person, Flow/Zone, Flow/Area, Sum, and Maximum use the values in the next three
      \\note fields: Outdoor Air Flow Rate per Person, Outdoor Air Flow Rate per Zone Floor Area,
      \\note and Outdoor Air Flow Rate per Zone.
      \\note DetailedSpecification ignores these three Outdoor Air Flow Rate fields and instead
      \\note references design specification objects named in the fields
      \\note Design Specification Outdoor Air Object Name and Design Specification Zone Air
      \\note Distribution Object Name.
      \\type choice
      \\key Flow/Person
      \\key Flow/Zone
      \\key Flow/Area
      \\key Sum
      \\key Maximum
      \\key DetailedSpecification
      \\default Flow/Person
  N6, \\field Outdoor Air Flow Rate per Person
      \\units m3/s
      \\note Default 0.00944 is 20 cfm per person
      \\note This input is used if the field Outdoor Air Method is
      \\note Flow/Person, Sum, or Maximum
      \\default 0.00944
  N7, \\field Outdoor Air Flow Rate per Zone Floor Area
      \\units m3/s-m2
      \\default 0.0
      \\note This input is used if the field Outdoor Air Method is
      \\note Flow/Area, Sum, or Maximum
  N8, \\field Outdoor Air Flow Rate per Zone
      \\type real
      \\units m3/s
      \\default 0.0
      \\note This input is used if the field Outdoor Air Method is
      \\note Flow/Zone, Sum, or Maximum
  A4, \\field System Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
  A5, \\field Supply Fan Operating Mode Schedule Name
      \\note Refers to a schedule to specify unitary supply fan operating mode.
      \\note Schedule values of 0 indicate cycling fan (auto)
      \\note Schedule values of 1 indicate continuous fan (on)
      \\note Keywords "Cycling" or "Continuous" may also be used here.
      \\type object-list
      \\object-list ScheduleNames
      \\default Cycling
  A6, \\field Supply Fan Placement
      \\type choice
      \\key BlowThrough
      \\key DrawThrough
      \\default DrawThrough
  N9, \\field Supply Fan Total Efficiency
      \\minimum> 0.0
      \\maximum 1.0
      \\default 0.7
 N10, \\field Supply Fan Delta Pressure
      \\units Pa
      \\ip-units inH2O
      \\minimum 0
      \\default 75
 N11, \\field Supply Fan Motor Efficiency
      \\minimum> 0.0
      \\maximum 1.0
      \\default 0.9
  A7, \\field Cooling Coil Type
      \\type choice
      \\key  SingleSpeedDX
      \\default SingleSpeedDX
  A8, \\field Cooling Coil Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
 N12, \\field Cooling Coil Rated Capacity
      \\note Gross capacity excluding effect of supply air fan heat
      \\note Rating point: air entering the cooling coil at 26.7 C dry-bulb/19.4 C wet-bulb, and
      \\note air entering the outdoor condenser coil at 35 C dry-bulb/23.9 C wet-bulb
      \\type real
      \\minimum> 0.0
      \\autosizable
      \\default autosize
      \\units W
 N13, \\field Cooling Coil Rated Sensible Heat Ratio
      \\note Rated sensible heat ratio (gross sensible capacity/gross total capacity)
      \\note Sensible and total capacities do not include effect of supply fan heat
      \\type real
      \\autosizable
      \\minimum 0.5
      \\maximum 1.0
      \\default autosize
 N14, \\field Cooling Coil Rated COP
      \\note Gross cooling capacity divided by power input to the compressor and outdoor fan,
      \\note does not include supply fan heat or supply fan electrical energy input
      \\type real
      \\units W/W
      \\minimum> 0.0
      \\default 3.0
  A9, \\field Heat Pump Heating Coil Type
      \\type choice
      \\key  SingleSpeedDXHeatPump
      \\default SingleSpeedDXHeatPump
 A10, \\field Heat Pump Heating Coil Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
 N15, \\field Heat Pump Heating Coil Rated Capacity
      \\note Capacity excluding supply air fan heat
      \\note Rating point outdoor dry-bulb temp 8.33 C, outdoor wet-bulb temp 6.11 C
      \\note Rating point heating coil entering air dry-bulb 21.11 C, coil entering wet-bulb 15.55 C
      \\type real
      \\units W
      \\minimum> 0.0
      \\autosizable
      \\default autosize
 N16, \\field Heat Pump Heating Coil Rated COP
      \\note Heat Pump Heating Coil Rated Capacity divided by power input to the compressor and outdoor fan,
      \\note Does not include supply air fan heat or supply air fan electrical energy
      \\note Rating point outdoor dry-bulb temp 8.33 C, outdoor wet-bulb temp 6.11 C
      \\note Rating point heating coil entering air dry-bulb 21.11 C, coil entering wet-bulb 15.55 C
      \\units W/W
      \\minimum> 0.0
      \\default 2.75
 N17, \\field Heat Pump Heating Minimum Outdoor Dry-Bulb Temperature
      \\type real
      \\minimum -20.0
      \\default -8.0
      \\units C
 N18, \\field Heat Pump Defrost Maximum Outdoor Dry-Bulb Temperature
      \\type real
      \\minimum 0.0
      \\maximum 7.22
      \\default 5.0
      \\units C
 A11, \\field Heat Pump Defrost Strategy
      \\type choice
      \\key ReverseCycle
      \\key Resistive
      \\default ReverseCycle
 A12, \\field Heat Pump Defrost Control
      \\type choice
      \\key Timed
      \\key OnDemand
      \\default Timed
 N19, \\field Heat Pump Defrost Time Period Fraction
      \\type real
      \\minimum 0.0
      \\default 0.058333
      \\note Fraction of time in defrost mode
      \\note only applicable if Timed defrost control is specified
 A13, \\field Supplemental Heating Coil Type
      \\type choice
      \\key  Electric
      \\key  Gas
      \\key  HotWater
      \\default Electric
 A14, \\field Supplemental Heating Coil Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
 N20, \\field Supplemental Heating Coil Capacity
      \\autosizable
      \\default autosize
      \\units W
 N21, \\field Supplemental Heating Coil Maximum Outdoor Dry-Bulb Temperature
      \\type real
      \\maximum 21.0
      \\default 21.0
      \\units C
      \\note Supplemental heater will not operate when outdoor temperature exceeds this value.
 N22, \\field Supplemental Gas Heating Coil Efficiency
      \\note Applies only if Supplemental Heating Coil Type is Gas
      \\maximum 1.0
      \\minimum 0.0
      \\default 0.8
 N23, \\field Supplemental Gas Heating Coil Parasitic Electric Load
      \\note Applies only if Supplemental Heating Coil Type is Gas
      \\units W
      \\ip-units W
      \\minimum 0.0
      \\default 0.0
 A15, \\field Dedicated Outdoor Air System Name
      \\note Enter the name of an HVACTemplate:System:DedicatedOutdoorAir object if this
      \\note zone is served by a separate dedicated outdoor air system (DOAS).
      \\note Leave field blank if no DOAS serves this zone.
      \\type object-list
      \\object-list HVACTemplateDOASSystems
 A16, \\field Zone Cooling Design Supply Air Temperature Input Method
      \\note SupplyAirTemperature = use the value from Zone Cooling Design Supply Air Temperature
      \\note TemperatureDifference = use the value from Zone Cooling Design Supply Air Temperature Difference
      \\type choice
      \\key SupplyAirTemperature
      \\key TemperatureDifference
      \\default SupplyAirTemperature
 N24, \\field Zone Cooling Design Supply Air Temperature
      \\type real
      \\units C
      \\default 14.0
      \\note Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
      \\note Supply Air Temperature Input Method = SupplyAirTemperature
 N25, \\field Zone Cooling Design Supply Air Temperature Difference
      \\type real
      \\units deltaC
      \\default 11.11
      \\note Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
      \\note Supply Air Temperature Input Method = TemperatureDifference
      \\note The absolute value of this field will be subtracted from the zone temperature
      \\note at peak load to calculate the Zone Cooling Design Supply Air Temperature.
 A17, \\field Zone Heating Design Supply Air Temperature Input Method
      \\note SupplyAirTemperature = use the value from Zone Heating Design Supply Air Temperature
      \\note TemperatureDifference = use the value from Zone Heating Design Supply Air Temperature Difference
      \\type choice
      \\key SupplyAirTemperature
      \\key TemperatureDifference
      \\default SupplyAirTemperature
 N26, \\field Zone Heating Design Supply Air Temperature
      \\type real
      \\units C
      \\default 50.0
      \\note Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
      \\note Supply Air Temperature Input Method = SupplyAirTemperature
 N27, \\field Zone Heating Design Supply Air Temperature Difference
      \\type real
      \\units deltaC
      \\default 30.0
      \\note Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
      \\note Supply Air Temperature Input Method = TemperatureDifference
      \\note The absolute value of this field will be added to the zone temperature
      \\note at peak load to calculate the Zone Heating Design Supply Air Temperature.
 A18, \\field Design Specification Outdoor Air Object Name
      \\note This field is used only when Outdoor Air Method=DetailedSpecification.
      \\type object-list
      \\object-list DesignSpecificationOutdoorAirNames
 A19; \\field Design Specification Zone Air Distribution Object Name
      \\note This field is used only when Outdoor Air Method=DetailedSpecification.
      \\type object-list
      \\object-list DesignSpecificationZoneAirDistributionNames

HVACTemplate:Zone:Unitary,
      \\min-fields 21
      \\memo Zone terminal unit, constant volume, no controls.
  A1, \\field Zone Name
      \\required-field
      \\note Zone name must match a building zone name
      \\type object-list
      \\object-list ZoneNames
  A2, \\field Template Unitary System Name
      \\required-field
      \\note Enter the name of a HVACTemplate:System:Unitary object serving this zone
      \\type object-list
      \\object-list CompactHVACSystemUnitary
  A3, \\field Template Thermostat Name
      \\note Enter the name of a HVACTemplate:Thermostat object.
      \\note If blank, then it is assumed that standard thermostat objects
      \\note have been defined for this zone.
      \\type object-list
      \\object-list CompactHVACThermostats
  N1, \\field Supply Air Maximum Flow Rate
      \\note This field may be set to "autosize".  If a value is entered, it will be
      \\note multiplied by the Supply Air Sizing Factor and by zone multipliers.
      \\autosizable
      \\default autosize
      \\units m3/s
  N2, \\field Zone Heating Sizing Factor
      \\note If blank, value from Sizing:Parameters will be used.
  N3, \\field Zone Cooling Sizing Factor
      \\note If blank, value from Sizing:Parameters will be used.
  A4, \\field Outdoor Air Method
      \\note Flow/Person, Flow/Zone, Flow/Area, Sum, and Maximum use the values in the next three
      \\note fields: Outdoor Air Flow Rate per Person, Outdoor Air Flow Rate per Zone Floor Area,
      \\note and Outdoor Air Flow Rate per Zone.
      \\note DetailedSpecification ignores these three Outdoor Air Flow Rate fields and instead
      \\note references design specification objects named in the fields
      \\note Design Specification Outdoor Air Object Name and Design Specification Zone Air
      \\note Distribution Object Name.
      \\type choice
      \\key Flow/Person
      \\key Flow/Zone
      \\key Flow/Area
      \\key Sum
      \\key Maximum
      \\key DetailedSpecification
      \\default Flow/Person
  N4, \\field Outdoor Air Flow Rate per Person
      \\units m3/s
      \\note Default 0.00944 is 20 cfm per person
      \\note This input is used if the field Outdoor Air Method is
      \\note Flow/Person, Sum, or Maximum
      \\default 0.00944
  N5, \\field Outdoor Air Flow Rate per Zone Floor Area
      \\units m3/s-m2
      \\default 0.0
      \\note This input is used if the field Outdoor Air Method is
      \\note Flow/Area, Sum, or Maximum
  N6, \\field Outdoor Air Flow Rate per Zone
      \\type real
      \\units m3/s
      \\default 0.0
      \\note This input is used if the field Outdoor Air Method is
      \\note Flow/Zone, Sum, or Maximum
  A5, \\field Supply Plenum Name
      \\note Plenum zone name.  Supply plenum runs through only this zone.
      \\note Blank if none.
      \\type object-list
      \\object-list ZoneNames
  A6, \\field Return Plenum Name
      \\note Plenum zone name.  Return plenum runs through only this zone.
      \\note Blank if none.
      \\type object-list
      \\object-list ZoneNames
  A7, \\field Baseboard Heating Type
      \\type choice
      \\key  HotWater
      \\key  Electric
      \\key  None
      \\default None
  A8, \\field Baseboard Heating Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
  N7, \\field Baseboard Heating Capacity
      \\autosizable
      \\default autosize
      \\units W
  A9, \\field Zone Cooling Design Supply Air Temperature Input Method
      \\note SupplyAirTemperature = use the value from Zone Cooling Design Supply Air Temperature
      \\note TemperatureDifference = use the value from Zone Cooling Design Supply Air Temperature Difference
      \\note SystemSupplyAirTemperature = use the value from HVACTemplate:System:Unitary or HVACTemplate:System:UnitaryHeatPump:AirToAir
      \\note Cooling Design Supply Air Temperature
      \\type choice
      \\key SupplyAirTemperature
      \\key TemperatureDifference
      \\key SystemSupplyAirTemperature
      \\default SystemSupplyAirTemperature
  N8, \\field Zone Cooling Design Supply Air Temperature
      \\type real
      \\units C
      \\default 12.8
      \\note Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
      \\note Supply Air Temperature Input Method = SupplyAirTemperature
  N9, \\field Zone Cooling Design Supply Air Temperature Difference
      \\type real
      \\units deltaC
      \\default 11.11
      \\note Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
      \\note Supply Air Temperature Input Method = TemperatureDifference
      \\note The absolute value of this field will be subtracted from the zone temperature
      \\note at peak load to calculate the Zone Cooling Design Supply Air Temperature.
 A10, \\field Zone Heating Design Supply Air Temperature Input Method
      \\note SupplyAirTemperature = use the value from Zone Heating Design Supply Air Temperature
      \\note TemperatureDifference = use the value from Zone Heating Design Supply Air Temperature Difference
      \\note SystemSupplyAirTemperature = use the value from HVACTemplate:System:Unitary or HVACTemplate:System:UnitaryHeatPump:AirToAir
      \\note Heating Design Supply Air Temperature
      \\type choice
      \\key SupplyAirTemperature
      \\key TemperatureDifference
      \\key SystemSupplyAirTemperature
      \\default SystemSupplyAirTemperature
 N10, \\field Zone Heating Design Supply Air Temperature
      \\type real
      \\units C
      \\default 50.0
      \\note Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
      \\note Supply Air Temperature Input Method = SupplyAirTemperature
 N11, \\field Zone Heating Design Supply Air Temperature Difference
      \\type real
      \\units deltaC
      \\default 30.0
      \\note Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
      \\note Supply Air Temperature Input Method = TemperatureDifference
      \\note The absolute value of this field will be added to the zone temperature
      \\note at peak load to calculate the Zone Heating Design Supply Air Temperature.
 A11, \\field Design Specification Outdoor Air Object Name
      \\note This field is used only when Outdoor Air Method=DetailedSpecification.
      \\type object-list
      \\object-list DesignSpecificationOutdoorAirNames
 A12; \\field Design Specification Zone Air Distribution Object Name
      \\note This field is used only when Outdoor Air Method=DetailedSpecification.
      \\type object-list
      \\object-list DesignSpecificationZoneAirDistributionNames

HVACTemplate:Zone:VAV,
      \\min-fields 32
      \\memo Zone terminal unit, variable volume, reheat optional.
      \\memo Referenced schedules must be defined elsewhere in the idf.
  A1, \\field Zone Name
      \\required-field
      \\note Zone name must match a building zone name
      \\type object-list
      \\object-list ZoneNames
  A2, \\field Template VAV System Name
      \\required-field
      \\note Name of a HVACTemplate:System:VAV object serving this zone
      \\type object-list
      \\object-list CompactHVACSystemVAV
  A3, \\field Template Thermostat Name
      \\note Enter the name of a HVACTemplate:Thermostat object.
      \\note If blank, then it is assumed that standard thermostat objects
      \\note have been defined for this zone.
      \\type object-list
      \\object-list CompactHVACThermostats
  N1, \\field Supply Air Maximum Flow Rate
      \\note This field may be set to "autosize".  If a value is entered, it will be
      \\note multiplied by the Supply Air Sizing Factor and by zone multipliers.
      \\autosizable
      \\default autosize
      \\units m3/s
  N2, \\field Zone Heating Sizing Factor
      \\note If blank, value from Sizing:Parameters will be used.
  N3, \\field Zone Cooling Sizing Factor
      \\note If blank, value from Sizing:Parameters will be used.
  A4 ,\\field Zone Minimum Air Flow Input Method
      \\type choice
      \\key Constant
      \\key FixedFlowRate
      \\key Scheduled
      \\default Constant
      \\note Constant = Constant Minimum Air Flow Fraction (a fraction of Maximum Air Flow Rate)
      \\note FixedFlowRate = Fixed Minimum Air Flow Rate (a fixed minimum air volume flow rate)
      \\note Scheduled = Scheduled Minimum Air Flow Fraction (a fraction of Maximum Air Flow
  N4 ,\\field Constant Minimum Air Flow Fraction
      \\note This field is used if the field Zone Minimum Air Flow Input Method is Constant
      \\note If the field Zone Minimum Air Flow Input Method is Scheduled, then this field
      \\note is optional. If a value is entered, then it is used for sizing normal-action reheat coils.
      \\note If both this field and the following field are entered, the larger result is used.
      \\minimum 0.0
      \\maximum 1.0
      \\default 0.2
  N5 ,\\field Fixed Minimum Air Flow Rate
      \\type real
      \\units m3/s
      \\note This field is used if the field Zone Minimum Air Flow Input Method is FixedFlowRate.
      \\note If the field Zone Minimum Air Flow Input Method is Scheduled, then this field
      \\note is optional. If a value is entered, then it is used for sizing normal-action reheat coils.
      \\note If both this field and the previous field are entered, the larger result is used.
  A5 ,\\field Minimum Air Flow Fraction Schedule Name
      \\type object-list
      \\object-list ScheduleNames
      \\note This field is used if the field Zone Minimum Air Flow Input Method is Scheduled
      \\note Schedule values are fractions, 0.0 to 1.0.
      \\note If the field Constant Minimum Air Flow Fraction is blank, then the average of the
      \\note minimum and maximum schedule values is used for sizing normal-action reheat coils.
  A6, \\field Outdoor Air Method
      \\note Flow/Person, Flow/Zone, Flow/Area, Sum, and Maximum use the values in the next three
      \\note fields: Outdoor Air Flow Rate per Person, Outdoor Air Flow Rate per Zone Floor Area,
      \\note and Outdoor Air Flow Rate per Zone.
      \\note DetailedSpecification ignores these three Outdoor Air Flow Rate fields and instead
      \\note references design specification objects named in the fields
      \\note Design Specification Outdoor Air Object Name and Design Specification Zone Air
      \\note Distribution Object Name.
      \\type choice
      \\key Flow/Person
      \\key Flow/Zone
      \\key Flow/Area
      \\key Sum
      \\key Maximum
      \\key DetailedSpecification
      \\default Flow/Person
  N6, \\field Outdoor Air Flow Rate per Person
      \\units m3/s
      \\note Default 0.00944 is 20 cfm per person
      \\note This input is used if the field Outdoor Air Method is
      \\note Flow/Person, Sum, or Maximum
      \\default 0.00944
  N7, \\field Outdoor Air Flow Rate per Zone Floor Area
      \\units m3/s-m2
      \\default 0.0
      \\note This input is used if the field Outdoor Air Method is
      \\note Flow/Area, Sum, or Maximum
  N8, \\field Outdoor Air Flow Rate per Zone
      \\type real
      \\units m3/s
      \\default 0.0
      \\note This input is used if the field Outdoor Air Method is
      \\note Flow/Zone, Sum, or Maximum
  A7, \\field Reheat Coil Type
      \\type choice
      \\key  HotWater
      \\key  Electric
      \\key  None
      \\default None
  A8, \\field Reheat Coil Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
  A9, \\field Damper Heating Action
      \\type choice
      \\key Normal
      \\key Reverse
      \\default Reverse
  N9, \\field Maximum Flow per Zone Floor Area During Reheat
      \\type real
      \\units m3/s-m2
      \\autocalculatable
      \\note Used only when Reheat Coil Object Type = Coil:Heating:Water and Damper Heating Action = Reverse
      \\note When autocalculating, the maximum flow per zone is set to 0.002032 m3/s-m2 (0.4 cfm/sqft)
      \\note This optional field limits the maximum flow allowed in reheat mode.
      \\note If this field and the following field are left blank, the maximum flow will not be limited.
      \\note At no time will the maximum flow rate calculated here exceed the value of
      \\note Maximum Air Flow Rate.
 N10, \\field Maximum Flow Fraction During Reheat
      \\type real
      \\autocalculatable
      \\note Used only when Reheat Coil Object Type = Coil:Heating:Water and Damper Heating Action = Reverse
      \\note When autocalculating, the maximum flow fraction is set to the ratio of
      \\note 0.002032 m3/s-m2 (0.4 cfm/sqft) multiplied by the zone floor area and the
      \\note Maximum Air Flow Rate.
      \\note This optional field limits the maximum flow allowed in reheat mode.
      \\note If this field and the previous field are left blank, the maximum flow will not be limited.
      \\note At no time will the maximum flow rate calculated here exceed the value of
      \\note Maximum Air Flow Rate.
 N11, \\field Maximum Reheat Air Temperature
      \\note Specifies the maximum allowable supply air temperature leaving the reheat coil.
      \\note If left blank, there is no limit and no default. If unknown, 35C (95F) is recommended.
      \\type real
      \\units C
      \\minimum> 0.0
 A10, \\field Design Specification Outdoor Air Object Name for Control
      \\type object-list
      \\object-list DesignSpecificationOutdoorAirNames
      \\note When the name of a DesignSpecification:OutdoorAir object is entered, the terminal
      \\note unit will increase flow as needed to meet this outdoor air requirement.
      \\note If Outdoor Air Flow per Person is non-zero, then the outdoor air requirement will
      \\note be computed based on the current number of occupants in the zone.
      \\note At no time will the supply air flow rate exceed the value for Maximum Air Flow Rate.
      \\note If this field is blank, then the terminal unit will not be controlled for outdoor air flow.
      \\note Note that this field is used only for specifying the design outdoor air flow rate used
      \\note for control. The field Design Specification Outdoor Air Object Name for Sizing
      \\note (see below) is used to specify the design outdoor air flow rate.
      \\type object-list
 A11, \\field Supply Plenum Name
      \\note Plenum zone name.  Supply plenum runs through only this zone.
      \\note Blank if none.
      \\type object-list
      \\object-list ZoneNames
 A12, \\field Return Plenum Name
      \\note Plenum zone name.  Return plenum runs through only this zone.
      \\note Blank if none.
      \\type object-list
      \\object-list ZoneNames
 A13, \\field Baseboard Heating Type
      \\type choice
      \\key  HotWater
      \\key  Electric
      \\key  None
      \\default None
 A14, \\field Baseboard Heating Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
 N12, \\field Baseboard Heating Capacity
      \\autosizable
      \\default autosize
      \\units W
 A15, \\field Zone Cooling Design Supply Air Temperature Input Method
      \\note SupplyAirTemperature = use the value from Zone Cooling Design Supply Air Temperature
      \\note TemperatureDifference = use the value from Zone Cooling Design Supply Air Temperature Difference
      \\note SystemSupplyAirTemperature = use the value from HVACTemplate:System:VAV Cooling Coil Design Setpoint
      \\type choice
      \\key SupplyAirTemperature
      \\key TemperatureDifference
      \\key SystemSupplyAirTemperature
      \\default SystemSupplyAirTemperature
 N13, \\field Zone Cooling Design Supply Air Temperature
      \\type real
      \\units C
      \\default 12.8
      \\note Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
      \\note Supply Air Temperature Input Method = SupplyAirTemperature
 N14, \\field Zone Cooling Design Supply Air Temperature Difference
      \\type real
      \\units deltaC
      \\default 11.11
      \\note Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
      \\note Supply Air Temperature Input Method = TemperatureDifference
      \\note The absolute value of this field will be subtracted from the zone temperature
      \\note at peak load to calculate the Zone Cooling Design Supply Air Temperature.
 A16, \\field Zone Heating Design Supply Air Temperature Input Method
      \\note SupplyAirTemperature = use the value from Zone Heating Design Supply Air Temperature
      \\note TemperatureDifference = use the value from Zone Heating Design Supply Air Temperature Difference
      \\type choice
      \\key SupplyAirTemperature
      \\key TemperatureDifference
      \\default SupplyAirTemperature
 N15, \\field Zone Heating Design Supply Air Temperature
      \\type real
      \\units C
      \\default 50.0
      \\note Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
      \\note Supply Air Temperature Input Method = SupplyAirTemperature
 N16, \\field Zone Heating Design Supply Air Temperature Difference
      \\type real
      \\units deltaC
      \\default 30.0
      \\note Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
      \\note Supply Air Temperature Input Method = TemperatureDifference
      \\note The absolute value of this field will be added to the zone temperature
      \\note at peak load to calculate the Zone Heating Design Supply Air Temperature.
 A17, \\field Design Specification Outdoor Air Object Name for Sizing
      \\note This field is used only when Outdoor Air Method=DetailedSpecification.
      \\note Note that this field is used only for specifying the design outdoor air flow rate used
      \\note for sizing. The field Design Specification Outdoor Air Object Name for Control
      \\note (see above) is used to actively control the VAV terminal air flow rate.
      \\type object-list
      \\object-list DesignSpecificationOutdoorAirNames
 A18; \\field Design Specification Zone Air Distribution Object Name
      \\note This field is used only when Outdoor Air Method=DetailedSpecification.
      \\type object-list
      \\object-list DesignSpecificationZoneAirDistributionNames

HVACTemplate:Zone:VAV:FanPowered,
      \\min-fields 31
      \\memo Zone terminal unit, fan powered variable volume, reheat optional.
      \\memo Referenced schedules must be defined elsewhere in the idf.
  A1, \\field Zone Name
      \\required-field
      \\note Zone Name must match a building zone name
      \\type object-list
      \\object-list ZoneNames
  A2, \\field Template VAV System Name
      \\required-field
      \\note Enter then name of a HVACTemplate:System:VAV object serving this zone.
      \\type object-list
      \\object-list CompactHVACSystemVAV
  A3, \\field Template Thermostat Name
      \\note Enter the name of a HVACTemplate:Thermostat object.
      \\note If blank, then it is assumed that standard thermostat objects
      \\note have been defined for this zone.
      \\type object-list
      \\object-list CompactHVACThermostats
  N1, \\field Primary Supply Air Maximum Flow Rate
      \\note This field may be set to "autosize".  If a value is entered, it will be
      \\note multiplied by the Supply Air Sizing Factor and by zone multipliers.
      \\autosizable
      \\default autosize
      \\units m3/s
  N2, \\field Zone Heating Sizing Factor
      \\note If blank, value from Sizing:Parameters will be used.
  N3, \\field Zone Cooling Sizing Factor
      \\note If blank, value from Sizing:Parameters will be used.
  N4, \\field Primary Supply Air Minimum Flow Fraction
      \\autosizable
      \\default autosize
      \\minimum 0.0
      \\maximum 1.0
  N5, \\field Secondary Supply Air Maximum Flow Rate
      \\note This field may be set to "autosize".  If a value is entered, it will be
      \\note multiplied by the Supply Air Sizing Factor and by zone multipliers.
      \\autosizable
      \\default autosize
      \\units m3/s
  A4, \\field Flow Type
      \\type choice
      \\key  Parallel
      \\key  Series
      \\default Parallel
  N6, \\field Parallel Fan On Flow Fraction
      \\note The fraction of the primary air flow at which fan turns on
      \\note Applicable only to Parallel Flow Type
      \\autosizable
      \\default autosize
  A5, \\field Outdoor Air Method
      \\note Flow/Person, Flow/Zone, Flow/Area, Sum, and Maximum use the values in the next three
      \\note fields: Outdoor Air Flow Rate per Person, Outdoor Air Flow Rate per Zone Floor Area,
      \\note and Outdoor Air Flow Rate per Zone.
      \\note DetailedSpecification ignores these three Outdoor Air Flow Rate fields and instead
      \\note references design specification objects named in the fields
      \\note Design Specification Outdoor Air Object Name and Design Specification Zone Air
      \\note Distribution Object Name.
      \\type choice
      \\key Flow/Person
      \\key Flow/Zone
      \\key Flow/Area
      \\key Sum
      \\key Maximum
      \\key DetailedSpecification
      \\default Flow/Person
  N7, \\field Outdoor Air Flow Rate per Person
      \\units m3/s
      \\note Default 0.00944 is 20 cfm per person
      \\note This input is used if the field Outdoor Air Method is
      \\note Flow/Person, Sum, or Maximum
      \\default 0.00944
  N8, \\field Outdoor Air Flow Rate per Zone Floor Area
      \\units m3/s-m2
      \\default 0.0
      \\note This input is used if the field Outdoor Air Method is
      \\note Flow/area, Sum, or Maximum
  N9, \\field Outdoor Air Flow Rate per Zone
      \\type real
      \\units m3/s
      \\default 0.0
      \\note This input is used if the field Outdoor Air Method is
      \\note Flow/Zone, Sum, or Maximum
  A6, \\field Reheat Coil Type
      \\type choice
      \\key  HotWater
      \\key  Electric
      \\default Electric
  A7, \\field Reheat Coil Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
 N10, \\field Fan Total Efficiency
      \\minimum> 0.0
      \\maximum 1.0
      \\default 0.7
 N11, \\field Fan Delta Pressure
      \\units Pa
      \\ip-units inH2O
      \\minimum 0
      \\default 1000
 N12, \\field Fan Motor Efficiency
      \\minimum> 0.0
      \\maximum 1.0
      \\default 0.9
  A8, \\field Supply Plenum Name
      \\note Plenum zone name.  Supply plenum runs through only this zone.
      \\note Blank if none.
      \\type object-list
      \\object-list ZoneNames
  A9, \\field Return Plenum Name
      \\note Plenum zone name.  Return plenum runs through only this zone.
      \\note Blank if none.
      \\type object-list
      \\object-list ZoneNames
 A10, \\field Baseboard Heating Type
      \\type choice
      \\key  HotWater
      \\key  Electric
      \\key  None
      \\default None
 A11, \\field Baseboard Heating Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
 N13, \\field Baseboard Heating Capacity
      \\autosizable
      \\default autosize
      \\units W
 A12, \\field Zone Cooling Design Supply Air Temperature Input Method
      \\note SupplyAirTemperature = use the value from Zone Cooling Design Supply Air Temperature
      \\note TemperatureDifference = use the value from Zone Cooling Design Supply Air Temperature Difference
      \\note SystemSupplyAirTemperature = use the value from HVACTemplate:System:VAV Cooling Coil Design Setpoint
      \\type choice
      \\key SupplyAirTemperature
      \\key TemperatureDifference
      \\key SystemSupplyAirTemperature
      \\default SystemSupplyAirTemperature
 N14, \\field Zone Cooling Design Supply Air Temperature
      \\type real
      \\units C
      \\default 12.8
      \\note Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
      \\note Supply Air Temperature Input Method = SupplyAirTemperature
 N15, \\field Zone Cooling Design Supply Air Temperature Difference
      \\type real
      \\units deltaC
      \\default 11.11
      \\note Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
      \\note Supply Air Temperature Input Method = TemperatureDifference
      \\note The absolute value of this field will be subtracted from the zone temperature
      \\note at peak load to calculate the Zone Cooling Design Supply Air Temperature.
 A13, \\field Zone Heating Design Supply Air Temperature Input Method
      \\note SupplyAirTemperature = use the value from Zone Heating Design Supply Air Temperature
      \\note TemperatureDifference = use the value from Zone Heating Design Supply Air Temperature Difference
      \\type choice
      \\key SupplyAirTemperature
      \\key TemperatureDifference
      \\default SupplyAirTemperature
 N16, \\field Zone Heating Design Supply Air Temperature
      \\type real
      \\units C
      \\default 50.0
      \\note Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
      \\note Supply Air Temperature Input Method = SupplyAirTemperature
 N17, \\field Zone Heating Design Supply Air Temperature Difference
      \\type real
      \\units deltaC
      \\default 30.0
      \\note Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
      \\note Supply Air Temperature Input Method = TemperatureDifference
      \\note The absolute value of this field will be added to the zone temperature
      \\note at peak load to calculate the Zone Heating Design Supply Air Temperature.
 A14, \\field Zone PIU Fan Schedule Name
      \\note This is the operating schedule for the zone PIU fan.
      \\note For a parallel PIU, the fan operates only when the primary air flow is below the
      \\note Parallel Fan On Flow Fraction and the Zone PIU Fan Schedule is on, or it is
      \\note activated by an availability manager.
      \\note For a series PIU, the zone fan operates whenever the Zone PIU Fan Schedule is on, or it
      \\note is activated by an availability manager.
      \\note If this field is left blank, the System Availability Schedule for the
      \\note HVACTemplate:System serving this zone will be used.
      \\type object-list
      \\object-list ScheduleNames
 A15, \\field Design Specification Outdoor Air Object Name
      \\type object-list
      \\object-list DesignSpecificationOutdoorAirNames
 A16; \\field Design Specification Zone Air Distribution Object Name
      \\type object-list
      \\object-list DesignSpecificationZoneAirDistributionNames

HVACTemplate:Zone:WaterToAirHeatPump,
      \\min-fields 39
      \\memo Wate to Air Heat Pump to be used with HVACTemplate:Plant:MixedWaterLoop
  A1, \\field Zone Name
      \\required-field
      \\note Zone name must match a building zone name
      \\type object-list
      \\object-list ZoneNames
  A2, \\field Template Thermostat Name
      \\note Enter the name of a HVACTemplate:Thermostat object.
      \\note If blank, then it is assumed that standard thermostat objects
      \\note have been defined for this zone.
      \\type object-list
      \\object-list CompactHVACThermostats
  N1, \\field Cooling Supply Air Flow Rate
      \\note Supply air flow rate during cooling operation
      \\note This field may be set to "autosize".  If a value is entered, it will be
      \\note multiplied by the Supply Air Sizing Factor and by zone multipliers.
      \\type real
      \\minimum> 0.0
      \\autosizable
      \\default autosize
      \\units m3/s
  N2, \\field Heating Supply Air Flow Rate
      \\note Supply air flow rate during heating operation
      \\note This field may be set to "autosize".  If a value is entered, it will be
      \\note multiplied by the Supply Air Sizing Factor and by zone multipliers.
      \\type real
      \\minimum> 0.0
      \\autosizable
      \\default autosize
      \\units m3/s
  N3, \\field No Load Supply Air Flow Rate
      \\note Supply air flow rate when no cooling or heating is needed
      \\note Only used when heat pump fan operating mode is continuous. This air flow rate
      \\note is used when no heating or cooling is required.
      \\note If this field is left blank or zero, the supply air flow rate from the previous on cycle
      \\note (either cooling or heating) is used.
      \\note A value entered in this field will *not* be multiplied by the sizing factor or
      \\note by zone multipliers.  It is best to autosize or leave blank when using zone multipliers.
      \\type real
      \\minimum 0
      \\autosizable
      \\units m3/s
  N4, \\field Zone Heating Sizing Factor
      \\note If blank, value from Sizing:Parameters will be used.
  N5, \\field Zone Cooling Sizing Factor
      \\note If blank, value from Sizing:Parameters will be used.
  A3, \\field Outdoor Air Method
      \\note Flow/Person, Flow/Zone, Flow/Area, Sum, and Maximum use the values in the next three
      \\note fields: Outdoor Air Flow Rate per Person, Outdoor Air Flow Rate per Zone Floor Area,
      \\note and Outdoor Air Flow Rate per Zone.
      \\note DetailedSpecification ignores these three Outdoor Air Flow Rate fields and instead
      \\note references design specification objects named in the fields
      \\note Design Specification Outdoor Air Object Name and Design Specification Zone Air
      \\note Distribution Object Name.
      \\type choice
      \\key Flow/Person
      \\key Flow/Zone
      \\key Flow/Area
      \\key Sum
      \\key Maximum
      \\key DetailedSpecification
      \\default Flow/Person
  N6, \\field Outdoor Air Flow Rate per Person
      \\units m3/s
      \\note Default 0.00944 is 20 cfm per person
      \\note This input is used if the field Outdoor Air Method is
      \\note Flow/Person, Sum, or Maximum
      \\default 0.00944
  N7, \\field Outdoor Air Flow Rate per Zone Floor Area
      \\units m3/s-m2
      \\default 0.0
      \\note This input is used if the field Outdoor Air Method is
      \\note Flow/Area, Sum, or Maximum
  N8, \\field Outdoor Air Flow Rate per Zone
      \\type real
      \\units m3/s
      \\default 0.0
      \\note This input is used if the field Outdoor Air Method is
      \\note Flow/Zone, Sum, or Maximum
  A4, \\field System Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
  A5, \\field Supply Fan Operating Mode Schedule Name
      \\note Refers to a schedule to specify unitary supply fan operating mode.
      \\note Schedule values of 0 indicate cycling fan (auto)
      \\note Schedule values of 1 indicate continuous fan (on)
      \\note Keywords "Cycling" or "Continuous" may also be used here.
      \\type object-list
      \\object-list ScheduleNames
      \\default Cycling
  A6, \\field Supply Fan Placement
      \\type choice
      \\key BlowThrough
      \\key DrawThrough
      \\default DrawThrough
  N9, \\field Supply Fan Total Efficiency
      \\minimum> 0.0
      \\maximum 1.0
      \\default 0.7
 N10, \\field Supply Fan Delta Pressure
      \\units Pa
      \\ip-units inH2O
      \\minimum 0
      \\default 75
 N11, \\field Supply Fan Motor Efficiency
      \\minimum> 0.0
      \\maximum 1.0
      \\default 0.9
  A7, \\field Cooling Coil Type
      \\type choice
      \\key  Coil:Cooling:WaterToAirHeatPump:EquationFit
      \\default Coil:Cooling:WaterToAirHeatPump:EquationFit
 N12, \\field Cooling Coil Rated Capacity
      \\note Gross capacity excluding effect of supply air fan heat
      \\type real
      \\minimum> 0.0
      \\autosizable
      \\default autosize
      \\units W
 N13, \\field Cooling Coil Rated Sensible Heat Ratio
      \\note Rated sensible heat ratio (gross sensible capacity/gross total capacity)
      \\note Sensible and total capacities do not include effect of supply fan heat
      \\type real
      \\autosizable
      \\minimum 0.5
      \\maximum 1.0
      \\default autosize
 N14, \\field Cooling Coil Rated COP
      \\note Gross cooling capacity divided by power input to the compressor and outdoor fan,
      \\note does not include supply fan heat or supply fan electrical energy input
      \\type real
      \\units W/W
      \\minimum> 0.0
      \\default 3.5
  A8, \\field Heat Pump Heating Coil Type
      \\type choice
      \\key  Coil:Heating:WaterToAirHeatPump:EquationFit
      \\default Coil:Heating:WaterToAirHeatPump:EquationFit
 N15, \\field Heat Pump Heating Coil Rated Capacity
      \\note Capacity excluding supply air fan heat
      \\type real
      \\units W
      \\minimum> 0.0
      \\autosizable
      \\default autosize
      \\units W
 N16, \\field Heat Pump Heating Coil Rated COP
      \\note Heat Pump Heating Coil Rated Capacity divided by power input to the compressor and outdoor fan,
      \\note does not include supply air fan heat or supply air fan electrical energy
      \\units W/W
      \\minimum> 0.0
      \\default 4.2
  A9, \\field Supplemental Heating Coil Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
 N17, \\field Supplemental Heating Coil Capacity
      \\autosizable
      \\default autosize
      \\units W
 N18, \\field Maximum Cycling Rate
      \\type real
      \\units cycles/hr
      \\minimum 0.0
      \\maximum 5.0
      \\default 2.5
      \\note The maximum on-off cycling rate for the compressor
      \\note Suggested value is 2.5 for a typical heat pump
 N19, \\field Heat Pump Time Constant
      \\type real
      \\units s
      \\minimum 0.0
      \\maximum 500.0
      \\default 60.0
      \\note Time constant for the cooling coil's capacity to reach steady state after startup
      \\note Suggested value is 60 for a typical heat pump
 N20, \\field Fraction of On-Cycle Power Use
      \\minimum 0.0
      \\maximum 0.05
      \\default 0.01
      \\note The fraction of on-cycle power use to adjust the part load fraction based on
      \\note the off-cycle power consumption due to crankcase heaters, controls, fans, and etc.
      \\note Suggested value is 0.01 for a typical heat pump
 N21, \\field Heat Pump Fan Delay Time
      \\units s
      \\minimum 0.0
      \\default 60
      \\note Programmed time delay for heat pump fan to shut off after compressor cycle off.
      \\note Only required when fan operating mode is cycling
      \\note Enter 0 when fan operating mode is continuous
 A10, \\field Dedicated Outdoor Air System Name
      \\note Enter the name of an HVACTemplate:System:DedicatedOutdoorAir object if this
      \\note zone is served by a separate dedicated outdoor air system (DOAS).
      \\note Leave field blank if no DOAS serves this zone.
      \\type object-list
      \\object-list HVACTemplateDOASSystems
 A11, \\field Supplemental Heating Coil Type
      \\type choice
      \\key  Electric
      \\key  HotWater
      \\default Electric
 A12, \\field Zone Cooling Design Supply Air Temperature Input Method
      \\note SupplyAirTemperature = use the value from Zone Cooling Design Supply Air Temperature
      \\note TemperatureDifference = use the value from Zone Cooling Design Supply Air Temperature Difference
      \\type choice
      \\key SupplyAirTemperature
      \\key TemperatureDifference
      \\default SupplyAirTemperature
 N22, \\field Zone Cooling Design Supply Air Temperature
      \\type real
      \\units C
      \\default 14.0
      \\note Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
      \\note Supply Air Temperature Input Method = SupplyAirTemperature
 N23, \\field Zone Cooling Design Supply Air Temperature Difference
      \\type real
      \\units deltaC
      \\default 11.11
      \\note Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
      \\note Supply Air Temperature Input Method = TemperatureDifference
      \\note The absolute value of this field will be subtracted from the zone temperature
      \\note at peak load to calculate the Zone Cooling Design Supply Air Temperature.
 A13, \\field Zone Heating Design Supply Air Temperature Input Method
      \\note SupplyAirTemperature = use the value from Zone Heating Design Supply Air Temperature
      \\note TemperatureDifference = use the value from Zone Heating Design Supply Air Temperature Difference
      \\type choice
      \\key SupplyAirTemperature
      \\key TemperatureDifference
      \\default SupplyAirTemperature
 N24, \\field Zone Heating Design Supply Air Temperature
      \\type real
      \\units C
      \\default 50.0
      \\note Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
      \\note Supply Air Temperature Input Method = SupplyAirTemperature
 N25, \\field Zone Heating Design Supply Air Temperature Difference
      \\type real
      \\units deltaC
      \\default 30.0
      \\note Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
      \\note Supply Air Temperature Input Method = TemperatureDifference
      \\note The absolute value of this field will be added to the zone temperature
      \\note at peak load to calculate the Zone Heating Design Supply Air Temperature.
 A14, \\field Heat Pump Coil Water Flow Mode
      \\type choice
      \\key Constant
      \\key Cycling
      \\key ConstantOnDemand
      \\default Cycling
      \\note used only when the heat pump coils are of the type WaterToAirHeatPump:EquationFit
      \\note Constant results in 100% water flow regardless of compressor PLR
      \\note Cycling results in water flow that matches compressor PLR
      \\note ConstantOnDemand results in 100% water flow whenever the coil is on, but is 0% whenever the coil has no load
 A15, \\field Design Specification Outdoor Air Object Name
      \\note This field is used only when Outdoor Air Method=DetailedSpecification.
      \\type object-list
      \\object-list DesignSpecificationOutdoorAirNames
 A16; \\field Design Specification Zone Air Distribution Object Name
      \\note This field is used only when Outdoor Air Method=DetailedSpecification.
      \\type object-list
      \\object-list DesignSpecificationZoneAirDistributionNames

HVACTemplate:System:Unitary,
      \\min-fields 47
      \\memo Unitary furnace with air conditioner
      \\memo Referenced schedules must be defined elsewhere in the idf.
  A1, \\field Name
      \\required-field
      \\reference CompactHVACSystemUnitary
      \\reference HVACTemplateSystems
  A2, \\field System Availability Schedule Name
      \\note If blank, always on; Unitary System always on.  Schedule is used in availability manager
      \\note and fan scheduling.
      \\note Also see "Night Cycle Control" field.
      \\type object-list
      \\object-list ScheduleNames
  A3, \\field Control Zone or Thermostat Location Name
      \\required-field
      \\type object-list
      \\object-list ZoneNames
  N1, \\field Supply Fan Maximum Flow Rate
      \\note This field may be set to "autosize".  If a value is entered, it will *not* be
      \\note multiplied by any sizing factor or by zone multipliers.  If using zone multipliers
      \\note a value entered here must be large enough to serve the multiplied zones.
      \\autosizable
      \\default autosize
      \\units m3/s
      \\minimum> 0.0
  A4, \\field Supply Fan Operating Mode Schedule Name
      \\note Refers to a schedule to specify unitary supply fan operating mode.
      \\note Schedule values of 0 indicate cycling fan (auto)
      \\note Schedule values of 1 indicate continuous fan (on)
      \\note Keywords "Cycling" or "Continuous" may also be used here.
      \\type object-list
      \\object-list ScheduleNames
      \\default Cycling
  N2, \\field Supply Fan Total Efficiency
      \\minimum> 0.0
      \\maximum 1.0
      \\default 0.7
  N3, \\field Supply Fan Delta Pressure
      \\units Pa
      \\ip-units inH2O
      \\minimum 0
      \\default 600
  N4, \\field Supply Fan Motor Efficiency
      \\minimum> 0.0
      \\maximum 1.0
      \\default 0.9
  N5, \\field Supply Fan Motor in Air Stream Fraction
      \\minimum 0.0
      \\maximum 1.0
      \\default 1.0
  A5, \\field Cooling Coil Type
      \\type choice
      \\key  SingleSpeedDX
      \\key  None
      \\default SingleSpeedDX
  A6, \\field Cooling Coil Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
  N6, \\field Cooling Design Supply Air Temperature
      \\note Used for sizing.
      \\default 12.8
      \\units C
  N7, \\field Cooling Coil Capacity
      \\note Gross cooling capacity (net capacity plus fan heat)
      \\autosizable
      \\default autosize
      \\units W
  N8, \\field Cooling Coil Rated Sensible Heat Ratio
      \\note Gross SHR
      \\autosizable
      \\minimum 0.5
      \\maximum 1.0
      \\default autosize
  N9, \\field Cooling Coil Rated COP
      \\note Gross cooling capacity divided by power input to the compressor and outdoor fan,
      \\note does not include supply air fan heat or supply air fan electrical energy
      \\units W/W
      \\minimum> 0.0
      \\default 3.0
  A7, \\field Heating Coil Type
      \\required-field
      \\type choice
      \\key  Electric
      \\key  Gas
      \\key  HotWater
  A8, \\field Heating Coil Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
 N10, \\field Heating Design Supply Air Temperature
      \\note Used for sizing.
      \\default 50.0
      \\units C
 N11, \\field Heating Coil Capacity
      \\autosizable
      \\default autosize
      \\units W
 N12, \\field Gas Heating Coil Efficiency
      \\maximum 1.0
      \\minimum 0.0
      \\default 0.8
 N13, \\field Gas Heating Coil Parasitic Electric Load
      \\units W
      \\ip-units W
      \\minimum 0.0
      \\default 0.0
 N14, \\field Maximum Outdoor Air Flow Rate
      \\autosizable
      \\default autosize
      \\units m3/s
      \\minimum 0.0
 N15, \\field Minimum Outdoor Air Flow Rate
      \\autosizable
      \\default autosize
      \\units m3/s
      \\minimum 0.0
  A9, \\field Minimum Outdoor Air Schedule Name
      \\note Schedule values multiply the minimum outdoor air flow rate
      \\note If blank, always one
      \\type object-list
      \\object-list ScheduleNames
 A10, \\field Economizer Type
      \\type choice
      \\key FixedDryBulb
      \\key FixedEnthalpy
      \\key DifferentialDryBulb
      \\key DifferentialEnthalpy
      \\key FixedDewPointAndDryBulb
      \\key ElectronicEnthalpy
      \\key DifferentialDryBulbAndEnthalpy
      \\key NoEconomizer
      \\default NoEconomizer
 A11, \\field Economizer Lockout
      \\type choice
      \\key NoLockout
      \\key LockoutWithHeating
      \\key LockoutWithCompressor
      \\default NoLockout
 N16, \\field Economizer Upper Temperature Limit
      \\note Outdoor temperature above which economizer is disabled and
      \\note heat recovery is enabled (if available).
      \\note Blank means no limit.
      \\units C
 N17, \\field Economizer Lower Temperature Limit
      \\note Outdoor temperature below which economizer is disabled and
      \\note heat recovery is enabled (if available).
      \\note Blank means no limit.
      \\units C
 N18, \\field Economizer Upper Enthalpy Limit
      \\note Outdoor enthalpy above which economizer is disabled and
      \\note heat recovery is enabled (if available).
      \\note Blank means no limit.
      \\units J/kg
 N19, \\field Economizer Maximum Limit Dewpoint Temperature
      \\type real
      \\units C
      \\note Enter the maximum outdoor dewpoint temperature limit for FixedDewPointAndDryBulb
      \\note economizer control type. No input or blank input means this limit is not operative.
      \\note Limit is applied regardless of economizer control type.
 A12, \\field Supply Plenum Name
      \\note Plenum zone name.  Supply plenum serves all zones on this system.
      \\note Blank if none.
      \\type object-list
      \\object-list ZoneNames
 A13, \\field Return Plenum Name
      \\note Plenum zone name.  Return plenum serves all zones on this system.
      \\note Blank if none.
      \\type object-list
      \\object-list ZoneNames
 A14, \\field Supply Fan Placement
      \\type choice
      \\key BlowThrough
      \\key DrawThrough
      \\default BlowThrough
 A15, \\field Night Cycle Control
      \\type choice
      \\key StayOff
      \\key CycleOnAny
      \\key CycleOnControlZone
      \\default StayOff
 A16, \\field Night Cycle Control Zone Name
      \\note Applicable only if Night Cycle Control is Cycle On Control Zone.
      \\type object-list
      \\object-list ZoneNames
 A17, \\field Heat Recovery Type
      \\type choice
      \\key None
      \\key Sensible
      \\key Enthalpy
      \\default None
 N20, \\field Sensible Heat Recovery Effectiveness
      \\minimum 0.0
      \\maximum 1.0
      \\default 0.70
 N21, \\field Latent Heat Recovery Effectiveness
      \\note Applicable only if Heat Recovery Type is Enthalpy.
      \\minimum 0.0
      \\maximum 1.0
      \\default 0.65
 A18, \\field Dehumidification Control Type
      \\note None = meet sensible cooling load only
      \\note CoolReheatHeatingCoil = cool beyond the dry-bulb setpoint
      \\note as required to meet the humidity setpoint, reheat with main heating coil.
      \\note CoolReheatDesuperheater = cool beyond the dry-bulb setpoint
      \\note as required to meet the humidity setpoint, reheat with desuperheater coil.
      \\type choice
      \\key None
      \\key CoolReheatHeatingCoil
      \\key CoolReheatDesuperheater
      \\default None
 A19, \\field Dehumidification Control Zone Name
      \\note This field is not currently used - the thermostat control zone is also the dehumidification control zone
      \\type object-list
      \\object-list ZoneNames
 N22, \\field Dehumidification Setpoint
      \\note Zone relative humidity setpoint in percent (0 to 100)
      \\type real
      \\minimum 0.0
      \\maximum 100.0
      \\default 60.0
      \\units percent
 A20, \\field Humidifier Type
      \\type choice
      \\key None
      \\key ElectricSteam
      \\default None
 A21, \\field Humidifier Availability Schedule Name
      \\note If blank, always available
      \\type object-list
      \\object-list ScheduleNames
 N23, \\field Humidifier Rated Capacity
      \\note Moisture output rate at full rated power input.
      \\note The humidifier does not currently autosize, so the default is very large
      \\note to allow for adequate capacity.
      \\type real
      \\units m3/s
      \\minimum 0.0
      \\default 0.000001
      \\ip-units gal/min
 N24, \\field Humidifier Rated Electric Power
      \\note Electric power input at rated capacity moisture output.
      \\note Power consumption is proportional to moisture output with no part-load penalty.
      \\type real
      \\units W
      \\minimum 0.0
      \\autosizable
      \\default autosize
      \\ip-units W
 A22, \\field Humidifier Control Zone Name
      \\note Zone name where humidistat is located
      \\type object-list
      \\object-list ZoneNames
 N25; \\field Humidifier Setpoint
      \\note Zone relative humidity setpoint in percent (0 to 100)
      \\type real
      \\minimum 0.0
      \\maximum 100.0
      \\default 30.0
      \\units percent

HVACTemplate:System:UnitaryHeatPump:AirToAir,
      \\min-fields 56
      \\memo Unitary furnace with electric air-to-air heat pump
      \\memo Referenced schedules must be defined elsewhere in the idf.
  A1, \\field Name
      \\required-field
      \\reference CompactHVACSystemUnitary
      \\reference HVACTemplateSystems
  A2, \\field System Availability Schedule Name
      \\note If blank, always on; Unitary System always on.  Schedule is used in availability manager
      \\note and fan scheduling.
      \\note Also see "Night Cycle Control" field.
      \\type object-list
      \\object-list ScheduleNames
  A3, \\field Control Zone or Thermostat Location Name
      \\required-field
      \\type object-list
      \\object-list ZoneNames
  N1, \\field Cooling Supply Air Flow Rate
      \\note Supply air flow rate during cooling operation
      \\note This field may be set to "autosize".  If a value is entered, it will *not* be
      \\note multiplied by any sizing factor or by zone multipliers.  If using zone multipliers
      \\note a value entered here must be large enough to serve the multiplied zones.
      \\type real
      \\minimum> 0.0
      \\autosizable
      \\default autosize
      \\units m3/s
  N2, \\field Heating Supply Air Flow Rate
      \\note Supply air flow rate during heating operation
      \\note This field may be set to "autosize".  If a value is entered, it will *not* be
      \\note multiplied by any sizing factor or by zone multipliers.  If using zone multipliers
      \\note a value entered here must be large enough to serve the multiplied zones.
      \\type real
      \\minimum> 0.0
      \\autosizable
      \\default autosize
      \\units m3/s
  N3, \\field No Load Supply Air Flow Rate
      \\note Supply air flow rate when no cooling or heating is needed
      \\note Only used when heat pump fan operating mode is Continuous. This air flow rate
      \\note is used when no heating or cooling is required and the DX coil compressor is off.
      \\note If this field is left blank or zero, the supply air flow rate from the previous on cycle
      \\note (either cooling or heating) is used.
      \\note This field may be set to "autosize".  If a value is entered, it will *not* be
      \\note multiplied by any sizing factor or by zone multipliers.  If using zone multipliers
      \\note a value entered here must be large enough to serve the multiplied zones.
      \\type real
      \\minimum 0
      \\default autosize
      \\autosizable
      \\units m3/s
  A4, \\field Supply Fan Operating Mode Schedule Name
      \\note Refers to a schedule to specify unitary supply fan operating mode.
      \\note Schedule values of 0 indicate cycling fan (auto)
      \\note Schedule values of 1 indicate continuous fan (on)
      \\note Keywords "Cycling" or "Continuous" may also be used here.
      \\type object-list
      \\object-list ScheduleNames
      \\default Cycling
  A5, \\field Supply Fan Placement
      \\type choice
      \\key BlowThrough
      \\key DrawThrough
      \\default BlowThrough
  N4, \\field Supply Fan Total Efficiency
      \\minimum> 0.0
      \\maximum 1.0
      \\default 0.7
  N5, \\field Supply Fan Delta Pressure
      \\units Pa
      \\ip-units inH2O
      \\minimum 0
      \\default 600
  N6, \\field Supply Fan Motor Efficiency
      \\minimum> 0.0
      \\maximum 1.0
      \\default 0.9
  N7, \\field Supply Fan Motor in Air Stream Fraction
      \\minimum 0.0
      \\maximum 1.0
      \\default 1.0
  A6, \\field Cooling Coil Type
      \\type choice
      \\key  SingleSpeedDX
      \\default SingleSpeedDX
  A7, \\field Cooling Coil Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
  N8, \\field Cooling Design Supply Air Temperature
      \\note Used for sizing.
      \\default 12.8
      \\units C
  N9, \\field Cooling Coil Capacity
      \\note Gross capacity excluding effect of supply air fan heat
      \\note Rating point: air entering the cooling coil at 26.7 C dry-bulb/19.4 C wet-bulb, and
      \\note air entering the outdoor condenser coil at 35 C dry-bulb/23.9 C wet-bulb
      \\autosizable
      \\default autosize
      \\units W
 N10, \\field Cooling Coil Rated Sensible Heat Ratio
      \\note Rated sensible heat ratio (gross sensible capacity/gross total capacity)
      \\note Sensible and total capacities do not include effect of supply fan heat
      \\autosizable
      \\minimum 0.5
      \\maximum 1.0
      \\default autosize
 N11, \\field Cooling Coil Rated COP
      \\note Gross cooling capacity divided by power input to the compressor and outdoor fan,
      \\note does not include supply fan heat or supply fan electrical energy input
      \\units W/W
      \\minimum> 0.0
      \\default 3.0
  A8, \\field Heat Pump Heating Coil Type
      \\type choice
      \\key  SingleSpeedDXHeatPump
      \\default SingleSpeedDXHeatPump
  A9, \\field Heat Pump Heating Coil Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
 N12, \\field Heating Design Supply Air Temperature
      \\note Used for sizing.
      \\default 50.0
      \\units C
 N13, \\field Heat Pump Heating Coil Rated Capacity
      \\note Capacity excluding supply air fan heat
      \\note Rating point outdoor dry-bulb temp 8.33 C, outdoor wet-bulb temp 6.11 C
      \\note Rating point heating coil entering air dry-bulb 21.11 C, coil entering wet-bulb 15.55 C
      \\type real
      \\units W
      \\minimum> 0.0
      \\autosizable
      \\default autosize
 N14, \\field Heat Pump Heating Coil Rated COP
      \\note Heat Pump Heating Coil Rated Capacity divided by power input to the compressor and outdoor fan,
      \\note does not include supply air fan heat or supply air fan electrical energy.
      \\note Rating point outdoor dry-bulb temp 8.33 C, outdoor wet-bulb temp 6.11 C
      \\note Rating point heating coil entering air dry-bulb 21.11 C, coil entering wet-bulb 15.55 C
      \\units W/W
      \\minimum> 0.0
      \\default 2.75
 N15, \\field Heat Pump Heating Minimum Outdoor Dry-Bulb Temperature
      \\type real
      \\minimum -20.0
      \\default -8.0
      \\units C
 N16, \\field Heat Pump Defrost Maximum Outdoor Dry-Bulb Temperature
      \\type real
      \\minimum 0.0
      \\maximum 7.22
      \\default 5.0
      \\units C
 A10, \\field Heat Pump Defrost Strategy
      \\type choice
      \\key ReverseCycle
      \\key Resistive
      \\default ReverseCycle
 A11, \\field Heat Pump Defrost Control
      \\type choice
      \\key Timed
      \\key OnDemand
      \\default Timed
 N17, \\field Heat Pump Defrost Time Period Fraction
      \\type real
      \\minimum 0.0
      \\default 0.058333
      \\note Fraction of time in defrost mode
      \\note only applicable if Timed defrost control is specified
 A12, \\field Supplemental Heating Coil Type
      \\type choice
      \\key  Electric
      \\key  Gas
      \\key  HotWater
      \\default Electric
 A13, \\field Supplemental Heating Coil Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
 N18, \\field Supplemental Heating Coil Capacity
      \\autosizable
      \\default autosize
      \\units W
 N19, \\field Supplemental Heating Coil Maximum Outdoor Dry-Bulb Temperature
      \\type real
      \\maximum 21.0
      \\default 21.0
      \\units C
      \\note Supplemental heater will not operate when outdoor temperature exceeds this value.
 N20, \\field Supplemental Gas Heating Coil Efficiency
      \\note Applies only if Supplemental Heating Coil Type is Gas
      \\maximum 1.0
      \\minimum 0.0
      \\default 0.8
 N21, \\field Supplemental Gas Heating Coil Parasitic Electric Load
      \\note Applies only if Supplemental Heating Coil Type is Gas
      \\units W
      \\ip-units W
      \\minimum 0.0
      \\default 0.0
 N22, \\field Maximum Outdoor Air Flow Rate
      \\autosizable
      \\default autosize
      \\units m3/s
      \\minimum 0.0
 N23, \\field Minimum Outdoor Air Flow Rate
      \\autosizable
      \\default autosize
      \\units m3/s
      \\minimum 0.0
 A14, \\field Minimum Outdoor Air Schedule Name
      \\note Schedule values multiply the minimum outdoor air flow rate
      \\note If blank, multiplier is always one
      \\type object-list
      \\object-list ScheduleNames
 A15, \\field Economizer Type
      \\type choice
      \\key FixedDryBulb
      \\key FixedEnthalpy
      \\key DifferentialDryBulb
      \\key DifferentialEnthalpy
      \\key FixedDewPointAndDryBulb
      \\key ElectronicEnthalpy
      \\key DifferentialDryBulbAndEnthalpy
      \\key NoEconomizer
      \\default NoEconomizer
 A16, \\field Economizer Lockout
      \\type choice
      \\key NoLockout
      \\key LockoutWithHeating
      \\key LockoutWithCompressor
      \\default NoLockout
 N24, \\field Economizer Maximum Limit Dry-Bulb Temperature
      \\type real
      \\units C
      \\note Enter the maximum outdoor dry-bulb temperature limit for FixedDryBulb
      \\note economizer control type. No input or blank input means this limit is
      \\note not operative. Limit is applied regardless of economizer control type.
 N25, \\field Economizer Maximum Limit Enthalpy
      \\type real
      \\units J/kg
      \\note Enter the maximum outdoor enthalpy limit for FixedEnthalpy economizer control type.
      \\note No input or blank input means this limit is not operative
      \\note Limit is applied regardless of economizer control type.
 N26, \\field Economizer Maximum Limit Dewpoint Temperature
      \\type real
      \\units C
      \\note Enter the maximum outdoor dewpoint temperature limit for FixedDewPointAndDryBulb
      \\note economizer control type. No input or blank input means this limit is not operative.
      \\note Limit is applied regardless of economizer control type.
 N27, \\field Economizer Minimum Limit Dry-Bulb Temperature
      \\type real
      \\units C
      \\note Enter the minimum outdoor dry-bulb temperature limit for economizer control.
      \\note No input or blank input means this limit is not operative
      \\note Limit is applied regardless of economizer control type.
 A17, \\field Supply Plenum Name
      \\note Plenum zone name.  Supply plenum serves all zones on this system.
      \\note Blank if none.
      \\type object-list
      \\object-list ZoneNames
 A18, \\field Return Plenum Name
      \\note Plenum zone name.  Return plenum serves all zones on this system.
      \\note Blank if none.
      \\type object-list
      \\object-list ZoneNames
 A19, \\field Night Cycle Control
      \\type choice
      \\key StayOff
      \\key CycleOnAny
      \\key CycleOnControlZone
      \\default StayOff
 A20, \\field Night Cycle Control Zone Name
      \\note Applicable only if Night Cycle Control is Cycle On Control Zone.
      \\type object-list
      \\object-list ZoneNames
 A21, \\field Heat Recovery Type
      \\type choice
      \\key None
      \\key Sensible
      \\key Enthalpy
      \\default None
 N28, \\field Sensible Heat Recovery Effectiveness
      \\minimum 0.0
      \\maximum 1.0
      \\default 0.70
 N29, \\field Latent Heat Recovery Effectiveness
      \\note Applicable only if Heat Recovery Type is Enthalpy.
      \\minimum 0.0
      \\maximum 1.0
      \\default 0.65
 A22, \\field Humidifier Type
      \\type choice
      \\key None
      \\key ElectricSteam
      \\default None
 A23, \\field Humidifier Availability Schedule Name
      \\note If blank, always available
      \\type object-list
      \\object-list ScheduleNames
 N30, \\field Humidifier Rated Capacity
      \\note Moisture output rate at full rated power input.
      \\note The humidifier does not currently autosize, so the default is very large
      \\note to allow for adequate capacity.
      \\type real
      \\units m3/s
      \\minimum 0.0
      \\default 0.000001
      \\ip-units gal/min
 N31, \\field Humidifier Rated Electric Power
      \\note Electric power input at rated capacity moisture output.
      \\note Power consumption is proportional to moisture output with no part-load penalty.
      \\type real
      \\units W
      \\minimum 0.0
      \\autosizable
      \\default autosize
      \\ip-units W
 A24, \\field Humidifier Control Zone Name
      \\note Zone name where humidistat is located
      \\type object-list
      \\object-list ZoneNames
 N32; \\field Humidifier Setpoint
      \\note Zone relative humidity setpoint in percent (0 to 100)
      \\type real
      \\minimum 0.0
      \\maximum 100.0
      \\default 30.0
      \\units percent

HVACTemplate:System:VAV,
      \\min-fields 55
      \\memo Variable Air Volume (VAV) air loop with optional heating coil
      \\memo and optional preheat.
      \\memo Referenced Schedules must be defined elsewhere in the idf.
  A1, \\field Name
      \\required-field
      \\reference CompactHVACSystemVAV
      \\reference HVACTemplateSystems
  A2, \\field System Availability Schedule Name
      \\note If blank, always on; VAV System always on.  Schedule is used in availability manager
      \\note and fan scheduling.
      \\note Also see "Night Cycle Control" field.
      \\type object-list
      \\object-list ScheduleNames
  N1, \\field Supply Fan Maximum Flow Rate
      \\note This field may be set to "autosize".  If a value is entered, it will *not* be
      \\note multiplied by any sizing factor or by zone multipliers.  If using zone multipliers
      \\note a value entered here must be large enough to serve the multiplied zones.
      \\autosizable
      \\default autosize
      \\units m3/s
      \\minimum> 0.0
  N2, \\field Supply Fan Minimum Flow Rate
      \\note This field is only used to set a minimum part load on the VAV fan power curve.
      \\note Autosize or zero is recommended.
      \\autosizable
      \\default autosize
      \\units m3/s
      \\minimum 0.0
  N3, \\field Supply Fan Total Efficiency
      \\minimum> 0.0
      \\maximum 1.0
      \\default 0.7
  N4, \\field Supply Fan Delta Pressure
      \\units Pa
      \\ip-units inH2O
      \\minimum 0
      \\default 1000
  N5, \\field Supply Fan Motor Efficiency
      \\minimum> 0.0
      \\maximum 1.0
      \\default 0.9
  N6, \\field Supply Fan Motor in Air Stream Fraction
       \\minimum 0.0
       \\maximum 1.0
       \\default 1.0
  A3, \\field Cooling Coil Type
      \\type choice
      \\key  ChilledWater
      \\key  ChilledWaterDetailedFlatModel
      \\default  ChilledWater
  A4, \\field Cooling Coil Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
  A5, \\field Cooling Coil Setpoint Schedule Name
      \\note  Leave blank if constant setpoint
      \\type object-list
      \\object-list ScheduleNames
  N7, \\field Cooling Coil Design Setpoint
      \\note  Used for sizing and as constant setpoint if no Cooling Coil Setpoint Schedule Name is specified.
      \\default 12.8
      \\units C
  A6, \\field Heating Coil Type
      \\type choice
      \\key  HotWater
      \\key  Electric
      \\key  Gas
      \\key  None
      \\default None
  A7, \\field Heating Coil Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
  A8, \\field Heating Coil Setpoint Schedule Name
      \\note  Leave blank if constant setpoint
      \\type object-list
      \\object-list ScheduleNames
  N8, \\field Heating Coil Design Setpoint
      \\note   Used for sizing and as constant setpoint if no Heating Coil Setpoint Schedule Name is specified.
      \\default 10.0
      \\units C
  N9, \\field Gas Heating Coil Efficiency
      \\maximum 1.0
      \\minimum 0.0
      \\default 0.8
 N10, \\field Gas Heating Coil Parasitic Electric Load
      \\units W
      \\ip-units W
      \\minimum 0.0
      \\default 0.0
  A9, \\field Preheat Coil Type
      \\type choice
      \\key  Electric
      \\key  Gas
      \\key  None
      \\default None
 A10, \\field Preheat Coil Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
 A11, \\field Preheat Coil Setpoint Schedule Name
      \\note  Leave blank if constant setpoint
      \\type object-list
      \\object-list ScheduleNames
 N11, \\field Preheat Coil Design Setpoint
      \\note   Used for sizing and as constant setpoint if no Preheat Coil Setpoint Schedule Name specified.
      \\units C
      \\default 7.2
 N12, \\field Gas Preheat Coil Efficiency
      \\maximum 1.0
      \\minimum 0.0
      \\default 0.8
 N13, \\field Gas Preheat Coil Parasitic Electric Load
      \\units W
      \\ip-units W
      \\minimum 0.0
      \\default 0.0
 N14, \\field Maximum Outdoor Air Flow Rate
      \\autosizable
      \\default autosize
      \\units m3/s
      \\minimum 0.0
 N15, \\field Minimum Outdoor Air Flow Rate
      \\autosizable
      \\default autosize
      \\units m3/s
      \\minimum 0.0
 A12, \\field Minimum Outdoor Air Control Type
      \\type choice
      \\key FixedMinimum
      \\key ProportionalMinimum
      \\default ProportionalMinimum
 A13, \\field Minimum Outdoor Air Schedule Name
      \\note Schedule values multiply the Minimum Outdoor Air Flow Rate
      \\note If blank, multiplier is always one
      \\type object-list
      \\object-list ScheduleNames
 A14, \\field Economizer Type
      \\type choice
      \\key FixedDryBulb
      \\key FixedEnthalpy
      \\key DifferentialDryBulb
      \\key DifferentialEnthalpy
      \\key FixedDewPointAndDryBulb
      \\key ElectronicEnthalpy
      \\key DifferentialDryBulbAndEnthalpy
      \\key NoEconomizer
      \\default NoEconomizer
 A15, \\field Economizer Lockout
      \\type choice
      \\key NoLockout
      \\default NoLockout
 N16, \\field Economizer Upper Temperature Limit
      \\note Outdoor temperature above which economizer is disabled and
      \\note heat recovery is enabled (if available).
      \\note Blank means no limit.
      \\units C
 N17, \\field Economizer Lower Temperature Limit
      \\note Outdoor temperature below which economizer is disabled and
      \\note heat recovery is enabled (if available).
      \\note Blank means no limit.
      \\units C
 N18, \\field Economizer Upper Enthalpy Limit
      \\note Outdoor enthalpy above which economizer is disabled and
      \\note heat recovery is enabled (if available).
      \\note Blank means no limit.
      \\units J/kg
 N19, \\field Economizer Maximum Limit Dewpoint Temperature
      \\type real
      \\units C
      \\note Enter the maximum outdoor dewpoint temperature limit for FixedDewPointAndDryBulb
      \\note economizer control type. No input or blank input means this limit is not operative.
      \\note Limit is applied regardless of economizer control type.
 A16, \\field Supply Plenum Name
      \\note Plenum zone name.  Supply plenum serves all zones on this system.
      \\note Blank if none.
      \\type object-list
      \\object-list ZoneNames
 A17, \\field Return Plenum Name
      \\note Plenum zone name.  Supply plenum serves all zones on this system.
      \\note Blank if none.
      \\type object-list
      \\object-list ZoneNames
 A18, \\field Supply Fan Placement
      \\type choice
      \\key DrawThrough
      \\key BlowThrough
      \\default DrawThrough
 A19, \\field Supply Fan Part-Load Power Coefficients
      \\note This field selects a predefined set of fan power coefficients.
      \\note The ASHRAE 90.1-2004 Appendix G coefficients are from TABLE G3.1.3.15, Method 2.
      \\note The other sets of coefficients are from the EnergyPlus Input
      \\note Output Reference, Fan Coefficient Values table.
      \\type choice
      \\key InletVaneDampers
      \\key OutletDampers
      \\key VariableSpeedMotor
      \\key ASHRAE90.1-2004AppendixG
      \\key VariableSpeedMotorPressureReset
      \\default InletVaneDampers
 A20, \\field Night Cycle Control
      \\type choice
      \\key StayOff
      \\key CycleOnAny
      \\key CycleOnControlZone
      \\key CycleOnAnyZoneFansOnly
      \\default StayOff
 A21, \\field Night Cycle Control Zone Name
      \\note Applicable only if Night Cycle Control is Cycle On Control Zone.
      \\type object-list
      \\object-list ZoneNames
 A22, \\field Heat Recovery Type
      \\type choice
      \\key None
      \\key Sensible
      \\key Enthalpy
      \\default None
 N20, \\field Sensible Heat Recovery Effectiveness
      \\minimum 0.0
      \\maximum 1.0
      \\default 0.70
 N21, \\field Latent Heat Recovery Effectiveness
      \\minimum 0.0
      \\maximum 1.0
      \\default 0.65
 A23, \\field Cooling Coil Setpoint Reset Type
      \\note Overrides Cooling Coil Setpoint Schedule Name
      \\note Warmest = as warm as possible yet meet all zone cooling loads
      \\type choice
      \\key None
      \\key Warmest
      \\key OutdoorAirTemperatureReset
      \\default None
 A24, \\field Heating Coil Setpoint Reset Type
      \\note Overrides Heating Coil Setpoint Schedule Name
      \\type choice
      \\key None
      \\key OutdoorAirTemperatureReset
      \\default None
 A25, \\field Dehumidification Control Type
      \\note None = meet sensible load only
      \\note CoolReheat = cool beyond the dry-bulb setpoint
      \\note as required to meet the humidity setpoint.
      \\type choice
      \\key None
      \\key CoolReheat
      \\default None
 A26, \\field Dehumidification Control Zone Name
      \\note Zone name where humidistat is located
      \\type object-list
      \\object-list ZoneNames
 N22, \\field Dehumidification Setpoint
      \\note Zone relative humidity setpoint in percent (0 to 100)
      \\type real
      \\minimum 0.0
      \\maximum 100.0
      \\default 60.0
      \\units percent
 A27, \\field Humidifier Type
      \\type choice
      \\key None
      \\key ElectricSteam
      \\default None
 A28, \\field Humidifier Availability Schedule Name
      \\note If blank, always available
      \\type object-list
      \\object-list ScheduleNames
 N23, \\field Humidifier Rated Capacity
      \\note Moisture output rate at full rated power input.
      \\note The humidifier does not currently autosize, so the default is very large
      \\note to allow for adequate capacity.
      \\type real
      \\units m3/s
      \\minimum 0.0
      \\default 0.000001
      \\ip-units gal/min
 N24, \\field Humidifier Rated Electric Power
      \\note Electric power input at rated capacity moisture output.
      \\note Power consumption is proportional to moisture output with no part-load penalty.
      \\type real
      \\units W
      \\minimum 0.0
      \\autosizable
      \\default autosize
      \\ip-units W
 A29, \\field Humidifier Control Zone Name
      \\note Zone name where humidistat is located
      \\type object-list
      \\object-list ZoneNames
 N25, \\field Humidifier Setpoint
      \\note Zone relative humidity setpoint in percent (0 to 100)
      \\type real
      \\minimum 0.0
      \\maximum 100.0
      \\default 30.0
      \\units percent
 A30; \\field Sizing Option
      \\note Select whether autosized system supply flow rate is the sum of Coincident or NonCoincident
      \\note zone air flow rates.
      \\type choice
      \\key Coincident
      \\key NonCoincident
      \\default NonCoincident

HVACTemplate:System:PackagedVAV,
      \\min-fields 53
      \\memo Packaged Variable Air Volume (PVAV) air loop with optional heating coil
      \\memo and optional preheat.
      \\memo Referenced Schedules must be defined elsewhere in the idf.
  A1, \\field Name
      \\required-field
      \\reference CompactHVACSystemVAV
      \\reference HVACTemplateSystems
  A2, \\field System Availability Schedule Name
      \\note If blank, always on; PVAV System always on.  Schedule is used in availability manager
      \\note and fan scheduling.
      \\note Also see "Night Cycle Control" field.
      \\type object-list
      \\object-list ScheduleNames
  N1, \\field Supply Fan Maximum Flow Rate
      \\note This field may be set to "autosize".  If a value is entered, it will *not* be
      \\note multiplied by any sizing factor or by zone multipliers.  If using zone multipliers
      \\note a value entered here must be large enough to serve the multiplied zones.
      \\autosizable
      \\default autosize
      \\units m3/s
      \\minimum> 0.0
  N2, \\field Supply Fan Minimum Flow Rate
      \\note This field is only used to set a minimum part load on the VAV fan power curve.
      \\note Autosize or zero is recommended.
      \\autosizable
      \\default autosize
      \\units m3/s
      \\minimum 0.0
  A3, \\field Supply Fan Placement
      \\type choice
      \\key DrawThrough
      \\key BlowThrough
      \\default DrawThrough
  N3, \\field Supply Fan Total Efficiency
      \\minimum> 0.0
      \\maximum 1.0
      \\default 0.7
  N4, \\field Supply Fan Delta Pressure
      \\units Pa
      \\ip-units inH2O
      \\minimum 0
      \\default 1000
  N5, \\field Supply Fan Motor Efficiency
      \\minimum> 0.0
      \\maximum 1.0
      \\default 0.9
  N6, \\field Supply Fan Motor in Air Stream Fraction
       \\minimum 0.0
       \\maximum 1.0
       \\default 1.0
  A4, \\field Cooling Coil Type
      \\type choice
      \\key  TwoSpeedDX
      \\key  TwoSpeedHumidControlDX
      \\default TwoSpeedDX
  A5, \\field Cooling Coil Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
  A6, \\field Cooling Coil Setpoint Schedule Name
      \\note  Leave blank if constant setpoint
      \\type object-list
      \\object-list ScheduleNames
  N7, \\field Cooling Coil Design Setpoint
      \\note  Used for sizing and as constant setpoint if no Cooling Coil Setpoint Schedule Name is specified.
      \\default 12.8
      \\units C
  N8, \\field Cooling Coil Capacity
      \\note Gross cooling capacity (net capacity plus fan heat)
      \\autosizable
      \\default autosize
      \\units W
  N9, \\field Cooling Coil Rated Sensible Heat Ratio
      \\note Gross SHR
      \\autosizable
      \\minimum 0.5
      \\maximum 1.0
      \\default autosize
 N10, \\field Cooling Coil Rated COP
      \\note Gross cooling capacity divided by power input to the compressor and outdoor fan,
      \\note does not include supply fan heat or supply fan electrical energy input
      \\units W/W
      \\minimum> 0.0
      \\default 3.0
  A7, \\field Heating Coil Type
      \\type choice
      \\key  HotWater
      \\key  Electric
      \\key  Gas
      \\key  None
      \\default None
  A8, \\field Heating Coil Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
  A9, \\field Heating Coil Setpoint Schedule Name
      \\note  Leave blank if constant setpoint
      \\type object-list
      \\object-list ScheduleNames
 N11, \\field Heating Coil Design Setpoint
      \\note   Used for sizing and as constant setpoint if no Heating Coil Setpoint Schedule Name is specified.
      \\default 10.0
      \\units C
 N12, \\field Heating Coil Capacity
      \\autosizable
      \\default autosize
      \\units W
 N13, \\field Gas Heating Coil Efficiency
      \\maximum 1.0
      \\minimum 0.0
      \\default 0.8
 N14, \\field Gas Heating Coil Parasitic Electric Load
      \\units W
      \\ip-units W
      \\minimum 0.0
      \\default 0.0
 N15, \\field Maximum Outdoor Air Flow Rate
      \\autosizable
      \\default autosize
      \\units m3/s
      \\minimum 0.0
 N16, \\field Minimum Outdoor Air Flow Rate
      \\autosizable
      \\default autosize
      \\units m3/s
      \\minimum 0.0
 A10, \\field Minimum Outdoor Air Control Type
      \\type choice
      \\key FixedMinimum
      \\key ProportionalMinimum
      \\default ProportionalMinimum
 A11, \\field Minimum Outdoor Air Schedule Name
      \\note Schedule values multiply the Minimum Outdoor Air Flow Rate
      \\note If blank, multiplier is always one
      \\type object-list
      \\object-list ScheduleNames
 A12, \\field Economizer Type
      \\type choice
      \\key FixedDryBulb
      \\key FixedEnthalpy
      \\key DifferentialDryBulb
      \\key DifferentialEnthalpy
      \\key FixedDewPointAndDryBulb
      \\key ElectronicEnthalpy
      \\key DifferentialDryBulbAndEnthalpy
      \\key NoEconomizer
      \\default NoEconomizer
 A13, \\field Economizer Lockout
      \\type choice
      \\key NoLockout
      \\key LockoutWithHeating
      \\key LockoutWithCompressor
      \\default NoLockout
 N17, \\field Economizer Maximum Limit Dry-Bulb Temperature
      \\type real
      \\units C
      \\note Enter the maximum outdoor dry-bulb temperature limit for FixedDryBulb
      \\note economizer control type. No input or blank input means this limit is
      \\note not operative. Limit is applied regardless of economizer control type.
 N18, \\field Economizer Maximum Limit Enthalpy
      \\type real
      \\units J/kg
      \\note Enter the maximum outdoor enthalpy limit for FixedEnthalpy economizer control type.
      \\note No input or blank input means this limit is not operative
      \\note Limit is applied regardless of economizer control type.
 N19, \\field Economizer Maximum Limit Dewpoint Temperature
      \\type real
      \\units C
      \\note Enter the maximum outdoor dewpoint temperature limit for FixedDewPointAndDryBulb
      \\note economizer control type. No input or blank input means this limit is not operative.
      \\note Limit is applied regardless of economizer control type.
 N20, \\field Economizer Minimum Limit Dry-Bulb Temperature
      \\type real
      \\units C
      \\note Enter the minimum outdoor dry-bulb temperature limit for economizer control.
      \\note No input or blank input means this limit is not operative
      \\note Limit is applied regardless of economizer control type.
 A14, \\field Supply Plenum Name
      \\note Plenum zone name.  Supply plenum serves all zones on this system.
      \\note Blank if none.
      \\type object-list
      \\object-list ZoneNames
 A15, \\field Return Plenum Name
      \\note Plenum zone name.  Supply plenum serves all zones on this system.
      \\note Blank if none.
      \\type object-list
      \\object-list ZoneNames
 A16, \\field Supply Fan Part-Load Power Coefficients
      \\note This field selects a predefined set of fan power coefficients.
      \\note The ASHRAE 90.1-2004 Appendix G coefficients are from TABLE G3.1.3.15, Method 2.
      \\note The other sets of coefficients are from the EnergyPlus Input
      \\note Output Reference, Fan Coefficient Values table.
      \\type choice
      \\key InletVaneDampers
      \\key OutletDampers
      \\key VariableSpeedMotor
      \\key ASHRAE90.1-2004AppendixG
      \\key VariableSpeedMotorPressureReset
      \\default InletVaneDampers
 A17, \\field Night Cycle Control
      \\type choice
      \\key StayOff
      \\key CycleOnAny
      \\key CycleOnControlZone
      \\key CycleOnAnyZoneFansOnly
      \\default StayOff
 A18, \\field Night Cycle Control Zone Name
      \\note Applicable only if Night Cycle Control is Cycle On Control Zone.
      \\type object-list
      \\object-list ZoneNames
 A19, \\field Heat Recovery Type
      \\type choice
      \\key None
      \\key Sensible
      \\key Enthalpy
      \\default None
 N21, \\field Sensible Heat Recovery Effectiveness
      \\minimum 0.0
      \\maximum 1.0
      \\default 0.70
 N22, \\field Latent Heat Recovery Effectiveness
      \\minimum 0.0
      \\maximum 1.0
      \\default 0.65
 A20, \\field Cooling Coil Setpoint Reset Type
      \\note Overrides Cooling Coil Setpoint Schedule Name
      \\note Warmest = as warm as possible yet meet all zone cooling loads
      \\type choice
      \\key None
      \\key Warmest
      \\key OutdoorAirTemperatureReset
      \\default None
 A21, \\field Heating Coil Setpoint Reset Type
      \\note Overrides Heating Coil Setpoint Schedule Name
      \\type choice
      \\key None
      \\key OutdoorAirTemperatureReset
      \\default None
 A22, \\field Dehumidification Control Type
      \\note None = meet sensible load only
      \\note CoolReheat = cool beyond the dry-bulb setpoint
      \\note as required to meet the humidity setpoint.
      \\type choice
      \\key None
      \\key CoolReheat
      \\default None
 A23, \\field Dehumidification Control Zone Name
      \\note Zone name where humidistat is located
      \\type object-list
      \\object-list ZoneNames
 N23, \\field Dehumidification Setpoint
      \\note Zone relative humidity setpoint in percent (0 to 100)
      \\type real
      \\minimum 0.0
      \\maximum 100.0
      \\default 60.0
      \\units percent
 A24, \\field Humidifier Type
      \\type choice
      \\key None
      \\key ElectricSteam
      \\default None
 A25, \\field Humidifier Availability Schedule Name
      \\note If blank, always available
      \\type object-list
      \\object-list ScheduleNames
 N24, \\field Humidifier Rated Capacity
      \\note Moisture output rate at full rated power input.
      \\note The humidifier does not currently autosize, so the default is very large
      \\note to allow for adequate capacity.
      \\type real
      \\units m3/s
      \\minimum 0.0
      \\default 0.000001
      \\ip-units gal/min
 N25, \\field Humidifier Rated Electric Power
      \\note Electric power input at rated capacity moisture output.
      \\note Power consumption is proportional to moisture output with no part-load penalty.
      \\type real
      \\units W
      \\minimum 0.0
      \\autosizable
      \\default autosize
      \\ip-units W
 A26, \\field Humidifier Control Zone Name
      \\note Zone name where humidistat is located
      \\type object-list
      \\object-list ZoneNames
 N26, \\field Humidifier Setpoint
      \\note Zone relative humidity setpoint in percent (0 to 100)
      \\type real
      \\minimum 0.0
      \\maximum 100.0
      \\default 30.0
      \\units percent
 A27; \\field Sizing Option
      \\note Select whether autosized system supply flow rate is the sum of Coincident or NonCoincident
      \\note zone air flow rates.
      \\type choice
      \\key Coincident
      \\key NonCoincident
      \\default NonCoincident

HVACTemplate:System:DedicatedOutdoorAir,
      \\min-fields 46
      \\memo This object creates a dedicated outdoor air system that must be used with
      \\memo HVACTemplate:Zone:* objects for FanCoil PTAC PTHP and WaterToAirHeatPump.
      \\memo Does not support HVACTemplate:Zone:VAV or other central multizone systems
      \\memo Referenced Schedules must be defined elsewhere in the idf.
  A1, \\field Name
      \\reference HVACTemplateDOASSystems
      \\reference HVACTemplateSystems
  A2, \\field System Availability Schedule Name
      \\note If blank, always on; DOAS System always on.  Schedule is used in availability manager
      \\note and fan scheduling.
      \\type object-list
      \\object-list ScheduleNames
  A3, \\field Air Outlet Type
      \\type choice
      \\key  DirectIntoZone
      \\default  DirectIntoZone
  N1, \\field Supply Fan Flow Rate
      \\autosizable
      \\default autosize
      \\units m3/s
      \\minimum> 0.0
  N2, \\field Supply Fan Total Efficiency
      \\minimum> 0.0
      \\maximum 1.0
      \\default 0.7
  N3, \\field Supply Fan Delta Pressure
      \\units Pa
      \\ip-units inH2O
      \\minimum 0
      \\default 1000
  N4, \\field Supply Fan Motor Efficiency
      \\minimum> 0.0
      \\maximum 1.0
      \\default 0.9
  N5, \\field Supply Fan Motor in Air Stream Fraction
      \\minimum 0.0
      \\maximum 1.0
      \\default 1.0
  A4, \\field Supply Fan Placement
      \\type choice
      \\key DrawThrough
      \\key BlowThrough
      \\default DrawThrough
  A5, \\field Cooling Coil Type
      \\type choice
      \\key  ChilledWater
      \\key  ChilledWaterDetailedFlatModel
      \\key  TwoSpeedDX
      \\key  TwoStageDX
      \\key  TwoStageHumidityControlDX
      \\key  HeatExchangerAssistedChilledWater
      \\key  HeatExchangerAssistedDX
      \\key  None
      \\default  ChilledWater
  A6, \\field Cooling Coil Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
  A7, \\field Cooling Coil Setpoint Control Type
      \\type choice
      \\key  FixedSetpoint
      \\key  Scheduled
      \\key  OutdoorAirTemperatureReset
      \\key  None
      \\default FixedSetpoint
  N6, \\field Cooling Coil Design Setpoint
      \\note  Used for sizing and as constant setpoint if no Cooling Coil Setpoint Schedule Name is specified.
      \\default 12.8
      \\units C
  A8, \\field Cooling Coil Setpoint Schedule Name
      \\note  Leave blank if constant setpoint
      \\type object-list
      \\object-list ScheduleNames
  N7, \\field Cooling Coil Setpoint at Outdoor Dry-Bulb Low
      \\note Applicable only for OutdoorAirTemperatureReset control.
      \\units C
      \\default 15.6
  N8, \\field Cooling Coil Reset Outdoor Dry-Bulb Low
      \\note Applicable only for OutdoorAirTemperatureReset control.
      \\note Defaults are 15.6C (60F) at 15.6C (60F) to 12.8C (55F) at 23.3C (74F)
      \\units C
      \\default 15.6
  N9, \\field Cooling Coil Setpoint at Outdoor Dry-Bulb High
      \\note Applicable only for OutdoorAirTemperatureReset control.
      \\units C
      \\default 12.8
 N10, \\field Cooling Coil Reset Outdoor Dry-Bulb High
      \\note Applicable only for OutdoorAirTemperatureReset control.
      \\units C
      \\default 23.3
 N11, \\field DX Cooling Coil Capacity
      \\note Gross cooling capacity (net capacity plus fan heat)
      \\autosizable
      \\default autosize
      \\units W
 N12, \\field DX Cooling Coil Rated Sensible Heat Ratio
      \\note Gross SHR
      \\autosizable
      \\minimum 0.5
      \\maximum 1.0
      \\default autosize
 N13, \\field DX Cooling Coil Rated COP
      \\note Gross cooling capacity divided by power input to the compressor and outdoor fan,
      \\note does not include supply fan heat or supply fan electrical energy input
      \\units W/W
      \\minimum> 0.0
      \\default 3.0
  A9, \\field Heating Coil Type
      \\type choice
      \\key  HotWater
      \\key  Electric
      \\key  Gas
      \\key  None
      \\default HotWater
 A10, \\field Heating Coil Availability Schedule Name
      \\note If blank, always on
      \\type object-list
      \\object-list ScheduleNames
 A11, \\field Heating Coil Setpoint Control Type
      \\note When selecting OutdoorAirTemperatureReset, the Heating Coil Design Setpoint may need to be changed
      \\type choice
      \\key  FixedSetpoint
      \\key  Scheduled
      \\key  OutdoorAirTemperatureReset
      \\key  None
      \\default FixedSetpoint
 N14, \\field Heating Coil Design Setpoint
      \\note   Used for sizing and as constant setpoint if no Heating Coil Setpoint Schedule Name is specified.
      \\default 12.2
      \\units C
 A12, \\field Heating Coil Setpoint Schedule Name
      \\note  Leave blank if constant setpoint
      \\type object-list
      \\object-list ScheduleNames
 N15, \\field Heating Coil Setpoint at Outdoor Dry-Bulb Low
      \\note Applicable only for OutdoorAirTemperatureReset control.
      \\note Defaults 15.0C (59F) at 7.8C (46F) to 12.2C (54F) at 12.2C (54F)
      \\units C
      \\default 15.0
 N16, \\field Heating Coil Reset Outdoor Dry-Bulb Low
      \\note Applicable only for OutdoorAirTemperatureReset control.
      \\units C
      \\default 7.8
 N17, \\field Heating Coil Setpoint at Outdoor Dry-Bulb High
      \\note Applicable only for OutdoorAirTemperatureReset control.
      \\units C
      \\default 12.2
 N18, \\field Heating Coil Reset Outdoor Dry-Bulb High
      \\note Applicable only for OutdoorAirTemperatureReset control.
      \\units C
      \\default 12.2
 N19, \\field Gas Heating Coil Efficiency
      \\maximum 1.0
      \\minimum 0.0
      \\default 0.8
 N20, \\field Gas Heating Coil Parasitic Electric Load
      \\units W
      \\ip-units W
      \\minimum 0.0
      \\default 0.0
 A13, \\field Heat Recovery Type
      \\type choice
      \\key None
      \\key Sensible
      \\key Enthalpy
      \\default None
 N21, \\field Heat Recovery Sensible Effectiveness
      \\minimum 0.0
      \\maximum 1.0
      \\default 0.70
 N22, \\field Heat Recovery Latent Effectiveness
      \\minimum 0.0
      \\maximum 1.0
      \\default 0.65
 A14, \\field Heat Recovery Heat Exchanger Type
      \\type choice
      \\key Plate
      \\key Rotary
      \\default Plate
 A15, \\field Heat Recovery Frost Control Type
      \\type choice
      \\key None
      \\key ExhaustAirRecirculation
      \\key ExhaustOnly
      \\key MinimumExhaustTemperature
      \\default None
 A16, \\field Dehumidification Control Type
      \\note None = meet sensible load only
      \\note CoolReheatHeatingCoil = cool beyond the dry-bulb setpoint, reheat with heating coil
      \\note Valid for all cooling coil types.  If no heating coil specified, cold supply temps may occur.
      \\note CoolReheatDesuperheater = cool beyond the dry-bulb setpoint
      \\note as required to meet the humidity setpoint, reheat with desuperheater coil.
      \\note Valid only for Cooling Coil Type = TwoSpeedDX, TwoStageDX, TwoStageHumidityControlDX, or HeatExchangerAssistedDX.
      \\note Multimode = activate enhanced dehumidification mode as needed and meet sensible load.
      \\note Valid only for Cooling Coil Type = TwoStageHumidityControlDX
      \\type choice
      \\key None
      \\key CoolReheatHeatingCoil
      \\key CoolReheatDesuperheater
      \\key Multimode
      \\default None
 N23, \\field Dehumidification Setpoint
      \\note The supply air humidity ratio for dehumidification control.
      \\note Default of 0.00924 kgWater/kgDryAir is equivalent to 12.8C (55F) dewpoint.
      \\note Ignored if Dehumidification Setpoint Schedule specified below
      \\type real
      \\minimum 0.0
      \\maximum 1.0
      \\default 0.00924
      \\units kgWater/kgDryAir
 A17, \\field Humidifier Type
      \\type choice
      \\key None
      \\key ElectricSteam
      \\default None
 A18, \\field Humidifier Availability Schedule Name
      \\note If blank, always available
      \\type object-list
      \\object-list ScheduleNames
 N24, \\field Humidifier Rated Capacity
      \\note Moisture output rate at full rated power input.
      \\note The humidifier does not currently autosize, so the default is very large
      \\note to allow for adequate capacity.
      \\type real
      \\units m3/s
      \\minimum 0.0
      \\default 0.000001
      \\ip-units gal/min
 N25, \\field Humidifier Rated Electric Power
      \\note Electric power input at rated capacity moisture output.
      \\note Power consumption is proportional to moisture output with no part-load penalty.
      \\type real
      \\units W
      \\minimum 0.0
      \\autosizable
      \\default autosize
      \\ip-units W
 N26, \\field Humidifier Constant Setpoint
      \\note The supply air humidity ratio for humidification control.
      \\note Ignored if Humidifier Setpoint Schedule specified below
      \\type real
      \\minimum 0.0
      \\maximum 1.0
      \\default 0.003
      \\units kgWater/kgDryAir
 A19, \\field Dehumidification Setpoint Schedule Name
      \\note Leave blank to use constant setpoint specified in Dehumidification Setpoint above.
      \\note Schedule values must be in units of humidity ratio (kgWater/kgDryAir or lbWater/lbDryAir)
      \\type object-list
      \\object-list ScheduleNames
 A20; \\field Humidifier Setpoint Schedule Name
      \\note Leave blank to use constant setpoint specified in Humidifer Constant Setpoint above.
      \\note Schedule values must be in units of humidity ratio (kgWater/kgDryAir or lbWater/lbDryAir)
      \\type object-list
      \\object-list ScheduleNames

HVACTemplate:Plant:ChilledWaterLoop,
      \\min-fields 21
      \\memo Plant and condenser loops to serve all HVACTemplate
      \\memo chilled water coils, chillers, and towers.
      \\unique-object
  A1, \\field Name
      \\required-field
  A2, \\field Pump Schedule Name
      \\note If blank, always available
      \\note Applies to both chilled water and condenser loop pumps
      \\type object-list
      \\object-list ScheduleNames
  A3, \\field Pump Control Type
      \\note Applies to both chilled water and condenser loop pumps
      \\type choice
      \\key Intermittent
      \\key Continuous
      \\default Intermittent
  A4, \\field Chiller Plant Operation Scheme Type
      \\note Default operation type makes all equipment available
      \\note at all times operating in order of Priority specified
      \\note in HVACTemplate:Plant:Chiller objects.
      \\type choice
      \\key Default
      \\key UserDefined
      \\default Default
  A5, \\field Chiller Plant Equipment Operation Schemes Name
      \\type object-list
      \\object-list PlantOperationSchemes
      \\note Name of a PlantEquipmentOperationSchemes object
      \\note Ignored if Chiller Plant Operation Scheme Type = Default
  A6, \\field Chilled Water Setpoint Schedule Name
      \\note  Leave blank if constant setpoint
      \\type object-list
      \\object-list ScheduleNames
  N1, \\field Chilled Water Design Setpoint
      \\note   Used for sizing and as constant setpoint if no Chilled Water Setpoint Schedule Name is specified.
      \\default 7.22
      \\units C
  A7, \\field Chilled Water Pump Configuration
      \\note VariablePrimaryNoSecondary - variable flow to chillers and coils
      \\note ConstantPrimaryNoSecondary - constant flow to chillers and coils, excess bypassed
      \\note ConstantPrimaryVariableSecondary - constant flow to chillers, variable flow to coils
      \\note VariablePrimaryConstantSecondary - currently unsupported - variable flow to chillers, constant flow to coils
      \\type choice
      \\key ConstantPrimaryNoSecondary
      \\key VariablePrimaryNoSecondary
      \\key ConstantPrimaryVariableSecondary
      \\default ConstantPrimaryNoSecondary
  N2, \\field Primary Chilled Water Pump Rated Head
      \\units Pa
      \\minimum 0.0
      \\default 179352
      \\note default head is 60 feet H2O
      \\ip-units ftH2O
  N3, \\field Secondary Chilled Water Pump Rated Head
      \\units Pa
      \\minimum 0.0
      \\default 179352
      \\note default head is 60 feet H2O
      \\ip-units ftH2O
  A8, \\field Condenser Plant Operation Scheme Type
      \\note Default operation type makes all equipment available
      \\note at all times operating in order of Priority specified
      \\note in HVACTemplate:Plant:Tower objects.
      \\type choice
      \\key Default
      \\key UserDefined
      \\default Default
      \\note  May be left blank if not serving any water cooled chillers
  A9, \\field Condenser Equipment Operation Schemes Name
      \\type object-list
      \\object-list CondenserOperationSchemes
      \\note Name of a CondenserEquipmentOperationSchemes object
      \\note Ignored if Condenser Plant Operation Scheme Type = Default
      \\note  May be left blank if not serving any water cooled chillers
 A10, \\field Condenser Water Temperature Control Type
      \\note  May be left blank if not serving any water cooled chillers
      \\type choice
      \\key OutdoorWetBulbTemperature
      \\key SpecifiedSetpoint
 A11, \\field Condenser Water Setpoint Schedule Name
      \\note  Leave blank if constant setpoint
      \\note  May be left blank if not serving any water cooled chillers
      \\type object-list
      \\object-list ScheduleNames
  N4, \\field Condenser Water Design Setpoint
      \\note  Used for sizing and as constant setpoint if no Condenser Water Setpoint Schedule Name is specified.
      \\note  May be left blank if not serving any water cooled chillers
      \\default 29.4
      \\units C
  N5, \\field Condenser Water Pump Rated Head
      \\note  May be left blank if not serving any water cooled chillers
      \\units Pa
      \\minimum 0.0
      \\default 179352
      \\note default head is 60 feet H2O
      \\ip-units ftH2O
 A12, \\field Chilled Water Setpoint Reset Type
      \\note Overrides Chilled Water Setpoint Schedule Name
      \\type choice
      \\key None
      \\key OutdoorAirTemperatureReset
      \\default None
  N6, \\field Chilled Water Setpoint at Outdoor Dry-Bulb Low
      \\note Applicable only for OutdoorAirTemperatureReset control.
      \\units C
      \\default 12.2
  N7, \\field Chilled Water Reset Outdoor Dry-Bulb Low
      \\note Applicable only for OutdoorAirTemperatureReset control.
      \\units C
      \\default 15.6
  N8, \\field Chilled Water Setpoint at Outdoor Dry-Bulb High
      \\note Applicable only for OutdoorAirTemperatureReset control.
      \\units C
      \\default 6.7
  N9, \\field Chilled Water Reset Outdoor Dry-Bulb High
      \\note Applicable only for OutdoorAirTemperatureReset control.
      \\units C
      \\default 26.7
 A13, \\field Chilled Water Primary Pump Type
      \\note Describes the type of pump configuration used for the primary portion of the chilled water loop.
      \\type choice
      \\key SinglePump
      \\key PumpPerChiller
      \\key TwoHeaderedPumps
      \\key ThreeHeaderedPumps
      \\key FourHeaderedPumps
      \\key FiveHeaderedPumps
      \\default SinglePump
 A14, \\field Chilled Water Secondary Pump Type
      \\note Describes the type of pump configuration used for the secondary portion of the chilled water loop.
      \\type choice
      \\key SinglePump
      \\key TwoHeaderedPumps
      \\key ThreeHeaderedPumps
      \\key FourHeaderedPumps
      \\key FiveHeaderedPumps
      \\default SinglePump
 A15, \\field Condenser Water Pump Type
      \\note Describes the type of pump configuration used for the condenser water loop.
      \\type choice
      \\key SinglePump
      \\key PumpPerTower
      \\key TwoHeaderedPumps
      \\key ThreeHeaderedPumps
      \\key FourHeaderedPumps
      \\key FiveHeaderedPumps
      \\default SinglePump
  A16,\\field Chilled Water Supply Side Bypass Pipe
      \\note Determines if a supply side bypass pipe is present in the chilled water loop.
      \\type choice
      \\key Yes
      \\key No
      \\default Yes
  A17,\\field Chilled Water Demand Side Bypass Pipe
      \\note Determines if a demand side bypass pipe is present in the chilled water loop.
      \\type choice
      \\key Yes
      \\key No
      \\default Yes
  A18,\\field Condenser Water Supply Side Bypass Pipe
      \\note Determines if a supply side bypass pipe is present in the condenser water loop.
      \\type choice
      \\key Yes
      \\key No
      \\default Yes
  A19,\\field Condenser Water Demand Side Bypass Pipe
      \\note Determines if a demand side bypass pipe is present in the condenser water loop.
      \\type choice
      \\key Yes
      \\key No
      \\default Yes
  A20,\\field Fluid Type
      \\type choice
      \\key Water
      \\key EthyleneGlycol30
      \\key EthyleneGlycol40
      \\key EthyleneGlycol50
      \\key EthyleneGlycol60
      \\key PropyleneGlycol30
      \\key PropyleneGlycol40
      \\key PropyleneGlycol50
      \\key PropyleneGlycol60
      \\default Water
  N10,\\field Loop Design Delta Temperature
      \\note The temperature difference used in sizing the loop flow rate.
      \\units deltaC
      \\default 6.67
  N11,\\field Minimum Outdoor Dry Bulb Temperature
      \\note The minimum outdoor dry bulb temperature that the chilled water loops operate.
      \\note Leave blank for no limit.
      \\units C
  A21,\\field Chilled Water Load Distribution Scheme
      \\type choice
      \\key Optimal
      \\key Sequential
      \\key Uniform
      \\default Sequential
  A22;\\field Condenser Water Load Distribution Scheme
      \\type choice
      \\key Optimal
      \\key Sequential
      \\key Uniform
      \\default Sequential

HVACTemplate:Plant:Chiller,
      \\min-fields 7
      \\memo This object adds a chiller to an HVACTemplate:Plant:ChilledWaterLoop.
  A1, \\field Name
      \\required-field
  A2, \\field Chiller Type
      \\required-field
      \\type choice
      \\key DistrictChilledWater
      \\key ElectricCentrifugalChiller
      \\key ElectricScrewChiller
      \\key ElectricReciprocatingChiller
  N1, \\field Capacity
      \\autosizable
      \\default autosize
      \\units W
      \\minimum> 0.0
  N2, \\field Nominal COP
      \\required-field
      \\note Not applicable if Chiller Type is DistrictChilledWater
      \\note Electric Reciprocating Chiller
      \\units W/W
      \\minimum> 0.0
  A3, \\field Condenser Type
      \\note Not applicable if Chiller Type is DistrictChilledWater
      \\type choice
      \\key AirCooled
      \\key WaterCooled
      \\key EvaporativelyCooled
      \\default WaterCooled
  A4, \\field Priority
      \\note If Chiller Plant Operation Scheme Type=Default
      \\note in HVACTemplate:Plant:ChilledWaterLoop, then equipment
      \\note operates in Priority order, 1, 2, 3, etc.
  N3, \\field Sizing Factor
      \\note Multiplies the autosized capacity and flow rates
      \\type real
      \\minimum> 0.0
      \\default 1.0
  N4, \\field Minimum Part Load Ratio
      \\type real
      \\note Part load ratio below which the chiller starts cycling on/off to meet the load.
      \\note Must be less than or equal to Maximum Part Load Ratio.
      \\minimum 0.0
      \\default 0.0
  N5, \\field Maximum Part Load Ratio
      \\type real
      \\note Maximum allowable part load ratio. Must be greater than or equal to Minimum Part Load Ratio.
      \\minimum> 0.0
      \\default 1.0
  N6, \\field Optimum Part Load Ratio
      \\type real
      \\note Optimum part load ratio where the chiller is most efficient.
      \\note Must be greater than or equal to the Minimum Part Load Ratio
      \\note and less than or equal to the Maximum Part Load Ratio.
      \\minimum> 0.0
      \\default 1.0
  N7, \\field Minimum Unloading Ratio
      \\type real
      \\note Part load ratio where the chiller can no longer unload and false loading begins.
      \\note Minimum unloading ratio must be greater than or equal to the Minimum Part Load Ratio
      \\note and less than or equal to the Maximum Part Load Ratio.
      \\minimum 0.0
      \\default 0.25
  N8; \\field Leaving Chilled Water Lower Temperature Limit
      \\type real
      \\default 5.0
      \\units C

HVACTemplate:Plant:Chiller:ObjectReference,
      \\min-fields 4
      \\memo This object references a detailed chiller object and adds it to
      \\memo an HVACTemplate:Plant:ChilledWaterLoop. The user must create a complete
      \\memo detailed chiller object with all required curve or performance objects.
  A1, \\field Name
      \\note The name of this object.
      \\required-field
  A2, \\field Chiller Object Type
      \\required-field
      \\type choice
      \\key Chiller:Electric:EIR
      \\key Chiller:Electric:ReformulatedEIR
      \\default Chiller:Electric:EIR
  A3, \\field Chiller Name
      \\note The name of the detailed chiller object.
      \\required-field
      \\type object-list
      \\object-list Chillers
  N1; \\field Priority
      \\note If Chiller Plant Operation Scheme Type=Default
      \\note in HVACTemplate:Plant:ChilledWaterLoop, then equipment
      \\note operates in Priority order, 1, 2, 3, etc.

HVACTemplate:Plant:Tower,
      \\min-fields 9
      \\memo This object adds a cooling tower to an HVACTemplate:Plant:ChilledWaterLoop or MixedWaterLoop.
  A1, \\field Name
      \\required-field
  A2, \\field Tower Type
      \\required-field
      \\type choice
      \\key SingleSpeed
      \\key TwoSpeed
  N1, \\field High Speed Nominal Capacity
      \\note Applicable for tower type SingleSpeed and TwoSpeed
      \\note Nominal tower capacity with entering water at 35C (95F), leaving water at
      \\note 29.44C (85F), entering air at 25.56C (78F) wet-bulb temperature and 35C (95F)
      \\note dry-bulb temperature, with the tower fan operating at high speed. Design water
      \\note flow rate assumed to be 5.382E-8 m3/s per watt(3 gpm/ton). Nominal tower capacity
      \\note times (1.25) gives the actual tower heat rejection at these operating conditions.
      \\autosizable
      \\default autosize
      \\units W
      \\minimum> 0.0
  N2, \\field High Speed Fan Power
      \\note Applicable for tower type SingleSpeed and TwoSpeed
      \\autosizable
      \\default autosize
      \\units W
      \\ip-units W
      \\minimum> 0.0
  N3, \\field Low Speed Nominal Capacity
      \\note Applicable only for Tower Type TwoSpeed
      \\note Nominal tower capacity with entering water at 35C (95F), leaving water at
      \\note 29.44C (85F), entering air at 25.56C (78F) wet-bulb temperature and 35C (95F)
      \\note dry-bulb temperature, with the tower fan operating at low speed. Design water flow
      \\note rate assumed to be 5.382E-8 m3/s per watt of tower high-speed nominal capacity
      \\note (3 gpm/ton). Nominal tower capacity times (1.25) gives the actual tower heat
      \\note rejection at these operating conditions.
      \\autosizable
      \\default autosize
      \\units W
      \\minimum> 0.0
  N4, \\field Low Speed Fan Power
      \\note Applicable only for Tower Type TwoSpeed
      \\autosizable
      \\default autosize
      \\units W
      \\ip-units W
      \\minimum> 0.0
  N5, \\field Free Convection Capacity
      \\note Applicable for Tower Type SingleSpeed and TwoSpeed
      \\note Tower capacity in free convection regime with entering water at 35C (95F),
      \\note leaving water at 29.44C (85F), entering air at 25.56C (78F) wet-bulb temperature
      \\note and 35C (95F) dry-bulb temperature. Design water flow rate assumed to be
      \\note 5.382E-8 m3/s per watt of tower high-speed nominal capacity (3 gpm/ton). Tower
      \\note free convection capacity times (1.25) gives the actual tower heat rejection at
      \\note these operating conditions.
      \\autosizable
      \\default autosize
      \\units W
      \\minimum 0.0
  A3, \\field Priority
      \\note Applicable for all Tower Types
      \\note If Condenser Plant Operation Scheme Type=Default
      \\note in HVACTemplate:Plant:ChilledWaterLoop, then equipment
      \\note operates in Priority order, 1, 2, 3, etc.
  N6; \\field Sizing Factor
      \\note Multiplies the autosized capacity and flow rates
      \\type real
      \\minimum> 0.0
      \\default 1.0

HVACTemplate:Plant:Tower:ObjectReference,
      \\min-fields 4
      \\memo This object references a detailed cooling tower object and adds it to
      \\memo an HVACTemplate:Plant:ChilledWaterLoop or MixedWaterLoop. The user must create a complete
      \\memo detailed cooling tower object with all required curve or performance objects.
  A1, \\field Name
      \\note The name of this object.
      \\required-field
  A2, \\field Cooling Tower Object Type
      \\required-field
      \\type choice
      \\key CoolingTower:SingleSpeed
      \\key CoolingTower:TwoSpeed
      \\key CoolingTower:VariableSpeed
      \\default CoolingTower:SingleSpeed
  A3, \\field Cooling Tower Name
      \\note The name of the detailed cooling tower object.
      \\required-field
      \\type object-list
      \\object-list CoolingTowers
  N1; \\field Priority
      \\note If Condenser Plant Operation Scheme Type=Default
      \\note in HVACTemplate:Plant:ChilledWaterLoop or MixedWaterLoop, then equipment
      \\note operates in Priority order, 1, 2, 3, etc.

HVACTemplate:Plant:HotWaterLoop,
      \\min-fields 14
      \\unique-object
      \\memo Plant loop to serve all HVACTemplate
      \\memo hot water coils and boilers.
  A1, \\field Name
      \\required-field
  A2, \\field Pump Schedule Name
      \\note If blank, always available
      \\type object-list
      \\object-list ScheduleNames
  A3, \\field Pump Control Type
      \\type choice
      \\key Intermittent
      \\key Continuous
      \\default Intermittent
  A4, \\field Hot Water Plant Operation Scheme Type
      \\note Default operation type makes all equipment available
      \\note at all times operating in order of Priority specified
      \\note in HVACTemplate:Plant:Boiler objects.
      \\type choice
      \\key Default
      \\key UserDefined
      \\default Default
  A5, \\field Hot Water Plant Equipment Operation Schemes Name
      \\type object-list
      \\object-list PlantOperationSchemes
      \\note Name of a PlantEquipmentOperationSchemes object
      \\note Ignored if Plant Operation Scheme Type = Default
  A6, \\field Hot Water Setpoint Schedule Name
      \\note Leave blank if constant setpoint
      \\type object-list
      \\object-list ScheduleNames
  N1, \\field Hot Water Design Setpoint
      \\note  Used for sizing and as constant setpoint if no Setpoint Schedule Name is specified.
      \\default 82.0
      \\units C
  A7, \\field Hot Water Pump Configuration
      \\note VariableFlow - variable flow to boilers and coils, excess bypassed
      \\note ConstantFlow - constant flow to boilers and coils, excess bypassed
      \\type choice
      \\key VariableFlow
      \\key ConstantFlow
      \\default ConstantFlow
  N2, \\field Hot Water Pump Rated Head
      \\units Pa
      \\minimum 0.0
      \\default 179352
      \\note Default head is 60 feet H2O
      \\ip-units ftH2O
  A8, \\field Hot Water Setpoint Reset Type
      \\note Overrides Hot Water Setpoint Schedule Name
      \\type choice
      \\key None
      \\key OutdoorAirTemperatureReset
      \\default None
  N3, \\field Hot Water Setpoint at Outdoor Dry-Bulb Low
      \\note Applicable only for OutdoorAirTemperatureReset control.
      \\units C
      \\default 82.2
  N4, \\field Hot Water Reset Outdoor Dry-Bulb Low
      \\note Applicable only for OutdoorAirTemperatureReset control.
      \\units C
      \\default -6.7
  N5, \\field Hot Water Setpoint at Outdoor Dry-Bulb High
      \\note Applicable only for OutdoorAirTemperatureReset control.
      \\units C
      \\default 65.6
  N6, \\field Hot Water Reset Outdoor Dry-Bulb High
      \\note Applicable only for OutdoorAirTemperatureReset control.
      \\units C
      \\default 10.0
  A9, \\field Hot Water Pump Type
      \\note Describes the type of pump configuration used for the hot water loop.
      \\type choice
      \\key SinglePump
      \\key PumpPerBoiler
      \\key TwoHeaderedPumps
      \\key ThreeHeaderedPumps
      \\key FourHeaderedPumps
      \\key FiveHeaderedPumps
      \\default SinglePump
  A10,\\field Supply Side Bypass Pipe
      \\note Determines if a supply side bypass pipe is present in the hot water loop.
      \\type choice
      \\key Yes
      \\key No
      \\default Yes
  A11,\\field Demand Side Bypass Pipe
      \\note Determines if a demand side bypass pipe is present in the hot water loop.
      \\type choice
      \\key Yes
      \\key No
      \\default Yes
  A12,\\field Fluid Type
      \\type choice
      \\key Water
      \\key EthyleneGlycol30
      \\key EthyleneGlycol40
      \\key EthyleneGlycol50
      \\key EthyleneGlycol60
      \\key PropyleneGlycol30
      \\key PropyleneGlycol40
      \\key PropyleneGlycol50
      \\key PropyleneGlycol60
      \\default Water
  N7, \\field Loop Design Delta Temperature
      \\note The temperature difference used in sizing the loop flow rate.
      \\units deltaC
      \\default 11.0
  N8, \\field Maximum Outdoor Dry Bulb Temperature
      \\note The maximum outdoor dry bulb temperature that the hot water loops operate.
      \\note Leave blank for no limit.
      \\units C
  A13;\\field Load Distribution Scheme
      \\type choice
      \\key Optimal
      \\key Sequential
      \\key Uniform
      \\default Sequential


HVACTemplate:Plant:Boiler,
      \\min-fields 7
      \\memo This object adds a boiler to an HVACTemplate:Plant:HotWaterLoop or MixedWaterLoop.
  A1, \\field Name
      \\required-field
  A2, \\field Boiler Type
      \\required-field
      \\type choice
      \\key DistrictHotWater
      \\key HotWaterBoiler
  N1, \\field Capacity
      \\autosizable
      \\default autosize
      \\units W
      \\minimum> 0.0
  N2, \\field Efficiency
      \\note Not applicable  if Boiler Type is DistrictHotWater
      \\minimum 0.0
      \\maximum 1.0
      \\default 0.8
  A3, \\field Fuel Type
      \\note Not applicable  if Boiler Type is DistrictHotWater
      \\type choice
      \\key Electricity
      \\key NaturalGas
      \\key PropaneGas
      \\key FuelOil#1
      \\key FuelOil#2
      \\key Coal
      \\key Diesel
      \\key Gasoline
      \\key OtherFuel1
      \\key OtherFuel2
  A4, \\field Priority
      \\note If Hot Water Plant Operation Scheme Type=Default
      \\note in HVACTemplate:Plant:HotWaterLoop, then equipment
      \\note operates in priority order, 1, 2, 3, etc.
  N3, \\field Sizing Factor
      \\note Multiplies the autosized capacity and flow rates
      \\type real
      \\minimum> 0.0
      \\default 1.0
  N4, \\field Minimum Part Load Ratio
      \\type real
      \\minimum 0.0
      \\default 0.0
  N5, \\field Maximum Part Load Ratio
      \\type real
      \\minimum 0.0
      \\default 1.1
  N6, \\field Optimum Part Load Ratio
      \\type real
      \\minimum 0.0
      \\default 1.0
  N7; \\field Water Outlet Upper Temperature Limit
      \\type real
      \\units C
      \\default 100.0

HVACTemplate:Plant:Boiler:ObjectReference,
      \\min-fields 4
      \\memo This object references a detailed boiler object and adds it to
      \\memo an HVACTemplate:Plant:HotWaterLoop or MixedWaterLoop. The user must create a complete
      \\memo detailed boiler object with all required curve or performance objects.
  A1, \\field Name
      \\note The name of this object.
      \\required-field
  A2, \\field Boiler Object Type
      \\required-field
      \\type choice
      \\key Boiler:HotWater
      \\default Boiler:HotWater
  A3, \\field Boiler Name
      \\note The name of the detailed boiler object.
      \\required-field
      \\type object-list
      \\object-list Boilers
  N1; \\field Priority
      \\note If Hot Water Plant Operation Scheme Type=Default
      \\note in HVACTemplate:Plant:HotWaterLoop or MixedWaterLoop, then equipment
      \\note operates in Priority order, 1, 2, 3, etc.


HVACTemplate:Plant:MixedWaterLoop,
      \\min-fields 11
      \\memo Central plant loop portion of a water source heat pump system.
      \\unique-object
  A1, \\field Name
      \\required-field
  A2, \\field Pump Schedule Name
      \\note If blank, always available
      \\note Applies to both chilled water and condenser loop pumps
      \\type object-list
      \\object-list ScheduleNames
  A3, \\field Pump Control Type
      \\note Applies to both chilled water and condenser loop pumps
      \\type choice
      \\key Intermittent
      \\key Continuous
      \\default Intermittent
  A4, \\field Operation Scheme Type
      \\note Default operation type makes all equipment available
      \\note at all times operating in order of Priority specified
      \\note in HVACTemplate:Plant:Boiler and HVACTemplate:Plant:Tower objects.
      \\type choice
      \\key Default
      \\key UserDefined
      \\default Default
  A5, \\field Equipment Operation Schemes Name
      \\type object-list
      \\object-list PlantOperationSchemes
      \\note Name of a PlantEquipmentOperationSchemes object
      \\note Ignored if Plant Operation Scheme Type = Default
  A6, \\field High Temperature Setpoint Schedule Name
      \\note Leave blank if constant setpoint
      \\type object-list
      \\object-list ScheduleNames
  N1, \\field High Temperature Design Setpoint
      \\note  Used for sizing and as constant setpoint if no Setpoint Schedule Name is specified.
      \\default 33.0
      \\units C
  A7, \\field Low Temperature Setpoint Schedule Name
      \\note  Leave blank if constant setpoint
      \\note  May be left blank if not serving any water cooled chillers
      \\type object-list
      \\object-list ScheduleNames
  N2, \\field Low Temperature Design Setpoint
      \\note  Used for sizing and as constant setpoint if no Condenser Water Setpoint Schedule Name is specified.
      \\note  May be left blank if not serving any water cooled chillers
      \\default 20.0
      \\units C
  A8, \\field Water Pump Configuration
      \\note VariableFlow - variable flow to boilers and coils, excess bypassed
      \\note ConstantFlow - constant flow to boilers and coils, excess bypassed
      \\type choice
      \\key VariableFlow
      \\key ConstantFlow
      \\default ConstantFlow
  N3, \\field Water Pump Rated Head
      \\note  May be left blank if not serving any water cooled chillers
      \\units Pa
      \\minimum 0.0
      \\default 179352
      \\note default head is 60 feet H2O
      \\ip-units ftH2O
  A9, \\field Water Pump Type
      \\note Describes the type of pump configuration used for the mixed water loop.
      \\type choice
      \\key SinglePump
      \\key PumpPerTowerOrBoiler
      \\key TwoHeaderedPumps
      \\key ThreeHeaderedPumps
      \\key FourHeaderedPumps
      \\key FiveHeaderedPumps
      \\default SinglePump
  A10,\\field Supply Side Bypass Pipe
      \\note Determines if a supply side bypass pipe is present in the hot water loop.
      \\type choice
      \\key Yes
      \\key No
      \\default Yes
  A11,\\field Demand Side Bypass Pipe
      \\note Determines if a demand side bypass pipe is present in the hot water loop.
      \\type choice
      \\key Yes
      \\key No
      \\default Yes
  A12,\\field Fluid Type
      \\type choice
      \\key Water
      \\key EthyleneGlycol30
      \\key EthyleneGlycol40
      \\key EthyleneGlycol50
      \\key EthyleneGlycol60
      \\key PropyleneGlycol30
      \\key PropyleneGlycol40
      \\key PropyleneGlycol50
      \\key PropyleneGlycol60
      \\default Water
  N4, \\field Loop Design Delta Temperature
      \\note The temperature difference used in sizing the loop flow rate.
      \\units deltaC
      \\default 5.6
  A13;\\field Load Distribution Scheme
      \\type choice
      \\key Optimal
      \\key Sequential
      \\key Uniform
      \\default Sequential

\\group HVAC Design Objects

DesignSpecification:OutdoorAir,
  \\min-fields 1
  \\memo This object is used to describe general outdoor air requirements which
  \\memo are referenced by other objects.
  A1, \\field Name
      \\required-field
      \\type alpha
      \\reference DesignSpecificationOutdoorAirNames
  A2, \\field Outdoor Air Method
      \\type choice
      \\key Flow/Person
      \\key Flow/Area
      \\key Flow/Zone
      \\key AirChanges/Hour
      \\key Sum
      \\key Maximum
      \\default Flow/Person
      \\note Flow/Person => Outdoor Air Flow per Person * Occupancy = Design Flow Rate,
      \\note Flow/Area => Outdoor Air Flow per Zone Floor Area * Zone Floor Area = Design Flow Rate,
      \\note Flow/Zone => Outdoor Air Flow per Zone = Design Flow Rate,
      \\note AirChanges/Hour => Outdoor Air Flow Air Changes per Hour * Zone Volume adjusted for m3/s = Design Flow Rate
  N1, \\field Outdoor Air Flow per Person
      \\type real
      \\units m3/s-person
      \\default 0.00944
      \\minimum 0
      \\note 0.00944 m3/s is equivalent to 20 cfm per person
      \\note This input should be used if the field Outdoor Air Method is Flow/Person.
      \\note This input is used if the field Outdoor Air Method is Flow/Person, Sum, or Maximum
  N2, \\field Outdoor Air Flow per Zone Floor Area
      \\units m3/s-m2
      \\default 0.0
      \\minimum 0
      \\note This input should be used if the field Outdoor Air Method is Flow/Area.
      \\note This input is used if the field Outdoor Air Method is Flow/Area, Sum, or Maximum
  N3, \\field Outdoor Air Flow per Zone
      \\type real
      \\units m3/s
      \\default 0.0
      \\minimum 0
      \\note This input should be used if the field Outdoor Air Method is Flow/Zone.
      \\note This input is used if the field Outdoor Air Method is Flow/Zone, Sum, or Maximum
  N4, \\field Outdoor Air Flow Air Changes per Hour
      \\units 1/hr
      \\type real
      \\default 0.0
      \\minimum 0
      \\note This input should be used if the field Outdoor Air Method is AirChanges/Hour.
      \\note This input is used if the field Outdoor Air Method is AirChanges/Hour, Sum, or Maximum
  A3; \\field Outdoor Air Flow Rate Fraction Schedule Name
      \\type object-list
      \\object-list ScheduleNames
      \\note Schedule values are multiplied by the Outdoor Air Flow rate calculated using
      \\note the previous four inputs. Schedule values are limited to 0 to 1.

DesignSpecification:ZoneAirDistribution,
  \\min-fields 1
  \\memo This object is used to describe zone air distribution in terms of air distribution
  \\memo effectiveness and secondary recirculation fraction. It is referenced by Sizing:Zone
  \\memo and Controller:MechanicalVentilation objects
   A1,  \\field Name
        \\required-field
        \\type alpha
        \\reference DesignSpecificationZoneAirDistributionNames
   N1,  \\field Zone Air Distribution Effectiveness in Cooling Mode
        \\type real
        \\default 1.0
        \\minimum> 0.0
        \\units dimensionless
   N2,  \\field Zone Air Distribution Effectiveness in Heating Mode
        \\type real
        \\default 1.0
        \\minimum> 0.0
        \\units dimensionless
   A2,  \\field Zone Air Distribution Effectiveness Schedule Name
        \\type object-list
        \\object-list ScheduleNames
        \\note optionally used to replace Zone Air Distribution Effectiveness in Cooling and
        \\note Heating Mode
   N3;  \\field Zone Secondary Recirculation Fraction
        \\type real
        \\default 0.0
        \\minimum 0.0
        \\units dimensionless

Sizing:Parameters,
  \\unique-object
      \\memo Specifies global heating and cooling sizing factors/ratios.
      \\memo These ratios are applied at the zone level to all of the zone heating and cooling loads
      \\memo and air flow rates. Then these new loads and air flow rates are used to calculate the
      \\memo system level flow rates and capacities and are used in all component sizing calculations.
      \\memo Specifies the width (in load timesteps) of a moving average window
      \\memo which is used to smooth the peak load across more than one timestep.
  \\min-fields 1
  N1, \\field Heating Sizing Factor
      \\type real
      \\minimum> 0.0
      \\default 1.0
  N2, \\field Cooling Sizing Factor
      \\type real
      \\minimum> 0.0
      \\default 1.0
  N3; \\field Timesteps in Averaging Window
      \\note blank => set the timesteps in averaging window to
      \\note Number of Timesteps per Hour resulting in a 1 hour averaging window
      \\note default is number of timesteps for 1 hour averaging window
      \\type integer
      \\minimum 1

Sizing:Zone,
      \\memo Specifies the data needed to perform a zone design air flow calculation.
      \\memo The calculation is done for every sizing period included in the input. The maximum
      \\memo cooling and heating load and cooling, heating, and ventilation air flows are then saved
      \\memo for system level and zone component design calculations.
  \\min-fields 18
  A1, \\field Zone or ZoneList Name
      \\required-field
      \\type object-list
      \\object-list ZoneAndZoneListNames
  A2, \\field Zone Cooling Design Supply Air Temperature Input Method
      \\required-field
      \\type choice
      \\key SupplyAirTemperature
      \\key TemperatureDifference
      \\default SupplyAirTemperature
  N1, \\field Zone Cooling Design Supply Air Temperature
      \\type real
      \\units C
      \\note Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
      \\note Supply Air Temperature Input Method = SupplyAirTemperature
  N2, \\field Zone Cooling Design Supply Air Temperature Difference
      \\type real
      \\units deltaC
      \\note Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
      \\note Supply Air Temperature Input Method = TemperatureDifference
      \\note The absolute value of this field will be subtracted from the zone temperature
      \\note at peak load to calculate the Zone Cooling Design Supply Air Temperature.
  A3, \\field Zone Heating Design Supply Air Temperature Input Method
      \\required-field
      \\type choice
      \\key SupplyAirTemperature
      \\key TemperatureDifference
      \\default SupplyAirTemperature
  N3, \\field Zone Heating Design Supply Air Temperature
      \\type real
      \\units C
      \\note Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
      \\note Supply Air Temperature Input Method = SupplyAirTemperature
  N4, \\field Zone Heating Design Supply Air Temperature Difference
      \\type real
      \\units deltaC
      \\note Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
      \\note Supply Air Temperature Input Method = TemperatureDifference
      \\note The absolute value of this field will be added to the zone temperature
      \\note at peak load to calculate the Zone Heating Design Supply Air Temperature.
  N5, \\field Zone Cooling Design Supply Air Humidity Ratio
      \\required-field
      \\minimum 0.0
      \\type real
      \\units kgWater/kgDryAir
  N6, \\field Zone Heating Design Supply Air Humidity Ratio
      \\required-field
      \\minimum 0.0
      \\type real
      \\units kgWater/kgDryAir
  A4, \\field Design Specification Outdoor Air Object Name
      \\type object-list
      \\object-list DesignSpecificationOutdoorAirNames
  N7, \\field Zone Heating Sizing Factor
      \\note if blank or zero, global heating sizing factor from Sizing:Parameters is used.
      \\minimum 0
  N8, \\field Zone Cooling Sizing Factor
      \\note if blank or zero, global cooling sizing factor from Sizing:Parameters is used.
      \\minimum 0
  A5, \\field Cooling Design Air Flow Method
      \\type choice
      \\key Flow/Zone
      \\key DesignDay
      \\key DesignDayWithLimit
      \\default DesignDay
  N9, \\field Cooling Design Air Flow Rate
      \\type real
      \\units m3/s
      \\minimum 0
      \\default 0
      \\note This input is used if Cooling Design Air Flow Method is Flow/Zone
      \\note This value will be multiplied by the global or zone sizing factor and
      \\note by zone multipliers.
  N10,\\field Cooling Minimum Air Flow per Zone Floor Area
      \\type real
      \\units m3/s-m2
      \\minimum 0
      \\default .000762
      \\note default is .15 cfm/ft2
      \\note This input is used if Cooling Design Air Flow Method is DesignDayWithLimit
  N11,\\field Cooling Minimum Air Flow
      \\type real
      \\units m3/s
      \\minimum 0
      \\default 0
      \\note This input is used if Cooling Design Air Flow Method is DesignDayWithLimit
  N12,\\field Cooling Minimum Air Flow Fraction
      \\note fraction of the Cooling design Air Flow Rate
      \\type real
      \\minimum 0
      \\default 0
      \\note This input is currently used in sizing the Fan minimum Flow Rate.
      \\note It does not currently affect other component autosizing.
  A6, \\field Heating Design Air Flow Method
      \\type choice
      \\key Flow/Zone
      \\key DesignDay
      \\key DesignDayWithLimit
      \\default DesignDay
  N13,\\field Heating Design Air Flow Rate
      \\type real
      \\units m3/s
      \\minimum 0
      \\default 0
      \\note This input is used if Heating Design Air Flow Method is Flow/Zone.
      \\note This value will be multiplied by the global or zone sizing factor and
      \\note by zone multipliers.
  N14,\\field Heating Maximum Air Flow per Zone Floor Area
      \\type real
      \\units m3/s-m2
      \\minimum 0
      \\default .002032
      \\note default is .40 cfm/ft2
      \\note This field is used to size the heating design flow rate when Heating Design Air Flow Method = Flow/Zone.
      \\note This input is used for autosizing components when Heating Design Air Flow Method = DesignDayWithLimit.
  N15,\\field Heating Maximum Air Flow
      \\type real
      \\units m3/s
      \\minimum 0
      \\default .1415762
      \\note default is 300 cfm
      \\note This input is used for autosizing components when Heating Design Air Flow Method = DesignDayWithLimit.
  N16,\\field Heating Maximum Air Flow Fraction
      \\note fraction of the Heating Design Air Flow Rate
      \\type real
      \\minimum 0
      \\default 0.3
      \\note This input is used for autosizing components when Heating Design Air Flow Method = DesignDayWithLimit.
  A7; \\field Design Specification Zone Air Distribution Object Name
      \\type object-list
      \\object-list DesignSpecificationZoneAirDistributionNames

Sizing:System,
      \\memo Specifies the input needed to perform sizing calculations for a central forced air
      \\memo system design air flow, heating capacity, and cooling capacity.
  \\min-fields 20
  A1, \\field AirLoop Name
      \\required-field
      \\type object-list
      \\object-list AirPrimaryLoops
  A2, \\field Type of Load to Size On
      \\note Specifies the basis for sizing the system supply air flow rate
      \\note Sensible and VentilationRequirement are the only available options
      \\note Sensible uses the zone design air flow rates
      \\note VentilationRequirement uses the system ventilation requirement
      \\required-field
      \\type choice
      \\key Sensible
      \\key VentilationRequirement
      !\\key Latent
      !\\key Total
      \\default Sensible
  N1, \\field Design Outdoor Air Flow Rate
      \\type real
      \\default autosize
      \\minimum 0.0
      \\units m3/s
      \\autosizable
  N2, \\field Minimum System Air Flow Ratio
      \\required-field
      \\type real
      \\minimum 0.0
      \\maximum 1.0
  N3, \\field Preheat Design Temperature
      \\required-field
      \\type real
      \\units C
  N4, \\field Preheat Design Humidity Ratio
      \\required-field
      \\type real
      \\units kgWater/kgDryAir
  N5, \\field Precool Design Temperature
      \\required-field
      \\type real
      \\units C
  N6, \\field Precool Design Humidity Ratio
      \\required-field
      \\type real
      \\units kgWater/kgDryAir
  N7, \\field Central Cooling Design Supply Air Temperature
      \\required-field
      \\type real
      \\units C
  N8, \\field Central Heating Design Supply Air Temperature
      \\required-field
      \\type real
      \\units C
  A3, \\field Sizing Option
      \\type choice
      \\key Coincident
      \\key NonCoincident
      \\default NonCoincident
  A4, \\field 100% Outdoor Air in Cooling
      \\type choice
      \\key Yes
      \\key No
      \\default No
  A5, \\field 100% Outdoor Air in Heating
      \\type choice
      \\key Yes
      \\key No
      \\default No
  N9, \\field Central Cooling Design Supply Air Humidity Ratio
      \\required-field
      \\type real
      \\default 0.008
      \\units kgWater/kgDryAir
  N10, \\field Central Heating Design Supply Air Humidity Ratio
      \\required-field
      \\type real
      \\default 0.008
      \\units kgWater/kgDryAir
  A6, \\field Cooling Design Air Flow Method
      \\type choice
      \\key Flow/System
      \\key DesignDay
      \\default DesignDay
  N11, \\field Cooling Design Air Flow Rate
      \\note This input is used if Cooling Design Air Flow Method is Flow/System
      \\note This value will *not* be multiplied by any sizing factor or by zone multipliers.
      \\note If using zone multipliers, this value must be large enough to serve the multiplied zones.
      \\type real
      \\units m3/s
      \\minimum 0
      \\default 0
  A7, \\field Heating Design Air Flow Method
      \\type choice
      \\key Flow/System
      \\key DesignDay
      \\default DesignDay
  N12,\\field Heating Design Air Flow Rate
      \\note This input is used if Heating Design Air Flow Method is Flow/System
      \\note This value will *not* be multiplied by any sizing factor or by zone multipliers.
      \\note If using zone multipliers, this value must be large enough to serve the multiplied zones.
      \\type real
      \\units m3/s
      \\minimum 0
      \\default 0
  A8, \\field System Outdoor Air Method
      \\type choice
      \\key ZoneSum
      \\key VentilationRateProcedure
      \\default ZoneSum
  N13;\\field Zone Maximum Outdoor Air Fraction
      \\type real
      \\default 1.0
      \\minimum> 0.0
      \\units dimensionless

Sizing:Plant,
      \\memo Specifies the input needed to autosize plant loop flow rates and equipment capacities.
      \\memo This information is initially used by components that use water for heating or cooling
      \\memo such as hot or chilled water coils to calculate their maximum water flow rates. These
      \\memo flow rates are then summed for use in calculating the Plant Loop flow rates.
  \\min-fields 4
  A1, \\field Plant or Condenser Loop Name
      \\note Enter the name of a PlantLoop or a CondenserLoop object
      \\required-field
      \\type object-list
      \\object-list PlantLoops
  A2, \\field Loop Type
      \\required-field
      \\type choice
      \\key Heating
      \\key Cooling
      \\key Condenser
      \\key Steam
  N1, \\field Design Loop Exit Temperature
      \\required-field
      \\type real
      \\units C
  N2; \\field Loop Design Temperature Difference
      \\required-field
      \\type real
      \\units deltaC
      \\minimum> 0.0

OutputControl:Sizing:Style,
       \\memo default style for the Sizing output files is comma -- this works well for
       \\memo importing into spreadsheet programs such as Excel(tm) but not so well for word
       \\memo processing progams -- there tab may be a better choice.  fixed puts spaces between
       \\memo the "columns"
       \\unique-object
   A1; \\field Column Separator
       \\required-field
       \\type choice
       \\key Comma
       \\key Tab
       \\key Fixed

\\Group Zone HVAC Controls and Thermostats

ZoneControl:Humidistat,
       \\memo Specifies zone relative humidity setpoint schedules for humidifying and dehumidifying.
  \\min-fields 3
  A1 , \\field Name
       \\required-field
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  A3 , \\field Humidifying Relative Humidity Setpoint Schedule Name
       \\required-field
       \\note hourly schedule values should be in Relative Humidity (percent)
       \\type object-list
       \\object-list ScheduleNames
  A4 ; \\field Dehumidifying Relative Humidity Setpoint Schedule Name
       \\note hourly schedule values should be in Relative Humidity (percent)
       \\type object-list
       \\object-list ScheduleNames

ZoneControl:Thermostat,
   \\memo Define the Thermostat settings for a zone or list of zones.
   \\memo If you use a ZoneList in the Zone or ZoneList name field then this definition applies
   \\memo to all the zones in the ZoneList.
  A1 , \\field Name
       \\required-field
       \\reference ZoneControlThermostaticNames
  A2 , \\field Zone or ZoneList Name
       \\required-field
       \\type object-list
       \\object-list ZoneAndZoneListNames
  A3 , \\field Control Type Schedule Name
       \\note This schedule contains appropriate control types for thermostat.
       \\note Control types are integers: 0 - Uncontrolled (floating, no thermostat), 1 = ThermostatSetpoint:SingleHeating,
       \\note 2 = ThermostatSetpoint:SingleCooling, 3 = ThermostatSetpoint:SingleHeatingOrCooling, 4 = ThermostatSetpoint:DualSetpoint
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
  A4 , \\field Control 1 Object Type
       \\required-field
       \\type choice
       \\key ThermostatSetpoint:SingleHeating
       \\key ThermostatSetpoint:SingleCooling
       \\key ThermostatSetpoint:SingleHeatingOrCooling
       \\key ThermostatSetpoint:DualSetpoint
  A5 , \\field Control 1 Name
       \\note Control names are names of individual control objects (e.g. ThermostatSetpoint:SingleHeating)
       \\note Schedule values in these objects list actual setpoint temperatures for the control types
       \\required-field
       \\type object-list
       \\object-list ControlTypeNames
  A6 , \\field Control 2 Object Type
       \\type choice
       \\key ThermostatSetpoint:SingleHeating
       \\key ThermostatSetpoint:SingleCooling
       \\key ThermostatSetpoint:SingleHeatingOrCooling
       \\key ThermostatSetpoint:DualSetpoint
  A7 , \\field Control 2 Name
       \\note Control names are names of individual control objects (e.g. ThermostatSetpoint:SingleHeating)
       \\note Schedule values in these objects list actual setpoint temperatures for the control types
       \\type object-list
       \\object-list ControlTypeNames
  A8 , \\field Control 3 Object Type
       \\type choice
       \\key ThermostatSetpoint:SingleHeating
       \\key ThermostatSetpoint:SingleCooling
       \\key ThermostatSetpoint:SingleHeatingOrCooling
       \\key ThermostatSetpoint:DualSetpoint
  A9 , \\field Control 3 Name
       \\note Control names are names of individual control objects (e.g. ThermostatSetpoint:SingleHeating)
       \\note Schedule values in these objects list actual setpoint temperatures for the control types
       \\type object-list
       \\object-list ControlTypeNames
  A10, \\field Control 4 Object Type
       \\type choice
       \\key ThermostatSetpoint:SingleHeating
       \\key ThermostatSetpoint:SingleCooling
       \\key ThermostatSetpoint:SingleHeatingOrCooling
       \\key ThermostatSetpoint:DualSetpoint
  A11; \\field Control 4 Name
       \\note Control names are names of individual control objects (e.g. ThermostatSetpoint:SingleHeating)
       \\note Schedule values in these objects list actual setpoint temperatures for the control types
       \\type object-list
       \\object-list ControlTypeNames

ZoneControl:Thermostat:OperativeTemperature,
       \\memo This object can be used with the ZoneList option on a thermostat or with one
       \\memo of the zones on that list (but you won't be able to use the object list to
       \\memo pick only one of those zones.  Thermostat names are <Zone Name> <global Thermostat name> internally.
  A1,  \\field Thermostat Name
       \\note Enter the name of a ZoneControl:Thermostat object.
       \\note This object modifies a ZoneControl:Thermostat object to add a
       \\note radiative fraction.
       \\required-field
       \\type object-list
       \\object-list ZoneControlThermostaticNames
  A2,  \\field Radiative Fraction Input Mode
       \\required-field
       \\type choice
       \\key Constant
       \\key Scheduled
  N1,  \\field Fixed Radiative Fraction
       \\minimum 0.0
       \\maximum< 0.9
  A3;  \\field Radiative Fraction Schedule Name
       \\note Schedule values of 0.0 indicate no operative temperature control
       \\type object-list
       \\object-list ScheduleNames

ZoneControl:Thermostat:ThermalComfort,
   \\memo If you use a ZoneList in the Zone or ZoneList name field then this definition applies
   \\memo to all the zones in the ZoneList.
       \\min-fields 9
  A1 , \\field Name
       \\required-field
       \\reference ZoneControlThermalComfortNames
  A2 , \\field Zone or ZoneList Name
       \\required-field
       \\type object-list
       \\object-list ZoneAndZoneListNames
  A3 , \\field Averaging Method
       \\note The method used to calculate thermal comfort dry-bulb temperature setpoint
       \\note for multiple people objects in a zone
       \\type choice
       \\key SpecificObject
       \\key ObjectAverage
       \\key PeopleAverage
       \\default PeopleAverage
  A4 , \\field Specific People Name
       \\note Used only when Averaging Method = SpecificObject in the previous field.
       \\type object-list
       \\object-list PeopleNames
  N1 , \\field Minimum Dry-Bulb Temperature Setpoint
       \\required-field
       \\type real
       \\units C
       \\minimum 0
       \\maximum 50
       \\default 0
  N2 , \\field Maximum Dry-Bulb Temperature Setpoint
       \\required-field
       \\type real
       \\units C
       \\minimum 0
       \\maximum 50
       \\default 50
  A5 , \\field Thermal Comfort Control Type Schedule Name
       \\note The Thermal Comfort Control Type Schedule contains values that are appropriate control types.
       \\note Thermal Comfort Control types are integers: 0 - Uncontrolled (floating),
       \\note 1 = ThermostatSetpoint:ThermalComfort:Fanger:SingleHeating
       \\note 2 = ThermostatSetpoint:ThermalComfort:Fanger:SingleCooling
       \\note 3 = ThermostatSetpoint:ThermalComfort:Fanger:SingleHeatingOrCooling
       \\note 4 = ThermostatSetpoint:ThermalComfort:Fanger:DualSetpoint
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
  A6 , \\field Thermal Comfort Control 1 Object Type
       \\required-field
       \\type choice
       \\key ThermostatSetpoint:ThermalComfort:Fanger:SingleHeating
       \\key ThermostatSetpoint:ThermalComfort:Fanger:SingleCooling
       \\key ThermostatSetpoint:ThermalComfort:Fanger:SingleHeatingOrCooling
       \\key ThermostatSetpoint:ThermalComfort:Fanger:DualSetpoint
  A7 , \\field Thermal Comfort Control 1 Name
       \\note Control type names are names for individual control type objects.
       \\note Schedule values in these objects list actual setpoint temperatures for the control types
       \\required-field
       \\type object-list
       \\object-list ThermalComfortControlTypeNames
  A8 , \\field Thermal Comfort Control 2 Object Type
       \\type choice
       \\key ThermostatSetpoint:ThermalComfort:Fanger:SingleHeating
       \\key ThermostatSetpoint:ThermalComfort:Fanger:SingleCooling
       \\key ThermostatSetpoint:ThermalComfort:Fanger:SingleHeatingOrCooling
       \\key ThermostatSetpoint:ThermalComfort:Fanger:DualSetpoint
  A9 , \\field Thermal Comfort Control 2 Name
       \\note Control Type names are names for individual control type objects.
       \\note Schedule values in these objects list actual setpoint temperatures for the control types
       \\type object-list
       \\object-list ThermalComfortControlTypeNames
  A10, \\field Thermal Comfort Control 3 Object Type
       \\type choice
       \\key ThermostatSetpoint:ThermalComfort:Fanger:SingleHeating
       \\key ThermostatSetpoint:ThermalComfort:Fanger:SingleCooling
       \\key ThermostatSetpoint:ThermalComfort:Fanger:SingleHeatingOrCooling
       \\key ThermostatSetpoint:ThermalComfort:Fanger:DualSetpoint
  A11, \\field Thermal Comfort Control 3 Name
       \\note Control type names are names for individual control type objects.
       \\note Schedule values in these objects list actual setpoint temperatures for the control types
       \\type object-list
       \\object-list ThermalComfortControlTypeNames
  A12, \\field Thermal Comfort Control 4 Object Type
       \\type choice
       \\key ThermostatSetpoint:ThermalComfort:Fanger:SingleHeating
       \\key ThermostatSetpoint:ThermalComfort:Fanger:SingleCooling
       \\key ThermostatSetpoint:ThermalComfort:Fanger:SingleHeatingOrCooling
       \\key ThermostatSetpoint:ThermalComfort:Fanger:DualSetpoint
  A13; \\field Thermal Comfort Control 4 Name
       \\note Control type names are names for individual control type objects.
       \\note Schedule values in these objects list actual setpoint temperatures for the control types
       \\type object-list
       \\object-list ThermalComfortControlTypeNames

ZoneControl:Thermostat:TemperatureAndHumidity,
       \\min-fields 2
       \\memo This object modifies a ZoneControl:Thermostat object to effect temperature control based on
       \\memo zone air humidity conditions.
  A1,  \\field Thermostat Name
       \\required-field
       \\type object-list
       \\object-list ZoneControlThermostaticNames
       \\note Enter the name of a ZoneControl:Thermostat object whose operation is to be modified to
       \\note effect temperature control based on zone air humidity conditions. If the ZoneControl:
       \\note Thermostat object references a ZoneList, simply enter the name of the ZoneControl:Thermostat
       \\note object and this temperature and humidity thermostat control will be applied to all zones
       \\note in the ZoneList. If the ZoneControl:Thermostat object references a ZoneList but it is
       \\note desired that only a single zone within the ZoneList be controlled based on temperature and
       \\note humidity control, then the name to be put here is <Zone Name> <Thermostat Name> where the
       \\note Thermostat Name is the the name of the ZoneControl:Thermostat object.
  A2 , \\field Dehumidifying Relative Humidity Setpoint Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note Schedule values should be in Relative Humidity (percent)
  A3,  \\field Dehumidification Control Type
       \\type choice
       \\key Overcool
       \\key None
       \\default Overcool
  A4,  \\field Overcool Range Input Method
       \\type choice
       \\key Constant
       \\key Scheduled
       \\default Constant
  N1,  \\field Overcool Constant Range
       \\type real
       \\units deltaC
       \\minimum 0.0
       \\maximum 3.0
       \\default 1.7
       \\note Maximum Overcool temperature range for cooling setpoint reduction.
       \\note Used with Dehumidification Control Type = Overcool.
       \\note A value of 0.0 indicates no zone temperature overcooling will be provided to
       \\note gain additional dehumidification.
  A5,  \\field Overcool Range Schedule Name
       \\note Schedule values of 0.0 indicates no zone temperature overcooling will be
       \\note provided to gain additional dehumidification.
       \\note Schedule values should be >= 0 and <= 3 (deltaC).
       \\type object-list
       \\object-list ScheduleNames
  N2;  \\field Overcool Control Ratio
       \\type real
       \\units percent/K
       \\minimum 0.0
       \\default 3.6
       \\note The value of this input field is used to adjust the cooling setpoint temperature
       \\note (established by the associated ZoneControl:Thermostat object) downward based on the
       \\note difference between the zone air relative humidity level and the dehumidifying
       \\note relative humidity setpoint.

ThermostatSetpoint:SingleHeating,
       \\memo Used for a heating only thermostat. The setpoint can be scheduled and varied throughout
       \\memo the simulation but only heating is allowed with this control type.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ControlTypeNames
  A2 ; \\field Setpoint Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames

ThermostatSetpoint:SingleCooling,
       \\memo Used for a cooling only thermostat. The setpoint can be scheduled and varied throughout
       \\memo the simulation but only cooling is allowed.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ControlTypeNames
  A2 ; \\field Setpoint Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames

ThermostatSetpoint:SingleHeatingOrCooling,
       \\memo Used for a heating and cooling thermostat with a single setpoint. The setpoint can be
       \\memo scheduled and varied throughout the simulation for both heating and cooling.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ControlTypeNames
  A2 ; \\field Setpoint Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames

ThermostatSetpoint:DualSetpoint,
       \\memo Used for a heating and cooling thermostat with dual setpoints. The setpoints can be
       \\memo scheduled and varied throughout the simulation for both heating and cooling.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ControlTypeNames
  A2 , \\field Heating Setpoint Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
  A3 ; \\field Cooling Setpoint Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames

ThermostatSetpoint:ThermalComfort:Fanger:SingleHeating,
       \\memo Used for heating only thermal comfort control. The PMV setpoint can be scheduled and
       \\memo varied throughout the simulation but only heating is allowed with this control type.
       \\min-fields 2
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ThermalComfortControlTypeNames
  A2 ; \\field Fanger Thermal Comfort Schedule Name
       \\note Schedule values should be Predicted Mean Vote (PMV)
       \\required-field
       \\type object-list
       \\object-list ScheduleNames

ThermostatSetpoint:ThermalComfort:Fanger:SingleCooling,
       \\memo Used for cooling only thermal comfort control. The PMV setpoint can be scheduled and
       \\memo varied throughout the simulation but only cooling is allowed with this control type.
       \\min-fields 2
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ThermalComfortControlTypeNames
  A2 ; \\field Fanger Thermal Comfort Schedule Name
       \\note Schedule values should be Predicted Mean Vote (PMV)
       \\required-field
       \\type object-list
       \\object-list ScheduleNames

ThermostatSetpoint:ThermalComfort:Fanger:SingleHeatingOrCooling,
       \\memo Used for heating and cooling thermal comfort control with a single setpoint. The PMV
       \\memo setpoint can be scheduled and varied throughout the simulation for both heating and
       \\memo cooling.
       \\min-fields 2
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ThermalComfortControlTypeNames
  A2 ; \\field Fanger Thermal Comfort Schedule Name
       \\note Schedule values should be Predicted Mean Vote (PMV)
       \\required-field
       \\type object-list
       \\object-list ScheduleNames

ThermostatSetpoint:ThermalComfort:Fanger:DualSetpoint,
       \\memo Used for heating and cooling thermal comfort control with dual setpoints. The PMV
       \\memo setpoints can be scheduled and varied throughout the simulation for both heating and
       \\memo cooling.
       \\min-fields 3
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ThermalComfortControlTypeNames
  A2 , \\field Fanger Thermal Comfort Heating Schedule Name
       \\note Schedule values should be Predicted Mean Vote (PMV)
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
  A3 ; \\field Fanger Thermal Comfort Cooling Schedule Name
       \\note Schedule values should be Predicted Mean Vote (PMV)
       \\required-field
       \\type object-list
       \\object-list ScheduleNames

ZoneControl:ContaminantController,
       \\memo Used to control a zone to a specified indoor level of CO2 or generic contaminants, or
       \\memo to specify minimum CO2 concentration schedule name for a zone.
       \\min-fields 4
  A1 , \\field Name
       \\required-field
  A2 , \\field Controlled Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  A3 , \\field Carbon Dioxide Control Availability Schedule Name
       \\note Availability schedule name for CO2 controller. Schedule value > 0 means the CO2
       \\note controller is enabled. If this field is blank, then CO2  controller is always enabled.
       \\type object-list
       \\object-list ScheduleNames
  A4 , \\field Carbon Dioxide Setpoint Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note Schedule values should be carbon dioxide concentration in parts per million (ppm)
  A5 , \\field Minimum Carbon Dioxide Concentration Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note Schedule values should be carbon dioxide concentration in parts per
       \\note million (ppm)
       \\note This field is used when the field System Outdoor Air Method =
       \\note ProportionalControl in Controller:MechanicalVentilation
  A6 , \\field Generic Contaminant Control Availability Schedule Name
       \\note Availability schedule name for generic contaminant controller. Schedule value > 0 means
       \\note the generic contaminant controller is enabled. If this field is blank, then generic
       \\note contaminant controller is always enabled.
       \\type object-list
       \\object-list ScheduleNames
  A7 ; \\field Generic Contaminant Setpoint Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note Schedule values should be generic contaminant concentration in parts per
       \\note million (ppm)
       \\note This field is used when the field System Outdoor Air Method =
       \\note IndoorAirQualityProcedureGenericContaminant in Controller:MechanicalVentilation

\\group Zone HVAC Forced Air Units

ZoneHVAC:IdealLoadsAirSystem,
       \\memo Ideal system used to calculate loads without modeling a full HVAC system. All that is
       \\memo required for the ideal system are zone controls, zone equipment configurations, and
       \\memo the ideal loads system component. This component can be thought of as an ideal unit
       \\memo that mixes zone air with the specified amount of outdoor air and then adds or removes
       \\memo heat and moisture at 100% efficiency in order to meet the specified controls. Energy
       \\memo use is reported as DistrictHeating and DistrictCooling.
       \\min-fields 26
  A1 , \\field Name
       \\required-field
  A2 , \\field Availability Schedule Name
       \\note Availability schedule name for this system. Schedule value > 0 means the system is available.
       \\note If this field is blank, the system is always available.
       \\type object-list
       \\object-list ScheduleNames
  A3 , \\field Zone Supply Air Node Name
       \\note Must match a zone air inlet node name.
       \\required-field
       \\type node
  A4 , \\field Zone Exhaust Air Node Name
       \\note Should match a zone air exhaust node name.
       \\note This field is optional, but is required if this
       \\note this object is used with other forced air equipment.
       \\type node
  N1 , \\field Maximum Heating Supply Air Temperature
       \\units C
       \\minimum> 0
       \\maximum< 100
       \\default 50
  N2 , \\field Minimum Cooling Supply Air Temperature
       \\units C
       \\minimum> -100
       \\maximum< 50
       \\default 13
  N3 , \\field Maximum Heating Supply Air Humidity Ratio
       \\units kgWater/kgDryAir
       \\minimum> 0
       \\default 0.0156
  N4 , \\field Minimum Cooling Supply Air Humidity Ratio
       \\units kgWater/kgDryAir
       \\minimum> 0
       \\default 0.0077
  A5 , \\field Heating Limit
       \\type choice
       \\key NoLimit
       \\key LimitFlowRate
       \\key LimitCapacity
       \\key LimitFlowRateAndCapacity
       \\default NoLimit
  N5 , \\field Maximum Heating Air Flow Rate
       \\note This field is ignored if Heating Limit = NoLimit
       \\note If this field is blank, there is no limit.
       \\units m3/s
       \\minimum 0.0
       \\autosizable
  N6 , \\field Maximum Sensible Heating Capacity
       \\note This field is ignored if Heating Limit = NoLimit
       \\note If this field is blank, there is no limit.
       \\units W
       \\minimum 0.0
       \\autosizable
  A6 , \\field Cooling Limit
       \\type choice
       \\key NoLimit
       \\key LimitFlowRate
       \\key LimitCapacity
       \\key LimitFlowRateAndCapacity
       \\default NoLimit
  N7 , \\field Maximum Cooling Air Flow Rate
       \\note This field is ignored if Cooling Limit = NoLimit
       \\note This field is required if Outdoor Air Control Type
       \\note is TemperatureEconomizer or EnthalpyEconomizer
       \\units m3/s
       \\minimum 0.0
       \\autosizable
  N8 , \\field Maximum Total Cooling Capacity
       \\note This field is ignored if Cooling Limit = NoLimit
       \\units W
       \\minimum 0.0
       \\autosizable
  A7 , \\field Heating Availability Schedule Name
       \\note If blank, heating is always available.
       \\type object-list
       \\object-list ScheduleNames
  A8 , \\field Cooling Availability Schedule Name
       \\note If blank, cooling is always available.
       \\type object-list
       \\object-list ScheduleNames
  A9 , \\field Dehumidification Control Type
       \\note ConstantSensibleHeatRatio means that the ideal loads system
       \\note will be controlled to meet the sensible cooling load, and the
       \\note latent cooling rate will be computed using a constant
       \\note sensible heat ratio (SHR)
       \\note Humidistat means that there is a ZoneControl:Humidistat for this
       \\note zone and the ideal loads system will attempt to satisfy the humidistat.
       \\note None means that there is no dehumidification.
       \\note ConstantSupplyHumidityRatio means that during cooling the supply air
       \\note will always be at the Minimum Cooling Supply Humidity Ratio.
       \\type choice
       \\key ConstantSensibleHeatRatio
       \\key Humidistat
       \\key None
       \\key ConstantSupplyHumidityRatio
       \\default ConstantSensibleHeatRatio
  N9 , \\field Cooling Sensible Heat Ratio
       \\note This field is applicable only when Dehumidification Control Type is ConstantSensibleHeatRatio
       \\units dimensionless
       \\minimum> 0.0
       \\maximum 1.0
       \\default 0.7
  A10, \\field Humidification Control Type
       \\note None means that there is no humidification.
       \\note Humidistat means that there is a ZoneControl:Humidistat for this
       \\note zone and the ideal loads system will attempt to satisfy the humidistat.
       \\note ConstantSupplyHumidityRatio means that during heating the supply air
       \\note will always be at the Maximum Heating Supply Humidity Ratio.
       \\type choice
       \\key None
       \\key Humidistat
       \\key ConstantSupplyHumidityRatio
       \\default None
  A11, \\field Design Specification Outdoor Air Object Name
       \\type object-list
       \\object-list DesignSpecificationOutdoorAirNames
       \\note When the name of a DesignSpecification:OutdoorAir object is entered, the minimum
       \\note outdoor air flow rate will be computed using these specifications. The outdoor air
       \\note flow rate will also be affected by the next two fields.
       \\note If this field is blank, there will be no outdoor air and the remaining fields will
       \\note be ignored.
  A12, \\field Outdoor Air Inlet Node Name
       \\type node
       \\note This field is required if the system provides outdoor air
       \\note Enter the name of an outdoor air node. This node name is also specified in
       \\note an OutdoorAir:Node or OutdoorAir:NodeList object.
  A13, \\field Demand Controlled Ventilation Type
       \\note This field controls how the minimum outdoor air flow rate is calculated.
       \\note None means that design occupancy will be uased to compute the minimum outdoor air flow rate
       \\note OccupancySchedule means that current occupancy level will be used.
       \\note CO2Setpoint means that the design occupancy will be used to compute the minimum outdoor air flow
       \\note reate and the outdoor air flow rate may be increased if necessary to maintain the indoor air carbon
       \\note dioxide setpoint defined in a ZoneControl:ContaminantController object.
       \\type choice
       \\key None
       \\key OccupancySchedule
       \\key CO2Setpoint
       \\default None
  A14, \\field Outdoor Air Economizer Type
       \\note DifferentialDryBulb and DifferentialEnthalpy will increase the outdoor air flow rate
       \\note when there is a cooling load and the outdoor air temperature or enthalpy
       \\note is below the zone exhaust air temperature or enthalpy.
       \\type choice
       \\key NoEconomizer
       \\key DifferentialDryBulb
       \\key DifferentialEnthalpy
       \\default NoEconomizer
  A15, \\field Heat Recovery Type
       \\type choice
       \\key None
       \\key Sensible
       \\key Enthalpy
       \\default None
  N10, \\field Sensible Heat Recovery Effectiveness
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.70
  N11; \\field Latent Heat Recovery Effectiveness
       \\note Applicable only if Heat Recovery Type is Enthalpy.
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.65

ZoneHVAC:FourPipeFanCoil,
        \\memo Four pipe fan coil system. Forced-convection hydronic heating-cooling unit with
        \\memo supply fan, hot water heating coil, chilled water cooling coil, and fixed-position
        \\memo outdoor air mixer.
        \\min-fields 24
   A1 , \\field Name
        \\required-field
   A2 , \\field Availability Schedule Name
        \\note Availability schedule name for this system. Schedule value > 0 means the system is available.
        \\note If this field is blank, the system is always available.
        \\type object-list
        \\object-list ScheduleNames
   A3 , \\field Capacity Control Method
        \\required-field
        \\type choice
        \\key ConstantFanVariableFlow
        \\key CyclingFan
        \\key VariableFanVariableFlow
        \\key VariableFanConstantFlow
   N1 , \\field Maximum Supply Air Flow Rate
        \\required-field
        \\autosizable
        \\units m3/s
   N2 , \\field Low Speed Supply Air Flow Ratio
        \\type real
        \\minimum> 0.0
        \\default 0.33
   N3 , \\field Medium Speed Supply Air Flow Ratio
        \\note Medium Speed Supply Air Flow Ratio should be greater
        \\note than Low Speed Supply Air Flow Ratio
        \\type real
        \\minimum> 0.0
        \\default 0.66
   N4 , \\field Maximum Outdoor Air Flow Rate
        \\required-field
        \\autosizable
        \\units m3/s
   A4 , \\field Outdoor Air Schedule Name
        \\note Value of schedule multiplies maximum outdoor air flow rate
        \\type object-list
        \\object-list ScheduleNames
   A5 , \\field Air Inlet Node Name
        \\required-field
        \\type node
   A6 , \\field Air Outlet Node Name
        \\required-field
        \\type node
   A7,  \\field Outdoor Air Mixer Object Type
        \\required-field
        \\type choice
        \\key OutdoorAir:Mixer
        \\note currently only one type OutdoorAir:Mixer object is available.
   A8 , \\field Outdoor Air Mixer Name
        \\required-field
        \\type object-list
        \\object-list OutdoorAirMixers
   A9 , \\field Supply Air Fan Object Type
        \\required-field
        \\type choice
        \\key Fan:OnOff
        \\key Fan:ConstantVolume
        \\key Fan:VariableVolume
        \\note Fan type must be according to capacity control method (see I/O)
        \\note Fan:ConstantVolume only works when continuous fan operation is used the entire
        \\note simulation (all supply air fan operating mode schedule values are greater than 0).
        \\note If any fan operating mode schedule values are 0 a Fan:OnOff object must be used.
        \\note For ConstantFanVariableFlow a Fan:OnOff or Fan:ConstantVolume is valid.
        \\note For CyclingFan, a Fan:OnOff is valid.
        \\note For VariableFanVariableFlow or VariableFanConstantFlow a Fan:VariableVolume is valid.
        \\note The fan's inlet node should be the same as the outdoor air mixer's mixed air node.
   A10, \\field Supply Air Fan Name
        \\required-field
        \\type object-list
        \\object-list FansCVandOnOffandVAV
   A11, \\field Cooling Coil Object Type
        \\required-field
        \\type choice
        \\key Coil:Cooling:Water
        \\key Coil:Cooling:Water:DetailedGeometry
        \\key CoilSystem:Cooling:Water:HeatExchangerAssisted
   A12, \\field Cooling Coil Name
        \\required-field
        \\type object-list
        \\object-list CoolingCoilsWater
   N5 , \\field Maximum Cold Water Flow Rate
        \\required-field
        \\autosizable
        \\units m3/s
        \\ip-units gal/min
   N6 , \\field Minimum Cold Water Flow Rate
        \\default 0.0
        \\units m3/s
        \\ip-units gal/min
   N7 , \\field Cooling Convergence Tolerance
        \\type real
        \\minimum> 0.0
        \\default 0.001
   A13, \\field Heating Coil Object Type
        \\required-field
        \\type choice
        \\key Coil:Heating:Water
   A14, \\field Heating Coil Name
        \\required-field
        \\type object-list
        \\object-list HeatingCoilsWater
   N8 , \\field Maximum Hot Water Flow Rate
        \\required-field
        \\autosizable
        \\units m3/s
        \\ip-units gal/min
   N9 , \\field Minimum Hot Water Flow Rate
        \\default 0.0
        \\units m3/s
        \\ip-units gal/min
   N10, \\field Heating Convergence Tolerance
        \\type real
        \\minimum> 0.0
        \\default 0.001
   A15; \\field Availability Manager List Name
        \\note Enter the name of an AvailabilityManagerAssignmentList object.
        \\type object-list
        \\object-list SystemAvailabilityManagerLists

ZoneHVAC:WindowAirConditioner,
        \\memo Window air conditioner. Forced-convection cooling-only unit with supply fan, direct
        \\memo expansion (DX) cooling coil, and fixed-position outdoor air mixer.
        \\min-fields 15
   A1,  \\field Name
        \\required-field
        \\type alpha
   A2 , \\field Availability Schedule Name
        \\note Availability schedule name for this system. Schedule value > 0 means the system is available.
        \\note If this field is blank, the system is always available.
        \\type object-list
        \\object-list ScheduleNames
   N1 , \\field Maximum Supply Air Flow Rate
        \\required-field
        \\type real
        \\units m3/s
        \\autosizable
   N2 , \\field Maximum Outdoor Air Flow Rate
        \\required-field
        \\type real
        \\units m3/s
        \\autosizable
   A3 , \\field Air Inlet Node Name
        \\required-field
        \\type node
   A4 , \\field Air Outlet Node Name
        \\required-field
        \\type node
   A5,  \\field Outdoor Air Mixer Object Type
        \\required-field
        \\type choice
        \\key OutdoorAir:Mixer
        \\note currently only one OutdoorAir:Mixer object type is available.
   A6 , \\field Outdoor Air Mixer Name
        \\required-field
        \\type object-list
        \\object-list OutdoorAirMixers
   A7 , \\field Supply Air Fan Object Type
        \\required-field
        \\type choice
        \\key Fan:OnOff
        \\key Fan:ConstantVolume
        \\note Fan:ConstantVolume only works when continuous fan operation is used the entire
        \\note simulation (all supply air fan operating mode schedule values are greater than 0).
        \\note If any fan operating mode schedule values are 0 a Fan:OnOff object must be used.
   A8 , \\field Supply Air Fan Name
        \\required-field
        \\note Fan type Fan:ConstantVolume is used with continuous fan
        \\note and fan type Fan:OnOff is used with cycling Fan.
        \\type object-list
        \\object-list FansCVandOnOff
   A9,  \\field Cooling Coil Object Type
        \\required-field
        \\type choice
        \\key Coil:Cooling:DX:SingleSpeed
        \\key CoilSystem:Cooling:DX:HeatExchangerAssisted
   A10, \\field DX Cooling Coil Name
        \\required-field
        \\type object-list
        \\object-list CoolingCoilsDXSingleSpeed
   A11, \\field Supply Air Fan Operating Mode Schedule Name
        \\type object-list
        \\object-list ScheduleNames
        \\note Enter the name of a schedule that controls fan operation. Schedule Name values of 0 denote
        \\note cycling fan operation (fan cycles with cooling coil). Schedule values greater
        \\note than 0 denote constant fan operation (fan runs continually regardless of coil operation).
        \\note The fan operating mode defaults to cycling fan operation if this field is left blank.
   A12, \\field Fan Placement
        \\required-field
        \\type choice
        \\key BlowThrough
        \\key DrawThrough
   N3 , \\field Cooling Convergence Tolerance
        \\type real
        \\minimum> 0.0
        \\default 0.001
   A13; \\field Availability Manager List Name
        \\note Enter the name of an AvailabilityManagerAssignmentList object.
        \\type object-list
        \\object-list SystemAvailabilityManagerLists

ZoneHVAC:PackagedTerminalAirConditioner,
        \\memo Packaged terminal air conditioner (PTAC).  Forced-convection heating-cooling unit
        \\memo with supply fan, direct expansion (DX) cooling coil, heating coil (gas, electric, hot
        \\memo water, or steam) and fixed-position outdoor air mixer.
        \\min-fields 18
   A1,  \\field Name
        \\required-field
        \\type alpha
        \\note Unique name for this packaged terminal air conditioner object.
   A2,  \\field Availability Schedule Name
        \\required-field
        \\type object-list
        \\object-list ScheduleNames
        \\note Schedule values of 0 denote the unit is off.
   A3 , \\field Air Inlet Node Name
        \\required-field
        \\type node
        \\note Air inlet node for the PTAC must be a zone air exhaust Node.
   A4 , \\field Air Outlet Node Name
        \\required-field
        \\type node
        \\note Air outlet node for the PTAC must be a zone air inlet node.
   A5,  \\field Outdoor Air Mixer Object Type
        \\required-field
        \\type choice
        \\key OutdoorAir:Mixer
        \\note currently only one OutdoorAir:Mixer object type is available.
   A6 , \\field Outdoor Air Mixer Name
        \\required-field
        \\type object-list
        \\object-list OutdoorAirMixers
        \\note Needs to match the name of the PTAC outdoor air mixer object.
   N1 , \\field Supply Air Flow Rate During Cooling Operation
        \\required-field
        \\type real
        \\units m3/s
        \\minimum> 0.0
        \\autosizable
        \\note Must be less than or equal to fan size.
   N2 , \\field Supply Air Flow Rate During Heating Operation
        \\required-field
        \\type real
        \\units m3/s
        \\minimum> 0.0
        \\autosizable
        \\note Must be less than or equal to fan size.
   N3 , \\field Supply Air Flow Rate When No Cooling or Heating is Needed
        \\type real
        \\units m3/s
        \\minimum 0
        \\autosizable
        \\note Must be less than or equal to fan size.
        \\note Only used when supply air fan operating mode schedule values specify continuous fan
        \\note (schedule values greater than 0 specify continuous fan operation).
        \\note This air flow rate is used when no heating or cooling is required and the cooling or
        \\note heating coil is off. If this field is left blank or zero, the supply air flow rate
        \\note from the previous on cycle (either cooling or heating) is used.
   N4 , \\field Outdoor Air Flow Rate During Cooling Operation
        \\required-field
        \\type real
        \\units m3/s
        \\minimum 0
        \\autosizable
        \\note Must be less than or equal to supply air flow rate during cooling operation.
   N5 , \\field Outdoor Air Flow Rate During Heating Operation
        \\required-field
        \\type real
        \\units m3/s
        \\minimum 0
        \\autosizable
        \\note Must be less than or equal to supply air flow rate during heating operation.
   N6 , \\field Outdoor Air Flow Rate When No Cooling or Heating is Needed
        \\type real
        \\units m3/s
        \\minimum 0
        \\autosizable
        \\note Only used when supply air fan operating mode schedule values specify continuous fan
        \\note (schedule values greater than 0 specify continuous fan operation).
        \\note This air flow rate is used when no heating or cooling is required and the cooling or
        \\note heating coil is off. If this field is left blank or zero, the outdoor air flow rate
        \\note from the previous on cycle (either cooling or heating) is used.
   A7 , \\field Supply Air Fan Object Type
        \\required-field
        \\type choice
        \\key Fan:OnOff
        \\key Fan:ConstantVolume
        \\note Fan:ConstantVolume only works when continuous fan operation is used the entire
        \\note simulation (all supply air fan operating mode schedule values are greater than 0).
        \\note If any fan operating mode schedule values are 0 a Fan:OnOff object must be used.
   A8 , \\field Supply Air Fan Name
        \\required-field
        \\type object-list
        \\object-list FansCVandOnOff
        \\note Needs to match in the fan object.
   A9 , \\field Heating Coil Object Type
        \\required-field
        \\type choice
        \\key Coil:Heating:Gas
        \\key Coil:Heating:Electric
        \\key Coil:Heating:Water
        \\key Coil:Heating:Steam
        \\note Select the type of heating coil.
   A10 , \\field Heating Coil Name
        \\required-field
        \\type object-list
        \\object-list HeatingCoilName
        \\note Needs to match in the heating coil object.
   A11, \\field Cooling Coil Object Type
        \\required-field
        \\type choice
        \\key Coil:Cooling:DX:SingleSpeed
        \\key Coil:Cooling:DX:VariableSpeed
        \\key CoilSystem:Cooling:DX:HeatExchangerAssisted
        \\note Select the type of Cooling Coil.
        \\note Onl