"""
Created on Dec 22, 2015

@author: albert
"""

from afcsimplifier.geotool import same_segment, same_point

# endpoint = (x, y, segment_id)
# intersection = (p)
# scanlineintersection = (segment, p)
# segmentintersection = (p, segment1, segment2)


# Event types
SEGMENT_START = 0
SEGMENT_END = 1
SEGMENT_INTERSECTION = 2


class Event(object):
    def __init__(self, intersection, event_type):
        """ Event instance for the sweep line algorithm
        :param intersection: ???? instance TODO: what
        :param event_type: SEGMENT_START, SEGMENT_END or SEGMENT_INTERSECTION
        """
        self.intersection = intersection
        self.event_type = event_type

    def __eq__(self, event):
        if not isinstance(event, Event):
            return super(Event, self).__eq__(event)

        if self.event_type == event.event_type:
            i2 = event.intersection
            if isinstance(self.intersection, ScanlineIntersection) and isinstance(i2, ScanlineIntersection):
                return self.equals_scanline_intersection(event)
            elif isinstance(self.intersection, SegmentsIntersection) and isinstance(i2, SegmentsIntersection):
                return self.equals_segment_intersection(event)
        return False

    def equals_scanline_intersection(self, event):
        s1 = self.intersection.segment
        p1 = self.intersection.point
        s2 = event.intersection.segment
        p2 = event.intersection.point

        if same_segment(s1, s2) and same_point(p1, p2):
            return True
        return False

    def equals_segment_intersection(self, event):
        sa1 = self.intersection.segment1
        sa2 = self.intersection.segment2
        sb1 = event.intersection.segment1
        sb2 = event.intersection.segment2
        p1 = self.intersection.point
        p2 = event.intersection.point

        if (same_segment(sa1, sb1) and same_segment(sa2, sb2)) or (same_segment(sa1, sb2) and same_segment(sa2, sb1)):
            if same_point(p1, p2):
                return True
        return False


class ScanlineIntersection(object):
    pass


class SegmentsIntersection(object):
    pass
