import psycopg2

TABLE = "debug_simplipy"
_db = None
_cursor = None
def connect():
    global _db, _cursor
    if _db is None:
        _db = psycopg2.connect("dbname=gisdb host=localhost user=postgres password=postgres port=5432")
        _cursor = _db.cursor() 

def commit():
    if _db:
        _db.commit()

def clear():
    connect()
    _cursor.execute("truncate "+TABLE)
    _cursor.execute("select setval('debug_simplipy_pkid_seq', 1, true)")
    commit()

def add_geom(comment, geom_str, iteration=0, key=None):
    connect()
    _cursor.execute("insert into "+TABLE+" (text, the_geom, debug_key, iteration) values (%s, ST_SetSRID("+geom_str+",4326), %s, %s) returning pkid", (comment, key, iteration))
    pkid = _cursor.fetchone()[0]
    return pkid

def add_line(comment, pa, pb, **kwargs):
    geom_str = "ST_MakeLine(ST_Point(%.16f,%.16f), ST_Point(%.16f,%.16f))" % (pa[0], pa[1], pb[0], pb[1])
    return add_geom(comment, geom_str, **kwargs)

def add_chain(comment, points, **kwargs):
    points = ["%.16f %.16f" % (p[0],p[1]) for p in points]
    geom_str = "ST_GeomFromText('SRID=4326;LINESTRING(" + ','.join(points)+")')"
    return add_geom(comment, geom_str, **kwargs)

def add_point(comment, p, **kwargs):
    geom_str = "ST_Point(%.16f,%.16f)" % (p[0], p[1])
    return add_geom(comment, geom_str, **kwargs)
