##Siligites script=group
##movecomp=name

# Module input
##SCR=crs
##MNT=raster
##NULL_dans_MNT=selection FALSE;TRUE ;
##Origine=vector point
##Destination=vector point
##Retour_Base=selection TRUE;FALSE ;
##Choix1=selection Tobler (h & min);Tobler hors chemin (h & min);Tobler modifiée par Marquez-Perez et al (h & min);Irmischer-Clarke (homme, sur un sentier) (h & min);Irmischer-Clarke (homme, hors sentier) (h & min);Irmischer-Clarke (femme, sur un chemin) (h & min);Irmischer-Clarke (femme, hors sentier) (h & min);Uriarte Gonzalez (h & min);Marin Arroyo (h & min);Alberti modifiée pour les excursions pastorales de recherche de nourriture (h & min);Garmy, Kaddouri, Rozenblat et Schneider (h & min);Rees (h & min);Kondo-Seino (h & min);Tripcevich (h & min);Véhicules à roues (h & min);Dépense énergétique (None);Bellavia (None);Eastman (None);Pandolf et al (Watt);Pandolf et al avec correction de decente de pente (Watt);Minetti et al (J/(kg*m));Herzog (J/(kg*m));Van Leusen (Watt);Llobera-Sluckin (kJ/m);Ardigo et al (J/(kg*m));Hare (cal/km) ;
##Choix2=selection Tobler (h & min);Tobler hors chemin (h & min);Tobler modifiée par Marquez-Perez et al (h & min);Irmischer-Clarke (homme, sur un sentier) (h & min);Irmischer-Clarke (homme, hors sentier) (h & min);Irmischer-Clarke (femme, sur un chemin) (h & min);Irmischer-Clarke (femme, hors sentier) (h & min);Uriarte Gonzalez (h & min);Marin Arroyo (h & min);Alberti modifiée pour les excursions pastorales de recherche de nourriture (h & min);Garmy, Kaddouri, Rozenblat et Schneider (h & min);Rees (h & min);Kondo-Seino (h & min);Tripcevich (h & min);Véhicules à roues (h & min);Dépense énergétique (None);Bellavia (None);Eastman (None);Pandolf et al (Watt);Pandolf et al avec correction de decente de pente (Watt);Minetti et al (J/(kg*m));Herzog (J/(kg*m));Van Leusen (Watt);Llobera-Sluckin (kJ/m);Ardigo et al (J/(kg*m));Hare (cal/km) ;
##Choix3=selection Tobler (h & min);Tobler hors chemin (h & min);Tobler modifiée par Marquez-Perez et al (h & min);Irmischer-Clarke (homme, sur un sentier) (h & min);Irmischer-Clarke (homme, hors sentier) (h & min);Irmischer-Clarke (femme, sur un chemin) (h & min);Irmischer-Clarke (femme, hors sentier) (h & min);Uriarte Gonzalez (h & min);Marin Arroyo (h & min);Alberti modifiée pour les excursions pastorales de recherche de nourriture (h & min);Garmy, Kaddouri, Rozenblat et Schneider (h & min);Rees (h & min);Kondo-Seino (h & min);Tripcevich (h & min);Véhicules à roues (h & min);Dépense énergétique (None);Bellavia (None);Eastman (None);Pandolf et al (Watt);Pandolf et al avec correction de decente de pente (Watt);Minetti et al (J/(kg*m));Herzog (J/(kg*m));Van Leusen (Watt);Llobera-Sluckin (kJ/m);Ardigo et al (J/(kg*m));Hare (cal/km) ;
##Mouvement=enum literal 16;8;4 ;
##Vitesse=number 1.2
##Poids_du_Marcheur=number 70
##Poids_Transporte=number 0
##Barriere=optional vector
##PlotBarriere=selection FALSE;TRUE ;
##Cognitive_Slope=selection TRUE;FALSE ;

# Module output
##LCP=output vector
##LCP_Retour=output vector
##output_plots_to_html
##showplots


print("Verification de la presence et chargement des librairies necessaires")

# Verification for R libraries
packages <- c("sp","sf","raster","progress","movecost")
installed_packages <- packages %in% rownames(installed.packages())
if (any(installed_packages == FALSE)) {
  install.packages(packages[!installed_packages])
}
invisible(lapply(packages, library, character.only = TRUE))

# Loading libraries
library(sp)
library(sf)
library(movecost)
library(progress)
library(raster)


print("Transformation des couches en entrees")

# Recovery of the SCR starting point and transformation of QGIS layers into objects usable by R
origin_crs <- st_crs(Origine)$proj4string
origin_sp <- as(Origine, "Spatial")
destin_sp <- as(Destination, "Spatial")
studyplot_sp <- raster(MNT@file@name)


print("Verification des valeurs du raster")

# Verification for the raster's values
summary(studyplot_sp)  
any(is.na(studyplot_sp))  
any(studyplot_sp == Inf)  
studyplot_sp[is.na(studyplot_sp)] <- 0  
studyplot_sp[studyplot_sp == Inf] <- max(studyplot_sp, na.rm = TRUE)  


print("Recuperation des valeurs renseignees")

# Definion of the function to choose a response from a choice list
get_string_value <- function(val, string_map) {
    string_map[val + 1] # +1 because R indexing starts from 1
}

# Getting the fonction name
functions_names <- c("Tobler (h & min)", "Tobler hors chemin (h & min)", "Tobler modifiée par Marquez-Perez et al (h & min)", "Irmischer-Clarke (homme, sur un sentier) (h & min)", "Irmischer-Clarke (homme, hors sentier) (h & min)", "Irmischer-Clarke (femme, sur un chemin) (h & min)", "Irmischer-Clarke (femme, hors sentier) (h & min)", "Uriarte Gonzalez (h & min)", "Marin Arroyo (h & min)", "Alberti modifiée pour les excursions pastorales de recherche de nourriture (h & min)", "Garmy, Kaddouri, Rozenblat et Schneider (h & min)", "Rees (h & min)", "Kondo-Seino (h & min)", "Tripcevich (h & min)", "Véhicules à roues (h & min)", "Dépense énergétique (None)", "Bellavia (None)", "Eastman (None)", "Pandolf et al (Watt)", "Pandolf et al avec correction de decente de pente (Watt)", "Minetti et al (J/(kg*m))", "Herzog (J/(kg*m))", "Van Leusen (Watt)", "Llobera-Sluckin (kJ/m)", "Ardigo et al (J/(kg*m))", "Hare (cal/km)")
function_map <- c("t", "tofp", "mp", "icmonp", "icmoffp", "icfonp", "icfoffp", "ug", "ma", "alb", "gkrs", "r", "ks", "trp", "wcs", "ree", "b", "e", "p", "pcf", "m", "hrz", "vl", "ls", "a", "h")

Choix1 <- get_string_value(Choix1, functions_names)
i <- match(Choix1, functions_names)
Choix1 <- function_map[i]
Choix2 <- get_string_value(Choix2, functions_names)
i <- match(Choix2, functions_names)
Choix2 <- function_map[i]
Choix3 <- get_string_value(Choix3, functions_names)
i <- match(Choix3, functions_names)
Choix3 <- function_map[i]

choices <- c(Choix1, Choix2)
if (Choix3 != '') {choices <- c(choices, Choix3)}

Bool <- c("TRUE","FALSE")
Bool2 <- c("FALSE","TRUE")
Retour_Base <- get_string_value(Retour_Base, Bool)
rb <- as.logical(Retour_Base)
NULL_dans_MNT <- get_string_value(NULL_dans_MNT, Bool2)
NULL_dans_MNT <- as.logical(NULL_dans_MNT)
Cognitive_Slope <- get_string_value(Cognitive_Slope, Bool)
Cognitive_Slope <- as.logical(Cognitive_Slope)

Mouvement<-as.integer(Mouvement)

# Gestion of barrier
PlotBarriere <- as.logical(get_string_value(PlotBarriere, Bool2))
if(!PlotBarriere) {
  barrier_sp <- NULL
  Field <- NULL
} else {
  barrier_sp <- as(Barriere, "Spatial")
  Mouvement <- 8
  Field <- 0
  NULL_dans_MNT <- TRUE
}


print("Lancement de l'outil... Cette opération peut durer plusieurs minutes...")

# Launching function movecomp
tryCatch({
  r <- movecomp(
    dtm = studyplot_sp,
    origin = origin_sp,
    destin = destin_sp,
    barrier = barrier_sp,
    plot.barrier = PlotBarriere,
    irregular.dtm = NULL_dans_MNT,
    field = Field,
    choice = choices,
    move = Mouvement,
    return.base = rb,
    cogn.slp = Cognitive_Slope,
    W = Poids_du_Marcheur,
    L = Poids_Transporte,
    V = Vitesse,
    oneplot = FALSE,
    export = FALSE)
},
error = function(e) {
  message(str(e))
})


print("Preparation des fichiers de sortie...")

l_fonction_t <- list("t", "tofp", "mp", "icmonp", "icmoffp", "icfonp", "icfoffp", "ug", "ma", "alb", "gkrs", "r", "ks", "trp")
l_fonction_abs <- list("wcs", "ree", "b", "e")
l_fonction_watt <- list("p", "pcf", "vl")
l_fonction_J <- list("m", "hrz", "a")

l_unite <- list()

n=1 

unite <- function(choix,liste,n){
  if (choix %in% l_fonction_t){
    liste[[n]] <- "h"
  }else if (choix %in% l_fonction_abs){
    liste[[n]] <- "Unité abstraite"
  } else if (choix %in% l_fonction_watt){
    liste[[n]] <- "Watts"
  } else if (choix %in% l_fonction_J){
    liste[[n]] <- "J/(kg*m)"
  } else if (choix == "ls"){
    liste[[n]] <- "kJ/m"
  } else if (choix == "h"){
    liste[[n]] <- "cal/km"
  }
  return(liste)
}

l_unite<-unite(Choix1,l_unite,n)
n<-n+1
l_unite<-unite(Choix2,l_unite,n)
n<-n+1
if (Choix3 != '') {l_unite<-unite(Choix3,l_unite,n)}

data <- as.data.frame(do.call(rbind, l_unite))
colnames(data)[1] <- "unite"


if (!is.null(r$LCPs)) {
  r$LCPs@data <- r$LCPs@data[,c(3,1,2)]
  sf_dl1 = st_as_sf(r$LCPs)
  # Définition du SCR pour les éléments de sortie s'il ce n'est pas déjà le cas
  if (is.na(st_crs(sf_dl1))) {
    sf_dl1 <- st_set_crs(sf_dl1, SCR)
  }

  colnames(sf_dl1)[colnames(sf_dl1) == 'length'] <- 'distance_km'
  sf_dl1$distance_km <- sf_dl1$distance_km/1000


  if (Choix1 %in% l_fonction_t & Choix2 %in% l_fonction_t & Choix3 %in% l_fonction_t){
    colnames(sf_dl1)[3] <- "temps_h"
    sf_dl1$temps_h <- as.numeric(sf_dl1$temps_h)
    sf_dl1$temps_h <- as.numeric(sf_dl1$temps_h)
    cout <- as.numeric(sf_dl1$temps_h)
    heures <- floor(cout)
    jours <- floor(heures/24)
    heures_2 <- floor(heures-24*jours)
    minutes <- floor((cout-heures)*60)
    hm <- paste(heures,"h",minutes,"min")
    jhm <- paste(jours,"j",heures_2,"h",minutes,"min")
    sf_dl1$temps_hm <- hm
    sf_dl1$temps_jhm <- jhm
  } else if (Choix1 %in% l_fonction_t & Choix2 %in% l_fonction_t& Choix3==''){
    colnames(sf_dl1)[3] <- "temps_h"
    sf_dl1$temps_h <- as.numeric(sf_dl1$temps_h)
    cout <- as.numeric(sf_dl1$temps_h)
    heures <- floor(cout)
    jours <- floor(heures/24)
    heures_2 <- floor(heures-24*jours)
    minutes <- floor((cout-heures)*60)
    hm <- paste(heures,"h",minutes,"min")
    jhm <- paste(jours,"j",heures_2,"h",minutes,"min")
    sf_dl1$temps_hm <- hm
    sf_dl1$temps_jhm <- jhm
  } else {
    sf_dl1 <- cbind(sf_dl1,data)
  }

  sf_dl1$mouvements <- Mouvement
  sf_dl1$vitesse <- Vitesse
  sf_dl1$poids_marcheur <- Poids_du_Marcheur
  sf_dl1$poids_transport <- Poids_Transporte
  LCP = sf_dl1
} 

if(Retour_Base == TRUE) {
  if (!is.null(r$LPCs.back)) {
    r$LPCs.back@data <- r$LPCs.back@data[,c(3,1,2)]
    sf_dl2 = st_as_sf(r$LPCs.back)
    if (is.na(st_crs(sf_dl2))) {
      sf_dl2 <- st_set_crs(sf_dl2, SCR)
    }

    colnames(sf_dl2)[colnames(sf_dl2) == 'length'] <- 'distance_km'
    sf_dl2$distance_km <- sf_dl2$distance_km/1000


    if (Choix1 %in% l_fonction_t & Choix2 %in% l_fonction_t & Choix3 %in% l_fonction_t){
      colnames(sf_dl2)[3] <- "temps_h"
      sf_dl2$temps_h <- as.numeric(sf_dl2$temps_h)
      cout <- as.numeric(sf_dl2$temps_h)
      heures <- floor(cout)
      jours <- floor(heures/24)
      heures_2 <- floor(heures-24*jours)
      minutes <- floor((cout-heures)*60)
      hm <- paste(heures,"h",minutes,"min")
      jhm <- paste(jours,"j",heures_2,"h",minutes,"min")
      sf_dl2$temps_hm <- hm
      sf_dl2$temps_jhm <- jhm
    } else if (Choix1 %in% l_fonction_t & Choix2 %in% l_fonction_t& Choix3==''){
      colnames(sf_dl2)[3] <- "temps_h"
      sf_dl2$temps_h <- as.numeric(sf_dl2$temps_h)
      cout <- as.numeric(sf_dl2$temps_h)
      heures <- floor(cout)
      jours <- floor(heures/24)
      heures_2 <- floor(heures-24*jours)
      minutes <- floor((cout-heures)*60)
      hm <- paste(heures,"h",minutes,"min")
      jhm <- paste(jours,"j",heures_2,"h",minutes,"min")
      sf_dl2$temps_hm <- hm
      sf_dl2$temps_jhm <- jhm
    } else {
      sf_dl2 <- cbind(sf_dl2,data)
    }

    sf_dl2$mouvements <- Mouvement
    sf_dl2$vitesse <- Vitesse
    sf_dl2$poids_marcheur <- Poids_du_Marcheur
    sf_dl2$poids_transport <- Poids_Transporte
    LCP_Retour = sf_dl2
  } 
}

print("Algorithme termine")

traceback()