##Siligites script=group
##movebound=name

# Module input
##SCR=crs
##MNT=raster
##Couche_Points=vector point
##Cout_Isoligne=number 0
##Fonction=selection Tobler (h & min);Tobler hors chemin (h & min);Tobler modifiée par Marquez-Perez et al (h & min);Irmischer-Clarke (homme, sur un sentier) (h & min);Irmischer-Clarke (homme, hors sentier) (h & min);Irmischer-Clarke (femme, sur un chemin) (h & min);Irmischer-Clarke (femme, hors sentier) (h & min);Uriarte Gonzalez (h & min);Marin Arroyo (h & min);Alberti modifiée pour les excursions pastorales de recherche de nourriture (h & min);Garmy, Kaddouri, Rozenblat et Schneider (h & min);Rees (h & min);Kondo-Seino (h & min);Tripcevich (h & min);Véhicules à roues (h & min);Dépense énergétique (None);Bellavia (None);Eastman (None);Pandolf et al (Watt);Pandolf et al avec correction de decente de pente (Watt);Minetti et al (J/(kg*m));Herzog (J/(kg*m));Van Leusen (Watt);Llobera-Sluckin (kJ/m);Ardigo et al (J/(kg*m));Hare (cal/km) ;
##Mouvement=enum literal 16;8;4 ;
##Vitesse=number 1.2
##Poids_du_Marcheur=number 70
##Poids_Transporte=number 0
##Barriere=optional vector
##PlotBarriere=selection FALSE;TRUE ;
##Cognitive_Slope=selection TRUE;FALSE ;

# Module output
##Isolignes=output vector
##output_plots_to_html
##showplots


print("Verification de la presence et chargement des librairies necessaires")

# Verification for R libraries
packages <- c("sp","sf","raster","progress","movecost")
installed_packages <- packages %in% rownames(installed.packages())
if (any(installed_packages == FALSE)) {
  install.packages(packages[!installed_packages])
}
invisible(lapply(packages, library, character.only = TRUE))

# Loading libraries
library(sp)
library(sf)
library(movecost)
library(progress)
library(raster)


print("Transformation des couches en entrees")

# Recovery of the SCR starting point and transformation of QGIS layers into objects usable by R
origin_crs <- SCR
p <- as_Spatial(Couche_Points)
studyplot_sp <- raster(MNT@file@name)
crs(studyplot_sp) <- origin_crs


print("Verification des valeurs du raster")

# Verification for the raster's values
summary(studyplot_sp) 
any(is.na(studyplot_sp))
any(studyplot_sp == Inf) 
studyplot_sp[is.na(studyplot_sp)] <- 0  
studyplot_sp[studyplot_sp == Inf] <- max(studyplot_sp, na.rm = TRUE)  


print("Recuperation des valeurs renseignees")

# Definion of the function to choose a response from a choice list
get_string_value <- function(val, string_map) {
    string_map[val + 1] # +1 because R indexing starts from 1
}

# Getting the fonction name
functions_names <- c("Tobler (h & min)", "Tobler hors chemin (h & min)", "Tobler modifiée par Marquez-Perez et al (h & min)", "Irmischer-Clarke (homme, sur un sentier) (h & min)", "Irmischer-Clarke (homme, hors sentier) (h & min)", "Irmischer-Clarke (femme, sur un chemin) (h & min)", "Irmischer-Clarke (femme, hors sentier) (h & min)", "Uriarte Gonzalez (h & min)", "Marin Arroyo (h & min)", "Alberti modifiée pour les excursions pastorales de recherche de nourriture (h & min)", "Garmy, Kaddouri, Rozenblat et Schneider (h & min)", "Rees (h & min)", "Kondo-Seino (h & min)", "Tripcevich (h & min)", "Véhicules à roues (h & min)", "Dépense énergétique (None)", "Bellavia (None)", "Eastman (None)", "Pandolf et al (Watt)", "Pandolf et al avec correction de decente de pente (Watt)", "Minetti et al (J/(kg*m))", "Herzog (J/(kg*m))", "Van Leusen (Watt)", "Llobera-Sluckin (kJ/m)", "Ardigo et al (J/(kg*m))", "Hare (cal/km)")
function_map <- c("t", "tofp", "mp", "icmonp", "icmoffp", "icfonp", "icfoffp", "ug", "ma", "alb", "gkrs", "r", "ks", "trp", "wcs", "ree", "b", "e", "p", "pcf", "m", "hrz", "vl", "ls", "a", "h")
Fonction <- get_string_value(Fonction, functions_names)
i <- match(Fonction, functions_names)
Fonction <- function_map[i]

Bool <- c("TRUE","FALSE")
Bool2 <- c("FALSE","TRUE")
Cognitive_Slope <- get_string_value(Cognitive_Slope, Bool)
Cognitive_Slope <- as.logical(Cognitive_Slope)

Mouvement<-as.integer(Mouvement)

# Gestion of barrier
PlotBarriere <- as.logical(get_string_value(PlotBarriere, Bool2))
if(!PlotBarriere) {
  barrier_sp <- NULL
  Field <- NULL
} else {
  barrier_sp <- as(Barriere, "Spatial")
  Mouvement <- 8
  Field <- 0
  NULL_dans_MNT <- TRUE
}

if (Cout_Isoligne==0){
   iso <- NULL
} else{
  iso <- Cout_Isoligne
}


print("Lancement de l'outil... Cette opération peut durer plusieurs minutes...")

# Launching function movebound
tryCatch({
  r<-movebound(dtm=studyplot_sp,
    origin=p,
    barrier = barrier_sp,
    plot.barrier = PlotBarriere,
    field = Field,
    funct=Fonction, 
    move=Mouvement, 
    cont.value=iso, 
    cogn.slp=Cognitive_Slope,  
    W=Poids_du_Marcheur, 
    L=Poids_Transporte,
    V=Vitesse, 
    cont.lab=TRUE, 
    add.geom=TRUE,
    export=FALSE)
},
error = function(e) {
  message(str(e))
})


print("Preparation des fichiers de sortie...")

l_fonction_t <- list("t", "tofp", "mp", "icmonp", "icmoffp", "icfonp", "icfoffp", "ug", "ma", "alb", "gkrs", "r", "ks", "trp")
l_fonction_abs <- list("wcs", "ree", "b", "e")
l_fonction_watt <- list("p", "pcf", "vl")
l_fonction_J <- list("m", "hrz", "a")

if (!is.null(r$isolines)) {
  a1=r$isolines
  sf_object = st_as_sf(a1)
  # Définition du SCR pour les éléments de sortie s'il ce n'est pas déjà le cas
  if (is.na(st_crs(sf_object))) {
    sf_object <- st_set_crs(sf_object, SCR) # esempio con WGS84
  }

  colnames(sf_object)[colnames(sf_object) == 'area'] <- 'aire_couverte_km²'

  if (Fonction %in% l_fonction_t){
    colnames(sf_object)[colnames(sf_object) == 'level'] <- 'temps_h'
    sf_object$temps_h <- as.numeric(sf_object$temps_h)
    cout <- as.numeric(sf_object$temps_h)
    heures <- floor(cout)
    jours <- floor(heures/24)
    heures_2 <- floor(heures-24*jours)
    minutes <- floor((cout-heures)*60)
    hm <- paste(heures,"h",minutes,"min")
    jhm <- paste(jours,"j",heures_2,"h",minutes,"min")
    sf_object$temps_hm <- hm
    sf_object$temps_jhm <- jhm
  } else{
    colnames(sf_object)[colnames(sf_object) == 'level'] <- 'cout_energie'
    sf_object$cout_energie <- as.numeric(sf_object$cout_energie)
    if (Fonction %in% l_fonction_abs){
      sf_object$unite <- "Unité abstraite"
    } else if (Fonction %in% l_fonction_watt){
      sf_object$unite <- "Watts"
    } else if (Fonction %in% l_fonction_J){
      sf_object$unite <- "J/(kg*m)"
    } else if (Fonction == "ls"){
      sf_object$unite <- "kJ/m"
    } else if (Fonction == "h"){
      sf_object$unite <- "cal/km"
    }
  }

  tempo <- r$origin_w_isolines_geom
  if (nrow(tempo)>1){
    tempo <- st_as_sf(tempo)
    tempo <- sum(tempo$area)
    sf_object$area <- tempo
  } else {
    sf_object$area <- tempo$area
  }
  sf_object$fonction <- Fonction
  sf_object$mouvements <- Mouvement
  sf_object$vitesse <- Vitesse
  sf_object$poids_marcheur <- Poids_du_Marcheur
  sf_object$poids_transport <- Poids_Transporte
  Isolignes=sf_object
}

print("Algorithme termine")

traceback()