##Siligites script=group
##moverank=name

# Module input
##SCR=crs
##MNT=raster
##NULL_dans_MNT=selection FALSE;TRUE ;
##Origine=vector point
##Destination=vector point
##Fonction=selection Tobler (h & min);Tobler hors chemin (h & min);Tobler modifiée par Marquez-Perez et al (h & min);Irmischer-Clarke (homme, sur un sentier) (h & min);Irmischer-Clarke (homme, hors sentier) (h & min);Irmischer-Clarke (femme, sur un chemin) (h & min);Irmischer-Clarke (femme, hors sentier) (h & min);Uriarte Gonzalez (h & min);Marin Arroyo (h & min);Alberti modifiée pour les excursions pastorales de recherche de nourriture (h & min);Garmy, Kaddouri, Rozenblat et Schneider (h & min);Rees (h & min);Kondo-Seino (h & min);Tripcevich (h & min);Véhicules à roues (h & min);Dépense énergétique (None);Bellavia (None);Eastman (None);Pandolf et al (Watt);Pandolf et al avec correction de decente de pente (Watt);Minetti et al (J/(kg*m));Herzog (J/(kg*m));Van Leusen (Watt);Llobera-Sluckin (kJ/m);Ardigo et al (J/(kg*m));Hare (cal/km) ;
##Mouvement=enum literal 16;8;4 ;
##Vitesse=number 1.2
##Poids_du_Marcheur=number 70
##Poids_Transporte=number 0
##Barriere=optional vector
##PlotBarriere=selection FALSE;TRUE ;
##Cognitive_Slope=selection TRUE;FALSE ;

# Module output
##LCP=output vector
##Least_Cost_Corridor=output raster
##output_plots_to_html
##showplots


print("Vérification de la présence et chargement des librairies nécessaires")

# Verification for R libraries
packages <- c("sp","sf","raster","progress","movecost")
installed_packages <- packages %in% rownames(installed.packages())
if (any(installed_packages == FALSE)) {
  install.packages(packages[!installed_packages])
}
invisible(lapply(packages, library, character.only = TRUE))

# Loading libraries
library(sp)
library(sf)
library(movecost)
library(progress)
library(raster)


print("Transformation des couches en entrées")

# Recovery of the SCR starting point and transformation of QGIS layers into objects usable by R
origin_crs <- st_crs(Origine)$proj4string
origin_sp <- as(Origine, "Spatial")
destin_sp <- as(Destination, "Spatial")
studyplot_sp <- raster(MNT@file@name)


print("Vérification des valeurs du raster")

# Verification for the raster's values
summary(studyplot_sp)  
any(is.na(studyplot_sp))
any(studyplot_sp == Inf) 
studyplot_sp[is.na(studyplot_sp)] <- 0  
studyplot_sp[studyplot_sp == Inf] <- max(studyplot_sp, na.rm = TRUE)  


print("Récupération des valeurs renseignées")

# Definion of the function to choose a response from a choice list
get_string_value <- function(val, string_map) {
    string_map[val + 1] # +1 because R indexing starts from 1
}

# Getting the fonction name
functions_names <- c("Tobler (h & min)", "Tobler hors chemin (h & min)", "Tobler modifiée par Marquez-Perez et al (h & min)", "Irmischer-Clarke (homme, sur un sentier) (h & min)", "Irmischer-Clarke (homme, hors sentier) (h & min)", "Irmischer-Clarke (femme, sur un chemin) (h & min)", "Irmischer-Clarke (femme, hors sentier) (h & min)", "Uriarte Gonzalez (h & min)", "Marin Arroyo (h & min)", "Alberti modifiée pour les excursions pastorales de recherche de nourriture (h & min)", "Garmy, Kaddouri, Rozenblat et Schneider (h & min)", "Rees (h & min)", "Kondo-Seino (h & min)", "Tripcevich (h & min)", "Véhicules à roues (h & min)", "Dépense énergétique (None)", "Bellavia (None)", "Eastman (None)", "Pandolf et al (Watt)", "Pandolf et al avec correction de decente de pente (Watt)", "Minetti et al (J/(kg*m))", "Herzog (J/(kg*m))", "Van Leusen (Watt)", "Llobera-Sluckin (kJ/m)", "Ardigo et al (J/(kg*m))", "Hare (cal/km)")
function_map <- c("t", "tofp", "mp", "icmonp", "icmoffp", "icfonp", "icfoffp", "ug", "ma", "alb", "gkrs", "r", "ks", "trp", "wcs", "ree", "b", "e", "p", "pcf", "m", "hrz", "vl", "ls", "a", "h")
Fonction <- get_string_value(Fonction, functions_names)
i <- match(Fonction, functions_names)
Fonction <- function_map[i]

Bool <- c("TRUE","FALSE")
Bool2 <- c("FALSE","TRUE")
NULL_dans_MNT <- get_string_value(NULL_dans_MNT, Bool2)
NULL_dans_MNT <- as.logical(NULL_dans_MNT)
Cognitive_Slope <- get_string_value(Cognitive_Slope, Bool)
Cognitive_Slope <- as.logical(Cognitive_Slope)

Mouvement<-as.integer(Mouvement)

# Gestion of barrier
PlotBarriere <- as.logical(get_string_value(PlotBarriere, Bool2))
if(!PlotBarriere) {
  barrier_sp <- NULL
  Field <- NULL
} else {
  barrier_sp <- as(Barriere, "Spatial")
  Mouvement <- 8
  Field <- 0
  NULL_dans_MNT <- TRUE
}


print("Lancement de l'outil... Cette opération peut durer plusieurs minutes...")

# Launching function moverank
tryCatch({
  r <- moverank(
    dtm = studyplot_sp,
    origin = origin_sp,
    destin = destin_sp,
    barrier = barrier_sp,
    plot.barrier = PlotBarriere,
    irregular.dtm = NULL_dans_MNT,
    funct = Fonction,
    lcp.n = 6,
    use.corr=TRUE,
    move = Mouvement,
    cogn.slp = Cognitive_Slope,
    W = Poids_du_Marcheur,
    L = Poids_Transporte,
    V = Vitesse,
    leg.pos="center",
    add.chart=TRUE,
    export = FALSE
  )
},
error = function(e) {
  message(str(e))
})


print("Préparation des fichiers de sortie...")

l_fonction_t <- list("t", "tofp", "mp", "icmonp", "icmoffp", "icfonp", "icfoffp", "ug", "ma", "alb", "gkrs", "r", "ks", "trp")
l_fonction_abs <- list("wcs", "ree", "b", "e")
l_fonction_watt <- list("p", "pcf", "vl")
l_fonction_J <- list("m", "hrz", "a")

if (!is.null(r$LCPs)) {
    b1=r$LCPs
    sf_dl = st_as_sf(b1)
    # Définition du SCR pour les éléments de sortie s'il ce n'est pas déjà le cas
    if (is.na(st_crs(sf_dl))) {
    sf_dl <- st_set_crs(sf_dl, SCR)
    }

    if (Fonction %in% l_fonction_t){
    colnames(sf_dl)[3] <- "temps_h"
    sf_dl$temps_h <- as.numeric(sf_dl$temps_h)
    cout <- as.numeric(sf_dl$temps_h)
    heures <- floor(cout)
    jours <- floor(heures/24)
    heures_2 <- floor(heures-24*jours)
    minutes <- floor((cout-heures)*60)
    hm <- paste(heures,"h",minutes,"min")
    jhm <- paste(jours,"j",heures_2,"h",minutes,"min")
    sf_dl$temps_hm <- hm
    sf_dl$temps_jhm <- jhm
    }else{
    colnames(sf_dl)[3] <- 'cout_energie'
    if (Fonction %in% l_fonction_abs){
      sf_dl$unite <- "Unité abstraite"
    } else if (Fonction %in% l_fonction_watt){
      sf_dl$unite <- "Watts"
    } else if (Fonction %in% l_fonction_J){
      sf_dl$unite <- "J/(kg*m)"
    } else if (Fonction == "ls"){
      sf_dl$unite <- "kJ/m"
    } else if (Fonction == "h"){
      sf_dl$unite <- "cal/km"
    }}

    sf_dl$fonction <- Fonction
    sf_dl$mouvements <- Mouvement
    sf_dl$vitesse <- Vitesse
    sf_dl$poids_marcheur <- Poids_du_Marcheur
    sf_dl$poids_transport <- Poids_Transporte
    LCP =sf_dl
}

if(!is.null(r$'least-cost corridor')) {
    sf_object_corr <- r$'least-cost corridor'
    if (is.na(crs(sf_object_corr))) {
        crs(sf_object_corr) <- SCR 
}
    crs(studyplot_sp)<-crs(sf_object_corr)
    sf_object_cropped = mask(sf_object_corr, studyplot_sp)
    Least_Cost_Corridor=sf_object_cropped
}

print("Algorithme terminé")

traceback()