##Siligites script=group
##movecorr=name

# Module input
##SCR=crs
##MNT=raster
##NULL_dans_MNT=selection FALSE;TRUE ;
##Point_Depart=vector point
##Point_Arrivee=vector point
##Fonction=selection Tobler (h & min);Tobler hors chemin (h & min);Tobler modifiée par Marquez-Perez et al (h & min);Irmischer-Clarke (homme, sur un sentier) (h & min);Irmischer-Clarke (homme, hors sentier) (h & min);Irmischer-Clarke (femme, sur un chemin) (h & min);Irmischer-Clarke (femme, hors sentier) (h & min);Uriarte Gonzalez (h & min);Marin Arroyo (h & min);Alberti modifiée pour les excursions pastorales de recherche de nourriture (h & min);Garmy, Kaddouri, Rozenblat et Schneider (h & min);Rees (h & min);Kondo-Seino (h & min);Tripcevich (h & min);Véhicules à roues (h & min);Dépense énergétique (None);Bellavia (None);Eastman (None);Pandolf et al (Watt);Pandolf et al avec correction de decente de pente (Watt);Minetti et al (J/(kg*m));Herzog (J/(kg*m));Van Leusen (Watt);Llobera-Sluckin (kJ/m);Ardigo et al (J/(kg*m));Hare (cal/km) ;
##Mouvement=enum literal 16;8;4 ;
##Vitesse=number 1.2
##Poids_du_Marcheur=number 70
##Poids_Transporte=number 0
##Barriere=optional vector
##PlotBarriere=selection FALSE;TRUE ;
##Cognitive_Slope=selection TRUE;FALSE ;

# Module output
##Least_Cost_Corridor=output raster
##LCP_A_vers_B=output vector
##LCP_B_vers_A=output vector
##output_plots_to_html
##showplots


print("Verification de la presence et chargement des librairies necessaires")

# Verification for R libraries
packages <- c("sp","sf","raster","progress","movecost")
installed_packages <- packages %in% rownames(installed.packages())
if (any(installed_packages == FALSE)) {
  install.packages(packages[!installed_packages])
}
invisible(lapply(packages, library, character.only = TRUE))

# Loading libraries
library(sp)
library(sf)
library(movecost)
library(progress)
library(raster)


print("Transformation des couches en entrees")

# Recovery of the SCR starting point and transformation of QGIS layers into objects usable by R
origin_crs <- SCR
a_sp <- as(Point_Depart, "Spatial")
b_sp <- as(Point_Arrivee, "Spatial")
studyplot_sp <- raster(MNT@file@name)
crs(studyplot_sp) <- origin_crs


print("Verification des valeurs du raster")

# Verification for the raster's values
summary(studyplot_sp)  
any(is.na(studyplot_sp))  
any(studyplot_sp == Inf)
studyplot_sp[is.na(studyplot_sp)] <- 0  
studyplot_sp[studyplot_sp == Inf] <- max(studyplot_sp, na.rm = TRUE)  


print("Recuperation des valeurs renseignees")

# Definion of the function to choose a response from a choice list
get_string_value <- function(val, string_map) {
    string_map[val + 1] # +1 because R indexing starts from 1
}

# Getting the fonction name
functions_names <- c("Tobler (h & min)", "Tobler hors chemin (h & min)", "Tobler modifiée par Marquez-Perez et al (h & min)", "Irmischer-Clarke (homme, sur un sentier) (h & min)", "Irmischer-Clarke (homme, hors sentier) (h & min)", "Irmischer-Clarke (femme, sur un chemin) (h & min)", "Irmischer-Clarke (femme, hors sentier) (h & min)", "Uriarte Gonzalez (h & min)", "Marin Arroyo (h & min)", "Alberti modifiée pour les excursions pastorales de recherche de nourriture (h & min)", "Garmy, Kaddouri, Rozenblat et Schneider (h & min)", "Rees (h & min)", "Kondo-Seino (h & min)", "Tripcevich (h & min)", "Véhicules à roues (h & min)", "Dépense énergétique (None)", "Bellavia (None)", "Eastman (None)", "Pandolf et al (Watt)", "Pandolf et al avec correction de decente de pente (Watt)", "Minetti et al (J/(kg*m))", "Herzog (J/(kg*m))", "Van Leusen (Watt)", "Llobera-Sluckin (kJ/m)", "Ardigo et al (J/(kg*m))", "Hare (cal/km)")
function_map <- c("t", "tofp", "mp", "icmonp", "icmoffp", "icfonp", "icfoffp", "ug", "ma", "alb", "gkrs", "r", "ks", "trp", "wcs", "ree", "b", "e", "p", "pcf", "m", "hrz", "vl", "ls", "a", "h")
Fonction <- get_string_value(Fonction, functions_names)
i <- match(Fonction, functions_names)
Fonction <- function_map[i]

Bool <- c("TRUE","FALSE")
Bool2 <- c("FALSE","TRUE")
NULL_dans_MNT <- get_string_value(NULL_dans_MNT, Bool2)
NULL_dans_MNT <- as.logical(NULL_dans_MNT)
Cognitive_Slope <- get_string_value(Cognitive_Slope, Bool)
Cognitive_Slope <- as.logical(Cognitive_Slope)

Mouvement<-as.integer(Mouvement)

# Gestion of barrier
PlotBarriere <- as.logical(get_string_value(PlotBarriere, Bool2))
if(!PlotBarriere) {
  barrier_sp <- NULL
  Field <- NULL
} else {
  barrier_sp <- as(Barriere, "Spatial")
  Mouvement <- 8
  Field <- 0
  NULL_dans_MNT <- TRUE
}


print("Lancement de l'outil... Cette opération peut durer plusieurs minutes...")

# Launching function movecorr
tryCatch({
  r<-movecorr(
    dtm=studyplot_sp,
    a=a_sp,
    b=b_sp,
    plot.barrier = PlotBarriere,
    barrier = barrier_sp,
    irregular.dtm = NULL_dans_MNT,
    field = Field,
    funct=Fonction,
    move=Mouvement,
    cogn.slp=Cognitive_Slope,
    W=Poids_du_Marcheur,
    L=Poids_Transporte,
    V=Vitesse)
},
error = function(e) {
  message(str(e))
})


print("Preparation des fichiers de sortie...")

if (!is.null(r$lc.corridor)) {
  LC<- r$lc.corridor
  # Définition du SCR pour les éléments de sortie s'il ce n'est pas déjà le cas
  if (is.na(crs(LC))) {
    crs(LC) <- SCR 
  }
  crs(studyplot_sp)<-crs(LC)
  LC_cropped = mask(LC, studyplot_sp)
  Least_Cost_Corridor=LC_cropped
}

if (!is.null(r$lcp_a_to_b)) {
  a1<- r$lcp_a_to_b
  sf_object_a1 = st_as_sf(a1)
  # Définition du SCR pour les éléments de sortie s'il ce n'est pas déjà le cas
  if (is.na(st_crs(sf_object_a1))) {
    sf_object_a1 <- st_set_crs(sf_object_a1,SCR)
  }

  colnames(sf_object_a1)[colnames(sf_object_a1) == 'length'] <- 'distance_km'
  sf_object_a1$distance_km <- sf_object_a1$distance_km/1000

  sf_object_a1$fonction <- Fonction
  sf_object_a1$mouvements <- Mouvement
  sf_object_a1$vitesse <- Vitesse
  sf_object_a1$poids_marcheur <- Poids_du_Marcheur
  sf_object_a1$poids_transport <- Poids_Transporte
  LCP_A_vers_B =sf_object_a1
}

if (!is.null(r$lcp_b_to_a)) {
  b1<- r$lcp_b_to_a
  sf_object_b1 = st_as_sf(b1)
  # Définition du SCR pour les éléments de sortie s'il ce n'est pas déjà le cas
  if (is.na(st_crs(sf_object_b1))) {
    sf_object_b1 <- st_set_crs(sf_object_b1,SCR)
  }

  colnames(sf_object_b1)[colnames(sf_object_b1) == 'length'] <- 'distance_km'
  sf_object_b1$distance_km <- sf_object_b1$distance_km/1000

  sf_object_b1$fonction <- Fonction
  sf_object_b1$mouvements <- Mouvement
  sf_object_b1$vitesse <- Vitesse
  sf_object_b1$poids_marcheur <- Poids_du_Marcheur
  sf_object_b1$poids_transport <- Poids_Transporte
  LCP_B_vers_A =sf_object_b1
}

print("Algorithme termine")

traceback()