# -*- coding: utf-8 -*-

"""
***************************************************************************
    delete_script.py
    ---------------------
    Date                 : August 2012
    Copyright            : (C) 2012 by Victor Olaya
    Email                : volayaf at gmail dot com
***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
"""

__author__ = "Victor Olaya"
__date__ = "August 2012"
__copyright__ = "(C) 2012, Victor Olaya"

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = "$Format:%H$"

import os

from processing.gui.ContextAction import ContextAction
from qgis.core import QgsApplication, QgsProcessingAlgorithm
from qgis.PyQt.QtCore import QCoreApplication
from qgis.PyQt.QtWidgets import QMessageBox


class DeleteScriptAction(ContextAction):
    """
    Toolbox context menu action for deleting an existing script
    """

    @staticmethod
    def tr(string):
        return QCoreApplication.translate("SiliciteR", string)

    def __init__(self):
        super().__init__()
        self.name = QCoreApplication.translate("SiliciteR", "Supprimer le script…")

    def isEnabled(self):
        """
        Returns whether the action is enabled
        """
        return (
            isinstance(self.itemData, QgsProcessingAlgorithm)
            and self.itemData.provider().id() == "siliciter"
            and self.itemData.is_user_script
        )

    def execute(self):
        """
        Called whenever the action is triggered
        """
        reply = QMessageBox.question(
            None,
            QCoreApplication.translate("SiliciteR", "Supprimer le script"),
            QCoreApplication.translate("SiliciteR", "Êtes-vous sur de vouloir supprimer ce script ?"),
            QMessageBox.StandardButton.Yes | QMessageBox.StandardButton.No,
            QMessageBox.StandardButton.No,
        )
        if reply == QMessageBox.StandardButton.Yes:
            file_path = self.itemData.description_file
            if file_path is not None:
                os.remove(file_path)
                QgsApplication.processingRegistry().providerById("siliciter").refreshAlgorithms()
            else:
                QMessageBox.warning(None, QCoreApplication.translate("SiliciteR", "Supprimer le script"), QCoreApplication.translate("SiliciteR", "Impossible de trouver le script correspondant."))
