##Siligites script=group
##movenetw=name

# Module input
##SCR=crs
##MNT=raster
##MNT_sans_Valeurs=selection FALSE;TRUE ;
##Couche_Points=vector point
##Type_Reseau=selection allpairs;neigh ;
##Densite_LCP=selection FALSE;TRUE ;
##Fonction=selection Tobler (h & min);Tobler hors chemin (h & min);Tobler modifiée par Marquez-Perez et al (h & min);Irmischer-Clarke (homme, sur un sentier) (h & min);Irmischer-Clarke (homme, hors sentier) (h & min);Irmischer-Clarke (femme, sur un chemin) (h & min);Irmischer-Clarke (femme, hors sentier) (h & min);Uriarte Gonzalez (h & min);Marin Arroyo (h & min);Alberti modifiée pour les excursions pastorales de recherche de nourriture (h & min);Garmy, Kaddouri, Rozenblat et Schneider (h & min);Rees (h & min);Kondo-Seino (h & min);Tripcevich (h & min);Véhicules à roues (h & min);Dépense énergétique (None);Bellavia (None);Eastman (None);Pandolf et al (Watt);Pandolf et al avec correction de decente de pente (Watt);Minetti et al (J/(kg*m));Herzog (J/(kg*m));Van Leusen (Watt);Llobera-Sluckin (kJ/m);Ardigo et al (J/(kg*m));Hare (cal/km) ;
##Mouvement=enum literal 16;8;4 ;
##Vitesse=number 1.2
##Poids_du_Marcheur=number 70
##Poids_Transporte=number 0
##Barriere=optional vector
##PlotBarriere=selection FALSE;TRUE ;
##Cognitive_Slope=selection TRUE;FALSE ;

# Module output
##Reseau_LCP=output vector
##Raster_Densite=output raster
##output_plots_to_html
##showplots


print("Verification de la presence et chargement des librairies necessaires")

# Verification for R libraries
packages <- c("sp","sf","raster","progress","movecost")
installed_packages <- packages %in% rownames(installed.packages())
if (any(installed_packages == FALSE)) {
  install.packages(packages[!installed_packages])
}
invisible(lapply(packages, library, character.only = TRUE))

# Loading libraries
library(sp)
library(sf)
library(movecost)
library(progress)
library(raster)


print("Transformation des couches en entrees")

# Recovery of the SCR starting point and transformation of QGIS layers into objects usable by R
origin_crs <- SCR
origin_sp <- as(Couche_Points, "Spatial")
studyplot_sp <- raster(MNT@file@name)
crs(studyplot_sp) <- origin_crs


print("Verification des valeurs du raster")

# Verification for the raster's values
summary(studyplot_sp)  
any(is.na(studyplot_sp))  
any(studyplot_sp == Inf)  
studyplot_sp[is.na(studyplot_sp)] <- 0  
studyplot_sp[studyplot_sp == Inf] <- max(studyplot_sp, na.rm = TRUE)  


print("Recuperation des valeurs renseignees")

# Definion of the function to choose a response from a choice list
get_string_value <- function(val, string_map) {
    string_map[val + 1] # +1 because R indexing starts from 1
}

# Getting the fonction name
functions_names <- c("Tobler (h & min)", "Tobler hors chemin (h & min)", "Tobler modifiée par Marquez-Perez et al (h & min)", "Irmischer-Clarke (homme, sur un sentier) (h & min)", "Irmischer-Clarke (homme, hors sentier) (h & min)", "Irmischer-Clarke (femme, sur un chemin) (h & min)", "Irmischer-Clarke (femme, hors sentier) (h & min)", "Uriarte Gonzalez (h & min)", "Marin Arroyo (h & min)", "Alberti modifiée pour les excursions pastorales de recherche de nourriture (h & min)", "Garmy, Kaddouri, Rozenblat et Schneider (h & min)", "Rees (h & min)", "Kondo-Seino (h & min)", "Tripcevich (h & min)", "Véhicules à roues (h & min)", "Dépense énergétique (None)", "Bellavia (None)", "Eastman (None)", "Pandolf et al (Watt)", "Pandolf et al avec correction de decente de pente (Watt)", "Minetti et al (J/(kg*m))", "Herzog (J/(kg*m))", "Van Leusen (Watt)", "Llobera-Sluckin (kJ/m)", "Ardigo et al (J/(kg*m))", "Hare (cal/km)")
function_map <- c("t", "tofp", "mp", "icmonp", "icmoffp", "icfonp", "icfoffp", "ug", "ma", "alb", "gkrs", "r", "ks", "trp", "wcs", "ree", "b", "e", "p", "pcf", "m", "hrz", "vl", "ls", "a", "h")
Fonction <- get_string_value(Fonction, functions_names)
i <- match(Fonction, functions_names)
Fonction <- function_map[i]

Netype_map <- c("allpairs", "neigh")
Type_Reseau <- get_string_value(Type_Reseau, Netype_map)

Bool <- c("TRUE","FALSE")
Bool2 <- c("FALSE","TRUE")
MNT_sans_Valeurs <- get_string_value(MNT_sans_Valeurs, Bool2)
MNT_sans_Valeurs <- as.logical(MNT_sans_Valeurs)
Cognitive_Slope <- get_string_value(Cognitive_Slope, Bool)
Cognitive_Slope <- as.logical(Cognitive_Slope)
if(Type_Reseau == 'allpairs') {
  Densite_LCP <- get_string_value(Densite_LCP, Bool2)
  Densite_LCP <- as.logical(Densite_LCP)
} else {
  Densite_LCP <- FALSE
}

Mouvement<-as.integer(Mouvement)

# Gestion of barrier
PlotBarriere <- as.logical(get_string_value(PlotBarriere, Bool2))
if(!PlotBarriere) {
  barrier_sp <- NULL
  Field <- NULL
} else {
  barrier_sp <- as(Barriere, "Spatial")
  Mouvement <- 8
  Field <- 0
  MNT_sans_Valeurs <- TRUE
}


print("Lancement de l'outil...")

# Launching function movenetw
tryCatch({
  r<-movenetw(
    dtm = studyplot_sp,
    origin = origin_sp,
    netw.type=Type_Reseau,
    barrier = barrier_sp,
    plot.barrier = PlotBarriere,
    irregular.dtm = MNT_sans_Valeurs,
    field = Field,
    funct=Fonction,
    move=Mouvement,
    cogn.slp=Cognitive_Slope,
    W=Poids_du_Marcheur,
    L=Poids_Transporte,
    V=Vitesse,
    lcp.dens=Densite_LCP,
    export=FALSE)
},
error = function(e) {
  message(str(e))
})


print("Preparation des fichiers de sortie...")

l_fonction_t <- list("t", "tofp", "mp", "icmonp", "icmoffp", "icfonp", "icfoffp", "ug", "ma", "alb", "gkrs", "r", "ks", "trp")
l_fonction_abs <- list("wcs", "ree", "b", "e")
l_fonction_watt <- list("p", "pcf", "vl")
l_fonction_J <- list("m", "hrz", "a")

if (Type_Reseau == 'allpairs') {
  if (!is.null(r$LCPs.netw.merged)) {
    sf_dl = st_as_sf(r$LCPs.netw.merged)
    # Définition du SCR pour les éléments de sortie s'il ce n'est pas déjà le cas
    if (is.na(st_crs(sf_dl))) {
      sf_dl <- st_set_crs(sf_dl, SCR)
    }

    sf_dl$longueur_km <- st_length(sf_dl)/1000

    values<-list()
    
    if (Fonction %in% l_fonction_t){
      n=1
      for (i in 1:nrow(r$cost.matrix.hrs)) {
        for (j in 1:ncol(r$cost.matrix.hrs)) {
          if (r$cost.matrix.hrs[i,j]!=0){
            values[[n]]<-r$cost.matrix.hrs[i,j]
            n<-n+1
      }}}
      data <- as.data.frame(do.call(rbind, values))
      colnames(data) <- "temps_h"
      data$temps_h <- as.numeric(data$temps_h)
      cout <- data$temps_h
      heures <- floor(cout)
      jours <- floor(heures/24)
      heures_2 <- floor(heures-24*jours)
      minutes <- floor((cout-heures)*60)
      hm <- paste(heures,"h",minutes,"min")
      jhm <- paste(jours,"j",heures_2,"h",minutes,"min")
      data$temps_hm <- hm
      data$temps_jhm <- jhm
    } else {
      n=1
      r$cost.matrix[is.na(r$cost.matrix)] <- 0
      for (i in 1:nrow(r$cost.matrix)) {
        for (j in 1:ncol(r$cost.matrix)) {
          if (r$cost.matrix[i,j]!=0){
            values[[n]]<-r$cost.matrix[i,j]
            n<-n+1
      }}}
      data <- as.data.frame(do.call(rbind, values))
      colnames(data) <- "cout_energie"
      if (Fonction %in% l_fonction_abs){
        data$unite <- "Unité abstraite"
      } else if (Fonction %in% l_fonction_watt){
        data$unite <- "Watts"
      } else if (Fonction %in% l_fonction_J){
        data$unite <- "J/(kg*m)"
      } else if (Fonction == "ls"){
        data$unite <- "kJ/m"
      } else if (Fonction == "h"){
        data$unite <- "cal/km"
      }
    }
    total <- cbind(sf_dl,data)

    total$fonction <- Fonction
    total$mouvements <- Mouvement
    total$vitesse <- Vitesse
    total$poids_marcheur <- Poids_du_Marcheur
    total$poids_transport <- Poids_Transporte
    Reseau_LCP <- total
    st_crs(Reseau_LCP) <- origin_crs
  } else {
    # Handle the case where r$LCPs.netw.merged is NULL
    Reseau_LCP <- NULL
    print("r$LCPs.netw.merged is NULL, so no SpatialLinesDataFrame was created.")
  }
  
} else {
  if (!is.null(r$LCPs.netw.neigh.merged)) {
    sf_dl = st_as_sf(r$LCPs.netw.neigh.merged)
    # Définition du SCR pour les éléments de sortie s'il ce n'est pas déjà le cas
    if (is.na(st_crs(sf_dl))) {
      sf_dl <- st_set_crs(sf_dl, SCR)
    }

    sf_dl$longueur <- st_length(sf_dl)

    values<-list()

    if (Fonction %in% l_fonction_t){
      n=1
      for (i in 1:nrow(r$cost.matrix.hrs)) {
        val=10000000000
        for (j in 1:ncol(r$cost.matrix.hrs)) {
          if (r$cost.matrix.hrs[i,j]!=0 & r$cost.matrix.hrs[i,j]<val){
            val<-r$cost.matrix.hrs[i,j]}}
        values[[n]]<-val
        n<-n+1
    }
    data <- as.data.frame(do.call(rbind, values))
    colnames(data) <- "temps_h"
    data$temps_h <- as.numeric(data$temps_h)
    cout <- data$temps_h
    heures <- floor(cout)
    jours <- floor(heures/24)
    heures_2 <- floor(heures-24*jours)
    minutes <- floor((cout-heures)*60)
    hm <- paste(heures,"h",minutes,"min")
    jhm <- paste(jours,"j",heures_2,"h",minutes,"min")
    data$temps_hm <- hm
    data$temps_jhm <- jhm
    } else {
      n=1
      r$cost.matrix[is.na(r$cost.matrix)] <- 0
      for (i in 1:nrow(r$cost.matrix)) {
        val=10000000000
        for (j in 1:ncol(r$cost.matrix)) {
          if (r$cost.matrix[i,j]!=0 & r$cost.matrix[i,j]<val){
            val<-r$cost.matrix[i,j]}}
        values[[n]]<-val
        n<-n+1
      }
      data <- as.data.frame(do.call(rbind, values))
      colnames(data) <- "cout_energie"
      if (Fonction %in% l_fonction_abs){
        data$unite <- "Unité abstraite"
      } else if (Fonction %in% l_fonction_watt){
        data$unite <- "Watts"
      } else if (Fonction %in% l_fonction_J){
        data$unite <- "J/(kg*m)"
      } else if (Fonction == "ls"){
        data$unite <- "kJ/m"
      } else if (Fonction == "h"){
        data$unite <- "cal/km"
      }
    }
    total <- cbind(sf_dl,data)
    
    total$fonction <- Fonction
    total$mouvements <- Mouvement
    total$vitesse <- Vitesse
    total$poids_marcheur <- Poids_du_Marcheur
    total$poids_transport <- Poids_Transporte
    Reseau_LCP <- total
    st_crs(Reseau_LCP) <- origin_crs
  } else {
    # Handle the case where r$LCPs.netw.neigh.merged is NULL
    Reseau_LCP <- NULL
    print("r$LCPs.netw.neigh.merged is NULL, so no SpatialLinesDataFrame was created.")
  }
}

if (Type_Reseau == 'allpairs') {
  print(r$LCPs.density.perc)
  if (!is.null(r$LCPs.density.perc)) {
    acc = r$LCPs.density.perc
    sf_acc = acc
    crs(studyplot_sp)<-SCR 
    raster_cropped = mask(sf_acc, studyplot_sp)
  Raster_Densite=raster_cropped
  }
} else {
  Output_Accumulation_Coast=NULL
  print("r$LCPs.density.perc est NULL, pas de sortie de raster.")
}

print("Algorithme termine")
traceback()