##Siligites script=group
##movecost=name

# Module input
##SCR=crs
##MNT=raster
##MNT_sans_Valeurs=selection FALSE;TRUE ;
##Origine=vector point
##Destination=vector point
##Retour_Base=selection TRUE;FALSE ;
#Raster_de_Cout_Cumul=selection FALSE;TRUE ;
##Fonction=selection Tobler (h & min);Tobler hors chemin (h & min);Tobler modifiée par Marquez-Perez et al (h & min);Irmischer-Clarke (homme, sur un sentier) (h & min);Irmischer-Clarke (homme, hors sentier) (h & min);Irmischer-Clarke (femme, sur un chemin) (h & min);Irmischer-Clarke (femme, hors sentier) (h & min);Uriarte Gonzalez (h & min);Marin Arroyo (h & min);Alberti modifiée pour les excursions pastorales de recherche de nourriture (h & min);Garmy, Kaddouri, Rozenblat et Schneider (h & min);Rees (h & min);Kondo-Seino (h & min);Tripcevich (h & min);Véhicules à roues (h & min);Dépense énergétique (None);Bellavia (None);Eastman (None);Pandolf et al (Watt);Pandolf et al avec correction de decente de pente (Watt);Minetti et al (J/(kg*m));Herzog (J/(kg*m));Van Leusen (Watt);Llobera-Sluckin (kJ/m);Ardigo et al (J/(kg*m));Hare (cal/km) ;
##Interval_Isolignes=number 0
##Mouvement=enum literal 16;8;4 ;
##Vitesse=number 1.2
##Poids_du_Marcheur=number 70
##Poids_Transporte=number 0
##Barriere=optional vector
##PlotBarriere=selection FALSE;TRUE ;
##Cognitive_Slope=selection TRUE;FALSE ;

# Module output
##Raster_de_Cout=output raster
##Isolignes=output vector
##LCP=output vector
##LCP_Retour=output vector
##output_plots_to_html
##showplots


print("Verification de la presence et chargement des librairies necessaires")

# Verification for R libraries
packages <- c("sp","sf","raster","progress","movecost")
installed_packages <- packages %in% rownames(installed.packages())
if (any(installed_packages == FALSE)) {
  install.packages(packages[!installed_packages])
}
invisible(lapply(packages, library, character.only = TRUE))


# Loading libraries
library(sp)
library(sf)
library(movecost)
library(progress)
library(raster)


print("Transformation des couches en entrees")

# Recovery of the SCR starting point and transformation of QGIS layers into objects usable by R
origin_crs <- st_crs(Origine)$proj4string
origin_sp <- as(Origine, "Spatial")
destin_sp <- as(Destination, "Spatial")
studyplot_sp <- raster(MNT@file@name)


print("Verification des valeurs du raster")

# Verification for the raster's values
summary(studyplot_sp)  
any(is.na(studyplot_sp))  
any(studyplot_sp == Inf)  
studyplot_sp[is.na(studyplot_sp)] <- 0  
studyplot_sp[studyplot_sp == Inf] <- max(studyplot_sp, na.rm = TRUE)  


print("Recuperation des valeurs renseignees")

# Definion of the function to choose a response from a choice list
get_string_value <- function(val, string_map) {
    string_map[val + 1] # +1 because R indexing starts from 1
}

# Getting the fonction name
functions_names <- c("Tobler (h & min)", "Tobler hors chemin (h & min)", "Tobler modifiée par Marquez-Perez et al (h & min)", "Irmischer-Clarke (homme, sur un sentier) (h & min)", "Irmischer-Clarke (homme, hors sentier) (h & min)", "Irmischer-Clarke (femme, sur un chemin) (h & min)", "Irmischer-Clarke (femme, hors sentier) (h & min)", "Uriarte Gonzalez (h & min)", "Marin Arroyo (h & min)", "Alberti modifiée pour les excursions pastorales de recherche de nourriture (h & min)", "Garmy, Kaddouri, Rozenblat et Schneider (h & min)", "Rees (h & min)", "Kondo-Seino (h & min)", "Tripcevich (h & min)", "Véhicules à roues (h & min)", "Dépense énergétique (None)", "Bellavia (None)", "Eastman (None)", "Pandolf et al (Watt)", "Pandolf et al avec correction de decente de pente (Watt)", "Minetti et al (J/(kg*m))", "Herzog (J/(kg*m))", "Van Leusen (Watt)", "Llobera-Sluckin (kJ/m)", "Ardigo et al (J/(kg*m))", "Hare (cal/km)")
function_map <- c("t", "tofp", "mp", "icmonp", "icmoffp", "icfonp", "icfoffp", "ug", "ma", "alb", "gkrs", "r", "ks", "trp", "wcs", "ree", "b", "e", "p", "pcf", "m", "hrz", "vl", "ls", "a", "h")
Fonction <- get_string_value(Fonction, functions_names)
i <- match(Fonction, functions_names)
Fonction <- function_map[i]

Bool <- c("TRUE","FALSE")
Bool2 <- c("FALSE","TRUE")
MNT_sans_Valeurs <- get_string_value(MNT_sans_Valeurs, Bool2)
MNT_sans_Valeurs <- as.logical(MNT_sans_Valeurs)
#Raster_de_Cout_Cumul <- get_string_value(Raster_de_Cout_Cumul, Bool2)
#RCC <- as.logical(Raster_de_Cout_Cumul)
Retour_Base <- get_string_value(Retour_Base, Bool)
rb <- as.logical(Retour_Base)
Cognitive_Slope <- get_string_value(Cognitive_Slope, Bool)
Cognitive_Slope <- as.logical(Cognitive_Slope)

Mouvement<-as.integer(Mouvement)

l_fonction_t <- list("t", "tofp", "mp", "icmonp", "icmoffp", "icfonp", "icfoffp", "ug", "ma", "alb", "gkrs", "r", "ks", "trp")

if (Fonction %in% l_fonction_t){
  if (Interval_Isolignes==0){
    iso <- NULL
  } else{
    iso <- Interval_Isolignes
  }
} else {
  iso <- NULL
}

# Gestion of barrier
PlotBarriere <- as.logical(get_string_value(PlotBarriere, Bool2))
if(!PlotBarriere) {
  barrier_sp <- NULL
  Field <- NULL
} else {
  barrier_sp <- as(Barriere, "Spatial")
  Mouvement <- 8
  Field <- 0
  MNT_sans_Valeurs <- TRUE
}


print("Lancement de l'outil...")

# Launching function movecost
tryCatch({
  r <- movecost(
    dtm = studyplot_sp,
    origin = origin_sp,
    destin = destin_sp,
    plot.barrier = PlotBarriere,
    barrier = barrier_sp,
    irregular.dtm = MNT_sans_Valeurs,
    funct = Fonction,
    move = Mouvement,
    field = Field,
    cogn.slp = Cognitive_Slope,
    W = Poids_du_Marcheur,
    L = Poids_Transporte,
    V = Vitesse,
    return.base = rb,
    breaks = iso,
    oneplot = TRUE,
    export = FALSE)
},
error = function(e) {
  message(str(e))
})


print("Preparation des fichiers de sortie...")

# if (RCC == "TRUE"){
if (!is.null(r$accumulated.cost.raster)) {
  acc= r$accumulated.cost.raster
  raster <- acc
  # Définition du SCR pour les éléments de sortie s'il ce n'est pas déjà le cas
  if (is.na(crs(raster))) {
    crs(raster) <- SCR 
  }
  Raster_de_Cout=raster
}
# }


l_fonction_abs <- list("wcs", "ree", "b", "e")
l_fonction_watt <- list("p", "pcf", "vl")
l_fonction_J <- list("m", "hrz", "a")

if (!is.null(r$isolines)) {
  a1=r$isolines
  sf_object = st_as_sf(a1)
  # Définition du SCR pour les éléments de sortie s'il ce n'est pas déjà le cas
  if (is.na(st_crs(sf_object))) {
    sf_object <- st_set_crs(sf_object, SCR) 
  }

  if (Fonction %in% l_fonction_t){
    colnames(sf_object)[colnames(sf_object) == 'level'] <- 'temps_h'
    sf_object$temps_h <- as.numeric(sf_object$temps_h)
    cout <- as.numeric(sf_object$temps_h)
    heures <- floor(cout)
    jours <- floor(heures/24)
    heures_2 <- floor(heures-24*jours)
    minutes <- floor((cout-heures)*60)
    hm <- paste(heures,"h",minutes,"min")
    jhm <- paste(jours,"j",heures_2,"h",minutes,"min")
    sf_object$temps_hm <- hm
    sf_object$temps_jhm <- jhm
  } else{
    colnames(sf_object)[colnames(sf_object) == 'level'] <- 'cout_energie'
    sf_object$cout_energie <- as.numeric(sf_object$cout_energie)
    if (Fonction %in% l_fonction_abs){
      sf_object$unite <- "Unité abstraite"
    } else if (Fonction %in% l_fonction_watt){
      sf_object$unite <- "Watts"
    } else if (Fonction %in% l_fonction_J){
      sf_object$unite <- "J/(kg*m)"
    } else if (Fonction == "ls"){
      sf_object$unite <- "kJ/m"
    } else if (Fonction == "h"){
      sf_object$unite <- "cal/km"
    }
  }

  sf_object$fonction <- Fonction
  sf_object$mouvements <- Mouvement
  sf_object$vitesse <- Vitesse
  sf_object$poids_marcheur <- Poids_du_Marcheur
  sf_object$poids_transport <- Poids_Transporte
  Isolignes=sf_object
}

if (!is.null(r$LCPs)) {
  sf_dl = st_as_sf(r$LCPs)
  # Définition du SCR pour les éléments de sortie s'il ce n'est pas déjà le cas
  if (is.na(st_crs(sf_dl))) {
    sf_dl <- st_set_crs(sf_dl, SCR)
  }

  colnames(sf_dl)[colnames(sf_dl) == 'length'] <- 'longueur_km'
  sf_dl$longueur_km <- sf_dl$longueur_km/1000

  tempo <- r$dest.loc.w.cost
  if(!is.null(tempo$cost_hms)){
    cout <- tempo$cost
    sf_dl$temps_h <- cout
    heures <- floor(cout)
    jours <- floor(heures/24)
    heures_2 <- floor(heures-24*jours)
    minutes <- floor((cout-heures)*60)
    hm <- paste(heures,"h",minutes,"min")
    jhm <- paste(jours,"j",heures_2,"h",minutes,"min")
    sf_dl$temps_hm <- hm
    sf_dl$temps_jhm <- jhm
  }else{
    cout <- tempo$cost
    sf_dl$cout_energie <- cout
    if (Fonction %in% l_fonction_abs){
      sf_dl$unite <- "Unité abstraite"
    } else if (Fonction %in% l_fonction_watt){
      sf_dl$unite <- "Watts"
    } else if (Fonction %in% l_fonction_J){
      sf_dl$unite <- "J/(kg*m)"
    } else if (Fonction == "ls"){
      sf_dl$unite <- "kJ/m"
    } else if (Fonction == "h"){
      sf_dl$unite <- "cal/km"
    }
  }

  sf_dl$fonction <- Fonction
  sf_dl$mouvements <- Mouvement
  sf_dl$vitesse <- Vitesse
  sf_dl$poids_marcheur <- Poids_du_Marcheur
  sf_dl$poids_transport <- Poids_Transporte
  LCP=sf_dl
}

if (!is.null(r$LCPs.back)) {
  sf_dl = st_as_sf(r$LCPs.back)
  if (is.na(st_crs(sf_dl))) {
    sf_dl <- st_set_crs(sf_dl, SCR)
  }

  colnames(sf_dl)[colnames(sf_dl) == 'length'] <- 'longueur_km'
  sf_dl$longueur_km <- sf_dl$longueur_km/1000

  tempo <- r$dest.loc.w.cost
  if(!is.null(tempo$cost_hms)){
    cout <- tempo$cost
    sf_dl$temps_h <- cout
    heures <- floor(cout)
    jours <- floor(heures/24)
    heures_2 <- floor(heures-24*jours)
    minutes <- floor((cout-heures)*60)
    hm <- paste(heures,"h",minutes,"min")
    jhm <- paste(jours,"j",heures_2,"h",minutes,"min")
    sf_dl$temps_hm <- hm
    sf_dl$temps_jhm <- jhm
  }else{
    cout <- tempo$cost
    sf_dl$cout_energie <- cout
    if (Fonction %in% l_fonction_abs){
      sf_dl$unite <- "Unité abstraite"
    } else if (Fonction %in% l_fonction_watt){
      sf_dl$unite <- "Watts"
    } else if (Fonction %in% l_fonction_J){
      sf_dl$unite <- "J/(kg*m)"
    } else if (Fonction == "ls"){
      sf_dl$unite <- "kJ/m"
    } else if (Fonction == "h"){
      sf_dl$unite <- "cal/km"
    }
  }

  sf_dl$fonction <- Fonction
  sf_dl$mouvements <- Mouvement
  sf_dl$vitesse <- Vitesse
  sf_dl$poids_marcheur <- Poids_du_Marcheur
  sf_dl$poids_transport <- Poids_Transporte
  LCP_Retour = sf_dl
} 



print("Algorithme termine")

traceback()