# -*- coding: utf-8 -*-
"""
/***************************************************************************
 SilLCP
                                 A QGIS plugin
 Plugin pour la création de LCP à partir des outils de la librairie movecost sur les bases du plugin MovecostToQGIS
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin               : 2024-06-03
        git sha             : $Format:%H$
        copyright           : (C) 2024 by Thomas ANDRE
        email               : thomas.andre.archgeo@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import shutil
import processing
import platform
from processing.core.ProcessingConfig import ProcessingConfig
from qgis import *
from qgis.PyQt import *
from qgis.core import *
from qgis.utils import *
from qgis.gui import *
from qgis.PyQt.QtGui import *
from qgis.PyQt.QtCore import *
from qgis.PyQt.QtWidgets import *
from qgis.PyQt.QtCore import *

from ..SiliciteR.Utils import ParamsR
from ..Fonctions.Utilitaires import *
from ..Fonctions.Fonctions_QGIS import *

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'SilLCP_dialog_base.ui'))


class SilLCPDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(SilLCPDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.setWindowFlags(Qt.WindowType.Window | Qt.WindowType.WindowMinimizeButtonHint | Qt.WindowType.WindowCloseButtonHint)

        # Needed to detect the closure of the plugin window
        self.finished.connect(self.on_finished)

        """Initialisation of some functions and tools"""
        self.combo_site.setFilters(QgsMapLayerProxyModel.Filter.PointLayer)
        self.combo_polygons.setFilters(QgsMapLayerProxyModel.Filter.PolygonLayer)
        self.combo_origin.setFilters(QgsMapLayerProxyModel.Filter.PointLayer)
        self.combo_nodes.setFilters(QgsMapLayerProxyModel.Filter.PointLayer)
        self.combo_star.setFilters(QgsMapLayerProxyModel.Filter.PointLayer)

        self.combo_star.setAllowEmptyLayer(True)
        self.combo_star.setCurrentIndex(0) 

        self.dossier_R.setStorageMode(QgsFileWidget.StorageMode.GetDirectory)
        self.scripts_R.setStorageMode(QgsFileWidget.StorageMode.GetDirectory)
        self.librairies_R.setStorageMode(QgsFileWidget.StorageMode.GetDirectory)

        """Preparations for the first use of SiliciteR"""
        R_parameters = QSettings().value("Siligites/R_parameters", False)
        if not R_parameters:
            self.tabWidget.setTabEnabled(1,False)
            self.LCP.setEnabled(False)
            self.network.setEnabled(False)
            self.corridors.setEnabled(False)
            self.isochrones.setEnabled(False)
            self.LCP.setEnabled(False)
            self.network.setEnabled(False)
            self.corridors.setEnabled(False)
            self.isochrones.setEnabled(False)
            self.prp.setEnabled(False)
            if not ParamsR.is_windows():
                self.label_26.hide()
                self.version_64.hide()

        """Linking buttons and functions"""
        self.validation.clicked.connect(self.maj_provider)
        self.ok_site.clicked.connect(self.select_sites)
        self.combo_attribute.fieldChanged.connect(self.select_attribute)
        self.ok_1.clicked.connect(self.select_origin)
        self.ok_polygones.clicked.connect(self.select_polygones)
        self.ok_origin.clicked.connect(self.select_origin_LCP)
        self.ok_2.clicked.connect(self.select_type)
        self.full.toggled.connect(self.switch)
        self.star.toggled.connect(self.switch)
        self.ok_3.clicked.connect(self.create_lines)
        self.original.toggled.connect(self.find_sources)
        self.prp.toggled.connect(self.find_sources)
        self.detec.toggled.connect(self.find_sources)
        self.manuel.toggled.connect(self.find_sources)
        self.original.toggle()

    """Gestion of the correct loading and unloading the plugin"""
    # When the plugin start
    def showEvent(self, event: QShowEvent):
        self.recharge()
    
    # When the window is closed
    def on_finished(self):   
        self.recharge()

    # What is needed to ensure the next use of the plugin
    def recharge(self):   
        self.ok_1.setEnabled(False)
        self.combo_origin.setEnabled(False)
        self.ok_origin.setEnabled(False)
        self.p_furthest.setEnabled(False)
        self.p_centroide.setEnabled(False)
        self.p_closest.setEnabled(False)
        self.ok_2.setEnabled(False)
        self.full.setChecked(True)
        self.combo_star.setEnabled(False)
        self.combo_star.hide()


    def find_sources(self):
        """
        Preparation to show the different parameters of SiliciteR depending of the source
        """
        self.prp.setEnabled(False)
        # Verification if Processing R Provider is installed to get possible already completed parameters
        profile_home = QgsApplication.qgisSettingsDirPath()
        processingR = os.path.exists(os.path.join(profile_home, 'python', 'plugins', 'processing_r'))

        # First step, does the plugin is installed ?
        if processingR:
            from processing_r.processing.utils import RUtils
            # Second step, does the plugin is activated to access the parameters
            if ProcessingConfig.getSetting(RUtils.R_FOLDER) is not None:
                self.prp.setEnabled(True)
        
        # First case, using or checking the parameters saved inside Siligîtes
        if self.original.isChecked():
            self.dossier_R.setFilePath(ProcessingConfig.getSetting(ParamsR.DOSSIER_R))
            self.scripts_R.setFilePath(ProcessingConfig.getSetting(ParamsR.DOSSIER_SCRIPTS_R))
            self.librairies_R.setFilePath(ProcessingConfig.getSetting(ParamsR.LIBS_R))
            self.cran.setText(ProcessingConfig.getSetting(ParamsR.DEPOT_R))
            self.user_folder.setChecked(ProcessingConfig.getSetting(ParamsR.USER_LIB))
            if ParamsR.is_windows():
                self.version_64.setChecked(ProcessingConfig.getSetting(ParamsR.R64))

        # Second case, using the parameters of Processing R Provider
        if self.prp.isChecked():
            self.dossier_R.setFilePath(ProcessingConfig.getSetting(RUtils.R_FOLDER))
            self.scripts_R.setFilePath(ProcessingConfig.getSetting(RUtils.RSCRIPTS_FOLDER))
            self.librairies_R.setFilePath(ProcessingConfig.getSetting(RUtils.R_LIBS_USER))
            self.cran.setText(ProcessingConfig.getSetting(RUtils.R_REPO))
            self.user_folder.setChecked(ProcessingConfig.getSetting(RUtils.R_USE_USER_LIB))
            if ParamsR.is_windows():
                self.version_64.setChecked(ProcessingConfig.getSetting(RUtils.R_USE64))

        # Third case, using the differents functions to detect the possible paths
        if self.detec.isChecked():
            self.dossier_R.setFilePath(ParamsR.locate_r("R"))
            self.scripts_R.setFilePath(ParamsR.default_scripts_folder())
            self.librairies_R.setFilePath(ParamsR.locate_r("Rscript"))
            self.cran.setText(ParamsR.repository())
            self.user_folder.setChecked(bool(ParamsR.user_libs()))
            if ParamsR.is_windows():
                self.version_64.setChecked(bool(ParamsR.R_64()))

        # Fourth case, reset every parameters to manually completing them
        if self.manuel.isChecked():
            self.dossier_R.setFilePath("")
            self.scripts_R.setFilePath("")
            self.librairies_R.setFilePath("")
            self.cran.setText("")
            self.user_folder.setChecked(False)
            self.version_64.setChecked(False)


    def maj_provider(self):
        """
        Update provider SiliciteR parameters and allow the use of Movecost tools
        """
        # Accessing the provider of Siligîtes
        provider = QgsApplication.processingRegistry().providerById("siliciter")

        # Modifying the R folder parameter if necessary
        if self.dossier_R.filePath() != ProcessingConfig.getSetting(ParamsR.DOSSIER_R):
            ProcessingConfig.setSettingValue(ParamsR.DOSSIER_R, self.dossier_R.filePath())
            ProcessingConfig.readSettings()
            provider.refreshAlgorithms()
            QSettings().setValue("Siligites/DOSSIER_R", self.dossier_R.filePath())

        # Modifying the R scipts folder parameter if necessary
        if self.scripts_R.filePath() != ProcessingConfig.getSetting(ParamsR.DOSSIER_SCRIPTS_R):
            ProcessingConfig.setSettingValue(ParamsR.DOSSIER_SCRIPTS_R, self.scripts_R.filePath())
            ProcessingConfig.readSettings()
            provider.refreshAlgorithms()
            QSettings().setValue("Siligites/DOSSIER_SCRIPTS_R", self.scripts_R.filePath())

        # Modifying the R libraries folder parameter if necessary
        if self.librairies_R.filePath() != ProcessingConfig.getSetting(ParamsR.LIBS_R):
            ProcessingConfig.setSettingValue(ParamsR.LIBS_R, self.librairies_R.filePath())
            ProcessingConfig.readSettings()
            provider.refreshAlgorithms()
            QSettings().setValue("Siligites/LIBS_R", self.librairies_R.filePath())

        # Modifying the R libraries repository parameter if necessary
        if self.cran.text() != ProcessingConfig.getSetting(ParamsR.DEPOT_R):
            ProcessingConfig.setSettingValue(ParamsR.DEPOT_R, self.cran.text())
            ProcessingConfig.readSettings()
            provider.refreshAlgorithms()
            QSettings().setValue("Siligites/DEPOT_R", self.cran.text())

        # Modifying the choice of using the user R librairies folder if necessary
        if self.user_folder.checkState() != ProcessingConfig.getSetting(ParamsR.USER_LIB):
            ProcessingConfig.setSettingValue(ParamsR.USER_LIB, self.user_folder.checkState())
            ProcessingConfig.readSettings()
            provider.refreshAlgorithms()
            QSettings().setValue("Siligites/USER_LIB", self.user_folder.checkState())

        # Modifying the choice of using the 64bit version of Windows if necessary
        if self.version_64.checkState() != ProcessingConfig.getSetting(ParamsR.R64) and ParamsR.is_windows():
            ProcessingConfig.setSettingValue(ParamsR.R64, self.version_64.checkState())
            ProcessingConfig.readSettings()
            provider.refreshAlgorithms()
            QSettings().setValue("Siligites/R64", self.version_64.checkState())

        # Giving access to the Movecost algorithms after completion
        QSettings().setValue("Siligites/R_parameters", True)
        self.original.toggle()
        self.tabWidget.setTabEnabled(1,True)
        self.tabWidget.setCurrentIndex(1)
        self.LCP.setEnabled(True)
        self.network.setEnabled(True)
        self.corridors.setEnabled(True)
        self.isochrones.setEnabled(True)


    """
    All scripts called up during analyses
    """    
    def prepare_folder_movecost(self, name):
        try:
            self.group = QgsProject.instance().layerTreeRoot().findGroup("Sorties_{}".format(name))
            if self.group is None:
                try:
                    group = QgsProject.instance().layerTreeRoot().insertGroup(0, "Sorties_{}".format(name))
                    group.setExpanded(True)
                    iface.layerTreeView().setCurrentNode(group)
                except Exception:
                    pass
        except Exception:
                pass

    def on_movecost_pressed(self):
        self.prepare_folder_movecost("Movecost")
        self.access_Script("movecost")
        processing.execAlgorithmDialog('siliciter:movecost')

    def on_movebound_pressed(self):
        self.prepare_folder_movecost("Movebound")
        self.access_Script("movebound")
        processing.execAlgorithmDialog('siliciter:movebound')

    def on_movecorr_pressed(self):
        self.prepare_folder_movecost("Movecorr")
        self.access_Script("movecorr")
        processing.execAlgorithmDialog('siliciter:movecorr')

    def on_movealloc_pressed(self):
        self.prepare_folder_movecost("Movealloc")
        self.access_Script("movealloc")
        processing.execAlgorithmDialog('siliciter:movealloc')

    def on_movecomp_pressed(self):
        self.prepare_folder_movecost("Movecomp")
        self.access_Script("movecomp")
        processing.execAlgorithmDialog('siliciter:movecomp')

    def on_movenetw_pressed(self):
        self.prepare_folder_movecost("Movenetw")
        self.access_Script("movenetw")
        processing.execAlgorithmDialog('siliciter:movenetw')

    def on_moverank_pressed(self):
        self.prepare_folder_movecost("Moverank")
        self.access_Script("moverank")
        processing.execAlgorithmDialog('siliciter:moverank')

    def on_LCP_pressed(self):
        self.prepare_folder_movecost("Movecost")
        self.access_Script("movecost")
        processing.execAlgorithmDialog('siliciter:movecost')

    def on_network_pressed(self):
        self.prepare_folder_movecost("Movenetw")
        self.access_Script("movenetw")
        processing.execAlgorithmDialog('siliciter:movenetw')

    def on_corridors_pressed(self):
        self.prepare_folder_movecost("Movecorr")
        self.access_Script("movecorr")
        processing.execAlgorithmDialog('siliciter:movecorr')

    def on_isochrones_pressed(self):
        self.prepare_folder_movecost("Movebound")
        self.access_Script("movebound")
        processing.execAlgorithmDialog('siliciter:movebound')


    def access_Script(self, function):
        """
        Makes a copy of the scripts so that the user can use them and be sure that the scripts are up to date

        :param function: Function to copy from the internal folder to the used folder
        :type function: str

        :returns: Translated string
        :rtypes: str
        """
        # Access to the folder where R scripts are stored in the module
        a = 'SiliciteR//rscripts'
        folder = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
        # print(folder) # debugtest
        source_profile = os.path.join(folder, a)
        # print(source_profile) # debugtest

        # Access to the folder where they must be copied to make the module work
        scripts = ProcessingConfig.getSetting(ParamsR.DOSSIER_SCRIPTS_R)
        # print(rs) # debugtest

        # Check that the file exists
        if not os.path.exists(scripts):
            os.makedirs(scripts)

        # Files are copied at the time of use, allowing them to be updated automatically in the event of changes
        for filename in os.listdir(source_profile):
            # print(str(filename)) # debugtest
            if str(filename) == "{}.rsx".format(function) or str(filename) == "{}.rsx.help".format(function):
                # print(str(filename)) # debugtest
                source_file = os.path.join(source_profile, filename)
                dest_file = os.path.join(scripts, filename)
                # print(dest_file) # debugtest

                shutil.copy2(source_file, dest_file)
        # print(os.listdir(scripts)) # debugtest


    def select_sites(self):
        """
        Selection of the layer from which the origin and destination(s) of the PCLs are to be extracted
        """
        self.site_layer = Utilitaires.layer_finder(self.combo_site)
        # Définition de la source de la list déroulante des entités de la couche sélectionnée
        self.combo_attribute.setLayer(self.site_layer)

        self.ok_1.setEnabled(True)


    def select_attribute(self):
        """
        Selecting an attribute field for selecting the point of origin of LCPs
        """
        self.attribute = self.combo_attribute.currentField()
        # Changement de champ de référence pour le choix de l'entité
        self.combo_start.setLayer(self.site_layer)
        self.combo_start.setFilterExpression("")
        self.combo_start.setDisplayExpression(self.attribute)


    def select_origin(self):
        """
        Extraction of the LCP point of origin, and creation of a destination layer(s) from the remaining points
        """
        self.attribute = self.combo_attribute.currentField()
        origin = self.combo_start.feature()
        # print(origin) # debugtest

        # Preparation of a layer group to put all the layers in the same place
        group = QgsProject.instance().layerTreeRoot().findGroup("Origine-Destinations")
        if group is None:
            group = QgsProject.instance().layerTreeRoot().insertGroup(0, "Origine-Destinations")
            group.setExpanded(True)

        # Recover the SCR from the input layer to use the same in the output layers
        SCR = self.site_layer.crs().authid().replace("EPSG:", "")
        # print(self.site_layer.crs().authid().replace("EPSG:","").replace(" ","")) # debugtest

        # Creation of layers containing the start point and end point(s)
        origin_layer = Utilitaires.layer_creation("Point", SCR, origin[str(self.attribute)], self.site_layer)

        # Adding the layer to the group
        QgsProject.instance().addMapLayer(origin_layer, False)
        if group.findLayer(origin_layer.id()) is None:
            group.addLayer(origin_layer)

        destination_layer = Utilitaires.layer_creation("Point", SCR, "Destinations_{}".format(origin[str(self.attribute)]), self.site_layer)
        # Adding the layer to the group
        QgsProject.instance().addMapLayer(destination_layer, False)
        if group.findLayer(destination_layer.id()) is None:
            group.addLayer(destination_layer)

        # Access the layer data and add the selected entity
        layer_data = origin_layer.dataProvider()
        layer_data.addFeature(origin)

        # Select all the other points in the layer, then remove the start point to obtain the end point(s)
        self.site_layer.selectAll()
        Fonctions_QGIS.Selectbylocation_simple(self.site_layer, origin_layer, 3)
        features = self.site_layer.selectedFeatures()

        # Accès aux données de la couche et ajout des entités restantes
        layer_data = destination_layer.dataProvider()
        layer_data.addFeatures(features)

        # Retrait de la sélection 
        self.site_layer.removeSelection()

        # Possibility of sorting points by distance if enabled
        # self.t12km = Fonctions_QGIS.Buffer(origin_layer, 12000, False, False)
        # self.t100km = Fonctions_QGIS.Buffer(origin_layer, 100000, False, False)
        # Division of the entities in the layer according to their distance from the LCP origin
        # self.division(destination_layer)

        self.combo_attribute.setLayer(None)
        self.combo_start.setFilterExpression("1 = 0")
        self.ok_1.setEnabled(False)


    def select_polygones(self):
        """
        Select a layer of polygons to simplify into points
        """
        self.polygon_layer = Utilitaires.layer_finder(self.combo_polygons)
        self.combo_origin.setEnabled(True)
        self.ok_origin.setEnabled(True)
        self.p_centroide.setEnabled(True)
        self.ok_2.setEnabled(True)


    def select_origin_LCP(self):
        """
        Selection of the layer containing the LCP point of origin
        """
        self.origin_layer = Utilitaires.layer_finder(self.combo_origin)
        self.p_furthest.setEnabled(True)
        self.p_closest.setEnabled(True)
        self.ok_2.setEnabled(True)
    

    def select_type(self):
        """
        Create a point layer from a polygon layer (centroids, nearest and furthest points)
        """
        progress_dialog = QProgressDialog("Chargement en cours...", None, 0, 0)
        progress_dialog.setWindowModality(Qt.WindowModality.WindowModal)
        progress_dialog.setWindowTitle("Veuillez patienter")
        progress_dialog.setWindowModality(Qt.WindowModality.ApplicationModal)
        progress_dialog.setCancelButton(None)
        progress_dialog.setValue(0)
        progress_dialog.show()
        QCoreApplication.processEvents()


        # print("start") # debugtest
        # Possibilité de trier les points en function d'une distance si activée
        # # Création des tampons correspondant aux domaines proches et à la limite du domaine lointain
        # self.t12km = Fonctions_QGIS.Buffer(self.origin_layer, 12000, False, False)
        # self.t100km = Fonctions_QGIS.Buffer(self.origin_layer, 100000, False, False)

        # Check the SCRs of the two layers to ensure they are the same for the distance calculation
        SCR1 = self.polygon_layer.crs().authid().replace("EPSG:", "")

        # Check if entities are selected
        if len(self.polygon_layer.selectedFeatures()) > 0:
            selected_poly = True
            polygons = self.polygon_layer.selectedFeatures()
        else:
            selected_poly = False
            polygons = None

        count = 0
        if self.p_centroide.isChecked():
            count += 1
        if self.p_closest.isChecked():
            count += 1
        if self.p_furthest.isChecked():
            count += 1
        
        if count > 1:
            group = QgsProject.instance().layerTreeRoot().findGroup("Points_extraits_de_{}".format(self.polygon_layer.name()))
            if group is None:
                group = QgsProject.instance().layerTreeRoot().insertGroup(0, "Points_extraits_de_{}".format(self.polygon_layer.name()))
                group.setExpanded(True)


        """Creation of the centroid layer if selected"""
        if self.p_centroide.isChecked():
            # Using the QGIS centroid tool
            Centroides = Fonctions_QGIS.Centroide(self.polygon_layer,selected_poly)

            # Preventing problems for futur usage
            if self.p_furthest.isEnabled() or self.p_closest.isEnabled():
                if Centroides.crs().authid().replace("EPSG:","") != self.origin_layer.crs().authid().replace("EPSG:", ""):
                    Centroides = Fonctions_QGIS.Reprojection(Centroides, self.origin_layer.crs().authid().replace("EPSG:", ""))

            Centroides.setName("Centroides")
            if count > 1:
                QgsProject.instance().addMapLayer(Centroides, False)
                group.addLayer(Centroides)
            else:
                QgsProject.instance().addMapLayer(Centroides)

            # Possibility of sorting points by distance if enabled
            # Division of layer entities according to their distance from the LCP origin
            # self.division(Centroides)

        """Only trigger these steps if you need to go through all the elements in the layer"""
        if self.p_furthest.isChecked() or self.p_closest.isChecked():
            SCR2 = self.origin_layer.crs().authid().replace("EPSG:", "")

            # Getting the coordinates of the reference point
            if len(self.origin_layer.selectedFeatures()) == 1: 
                feat = self.origin_layer.selectedFeatures()[0]
            else:
                self.origin_layer.selectAll()
                if len(self.origin_layer.selectedFeatures()) == 1:
                    feat = self.origin_layer.selectedFeatures()[0]
                else:
                    iface.messageBar().pushMessage("Erreur:", "Plus d'un point sélectionné ou sélectionnable dans la couche", level=Qgis.MessageLevel.Critical)
                    return
            
            xa = feat.geometry().asPoint()[0]
            ya = feat.geometry().asPoint()[1]

            # Creation of a temporary layer that will receive the various entities of the layer to be progressively transformed
            tempo = Utilitaires.layer_creation("Polygon", SCR1, "tempo", self.polygon_layer)
            if count > 1:
                QgsProject.instance().addMapLayer(tempo, False)
                group.addLayer(tempo)
            else:
                QgsProject.instance().addMapLayer(tempo)
            layer_data = tempo.dataProvider()

            # Creation of lists of minimum and maximum points retained
            liste_min = []
            liste_max = []

            """Browse all the entities in the layer to be transformed"""
            if polygons == None:
                polygons = self.polygon_layer.getFeatures()

            for feat in polygons:
                # Add the entity to the temporary layer
                layer_data.addFeature(feat)

                # Transforming a polygon into a set of points 
                vertices = Fonctions_QGIS.VerticesExtraction(tempo)
                # QgsProject.instance().addMapLayer(vertices) # debugtest

                # Search for points closest to and furthest from the entity
                feat_min, feat_max = self.recup_vertices(vertices, xa, ya)

                # Addition of points identified in the final list
                liste_min.append(feat_min)
                liste_max.append(feat_max)

                # Delete the entity from the temporary layer to replace it
                layer_data.truncate()

            # Layer removed from project as unnecessary
            QgsProject.instance().removeMapLayer(tempo)
        
            """Creation of the nearest points layer if selected"""
            if self.p_furthest.isChecked():
                # Layer creation
                closest = Utilitaires.layer_creation("Point", SCR1, "Points_+_Eloignes_de_{}".format(self.origin_layer.name()), vertices)

                # Access to layer entities
                layer_data = closest.dataProvider()

                # Adding identified points to the layer
                layer_data.addFeatures(liste_max)

                # Possibility of sorting points by distance if enabled
                # Layer entities can be divided according to their distance from the LCP origin
                # self.division(closest)

                if SCR1 != SCR2:
                    reproj = Fonctions_QGIS.Reprojection(closest, SCR2)
                    reproj.setName("Points_+_Eloignes_de_{}".format(self.origin_layer.name()))
                    QgsProject.instance().removeMapLayer(closest)
                    closest = reproj

                if count > 1:
                    QgsProject.instance().addMapLayer(closest, False)
                    group.addLayer(closest)
                else:
                    QgsProject.instance().addMapLayer(closest)


            if self.p_closest.isChecked():
                # Layer creation
                furthest = Utilitaires.layer_creation("Point", SCR1, "Points_+_Proche_de_{}".format(self.origin_layer.name()), vertices)
                QgsProject.instance().addMapLayer(furthest)

                # Access to layer entities
                layer_data = furthest.dataProvider()

                # Adding identified points to the layer
                layer_data.addFeatures(liste_min)

                # Possibility of sorting points by distance if enabled
                # Layer entities can be divided according to their distance from the LCP origin
                # self.division(furthest)

                if SCR1 != SCR2:
                    reproj = Fonctions_QGIS.Reprojection(furthest, SCR2)
                    reproj.setName("Points_+_Proche_de_{}".format(self.origin_layer.name()))
                    QgsProject.instance().removeMapLayer(furthest)
                    furthest = reproj
                    
                if count > 1:
                    QgsProject.instance().addMapLayer(furthest, False)
                    group.addLayer(furthest)
                else:
                    QgsProject.instance().addMapLayer(furthest)
        
        progress_dialog.close()

        self.combo_origin.setEnabled(False)
        self.ok_origin.setEnabled(False)
        self.p_furthest.setChecked(False)
        self.p_centroide.setChecked(False)
        self.p_closest.setChecked(False)
        self.p_furthest.setEnabled(False)
        self.p_centroide.setEnabled(False)
        self.p_closest.setEnabled(False)
        self.ok_2.setEnabled(False)


    def recup_vertices(self, vertices, xa, ya):
        """
        Retrieving the nearest and furthest vertices from a point

        :param vertices: List of vertices to sort
        :type vertices: list

        :param xa: Coordinate X of the reference point
        :type xa: int or float

        :param ya: Coordinate Y of the reference point
        :type ya: int or float

        :returns: Points closest to and furthest from the origin of the LCP
        :rtypes: QgsVectorLayer
        """
        # Creating a value to initialise the search
        dist_min = 0
        dist_max = 0

        """Search all the vertices of the transformed polygon"""
        for vertex in vertices.getFeatures():
            # Retrieving vertex coordinates
            xb = vertex.geometry().asPoint()[0]
            yb = vertex.geometry().asPoint()[1]

            # Calculation of the distance separating the vertex from the origin of the LCP
            dist=(((xa - xb)**2) + ((ya - yb)**2))**0.5

            # Checking whether it is furthest or closest to the origin of the LCP
            if dist < dist_min or dist_min == 0:
                feat_min = vertex
                dist_min = dist
            if dist > dist_max or dist_max == 0:
                feat_max = vertex
                dist_max = dist

        return feat_min, feat_max


    def division(self, layer):
        """
        Add a field and divide entities in a layer according to their distance from the PCL origin
        (Not maintained, as it is specific to a study being carried out, but can be modified)
        
        :param layer: Layer to modify
        :type layer: QgsVectorLayer

        :returns: Points closest to and furthest from the origin of the LCP
        :rtypes: QgsVectorLayer
        """

        if self.p_furthest.isChecked() or self.p_closest.isChecked():
            # Deletion of columns in the attribute table that were created during the process but are no longer required 
            count = layer.fields().count()
            ind_list = list((count-1, count-2, count-3, count-4, count-5, count-6))

            # Remove multiple fields with a list of indices
            layer.dataProvider().deleteAttributes(ind_list)
            layer.updateFields()

        # # Accès aux données de la couche
        # layer_data = layer.dataProvider()
        # # Création d'un nouveau champ
        # layer_data.addAttributes([QgsField("Classe_Distance", QVariant.String)])
        # layer.updateFields()
        # # Récupération de l'id du champ pour sa complétion
        # field_idx = layer.fields().indexOf("Classe_Distance")

        # # Sélection des points dans le domaine proche (moins de 12km)
        # Fonctions_QGIS.Selectbylocation_simple(layer,self.t12km,0)
        # with edit(layer):
        #     for feature in layer.selectedFeatures():
        #         # Changement de la valeur du champ
        #         layer.changeAttributeValue(feature.id(), field_idx, "<12km")
        
        # # Sélection des points dans la zone intermédiaire (entre 12 et 100km)
        # Fonctions_QGIS.Selectbylocation_simple(layer,self.t100km,0)
        # Fonctions_QGIS.Selectbylocation_simple(layer,self.t12km,3)
        # with edit(layer):
        #     for feature in layer.selectedFeatures():
        #         # Changement de la valeur du champ
        #         layer.changeAttributeValue(feature.id(), field_idx, "12km->100km")

        # # Sélection des points dans le domaine lointain
        # layer.selectAll()
        # Fonctions_QGIS.Selectbylocation_simple(layer,self.t100km,3)
        # with edit(layer):
        #     for feature in layer.selectedFeatures():
        #         # Changement de la valeur du champ
        #         layer.changeAttributeValue(feature.id(), field_idx, ">100km")

        # Suppresion de la sélection
        layer.removeSelection()


    def switch(self):
        """
        Function to switch between modes of networks
        """
        if self.full.isChecked():
            self.label_specific.setText("Noeuds du réseau :")
            message = "Couche vecteur de points à relier avec des lignes droites"
            self.label_specific.setToolTip('<p style="white-space: pre-wrap; width:200px;">'+message+"</p>")
            self.label_specific.setWhatsThis('<p style="white-space: pre-wrap; width:200px;">'+message+"<p>")
            self.combo_nodes.setToolTip('<b>'+message+'</b>')
            self.combo_nodes.setWhatsThis('<b>'+message+'</b>')
            self.label_specific2.setText("")
            self.full.setChecked(False)
            self.combo_star.hide()
            self.combo_star.setCurrentIndex(0) 
            self.combo_star.setEnabled(False)

        if self.star.isChecked():
            self.label_specific.setText("Noeud central : ")
            message ="Couche vecteur de points avec le noeud servant de centrepour réseau de lignes droites en étoile \n" \
                    "Il est possible d'utiliser soit une couche ne contenant qu'une entité(en utilisant par exemple le premier outil de ce plugin)," \
                    "soit d'en utiliser une avec plusieurs entités, mais en sélectionnant une en avance"
            self.label_specific.setToolTip('<p style="white-space: pre-wrap; width:200px;">'+message+"</p>")
            self.label_specific.setWhatsThis('<p style="white-space: pre-wrap; width:200px;">'+message+"</p>")
            self.combo_nodes.setToolTip('<b>'+message+'<b>')
            self.combo_nodes.setWhatsThis('<b>'+message+'<b>')
            self.label_specific2.setText("Noeuds à relier : ")
            self.star.setChecked(True)
            self.combo_star.show()
            self.combo_star.setEnabled(True)
            self.combo_star.setCurrentIndex(0) 
            

    def create_lines(self):
        """
        Create a network of straight lines between several points, 
        or between one or more origins and several destinations
        """
        progress_dialog = QProgressDialog("Chargement en cours...", None, 0, 0)
        progress_dialog.setWindowModality(Qt.WindowModality.WindowModal)
        progress_dialog.setWindowTitle("Veuillez patienter")
        progress_dialog.setWindowModality(Qt.WindowModality.ApplicationModal)
        progress_dialog.setCancelButton(None)
        progress_dialog.setValue(0)
        progress_dialog.show()
        QCoreApplication.processEvents()
        
        nodes = Utilitaires.layer_finder(self.combo_nodes)
        SCR = nodes.crs().authid().replace("EPSG:","")
        new_layer=QgsVectorLayer("{}?crs=epsg:{}".format('LineString',SCR), "Reseau_droites", "memory")
        layer_data = new_layer.dataProvider()

        if self.full.isChecked():
            layer_data.addAttributes([QgsField("Id", QVariant.String),QgsField("IdCouple", QVariant.String),QgsField("IdA", QVariant.Int),QgsField("IdB", QVariant.Int),QgsField("Distance", QVariant.Double)])
            new_layer.setName("Reseau_droites_complet")

        if self.star.isChecked():
            ends = Utilitaires.layer_finder(self.combo_star)

            # Preventing problems of projections if different
            if ends.crs().authid().replace("EPSG:","") != SCR:
                ends = Fonctions_QGIS.Reprojection(ends, SCR)

            layer_data.addAttributes([QgsField("Id", QVariant.String),QgsField("Id_Fin", QVariant.Int),QgsField("Distance", QVariant.Double)])
            new_layer.setName("Reseau_droites_etoile")
        
        # Defining the layer style
        style_path = os.path.dirname(os.path.abspath(__file__)).replace('SilLCP','Styles//Liens.qml')
        new_layer.loadNamedStyle(style_path)

        new_layer.updateFields()

        # Ajout de la couche à la carte
        QgsProject.instance().addMapLayer(new_layer)

        if self.full.isChecked():
            self.full_network(nodes,new_layer)
                
        if self.star.isChecked():
            self.star_network(nodes,ends,new_layer)
        
        progress_dialog.close()


    def full_network(self, network, new_layer):
        """
        Creation of a complete network between all the nodes
        
        :param network: Layer of network nodes
        :type network: QgsVectorLayer

        :param new_layer: Layer created to host the network
        :type new_layer: QgsVectorLayer
        """
        layer_data = new_layer.dataProvider()
        list = []
        ref = []

        if len(network.selectedFeatures()) > 0:
            l = network.selectedFeatures()
        else:
            l = network.getFeatures()

        for node in l:
            list.append(node)
            ref.append(node)

        m = 0
        while len(list) != 1:
            start = list[0]
            id1 = ref.index(start)+1
            for end in list:
                id2 = ref.index(end)+1
                if end != start:
                    points = []
                    points.append(start.geometry().asPoint())
                    points.append(end.geometry().asPoint())
                    trace = QgsFeature()
                    trace.setGeometry(QgsGeometry.fromPolylineXY(points))
                    dist = trace.geometry().length()
                    layer_data.addFeature(trace)

                    if id1 < id2:
                        ids = str(id1) + "-" + str(id2)
                    else:
                        ids = str(id2) + "-" + str(id1)

                    with edit(new_layer):
                        for feat in new_layer.getFeatures():
                            attribute = feat.fields().names()
                            if feat[attribute[0]]==None:
                                new_layer.changeAttributeValue(feat.id(), 0, m)
                                new_layer.changeAttributeValue(feat.id(), 1, ids)
                                new_layer.changeAttributeValue(feat.id(), 2, id1)
                                new_layer.changeAttributeValue(feat.id(), 3, id2)
                                new_layer.changeAttributeValue(feat.id(), 4, dist/1000)
                    m += 1
            del list[0]


    def star_network(self, network, ends, new_layer):
        """
        Creation aof a star shaped network

        :param network: Layer of destination nodes
        :type network: QgsVectorLayer

        :param ends: Layer of central nodes
        :type ends: QgsVectorLayer

        :param new_layer: Layer created to host the network
        :type new_layer: QgsVectorLayer
        """
        layer_data = new_layer.dataProvider()
        listend = []
        list = []

        if len(ends.selectedFeatures()) > 0:
            l = ends.selectedFeatures()
        else:
            l = ends.getFeatures()

        for node in l:
            listend.append(node)

        if len(network.selectedFeatures()) > 0:
            l = network.selectedFeatures()
        else:
            l = network.getFeatures()

        for node in l:
            list.append(node)

        m=0
        for center in list:
            for end in listend:
                points = []
                points.append(center.geometry().asPoint())
                points.append(end.geometry().asPoint())
                trace = QgsFeature()
                trace.setGeometry(QgsGeometry.fromPolylineXY(points))
                dist = trace.geometry().length()

                if dist != 0:
                    layer_data.addFeature(trace)
                    with edit(new_layer):
                            for feat in new_layer.getFeatures():
                                attribute=feat.fields().names()
                                if feat[attribute[0]] == None:
                                    new_layer.changeAttributeValue(feat.id(), 0, m)
                                    new_layer.changeAttributeValue(feat.id(), 1, center.id()+1)
                                    new_layer.changeAttributeValue(feat.id(), 2, dist/1000)
                    m += 1

