# Siligîtes
*** 

## Présentation 
Siligîtes est une extension proposant différents outils pour l'analyse de mobilité de populations préhistoriques en lien avec l'acquisition de géoressources, et plus précisément de silicites.
L'outil a été créé en lien avec les travaux du RT SILEX. L'objectif était de proposer plusieurs outils permettant l'automatisation des étapes de traitement, et de faciliter la création et l'analyse de réseaux, notamment composés de chemins au moindre effort (Least Cost Path ou LCP).

Le module en lui-même se décompose en trois modules : Silextracteur, SilLCP et Silanalyses, ainsi qu'un provider pour accéder au langage R : SiliciteR. Ceux-ci viennent répondre aux différentes étapes de l'analyse de réseaux de sites et gîtes réalisés par le RT SILEX. 

## Prérequis :
- [QGIS](https://qgis.org/download/), au minimum version 3.28 (minimum testé)
- GRASS (fourni avec QGIS), au minimum version 7.0
- [R](https://www.r-project.org/), au minimum version 4.4

## Installation :
- Télécharger le module sous forme de .zip
- Se rendre dans Extensions > Installer/Gérer les extensions depuis QGIS
- Aller dans l'onglet Installer depuis un ZIP
- Sélectionner le .zip à partir de l'outil de recherche de fichiers
- Valider l'installation
- Choisir de télécharger les couches par défaut ou non (possibilité de le faire par la suite)
- Activer le module dans l'onglet Installées
- Vérifier si les trois outils apparaissent bien dans la liste des extensions et outils

## Descriptifs des modules et de leurs outils :

### I. Silextracteur
1. Prérequis :
* a. L'outil utilise un flux WFS du RT SILEX pour fonctionner. Celui-ci est composé de polygones représentant des formations géologiques à silicites provenant des cartes vectorisées et harmonisées à 50m du BRGM. **Une connexion internet** est donc nécessaire pour charger les différents flux au cours de l'analyse.
* b. Durant son utilisation, l'outil nécessite **une couche vecteur (polygones) d'entités administratives (ex. : départements)'**, comprenant leur nom avec une majuscule (ex. : Dordogne, Lot-et-Garonne, etc.) (certaines sont déjà fournies dans le module en lui-même), **une couche vecteur (polygones) de zones d'étude** et **une couche vecteur (points) de communes de référence**. Des couches peuvent être téléchargées au premier lancement, notamment une couche des départements et des centroïdes des communes de France, les rendant directement disponibles avec l'outil, mais d'autres couches peuvent être utilisées. Si les couches ne sont pas téléchargées (ce qu'il est possible de faire depuis le module à tout moment), une version en ligne sera chargée dans le projet si souhaité, ce qui peut ralentir pendant un temps certaines opérations.

2. Outils et fonctionnement (plus d'informations dans le module) :
* c. Le module comprend un grand outil avec plusieurs étapes. Son objectif est de permettre l'extraction de polygones de formations géologiques à silicites depuis les flux WFS du RT SILEX. Différentes étapes sont cependant nécessaires :
* d. La sélection d'une couche de zones d'extraction, comme par exemple les régions naturelles de France, un champ d'identification et une zone spécifique. 
* La sélection de la couche d'entités administratives parmi une liste de celles disponibles, ou l'utilisation d'une couche personnalisée, demandant un champ d'identification contenant **le nom des départements avec une majuscule** (ex. : Dordogne, Lot-et-Garonne, etc.). Une fois sélectionnés une première fois et le flux chargé, ces deux couches seront automatiquement retrouvées (sauf si leur nom est changé), et il est possible de simplement changer de zone d'étude, sans repasser par les étapes de sélection des entités administratives.
* e. La sélection d'une des régions couvertes par la zone d'étude, et d'un type de formation géologique à partir de l'étage géologique qui leur est associé, ou leur description.
* f. Si souhaité, l'outil propose la possibilité de restreindre la zone de sélection des formations géologiques à 10km autour d'une commune. En cochant la case correspondante, il devient alors possible de sélectionner la couche de communes, un champ d'identification et un nom **(Attention à sélectionner un champ permettant d'éviter de possibles doublons)**.
* g. Une fois les informations de sélection entrées, un nom est à définir pour la couche temporaire créée avec les entités sélectionnées (si laissé vide, un nom automatique sera créé et appliqué). Il est possible de réaliser plusieurs sélections sous le même nom, mais la couche ne doit pas être renommée avant la validation finale. Une fois celle-ci réalisée, une couche agrégée est créée à partir de la sélection et enregistrée dans une couche nommée "Couches Geologiques". 

3. Sorties :
* Une ou plusieurs couches contenant les entités sélectionnées au cours des sélections sous forme de couches temporaires contenant plusieurs entités
* Une couche rassemblant les sélections une fois agrégées, identifiées par le nom donné durant la sélection.
* **Important !!! :** Ne pas changer le nom de la sélection, ni de la couche finale, avant d'avoir validé pour l'enregistrer dans cette dernière, sinon, la couche ne sera pas enregistrée. Une fois toutes les sélections intégrées, il est possible et vivement conseillé de changer le nom de la couche finale pour lancer une nouvelle couche finale.

### II. SilLCP
1. Prérequis :
* Une partie des outils utilisent directement les fonctionnalités de QGIS, mais celles liées à la librairie Movecost nécessitent l'utilisation du langage R. Ce langage est donc à installer grâce à ce [lien](https://www.r-project.org/). L'extension comprend son propre provider, SiliciteR, développé à partir de l'extension **Processing R Provider** créée par Victor Olaya et permettant de faire le lien entre QGIS et R. Les deux extensions sont compatibles entre elles, et SiciteR est capable de récupérer les paramètres de connexions de Processing R Provider si celle-ci est téléchargée et activée.
Pour correctement mettre en place la connexion, nous vous conseillons de vous reporter à l'aide présente dans le troisième onglet du module SilLCP. Nous pouvons simplement ajouter les conseils suivants :

* Pour paramétrer Processing R Provider, se rendre dans **Préférence > Options > Traitement > Fournisseurs de traitements > R** et utiliser le guide de cette [vidéo](https://youtu.be/GyHgjcAYVW4?si=25aDVgobSHpwWBak).
* Pour récupérer les chemins de connexions, se rendre dans **la console R** ou **Rstudio**. Pour récupérer le chemin d'accès vers R, taper : *R.home()*. Pour récupérer le chemin vers les librairies R installées, taper : *.libPaths()*. Il est possible que le lien proposé soit le même dans les deux cas, notamment pour les utilisateurs de MacOS.
* Indiquer dans les champs de **R Folder** le chemin vers le dossier où le langage R est stocké, et dans celui de **User library folder** le chemin vers la bibliothèque de librairies R (**Attention !** : Bien vérifier que les chemins ne sont pas condensés, et que le dossier vers les librairies soit bien celui que vous utilisez régulièrement dans R si plusieurs sont renvoyés).

2. Outils proposés (plus d'informations dans le module) : 
* a. Un outil de division de couches de points. Son objectif est de sélectionner un point de la couche à partir d'un champ d'identification et de son nom, de l'isoler dans une couche temporaire et de rassembler les autres points dans une seconde couche. L'intérêt et de faciliter la création de LCP entre un point d'une couche et ceux restants.
* b. Un outil pour permettre la création de LCP à partir de polygones en créant des points leur correspondant. Il est possible de choisir entre la création de centroïdes ou de points les plus proches/éloignés d'un point de référence. Un champ supplémentaire est créé pour permettre de séparer les entités créées en différentes catégories de distance pour faciliter leurs analyses.
* c. Différents outils pour créer des réseaux de lignes droites, ainsi que d'autres liés à la librairie Movecost pour des réseaux de LCP. Ces derniers ont été rendus accessibles depuis QGIS en partant des scripts réalisés par Enzo Cocca et Gianmarco Alberti pour l'outil Movecost to QGIS. Les modifications apportées sont notamment pour limiter les couches de sorties à certains éléments pouvant être utilisés pour les analyses des archéologues lors de leurs questionnements autour de LCP entre différents lieux (sites et gîtes). Plus de détails ci-dessous :

3. Outils de Movecost (plus d'informations dans les pages des outils) :
* **Movecost** : Calcul de la surface des coûts cumulés en fonction de la pente et des chemins à moindre coût (LCP) et des corridors à moindre coût.
* **Movebound** : Fonction permettant de calculer les limites du coût de la marche en fonction de la pente autour d'un ou de plusieurs points. Cette fonction permet de calculer les limites du coût de la marche autour d'un ou de plusieurs points. Alors que movecost peut calculer et restituer une surface de coût cumulé et les isochrones correspondantes autour d'un point, l'utilisateur peut vouloir calculer et tracer une ou plusieurs limites correspondant à un coût de marche spécifique autour d'un ou plusieurs points, soit en termes de temps de marche, soit en termes de dépense d'énergie
* **Movecorr** : Cette fonction permet de calculer le corridor le moins coûteux entre deux points. Elle nécessite simplement un MNT en entrée et deux emplacements de points (classe VectorLayer) représentant les emplacements entre lesquels le couloir est calculé.
* **Movealloc** : Cette fonction permet d'effectuer une analyse de répartition des coûts. En utilisant un certain nombre de points d'origine, une grille de répartition des coûts est produite ; chaque cellule de la grille de répartition des coûts reçoit un nombre entier indiquant le point d'origine dont la cellule est la plus proche en termes de coût. Il va sans dire que le coût peut être conceptualisé en termes de temps de marche ou de dépense d'énergie, et qu'il est fonction de la pente du terrain. Important : Les isochrones créées par cette fonction représenteront toujours 1/10e de la surface totale calculée. Pour obtenir un visuel de ces isochrones en fonction d'un intervalle précis, un visuel sur le résultat R est disponible. Si l'objectif est d'obtenir les isochrones avec un intervalle précis autour d'un point, il est possible d'utiliser la fonction movecost. S'il s'agit d'obtenir une isochrone précise autour d'un ou plusieurs points, il est possible d'utiliser la fonction movebound.
* **Movecomp** : Cette fonction permet de calculer les LCP à l'aide de différentes fonctions de coût et de les représenter sur le même support visuel afin de les comparer
* **Movenetw** : La fonction permet de calculer les LCP entre plusieurs origines. Le résultat est un réseau de LCP reliant chaque point d'origine à tous les autres points d'origine, ou chaque point par rapport à son plus proche voisin, ainsi qu'un raster représentant la densité du réseau.
* **Moverank** : Cette fonction permet de calculer le chemin le moins coûteux entre un point d'origine et un point de destination et (plus important) de déterminer les n premiers chemins les moins coûteux entre ces deux points. L'idée sous-jacente est la suivante : étant donné deux lieux, nous pouvons calculer le chemin le moins coûteux entre eux ; mais, si nous ne tenons pas compte de ce PCL, quel chemin serait le deuxième moins coûteux ? Et si nous négligeons à notre tour les deux premiers, quel serait le troisième chemin le moins coûteux ? Le même raisonnement s'applique à tous les nièmes LCP suivants.

### III. Silanalyses
1. Prérequis :
* Pour fonctionner, une grande partie des outils proposés nécessitent l'utilisation de fonctions liées à GRASS. Ces outils sont normalement directement téléchargés avec QGIS, mais il est nécessaire de vérifier que GRASS GIS provider est bien activé (Préférence > Options > Traitement > Fournisseurs de traitements > R).

2. Outils proposés (plus d'informations dans le module) : 
* a. Un outil de fusion de morceaux de réseaux en une couche unique. Après avoir sélectionné les couches souhaitées et donné un nouveau nom, l'outil sort une couche temporaire contenant les différents arcs réindexés. Un seul lien est conservé s'il y a des doublons, mais seulement s'ils sont exactement identiques.
* b. Un outil de simplification de réseau à partir d'une valeur. En sélectionnant le champ de valeur, il est possible de choisir entre trois possibilités : une valeur de temps (avec un champ contenant **le nombre d'heures** sous forme de **nombre entier ou décimal**, ou un **champ de texte** avec dans le format **--j --h --min** ou **--h --min**), une valeur de distance (avec un champ contenant **une distance** sous forme de **nombre entier ou décimal**) ou une autre valeur (avec un champ contenant **le coût** sous forme de **nombre entier ou décimal**).
Deux couches sont créées, représentant le réseau simplifié, ainsi que les nœuds de ce dernier, représentés par leur degré de centralité (centrality) et d'intermédiarité (betweeness) par leur taille et couleur respectivement.
* c. Un outil de recherche d'itinéraire dans un réseau entre deux points, avec ou sans étapes intermédiaires. L'outil va naviguer dans le réseau pour trouver le chemin le plus court **en termes de distance** ou **en termes de temps** entre les différentes étapes sélectionnées, et sortir une couche temporaire contenant **les différentes étapes de voyage**, ainsi que **le trajet entier**. **Important ! :** L'outil nécessite que **l'extension GRASS soit activée** pour être accessible et fonctionner. De plus, l'outil ne permet pas de prendre plusieurs points de départ ou d'arrivée. Penser à n'indiquer en point de départ ou d'arrivée une couche ne contenant qu'un point sélectionné ou sélectionnable. Concernant les points intermédiaires, penser à sélectionner ceux par lesquels le chemin doit passer, sinon l'ensemble des points seront utilisés.

## Licences :
* Licence publique générale GNU publiée par la Free Software Foundation ; version 2 de la licence, ou toute version ultérieure.
* INSPIRE sans condition d'accès

## Maintainer et Auteur :
* Thomas ANDRE, diplômé du Master en Archéologie (Master Quaternaire, Préhistoire, Bioarchéologie) au Museum National d'Histoire Naturelle (MNHN), ainsi que d'un Master en Géomatique à l'Université Gustave Eiffel et Géodata Paris (ex ENSG-Géomatique).

## Source d'inspiration :
* Victor Olaya, dont l'extension Processing R Provider a été utilisée comme base pour créer notre provider pour R.
* Enzo Cocca et Gianmarco Alberti, dont la librairie R Movecost et l'extension pour QGIS éponyme ont aidé dans la réalisation du deuxième module de cette extension.

## Remerciements :
* Associations Archéo-Logis et Archéologie pour Tous.
* RT 2059 SILEX du CNRS et PCR Réseaux de lithothèques Centre-Val de Loire, en les personnes de Jean-Paul Raynal, Paul Fernandes, et Marie-France Crausillet.
* Vincent Delvigne et Christophe Tufféry pour leur temps, leur aide et leurs conseils.


git : https://gitlab.com/Thomas.Andre.Archgeo/Siligites.git