# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Siligites
                                 A QGIS plugin
 Extension pour l'étude de la proximité entre des sites archéologiques et les formations géologiques à silicites qui leur sont liées
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-06-03
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Thomas ANDRE
        email                : thomas.andre.archgeo@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .Silextracteur_dialog import SilextracteurDialog
from .SilLCP_dialog import SilLCPDialog
from .Silanalyses_dialog import SilanalysesDialog
from .Siliguide_dialog import SiliguideDialog
import os.path

import os

from qgis import *
from qgis.PyQt import *
from qgis.core import *
from qgis.utils import *
from PyQt5.QtGui import *
from PyQt5.QtCore import *
from PyQt5.QtWidgets import *
from PyQt5.QtCore import *
from processing.tools import dataobjects
import processing
from .Fonctions.Utilitaires import *
from .Fonctions.Fonctions_QGIS import *

class Siligites:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        progress_dialog = QProgressDialog("Chargement en cours...", None, 0, 0)
        progress_dialog.setWindowTitle("Veuillez patienter")
        progress_dialog.setWindowModality(Qt.ApplicationModal)
        progress_dialog.setCancelButton(None)
        progress_dialog.setMinimumDuration(0) 
        progress_dialog.show()

        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Siligites_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Siligites')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start1 = None
        self.first_start2 = None
        self.first_start3 = None

        path = os.path.dirname(os.path.abspath(__file__))
        path = path+'//Couches//'
        self.Recuperation(path, 'Departements')
        self.Recuperation(path, 'Communes')

        progress_dialog.close()


    def Recuperation(self, path, name):
        """
        Entries = path : Path to the extension's folder
                    name : layer's name
        Function = Récupération des couches des tests depuis les flux WFS
        """
        
        if not os.path.isfile(path + '{}.shp'.format(name)):
            uri = QgsDataSourceUri()
            url = 'https://services3.arcgis.com/zy1UGXGNCAGm516O/arcgis/rest/services/{}/FeatureServer/0'.format(name)
            uri.setParam('url', url)
            uri.setSrid('EPSG:2154')
            vlayer = QgsVectorLayer(uri.uri(), "{}".format("Depart") , 'arcgisfeatureserver')
            if name == "Departements":
                print(1)
                params = {'INPUT': vlayer,
                        'OUTPUT': 'TEMPORARY_OUTPUT'}
                uri= processing.run("native:savefeatures", params)['OUTPUT']    
                vlayer = QgsVectorLayer(uri, "Shape", "ogr")
                vlayer.dataProvider().deleteAttributes([3,4])
                vlayer.updateFields()
            else:
                print(2)
                pass
            params = {'INPUT': vlayer,
                      'OUTPUT': path + '{}.shp'.format(name)}
            processing.run("native:savefeatures", params)
            print("OK")


    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Siligites', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.toolBar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        self.toolBar = self.iface.addToolBar("Siligites")
        self.toolBar.setObjectName("Siligites")


        path = os.path.dirname(os.path.abspath(__file__))

        icon_path=os.path.join(path, 'Silextracteur.png')
        self.add_action(
            icon_path,
            text = self.tr(u'Silextracteur'),
            callback = self.run1,
            parent = self.iface.mainWindow())
        
        icon_path=os.path.join(path, 'SilLCP.png')
        self.add_action(
            icon_path,
            text = self.tr(u'SilLCP'),
            callback = self.run2,
            parent = self.iface.mainWindow())
        
        icon_path=os.path.join(path, 'Silanalyses.png')
        self.add_action(
            icon_path,
            text = self.tr(u'Silanalyses'),
            callback = self.run3,
            parent = self.iface.mainWindow())
        
        icon_path=os.path.join(path, 'Siliguide.png')
        self.add_action(
            icon_path,
            text = self.tr(u'Siliguide'),
            callback = self.run4,
            parent = self.iface.mainWindow())

        # will be set False in run()
        self.first_start1 = True
        self.first_start2 = True
        self.first_start3 = True
        self.first_start4 = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'Silextracteur'),
                action)
            self.iface.removePluginMenu(
                self.tr(u'SilLCP'),
                action)
            self.iface.removePluginMenu(
                self.tr(u'Silanalyses'),
                action)
            self.iface.removePluginMenu(
                self.tr(u'Siliguide'),
                action)
            self.iface.removeToolBarIcon(action)
        del self.toolBar


    def run1(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start1 == True:
            self.first_start1 = False
            self.dlg1 = SilextracteurDialog()

        # show the dialog
        self.dlg1.show()
        # Run the dialog event loop
        result = self.dlg1.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
    
    def run2(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start2 == True:
            self.first_start2 = False
            self.dlg2 = SilLCPDialog()

        # show the dialog
        self.dlg2.show()
        # Run the dialog event loop
        result = self.dlg2.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass

    def run3(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start3 == True:
            self.first_start3 = False
            self.dlg3 = SilanalysesDialog()

        # show the dialog
        self.dlg3.show()
        # Run the dialog event loop
        result = self.dlg3.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass

    def run4(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start4 == True:
            self.first_start4 = False
            self.dlg4 = SiliguideDialog()

        # show the dialog
        self.dlg4.show()
        # Run the dialog event loop
        result = self.dlg4.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
