# -*- coding: utf-8 -*-
"""
/***************************************************************************
 sigpac_downloaderDialog
                                 A QGIS plugin
 Plugin to download SIGPAC parcels
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2022-01-20
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Geomatico
        email                : info@geomatico.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import sys
from urllib.error import URLError

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets

from sigpac_downloader.use_cases.files import download_file, download_multiple, merge_files
from sigpac_downloader.use_cases.parse_dataset_url import parse_dataset_url
from sigpac_downloader.use_cases.parse_general_data import parse_general_data
from sigpac_downloader.use_cases.parse_municipality_data import parse_municipality_data
from sigpac_downloader.use_cases.parse_province_data import parse_province_data

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
pluginPath = os.path.split(os.path.dirname(__file__))[0]
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    pluginPath, 'ui', 'qgis_sigpac.ui'))

class main_window(QtWidgets.QDialog, FORM_CLASS):

    def __init__(self, parent=None):
        """Constructor."""
        super(main_window, self).__init__(parent)

        self.setupUi(self)
        self.browser = None
        self.comboBox_data.clear()
        self.comboBox_province.clear()

        self.datas_url = {}
        self.links = {}
        self.province_links = []
        self.municipalities_links = {}

        self.comboBox_data.currentIndexChanged.connect(self.get_province_url)
        self.comboBox_province.currentIndexChanged.connect(self.update_file_options_for_municipality)
        self.checkBox_download_province.toggled.connect(self.activate_massive_download)

        self.download_and_parse_general_atom()

        #self.comboBox_data.currentIndexChanged.connect(self.download_and_parse_province_atom)


        self.progressBar_massive.hide()

        self.btnDownload.clicked.connect(self.download)

        self.providerLabel.setOpenExternalLinks(True)
        self.conditionsLabel.setOpenExternalLinks(True)
        self.label.setOpenExternalLinks(True)

        self.activate_controls()


    def activate_controls(self):
        # self.btnOpenBrowser.setEnabled(False)
        self.comboBox_province.setEnabled(True)
        self.comboBox_data.setEnabled(True)
        self.checkBox_download_province.setEnabled(True)
        self.comboBox_municipality.setEnabled(True)
        self.mQgsFileWidget.setEnabled(True)
        self.btnDownload.setEnabled(True)


    def get_selected_dataset(self):
        dataset_name = self.comboBox_data.currentText()
        general_data = parse_general_data()
        dataset = next(x for x in general_data if x['title'] == dataset_name)
        return dataset

    def get_selected_province(self):
        province_name = self.comboBox_province.currentText()
        province = next(x for x in self.province_links if x['name'] == province_name)
        return province

    def get_selected_municipality(self):
        province = self.get_selected_province()
        municipality_name = self.comboBox_municipality.currentText()
        municipality = next(x for x in province['municipalities'] if x['name'] == municipality_name)
        return municipality

    def download(self):
        if self.checkBox_download_province.isChecked():
            self.download_massive()
        else:
            self.download_file()

    def download_massive(self):

        path = self.mQgsFileWidget.filePath()
        if path == '':
            self.display_warning('Debes seleccionar una carpeta de destino')
            return

        self.progressBar.setEnabled(True)
        self.progressBar_massive.show()
        self.progressBar_massive.setEnabled(True)

        province = self.get_selected_province()
        municipalities = province['municipalities']
        municipalities_urls = [municipality['href'] for municipality in municipalities]

        self.display_warning(f'Descargando...')

        try:
            downloads_path = download_multiple(municipalities_urls, path, self.update_progress, self.update_massive_progress)
            self.display_warning(f'Descarga correcta.')
        except URLError as e:
            self.display_warning('Error en la descarga', True)

        self.display_warning(f'Creando output.gpkg')

        if downloads_path:
            merge_files(downloads_path, path, self.update_massive_progress)

        self.display_warning(f'Finalizado.')
        self.progressBar.setEnabled(False)
        self.progressBar_massive.setEnabled(False)

    def download_file(self):

        path = self.mQgsFileWidget.filePath()
        municipality = self. get_selected_municipality()
        url = municipality['href']

        if url == None:
            self.display_warning('Debes seleccionar provincia y municipio')
            return

        if path == '':
            self.display_warning('Debes seleccionar una carpeta de destino')
            return

        self.display_warning(f'Descargando {os.path.basename(url)}')
        self.progressBar.setEnabled(True)
        try:
            download_file(url, path, self.update_progress)
            self.display_warning(f'Descarga correcta {os.path.basename(url)}')
        except BaseException as e:
            self.display_warning('Error en la descarga', error=True)
        self.progressBar.setEnabled(False)


    def update_progress(self, block_num, block_size, total_size):
        self.progressBar.setMaximum(total_size)
        downloaded = block_num * block_size
        if downloaded <= total_size:
            self.progressBar.setValue(downloaded)
        else:
            self.progressBar.setValue(total_size)

    def update_massive_progress(self, completed, total):
        self.progressBar_massive.setMaximum(total)
        self.progressBar_massive.setValue(completed)


    def display_warning(self, text, error=False):
        # warning: conditions not accepted
        if type(text) == str:
            self.lblInfo.setText(text)
        else:
            self.lblInfo.setText('')

        #color
        if error == True:
            self.lblInfo.setStyleSheet("color: red;")
        else:
            self.lblInfo.setStyleSheet("color: black;")

    def download_and_parse_general_atom(self) -> None:

        try:
            general_data = parse_general_data()
            for data in general_data:
                self.comboBox_data.addItem(data['title'])
        except BaseException as e:
            self.display_warning(e)


    def get_province_url(self) -> None:
        dataset = self.get_selected_dataset()
        atom_url = dataset['url']
        self.comboBox_province.clear()
        self.links = {}
        self.province_links = []

        try:
            url = parse_dataset_url(atom_url)
            provinces = parse_province_data(url)
            self.province_links = provinces

            for province in provinces:
                self.comboBox_province.addItem(province['name'])
        except BaseException as e:
            self.display_warning(e)


    def update_file_options_for_municipality(self):
        self.comboBox_municipality.clear()
        province_name = self.comboBox_province.currentText()
        if province_name:
            province = next(x for x in self.province_links if x['name'] == province_name)
            if 'municipalities' not in province:
                municipalities = parse_municipality_data(province['href'])
                province['municipalities'] = municipalities
            for municipality in province['municipalities']:
                self.comboBox_municipality.addItem(municipality['name'])

    def activate_massive_download(self):
        if self.checkBox_download_province.isChecked():
            self.comboBox_municipality.setEnabled(False)
            self.progressBar_massive.show()
        else:
            self.download_and_parse_general_atom()
            self.progressBar_massive.hide()
            self.activate_controls()



if __name__ == "__main__":
    app = QtWidgets.QApplication(sys.argv)
    dialog = main_window()
    dialog.show()
    app.exec_()
