# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Sidewalk Priority Toolkit
                                 A QGIS plugin
 Algorithms for location priority planning, particularly with sidewalks in mind.
                             -------------------
        begin                : 2025-12-22
        copyright            : (C) 2025 Mark Stosberg
        email                : mark@stosberg.com
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 This script initializes the plugin, making it known to QGIS.
"""
import os.path
from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import QgsApplication

from .sidewalk_priority_toolkit_provider import SidewalkPriorityToolkitProvider


class SidewalkPriorityToolkitPlugin:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # Initialize processing provider
        self.provider = None


    def initGui(self):
        """Initialize the plugin GUI."""
        # Register processing provider
        self.provider = SidewalkPriorityToolkitProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def unload(self):
        """Removes the plugin from QGIS."""
        # Unregister processing provider
        if self.provider:
            QgsApplication.processingRegistry().removeProvider(self.provider)


# noinspection PyPep8Naming
def classFactory(iface):  # pylint: disable=invalid-name
    """Load Sidewalk Priority Toolkit class.

    :param iface: A QGIS interface instance.
    :type iface: QgsInterface
    """
    return SidewalkPriorityToolkitPlugin(iface)

