# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Shoreline_Identificator
                                 A QGIS plugin
 This plugin is used for the identification of shore lines starting from topographic surveys

 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-08-25
        git sha              : $Format:%H$
        copyright            : (C) 2020 by University of Pisa
        email                : marco.luppichini@unifi.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import *
from qgis.PyQt.QtGui import *
from qgis.PyQt.QtWidgets import *
from qgis.core import *
# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .shoreline_dialog import Shoreline_IdentificatorDialog
import os.path
import pandas as pd
import numpy as np
from osgeo import gdal,osr
from osgeo.gdalconst import *
import sys
#from scipy.interpolate import interp1d
import shutil
import traceback

from .TaskCalculation import ExecuteShorelineCalculation
class Shoreline_Identificator:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Shoreline_Identificator_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Shoreline Identificator')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Shoreline_Identificator', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/shoreline/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Shoreline Identificator'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True
        self.png_Pisa = self.plugin_dir + os.sep + "unipi.png"
        self.icona_Unipi = QPixmap(self.png_Pisa)
        self.icona_Unipi = self.icona_Unipi.scaled(80, 80, QtCore.Qt.KeepAspectRatio)

        #self.dlg = Shoreline_IdentificatorDialog()


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Shoreline Identificator'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""
        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = Shoreline_IdentificatorDialog()
            self.dlg.Unipi.setPixmap(self.icona_Unipi)
            self.dlg.transects_layer.currentIndexChanged.connect(self.update_fields_Trans)
            self.dlg.apri.clicked.connect(lambda: self.save_file(self.dlg.output))
            self.dlg.ris.clicked.connect(lambda: self.exportCit(0))
            self.dlg.bib.clicked.connect(lambda: self.exportCit(1))
            self.dlg.text.clicked.connect(lambda: self.exportCit(2))


        self.dlg.log_attivita.clear()
        self.dlg.transects_layer.clear()
        self.dlg.DEM_raster.clear()
        # Get layers and raster layers from legend
        self.loaded_layers = [layer for layer in QgsProject.instance().mapLayers().values()]
        vector_layers, raster_layers = self.get_useful_layers()

        self.dlg.transects_layer.addItems(vector_layers)

        index = self.dlg.transects_layer.findText("transects", QtCore.Qt.MatchFixedString)
        if index >= 0:
            self.dlg.transects_layer.setCurrentIndex(index)

        self.dlg.DEM_raster.addItems(raster_layers)


        self.dlg.Execute.clicked.connect(self.Shoreline_Calculation)
        self.dlg.Cancel.clicked.connect(self.Cancel)
        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        #result = self.dlg.exec_()
        # See if OK was pressed



    def Cancel (self):
        self.dlg.reject()

    def Shoreline_Calculation(self):
        self.dlg.Tab.setCurrentIndex(2)
        self.dx = self.dlg.dxSpin.value()
        self.r2Limit = self.dlg.r2Limit.value()
        self.dem_lay_name = self.dlg.DEM_raster.currentText()
        self.dem_lay = self.raster_layers[self.dem_lay_name]
        self.transects_lay_name_ = self.dlg.transects_layer.currentText()
        self.transects_lay = self.vector_layers_list[self.transects_lay_name_][0]
        self.field_order = self.dlg.field.currentText()

        self.output = self.dlg.output.text()

        if self.output == '':
            self.dlg.log_attivita.setTextColor(QColor("red"))
            self.dlg.log_attivita.append("Select a valid output")
            self.dlg.log_attivita.setTextColor(QColor("black"))
            self.dlg.log_attivita.append("__________________________________________________________")
            return
        message = '''{'INPUT_DEM': %s,
'INPUT_TRASECTS: %s,
'ORDER_FIELD': %s,
'DX': %s,
'R2_LIMIT': %s,
'OUTPUT': %s,
}
__________________________________________________________
''' %(self.dem_lay_name,  self.transects_lay_name_,  self.field_order, self.dx, self.r2Limit,  self.output )
        self.dlg.log_attivita.append(message)
        self.dlg.log_attivita.append("Executing algorithm...")
        self.prog = self.dlg.progressBar
        self.prog.setValue(0)
        var = [self.prog, self.dx, self.r2Limit,  self.dem_lay,
            self.transects_lay, self.field_order, self.output, self.dlg]

        self.task1 = ExecuteShorelineCalculation('Shoreline calculation', var)
        #self.task1.progressChanged.connect(lambda: self.prog.setValue(self.task1.progress()))
        self.task1.taskTerminated.connect(self.FailedLoadShoreline)
        self.task1.taskCompleted.connect(self.LoadShoreline)
        QgsApplication.taskManager().addTask(self.task1)


    def get_useful_layers(self):
        """
        Purpose: iterate the map legend and return a list of line vector layers (with fields)
        and a list of raster layers.
        vector_layers is like {Layer1name:[Layer 1,[fileld1, field2, ...]], Layer2Name: [Layer 2,[fileld1, field2, ...]],...}

        """
        self.vector_layers_list = {}
        self.raster_layers = {}

        for layer in self.loaded_layers:
            fields_names = []
            #select line vector layers
            if (layer.type() == layer.VectorLayer):
                layer_info = [layer]
                provider = layer.dataProvider()
                fields = provider.fields()
                #get vector layer fields
                for field in fields:
                    fields_names.append(field.name())
                layer_info += [fields_names]
                self.vector_layers_list[unicode(layer.name())] = layer_info

            #select raster layers
            elif layer.type() == layer.RasterLayer:
                self.raster_layers[unicode(layer.name())] = layer
            else:
                pass

        vector_layers = self.vector_layers_list
        raster_layers = self.raster_layers

        return vector_layers,  raster_layers

    def update_fields_Trans(self):
        if self.dlg.transects_layer.currentText() != '':
            line_layer_fields = self.vector_layers_list[self.dlg.transects_layer.currentText()][1]

            self.dlg.field.clear()
            self.dlg.field.addItems(line_layer_fields)

    def save_file(self, linedit):
        self.path = QFileDialog.getSaveFileName(None, "Save shoreline file",
                                    "Shoreline.shp",
                                    "Shapefile (*.shp)")[0]
        linedit.setText(self.path)

    def exportCit(self, index):
        try:
            path_folder = self.plugin_dir + os.sep + "include" + os.sep + "citation"+ os.sep
            paths = {
                0:  "cit.ris",
                1: "cit.bib",
                2: "cit.xml",
            }
            path = path_folder + paths[index]

            path_out = QFileDialog.getSaveFileName(None, "Export citation",
                                                    paths[index],
                                                    "All file (*)")[0]
            if path_out != '' and  path_out != None:
                shutil.copyfile(path, path_out)
                QMessageBox.information (None, "Execution", "Exportation completed")
        except:
            QMessageBox.critical(None, "Error", "Critical Error")

    def LoadShoreline(self):
        try:
            shoreline_lay = QgsVectorLayer(self.output, "Shoreline", "ogr")
            QgsProject.instance().addMapLayer(shoreline_lay)
            self.prog.setValue(0)
            self.dlg.log_attivita.append("Complete")
        except:
            pass

    def FailedLoadShoreline(self):
        self.prog.setValue(0)
        self.dlg.log_attivita.append("Failed")

