import os

from PyQt4 import QtGui, uic
from PyQt4.QtCore import QSettings

from qgis.core import QgsCoordinateReferenceSystem

epsg4326 = QgsCoordinateReferenceSystem("EPSG:4326")

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'ui/settings.ui'))

class Settings():

    def __init__(self):
        self.readSettings()

    def readSettings(self):
        '''Load the user selected settings. The settings are retained even when
        the user quits QGIS.'''
        qset = QSettings()
        self.guessNames = int(qset.value('/ShapeTools/GuessNames', 2))
        self.maxSegLength =  float(qset.value('/ShapeTools/MaxSegLength', 20.0)) # In km
        self.maxSegments =  int(qset.value('/ShapeTools/MaxSegments', 1000))

settings = Settings()

class SettingsWidget(QtGui.QDialog, FORM_CLASS):
    '''Settings Dialog box.'''
    def __init__(self, iface, parent):
        super(SettingsWidget, self).__init__(parent)
        self.setupUi(self)
        self.iface = iface
        settings.readSettings()
        
    def accept(self):
        '''Accept the settings and save them for next time.'''
        qset = QSettings()
        qset.setValue('/ShapeTools/GuessNames', self.guessCheckBox.checkState())
        qset.setValue('/ShapeTools/MaxSegments', self.maxSegmentsSpinBox.value())
        qset.setValue('/ShapeTools/MaxSegLength', self.segLengthSpinBox.value())
        settings.readSettings()
        self.close()
        
    def showEvent(self, e):
        '''The user has selected the settings dialog box so we need to
        read the settings and update the dialog box with the previously
        selected settings.'''
        settings.readSettings()
        self.guessCheckBox.setCheckState(settings.guessNames)
        self.maxSegmentsSpinBox.setValue(settings.maxSegments)
        self.segLengthSpinBox.setValue(settings.maxSegLength)
        
