from sextante.gui.ToolboxAction import ToolboxAction
import os
from PyQt4 import QtGui
from sextante.fusion.FusionUtils import FusionUtils
import subprocess

class OpenViewerAction(ToolboxAction):

    def __init__(self):
        self.name="Open LAS viewer"
        self.group="Visualization"

    def getIcon(self):
       return QtGui.QIcon(os.path.dirname(__file__) + "/../images/tool.png")

    def execute(self):
        f = os.path.join(FusionUtils.FusionPath(), "pdq.exe")
        if os.path.exists(f):
            subprocess.Popen(f)
        else:
            QtGui.QMessageBox.critical(None, "Unable to open viewer", "The current Fusion folder does not contain the viewer executable.\nPlease check the configuration in the SEXTANTE settings dialog.")
