"""
/***************************************************************************
 Servizi Sinfi
                                 A QGIS plugin
 Plugin per accedere ai servizi Sinfi da piattaforma QGis
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-04-16
        copyright            : (C) 2025 by Infratel Italia
        email                : info@sinfi.it
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import zipfile
import requests
from datetime import datetime
from qgis.PyQt.QtCore import Qt
from qgis.PyQt.QtGui import QFont 
from ...gui.report import Report
from ..utils import sinfi_utils

class SinfiUpload():

    def __init__(self,sinfi_dockwidget,link):
        self.link = link
        self.user = None
        self.psw = None
        self.group_codes = None
        self.cap = None
        
        self.report = Report()
        self.report.setWindowFlags(Qt.WindowStaysOnTopHint|Qt.WindowCloseButtonHint)

        self.font = QFont()

        self.sinfi_dockwidget = sinfi_dockwidget
        
        self.sinfi_dockwidget.folder_widget.fileChanged.connect(lambda path: self.folder_widget_path(path))

        self.sinfi_dockwidget.verifica_file_e_crea_zip_button.clicked.connect(self.verifica_file)
    
        self.sinfi_dockwidget.seleziona_zip_widget.setFilter('*.zip')
        self.sinfi_dockwidget.seleziona_zip_widget.fileChanged.connect(lambda path: self.seleziona_zip_path(path))
        self.sinfi_dockwidget.upload_zip.clicked.connect(self.upload_zip)
        self.uploading = None
        
        self.report.save_widget.fileChanged.connect(lambda path: self.save_widget_path(path))
        self.report.crea_zip_button.clicked.connect(self.crea_zip)

        self.estensioni_file = ['.dbf','.prj','.shp','.shx']

        self.altri_layer = ['META']

        #se è presente il layer lineare deve essere presente anche il rispettivo layer puntuale
        self.layer_lineari = ['TR_AAC','TR_SAC','TR_ELE','TR_GAS','TR_TLR','TR_OLE','TR_COM']
        #per ogni layer lineare deve essere presente il rispettivo layer segmento
        self.layer_segmenti_lineari = ['_TRA_SG']

        #il layer puntuale può esistere anche senza rispettivo layer lineare
        self.layer_puntuali = ['ND_AAC','ND_SAC','ND_ELE','ND_GAS','ND_TLR','ND_OLE','ND_COM']
        #per ogni layer puntuale deve esistere il rispettivo dbf ty
        self.layer_tipo_punti = ['_TY.dbf']

        #per ognuno di questi elementi devono esistere i corrispettivi 4 file
        self.layer_infr_rt = ['INFR_RT_ESTENSIONE','INFR_RT_ESTENSIONE_L','INFR_RT_ESTENSIONE_P']
        #se esiste almeno uno dei layer precedenti allora devono esistere obbligatoriamente tutti i 3 file successivi
        self.layer_infr_rt_obbligatori = ['INFR_RT.dbf','INFR_RT_INFR_RT_TR.dbf','INFR_RT_INFR_RT_TY.dbf']

        self.file_dict = None #nome_layer:[True o False per indicare se tutto ok,messaggio di successo o errore,[lista con percorsi file]]

        self.messaggio_errore = None
        self.messaggio_successo = None

        self.group_to_cap = None
    def unload(self):
        try:
            self.sinfi_dockwidget.folder_widget.fileChanged.disconnect()
            self.sinfi_dockwidget.verifica_file_e_crea_zip_button.clicked.disconnect()

            self.sinfi_dockwidget.seleziona_zip_widget.fileChanged.disconnect()
            self.sinfi_dockwidget.upload_zip.clicked.disconnect()
            self.uploading = None

            self.report.save_widget.fileChanged.disconnect()
            self.report.crea_zip_button.clicked.disconnect()
        except:
            pass

        self.sinfi_dockwidget.folder_widget.setFilePath(None)
        self.sinfi_dockwidget.seleziona_zip_widget.setFilePath(None)
        self.report.save_widget.setFilePath(None)

        self.report = None
        self.user = None
        self.psw = None
        self.group_codes = None
        self.group_to_cap = None
        
    def reset(self):
        self.sinfi_dockwidget.folder_widget.setFilePath(None)
        self.sinfi_dockwidget.seleziona_zip_widget.setFilePath(None)
        self.report.save_widget.setFilePath(None)
        
        self.user = None
        self.psw = None
        self.group_codes = None
        self.group_to_cap = None
        
    def set_user_psw(self,user,psw):
        self.user = user
        self.psw = psw

    def set_group_codes(self,group_codes):
        self.group_codes = group_codes
    
    def set_group_to_cap(self,group_to_cap):
        self.group_to_cap = group_to_cap

    def gruppo_cambiato(self,current_index):
        if not self.group_codes:
            return None
        current_group_code = self.group_codes[current_index]

        self.sinfi_dockwidget.folder_widget.setFilePath('')
        self.sinfi_dockwidget.seleziona_zip_widget.setFilePath('')
        
                
    def set_ho_capabilities(self,ho_cap):
        if ho_cap:
            self.cap = True
            self.sinfi_dockwidget.label_no_cap_upload.clear()
            self.sinfi_dockwidget.label_no_cap_upload.move(20,340)

            self.sinfi_dockwidget.folder_widget.setEnabled(True)
            self.sinfi_dockwidget.verifica_file_e_crea_zip_button.setEnabled(False)

            self.sinfi_dockwidget.seleziona_zip_widget.setEnabled(True)
            self.sinfi_dockwidget.seleziona_zip_widget.show()
            self.sinfi_dockwidget.seleziona_zip_widget.move(10,160)

            self.sinfi_dockwidget.upload_zip.setEnabled(False)
            self.sinfi_dockwidget.upload_zip.show()
            self.sinfi_dockwidget.upload_zip.move(120,200)
            
        else:
            self.cap = False
            self.sinfi_dockwidget.label_no_cap_upload.move(10,140)
            self.sinfi_dockwidget.label_no_cap_upload.setText("Utente non abilitato all'upload.")

            self.sinfi_dockwidget.folder_widget.setEnabled(True)
            self.sinfi_dockwidget.verifica_file_e_crea_zip_button.setEnabled(False)
            
            self.sinfi_dockwidget.seleziona_zip_widget.setEnabled(False)
            self.sinfi_dockwidget.seleziona_zip_widget.hide()
            self.sinfi_dockwidget.seleziona_zip_widget.move(10,185)

            self.sinfi_dockwidget.upload_zip.setEnabled(False)
            self.sinfi_dockwidget.upload_zip.hide()
            self.sinfi_dockwidget.upload_zip.move(120,225)

    def folder_widget_path(self,path):
        if os.path.isdir(path):
            self.sinfi_dockwidget.verifica_file_e_crea_zip_button.setEnabled(True)
        else:            
            self.sinfi_dockwidget.verifica_file_e_crea_zip_button.setEnabled(False)

    def seleziona_zip_path(self,path):
        if os.path.isfile(path):
            if '.zip' in path:
                self.sinfi_dockwidget.upload_zip.setEnabled(True)
            else:
                self.sinfi_dockwidget.upload_zip.setEnabled(False)
        else:
            self.sinfi_dockwidget.upload_zip.setEnabled(False)

    def save_widget_path(self,path):
        if os.path.isdir(path):
            self.report.crea_zip_button.setEnabled(True)
        else:            
            self.report.crea_zip_button.setEnabled(False)

    def verifica_file(self):
        self.file_dict = {}
        self.messaggio_errore = ''
        
        path = self.sinfi_dockwidget.folder_widget.filePath()
        if not path:
                sinfi_utils.message_creator("Attenzione","warning","Nessun percorso selezionato.                               ")
                return None
        if not os.path.isdir(path):
            if not path:
                sinfi_utils.message_creator("Attenzione","warning","Nessun percorso selezionato.                               ")
            else:
                sinfi_utils.message_creator("Attenzione","warning","Il percorso selezionato non è un percorso valido.")
            return None
        lista_file = []
        lista_path = []
        if path:
            w = os.walk(path)
            file_duplicati = None
            for (dirpath, dirnames, filenames) in w:
                if filenames:
                    for file in filenames:
                        #verifico se è un file SINFI
                        file_sinfi = ['META','TR_AAC','TR_SAC','TR_ELE','TR_GAS','TR_TLR','TR_OLE','TR_COM','ND_AAC','ND_SAC','ND_ELE','ND_GAS','ND_TLR','ND_OLE','ND_COM','INFR_RT']
                        check = False
                        for check_sinfi in file_sinfi:
                            if check_sinfi in file:
                                check = True
                                break
                        if not check:
                            continue
                        path_file = f'{dirpath}\{file}'
                        
                        if file in lista_file:
                            if not file_duplicati:
                                file_duplicati = [file]
                            else:
                                file_duplicati.append(file)
                            
                        lista_file.append(file)
                        lista_path.append(path_file)
            if file_duplicati:
                text = "I seguenti file sono presenti più volte all'interno del percorso selezionato:"
                for f in file_duplicati:
                    text = f'{text}\n{f}'
                text = text + '\nOperazione annullata!'
                
                sinfi_utils.message_creator("Attenzione","warning",text,check_upload=True)
                return None
            
            self.verifica_layer(lista_file,lista_path)
            if 'META' in list(f for f in self.file_dict.keys()):
                if not self.file_dict.get('META')[0]:
                    text = f"Il gruppo META è obbligatorio ma mancano i seguenti file:"
                    for f in self.file_dict.get('META')[3]:
                        text = f'{text}\n{f}'
                    text = text + '\nOperazione annullata!'

                    sinfi_utils.message_creator("Attenzione","warning",text,check_upload=True)
                    return None
            elif 'META' not in list(f for f in self.file_dict.keys()):
                text = f"Non è presente nessun file del gruppo META all'interno del percorso selezionato.\nOperazione annullata!"
                sinfi_utils.message_creator("Attenzione","warning",text)
                return None

            self.verifica_layer_lineari(lista_file,lista_path)

            self.verifica_layer_puntuali(lista_file,lista_path)

            self.verifica_layer_infra_rt(lista_file,lista_path)
            
            self.genera_report()

    def verifica_layer(self,lista_file,lista_path):
        
        #per ogni file verifico se esiste in lista_file
        for nome_file in self.altri_layer:
            check_no_estensione = any(nome_file in file for file in lista_file)
            if check_no_estensione:                
                #preparo la lista per il dizionario
                list_out = [True,[],[],[]] #[True o False, lista file corretti, lista path file corretti, lista file errore]
                #se il file esiste verifico che siano presenti tutti i file
                for estensione in self.estensioni_file:
                    file_con_estensione = f'{nome_file}{estensione}'
                    
                    #controllo se il file con estensione è presente in lista_file
                    index = None
                    #provo di recuperare l'indice del file con estensione e di recuperare il suo path
                    try:
                        index = lista_file.index(file_con_estensione)
                        path = lista_path[index]
                        list_out[1].append(file_con_estensione)
                        list_out[2].append(path)
                    #se non trovo l'elemento creo il messaggio di errore 
                    except:
                        list_out[0] = False
                        list_out[3].append(file_con_estensione)


                #aggiungo list_out al dizionario
                self.file_dict[nome_file] = list_out
                
                
    def verifica_layer_lineari(self,lista_file,lista_path):
        #per ogni file verifico se esiste in lista_file
        for indice_linee in range(0,len(self.layer_lineari)):
            
            nome_file = self.layer_lineari[indice_linee]
            file_tra_sg,nome_file_punti,nome_file_punti_ty = None,None,None
            check_seg, check_punti, check_punti_ty  = None,None,None

            check_no_estensione = any(nome_file in file for file in lista_file)
            if check_no_estensione:
                #se il lineare è presente deve esistere anche il corrispettivo _file_tra_sg, altrimenti errore
                for seg in self.layer_segmenti_lineari:
                    file_tra_sg = f'{nome_file}_{nome_file}{seg}'
                    
                    check_seg = any(file_tra_sg in file for file in lista_file)
                #se il lineare è presente deve esistere anche il corrispettivo puntuale, altrimenti errore
                nome_file_punti = self.layer_puntuali[indice_linee]
                
                check_punti = any(nome_file_punti in file for file in lista_file)
                #se il corrispettivo punti è presente deve esistere anche il corrispettivo TY
                
                if nome_file_punti:
                    for tipo in self.layer_tipo_punti:
                        nome_file_punti_ty = f'{nome_file_punti}_{nome_file_punti}{tipo}'
                        
                        check_punti_ty = any(nome_file_punti_ty in file for file in lista_file)

                
                #preparo la lista per il dizionario
                list_out_linee = [True,[],[],[]] #[True o False, lista file corretti, lista path file corretti, lista file errore]
                list_out_punti = [True,[],[],[]] #[True o False, lista file corretti, lista path file corretti, lista file errore]
                #se ho trovato il file seg, il file punti e il file tipo_punti
                if check_seg and check_punti and check_punti_ty:
                    
                    #se il file esiste verifico che siano presenti tutti i file
                    for estensione in self.estensioni_file:
                        file_con_estensione = f'{nome_file}{estensione}'
                        
                        #controllo se il file con estensione è presente in lista_file
                        index = None
                        #provo di recuperare l'indice del file con estensione e di recuperare il suo path
                        try:
                            index = lista_file.index(file_con_estensione)
                            path = lista_path[index]
                            list_out_linee[1].append(file_con_estensione)
                            list_out_linee[2].append(path)
                        #se non trovo l'elemento creo il messaggio di errore 
                        except:
                            list_out_linee[0] = False
                            list_out_linee[3].append(file_con_estensione)
                            list_out_punti[0] = False
                            list_out_punti[3].append(file_con_estensione)
                            
                        file_tra_sg_con_estensione = f'{file_tra_sg}{estensione}'
                        
                        #controllo se il file file_tra_sg con estensione è presente in lista_file
                        index = None
                        #provo di recuperare l'indice del file file_tra_sg con estensione e di recuperare il suo path
                        try:
                            index = lista_file.index(file_tra_sg_con_estensione)
                            path = lista_path[index]
                            list_out_linee[1].append(file_tra_sg_con_estensione)
                            list_out_linee[2].append(path)
                        #se non trovo l'elemento creo il messaggio di errore 
                        except:
                            list_out_linee[0] = False
                            list_out_linee[3].append(file_tra_sg_con_estensione)
                            list_out_punti[0] = False
                            list_out_punti[3].append(file_tra_sg_con_estensione)
                            
                        file_nodi_con_estensione = f'{nome_file_punti}{estensione}'
                        
                        #controllo se il file nome_file_punti con estensione è presente in lista_file
                        index = None
                        #provo di recuperare l'indice del file nome_file_punti con estensione e di recuperare il suo path
                        try:
                            index = lista_file.index(file_nodi_con_estensione)
                            path = lista_path[index]
                            list_out_punti[1].append(file_nodi_con_estensione)
                            list_out_punti[2].append(path)
                        #se non trovo l'elemento creo il messaggio di errore 
                        except:
                            list_out_linee[0] = False
                            list_out_linee[3].append(file_nodi_con_estensione)
                            list_out_punti[0] = False
                            list_out_punti[3].append(file_nodi_con_estensione)
                  
                    #recupero anche il punti ty.dbf
                    try:
                        index_ty = lista_file.index(nome_file_punti_ty)
                        path_ty = lista_path[index_ty]
                        list_out_punti[1].append(nome_file_punti_ty)
                        list_out_punti[2].append(path_ty)
                    #se non trovo l'elemento creo il messaggio di errore 
                    except:
                        list_out_linee[0] = False
                        list_out_linee[3].append(nome_file_punti_ty)
                        list_out_punti[0] = False
                        list_out_punti[3].append(nome_file_punti_ty)
                                            
                    #aggiungo list_out_linee e list_out_punti al dizionario
                    self.file_dict[nome_file] = list_out_linee
                    self.file_dict[nome_file_punti] = list_out_punti
                    
                #se almeno uno tra file seg, file punti e file tipo_punti è falso allora genero il messaggio di errore
                else:  
                    #vado a vedere quali file mancano per il file principale 
                    for estensione in self.estensioni_file:
                        file_con_estensione = f'{nome_file}{estensione}'

                        #controllo se il file con estensione è presente in lista_file
                        index = None
                        #provo di recuperare l'indice del file con estensione e di recuperare il suo path
                        try:
                            index = lista_file.index(file_con_estensione)
                        #se non trovo l'elemento creo il messaggio di errore 
                        except:
                            list_out_linee[0] = False
                            list_out_linee[3].append(file_con_estensione)
                            list_out_punti[0] = False
                            list_out_punti[3].append(file_con_estensione)
                            
                    #vado a vedere quali file mancano per check_seg e genero il file di errore
                    for estensione in self.estensioni_file:
                        file_tra_sg_con_estensione = f'{file_tra_sg}{estensione}'
                        
                        #controllo se il file con estensione è presente in lista_file
                        index = None
                        #provo di recuperare l'indice del file con estensione e di recuperare il suo path
                        try:
                            index = lista_file.index(file_tra_sg_con_estensione)
                        #se non trovo l'elemento creo il messaggio di errore 
                        except:
                            list_out_linee[0] = False
                            list_out_linee[3].append(file_tra_sg_con_estensione)
                            list_out_punti[0] = False
                            list_out_punti[3].append(file_tra_sg_con_estensione)
                            
                    #vado a vedere quali file mancano e genero il file di errore
                    for estensione in self.estensioni_file:
                        nome_file_punti_con_estensione = f'{nome_file_punti}{estensione}'
                        
                        #controllo se il file con estensione è presente in lista_file
                        index = None
                        #provo di recuperare l'indice del file con estensione e di recuperare il suo path
                        try:
                            index = lista_file.index(nome_file_punti_con_estensione)
                        #se non trovo l'elemento creo il messaggio di errore 
                        except:
                            list_out_punti[0] = False
                            list_out_punti[3].append(nome_file_punti_con_estensione)
                            list_out_linee[0] = False
                            list_out_linee[3].append(nome_file_punti_con_estensione)
                            
                    #se check_punti_ty manca aggiungo il messaggio di errore
                    if not check_punti_ty:
                        list_out_punti[0] = False
                        list_out_punti[3].append(nome_file_punti_ty)
                        list_out_linee[0] = False
                        list_out_linee[3].append(nome_file_punti_ty)
                        
                    #aggiungo list_out_linee e list_out_punti al dizionario
                    self.file_dict[nome_file] = list_out_linee
                    self.file_dict[nome_file_punti] = list_out_punti

    def verifica_layer_puntuali(self,lista_file,lista_path):
        #per ogni file verifico se esiste in lista_file
        for indice_punti in range(0,len(self.layer_puntuali)):
            
            nome_file = self.layer_puntuali[indice_punti]
            
            if nome_file in list(self.file_dict.keys()):
                continue

            nome_file_punti_ty = None
            check_punti_ty  = None
            check_no_estensione = any(nome_file in file for file in lista_file)
            if check_no_estensione:
                #se il corrispettivo file punti è presente deve esistere anche il corrispettivo TY
                for tipo in self.layer_tipo_punti:
                    nome_file_punti_ty = f'{nome_file}_{nome_file}{tipo}'
                    check_punti_ty = any(nome_file_punti_ty in file for file in lista_file)

                #preparo la lista per il dizionario
                list_out_punti = [True,[],[],[]] #[True o False, lista file corretti, lista path file corretti, lista file errore]
                #se ho trovato il file tipo_punti
                if check_punti_ty:
                    #se il file esiste verifico che siano presenti tutti i file
                    for estensione in self.estensioni_file:
                        file_con_estensione = f'{nome_file}{estensione}'
                        
                        #controllo se il file con estensione è presente in lista_file
                        index = None
                        #provo di recuperare l'indice del file con estensione e di recuperare il suo path
                        try:
                            index = lista_file.index(file_con_estensione)
                            path = lista_path[index]
                            list_out_punti[1].append(file_con_estensione)
                            list_out_punti[2].append(path)
                        #se non trovo l'elemento creo il messaggio di errore 
                        except:
                            list_out_punti[0] = False
                            list_out_punti[3].append(file_con_estensione)
                            
                    #recupero anche il punti ty.dbf
                    try:
                        index_ty = lista_file.index(nome_file_punti_ty)
                        path_ty = lista_path[index_ty]
                        list_out_punti[1].append(nome_file_punti_ty)
                        list_out_punti[2].append(path_ty)
                    #se non trovo l'elemento creo il messaggio di errore 
                    except:
                        list_out_punti[0] = False
                        list_out_punti[3].append(nome_file_punti_ty)
                        
                    #aggiungo list_out_linee e list_out_punti al dizionario
                    self.file_dict[nome_file] = list_out_punti
                #se almeno uno tra file seg, file punti e file tipo_punti è falso allora genero il messaggio di errore
                else:  
                    #vado a vedere quali file mancano per il file principale 
                    for estensione in self.estensioni_file:
                        file_con_estensione = f'{nome_file}{estensione}'
                        
                        #controllo se il file con estensione è presente in lista_file
                        index = None
                        #provo di recuperare l'indice del file con estensione e di recuperare il suo path
                        try:
                            index = lista_file.index(file_con_estensione)
                        #se non trovo l'elemento creo il messaggio di errore 
                        except:
                            list_out_punti[0] = False
                            list_out_punti[3].append(file_con_estensione)
                            
                    #se check_punti_ty manca aggiungo il messaggio di errore
                    if not check_punti_ty:
                        list_out_punti[0] = False
                        list_out_punti[3].append(nome_file_punti_ty)
                        
                    #aggiungo list_out_linee e list_out_punti al dizionario
                    self.file_dict[nome_file] = list_out_punti

    def verifica_layer_infra_rt(self,lista_file,lista_path):
        
        list_out_infr_rt = [True,[],[],[]] #[True o False, lista file corretti, lista path file corretti, lista file errore]
        infr_rt_non_presenti = ''
        #effettuo un check preliminare per gli infr_rt obbligatori
        for indice_infr_rt in range(0,len(self.layer_infr_rt_obbligatori)):
            nome_file_infr_rt = self.layer_infr_rt_obbligatori[indice_infr_rt]
            
            #if any(nome_file_infr_rt in file for file in lista_file):
            try:
                index = lista_file.index(nome_file_infr_rt)
                path = lista_path[index]
                list_out_infr_rt[1].append(nome_file_infr_rt)
                list_out_infr_rt[2].append(path)
            #se non trovo l'elemento creo il messaggio di errore 
            except:
                list_out_infr_rt[0] = False
                list_out_infr_rt[3].append(nome_file_infr_rt)
                
                if not infr_rt_non_presenti:
                    infr_rt_non_presenti = f'{nome_file_infr_rt}'
                else:
                    infr_rt_non_presenti = f'<br>{nome_file_infr_rt}'
                    
        #per ogni file verifico se esiste in lista_file
        for indice_infr_rt in range(0,len(self.layer_infr_rt)):
            
            nome_file = self.layer_infr_rt[indice_infr_rt]
            
            check_no_estensione = any(f'{nome_file}.' in file for file in lista_file)
            if check_no_estensione:
                #visto che abbiamo trovato almeno un'occorrenza aggiungo anche list_out_infr_rt al dizionario se non è già presente
                if 'INFR_RT' not in list(self.file_dict.keys()):
                    self.file_dict['INFR_RT'] = list_out_infr_rt
                
                #preparo la lista per il dizionario
                list_out = [True,[],[],[]] #[True o False, lista file corretti, lista path file corretti, lista file errore]
                #se il file esiste verifico che siano presenti tutti i file
                for estensione in self.estensioni_file:
                    file_con_estensione = f'{nome_file}{estensione}'
                    
                    #controllo se il file con estensione è presente in lista_file
                    index = None
                    #provo di recuperare l'indice del file con estensione e di recuperare il suo path
                    try:
                        index = lista_file.index(file_con_estensione)
                        path = lista_path[index]
                        list_out[1].append(file_con_estensione)
                        list_out[2].append(path)
                    #se non trovo l'elemento creo il messaggio di errore 
                    except:
                        list_out[0] = False
                        list_out[3].append(file_con_estensione)
                        
                #se list_out_infr_rt[0] è False e list_out[0] è True allora lo sovrascrivo a False e inserisco il messaggio di errore
                
                if not list_out_infr_rt[0]:
                    if list_out[0]:
                        list_out[0] = False
                        list_out[3] = list_out_infr_rt[3]
                    else:
                        temp_list_out_infr_rt = list_out_infr_rt[3]
                        temp_list_out_infr_rt.extend(list_out[3])
                        list_out[3] = temp_list_out_infr_rt
                
                self.file_dict[nome_file] = list_out
                
    def genera_report(self):
        self.report.textBrowser_errori.clear()
        self.report.textBrowser_successo.clear()
        self.report.save_widget.setEnabled(False)
        self.report.crea_zip_button.setEnabled(False)
        
        check_shape_sinfi = False
        check_text_browser_errori = False

        for k,v in list(self.file_dict.items()):
            
            if k != 'META' and v[0]:
                check_shape_sinfi = True
            if not v[0]:
                self.font.setBold(True)
                self.report.textBrowser_errori.setCurrentFont(self.font)
                self.report.textBrowser_errori.insertPlainText(f'{k}')
                self.font.setBold(False)
                self.report.textBrowser_errori.setCurrentFont(self.font)
                v[3].sort()
                for i in v[3]:
                    self.report.textBrowser_errori.append(f' -File {i} non presente')
                self.report.textBrowser_errori.insertPlainText(f'\n')
                if not check_text_browser_errori:
                    check_text_browser_errori = True
            else:
                if v[1]:
                    self.font.setBold(True)
                    self.report.textBrowser_successo.setCurrentFont(self.font)
                    self.report.textBrowser_successo.insertPlainText(f'{k}')
                    self.font.setBold(False)
                    self.report.textBrowser_successo.setCurrentFont(self.font)
                    v[1].sort()
                    for i in v[1]:
                        self.report.textBrowser_successo.append(f' -File {i}')
                    self.report.textBrowser_successo.insertPlainText(f'\n')

        error_cursor = self.report.textBrowser_errori.textCursor()
        error_pos = error_cursor.position()
        
        error_cursor.setPosition(0)
        self.report.textBrowser_errori.setTextCursor(error_cursor)

        ok_cursor = self.report.textBrowser_successo.textCursor()
        ok_pos = ok_cursor.position()
        
        ok_cursor.setPosition(0)
        self.report.textBrowser_successo.setTextCursor(ok_cursor)
        

        if check_shape_sinfi:
            self.report.save_widget.setEnabled(True)
            self.report.tab_report.setTabVisible(1,True)
        else:
            self.report.tab_report.setTabVisible(1,False)
            sinfi_utils.message_creator("Attenzione","warning",
                "Nel percorso selezionato non sono presenti gruppi conformi alle specifiche SINFI ad eccezione del gruppo META.\nNon sarà possibile creare il pacchetto .zip!")
            
        self.report.tab_report.setCurrentIndex(0)
        self.report.save_widget.setFilePath(None)

        self.report.crea_zip_button.setEnabled(check_shape_sinfi)

        if not check_shape_sinfi and not check_text_browser_errori:
            pass
        else:
            self.report.show()
       
    def crea_zip(self):
        save_widget_path = self.report.save_widget.filePath()
        if not os.path.isdir(save_widget_path):
            sinfi_utils.message_creator("Attenzione","warning","Il percorso selezionato non è un percorso valido.")
            return None
        
        self.report.hide()
        current_index = self.sinfi_dockwidget.cb_gruppi.currentIndex()
        #recupero il codice e il nome del gruppo
        current_group_code = self.group_codes[current_index]

        log_str = str(datetime.now()).replace(".","_").replace(":","_").replace("-","_").replace(" ","_")
        save_name = f'{current_group_code}_{log_str}.zip'
        save_path = f'{save_widget_path}\{save_name}'

        #itero sugli elementi del dizionario che sono True
        with zipfile.ZipFile(f'{save_path}', 'w') as zipMe:
            for l in [[k,v] for k,v in list(self.file_dict.items()) if v[0]]:
                
                k = l[0]
                files = l[1][2]
                #faccio un primo check per controllare che tutti i file siano ancora presenti
                file_check = True
                file_list_error = ''
                for file in files:  
                    if not os.path.isfile(file):
                        file_check = False
                        if not file_list_error:
                            file_list_error = f'{file}'
                        else:
                            file_list_error = f'{file_list_error}\n{file}'
                if not file_check:
                    sinfi_utils.message_creator("Attenzione","warning",
                        f"I file del gruppo {k} non verranno aggiunti nello zip poichè i seguenti file risultano non più disponibili:\n{file_list_error}")
                    continue

                #se tutto ok inserisco i file nello zip
                for file in files:
                    zipMe.write(f'{file}', os.path.basename(file),compress_type=zipfile.ZIP_DEFLATED)
        
        sinfi_utils.message_creator("Attenzione","warning",
            f"Operazione completata con successo!\nFile zip {save_name} generato al percorso\n{save_path}",zip_created=True)

    def upload_zip(self):
        if not self.uploading and self.cap:
            self.uploading = True
            seleziona_zip_path = self.sinfi_dockwidget.seleziona_zip_widget.filePath()
            if not seleziona_zip_path:
                sinfi_utils.message_creator("Attenzione","warning","Nessun file selezionato.                               ")
                self.uploading = False
                return None
            
            sinfi_utils.message_creator("Upload pacchetto","information","Inizio l\'operazione di Upload.                  ")
            
            if os.path.isfile(seleziona_zip_path):
                if '.zip' not in seleziona_zip_path:
                    sinfi_utils.message_creator("Attenzione","warning","Il file selezionato non è un file zip.\nOperazione annullata.")
                    self.uploading = False
                    return None
                                
                current_index = self.sinfi_dockwidget.cb_gruppi.currentIndex()
                #recupero il codice e il nome del gruppo
                current_group_code = self.group_codes[current_index]
                
                try:
                    #url per caricamento
                    url = f'https://{self.link}/sinfi_data_panel/rest/api/m2m/{current_group_code}/upload/' 
                    headers = {
                        'X-Pass': self.psw,
                        'X-User': self.user
                    }
                    files = {
                        'file_name': open(seleziona_zip_path, 'rb')
                    }
                    
                    req = requests.post(url, headers=headers, files=files)

                    if req.status_code == 200:
                        sinfi_utils.message_creator("Operazione completata","information",f"Il pacchetto zip è stato caricato con successo!\nPuoi seguire lo stato della validazione dal Sinfi Data Panel nella tua area riservata!",upload=True)
                    
                    elif req.status_code == 403:
                        sinfi_utils.message_creator("Attenzione","warning",f"{req.status_code} - Errore di autenticazione.")

                    elif req.status_code in (400,500):
                        sinfi_utils.message_creator("Attenzione","warning",sinfi_utils.traduci_status_code(req.status_code))
                    else:
                        sinfi_utils.message_creator("Attenzione","warning",f"{req.status_code} - Errore sconosciuto.")
                except FileNotFoundError:
                    sinfi_utils.message_creator("Attenzione","warning",f"Il file selezionato non è più presente al percorso indicato.\nOperazione annullata.")
                except requests.exceptions.RequestException as e:
                    sinfi_utils.message_creator("Attenzione","warning",f"Si è presentato il seguente errore durante la gestione della tua richiesta: {e}\nOperazione annullata.")
                except Exception as e:
                    sinfi_utils.message_creator("Attenzione","warning",f"Si è presentato il seguente errore durante la gestione della tua richiesta: {e}\nOperazione annullata.")
                
            else:
                sinfi_utils.message_creator("Attenzione","warning",f"Il file selezionato non è più presente al percorso indicato.\nOperazione annullata.")
            
            self.uploading = False