# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Servizi Sinfi
                                 A QGIS plugin
 Plugin per accedere ai servizi Sinfi da piattaforma QGis
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-04-16
        copyright            : (C) 2025 by Infratel Italia
        email                : info@sinfi.it
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

# =============================================================================
# 🔧 Controllo e installazione automatica delle dipendenze Python
# =============================================================================
import importlib
import os
from .moduli.utils import sinfi_utils
import sys

ext_lib_path = os.path.join(os.path.dirname(__file__), "/moduli/librerie_esterne")

if ext_lib_path not in sys.path:
    sys.path.append(ext_lib_path)

def ensure_package_installed(package_name, pip_name=None):
    """Controlla se un pacchetto è installato, altrimenti lo installa."""
    try:
        importlib.import_module(package_name)
    except ImportError:
        pip_pkg = pip_name if pip_name else package_name
        sinfi_utils.message_creator("Installazione dipendenze","information",f"Il plugin ServiziSinfi installerà automaticamente la libreria mancante: {pip_pkg}")
                    
        try:
            os.system(f'python -m pip install {pip_pkg}')
        except Exception as e:
            sinfi_utils.message_creator("Errore installazione","critical",f"Impossibile installare {pip_pkg}.\nErrore: {e}")
                    

# Elenco dipendenze richieste dal plugin
for pkg, pip_pkg in [("requests", "requests>=2.25.0"), ("cryptography","cryptography==44.0.2")]: # ("jwt", "PyJWT==2.8.0"),
    ensure_package_installed(pkg, pip_pkg)

# =============================================================================
# 🔌 Inizializzazione del plugin QGIS
# =============================================================================
# noinspection PyPep8Naming
def classFactory(iface):  # pylint: disable=invalid-name
    """Load ServiziSinfi class from file ServiziSinfi.

    :param iface: A QGIS interface instance.
    :type iface: QgsInterface
    """
    from .mainPlugin import MainPlugin
    return MainPlugin(iface)