"""
/***************************************************************************
 Servizi Sinfi
                                 A QGIS plugin
 Plugin per accedere ai servizi Sinfi da piattaforma QGis
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-04-16
        copyright            : (C) 2025 by Infratel Italia
        email                : info@sinfi.it
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.core import QgsProject,QgsRasterLayer,QgsHttpHeaders,QgsDataSourceUri,QgsRectangle,QgsCoordinateReferenceSystem
from qgis.PyQt.QtCore import QTimer

import requests,time
import xml.etree.ElementTree as ET
from urllib.parse import urlparse
from PyQt5.QtCore import QTimer

class PdndWMS():

    def __init__(self,iface,pdnd_dockwidget,login_pdnd,link_pdnd):
        self.authCfdId = None
        self.iface = iface
                
        self.link_pdnd = link_pdnd
        self.pdnd_dockwidget = pdnd_dockwidget
        self.login_pdnd = login_pdnd
        self.group_code = None
        self.minx,self.miny,self.maxx,self.maxy = None,None,None,None
        self.rect = None
        self.layer_list = ['ND_AAC','ND_COM','ND_ELE','ND_GAS','ND_OLE','ND_SAC','ND_TLR','TR_AAC','TR_COM','TR_ELE','TR_GAS','TR_OLE','TR_SAC','TR_TLR',
                           'INFR_RT_ESTENSIONE','INFR_RT_POLYGONS_ALL','INFR_RT_POLYGONS_BY_STATE','INFR_RT_POLY_BY_TY','INFR_RT_POLYGONS_BY_TR','INFR_RT_POLYGONS_BY_INFR_RT_UT',
                           'INFR_RT_ESTENSIONE_L','INFR_RT_LINES_ALL','INFR_RT_LINES_BY_STATE','INFR_RT_BY_TY','INFR_RT_LINES_BY_TR','INFR_RT_LINES_BY_INFR_RT_UT',
                           'INFR_RT_ESTENSIONE_P','INFR_RT_POINTS_ALL','INFR_RT_POINTS_BY_STATE','INFR_RT_POINT_BY_TY','INFR_RT_POINTS_BY_TR','INFR_RT_POINTS_BY_INFR_RT_UT',
                           'worksites',
                           'cartodb_basemap','osm_standard','esri_world_imagery']
        
        self.layer_list_no_stili = ['ND_AAC','ND_COM','ND_ELE','ND_GAS','ND_OLE','ND_SAC','ND_TLR','TR_AAC','TR_COM','TR_ELE','TR_GAS','TR_OLE','TR_SAC','TR_TLR',
                           'INFR_RT_ESTENSIONE','INFR_RT_ESTENSIONE_L','INFR_RT_ESTENSIONE_P','worksites']
        
        self.stili_INFR_RT_ESTENSIONE = ['INFR_RT_POLYGONS_ALL','INFR_RT_POLYGONS_BY_STATE','INFR_RT_POLY_BY_TY','INFR_RT_POLYGONS_BY_TR','INFR_RT_POLYGONS_BY_INFR_RT_UT']
        self.stili_nome_layer_INFR_RT_ESTENSIONE = ['Aree:Default','Aree:Stato infrastruttura','Aree:Tipo di infrastruttura','Aree:Tipo di rete alloggiata','Aree:Utilizzabilità infrastruttura']
        
        self.stili_INFR_RT_ESTENSIONE_L = ['INFR_RT_LINES_ALL','INFR_RT_LINES_BY_STATE','INFR_RT_BY_TY','INFR_RT_LINES_BY_TR','INFR_RT_LINES_BY_INFR_RT_UT']
        self.stili_nome_layer_INFR_RT_ESTENSIONE_L = ['Tratte:Default','Tratte:Stato infrastruttura','Tratte:Tipo di infrastruttura','Tratte:Tipo di rete alloggiata','Tratte:Utilizzabilità infrastruttura']

        self.stili_INFR_RT_ESTENSIONE_P = ['INFR_RT_POINTS_ALL','INFR_RT_POINTS_BY_STATE','INFR_RT_POINT_BY_TY','INFR_RT_POINTS_BY_TR','INFR_RT_POINTS_BY_INFR_RT_UT']
        self.stili_nome_layer_INFR_RT_ESTENSIONE_P = ['Nodi:Default','Nodi:Stato infrastruttura','Nodi:Tipo di infrastruttura','Nodi:Tipo di rete alloggiata','Nodi:Utilizzabilità infrastruttura']

        self.layer_puntuali = ['ND_AAC','ND_COM','ND_ELE','ND_GAS','ND_OLE','ND_SAC','ND_TLR','INFR_RT_POINTS_ALL','INFR_RT_POINTS_BY_STATE','INFR_RT_POINT_BY_TY','INFR_RT_POINTS_BY_TR','INFR_RT_POINTS_BY_INFR_RT_UT']
        self.layer_lineari = ['TR_AAC','TR_COM','TR_ELE','TR_GAS','TR_OLE','TR_SAC','TR_TLR','INFR_RT_LINES_ALL','INFR_RT_LINES_BY_STATE','INFR_RT_BY_TY','INFR_RT_LINES_BY_TR','INFR_RT_LINES_BY_INFR_RT_UT','worksites']
        
        self.sfondi = ['cartodb_basemap','osm_standard','esri_world_imagery']
        self.dict_sfondi = {'cartodb_basemap' : ["Cartografia chiara (CartoDB)","http://a.basemaps.cartocdn.com/light_all/%7Bz%7D/%7Bx%7D/%7By%7D.png&zmin=0&zmax=20"],
                            'osm_standard' : ["Mappa stradale (OpenStreetMap)","http://tile.openstreetmap.org/%7Bz%7D/%7Bx%7D/%7By%7D.png&zmin=0&zmax=19"],
                            'esri_world_imagery' : ["Immagine satellitare (Esri)","https://server.arcgisonline.com/ArcGIS/rest/services/World_Imagery/MapServer/tile/%7Bz%7D/%7By%7D/%7Bx%7D&zmin=0&zmax=20"]}

        self.dict_wms = None
        
        self.dict_stili_ND_TR_worksite = {
            "ND_AAC" : ["AAC_POINTS_ALL","Default"],
            "ND_COM" : ["COM_POINTS_ALL","Default"],
            "ND_ELE" : ["ELE_POINTS_ALL","Default"],
            "ND_GAS" : ["GAS_POINTS_ALL","Default"],
            "ND_OLE" : ["OLE_POINTS_ALL","Default"],
            "ND_SAC" : ["SAC_POINTS_ALL","Default"],
            "ND_TLR" : ["TLR_POINTS_ALL","Default"],
            "TR_AAC" : ["AAC_LINES_ALL","Default"],
            "TR_COM" : ["COM_LINES_ALL","Default"],
            "TR_ELE" : ["ELE_LINES_ALL","Default"],
            "TR_GAS" : ["GAS_LINES_ALL","Default"],
            "TR_OLE" : ["OLE_LINES_ALL","Default"],
            "TR_SAC" : ["SAC_LINES_ALL","Default"],
            "TR_TLR" : ["TLR_LINES_ALL","Default"],
            "worksites" : ["WORKSITE_BY_CATEGORY","Categoria di cantiere"]
        }


        self.pdnd_dockwidget.ND_AAC_cb.stateChanged.connect(lambda state: self.checcato(state,'ND_AAC',True))
        self.pdnd_dockwidget.ND_COM_cb.stateChanged.connect(lambda state: self.checcato(state,'ND_COM',True))
        self.pdnd_dockwidget.ND_ELE_cb.stateChanged.connect(lambda state: self.checcato(state,'ND_ELE',True))
        self.pdnd_dockwidget.ND_GAS_cb.stateChanged.connect(lambda state: self.checcato(state,'ND_GAS',True))
        self.pdnd_dockwidget.ND_OLE_cb.stateChanged.connect(lambda state: self.checcato(state,'ND_OLE',True))
        self.pdnd_dockwidget.ND_SAC_cb.stateChanged.connect(lambda state: self.checcato(state,'ND_SAC',True))
        self.pdnd_dockwidget.ND_TLR_cb.stateChanged.connect(lambda state: self.checcato(state,'ND_TLR',True))
        self.pdnd_dockwidget.TR_AAC_cb.stateChanged.connect(lambda state: self.checcato(state,'TR_AAC',True))
        self.pdnd_dockwidget.TR_COM_cb.stateChanged.connect(lambda state: self.checcato(state,'TR_COM',True))
        self.pdnd_dockwidget.TR_ELE_cb.stateChanged.connect(lambda state: self.checcato(state,'TR_ELE',True))
        self.pdnd_dockwidget.TR_GAS_cb.stateChanged.connect(lambda state: self.checcato(state,'TR_GAS',True))
        self.pdnd_dockwidget.TR_OLE_cb.stateChanged.connect(lambda state: self.checcato(state,'TR_OLE',True))
        self.pdnd_dockwidget.TR_SAC_cb.stateChanged.connect(lambda state: self.checcato(state,'TR_SAC',True))
        self.pdnd_dockwidget.TR_TLR_cb.stateChanged.connect(lambda state: self.checcato(state,'TR_TLR',True))

        self.pdnd_dockwidget.INFR_RT_ESTENSIONE_cb.stateChanged.connect(lambda state: self.abilita_infr_rt(state,'INFR_RT_ESTENSIONE',self.pdnd_dockwidget.stili_INFR_RT_ESTENSIONE_cb,self.stili_INFR_RT_ESTENSIONE,self.stili_nome_layer_INFR_RT_ESTENSIONE))
        self.pdnd_dockwidget.stili_INFR_RT_ESTENSIONE_cb.currentIndexChanged.connect(lambda index: self.checcato_con_stile(index,'INFR_RT_ESTENSIONE',self.stili_INFR_RT_ESTENSIONE,self.stili_nome_layer_INFR_RT_ESTENSIONE))
        
        self.pdnd_dockwidget.INFR_RT_ESTENSIONE_L_cb.stateChanged.connect(lambda state: self.abilita_infr_rt(state,'INFR_RT_ESTENSIONE_L',self.pdnd_dockwidget.stili_INFR_RT_ESTENSIONE_L_cb,self.stili_INFR_RT_ESTENSIONE_L,self.stili_nome_layer_INFR_RT_ESTENSIONE_L))
        self.pdnd_dockwidget.stili_INFR_RT_ESTENSIONE_L_cb.currentIndexChanged.connect(lambda index: self.checcato_con_stile(index,'INFR_RT_ESTENSIONE_L',self.stili_INFR_RT_ESTENSIONE_L,self.stili_nome_layer_INFR_RT_ESTENSIONE_L))
        
        self.pdnd_dockwidget.INFR_RT_ESTENSIONE_P_cb.stateChanged.connect(lambda state: self.abilita_infr_rt(state,'INFR_RT_ESTENSIONE_P',self.pdnd_dockwidget.stili_INFR_RT_ESTENSIONE_P_cb,self.stili_INFR_RT_ESTENSIONE_P,self.stili_nome_layer_INFR_RT_ESTENSIONE_P))
        self.pdnd_dockwidget.stili_INFR_RT_ESTENSIONE_P_cb.currentIndexChanged.connect(lambda index: self.checcato_con_stile(index,'INFR_RT_ESTENSIONE_P',self.stili_INFR_RT_ESTENSIONE_P,self.stili_nome_layer_INFR_RT_ESTENSIONE_P))
        
        self.pdnd_dockwidget.worksites_cb.stateChanged.connect(lambda state: self.checcato(state,'worksites',True))

        self.pdnd_dockwidget.cartodb_basemap_rb.toggled.connect(lambda state: self.checcato(state,'cartodb_basemap'))
        self.pdnd_dockwidget.osm_standard_rb.toggled.connect(lambda state: self.checcato(state,'osm_standard'))
        self.pdnd_dockwidget.esri_world_imagery_rb.toggled.connect(lambda state: self.checcato(state,'esri_world_imagery'))

        QgsProject.instance().layerRemoved.connect(self.layer_removed_listener)

        self.layer_dict = {}

        self.root = QgsProject.instance().layerTreeRoot()
        self.children_count = 0

        self.bearer = None
        self.expires = None
        self.jws = None
        self.timer = QTimer()
        self.timer.timeout.connect(self.refresh_voucher)

        self.zoom_italia = QgsRectangle(736267.1121067114,4230671.180235986, 2061748.2889822198,5957594.299513203)
        self.zoomato_italia = False

        self.zoom_mappa = False

    def set_authCfdId(self, authCfdId):
        self.authCfdId = authCfdId    
    
    def init_dict_wms(self):
        self.dict_wms = {}
        for layer in self.layer_list:
            self.dict_wms[layer] = [False,None]

    def unload(self):
        
        self.sinfi_upload = None
        self.cap = None
        self.pdnd_dockwidget.ND_AAC_cb.stateChanged.disconnect()
        self.pdnd_dockwidget.ND_COM_cb.stateChanged.disconnect()
        self.pdnd_dockwidget.ND_ELE_cb.stateChanged.disconnect()
        self.pdnd_dockwidget.ND_GAS_cb.stateChanged.disconnect()
        self.pdnd_dockwidget.ND_OLE_cb.stateChanged.disconnect()
        self.pdnd_dockwidget.ND_SAC_cb.stateChanged.disconnect()
        self.pdnd_dockwidget.ND_TLR_cb.stateChanged.disconnect()
        self.pdnd_dockwidget.TR_AAC_cb.stateChanged.disconnect()
        self.pdnd_dockwidget.TR_COM_cb.stateChanged.disconnect()
        self.pdnd_dockwidget.TR_ELE_cb.stateChanged.disconnect()
        self.pdnd_dockwidget.TR_GAS_cb.stateChanged.disconnect()
        self.pdnd_dockwidget.TR_OLE_cb.stateChanged.disconnect()
        self.pdnd_dockwidget.TR_SAC_cb.stateChanged.disconnect()
        self.pdnd_dockwidget.TR_TLR_cb.stateChanged.disconnect()
        self.pdnd_dockwidget.INFR_RT_ESTENSIONE_cb.stateChanged.disconnect()
        self.pdnd_dockwidget.stili_INFR_RT_ESTENSIONE_cb.currentIndexChanged.disconnect()

        self.pdnd_dockwidget.INFR_RT_ESTENSIONE_L_cb.stateChanged.disconnect()
        self.pdnd_dockwidget.stili_INFR_RT_ESTENSIONE_L_cb.currentIndexChanged.disconnect()

        self.pdnd_dockwidget.INFR_RT_ESTENSIONE_P_cb.stateChanged.disconnect()
        self.pdnd_dockwidget.stili_INFR_RT_ESTENSIONE_P_cb.currentIndexChanged.disconnect()

        self.pdnd_dockwidget.worksites_cb.stateChanged.disconnect()

        self.pdnd_dockwidget.cartodb_basemap_rb.toggled.disconnect()
        self.pdnd_dockwidget.osm_standard_rb.toggled.disconnect()
        self.pdnd_dockwidget.esri_world_imagery_rb.toggled.disconnect()
        
        try:
            QgsProject.instance().layerRemoved.disconnect()
        except:
            pass
        self.remove_all_wms()

        if self.group_code and self.root:
            if self.root.findGroup(f"{self.group_code}"):
                group = self.root.findGroup(f"{self.group_code}")
                if group:
                    self.root.removeChildNode(group)

        self.group_code = None
        self.root = None
        self.children_count = 0
        self.zoomato_italia = False
        self.zoom_mappa = False

    def reset (self):
        
        if self.group_code and self.root:
            if self.root.findGroup(f"{self.group_code}"):
                group = self.root.findGroup(f"{self.group_code}")
                if group:
                    self.root.removeChildNode(group)

        self.group_code = None
        self.minx,self.miny,self.maxx,self.maxy = None,None,None,None
        self.rect = None
        self.group_names = None
        self.roles_codes = None
        self.user = None
        self.psw = None
        self.admin = None
        self.cap = None
        self.bearer = None
        self.expires = None
        self.jws = None
        self.timer.stop()
        #pulisco la combobox
        self.dict_wms = {}
        self.pdnd_dockwidget.INFR_RT_ESTENSIONE_cb.setChecked(False)
        self.pdnd_dockwidget.INFR_RT_ESTENSIONE_L_cb.setChecked(False)
        self.pdnd_dockwidget.INFR_RT_ESTENSIONE_P_cb.setChecked(False)
        
        self.pdnd_dockwidget.cartodb_basemap_rb.setAutoExclusive(False)
        self.pdnd_dockwidget.osm_standard_rb.setAutoExclusive(False)
        self.pdnd_dockwidget.esri_world_imagery_rb.setAutoExclusive(False)

        self.pdnd_dockwidget.cartodb_basemap_rb.setChecked(False)
        self.pdnd_dockwidget.osm_standard_rb.setChecked(False)
        self.pdnd_dockwidget.esri_world_imagery_rb.setChecked(False)
        
        self.pdnd_dockwidget.cartodb_basemap_rb.setAutoExclusive(True)
        self.pdnd_dockwidget.osm_standard_rb.setAutoExclusive(True)
        self.pdnd_dockwidget.esri_world_imagery_rb.setAutoExclusive(True)
        
        self.pdnd_dockwidget.tab_wms.setEnabled(True)
        self.pdnd_dockwidget.wms_layer_tabWidget.setVisible(True)
        self.pdnd_dockwidget.label_no_cap_wms.clear()
        self.pdnd_dockwidget.label_no_cap_wms.move(20,340)
        self.children_count = 0
        
        self.zoomato_italia = False
        self.zoom_mappa = False
        
    def abilita_infr_rt(self,value,nome,combobox,lista_stile_layer,lista_nome_stile):
        
        if not self.dict_wms:
            self.init_dict_wms()
        self.dict_wms[nome] = [value,None]

        #imposto la relativa combobox allo stesso stato della checkbox
        combobox.setEnabled(value)

        #recupero l'indice della combobox e il nome del relativo stile
        index = combobox.currentIndex()
        stile_layer = lista_stile_layer[index]

        #se la checkbox è disabilitata chiamo il rimuoviWMs
        if not value:
            self.remove_wms(stile_layer)
            combobox.setCurrentIndex(-1)
        else:
            combobox.setCurrentIndex(0)
            #altrimenti aggiungo il wms dell'Index 0

    def non_ho_cap(self):
        self.pdnd_dockwidget.tab_wms.setEnabled(False)
        self.pdnd_dockwidget.wms_layer_tabWidget.setVisible(False)

        self.pdnd_dockwidget.label_no_cap_wms.setText("Utente non abilitato ai servizi WMS.")
        self.pdnd_dockwidget.label_no_cap_wms.move(10,10)

    def checcato(self,value,nome,cerca_stile = None):
        if value:
            if cerca_stile:
                recupero_stile = self.dict_stili_ND_TR_worksite.get(nome)
                stile_layer = recupero_stile[0]
                nome_stile = recupero_stile[1]
                self.download_wms(nome,stile_layer,nome_stile)

            else:
                self.download_wms(nome)
        else:
            self.remove_wms(nome)

    def checcato_con_stile(self,index,nome,lista_stile_layer,lista_nome_stile):
        if index != -1:
            
            #recupero stile_layer e nome_stile
            stile_layer = lista_stile_layer[index]
            nome_stile = lista_nome_stile[index]
            
            if not self.dict_wms:
                self.init_dict_wms()
            #se il layer attuale è già presente non faccio niente
            current_bool = self.dict_wms.get(stile_layer)[0]
            if not current_bool:
                #passo il layer da aggiungere a download_wms
                self.download_wms(nome,stile_layer,nome_stile,True)

            #cerco i layer in lista_stile_layer del gruppo e rimuovo quelli a True
            for itero_stile_layer in lista_stile_layer:
                if itero_stile_layer == stile_layer:
                    continue
                current_bool = self.dict_wms.get(itero_stile_layer)[0]
                if current_bool:
                    self.remove_wms(itero_stile_layer)

    def download_wms(self,nome_layer,stile_layer = None, nome_stile = None,cerca_stile=None):
        #recupero il codice e il nome del gruppo
        
        if not self.dict_wms:
            self.init_dict_wms()
        #se il layer corrente è False allora procedo
        if stile_layer and cerca_stile:
            current_bool = self.dict_wms.get(stile_layer)[0]
        else:
            current_bool = self.dict_wms.get(nome_layer)[0]
            
        if not current_bool:
            url = f"https://{self.link_pdnd}/sinfi/pdnd/wms/1.0.0/sinfi_data_server_get_wms/"
            if not self.bearer:
                voucher = self.login_pdnd.request_voucher("wms")
                
                self.bearer =  voucher["bearer"]
                self.jws = voucher["jws"]
                self.expires = voucher["expires_in"]
                self.timer.start(50 * 1000)
            
            #se non ho il gruppo lo recupero
            if not self.group_code:
                url_capabilities = f'https://{self.link_pdnd}/sinfi/pdnd/wms/1.0.0/sinfi_data_server_get_wms/?SERVICE=WMS&REQUEST=GetCapabilities'

                headers = {
                    "Authorization": f"Bearer {self.bearer}",
                    "Agid-JWT-TrackingEvidence": self.jws,
                    "accept": "application/json",
                    "content-type": "application/json"
                }
                
                res = requests.get(url_capabilities, headers = headers)
                if res.status_code != 200:
                    self.pdnd_dockwidget.tab_wms.setEnabled(False)
                    self.pdnd_dockwidget.wms_layer_tabWidget.setVisible(False)

                    self.pdnd_dockwidget.label_no_cap_wms.setText("Non sono presenti layer WMS\nper il gruppo selezionato.")
                    self.pdnd_dockwidget.label_no_cap_wms.move(10,10)
                    return None
                
                root = ET.fromstring(res.text)

                #verifico i layer non presenti
                xml_layers_list = []
                for cap in root.findall("{http://www.opengis.net/wms}Capability"):
                    layer = cap.find("{http://www.opengis.net/wms}Layer")
                    layers = layer.findall('{http://www.opengis.net/wms}Layer')
                    for l in layers:
                        name = l.find('{http://www.opengis.net/wms}Name')
                        
                        xml_layers_list.append(name.text)

                check_layer_wms = False
                for ll in self.layer_list_no_stili:
                    if ll not in xml_layers_list:
                        code_to_exec = f'self.pdnd_dockwidget.{ll}_cb.setEnabled(False)'
                        exec(code_to_exec)
                    else:
                        code_to_exec = f'self.pdnd_dockwidget.{ll}_cb.setEnabled(True)'
                        exec(code_to_exec)
                        check_layer_wms = True

                if not check_layer_wms:
                    self.pdnd_dockwidget.tab_wms.setEnabled(False)
                    self.pdnd_dockwidget.label_no_cap_wms.setText("Non sono presenti layer WMS.")
                    return None
                else:
                    self.pdnd_dockwidget.tab_wms.setEnabled(True)
                    self.pdnd_dockwidget.label_no_cap_wms.clear()

                #recupero il gruppo
                # Namespace usati nel capabilities
                ns = {
                    "wms": "http://www.opengis.net/wms",
                    "xlink": "http://www.w3.org/1999/xlink"
                }
                # Prendo il primo OnlineResource del blocco GetMap
                node = root.find(".//wms:GetMap//wms:OnlineResource", ns)
                href = node.attrib["{http://www.w3.org/1999/xlink}href"]
                # Estraggo il gruppo dal path
                path = urlparse(href).path  # es: /data/ows/comune_di_varese/wms
                parts = path.split("/")
                self.group_code = parts[3]  # "comune_di_varese"

                #recupero le coordinate della bbox
                # lo spazio dei nomi del WMS
                ns = {"wms": "http://www.opengis.net/wms"}

                # cerca il BoundingBox con CRS EPSG:3857
                bbox_elem = root.find(".//wms:BoundingBox[@CRS='EPSG:3857']", ns)

                if bbox_elem is not None:
                    self.minx = float(bbox_elem.attrib["minx"])
                    self.miny = float(bbox_elem.attrib["miny"])
                    self.maxx = float(bbox_elem.attrib["maxx"])
                    self.maxy = float(bbox_elem.attrib["maxy"])

                    self.rect = QgsRectangle(self.minx, self.miny, self.maxx, self.maxy)

            #se esiste recupero il gruppo in cui aggiungere il layer, altrimenti lo creo
            if self.root.findGroup(f"{self.group_code}"):
                layer_group = self.root.findGroup(f"{self.group_code}")
            else:
                self.root.insertGroup(0,f"{self.group_code}")
                layer_group = self.root.findGroup(f"{self.group_code}")

            #controllo che il layer non sia di sfondo
            if nome_layer not in self.sfondi:
                if stile_layer and cerca_stile:
                    layer_id = nome_layer
                    layer_name = nome_stile
                    layer_style = stile_layer
                elif stile_layer:
                    layer_id = nome_layer
                    layer_name = f'SINFI: {nome_layer}'
                    layer_style = stile_layer
                else:
                    layer_id = nome_layer
                    layer_name = f'SINFI: {nome_layer}'
                    layer_style = ''
                    
                # url_wms = f'https://{self.link_pdnd}/data/ows/{self.group_code}/wms'
                url_wms = f'https://{self.link_pdnd}/sinfi/pdnd/wms/1.0.0/sinfi_data_server_get_wms/'
                
                header = QgsHttpHeaders()
                
                header.insert("Agid-JWT-TrackingEvidence",f"{self.jws}")
                header.insert("authorization",f"Bearer {self.bearer}")
                                
                uri_config = dict(
                    IgnoreGetMapUrl='1',
                    contextualWMSLegend='0',
                    crs="EPSG:3857",
                    dpiMode='7',
                    featureCount='10',
                    format='image/png',
                    layers=layer_id,
                    styles=layer_style,
                    tilePixelRatio='0',
                    url=url_wms,
                    bbox=f"{self.minx},{self.miny},{self.maxx},{self.maxy}",
                    width="624",
                    height="580",
                    dpi="96",
                    MAP_RESOLUTION="96",
                    TRANSPARENT="true",
                    FORMAT_OPTIONS="dpi:96",
                    url_pdnd="true"
                )
                
                uri = QgsDataSourceUri()

                for key,val in uri_config.items():
                    uri.setParam(key,val)
                uri.setHttpHeaders(header)
                
                wms_layer = QgsRasterLayer(bytes(uri.encodedUri()).decode(), layer_name, 'wms')
                wms_layer.setExtent(self.rect)
                
                if not self.zoom_mappa:
                    self.zoom_mappa = True
                    self.iface.mapCanvas().setExtent(self.rect)
                    self.iface.mapCanvas().refresh()

                #aggiungo il layer nel gruppo designato
                added_layer = QgsProject.instance().addMapLayer(wms_layer,False)
                index_pos = 0
                if nome_layer in self.layer_lineari or stile_layer in self.layer_lineari:
                    if self.children_count >1:
                        index_pos = self.children_count - 1

                layer_group.insertLayer(index_pos,added_layer)
                
                self.children_count +=1
                #recupero il riferimento alla checkbox nel dict,aggiorno lo stato e inserisco l'id del layer appena inserito
                if stile_layer and cerca_stile:
                    self.dict_wms[stile_layer] = [True,added_layer.id()]
                    self.layer_dict[added_layer.id()] = [stile_layer]
                else:
                    self.dict_wms[nome_layer] = [True,added_layer.id()]
                    self.layer_dict[added_layer.id()] = [nome_layer]

            else:
                layer_id = nome_layer
                sfondi_list = self.dict_sfondi.get(nome_layer)
                layer_name = sfondi_list[0]
                url = sfondi_list[1]
                
                layer_sfondo = QgsRasterLayer("type=xyz&url=" + url, layer_name, "wms")
                added_layer = QgsProject.instance().addMapLayer(layer_sfondo,False)
                
                layer_group.insertLayer(-1,added_layer)
                
                self.dict_wms[nome_layer] = [True,added_layer.id()]
                self.layer_dict[added_layer.id()] = [nome_layer]
                self.children_count +=1

                if not self.zoomato_italia:
                    self.zoomato_italia = True
                    QTimer.singleShot(200, lambda: self._zoom_to_italia(self.zoom_italia))
                    
    def _zoom_to_italia(self,zoom):
        canvas = self.iface.mapCanvas()
        canvas.setDestinationCrs(QgsCoordinateReferenceSystem("EPSG:3857"))
        canvas.setExtent(zoom)
        canvas.refresh()
        canvas.repaint()

    def refresh_voucher(self):
        now = int(time.time())
        # rigenera se mancano meno di 60 secondi alla scadenza
        if now > self.expires:
            voucher = self.login_pdnd.request_voucher("wms")
            bearer = voucher["bearer"]
            expires = voucher["expires_in"]
            
            layer_ids = [f[1] for f in self.dict_wms.values() if f[0]]
            for layer_id in layer_ids:
                layer = QgsProject.instance().mapLayer(layer_id)
                if layer:
                    
                    uri = layer.dataProvider().dataSourceUri()
                    
                    new_uri = uri.replace(f"http-header:authorization=Bearer {self.bearer}", f"http-header:authorization=Bearer {bearer}")
                    
                    layer.setDataSource(new_uri, f'{layer.name()}_bis', "wms")
                    layer.triggerRepaint()
                    self.iface.messageBar().pushMessage("SINFI WMS", "Voucher aggiornato", level=0)

            self.bearer = bearer
            self.expires = int(time.time()) + (expires-60)
            self.timer.start(50 * 1000)

    def remove_wms(self,nome_layer):
        
        if not self.dict_wms:
            self.init_dict_wms()
        #se il layer corrente è True allora procedo
        current_bool = self.dict_wms.get(nome_layer)[0]
        
        if current_bool:
            #recupero l'id del layer da rimuovere
            id_da_rimuovere = self.dict_wms.get(nome_layer)[1]
            #controllo che il layer sia ancora presente:
            layer= QgsProject.instance().mapLayer(id_da_rimuovere)
            if layer:
                QgsProject.instance().removeMapLayer(id_da_rimuovere)
            #recupero il riferimento alla checkbox nel dict, aggiorno lo stato e rimuovo l'id del layer
            self.dict_wms[nome_layer] = [False,None]
            self.iface.mapCanvas().refresh()
            self.children_count -=1

    def remove_all_wms(self):
            
            for v in list(self.layer_dict.keys()):
                id_da_rimuovere= v
                if id_da_rimuovere:
                    layer= QgsProject.instance().mapLayer(id_da_rimuovere)
                    if layer:
                        QgsProject.instance().removeMapLayer(id_da_rimuovere)
            
            self.iface.mapCanvas().refresh()
            self.timer.stop()

    def layer_removed_listener(self,id_layer_rimosso):

        if id_layer_rimosso in list(self.layer_dict.keys()):
            layer_list = self.layer_dict.get(id_layer_rimosso)
            nome_layer = layer_list[0]
            self.dict_wms[nome_layer] = [False,None]

                
            check_stili_INFR_RT_ESTENSIONE = 0
            check_stili_INFR_RT_ESTENSIONE_L = 0
            check_stili_INFR_RT_ESTENSIONE_P = 0

            for k,v in list(self.dict_wms.items()):

                if k in self.stili_INFR_RT_ESTENSIONE:
                    if v[0]:
                        check_stili_INFR_RT_ESTENSIONE +=1
                elif k in self.stili_INFR_RT_ESTENSIONE_L:
                    if v[0]:
                        check_stili_INFR_RT_ESTENSIONE_L +=1
                elif k in self.stili_INFR_RT_ESTENSIONE_P:
                    if v[0]:
                        check_stili_INFR_RT_ESTENSIONE_P +=1
                elif k in self.sfondi:
                    continue
                else:
                    code_to_exec = f'self.pdnd_dockwidget.{k}_cb.setChecked({v[0]})'
                    exec(code_to_exec)
            
            if check_stili_INFR_RT_ESTENSIONE == 0:
                if self.pdnd_dockwidget.INFR_RT_ESTENSIONE_cb.isChecked():
                    self.pdnd_dockwidget.stili_INFR_RT_ESTENSIONE_cb.setCurrentIndex(-1)
            if check_stili_INFR_RT_ESTENSIONE_L == 0:
                if self.pdnd_dockwidget.INFR_RT_ESTENSIONE_L_cb.isChecked():
                    self.pdnd_dockwidget.stili_INFR_RT_ESTENSIONE_L_cb.setCurrentIndex(-1)
            if check_stili_INFR_RT_ESTENSIONE_P == 0:
                if self.pdnd_dockwidget.INFR_RT_ESTENSIONE_P_cb.isChecked():
                    self.pdnd_dockwidget.stili_INFR_RT_ESTENSIONE_P_cb.setCurrentIndex(-1)