"""
/***************************************************************************
 Servizi Sinfi
                                 A QGIS plugin
 Plugin per accedere ai servizi Sinfi da piattaforma QGis
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-04-16
        copyright            : (C) 2025 by Infratel Italia
        email                : info@sinfi.it
        git sha              : $Format:%H$
 ***************************************************************************/

 /***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from ..utils import sinfi_utils
try:
    # import jwt
    from ..librerie_esterne import jwt
except Exception as e:
    sinfi_utils.message_creator("Attenzione","warning","QGIS ha completato l'installazione del modulo JWT ma non riesce a completare l'importazione.\nSi prega di chiudere e riaprire QGIS.")
  

import time
import uuid
import datetime
import hashlib
import requests
import json

def get_private_key(key_path: str) -> bytes:
    
    with open(key_path, "rb") as private_key:
        return private_key.read()

def create_jws(
    kid: str,
    keyPath: str,
    apikey: str,
    audience: str,
    issuer: str,
    purposeId: str,
    lifetime_seconds: int = 300  # 5 minuti
):

    # Timestamp epoch
    now = int(time.time())
    iat = now
    nbf = now
    exp = now + lifetime_seconds

    try:
        # Carico chiave RSA
        rsa_key = get_private_key(keyPath)

        # Timestamp epoch
        now = int(time.time())
        iat = now
        nbf = now
        exp = now + lifetime_seconds

        # Header JWS
        headers_jws = {
            "kid": str(kid),
            "alg": "RS256",
            "typ": "JWT"
        }
        # Payload JWS
        payload_jws = {
            "userID": apikey,
            "userLocation": "plugin-qgis",
            "LoA": "SINFI",
            "iat": iat,
            "exp": exp,
            "nbf": nbf,
            "aud": audience,
            "jti": str(uuid.uuid4()),
            "iss": issuer,
            "purposeId": purposeId
        }
        # Firma JWS (RS256)
        jws = jwt.encode(
            payload_jws,
            rsa_key,
            algorithm="RS256",
            headers=headers_jws
        )

        # HASH SHA-256 per il digest nella client assertion
        digest = hashlib.sha256(jws.encode("utf-8")).hexdigest()
        
        return [jws, digest, "success"]

    except Exception as e:
        return [None, None, f"Errore creazione JWS: {e}"]

def create_client_assertion(
    kid: str,
    alg: str,
    typ: str,
    issuer: str,
    subject: str,
    audience: str,
    purposeId: str,
    keyPath: str,
    digest_value: str,
    lifetime_minutes: int = 43200  # 30 giorni
):
 
    issued = datetime.datetime.utcnow()
    expire_in = issued + datetime.timedelta(minutes=lifetime_minutes)
    jti = uuid.uuid4()

    headers_rsa = {
        "kid": str(kid),
        "alg": str(alg),
        "typ": str(typ)
    }
    # Payload standard + campo digest
    payload = {
        "iss": issuer,
        "sub": subject,
        "aud": audience,
        "jti": str(jti),
        "iat": issued,
        "exp": expire_in,
        "purposeId": purposeId,
        "digest": {
            "alg": "SHA256",
            "value": digest_value
        }
    }

    try:
        rsa_key = get_private_key(keyPath)

        client_assertion = jwt.encode(
            payload,
            rsa_key,
            algorithm=str(alg),
            headers=headers_rsa
        )

        return [client_assertion, "success"]
        
        
    except Exception as e:
        return [None, f"Errore nella creazione della client assertion: {e}"]

def create_voucher(
    purpose: str,
    kid: str,
    private_path: str,
    client_id: str,
    apikey: str,
    link_pdnd: str
):

        # purposeId = {
        #     "statistico" : ["26528558-7b3c-4c51-a290-a68e06b5292f",'stats'],
        #     "datapanel" : ["6e6bbe40-e487-48c8-8796-272b3901d1f4","datapanel"],
        #     "wms" : ["410ac132-ebec-4958-97f0-69585dd0c849","wms"]
        # }#sviluppo

        purposeId = {
            "statistico" : ["16b1ea09-1062-43d4-a315-a0d5b3a5270f",'stats'],
            "datapanel" : ["b80795d7-f191-46e4-bf35-4e44f29e2bed","datapanel"],
            "wms" : ["8a956078-1ebe-4667-8b5d-102cb996a3be","wms"]
        } #prod



        get_purpose = purposeId.get(purpose, None)
        if not get_purpose:
            sinfi_utils.message_creator("Errore","critical","PurposeId non valido.")
            return None
        
        kid = kid
        keyPath = private_path
        client_id = client_id
        apikey = apikey

        # issuer_da_usare = "uat.interop.pagopa.it" #sviluppo
        issuer_da_usare = "interop.pagopa.it" #prod

        jws, digest_value, status = create_jws(
            kid=kid,
            keyPath=keyPath,
            apikey=apikey,
            audience=f"https://{link_pdnd}/sinfi/pdnd/{get_purpose[1]}/1.0.0",#f"https://sinfi.be.pdnd.it/sinfi/pdnd/{get_purpose[1]}/1.0.0",#
            issuer=issuer_da_usare,
            purposeId=get_purpose[0]
        )
        
        if not jws:
            sinfi_utils.message_creator("Errore","critical",status)
            return None

        alg = "RS256"
        typ = "JWT"
        # audience_assertion = "auth.uat.interop.pagopa.it/client-assertion" #sviluppo
        audience_assertion = "auth.interop.pagopa.it/client-assertion" #prod

        client_assertion_result = create_client_assertion(
            kid=kid,
            alg=alg,
            typ=typ,
            issuer=client_id,
            subject=client_id,
            audience=audience_assertion,
            purposeId=get_purpose[0],
            keyPath=keyPath,
            digest_value=digest_value
        )

        assertion = client_assertion_result[0]
        if not assertion:
            sinfi_utils.message_creator("Errore client assertion","critical",client_assertion_result[1])

            return None

        # url = "https://auth.uat.interop.pagopa.it/token.oauth2" #sviluppo
        url = "https://auth.interop.pagopa.it/token.oauth2" #prod
        
        headers = {'Content-Type': 'application/x-www-form-urlencoded'}
        body = (
            f"client_id={client_id}"
            f"&client_assertion={assertion}"
            f"&client_assertion_type=urn:ietf:params:oauth:client-assertion-type:jwt-bearer"
            f"&grant_type=client_credentials"
        )

        try:
            req = requests.post(url, headers=headers, data=body)
        except Exception as e:
            sinfi_utils.message_creator("Errore di rete","critical",f"Impossibile contattare PDND:\n{e}")
            return None

        if req.status_code != 200:
            msg = sinfi_utils.traduci_status_code(req.status_code)
            sinfi_utils.message_creator("Errore voucher PDND","warning",f"Voucher non generato:\n{msg}")
            return None

        res = json.loads(req.text)
        bearer = res.get("access_token")
        expires = res.get("expires_in")
        expires_in = int(time.time()) + (expires - 60)

        return {
            "bearer": bearer,
            "expires_in": expires_in,
            "apikey": apikey,
            "jws": jws
        }