"""
/***************************************************************************
 Servizi Sinfi
                                 A QGIS plugin
 Plugin per accedere ai servizi Sinfi da piattaforma QGis
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-04-16
        copyright            : (C) 2025 by Infratel Italia
        email                : info@sinfi.it
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.PyQt.QtWidgets import QMessageBox,QLabel, QScrollArea, QWidget, QVBoxLayout
from qgis.PyQt.QtCore import Qt

def traduci_status_code(status_code: int) -> str:
    """
    Restituisce un messaggio leggibile per uno status code HTTP.
    """
    messages = {
        # 2xx Success
        200: "OK - Richiesta eseguita con successo.",
        201: "Created - Risorsa creata correttamente.",
        202: "Accepted - Richiesta accettata, in elaborazione.",
        204: "No Content - Richiesta completata, nessun contenuto restituito.",

        # 3xx Redirect
        301: "301:Moved Permanently - La risorsa è stata spostata in modo permanente.",
        302: "302:Found - La risorsa è temporaneamente disponibile altrove.",
        304: "304:Not Modified - Nessuna modifica dalla versione cache.",

        # 4xx Client Error
        400: "400:Bad Request - La richiesta non è valida.",
        401: "401:Unauthorized - Errore di autenticazione.",
        403: "403:Forbidden - Accesso negato alla risorsa.",
        404: "404:Not Found - Risorsa non trovata.",
        405: "405:Method Not Allowed - Metodo HTTP non consentito.",
        408: "408:Request Timeout - La richiesta è scaduta.",
        429: "429:Too Many Requests - Limite di richieste superato.",

        # 5xx Server Error
        500: "500:Internal Server Error - Errore generico del server.",
        501: "501:Not Implemented - Funzionalità non supportata dal server.",
        502: "502:Bad Gateway - Risposta non valida dal server upstream.",
        503: "503:Service Unavailable - Servizio momentaneamente non disponibile.",
        504: "504:Gateway Timeout - Timeout del server upstream."
    }

    return messages.get(status_code, f"Status Code {status_code} - Codice non gestito esplicitamente.")

def get_icon(icon):
    if icon == 'warning':
        return QMessageBox.Warning
    elif icon == 'critical':
        return QMessageBox.Critical
    elif icon == 'information':
        return QMessageBox.Information
    
def message_creator(title,icon,text,check_upload=False,zip_created=False,upload=False):
    message = QMessageBox()
    message.setWindowFlags(Qt.WindowStaysOnTopHint)
    message.setStyleSheet("""
        QWidget { background-color: white; }
        QPushButton { border: 2px solid rgb(222,222,222); background: white; margin: 0px 2px 2px 0px ; padding: 5px; }
        QPushButton:hover, QPushButton:pressed { background: rgb(230,230,230); }
    """)
    message.setWindowTitle(title)
    # message.setIcon(get_icon(icon))

    scroll = QScrollArea(message)
    scroll.setWidgetResizable(True)
    
    if not check_upload:
        scroll.setMinimumHeight(50)
    else:
        scroll.setMinimumHeight(150)

    if not zip_created and not upload:
        scroll.setMinimumWidth(250)
    else:
        scroll.setMinimumWidth(550)
        scroll.setMinimumHeight(80)

    scroll.setMaximumHeight(300)
    scroll.setStyleSheet("QScrollArea { border: none; background: transparent; }")

    content = QWidget()
    # content.setStyleSheet("background: transparent;")
    layout = QVBoxLayout(content)

    label = QLabel(text)
    label.setWordWrap(True)
    label.setStyleSheet("""
        QLabel {
            border: none;
            background-color: transparent;
        }
    """)
    layout.addWidget(label)

    scroll.setWidget(content)

    message.layout().addWidget(scroll, 0, 0, 1, message.layout().columnCount())

    message.exec()
