"""
/***************************************************************************
 Servizi Sinfi
                                 A QGIS plugin
 Plugin per accedere ai servizi Sinfi da piattaforma QGis
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-04-16
        copyright            : (C) 2025 by Infratel Italia
        email                : info@sinfi.it
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.PyQt.QtCore import Qt
from qgis.core import QgsProject,QgsRasterLayer,QgsRectangle,QgsDataSourceUri,QgsCoordinateReferenceSystem

from qgis.PyQt.QtCore import QTimer
import requests
from requests.auth import HTTPBasicAuth
import xml.etree.ElementTree as ET
import locale

class SinfiWMS():

    def __init__(self,iface,sinfi_dockwidget,link):
        self.cap = None
        self.authCfdId = None
        self.iface = iface
        self.link = link
        self.user = None
        self.psw = None
        self.sinfi_dockwidget = sinfi_dockwidget
        self.minx,self.miny,self.maxx,self.maxy = None,None,None,None
        self.rect = None
        
        self.sinfi_upload = None
        self.group_codes = None
        self.group_names = None
        self.roles_codes = None
        self.dict_wms = None
        self.dict_sfondi = None
        self.admin = None
        self.layer_list = ['ND_AAC','ND_COM','ND_ELE','ND_GAS','ND_OLE','ND_SAC','ND_TLR','TR_AAC','TR_COM','TR_ELE','TR_GAS','TR_OLE','TR_SAC','TR_TLR',
                           'INFR_RT_ESTENSIONE','INFR_RT_POLYGONS_ALL','INFR_RT_POLYGONS_BY_STATE','INFR_RT_POLY_BY_TY','INFR_RT_POLYGONS_BY_TR','INFR_RT_POLYGONS_BY_INFR_RT_UT',
                           'INFR_RT_ESTENSIONE_L','INFR_RT_LINES_ALL','INFR_RT_LINES_BY_STATE','INFR_RT_BY_TY','INFR_RT_LINES_BY_TR','INFR_RT_LINES_BY_INFR_RT_UT',
                           'INFR_RT_ESTENSIONE_P','INFR_RT_POINTS_ALL','INFR_RT_POINTS_BY_STATE','INFR_RT_POINT_BY_TY','INFR_RT_POINTS_BY_TR','INFR_RT_POINTS_BY_INFR_RT_UT',
                           'cartodb_basemap','osm_standard','esri_world_imagery']
        
        self.layer_list_no_stili = ['ND_AAC','ND_COM','ND_ELE','ND_GAS','ND_OLE','ND_SAC','ND_TLR','TR_AAC','TR_COM','TR_ELE','TR_GAS','TR_OLE','TR_SAC','TR_TLR',
                           'INFR_RT_ESTENSIONE','INFR_RT_ESTENSIONE_L','INFR_RT_ESTENSIONE_P']
        
        self.stili_INFR_RT_ESTENSIONE = ['INFR_RT_POLYGONS_ALL','INFR_RT_POLYGONS_BY_STATE','INFR_RT_POLY_BY_TY','INFR_RT_POLYGONS_BY_TR','INFR_RT_POLYGONS_BY_INFR_RT_UT']
        self.stili_nome_layer_INFR_RT_ESTENSIONE = ['Aree:Default','Aree:Stato infrastruttura','Aree:Tipo di infrastruttura','Aree:Tipo di rete alloggiata','Aree:Utilizzabilità infrastruttura']
        
        self.stili_INFR_RT_ESTENSIONE_L = ['INFR_RT_LINES_ALL','INFR_RT_LINES_BY_STATE','INFR_RT_BY_TY','INFR_RT_LINES_BY_TR','INFR_RT_LINES_BY_INFR_RT_UT']
        self.stili_nome_layer_INFR_RT_ESTENSIONE_L = ['Tratte:Default','Tratte:Stato infrastruttura','Tratte:Tipo di infrastruttura','Tratte:Tipo di rete alloggiata','Tratte:Utilizzabilità infrastruttura']

        self.stili_INFR_RT_ESTENSIONE_P = ['INFR_RT_POINTS_ALL','INFR_RT_POINTS_BY_STATE','INFR_RT_POINT_BY_TY','INFR_RT_POINTS_BY_TR','INFR_RT_POINTS_BY_INFR_RT_UT']
        self.stili_nome_layer_INFR_RT_ESTENSIONE_P = ['Nodi:Default','Nodi:Stato infrastruttura','Nodi:Tipo di infrastruttura','Nodi:Tipo di rete alloggiata','Nodi:Utilizzabilità infrastruttura']

        self.layer_puntuali = ['ND_AAC','ND_COM','ND_ELE','ND_GAS','ND_OLE','ND_SAC','ND_TLR','INFR_RT_POINTS_ALL','INFR_RT_POINTS_BY_STATE','INFR_RT_POINT_BY_TY','INFR_RT_POINTS_BY_TR','INFR_RT_POINTS_BY_INFR_RT_UT']
        self.layer_lineari = ['TR_AAC','TR_COM','TR_ELE','TR_GAS','TR_OLE','TR_SAC','TR_TLR','INFR_RT_LINES_ALL','INFR_RT_LINES_BY_STATE','INFR_RT_BY_TY','INFR_RT_LINES_BY_TR','INFR_RT_LINES_BY_INFR_RT_UT']

        self.sfondi = ['cartodb_basemap','osm_standard','esri_world_imagery']
        self.dict_sfondi_nome = {'cartodb_basemap' : ["Cartografia chiara (CartoDB)","http://a.basemaps.cartocdn.com/light_all/%7Bz%7D/%7Bx%7D/%7By%7D.png&zmin=0&zmax=20"],
                            'osm_standard' : ["Mappa stradale (OpenStreetMap)","http://tile.openstreetmap.org/%7Bz%7D/%7Bx%7D/%7By%7D.png&zmin=0&zmax=19"],
                            'esri_world_imagery' : ["Immagine satellitare (Esri)","https://server.arcgisonline.com/ArcGIS/rest/services/World_Imagery/MapServer/tile/%7Bz%7D/%7By%7D/%7Bx%7D&zmin=0&zmax=20"]}

        self.sinfi_dockwidget.ND_AAC_cb.stateChanged.connect(lambda state: self.checcato(state,'ND_AAC'))
        self.sinfi_dockwidget.ND_COM_cb.stateChanged.connect(lambda state: self.checcato(state,'ND_COM'))
        self.sinfi_dockwidget.ND_ELE_cb.stateChanged.connect(lambda state: self.checcato(state,'ND_ELE'))
        self.sinfi_dockwidget.ND_GAS_cb.stateChanged.connect(lambda state: self.checcato(state,'ND_GAS'))
        self.sinfi_dockwidget.ND_OLE_cb.stateChanged.connect(lambda state: self.checcato(state,'ND_OLE'))
        self.sinfi_dockwidget.ND_SAC_cb.stateChanged.connect(lambda state: self.checcato(state,'ND_SAC'))
        self.sinfi_dockwidget.ND_TLR_cb.stateChanged.connect(lambda state: self.checcato(state,'ND_TLR'))
        self.sinfi_dockwidget.TR_AAC_cb.stateChanged.connect(lambda state: self.checcato(state,'TR_AAC'))
        self.sinfi_dockwidget.TR_COM_cb.stateChanged.connect(lambda state: self.checcato(state,'TR_COM'))
        self.sinfi_dockwidget.TR_ELE_cb.stateChanged.connect(lambda state: self.checcato(state,'TR_ELE'))
        self.sinfi_dockwidget.TR_GAS_cb.stateChanged.connect(lambda state: self.checcato(state,'TR_GAS'))
        self.sinfi_dockwidget.TR_OLE_cb.stateChanged.connect(lambda state: self.checcato(state,'TR_OLE'))
        self.sinfi_dockwidget.TR_SAC_cb.stateChanged.connect(lambda state: self.checcato(state,'TR_SAC'))
        self.sinfi_dockwidget.TR_TLR_cb.stateChanged.connect(lambda state: self.checcato(state,'TR_TLR'))

        self.sinfi_dockwidget.INFR_RT_ESTENSIONE_cb.stateChanged.connect(lambda state: self.abilita_infr_rt(state,'INFR_RT_ESTENSIONE',self.sinfi_dockwidget.stili_INFR_RT_ESTENSIONE_cb,self.stili_INFR_RT_ESTENSIONE,self.stili_nome_layer_INFR_RT_ESTENSIONE))
        self.sinfi_dockwidget.stili_INFR_RT_ESTENSIONE_cb.currentIndexChanged.connect(lambda index: self.checcato_con_stile(index,'INFR_RT_ESTENSIONE',self.stili_INFR_RT_ESTENSIONE,self.stili_nome_layer_INFR_RT_ESTENSIONE))
        
        self.sinfi_dockwidget.INFR_RT_ESTENSIONE_L_cb.stateChanged.connect(lambda state: self.abilita_infr_rt(state,'INFR_RT_ESTENSIONE_L',self.sinfi_dockwidget.stili_INFR_RT_ESTENSIONE_L_cb,self.stili_INFR_RT_ESTENSIONE_L,self.stili_nome_layer_INFR_RT_ESTENSIONE_L))
        self.sinfi_dockwidget.stili_INFR_RT_ESTENSIONE_L_cb.currentIndexChanged.connect(lambda index: self.checcato_con_stile(index,'INFR_RT_ESTENSIONE_L',self.stili_INFR_RT_ESTENSIONE_L,self.stili_nome_layer_INFR_RT_ESTENSIONE_L))
        
        self.sinfi_dockwidget.INFR_RT_ESTENSIONE_P_cb.stateChanged.connect(lambda state: self.abilita_infr_rt(state,'INFR_RT_ESTENSIONE_P',self.sinfi_dockwidget.stili_INFR_RT_ESTENSIONE_P_cb,self.stili_INFR_RT_ESTENSIONE_P,self.stili_nome_layer_INFR_RT_ESTENSIONE_P))
        self.sinfi_dockwidget.stili_INFR_RT_ESTENSIONE_P_cb.currentIndexChanged.connect(lambda index: self.checcato_con_stile(index,'INFR_RT_ESTENSIONE_P',self.stili_INFR_RT_ESTENSIONE_P,self.stili_nome_layer_INFR_RT_ESTENSIONE_P))
        
        self.sinfi_dockwidget.cartodb_basemap_rb.toggled.connect(lambda state: self.checcato(state,'cartodb_basemap'))
        self.sinfi_dockwidget.osm_standard_rb.toggled.connect(lambda state: self.checcato(state,'osm_standard'))
        self.sinfi_dockwidget.esri_world_imagery_rb.toggled.connect(lambda state: self.checcato(state,'esri_world_imagery'))

        QgsProject.instance().layerRemoved.connect(self.layer_removed_listener)

        self.layer_dict = {}

        self.root = QgsProject.instance().layerTreeRoot()
        
        self.sinfi_dockwidget.cb_gruppi.currentIndexChanged.connect(self.gruppo_cambiato)
        self.group_to_cap = None

        self.zoom_italia = QgsRectangle(736267.1121067114,4230671.180235986, 2061748.2889822198,5957594.299513203)
        self.zoomato_italia = False

        self.zoom_mappa = False
        
        self.sfondi_admin = None

    def unload(self):
        self.authCfdId = None
        self.sinfi_upload = None
        self.cap = None
        self.minx,self.miny,self.maxx,self.maxy = None,None,None,None
        self.rect = None
        
        self.sinfi_dockwidget.ND_AAC_cb.stateChanged.disconnect()
        self.sinfi_dockwidget.ND_COM_cb.stateChanged.disconnect()
        self.sinfi_dockwidget.ND_ELE_cb.stateChanged.disconnect()
        self.sinfi_dockwidget.ND_GAS_cb.stateChanged.disconnect()
        self.sinfi_dockwidget.ND_OLE_cb.stateChanged.disconnect()
        self.sinfi_dockwidget.ND_SAC_cb.stateChanged.disconnect()
        self.sinfi_dockwidget.ND_TLR_cb.stateChanged.disconnect()
        self.sinfi_dockwidget.TR_AAC_cb.stateChanged.disconnect()
        self.sinfi_dockwidget.TR_COM_cb.stateChanged.disconnect()
        self.sinfi_dockwidget.TR_ELE_cb.stateChanged.disconnect()
        self.sinfi_dockwidget.TR_GAS_cb.stateChanged.disconnect()
        self.sinfi_dockwidget.TR_OLE_cb.stateChanged.disconnect()
        self.sinfi_dockwidget.TR_SAC_cb.stateChanged.disconnect()
        self.sinfi_dockwidget.TR_TLR_cb.stateChanged.disconnect()
        self.sinfi_dockwidget.INFR_RT_ESTENSIONE_cb.stateChanged.disconnect()
        self.sinfi_dockwidget.stili_INFR_RT_ESTENSIONE_cb.currentIndexChanged.disconnect()

        self.sinfi_dockwidget.INFR_RT_ESTENSIONE_L_cb.stateChanged.disconnect()
        self.sinfi_dockwidget.stili_INFR_RT_ESTENSIONE_L_cb.currentIndexChanged.disconnect()

        self.sinfi_dockwidget.INFR_RT_ESTENSIONE_P_cb.stateChanged.disconnect()
        self.sinfi_dockwidget.stili_INFR_RT_ESTENSIONE_P_cb.currentIndexChanged.disconnect()

        try:
            self.sinfi_dockwidget.cb_gruppi.currentIndexChanged.disconnect()
        except:
            pass

        QgsProject.instance().layerRemoved.disconnect()
        self.remove_all_wms()

        self.root = None
        self.group_to_cap = None
        
        self.zoomato_italia = False

        self.zoom_mappa = False
        self.sfondi_admin = False

    def reset (self):
        self.minx,self.miny,self.maxx,self.maxy = None,None,None,None
        self.rect = None
        
        self.group_codes = None
        self.group_names = None
        self.roles_codes = None
        self.user = None
        self.psw = None
        self.admin = None
        self.cap = None
        #pulisco la combobox
        self.sinfi_dockwidget.cb_gruppi.currentIndexChanged.disconnect()
        
        self.sinfi_dockwidget.le_gruppi.setText('')
        self.sinfi_dockwidget.cb_gruppi.clear()

        self.dict_wms = None
        self.dict_sfondi = None
        self.sinfi_dockwidget.cb_gruppi.currentIndexChanged.connect(self.gruppo_cambiato)

        self.sinfi_dockwidget.tab_wms.setEnabled(True)
        self.sinfi_dockwidget.wms_layer_tabWidget.setVisible(True)
        self.sinfi_dockwidget.label_no_cap_wms.clear()
        self.sinfi_dockwidget.label_no_cap_wms.move(20,340)
        
        self.sinfi_dockwidget.cartodb_basemap_rb.setAutoExclusive(False)
        self.sinfi_dockwidget.osm_standard_rb.setAutoExclusive(False)
        self.sinfi_dockwidget.esri_world_imagery_rb.setAutoExclusive(False)

        self.sinfi_dockwidget.cartodb_basemap_rb.setChecked(False)
        self.sinfi_dockwidget.osm_standard_rb.setChecked(False)
        self.sinfi_dockwidget.esri_world_imagery_rb.setChecked(False)
        
        self.sinfi_dockwidget.cartodb_basemap_rb.setAutoExclusive(True)
        self.sinfi_dockwidget.osm_standard_rb.setAutoExclusive(True)
        self.sinfi_dockwidget.esri_world_imagery_rb.setAutoExclusive(True)

        self.group_to_cap = None
        
        self.zoomato_italia = None

        self.zoom_mappa = False
        self.sfondi_admin = None

    def set_group_to_cap(self,group_to_cap):
        self.group_to_cap = group_to_cap

    def set_ho_capabilities(self,ho_cap,messaggio = None):
        if ho_cap:
            self.cap = True
            
            if not messaggio:
                self.sinfi_dockwidget.label_no_cap_wms.clear()

                self.sinfi_dockwidget.tab_wms.setEnabled(True)
                self.sinfi_dockwidget.wms_layer_tabWidget.setVisible(True)
                self.sinfi_dockwidget.label_no_cap_wms.clear()
                self.sinfi_dockwidget.label_no_cap_wms.move(20,340)
            else:
                self.sinfi_dockwidget.wms_layer_tabWidget.setVisible(False)
                self.sinfi_dockwidget.label_no_cap_wms.setText(messaggio)
                    
                self.sinfi_dockwidget.label_no_cap_wms.move(10,10)
        else:
            self.cap = False
            
            self.sinfi_dockwidget.tab_wms.setEnabled(False)
            self.sinfi_dockwidget.wms_layer_tabWidget.setVisible(False)
            if not messaggio:
                self.sinfi_dockwidget.label_no_cap_wms.setText("Utente o gruppo non abilitato ai servizi WMS.")
            else:
                self.sinfi_dockwidget.label_no_cap_wms.setText(messaggio)
                
            self.sinfi_dockwidget.label_no_cap_wms.move(10,10)
            

    def gruppo_cambiato(self,current_index):
        
        current_group_code = self.group_codes[current_index]
        
            
        if self.sinfi_upload:
            self.sinfi_upload.gruppo_cambiato(current_index)

        if not self.cap:
            return None
        
        #come prima cosa aggiorno le tab wms
        #recupero il dizionario del gruppo
        cb_dict = self.dict_wms.get(current_group_code)
        
        check_stili_INFR_RT_ESTENSIONE = 0
        check_stili_INFR_RT_ESTENSIONE_L = 0
        check_stili_INFR_RT_ESTENSIONE_P = 0

        for k,v in list(cb_dict.items()):

            if k in self.stili_INFR_RT_ESTENSIONE:
                #se è true:
                if v[0]:
                    index = self.stili_INFR_RT_ESTENSIONE.index(k)
                    self.sinfi_dockwidget.stili_INFR_RT_ESTENSIONE_cb.setCurrentIndex(index)
                else: #altrimenti incremento la mia variabile di controllo
                    check_stili_INFR_RT_ESTENSIONE +=1
            elif k in self.stili_INFR_RT_ESTENSIONE_L:
                #se è true:
                if v[0]:
                    index = self.stili_INFR_RT_ESTENSIONE_L.index(k)
                    self.sinfi_dockwidget.stili_INFR_RT_ESTENSIONE_L_cb.setCurrentIndex(index)
                else: #altrimenti incremento la mia variabile di controllo
                    check_stili_INFR_RT_ESTENSIONE_L +=1
            elif k in self.stili_INFR_RT_ESTENSIONE_P:
                #se è true:
                if v[0]:
                    index = self.stili_INFR_RT_ESTENSIONE_P.index(k)
                    self.sinfi_dockwidget.stili_INFR_RT_ESTENSIONE_P_cb.setCurrentIndex(index)
                else: #altrimenti incremento la mia variabile di controllo
                    check_stili_INFR_RT_ESTENSIONE_P +=1
            elif k in self.sfondi:
                continue
            else:
                code_to_exec = f'self.sinfi_dockwidget.{k}_cb.setChecked({v[0]})'
                exec(code_to_exec)
        
        #se check_stili_INFR_RT_ESTENSIONE è pari a 5 e la cb è checcata la deflaggo
        if check_stili_INFR_RT_ESTENSIONE == 5:
            if self.sinfi_dockwidget.INFR_RT_ESTENSIONE_cb.isChecked():
                self.dict_wms[current_group_code]['INFR_RT_ESTENSIONE'] = [False,None]
                self.sinfi_dockwidget.INFR_RT_ESTENSIONE_cb.setChecked(False)
        if check_stili_INFR_RT_ESTENSIONE_L == 5:
            if self.sinfi_dockwidget.INFR_RT_ESTENSIONE_L_cb.isChecked():
                self.dict_wms[current_group_code]['INFR_RT_ESTENSIONE_L'] = [False,None]
                self.sinfi_dockwidget.INFR_RT_ESTENSIONE_L_cb.setChecked(False)
        if check_stili_INFR_RT_ESTENSIONE_P == 5:
            if self.sinfi_dockwidget.INFR_RT_ESTENSIONE_P_cb.isChecked():
                self.dict_wms[current_group_code]['INFR_RT_ESTENSIONE_P'] = [False,None]
                self.sinfi_dockwidget.INFR_RT_ESTENSIONE_P_cb.setChecked(False)

        self.sinfi_dockwidget.wms_layer_tabWidget.setCurrentIndex(0)
        
        
        url = f"https://{self.link}/data/ows/{current_group_code}/wms?service=WMS&request=GetCapabilities"
        
        res = requests.get(url, auth=HTTPBasicAuth(self.user, self.psw), verify=False)
                
        if res.status_code != 200:
            
            self.set_ho_capabilities(True,"Utente non abilitato a visualizzare\ni layer WMS per il gruppo selezionato.")
            return None
        
        root_tree = ET.fromstring(res.text)
        xml_layers_list = []
        for cap in root_tree.findall("{http://www.opengis.net/wms}Capability"):
            layer = cap.find("{http://www.opengis.net/wms}Layer")
            layers = layer.findall('{http://www.opengis.net/wms}Layer')
            for l in layers:
                name = l.find('{http://www.opengis.net/wms}Name')
                
                xml_layers_list.append(name.text)

        check_layer_wms = False
        for ll in self.layer_list_no_stili:
            if ll not in xml_layers_list:
                code_to_exec = f'self.sinfi_dockwidget.{ll}_cb.setEnabled(False)'
                exec(code_to_exec)
            else:
                code_to_exec = f'self.sinfi_dockwidget.{ll}_cb.setEnabled(True)'
                exec(code_to_exec)
                check_layer_wms = True        
                
        if not check_layer_wms:
            
            self.sinfi_dockwidget.tab_wms.setEnabled(False)
            self.set_ho_capabilities(False,"Non sono presenti layer WMS\nper il gruppo selezionato.")
            
        else:
            self.set_ho_capabilities(True)
            

        #recupero le coordinate della bbox
        # lo spazio dei nomi del WMS
        ns = {"wms": "http://www.opengis.net/wms"}

        # cerca il BoundingBox con CRS EPSG:3857
        bbox_elem = root_tree.find(".//wms:BoundingBox[@CRS='EPSG:3857']", ns)

        if bbox_elem is not None:
            self.minx = float(bbox_elem.attrib["minx"])
            self.miny = float(bbox_elem.attrib["miny"])
            self.maxx = float(bbox_elem.attrib["maxx"])
            self.maxy = float(bbox_elem.attrib["maxy"])

            self.rect = QgsRectangle(self.minx, self.miny, self.maxx, self.maxy)
        self.zoom_mappa = None
            
    def set_user_psw(self,user,psw,authCfdId,sinfi_upload = None):
        self.user = user
        self.psw = psw
        self.authCfdId = authCfdId
        self.sinfi_upload = sinfi_upload

    def aggiorna_cb_gruppi_admin(self,group_code,group_name):
        self.admin = True
        if not self.group_codes:
            self.group_codes = []
        if not self.group_names:
            self.group_names = []

        #aggiungo il nuovo elemento alla combobox
        if group_code not in self.group_codes and group_name not in self.group_names: 
            #recupero il current_index di cb_gruppi
            current_index = self.sinfi_dockwidget.cb_gruppi.currentIndex()
            if self.group_codes:
                current_group = self.group_codes[current_index]
            else:
                current_group = None
            
            #aggiungo i nuovi elementi alle liste
            self.group_codes.append(group_code)
            self.group_names.append(group_name)
            if not self.dict_wms:
                self.dict_wms = {}
            #inizializzo il dict per i gruppi
            temp_dict = {}
            for layer in self.layer_list:
                temp_dict[layer] = [False,None]
            self.dict_wms[group_code] = temp_dict
            
            
            #metto group_code e group_name in ordine alfabetico
            group_dict_to_sort = {}
            for i in range(0,len(self.group_codes)):
                group_dict_to_sort[self.group_codes[i]] = self.group_names[i]
                

            group_dict_sorted = dict(sorted(group_dict_to_sort.items(), key=lambda item: locale.strxfrm(item[1])))
            

            self.group_codes = list(group_dict_sorted.keys())
            
            self.group_names = list(group_dict_sorted.values())
            
            #pulisco cb_gruppi
            self.sinfi_dockwidget.cb_gruppi.currentIndexChanged.disconnect()
            self.sinfi_dockwidget.cb_gruppi.clear()

            #aggiungo gli elementi
            for i in range(0,len(self.group_names)):
                # print('adding ',self.group_names[i])
                self.sinfi_dockwidget.cb_gruppi.insertItem(i,self.group_names[i])
            
            #se avevo già un gruppo selezionato lo riseleziono
            if current_group:
                pos= self.group_codes.index(current_group)
                
                self.sinfi_dockwidget.cb_gruppi.setCurrentIndex(pos)
            else:
                self.gruppo_cambiato(0)
            
            self.sinfi_dockwidget.tab_wms.setEnabled(True)
            self.sinfi_dockwidget.tab_upload.setEnabled(True)

            if self.sinfi_upload:
                self.sinfi_upload.set_group_codes(self.group_codes)

            self.sinfi_dockwidget.cb_gruppi.currentIndexChanged.connect(self.gruppo_cambiato)

            self.iface.messageBar().pushMessage("SINFI WMS", f"Gruppo \"{group_name}\" aggiunto", level=0)
            self.sinfi_dockwidget.cartodb_basemap_rb.click()
                
    def aggiorna_cb_gruppi(self,group_codes,group_names,roles_codes,user,psw):
        try:
            self.sinfi_dockwidget.cb_gruppi.currentIndexChanged.disconnect()
        except:
            pass
        self.group_codes = group_codes
        self.group_names = group_names
        self.roles_codes = roles_codes
        self.user = user
        self.psw = psw
        #pulisco la combobox
        self.sinfi_dockwidget.cb_gruppi.clear()
        #aggiungo gli elementi alla combobox
        self.sinfi_dockwidget.cb_gruppi.addItems(self.group_names)

        self.dict_wms = {}
        #inizializzo il dict per i gruppi
        for gruppo in self.group_codes:
            temp_dict = {}
            for layer in self.layer_list:
                temp_dict[layer] = [False,None]

            self.dict_wms[gruppo] = temp_dict

        self.gruppo_cambiato(0)
        self.sinfi_dockwidget.cb_gruppi.currentIndexChanged.connect(self.gruppo_cambiato)

        self.iface.addDockWidget(Qt.RightDockWidgetArea, self.sinfi_dockwidget)
        
        self.sinfi_dockwidget.cartodb_basemap_rb.click()

        self.sinfi_dockwidget.tab_servizi_sinfi.setCurrentIndex(0)
        self.sinfi_dockwidget.show()

    def abilita_infr_rt(self,value,nome,combobox,lista_stile_layer,lista_nome_stile):
        #recupero l'indice del gruppo selezionato dalla combobox
        current_index = self.sinfi_dockwidget.cb_gruppi.currentIndex()
        #recupero il codice e il nome del gruppo
        current_group_code = self.group_codes[current_index]
        self.dict_wms[current_group_code][nome] = [value,None]

        #imposto la relativa combobox allo stesso stato della checkbox
        combobox.setEnabled(value)

        #recupero l'indice della combobox e il nome del relativo stile
        index = combobox.currentIndex()
        stile_layer = lista_stile_layer[index]

        #se la checkbox è disabilitata chiamo il rimuoviWMs
        if not value:
            self.remove_wms(stile_layer)
            combobox.setCurrentIndex(-1)
        else:
            combobox.setCurrentIndex(0)
            #altrimenti aggiungo il wms dell'Index 0

    def checcato(self,value,nome):
        if value:
            self.download_wms(nome)
        else:
            self.remove_wms(nome)

    def checcato_con_stile(self,index,nome,lista_stile_layer,lista_nome_stile):
        if index != -1:
            #cerco se esiste già un layer nel gruppo corrente della stessa categoria di infra_rt
            current_index = self.sinfi_dockwidget.cb_gruppi.currentIndex()
            #recupero il codice e il nome del gruppo
            current_group_code = self.group_codes[current_index]
            
            #recupero stile_layer e nome_stile
            stile_layer = lista_stile_layer[index]
            nome_stile = lista_nome_stile[index]
            
            #se il layer attuale è già presente non faccio niente
            current_bool = self.dict_wms.get(current_group_code).get(stile_layer)[0]
            if not current_bool:
                #passo il layer da aggiungere a download_wms
                self.download_wms(nome,stile_layer,nome_stile)

            #cerco i layer in lista_stile_layer del gruppo e rimuovo quelli a True
            for itero_stile_layer in lista_stile_layer:
                if itero_stile_layer == stile_layer:
                    continue
                current_bool = self.dict_wms.get(current_group_code).get(itero_stile_layer)[0]
                if current_bool:
                    self.remove_wms(itero_stile_layer)
            
        
    def download_wms(self,nome_layer,stile_layer = None, nome_stile = None,admin=None):
        #controllo che il layer non sia di sfondo
        if nome_layer not in self.sfondi:
            #recupero l'indice del gruppo selezionato dalla combobox
            current_index = self.sinfi_dockwidget.cb_gruppi.currentIndex()
            #recupero il codice e il nome del gruppo
            current_group_code = self.group_codes[current_index]
            current_group_name = self.group_names[current_index]
            
            #se il layer corrente è False allora procedo
            if stile_layer:
                current_bool = self.dict_wms.get(current_group_code).get(stile_layer)[0]
            else:
                current_bool = self.dict_wms.get(current_group_code).get(nome_layer)[0]
            if not current_bool:
                
                #se esiste recupero il gruppo in cui aggiungere il layer, altrimenti lo creo
                if self.root.findGroup(current_group_name):
                    layer_group = self.root.findGroup(current_group_name)
                else:
                    self.root.insertGroup(0,current_group_name)
                    layer_group = self.root.findGroup(current_group_name)

                uri_config = dict(
                    authcfg = self.authCfdId,
                    layers = nome_layer,
                    crs = "EPSG:3857",
                    contextualWMSLegend='0',
                    dpiMode='7',
                    featureCount='10',
                    format='image/png',
                    styles=stile_layer,
                    tilePixelRatio='0',
                    url=f'https://{self.link}/data/ows/{current_group_code}/wms'
                )
                uri = QgsDataSourceUri()
                for key,val in uri_config.items():
                    uri.setParam(key,val)
                    
                if stile_layer:
                    wms_layer = QgsRasterLayer(bytes(uri.encodedUri()).decode(), nome_stile, 'wms')
                else:
                    wms_layer = QgsRasterLayer(bytes(uri.encodedUri()).decode(), f'SINFI: {nome_layer}', 'wms')            
                
                #aggiungo il layer nel gruppo designato
                added_layer = QgsProject.instance().addMapLayer(wms_layer,False)
                index_pos = 0
                if nome_layer in self.layer_lineari or stile_layer in self.layer_lineari:
                    index_pos = -1
                layer_group.insertLayer(index_pos,added_layer)

                #recupero il riferimento alla checkbox nel dict,aggiorno lo stato e inserisco l'id del layer appena inserito
                if stile_layer:
                    self.dict_wms[current_group_code][stile_layer] = [True,added_layer.id()]
                    self.layer_dict[added_layer.id()] = [current_group_code,stile_layer]
                else:
                    self.dict_wms[current_group_code][nome_layer] = [True,added_layer.id()]
                    self.layer_dict[added_layer.id()] = [current_group_code,nome_layer]
                
                if not self.zoom_mappa:
                    self.zoom_mappa  = True
                    self.iface.mapCanvas().setExtent(self.rect)
                    self.iface.mapCanvas().refresh()
        else:
            if not self.dict_sfondi:
                self.dict_sfondi = {}

            #se esiste recupero il gruppo in cui aggiungere il layer, altrimenti lo creo
            if self.root.findGroup("Sfondi"):
                sfondi_group = self.root.findGroup("Sfondi")
            else:
                self.root.insertGroup(-1,"Sfondi")
                sfondi_group = self.root.findGroup("Sfondi")

            layer_id = nome_layer
            sfondi_list = self.dict_sfondi_nome.get(nome_layer)
            layer_name = sfondi_list[0]
            url = sfondi_list[1]

            layer_sfondo = QgsRasterLayer("type=xyz&url=" + url, layer_name, "wms")
            added_layer = QgsProject.instance().addMapLayer(layer_sfondo,False)
            
            sfondi_group.insertLayer(-1,added_layer)
            
            self.dict_sfondi[nome_layer] = [True,added_layer.id()]
            if not self.zoomato_italia:
                self.zoomato_italia = True
                QTimer.singleShot(200, lambda: self._zoom_to_italia())

    def _zoom_to_italia(self):
        canvas = self.iface.mapCanvas()
        canvas.setDestinationCrs(QgsCoordinateReferenceSystem("EPSG:3857"))
        canvas.setExtent(self.zoom_italia)
        canvas.refresh()
        canvas.repaint()

    def remove_wms(self,nome_layer):
        
        if nome_layer not in self.sfondi:
            #recupero l'indice del gruppo selezionato dalla combobox
            current_index = self.sinfi_dockwidget.cb_gruppi.currentIndex()
            #recupero il codice del gruppo
            current_group_code = self.group_codes[current_index]

            #se il layer corrente è True allora procedo
            current_bool = self.dict_wms.get(current_group_code).get(nome_layer)[0]
            if current_bool:
                #recupero l'id del layer da rimuovere
                id_da_rimuovere = self.dict_wms.get(current_group_code).get(nome_layer)[1]
                #controllo che il layer sia ancora presente:
                layer= QgsProject.instance().mapLayer(id_da_rimuovere)
                if layer:
                    QgsProject.instance().removeMapLayer(id_da_rimuovere)
                #recupero il riferimento alla checkbox nel dict, aggiorno lo stato e rimuovo l'id del layer
                self.dict_wms[current_group_code][nome_layer] = [False,None]
                self.iface.mapCanvas().refresh()
        else:
            if self.dict_sfondi:
                id_da_rimuovere = self.dict_sfondi.get(nome_layer,None)
                if id_da_rimuovere:
                    id_da_rimuovere = id_da_rimuovere[1]
                    layer= QgsProject.instance().mapLayer(id_da_rimuovere)
                    if layer:
                        QgsProject.instance().removeMapLayer(id_da_rimuovere)
                else:
                    self.sinfi_dockwidget.cartodb_basemap_rb.click()
    def remove_all_wms(self):
        
        if self.group_codes:
            for current_group_code in self.group_codes:
                layer_dict = self.dict_wms.get(current_group_code)
                for v in list(layer_dict.values()):
                    id_da_rimuovere= v[1]
                    if id_da_rimuovere:
                        layer= QgsProject.instance().mapLayer(id_da_rimuovere)
                        if layer:
                            QgsProject.instance().removeMapLayer(id_da_rimuovere)
            
            for current_group_name in self.group_names:
                if self.root.findGroup(current_group_name):
                    self.root.removeChildNode(self.root.findGroup(current_group_name))

            
            if self.root.findGroup('Sfondi'):
                self.root.removeChildNode(self.root.findGroup('Sfondi'))
                
            self.iface.mapCanvas().refresh()

    def layer_removed_listener(self,id_layer_rimosso):

        if id_layer_rimosso in list(self.layer_dict.keys()):
            layer_list = self.layer_dict.get(id_layer_rimosso)
            group_code = layer_list[0]
            nome_layer = layer_list[1]
            self.dict_wms[group_code][nome_layer] = [False,None]

            current_index = self.sinfi_dockwidget.cb_gruppi.currentIndex()
            current_group_code = self.group_codes[current_index]
            check_stili_INFR_RT_ESTENSIONE = 0
            check_stili_INFR_RT_ESTENSIONE_L = 0
            check_stili_INFR_RT_ESTENSIONE_P = 0
            if group_code == current_group_code:
                
                cb_dict = self.dict_wms.get(current_group_code)
                
                check_stili_INFR_RT_ESTENSIONE = 0
                check_stili_INFR_RT_ESTENSIONE_L = 0
                check_stili_INFR_RT_ESTENSIONE_P = 0

                for k,v in list(cb_dict.items()):

                    if k in self.stili_INFR_RT_ESTENSIONE:
                        if v[0]:
                            check_stili_INFR_RT_ESTENSIONE +=1
                    elif k in self.stili_INFR_RT_ESTENSIONE_L:
                        if v[0]:
                            check_stili_INFR_RT_ESTENSIONE_L +=1
                    elif k in self.stili_INFR_RT_ESTENSIONE_P:
                        if v[0]:
                            check_stili_INFR_RT_ESTENSIONE_P +=1
                    elif k in self.sfondi:
                        continue
                    else:
                        code_to_exec = f'self.sinfi_dockwidget.{k}_cb.setChecked({v[0]})'
                        exec(code_to_exec)
                
                if check_stili_INFR_RT_ESTENSIONE == 0:
                    if self.sinfi_dockwidget.INFR_RT_ESTENSIONE_cb.isChecked():
                        self.sinfi_dockwidget.stili_INFR_RT_ESTENSIONE_cb.setCurrentIndex(-1)
                if check_stili_INFR_RT_ESTENSIONE_L == 0:
                    if self.sinfi_dockwidget.INFR_RT_ESTENSIONE_L_cb.isChecked():
                        self.sinfi_dockwidget.stili_INFR_RT_ESTENSIONE_L_cb.setCurrentIndex(-1)
                if check_stili_INFR_RT_ESTENSIONE_P == 0:
                    if self.sinfi_dockwidget.INFR_RT_ESTENSIONE_P_cb.isChecked():
                        self.sinfi_dockwidget.stili_INFR_RT_ESTENSIONE_P_cb.setCurrentIndex(-1)