"""
/***************************************************************************
 Servizi Sinfi
                                 A QGIS plugin
 Plugin per accedere ai servizi Sinfi da piattaforma QGis
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-04-16
        copyright            : (C) 2025 by Infratel Italia
        email                : info@sinfi.it
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import requests
import json
from ..utils import sinfi_utils

class PdndStatistico():

    def __init__(self,pdnd_dockwidget,login_pdnd,link_pdnd,iface):
        self.pdnd_dockwidget = pdnd_dockwidget
        self.link_pdnd = link_pdnd
        self.login_pdnd = login_pdnd
        self.iface = iface

        self.pdnd_dockwidget.get_aggregate_stats.clicked.connect(self.get_aggregate_stats)

        self.dict_regioni = {}
        self.dict_regioni_per_codice = {}
        self.current_codice_regione = None

        self.dict_province = {}
        self.dict_province_per_codice = {}
        self.dict_province_per_codice_regione = {}
        self.current_codice_province = None

        self.dict_comuni = {}
        self.dict_comuni_per_codice = {}
        self.dict_comuni_per_codice_provincia = {}
        self.current_codice_comuni = None
        self.pdnd_dockwidget.tab_riepilogo_statistiche.setVisible(False)
        

    def unload(self):
        self.reset_gui()
        try:
            self.pdnd_dockwidget.get_aggregate_stats.clicked.disconnect()
        except:
            pass

        try:
            self.pdnd_dockwidget.regioni_cb.currentIndexChanged.disconnect()
        except:
            pass
        
        try:
            self.pdnd_dockwidget.province_cb.currentIndexChanged.disconnect()
        except:
            pass
        
    def reset(self):
        self.dict_regioni = {}
        self.dict_regioni_per_codice = {}
        self.current_codice_regione = None

        self.dict_province = {}
        self.dict_province_per_codice = {}
        self.dict_province_per_codice_regione = {}
        self.current_codice_province = None

        self.dict_comuni = {}
        self.dict_comuni_per_codice = {}
        self.dict_comuni_per_codice_provincia = {}
        self.current_codice_comuni = None

        self.pdnd_dockwidget.regioni_cb.clear()
        self.pdnd_dockwidget.province_cb.clear()
        self.pdnd_dockwidget.comuni_cb.clear()

        self.pdnd_dockwidget.titolo.clear()
        self.pdnd_dockwidget.rete_stradale.clear()
        self.pdnd_dockwidget.abitanti.clear()
        self.pdnd_dockwidget.superficie.clear()
        self.pdnd_dockwidget.regioni.clear()
        self.pdnd_dockwidget.province.clear()
        self.pdnd_dockwidget.comuni.clear()

        self.pdnd_dockwidget.tratte_infr_rt.clear()
        self.pdnd_dockwidget.gestore_tratte_infr_rt.clear()
        self.pdnd_dockwidget.nodi_infr_rt.clear()
        self.pdnd_dockwidget.gestore_nodi_infr_rt.clear()

        self.pdnd_dockwidget.tratte_com.clear()
        self.pdnd_dockwidget.gestore_tratte_com.clear()
        self.pdnd_dockwidget.nodi_com.clear()
        self.pdnd_dockwidget.gestore_nodi_com.clear()

        self.pdnd_dockwidget.tratte_sac.clear()
        self.pdnd_dockwidget.gestore_tratte_sac.clear()
        self.pdnd_dockwidget.nodi_sac.clear()
        self.pdnd_dockwidget.gestore_nodi_sac.clear()

        self.pdnd_dockwidget.tratte_ele.clear()
        self.pdnd_dockwidget.gestore_tratte_ele.clear()
        self.pdnd_dockwidget.nodi_ele.clear()
        self.pdnd_dockwidget.gestore_nodi_ele.clear()

        self.pdnd_dockwidget.tratte_gas.clear()
        self.pdnd_dockwidget.gestore_tratte_gas.clear()
        self.pdnd_dockwidget.nodi_gas.clear()
        self.pdnd_dockwidget.gestore_nodi_gas.clear()

        self.pdnd_dockwidget.tratte_aac.clear()
        self.pdnd_dockwidget.gestore_tratte_aac.clear()
        self.pdnd_dockwidget.nodi_aac.clear()
        self.pdnd_dockwidget.gestore_nodi_aac.clear()

        self.pdnd_dockwidget.tratte_tlr.clear()
        self.pdnd_dockwidget.gestore_tratte_tlr.clear()
        self.pdnd_dockwidget.nodi_tlr.clear()
        self.pdnd_dockwidget.gestore_nodi_tlr.clear()

        self.pdnd_dockwidget.tratte_ole.clear()
        self.pdnd_dockwidget.gestore_tratte_ole.clear()
        self.pdnd_dockwidget.nodi_ole.clear()
        self.pdnd_dockwidget.gestore_nodi_ole.clear()


        self.reset_gui()
    
    def non_ho_cap(self):
        # self.pdnd_dockwidget.tab_statistico.setEnabled(False)
        self.hide_gui()
        self.pdnd_dockwidget.label_no_cap_statistico.setText('Utente non abilitato al servizio Statistico')
        self.pdnd_dockwidget.label_no_cap_statistico.show()

    def hide_gui(self):
        self.pdnd_dockwidget.label_regioni.setVisible(False)
        self.pdnd_dockwidget.regioni_cb.setVisible(False)

        self.pdnd_dockwidget.label_province.setVisible(False)
        self.pdnd_dockwidget.province_cb.setVisible(False)

        self.pdnd_dockwidget.label_comuni.setVisible(False)
        self.pdnd_dockwidget.comuni_cb.setVisible(False)

        self.pdnd_dockwidget.get_aggregate_stats.setVisible(False)

        self.pdnd_dockwidget.label_no_cap_statistico.move(10,10)
        self.pdnd_dockwidget.label_no_cap_statistico.show()
        self.pdnd_dockwidget.tab_riepilogo_statistiche.setVisible(False)
        
    def reset_gui(self):
        #resetto la gui
        self.pdnd_dockwidget.label_regioni.setVisible(True)
        self.pdnd_dockwidget.label_regioni.move(10,10)
        self.pdnd_dockwidget.regioni_cb.setVisible(True)
        self.pdnd_dockwidget.regioni_cb.move(150,10)

        self.pdnd_dockwidget.label_province.setVisible(True)
        self.pdnd_dockwidget.label_province.move(10,40)
        self.pdnd_dockwidget.province_cb.setVisible(True)
        self.pdnd_dockwidget.province_cb.move(150,40)

        self.pdnd_dockwidget.label_comuni.setVisible(True)
        self.pdnd_dockwidget.label_comuni.move(10,70)
        self.pdnd_dockwidget.comuni_cb.setVisible(True)
        self.pdnd_dockwidget.comuni_cb.move(150,70)

        self.pdnd_dockwidget.get_aggregate_stats.move(60,100)
        self.pdnd_dockwidget.get_aggregate_stats.setVisible(True)

        self.pdnd_dockwidget.titolo.move(10,10)
        self.pdnd_dockwidget.titolo.clear()
        self.pdnd_dockwidget.titolo.resize(250,20)

        self.pdnd_dockwidget.tab_riepilogo_statistiche.move(10,130)

        self.show_tab(self.pdnd_dockwidget.tab_riepilogo_statistiche, self.pdnd_dockwidget.tab_infr_rt,'Infrastrutture di Alloggiamento Reti',1)
        self.show_tab(self.pdnd_dockwidget.tab_riepilogo_statistiche, self.pdnd_dockwidget.tab_com,'Telecomunicazioni',2)
        self.show_tab(self.pdnd_dockwidget.tab_riepilogo_statistiche, self.pdnd_dockwidget.tab_sac,'Smaltimento Acque',3)
        self.show_tab(self.pdnd_dockwidget.tab_riepilogo_statistiche, self.pdnd_dockwidget.tab_ele,'Elettrica',4)
        self.show_tab(self.pdnd_dockwidget.tab_riepilogo_statistiche, self.pdnd_dockwidget.tab_gas,'Gas',5)
        self.show_tab(self.pdnd_dockwidget.tab_riepilogo_statistiche, self.pdnd_dockwidget.tab_aac,'Approvigionamento Idrico',6)
        self.show_tab(self.pdnd_dockwidget.tab_riepilogo_statistiche, self.pdnd_dockwidget.tab_tlr,'Teleriscaldamento',7)
        self.show_tab(self.pdnd_dockwidget.tab_riepilogo_statistiche, self.pdnd_dockwidget.tab_ole,'Oleodotti',8)
        

        self.pdnd_dockwidget.tab_riepilogo_statistiche.setCurrentIndex(0)
        self.pdnd_dockwidget.tab_riepilogo_statistiche.setVisible(False)
        
        self.pdnd_dockwidget.label_no_cap_statistico.move(20,380)
        self.pdnd_dockwidget.label_no_cap_statistico.hide()
        self.pdnd_dockwidget.label_no_cap_statistico.clear()

    def move_elements(self,tipo):
        if tipo =='regione':
            self.pdnd_dockwidget.label_regioni.setVisible(False)
            self.pdnd_dockwidget.regioni_cb.setVisible(False)
        elif tipo =='province':
            self.pdnd_dockwidget.label_province.setVisible(False)
            self.pdnd_dockwidget.province_cb.setVisible(False)
        elif tipo =='comuni':
            self.pdnd_dockwidget.label_comuni.setVisible(False)
            self.pdnd_dockwidget.comuni_cb.setVisible(False)

        #sposto gli elementi
        self.pdnd_dockwidget.label_regioni.move(10,self.pdnd_dockwidget.label_regioni.y()-30)
        self.pdnd_dockwidget.regioni_cb.move(150,self.pdnd_dockwidget.regioni_cb.y()-30)

        self.pdnd_dockwidget.label_province.move(10,self.pdnd_dockwidget.label_province.y()-30)
        self.pdnd_dockwidget.province_cb.move(150,self.pdnd_dockwidget.province_cb.y()-30)

        self.pdnd_dockwidget.label_comuni.move(10,self.pdnd_dockwidget.label_comuni.y()-30)
        self.pdnd_dockwidget.comuni_cb.move(150,self.pdnd_dockwidget.comuni_cb.y()-30)

        self.pdnd_dockwidget.get_aggregate_stats.move(60,self.pdnd_dockwidget.get_aggregate_stats.y()-30)

        self.pdnd_dockwidget.tab_riepilogo_statistiche.move(10,self.pdnd_dockwidget.tab_riepilogo_statistiche.y()-30)

    def fmt_int(self,x): 
        return f"{int(x):,}".replace(",", ".")
    def fmt_float(self,x): 
        return f"{x:,.2f}".replace(",", "X").replace(".", ",").replace("X", ".")

    def regione_cambiata(self,index):
        #recupero l'elemento corrente
        testo_corrente = self.pdnd_dockwidget.regioni_cb.currentText()
        #pulisco province e comuni
        self.pdnd_dockwidget.province_cb.clear()
        self.pdnd_dockwidget.comuni_cb.clear()
        if testo_corrente:
            nuovo_codice_corrente = self.dict_regioni.get(testo_corrente)
            self.current_codice_regione = nuovo_codice_corrente

            lista_province_per_codice = self.dict_province_per_codice_regione.get(self.current_codice_regione)
            lista_province = [f[1] for f in self.dict_province_per_codice.items() if f[0] in lista_province_per_codice]
            lista_province.insert(0,'')
            
            self.pdnd_dockwidget.province_cb.clear()
            self.pdnd_dockwidget.province_cb.addItems(lista_province)
            
            self.pdnd_dockwidget.province_cb.setCurrentIndex(-1)

    def provincia_cambiata(self,index):
        #recupero l'elemento corrente
        testo_corrente = self.pdnd_dockwidget.province_cb.currentText()
        #pulisco comuni
        self.pdnd_dockwidget.comuni_cb.clear()
        if testo_corrente:
            nuovo_codice_corrente = self.dict_province.get(testo_corrente)
            self.current_codice_province = nuovo_codice_corrente
            lista_comuni_per_codice = self.dict_comuni_per_codice_provincia.get(self.current_codice_province)
            lista_comuni = [f[1] for f in self.dict_comuni_per_codice.items() if f[0] in lista_comuni_per_codice]
            lista_comuni.insert(0,'')
            self.pdnd_dockwidget.comuni_cb.clear()
            self.pdnd_dockwidget.comuni_cb.addItems(lista_comuni)

            self.pdnd_dockwidget.comuni_cb.setCurrentIndex(-1)        

    def set_groups(self):
        #creo il voucher e recupero bearer e jws
        voucher = self.login_pdnd.request_voucher("statistico")
        bearer = voucher["bearer"]
        jws = voucher["jws"]
        
        #recupero tutte i gruppi appartenenti al gruppo corrente
        url = f"https://{self.link_pdnd}/qgis/rest/api/system/get_istat_by_group/?group_code=''"
        headers = {
            'Authorization': f'Bearer {bearer}',
            "Agid-JWT-TrackingEvidence": jws
        }
        req = requests.get(url, headers=headers, verify=False)
        if req.status_code == 200:
            bad_text = req.text
            fixed_text = bad_text.encode('latin1', errors='ignore').decode('utf-8', errors='replace')
            req_json = json.loads(fixed_text)

            #regioni
            req_regioni = req_json["region"]
            for regione in req_regioni:
                name = regione["name"]
                code = regione["code"]
                
                self.dict_regioni[name] = code
                self.dict_regioni_per_codice[code] = name

            #province
            req_province = req_json["province"]
            for provincia in req_province:
                name = provincia["name"]
                code = provincia["code"]
                codice_regione = provincia["region"]

                self.dict_province[name] = code
                self.dict_province_per_codice[code] = name
                if codice_regione not in self.dict_province_per_codice_regione:
                    self.dict_province_per_codice_regione[codice_regione] = [code]
                else:
                    lista_codici_regione_province = self.dict_province_per_codice_regione.get(codice_regione)
                    lista_codici_regione_province.append(code)
                    self.dict_province_per_codice_regione[codice_regione] = lista_codici_regione_province

            #comuni
            req_city = req_json["city"]
            for comune in req_city:
                name = comune["name"]
                code = comune["code"]
                codice_provincia = comune["province"]["code"]

                self.dict_comuni[name] = code
                self.dict_comuni_per_codice[code] = name

                if codice_provincia not in self.dict_comuni_per_codice_provincia:
                    self.dict_comuni_per_codice_provincia[codice_provincia] = [code]
                else:
                    lista_codici_province_comuni = self.dict_comuni_per_codice_provincia.get(codice_provincia)
                    lista_codici_province_comuni.append(code)
                    self.dict_comuni_per_codice_provincia[codice_provincia] = lista_codici_province_comuni
            
        if not self.dict_regioni:
            #disabilito gli elementi per regioni
            self.move_elements('regioni')
        else:
            lista_regioni = [f for f in self.dict_regioni.keys()]
            self.pdnd_dockwidget.regioni_cb.clear()
            self.pdnd_dockwidget.regioni_cb.addItems(lista_regioni)
            self.pdnd_dockwidget.regioni_cb.setCurrentIndex(0)
            self.current_codice_regione = self.dict_regioni.get(lista_regioni[0])

            self.pdnd_dockwidget.regioni_cb.currentIndexChanged.connect(lambda index: self.regione_cambiata(index))
            
        if not self.dict_province:
            #disabilito gli elementi per province
            self.move_elements('province')
        else:
            if self.current_codice_regione:
                lista_province_per_codice = self.dict_province_per_codice_regione.get(self.current_codice_regione)
                lista_province = [f[1] for f in self.dict_province_per_codice.items() if f[0] in lista_province_per_codice]
                lista_province.insert(0,'')
            else:
                lista_province = [f for f in self.dict_province.keys()]

            self.pdnd_dockwidget.province_cb.clear()
            self.pdnd_dockwidget.province_cb.addItems(lista_province)
            if not self.current_codice_regione:
                self.pdnd_dockwidget.province_cb.setCurrentIndex(0)
                self.current_codice_province = self.dict_province.get(lista_province[0])
            else:
                self.pdnd_dockwidget.province_cb.setCurrentIndex(-1)
            
            self.pdnd_dockwidget.province_cb.currentIndexChanged.connect(lambda index: self.provincia_cambiata(index))

        if not self.dict_comuni:
            #disabilito gli elementi per comuni
            self.move_elements('comuni')
        else:
            if not self.current_codice_regione:
                if self.current_codice_province:
                    lista_comuni_per_codice = self.dict_comuni_per_codice_provincia.get(self.current_codice_province)
                    lista_comuni = [f[1] for f in self.dict_comuni_per_codice.items() if f[0] in lista_comuni_per_codice]
                    lista_comuni.insert(0,'')
                else:
                    lista_comuni = [f for f in self.dict_comuni.keys()]
                self.pdnd_dockwidget.comuni_cb.clear()
                self.pdnd_dockwidget.comuni_cb.addItems(lista_comuni)

                if not self.current_codice_province:
                    self.pdnd_dockwidget.comuni_cb.setCurrentIndex(0)
                else:
                    self.pdnd_dockwidget.comuni_cb.setCurrentIndex(-1)        
        
        self.pdnd_dockwidget.label_no_cap_statistico.move(10,200)
        self.pdnd_dockwidget.label_no_cap_statistico.hide()
        self.pdnd_dockwidget.label_no_cap_statistico.clear()
    def get_aggregate_stats(self):
        self.pdnd_dockwidget.get_aggregate_stats.setEnabled(False)
        #recupero il codice da passare
        territorio = None
        titolo = ''
        messaggio_bar = None
        #se dict comuni esiste verifico se ho un comune selezionato nella combobox
        if self.dict_comuni:
            current_index = self.pdnd_dockwidget.comuni_cb.currentIndex()
            if current_index != -1:
                current_text = self.pdnd_dockwidget.comuni_cb.currentText()
                titolo = f"Comune: {current_text}"
                territorio = self.dict_comuni.get(current_text)
                messaggio_bar = f'Statistiche recuperate per il comune di {current_text}'

        #se territorio è ancora nullo e esiste dict_province
        if not territorio and self.dict_province:
            current_index = self.pdnd_dockwidget.province_cb.currentIndex()
            if current_index != -1:
                current_text = self.pdnd_dockwidget.province_cb.currentText()
                titolo = f"Provincia: {current_text}"
                territorio = self.dict_province.get(current_text)
                messaggio_bar = f'Statistiche recuperate per la provincia di {current_text}'

        #se territorio è ancora nullo e esiste dict_regioni
        if not territorio and self.dict_regioni:
            current_index = self.pdnd_dockwidget.regioni_cb.currentIndex()
            if current_index != -1:
                current_text = self.pdnd_dockwidget.regioni_cb.currentText()
                titolo = f"Regione: {current_text}"
                territorio = self.dict_regioni.get(current_text)
                messaggio_bar = f'Statistiche recuperate per la regione {current_text}'
        
        if not messaggio_bar:
            messaggio_bar = 'Statistiche recuperate'
        
        voucher = self.login_pdnd.request_voucher("statistico")
        bearer = voucher["bearer"]
        jws = voucher["jws"]
        
        url = f"https://{self.link_pdnd}/sinfi/pdnd/stats/1.0.0/sinfi_stats_get_aggregate_stats/"

        headers = {
            'Authorization': f'Bearer {bearer}',
            "Agid-JWT-TrackingEvidence": jws,
            "accept" : "application/json",
            "content-type" : "application/json"
        }

        if territorio:
            body =f"""{{
                "group_code": "",
                "query": {{
                    "territories":["{territorio}"
                    ]
                }}
                }}"""
        else:
            body =f"""{{
            "group_code": "",
            "query": {{
                "territories":[
                ]
            }}
            }}"""

        req = requests.post(url, headers=headers, data=body, verify=False)
        
        if req.status_code == 200:
        
            req_json = json.loads(req.text)
            data = req_json["retdata"]["data"]
            km = data["km"]
            population = data["population"]
            area = data["area"]
            regions = data["total_regions"]
            provinces = data["total_provinces"]
            cities = data["total_cities"]
            
            self.pdnd_dockwidget.titolo.setText(titolo)
            if km:
                text = f"- Rete Stradale Stimata: {self.fmt_int(km)} km"
            else:
                text = f"- Rete Stradale Stimata: -- km"
            self.pdnd_dockwidget.rete_stradale.setText(text)
            
            if population:
                text = f"- Abitanti: {self.fmt_int(population)}"
            else:
                text = f"- Abitanti: --"
            self.pdnd_dockwidget.abitanti.setText(text)
            
            if area:
                text = f"- Superficie: {self.fmt_float(area)} km²"
            else:
                text = f"- Superficie: -- km²"
            self.pdnd_dockwidget.superficie.setText(text)

            if regions:
                text = f"- Totale Regioni: {regions}"
            else:
                text = f"- Totale Regioni: --"
            self.pdnd_dockwidget.regioni.setText(text)

            if provinces:
                text = f"- Province: {provinces}"
            else:
                text = f"- Province: --"
            self.pdnd_dockwidget.province.setText(text)

            if cities:
                text = f"- Comuni: {cities}"
            else:
                text = f"- Comuni: --"
            self.pdnd_dockwidget.comuni.setText(text)
            
            self.iface.messageBar().pushMessage("PDND STATISTICHE", messaggio_bar, level=0)

            self.pdnd_dockwidget.tab_riepilogo_statistiche.setVisible(True)
        else:
            self.pdnd_dockwidget.tab_riepilogo_statistiche.setVisible(False)
            sinfi_utils.message_creator("Attenzione","warning",req.text)

        #####################recupero gli altri dati
        url = f"https://{self.link_pdnd}/sinfi/pdnd/stats/1.0.0/sinfi_stats_get_data/"
   
        headers = {
            'Authorization': f'Bearer {bearer}',
            "Agid-JWT-TrackingEvidence": jws,
            "accept" : "application/json",
            "content-type" : "application/json"
        }
        
        if territorio:
            body =f"""{{
                "query": {{
                    "territories": ["{territorio}"],
                    "datatypes": [],
                    "ownerids": []
                }}
                }}"""
            
            req = requests.post(url, headers=headers, data=body, verify=False)
            
            if req.status_code == 200:
                req_json = json.loads(req.text)
                
                stats = req_json["retdata"]["data"]["stats"]
                cover = stats["cover"]

                # Tutte le chiavi richieste
                keys_to_extract = [
                    "ND_AAC","ND_COM","ND_ELE","ND_GAS","ND_OLE","ND_SAC","ND_TLR",
                    "TR_AAC","TR_COM","TR_ELE","TR_GAS","TR_OLE","TR_SAC","TR_TLR",
                    "INFR_RT_ESTENSIONE_L","INFR_RT_ESTENSIONE_P"
                ]

                estratti = {}

                for k in keys_to_extract:
                    if k in cover:
                        estratti[k] = [cover[k].get("data", None),cover[k].get("total_owners",None)]
                    else:
                        estratti[k] = None  # chiave non presente

                self.pdnd_dockwidget.tab_riepilogo_statistiche.setVisible(True)
                
                #aggiorno le tab   
                #infr_rt
                if estratti.get("INFR_RT_ESTENSIONE_L") and estratti.get("INFR_RT_ESTENSIONE_P"):
                    tratte = estratti.get("INFR_RT_ESTENSIONE_L")
                    km_tratte = str(tratte[0]/1000).replace('.',',')
                    gestori_tratte = tratte[1]
                    
                    self.pdnd_dockwidget.tratte_infr_rt.setText(f"{km_tratte} km di tratte")
                    self.pdnd_dockwidget.gestore_tratte_infr_rt.setText(f"{gestori_tratte} gestori di tratte")

                    nodi = estratti.get("INFR_RT_ESTENSIONE_P")
                    n_nodi = nodi[0]
                    gestori_nodi = nodi[1]

                    self.pdnd_dockwidget.nodi_infr_rt.setText(f"{n_nodi} nodi")
                    self.pdnd_dockwidget.gestore_nodi_infr_rt.setText(f"{gestori_nodi} gestori di nodi")
                    
                    self.show_tab(self.pdnd_dockwidget.tab_riepilogo_statistiche, self.pdnd_dockwidget.tab_infr_rt,'Infrastrutture di Alloggiamento Reti',1)
                else:
                    self.hide_tab(self.pdnd_dockwidget.tab_riepilogo_statistiche, self.pdnd_dockwidget.tab_infr_rt)
                

                #com
                if estratti.get("ND_COM") and estratti.get("TR_COM"):
                    tratte = estratti.get("TR_COM")
                    km_tratte = str(tratte[0]/1000).replace('.',',')
                    gestori_tratte = tratte[1]
                    
                    nodi = estratti.get("ND_COM")
                    n_nodi = nodi[0]
                    gestori_nodi = nodi[1]
                    
                    self.pdnd_dockwidget.tratte_com.setText(f"{km_tratte} km di tratte")
                    self.pdnd_dockwidget.gestore_tratte_com.setText(f"{gestori_tratte} gestori di tratte")
                    self.pdnd_dockwidget.nodi_com.setText(f"{n_nodi} nodi")
                    self.pdnd_dockwidget.gestore_nodi_com.setText(f"{gestori_nodi} gestori di nodi")
                    
                    self.show_tab(self.pdnd_dockwidget.tab_riepilogo_statistiche, self.pdnd_dockwidget.tab_com,'Telecomunicazioni',2)
                else:
                    self.hide_tab(self.pdnd_dockwidget.tab_riepilogo_statistiche, self.pdnd_dockwidget.tab_com)

                #sac
                if estratti.get("ND_SAC") and estratti.get("TR_SAC"):
                    tratte = estratti.get("TR_SAC")
                    km_tratte = str(tratte[0]/1000).replace('.',',')
                    gestori_tratte = tratte[1]
                    
                    nodi = estratti.get("ND_SAC")
                    n_nodi = nodi[0]
                    gestori_nodi = nodi[1]
                    
                    self.pdnd_dockwidget.tratte_sac.setText(f"{km_tratte} km di tratte")
                    self.pdnd_dockwidget.gestore_tratte_sac.setText(f"{gestori_tratte} gestori di tratte")
                    self.pdnd_dockwidget.nodi_sac.setText(f"{n_nodi} nodi")
                    self.pdnd_dockwidget.gestore_nodi_sac.setText(f"{gestori_nodi} gestori di nodi")
                    
                    self.show_tab(self.pdnd_dockwidget.tab_riepilogo_statistiche, self.pdnd_dockwidget.tab_sac,'Smaltimento Acque',3)
                else:
                    self.hide_tab(self.pdnd_dockwidget.tab_riepilogo_statistiche, self.pdnd_dockwidget.tab_sac)
                
                #ele
                if estratti.get("ND_ELE") and estratti.get("TR_ELE"):
                    tratte = estratti.get("TR_ELE")
                    km_tratte = str(tratte[0]/1000).replace('.',',')
                    gestori_tratte = tratte[1]
                    
                    nodi = estratti.get("ND_ELE")
                    n_nodi = nodi[0]
                    gestori_nodi = nodi[1]
                    
                    self.pdnd_dockwidget.tratte_ele.setText(f"{km_tratte} km di tratte")
                    self.pdnd_dockwidget.gestore_tratte_ele.setText(f"{gestori_tratte} gestori di tratte")
                    self.pdnd_dockwidget.nodi_ele.setText(f"{n_nodi} nodi")
                    self.pdnd_dockwidget.gestore_nodi_ele.setText(f"{gestori_nodi} gestori di nodi")
                    
                    self.show_tab(self.pdnd_dockwidget.tab_riepilogo_statistiche, self.pdnd_dockwidget.tab_ele,'Elettrica',4)
                else:
                    self.hide_tab(self.pdnd_dockwidget.tab_riepilogo_statistiche, self.pdnd_dockwidget.tab_ele)
                
                #gas
                if estratti.get("ND_GAS") and estratti.get("TR_GAS"):
                    tratte = estratti.get("TR_GAS")
                    km_tratte = str(tratte[0]/1000).replace('.',',')
                    gestori_tratte = tratte[1]
                    
                    nodi = estratti.get("ND_GAS")
                    n_nodi = nodi[0]
                    gestori_nodi = nodi[1]
                    
                    self.pdnd_dockwidget.tratte_gas.setText(f"{km_tratte} km di tratte")
                    self.pdnd_dockwidget.gestore_tratte_gas.setText(f"{gestori_tratte} gestori di tratte")
                    self.pdnd_dockwidget.nodi_gas.setText(f"{n_nodi} nodi")
                    self.pdnd_dockwidget.gestore_nodi_gas.setText(f"{gestori_nodi} gestori di nodi")
                    
                    self.show_tab(self.pdnd_dockwidget.tab_riepilogo_statistiche, self.pdnd_dockwidget.tab_gas,'Gas',5)
                else:
                    self.hide_tab(self.pdnd_dockwidget.tab_riepilogo_statistiche, self.pdnd_dockwidget.tab_gas)
                
                #aac
                if estratti.get("ND_AAC") and estratti.get("TR_AAC"):
                    tratte = estratti.get("TR_AAC")
                    km_tratte = str(tratte[0]/1000).replace('.',',')
                    gestori_tratte = tratte[1]
                    
                    nodi = estratti.get("ND_AAC")
                    n_nodi = nodi[0]
                    gestori_nodi = nodi[1]
                    
                    self.pdnd_dockwidget.tratte_aac.setText(f"{km_tratte} km di tratte")
                    self.pdnd_dockwidget.gestore_tratte_aac.setText(f"{gestori_tratte} gestori di tratte")
                    self.pdnd_dockwidget.nodi_aac.setText(f"{n_nodi} nodi")
                    self.pdnd_dockwidget.gestore_nodi_aac.setText(f"{gestori_nodi} gestori di nodi")
                    
                    self.show_tab(self.pdnd_dockwidget.tab_riepilogo_statistiche, self.pdnd_dockwidget.tab_aac,'Approvigionamento Idrico',6)
                else:
                    self.hide_tab(self.pdnd_dockwidget.tab_riepilogo_statistiche, self.pdnd_dockwidget.tab_aac)
                
                #tlr
                if estratti.get("ND_TLR") and estratti.get("TR_TLR"):
                    tratte = estratti.get("TR_TLR")
                    km_tratte = str(tratte[0]/1000).replace('.',',')
                    gestori_tratte = tratte[1]
                    
                    nodi = estratti.get("ND_TLR")
                    n_nodi = nodi[0]
                    gestori_nodi = nodi[1]
                    
                    self.pdnd_dockwidget.tratte_tlr.setText(f"{km_tratte} km di tratte")
                    self.pdnd_dockwidget.gestore_tratte_tlr.setText(f"{gestori_tratte} gestori di tratte")
                    self.pdnd_dockwidget.nodi_tlr.setText(f"{n_nodi} nodi")
                    self.pdnd_dockwidget.gestore_nodi_tlr.setText(f"{gestori_nodi} gestori di nodi")
                    
                    self.show_tab(self.pdnd_dockwidget.tab_riepilogo_statistiche, self.pdnd_dockwidget.tab_tlr,'Teleriscaldamento',7)
                else:
                    self.hide_tab(self.pdnd_dockwidget.tab_riepilogo_statistiche, self.pdnd_dockwidget.tab_tlr)
                
                #ole
                if estratti.get("ND_OLE") and estratti.get("TR_OLE"):
                    tratte = estratti.get("TR_OLE")
                    km_tratte = str(tratte[0]/1000).replace('.',',')
                    gestori_tratte = tratte[1]
                    
                    nodi = estratti.get("ND_OLE")
                    n_nodi = nodi[0]
                    gestori_nodi = nodi[1]
                    
                    self.pdnd_dockwidget.tratte_ole.setText(f"{km_tratte} km di tratte")
                    self.pdnd_dockwidget.gestore_tratte_ole.setText(f"{gestori_tratte} gestori di tratte")
                    self.pdnd_dockwidget.nodi_ole.setText(f"{n_nodi} nodi")
                    self.pdnd_dockwidget.gestore_nodi_ole.setText(f"{gestori_nodi} gestori di nodi")
                    
                    self.show_tab(self.pdnd_dockwidget.tab_riepilogo_statistiche, self.pdnd_dockwidget.tab_ole,'Oleodotti',8)
                else:
                    self.hide_tab(self.pdnd_dockwidget.tab_riepilogo_statistiche, self.pdnd_dockwidget.tab_ole)

                self.pdnd_dockwidget.tab_riepilogo_statistiche.setCurrentIndex(0)
                self.iface.messageBar().pushMessage("PDND STATISTICHE", messaggio_bar, level=0)
            else:
                self.pdnd_dockwidget.tab_riepilogo_statistiche.setVisible(False)
                
                sinfi_utils.message_creator("Attenzione","warning",req.text)

        self.pdnd_dockwidget.get_aggregate_stats.setEnabled(True)
    def hide_tab(self,tabwidget, tab):
        index = tabwidget.indexOf(tab)
        if index != -1:
            tabwidget.removeTab(index)
    
    def show_tab(self,tabwidget, tab, label,index):

        if index != -1:
            tabwidget.insertTab(index,tab,label)
