"""
/***************************************************************************
 Servizi Sinfi
                                 A QGIS plugin
 Plugin per accedere ai servizi Sinfi da piattaforma QGis
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-04-16
        copyright            : (C) 2025 by Infratel Italia
        email                : info@sinfi.it
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import requests
from requests.auth import HTTPBasicAuth
import json
from ..utils import sinfi_utils


class LoginSinfi():

    def __init__(self,iface,link):
        self.iface = iface
        self.token = None
        self.username = None
        self.password = None
        self.link = link

    def get_user(self):
        return self.username
    def get_token(self):
        return self.token
    
    def effettua_login_update_token(self,username,password):
        if not username and not password:
            sinfi_utils.message_creator("Attenzione","warning",f"Nessuna credenziale inserita.")
        elif not username:
            sinfi_utils.message_creator("Attenzione","warning",f"Username non inserito.                               ")
        elif not password:
            sinfi_utils.message_creator("Attenzione","warning",f"Password non inserita.                               ")
        else:
            res = requests.get(f"https://{self.link}/sinfi_gateway/rest/pub/auth/get_token_by_credentials/", auth=HTTPBasicAuth(username, password), verify=False)
            if res.status_code == 403:
                sinfi_utils.message_creator("Attenzione","warning",f"\nCredenziali Errate.                               ")
            elif res.status_code == 200:
                res_dict = json.loads(res.text)
                self.token = res_dict.get("retdata").get("data")
                
                if res.status_code == 200:
                    return "Success"
            else:
                sinfi_utils.message_creator("Attenzione","warning",f"{res.status_code} - Errore sconosciuto.")
        return None

    def effettua_login(self,username,password):
        token,group_codes,group_names,roles_codes,capabilities,firstName,lastName,group_to_cap = None,None,None,None,None,None,None,None
        if not username and not password:
            sinfi_utils.message_creator("Attenzione","warning",f"Nessuna credenziale inserita.")
        elif not username:
            sinfi_utils.message_creator("Attenzione","warning",f"Username non inserito.                               ")
        elif not password:
            sinfi_utils.message_creator("Attenzione","warning",f"Password non inserita.                               ")
        else:
            #recupero il token
            res = requests.get(f"https://{self.link}/sinfi_gateway/rest/pub/auth/get_token_by_credentials/", auth=HTTPBasicAuth(username, password), verify=False)

            if res.status_code == 200:
                res_dict = json.loads(res.text)
                token = res_dict.get("retdata").get("data")
                
                #recupero gruppi ,roles e capabilities
                headers = {
                            "X-User": username,
                            "X-Token": token
                        }
                # print('token ',token)
                res = requests.get(f"https://{self.link}/sinfi_gateway/rest/pub/auth/get_user/", headers = headers, verify=False)
                if res.status_code == 200:
                    res_dict = json.loads(res.text)
                        
                    firstName = res_dict.get("retdata").get("data").get("data").get("firstName")
                    lastName = res_dict.get("retdata").get("data").get("data").get("lastName")

                    group_codes = res_dict.get("retdata").get("data").get("data").get("group_codes")
                    group_names = res_dict.get("retdata").get("data").get("data").get("group_names")
                    capabilities = res_dict.get("retdata").get("data").get("data").get("capabilities")
                    roles_codes = res_dict.get("retdata").get("data").get("data").get("roles_codes")
                    
                    self.username = username
                    self.token = token
                    self.password = password
                elif res.status_code == 403:
                    sinfi_utils.message_creator("Attenzione","warning",f"\nCredenziali Errate.                               ")
                else:
                    message = sinfi_utils.traduci_status_code(res.status_code)
                    sinfi_utils.message_creator("Attenzione","warning",f"\n{message}")
            elif res.status_code == 403:
                sinfi_utils.message_creator("Attenzione","warning",f"\nCredenziali Errate.                               ")
            else:
                message = sinfi_utils.traduci_status_code(res.status_code)
                sinfi_utils.message_creator("Attenzione","warning",f"\n{message}")
        return username,password,token,group_codes,group_names,roles_codes,capabilities,firstName,lastName,group_to_cap




