"""
/***************************************************************************
 Servizi Sinfi
                                 A QGIS plugin
 Plugin per accedere ai servizi Sinfi da piattaforma QGis
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-04-16
        copyright            : (C) 2025 by Infratel Italia
        email                : info@sinfi.it
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from . import pdnd_auth
import requests
import json
import os

from ..utils import sinfi_utils

class LoginPDND:

    def __init__(self, iface, link_pdnd: str):
        self.iface = iface
        self.link_pdnd = link_pdnd

        # Dati utente
        self.kid = None
        self.private_path = None
        self.client_id = None
        self.apikey = None
        self.bearer = None

        # PurposeID ufficiali SINFI
        self.purposeId = {
            "statistico": "26528558-7b3c-4c51-a290-a68e06b5292f",
            "datapanel": "6e6bbe40-e487-48c8-8796-272b3901d1f4",
            "wms": "410ac132-ebec-4958-97f0-69585dd0c849"
        }

    # ---------------------------------------------------------------------
    # LOGOUT
    # ---------------------------------------------------------------------
    def logout(self):
        self.kid = None
        self.private_path = None
        self.client_id = None
        self.apikey = None
        self.bearer = None

    # ---------------------------------------------------------------------
    # VALIDAZIONE INPUT
    # ---------------------------------------------------------------------
    def verifica_input(self, private_path: str, kid: str, client_id: str, apikey: str):

        # 1. Controllo presenza file
        if not private_path or not os.path.isfile(private_path):
            sinfi_utils.message_creator("Attenzione","warning","Il file della chiave privata non è valido.")
            return None, None, None, None, None, None

        # 2. Verifica estensione
        if not private_path.endswith(".priv"):
            sinfi_utils.message_creator("Attenzione","warning","Il file selezionato non è una chiave privata .priv.")
            return None, None, None, None, None, None

        # 3. Verifica kid
        if not kid:
            sinfi_utils.message_creator("Attenzione","warning","Nessun KeyID inserito.")
            return None, None, None, None, None, None

        # 4. Verifica client_id
        if not client_id:
            sinfi_utils.message_creator("Attenzione","warning","Nessun client_id inserito.")
            return None, None, None, None, None, None

        # 5. Verifica APIKEY
        if not apikey:
            sinfi_utils.message_creator("Attenzione","warning","Nessuna APIKEY inserita.")
            return None, None, None, None, None, None

        if len(apikey) != 64:
            sinfi_utils.message_creator("Attenzione","warning","APIKey di lunghezza errata.")
            return None, None, None, None, None, None

        # -----------------------------------------------------------------
        # 6. Test login PDND usando JWS + client assertion corretta
        # -----------------------------------------------------------------
        test_result = self._test_pdnd_auth(private_path, kid, client_id, apikey)

        if not test_result:
            return None, None, None, None, None, None

        if test_result[0] != 200:
            sinfi_utils.message_creator("Attenzione","warning",test_result[1])
            return None, None, None, None, None, None

        # Se tutto OK salvo i dati nella classe
        self.private_path = private_path
        self.kid = kid
        self.client_id = client_id
        self.apikey = apikey

        check_statistico = test_result[2]
        firstName = test_result[3]
        lastName = test_result[4]
        groupName = test_result[5]
        roles_codes = test_result[6]

        return True, check_statistico, firstName, lastName, groupName, roles_codes

    # ---------------------------------------------------------------------
    # TEST AUTENTICAZIONE PDND + SINFI
    # ---------------------------------------------------------------------
    def _test_pdnd_auth(self, private_path, kid, client_id, apikey):

        # 1. Crea voucher per il purpose statistico
        result = pdnd_auth.create_voucher(
            purpose="statistico",
            kid=kid,
            private_path=private_path,
            client_id=client_id,
            apikey=apikey,
            link_pdnd=self.link_pdnd
        )

        if not result:
            return None

        bearer = result["bearer"]
        apikey = result["apikey"]
        jws = result["jws"]
        # -----------------------------------------------------------------
        # 2. Test capabilities SINFI (statistico)
        # -----------------------------------------------------------------
        url_cap = f"https://{self.link_pdnd}/sinfi/pdnd/stats/1.0.0/sinfi_stats_get_aggregate_stats/"
        headers = {
            "Authorization": f"Bearer {bearer}",
            "Agid-JWT-TrackingEvidence": jws,
            "accept": "application/json",
            "content-type": "application/json"
        }
        
        body = """{
            "group_code": "",
            "query": { "territories": [] }
        }"""

        resp = requests.post(url_cap, headers=headers, data=body, verify=False)

        status_code = resp.status_code
        message = sinfi_utils.traduci_status_code(status_code)

        abilita_stat = True

        if status_code == 200:
            pass  # tutto ok

        elif status_code == 401:
            abilita_stat = False
            j = resp.json()
            code = j.get("code", "")
            if code == "SP007":
                message = "APIKey errata."
            elif code == "SP008":
                message = "APIKey scaduta."
            return [status_code, message, abilita_stat, None, None, None, None]

        elif status_code == 403:
            j = resp.json()
            if j.get("code") in ("1002", "1010"):
                abilita_stat = False  # l'utente non ha statistico, non è un errore
                status_code = 200
            else:
                return [403, "Accesso negato ai servizi SINFI.", False, None, None, None, None]

        elif status_code == 429:
            return [429, "Troppe richieste (rate limit).", False, None, None, None, None]

        else:
            return [status_code, message, False, None, None, None, None]

        # -----------------------------------------------------------------
        # 3. Recupero informazioni utente
        # -----------------------------------------------------------------
        url_user = f"https://{self.link_pdnd}/qgis/rest/api/system/get_istat_by_group/?group_code=''"
        headers_user = {
            "Authorization": f"Bearer {bearer}",
            "Agid-JWT-TrackingEvidence": jws
        }

        req_user = requests.get(url_user, headers=headers_user, verify=False)

        if req_user.status_code != 200:
            return [200, "OK ma impossibile recuperare user info.", abilita_stat, None, None, None, None]

        fixed_json = json.loads(req_user.text.encode("latin1", "ignore").decode("utf-8", "replace"))

        try:
            firstName = fixed_json["user"]["data"]["firstName"]
            lastName = fixed_json["user"]["data"]["lastName"]
            groupName = fixed_json["group"]["name"]
            roles_codes = fixed_json["user"]["data"]["roles_codes"]
        except:
            return [200, "OK ma user info non complete.", abilita_stat, None, None, None, None]

        return [200, "OK", abilita_stat, firstName, lastName, groupName, roles_codes]

    def request_voucher(self,purpose):
        result = pdnd_auth.create_voucher(
            purpose=purpose,
            kid=self.kid,
            private_path=self.private_path,
            client_id=self.client_id,
            apikey=self.apikey,
            link_pdnd=self.link_pdnd
        )

        if not result:
            return None
        
        return result