# -*- coding: utf-8 -*- 
"""
/***************************************************************************
 Servizi Sinfi
                                 A QGIS plugin
 Plugin per accedere ai servizi Sinfi da piattaforma QGis
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-04-16
        copyright            : (C) 2025 by Infratel Italia
        email                : info@sinfi.it
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
#import per QGIS
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction,QToolBar
from qgis.core import QgsApplication,QgsAuthMethodConfig,Qgis,QgsSettings
# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the DockWidget
import os.path
import requests
import json
#import per la gui
from .gui.login_widget import LoginWidget
from .gui.user_form import UserForm
# from .gui.user_form_pdnd import UserFormPDND
from .gui.sinfi_dockwidget import SinfiDockWidget
# from .gui.pdnd_dockwidget import PdndDockwidget

#import dei moduli
from .moduli.utils import sinfi_utils

# from .moduli.login.login_pdnd import LoginPDND
from .moduli.login.login_sinfi import LoginSinfi
from .moduli.sinfi_api.check_token import CheckToken

from .moduli.sinfi_api.sinfi_wms import SinfiWMS
from .moduli.sinfi_api.sinfi_upload import SinfiUpload

# from .moduli.pdnd_api.pdnd_wms import PdndWMS
# from .moduli.pdnd_api.pdnd_upload import PdndUpload
# from .moduli.pdnd_api.pdnd_statistico import PdndStatistico

import locale
class MainPlugin:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale
        local = QSettings().value('locale/userLocale')[0:2]

        locale.setlocale(locale.LC_ALL, 'it_IT.UTF-8')

        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'mainPlugin_{}.qm'.format(local))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Servizi Sinfi')
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.mainWindow().findChild( QToolBar, u'mPluginToolBar' )
        if not self.toolbar:
            self.toolbar = self.iface.addToolBar(u'mPluginToolBar')
            self.toolbar.setObjectName(u'mPluginToolBar')

        self.pluginIsActive = False
        self.settings =  QgsSettings()
        self.user = None
        self.psw = None
        self.token = None
        self.group_codes = None
        self.group_names = None
        self.firstName = None
        self.lastName = None

        #gui
        self.dockwidget = None
        self.login_widget = None
        self.user_form = None
        self.sinfi_dockwidget = None
        self.pdnd_dockwidget = None

        #moduli
        self.check_token = None
        self.valida_dati = None
        
        self.login_sinfi = None
        self.sinfi_wms = None
        self.sinfi_upload = None

        self.login_pdnd = None
        self.pdnd_wms = None
        self.pdnd_upload = None
        self.pdnd_statistico = None

        self.show = None

        self.link_sinfi = 'sinfi.it'
        
        self.authCfdId = None

        self.dict_cerca_gruppo_admin = None
        
    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('mainPlugin', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """
        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/servizi_sinfi/icone/logo_sinfi.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Accesso ai servizi SINFI'),
            callback=self.run,
            parent=self.iface.mainWindow())

    #--------------------------------------------------------------------------
    def onClosePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""
        # disconnects
        if self.login_widget:
            try:
                self.login_widget.signal_emitter.close_signal.disconnect(self.onClosePlugin)
            except:
                pass
            
            try:
                self.login_widget.accedi_sinfi.clicked.disconnect()
            except:
                pass

            # try:
            #     self.login_widget.accedi_pdnd.clicked.disconnect()
            # except:
            #     pass
        
        if self.user_form:
            try:
                self.user_form.accedi.clicked.disconnect()
            except:
                pass
            try:
                self.user_form.accedi_valida_token.clicked.disconnect()
            except:
                pass
            try:
                self.user_form.signal_emitter.close_signal.disconnect()
            except:
                pass
        
        if self.sinfi_dockwidget:
            try:
                self.sinfi_dockwidget.le_gruppi.textEdited.disconnect()
            except:
                pass
            try:
                self.sinfi_dockwidget.le_gruppi_cleaner.clicked.disconnect()
            except:
                pass
            try:
                self.sinfi_dockwidget.search_button.clicked.disconnect()
            except:
                pass
            try:
                self.sinfi_dockwidget.insert_button.clicked.disconnect()
            except:
                pass
            
            self.sinfi_dockwidget.le_gruppi.clear()
            self.sinfi_dockwidget.cb_gruppi_admin.clear()

            self.sinfi_dockwidget.search_button.setEnabled(False)
            self.sinfi_dockwidget.insert_button.setEnabled(False)
            try:
                self.sinfi_dockwidget.signal_emitter.close_signal.disconnect()
            except:
                pass
        
        # if self.pdnd_dockwidget:
        #     try:
        #         self.pdnd_dockwidget.signal_emitter.close_signal.disconnect()
        #     except:
        #         pass
        #     try:
        #         self.pdnd_dockwidget.le_apikeys.textEdited.disconnect()
        #     except:
        #         pass
        #     try:
        #         self.pdnd_dockwidget.genera_bearer_statistico.clicked.disconnect()
        #     except:
        #         pass
            
        #     self.pdnd_dockwidget.tab_statistico.setEnabled(True)

        try:
            self.check_token.stop_thread()
        except:
            pass

        #gui
        self.dockwidget = None
        self.login_widget = None
        self.user_form = None

        try:
            self.sinfi_dockwidget.benvenuto.clear()
        except:
            pass
        self.sinfi_dockwidget = None
        
        # try:
        #     self.pdnd_dockwidget.benvenuto.clear()
        #     self.pdnd_dockwidget.benvenuto_gruppo.clear()
        # except:
        #     pass
        # self.pdnd_dockwidget = None

        #moduli
        self.login_sinfi = None
        # self.login_pdnd = None

        self.check_token = None
        self.valida_dati = None
        
        if self.sinfi_wms:
            self.sinfi_wms.unload()
            self.sinfi_wms = None
        
        if self.sinfi_upload:
            self.sinfi_upload.unload()
            self.sinfi_upload = None
            
        # if self.pdnd_wms:
        #     self.pdnd_wms.unload()
        #     self.pdnd_wms = None

        # if self.pdnd_upload:
        #     self.pdnd_upload.unload()
        #     self.pdnd_upload = None

        # if self.pdnd_statistico:
        #     self.pdnd_statistico.reset_gui()
        #     self.pdnd_statistico.unload()
        #     self.pdnd_statistico = None

        if self.authCfdId:
            QgsApplication.authManager().removeAuthenticationConfig(self.authCfdId)
            self.authCfdId = None
        
        self.dict_cerca_gruppo_admin = None
        self.pluginIsActive = False
                
        self.user = None
        self.psw = None
        self.token = None
        self.group_codes = None
        self.group_names = None
        self.firstName = None
        self.lastName = None

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""

        self.onClosePlugin()
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Servizi Sinfi'),
                action)
            self.iface.removeToolBarIcon(action)

    #--------------------------------------------------------------------------
    #se il login widget viene chiuso lo rendo riapribile
    def chiudi_login_widget(self):
        if self.login_widget:
            self.login_widget =  None
            self.onClosePlugin()
            
    ##########################################################################################################
    #SINFI

    def apri_user_form_sinfi(self):
        self.user_form.accedi_valida_token.setVisible(False)
        self.user_form.accedi.setVisible(True)
        self.user_form.show()
        self.login_widget.hide()

    def chiudi_user_form_sinfi(self):
        self.user_form.accedi_valida_token.setVisible(False)
        self.user_form.accedi.setVisible(True)
        self.login_widget.show()
        self.user_form.hide()
        self.logout_sinfi()

    def chiudi_sinfi_dockwidget(self):
        try:
            if not self.show:
                self.login_widget.show()
                self.sinfi_dockwidget.hide()
            else:
                self.show = None
            self.check_token.stop_thread()
            self.check_token = None
        except:
            pass

        if self.sinfi_dockwidget:
            self.sinfi_dockwidget.cb_gruppi.clear()
        
    def check_le_gruppi(self,testo):
        if testo:
            if len(testo) >2:
                self.sinfi_dockwidget.search_button.setEnabled(True)
            else:
                self.sinfi_dockwidget.search_button.setEnabled(False)

    def login_con_credenziali_sinfi(self):
        self.user_form.accedi_valida_token.setVisible(False)
        self.user_form.accedi.setVisible(True)
        self.user_form.setWindowModality(Qt.NonModal)
        self.user_form.hide()
        token,roles_codes,capabilities = None,None,None
        
        user,psw,token,group_codes,group_names,roles_codes,capabilities,firstName,lastName,group_to_cap = self.login_sinfi.effettua_login(self.user_form.user_input.text(),self.user_form.psw_input.text())
        
        #se i gruppi contengono elementi li inserisco nel cb_gruppi e mostro il dockwidget
        if roles_codes and capabilities:
            self.user = user
            self.psw = psw
            self.token = token
            self.firstName = firstName
            self.lastName = lastName
            self.sinfi_dockwidget.benvenuto.setText(f"Benvenuto/a {lastName} {firstName}")

            self.check_token = CheckToken(self.iface,user,token,self.link_sinfi)
            self.check_token.token_signal.connect(self.login_refresh_token)

            #creo_la_connessione 
            if self.authCfdId:
                QgsApplication.authManager().removeAuthenticationConfig(self.authCfdId)
                self.authCfdId = None

            authMgr = QgsApplication.authManager()
            
            config = QgsAuthMethodConfig()
            config.setName("wms_plugin_qgis")
            config.setMethod("Basic")
            config.setUri(f"{self.link_sinfi}")
            config.setConfig("username", self.user)
            config.setConfig("password", self.psw)

            authMgr.storeAuthenticationConfig(config)
            self.authCfdId = config.id()
            
            if 'DEFAULT_CLIENT_SINFI_ADMIN' in roles_codes:
                self.sinfi_dockwidget.label_le.setVisible(True)
                self.sinfi_dockwidget.le_gruppi.setVisible(True)
                self.sinfi_dockwidget.le_gruppi_cleaner.setVisible(True)
                self.sinfi_dockwidget.search_button.setVisible(True)
                
                self.sinfi_dockwidget.label_gruppo_da_aggiungere.setVisible(True)
                self.sinfi_dockwidget.cb_gruppi_admin.setVisible(True)
                self.sinfi_dockwidget.insert_button.setVisible(True)

                self.sinfi_dockwidget.label_seleziona_gruppo.move(10,150)
                self.sinfi_dockwidget.cb_gruppi.move(135,160)
                
                self.sinfi_dockwidget.tab_servizi_sinfi.move(20,205)

                self.sinfi_upload.set_ho_capabilities(True)
                self.sinfi_wms.set_ho_capabilities(True)

                self.iface.addDockWidget(Qt.RightDockWidgetArea, self.sinfi_dockwidget)

                self.sinfi_dockwidget.tab_servizi_sinfi.setCurrentIndex(0)
                self.sinfi_wms.set_user_psw(self.user,self.psw,self.authCfdId,self.sinfi_upload)
                self.sinfi_upload.set_user_psw(self.user,self.psw)

                self.sinfi_dockwidget.tab_wms.setEnabled(False)
                self.sinfi_dockwidget.tab_upload.setEnabled(False)

                self.sinfi_dockwidget.cartodb_basemap_rb.click()
                self.sinfi_dockwidget.show()
            elif group_codes and group_names:
                #creo un dizionario temporaneo su cui fare il sort
                group_dict_to_sort = {}
                for i in range(0,len(group_codes)):
                    group_dict_to_sort[group_codes[i]] = group_names[i]
                    

                group_dict_sorted = dict(sorted(group_dict_to_sort.items(), key=lambda item: locale.strxfrm(item[1])))
                
                self.group_codes = list(group_dict_sorted.keys())
                
                self.group_names = list(group_dict_sorted.values())
                
                self.sinfi_dockwidget.label_le.setVisible(False)
                self.sinfi_dockwidget.le_gruppi.setVisible(False)
                self.sinfi_dockwidget.le_gruppi_cleaner.setVisible(False)
                self.sinfi_dockwidget.search_button.setVisible(False)
                
                self.sinfi_dockwidget.label_gruppo_da_aggiungere.setVisible(False)
                self.sinfi_dockwidget.cb_gruppi_admin.setVisible(False)
                self.sinfi_dockwidget.insert_button.setVisible(False)

                self.sinfi_dockwidget.label_seleziona_gruppo.move(10,40)
                self.sinfi_dockwidget.cb_gruppi.move(135,50)
                
                self.sinfi_dockwidget.tab_servizi_sinfi.move(20,95)
                
                if 'DEFAULT_DATA_UPLOAD' in roles_codes:
                    self.sinfi_upload.set_ho_capabilities(True)
                else:
                    self.sinfi_upload.set_ho_capabilities(False)

                self.sinfi_upload.set_user_psw(self.user,self.psw)
                self.sinfi_upload.set_group_codes(self.group_codes)

                #aggiorno i gruppi
                if 'DEFAULT_CLIENT_DATA_API_VIEWER_USER' in roles_codes:
                    self.sinfi_wms.set_ho_capabilities(True)
                else:
                    self.sinfi_wms.set_ho_capabilities(False,"Utente non abilitato ai servizi WMS.")

                self.sinfi_wms.set_user_psw(self.user,self.psw,self.authCfdId,self.sinfi_upload)
                self.sinfi_wms.aggiorna_cb_gruppi(self.group_codes,self.group_names,roles_codes,self.user,self.psw)
            else:
                self.user_form.show()
        else:
            self.user_form.show()

    def logout_sinfi(self):
        self.user_form.user_input.clear()
        self.user_form.psw_input.clear()
        self.sinfi_wms.remove_all_wms()
        self.sinfi_upload.reset()
        
        self.sinfi_dockwidget.close()
        self.sinfi_wms.reset()

        self.dict_cerca_gruppo_admin = None
        self.sinfi_dockwidget.cb_gruppi_admin.clear()
        
        self.sinfi_dockwidget.search_button.setEnabled(False)
    
        self.sinfi_dockwidget.le_gruppi.clear()
        
        self.sinfi_dockwidget.insert_button.setEnabled(False)
        
        self.user = None
        self.psw = None
        self.token = None
        self.group_codes = None
        self.group_names = None
        self.firstName = None
        self.lastName = None
        self.sinfi_dockwidget.benvenuto.clear()

    def pulisci_le_gruppi(self):
        self.sinfi_dockwidget.le_gruppi.clear()
        self.sinfi_dockwidget.search_button.setEnabled(False)
        self.sinfi_dockwidget.cb_gruppi_admin.clear()
        self.sinfi_dockwidget.insert_button.setEnabled(False)
        
    def cerca_gruppo_admin(self):
        self.sinfi_dockwidget.search_button.setEnabled(False)

        le_text = self.sinfi_dockwidget.le_gruppi.text()
        #recupero gruppi ,roles e capabilities
        headers = {
                    "X-User": self.user,
                    "X-Token": self.token
                }
        res = requests.get(f"https://{self.link_sinfi}/sinfi_gateway/rest/pub/auth/search_group/?probe={le_text}", headers = headers, verify=False)
        if res.status_code == 200:
            res_dict = json.loads(res.text)
            
            retdata_data = res_dict.get("retdata").get("data")
            if retdata_data:
                self.dict_cerca_gruppo_admin = {}
                self.sinfi_dockwidget.cb_gruppi_admin.clear()
                
                self.sinfi_dockwidget.insert_button.setEnabled(True)

                group_name_to_sort = []
                for i in retdata_data:
                    group_name = i.get('name')
                    group_code = i.get('code')
                    self.dict_cerca_gruppo_admin[group_name] = group_code
                    group_name_to_sort.append(group_name)
                    
                group_name_to_sort.sort(key=locale.strxfrm)
                
                for i in range(0,len(group_name_to_sort)):
                    self.sinfi_dockwidget.cb_gruppi_admin.insertItem(i,group_name_to_sort[i])
            else:
                sinfi_utils.message_creator("Attenzione","warning","Non è stato trovato nessun gruppo!")
        else:
            sinfi_utils.message_creator("Attenzione","warning",f"{res.status_code} - Errore sconosciuto.")

        self.sinfi_dockwidget.search_button.setEnabled(True)
            
    def inserisci_gruppo_admin(self):
        current_group_name  = self.sinfi_dockwidget.cb_gruppi_admin.currentText()
        current_group_code = self.dict_cerca_gruppo_admin.get(current_group_name)
        if current_group_code:
            self.sinfi_wms.aggiorna_cb_gruppi_admin(current_group_code,current_group_name)

    def login_refresh_token(self):
        
        try:
            self.check_token.stop_thread()
        except:
            pass
        else:
            sinfi_utils.message_creator("Attenzione","warning","Token scaduto! Si prega di effettuare nuovamente l'accesso")

            self.user_form.accedi_valida_token.setVisible(True)
            self.user_form.accedi.setVisible(False)
            self.user_form.psw_input.clear()
            
            self.user_form.setWindowModality(Qt.ApplicationModal)
            self.sinfi_dockwidget.hide()
            self.user_form.show()
        
    def login_aggiorna_token(self):
        self.user_form.hide()
        old_user = self.login_sinfi.get_user()
        ret = None
        #se lo username è lo stesso tento la riconnessione per aggiornare il token
        if old_user == self.user_form.user_input.text():
            ret = self.login_sinfi.effettua_login_update_token(self.user_form.user_input.text(),self.user_form.psw_input.text())
            if not ret:
                self.user_form.show()
            else:
                self.sinfi_dockwidget.show()
                new_token = self.login_sinfi.get_token()
                self.check_token.set_token(new_token)
                self.check_token.start_thread()
                self.iface.mapCanvas().refresh()
        else:
            #se ho cambiato username rimuovo i vecchi elementi e ricreo la connessione per la nuova utenza
            user, psw = self.user_form.user_input.text(),self.user_form.psw_input.text()
            self.show = True
            self.logout_sinfi()
            self.user_form.user_input.setText(user)
            self.user_form.psw_input.setText(psw)

            self.login_con_credenziali_sinfi()

    ##########################################################################################################
    # PDND

    # def apri_user_form_pdnd(self):
    #     self.user_form_pdnd.show()
    #     self.login_widget.hide()
    
    # def chiudi_user_form_pdnd(self):
    #     self.login_widget.show()
    #     self.user_form_pdnd.hide()
    #     self.logout_pdnd()
    
    # def chiudi_pdnd_dockwidget(self):
    #     try:
    #         if not self.show:
    #             self.login_widget.show()
    #             self.pdnd_dockwidget.hide()
                
    #             self.pdnd_dockwidget.tab_statistico.setEnabled(True)
    #             self.pdnd_statistico.reset_gui()
    #         else:
    #             self.show = None
    #     except:
    #         pass
    
    # def login_con_credenziali_pdnd(self):
    #     self.user_form_pdnd.hide()
    #     private_path = self.user_form_pdnd.private_widget.filePath()
    #     kid = self.user_form_pdnd.kid.text().strip()
    #     client_id = self.user_form_pdnd.client_id.text().strip()
    #     apikey = self.user_form_pdnd.apikey.text().strip()

    #     result,check_statistico,firstName,lastName,groupName,roles_codes = self.login_pdnd.verifica_input(private_path,kid,client_id,apikey)
    #     if result:
    #         #verifico nome utente
    #         if firstName and lastName:
    #             self.firstName = firstName
    #             self.lastName = lastName
    #             self.pdnd_dockwidget.benvenuto.setText(f"Benvenuto/a {firstName} {lastName}")
    #         if groupName:
    #             self.pdnd_dockwidget.benvenuto_gruppo.setText(f"Gruppo selezionato: {groupName}")

    #         #verifico se sono super admin
    #         if 'DEFAULT_CLIENT_SINFI_ADMIN' in roles_codes:

    #             #inizializzo wms
    #             self.pdnd_dockwidget.cartodb_basemap_rb.click()
    #             self.pdnd_dockwidget.tab_servizi_sinfi.setCurrentIndex(0)

    #             self.pdnd_statistico.set_groups()
    #             self.pdnd_upload.set_ho_capabilities(True)

    #         else:
    #             #verifico le capabilities:
    #             try:
    #                 if 'DEFAULT_CLIENT_DATA_API_VIEWER_USER' not in roles_codes:
    #                     self.pdnd_wms.non_ho_cap()
    #                     self.pdnd_statistico.non_ho_cap()
    #                 else:
    #                     #inizializzo wms
    #                     self.pdnd_dockwidget.cartodb_basemap_rb.click()
    #                     self.pdnd_dockwidget.tab_servizi_sinfi.setCurrentIndex(0)

    #                     #inizializzo statistico
    #                     if check_statistico:
    #                         self.pdnd_statistico.set_groups()
    #                     else:
    #                         # self.pdnd_dockwidget.tab_statistico.setEnabled(False)
    #                         self.pdnd_statistico.hide_gui()
    #                         self.pdnd_dockwidget.label_no_cap_statistico.setText('Gruppo non abilitato al servizio Statistico')

    #             except Exception as e:
    #                     #inizializzo wms
    #                     self.pdnd_dockwidget.cartodb_basemap_rb.click()
    #                     self.pdnd_dockwidget.tab_servizi_sinfi.setCurrentIndex(0)

    #                     #inizializzo statistico
    #                     if check_statistico:
    #                         self.pdnd_statistico.set_groups()
    #                     else:
    #                         # self.pdnd_dockwidget.tab_statistico.setEnabled(False)
    #                         self.pdnd_statistico.hide_gui()
    #                         self.pdnd_dockwidget.label_no_cap_statistico.setText('Gruppo non abilitato al servizio Statistico')

    #             try:
    #                 if 'DEFAULT_DATA_UPLOAD' in (roles_codes):
    #                     self.pdnd_upload.set_ho_capabilities(True)
    #                 else:
    #                     self.pdnd_upload.set_ho_capabilities(False)

    #             except Exception as e:
    #                 self.pdnd_upload.set_ho_capabilities(True)

    #         self.iface.addDockWidget(Qt.RightDockWidgetArea, self.pdnd_dockwidget)
            
    #         self.pdnd_dockwidget.show()
    #         self.user_form_pdnd.hide()
                
    #     else:
    #         self.user_form_pdnd.show()

    # def logout_pdnd(self):
    #     self.user_form_pdnd.private_widget.setFilePath(None)
    #     self.user_form_pdnd.kid.clear()
    #     self.user_form_pdnd.client_id.clear()
    #     self.user_form_pdnd.apikey.clear()
                
    #     self.pdnd_dockwidget.close()
    #     self.pdnd_wms.remove_all_wms()
    #     self.pdnd_wms.reset()
        
    #     self.pdnd_upload.reset()

        
    #     self.pdnd_dockwidget.tab_statistico.setEnabled(True)
    #     self.pdnd_statistico.reset()

    #     self.pdnd_dockwidget.benvenuto.clear()
    #     self.pdnd_dockwidget.benvenuto_gruppo.clear()

    #     self.login_pdnd.logout()

    def run(self):
        """Run method that loads and starts the plugin"""
        
        qgis_version = 34005
        if Qgis.versionInt() <qgis_version:
            sinfi_utils.message_creator("Attenzione","warning","La versione minima di Qgis supportata è la 3.40.5-Bratislava.\nSi prega di utilizzare una versione più aggiornata.")
            self.onClosePlugin()
            return None
        
        #se il widget del login non è presente lo creo
        if not self.login_widget:
            #inizializzo le gui
            self.login_widget = LoginWidget()
            #imposto il widget in modo che sia sempre on top
            self.login_widget.setWindowFlags(Qt.WindowStaysOnTopHint|Qt.WindowCloseButtonHint)

            #collego l'emitter di chiusura della finestra alla relativa funzione
            self.login_widget.signal_emitter.close_signal.connect(self.onClosePlugin)

            ###SINFI

            #assegno l'icona del SINFI al relativo tasto
            sinfi_icon = QIcon(":/plugins/servizi_sinfi/icone/logo_sinfi.png")
            self.login_widget.accedi_sinfi.setIcon(sinfi_icon)
            #collego il tasto accedi alla funzione corrispondente
            self.login_widget.accedi_sinfi.clicked.connect(self.apri_user_form_sinfi)
            
            #creo l'oggetto per la gui dello user form
            self.user_form = UserForm()
            #imposto il widget in modo che sia sempre on top
            self.user_form.setWindowFlags(Qt.WindowStaysOnTopHint|Qt.WindowCloseButtonHint)
            #collego l'emitter di chiusura della finestra alla relativa funzione
            self.user_form.signal_emitter.close_signal.connect(self.chiudi_user_form_sinfi)
            #imposto il button di accesso per la verifica di validità del token come non visibile
            self.user_form.accedi_valida_token.setVisible(False)

            #creo l'oggetto per il modulo login_sinfi
            self.login_sinfi = LoginSinfi(self.iface,self.link_sinfi)
            #collego il tasto accedi alla funzione di login
            self.user_form.accedi.clicked.connect(self.login_con_credenziali_sinfi)
            self.user_form.accedi_valida_token.clicked.connect(self.login_aggiorna_token)

            #creo l'oggetto per il dockwidget sinfi
            self.sinfi_dockwidget = SinfiDockWidget()
            #collego l'emitter di chiusura della finestra alla relativa funzione
            self.sinfi_dockwidget.signal_emitter.close_signal.connect(self.chiudi_sinfi_dockwidget)
            
            #assegno l'icona del logout al relativo tasto
            logout_icon = QIcon(":/plugins/servizi_sinfi/icone/logout.png")
            #<a href="https://www.flaticon.com/free-icons/exit" title="exit icons">Exit icons created by Radhe Icon - Flaticon</a>
            self.sinfi_dockwidget.logout_button.setIcon(logout_icon)
            #collego il tasto di logout al relativo metodo
            self.sinfi_dockwidget.logout_button.clicked.connect(self.logout_sinfi)
            #connetto le_gruppi al check sull'inserisci testo
            self.sinfi_dockwidget.le_gruppi.textEdited.connect(lambda testo : self.check_le_gruppi(testo))
            #assegno l'icona delete al relativo tasto
            delete_icon = QIcon(":/plugins/servizi_sinfi/icone/delete.png")
            #<a href="https://www.flaticon.com/free-icons/delete" title="delete icons">Delete icons created by Those Icons - Flaticon</a>
            self.sinfi_dockwidget.le_gruppi_cleaner.setIcon(delete_icon)
            self.sinfi_dockwidget.le_gruppi_cleaner.clicked.connect(self.pulisci_le_gruppi)
            #assegno l'icona cerca al relativo tasto
            search_icon = QIcon(":/plugins/servizi_sinfi/icone/cerca.png")
            #<a href="https://www.flaticon.com/free-icons/search" title="search icons">Search icons created by Pixel perfect - Flaticon</a>
            self.sinfi_dockwidget.search_button.setIcon(search_icon)
            self.sinfi_dockwidget.search_button.clicked.connect(self.cerca_gruppo_admin)
            #assegno l'icona inserisci al relativo tasto
            insert_icon = QIcon(":/plugins/servizi_sinfi/icone/inserisci.png")
            #<a href="https://www.flaticon.com/free-icons/tick" title="tick icons">Tick icons created by Kiranshastry - Flaticon</a>
            self.sinfi_dockwidget.insert_button.setIcon(insert_icon)
            self.sinfi_dockwidget.insert_button.clicked.connect(self.inserisci_gruppo_admin)
            
            #creo l'oggetto per il modulo sinfi_wms
            self.sinfi_wms = SinfiWMS(self.iface,self.sinfi_dockwidget,self.link_sinfi)
            
            #creo l'oggetto per il modulo sinfi_upload
            self.sinfi_upload = SinfiUpload(self.sinfi_dockwidget,self.link_sinfi)


            ###PDND
            #assegno l'icona del PDND al relativo tasto
            pdnd_icon = QIcon(":/plugins/servizi_sinfi/icone/logo_pdnd.png")
            self.login_widget.accedi_pdnd.setIcon(pdnd_icon)
            #collego il tasto accedi alla funzione corrispondente
            # self.login_widget.accedi_pdnd.clicked.connect(self.apri_user_form_pdnd)

            # #creo l'oggetto per la gui dello user form
            # self.user_form_pdnd = UserFormPDND()
            # #imposto il widget in modo che sia sempre on top
            # self.user_form_pdnd.setWindowFlags(Qt.WindowStaysOnTopHint|Qt.WindowCloseButtonHint)
            # #collego l'emitter di chiusura della finestra alla relativa funzione
            # self.user_form_pdnd.signal_emitter.close_signal.connect(self.chiudi_user_form_pdnd)
            
            # #creo l'oggetto per il modulo login_sinfi
            # self.login_pdnd = LoginPDND(self.iface,self.link_pdnd)
            # #collego il tasto accedi alla funzione di login
            # self.user_form_pdnd.accedi.clicked.connect(self.login_con_credenziali_pdnd)
            
            # #creo l'oggetto per il dockwidget pdnd
            # self.pdnd_dockwidget = PdndDockwidget()
            # #collego l'emitter di chiusura della finestra alla relativa funzione
            # self.pdnd_dockwidget.signal_emitter.close_signal.connect(self.chiudi_pdnd_dockwidget)

            # #assegno l'icona del logout al relativo tasto
            # logout_icon = QIcon(":/plugins/servizi_sinfi/icone/logout.png")
            # #<a href="https://www.flaticon.com/free-icons/exit" title="exit icons">Exit icons created by Radhe Icon - Flaticon</a>
            
            # self.pdnd_dockwidget.logout_button.setIcon(logout_icon)
            # #collego il tasto di logout al relativo metodo
            # self.pdnd_dockwidget.logout_button.clicked.connect(self.logout_pdnd)
            
            # #creo l'oggetto per il modulo sinfi_wms
            # self.pdnd_wms = PdndWMS(self.iface,self.pdnd_dockwidget,self.login_pdnd,self.link_pdnd)
            
            # #creo l'oggetto per il modulo pdnd_upload
            # self.pdnd_upload = PdndUpload(self.pdnd_dockwidget,self.login_pdnd,self.link_pdnd)

            # #creo l'oggetto per il modulo pdnd_statistico
            # self.pdnd_statistico = PdndStatistico(self.pdnd_dockwidget,self.login_pdnd,self.link_pdnd,self.iface)

            #mostro la pagina di login
            self.login_widget.show()
        
