"""
/***************************************************************************
 Servizi Sinfi
                                 A QGIS plugin
 Plugin per accedere ai servizi Sinfi da piattaforma QGis
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-04-16
        copyright            : (C) 2025 by Infratel Italia
        email                : info@sinfi.it
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.PyQt.QtCore import Qt
from qgis.PyQt.QtWidgets import QMessageBox
import requests
from requests.auth import HTTPBasicAuth
import json


class LoginSinfi():

    def __init__(self,iface,link):
        self.iface = iface
        self.token = None
        self.username = None
        self.password = None
        self.message = QMessageBox()
        self.message.setWindowFlags(Qt.WindowStaysOnTopHint)
        self.message.setMinimumSize(400,200)
        self.message.setStyleSheet("""QWidget{background-color: rgb(255, 255, 255);}
                                        QPushButton{border:2px solid rgb(222, 222, 222); background: rgb(255, 255, 255); margin:5px;padding: 5px;}
                                        QPushButton:hover,QPushButton:pressed{background: rgb(230, 230, 230);}""")
        self.link = link
    def interpret_status_code(self,status_code: int) -> str:
        """
        Restituisce un messaggio leggibile per uno status code HTTP.
        """
        messages = {
            # 2xx Success
            200: "OK - Richiesta eseguita con successo.",
            201: "Created - Risorsa creata correttamente.",
            202: "Accepted - Richiesta accettata, in elaborazione.",
            204: "No Content - Richiesta completata, nessun contenuto restituito.",

            # 3xx Redirect
            301: "Moved Permanently - La risorsa è stata spostata in modo permanente.",
            302: "Found - La risorsa è temporaneamente disponibile altrove.",
            304: "Not Modified - Nessuna modifica dalla versione cache.",

            # 4xx Client Error
            400: "Bad Request - La richiesta non è valida.",
            401: "Unauthorized - Autenticazione richiesta o fallita.",
            403: "Forbidden - Accesso negato alla risorsa.",
            404: "Not Found - Risorsa non trovata.",
            405: "Method Not Allowed - Metodo HTTP non consentito.",
            408: "Request Timeout - La richiesta è scaduta.",
            429: "Too Many Requests - Limite di richieste superato.",

            # 5xx Server Error
            500: "Internal Server Error - Errore generico del server.",
            501: "Not Implemented - Funzionalità non supportata dal server.",
            502: "Bad Gateway - Risposta non valida dal server upstream.",
            503: "Service Unavailable - Servizio momentaneamente non disponibile.",
            504: "Gateway Timeout - Timeout del server upstream."
        }

        return messages.get(status_code, f"Status Code {status_code} - Codice non gestito esplicitamente.")

    def get_user(self):
        return self.username
    def get_token(self):
        return self.token

    def check_group(self,group_code):
        res_dict_list = []
        headers = {
                    "X-User": self.username,
                    "X-Token": self.token
                }
        #l"utente può inserire più gruppi insieme divisi da una virgola
        group_split = group_code.split(",")
        for group_code in group_split:
            #eseguo la request per ogni group_code
            res = requests.get(f"https://{self.link}/sinfi_gateway/rest/pub/auth/check_group/?group_code={group_code}", headers = headers, verify=False)
            if res.status_code == 403:
                self.message.setWindowTitle("Attenzione")
                self.message.setIcon(QMessageBox.Warning)
                self.message.setText("\nUtente non appartenente al gruppo")
                self.message.exec()
            elif res.status_code == 500:
                self.message.setWindowTitle("Attenzione")
                self.message.setIcon(QMessageBox.Warning)
                self.message.setText(f"\nIl gruppo '{group_code}' non esiste")
                self.message.exec()
            elif res.status_code == 200:
                #converto il json in un dict e lo aggiungo alla lista
                res_dict = json.loads(res.text)
                res_dict_list.append(res_dict)
            else:
                self.message.setWindowTitle("Attenzione")
                self.message.setIcon(QMessageBox.Warning)
                self.message.setText(f"{res.status_code} - Errore sconosciuto.")
                self.message.exec()

        return res_dict_list
    
    def effettua_login_update_token(self,username,password):
        self.message.setWindowTitle("Attenzione")
        self.message.setIcon(QMessageBox.Warning)
        if not username and not password:
            self.message.setText("Nessuna credenziale inserita")
            self.message.exec()
        elif not username:
            self.message.setText("Username non inserito")
            self.message.exec()
        elif not password:
            self.message.setText("Password non inserita")
            self.message.exec()
        else:
            res = requests.get(f"https://{self.link}/sinfi_gateway/rest/pub/auth/get_token_by_credentials/", auth=HTTPBasicAuth(username, password), verify=False)
            if res.status_code == 403:
                self.message.setText("\nCredenziali Errate.                               ")
                self.message.exec()
            elif res.status_code == 200:
                res_dict = json.loads(res.text)
                self.token = res_dict.get("retdata").get("data")
                
                if res.status_code == 200:
                    return "Success"
            else:
                self.message.setText(f"{res.status_code} - Errore sconosciuto.")
                self.message.exec()
        return None

    def effettua_login(self,username,password):
        token,group_codes,group_names,roles_codes,capabilities,firstName,lastName,group_to_cap = None,None,None,None,None,None,None,None
        if not username and not password:
            self.message.setWindowTitle("Attenzione")
            self.message.setIcon(QMessageBox.Warning)
            self.message.setText("Nessuna credenziale inserita")
            self.message.exec()
        elif not username:
            self.message.setWindowTitle("Attenzione")
            self.message.setIcon(QMessageBox.Warning)
            self.message.setText("Username non inserito")
            self.message.exec()
        elif not password:
            self.message.setWindowTitle("Attenzione")
            self.message.setIcon(QMessageBox.Warning)
            self.message.setText("Password non inserita")
            self.message.exec()
        else:
            #recupero il token
            res = requests.get(f"https://{self.link}/sinfi_gateway/rest/pub/auth/get_token_by_credentials/", auth=HTTPBasicAuth(username, password), verify=False)

            if res.status_code == 200:
                res_dict = json.loads(res.text)
                token = res_dict.get("retdata").get("data")
                
                #recupero gruppi ,roles e capabilities
                headers = {
                            "X-User": username,
                            "X-Token": token
                        }
                # print('token ',token)
                res = requests.get(f"https://{self.link}/sinfi_gateway/rest/pub/auth/get_user/", headers = headers, verify=False)
                if res.status_code == 200:
                    res_dict = json.loads(res.text)

                        
                    firstName = res_dict.get("retdata").get("data").get("data").get("firstName")
                    lastName = res_dict.get("retdata").get("data").get("data").get("lastName")

                    group_codes = res_dict.get("retdata").get("data").get("data").get("group_codes")
                    group_names = res_dict.get("retdata").get("data").get("data").get("group_names")
                    capabilities = res_dict.get("retdata").get("data").get("data").get("capabilities")
                    roles_codes = res_dict.get("retdata").get("data").get("data").get("roles_codes")
                    
                    self.username = username
                    self.token = token
                    self.password = password
                elif res.status_code == 403:
                    self.message.setWindowTitle("Attenzione")
                    self.message.setIcon(QMessageBox.Warning)
                    self.message.setText("\nCredenziali Errate.")
                    self.message.exec()
                else:
                    message = self.interpret_status_code(res.status_code)
                    self.message.setWindowTitle("Attenzione")
                    self.message.setIcon(QMessageBox.Warning)
                    self.message.setText(f"\n{message}")
                    self.message.exec()
            elif res.status_code == 403:
                self.message.setWindowTitle("Attenzione")
                self.message.setIcon(QMessageBox.Warning)
                self.message.setText("\nCredenziali Errate.")
                self.message.exec()
            else:
                message = self.interpret_status_code(res.status_code)
                self.message.setWindowTitle("Attenzione")
                self.message.setIcon(QMessageBox.Warning)
                self.message.setText(f"\n{message}")
                self.message.exec()
        return username,password,token,group_codes,group_names,roles_codes,capabilities,firstName,lastName,group_to_cap




