"""
/***************************************************************************
 Servizi Sinfi
                                 A QGIS plugin
 Plugin per accedere ai servizi Sinfi da piattaforma QGis
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-04-16
        copyright            : (C) 2025 by Infratel Italia
        email                : info@sinfi.it
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.PyQt.QtCore import Qt
from qgis.PyQt.QtWidgets import QMessageBox
import requests
import json
from .create_client_assertion import create_client_assertion
import os
import time

class LoginPDND():

    def __init__(self,iface,link_pdnd:str):
        self.iface = iface

        self.message = QMessageBox()
        self.message.setWindowFlags(Qt.WindowStaysOnTopHint)
        
        self.message.setStyleSheet("""QWidget{background-color: rgb(255, 255, 255);}
                                        QPushButton{border:2px solid rgb(222, 222, 222); background: rgb(255, 255, 255); margin:5px;padding: 5px;}
                                        QPushButton:hover,QPushButton:pressed{background: rgb(230, 230, 230);}""")
        self.purposeId = {
            "statistico" : "26528558-7b3c-4c51-a290-a68e06b5292f",
            "datapanel" : "6e6bbe40-e487-48c8-8796-272b3901d1f4",
            "wms" : "410ac132-ebec-4958-97f0-69585dd0c849"
        }
        self.link_pdnd = link_pdnd
        self.kid = None
        self.private_path = None
        self.apikey = None
        self.bearer = None
        self.username = None
        self.password = None
        self.authCfdId = None

    def logout(self):
        
        self.kid = None
        self.private_path = None
        self.client_id = None
        self.apikey = None
        self.bearer = None
        self.username = None
        self.password = None
        self.authCfdId = None
        
    def interpret_status_code(self,status_code: int) -> str:
        """
        Restituisce un messaggio leggibile per uno status code HTTP.
        """
        messages = {
            # 2xx Success
            200: "OK - Richiesta eseguita con successo.",
            201: "Created - Risorsa creata correttamente.",
            202: "Accepted - Richiesta accettata, in elaborazione.",
            204: "No Content - Richiesta completata, nessun contenuto restituito.",

            # 3xx Redirect
            301: "301:Moved Permanently - La risorsa è stata spostata in modo permanente.",
            302: "302:Found - La risorsa è temporaneamente disponibile altrove.",
            304: "304:Not Modified - Nessuna modifica dalla versione cache.",

            # 4xx Client Error
            400: "400:Bad Request - La richiesta non è valida.",
            401: "401:Unauthorized - Errore di autenticazione.",
            403: "403:Forbidden - Accesso negato alla risorsa.",
            404: "404:Not Found - Risorsa non trovata.",
            405: "405:Method Not Allowed - Metodo HTTP non consentito.",
            408: "408:Request Timeout - La richiesta è scaduta.",
            429: "429:Too Many Requests - Limite di richieste superato.",

            # 5xx Server Error
            500: "500:Internal Server Error - Errore generico del server.",
            501: "501:Not Implemented - Funzionalità non supportata dal server.",
            502: "502:Bad Gateway - Risposta non valida dal server upstream.",
            503: "503:Service Unavailable - Servizio momentaneamente non disponibile.",
            504: "504:Gateway Timeout - Timeout del server upstream."
        }

        return messages.get(status_code, f"Status Code {status_code} - Codice non gestito esplicitamente.")

    def verifica_input(self, private_path:str,kid:str,client_id:str,apikey:str):
        #verifico che i campi siano compilati

        if not private_path:
            self.message.setWindowTitle("Attenzione")
            self.message.setIcon(QMessageBox.Warning)
            self.message.setText("Nessun file selezionato.          ")
            self.message.setStyleSheet('''
                                    QWidget{background-color: rgb(255, 255, 255);}
                                    QPushButton{border:2px solid rgb(222, 222, 222); background: rgb(255, 255, 255); margin:5px;padding: 5px;width:100 px; height: 20}
                                    QPushButton:hover,QPushButton:pressed{background: rgb(230, 230, 230);}'''
                                )
            self.message.exec()
            return None, None, None, None, None, None
            
        if not os.path.isfile(private_path):
            self.message.setWindowTitle("Attenzione")
            self.message.setIcon(QMessageBox.Warning)
            self.message.setText("L'elemento selezionato non è un file.         ")
            self.message.setStyleSheet('''
                                    QWidget{background-color: rgb(255, 255, 255);}
                                    QPushButton{border:2px solid rgb(222, 222, 222); background: rgb(255, 255, 255); margin:5px;padding: 5px;width:100 px; height: 20;}
                                    QPushButton:hover,QPushButton:pressed{background: rgb(230, 230, 230);}'''
                                )
            self.message.exec()
            return None, None, None, None, None, None
        
        if not ".priv" in private_path:
            self.message.setWindowTitle("Attenzione")
            self.message.setIcon(QMessageBox.Warning)
            self.message.setText("Il file selezionato non contiene nessuna chiave privata." )
            self.message.setStyleSheet('''
                                    QWidget{background-color: rgb(255, 255, 255);}
                                    QPushButton{border:2px solid rgb(222, 222, 222); background: rgb(255, 255, 255); margin:5px;padding: 5px;width:100 px; height: 20}
                                    QPushButton:hover,QPushButton:pressed{background: rgb(230, 230, 230);}'''
                                )
            self.message.exec()
            return None, None, None, None, None, None
        
        if not kid:
            self.message.setWindowTitle("Attenzione")
            self.message.setIcon(QMessageBox.Warning)
            self.message.setText("Nessun identificativo inserito per la chiave privata selezionata.                      ")
            self.message.setStyleSheet('''
                                    QLabel{ height: 20px}
                                    QWidget{background-color: rgb(255, 255, 255);}
                                    QPushButton{border:2px solid rgb(222, 222, 222); background: rgb(255, 255, 255); margin:5px;padding: 5px;width:100 px; height: 20}
                                    QPushButton:hover,QPushButton:pressed{background: rgb(230, 230, 230);}'''
                                )
            self.message.exec()
            return None, None, None, None, None, None
        
        if not client_id:
            self.message.setWindowTitle("Attenzione")
            self.message.setIcon(QMessageBox.Warning)
            self.message.setText("Nessun client_id inserito.                      ")
            self.message.setStyleSheet('''
                                    QLabel{ height: 20px}
                                    QWidget{background-color: rgb(255, 255, 255);}
                                    QPushButton{border:2px solid rgb(222, 222, 222); background: rgb(255, 255, 255); margin:5px;padding: 5px;width:100 px; height: 20}
                                    QPushButton:hover,QPushButton:pressed{background: rgb(230, 230, 230);}'''
                                )
            self.message.exec()
            return None, None, None, None, None, None
        
        if len(apikey) != 64:
            self.message.setWindowTitle("Attenzione")
            self.message.setIcon(QMessageBox.Warning)
            if len(apikey) == 0:
                self.message.setText("Nessuna apikey inserita.                             ")
            else:
                self.message.setText("L'apikey inserita non è valida.                      ")
            self.message.setStyleSheet('''
                                    QLabel{ height: 20px}
                                    QWidget{background-color: rgb(255, 255, 255);}
                                    QPushButton{border:2px solid rgb(222, 222, 222); background: rgb(255, 255, 255); margin:5px;padding: 5px;width:100 px; height: 20}
                                    QPushButton:hover,QPushButton:pressed{background: rgb(230, 230, 230);}'''
                                )
            self.message.exec()
            return None, None, None, None, None, None
        
        #testo la creazione di una assertion
        result = self.test_assertion(private_path,kid,client_id,apikey)
        if not result:
            return None, None, None, None, None, None
        elif result[0]  != 200:
            
            self.message.setWindowTitle("Attenzione")
            self.message.setIcon(QMessageBox.Warning)
            self.message.setText(result[1])
            self.message.setStyleSheet('''
                                    QLabel{ height: 20px}
                                    QWidget{background-color: rgb(255, 255, 255);}
                                    QPushButton{border:2px solid rgb(222, 222, 222); background: rgb(255, 255, 255); margin:5px;padding: 5px;width:100 px; height: 20}
                                    QPushButton:hover,QPushButton:pressed{background: rgb(230, 230, 230);}'''
                                )
            self.message.exec()
            return None, None, None, None, None, None
        
        self.private_path = private_path
        self.kid = kid
        self.client_id = client_id
        self.apikey = apikey
        check_statistico = result[2]
        firstName = result[3]
        lastName = result[4]
        groupName = result[5]
        roles_codes = result[6]

        return True,check_statistico,firstName,lastName,groupName,roles_codes
    
    
    def test_assertion(self,private_path,kid,client_id,apikey):
        
        get_purpose = self.purposeId.get('statistico',None)

        alg="RS256"
        typ="JWT"
        issuer=client_id
        subject=client_id
        audience="auth.uat.interop.pagopa.it/client-assertion"
        purposeId=get_purpose
        keyPath=rf"{private_path}"
        client_assertion_result = create_client_assertion(kid,alg,typ,issuer,subject,audience,purposeId,keyPath)

        if not client_assertion_result[0]:
            self.message.setWindowTitle("Attenzione")
            self.message.setIcon(QMessageBox.Warning)
            self.message.setText(client_assertion_result[1])
            self.message.setStyleSheet('''
                                    QLabel{ height: 20px}
                                    QWidget{background-color: rgb(255, 255, 255);}
                                    QPushButton{border:2px solid rgb(222, 222, 222); background: rgb(255, 255, 255); margin:5px;padding: 5px;width:100 px; height: 20}
                                    QPushButton:hover,QPushButton:pressed{background: rgb(230, 230, 230);}'''
                                )
            self.message.exec()
            return None
        
        assertion = client_assertion_result[0]

        url = 'https://auth.uat.interop.pagopa.it/token.oauth2'
        headers = {'Content-Type': 'application/x-www-form-urlencoded'}
        client_id=client_id
        client_assertion = assertion
        client_assertion_type = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"
        grant_type = "client_credentials"
        body = f"""client_id={client_id}&client_assertion={client_assertion}&client_assertion_type={client_assertion_type}&grant_type={grant_type}"""

        try:
            voucher_result = requests.post(url, headers=headers, data=body, verify=False)
        except requests.exceptions.SSLError as e:
            self.message.setWindowTitle("Errore SSL")
            self.message.setIcon(QMessageBox.Critical)
            self.message.setText(f"Errore di connessione SSL.\nVerifica i certificati o la connessione di rete.\n\nDettagli: {e}")
            self.message.exec()
            return None
        if voucher_result.status_code != 200:
            message = self.interpret_status_code(voucher_result.status_code)
            self.message.setWindowTitle("Attenzione")
            self.message.setIcon(QMessageBox.Warning)
            self.message.setText(f"\n{message}\nNon è stato possibile generare il voucher.\nKid, chiave privata o Client ID errati.")
            self.message.exec()
            return None
        
        res_dict = json.loads(voucher_result.text)
        bearer = res_dict.get("access_token")

        #verifico se posso usare statistico
        abilita_stat = True
        url_capabilities = f"https://{self.link_pdnd}/sinfi/pdnd/stats/1.0.0/sinfi_stats_get_aggregate_stats/"
                                        
        headers = {
            'Authorization': f'Bearer {bearer}',
            'x-sinfi-apikey': apikey,
            "accept" : "application/json",
            "content-type" : "application/json"
        }
        body =f"""{{
            "group_code": "",
            "query": {{
                "territories":[
                ]
            }}
            }}"""

        capabilities_result = requests.post(url_capabilities, headers=headers, data=body, verify=False)
        
        res_status_code = None

        message = self.interpret_status_code(capabilities_result.status_code)
        self.message.setWindowTitle("Attenzione")
        self.message.setIcon(QMessageBox.Warning)
        messaggio = None
        
        if capabilities_result.status_code == 200:
            messaggio = "APIKey valida e voucher accettato. Servizio WMS disponibile."
            res_status_code = capabilities_result.status_code
        elif capabilities_result.status_code == 401:
            res_dict = json.loads(capabilities_result.text)
            code = res_dict.get("code")
            
            abilita_stat = False
            
            if code == "SP007":
                messaggio = f"\n{message}\nApikey errata."
            elif code == "SP008":
                messaggio = f"\n{message}\nApikey scaduta."
            else:
                messaggio = f"\n{message}\nControllare che l'apikey sia valida."
            res_status_code = capabilities_result.status_code
        elif capabilities_result.status_code == 403:
            #controllo i codici:
            cap_json = json.loads(capabilities_result.text)
            cap_code = cap_json["code"]
            if cap_code in ('1002','1010'):
                abilita_stat = False
                res_status_code = 200
                
            else:
                # messaggio = "403: APIKey non valida o non autorizzata per questo servizio."
                messaggio = f"\n{message}\nAPIKey non valida o non autorizzata per questo servizio."
                abilita_stat = False
                res_status_code = capabilities_result.status_code
        elif capabilities_result.status_code == 429:
            # messaggio = "429: Troppe richieste: rate limit superato."
            messaggio = f"\n{message}\nTroppe richieste: rate limit superato."
            abilita_stat = False
            res_status_code = capabilities_result.status_code
        else:
            messaggio = self.interpret_status_code(capabilities_result.status_code)
            abilita_stat = False
            res_status_code = capabilities_result.status_code
        
        firstName,lastName,groupName,roles_codes = None,None,None,None
        #recupero nome e cognome utente
        if res_status_code == 200:
            url = f"https://{self.link_pdnd}/qgis/rest/api/system/get_istat_by_group/?group_code=''"
            headers = {
                'Authorization': f'Bearer {bearer}',
                'x-sinfi-apikey': apikey
            }
            req = requests.get(url, headers=headers, verify=False)

            if req.status_code == 200:
                
                bad_text = req.text
                fixed_text = bad_text.encode('latin1', errors='ignore').decode('utf-8', errors='replace')
                req_json = json.loads(fixed_text)
                
                try:
                    firstName = req_json["user"]["data"]["firstName"]
                except:
                    pass
                try:
                    lastName = req_json["user"]["data"]["lastName"]
                except:
                    pass
                #recupero nome gruppo
                try:
                    groupName = req_json["group"]["name"]
                except:
                    pass
                #recupero i ruoli
                try:
                    roles_codes = req_json["user"]["data"]["roles_codes"]
                except:
                    pass

        if not roles_codes:
            self.message.setWindowTitle("Attenzione")
            self.message.setIcon(QMessageBox.Warning)
            self.message.setText(f"Non è stato possibile recuperare i ruoli dell'utente.")
            self.message.exec()
            return None
        return[res_status_code,messaggio,abilita_stat,firstName,lastName,groupName,roles_codes]
    
    def create_voucher(self,purpose):
        #controllo che private_path sia un file che termina in priv
        
        get_purpose = self.purposeId.get(purpose,None)


        kid=self.kid

        alg="RS256"
        typ="JWT"
        issuer=self.client_id
        subject=self.client_id
        audience="auth.uat.interop.pagopa.it/client-assertion"
        purposeId=get_purpose
        keyPath=rf"{self.private_path}"
        client_assertion_result = create_client_assertion(kid,alg,typ,issuer,subject,audience,purposeId,keyPath)

        if not client_assertion_result[0]:
            self.message.setWindowTitle("Attenzione")
            self.message.setIcon(QMessageBox.Warning)
            self.message.setText(client_assertion_result[1])
            self.message.setStyleSheet('''
                                    QLabel{ height: 20px}
                                    QWidget{background-color: rgb(255, 255, 255);}
                                    QPushButton{border:2px solid rgb(222, 222, 222); background: rgb(255, 255, 255); margin:5px;padding: 5px;width:100 px; height: 20}
                                    QPushButton:hover,QPushButton:pressed{background: rgb(230, 230, 230);}'''
                                )
            self.message.exec()
            return None
        
        assertion = client_assertion_result[0]

        url = 'https://auth.uat.interop.pagopa.it/token.oauth2'
        headers = {'Content-Type': 'application/x-www-form-urlencoded'}
        client_id=self.client_id
        client_assertion = assertion
        client_assertion_type = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"
        grant_type = "client_credentials"
        body = f"""client_id={client_id}&client_assertion={client_assertion}&client_assertion_type={client_assertion_type}&grant_type={grant_type}"""

        req = requests.post(url, headers=headers, data=body)
        
        res_dict = json.loads(req.text)
        
        bearer = res_dict.get("access_token")
        
        expires = res_dict.get("expires_in")
        
        expires_in = int(time.time()) + (expires-60)
        
        return [bearer,expires_in,self.apikey]
        
