"""
/***************************************************************************
 Servizi Sinfi
                                 A QGIS plugin
 Plugin per accedere ai servizi Sinfi da piattaforma QGis
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-04-16
        copyright            : (C) 2025 by Infratel Italia
        email                : info@sinfi.it
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import jwt
import datetime
import uuid


def get_private_key(key_path: str) -> bytes:
    """Legge la chiave privata RSA da file"""
    with open(key_path, "rb") as private_key:
        return private_key.read()


def create_client_assertion(
    kid: str,
    alg: str,
    typ: str,
    issuer: str,
    subject: str,
    audience: str,
    purposeId: str,
    keyPath: str,
    lifetime_minutes: int = 43200  # 30 giorni
) -> str:
    """
    Crea un client assertion JWT firmato con chiave privata RSA.

    Args:
        kid: Key ID
        alg: Algoritmo (es. RS256)
        typ: Tipo di token (es. JWT)
        issuer: Issuer
        subject: Subject
        audience: Audience
        purposeId: Purpose ID
        keyPath: Path della chiave privata
        lifetime_minutes: durata in minuti del token (default 30 giorni)

    Returns:
        JWT come stringa
    """
    
    issued = datetime.datetime.utcnow()
    expire_in = issued + datetime.timedelta(minutes=lifetime_minutes)
    jti = uuid.uuid4()

    headers_rsa = {
        "kid": str(kid),
        "alg": str(alg),
        "typ": str(typ)
    }

    payload = {
        "iss": str(issuer),
        "sub": str(subject),
        "aud": str(audience),
        "jti": str(jti),
        "iat": issued,
        "exp": expire_in,
        "purposeId": str(purposeId)
    }

    try:
      rsa_key = get_private_key(keyPath)

      client_assertion = jwt.encode(
          payload,
          rsa_key,
          algorithm=str(alg),  # forza RS256
          headers=headers_rsa
      )
    except Exception as e:
        message = f"Errore nella creazione della client assertion: {e}"
        return [None,message]
    else:
      return [client_assertion,"success"]
