"""
/***************************************************************************
 Servizi Sinfi
                                 A QGIS plugin
 Plugin per accedere ai servizi Sinfi da piattaforma QGis
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-04-16
        copyright            : (C) 2025 by Infratel Italia
        email                : info@sinfi.it
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import requests,json,time,threading
from qgis.PyQt.QtWidgets import QMessageBox
from qgis.PyQt.QtCore import pyqtSignal,Qt
from qgis.PyQt import QtWidgets

class CheckToken(QtWidgets.QWidget):
    
    token_signal = pyqtSignal()
    def __init__(self,iface,user,token,link, parent=None):
        """Constructor."""
        super(CheckToken, self).__init__(parent)
        
        self.iface = iface
        self.user = user
        self.token = token
        self.link = link
        
        self.stop_threads = False
        self.t = threading.Thread(target=self.launch_tread, args =(lambda : self.stop_threads, ))
        self.t.start()
        self.conta = 0
        self.message = QMessageBox()
        self.message.setWindowFlags(Qt.WindowStaysOnTopHint)
        self.message.setMinimumSize(400,200)
        self.message.setStyleSheet("""QWidget{background-color: rgb(255, 255, 255);}
                                        QPushButton{border:2px solid rgb(222, 222, 222); background: rgb(255, 255, 255); margin:5px;padding: 5px;}
                                        QPushButton:hover,QPushButton:pressed{background: rgb(230, 230, 230);}""")
    def set_user(self,user):
        self.user = user
    
    def set_token(self,token):
        self.token = token
    
    def stop_thread(self):
        self.stop_threads = True
        self.t.join()

    def start_thread(self):
        self.stop_threads = False
        self.t = threading.Thread(target=self.launch_tread, args =(lambda : self.stop_threads, ))
        self.t.start()
        self.conta = 0

    def launch_tread(self,stop):
        while True:
            if stop():
                break
            time.sleep(1)
            
            self.conta +=1
            
            if self.conta%60 == 0:
                res_dict = self.check_validità_token() #updates the variable
                
                if not res_dict:
                    self.token_signal.emit()
                    break

    def check_validità_token(self):
        headers = {
                    'X-User': self.user,
                    'X-Token': self.token
                }
        res = requests.get(f'https://{self.link}/sinfi_gateway/rest/pub/auth/check_token/', headers = headers, verify=False)
        res_dict = None
        if res.status_code == 200:
            res_dict = json.loads(res.text)
            
        return res_dict

    def refresh_token(self):
        headers = {
                    'X-User': self.user,
                    'X-Token': self.token
                }
        res = requests.get(f'https://{self.link}/sinfi_gateway/rest/pub/auth/refresh_token/', headers = headers, verify=False)
        res_dict = None
        if res.status_code == 200:
            res_dict = json.loads(res.text)
            
        return res_dict
    

    
