# -*- coding: utf-8 -*-

"""
/***************************************************************************
 ServiziEcosistemici
                                 A QGIS plugin
 ServiziEcosistemici
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-07-06
        copyright            : (C) 2021 by Pietro
        email                : pq.90@hotmail.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Pietro'
__date__ = '2021-07-06'
__copyright__ = '(C) 2021 by Pietro'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.core import QgsProcessingProvider
from qgis.PyQt.QtGui import QIcon
import os
from .SE_BeneficiSociali import SE_BeneficiSociali
from .SE_Biodiversita import SE_Biodiversita
from .SE_Impollinazione import SE_Impollinazione
from .SE_Infiltrazione import SE_Infiltrazione
from .SE_ProtezioneIdrogeologica import SE_ProtezioneIdrogeologica
from .SE_RegolazioneTemperatura import SE_RegolazioneTemperatura
from .SE_RimozioneInquinanti import SE_RimozioneInquinanti
from .SE_ProduzioneAgricola import SE_ProduzioneAgricola
from .SE_SequestroCarbonio import SE_SequestroCarbonio
from .SE_CalcoloComplessivo import SE_CalcoloComplessivo
from .CalcoloCarbonio import CalcoloCarbonio
from .CalcoloInfiltrazione import CalcoloInfiltrazione
from .CalcoloRimozioneInquinanti import CalcoloRimozioneInquinanti



class ServiziEcosistemiciProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        self.addAlgorithm(SE_SequestroCarbonio())
        self.addAlgorithm(SE_BeneficiSociali())
        self.addAlgorithm(SE_Impollinazione())
        self.addAlgorithm(SE_Biodiversita())
        self.addAlgorithm(SE_Infiltrazione())
        self.addAlgorithm(SE_ProduzioneAgricola())
        self.addAlgorithm(SE_ProtezioneIdrogeologica())
        self.addAlgorithm(SE_RegolazioneTemperatura())
        self.addAlgorithm(SE_RimozioneInquinanti())
        self.addAlgorithm(SE_CalcoloComplessivo())
        self.addAlgorithm(CalcoloCarbonio())
        self.addAlgorithm(CalcoloInfiltrazione())
        self.addAlgorithm(CalcoloRimozioneInquinanti())

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'Servizi Ecosistemici'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('Servizi Ecosistemici Torino')

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        plg_dir = os.path.dirname(__file__)

        # icons: folder containing my icon files
        icon_path = os.path.join(plg_dir, "logo.png")

        icon = QIcon(icon_path)
        return icon
        # return QgsProcessingProvider.icon(self)

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()
